/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.BalanceCompareFilter;
import com.kingdee.eas.fi.books.app.AbstractBalanceCompareFacadeControllerBean;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BalanceCompareFacadeControllerBean
extends AbstractBalanceCompareFacadeControllerBean {
    private static final long serialVersionUID = -6770721981250101734L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.books.app.BalanceCompareFacadeControllerBean");

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, EASBizException {
        return " * ";
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append(" FROM \r\n");
        sqlFrom.append(partner.getTempTableName());
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws BOSException, EASBizException {
        return "where 1 = 1  \r\n";
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, EASBizException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReportResultInfo _findData(Context ctx, EntityViewInfo condition, int start, int count, String tempTableName, CompanyOrgUnitInfo company, boolean allExpand) throws BOSException, EASBizException {
        GLResUtil.setLocale(ctx);
        ReportPartner partner = new ReportPartner(ctx);
        partner.setCondition(condition);
        partner.setStartIndex(start);
        partner.setLineCount(count);
        partner.setTempTableName(tempTableName);
        partner.setCompany(company);
        ReportResultInfo result = new ReportResultInfo();
        Connection conn = this.getConnection(ctx);
        partner.setConnection(conn);
        try {
            Collection cc = null;
            if (partner.isNewQuery()) {
                cc = this.insertDataIntoTempTables(ctx, partner);
            }
            result.getData().addAll(cc);
            result.setRowCount(1);
            result.setTempTableName(partner.getTempTableName());
            result.setTableHeadInfo(partner.getTableHeadInfo());
            ReportResultInfo reportResultInfo = result;
            return reportResultInfo;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPeriodByCurCompany(Context ctx, String mPeriodTypeId, String periodTypeId, String periodNumber) {
        String period = null;
        String sql = "select a.* from t_bd_period a,(select * from t_bd_period where fnumber = ? and ftypeid = ?) b where a.fbegindate = b.fbegindate and a.fenddate = b.fenddate and a.ftypeid = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, periodNumber);
            ps.setString(2, periodTypeId);
            ps.setString(3, mPeriodTypeId);
            rs = ps.executeQuery();
            while (rs.next()) {
                period = rs.getString("fnumber");
            }
        }
        catch (Exception e) {
            try {
                period = null;
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return period;
    }

    protected Collection insertDataIntoTempTables(Context ctx, ReportPartner partner) throws EASBizException, BOSException {
        ArrayList<Object[]> cc;
        boolean isOnlyLeaf = ((BalanceCompareFilter)partner.getFixCondition()).getOptionOnlyLeaf();
        boolean isIncludePost = ((BalanceCompareFilter)partner.getFixCondition()).getOptionPosting();
        int level = ((BalanceCompareFilter)partner.getFixCondition()).getAccountLevelStart();
        int periodYear = ((BalanceCompareFilter)partner.getFixCondition()).getPeriodYearStart();
        int periodNumber = ((BalanceCompareFilter)partner.getFixCondition()).getPeriodNumberStart();
        CompanyOrgUnitInfo masterCompany = ((BalanceCompareFilter)partner.getFixCondition()).getMasterCompany();
        CompanyOrgUnitInfo curCompany = partner.getCompany();
        String masterCompanyId = masterCompany.getId().toString();
        String curCompanyId = curCompany.getId().toString();
        String accountTableId = curCompany.getAccountTable().getId().toString();
        String currencyId = ((BalanceCompareFilter)partner.getFixCondition()).getCurrencyID();
        int baltype = isIncludePost ? 1 : 5;
        boolean isForCurrency = false;
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isForCurrency = true;
        }
        String tempTable = InitHelp.createTempTable(ctx, this.getTempTableStructure(), "BOOKSBALANCECMOPARE1111");
        try {
            StringBuffer sql = null;
            String srcTable = masterCompany.getAccountTable().getId().toString();
            String objTable = curCompany.getAccountTable().getId().toString();
            String mPeriodTypeId = masterCompany.getAccountPeriodType().getId().toString();
            String periodTypeId = curCompany.getAccountPeriodType().getId().toString();
            String period = String.valueOf(periodYear * 100 + periodNumber);
            String mPeriod = BalanceCompareFacadeControllerBean.getPeriodByCurCompany(ctx, mPeriodTypeId, periodTypeId, period);
            String resultPeriod = mPeriod != null ? mPeriod : period;
            String accountRef = this.getRefContrastIdOld(ctx, srcTable, objTable, curCompanyId);
            Object[] param = null;
            if (accountRef == null) {
                sql = new StringBuffer();
                sql.append("    INSERT INTO ");
                sql.append(tempTable);
                sql.append("  (ftypeid,faccountid,faccountnumber,faccountname,fsubacctid,fsubacctnumber,fsubacctname,fmendbalance)   \r\n");
                sql.append("  (SELECT 1 ftypeid,acct1.fid, acct1.fnumber as faccountnumber ,acct1.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append(" as faccountname ,");
                sql.append(" acct1.fid as fsubacctid,acct1.fnumber as fsubacctnumber,acct1.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append(" as fsubacctname ,");
                if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("  bal1.FEndBalanceLocal as fmendbalance  ");
                } else if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("  bal1.FEndBalanceRpt as fmendbalance  ");
                }
                sql.append("  from " + GLBalanceUtils.getAccountBalanceTable(baltype, currencyId) + " bal1   \r\n");
                sql.append(" inner join  t_bd_accountview acct1 on acct1.fid=bal1.FAccountID   \r\n");
                sql.append(" where bal1.forgunitid=? \r\n");
                if (isForCurrency) {
                    sql.append(" and bal1.fcurrencyid=? \r\n");
                }
                sql.append(" and bal1.fperiod=?   \r\n");
                if (isOnlyLeaf) {
                    sql.append(" and acct1.fisleaf=1 ");
                } else {
                    sql.append(" and acct1.flevel <=? ");
                }
                if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("  and bal1.FEndBalanceLocal <> 0");
                } else if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("  and bal1.FEndBalanceRpt <> 0  ");
                }
                sql.append("   )     \r\n");
                param = isOnlyLeaf ? (isForCurrency ? new Object[]{masterCompanyId, currencyId, resultPeriod} : new Object[]{masterCompanyId, resultPeriod}) : (isForCurrency ? new Object[]{masterCompanyId, currencyId, resultPeriod, new Integer(level)} : new Object[]{masterCompanyId, resultPeriod, new Integer(level)});
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
                sql = new StringBuffer();
                sql.append("    INSERT INTO ");
                sql.append(tempTable);
                sql.append("  (ftypeid,faccountid,faccountnumber,faccountname,fsubacctid,fsubacctnumber,fsubacctname,fsendbalance)   \r\n");
                sql.append("(SELECT 2 ftypeid,acct1.fid,acct1.fnumber,acct1.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append(" , ");
                sql.append(" acct1.fid as fsubacctid, acct1.fnumber as fsubacctnumber,acct1.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append(" as fsubacctname, ");
                if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("  bal1.FEndBalanceLocal as fsendbalance  ");
                } else if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("  bal1.FEndBalanceRpt as fsendbalance  ");
                }
                sql.append(" from " + GLBalanceUtils.getAccountBalanceTable(baltype, currencyId) + " bal1   \r\n");
                sql.append(" inner join  t_bd_accountview acct1 on acct1.fid=bal1.FAccountID   \r\n");
                sql.append(" where bal1.forgunitid=? \r\n");
                sql.append(" and acct1.faccounttableid = ? \r\n ");
                if (isForCurrency) {
                    sql.append(" and bal1.fcurrencyid=? \r\n");
                }
                sql.append(" and bal1.fperiod=?   \r\n");
                if (isOnlyLeaf) {
                    sql.append(" and acct1.fisleaf=1 ");
                } else {
                    sql.append(" and acct1.flevel <=? ");
                }
                if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("  and bal1.FEndBalanceLocal <>0");
                } else if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("  and bal1.FEndBalanceRpt <>0  ");
                }
                sql.append(" )  \r\n");
                param = isOnlyLeaf ? (isForCurrency ? new Object[]{curCompanyId, accountTableId, currencyId, periodYear * 100 + periodNumber} : new Object[]{curCompanyId, accountTableId, periodYear * 100 + periodNumber}) : (isForCurrency ? new Object[]{curCompanyId, accountTableId, currencyId, periodYear * 100 + periodNumber, new Integer(level)} : new Object[]{curCompanyId, accountTableId, periodYear * 100 + periodNumber, new Integer(level)});
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
                sql = new StringBuffer();
                sql.append("    INSERT INTO ");
                sql.append(tempTable);
                sql.append("  (ftypeid,faccountid,faccountnumber,faccountname,fsubacctid,fsubacctnumber,fsubacctname,FAdjustDebit,FAdjustcredit)   \r\n");
                sql.append("  (select temp.* from (SELECT 3 ftypeid,pacct.fid ,pacct.fnumber ,pacct.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append("   ,");
                sql.append("    pacct.fid as fsubacctid, pacct.fnumber as fsubacctnumber,pacct.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append("   as fsubacctname,");
                if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("  sum(case entry.FEntryDC when 1 then entry.FLocalAmount else 0 end) fAdjustDebitBalance , \r\n");
                    sql.append("  sum(case entry.FEntryDC when 0 then entry.FLocalAmount else 0 end) fAdjustCreditBalance  \r\n");
                } else if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("  sum(case entry.FEntryDC when 1 then entry.FReportingAmount else 0 end) fAdjustDebitBalance,  \r\n");
                    sql.append("  sum(case entry.FEntryDC when 0 then entry.FReportingAmount else 0 end) fAdjustCreditBalance  \r\n");
                }
                sql.append(" from T_GL_Voucher vch        \r\n");
                sql.append("   inner join T_GL_VoucherEntry entry on entry.fbillid=vch.fid \r\n");
                sql.append("   inner join t_bd_period pi on pi.fid=vch.fperiodid    \r\n");
                sql.append("   inner join t_bd_accountview acct1 on acct1.fid=entry.faccountid    \r\n");
                sql.append("   inner join t_BD_AccountView pacct  on pacct.Fcompanyid = acct1.Fcompanyid    and pacct.faccounttableid = acct1.faccounttableid and  (charindex(pacct.FLongNumber || '!', acct1.FLongNumber) = 1 or pacct.fid = acct1.fid)        \r\n");
                sql.append("  WHERE vch.FIsAccountCopy=0 and vch.fcompanyid=? and pi.fperiodyear =? and pi.fperiodnumber=?  ");
                if (isOnlyLeaf) {
                    sql.append(" and pacct.fisleaf=1 ");
                    sql.append(" and acct1.fisleaf=1 ");
                } else {
                    sql.append(" and (acct1.flevel <=? or acct1.fisleaf=1)");
                }
                if (isIncludePost) {
                    sql.append("       and vch.FBizStatus>0 and vch.FBizStatus !=2    \r\n");
                } else {
                    sql.append("       and vch.FBizStatus=5     \r\n");
                }
                sql.append("   GROUP BY pacct.fid,pacct.fnumber,pacct.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append(" ) as temp inner join t_BD_AccountView av on temp.fid = av.fid ");
                if (isOnlyLeaf) {
                    sql.append(")  \r\n");
                    param = new Object[]{curCompanyId, new Integer(periodYear), new Integer(periodNumber)};
                } else {
                    sql.append("and av.flevel <=?)  \r\n");
                    param = new Object[]{curCompanyId, new Integer(periodYear), new Integer(periodNumber), new Integer(level), new Integer(level)};
                }
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
                sql = new StringBuffer();
                sql.append(" UPDATE ").append(tempTable).append("  SET  FAdjustDebit=").append(" (SELECT sum(isnull(b.FAdjustDebit,0)) FROM ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber and b.ftypeid=3 ),  \r\n").append(" FAdjustCredit=").append(" (SELECT sum(isnull(b.FAdjustCredit,0)) FROM ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber and b.ftypeid=3 ),  \r\n").append(" fsendbalance=").append(" (SELECT sum(isnull(c.fsendbalance,0)) FROM ").append(tempTable).append(" c WHERE c.faccountnumber=").append(tempTable).append(".faccountnumber and c.ftypeid=2 )  \r\n").append(" WHERE ftypeid=1   \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql = new StringBuffer();
                sql.append(" UPDATE ").append(tempTable).append("  SET FAdjustDebit=    \r\n").append(" (SELECT b.FAdjustDebit FROM ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber and b.ftypeid=3 ),  \r\n").append(" FAdjustCredit=     \r\n").append(" (SELECT b.FAdjustCredit FROM ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber and b.ftypeid=3 )  \r\n").append(" WHERE ftypeid=2 and ").append(tempTable).append(".faccountnumber not in (select faccountnumber from  ").append(tempTable).append("  where ftypeid=1 )");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else {
                sql = new StringBuffer();
                sql.append("    INSERT INTO ");
                sql.append(tempTable);
                sql.append("  (ftypeid,faccountid,faccountnumber,faccountname,fmendbalance)   \r\n");
                sql.append("  (SELECT 1 ftypeid,acct1.fid as faccountid ,acct1.fnumber as faccountnumber ,acct1.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append(" as faccountname ,");
                if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("  bal1.FEndBalanceLocal as fmendbalance  ");
                } else if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("  bal1.FEndBalanceRpt as fmendbalance  ");
                }
                sql.append("  from " + GLBalanceUtils.getAccountBalanceTable(baltype, currencyId) + " bal1   \r\n");
                sql.append(" inner join  t_bd_accountview acct1 on acct1.fid=bal1.FAccountID   \r\n");
                sql.append(" where bal1.forgunitid=?   \r\n");
                if (isForCurrency) {
                    sql.append(" and bal1.fcurrencyid=?   \r\n");
                }
                sql.append(" and bal1.fperiod=?   \r\n");
                if (isOnlyLeaf) {
                    sql.append(" and acct1.fisleaf=1 ");
                } else {
                    sql.append(" and acct1.flevel <=? ");
                }
                if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("  and bal1.FEndBalanceLocal <>0");
                } else if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("  and bal1.FEndBalanceRpt <>0  ");
                }
                sql.append("   )     \r\n");
                param = isOnlyLeaf ? (isForCurrency ? new Object[]{masterCompanyId, currencyId, resultPeriod} : new Object[]{masterCompanyId, resultPeriod}) : (isForCurrency ? new Object[]{masterCompanyId, currencyId, resultPeriod, new Integer(level)} : new Object[]{masterCompanyId, resultPeriod, new Integer(level)});
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
                sql = new StringBuffer();
                sql.append("    INSERT INTO ");
                sql.append(tempTable);
                sql.append("  (ftypeid,faccountid,faccountnumber,faccountname,fsubacctid,fsubacctnumber,fsubacctname,fsendbalance)   \r\n");
                sql.append("(SELECT 2 ftypeid,acct2.fid,acct2.fnumber,acct2.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append(" , ");
                sql.append(" acct1.fid as fsubacctid, acct1.fnumber as fsubacctnumber,acct1.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append(" as fsubacctname, ");
                if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("  bal1.FEndBalanceLocal as fsendbalance  ");
                } else if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("  bal1.FEndBalanceRpt as fsendbalance  ");
                }
                sql.append(" from " + GLBalanceUtils.getAccountBalanceTable(baltype, currencyId) + " bal1   \r\n");
                sql.append(" inner join  t_bd_acctrefcontrastentry refrence on refrence.fnewacctid=bal1.faccountid  \r\n");
                sql.append(" inner join  t_bd_accountview acct1 on acct1.fid=bal1.FAccountID   \r\n");
                sql.append(" inner join  t_bd_accountview acct2 on acct2.fid=refrence.foldacctid  \r\n");
                sql.append(" where bal1.forgunitid=?   \r\n");
                if (isForCurrency) {
                    sql.append(" and bal1.fcurrencyid=?   \r\n");
                }
                sql.append(" and bal1.fperiod=?   \r\n");
                if (isOnlyLeaf) {
                    sql.append(" and acct1.fisleaf=1 ");
                } else {
                    sql.append(" and acct1.flevel <=? ");
                }
                if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("  and bal1.FEndBalanceLocal <>0");
                } else if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("  and bal1.FEndBalanceRpt <>0  ");
                }
                sql.append("  and refrence.facctrefcontrastid=?    \r\n ");
                sql.append(" )  \r\n");
                param = isOnlyLeaf ? (isForCurrency ? new Object[]{curCompanyId, currencyId, periodYear * 100 + periodNumber, accountRef} : new Object[]{curCompanyId, periodYear * 100 + periodNumber, accountRef}) : (isForCurrency ? new Object[]{curCompanyId, currencyId, periodYear * 100 + periodNumber, new Integer(level), accountRef} : new Object[]{curCompanyId, periodYear * 100 + periodNumber, new Integer(level), accountRef});
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
                sql = new StringBuffer();
                sql.append("    INSERT INTO ");
                sql.append(tempTable);
                sql.append("  (ftypeid,faccountid,faccountnumber,faccountname,fsubacctid,fsubacctnumber,fsubacctname,FAdjustDebit,FAdjustcredit)   \r\n");
                sql.append("    (SELECT 3 ftypeid,pacct.fid ,pacct.fnumber ,pacct.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append("   ,");
                sql.append("   pacct2.fid as fsubacctid,  pacct2.fnumber as fsubacctnumber,pacct2.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append("   as fsubacctname,");
                if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("  sum(case entry.FEntryDC when 1 then entry.FLocalAmount else 0 end) fAdjustDebitBalance , \r\n");
                    sql.append("  sum(case entry.FEntryDC when 0 then entry.FLocalAmount else 0 end) fAdjustCreditBalance  \r\n");
                } else if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("  sum(case entry.FEntryDC when 1 then entry.FReportingAmount else 0 end) fAdjustDebitBalance,  \r\n");
                    sql.append("  sum(case entry.FEntryDC when 0 then entry.FReportingAmount else 0 end) fAdjustCreditBalance  \r\n");
                }
                sql.append(" from T_GL_Voucher vch        \r\n");
                sql.append("   inner join T_GL_VoucherEntry entry on entry.fbillid=vch.fid \r\n");
                sql.append("   inner join  t_bd_acctrefcontrastentry refrence on refrence.fnewacctid=entry.faccountid  \r\n");
                sql.append("   inner join t_bd_period pi on pi.fid=vch.fperiodid    \r\n");
                sql.append("   inner join t_bd_accountview acct1 on acct1.fid=entry.faccountid    \r\n");
                sql.append(" inner join  t_bd_accountview acct2 on acct2.fid=refrence.foldacctid  \r\n");
                sql.append("   inner join t_BD_AccountView pacct  on pacct.Fcompanyid = acct2.Fcompanyid    and pacct.faccounttableid = acct2.faccounttableid and  (charindex(pacct.FLongNumber || '!', acct2.FLongNumber) = 1 or pacct.fid = acct2.fid)        \r\n");
                sql.append("   inner join t_BD_AccountView pacct2  on pacct2.Fcompanyid = acct1.Fcompanyid    and pacct2.faccounttableid = acct1.faccounttableid and  (charindex(pacct2.FLongNumber || '!', acct1.FLongNumber) = 1 or pacct2.fid = acct1.fid) and pacct2.flevel=pacct.flevel        \r\n");
                sql.append("  WHERE vch.FIsAccountCopy=0 and vch.fcompanyid=? and pi.fperiodyear =? and pi.fperiodnumber=?  ");
                if (isOnlyLeaf) {
                    sql.append(" and pacct.fisleaf=1 ");
                    sql.append(" and acct1.fisleaf=1 ");
                } else {
                    sql.append(" and acct1.flevel <=? ");
                }
                if (isIncludePost) {
                    sql.append("       and vch.FBizStatus>0  and vch.FBizStatus !=2    \r\n");
                } else {
                    sql.append("       and vch.FBizStatus=5     \r\n");
                }
                sql.append("  and refrence.facctrefcontrastid=?    \r\n ");
                sql.append("   GROUP BY pacct.fid,pacct.fnumber,pacct.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append(" ,pacct2.fid,pacct2.fnumber,pacct2.fname");
                sql.append(partner.getFieldNameExtend());
                sql.append(" )    \r\n");
                param = isOnlyLeaf ? new Object[]{curCompanyId, new Integer(periodYear), new Integer(periodNumber), accountRef} : new Object[]{curCompanyId, new Integer(periodYear), new Integer(periodNumber), new Integer(level), accountRef};
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
                sql = new StringBuffer();
                sql.append(" UPDATE ").append(tempTable).append("  SET  FAdjustDebit=").append(" (SELECT b.FAdjustDebit FROM ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber and b.ftypeid=3 ),  \r\n").append(" FAdjustCredit=").append(" (SELECT b.FAdjustCredit FROM ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber and b.ftypeid=3 ),  \r\n").append(" FSubAcctNumber=").append(" (select  b.FSubAcctNumber from ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber ").append(" and b.ftypeid=3),  \r\n").append(" FSubAcctName=").append(" (select b.fSubAcctName from ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber ").append(" and b.ftypeid=3)  \r\n").append(" WHERE ftypeid=1   \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql = new StringBuffer();
                sql.append(" UPDATE ").append(tempTable).append("  SET ").append(" fsendbalance=").append(" (SELECT c.fsendbalance FROM ").append(tempTable).append(" c WHERE c.faccountnumber=").append(tempTable).append(".faccountnumber and c.ftypeid=2 ),  \r\n").append(" FSubAcctNumber=").append(" (select  b.FSubAcctNumber from ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber ").append(" and b.ftypeid=2),  \r\n").append(" FSubAcctName=").append(" (select b.fSubAcctName from ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber ").append(" and b.ftypeid=2)  \r\n").append(" WHERE ftypeid=1   \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql = new StringBuffer();
                sql.append(" UPDATE ").append(tempTable).append("  SET FAdjustDebit=    \r\n").append(" (SELECT b.FAdjustDebit FROM ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber and b.ftypeid=3 ),  \r\n").append(" FAdjustCredit=     \r\n").append(" (SELECT b.FAdjustCredit FROM ").append(tempTable).append(" b WHERE b.faccountnumber=").append(tempTable).append(".faccountnumber and b.ftypeid=3 )  \r\n").append(" WHERE ftypeid=2 and ").append(tempTable).append(".faccountnumber not in (select faccountnumber from  ").append(tempTable).append("  where ftypeid=1 )");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            if (objTable.equals(srcTable)) {
                sql = new StringBuffer();
                sql.append(" update  ").append(tempTable).append(" set FSubAcctNumber = FAccountNumber, FSubAcctName=FAccountName, \r\n ").append(" FAdjustDebit=0,fSEndBalance=0 where FAccountNumber is not null and FSubAcctNumber is null ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else {
                sql = new StringBuffer();
                sql.append(" update  ").append(tempTable).append(" set FSubAcctNumber = (select fnumber from t_bd_accountview where fid=  \r\n ").append(" select fnewacctid from t_bd_acctrefcontrastentry  where foldacctid=FAccountid and fid='").append(accountRef).append("'), \r\n").append(" FSubAcctName = (select fname").append(partner.getFieldNameExtend()).append(" from t_bd_accountview where fid=  \r\n ").append(" select fnewacctid from t_bd_acctrefcontrastentry  where foldacctid=FAccountid and fid='").append(accountRef).append("'), \r\n").append(" FAdjustDebit=0,fSEndBalance=0 where FAccountNumber is not null and FSubAcctNumber is null ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            int index = 0;
            cc = new ArrayList<Object[]>();
            sql = new StringBuffer();
            sql.append("SELECT * FROM ").append(" ( SELECT * FROM ").append(tempTable).append(" WHERE ftypeid=1 UNION ALL     \r\n").append(" SELECT * FROM ").append(tempTable).append(" WHERE ftypeid=2 AND faccountnumber NOT IN (SELECT faccountnumber FROM ").append(tempTable).append(" WHERE ftypeid=1) UNION ALL     \r\n").append(" SELECT * FROM ").append(tempTable).append(" WHERE ftypeid=3 AND faccountnumber NOT IN (SELECT faccountnumber FROM ").append(tempTable).append(" WHERE ftypeid=1)      \r\n").append(" AND faccountnumber NOT IN (SELECT faccountnumber FROM ").append(tempTable).append(" WHERE ftypeid=2)      \r\n").append("  ) a ORDER BY a.FAccountNumber");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                index = 0;
                Object[] row = new Object[8];
                row[index++] = rs.getString("FAccountNumber");
                row[index++] = rs.getString("FAccountName");
                row[index++] = rs.getString("fMEndBalance");
                row[index++] = rs.getBigDecimal("FAdjustDebit");
                row[index++] = rs.getBigDecimal("FAdjustCredit");
                row[index++] = rs.getBigDecimal("fSEndBalance");
                row[index++] = rs.getString("FSubAcctNumber");
                row[index++] = rs.getString("FSubAcctName");
                cc.add(row);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return cc;
    }

    private String getTempTableStructure() {
        StringBuffer sb = new StringBuffer();
        sb.append(" (").append("FTypeID Int,").append("FAccountid VARCHAR(44),").append("FAccountNumber VARCHAR(80),").append("FAccountName VARCHAR(256),").append("FSubAcctid VARCHAR(44),").append("FSubAcctNumber VARCHAR(80),").append("FSubAcctName VARCHAR(256),").append("fMEndBalance DECIMAL(28,10),").append("FAdjustDebit DECIMAL(28,10),").append("FAdjustCredit DECIMAL(28,10),").append("fSEndBalance DECIMAL(28,10),").append("FLevel Int,").append("FIsLeaf Int").append(")");
        return sb.toString();
    }

    private String getRefContrastIdOld(Context ctx, String srcTable, String objTable, String companyId) throws BOSException, EASBizException {
        String accountRef = null;
        try {
            String sql2 = " select fid from t_bd_acctrefcontrast where FEnabledAcctTableID=? and FDisabledAcctTableID=? and FIsEnabled=1 and FRefType=2 and Fcompanyid=?  ";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{objTable, srcTable, companyId});
            if (set != null && set.next()) {
                accountRef = set.getString(1);
            } else if (!srcTable.equals(objTable)) {
                throw new AccountBooksException(AccountBooksException.ACCT_NOTREF_COMPARE);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return accountRef;
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        return head;
    }

    @Override
    protected CurrencyCollection getAllCurrency(ReportPartner partner) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("sign"));
        sic.add(new SelectorItemInfo("BaseUnit"));
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)partner.getContext());
        CurrencyCollection currencyCollection = null;
        if (partner.isParmForeignCurrencySu()) {
            currencyCollection = currency.getCurrencyCollection(view, true);
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()));
            if (partner.isParmUseReportCurrency()) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString()));
                filter.setMaskString("(#0 OR #1)");
            }
            view.setFilter(filter);
            currencyCollection = currency.getCurrencyCollection(view, false);
        }
        return currencyCollection;
    }

    @Override
    protected String getReportName() {
        return "BalanceCompare";
    }

    @Override
    protected String getAuthorityName() {
        return "BalanceCompare";
    }

    @Override
    protected ArrayList _getBalanceList(Context ctx, BalanceCompareFilter param, HashMap otherCtx) throws BOSException, EASBizException {
        ArrayList balanceList = new ArrayList();
        return balanceList;
    }

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, BOSException, EASBizException {
        int index = 0;
        Object[] row = new Object[5];
        row[index++] = rs.getString("FAccountNumber");
        row[index++] = rs.getString("FAccountName");
        row[index++] = rs.getBigDecimal("fmendbalance");
        row[index++] = rs.getBigDecimal("fadjustbalance");
        row[index++] = rs.getBigDecimal("fsendbalance");
        return row;
    }

    @Override
    protected boolean _getRefContrastId(Context ctx, String srcTable, String objTable, String companyId) throws BOSException, EASBizException {
        boolean result = false;
        try {
            String sql2 = " select fid from t_bd_acctrefcontrast where FEnabledAcctTableID=? and FDisabledAcctTableID=? and FIsEnabled=1 and FRefType=2 and Fcompanyid=?  ";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{objTable, srcTable, companyId});
            if (set != null && set.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }
}

