/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.app.AbstractBalanceInitFacadeControllerBean;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AcctCussentInitFacadeFactory;
import com.kingdee.eas.fi.gl.AssistInitFacadeFactory;
import com.kingdee.eas.fi.gl.GLBaseDataCheckException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BalanceInitFacadeControllerBean
extends AbstractBalanceInitFacadeControllerBean {
    private static final long serialVersionUID = 6592744696160518795L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.RptAsstactGGControllerBean");
    private static final String RECFLOW = "com.kingdee.eas.fi.books.AccountBooksResource";
    private static final String GL_RESOURCE = "com.kingdee.eas.fi.gl.GLResource";
    private static CompanyOrgUnitInfo mainOrg = null;
    private static CompanyOrgUnitInfo asstOrg = null;

    @Override
    protected ArrayList _getInitData(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(false);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        Map hmParamValue = InitHelp.getInitParam(ctx, company);
        Boolean allowCussent = Boolean.valueOf(hmParamValue.get("GL_028").toString());
        boolean isInitClosed = this.isInitClosed(ctx, company.getId().toString());
        result.add(isInitClosed);
        result.add(this.getAllAstInitClosed(ctx, company.getId().toString()));
        result.add(this.getAllCussentInitClosed(ctx, company.getId().toString()));
        result.add(allowCussent);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _importBalance(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        BooksUtil.checkBookRule((Context)ctx);
        int type = Integer.parseInt(otherCtx.get("type").toString());
        String periodYear = otherCtx.get("periodyear").toString();
        String periodNumber = otherCtx.get("periodnumber").toString();
        CompanyOrgUnitInfo masterCompany = (CompanyOrgUnitInfo)otherCtx.get("mastercompany");
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)otherCtx.get("curcompany");
        PeriodInfo masterStartPeriod = GlUtils.getStartPeriod(ctx, masterCompany.getId().toString());
        PeriodInfo masterCurPeriod = GlUtils.getCurrentPeriod(ctx, masterCompany.getId().toString());
        PeriodInfo curStartPeriod = GlUtils.getStartPeriod(ctx, curCompany.getId().toString());
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        VoucherProcessCache.initCache(ctx, cacheId);
        StringBuffer message = new StringBuffer();
        String accountMessage = null;
        String asstMessage = null;
        String cussentMessage = null;
        try {
            switch (type) {
                case 1: {
                    accountMessage = this.importAccountBalance(ctx, periodYear, periodNumber, masterCompany, curCompany, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    if (StringUtils.isEmpty((String)accountMessage)) return null;
                    String string = accountMessage;
                    return string;
                }
                case 2: {
                    asstMessage = this.importAsstBalance(ctx, periodYear, periodNumber, masterCompany, curCompany, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    if (StringUtils.isEmpty((String)asstMessage)) return null;
                    String string = asstMessage;
                    return string;
                }
                case 3: {
                    accountMessage = this.importAccountBalance(ctx, periodYear, periodNumber, masterCompany, curCompany, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    asstMessage = this.importAsstBalance(ctx, periodYear, periodNumber, masterCompany, curCompany, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    if (!StringUtils.isEmpty((String)accountMessage)) {
                        message.append(accountMessage);
                    }
                    if (!StringUtils.isEmpty((String)asstMessage)) {
                        message.append(asstMessage);
                    }
                    if (StringUtils.isEmpty((String)message.toString())) return null;
                    String string = message.toString();
                    return string;
                }
                case 4: {
                    cussentMessage = this.importCussentBalance(ctx, periodYear, masterCompany, curCompany, periodNumber, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    if (StringUtils.isEmpty((String)cussentMessage)) return null;
                    String string = cussentMessage;
                    return string;
                }
                case 5: {
                    accountMessage = this.importAccountBalance(ctx, periodYear, periodNumber, masterCompany, curCompany, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    cussentMessage = this.importCussentBalance(ctx, periodYear, masterCompany, curCompany, periodNumber, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    if (!StringUtils.isEmpty((String)accountMessage)) {
                        message.append(accountMessage);
                    }
                    if (!StringUtils.isEmpty((String)cussentMessage)) {
                        message.append(cussentMessage);
                    }
                    if (StringUtils.isEmpty((String)message.toString())) return null;
                    String string = message.toString();
                    return string;
                }
                case 6: {
                    asstMessage = this.importAsstBalance(ctx, periodYear, periodNumber, masterCompany, curCompany, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    cussentMessage = this.importCussentBalance(ctx, periodYear, masterCompany, curCompany, periodNumber, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    if (!StringUtils.isEmpty((String)asstMessage)) {
                        message.append(asstMessage);
                    }
                    if (!StringUtils.isEmpty((String)cussentMessage)) {
                        message.append(cussentMessage);
                    }
                    if (StringUtils.isEmpty((String)message.toString())) return null;
                    String string = message.toString();
                    return string;
                }
                case 7: {
                    accountMessage = this.importAccountBalance(ctx, periodYear, periodNumber, masterCompany, curCompany, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    asstMessage = this.importAsstBalance(ctx, periodYear, periodNumber, masterCompany, curCompany, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    cussentMessage = this.importCussentBalance(ctx, periodYear, masterCompany, curCompany, periodNumber, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
                    if (!StringUtils.isEmpty((String)accountMessage)) {
                        message.append(accountMessage);
                    }
                    if (!StringUtils.isEmpty((String)asstMessage)) {
                        message.append(asstMessage);
                    }
                    if (!StringUtils.isEmpty((String)cussentMessage)) {
                        message.append(cussentMessage);
                    }
                    if (StringUtils.isEmpty((String)message.toString())) return null;
                    String string = message.toString();
                    return string;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
        }
    }

    private String importCussentBalance(Context ctx, String periodYear, CompanyOrgUnitInfo masterCompany, CompanyOrgUnitInfo curCompany, String periodNumber, HashMap otherCtx, PeriodInfo masterStartPeriod, PeriodInfo masterCurPeriod, PeriodInfo curStartPeriod) throws EASBizException, BOSException {
        SystemStatusCtrolCollection ctrols;
        int lcPre;
        String masterCompanyId = masterCompany.getId().toString();
        String curCompanyId = curCompany.getId().toString();
        mainOrg = masterCompany;
        asstOrg = curCompany;
        String mainBaseCurrency = masterCompany.getBaseCurrency().getId().toString();
        String transBaseCurrency = curCompany.getBaseCurrency().getId().toString();
        boolean isSameCurrency = mainBaseCurrency.equals(transBaseCurrency);
        boolean isSameRptCurrency = true;
        if (masterCompany.getReportCurrency() != null && curCompany.getReportCurrency() != null) {
            String mainRptCurrency = masterCompany.getReportCurrency().getId().toString();
            String transRptCurrency = curCompany.getReportCurrency().getId().toString();
            isSameRptCurrency = mainRptCurrency.equals(transRptCurrency);
        }
        VoucherInfo.ExchangeRateWithValue localRate = null;
        VoucherInfo.ExchangeRateWithValue rptRate = null;
        if (!isSameCurrency || !isSameRptCurrency) {
            Object[] exes = this.getExchangeRate(ctx, masterCompany, curCompany);
            localRate = (VoucherInfo.ExchangeRateWithValue)exes[0];
            rptRate = (VoucherInfo.ExchangeRateWithValue)exes[1];
            if (!isSameCurrency && localRate == null) {
                Object[] param = new Object[]{masterCompany.getBaseCurrency().getName(), curCompany.getBaseCurrency().getName()};
                throw new AccountBooksException(AccountBooksException.LOCALRATENOTFOUND, param);
            }
            if (!isSameRptCurrency && rptRate == null) {
                Object[] param = new Object[]{curCompany.getReportCurrency().getName(), masterCompany.getReportCurrency().getName()};
                throw new AccountBooksException(AccountBooksException.RPTRATENOTFOUND, param);
            }
        }
        String localRateValue = "1";
        String rptRateValue = "1";
        if (!isSameCurrency) {
            localRateValue = localRate.getValue().toString();
        }
        if (!isSameRptCurrency) {
            rptRateValue = rptRate.getValue().toString();
        }
        int rcurPre = lcPre = curCompany.getBaseCurrency().getPrecision();
        if (curCompany.getReportCurrency() != null) {
            rcurPre = curCompany.getReportCurrency().getPrecision();
        }
        PeriodInfo acPeriod = (ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select acPeriod.* where company.id='" + masterCompanyId + "' and systemStatus.name=6")).size() > 0 && ctrols.get(0).getAcPeriod() != null ? ctrols.get(0).getAcPeriod() : null;
        this.checkCusstInitPeriod(ctx, masterCompany, curCompany, otherCtx, masterStartPeriod, masterCurPeriod, curStartPeriod);
        PeriodInfo toMasterPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)curStartPeriod.getBeginDate(), (CompanyOrgUnitInfo)masterCompany);
        this.checkhasUnVerified(ctx, masterCompanyId, curStartPeriod, acPeriod);
        String deleteSql = "delete from t_gl_voucherassistrecord  where fid in (select FVchAssistRecordID from  t_GL_AcctCussent  where FCompanyID=?)  and not exists (select FVchAssistRecordID from  t_GL_AcctCussent ac where ac.FCompanyID=? and ac.FVchAssistRecordID = t_gl_voucherassistrecord.fid)";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new String[]{curCompanyId, masterCompany.getId().toString()});
        deleteSql = "delete from t_GL_AcctCussent  where FCompanyID=?  ";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new String[]{curCompanyId});
        deleteSql = "delete from T_BKS_BalanceAdjust where FOrgUnitID=? and FType=? ";
        DbUtil.execute((Context)ctx, (String)deleteSql.toString(), (Object[])new Object[]{curCompanyId, new Integer(3)});
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_052", new ObjectUuidPK(masterCompany.getId()));
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        boolean isInTimeVerify = false;
        int ctype = 0;
        if (hmAllParam.get("GL_052") != null) {
            ctype = Integer.parseInt(hmAllParam.get("GL_052").toString());
        }
        isInTimeVerify = ctype == 0;
        String message = null;
        boolean isCheckAccount = false;
        if (otherCtx.get("continue").equals("no")) {
            isCheckAccount = true;
        }
        StringBuffer sql = null;
        String srcTable = masterCompany.getAccountTable().getId().toString();
        String objTable = curCompany.getAccountTable().getId().toString();
        String accountRef = this.getRefContrastId(ctx, srcTable, objTable, curCompanyId);
        StringBuffer msgStr = new StringBuffer();
        if (accountRef == null) {
            HashSet<String> accountSet = new HashSet<String>();
            msgStr.append(this.validateAccountAndCurrencyAcForInit(ctx, masterCompanyId, curCompany, accountSet));
            if (isCheckAccount && !isSameCurrency && (message = this.checkAccountIsValid(ctx, mainBaseCurrency, transBaseCurrency, objTable, curCompanyId, true, null)) != null) {
                return message;
            }
            if (this.periodCompare(masterStartPeriod, curStartPeriod) == 0) {
                sql = this.getCussentSqlForInit(curCompanyId, localRateValue, rptRateValue, lcPre, rcurPre);
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, curCompanyId});
                String msg = this.getAssitInsertSql(ctx, curCompanyId, localRateValue, rptRateValue, lcPre, rcurPre, accountRef, curCompany);
                if (!StringUtils.isEmpty((String)msg)) {
                    msgStr.append(msg);
                }
                String updateSql = this.getAssitUpdateSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId});
                updateSql = this.getUpdateUnVerifiedAmountSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, curCompanyId});
                updateSql = this.getUpdateUnHoldedAmountSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId});
                updateSql = this.getInitAcctCussentVar();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, curCompanyId});
            } else {
                if (acPeriod == null) {
                    acPeriod = masterStartPeriod;
                }
                msgStr.append(this.validateAccountAndCurrencyAcForVoucher(ctx, masterCompanyId, curCompany, acPeriod.getPeriodYear(), acPeriod.getPeriodNumber(), toMasterPeriod.getPeriodYear(), toMasterPeriod.getPeriodNumber(), accountSet));
                sql = this.getCussentSqlForInit(curCompanyId, localRateValue, rptRateValue, lcPre, rcurPre);
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, curCompanyId});
                sql = this.getCussentSqlForVoucher(curCompanyId, localRateValue, rptRateValue, lcPre, rcurPre);
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, acPeriod.getPeriodYear() + "", acPeriod.getPeriodYear() + "", acPeriod.getPeriodNumber() + "", toMasterPeriod.getPeriodYear() + "", toMasterPeriod.getPeriodYear() + "", toMasterPeriod.getPeriodNumber() + "", curCompanyId});
                String msg = this.getAssitInsertSql(ctx, curCompanyId, localRateValue, rptRateValue, lcPre, rcurPre, accountRef, curCompany);
                if (!StringUtils.isEmpty((String)msg)) {
                    msgStr.append(msg);
                }
                String updateSql = this.getUpdateUnVerifiedAmountSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, curCompanyId});
                updateSql = this.getSubtractSql(isInTimeVerify, localRateValue, rptRateValue);
                if (isInTimeVerify) {
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), curCompanyId});
                } else {
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId});
                }
                updateSql = this.getAssitUpdateSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId});
                updateSql = this.getUpdateUnHoldedAmountSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId});
                updateSql = this.getInitAcctCussentVar();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, curCompanyId});
            }
        } else {
            accountRef = this.getRefContrastId(ctx, srcTable, objTable, curCompanyId);
            if (isCheckAccount && !isSameCurrency && (message = this.checkAccountIsValid(ctx, mainBaseCurrency, transBaseCurrency, objTable, curCompanyId, false, accountRef)) != null) {
                return message;
            }
            if (this.periodCompare(masterStartPeriod, curStartPeriod) == 0) {
                sql = this.getCussentSqlWithDtAcctForInit(curCompanyId, localRateValue, rptRateValue, lcPre, rcurPre);
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, accountRef});
                this.getAssitInsertSql(ctx, curCompanyId, localRateValue, rptRateValue, lcPre, rcurPre, accountRef, curCompany);
                String updateSql = this.getAssitUpdateSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId});
                updateSql = this.getUpdateUnVerifiedAmountSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, curCompanyId});
                updateSql = this.getUpdateUnHoldedAmountSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId});
                updateSql = this.getInitAcctCussentVar();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, curCompanyId});
            } else {
                sql = this.getCussentSqlWithDtAcctForInit(curCompanyId, localRateValue, rptRateValue, lcPre, rcurPre);
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, accountRef});
                sql = this.getCussentSqlWithDtAcctForVoucher(curCompanyId, localRateValue, rptRateValue, lcPre, rcurPre);
                if (acPeriod == null) {
                    acPeriod = masterStartPeriod;
                }
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, accountRef, acPeriod.getPeriodYear() + "", acPeriod.getPeriodYear() + "", acPeriod.getPeriodNumber() + "", curStartPeriod.getPeriodYear() + "", curStartPeriod.getPeriodYear() + "", curStartPeriod.getPeriodNumber() + ""});
                this.getAssitInsertSql(ctx, curCompanyId, localRateValue, rptRateValue, lcPre, rcurPre, accountRef, curCompany);
                String updateSql = this.getUpdateUnVerifiedAmountSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, curCompanyId});
                updateSql = this.getSubtractSql(isInTimeVerify, localRateValue, rptRateValue);
                if (isInTimeVerify) {
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), new Integer(curStartPeriod.getNumber()), curCompanyId});
                } else {
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId, masterCompanyId, masterCompanyId, new Integer(curStartPeriod.getNumber()), curCompanyId});
                }
                updateSql = this.getAssitUpdateSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId});
                updateSql = this.getUpdateUnHoldedAmountSql();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId});
                updateSql = this.getInitAcctCussentVar();
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, curCompanyId});
            }
        }
        if (curCompany.getReportCurrency() != null) {
            this.dealGlAcctCussentSamCurrency(ctx, curCompanyId, curCompany.getBaseCurrency().getId().toString(), curCompany.getReportCurrency().getId().toString());
        } else {
            this.dealGlAcctCussentSamCurrency(ctx, curCompanyId, curCompany.getBaseCurrency().getId().toString(), null);
        }
        if (!StringUtils.isEmpty((String)msgStr.toString())) {
            msgStr.insert(0, "\r\n" + EASResource.getString((String)GL_RESOURCE, (String)"1030", (Locale)ctx.getLocale()));
            return msgStr.toString();
        }
        return null;
    }

    private String getInitAcctCussentVar() {
        StringBuffer sql = new StringBuffer();
        sql.append(" update   t_GL_voucherassistrecord set (FOriginalAmount,FLocalAmount,FReportingAmount,FQuantity,FStandardQuantity) = \r\n");
        sql.append("( select FUnHoldedAmtFor,FUnHoldedAmtLocal,FUnHoldedAmtRpt, FUnHoldedQty, FUnHoldedStdQty from t_GL_AcctCussent ac where ac.FVchAssistRecordID = t_GL_voucherassistrecord.fid and ac.fcompanyid = ? ) \r\n");
        sql.append("    \r\n");
        sql.append(" where exists ( select 1  from t_GL_AcctCussent ac where ac.FVchAssistRecordID = t_GL_voucherassistrecord.fid and ac.fcompanyid = ?)                                                                \r\n");
        return sql.toString();
    }

    private StringBuffer getCussentSqlForInit(String curCompanyId, String localRateValue, String rptRateValue, int lcPre, int rcurPre) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into t_GL_AcctCussent                                                       \r\n");
        sql.append("(                                                                                  \r\n");
        sql.append("    FSeq,                                                                          \r\n");
        sql.append("    FID,                                                                           \r\n");
        sql.append("    FCompanyID,                                                                    \r\n");
        sql.append("    FAccountID,                                                                    \r\n");
        sql.append("    FCurrencyID,                                                                   \r\n");
        sql.append("    FIsInit,                                                                       \r\n");
        sql.append("    FIsInitClosed,                                                                 \r\n");
        sql.append("    FVchAssistRecordID,                                                            \r\n");
        sql.append("    fsourcebillid,                                                                 \r\n");
        sql.append("    FCreatorID,                                                                    \r\n");
        sql.append("    FCreateTime,                                                                   \r\n");
        sql.append("    FLastUpdateUserID,                                                             \r\n");
        sql.append("    FLastUpdateTime,                                                               \r\n");
        sql.append("    FUnVerifiedAmtFor,                                                             \r\n");
        sql.append("    FUnHoldedAmtFor,                                                               \r\n");
        sql.append("    FUnVerifiedAmtLocal,                                                           \r\n");
        sql.append("    FUnHoldedAmtLocal,                                                             \r\n");
        sql.append("    FUnVerifiedAmtRpt,                                                             \r\n");
        sql.append("    FUnHoldedAmtRpt,                                                               \r\n");
        sql.append("    FMeasureUnitID,                                                                \r\n");
        sql.append("    FUnVerifiedQty,                                                                \r\n");
        sql.append("    FUnHoldedQty,                                                                  \r\n");
        sql.append("    FUnVerifiedStdQty,                                                             \r\n");
        sql.append("    FUnHoldedStdQty                                                                \r\n");
        sql.append(")                                                                                  \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("Select                                                                             \r\n");
        sql.append("    bal.FSeq,                                                                   \r\n");
        sql.append("    newBosID('CE2D850A'),                                                          \r\n");
        sql.append("'");
        sql.append(curCompanyId);
        sql.append("',");
        sql.append("    acctnew.fid,                                                                 \r\n");
        sql.append("    bal.FCurrencyID,                                                                 \r\n");
        sql.append("    1,                                                                             \r\n");
        sql.append("    0,                                                                             \r\n");
        sql.append("    bal.FVchAssistRecordID,                                                           \r\n");
        sql.append("    newBosID('0FFFBCAA'),                                                                               \r\n");
        sql.append("    bal.FCreatorID,                                                                    \r\n");
        sql.append("    bal.FCreateTime,                                                                   \r\n");
        sql.append("    bal.FLastUpdateUserID,                                                             \r\n");
        sql.append("    bal.FLastUpdateTime,                                                               \r\n");
        sql.append("    bal.FUnVerifiedAmtFor,                                                             \r\n");
        sql.append("    bal.FUnHoldedAmtFor,                                                               \r\n");
        sql.append(" TO_DECIMAL( bal.FUnVerifiedAmtLocal*");
        sql.append(localRateValue);
        sql.append(",19,");
        sql.append(lcPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnHoldedAmtLocal*");
        sql.append(localRateValue);
        sql.append(",19,");
        sql.append(lcPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnVerifiedAmtRpt*");
        sql.append(rptRateValue);
        sql.append(",19,");
        sql.append(rcurPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnHoldedAmtRpt*");
        sql.append(rptRateValue);
        sql.append(",19,");
        sql.append(rcurPre);
        sql.append("),");
        sql.append("    bal.FMeasureUnitID,                                                                \r\n");
        sql.append("    bal.FUnVerifiedQty,                                                                \r\n");
        sql.append("    bal.FUnHoldedQty,                                                                  \r\n");
        sql.append("    bal.FUnVerifiedStdQty,                                                             \r\n");
        sql.append("    bal.FUnHoldedStdQty                                                                \r\n");
        sql.append(" From T_GL_AcctCussent  bal                                                                                       \r\n");
        sql.append("         inner join t_bd_accountview acct on acct.fid=bal.FAccountID \r\n ");
        sql.append("         inner join t_bd_accountview acctnew on acctnew.fnumber=acct.fnumber  \r\n ");
        sql.append("Where   bal.FCompanyID = ? and bal.fisinit=1  and acctnew.fcompanyid=? \r\n");
        return sql;
    }

    private StringBuffer getCussentSqlForVoucher(String curCompanyId, String localRateValue, String rptRateValue, int lcPre, int rcurPre) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into t_GL_AcctCussent                                                       \r\n");
        sql.append("(                                                                                  \r\n");
        sql.append("    FID,                                                                           \r\n");
        sql.append("    FCompanyID,                                                                    \r\n");
        sql.append("    FAccountID,                                                                    \r\n");
        sql.append("    FCurrencyID,                                                                   \r\n");
        sql.append("    FIsInit,                                                                       \r\n");
        sql.append("    FIsInitClosed,                                                                 \r\n");
        sql.append("    FVchAssistRecordID,                                                            \r\n");
        sql.append("    fsourcebillid,                                                                 \r\n");
        sql.append("    FCreatorID,                                                                    \r\n");
        sql.append("    FCreateTime,                                                                   \r\n");
        sql.append("    FLastUpdateUserID,                                                             \r\n");
        sql.append("    FLastUpdateTime,                                                               \r\n");
        sql.append("    FUnVerifiedAmtFor,                                                             \r\n");
        sql.append("    FUnHoldedAmtFor,                                                               \r\n");
        sql.append("    FUnVerifiedAmtLocal,                                                           \r\n");
        sql.append("    FUnHoldedAmtLocal,                                                             \r\n");
        sql.append("    FUnVerifiedAmtRpt,                                                             \r\n");
        sql.append("    FUnHoldedAmtRpt,                                                               \r\n");
        sql.append("    FMeasureUnitID,                                                                \r\n");
        sql.append("    FUnVerifiedQty,                                                                \r\n");
        sql.append("    FUnHoldedQty,                                                                  \r\n");
        sql.append("    FUnVerifiedStdQty,                                                             \r\n");
        sql.append("    FUnHoldedStdQty                                                                \r\n");
        sql.append(")                                                                                  \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("Select                                                                             \r\n");
        sql.append("    newBosID('CE2D850A'),                                                          \r\n");
        sql.append("'");
        sql.append(curCompanyId);
        sql.append("',");
        sql.append("    acctnew.fid,                                                                 \r\n");
        sql.append("    bal.FCurrencyID,                                                                 \r\n");
        sql.append("    1,                                                                             \r\n");
        sql.append("    0,                                                                             \r\n");
        sql.append("    bal.FVchAssistRecordID,                                                           \r\n");
        sql.append("    newBosID('0FFFBCAA'),                                                                               \r\n");
        sql.append("    bal.FCreatorID,                                                                    \r\n");
        sql.append("    bal.FCreateTime,                                                                   \r\n");
        sql.append("    bal.FLastUpdateUserID,                                                             \r\n");
        sql.append("    bal.FLastUpdateTime,                                                               \r\n");
        sql.append("    bal.FUnVerifiedAmtFor,                                                             \r\n");
        sql.append("    bal.FUnHoldedAmtFor,                                                               \r\n");
        sql.append(" TO_DECIMAL( bal.FUnVerifiedAmtLocal*");
        sql.append(localRateValue);
        sql.append(",19,");
        sql.append(lcPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnHoldedAmtLocal*");
        sql.append(localRateValue);
        sql.append(",19,");
        sql.append(lcPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnVerifiedAmtRpt*");
        sql.append(rptRateValue);
        sql.append(",19,");
        sql.append(rcurPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnHoldedAmtRpt*");
        sql.append(rptRateValue);
        sql.append(",19,");
        sql.append(rcurPre);
        sql.append("),");
        sql.append("    bal.FMeasureUnitID,                                                                \r\n");
        sql.append("    bal.FUnVerifiedQty,                                                                \r\n");
        sql.append("    bal.FUnHoldedQty,                                                                  \r\n");
        sql.append("    bal.FUnVerifiedStdQty,                                                             \r\n");
        sql.append("    bal.FUnHoldedStdQty                                                                \r\n");
        sql.append(" From T_GL_AcctCussent  bal                                                           \r\n");
        sql.append("    inner join t_bd_period pi on pi.fid=bal.fperiodid                              \r\n");
        sql.append("         inner join t_bd_accountview acct on acct.fid=bal.FAccountID \r\n ");
        sql.append("         inner join t_bd_accountview acctnew on acctnew.fnumber=acct.fnumber  \r\n ");
        sql.append("Where   bal.FCompanyID = ? and  bal.fisinit=0 and (pi.fperiodyear>? or( pi.fperiodyear=? and  pi.fperiodnumber>=?)) and (pi.fperiodyear<? or( pi.fperiodyear=? and  pi.fperiodnumber<?)) and acctnew.fcompanyid=? \r\n");
        return sql;
    }

    private StringBuffer getCussentSqlWithDtAcctForInit(String curCompanyId, String localRateValue, String rptRateValue, int lcPre, int rcurPre) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into t_GL_AcctCussent                                                       \r\n");
        sql.append("(                                                                                  \r\n");
        sql.append("    FID,                                                                           \r\n");
        sql.append("    FCompanyID,                                                                    \r\n");
        sql.append("    FAccountID,                                                                    \r\n");
        sql.append("    FCurrencyID,                                                                   \r\n");
        sql.append("    FIsInit,                                                                       \r\n");
        sql.append("    FIsInitClosed,                                                                 \r\n");
        sql.append("    FVchAssistRecordID,                                                            \r\n");
        sql.append("    Fassgrpid,                                                                     \r\n");
        sql.append("    fsourcebillid,                                                                 \r\n");
        sql.append("    FCreatorID,                                                                    \r\n");
        sql.append("    FCreateTime,                                                                   \r\n");
        sql.append("    FLastUpdateUserID,                                                             \r\n");
        sql.append("    FLastUpdateTime,                                                               \r\n");
        sql.append("    FUnVerifiedAmtFor,                                                             \r\n");
        sql.append("    FUnHoldedAmtFor,                                                               \r\n");
        sql.append("    FUnVerifiedAmtLocal,                                                           \r\n");
        sql.append("    FUnHoldedAmtLocal,                                                             \r\n");
        sql.append("    FUnVerifiedAmtRpt,                                                             \r\n");
        sql.append("    FUnHoldedAmtRpt,                                                               \r\n");
        sql.append("    FMeasureUnitID,                                                                \r\n");
        sql.append("    FUnVerifiedQty,                                                                \r\n");
        sql.append("    FUnHoldedQty,                                                                  \r\n");
        sql.append("    FUnVerifiedStdQty,                                                             \r\n");
        sql.append("    FUnHoldedStdQty                                                                \r\n");
        sql.append(")                                                                                  \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("Select                                                                             \r\n");
        sql.append("    newBosID('CE2D850A'),                                                          \r\n");
        sql.append("'");
        sql.append(curCompanyId);
        sql.append("',");
        sql.append("    refe.FnewacctID,                                                                 \r\n");
        sql.append("    bal.FCurrencyID,                                                                 \r\n");
        sql.append("    1,                                                                             \r\n");
        sql.append("    0,                                                                             \r\n");
        sql.append("    bal.FVchAssistRecordID,                                                           \r\n");
        sql.append("    bal.Fassgrpid,                                                           \r\n");
        sql.append("    newBosID('0FFFBCAA'),                                                                               \r\n");
        sql.append("    bal.FCreatorID,                                                                    \r\n");
        sql.append("    bal.FCreateTime,                                                                   \r\n");
        sql.append("    bal.FLastUpdateUserID,                                                             \r\n");
        sql.append("    bal.FLastUpdateTime,                                                               \r\n");
        sql.append("    bal.FUnVerifiedAmtFor,                                                             \r\n");
        sql.append("    bal.FUnHoldedAmtFor,                                                               \r\n");
        sql.append(" TO_DECIMAL( bal.FUnVerifiedAmtLocal*");
        sql.append(localRateValue);
        sql.append(",19,");
        sql.append(lcPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnHoldedAmtLocal*");
        sql.append(localRateValue);
        sql.append(",19,");
        sql.append(lcPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnVerifiedAmtRpt*");
        sql.append(rptRateValue);
        sql.append(",19,");
        sql.append(rcurPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnHoldedAmtRpt*");
        sql.append(rptRateValue);
        sql.append(",19,");
        sql.append(rcurPre);
        sql.append("),");
        sql.append("    bal.FMeasureUnitID,                                                                \r\n");
        sql.append("    bal.FUnVerifiedQty,                                                                \r\n");
        sql.append("    bal.FUnHoldedQty,                                                                  \r\n");
        sql.append("    bal.FUnVerifiedStdQty,                                                             \r\n");
        sql.append("    bal.FUnHoldedStdQty                                                                \r\n");
        sql.append(" From T_GL_AcctCussent bal,T_BD_AcctRefContrastEntry refe                \r\n");
        sql.append("Where   bal.FCompanyID = ? and bal.fisinit=1 and bal.fisinitclosed=1 and bal.faccountid=refe.foldacctid and refe.FacctrefcontrastId=?  \r\n");
        return sql;
    }

    private StringBuffer getCussentSqlWithDtAcctForVoucher(String curCompanyId, String localRateValue, String rptRateValue, int lcPre, int rcurPre) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into t_GL_AcctCussent                                                       \r\n");
        sql.append("(                                                                                  \r\n");
        sql.append("    FID,                                                                           \r\n");
        sql.append("    FCompanyID,                                                                    \r\n");
        sql.append("    FAccountID,                                                                    \r\n");
        sql.append("    FCurrencyID,                                                                   \r\n");
        sql.append("    FIsInit,                                                                       \r\n");
        sql.append("    FIsInitClosed,                                                                 \r\n");
        sql.append("    FVchAssistRecordID,                                                            \r\n");
        sql.append("    Fassgrpid,                                                                     \r\n");
        sql.append("    fsourcebillid,                                                                 \r\n");
        sql.append("    FCreatorID,                                                                    \r\n");
        sql.append("    FCreateTime,                                                                   \r\n");
        sql.append("    FLastUpdateUserID,                                                             \r\n");
        sql.append("    FLastUpdateTime,                                                               \r\n");
        sql.append("    FUnVerifiedAmtFor,                                                             \r\n");
        sql.append("    FUnHoldedAmtFor,                                                               \r\n");
        sql.append("    FUnVerifiedAmtLocal,                                                           \r\n");
        sql.append("    FUnHoldedAmtLocal,                                                             \r\n");
        sql.append("    FUnVerifiedAmtRpt,                                                             \r\n");
        sql.append("    FUnHoldedAmtRpt,                                                               \r\n");
        sql.append("    FMeasureUnitID,                                                                \r\n");
        sql.append("    FUnVerifiedQty,                                                                \r\n");
        sql.append("    FUnHoldedQty,                                                                  \r\n");
        sql.append("    FUnVerifiedStdQty,                                                             \r\n");
        sql.append("    FUnHoldedStdQty                                                                \r\n");
        sql.append(")                                                                                  \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("Select                                                                             \r\n");
        sql.append("    newBosID('CE2D850A'),                                                          \r\n");
        sql.append("'");
        sql.append(curCompanyId);
        sql.append("',");
        sql.append("    refe.FnewacctID,                                                                 \r\n");
        sql.append("    bal.FCurrencyID,                                                                 \r\n");
        sql.append("    1,                                                                             \r\n");
        sql.append("    0,                                                                             \r\n");
        sql.append("    bal.FVchAssistRecordID,                                                           \r\n");
        sql.append("    bal.Fassgrpid,                                                           \r\n");
        sql.append("    newBosID('0FFFBCAA'),                                                                               \r\n");
        sql.append("    bal.FCreatorID,                                                                    \r\n");
        sql.append("    bal.FCreateTime,                                                                   \r\n");
        sql.append("    bal.FLastUpdateUserID,                                                             \r\n");
        sql.append("    bal.FLastUpdateTime,                                                               \r\n");
        sql.append("    bal.FUnVerifiedAmtFor,                                                             \r\n");
        sql.append("    bal.FUnHoldedAmtFor,                                                               \r\n");
        sql.append(" TO_DECIMAL( bal.FUnVerifiedAmtLocal*");
        sql.append(localRateValue);
        sql.append(",19,");
        sql.append(lcPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnHoldedAmtLocal*");
        sql.append(localRateValue);
        sql.append(",19,");
        sql.append(lcPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnVerifiedAmtRpt*");
        sql.append(rptRateValue);
        sql.append(",19,");
        sql.append(rcurPre);
        sql.append("),");
        sql.append(" TO_DECIMAL( bal.FUnHoldedAmtRpt*");
        sql.append(rptRateValue);
        sql.append(",19,");
        sql.append(rcurPre);
        sql.append("),");
        sql.append("    bal.FMeasureUnitID,                                                                \r\n");
        sql.append("    bal.FUnVerifiedQty,                                                                \r\n");
        sql.append("    bal.FUnHoldedQty,                                                                  \r\n");
        sql.append("    bal.FUnVerifiedStdQty,                                                             \r\n");
        sql.append("    bal.FUnHoldedStdQty                                                                \r\n");
        sql.append("From T_GL_AcctCussent bal,T_BD_AcctRefContrastEntry refe,t_bd_period pi                 \r\n");
        sql.append("Where   bal.FCompanyID = ? and bal.fisinit=0 and bal.faccountid=refe.foldacctid and refe.FacctrefcontrastId=?  \r\n");
        sql.append(" and pi.fid=bal.fperiodid and  (pi.fperiodyear>? or( pi.fperiodyear=? and  pi.fperiodnumber>=?)) and (pi.fperiodyear<? or( pi.fperiodyear=? and  pi.fperiodnumber<?))           \r\n");
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssitInsertSql(Context ctx, String curCompanyId, String localRateValue, String rptRateValue, int lcPre, int rcurPre, String accountRef, CompanyOrgUnitInfo curCompany) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        StringBuffer sbMsg = new StringBuffer();
        String tempTable = "tempTable_voucherassistrecord ";
        SqlParams sp = new SqlParams();
        sql.append(" Select                                                                             \r\n");
        sql.append(" a.fsourcebillid fsourcebillid,                                                               \r\n");
        sql.append(" a.faccountid fnewacctid,                                                      \r\n");
        if (StringUtils.isEmpty((String)accountRef)) {
            sql.append(" acct.fid foldacctid,                                                     \r\n");
        } else {
            sql.append(" refe.foldacctid foldacctid,                                                     \r\n");
        }
        sql.append(" c.Fassgrpid   as      FAssistGrpID ,                                         \r\n");
        sql.append(" c.FSeq FSeq,                                                                        \r\n");
        sql.append(" c.fbizdate fbizdate,                                                                    \r\n");
        sql.append(" c.foriginalamount foriginalamount,                                                           \r\n");
        sql.append(" TO_DECIMAL( c.flocalamount*");
        sql.append(localRateValue);
        sql.append(",19,");
        sql.append(lcPre);
        sql.append(") flocalamount,");
        sql.append(" TO_DECIMAL( c.freportingamount*");
        sql.append(rptRateValue);
        sql.append(",19,");
        sql.append(rcurPre);
        sql.append(") freportingamount,");
        sql.append("    c.fquantity  fquantity,                                                             \r\n");
        sql.append("    c.fdescription fdescription,                                                                \r\n");
        sql.append("    c.fsettlementtypeid fsettlementtypeid,                                                           \r\n");
        sql.append("    c.fsettlementcode fsettlementcode,                                                             \r\n");
        sql.append("    c.fstandardquantity fstandardquantity,                                                             \r\n");
        sql.append("    c.fbiznumber fbiznumber,                                                                  \r\n");
        sql.append("    c.fenddate fenddate,                                                                    \r\n");
        sql.append("    c.fcustomerid fcustomerid,                                                                 \r\n");
        sql.append("    c.finvoicenumber finvoicenumber,                                                             \r\n");
        sql.append("    c.fticketnumber fticketnumber,                                                                \r\n");
        sql.append("    c.fmeasureunitid fmeasureunitid                                                        \r\n");
        sql.append("     into " + tempTable);
        sql.append("    From  T_GL_AcctCussent  a,t_gl_voucherassistrecord c,                           \r\n");
        if (StringUtils.isEmpty((String)accountRef)) {
            sql.append(" t_bd_accountview acct                                                      \r\n");
        } else {
            sql.append(" T_BD_AcctRefContrastEntry refe                                                      \r\n");
        }
        sql.append("    Where  a.FCompanyID = ? ");
        sp.addString(curCompanyId);
        sql.append(" and a.fvchassistrecordid=c.fid                                      \r\n");
        if (StringUtils.isEmpty((String)accountRef)) {
            sql.append(" and a.faccountid=acct.fid                                      \r\n");
        } else {
            sql.append(" and a.faccountid=refe.fnewacctid                                      \r\n");
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            tempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
        }
        catch (Exception ex) {
            throw new BOSException("SQL ERROR", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(tempTable, "FAssistGrpID", false, false);
        }
        catch (Exception ex) {
            logger.error((Object)"SQL ERROR", (Throwable)ex);
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tempTable);
        }
        catch (Exception ex) {
            logger.error((Object)"SQL ERROR", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        try {
            String msg = this.dealAssistHg(ctx, tempTable, accountRef, curCompany);
            if (!StringUtils.isEmpty((String)msg)) {
                sbMsg.append(msg);
            }
            StringBuffer insertSql = new StringBuffer();
            insertSql.append(" insert into t_gl_voucherassistrecord                                               \r\n");
            insertSql.append("(                                                                                  \r\n");
            insertSql.append("  FID,                                                                             \r\n");
            insertSql.append("  Fassgrpid,                                                                       \r\n");
            insertSql.append("  FSeq,                                                                            \r\n");
            insertSql.append("  fbizdate,                                                                        \r\n");
            insertSql.append("  foriginalamount,");
            insertSql.append("  flocalamount,");
            insertSql.append("  freportingamount,");
            insertSql.append("  fquantity,                                                                       \r\n");
            insertSql.append("  fdescription,                                                                    \r\n");
            insertSql.append("  fsettlementtypeid,                                                               \r\n");
            insertSql.append("  fsettlementcode,                                                                 \r\n");
            insertSql.append("  fstandardquantity,                                                               \r\n");
            insertSql.append("  fbiznumber,                                                                      \r\n");
            insertSql.append("  fenddate,                                                                        \r\n");
            insertSql.append("  fcustomerid,                                                                     \r\n");
            insertSql.append("  finvoicenumber,                                                                  \r\n");
            insertSql.append("  fticketnumber,                                                                    \r\n");
            insertSql.append("  fmeasureunitid                                                                    \r\n");
            insertSql.append("   )  ");
            insertSql.append("select fsourcebillid,FAssistGrpID,FSeq, fbizdate,foriginalamount,flocalamount,freportingamount,fquantity,fdescription,fsettlementtypeid,fsettlementcode,fstandardquantity,fbiznumber,fenddate,fcustomerid,finvoicenumber,fticketnumber,fmeasureunitid  from " + tempTable);
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR", (Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        if (!StringUtils.isEmpty((String)sbMsg.toString())) {
            return sbMsg.toString();
        }
        return null;
    }

    private String getAssitUpdateSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" update   t_GL_AcctCussent set  fvchassistrecordid= fsourcebillid      \r\n");
        sql.append(" where fcompanyid=?                                                                \r\n");
        return sql.toString();
    }

    private String getUpdateUnVerifiedAmountSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_GL_AcctCussent set  \r\n");
        sql.append(" (FUnVerifiedAmtFor,FUnVerifiedAmtLocal,FUnVerifiedAmtRpt,FUnVerifiedQty,fassgrpid) \r\n");
        sql.append(" =(select t.foriginalamount,t.flocalamount, t.freportingamount,t.fquantity,t.fassgrpid \r\n");
        sql.append(" from (select va.fid,va.foriginalamount,va.flocalamount,va.freportingamount,va.fquantity,va.fassgrpid \r\n");
        sql.append(" from t_gl_voucherassistrecord va) t where fcompanyid = ? and t.fid = fsourcebillid )  \r\n");
        sql.append(" where fcompanyid=?                                                                \r\n");
        return sql.toString();
    }

    private String getUpdateUnHoldedAmountSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" update   t_GL_AcctCussent set  \r\n");
        sql.append(" FUnVerifiedStdQty=FUnVerifiedQty, FUnHoldedAmtFor=FUnVerifiedAmtFor,FUnHoldedAmtLocal=FUnVerifiedAmtLocal,   \r\n");
        sql.append(" FUnHoldedAmtRpt=FUnVerifiedAmtRpt ,funHoldedQty=FUnVerifiedQty ,FUnHoldedStdQty=FUnVerifiedQty \r\n");
        sql.append(" where fcompanyid=?                                                                \r\n");
        return sql.toString();
    }

    private String getSubtractSql(boolean isInTimeVerify, String localRateValue, String rptRateValue) {
        StringBuffer sql = new StringBuffer();
        StringBuffer innerFrom = new StringBuffer();
        if (isInTimeVerify) {
            innerFrom.append(" from t_gl_voucherassistrecord vch where exists  (select ac.* from t_GL_AcctCussent ac ,t_gl_voucher v,t_bd_period p  where    ac.fid <> t_GL_AcctCussent.fid and ac.FVchAssistRecordID = t_GL_AcctCussent.FVchAssistRecordID and ac.fid = vch.FVerifiedCussentID  \r\nand vch.fbillid = v.fid and v.fperiodid = p.fid and p.fnumber < ? and p.fnumber < ?  )");
            sql.append(" update   t_GL_AcctCussent set  ");
            sql.append(" FUnVerifiedAmtFor=FUnVerifiedAmtFor-(select  case when sum(FOriginalAmount) is null then 0 else sum(FOriginalAmount) end ").append(innerFrom).append(") , \r\n");
            sql.append(" FUnVerifiedAmtLocal=FUnVerifiedAmtLocal-(select  case when sum(FLocalAmount) is null then 0 else sum(FLocalAmount)*");
            sql.append(localRateValue);
            sql.append(" end ").append(innerFrom).append(") , \r\n");
            sql.append(" FUnVerifiedAmtRpt=FUnVerifiedAmtRpt-(select  case when sum(freportingamount) is null then 0 else sum(freportingamount)*");
            sql.append(rptRateValue);
            sql.append(" end ").append(innerFrom).append(") , \r\n");
            sql.append(" FUnVerifiedQty=FUnVerifiedQty-(select  case when sum(FQuantity) is null then 0 else sum(FQuantity) end   ").append(innerFrom).append(") , \r\n");
            sql.append(" FUnVerifiedStdQty=FUnVerifiedStdQty-(select case when sum(FStandardQuantity) is null then 0 else sum(FStandardQuantity) end  ").append(innerFrom).append(") \r\n");
            sql.append(" where fcompanyid=?                                                                \r\n");
        } else {
            innerFrom.append(" from  t_GL_AcctCussentHistory his  where  exists  ( select ac.fid from t_GL_AcctCussent ac,t_gl_voucherassistrecord va,t_gl_voucher v,t_bd_period p where  ac.FVchAssistRecordID = t_GL_AcctCussent.FVchAssistRecordID and t_GL_AcctCussent.fcompanyid = ? and v.fcompanyid = ? and ac.fcompanyid = ?  and ((ac.fid = his.FCussentidID and his.FVoucherAsstIDID = va.fid and va.fbillid = v.fid and v.fperiodid = p.fid and p.fnumber <?) ))");
            innerFrom.append("\r\r or exists ( select ac.fid from t_GL_AcctCussent ac,t_gl_voucherassistrecord va,t_bd_period p,t_GL_AcctCussent acv where  ac.FVchAssistRecordID = t_GL_AcctCussent.FVchAssistRecordID and t_GL_AcctCussent.fcompanyid = ?  and ac.fcompanyid = ? and acv.fcompanyid = ? and (( ac.fid = his.FVoucherAsstIDID and his.FCussentidID = acv.fid and acv.fperiodid = p.fid and p.fnumber <?)))");
            sql.append(" update   t_GL_AcctCussent set  ");
            sql.append(" FUnVerifiedAmtFor=FUnVerifiedAmtFor-(select  case when sum(FOroginalAmount) is null then 0 else sum(FOroginalAmount) end ").append(innerFrom).append(") , \r\n");
            sql.append(" FUnVerifiedAmtLocal=FUnVerifiedAmtLocal-(select  case when sum(FLocalAmount) is null then 0 else sum(FLocalAmount)*");
            sql.append(localRateValue);
            sql.append(" end ").append(innerFrom).append(") , \r\n");
            sql.append(" FUnVerifiedAmtRpt=FUnVerifiedAmtRpt-(select  case when sum(FReportAmount) is null then 0 else sum(FReportAmount)*");
            sql.append(rptRateValue);
            sql.append(" end ").append(innerFrom).append(") , \r\n");
            sql.append(" FUnVerifiedQty=FUnVerifiedQty-(select  case when sum(FQty) is null then 0 else sum(FQty) end   ").append(innerFrom).append(") , \r\n");
            sql.append(" FUnVerifiedStdQty=FUnVerifiedStdQty-(select case when sum(FQty) is null then 0 else sum(FQty) end  ").append(innerFrom).append(") \r\n");
            sql.append(" where fcompanyid=?                                                                \r\n");
        }
        return sql.toString();
    }

    private void checkCusstInitPeriod(Context ctx, CompanyOrgUnitInfo masterCompany, CompanyOrgUnitInfo curCompany, HashMap otherCtx, PeriodInfo masterStartPeriod, PeriodInfo masterCurPeriod, PeriodInfo curStartPeriod) throws EASBizException, BOSException {
        if (this.periodCompare(masterStartPeriod, curStartPeriod) > 0) {
            throw new AccountBooksException(AccountBooksException.SUBBOOK_AFTER_MAINSTARTPI);
        }
        if (this.periodCompare(masterStartPeriod, curStartPeriod) == 0) {
            otherCtx.put("COMPANY", otherCtx.get("mastercompany"));
            ArrayList cussentInitInfo = AcctCussentInitFacadeFactory.getLocalInstance(ctx).findInitData(otherCtx);
            boolean flag = (Boolean)cussentInitInfo.get(7);
            if (!flag) {
                throw new AccountBooksException(AccountBooksException.MAINBOOK_CUSST_NOTCLOSED);
            }
        }
        if (this.periodCompare(masterCurPeriod, curStartPeriod) < 0) {
            throw new AccountBooksException(AccountBooksException.SUBBOOK_BEFORE_MAINCURPI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String importAsstBalance(Context ctx, String periodYear, String periodNumber, CompanyOrgUnitInfo masterCompany, CompanyOrgUnitInfo curCompany, HashMap otherCtx, PeriodInfo masterStartPeriod, PeriodInfo masterCurPeriod, PeriodInfo curStartPeriod) throws BOSException, EASBizException {
        masterCompanyId = masterCompany.getId().toString();
        curCompanyId = curCompany.getId().toString();
        BalanceInitFacadeControllerBean.mainOrg = masterCompany;
        BalanceInitFacadeControllerBean.asstOrg = curCompany;
        isFirstPeriod = false;
        curFirstPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)new Integer(periodYear), (int)1, (CompanyOrgUnitInfo)curCompany);
        if (curFirstPeriod.getNumber() == curStartPeriod.getNumber()) {
            isFirstPeriod = true;
        }
        isSameStartPeriod = false;
        if (masterCompany.getAccountPeriodType().equals((Object)curCompany.getAccountPeriodType()) && masterStartPeriod.equals((Object)curStartPeriod)) {
            isSameStartPeriod = true;
        }
        curBeforePeriod = null;
        toMasterFirstPeriod = null;
        toMasterBeforePeriod = null;
        if (!isFirstPeriod) {
            curBeforePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)curStartPeriod);
            if (curBeforePeriod == null) {
                isFirstPeriod = true;
            } else {
                toMasterFirstPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)curFirstPeriod.getBeginDate(), (CompanyOrgUnitInfo)masterCompany);
                toMasterBeforePeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)curBeforePeriod.getEndDate(), (CompanyOrgUnitInfo)masterCompany);
            }
        }
        if (toMasterBeforePeriod != null) {
            if (toMasterFirstPeriod == null) {
                toMasterFirstPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)toMasterBeforePeriod.getPeriodYear(), (int)1, (CompanyOrgUnitInfo)masterCompany);
            }
        } else {
            isFirstPeriod = true;
        }
        mainBaseCurrency = masterCompany.getBaseCurrency().getId().toString();
        transBaseCurrency = curCompany.getBaseCurrency().getId().toString();
        isSameCurrency = mainBaseCurrency.equals(transBaseCurrency);
        isSameRptCurrency = true;
        if (masterCompany.getReportCurrency() != null && curCompany.getReportCurrency() != null) {
            mainRptCurrency = masterCompany.getReportCurrency().getId().toString();
            transRptCurrency = curCompany.getReportCurrency().getId().toString();
            isSameRptCurrency = mainRptCurrency.equals(transRptCurrency);
        }
        localRate = null;
        rptRate = null;
        if (!isSameCurrency || !isSameRptCurrency) {
            exes = this.getExchangeRate(ctx, masterCompany, curCompany);
            localRate = (VoucherInfo.ExchangeRateWithValue)exes[0];
            rptRate = (VoucherInfo.ExchangeRateWithValue)exes[1];
            if (!isSameCurrency && localRate == null) {
                param = new Object[]{masterCompany.getBaseCurrency().getName(), curCompany.getBaseCurrency().getName()};
                throw new AccountBooksException(AccountBooksException.LOCALRATENOTFOUND, param);
            }
            if (!isSameRptCurrency && rptRate == null) {
                param = new Object[]{curCompany.getReportCurrency().getName(), masterCompany.getReportCurrency().getName()};
                throw new AccountBooksException(AccountBooksException.RPTRATENOTFOUND, param);
            }
        }
        localRateValue = "1";
        rptRateValue = "1";
        if (!isSameCurrency) {
            localRateValue = localRate.getValue().toString();
        }
        if (!isSameRptCurrency) {
            rptRateValue = rptRate.getValue().toString();
        }
        rcurPre = lcPre = curCompany.getBaseCurrency().getPrecision();
        if (curCompany.getReportCurrency() != null) {
            rcurPre = curCompany.getReportCurrency().getPrecision();
        }
        hmParamValue = InitHelp.getInitParam(ctx, curCompany);
        qtyAsst = (Boolean)hmParamValue.get("G010");
        this.checkAsstInitPeriod(ctx, masterCompany, curCompany, masterStartPeriod, masterCurPeriod, curStartPeriod, otherCtx);
        sql = new StringBuffer();
        sql.append("delete from T_GL_InitAssistBalance  where forgunitid=? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{curCompanyId});
        sql = new StringBuffer();
        sql.append("delete from T_BKS_BalanceAdjust where FOrgUnitID=? and FType=? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyId, new Integer(2)});
        message = null;
        isCheckAccount = false;
        if (otherCtx.get("continue").equals("no")) {
            isCheckAccount = true;
        }
        tempTable = "tempTable_assistBalance";
        tempTable2 = "tempTable_assistBalanceForYear";
        sql = new StringBuffer();
        srcTable = masterCompany.getAccountTable().getId().toString();
        objTable = curCompany.getAccountTable().getId().toString();
        curPerDate = curStartPeriod.getBeginDate();
        toMasterPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)curPerDate, (CompanyOrgUnitInfo)masterCompany);
        periodYear = String.valueOf(toMasterPeriod.getPeriodYear());
        periodNumber = String.valueOf(toMasterPeriod.getPeriodNumber());
        accountRef = this.getRefContrastId(ctx, srcTable, objTable, curCompanyId);
        msgStr = new StringBuffer();
        if (accountRef == null) {
            msgStr.append(this.validateAccountAndCurrency(ctx, masterCompanyId, periodYear, periodNumber, curCompany));
            if (isSameCurrency && isSameRptCurrency) {
                sp = new SqlParams();
                sql.append(" select bal.fbeginbalancefor*acctnew.fdc fbeginbalancefor ,bal.fbeginbalancelocal*acctnew.fdc fbeginbalancelocal,bal.fbeginbalancerpt*acctnew.fdc fbeginbalancerpt,bal.fbeginqty*acctnew.fdc fbeginqty,bal.fbeginqty*acctnew.fdc FStandardBeginQty,acctnew.fid FNEWACCTID,bal.faccountid foldacctid,measureunitgroup.fdefaultunitid FDEFAULTUNITID,bal.fcurrencyid FCurrencyID,'");
                sql.append(curCompanyId);
                sql.append("' forgunitid ,FAssistGrpID FAssistGrpID  ");
                sql.append(" into " + tempTable);
                sql.append(" from T_GL_AssistBalance bal     \r\n");
                sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                sql.append(" inner join t_bd_accountview acct on acct.fid = bal.faccountid \r\n");
                sql.append(" inner join t_bd_accountview acctnew on acctnew.fnumber = acct.fnumber \r\n");
                if (qtyAsst) {
                    sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                    sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                } else {
                    sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                }
                sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                sp.addString(masterCompanyId);
                sql.append(" and pi.fnumber=?");
                sp.addInt(Integer.parseInt(periodYear) * 100 + Integer.parseInt(periodNumber));
                sql.append(" and acctnew.fcompanyid= ?");
                sp.addString(curCompanyId);
                conn = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    tempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                    if (isFirstPeriod) ** GOTO lbl1533
                    sp = new SqlParams();
                    sql = new StringBuffer();
                    sql.append(" select  isNull(sum(FDebitQty),0) AS  FStandardYearDebitQty ,isNull(sum(FCreditQty),0) AS  FStandardYearCreditQty ,isNull(sum(FDebitFor),0) AS FYearDebitFor,isNull(sum(FCreditFor),0) AS FYearCreditFor ,isNull(sum(FDebitLocal),0) AS FYearDebitLocal ,isNull(sum(FCreditLocal),0) AS FYearCreditLocal ,isNull(sum(FDebitRpt),0) AS FYearDebitRpt ,isNull(sum(FCreditRpt),0) AS FYearCreditRpt ");
                    sql.append(",isNull(sum(bal.FMONTHPNLFOR),0)*acctnew.fdc FYEARPNLFOR, isNull(sum(bal.FMONTHPNLLOCAL),0)*acctnew.fdc  FYEARPNLLOCAL,isNull(sum(bal.FMONTHPNLRPT),0)*acctnew.fdc FYEARPNLRPT ");
                    sql.append(",acctnew.fid FNEWACCTID,bal.faccountid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid FCurrencyID,'");
                    sql.append(curCompanyId);
                    sql.append("' forgunitid ,FAssistGrpID FAssistGrpID  ");
                    sql.append(" into " + tempTable2);
                    sql.append(" from T_GL_AssistBalance bal     \r\n");
                    sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    sql.append(" inner join t_bd_accountview acct on acct.fid = bal.faccountid \r\n");
                    sql.append(" inner join t_bd_accountview acctnew on acctnew.fnumber = acct.fnumber \r\n");
                    if (qtyAsst) {
                        sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                    } else {
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                    }
                    sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                    sp.addString(masterCompanyId);
                    sql.append(" and pi.fnumber>=?");
                    sp.addInt(toMasterFirstPeriod.getNumber());
                    sql.append(" and pi.fnumber<=?");
                    sp.addInt(toMasterBeforePeriod.getNumber());
                    sql.append(" and acctnew.fcompanyid= ?");
                    sp.addString(curCompanyId);
                    sql.append(" group by acctnew.fid,bal.faccountid,measureunitgroup.fdefaultunitid,bal.FCurrencyID,forgunitid,FAssistGrpID");
                    sql.append(",acctnew.fdc");
                    tempTable2 = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                }
                catch (Exception ex) {
                    throw new BOSException("SQL ERROR", (Throwable)ex);
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
            } else {
                if (isCheckAccount && !isSameCurrency && (message = this.checkAccountIsValid(ctx, mainBaseCurrency, transBaseCurrency, objTable, curCompanyId, true, null)) != null) {
                    return message;
                }
                sp = new SqlParams();
                sql.append(" select bal.fbeginbalancefor*acctnew.fdc fbeginbalancefor , ");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acctnew.fdc)*");
                sql.append(localRateValue);
                sql.append(",19,");
                sql.append(lcPre);
                sql.append(") fbeginbalancelocal,");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acctnew.fdc)*");
                sql.append(rptRateValue);
                sql.append(",19,");
                sql.append(rcurPre);
                sql.append(") fbeginbalancerpt,");
                sql.append("bal.fbeginqty*acctnew.fdc fbeginqty,bal.fbeginqty*acctnew.fdc FStandardBeginQty,acctnew.fid FNEWACCTID,bal.faccountid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                sql.append(curCompanyId);
                sql.append("' forgunitid ,FAssistGrpID FAssistGrpID ");
                sql.append("  into  ").append(tempTable);
                sql.append("  from T_GL_AssistBalance bal     \r\n");
                sql.append("  inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                sql.append(" inner join t_bd_accountview acct on acct.fid = bal.faccountid \r\n");
                sql.append(" inner join t_bd_accountview acctnew on acctnew.fnumber = acct.fnumber \r\n");
                if (qtyAsst) {
                    sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                    sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                } else {
                    sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                }
                sql.append(" where bal.fbaltype=5 and bal.forgunitid= ?");
                sp.addString(masterCompanyId);
                sql.append("  and bal.FCurrencyID<>'");
                sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                sql.append("' and bal.FCurrencyID<>'");
                sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                sql.append("' and pi.fnumber=?");
                sp.addInt(Integer.parseInt(periodYear) * 100 + Integer.parseInt(periodNumber));
                sql.append("  and acctnew.fcompanyid= ? ");
                sp.addString(curCompanyId);
                conn = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    tempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                    if (!isFirstPeriod) {
                        sp = new SqlParams();
                        sql = new StringBuffer();
                        sql.append(" select isNull(sum(FDebitQty),0) AS  FStandardYearDebitQty ,isNull(sum(FCreditQty),0) AS  FStandardYearCreditQty ,isNull(sum(FDebitFor),0) AS FYearDebitFor,isNull(sum(FCreditFor),0) AS FYearCreditFor , ");
                        sql.append(" TO_DECIMAL( isNull(sum(FDebitLocal),0)*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearDebitLocal,");
                        sql.append(" TO_DECIMAL( isNull(sum(FCreditLocal),0)*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearCreditlocal,");
                        sql.append(" TO_DECIMAL( isNull(sum(FDebitRpt),0)*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYearDebitRpt,");
                        sql.append(" TO_DECIMAL( isNull(sum(FCreditRpt),0)*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYearCreditrpt,");
                        sql.append(" isNull(sum(bal.FMONTHPNLFOR),0)*acctnew.fdc FYEARPNLFOR,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acctnew.fdc*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(" )FYEARPNLLOCAL,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acctnew.fdc*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLRPT,");
                        sql.append("acctnew.fid FNEWACCTID,bal.faccountid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                        sql.append(curCompanyId);
                        sql.append("' forgunitid ,FAssistGrpID FAssistGrpID ");
                        sql.append("  into  ").append(tempTable2);
                        sql.append("  from T_GL_AssistBalance bal     \r\n");
                        sql.append("  inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                        sql.append(" inner join t_bd_accountview acct on acct.fid = bal.faccountid \r\n");
                        sql.append(" inner join t_bd_accountview acctnew on acctnew.fnumber = acct.fnumber \r\n");
                        if (qtyAsst) {
                            sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                            sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                        } else {
                            sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                        }
                        sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                        sp.addString(masterCompanyId);
                        sql.append("  and bal.FCurrencyID<>'");
                        sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                        sql.append("' and bal.FCurrencyID<>'");
                        sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                        sql.append("' and pi.fnumber>=?");
                        sp.addInt(toMasterFirstPeriod.getNumber());
                        sql.append(" and pi.fnumber<=?");
                        sp.addInt(toMasterBeforePeriod.getNumber());
                        sql.append(" and acctnew.fcompanyid= ?");
                        sp.addString(curCompanyId);
                        sql.append(" group by acctnew.fid,bal.faccountid,fdefaultunitid,bal.FCurrencyID,forgunitid,FAssistGrpID");
                        sql.append(" ,acctnew.fdc");
                        tempTable2 = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                    }
                    sp = new SqlParams();
                    sql = new StringBuffer(" insert into ").append(tempTable);
                    sql.append(" select TO_DECIMAL( (bal.fbeginbalancefor*acctnew.fdc)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append(") fbeginbalancefor,");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acctnew.fdc)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append(") fbeginbalancelocal,");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acctnew.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") fbeginbalancerpt,");
                    sql.append("bal.fbeginqty*acctnew.fdc fbeginqty ,bal.fbeginqty*acctnew.fdc FStandardBeginQty,acctnew.fid facctnewfid,bal.faccountid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                    sql.append(curCompanyId);
                    sql.append("' forgunitid ,FAssistGrpID ");
                    sql.append(" from T_GL_AssistBalance bal     \r\n");
                    sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    sql.append(" inner join t_bd_accountview acct on acct.fid = bal.faccountid \r\n");
                    sql.append(" inner join t_bd_accountview acctnew on acctnew.fnumber = acct.fnumber \r\n");
                    if (qtyAsst) {
                        sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                    } else {
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                    }
                    sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                    sp.addString(masterCompanyId);
                    sql.append("  and bal.FCurrencyID='");
                    sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                    sql.append("' and pi.fnumber=?");
                    sp.addInt(Integer.parseInt(periodYear) * 100 + Integer.parseInt(periodNumber));
                    sql.append("  and acctnew.fcompanyid= ? ");
                    sp.addString(curCompanyId);
                    DBUtil.executeUpdate((String)sql.toString(), (SqlParams)sp, (Connection)conn);
                    if (!isFirstPeriod) {
                        sp = new SqlParams();
                        sql = new StringBuffer(" insert into ").append(tempTable2);
                        sql.append(" select isNull(sum(FDebitQty),0) AS  FStandardYearDebitQty ,isNull(sum(FCreditQty),0) AS  FStandardYearCreditQty ,");
                        sql.append(" TO_DECIMAL( isNull(sum(FDebitFor),0)*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearDebitFor,");
                        sql.append(" TO_DECIMAL( isNull(sum(FCreditFor),0)*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearCreditFor,");
                        sql.append(" TO_DECIMAL( isNull(sum(FDebitLocal),0)*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearDebitLocal,");
                        sql.append(" TO_DECIMAL( isNull(sum(FCreditLocal),0)*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearCreditlocal,");
                        sql.append(" TO_DECIMAL( isNull(sum(FDebitRpt),0)*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYearDebitRpt,");
                        sql.append(" TO_DECIMAL( isNull(sum(FCreditRpt),0)*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYearCreditrpt,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLFOR),0))*acctnew.fdc*");
                        sql.append(localRateValue);
                        sql.append(",19,4) FYEARPNLFOR,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acctnew.fdc*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLLOCAL,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acctnew.fdc*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLRPT,");
                        sql.append("acctnew.fid FNEWACCTID,bal.faccountid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                        sql.append(curCompanyId);
                        sql.append("' forgunitid ,FAssistGrpID FAssistGrpID ");
                        sql.append("  from T_GL_AssistBalance bal     \r\n");
                        sql.append("  inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                        sql.append(" inner join t_bd_accountview acct on acct.fid = bal.faccountid \r\n");
                        sql.append(" inner join t_bd_accountview acctnew on acctnew.fnumber = acct.fnumber \r\n");
                        if (qtyAsst) {
                            sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                            sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                        } else {
                            sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                        }
                        sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                        sp.addString(masterCompanyId);
                        sql.append("  and bal.FCurrencyID='");
                        sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                        sql.append("' and pi.fnumber>=?");
                        sp.addInt(toMasterFirstPeriod.getNumber());
                        sql.append(" and pi.fnumber<=?");
                        sp.addInt(toMasterBeforePeriod.getNumber());
                        sql.append(" and acctnew.fcompanyid= ?");
                        sp.addString(curCompanyId);
                        sql.append(" group by acctnew.fid,bal.faccountid,fdefaultunitid,bal.FCurrencyID,forgunitid,FAssistGrpID");
                        sql.append(" ,acctnew.fdc");
                        DBUtil.executeUpdate((String)sql.toString(), (SqlParams)sp, (Connection)conn);
                    }
                    sp = new SqlParams();
                    sql = new StringBuffer(" insert into ").append(tempTable);
                    sql.append(" select TO_DECIMAL( (bal.fbeginbalancefor*acctnew.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") fbeginbalancefor,");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acctnew.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") fbeginbalancelocal,");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acctnew.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") fbeginbalancerpt,");
                    sql.append("bal.fbeginqty*acctnew.fdc fbeginqty ,bal.fbeginqty*acctnew.fdc FStandardBeginQty,acctnew.fid FNEWACCTID,bal.faccountid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                    sql.append(curCompanyId);
                    sql.append("' forgunitid ,FAssistGrpID");
                    sql.append(" from T_GL_AssistBalance bal     \r\n");
                    sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    sql.append(" inner join t_bd_accountview acct on acct.fid = bal.faccountid \r\n");
                    sql.append(" inner join t_bd_accountview acctnew on acctnew.fnumber = acct.fnumber \r\n");
                    if (qtyAsst) {
                        sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                    } else {
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                    }
                    sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                    sp.addString(masterCompanyId);
                    sql.append(" and bal.FCurrencyID='");
                    sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                    sql.append("' and pi.fnumber=?");
                    sp.addInt(Integer.parseInt(periodYear) * 100 + Integer.parseInt(periodNumber));
                    sql.append(" and acctnew.fcompanyid= ? ");
                    sp.addString(curCompanyId);
                    DBUtil.executeUpdate((String)sql.toString(), (SqlParams)sp, (Connection)conn);
                    if (isFirstPeriod) ** GOTO lbl1533
                    sp = new SqlParams();
                    sql = new StringBuffer(" insert into ").append(tempTable2);
                    sql.append(" select isNull(sum(FDebitQty),0) AS  FStandardYearDebitQty ,isNull(sum(FCreditQty),0) AS  FStandardYearCreditQty ,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitFor),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearDebitFor,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditFor),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearCreditFor,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitLocal),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearDebitLocal,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditLocal),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearCreditlocal,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitRpt),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearDebitRpt,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditRpt),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearCreditrpt,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLFOR),0))*acctnew.fdc*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYEARPNLFOR,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acctnew.fdc*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYEARPNLLOCAL,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acctnew.fdc*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYEARPNLRPT,");
                    sql.append("acctnew.fid FNEWACCTID,bal.faccountid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                    sql.append(curCompanyId);
                    sql.append("' forgunitid ,FAssistGrpID FAssistGrpID ");
                    sql.append("  from T_GL_AssistBalance bal     \r\n");
                    sql.append("  inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    sql.append(" inner join t_bd_accountview acct on acct.fid = bal.faccountid \r\n");
                    sql.append(" inner join t_bd_accountview acctnew on acctnew.fnumber = acct.fnumber \r\n");
                    if (qtyAsst) {
                        sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                    } else {
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                    }
                    sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                    sp.addString(masterCompanyId);
                    sql.append("  and bal.FCurrencyID='");
                    sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                    sql.append("' and pi.fnumber>=?");
                    sp.addInt(toMasterFirstPeriod.getNumber());
                    sql.append(" and pi.fnumber<=?");
                    sp.addInt(toMasterBeforePeriod.getNumber());
                    sql.append(" and acctnew.fcompanyid= ?");
                    sp.addString(curCompanyId);
                    sql.append(" group by acctnew.fid,bal.faccountid,fdefaultunitid,bal.FCurrencyID,forgunitid,FAssistGrpID");
                    sql.append(",acctnew.fdc");
                    DBUtil.executeUpdate((String)sql.toString(), (SqlParams)sp, (Connection)conn);
                }
                catch (Exception ex) {
                    throw new BOSException("SQL ERROR", (Throwable)ex);
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
            }
        } else if (isSameCurrency && isSameRptCurrency) {
            sp = new SqlParams();
            sql.append(" select bal.fbeginbalancefor*acctnew.fdc fbeginbalancefor,bal.fbeginbalancelocal*acctnew.fdc fbeginbalancelocal ,bal.fbeginbalancerpt*acctnew.fdc fbeginbalancerpt,bal.fbeginqty*acctnew.fdc fbeginqty,bal.fbeginqty*acctnew.fdc FStandardBeginQty,refe.fnewacctid fnewacctid,refe.foldacctid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
            sql.append(curCompanyId);
            sql.append("' forgunitid ,FAssistGrpID ");
            sql.append(" into " + tempTable);
            sql.append(" from T_GL_AssistBalance bal     \r\n");
            sql.append(" inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
            sql.append(" inner join t_bd_accountview acctnew on acctnew.fid=refe.fnewacctid   \r\n");
            sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
            if (qtyAsst) {
                sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
            } else {
                sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
            }
            sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
            sp.addString(masterCompanyId);
            sql.append(" and pi.fnumber=?");
            sp.addInt(Integer.parseInt(periodYear) * 100 + Integer.parseInt(periodNumber));
            sql.append(" and refe.FacctrefcontrastId= ? ");
            sp.addString(accountRef);
            conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                tempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                if (isFirstPeriod) ** GOTO lbl1533
                sp = new SqlParams();
                sql = new StringBuffer();
                sql.append("select  isNull(sum(FDebitQty),0) AS  FStandardYearDebitQty ,isNull(sum(FCreditQty),0) AS  FStandardYearCreditQty ,isNull(sum(FDebitFor),0) AS FYearDebitFor,isNull(sum(FCreditFor),0) AS FYearCreditFor ,isNull(sum(FDebitLocal),0) AS FYearDebitLocal ,isNull(sum(FCreditLocal),0) AS FYearCreditLocal ,isNull(sum(FDebitRpt),0) AS FYearDebitRpt ,isNull(sum(FCreditRpt),0) AS FYearCreditRpt ");
                sql.append(",isNull(sum(bal.FMONTHPNLFOR),0)*acctnew.fdc FYEARPNLFOR, isNull(sum(bal.FMONTHPNLLOCAL),0)*acctnew.fdc  FYEARPNLLOCAL,isNull(sum(bal.FMONTHPNLRPT),0)*acctnew.fdc FYEARPNLRPT ");
                sql.append(", refe.fnewacctid fnewacctid,refe.foldacctid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                sql.append(curCompanyId);
                sql.append("' forgunitid ,FAssistGrpID ");
                sql.append(" into " + tempTable);
                sql.append(" from T_GL_AssistBalance bal     \r\n");
                sql.append(" inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                sql.append(" inner join t_bd_accountview acctnew on acctnew.fid=refe.fnewacctid   \r\n");
                sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                if (qtyAsst) {
                    sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                    sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                } else {
                    sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                }
                sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                sp.addString(masterCompanyId);
                sql.append(" and pi.fnumber>=?");
                sp.addInt(toMasterFirstPeriod.getNumber());
                sql.append(" and pi.fnumber<=?");
                sp.addInt(toMasterBeforePeriod.getNumber());
                sql.append(" and refe.FacctrefcontrastId= ? ");
                sp.addString(accountRef);
                sql.append(" group by refe.fnewacctid,refe.foldacctid,fdefaultunitid,bal.FCurrencyID,forgunitid,FAssistGrpID");
                sql.append(" ,acctnew.fdc");
                tempTable2 = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
            }
            catch (Exception ex) {
                throw new BOSException("SQL ERROR", (Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        } else {
            if (isCheckAccount && !isSameCurrency && (message = this.checkAccountIsValid(ctx, mainBaseCurrency, transBaseCurrency, objTable, curCompanyId, false, accountRef)) != null) {
                return message;
            }
            sp = new SqlParams();
            sql.append(" select bal.fbeginbalancefor*acctnew.fdc fbeginbalancefor,");
            sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acctnew.fdc)*");
            sql.append(localRateValue);
            sql.append(",19,");
            sql.append(lcPre);
            sql.append(") fbeginbalancelocal,");
            sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acctnew.fdc)*");
            sql.append(rptRateValue);
            sql.append(",19,");
            sql.append(rcurPre);
            sql.append(") fbeginbalancerpt,");
            sql.append(" bal.fbeginqty*acctnew.fdc fbeginqty,bal.fbeginqty*acctnew.fdc FStandardBeginQty,refe.fnewacctid fnewacctid,refe.foldacctid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
            sql.append(curCompanyId);
            sql.append("' as forgunitid ,FAssistGrpID");
            sql.append(" into " + tempTable);
            sql.append(" from T_GL_AssistBalance bal     \r\n");
            sql.append(" inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
            sql.append(" inner join t_bd_accountview acctnew on acctnew.fid=refe.fnewacctid   \r\n");
            sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
            if (qtyAsst) {
                sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
            } else {
                sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
            }
            sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
            sp.addString(masterCompanyId);
            sql.append("  and bal.FCurrencyID<>'");
            sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
            sql.append("' and bal.FCurrencyID<>'");
            sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
            sql.append("' and pi.fnumber=?");
            sp.addInt(Integer.parseInt(periodYear) * 100 + Integer.parseInt(periodNumber));
            sql.append(" and refe.FacctrefcontrastId= ? ");
            sp.addString(accountRef);
            conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                tempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                if (!isFirstPeriod) {
                    sp = new SqlParams();
                    sql = new StringBuffer();
                    sql.append("select  isNull(sum(FDebitQty),0) AS  FStandardYearDebitQty ,isNull(sum(FCreditQty),0) AS  FStandardYearCreditQty ,isNull(sum(FDebitFor),0) AS FYearDebitFor,isNull(sum(FCreditFor),0) AS FYearCreditFor ,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitLocal),0)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append(") FYearDebitLocal,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditLocal),0)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append(") FYearCreditLocal,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitRpt),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearDebitRpt,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditRpt),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearCreditRpt,");
                    sql.append(" isNull(sum(bal.FMONTHPNLFOR),0)*acctnew.fdc FYEARPNLFOR,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acctnew.fdc*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYEARPNLLOCAL,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acctnew.fdc*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYEARPNLRPT,");
                    sql.append("refe.fnewacctid fnewacctid,refe.foldacctid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                    sql.append(curCompanyId);
                    sql.append("' forgunitid ,FAssistGrpID ");
                    sql.append(" into " + tempTable2);
                    sql.append(" from T_GL_AssistBalance bal     \r\n");
                    sql.append(" inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                    sql.append(" inner join t_bd_accountview acctnew on acctnew.fid=refe.fnewacctid   \r\n");
                    sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    if (qtyAsst) {
                        sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                    } else {
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                    }
                    sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                    sp.addString(masterCompanyId);
                    sql.append("  and bal.FCurrencyID<>'");
                    sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                    sql.append("' and bal.FCurrencyID<>'");
                    sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                    sql.append("' and pi.fnumber>=?");
                    sp.addInt(toMasterFirstPeriod.getNumber());
                    sql.append(" and pi.fnumber<=?");
                    sp.addInt(toMasterBeforePeriod.getNumber());
                    sql.append(" and refe.FacctrefcontrastId= ? ");
                    sp.addString(accountRef);
                    sql.append(" group by refe.fnewacctid,refe.foldacctid,fdefaultunitid,bal.FCurrencyID,forgunitid,FAssistGrpID");
                    sql.append(",acctnew.fdc");
                    tempTable2 = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                }
                sp = new SqlParams();
                sql = new StringBuffer("insert into ").append(tempTable);
                sql.append(" select TO_DECIMAL( (bal.fbeginbalancefor*acctnew.fdc)*");
                sql.append(localRateValue);
                sql.append(",19,");
                sql.append(lcPre);
                sql.append(") fbeginbalancefor,");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acctnew.fdc)*");
                sql.append(localRateValue);
                sql.append(",19,");
                sql.append(lcPre);
                sql.append(") fbeginbalancelocal,");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acctnew.fdc)*");
                sql.append(rptRateValue);
                sql.append(",19,");
                sql.append(rcurPre);
                sql.append(") fbeginbalancerpt,");
                sql.append(" bal.fbeginqty*acctnew.fdc fbeginqty ,bal.fbeginqty*acctnew.fdc FStandardBeginQty ,refe.fnewacctid fnewacctid ,refe.foldacctid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid ,bal.fcurrencyid fcurrencyid,'");
                sql.append(curCompanyId);
                sql.append("' forgunitid ,FAssistGrpID ");
                sql.append(" from T_GL_AssistBalance bal     \r\n");
                sql.append(" inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                sql.append(" inner join t_bd_accountview acctnew on acctnew.fid=refe.fnewacctid   \r\n");
                sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                if (qtyAsst) {
                    sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                    sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                } else {
                    sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                }
                sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                sp.addString(masterCompanyId);
                sql.append(" and bal.FCurrencyID='");
                sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                sql.append("' and pi.fnumber=?");
                sp.addInt(Integer.parseInt(periodYear) * 100 + Integer.parseInt(periodNumber));
                sql.append("and refe.FacctrefcontrastId= ? ");
                sp.addString(accountRef);
                DBUtil.executeUpdate((String)sql.toString(), (SqlParams)sp, (Connection)conn);
                if (!isFirstPeriod) {
                    sp = new SqlParams();
                    sql = new StringBuffer("insert into ").append(tempTable2);
                    sql.append(" select  isNull(sum(FDebitQty),0) AS  FStandardYearDebitQty ,isNull(sum(FCreditQty),0) AS  FStandardYearCreditQty ,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitFor),0)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append(") FYearDebitFor,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditFor),0)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append(") FYearCreditFor,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitLocal),0)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append(") FYearDebitLocal,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditLocal),0)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append(") FYearCreditLocal,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitRpt),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearDebitRpt,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditRpt),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearCreditRpt,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLFOR),0))*acctnew.fdc*");
                    sql.append(localRateValue);
                    sql.append(",19,4) FYEARPNLFOR,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acctnew.fdc*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYEARPNLLOCAL,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acctnew.fdc*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYEARPNLRPT,");
                    sql.append("refe.fnewacctid fnewacctid,refe.foldacctid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                    sql.append(curCompanyId);
                    sql.append("' forgunitid ,FAssistGrpID ");
                    sql.append(" from T_GL_AssistBalance bal     \r\n");
                    sql.append(" inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                    sql.append(" inner join t_bd_accountview acctnew on acctnew.fid=refe.fnewacctid   \r\n");
                    sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    if (qtyAsst) {
                        sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                    } else {
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                    }
                    sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                    sp.addString(masterCompanyId);
                    sql.append("  and bal.FCurrencyID='");
                    sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                    sql.append("' and pi.fnumber>=?");
                    sp.addInt(toMasterFirstPeriod.getNumber());
                    sql.append(" and pi.fnumber<=?");
                    sp.addInt(toMasterBeforePeriod.getNumber());
                    sql.append(" and refe.FacctrefcontrastId= ? ");
                    sp.addString(accountRef);
                    sql.append(" group by refe.fnewacctid,refe.foldacctid,fdefaultunitid,bal.FCurrencyID,forgunitid,FAssistGrpID");
                    sql.append(",acctnew.fdc");
                    DBUtil.executeUpdate((String)sql.toString(), (SqlParams)sp, (Connection)conn);
                }
                sp = new SqlParams();
                sql = new StringBuffer("insert into ").append(tempTable);
                sql.append(" select ");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancefor*acctnew.fdc)*");
                sql.append(rptRateValue);
                sql.append(",19,");
                sql.append(rcurPre);
                sql.append(") fbeginbalancefor,");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acctnew.fdc)*");
                sql.append(rptRateValue);
                sql.append(",19,");
                sql.append(rcurPre);
                sql.append(") fbeginbalancelocal,");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acctnew.fdc)*");
                sql.append(rptRateValue);
                sql.append(",19,");
                sql.append(rcurPre);
                sql.append(") fbeginbalancerpt,");
                sql.append(" bal.fbeginqty*acctnew.fdc fbeginqty,bal.fbeginqty*acctnew.fdc FStandardBeginQty,refe.fnewacctid fnewacctid,refe.foldacctid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                sql.append(curCompanyId);
                sql.append("' forgunitid ,FAssistGrpID");
                sql.append(" from T_GL_AssistBalance bal     \r\n");
                sql.append(" inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                sql.append(" inner join t_bd_accountview acctnew on acctnew.fid=refe.fnewacctid   \r\n");
                sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                if (qtyAsst) {
                    sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                    sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                } else {
                    sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                }
                sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                sp.addString(masterCompanyId);
                sql.append(" and bal.FCurrencyID='");
                sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                sql.append("' and pi.fnumber=?");
                sp.addInt(Integer.parseInt(periodYear) * 100 + Integer.parseInt(periodNumber));
                sql.append(" and refe.FacctrefcontrastId= ? ");
                sp.addString(accountRef);
                DBUtil.executeUpdate((String)sql.toString(), (SqlParams)sp, (Connection)conn);
                if (!isFirstPeriod) {
                    sp = new SqlParams();
                    sql = new StringBuffer("insert into ").append(tempTable2);
                    sql.append(" select  isNull(sum(FDebitQty),0) AS  FStandardYearDebitQty ,isNull(sum(FCreditQty),0) AS  FStandardYearCreditQty ,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitFor),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearDebitFor,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditFor),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearCreditFor,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitLocal),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearDebitLocal,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditLocal),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearCreditLocal,");
                    sql.append(" TO_DECIMAL( isNull(sum(FDebitRpt),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearDebitRpt,");
                    sql.append(" TO_DECIMAL( isNull(sum(FCreditRpt),0)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYearCreditRpt,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLFOR),0))*acctnew.fdc*");
                    sql.append(rptRateValue);
                    sql.append(",19,4) FYEARPNLFOR,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acctnew.fdc*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYEARPNLLOCAL,");
                    sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acctnew.fdc*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") FYEARPNLRPT,");
                    sql.append("refe.fnewacctid fnewacctid,refe.foldacctid foldacctid,measureunitgroup.fdefaultunitid fdefaultunitid,bal.fcurrencyid fcurrencyid,'");
                    sql.append(curCompanyId);
                    sql.append("' forgunitid ,FAssistGrpID ");
                    sql.append(" from T_GL_AssistBalance bal     \r\n");
                    sql.append(" inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                    sql.append(" inner join t_bd_accountview acctnew on acctnew.fid=refe.fnewacctid   \r\n");
                    sql.append(" inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    if (qtyAsst) {
                        sql.append(" inner join T_BD_AsstAccount asstacct on asstacct.fid=acctnew.fcaa   \r\n");
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on measureunitgroup.fid=asstacct.FMeasureUnitGroupID  \r\n");
                    } else {
                        sql.append(" left outer join t_bd_measureunitgroup measureunitgroup on acctnew.fmeasureunitgroupid=measureunitgroup.fid  \r\n");
                    }
                    sql.append(" where bal.fbaltype=5 and bal.forgunitid= ? ");
                    sp.addString(masterCompanyId);
                    sql.append("  and bal.FCurrencyID='");
                    sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                    sql.append("' and pi.fnumber>=?");
                    sp.addInt(toMasterFirstPeriod.getNumber());
                    sql.append(" and pi.fnumber<=?");
                    sp.addInt(toMasterBeforePeriod.getNumber());
                    sql.append(" and refe.FacctrefcontrastId= ? ");
                    sp.addString(accountRef);
                    sql.append(" group by refe.fnewacctid,refe.foldacctid,fdefaultunitid,bal.FCurrencyID,forgunitid,FAssistGrpID");
                    sql.append(",acctnew.fdc");
                    DBUtil.executeUpdate((String)sql.toString(), (SqlParams)sp, (Connection)conn);
                }
            }
            catch (Exception ex) {
                throw new BOSException("SQL ERROR", (Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(tempTable, "FAssistGrpID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTable2, "FAssistGrpID", false, false);
        }
        catch (Exception ex) {
            BalanceInitFacadeControllerBean.logger.error((Object)"SQL ERROR", (Throwable)ex);
        }
        conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tempTable);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tempTable2);
        }
        catch (Exception ex) {
            BalanceInitFacadeControllerBean.logger.error((Object)"SQL ERROR", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        try {
            assistMsg = this.dealAssistHg(ctx, tempTable, accountRef, curCompany);
            if (!StringUtils.isEmpty((String)assistMsg)) {
                msgStr.append(assistMsg);
            }
            if (!isFirstPeriod) {
                this.dealAssistHg(ctx, tempTable2, accountRef, curCompany);
            }
        }
        catch (SQLException e) {
            BalanceInitFacadeControllerBean.logger.error((Object)"SQL ERROR", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.insertAssistBalanceRecord(ctx, tempTable, tempTable2, isFirstPeriod, isSameStartPeriod, curCompany);
        if (curCompany.getReportCurrency() != null) {
            this.dealAssistbalanceSamCurrency(ctx, curCompanyId, curCompany.getBaseCurrency().getId().toString(), curCompany.getReportCurrency().getId().toString(), isSameStartPeriod);
        } else {
            this.dealAssistbalanceSamCurrency(ctx, curCompanyId, curCompany.getBaseCurrency().getId().toString(), null, isSameStartPeriod);
        }
        if (!StringUtils.isEmpty((String)msgStr.toString())) {
            msgStr.insert(0, "\r\n" + EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"1029", (Locale)ctx.getLocale()));
            return msgStr.toString();
        }
        return null;
    }

    private void checkAsstInitPeriod(Context ctx, CompanyOrgUnitInfo masterCompany, CompanyOrgUnitInfo curCompany, PeriodInfo masterStartPeriod, PeriodInfo masterCurPeriod, PeriodInfo curStartPeriod, HashMap otherCtx) throws EASBizException, BOSException {
        if (this.periodCompare(masterStartPeriod, curStartPeriod) > 0) {
            throw new AccountBooksException(AccountBooksException.SUBBOOK_AFTER_MAINSTARTPI);
        }
        if (this.periodCompare(masterStartPeriod, curStartPeriod) == 0) {
            otherCtx.put("COMPANY", otherCtx.get("mastercompany"));
            AccountViewCollection arr = AssistInitFacadeFactory.getLocalInstance(ctx).getCanCloseInitAccount(null, otherCtx);
            if (arr != null && arr.size() > 0) {
                throw new AccountBooksException(AccountBooksException.MAINBOOK_ASST_NOTCLOSED);
            }
        }
        if (this.periodCompare(masterCurPeriod, curStartPeriod) < 0) {
            throw new AccountBooksException(AccountBooksException.SUBBOOK_BEFORE_MAINCURPI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String importAccountBalance(Context ctx, String periodYear, String periodNumber, CompanyOrgUnitInfo masterCompany, CompanyOrgUnitInfo curCompany, HashMap otherCtx, PeriodInfo masterStartPeriod, PeriodInfo masterCurPeriod, PeriodInfo curStartPeriod) throws BOSException, EASBizException {
        masterCompanyId = masterCompany.getId().toString();
        curCompanyId = curCompany.getId().toString();
        isFirstPeriod = false;
        isSameStartPeriod = false;
        if (masterCompany.getAccountPeriodType().equals((Object)curCompany.getAccountPeriodType()) && masterStartPeriod.equals((Object)curStartPeriod)) {
            isSameStartPeriod = true;
        }
        if ((curFirstPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)new Integer(periodYear), (int)1, (CompanyOrgUnitInfo)curCompany)).getNumber() == curStartPeriod.getNumber()) {
            isFirstPeriod = true;
        }
        curBeforePeriod = null;
        toMasterFirstPeriod = null;
        toMasterBeforePeriod = null;
        if (!isFirstPeriod) {
            curBeforePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)curStartPeriod);
            if (curBeforePeriod == null) {
                isFirstPeriod = true;
            } else {
                toMasterFirstPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)curFirstPeriod.getBeginDate(), (CompanyOrgUnitInfo)masterCompany);
                toMasterBeforePeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)curBeforePeriod.getEndDate(), (CompanyOrgUnitInfo)masterCompany);
            }
        }
        if (toMasterBeforePeriod != null) {
            if (toMasterFirstPeriod == null) {
                toMasterFirstPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)toMasterBeforePeriod.getPeriodYear(), (int)1, (CompanyOrgUnitInfo)masterCompany);
            }
        } else {
            isFirstPeriod = true;
        }
        mainBaseCurrency = masterCompany.getBaseCurrency().getId().toString();
        transBaseCurrency = curCompany.getBaseCurrency().getId().toString();
        isSameCurrency = mainBaseCurrency.equals(transBaseCurrency);
        isSameRptCurrency = true;
        if (masterCompany.getReportCurrency() != null && curCompany.getReportCurrency() != null) {
            mainRptCurrency = masterCompany.getReportCurrency().getId().toString();
            transRptCurrency = curCompany.getReportCurrency().getId().toString();
            isSameRptCurrency = mainRptCurrency.equals(transRptCurrency);
        }
        localRate = null;
        rptRate = null;
        if (!isSameCurrency || !isSameRptCurrency) {
            exes = this.getExchangeRate(ctx, masterCompany, curCompany);
            localRate = (VoucherInfo.ExchangeRateWithValue)exes[0];
            rptRate = (VoucherInfo.ExchangeRateWithValue)exes[1];
            if (!isSameCurrency && localRate == null) {
                param = new Object[]{masterCompany.getBaseCurrency().getName(), curCompany.getBaseCurrency().getName()};
                throw new AccountBooksException(AccountBooksException.LOCALRATENOTFOUND, param);
            }
            if (!isSameRptCurrency && rptRate == null) {
                param = new Object[]{curCompany.getReportCurrency().getName(), masterCompany.getReportCurrency().getName()};
                throw new AccountBooksException(AccountBooksException.RPTRATENOTFOUND, param);
            }
        }
        localRateValue = "1";
        rptRateValue = "1";
        if (!isSameCurrency) {
            localRateValue = localRate.getValue().toString();
        }
        if (!isSameRptCurrency) {
            rptRateValue = rptRate.getValue().toString();
        }
        rcurPre = lcPre = curCompany.getBaseCurrency().getPrecision();
        if (curCompany.getReportCurrency() != null) {
            rcurPre = curCompany.getReportCurrency().getPrecision();
        }
        this.checkAccountInitPeriod(ctx, masterCompany, curCompany, masterStartPeriod, masterCurPeriod, curStartPeriod);
        sql = new StringBuffer();
        sql.append("delete from T_GL_InitAccountBalance  where forgunitid=? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{curCompanyId});
        sql = new StringBuffer();
        sql.append("delete from T_BKS_BalanceAdjust where FOrgUnitID=? and FType=? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyId, new Integer(1)});
        message = null;
        isCheckAccount = false;
        if (otherCtx.get("continue").equals("no")) {
            isCheckAccount = true;
        }
        sql = new StringBuffer();
        srcTable = masterCompany.getAccountTable().getId().toString();
        objTable = curCompany.getAccountTable().getId().toString();
        curPerDate = curStartPeriod.getBeginDate();
        toMasterPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)curPerDate, (CompanyOrgUnitInfo)masterCompany);
        tempTable = "tempTable_accountBalance";
        tempTable2 = "tempTable_accountBalanceForYear";
        periodYear = String.valueOf(toMasterPeriod.getPeriodYear());
        periodNumber = String.valueOf(toMasterPeriod.getPeriodNumber());
        sp = new SqlParams();
        msgStr = new StringBuffer();
        accountRef = this.getRefContrastId(ctx, srcTable, objTable, curCompanyId);
        if (accountRef == null) {
            msgStr.append(this.validateAccountAndCurrency(ctx, masterCompanyId, periodYear, periodNumber, curCompany));
            if (isSameCurrency && isSameRptCurrency) {
                sql.append("   select bal.fbeginbalancefor*acct.fdc fbeginbalancefor,bal.fbeginbalancelocal*acct.fdc fbeginbalancelocal,bal.fbeginbalancerpt*acct.fdc fbeginbalancerpt,bal.fbeginqty*acct.fdc fbeginqty,acctnew.fid FAccountID,bal.fcurrencyid FCurrencyID,'");
                sql.append(curCompanyId);
                sql.append("' as forgunitid into ");
                sql.append(tempTable);
                sql.append(" from t_gl_accountbalance bal     \r\n");
                sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                sql.append("         inner join t_bd_accountview acct on acct.fid=bal.faccountid   \r\n");
                sql.append("         inner join t_bd_accountview acctnew on acctnew.fnumber=acct.fnumber ");
                sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and pi.fperiodyear=? and pi.fperiodnumber=? and acctnew.fcompanyid=? ");
                sp.addString(masterCompanyId);
                sp.addInt(Integer.valueOf(periodYear).intValue());
                sp.addInt(Integer.valueOf(periodNumber).intValue());
                sp.addString(curCompanyId);
                conn = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    tempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                    if (isFirstPeriod) ** GOTO lbl663
                    sp = new SqlParams();
                    sql = new StringBuffer();
                    sql.append("   select isNull(sum(FDebitQty),0) AS  FYearDebitQty ,isNull(sum(FCreditQty),0) AS  FYearCreditQty ,isNull(sum(bal.FDebitFor),0) FYearDebitFor,isNull(sum(bal.FCreditFor),0) FYearCreditFor,isNull(sum(bal.FDebitLocal),0) FYearDebitLocal,isNull(sum(bal.FCreditLocal),0) FYearCreditLocal,isNull(sum(bal.FDebitRpt),0) FYearDebitRpt,isNull(sum(bal.FCreditRpt),0) FYearCreditRpt");
                    sql.append(",isNull(sum(bal.FMONTHPNLFOR),0)*acctnew.fdc FYEARPNLFOR, isNull(sum(bal.FMONTHPNLLOCAL),0)*acctnew.fdc  FYEARPNLLOCAL,isNull(sum(bal.FMONTHPNLRPT),0)*acctnew.fdc FYEARPNLRPT ");
                    sql.append(",bal.FCurrencyID FCurrencyID,acctnew.FID FAccountID,acctnew.fcompanyid forgunitid");
                    sql.append(" into ");
                    sql.append(tempTable2);
                    sql.append(" from t_gl_accountbalance bal     \r\n");
                    sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    sql.append("         inner join t_bd_accountview acct on acct.fid=bal.faccountid   \r\n");
                    sql.append("         inner join t_bd_accountview acctnew on acctnew.fnumber=acct.fnumber ");
                    sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and pi.fnumber>=? and pi.fnumber<=? and acctnew.fcompanyid=?  group by acctnew.fcompanyid,bal.FCurrencyID,acctnew.FID ");
                    sql.append(",acctnew.fdc");
                    sp = new SqlParams();
                    sp.addString(masterCompanyId);
                    sp.addInt(toMasterFirstPeriod.getNumber());
                    sp.addInt(toMasterBeforePeriod.getNumber());
                    sp.addString(curCompanyId);
                    tempTable2 = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                }
                catch (Exception e) {
                    throw new BOSException("SQL ERROR", (Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
            } else {
                if (!isCheckAccount || isSameCurrency || (message = this.checkAccountIsValid(ctx, mainBaseCurrency, transBaseCurrency, objTable, curCompanyId, true, null)) != null) {
                    // empty if block
                }
                sql.append("   select ");
                sql.append("  bal.fbeginbalancefor*acct.fdc fbeginbalancefor,");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acct.fdc)*");
                sql.append(localRateValue);
                sql.append(",19,");
                sql.append(lcPre);
                sql.append(") fbeginbalancelocal,");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acct.fdc)*");
                sql.append(rptRateValue);
                sql.append(",19,");
                sql.append(rcurPre);
                sql.append(") fbeginbalancerpt,");
                sql.append("  bal.fbeginqty*acct.fdc fbeginqty,acctnew.fid FAccountID,bal.fcurrencyid FCurrencyID,'");
                sql.append(curCompanyId);
                sql.append("' as forgunitid");
                sql.append(" into ");
                sql.append(tempTable);
                sql.append(" from t_gl_accountbalance bal     \r\n");
                sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                sql.append("         inner join t_bd_accountview acct on acct.fid=bal.faccountid   \r\n");
                sql.append("         inner join t_bd_accountview acctnew on acctnew.fnumber=acct.fnumber ");
                sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and bal.FCurrencyID<>'");
                sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                sql.append("' and bal.FCurrencyID<>'");
                sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                sql.append("'   and pi.fperiodyear=? and pi.fperiodnumber=? and acctnew.fcompanyid=? ");
                sp.addString(masterCompanyId);
                sp.addInt(Integer.valueOf(periodYear).intValue());
                sp.addInt(Integer.valueOf(periodNumber).intValue());
                sp.addString(curCompanyId);
                conn = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    tempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                    if (!isFirstPeriod) {
                        sql = new StringBuffer();
                        sql.append("   select  isNull(sum(FDebitQty),0) AS  FYearDebitQty ,isNull(sum(FCreditQty),0) AS  FYearCreditQty ,isNull(sum(bal.FDebitFor),0) FYearDebitFor,isNull(sum(bal.FCreditFor),0) FYearCreditFor, ");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitLocal),0))*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearDebitLocal,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditLocal),0))*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearCreditLocal,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYearDebitRpt,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYearCreditRpt,");
                        sql.append(" isNull(sum(bal.FMONTHPNLFOR),0)*acctnew.fdc FYEARPNLFOR,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acctnew.fdc*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLLOCAL,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acctnew.fdc*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLRPT,");
                        sql.append(" bal.FCurrencyID FCurrencyID,acctnew.FID FAccountID,acctnew.fcompanyid forgunitid into ");
                        sql.append(tempTable2);
                        sql.append(" from t_gl_accountbalance bal     \r\n");
                        sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                        sql.append("         inner join t_bd_accountview acct on acct.fid=bal.faccountid   \r\n");
                        sql.append("         inner join t_bd_accountview acctnew on acctnew.fnumber=acct.fnumber ");
                        sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and pi.fnumber>=? and pi.fnumber<=? and acctnew.fcompanyid=?  ");
                        sql.append("   and bal.FCurrencyID<>'");
                        sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                        sql.append("' and bal.FCurrencyID<>'");
                        sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                        sql.append("' group by bal.FCurrencyID,acctnew.FID,acctnew.fcompanyid");
                        sql.append(" ,acctnew.fdc ");
                        sp = new SqlParams();
                        sp.addString(masterCompanyId);
                        sp.addInt(toMasterFirstPeriod.getNumber());
                        sp.addInt(toMasterBeforePeriod.getNumber());
                        sp.addString(curCompanyId);
                        tempTable2 = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                    }
                    sql = new StringBuffer("insert into ");
                    sql.append(tempTable);
                    sql.append("   select ");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancefor*acct.fdc)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append(") fbeginbalancefor,");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acct.fdc)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append(") fbeginbalancelocal,");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acct.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append(") fbeginbalancerpt,");
                    sql.append("  bal.fbeginqty*acct.fdc fbeginqty,acctnew.fid FAccountID,bal.fcurrencyid FCurrencyID,'");
                    sql.append(curCompanyId);
                    sql.append("' as forgunitid from t_gl_accountbalance bal     \r\n");
                    sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    sql.append("         inner join t_bd_accountview acct on acct.fid=bal.faccountid   \r\n");
                    sql.append("         inner join t_bd_accountview acctnew on acctnew.fnumber=acct.fnumber ");
                    sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and bal.FCurrencyID='");
                    sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                    sql.append("'   and pi.fperiodyear=? and pi.fperiodnumber=? and acctnew.fcompanyid=? ");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{masterCompanyId, periodYear, periodNumber, curCompanyId});
                    if (!isFirstPeriod) {
                        sql = new StringBuffer("insert into ").append(tempTable2);
                        sql.append("   select   isNull(sum(FDebitQty),0) AS  FYearDebitQty ,isNull(sum(FCreditQty),0) AS  FYearCreditQty ,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitFor),0))*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearDebitFor,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditFor),0))*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearCreditFor,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitLocal),0))*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearDebitLocal,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditLocal),0))*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearCreditLocal,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYearDebitRpt,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYearCreditRpt,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLFOR),0))*acctnew.fdc*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLFOR,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acctnew.fdc*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLLOCAL,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acctnew.fdc*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLRPT,");
                        sql.append(" bal.FCurrencyID FCurrencyID,acctnew.FID FAccountID,acctnew.fcompanyid forgunitid from t_gl_accountbalance bal     \r\n");
                        sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                        sql.append("         inner join t_bd_accountview acct on acct.fid=bal.faccountid   \r\n");
                        sql.append("         inner join t_bd_accountview acctnew on acctnew.fnumber=acct.fnumber ");
                        sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and pi.fnumber>=? and pi.fnumber<=? and acctnew.fcompanyid=?  ");
                        sql.append("   and bal.FCurrencyID='");
                        sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                        sql.append("' group by bal.FCurrencyID,acctnew.FID,acctnew.fcompanyid ");
                        sql.append(",acctnew.fdc");
                        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, new Integer(toMasterFirstPeriod.getNumber()), new Integer(toMasterBeforePeriod.getNumber()), curCompanyId});
                    }
                    sql = new StringBuffer("insert into ").append(tempTable);
                    sql.append("   select ");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancefor*acct.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append("),");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acct.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append("),");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acct.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append("),");
                    sql.append("  bal.fbeginqty*acct.fdc,acctnew.fid,bal.fcurrencyid,'");
                    sql.append(curCompanyId);
                    sql.append("' as forgunitid from t_gl_accountbalance bal     \r\n");
                    sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    sql.append("         inner join t_bd_accountview acct on acct.fid=bal.faccountid   \r\n");
                    sql.append("         inner join t_bd_accountview acctnew on acctnew.fnumber=acct.fnumber ");
                    sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and bal.FCurrencyID='");
                    sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                    sql.append("'   and pi.fperiodyear=? and pi.fperiodnumber=? and acctnew.fcompanyid=? ");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{masterCompanyId, periodYear, periodNumber, curCompanyId});
                    if (!isFirstPeriod) {
                        sql = new StringBuffer("insert into ");
                        sql.append(tempTable2);
                        sql.append("   select   isNull(sum(FDebitQty),0) AS  FYearDebitQty ,isNull(sum(FCreditQty),0) AS  FYearCreditQty ,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitFor),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditFor),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitLocal),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditLocal),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLFOR),0))*acctnew.fdc * ");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLFOR,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acctnew.fdc * ");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLLOCAL,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acctnew.fdc * ");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLRPT,");
                        sql.append("bal.FCurrencyID FCurrencyID,acctnew.FID FAccountID,acctnew.fcompanyid forgunitid ");
                        sql.append(" from t_gl_accountbalance bal     \r\n");
                        sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                        sql.append("         inner join t_bd_accountview acct on acct.fid=bal.faccountid   \r\n");
                        sql.append("         inner join t_bd_accountview acctnew on acctnew.fnumber=acct.fnumber ");
                        sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and pi.fnumber>=? and pi.fnumber<=? and acctnew.fcompanyid=?  ");
                        sql.append("   and bal.FCurrencyID='");
                        sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                        sql.append("' group by bal.FCurrencyID,acctnew.FID,acctnew.fcompanyid  ");
                        sql.append(",acctnew.fdc");
                        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, new Integer(toMasterFirstPeriod.getNumber()), new Integer(toMasterBeforePeriod.getNumber()), curCompanyId});
                    }
                }
                catch (Exception e) {
                    throw new BOSException("SQL ERROR", (Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
            }
            this.dealAccountBalanceRecord(ctx, tempTable, tempTable2, isFirstPeriod, isSameStartPeriod);
            if (curCompany.getReportCurrency() != null) {
                this.dealAccountbalanceSamCurrency(ctx, curCompanyId, curCompany.getBaseCurrency().getId().toString(), curCompany.getReportCurrency().getId().toString(), isSameStartPeriod);
            } else {
                this.dealAccountbalanceSamCurrency(ctx, curCompanyId, curCompany.getBaseCurrency().getId().toString(), null, isSameStartPeriod);
            }
        } else {
            if (isSameCurrency && isSameRptCurrency) {
                sql.append("   select bal.fbeginbalancefor*acct.fdc fbeginbalancefor,bal.fbeginbalancelocal*acct.fdc fbeginbalancelocal,bal.fbeginbalancerpt*acct.fdc fbeginbalancerpt,bal.fbeginqty*acct.fdc fbeginqty,refe.fnewacctid FAccountID,bal.fcurrencyid FCurrencyID,'");
                sql.append(curCompanyId);
                sql.append("' as forgunitid ");
                sql.append(" into ");
                sql.append(tempTable);
                sql.append(" from t_gl_accountbalance bal   \r\n");
                sql.append("         inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                sql.append("         inner join t_bd_accountview acct on acct.fid=refe.fnewacctid   \r\n");
                sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and pi.fperiodyear=? and pi.fperiodnumber=?  and refe.FacctrefcontrastId=? and acct.fisleaf = 1 ");
                sp.addString(masterCompanyId);
                sp.addInt(Integer.valueOf(periodYear).intValue());
                sp.addInt(Integer.valueOf(periodNumber).intValue());
                sp.addString(accountRef);
                conn = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    tempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                    if (isFirstPeriod) ** GOTO lbl1248
                    sql = new StringBuffer();
                    sql.append("   select isNull(sum(FDebitQty),0) AS  FYearDebitQty ,isNull(sum(FCreditQty),0) AS  FYearCreditQty ,isNull(sum(bal.FDebitFor),0) FYearDebitFor,isNull(sum(bal.FCreditFor),0) FYearCreditFor,isNull(sum(bal.FDebitLocal),0) FYearDebitLocal,isNull(sum(bal.FCreditLocal),0) FYearCreditLocal,isNull(sum(bal.FDebitRpt),0) FYearDebitRpt,isNull(sum(bal.FCreditRpt),0) FYearCreditRpt");
                    sql.append(",isNull(sum(bal.FMONTHPNLFOR),0)*acct.fdc FYEARPNLFOR, isNull(sum(bal.FMONTHPNLLOCAL),0)*acct.fdc  FYEARPNLLOCAL,isNull(sum(bal.FMONTHPNLRPT),0)*acct.fdc FYEARPNLRPT ");
                    sql.append(",bal.FCurrencyID FCurrencyID,refe.fnewacctid FAccountID,acct.fcompanyid forgunitid");
                    sql.append(" into ");
                    sql.append(tempTable2);
                    sql.append(" from t_gl_accountbalance bal   \r\n");
                    sql.append("         inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                    sql.append("         inner join t_bd_accountview acct on acct.fid=refe.fnewacctid   \r\n");
                    sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and pi.fnumber>=? and pi.fnumber<=?  and refe.FacctrefcontrastId=? and acct.fisleaf = 1 group by bal.FCurrencyID,refe.fnewacctid,acct.fcompanyid");
                    sql.append(" ,acct.fdc");
                    sp = new SqlParams();
                    sp.addString(masterCompanyId);
                    sp.addInt(toMasterFirstPeriod.getNumber());
                    sp.addInt(toMasterBeforePeriod.getNumber());
                    sp.addString(accountRef);
                    tempTable2 = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                }
                catch (Exception e) {
                    throw new BOSException("SQL ERROR", (Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
            } else {
                if (isCheckAccount && !isSameCurrency && (message = this.checkAccountIsValid(ctx, mainBaseCurrency, transBaseCurrency, objTable, curCompanyId, false, accountRef)) != null) {
                    return message;
                }
                sql.append("   select ");
                sql.append("bal.fbeginbalancefor*acct.fdc fbeginbalancefor,");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acct.fdc)*");
                sql.append(localRateValue);
                sql.append(",19,");
                sql.append(lcPre);
                sql.append(") fbeginbalancelocal,");
                sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acct.fdc)*");
                sql.append(rptRateValue);
                sql.append(",19,");
                sql.append(rcurPre);
                sql.append(") fbeginbalancerpt,");
                sql.append("bal.fbeginqty*acct.fdc fbeginqty,refe.fnewacctid FAccountID,bal.fcurrencyid FCurrencyID,'");
                sql.append(curCompanyId);
                sql.append("' as forgunitid ");
                sql.append(" into ");
                sql.append(tempTable);
                sql.append(" from t_gl_accountbalance bal   \r\n");
                sql.append("         inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                sql.append("         inner join t_bd_accountview acct on acct.fid=refe.fnewacctid   \r\n");
                sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and bal.FCurrencyID<>'");
                sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                sql.append("' and bal.FCurrencyID<>'");
                sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                sql.append("'  and pi.fperiodyear=? and pi.fperiodnumber=?  and refe.FacctrefcontrastId=? and acct.fisleaf = 1 ");
                sp.addString(masterCompanyId);
                sp.addInt(Integer.valueOf(periodYear).intValue());
                sp.addInt(Integer.valueOf(periodNumber).intValue());
                sp.addString(accountRef);
                conn = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    tempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                    if (!isFirstPeriod) {
                        sql = new StringBuffer();
                        sql.append("   select isNull(sum(FDebitQty),0) AS  FYearDebitQty ,isNull(sum(FCreditQty),0) AS  FYearCreditQty ,isNull(sum(bal.FDebitFor),0) FYearDebitFor,isNull(sum(bal.FCreditFor),0) FYearCreditFor, ");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitLocal),0) )*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearDebitLocal,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditLocal),0))*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append(") FYearCreditLocal,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYearDebitRpt,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYearCreditRpt,");
                        sql.append(" isNull(sum(bal.FMONTHPNLFOR),0)*acct.fdc FYEARPNLFOR,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acct.fdc*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLLOCAL,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acct.fdc*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLRPT,");
                        sql.append(" bal.FCurrencyID FCurrencyID,refe.fnewacctid FAccountID,acct.fcompanyid forgunitid into ");
                        sql.append(tempTable2);
                        sql.append(" from t_gl_accountbalance bal   \r\n");
                        sql.append("         inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                        sql.append("         inner join t_bd_accountview acct on acct.fid=refe.fnewacctid   \r\n");
                        sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                        sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and pi.fnumber>=? and pi.fnumber<=?  and refe.FacctrefcontrastId=? and acct.fisleaf = 1 ");
                        sql.append(" and bal.FCurrencyID<>'");
                        sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                        sql.append("' and bal.FCurrencyID<>'");
                        sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                        sql.append("' group by bal.FCurrencyID,refe.fnewacctid,acct.fcompanyid");
                        sql.append(" ,acct.fdc");
                        sp = new SqlParams();
                        sp.addString(masterCompanyId);
                        sp.addInt(toMasterFirstPeriod.getNumber());
                        sp.addInt(toMasterBeforePeriod.getNumber());
                        sp.addString(accountRef);
                        tempTable2 = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)conn).getTempTable();
                    }
                    sql = new StringBuffer("insert into ").append(tempTable);
                    sql.append("   select ");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancefor*acct.fdc)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append("),");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acct.fdc)*");
                    sql.append(localRateValue);
                    sql.append(",19,");
                    sql.append(lcPre);
                    sql.append("),");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acct.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append("),");
                    sql.append("bal.fbeginqty*acct.fdc,refe.fnewacctid,bal.fcurrencyid,'");
                    sql.append(curCompanyId);
                    sql.append("' as forgunitid from t_gl_accountbalance bal   \r\n");
                    sql.append("         inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                    sql.append("         inner join t_bd_accountview acct on acct.fid=refe.fnewacctid   \r\n");
                    sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and bal.FCurrencyID='");
                    sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                    sql.append("'  and pi.fperiodyear=? and pi.fperiodnumber=?  and refe.FacctrefcontrastId=? and acct.fisleaf = 1");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{masterCompanyId, periodYear, periodNumber, accountRef});
                    if (!isFirstPeriod) {
                        sql = new StringBuffer("insert into ").append(tempTable2);
                        sql.append("   select isNull(sum(FDebitQty),0) AS  FYearDebitQty ,isNull(sum(FCreditQty),0) AS  FYearCreditQty ,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitFor),0) )*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditFor),0) )*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitLocal),0) )*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditLocal),0))*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(lcPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLFOR),0))*acct.fdc*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLFOR,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acct.fdc*");
                        sql.append(localRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLLOCAL,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acct.fdc*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLRPT,");
                        sql.append(" bal.FCurrencyID,refe.fnewacctid,acct.fcompanyid from t_gl_accountbalance bal   \r\n");
                        sql.append("         inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                        sql.append("         inner join t_bd_accountview acct on acct.fid=refe.fnewacctid   \r\n");
                        sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                        sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and pi.fnumber>=? and pi.fnumber<=?  and refe.FacctrefcontrastId=? and acct.fisleaf = 1 ");
                        sql.append(" and bal.FCurrencyID='");
                        sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                        sql.append("'  group by bal.FCurrencyID,refe.fnewacctid,acct.fcompanyid");
                        sql.append(" ,acct.fdc");
                        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, new Integer(toMasterFirstPeriod.getNumber()), new Integer(toMasterBeforePeriod.getNumber()), accountRef});
                    }
                    sql = new StringBuffer("insert into ").append(tempTable);
                    sql.append("   select ");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancefor*acct.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append("),");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancelocal*acct.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append("),");
                    sql.append(" TO_DECIMAL( (bal.fbeginbalancerpt*acct.fdc)*");
                    sql.append(rptRateValue);
                    sql.append(",19,");
                    sql.append(rcurPre);
                    sql.append("),");
                    sql.append("bal.fbeginqty*acct.fdc,refe.fnewacctid,bal.fcurrencyid,'");
                    sql.append(curCompanyId);
                    sql.append("' as forgunitid from t_gl_accountbalance bal   \r\n");
                    sql.append("         inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                    sql.append("         inner join t_bd_accountview acct on acct.fid=refe.fnewacctid   \r\n");
                    sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                    sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and bal.FCurrencyID='");
                    sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                    sql.append("'  and pi.fperiodyear=? and pi.fperiodnumber=?  and refe.FacctrefcontrastId=? and acct.fisleaf = 1");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{masterCompanyId, periodYear, periodNumber, accountRef});
                    if (!isFirstPeriod) {
                        sql = new StringBuffer("insert into ").append(tempTable2);
                        sql.append("   select isNull(sum(FDebitQty),0) AS  FYearDebitQty ,isNull(sum(FCreditQty),0) AS  FYearCreditQty ,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitFor),0) )*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditFor),0) )*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitLocal),0) )*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditLocal),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FDebitRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FCreditRpt),0))*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append("),");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLFOR),0))*acct.fdc*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLFOR,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLLOCAL),0))*acct.fdc*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLLOCAL,");
                        sql.append(" TO_DECIMAL( (isNull(sum(bal.FMONTHPNLRPT),0))*acct.fdc*");
                        sql.append(rptRateValue);
                        sql.append(",19,");
                        sql.append(rcurPre);
                        sql.append(") FYEARPNLRPT,");
                        sql.append(" bal.FCurrencyID,refe.fnewacctid,acct.fcompanyid from t_gl_accountbalance bal   \r\n");
                        sql.append("         inner join T_BD_AcctRefContrastEntry refe on refe.foldacctid=bal.faccountid  \r\n");
                        sql.append("         inner join t_bd_accountview acct on acct.fid=refe.fnewacctid   \r\n");
                        sql.append("         inner join t_bd_period pi on pi.fid=bal.fperiodid     \r\n");
                        sql.append("   where bal.fbaltype=5 and bal.forgunitid=? and pi.fnumber>=? and pi.fnumber<=?  and refe.FacctrefcontrastId=? and acct.fisleaf = 1 ");
                        sql.append(" and bal.FCurrencyID='");
                        sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                        sql.append("' group by bal.FCurrencyID,refe.fnewacctid,acct.fcompanyid");
                        sql.append(" ,acct.fdc");
                        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, new Integer(toMasterFirstPeriod.getNumber()), new Integer(toMasterBeforePeriod.getNumber()), accountRef});
                    }
                }
                catch (Exception e) {
                    BalanceInitFacadeControllerBean.logger.error((Object)e);
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
            }
            this.dealAccountBalanceRecord(ctx, tempTable, tempTable2, isFirstPeriod, isSameStartPeriod);
            sql = new StringBuffer();
            sql.append("insert into T_GL_InitAccountBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt  \r\n");
            sql.append(",FYEARPNLFOR,FYEARPNLLOCAL,FYEARPNLRPT  ");
            sql.append(",FAccountID,FCurrencyID,FOrgUnitID )  ");
            sql.append(" (select sum(b.fbeginbalancefor*av.fdc)*pav.fdc,sum(b.fbeginbalancelocal*av.fdc)*pav.fdc,sum(b.fbeginbalancerpt*av.fdc)*pav.fdc,sum(fbeginqty*av.fdc)*pav.fdc,sum(FYearDebitFor),sum(FYearCreditFor) ,sum(FYearDebitLocal) ,sum(FYearCreditLocal) ,sum(FYearDebitRpt) ,sum(FYearCreditRpt),");
            sql.append("sum(FYEARPNLFOR)*pav.fdc,sum(FYEARPNLLOCAL)*pav.fdc,sum(FYEARPNLRPT)*pav.fdc,");
            sql.append(" pav.fid,b.fcurrencyid,b.forgunitid from t_gl_initaccountbalance b \r\n");
            sql.append(" inner join t_bd_accountview av on av.fid = b.faccountid and av.fcompanyid = b.forgunitid \r\n");
            sql.append(" inner join t_bd_accountview pav on (charindex(pav.flongnumber || '!',av.flongnumber)=1) and av.faccounttableid = pav.faccounttableid and av.fcompanyid = pav.fcompanyid \r\n");
            sql.append(" where b.forgunitid =? and av.fisleaf = 1 \r\n");
            sql.append(" group by b.forgunitid,pav.fid, pav.fdc, b.fcurrencyid) \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{curCompanyId});
            if (curCompany.getReportCurrency() != null) {
                this.dealAccountbalanceSamCurrency(ctx, curCompanyId, curCompany.getBaseCurrency().getId().toString(), curCompany.getReportCurrency().getId().toString(), isSameStartPeriod);
            } else {
                this.dealAccountbalanceSamCurrency(ctx, curCompanyId, curCompany.getBaseCurrency().getId().toString(), null, isSameStartPeriod);
            }
        }
        if (!StringUtils.isEmpty((String)msgStr.toString())) {
            msgStr.insert(0, "\r\n" + EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"1028", (Locale)ctx.getLocale()));
            return msgStr.toString();
        }
        return null;
    }

    private String validateAccountAndCurrencyAcForVoucher(Context ctx, String masterCompanyId, CompanyOrgUnitInfo transCompany, int acPeriodYear, int acPeriodNumber, int toMasterPeriodYear, int toMasterPeriodNumber, Set<String> accountSet) throws NumberFormatException, BOSException, EASBizException {
        StringBuffer sbMsg = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct t.faccountid, x.fid as transfaccountid, t.fnumber, x.fnumber as transfnumber, \r\n");
        sql.append("t.fcurrencyid, t.fac, x.fac as transfac, t.fhasuserproperty, x.fhasuserproperty as transfhasuserproperty from \r\n");
        sql.append("(select bal.faccountid, acct.fnumber, bal.fcurrencyid, acct.fac, acct.fhasuserproperty \r\n");
        sql.append("from t_gl_acctcussent bal \r\n");
        sql.append("inner join t_bd_period pi \r\n");
        sql.append("on pi.fid = bal.fperiodid \r\n");
        sql.append("inner join t_bd_accountview acct \r\n");
        sql.append("on acct.fid = bal.faccountid \r\n");
        sql.append("where bal.fcompanyid = ? \r\n");
        sql.append("and bal.fisinit = 0 \r\n");
        sql.append("and (pi.fperiodyear > ? or (pi.fperiodyear = ? and pi.fperiodnumber >= ?)) \r\n");
        sql.append("and (pi.fperiodyear < ? or (pi.fperiodyear = ? and pi.fperiodnumber < ?)) \r\n");
        sql.append(") t \r\n");
        sql.append("left join \r\n");
        sql.append("(select fid, fnumber, fac, fhasuserproperty from t_bd_accountview where fisleaf = 1 and fcompanyid = ?) x \r\n");
        sql.append("on t.fnumber = x.fnumber order by t.fnumber \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, acPeriodYear, acPeriodYear, acPeriodNumber, toMasterPeriodYear, toMasterPeriodYear, toMasterPeriodNumber, transCompany.getId().toString()});
        HashSet<String> accountError = new HashSet<String>();
        HashSet<Map<String, Object>> currencyError = new HashSet<Map<String, Object>>();
        HashSet<String> acError = new HashSet<String>();
        HashSet<String> userpropertyError = new HashSet<String>();
        if (rs.size() > 0) {
            try {
                while (rs.next()) {
                    String faccountid = rs.getString("faccountid");
                    String transFaccountid = rs.getString("transfaccountid");
                    String fnumber = rs.getString("fnumber");
                    String transFnumber = rs.getString("transfnumber");
                    String fcurrencyid = rs.getString("fcurrencyid");
                    String fac = rs.getString("fac");
                    String transFac = rs.getString("transfac");
                    String fhasuserproperty = rs.getString("fhasuserproperty");
                    String transFhasuserproperty = rs.getString("transfhasuserproperty");
                    if (accountSet.contains(fnumber)) continue;
                    if (StringUtils.isEmpty((String)transFaccountid) && StringUtils.isEmpty((String)transFnumber)) {
                        accountSet.add(fnumber);
                        accountError.add(fnumber);
                        continue;
                    }
                    AccountViewInfo transAccount = this.getCurrencyAccount(ctx, transFaccountid);
                    boolean hasON = this.checkBalCurrencyIsInTransfer(ctx, transAccount, fcurrencyid, transCompany);
                    if (!hasON) {
                        String currencyName = this.getCurrencyName(ctx, fcurrencyid);
                        accountSet.add(fnumber);
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("currencyName", currencyName);
                        map.put("fnumber", fnumber);
                        currencyError.add(map);
                        continue;
                    }
                    if (!fac.equals(transFac)) {
                        accountSet.add(fnumber);
                        acError.add(fnumber);
                        continue;
                    }
                    if (fhasuserproperty.equals(transFhasuserproperty)) continue;
                    accountSet.add(fnumber);
                    userpropertyError.add(fnumber);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sbMsg.append(this.getMsgByErrorColl(ctx, accountError, currencyError, acError, userpropertyError));
        return sbMsg.toString();
    }

    private String validateAccountAndCurrencyAcForInit(Context ctx, String masterCompanyId, CompanyOrgUnitInfo transCompany, Set<String> accountSet) throws NumberFormatException, BOSException, EASBizException {
        StringBuffer sbMsg = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct t.faccountid, x.fid as transfaccountid, t.fnumber, x.fnumber as transfnumber, \r\n");
        sql.append("t.fcurrencyid, t.fac, x.fac as transfac, t.fhasuserproperty, x.fhasuserproperty as transfhasuserproperty from \r\n");
        sql.append("(select bal.faccountid, acct.fnumber, bal.fcurrencyid, acct.fac, acct.fhasuserproperty \r\n");
        sql.append("from t_gl_acctcussent bal \r\n");
        sql.append("inner join t_bd_accountview acct \r\n");
        sql.append("on acct.fid = bal.faccountid \r\n");
        sql.append("where bal.fcompanyid = ? \r\n");
        sql.append("and bal.fisinit = 1 \r\n");
        sql.append(") t \r\n");
        sql.append("left join \r\n");
        sql.append("(select fid, fnumber, fac, fhasuserproperty from t_bd_accountview where fisleaf = 1 and fcompanyid = ?) x \r\n");
        sql.append("on t.fnumber = x.fnumber order by t.fnumber \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{masterCompanyId, transCompany.getId().toString()});
        HashSet<String> accountError = new HashSet<String>();
        HashSet<Map<String, Object>> currencyError = new HashSet<Map<String, Object>>();
        HashSet<String> acError = new HashSet<String>();
        HashSet<String> userpropertyError = new HashSet<String>();
        if (rs.size() > 0) {
            try {
                while (rs.next()) {
                    String faccountid = rs.getString("faccountid");
                    String transFaccountid = rs.getString("transfaccountid");
                    String fnumber = rs.getString("fnumber");
                    String transFnumber = rs.getString("transfnumber");
                    String fcurrencyid = rs.getString("fcurrencyid");
                    String fac = rs.getString("fac");
                    String transFac = rs.getString("transfac");
                    String fhasuserproperty = rs.getString("fhasuserproperty");
                    String transFhasuserproperty = rs.getString("transfhasuserproperty");
                    if (accountSet.contains(fnumber)) continue;
                    if (StringUtils.isEmpty((String)transFaccountid) && StringUtils.isEmpty((String)transFnumber)) {
                        accountSet.add(fnumber);
                        accountError.add(fnumber);
                        continue;
                    }
                    AccountViewInfo transAccount = this.getCurrencyAccount(ctx, transFaccountid);
                    boolean hasON = this.checkBalCurrencyIsInTransfer(ctx, transAccount, fcurrencyid, transCompany);
                    if (!hasON) {
                        String currencyName = this.getCurrencyName(ctx, fcurrencyid);
                        accountSet.add(fnumber);
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("currencyName", currencyName);
                        map.put("fnumber", fnumber);
                        currencyError.add(map);
                        continue;
                    }
                    if (!fac.equals(transFac)) {
                        accountSet.add(fnumber);
                        acError.add(fnumber);
                        continue;
                    }
                    if (fhasuserproperty.equals(transFhasuserproperty)) continue;
                    accountSet.add(fnumber);
                    userpropertyError.add(fnumber);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sbMsg.append(this.getMsgByErrorColl(ctx, accountError, currencyError, acError, userpropertyError));
        return sbMsg.toString();
    }

    private String getMsgByErrorColl(Context ctx, Set<String> accountError, Set<Map<String, Object>> currencyError, Set<String> acError, Set<String> userpropertyError) {
        String fnumber;
        Iterator<String> iter;
        StringBuffer accountColl;
        StringBuffer sbMsg = new StringBuffer();
        if (accountError != null && accountError.size() > 0) {
            accountColl = new StringBuffer();
            iter = accountError.iterator();
            while (iter.hasNext()) {
                fnumber = iter.next();
                accountColl.append(fnumber);
                if (!iter.hasNext()) continue;
                accountColl.append("\u3001");
            }
            sbMsg.append("\r\n").append(MessageFormat.format(EASResource.getString((String)GL_RESOURCE, (String)"1019", (Locale)ctx.getLocale()), accountColl.toString()));
        }
        if (currencyError != null && currencyError.size() > 0) {
            for (Map<String, Object> item : currencyError) {
                String currencyName = (String)item.get("currencyName");
                String fnumber2 = (String)item.get("fnumber");
                sbMsg.append("\r\n").append(MessageFormat.format(EASResource.getString((String)GL_RESOURCE, (String)"1023", (Locale)ctx.getLocale()), fnumber2, currencyName));
            }
        }
        if (acError != null && acError.size() > 0) {
            accountColl = new StringBuffer();
            iter = acError.iterator();
            while (iter.hasNext()) {
                fnumber = iter.next();
                accountColl.append(fnumber);
                if (!iter.hasNext()) continue;
                accountColl.append("\u3001");
            }
            sbMsg.append("\r\n").append(MessageFormat.format(EASResource.getString((String)GL_RESOURCE, (String)"1027", (Locale)ctx.getLocale()), accountColl.toString()));
        }
        if (userpropertyError != null && userpropertyError.size() > 0) {
            accountColl = new StringBuffer();
            iter = userpropertyError.iterator();
            while (iter.hasNext()) {
                fnumber = iter.next();
                accountColl.append(fnumber);
                if (!iter.hasNext()) continue;
                accountColl.append("\u3001");
            }
            sbMsg.append("\r\n").append(MessageFormat.format(EASResource.getString((String)GL_RESOURCE, (String)"1031", (Locale)ctx.getLocale()), accountColl.toString()));
        }
        return sbMsg.toString();
    }

    private String validateAccountAndCurrency(Context ctx, String masterCompanyId, String periodYear, String periodNumber, CompanyOrgUnitInfo transCompany) throws BOSException, EASBizException {
        StringBuffer sbMsg = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct t.faccountid, x.fid as transfaccountid, t.fnumber, x.fnumber as transfnumber, t.fcurrencyid from \r\n");
        sql.append("(select bal.faccountid, acct.fnumber, bal.fcurrencyid \r\n");
        sql.append("from t_gl_accountbalance bal \r\n");
        sql.append("inner join t_bd_period pi \r\n");
        sql.append("on pi.fid = bal.fperiodid \r\n");
        sql.append("inner join t_bd_accountview acct \r\n");
        sql.append("on acct.fid = bal.faccountid \r\n");
        sql.append("where bal.fbaltype = 5 \r\n");
        sql.append("and bal.fcurrencyid <> ? \r\n");
        sql.append("and bal.fcurrencyid <> ? \r\n");
        sql.append("and acct.fisleaf = '1' \r\n");
        sql.append("and acct.faccounttableid = ? \r\n");
        sql.append("and bal.forgunitid = ? \r\n");
        sql.append("and pi.fperiodyear = ? \r\n");
        sql.append("and pi.fperiodnumber = ?) t \r\n");
        sql.append("left join (select fid, fnumber from t_bd_accountview where fisleaf = '1' and fcompanyid = ?) x \r\n");
        sql.append("on t.fnumber = x.fnumber order by t.fnumber \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), transCompany.getAccountTable().getId().toString(), masterCompanyId, Integer.valueOf(periodYear), Integer.valueOf(periodNumber), transCompany.getId().toString()});
        HashSet<String> accountError = new HashSet<String>();
        HashSet<Map<String, Object>> currencyError = new HashSet<Map<String, Object>>();
        if (rs.size() > 0) {
            try {
                HashSet<String> accountSet = new HashSet<String>();
                while (rs.next()) {
                    String faccountid = rs.getString("faccountid");
                    String transFaccountid = rs.getString("transfaccountid");
                    String fnumber = rs.getString("fnumber");
                    String transFnumber = rs.getString("transfnumber");
                    String fcurrencyid = rs.getString("fcurrencyid");
                    if (accountSet.contains(fnumber)) continue;
                    if (StringUtils.isEmpty((String)transFaccountid) && StringUtils.isEmpty((String)transFnumber)) {
                        accountSet.add(fnumber);
                        accountError.add(fnumber);
                        continue;
                    }
                    AccountViewInfo transAccount = this.getCurrencyAccount(ctx, transFaccountid);
                    boolean hasON = this.checkBalCurrencyIsInTransfer(ctx, transAccount, fcurrencyid, transCompany);
                    if (hasON) continue;
                    String currencyName = this.getCurrencyName(ctx, fcurrencyid);
                    accountSet.add(fnumber);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("currencyName", currencyName);
                    map.put("fnumber", fnumber);
                    currencyError.add(map);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sbMsg.append(this.getMsgByErrorColl(ctx, accountError, currencyError, null, null));
        return sbMsg.toString();
    }

    private String getCurrencyName(Context ctx, String currencyId) throws EASBizException, BOSException {
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, this.getClass().getName() + "getCurrencyName");
        if (datas.containsKey(currencyId)) {
            return (String)datas.get(currencyId);
        }
        String name = "";
        CurrencyInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        info = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId), sic);
        if (info != null) {
            name = info.getName();
            datas.put(currencyId, name);
        }
        return name;
    }

    private boolean checkBalCurrencyIsInTransfer(Context ctx, AccountViewInfo transAccount, String currencyId, CompanyOrgUnitInfo transCompany) {
        String dataKey;
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, this.getClass().getName() + "checkBalCurrencyIsInTransfer");
        if (datas.containsKey(dataKey = transAccount.getId().toString() + currencyId + transCompany.getId().toString())) {
            return (Boolean)datas.get(dataKey);
        }
        boolean hasON = false;
        int value = transAccount.getAccountingcurrency().getValue();
        if (value == 1) {
            AccountCurrencyCollection accountCurrencyColl = transAccount.getAccountCurrency();
            Iterator iter = accountCurrencyColl.iterator();
            while (iter.hasNext()) {
                CurrencyInfo curInfo = ((AccountCurrencyInfo)iter.next()).getCurrency();
                String curId = curInfo.getId().toString();
                if (!curId.equals(currencyId)) continue;
                hasON = true;
                break;
            }
        } else if (value == 2) {
            hasON = true;
        } else if (value == 0) {
            String localCurId = transCompany.getBaseCurrency().getId().toString();
            hasON = localCurId.equals(currencyId);
        }
        datas.put(dataKey, hasON);
        return hasON;
    }

    private AccountViewInfo getCurrencyAccount(Context ctx, String transFaccountid) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
        accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(transFaccountid), sic);
        return accountViewInfo;
    }

    private void dealGlAcctCussentSamCurrency(Context ctx, String curCompanyId, String localCurrency, String rptCurrency) throws BOSException {
        StringBuffer updateSql = new StringBuffer("update t_gl_acctcussent set FUNVERIFIEDAMTLOCAL = FUNVERIFIEDAMTFOR, FUNHOLDEDAMTLOCAL = FUNHOLDEDAMTFOR ");
        updateSql.append(" where fcompanyid = ? and fcurrencyid = ?");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, localCurrency});
        updateSql.setLength(0);
        updateSql.append("update t_gl_voucherassistrecord set flocalamount = foriginalamount where fid in (");
        updateSql.append("select fsourcebillid from t_gl_acctcussent where fcompanyid = ? and fcurrencyid = ?)");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, localCurrency});
        if (rptCurrency != null) {
            updateSql.setLength(0);
            updateSql.append("update t_gl_acctcussent set FUNVERIFIEDAMTRPT = FUNVERIFIEDAMTFOR, FUNHOLDEDAMTRPT = FUNHOLDEDAMTFOR ");
            updateSql.append(" where fcompanyid = ? and fcurrencyid = ?");
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, rptCurrency});
            updateSql.setLength(0);
            updateSql.append("update t_gl_voucherassistrecord set freportingamount = foriginalamount where fid in (");
            updateSql.append("select fsourcebillid from t_gl_acctcussent where fcompanyid = ? and fcurrencyid = ?)");
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, rptCurrency});
        }
    }

    private void dealAccountbalanceSamCurrency(Context ctx, String curCompanyId, String localCurrency, String rptCurrency, boolean isSameStartPeriod) throws BOSException {
        StringBuffer updateSql = new StringBuffer("update T_GL_InitAccountBalance set fbeginbalancelocal = fbeginbalancefor, FYearDebitLocal = FYearDebitFor,FYearCreditLocal = FYearCreditFor ");
        updateSql.append(", FYEARPNLLOCAL = FYEARPNLFOR");
        updateSql.append(" where FOrgUnitID = ? and FCurrencyId = ?");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, localCurrency});
        updateSql.setLength(0);
        updateSql.append("update T_GL_InitAccountBalance set fbeginbalancelocal = (select sum(b.fbeginbalancelocal)");
        updateSql.append(" from T_GL_InitAccountBalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ? ");
        updateSql.append(" and b.forgunitid = ? and T_GL_InitAccountBalance.faccountid = b.faccountid), fyeardebitlocal = (select sum(b.fyeardebitlocal)");
        updateSql.append(" from T_GL_InitAccountBalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
        updateSql.append(" and b.forgunitid = ? and T_GL_InitAccountBalance.faccountid = b.faccountid), fyearcreditlocal = (select sum(b.fyearcreditlocal)");
        updateSql.append(" from T_GL_InitAccountBalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
        updateSql.append(" and b.forgunitid = ? and T_GL_InitAccountBalance.faccountid = b.faccountid), fyearpnllocal = (select sum(b.fyearpnllocal)");
        updateSql.append(" from T_GL_InitAccountBalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
        updateSql.append(" and b.forgunitid = ? and T_GL_InitAccountBalance.faccountid = b.faccountid)");
        updateSql.append(" where fcurrencyid = ? and forgunitid = ?");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), curCompanyId});
        if (rptCurrency != null) {
            updateSql.setLength(0);
            updateSql.append("update T_GL_InitAccountBalance set fbeginbalancerpt = fbeginbalancefor, FYearDebitrpt = FYearDebitFor,FYearCreditrpt = FYearCreditFor");
            updateSql.append(", FYEARPNLRPT = FYEARPNLFOR");
            updateSql.append(" where FOrgUnitID = ? and FCurrencyId = ?");
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, rptCurrency});
            updateSql.setLength(0);
            updateSql.append("update T_GL_InitAccountBalance set fbeginbalancerpt = (select sum(b.fbeginbalancerpt)");
            updateSql.append(" from T_GL_InitAccountBalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ? ");
            updateSql.append(" and b.forgunitid = ? and T_GL_InitAccountBalance.faccountid = b.faccountid), FYearDebitrpt = (select sum(b.FYearDebitrpt)");
            updateSql.append(" from T_GL_InitAccountBalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
            updateSql.append(" and b.forgunitid = ? and T_GL_InitAccountBalance.faccountid = b.faccountid), FYearCreditrpt = (select sum(b.FYearCreditrpt)");
            updateSql.append(" from T_GL_InitAccountBalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
            updateSql.append(" and b.forgunitid = ? and T_GL_InitAccountBalance.faccountid = b.faccountid), FYEARPNLRPT = (select sum(b.FYEARPNLRPT)");
            updateSql.append(" from T_GL_InitAccountBalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
            updateSql.append(" and b.forgunitid = ? and T_GL_InitAccountBalance.faccountid = b.faccountid)");
            updateSql.append(" where fcurrencyid = ? and forgunitid = ?");
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), curCompanyId});
        }
    }

    private void dealAssistbalanceSamCurrency(Context ctx, String curCompanyId, String localCurrency, String rptCurrency, boolean isSameStartPeriod) throws BOSException {
        StringBuffer updateSql = new StringBuffer("update T_GL_InitAssistBalance set fbeginbalancelocal = fbeginbalancefor, FYearDebitLocal = FYearDebitFor,FYearCreditLocal = FYearCreditFor ");
        updateSql.append(", FYEARPNLLOCAL = FYEARPNLFOR");
        updateSql.append(" where FOrgUnitID = ? and FCurrencyId = ?");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, localCurrency});
        updateSql.setLength(0);
        updateSql.append("update t_gl_initassistbalance set fbeginbalancelocal = (select sum(b.fbeginbalancelocal)");
        updateSql.append(" from t_gl_initassistbalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ? ");
        updateSql.append(" and b.forgunitid = ? and t_gl_initassistbalance.faccountid = b.faccountid), fyeardebitlocal = (select sum(b.fyeardebitlocal)");
        updateSql.append(" from t_gl_initassistbalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
        updateSql.append(" and b.forgunitid = ? and t_gl_initassistbalance.faccountid = b.faccountid), fyearcreditlocal = (select sum(b.fyearcreditlocal)");
        updateSql.append(" from t_gl_initassistbalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
        updateSql.append(" and b.forgunitid = ? and t_gl_initassistbalance.faccountid = b.faccountid), fyearpnllocal = (select sum(b.fyearpnllocal)");
        updateSql.append(" from t_gl_initassistbalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
        updateSql.append(" and b.forgunitid = ? and t_gl_initassistbalance.faccountid = b.faccountid)");
        updateSql.append(" where fcurrencyid = ? and forgunitid = ?");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), curCompanyId});
        if (rptCurrency != null) {
            updateSql.setLength(0);
            updateSql.append("update T_GL_InitAssistBalance set fbeginbalancerpt = fbeginbalancefor, FYearDebitrpt = FYearDebitFor,FYearCreditrpt = FYearCreditFor");
            updateSql.append(", FYEARPNLRPT = FYEARPNLFOR");
            updateSql.append(" where FOrgUnitID = ? and FCurrencyId = ?");
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{curCompanyId, rptCurrency});
            updateSql.setLength(0);
            updateSql.append("update t_gl_initassistbalance set fbeginbalancerpt = (select sum(b.fbeginbalancerpt)");
            updateSql.append(" from t_gl_initassistbalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ? ");
            updateSql.append(" and b.forgunitid = ? and t_gl_initassistbalance.faccountid = b.faccountid), fyeardebitrpt = (select sum(b.fyeardebitrpt)");
            updateSql.append(" from t_gl_initassistbalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
            updateSql.append(" and b.forgunitid = ? and t_gl_initassistbalance.faccountid = b.faccountid), fyearcreditrpt = (select sum(b.fyearcreditrpt)");
            updateSql.append(" from t_gl_initassistbalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
            updateSql.append(" and b.forgunitid = ? and t_gl_initassistbalance.faccountid = b.faccountid), fyearpnlrpt = (select sum(b.fyearpnlrpt)");
            updateSql.append(" from t_gl_initassistbalance b where b.fcurrencyid <> ? and b.fcurrencyid <> ?");
            updateSql.append(" and b.forgunitid = ? and t_gl_initassistbalance.faccountid = b.faccountid)");
            updateSql.append(" where fcurrencyid = ? and forgunitid = ?");
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId, CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), curCompanyId});
        }
    }

    private String checkAccountIsValid(Context ctx, String mainBaseCurrency, String transBaseCurrency, String accountTable, String companyId, boolean isSameAcctTable, String accountRef) throws BOSException, EASBizException {
        block22: {
            if (isSameAcctTable) {
                StringBuffer sql = new StringBuffer();
                sql.append(" select fnumber as fnumber,fname_").append(ctx.getLocale()).append(" as fname ");
                sql.append("   from t_bd_accountview  where fid not in( select acct.fid from t_bd_accountview acct  \r\n");
                sql.append("   left join t_bd_accountcurrency b on  acct.fid=b.faccountviewid  \r\n  ");
                sql.append("     where (acct.facctcurrency=1 and b.fcurrencyid=?) or acct.facctcurrency=2 \r\n");
                sql.append("and acct.Fcompanyid=?  and  acct.faccountTableid=? ) and Fcompanyid=?  and  faccountTableid=?");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{mainBaseCurrency, companyId, accountTable, companyId, accountTable});
                try {
                    if (rs == null) break block22;
                    StringBuffer sb = new StringBuffer();
                    while (rs.next()) {
                        sb.append(rs.getString("fnumber") + " " + rs.getString("fname") + ",");
                    }
                    if (sb.length() > 0) {
                        sb.delete(sb.length() - 1, sb.length());
                        String message = ResourceBase.getString((String)RECFLOW, (String)"AccountNotValid", (Locale)ctx.getOriginLocale()) + "\r\n" + sb.toString();
                        return message.toString();
                    }
                }
                catch (SQLException e) {
                    new BOSException((Throwable)e);
                }
            } else {
                StringBuffer sql = new StringBuffer();
                sql.append(" select acctnew.fid as fnewid,acctnew.fnumber ,acctnew.fname_").append(ctx.getLocale()).append(" as fname,acctnew.facctcurrency,acctold.fid as foldid,oldcurr.fcurrencyid from T_BD_AcctRefContrastEntry refe    \r\n");
                sql.append("  inner join t_bd_accountview acctnew  on refe.fnewacctid=acctnew.fid  \r\n");
                sql.append("  inner  join t_bd_accountview acctold on acctold.fid=refe.foldacctid    \r\n");
                sql.append("  left join  t_bd_accountcurrency oldcurr on oldcurr.faccountviewid= refe.fnewacctid  \r\n");
                sql.append("    where   refe.FacctrefcontrastId=? and  acctnew.Fcompanyid=? and  acctnew. faccountTableid=? \r\n");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{accountRef, companyId, accountTable});
                HashMap<String, AccountViewInfo> newAcctMap = new HashMap<String, AccountViewInfo>();
                try {
                    if (rs != null) {
                        while (rs.next()) {
                            ArrayList<String> acctCurCol;
                            AccountViewInfo newacc;
                            String id = rs.getString("fnewid");
                            if (newAcctMap.get(id) == null) {
                                newacc = new AccountViewInfo();
                                newacc.setId(BOSUuid.read((String)id));
                                newacc.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)rs.getInt("facctcurrency")));
                                newacc.setNumber(rs.getString("fnumber"));
                                newacc.setName(rs.getString("fname"));
                                acctCurCol = new ArrayList<String>();
                                acctCurCol.add(rs.getString("fcurrencyid"));
                                newacc.put("myaccountCurrency", acctCurCol);
                                newacc.put("oldacctid", (Object)rs.getString("foldid"));
                                newAcctMap.put(id, newacc);
                                continue;
                            }
                            newacc = (AccountViewInfo)newAcctMap.get(id);
                            acctCurCol = (ArrayList<String>)newacc.get("myaccountCurrency");
                            acctCurCol.add(rs.getString("fcurrencyid"));
                        }
                    }
                }
                catch (SQLException e) {
                    new BOSException((Throwable)e);
                }
                sql = new StringBuffer();
                sql.append(" select acctold.fid as foldid,acctold.fnumber as fnumber,acctold.fname_").append(ctx.getLocale()).append(" as fname,acctold.facctcurrency,acctnew.fid as fnewid,oldcurr.fcurrencyid from T_BD_AcctRefContrastEntry refe    \r\n");
                sql.append("  inner join t_bd_accountview acctnew  on refe.fnewacctid=acctnew.fid  \r\n");
                sql.append("  inner  join t_bd_accountview acctold on acctold.fid=refe.foldacctid    \r\n");
                sql.append("  left join  t_bd_accountcurrency oldcurr on oldcurr.faccountviewid= refe.foldacctid  \r\n");
                sql.append("    where   refe.FacctrefcontrastId=? and  acctnew.Fcompanyid=? and  acctnew.faccountTableid=?   \r\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{accountRef, companyId, accountTable});
                HashMap<String, AccountViewInfo> oldAcctMap = new HashMap<String, AccountViewInfo>();
                try {
                    if (rs != null) {
                        while (rs.next()) {
                            ArrayList<String> acctCurCol;
                            AccountViewInfo oldacc;
                            String id = rs.getString("foldid");
                            if (oldAcctMap.get(id) == null) {
                                oldacc = new AccountViewInfo();
                                oldacc.setId(BOSUuid.read((String)id));
                                oldacc.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)rs.getInt("facctcurrency")));
                                oldacc.setNumber(rs.getString("fnumber"));
                                oldacc.setName(rs.getString("fname"));
                                acctCurCol = new ArrayList<String>();
                                acctCurCol.add(rs.getString("fcurrencyid"));
                                oldacc.put("myaccountCurrency", acctCurCol);
                                oldacc.put("newacctid", (Object)rs.getString("fnewid"));
                                oldAcctMap.put(id, oldacc);
                                continue;
                            }
                            oldacc = (AccountViewInfo)oldAcctMap.get(id);
                            acctCurCol = (ArrayList<String>)oldacc.get("myaccountCurrency");
                            acctCurCol.add(rs.getString("fcurrencyid"));
                        }
                    }
                }
                catch (SQLException e) {
                    new BOSException((Throwable)e);
                }
                CurrencyCollection curCol = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(true);
                ArrayList<String> curList = new ArrayList<String>();
                if (curCol != null) {
                    for (CurrencyInfo curInfo : curCol) {
                        curList.add(curInfo.getId().toString());
                    }
                    curList.remove(transBaseCurrency);
                }
                StringBuffer sb = new StringBuffer();
                Iterator it = oldAcctMap.keySet().iterator();
                while (it.hasNext()) {
                    ArrayList newAcctCurCol;
                    AccountViewInfo oldacc = (AccountViewInfo)oldAcctMap.get(it.next().toString());
                    String newacctid = oldacc.get("newacctid").toString();
                    AccountViewInfo newacc = (AccountViewInfo)newAcctMap.get(newacctid);
                    if (oldacc.getAccountingcurrency().getValue() == 2) {
                        if (newacc.getAccountingcurrency().getValue() == 2 || newacc.getAccountingcurrency().getValue() != 1 || (newAcctCurCol = (ArrayList)newacc.get("myaccountCurrency")).containsAll(curList)) continue;
                        sb.append(newacc.getNumber());
                        sb.append(" ");
                        sb.append(newacc.getName());
                        sb.append(",");
                        continue;
                    }
                    if (oldacc.getAccountingcurrency().getValue() == 1) {
                        ArrayList oldAcctCurCol = (ArrayList)oldacc.get("myaccountCurrency");
                        oldAcctCurCol.remove(transBaseCurrency);
                        oldAcctCurCol.add(mainBaseCurrency);
                        ArrayList newAcctCurCol2 = (ArrayList)newacc.get("myaccountCurrency");
                        if (newAcctCurCol2.containsAll(oldAcctCurCol)) continue;
                        sb.append(newacc.getNumber());
                        sb.append(" ");
                        sb.append(newacc.getName());
                        sb.append(",");
                        continue;
                    }
                    newAcctCurCol = (ArrayList)newacc.get("myaccountCurrency");
                    if (!newAcctCurCol.isEmpty() && newAcctCurCol.contains(mainBaseCurrency)) continue;
                    sb.append(newacc.getNumber());
                    sb.append(" ");
                    sb.append(newacc.getName());
                    sb.append(",");
                }
                if (sb.length() > 0) {
                    sb.delete(sb.length() - 1, sb.length());
                    String message = ResourceBase.getString((String)RECFLOW, (String)"AccountNotDifferent", (Locale)ctx.getOriginLocale()) + "\r\n" + sb.toString();
                    return message.toString();
                }
            }
        }
        return null;
    }

    private Object[] getExchangeRate(Context ctx, CompanyOrgUnitInfo masterCompany, CompanyOrgUnitInfo curCompany) throws EASBizException, BOSException {
        PeriodInfo curStartPeriod = GlUtils.getStartPeriod(ctx, curCompany.getId().toString());
        String mainBaseCurrency = masterCompany.getBaseCurrency().getId().toString();
        String transBaseCurrency = curCompany.getBaseCurrency().getId().toString();
        boolean isSameCurrency = mainBaseCurrency.equals(transBaseCurrency);
        boolean isSameRptCurrency = true;
        if (masterCompany.getReportCurrency() != null && curCompany.getReportCurrency() != null) {
            String mainRptCurrency = masterCompany.getReportCurrency().getId().toString();
            String transRptCurrency = curCompany.getReportCurrency().getId().toString();
            isSameRptCurrency = mainRptCurrency.equals(transRptCurrency);
        }
        HashMap exchange = new HashMap();
        Object[] info = null;
        Object[] exes = null;
        if (!isSameCurrency || !isSameRptCurrency) {
            info = new Object[8];
            info[0] = curCompany.getBaseExchangeTable().getId().toString();
            info[3] = curCompany.getBaseCurrency().getId().toString();
            if (curCompany.getReportExchangeTable() != null) {
                info[1] = curCompany.getReportExchangeTable().getId().toString();
            }
            if (curCompany.getReportCurrency() != null) {
                info[4] = curCompany.getReportCurrency().getId().toString();
            }
            info[5] = curStartPeriod.getBeginDate();
            info[6] = curStartPeriod.getBeginDate();
            info[2] = mainBaseCurrency;
            exes = GlUtils.getExchangeRate(ctx, info, mainBaseCurrency, exchange);
        }
        return exes;
    }

    private void checkAccountInitPeriod(Context ctx, CompanyOrgUnitInfo masterCompany, CompanyOrgUnitInfo curCompany, PeriodInfo masterStartPeriod, PeriodInfo masterCurPeriod, PeriodInfo curStartPeriod) throws EASBizException, BOSException {
        if (this.periodCompare(masterStartPeriod, curStartPeriod) > 0) {
            throw new AccountBooksException(AccountBooksException.SUBBOOK_AFTER_MAINSTARTPI);
        }
        if (this.periodCompare(masterStartPeriod, curStartPeriod) == 0 && !this.isInitClosed(ctx, masterCompany.getId().toString())) {
            throw new AccountBooksException(AccountBooksException.MAINBOOK_ACCT_NOTCLOSED);
        }
        if (this.periodCompare(masterCurPeriod, curStartPeriod) < 0) {
            throw new AccountBooksException(AccountBooksException.SUBBOOK_BEFORE_MAINCURPI);
        }
    }

    private String getRefContrastId(Context ctx, String srcTable, String objTable, String companyId) throws BOSException, EASBizException {
        String accountRef = null;
        try {
            String sql2 = " select fid from t_bd_acctrefcontrast where FEnabledAcctTableID=? and FDisabledAcctTableID=? and FIsEnabled=1 and FRefType=2 and Fcompanyid=? ";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{objTable, srcTable, companyId});
            if (set != null && set.next()) {
                accountRef = set.getString(1);
            } else if (!srcTable.equals(objTable)) {
                throw new AccountBooksException(AccountBooksException.ACCOUNT_NOT_REF);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return accountRef;
    }

    private void checkhasUnVerified(Context ctx, String masterCompanyId, PeriodInfo curStartPeriod, PeriodInfo acPeriod) throws EASBizException, BOSException {
        StringBuffer sqlcussent = new StringBuffer();
        sqlcussent.append("     select com.fname_").append(ctx.getLocale()).append("  as fname,aview.fnumber as acctNumber, voucher.fnumber as vchNumber from t_gl_voucher voucher           \r\n\r\n");
        sqlcussent.append("   inner join t_bd_period p on p.fid=voucher.fperiodid  \r\n");
        sqlcussent.append("   inner join t_org_company com on voucher.fcompanyid=com.fid              \r\n").append("   inner join t_gl_voucherentry entry on entry.fbillid=voucher.fid                 \r\n").append("   inner join t_bd_accountview aview on entry.faccountid=aview.fid         \r\n ").append("  inner join t_gl_acctverify averify on entry.fid = averify.fentryid \r\n  ").append("   where aview.fdc<> (entry.fentrydc*2-1) and aview.FAC=1          \r\n").append("   and voucher.fcompanyid =?   \r\n");
        if (acPeriod != null) {
            sqlcussent.append("   and (p.fperiodyear>? or (p.fperiodyear=? and p.fperiodnumber>=? ))    \r\n");
        }
        sqlcussent.append("   and p.fnumber  < ?  \r\n");
        sqlcussent.append(" and averify.FUNVERIFIEDAMTFOR <> 0 \r\n  ");
        sqlcussent.append("   group by com.fname_").append(ctx.getLocale()).append(",voucher.fnumber,aview.fnumber        \r\n");
        HashMap hmAllParam = this.isPNLAcctMustZero(ctx, (IObjectPK)new ObjectUuidPK(masterCompanyId));
        boolean iscu = Boolean.valueOf(hmAllParam.get("GL_028").toString());
        int allowCussent = Integer.parseInt(hmAllParam.get("GL_052").toString());
        boolean isVerify = iscu && Boolean.valueOf(allowCussent != 0) != false;
        try {
            if (isVerify) {
                IRowSet setcu = null;
                setcu = acPeriod != null ? DbUtil.executeQuery((Context)ctx, (String)sqlcussent.toString(), (Object[])new Object[]{masterCompanyId, acPeriod.getPeriodYear() + "", acPeriod.getPeriodYear() + "", acPeriod.getPeriodNumber() + "", new Integer(curStartPeriod.getNumber())}) : DbUtil.executeQuery((Context)ctx, (String)sqlcussent.toString(), (Object[])new Object[]{masterCompanyId, new Integer(curStartPeriod.getNumber())});
                if (setcu != null && setcu.next()) {
                    throw new GLBaseDataCheckException(GLBaseDataCheckException.HAS_NOTVERIY, new Object[]{setcu.getString("fname"), setcu.getString("acctNumber"), setcu.getString("vchNumber")});
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private HashMap isPNLAcctMustZero(Context ctx, IObjectPK comPK) throws BOSException, EASBizException {
        HashMap<String, IObjectPK> hmParamIn = new HashMap<String, IObjectPK>();
        hmParamIn.put("GL_011", comPK);
        hmParamIn.put("GL_052", comPK);
        hmParamIn.put("GL_028", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        return hmAllParam;
    }

    private boolean isInitClosed(Context ctx, String orgUnitId) throws BOSException {
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        return flag.getGLInitClosed(orgUnitId);
    }

    private String[] getAllAstInitClosed(Context ctx, String orgUnitId) throws BOSException {
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        String[] result = flag.getAllAstInitClosed(orgUnitId);
        return result;
    }

    private String[] getAllCussentInitClosed(Context ctx, String orgUnitId) throws BOSException {
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        String[] result = flag.getAllCussentInitClosed(orgUnitId);
        return result;
    }

    private int periodCompare(PeriodInfo sourceperiodInfo, PeriodInfo targetperiodInfo) {
        Date targetperiodDate;
        Date sourceperiodDate = sourceperiodInfo.getBeginDate();
        if (sourceperiodDate.after(targetperiodDate = targetperiodInfo.getBeginDate())) {
            return 1;
        }
        if (sourceperiodDate.equals(targetperiodDate)) {
            return 0;
        }
        return -1;
    }

    private void insertAssistBalanceRecord(Context ctx, String tempTable, String temTable2, boolean isFirst, boolean isSameStartPeriod, CompanyOrgUnitInfo curCompany) throws BOSException {
        try {
            StringBuffer insertSql = new StringBuffer();
            if (!isFirst) {
                String sql = "select count(1) from " + temTable2;
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                int count = 0;
                if (rowSet.next()) {
                    count = rowSet.getInt(1);
                }
                if (count > 0) {
                    insertSql.append(" insert into T_GL_InitAssistBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FStandardBeginQty,FAccountID,FMeasureUnitID,FCurrencyID,FOrgUnitID,FAssistGrpID,FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FStandardYearDebitQty,FStandardYearCreditQty     \r\n");
                    insertSql.append(",FYEARPNLFOR,FYEARPNLLOCAL,FYEARPNLRPT   ");
                    insertSql.append(" ) select t.* from ( select sum(t1.fbeginbalancefor) as fbeginbalancefor,sum(t1.fbeginbalancelocal) as fbeginbalancelocal,sum(t1.fbeginbalancerpt) as fbeginbalancerpt,sum(t1.fbeginqty) as fbeginqty,sum(t1.FStandardBeginQty) as FStandardBeginQty,t1.FNEWACCTID,t1.FDEFAULTUNITID,t1.FCurrencyID,t1.FOrgUnitID,t1.FAssistGrpID,sum(t2.FYearDebitFor) as FYearDebitFor,sum(t2.FYearCreditFor) as FYearCreditFor,sum(t2.FYearDebitLocal) as FYearDebitLocal,sum(t2.FYearCreditLocal) as FYearCreditLocal,sum(t2.FYearDebitRpt) as FYearDebitRpt,sum(t2.FYearCreditRpt) as FYearCreditRpt,sum(t2.FStandardYearDebitQty) as FStandardYearDebitQty,sum(t2.FStandardYearCreditQty) as FStandardYearCreditQty ");
                    insertSql.append(",sum(t2.FYEARPNLFOR) as FYEARPNLFOR,sum(t2.FYEARPNLLOCAL) as FYEARPNLLOCAL,sum(t2.FYEARPNLRPT) as FYEARPNLRPT");
                    insertSql.append(" from  (select FNEWACCTID,FOLDACCTID, FCurrencyID, forgunitid,FDEFAULTUNITID,FAssistGrpID,sum(fbeginbalancefor) fbeginbalancefor,sum(fbeginbalancelocal) fbeginbalancelocal,sum(fbeginbalancerpt) fbeginbalancerpt,sum(fbeginqty) fbeginqty,sum(FSTANDARDBEGINQTY) FSTANDARDBEGINQTY from " + tempTable + "  group by FNEWACCTID,FOLDACCTID, FCurrencyID, forgunitid,FDEFAULTUNITID,FAssistGrpID) t1 , (select fnewacctid, foldacctid, fcurrencyid, forgunitid, fdefaultunitid, fassistgrpid, sum(FYearDebitFor) as FYearDebitFor,sum(FYearCreditFor) as FYearCreditFor,\tsum(FYearDebitLocal) as FYearDebitLocal,sum(FYearCreditLocal) as FYearCreditLocal,sum(FYearDebitRpt) as FYearDebitRpt,sum(FYearCreditRpt) as FYearCreditRpt,sum(FStandardYearDebitQty) as FStandardYearDebitQty, sum(FStandardYearCreditQty) as FStandardYearCreditQty");
                    insertSql.append(",sum(FYEARPNLFOR) as FYEARPNLFOR,sum(FYEARPNLLOCAL) as FYEARPNLLOCAL,sum(FYEARPNLRPT) as FYEARPNLRPT ");
                    insertSql.append(" from " + temTable2 + " group by FNEWACCTID, FOLDACCTID, FCurrencyID, forgunitid, FDEFAULTUNITID, FAssistGrpID ) t2 ");
                    insertSql.append(" where t1.FNEWACCTID = t2.FNEWACCTID and t1.FOLDACCTID = t2.FOLDACCTID and t1.FCurrencyID = t2.FCurrencyID  and t1.FOrgUnitID = t2.FOrgUnitID and t1.FAssistGrpID = t2.FAssistGrpID");
                    insertSql.append(" group by t1.FNEWACCTID,t1.FCurrencyID,t1.FOrgUnitID,t1.FAssistGrpID,t1.FDEFAULTUNITID) t where t.fbeginbalancefor != 0 or t.fbeginbalancelocal != 0 or t.fbeginbalancerpt != 0 or t.fbeginqty != 0 or t.FStandardBeginQty != 0 or t.FYearDebitFor != 0 or t.FYearCreditFor != 0 or t.FYearDebitLocal != 0 or t.FYearCreditLocal != 0 or t.FYearDebitRpt != 0 or t.FYearCreditRpt != 0 or t.FStandardYearDebitQty != 0 or t.FStandardYearCreditQty != 0");
                    insertSql.append(" or FYEARPNLFOR != 0 or FYEARPNLLOCAL != 0 or FYEARPNLRPT != 0");
                } else {
                    insertSql.append(" insert into T_GL_InitAssistBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FStandardBeginQty,FAccountID,FMeasureUnitID,FCurrencyID,FOrgUnitID,FAssistGrpID )    \r\n");
                    insertSql.append(" select t.* from (select sum(fbeginbalancefor) as fbeginbalancefor,sum(fbeginbalancelocal) as fbeginbalancelocal,sum(fbeginbalancerpt) as fbeginbalancerpt,sum(fbeginqty) as fbeginqty,sum(FStandardBeginQty) as FStandardBeginQty,FNEWACCTID,FDEFAULTUNITID,FCurrencyID,FOrgUnitID,FAssistGrpID from " + tempTable);
                    insertSql.append(" group by FNEWACCTID,FCurrencyID,FOrgUnitID,FAssistGrpID,FDEFAULTUNITID) t where t.fbeginbalancefor != 0 or t.fbeginbalancelocal != 0 or t.fbeginbalancerpt != 0 or t.fbeginqty != 0");
                }
            } else {
                insertSql.append(" insert into T_GL_InitAssistBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FStandardBeginQty,FAccountID,FMeasureUnitID,FCurrencyID,FOrgUnitID,FAssistGrpID )    \r\n");
                insertSql.append(" select t.* from (select sum(fbeginbalancefor) as fbeginbalancefor,sum(fbeginbalancelocal) as fbeginbalancelocal,sum(fbeginbalancerpt) as fbeginbalancerpt,sum(fbeginqty) as fbeginqty,sum(FStandardBeginQty) as FStandardBeginQty,FNEWACCTID,FDEFAULTUNITID,FCurrencyID,FOrgUnitID,FAssistGrpID from " + tempTable);
                insertSql.append(" group by FNEWACCTID,FCurrencyID,FOrgUnitID,FAssistGrpID,FDEFAULTUNITID) t where t.fbeginbalancefor != 0 or t.fbeginbalancelocal != 0 or t.fbeginbalancerpt != 0 or t.fbeginqty != 0");
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROER ", (Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            TempTablePool.getInstance((Context)ctx).releaseTable(temTable2);
        }
    }

    private void dealAssistBalanceRecord(Context ctx, String tempTable, String temTable2, boolean isFirst, boolean isSameStartPeriod, CompanyOrgUnitInfo curCompany) throws BOSException, EASBizException {
        try {
            this.dealAssistHgOld(ctx, tempTable);
            if (!isFirst) {
                this.dealAssistHgOld(ctx, temTable2);
            }
            this.dealAcctRef(ctx, tempTable, temTable2, isFirst, isSameStartPeriod, curCompany);
            StringBuffer insertSql = new StringBuffer();
            if (!isFirst) {
                String sql = "select count(1) from " + temTable2;
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                int count = 0;
                if (rowSet.next()) {
                    count = rowSet.getInt(1);
                }
                if (count > 0) {
                    insertSql.append(" insert into T_GL_InitAssistBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FStandardBeginQty,FAccountID,FMeasureUnitID,FCurrencyID,FOrgUnitID,FAssistGrpID,FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FStandardYearDebitQty,FStandardYearCreditQty     \r\n");
                    insertSql.append(",FYEARPNLFOR,FYEARPNLLOCAL,FYEARPNLRPT   ");
                    insertSql.append(" ) select sum(t1.fbeginbalancefor),sum(t1.fbeginbalancelocal),sum(t1.fbeginbalancerpt),sum(t1.fbeginqty),sum(t1.FStandardBeginQty),t1.FNEWACCTID,t1.FDEFAULTUNITID,t1.FCurrencyID,t1.FOrgUnitID,t1.FAssistGrpID,sum(t2.FYearDebitFor),sum(t2.FYearCreditFor) ,sum(t2.FYearDebitLocal) ,sum(t2.FYearCreditLocal) ,sum(t2.FYearDebitRpt) ,sum(t2.FYearCreditRpt),sum(t2.FStandardYearDebitQty),sum(t2.FStandardYearCreditQty) ");
                    insertSql.append(",sum(t2.FYEARPNLFOR),sum(t2.FYEARPNLLOCAL),sum(t2.FYEARPNLRPT)");
                    insertSql.append(" from  (select FNEWACCTID, FCurrencyID, forgunitid,FDEFAULTUNITID,FAssistGrpID,sum(fbeginbalancefor) fbeginbalancefor,sum(fbeginbalancelocal) fbeginbalancelocal,sum(fbeginbalancerpt) fbeginbalancerpt,sum(fbeginqty) fbeginqty,sum(FSTANDARDBEGINQTY) FSTANDARDBEGINQTY from " + tempTable + "  group by FNEWACCTID, FCurrencyID, forgunitid,FDEFAULTUNITID,FAssistGrpID) t1 ," + temTable2 + " t2 where t1.FNEWACCTID = t2.FNEWACCTID  and t1.FCurrencyID = t2.FCurrencyID  and t1.FOrgUnitID = t2.FOrgUnitID and t1.FAssistGrpID = t2.FAssistGrpID");
                    insertSql.append(" group by t1.FNEWACCTID,t1.FCurrencyID,t1.FOrgUnitID,t1.FAssistGrpID,t1.FDEFAULTUNITID");
                } else {
                    insertSql.append(" insert into T_GL_InitAssistBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FStandardBeginQty,FAccountID,FMeasureUnitID,FCurrencyID,FOrgUnitID,FAssistGrpID )    \r\n");
                    insertSql.append("select sum(fbeginbalancefor),sum(fbeginbalancelocal),sum(fbeginbalancerpt),sum(fbeginqty),sum(FStandardBeginQty),FNEWACCTID,FDEFAULTUNITID,FCurrencyID,FOrgUnitID,FAssistGrpID from " + tempTable);
                    insertSql.append(" group by FNEWACCTID,FCurrencyID,FOrgUnitID,FAssistGrpID,FDEFAULTUNITID");
                }
            } else {
                insertSql.append(" insert into T_GL_InitAssistBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FStandardBeginQty,FAccountID,FMeasureUnitID,FCurrencyID,FOrgUnitID,FAssistGrpID )    \r\n");
                insertSql.append("select sum(fbeginbalancefor),sum(fbeginbalancelocal),sum(fbeginbalancerpt),sum(fbeginqty),sum(FStandardBeginQty),FNEWACCTID,FDEFAULTUNITID,FCurrencyID,FOrgUnitID,FAssistGrpID from " + tempTable);
                insertSql.append(" group by FNEWACCTID,FCurrencyID,FOrgUnitID,FAssistGrpID,FDEFAULTUNITID");
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROER ", (Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            TempTablePool.getInstance((Context)ctx).releaseTable(temTable2);
        }
    }

    private String dealAcctRef(Context ctx, String tempTable, String accountRef, boolean isFirstPeriod, boolean isSameStartPeriod, CompanyOrgUnitInfo curCompany) throws BOSException, SQLException, EASBizException {
        String temTable = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select oldAcc.fid foldId ,newAcc.fid fnewId from T_BD_AcctRefContrastEntry are    \r\n");
        sql.append(" inner join T_BD_AccountView  oldAcc on oldAcc.fid = are.FOldAcctID   \r\n");
        sql.append(" inner join T_BD_AccountView  newAcc on newAcc.fid = are.FNewAcctID   \r\n");
        sql.append(" where are.FAcctRefContrastID = ? ");
        sql.append(" and oldacc.FCAA is null and newacc.FCAA is not null order by are.fid   \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountRef});
        if (rs.size() > 0) {
            try {
                StringBuffer createrql = new StringBuffer();
                createrql.append("create table t_gl_initBalanceassist(foldId varchar(44),fnewId varchar(44),fassistGrpID varchar(44))");
                temTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            }
            catch (Exception e) {
                throw new BOSException("create tempTable error!", (Throwable)e);
            }
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into ").append(temTable).append(" (foldId,fnewId,fassistGrpID) values (?,?,?)");
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            AsstActTypeCollection items = new AsstActTypeCollection();
            while (rs.next()) {
                String oldActId = rs.getString("foldId");
                String newActId = rs.getString("fnewId");
                AssistantHGInfo result = new AssistantHGInfo();
                sql.setLength(0);
                sql.append(" select newacc.FCAA,ty.fassthgattribute,ty.FNAME_").append(ctx.getLocale().toString()).append(" fname ,adf.FDefaultId   \r\n");
                sql.append(" from T_BD_AcctRefContrastEntry are    \r\n");
                sql.append(" inner join T_AC_AcctRefContrastEntryDef adf on adf.FParentID = are.fid   \r\n");
                sql.append(" inner join T_BD_AsstActType ty on ty.fid = adf.FAsstActTypeID \t\r\n");
                sql.append(" inner join T_BD_AccountView  oldAcc on oldAcc.fid = are.FOldAcctID   \r\n");
                sql.append(" inner join T_BD_AccountView  newAcc on newAcc.fid = are.FNewAcctID   \r\n");
                sql.append(" where are.FAcctRefContrastID = ?  and oldAcc.fid = ? ");
                IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountRef, oldActId});
                String acc = null;
                while (rs1.next()) {
                    String atr = rs1.getString("fassthgattribute");
                    String atrName = rs1.getString("fname");
                    String itemId = rs1.getString("FDefaultId");
                    acc = rs1.getString("FCAA");
                    BOSUuid bosid = BOSUuid.read((String)itemId);
                    IObjectValue dataInfo = iDynamicObject.getValue(bosid.getType(), (IObjectPK)new ObjectUuidPK(bosid));
                    AsstActTypeInfo asstActInfo = new AsstActTypeInfo();
                    asstActInfo.setAsstHGAttribute(atr);
                    asstActInfo.setName(atrName);
                    items.add(asstActInfo);
                    result.put(atr, (Object)dataInfo);
                }
                if (acc != null) {
                    AssistantHGInfo transferHgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(result, acc, items);
                    DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{oldActId, newActId, transferHgInfo.getId()});
                }
                items.clear();
            }
        }
        return temTable;
    }

    private String dealAssistHg(Context ctx, String tempTable, String accountRef, CompanyOrgUnitInfo curCompany) throws BOSException, SQLException, EASBizException {
        StringBuffer sbMsg = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select  distinct t.FAssistGrpID, assist.FAsstAccountID FAsstAccountID, act.fid fnewAcctId , t.foldacctid, act.FCAA,act.Fnumber \r\n");
        sql.append(" from  ").append(tempTable).append(" t ");
        sql.append(" inner join T_BD_AssistantHG assist on assist.fid = t.FAssistGrpID   \r\n");
        sql.append(" inner join T_BD_ACCOUNTVIEW act on act.fid = t.fnewacctid order by act.fnumber \t\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() > 0) {
            HashMap<String, Object> dataBaseInfoMap = new HashMap<String, Object>();
            HashMap<String, Vector> asstActTypeVectorMap = new HashMap<String, Vector>();
            HashMap resultsMap = new HashMap();
            HashSet<String> accountSet = new HashSet<String>();
            while (rs.next()) {
                String oldHgId = rs.getString("FAssistGrpID");
                String oldAccId = rs.getString("FAsstAccountID");
                String newAccId = rs.getString("FCAA");
                String newActID = rs.getString("FnewAcctId");
                String oldActID = rs.getString("FoldAcctId");
                String newActNum = rs.getString("Fnumber");
                String rsKey = newActID + "_" + oldActID + "_" + newAccId + "_" + oldAccId;
                Map results = (Map)resultsMap.get(rsKey);
                if (results == null) {
                    results = this.getAsstData(ctx, accountRef, newActID, oldActID, newAccId, oldAccId);
                }
                try {
                    Map cloneMap = results != null ? (Map)ObjectUtils.createCopy((Object)results) : new HashMap();
                    resultsMap.put(rsKey, cloneMap);
                }
                catch (CloneNotSupportedException cnse) {
                    throw new InternalError();
                }
                Map defaults = results != null ? (Map)results.get("defaults") : new HashMap();
                List common = results != null ? (List)results.get("common") : new ArrayList();
                ArrayList commonMsg = new ArrayList();
                try {
                    commonMsg = common != null ? (List)ObjectUtils.createCopy(common) : new ArrayList();
                }
                catch (CloneNotSupportedException e1) {
                    e1.printStackTrace();
                }
                if (!(defaults != null && defaults.size() != 0 || common != null && common.size() != 0)) {
                    StringBuffer delSql = new StringBuffer();
                    delSql.append(" delete from ").append(tempTable).append(" where FAssistGrpID = ").append("'").append(oldHgId).append("'").append(" and fnewacctid = ").append("'").append(newActID).append("'");
                    DbUtil.execute((Context)ctx, (String)delSql.toString());
                    if (!StringUtils.isEmpty((String)accountRef) || oldAccId.equals(newAccId) || accountSet.contains(newActNum)) continue;
                    accountSet.add(newActNum);
                    if (commonMsg != null && commonMsg.size() != 0) continue;
                    String accountNumber = newActNum;
                    String msg = MessageFormat.format(EASResource.getString((String)GL_RESOURCE, (String)"1026", (Locale)ctx.getLocale()), accountNumber, accountNumber);
                    sbMsg.append("\r\n").append(msg);
                    continue;
                }
                Vector vec = (Vector)asstActTypeVectorMap.get(newAccId);
                if (vec == null) {
                    vec = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(newAccId));
                    asstActTypeVectorMap.put(newAccId, vec);
                }
                SelectorItemCollection selectors = new SelectorItemCollection();
                String temp = null;
                for (int i = 0; i < common.size(); ++i) {
                    temp = (String)common.get(i);
                    if ("bankAccount".equals(temp)) {
                        selectors.add(new SelectorItemInfo("bankAccount.*"));
                        continue;
                    }
                    selectors.add(new SelectorItemInfo(temp + ".id"));
                }
                AssistantHGInfo hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(oldHgId), selectors);
                boolean isHgOK = true;
                AssistantHGInfo result = new AssistantHGInfo();
                AsstActTypeCollection items = new AsstActTypeCollection();
                Iterator it = defaults.keySet().iterator();
                IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                int size = common.size() - 1;
                block10: while (size >= 0 && isHgOK) {
                    for (int i = 0; i < vec.size(); ++i) {
                        String attr = (String)common.get(size);
                        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)vec.get(i);
                        if ("bankAccount".equalsIgnoreCase(attr)) {
                            result.put(attr, (Object)hgInfo.getObjectValue(attr));
                            if (i != vec.size() - 1) continue;
                            --size;
                            continue;
                        }
                        if (!asstActTypeInfo.getAsstHGAttribute().equals(attr)) {
                            if (i != vec.size() - 1) continue;
                            --size;
                            continue;
                        }
                        String dataid = hgInfo.getObjectValue(attr).getString("id");
                        DataBaseInfo data = (DataBaseInfo)dataBaseInfoMap.get(dataid + "_" + curCompany.getId().toString());
                        if (data == null) {
                            HashSet<String> set = new HashSet<String>();
                            set.add(dataid);
                            Object dt = null;
                            try {
                                Map<String, Object> aAsstActs = VoucherProcessCache.findAsstActByIds(ctx, asstActTypeInfo, set, curCompany, curCompany.getCU().getId().toString(), null);
                                dt = aAsstActs.get(dataid);
                            }
                            catch (Exception e) {
                                dt = "error";
                                e.printStackTrace();
                            }
                            if (dt instanceof String) {
                                String accountNumber = newActNum;
                                String actTypeName = asstActTypeInfo != null ? asstActTypeInfo.toString() : "";
                                String dataName = "";
                                try {
                                    dataName = dt.toString().split("]")[0].toString().replace("[", "");
                                }
                                catch (Exception e) {
                                    dataName = "";
                                }
                                String msg = MessageFormat.format(EASResource.getString((String)GL_RESOURCE, (String)"1024", (Locale)ctx.getLocale()), accountNumber, actTypeName, dataName);
                                sbMsg.append("\r\n").append(msg);
                                data = null;
                            } else {
                                data = (DataBaseInfo)dt;
                            }
                        }
                        if (data == null) {
                            StringBuffer delSql = new StringBuffer();
                            delSql.append(" delete from ").append(tempTable).append(" where FAssistGrpID = ").append("'").append(oldHgId).append("'").append(" and fnewacctid = ").append("'").append(newActID).append("'");
                            DbUtil.execute((Context)ctx, (String)delSql.toString());
                            isHgOK = false;
                            continue block10;
                        }
                        dataBaseInfoMap.put(dataid + "_" + curCompany.getId().toString(), data);
                        if (!isHgOK) continue;
                        result.put(attr, (Object)data);
                        items.add(asstActTypeInfo);
                        common.remove(size);
                        --size;
                        continue block10;
                    }
                }
                if (StringUtils.isEmpty((String)accountRef) && !oldAccId.equals(newAccId) && !accountSet.contains(newActNum)) {
                    accountSet.add(newActNum);
                    if (commonMsg != null && commonMsg.size() > 0) {
                        Vector vecMa = (Vector)asstActTypeVectorMap.get(oldAccId);
                        if (vecMa == null) {
                            vecMa = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(oldAccId));
                            asstActTypeVectorMap.put(oldAccId, vecMa);
                        }
                        String accountNumber = newActNum;
                        String asstTypeName = vec.toString();
                        String maAsstTypeName = vecMa.toString();
                        String commonAsstTypeName = items.toString();
                        String msg = MessageFormat.format(EASResource.getString((String)GL_RESOURCE, (String)"1025", (Locale)ctx.getLocale()), accountNumber, asstTypeName, maAsstTypeName, commonAsstTypeName);
                        sbMsg.append("\r\n").append(msg);
                    } else {
                        String accountNumber = newActNum;
                        String msg = MessageFormat.format(EASResource.getString((String)GL_RESOURCE, (String)"1026", (Locale)ctx.getLocale()), accountNumber, accountNumber);
                        sbMsg.append("\r\n").append(msg);
                    }
                }
                if (!isHgOK) continue;
                if (defaults.size() > 0) {
                    IObjectValue dataInfo = null;
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        String value = (String)defaults.get(key);
                        String[] s = value.split("_!");
                        BOSUuid bosid = BOSUuid.read((String)s[2]);
                        dataInfo = (IObjectValue)dataBaseInfoMap.get(bosid.toString());
                        if (dataInfo == null) {
                            dataInfo = iDynamicObject.getValue(bosid.getType(), (IObjectPK)new ObjectUuidPK(bosid));
                            dataBaseInfoMap.put(bosid.toString(), dataInfo);
                        }
                        AsstActTypeInfo asstActInfo = new AsstActTypeInfo();
                        asstActInfo.setAsstHGAttribute(s[0]);
                        asstActInfo.setName(s[1]);
                        items.add(asstActInfo);
                        result.put(s[0], (Object)dataInfo);
                    }
                }
                AssistantHGInfo transferHgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(result, newAccId, items);
                String updateSql = "update " + tempTable + " set FAssistGrpID = ? where FAssistGrpID = ? and fnewacctid = ?";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new String[]{transferHgInfo.getId().toString(), oldHgId, newActID});
            }
        }
        return sbMsg.toString();
    }

    private Map getAsstData(Context ctx, String accountRef, String newActID, String oldActID, String newAccId, String oldAccId) throws BOSException {
        String actTpye;
        if (newAccId == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        if (!StringUtils.isEmpty((String)accountRef)) {
            sql.append(" select distinct tdf.FAsstActTypeID,ty.fassthgattribute,tdf.FDEFAULTID,ty.FNAME_").append(ctx.getLocale().toString()).append(" fname \r\n");
            sql.append(" from T_BD_AcctRefContrast t \t\r\n");
            sql.append(" inner join T_BD_AcctRefContrastEntry tf on tf.FAcctRefContrastID =t.fid \t\r\n");
            sql.append(" inner join T_AC_AcctRefContrastEntryDef tdf on tdf.FParentID = tf.fid \t\r\n");
            sql.append(" inner join T_BD_AsstActType ty on tdf.FAsstActTypeID = ty.fid \t\r\n");
            sql.append(" where tf.fnewacctid = ? and tf.foldacctid = ? and t.fid = ? and tdf.FDEFAULTID is not null  \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{newActID, oldActID, accountRef});
            HashMap<String, String> defaults = new HashMap<String, String>();
            try {
                while (rs != null && rs.next()) {
                    actTpye = rs.getString("FAsstActTypeID");
                    String attr = rs.getString("fassthgattribute");
                    String def = rs.getString("FDEFAULTID");
                    String name = rs.getString("fname");
                    defaults.put(actTpye, attr + "_!" + name + "_!" + def);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            result.put("defaults", defaults);
        } else {
            result.put("defaults", new HashMap());
        }
        sql.setLength(0);
        if (oldAccId != null) {
            sql.append("SELECT ty.fassthgattribute attr FROM T_BD_AsstActGroupDetail aagdChild   \r\n");
            sql.append("INNER JOIN T_BD_AsstActType ty on aagdChild.FAsstActTypeID = ty.fid    \r\n");
            sql.append("WHERE aagdChild.FAsstAccountID = ? AND aagdChild.FAsstActTypeID \r\n");
            sql.append("IN (SELECT aagdParent.FAsstActTypeID FROM T_BD_AsstActGroupDetail aagdParent WHERE aagdParent.FAsstAccountID = ? )");
            IRowSet comrs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{newAccId, oldAccId});
            ArrayList<String> common = new ArrayList<String>();
            try {
                while (comrs != null && comrs.next()) {
                    actTpye = comrs.getString("attr");
                    common.add(actTpye);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            result.put("common", common);
        }
        return result;
    }

    private void dealAssistHgOld(Context ctx, String tempTable) throws BOSException, SQLException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select  distinct t.FAssistGrpID, assist.FAsstAccountID AsstAccountID, t.fnewacctid newAcctId \r\n");
        sql.append(" from  ").append(tempTable).append(" t ");
        sql.append(" inner join T_BD_AssistantHG assist on assist.fid = t.FAssistGrpID   \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() > 0) {
            sql = new StringBuffer();
            sql.append("select distinct act.FAsstHgAttribute \r\n");
            sql.append(" from  ").append(tempTable).append(" t ");
            sql.append(" inner join T_BD_AssistantHG assist on assist.fid = t.FAssistGrpID   \r\n");
            sql.append(" inner join t_bd_asstactgroupdetail detail on detail.FAsstAccountID = assist.FAsstAccountID  \r\n");
            sql.append(" inner join t_bd_asstacttype act on act.fid = detail.FAsstactTypeID \r\n");
            IRowSet selectorRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("asstAccount.id"));
            while (selectorRs.next()) {
                view.getSelector().add(new SelectorItemInfo(selectorRs.getString("FAsstHgAttribute") + ".id"));
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select FAssistGrpID from " + tempTable), CompareType.INNER));
            view.setFilter(filter);
            AssistantHGCollection hgColl = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGCollection(view);
            IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("CAA.*"));
            selector.add(new SelectorItemInfo("CAA.asstActGpDt.*"));
            selector.add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.*"));
            StringBuffer hgIds = new StringBuffer();
            while (rs.next()) {
                String assistGrpID = rs.getString("FAssistGrpID");
                String asstAccountID = rs.getString("AsstAccountID");
                boolean isHgOK = true;
                AccountViewInfo asstAcct = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(rs.getString("newAcctId")), selector);
                AssistantHGInfo hgInfo = null;
                for (int i = 0; i < hgColl.size(); ++i) {
                    if (!assistGrpID.equals(hgColl.get(i).getId().toString())) continue;
                    hgInfo = hgColl.get(i);
                    break;
                }
                if (hgInfo == null) {
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.books.BOOKSAutoGenerateResource", (String)"2_BalanceInitFacadeControllerBean", (Locale)ctx.getOriginLocale()) + assistGrpID));
                    continue;
                }
                hgInfo.setCompanyOrg(asstOrg);
                hgInfo.setId(null);
                AsstActTypeCollection types = new AsstActTypeCollection();
                Vector vec = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(asstAccountID));
                int n = vec.size();
                for (int i = 0; i < n; ++i) {
                    AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)vec.get(i);
                    AsstActGroupDetailCollection detailCol = asstAcct.getCAA().getAsstActGpDt();
                    for (int j = 0; j < detailCol.size(); ++j) {
                        if (!detailCol.get(j).getAsstActType().getId().toString().equals(asstActTypeInfo.getId().toString())) continue;
                        DataBaseInfo data = GlUtils.findAsstActObject(ctx, asstActTypeInfo, hgInfo.getObjectValue(asstActTypeInfo.getAsstHGAttribute()).getString("id"), asstOrg.getCU().getId().toString(), asstOrg, true);
                        if (data == null) {
                            hgIds.append("'").append(assistGrpID).append("',");
                            isHgOK = false;
                        }
                        types.add(asstActTypeInfo);
                    }
                }
                hgInfo.setAsstAccount(AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountInfo((IObjectPK)new ObjectUuidPK(asstAcct.getCAA().getId().toString())));
                String pk = iAssistantHG.getAssistantHG(hgInfo, hgInfo.getAsstAccount().getId().toString(), types).getId().toString();
                if (!isHgOK) continue;
                StringBuffer updateSql = new StringBuffer();
                updateSql.append(" update ").append(tempTable).append(" set FAssistGrpID = ? where FAssistGrpID = ? ");
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new String[]{pk, assistGrpID});
            }
            StringBuffer delSql = new StringBuffer();
            if (hgIds.length() != 0) {
                delSql.append(" delete from ").append(tempTable).append(" where FAssistGrpID in (").append(hgIds.substring(0, hgIds.lastIndexOf(","))).append(")");
                DbUtil.execute((Context)ctx, (String)delSql.toString());
            }
        }
    }

    private void dealAccountBalanceRecord(Context ctx, String tempTable, String temTable2, boolean isFirst, boolean isSameStartPeriod) throws BOSException, EASBizException {
        StringBuffer insertSql = new StringBuffer();
        try {
            if (!isFirst) {
                String sql = "select count(1) from " + temTable2;
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                int count = 0;
                if (rowSet.next()) {
                    count = rowSet.getInt(1);
                }
                if (count > 0) {
                    insertSql.append(" insert into T_GL_InitAccountBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FAccountID,FCurrencyID,FOrgUnitID ,FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FYearDebitQty,FYearCreditQty \r\n");
                    insertSql.append(",FYEARPNLFOR,FYEARPNLLOCAL,FYEARPNLRPT   ");
                    insertSql.append(" ) select sum(t1.fbeginbalancefor),sum(t1.fbeginbalancelocal),sum(t1.fbeginbalancerpt),sum(t1.fbeginqty),t1.FAccountID,t1.FCurrencyID,t1.FOrgUnitID,sum(t2.FYearDebitFor),sum(t2.FYearCreditFor),sum(t2.FYearDebitLocal),sum(t2.FYearCreditLocal),sum(t2.FYearDebitRpt),sum(t2.FYearCreditRpt),sum(t2.FYearDebitQty),sum(t2.FYearCreditQty) ");
                    insertSql.append(",sum(t2.FYEARPNLFOR),sum(t2.FYEARPNLLOCAL),sum(t2.FYEARPNLRPT)");
                    insertSql.append(" from (select FAccountID, FCurrencyID, forgunitid,sum(fbeginbalancefor) fbeginbalancefor,sum(fbeginbalancelocal) fbeginbalancelocal,sum(fbeginbalancerpt) fbeginbalancerpt,sum(fbeginqty) fbeginqty from " + tempTable + "  group by FAccountID, FCurrencyID, forgunitid) t1 ," + temTable2 + " t2 where t1.FAccountID = t2.FAccountID  and t1.FCurrencyID = t2.FCurrencyID  and t1.FOrgUnitID = t2.FOrgUnitID ");
                    insertSql.append(" group by t1.FAccountID,t1.FCurrencyID,t1.FOrgUnitID");
                } else {
                    insertSql.append(" insert into T_GL_InitAccountBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FAccountID,FCurrencyID,FOrgUnitID )    \r\n");
                    insertSql.append("select sum(fbeginbalancefor),sum(fbeginbalancelocal),sum(fbeginbalancerpt),sum(fbeginqty),FAccountID,FCurrencyID,FOrgUnitID from " + tempTable + " group by FAccountID,FCurrencyID,FOrgUnitID");
                }
            } else {
                insertSql.append(" insert into T_GL_InitAccountBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FAccountID,FCurrencyID,FOrgUnitID )    \r\n");
                insertSql.append("select sum(fbeginbalancefor),sum(fbeginbalancelocal),sum(fbeginbalancerpt),sum(fbeginqty),FAccountID,FCurrencyID,FOrgUnitID from " + tempTable + " group by FAccountID,FCurrencyID,FOrgUnitID");
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            if (!isFirst) {
                TempTablePool.getInstance((Context)ctx).releaseTable(temTable2);
            }
        }
    }

    @Override
    protected String _checkAccountIsValid(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo masterCompany = (CompanyOrgUnitInfo)otherCtx.get("mastercompany");
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)otherCtx.get("curcompany");
        String srcTable = masterCompany.getAccountTable().getId().toString();
        String objTable = curCompany.getAccountTable().getId().toString();
        boolean isCheckAccount = false;
        if (otherCtx.get("continue").equals("no")) {
            isCheckAccount = true;
        }
        String mainBaseCurrency = masterCompany.getBaseCurrency().getId().toString();
        String transBaseCurrency = curCompany.getBaseCurrency().getId().toString();
        boolean isSameCurrency = mainBaseCurrency.equals(transBaseCurrency);
        String curCompanyId = curCompany.getId().toString();
        if (objTable.equals(srcTable)) {
            String message;
            if (isCheckAccount && !isSameCurrency && (message = this.checkAccountIsValid(ctx, mainBaseCurrency, transBaseCurrency, objTable, curCompanyId, true, null)) != null) {
                return message;
            }
        } else {
            String message;
            String accountRef = this.getRefContrastId(ctx, srcTable, objTable, curCompanyId);
            if (isCheckAccount && !isSameCurrency && (message = this.checkAccountIsValid(ctx, mainBaseCurrency, transBaseCurrency, objTable, curCompanyId, false, accountRef)) != null) {
                return message;
            }
        }
        return null;
    }
}

