/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;

public class CashEntryInfo
implements Serializable {
    private static final long serialVersionUID = 1369211888019401357L;
    private BOSUuid id;
    private String assistID;
    private VoucherInfo bill;
    private String entryID;
    private boolean isAssist;
    private Object entry;
    private AccountViewInfo account;
    private EntryDC entryDC;
    private boolean isCash = false;
    private boolean isPL;
    private CurrencyInfo currency;
    private BigDecimal originalAmount;
    private BigDecimal localAmount;
    private BigDecimal reportingAmount;
    private AssistantHGInfo assGrp;
    private VoucherAssistRecordInfo voucherAssistEntry;
    private VoucherEntryInfo voucherEntry;
    private int seq;
    private Collection assistCol;

    public Collection getAssistCol() {
        return this.assistCol;
    }

    public void setAssistCol(Collection assistCol) {
        this.assistCol = assistCol;
    }

    public VoucherAssistRecordInfo getVoucherAssistEntry() {
        return this.voucherAssistEntry;
    }

    public void setVoucherAssistEntry(VoucherAssistRecordInfo voucherAssistEntry) {
        this.voucherAssistEntry = voucherAssistEntry;
    }

    public AssistantHGInfo getAssGrp() {
        return this.assGrp;
    }

    public void setAssGrp(AssistantHGInfo assGrp) {
        this.assGrp = assGrp;
    }

    public CashEntryInfo(VoucherEntryInfo voucherEntry) {
        this.id = voucherEntry.getId();
        this.isAssist = false;
        this.entry = voucherEntry;
        this.account = voucherEntry.getAccount();
        this.entryDC = voucherEntry.getEntryDC();
        this.seq = voucherEntry.getSeq();
        if (CashFlowUtils.isCashAccount(voucherEntry.getAccount())) {
            this.isCash = true;
        }
        if (CashFlowUtils.isPL(voucherEntry.getAccount())) {
            this.isPL = true;
        }
        this.originalAmount = voucherEntry.getOriginalAmount();
        this.localAmount = voucherEntry.getLocalAmount();
        this.reportingAmount = voucherEntry.getReportingAmount();
        this.bill = voucherEntry.getBill();
        this.currency = voucherEntry.getCurrency();
        this.voucherEntry = voucherEntry;
    }

    public CashEntryInfo(VoucherEntryInfo voucherEntry, VoucherAssistRecordInfo voucherAssistEntry) {
        this.id = voucherAssistEntry.getId();
        this.isAssist = true;
        this.entry = voucherAssistEntry;
        this.seq = voucherEntry.getSeq();
        this.account = voucherEntry.getAccount();
        this.entryDC = voucherEntry.getEntryDC();
        if (CashFlowUtils.isCashAccount(voucherEntry.getAccount())) {
            this.isCash = true;
        }
        if (CashFlowUtils.isPL(voucherEntry.getAccount())) {
            this.isPL = true;
        }
        this.originalAmount = voucherAssistEntry.getOriginalAmount();
        this.localAmount = voucherAssistEntry.getLocalAmount();
        this.reportingAmount = voucherAssistEntry.getReportingAmount();
        this.bill = voucherEntry.getBill();
        this.currency = voucherEntry.getCurrency();
        this.assGrp = voucherAssistEntry.getAssGrp();
        this.voucherEntry = voucherEntry;
        this.voucherAssistEntry = voucherAssistEntry;
    }

    public AccountViewInfo getAccount() {
        return this.account;
    }

    public void setAccount(AccountViewInfo account) {
        this.account = account;
    }

    public Object getEntry() {
        return this.entry;
    }

    public void setEntry(Object entry) {
        this.entry = entry;
    }

    public boolean isAssist() {
        return this.isAssist;
    }

    public void setAssist(boolean isAssist) {
        this.isAssist = isAssist;
    }

    public boolean isCash() {
        return this.isCash;
    }

    public void setCash(boolean isCash) {
        this.isCash = isCash;
    }

    public boolean isPL() {
        return this.isPL;
    }

    public void setPL(boolean isPL) {
        this.isPL = isPL;
    }

    public BigDecimal getLocalAmount() {
        return this.localAmount;
    }

    public void setLocalAmount(BigDecimal localAmount) {
        this.localAmount = localAmount;
    }

    public EntryDC getEntryDC() {
        return this.entryDC;
    }

    public void setEntryDC(EntryDC entryDC) {
        this.entryDC = entryDC;
    }

    public BOSUuid getId() {
        return this.id;
    }

    public void setId(BOSUuid id) {
        this.id = id;
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(BigDecimal originalAmount) {
        this.originalAmount = originalAmount;
    }

    public BigDecimal getReportingAmount() {
        return this.reportingAmount;
    }

    public void setReportingAmount(BigDecimal reportingAmount) {
        this.reportingAmount = reportingAmount;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    public VoucherInfo getBill() {
        return this.bill;
    }

    public void setBill(VoucherInfo bill) {
        this.bill = bill;
    }

    public String getAssistID() {
        return this.assistID;
    }

    public void setAssistID(String assistID) {
        this.assistID = assistID;
    }

    public Object clone() throws CloneNotSupportedException {
        CashEntryInfo info = this.isAssist ? new CashEntryInfo(this.voucherEntry, this.voucherAssistEntry) : new CashEntryInfo(this.voucherEntry);
        return info;
    }

    public String toString() {
        return this.account.getNumber() + "       " + this.localAmount;
    }

    public String getEntryID() {
        return this.entryID;
    }

    public void setEntryID(String entryID) {
        this.entryID = entryID;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public VoucherEntryInfo getVoucherEntry() {
        return this.voucherEntry;
    }

    public void setVoucherEntry(VoucherEntryInfo voucherEntry) {
        this.voucherEntry = voucherEntry;
    }
}

