/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.gl.CashFlowProcess;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CashFlowProcessImpl
implements CashFlowProcess {
    private static final Logger logger = Logger.getLogger(CashFlowProcessImpl.class);

    public void updateCashFlowAsst(Context ctx, IObjectValue asstTypeInfo, Map defaultVal, IObjectValue oldAsstAccount, CashFlowItemInfo itemInfo, String hgId) throws BOSException, EASBizException {
        if (asstTypeInfo == null || oldAsstAccount == null) {
            StringBuffer sb = new StringBuffer();
            sb.delete(0, sb.length());
            sb.append("update T_GL_CashflowGrpAsst as a set FAssistGrpID = '");
            sb.append(hgId).append("' where  FAssistGrpID in ( ");
            sb.append("select  b.FAssistGrpID from T_GL_CashflowGrpAsst b inner join T_GL_CashflowInit  c on c.fid =  b.FCflowInitID where c.FCashflowItemID ='").append(itemInfo.getId()).append("')");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            int type = 0;
            if (oldAsstAccount == null) {
                boolean isIn = false;
                if (defaultVal != null) {
                    Set keyset = defaultVal.keySet();
                    for (AsstActTypeInfo oldInfo : keyset) {
                        CustomerInfo customer;
                        String asstHGAttribute = oldInfo.getAsstHGAttribute();
                        if ("companyOrg".equals(asstHGAttribute)) {
                            isIn = true;
                            break;
                        }
                        if ("customer".equals(asstHGAttribute)) {
                            customer = (CustomerInfo)defaultVal.get(oldInfo);
                            customer = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(customer.getId().toString()));
                            if (!customer.isIsInternalCompany()) continue;
                            isIn = true;
                            break;
                        }
                        if (!"provider".equals(asstHGAttribute)) continue;
                        customer = (SupplierInfo)defaultVal.get(oldInfo);
                        customer = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(customer.getId().toString()));
                        if (!customer.isIsInternalCompany()) continue;
                        isIn = true;
                        break;
                    }
                }
                type = isIn ? 3 : 2;
                ArrayList<String> pkList = new ArrayList<String>();
                pkList.add(itemInfo.getId().toString());
                CashFlowItemFactory.getLocalInstance((Context)ctx).enble(pkList);
            } else {
                type = 2;
                ArrayList<String> pkList = new ArrayList<String>();
                pkList.add(itemInfo.getId().toString());
                CashFlowItemFactory.getLocalInstance((Context)ctx).disEnable(pkList);
            }
            sb.delete(0, sb.length());
            sb.append("update T_GL_CashflowRecord set FAssGrpId = ");
            sb.append("'").append(hgId).append("', FType = ").append(type).append(" where FPrimaryItemID = '").append(itemInfo.getId()).append("'");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        } else {
            AsstAccountInfo asstAccount = new AsstAccountInfo();
            String asstAccountId = "";
            if (asstTypeInfo != null) {
                asstAccountId = ((AsstAccountInfo)asstTypeInfo).getId().toString();
                asstAccount.setId(BOSUuid.read((String)asstAccountId));
            }
            AsstActTypeCollection typeCol = new AsstActTypeCollection();
            IAssistantHG igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            if (defaultVal != null) {
                Set keyset = defaultVal.keySet();
                for (AsstActTypeInfo oldInfo : keyset) {
                    String asstHGAttribute = oldInfo.getAsstHGAttribute();
                    selector.add(new SelectorItemInfo(asstHGAttribute + ".id"));
                    typeCol.add(oldInfo);
                }
            }
            HashMap assisthg = new HashMap();
            String selectSql = " select distinct FAssistGrpID from T_GL_CashflowGrpAsst b inner join T_GL_CashflowInit  c on c.fid =  b.FCflowInitID where c.FCashflowItemID = ?  ";
            String updateSql = " update T_GL_CashflowGrpAsst set FAssistGrpID=? where FAssistGrpID=? and  FCflowInitID in (select fid from T_GL_CashflowInit where FCashflowItemID = ?) ";
            this.selectAndUpdate(ctx, itemInfo.getId().toString(), asstAccountId, defaultVal, selector, asstAccount, typeCol, selectSql, updateSql, assisthg, igCtrl, "FAssistGrpID");
            selectSql = " select distinct FAssGrpId from T_GL_CashflowRecord where FPrimaryItemID=?  ";
            updateSql = " update T_GL_CashflowRecord set FAssGrpId=?  where FAssGrpId=? and  FPrimaryItemID=? ";
            this.selectAndUpdate(ctx, itemInfo.getId().toString(), asstAccountId, defaultVal, selector, asstAccount, typeCol, selectSql, updateSql, assisthg, igCtrl, "FAssGrpId");
        }
    }

    public void updateCashflowRequisition(Context ctx, IObjectValue asstTypeInfo, IObjectValue oldAsstAccount, CashFlowItemInfo itemInfo) throws BOSException, EASBizException {
        HashMap cfRequisitionMap = this.getCFRequisition(ctx, (IObjectValue)itemInfo);
        ArrayList unCfRequisition = new ArrayList();
        for (Map.Entry e : cfRequisitionMap.entrySet()) {
            if (!e.getValue().toString().equals("1")) continue;
            unCfRequisition.add(e.getKey());
        }
        if (oldAsstAccount == null || asstTypeInfo == null) {
            this.delCFRequisition(ctx, unCfRequisition);
        } else {
            Vector newAsstTypeCol;
            IAsstAccount iasstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
            AsstAccountInfo oldAsstAccountInfo = (AsstAccountInfo)oldAsstAccount;
            AsstAccountInfo newAsstAccountInfo = (AsstAccountInfo)asstTypeInfo;
            Vector oldAsstTypeCol = iasstAccount.getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(oldAsstAccountInfo.getId()));
            if (!this.cheakAsstType(oldAsstTypeCol, newAsstTypeCol = iasstAccount.getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(newAsstAccountInfo.getId())))) {
                this.delCFRequisition(ctx, unCfRequisition);
            }
        }
    }

    private boolean cheakAsstType(Vector oldAsstTypeCol, Vector newAsstTypeCol) {
        String assHgAtbute;
        AsstActTypeInfo type;
        int i;
        ArrayList<String> oldlist = new ArrayList<String>();
        ArrayList<String> newlist = new ArrayList<String>();
        int size = oldAsstTypeCol.size();
        for (i = 0; i < size; ++i) {
            type = (AsstActTypeInfo)oldAsstTypeCol.get(i);
            assHgAtbute = type.getAsstHGAttribute();
            if (assHgAtbute.equals("customer")) {
                oldlist.add("customer");
            }
            if (assHgAtbute.equals("companyOrg")) {
                oldlist.add("companyOrg");
            }
            if (!assHgAtbute.equals("provider")) continue;
            oldlist.add("provider");
        }
        size = newAsstTypeCol.size();
        for (i = 0; i < size; ++i) {
            type = (AsstActTypeInfo)newAsstTypeCol.get(i);
            assHgAtbute = type.getAsstHGAttribute();
            if (assHgAtbute.equals("customer")) {
                newlist.add("customer");
            }
            if (assHgAtbute.equals("companyOrg")) {
                newlist.add("companyOrg");
            }
            if (!assHgAtbute.equals("provider")) continue;
            newlist.add("provider");
        }
        for (i = 0; i < oldlist.size(); ++i) {
            int vaule = 0;
            String oldAssHgAtbute = oldlist.get(i).toString();
            for (int j = 0; j < newlist.size(); ++j) {
                String newAssHgAtbute = newlist.get(j).toString();
                if (oldAssHgAtbute.equals(newAssHgAtbute)) {
                    ++vaule;
                }
                if (vaule != oldlist.size()) continue;
                return true;
            }
        }
        return false;
    }

    private void delCFRequisition(Context ctx, List unCfRequisitionCol) throws EASBizException, BOSException {
        if (unCfRequisitionCol.size() > 0) {
            int size = unCfRequisitionCol.size();
            for (int i = 0; i < size; ++i) {
                ObjectUuidPK reqpk = new ObjectUuidPK(unCfRequisitionCol.get(i).toString());
                CFRequisitionFactory.getLocalInstance(ctx).delete((IObjectPK)reqpk);
            }
        }
    }

    private Map selectAndUpdate(Context ctx, String cashflowitem, String caa, Map defaultVal, SelectorItemCollection selector, AsstAccountInfo asstAccount, AsstActTypeCollection typeCol, String selectSql, String updateSql, Map assisthg, IAssistantHG igCtrl, String field) throws BOSException, EASBizException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{cashflowitem});
        PreparedStatement stmt = null;
        Connection conn = null;
        HashMap<String, String> HGnewMap = new HashMap<String, String>();
        try {
            while (rowSet != null && rowSet.next()) {
                String id = rowSet.getString(field);
                if (id == null || id.trim().length() <= 0) continue;
                AssistantHGInfo hgInfo = null;
                if (assisthg.containsKey(id)) {
                    hgInfo = (AssistantHGInfo)assisthg.get(id);
                } else {
                    hgInfo = igCtrl.getAssistantHGInfo((IObjectPK)new ObjectUuidPK(id), selector);
                    hgInfo.setId(null);
                    hgInfo.setAsstAccount(asstAccount);
                    if (defaultVal != null) {
                        Set keyset = defaultVal.keySet();
                        for (AsstActTypeInfo oldInfo : keyset) {
                            String asstHGAttribute = oldInfo.getAsstHGAttribute();
                            if (defaultVal.get(oldInfo) == null) continue;
                            hgInfo.put(asstHGAttribute, defaultVal.get(oldInfo));
                        }
                        hgInfo = igCtrl.getAssistantHG(hgInfo, caa, typeCol);
                    }
                    assisthg.put(id, hgInfo);
                    AssistUtil._modify((Context)ctx, (String)id);
                }
                String hgid = hgInfo.getId().toString();
                HGnewMap.put(id, hgid);
            }
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(updateSql);
            Set keyset = HGnewMap.keySet();
            for (String oldId : keyset) {
                stmt.setString(1, (String)HGnewMap.get(oldId));
                stmt.setString(2, oldId);
                stmt.setString(3, cashflowitem);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return HGnewMap;
    }

    private HashMap getCFRequisition(Context ctx, IObjectValue cashflowItem) throws BOSException {
        CashFlowItemInfo flowItemInfo = (CashFlowItemInfo)cashflowItem;
        StringBuffer sb = new StringBuffer();
        sb.append("select cFRequisition.fid,cFRequisition.FStatus from T_GL_CFRequisition cFRequisition inner join T_GL_CashflowRecord cashflowRecord on ");
        sb.append("FCFRecordID = cashflowRecord.fid inner join T_BD_CashFlowItem cashFlowItem on cashflowRecord.FPrimaryItemID = cashFlowItem.fid ");
        sb.append("where cashFlowItem.fid = '").append(flowItemInfo.getId()).append("'");
        HashMap<String, Integer> cfRequisitionMap = new HashMap<String, Integer>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                cfRequisitionMap.put(rs.getString(1), new Integer(rs.getInt(2)));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return cfRequisitionMap;
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CFRequisitionFactory.getLocalInstance(ctx).delete(pk);
    }

    public boolean checkCFRequisition(Context ctx, IObjectValue cashflowItem, IObjectValue oldAsstAccount, IObjectValue newAsstAccount) throws BOSException, EASBizException {
        CashFlowItemInfo flowItemInfo = (CashFlowItemInfo)cashflowItem;
        StringBuffer sb = new StringBuffer();
        HashMap cfRequisitionMap = this.getCFRequisition(ctx, (IObjectValue)flowItemInfo);
        boolean isSelect = false;
        for (Map.Entry e : cfRequisitionMap.entrySet()) {
            if (!e.getValue().toString().equals("2")) continue;
            isSelect = true;
            break;
        }
        if (isSelect && oldAsstAccount != null) {
            int i;
            if (newAsstAccount == null) {
                return false;
            }
            IAsstAccount iasstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
            AsstAccountInfo oldAsstAccountInfo = (AsstAccountInfo)oldAsstAccount;
            AsstAccountInfo newAsstAccountInfo = (AsstAccountInfo)newAsstAccount;
            Vector oldAsstTypeCol = iasstAccount.getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(oldAsstAccountInfo.getId()));
            Vector newAsstTypeCol = iasstAccount.getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(newAsstAccountInfo.getId()));
            ArrayList<String> list = new ArrayList<String>();
            int size = oldAsstTypeCol.size();
            for (i = 0; i < size; ++i) {
                AsstActTypeInfo type = (AsstActTypeInfo)oldAsstTypeCol.get(i);
                String assHgAtbute = type.getAsstHGAttribute();
                if (assHgAtbute.equals("customer")) {
                    list.add("customer");
                }
                if (assHgAtbute.equals("companyOrg")) {
                    list.add("companyOrg");
                }
                if (!assHgAtbute.equals("provider")) continue;
                list.add("provider");
            }
            sb.delete(0, sb.length());
            size = newAsstTypeCol.size();
            for (i = 0; i < size; ++i) {
                AsstActTypeInfo newType = (AsstActTypeInfo)newAsstTypeCol.get(i);
                if (i < size - 1) {
                    sb.append(newType.getAsstHGAttribute()).append("+");
                    continue;
                }
                sb.append(newType.getAsstHGAttribute());
            }
            size = list.size();
            for (i = 0; i < size; ++i) {
                if (sb.toString().indexOf(list.get(i).toString()) != -1) continue;
                return false;
            }
        }
        return true;
    }
}

