/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CollectionUtils {
    public static <T, V> Map<T, List<V>> groupBy(List<V> list, GroupFunction<T, V> function) {
        HashMap map = new HashMap();
        for (V v : list) {
            T t = function.group(v);
            if (!map.containsKey(t)) {
                ArrayList<V> temp = new ArrayList<V>();
                temp.add(v);
                map.put(t, temp);
                continue;
            }
            ((List)map.get(t)).add(v);
        }
        map.remove(null);
        return map;
    }

    public static <T, V> Map<T, V> groupByOne(List<V> list, GroupFunction<T, V> function) {
        HashMap<T, V> map = new HashMap<T, V>();
        for (V v : list) {
            T t = function.group(v);
            if (map.containsKey(t)) continue;
            map.put(t, v);
        }
        return map;
    }

    public static <T, V> Map<T, V> listToMap(List<V> list, GroupFunction<T, V> function) {
        HashMap<T, V> map = new HashMap<T, V>();
        for (V v : list) {
            T t = function.group(v);
            map.put(t, v);
        }
        return map;
    }

    public static <T, V> Map<T, List<V>> groupBy(List<V> list, GroupFunction<T, V> function, Comparator<T> comparator1, Comparator<V> comparator2) {
        AbstractMap map = null;
        map = comparator1 == null ? new HashMap() : new TreeMap(comparator1);
        for (V v : list) {
            T t = function.group(v);
            if (!map.containsKey(t)) {
                ArrayList<V> temp = new ArrayList<V>();
                temp.add(v);
                map.put(t, temp);
                continue;
            }
            ((List)map.get(t)).add(v);
        }
        if (comparator2 != null) {
            for (Object t : map.keySet()) {
                List vs = (List)map.get(t);
                Collections.sort(vs, comparator2);
            }
        }
        return map;
    }

    public static interface GroupFunction<T, V> {
        public T group(V var1);
    }
}

