/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.eas.basedata.master.account.AccountCategoryEnum;
import com.kingdee.eas.basedata.master.account.AccountDiffType;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;

public class DiffEntryWrapper {
    public VoucherEntryInfo entry;
    public AccountDiffType diffType;
    public String prefix = "";

    public DiffEntryWrapper(VoucherEntryInfo entry) {
        if (entry == null || entry.getAccount() == null) {
            throw new IllegalArgumentException("entry can not be null!");
        }
        this.entry = entry;
        this.diffType = entry.getAccount().getDiffType();
        this.prefix = this.diffType.equals((Object)AccountDiffType.INCOME) ? "\u2192" : (this.diffType.equals((Object)AccountDiffType.EXPENSE) ? "\u2190" : "");
    }

    public boolean isFinanceIncome() {
        return this.isFinance() && this.isIncome();
    }

    public boolean isFinanceExpense() {
        return this.isFinance() && this.isExpense();
    }

    public boolean isBudgetIncome() {
        return this.isbudget() && this.isIncome();
    }

    public boolean isBudgetExpense() {
        return this.isbudget() && this.isExpense();
    }

    public boolean isFinance() {
        return this.entry.getAccount().getCategory().equals((Object)AccountCategoryEnum.FINANCE);
    }

    public boolean isbudget() {
        return this.entry.getAccount().getCategory().equals((Object)AccountCategoryEnum.BUDGET);
    }

    public boolean isIncome() {
        return this.diffType.equals((Object)AccountDiffType.INCOME);
    }

    public boolean isExpense() {
        return this.diffType.equals((Object)AccountDiffType.EXPENSE);
    }

    public boolean isDiff() {
        return this.isIncome() || this.isExpense();
    }

    public boolean isCheck() {
        return this.isFinance() && this.diffType.equals((Object)AccountDiffType.EMPTY);
    }

    public String toString() {
        return this.prefix + "(" + this.entry.getSeq() + ") " + this.entry.getAccount().getNumber() + " - " + this.entry.getAccount().getLongName();
    }
}

