/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class EventModelParserExcel {
    protected static final Logger logger = Logger.getLogger(EventModelParserExcel.class);
    public static final int ERROR = 4;
    public static final int BOOLEAN = 1;
    public static final int NUMBER = 0;
    public static final int STRING = 3;
    public static final int DATE = 2;
    public static final String DATE_FORMAT_STR = "yyyy/MM/dd";
    public boolean sheetEndFlag;
    private InputStream sheet;
    private XMLReader parser;
    private InputSource sheetSource;
    public int rowNum = 1;
    private SharedStringsTable sharedStringsTable;
    private StylesTable stylesTable;
    private XSSFReader xssfReader;
    private OPCPackage pkg;
    private boolean isCheck;
    private Map<String, String> sheetMap = new HashMap<String, String>();
    public String fileName;
    public volatile boolean endTask = false;

    public EventModelParserExcel(String fileName, boolean isCheck) {
        this.isCheck = isCheck;
        this.fileName = fileName;
        try {
            this.pkg = OPCPackage.open((String)fileName);
            this.xssfReader = new XSSFReader(this.pkg);
            this.sharedStringsTable = this.xssfReader.getSharedStringsTable();
            this.stylesTable = this.xssfReader.getStylesTable();
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OpenXML4JException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAllSheetInfo() {
        InputStream book = null;
        try {
            book = this.xssfReader.getWorkbookData();
            XMLReader parser = this.fetchSheetParser(this.sharedStringsTable, this.stylesTable);
            parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            InputSource source = new InputSource(book);
            parser.parse(source);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        finally {
            if (book != null) {
                try {
                    book.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new HashMap<String, String>(this.sheetMap);
    }

    public EventModelParserExcel(String filename, String sheetRid) throws IOException, OpenXML4JException, SAXException {
        this.pkg = OPCPackage.open((String)filename);
        this.init(this.pkg, sheetRid);
    }

    public EventModelParserExcel(InputStream in, String sheetRid) throws IOException, OpenXML4JException, SAXException {
        this.pkg = OPCPackage.open((InputStream)in);
        this.init(this.pkg, sheetRid);
    }

    private void init(OPCPackage pkg, String sheetRid) throws IOException, OpenXML4JException, SAXException {
        this.xssfReader = new XSSFReader(pkg);
        this.sharedStringsTable = this.xssfReader.getSharedStringsTable();
        this.stylesTable = this.xssfReader.getStylesTable();
        this.sheet = this.xssfReader.getSheet(sheetRid);
        this.parser = this.fetchSheetParser(this.sharedStringsTable, this.stylesTable);
        this.sheetSource = new InputSource(this.sheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOneSheet(String sheetRid) throws Exception {
        try (InputStream sheet = null;){
            sheet = this.xssfReader.getSheet(sheetRid);
            XMLReader parser = this.fetchSheetParser(this.sharedStringsTable, this.stylesTable);
            parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            InputSource source = new InputSource(sheet);
            parser.parse(source);
            logger.info((Object)("this sheet:" + sheetRid + " rownums:" + this.rowNum));
        }
    }

    public int parse() {
        try {
            this.parser.parse(this.sheetSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        finally {
            if (this.sheet != null) {
                try {
                    this.sheet.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.rowNum;
    }

    private XMLReader fetchSheetParser(SharedStringsTable sharedStringsTable, StylesTable stylesTable) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        SheetHandler handler = new SheetHandler(sharedStringsTable, stylesTable);
        parser.setContentHandler(handler);
        return parser;
    }

    protected abstract void outputRow(Object[] var1, int[] var2, int var3);

    protected abstract void outputTheFirstRow(Object[] var1, int[] var2, int var3);

    private int getColumn(Attributes attrubuts) {
        String name = attrubuts.getValue("r");
        int column = -1;
        for (int i = 0; i < name.length() && !Character.isDigit(name.charAt(i)); ++i) {
            char c = name.charAt(i);
            column = (column + 1) * 26 + c - 65;
        }
        return column;
    }

    private int getColsNum(Attributes attrubuts) {
        String spans = attrubuts.getValue("spans");
        if (!StringUtils.isEmpty((String)spans)) {
            String cols = spans.substring(spans.indexOf(":") + 1);
            return Integer.parseInt(cols);
        }
        return -1;
    }

    public void close() {
        if (this.pkg != null) {
            try {
                this.pkg.close();
            }
            catch (Exception e) {
                logger.error((Object)"OPCPackage close error.", (Throwable)e);
            }
        }
    }

    private class SheetHandler
    extends DefaultHandler {
        private SharedStringsTable sharedStringsTable;
        private StylesTable stylesTable;
        private String readValue;
        private xssfDataType dataType;
        private Object[] rowDatas;
        private int[] rowTypes;
        private int colIdx;
        private int cols;
        private short formatIndex;

        private SheetHandler(SharedStringsTable sst, StylesTable stylesTable) {
            this.sharedStringsTable = sst;
            this.stylesTable = stylesTable;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("c")) {
                this.colIdx = EventModelParserExcel.this.getColumn(attributes);
                String cellType = attributes.getValue("t");
                String cellStyle = attributes.getValue("s");
                this.dataType = xssfDataType.NUMBER;
                if ("b".equals(cellType)) {
                    this.dataType = xssfDataType.BOOL;
                } else if ("e".equals(cellType)) {
                    this.dataType = xssfDataType.ERROR;
                } else if ("inlineStr".equals(cellType)) {
                    this.dataType = xssfDataType.INLINESTR;
                } else if ("s".equals(cellType)) {
                    this.dataType = xssfDataType.SSTINDEX;
                } else if ("str".equals(cellType)) {
                    this.dataType = xssfDataType.FORMULA;
                }
                if (cellStyle != null) {
                    int styleIndex = Integer.parseInt(cellStyle);
                    XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
                    this.formatIndex = style.getDataFormat();
                } else {
                    this.formatIndex = 0;
                }
            } else if (name.equals("row")) {
                int cols = EventModelParserExcel.this.getColsNum(attributes);
                if (cols == -1 && EventModelParserExcel.this.rowNum == 1) {
                    this.cols = 100;
                } else if (cols != -1 && EventModelParserExcel.this.rowNum == 1) {
                    this.cols = cols;
                }
                if (EventModelParserExcel.this.rowNum > 1 && cols > this.cols) {
                    this.rowDatas = new String[cols];
                    this.rowTypes = new int[cols];
                } else {
                    this.rowDatas = new String[this.cols];
                    this.rowTypes = new int[this.cols];
                }
            } else if (name.equals("sheet")) {
                String sheetId = attributes.getValue("sheetId");
                String sheetRid = attributes.getValue("r:id");
                if (StringUtils.isNotEmpty((String)sheetId) && StringUtils.isNotEmpty((String)sheetRid)) {
                    EventModelParserExcel.this.sheetMap.put(sheetId, sheetRid);
                }
            }
            this.readValue = "";
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ((name.equals("v") || name.equals("t")) && this.colIdx < this.cols) {
                switch (this.dataType) {
                    case BOOL: {
                        char first = this.readValue.charAt(0);
                        this.rowDatas[this.colIdx] = first == '0' ? "FALSE" : "TRUE";
                        this.rowTypes[this.colIdx] = 1;
                        break;
                    }
                    case ERROR: {
                        this.rowDatas[this.colIdx] = "ERROR:" + this.readValue.toString();
                        this.rowTypes[this.colIdx] = 4;
                        break;
                    }
                    case INLINESTR: {
                        this.rowDatas[this.colIdx] = new XSSFRichTextString(this.readValue).toString();
                        this.rowTypes[this.colIdx] = 3;
                        break;
                    }
                    case SSTINDEX: {
                        int idx = Integer.parseInt(this.readValue);
                        this.rowDatas[this.colIdx] = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx)).toString();
                        this.rowTypes[this.colIdx] = 3;
                        break;
                    }
                    case FORMULA: {
                        this.rowDatas[this.colIdx] = this.readValue;
                        this.rowTypes[this.colIdx] = 3;
                        break;
                    }
                    case NUMBER: {
                        if (HSSFDateUtil.isADateFormat((int)this.formatIndex, (String)this.readValue)) {
                            Double d = Double.parseDouble(this.readValue);
                            HSSFDateUtil.isValidExcelDate((double)d);
                            Date date = HSSFDateUtil.getJavaDate((double)d);
                            this.rowDatas[this.colIdx] = DateFormatUtils.format((Date)date, (String)EventModelParserExcel.DATE_FORMAT_STR);
                            this.rowTypes[this.colIdx] = 2;
                            break;
                        }
                        this.rowDatas[this.colIdx] = this.readValue;
                        this.rowTypes[this.colIdx] = 0;
                    }
                }
            } else if (name.equals("row")) {
                if (EventModelParserExcel.this.rowNum == 1) {
                    this.rowDatas = this.toNewArray(this.rowDatas);
                    this.cols = this.rowDatas.length;
                }
                if (EventModelParserExcel.this.isCheck && EventModelParserExcel.this.rowNum == 1) {
                    EventModelParserExcel.this.outputTheFirstRow(this.rowDatas, this.rowTypes, EventModelParserExcel.this.rowNum++);
                } else if (!EventModelParserExcel.this.isCheck && !EventModelParserExcel.this.endTask) {
                    EventModelParserExcel.this.outputRow(this.rowDatas, this.rowTypes, EventModelParserExcel.this.rowNum++);
                }
            } else if (name.equals("worksheet")) {
                EventModelParserExcel.this.sheetEndFlag = true;
            }
        }

        private Object[] toNewArray(Object[] objs) {
            ArrayList<Object> objList = new ArrayList<Object>();
            for (int i = 0; i < objs.length; ++i) {
                Object obj = objs[i];
                if (obj == null || "".equals(obj)) continue;
                objList.add(obj);
            }
            Object[] newArray = objList.toArray();
            return newArray;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.readValue = this.readValue + new String(ch, start, length);
        }
    }

    static enum xssfDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER;

    }
}

