/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gl.GLAsstBalanceCollection;
import com.kingdee.eas.fi.gl.GLAsstBalanceInfo;
import com.kingdee.eas.fi.gl.GLAsstBalanceKey;
import com.kingdee.eas.fi.gl.GLBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GLBalanceCollection
implements Serializable {
    private static final long serialVersionUID = -5588485269052073669L;
    private List balList = new ArrayList();

    public Iterator iterator() {
        return this.balList.iterator();
    }

    public void add(GLBalanceInfo balInfo) throws BOSException {
        GLBalanceInfo oldBalInfo = this.getGLBalanceInfo(balInfo.getKey());
        if (oldBalInfo != null) {
            oldBalInfo.add(balInfo);
        } else {
            this.balList.add(balInfo);
        }
    }

    public void addAll(GLBalanceCollection balColl) throws BOSException {
        if (balColl == null) {
            return;
        }
        Iterator it = balColl.iterator();
        while (it.hasNext()) {
            this.add((GLBalanceInfo)it.next());
        }
    }

    public void addGLAsstBalInfo(GLAsstBalanceInfo balInfo) throws BOSException {
        if (balInfo == null) {
            return;
        }
        GLAsstBalanceKey asstKey = balInfo.getKey();
        GLBalanceKey key = new GLBalanceKey(asstKey.getCompany(), asstKey.getAccount(), asstKey.getCurrency(), asstKey.getPeriod(), asstKey.getBalType());
        GLBalanceInfo oldBalInfo = this.getGLBalanceInfo(key);
        if (oldBalInfo == null) {
            oldBalInfo = new GLBalanceInfo(key);
        }
        oldBalInfo.addGLAsstBalInfo(balInfo);
    }

    public void addGLAsstBalanceCollection(GLAsstBalanceCollection balColl) throws BOSException {
        if (balColl == null) {
            return;
        }
        Iterator it = balColl.iterator();
        while (it.hasNext()) {
            this.addGLAsstBalInfo((GLAsstBalanceInfo)it.next());
        }
    }

    public void subtract(GLBalanceInfo balInfo) throws BOSException {
        GLBalanceInfo oldBalInfo = this.getGLBalanceInfo(balInfo.getKey());
        if (oldBalInfo != null) {
            oldBalInfo.subtract(balInfo);
        } else {
            balInfo.negate();
            this.balList.add(balInfo);
        }
    }

    public void negate() {
        GLBalanceInfo balInfo = null;
        for (int i = 0; i < this.balList.size(); ++i) {
            balInfo = (GLBalanceInfo)this.balList.get(i);
            balInfo.negate();
        }
    }

    public GLBalanceCollection getDeficitBalance() throws BOSException {
        GLBalanceCollection balColl = new GLBalanceCollection();
        Iterator balIt = this.iterator();
        while (balIt.hasNext()) {
            GLBalanceInfo balInfo = (GLBalanceInfo)balIt.next();
            GLAsstBalanceCollection asstBalColl = balInfo.getAsstBalColl();
            if (asstBalColl != null) {
                Iterator it = asstBalColl.iterator();
                while (it.hasNext()) {
                    GLAsstBalanceInfo asstBalInfo = (GLAsstBalanceInfo)it.next();
                    if (asstBalInfo.compareToZero() < 0) continue;
                    it.remove();
                }
            }
            if (balInfo.compareToZero() >= 0 && (asstBalColl == null || asstBalColl.size() <= 0)) continue;
            balColl.add(balInfo);
        }
        return balColl;
    }

    public GLBalanceInfo getGLBalanceInfo(GLBalanceKey key) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            GLBalanceInfo balInfo = (GLBalanceInfo)it.next();
            if (!balInfo.getKey().equals(key)) continue;
            return balInfo;
        }
        return null;
    }

    public Set getBalanceKeySet() {
        HashSet<GLBalanceKey> keySet = new HashSet<GLBalanceKey>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            keySet.add(((GLBalanceInfo)it.next()).getKey());
        }
        return keySet;
    }

    public Set getAsstBalanceKeySet() {
        HashSet keySet = new HashSet();
        GLAsstBalanceCollection balCol = null;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            balCol = ((GLBalanceInfo)it.next()).getAsstBalColl();
            if (balCol == null || balCol.size() == 0) continue;
            keySet.addAll(balCol.getBalanceKeySet());
        }
        return keySet;
    }

    public int size() {
        return this.balList.size();
    }

    public void subtractB(GLBalanceInfo balInfo) throws BOSException {
        GLBalanceInfo oldBalInfo = this.getGLBalanceInfo(balInfo.getKey());
        if (oldBalInfo != null) {
            oldBalInfo.subtract(balInfo);
            oldBalInfo.negateB();
        }
    }

    public void subtractBAll(GLBalanceCollection balColl) throws BOSException {
        if (balColl == null) {
            return;
        }
        Iterator it = balColl.iterator();
        while (it.hasNext()) {
            this.subtractB((GLBalanceInfo)it.next());
        }
    }

    public void subtractBGLAsstBalInfo(GLAsstBalanceInfo balInfo) throws BOSException {
        if (balInfo == null) {
            return;
        }
        GLAsstBalanceKey asstKey = balInfo.getKey();
        GLBalanceKey key = new GLBalanceKey(asstKey.getCompany(), asstKey.getAccount(), asstKey.getCurrency(), asstKey.getPeriod(), asstKey.getBalType());
        GLBalanceInfo oldBalInfo = this.getGLBalanceInfo(key);
        if (oldBalInfo == null) {
            oldBalInfo = new GLBalanceInfo(key);
        }
        oldBalInfo.subtractBGLAsstBalInfo(balInfo);
    }

    public void subtractBGLAsstBalanceCollection(GLAsstBalanceCollection balColl) throws BOSException {
        if (balColl == null) {
            return;
        }
        Iterator it = balColl.iterator();
        while (it.hasNext()) {
            this.subtractBGLAsstBalInfo((GLAsstBalanceInfo)it.next());
        }
    }
}

