/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.fi.gl.GLAsstBalanceCollection;
import com.kingdee.eas.fi.gl.GLAsstBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceKey;
import com.kingdee.eas.fi.gl.GlUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;

public class GLBalanceInfo
implements Serializable {
    private static final long serialVersionUID = 5001310902019389090L;
    protected GLBalanceKey key;
    protected BigDecimal debitFor = GlUtils.zero;
    protected BigDecimal debitLocal = GlUtils.zero;
    protected BigDecimal creditFor = GlUtils.zero;
    protected BigDecimal creditLocal = GlUtils.zero;
    protected BigDecimal origAmount = GlUtils.zero;
    protected BigDecimal localAmount = GlUtils.zero;
    private GLAsstBalanceCollection asstBalColl;

    public GLBalanceInfo(GLBalanceKey key) {
        this.key = key;
    }

    public GLBalanceKey getKey() {
        return this.key;
    }

    public BigDecimal getOrigAmount() {
        return this.origAmount;
    }

    public void setOrigAmount(BigDecimal origAmount) {
        if (origAmount != null) {
            this.origAmount = origAmount;
        }
    }

    public BigDecimal getLocalAmount() {
        return this.localAmount;
    }

    public void setLocalAmount(BigDecimal localAmount) {
        if (localAmount != null) {
            this.localAmount = localAmount;
        }
    }

    public BigDecimal getDebitFor() {
        return this.debitFor;
    }

    public void setDebitFor(BigDecimal debitFor) {
        this.debitFor = debitFor;
    }

    public BigDecimal getDebitLocal() {
        return this.debitLocal;
    }

    public void setDebitLocal(BigDecimal debitLocal) {
        this.debitLocal = debitLocal;
    }

    public BigDecimal getCreditFor() {
        return this.creditFor;
    }

    public void setCreditFor(BigDecimal creditFor) {
        this.creditFor = creditFor;
    }

    public BigDecimal getCreditLocal() {
        return this.creditLocal;
    }

    public void setCreditLocal(BigDecimal creditLocal) {
        this.creditLocal = creditLocal;
    }

    public GLAsstBalanceCollection getAsstBalColl() {
        return this.asstBalColl;
    }

    public void addGLAsstBalInfo(GLAsstBalanceInfo balInfo) throws BOSException {
        if (this.asstBalColl == null) {
            this.asstBalColl = new GLAsstBalanceCollection();
        }
        this.asstBalColl.add(balInfo);
    }

    public void subtractBGLAsstBalInfo(GLAsstBalanceInfo balInfo) throws BOSException {
        if (this.asstBalColl == null) {
            this.asstBalColl = new GLAsstBalanceCollection();
        }
        this.asstBalColl.subtractB(balInfo);
    }

    public void addGLAsstBalCollection(GLAsstBalanceCollection balColl) throws BOSException {
        if (balColl == null || balColl.size() == 0) {
            return;
        }
        if (this.asstBalColl == null) {
            this.asstBalColl = new GLAsstBalanceCollection();
        }
        Iterator it = balColl.iterator();
        while (it.hasNext()) {
            this.addGLAsstBalInfo((GLAsstBalanceInfo)it.next());
        }
    }

    public void add(GLBalanceInfo augend) throws BOSException {
        if (augend == null) {
            return;
        }
        if (this.key.equals(augend.getKey())) {
            this.debitFor = this.debitFor.add(augend.getDebitFor());
            this.debitLocal = this.debitLocal.add(augend.getDebitLocal());
            this.creditFor = this.creditFor.add(augend.getCreditFor());
            this.creditLocal = this.creditLocal.add(augend.getCreditLocal());
            this.origAmount = this.origAmount.add(augend.origAmount);
            this.localAmount = this.localAmount.add(augend.localAmount);
            if (augend.asstBalColl != null) {
                Iterator it = augend.asstBalColl.iterator();
                while (it.hasNext()) {
                    this.asstBalColl.add((GLAsstBalanceInfo)it.next());
                }
            }
        } else {
            throw new BOSException("The accKey not equal!");
        }
    }

    public void subtract(GLBalanceInfo subtrahend) throws BOSException {
        if (subtrahend == null) {
            return;
        }
        if (this.key.equals(subtrahend.getKey())) {
            this.debitFor = this.debitFor.subtract(subtrahend.getDebitFor());
            this.debitLocal = this.debitLocal.subtract(subtrahend.getDebitLocal());
            this.creditFor = this.creditFor.subtract(subtrahend.getCreditFor());
            this.creditLocal = this.creditLocal.subtract(subtrahend.getCreditLocal());
            this.origAmount = this.origAmount.subtract(subtrahend.origAmount);
            this.localAmount = this.localAmount.subtract(subtrahend.localAmount);
            if (subtrahend.asstBalColl != null) {
                Iterator it = subtrahend.asstBalColl.iterator();
                while (it.hasNext()) {
                    this.asstBalColl.subtract((GLAsstBalanceInfo)it.next());
                }
            }
        } else {
            throw new BOSException("The accKey not equal!");
        }
    }

    public void negate() {
        this.debitFor = this.debitFor.negate();
        this.debitLocal = this.debitLocal.negate();
        this.creditFor = this.creditFor.negate();
        this.creditLocal = this.creditLocal.negate();
        this.origAmount = this.origAmount.negate();
        this.localAmount = this.localAmount.negate();
        if (this.asstBalColl != null) {
            this.asstBalColl.negate();
        }
    }

    public void negateB() {
        this.debitFor = this.debitFor.negate();
        this.debitLocal = this.debitLocal.negate();
        this.creditFor = this.creditFor.negate();
        this.creditLocal = this.creditLocal.negate();
        this.origAmount = this.origAmount.negate();
        this.localAmount = this.localAmount.negate();
    }

    public boolean equalZero() {
        return this.origAmount.doubleValue() == 0.0 && this.localAmount.doubleValue() == 0.0;
    }

    public int compareToZero() throws BOSException {
        int dc = 1;
        if (this.key.getAccount().getDC() == BalanceDirectionEnum.CREDIT) {
            dc = -1;
        }
        if (this.origAmount.doubleValue() * (double)dc < 0.0) {
            return -1;
        }
        if (this.equalZero()) {
            return 0;
        }
        return 1;
    }
}

