/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GLAsstBalanceKey;
import com.kingdee.eas.fi.gl.GLBalanceKey;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GLBalanceKeyCPCT
implements Serializable {
    private static final long serialVersionUID = -3045299352445380058L;
    private CompanyOrgUnitInfo company;
    private PeriodInfo period;
    private CurrencyInfo currency;
    private int balType;
    private AccountViewCollection accountColl = new AccountViewCollection();
    private Map accHgMap = new HashMap();

    public GLBalanceKeyCPCT(CompanyOrgUnitInfo company, PeriodInfo period, CurrencyInfo currency, int balType) throws BOSException {
        if (company == null || period == null || currency == null) {
            throw new BOSException("The key attribute is empty!");
        }
        this.company = company;
        this.period = period;
        this.currency = currency;
        this.balType = balType;
    }

    public GLBalanceKeyCPCT(GLBalanceKey key) throws BOSException {
        this.company = key.getCompany();
        this.period = key.getPeriod();
        this.currency = key.getCurrency();
        this.balType = key.getBalType();
        this.addAccount(key.getAccount());
    }

    public GLBalanceKeyCPCT(GLAsstBalanceKey key) throws BOSException {
        this.company = key.getCompany();
        this.period = key.getPeriod();
        this.currency = key.getCurrency();
        this.balType = key.getBalType();
        this.addAccount(key.getAccount());
        this.addAssistantHG(key.getAccount().getId(), key.getHg());
    }

    public void addAccount(AccountViewInfo account) {
        this.accountColl.add(account);
    }

    public AccountViewCollection getAccountViweCollection() {
        return this.accountColl;
    }

    public void addAssistantHG(BOSUuid accountId, AssistantHGInfo hg) {
        AssistantHGCollection hgColl = (AssistantHGCollection)this.accHgMap.get(accountId);
        if (hgColl == null) {
            hgColl = new AssistantHGCollection();
            this.accHgMap.put(accountId, hgColl);
        }
        hgColl.add(hg);
    }

    public AssistantHGCollection getAssistantHGCollection(BOSUuid accountId) {
        return (AssistantHGCollection)this.accHgMap.get(accountId);
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public PeriodInfo getPeriod() {
        return this.period;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public int getBalType() {
        return this.balType;
    }

    public static GLBalanceKeyCPCT[] getGLBalanceKeyCPCTs(Set GLBalanceKeySet) throws BOSException {
        if (GLBalanceKeySet == null || GLBalanceKeySet.size() == 0) {
            return null;
        }
        HashMap<GLBalanceKeyCPCT, GLBalanceKeyCPCT> cpctMap = new HashMap<GLBalanceKeyCPCT, GLBalanceKeyCPCT>();
        for (GLBalanceKey key : GLBalanceKeySet) {
            GLBalanceKeyCPCT cpct = new GLBalanceKeyCPCT(key.getCompany(), key.getPeriod(), key.getCurrency(), key.getBalType());
            GLBalanceKeyCPCT cpctValue = (GLBalanceKeyCPCT)cpctMap.get(cpct);
            if (cpctValue == null) {
                cpctValue = cpct;
                cpctMap.put(cpct, cpctValue);
            }
            cpctValue.addAccount(key.getAccount());
        }
        Collection cpctSet = cpctMap.values();
        GLBalanceKeyCPCT[] cpcts = new GLBalanceKeyCPCT[cpctSet.size()];
        cpctSet.toArray(cpcts);
        return cpcts;
    }

    public static GLBalanceKeyCPCT[] getGLAsstBalanceKeyCPCTs(Set GLAsstBalanceKeySet) throws BOSException {
        if (GLAsstBalanceKeySet == null || GLAsstBalanceKeySet.size() == 0) {
            return null;
        }
        HashMap<GLBalanceKeyCPCT, GLBalanceKeyCPCT> cpctMap = new HashMap<GLBalanceKeyCPCT, GLBalanceKeyCPCT>();
        for (GLAsstBalanceKey key : GLAsstBalanceKeySet) {
            GLBalanceKeyCPCT cpct = new GLBalanceKeyCPCT(key.getCompany(), key.getPeriod(), key.getCurrency(), key.getBalType());
            GLBalanceKeyCPCT cpctValue = (GLBalanceKeyCPCT)cpctMap.get(cpct);
            if (cpctValue == null) {
                cpctValue = cpct;
                cpctMap.put(cpct, cpctValue);
            }
            cpctValue.addAccount(key.getAccount());
            cpctValue.addAssistantHG(key.getAccount().getId(), key.getHg());
        }
        Collection cpctSet = cpctMap.values();
        GLBalanceKeyCPCT[] cpcts = new GLBalanceKeyCPCT[cpctSet.size()];
        cpctSet.toArray(cpcts);
        return cpcts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.balType;
        result = 31 * result + this.company.getId().hashCode();
        result = 31 * result + this.currency.getId().hashCode();
        result = 31 * result + this.period.getId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GLBalanceKeyCPCT other = (GLBalanceKeyCPCT)obj;
        return this.company.getId().equals((Object)other.company.getId()) && this.currency.getId().equals((Object)other.currency.getId()) && this.period.getId().equals((Object)other.period.getId()) && this.balType == other.balType;
    }

    public String toString() {
        return this.company.toString() + "," + this.period.toString() + "," + this.currency.toString() + "," + this.balType;
    }
}

