/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gl.common.GLExecutor;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GLConfig
implements Serializable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.GLConfig");
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLConfigResource";
    private static Hashtable<String, String> defs = new Hashtable();
    private static Hashtable<String, String> vals = new Hashtable();
    public static final String CORE_POOL_SIZE = "CORE_POOL_SIZE";
    public static final String MAX_POOL_SIZE = "MAX_POOL_SIZE";
    public String name;
    public String value;
    public String def;
    public String desc;

    public GLConfig() {
    }

    public GLConfig(String name, String value, String def, String desc) {
        this.name = name;
        this.value = value;
        this.def = def;
        this.desc = desc;
    }

    public static String getString(String key) {
        return vals.get(key);
    }

    public static boolean getBoolean(String key) {
        String value = vals.get(key);
        return "true".equals(value);
    }

    public static int getInt(String key) {
        String value = vals.get(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static void saveConfigs(Context ctx, List<GLConfig> configs) {
        HashMap<String, String> newVals = new HashMap<String, String>();
        for (GLConfig config : configs) {
            if (!defs.containsKey(config.name)) continue;
            newVals.put(config.name, config.value == null ? "" : config.value);
        }
        boolean isPoolSizeChange = false;
        if (newVals.containsKey(CORE_POOL_SIZE) && !((String)newVals.get(CORE_POOL_SIZE)).equals(vals.get(CORE_POOL_SIZE))) {
            isPoolSizeChange = true;
        }
        if (newVals.containsKey(MAX_POOL_SIZE) && !((String)newVals.get(MAX_POOL_SIZE)).equals(vals.get(MAX_POOL_SIZE))) {
            isPoolSizeChange = true;
        }
        vals.putAll(newVals);
        if (isPoolSizeChange) {
            GLExecutor.close();
        }
        GLConfig.saveProperties();
    }

    public static List<GLConfig> getConfigs(Context ctx) {
        ArrayList<GLConfig> configs = new ArrayList<GLConfig>(vals.size());
        for (String name : vals.keySet()) {
            GLConfig config = new GLConfig();
            config.name = name;
            config.value = vals.get(name);
            config.def = defs.get(name);
            config.desc = ctx != null ? ResourceBase.getString((String)RESOURCE, (String)name, (Locale)ctx.getLocale()) : EASResource.getString((String)RESOURCE, (String)name);
            configs.add(config);
        }
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() {
        File file;
        Properties props = new Properties();
        String dir = System.getProperty("EAS_INSTANCE_CONFIG_PATH");
        if (dir != null && dir.length() > 0 && (file = new File(dir + "/GLConfig.properties")).exists() && file.isFile()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                props.load(fis);
            }
            catch (Exception e) {
                logger.error((Object)"Load GL Config fail!", (Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties saveProperties() {
        File file;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)vals);
        String dir = System.getProperty("EAS_INSTANCE_CONFIG_PATH");
        if (dir != null && dir.length() > 0 && (file = new File(dir)).exists() && file.isDirectory()) {
            try (PrintWriter writer = null;){
                writer = new PrintWriter(new FileOutputStream(dir + "/GLConfig.properties"));
                props.store(writer, "GLConfig");
                writer.flush();
            }
        }
        return props;
    }

    static {
        defs.put(CORE_POOL_SIZE, "4");
        defs.put(MAX_POOL_SIZE, "16");
        vals.putAll(defs);
        Properties props = GLConfig.loadProperties();
        for (String name : props.stringPropertyNames()) {
            if (!defs.containsKey(name)) continue;
            vals.put(name, props.getProperty(name));
        }
    }
}

