/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLMutexException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Uuid;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLMutexUtils {
    public static final String RES = "com.kingdee.eas.fi.gl.GLMutexResource";
    public static final String GL_ModifyBalance = "gl_modifyBalance";
    public static final String GL_ML_CheckVoucherNumber = "gl_mutexlock_checkVoucherNumber";
    public static final String GL_ML_ACVerify = "gl_mutexlock_ACVerify";
    public static String GL_Verify = "GL_AutoVerify";
    private static Map<String, String> strs = new HashMap<String, String>();

    public static String getString(Context ctx, String resName) {
        if (ctx != null) {
            String key = resName + "_" + ctx.getLocale();
            if (strs.containsKey(key)) {
                return strs.get(key);
            }
            String str = ResourceBase.getString((String)RES, (String)resName, (Locale)ctx.getLocale());
            strs.put(key, str);
            return str;
        }
        return EASResource.getString((String)RES, (String)resName);
    }

    public static String getMutexMessage(MutexParameter current, MutexParameter mp) {
        return GLMutexUtils.getMutexMessage(null, current, mp);
    }

    public static String getMutexMessage(Context ctx, MutexParameter current, MutexParameter mp) {
        Object[] params = new Object[]{current.getActionName(), mp.getActionName()};
        if (ctx != null) {
            return ResourceBase.getString((String)RES, (String)"GL_MutexMessage", (Locale)ctx.getLocale(), (Object[])params);
        }
        return EASResource.getString((String)RES, (String)"GL_MutexMessage", (Object[])params);
    }

    public static MutexParameter buildModifyBalanceParameter(Context ctx, String companyId, String userId, String actionResName) {
        return GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId, actionResName, null);
    }

    public static MutexParameter buildModifyBalanceParameter(Context ctx, String companyId, String userId, String actionResName, String actionDetail) {
        return GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId, actionResName, actionDetail, MutexLockType.EXCLUSIVE_LOCK);
    }

    public static MutexParameter buildModifyBalanceParameter(Context ctx, String companyId, String userId, String actionResName, String actionDetail, MutexLockType type) {
        return GLMutexUtils.buildMutexParameter(ctx, companyId, userId, "gl_modifyBalance_" + companyId, actionResName, actionDetail, type, GLMutexUtils.getString(ctx, "GL_Modify_MutexDesc"));
    }

    public static MutexParameter buildMutexParameter(Context ctx, String orgUnitId, String userId, String mutexName, String actionResName, String actionDetail, MutexLockType type, String description) {
        MutexParameter mp = new MutexParameter();
        mp.setRequestId(Uuid.create());
        mp.setOrgUnitID(BOSUuid.read((String)orgUnitId));
        mp.setUserID(BOSUuid.read((String)userId));
        mp.setMutexName(mutexName);
        String actionName = GLMutexUtils.getString(ctx, actionResName);
        if (actionDetail != null && actionDetail.trim().length() > 0) {
            actionName = actionName + "[" + actionDetail.trim() + "]";
        }
        mp.setActionName(actionName);
        mp.setMutexLockType(type);
        String dcName = ctx.getAIS();
        if (dcName == null) {
            dcName = "";
        }
        mp.setDcName(dcName);
        mp.setDescription(description);
        return mp;
    }

    public static MutexParameter buildACVerifyParameter(Context ctx, String companyId, String userId, String actionResName) {
        return GLMutexUtils.buildMutexParameter(ctx, ctx.getAIS(), companyId, userId, GL_ML_ACVerify, actionResName, null, MutexLockType.EXCLUSIVE_LOCK, "GL_ACVerify_MutexDesc");
    }

    public static MutexParameter buildCFApplyParameter(Context ctx, String companyId, String userId, String actionResName) {
        return GLMutexUtils.buildMutexParameter(ctx, ctx.getAIS(), companyId, userId, "gl_mutexlock_applyCF", actionResName, null, MutexLockType.EXCLUSIVE_LOCK, "GL_ModifyCF_MutexDesc");
    }

    protected static MutexParameter buildMutexParameter(Context ctx, String dcName, String companyId, String userId, String mutexlock, String actionResName, String actionDetail, MutexLockType type, String descResName) {
        MutexParameter mp = new MutexParameter();
        Uuid requestId = Uuid.create();
        mp.setRequestId(requestId);
        mp.setMutexName(mutexlock + "_" + companyId);
        String actionName = GLMutexUtils.getString(ctx, actionResName);
        if (actionDetail != null && actionDetail.trim().length() > 0) {
            actionName = actionName + "[" + actionDetail.trim() + "]";
        }
        mp.setActionName(actionName);
        mp.setOrgUnitID(BOSUuid.read((String)companyId));
        mp.setUserID(BOSUuid.read((String)userId));
        mp.setMutexLockType(type);
        if (dcName == null) {
            dcName = "";
        }
        mp.setDcName(dcName);
        String description = GLMutexUtils.getString(ctx, descResName);
        mp.setDescription(description);
        return mp;
    }

    public static MutexParameter buildModifyMutexParameterForCheckNumber(Context ctx, String companyId, String periodId, String userId) {
        MutexParameter mp = new MutexParameter();
        Uuid requestId = Uuid.create();
        mp.setRequestId(requestId);
        mp.setMutexName("gl_mutexlock_checkVoucherNumber_" + companyId + "_" + periodId);
        mp.setActionName(GLMutexUtils.getString(ctx, "GL_CheckVoucherNumber"));
        mp.setOrgUnitID(BOSUuid.read((String)companyId));
        mp.setUserID(BOSUuid.read((String)userId));
        mp.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        String dcName = ctx.getAIS();
        if (dcName == null) {
            dcName = "";
        }
        mp.setDcName(dcName);
        String description = GLMutexUtils.getString(ctx, "GL_CheckVoucherNumber_MutexDesc");
        mp.setDescription(description);
        return mp;
    }

    public static Uuid setAcExclusiveMutex(Context ctx, String companyid, String detailKey, String actionResName, Logger logger) throws BOSException, EASBizException {
        MutexParameter mp = GLMutexUtils.buildModifyMutexParameter(ctx, ctx.getAIS(), companyid, detailKey, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), actionResName, MutexLockType.EXCLUSIVE_LOCK);
        IMutexServiceControl mutex = null;
        mutex = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLockSucceed = false;
        if (mp != null && !(isLockSucceed = mutex.requestMutex(mp))) {
            Map requestMaps = mutex.getMutexList();
            String actionName = null;
            if (requestMaps != null && requestMaps.size() > 0) {
                Iterator it = requestMaps.keySet().iterator();
                if (it.hasNext()) {
                    MutexParameter mp1 = (MutexParameter)requestMaps.get(it.next());
                    actionName = mp1.getActionName();
                    logger.error((Object)("\u7533\u8bf7\u4e92\u65a5\u5931\u8d25\uff0c\u5f53\u524d\u4e92\u65a5\u540d\u79f0 = " + actionName + " \r\n \u63cf\u8ff0->" + mp1.toString()));
                }
            } else {
                actionName = mp.getDescription();
            }
            throw new GLMutexException(GLMutexException.ISMUTEX, new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getName(), actionName});
        }
        return mp.getRequestId();
    }

    public static MutexParameter buildModifyMutexParameter(Context ctx, String dcName, String companyId, String detailKey, String userId, String actionKey, MutexLockType type) {
        MutexParameter mp = new MutexParameter();
        Uuid requestId = Uuid.create();
        mp.setRequestId(requestId);
        mp.setMutexName("gl_modify_mutexlock_" + companyId + "_" + detailKey);
        mp.setActionName(GLMutexUtils.getString(ctx, actionKey));
        mp.setOrgUnitID(BOSUuid.read((String)companyId));
        mp.setUserID(BOSUuid.read((String)userId));
        mp.setMutexLockType(type);
        if (dcName == null) {
            dcName = "";
        }
        mp.setDcName(dcName);
        String description = GLMutexUtils.getString(ctx, "GL_Verifiy_MutexDesc");
        mp.setDescription(description);
        return mp;
    }

    public static void releaseMutex(Context ctx, Uuid uuid) throws BOSException {
        IMutexServiceControl mutex = null;
        mutex = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutex.releaseMutex(uuid);
    }
}

