/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistInitFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.InitAccountBalanceFactory;
import com.kingdee.eas.fi.gl.InitAccountBalanceInfo;
import com.kingdee.eas.fi.gl.InitException;
import com.kingdee.eas.fi.gl.InitImportBase;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InitAccountBalanceImport
extends InitImportBase {
    private static final Logger logger = Logger.getLogger(InitAccountBalanceImport.class);
    private String accountid = null;
    private String companyid;
    private String actualAssistantHGInfoID = null;
    private String currecyID = null;
    private Map currencyMap = null;
    private int baseCurrencyPrecision = 4;
    private int reportCurrencyPrecision = 4;
    private int qtyScale = 0;
    private int rowNumber = 1;
    private CompanyOrgUnitInfo curCompany = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InitAccountBalanceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getType(), (Throwable)e);
        }
    }

    @Override
    public CompanyOrgUnitInfo getCompany(Context ctx, Hashtable hsData) throws UuidException, SQLException, Exception {
        Map pageParam = super.getContextMap();
        CompanyOrgUnitInfo unitInfo = null;
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        unitInfo = pageParam != null && pageParam.get("COMPANYID") != null ? companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(pageParam.get("COMPANYID").toString())) : ContextUtil.getCurrentFIUnit((Context)ctx);
        String orgUnitID = ((DataToken)hsData.get((Object)"FOrgUnitID")).data.toString();
        ObjectUuidPK pk = new ObjectUuidPK(unitInfo.getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        unitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
        if (!unitInfo.getNumber().equals(orgUnitID)) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1011_InitImportBase", (Locale)ctx.getLocale()));
        }
        return unitInfo;
    }

    @Override
    public void isCloseInit(Context ctx, AccountViewInfo account, boolean isCussent) throws Exception, BOSException {
        String cuid = null;
        Map pageParam = super.getContextMap();
        cuid = pageParam != null && pageParam.get("COMPANYID") != null ? pageParam.get("COMPANYID").toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        CompanyOrgUnitInfo curCompany = null;
        if (pageParam != null && pageParam.get("COMPANYID") != null) {
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            curCompany = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(pageParam.get("COMPANYID").toString()));
        } else {
            curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String accouttable = curCompany.getAccountTable().getId().toString();
        otherCtx.put("COMPANY", curCompany);
        otherCtx.put("CUID", cuid);
        otherCtx.put("accouttable", accouttable);
        String orgUnitId = curCompany.getId().toString();
        boolean isCloseInit = GLFlagFactory.getLocalInstance(ctx).getGLInitClosed(orgUnitId);
        if (isCloseInit) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1012_InitImportBase", (Locale)ctx.getLocale()));
        }
    }

    @Override
    public AccountViewInfo getAccount(Context ctx, CurrencyInfo currency, Hashtable hsData, boolean isCussent) throws Exception, SQLException {
        AccountViewInfo account = new AccountViewInfo();
        String accountID = ((DataToken)hsData.get((Object)"FAccountID")).data.toString();
        CompanyOrgUnitInfo unitInfo = null;
        Map pageParam = super.getContextMap();
        if (pageParam != null && pageParam.get("COMPANYID") != null) {
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            unitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(pageParam.get("COMPANYID").toString()));
        } else {
            unitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String sqlToGetAccount = "select top 1 fid,fcaa,fac,facctcurrency,fisQty,flongnumber,FISCFREEZE,FAccountTypeID from T_BD_ACCOUNTVIEW where fisleaf=1  and fnumber=? and Fcompanyid=? and faccounttableid=?";
        IRowSet rsToGetAccount = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccount, (Object[])new Object[]{accountID, unitInfo.getId().toString(), unitInfo.getAccountTable().getId().toString()});
        if (rsToGetAccount != null && rsToGetAccount.next()) {
            String acctCurrSql;
            IRowSet rs;
            if (rsToGetAccount.getInt("facctcurrency") == 0 && !currency.getId().equals((Object)unitInfo.getBaseCurrency().getId())) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1013_InitImportBase", (Locale)ctx.getLocale()));
            }
            if (rsToGetAccount.getInt("facctcurrency") == 1 && !(rs = DbUtil.executeQuery((Context)ctx, (String)(acctCurrSql = "select fid from T_BD_AccountCurrency where FACCOUNTVIEWID = ? and FCURRENCYID =?"), (Object[])new Object[]{rsToGetAccount.getString("fid"), currency.getId().toString()})).next()) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1077_CurrencyVaild", (Locale)ctx.getLocale(), (Object[])new Object[]{accountID, currency.getNumber()}));
            }
            account.setId(BOSUuid.read((String)rsToGetAccount.getString("fid")));
            account.setAC(rsToGetAccount.getBoolean("fac"));
            account.setIsQty(rsToGetAccount.getBoolean("fisQty"));
            account.setLongNumber(rsToGetAccount.getString("flongnumber"));
            account.setNumber(accountID);
            account.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)rsToGetAccount.getInt("facctcurrency")));
            account.setIsCFreeze(rsToGetAccount.getBoolean("FISCFREEZE"));
            String accountTypeId = rsToGetAccount.getString("FAccountTypeID");
            if (accountTypeId != null) {
                AccountTypeInfo accountType = AccountTypeFactory.getLocalInstance((Context)ctx).getAccountTypeInfo((IObjectPK)new ObjectUuidPK(accountTypeId));
                account.setAccountTypeID(accountType);
            }
        } else {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1014_InitImportBase", (Locale)ctx.getLocale()));
        }
        this.isCloseInit(ctx, account, isCussent);
        return account;
    }

    @Override
    public Object[] getExchangeRate(Context ctx, String orgCurId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curCompany = null;
        Map pageParam = super.getContextMap();
        curCompany = pageParam != null && pageParam.get("COMPANYID") != null ? InitHelp.getCurrentCompany(ctx, pageParam.get("COMPANYID").toString()) : InitHelp.getCurrentCompany(ctx, ctx.get((Object)"CurCompanyId").toString());
        CurrencyInfo reportCur = curCompany.getReportCurrency();
        CurrencyInfo localCur = curCompany.getBaseCurrency();
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        AccountTableInfo accouttable = curCompany.getAccountTable();
        String cuid = curCompany.getCU().getId().toString();
        otherCtx.put("COMPANY", curCompany);
        otherCtx.put("CUID", cuid);
        otherCtx.put("ACCOUNTTABLEID", accouttable.getId().toString());
        LowTimer low = new LowTimer();
        low.reset();
        ArrayList al = AssistInitFacadeFactory.getLocalInstance(ctx).findInitData(otherCtx);
        int index = 0;
        ++index;
        int n = ++index;
        ++index;
        Boolean b = (Boolean)al.get(n);
        boolean isUsingReport = b;
        int n2 = ++index;
        ++index;
        PeriodInfo startPeriod = (PeriodInfo)al.get(n2);
        if (curCompany.getBaseExchangeTable() == null) {
            throw new GLException(GLException.NOLOCALEXTABLE);
        }
        Object[] exes = new Object[2];
        exes[0] = GlUtils.getLocalCurrencyExchangeRate(ctx, orgCurId, curCompany, startPeriod, startPeriod.getEndDate());
        if (isUsingReport) {
            boolean isSettleByLocal = 3 == curCompany.getReportConvertMode().getValue();
            exes[1] = isSettleByLocal ? GlUtils.getRptCurrencyExchangeRate(ctx, localCur.getId().toString(), curCompany, startPeriod, startPeriod.getEndDate()) : GlUtils.getRptCurrencyExchangeRate(ctx, orgCurId, curCompany, startPeriod, startPeriod.getEndDate());
        }
        return exes;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        InitAccountBalanceInfo infos = new InitAccountBalanceInfo();
        infos.setFromExcel(true);
        try {
            int precision;
            BigDecimal amt;
            BigDecimal qty;
            boolean isSettleByLocal;
            CompanyOrgUnitInfo companyInfo = this.getCompany(ctx, hsData);
            this.companyid = companyInfo.getId().toString();
            ctx.remove((Object)"COMPANY");
            ctx.put((Object)"COMPANY", (Object)companyInfo);
            infos.setOrgUnit(companyInfo);
            CurrencyInfo currency = super.getCurrency(ctx, hsData);
            this.currecyID = currency.getId().toString();
            infos.setCurrency(currency);
            AccountViewInfo account = this.getAccount(ctx, currency, hsData, false);
            if (account.isIsCFreeze()) {
                throw new InitException(InitException.ACCOUNT_FREEZE, new Object[]{account.getNumber()});
            }
            this.accountid = account.getId().toString();
            infos.setAccount(account);
            PeriodInfo periodInfo = GlUtils.getStartPeriod(ctx, this.companyid);
            Object[] exes = this.getExchangeRate(ctx, this.currecyID);
            VoucherInfo.ExchangeRateWithValue lex = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            VoucherInfo.ExchangeRateWithValue rex = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            if (exes != null) {
                if (exes[0] != null) {
                    lex = (VoucherInfo.ExchangeRateWithValue)exes[0];
                }
                if (exes[1] != null) {
                    rex = (VoucherInfo.ExchangeRateWithValue)exes[1];
                }
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearDebitFor")).data)) {
                infos.setYearDebitFor(this.getValue(hsData.get("FYearDebitFor")));
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearDebitLocal")).data)) {
                infos.setYearDebitLocal(this.getValue(hsData.get("FYearDebitLocal")));
            } else if (infos.getYearDebitFor() != null) {
                BigDecimal yearDebitLocal = lex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getYearDebitFor().multiply(lex.getValue()) : infos.getYearDebitFor().divide(lex.getValue());
                infos.setYearDebitLocal(yearDebitLocal);
            }
            Map pageParam = super.getContextMap();
            boolean bl = isSettleByLocal = 3 == companyInfo.getReportConvertMode().getValue();
            if (pageParam == null || pageParam.get("G001") == null || Boolean.parseBoolean(pageParam.get("G001").toString())) {
                if (this.CheckString(((DataToken)hsData.get((Object)"FYearDebitRpt")).data)) {
                    infos.setYearDebitRpt(this.getValue(hsData.get("FYearDebitRpt")));
                } else {
                    BigDecimal yearDebitRpt = null;
                    if (isSettleByLocal) {
                        if (infos.getYearDebitLocal() != null) {
                            yearDebitRpt = rex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getYearDebitLocal().multiply(rex.getValue()) : infos.getYearDebitLocal().divide(rex.getValue());
                        }
                    } else if (infos.getYearDebitFor() != null) {
                        yearDebitRpt = rex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getYearDebitFor().multiply(rex.getValue()) : infos.getYearDebitFor().divide(rex.getValue());
                    }
                    if (yearDebitRpt != null) {
                        infos.setYearDebitRpt(yearDebitRpt);
                    }
                }
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FYearDebitQty")).data)) {
                qty = this.getValue(hsData.get("FYearDebitQty"));
                infos.setYearDebitQty(qty);
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FYearCreditQty")).data)) {
                qty = this.getValue(hsData.get("FYearCreditQty"));
                infos.setYearCreditQty(qty);
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearCreditFor")).data)) {
                infos.setYearCreditFor(this.getValue(hsData.get("FYearCreditFor")));
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearCreditLocal")).data)) {
                infos.setYearCreditLocal(this.getValue(hsData.get("FYearCreditLocal")));
            } else if (infos.getYearCreditFor() != null) {
                BigDecimal yearCreditLocal = lex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getYearCreditFor().multiply(lex.getValue()) : infos.getYearCreditFor().divide(lex.getValue());
                infos.setYearCreditLocal(yearCreditLocal);
            }
            if (pageParam == null || pageParam.get("G001") == null || Boolean.parseBoolean(pageParam.get("G001").toString())) {
                if (this.CheckString(((DataToken)hsData.get((Object)"FYearCreditRpt")).data)) {
                    infos.setYearCreditRpt(this.getValue(hsData.get("FYearCreditRpt")));
                } else {
                    BigDecimal yearCreditRpt = null;
                    if (isSettleByLocal) {
                        if (infos.getYearCreditLocal() != null) {
                            yearCreditRpt = rex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getYearCreditLocal().multiply(rex.getValue()) : infos.getYearCreditLocal().divide(rex.getValue());
                        }
                    } else if (infos.getYearCreditFor() != null) {
                        yearCreditRpt = rex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getYearCreditFor().multiply(rex.getValue()) : infos.getYearCreditFor().divide(rex.getValue());
                    }
                    if (yearCreditRpt != null) {
                        infos.setYearCreditRpt(yearCreditRpt);
                    }
                }
            }
            if (account.getAccountTypeID() != null && account.getAccountTypeID().getProperty().equals((Object)AccountProperty.SUNYI) && this.CheckString(((DataToken)hsData.get((Object)"FYearPnLFor")).data)) {
                infos.setYearPnLFor(this.getValue(hsData.get("FYearPnLFor")));
            }
            if (account.getAccountTypeID() != null && account.getAccountTypeID().getProperty().equals((Object)AccountProperty.SUNYI) && this.CheckString(((DataToken)hsData.get((Object)"FYearPnLLocal")).data)) {
                infos.setYearPnLLocal(this.getValue(hsData.get("FYearPnLLocal")));
            } else if (infos.getYearPnLFor() != null) {
                BigDecimal yearPnLLocal = lex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getYearPnLFor().multiply(lex.getValue()) : infos.getYearPnLFor().divide(lex.getValue());
                infos.setYearPnLLocal(yearPnLLocal);
            }
            if (pageParam == null || pageParam.get("G001") == null || Boolean.parseBoolean(pageParam.get("G001").toString())) {
                if (this.CheckString(((DataToken)hsData.get((Object)"FYearPnLRpt")).data)) {
                    infos.setYearPnLRpt(this.getValue(hsData.get("FYearPnLRpt")));
                } else {
                    BigDecimal yearPnLRpt = null;
                    if (isSettleByLocal) {
                        if (infos.getYearPnLLocal() != null) {
                            yearPnLRpt = rex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getYearPnLLocal().multiply(rex.getValue()) : infos.getYearPnLLocal().divide(rex.getValue());
                        }
                    } else if (infos.getYearPnLFor() != null) {
                        yearPnLRpt = rex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getYearPnLFor().multiply(rex.getValue()) : infos.getYearPnLFor().divide(rex.getValue());
                    }
                    if (yearPnLRpt != null) {
                        infos.setYearPnLRpt(yearPnLRpt);
                    }
                }
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FBeginQty")).data)) {
                infos.setEndQty(this.getValue(hsData.get("FBeginQty")));
                qty = this.getValue(hsData.get("FBeginQty"));
                infos.setBeginQty(qty);
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceFor")).data)) {
                infos.setBeginBalanceFor(this.getValue(hsData.get("FBeginBalanceFor")));
                infos.setEndBalanceFor(this.getValue(hsData.get("FBeginBalanceFor")));
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceLocal")).data)) {
                infos.setBeginBalanceLocal(this.getValue(hsData.get("FBeginBalanceLocal")));
                infos.setEndBalanceLocal(this.getValue(hsData.get("FBeginBalanceLocal")));
            } else if (infos.getBeginBalanceFor() != null) {
                BigDecimal balanceFor = lex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getBeginBalanceFor().multiply(lex.getValue()) : infos.getBeginBalanceFor().divide(lex.getValue());
                infos.setBeginBalanceLocal(balanceFor);
                infos.setEndBalanceLocal(balanceFor);
            }
            if (pageParam == null || pageParam.get("G001") == null || Boolean.parseBoolean(pageParam.get("G001").toString())) {
                if (this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceRpt")).data)) {
                    infos.setBeginBalanceRpt(this.getValue(hsData.get("FBeginBalanceRpt")));
                    infos.setEndBalanceRpt(this.getValue(hsData.get("FBeginBalanceRpt")));
                } else {
                    BigDecimal balanceRpt = null;
                    if (isSettleByLocal) {
                        if (infos.getBeginBalanceLocal() != null) {
                            balanceRpt = rex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getBeginBalanceLocal().multiply(rex.getValue()) : infos.getBeginBalanceLocal().divide(rex.getValue());
                        }
                    } else if (infos.getBeginBalanceFor() != null) {
                        balanceRpt = rex.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? infos.getBeginBalanceFor().multiply(rex.getValue()) : infos.getBeginBalanceFor().divide(rex.getValue());
                    }
                    if (balanceRpt != null) {
                        infos.setBeginBalanceRpt(balanceRpt);
                        infos.setEndBalanceRpt(balanceRpt);
                    }
                }
            }
            if (periodInfo.getPeriodNumber() == 1) {
                infos.setYearCreditFor(BigDecimal.ZERO);
                infos.setYearCreditLocal(BigDecimal.ZERO);
                infos.setYearCreditQty(BigDecimal.ZERO);
                infos.setYearCreditRpt(BigDecimal.ZERO);
                infos.setYearDebitFor(BigDecimal.ZERO);
                infos.setYearDebitLocal(BigDecimal.ZERO);
                infos.setYearDebitQty(BigDecimal.ZERO);
                infos.setYearDebitRpt(BigDecimal.ZERO);
                infos.setYearPnLFor(BigDecimal.ZERO);
                infos.setYearPnLLocal(BigDecimal.ZERO);
                infos.setYearPnLRpt(BigDecimal.ZERO);
            }
            if (infos.getYearDebitFor() != null) {
                amt = infos.getYearDebitFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearDebitFor(amt);
            }
            if (infos.getYearDebitLocal() != null) {
                amt = infos.getYearDebitLocal();
                amt = amt.setScale(companyInfo.getBaseCurrency().getPrecision(), 4);
                infos.setYearDebitLocal(amt);
            }
            if (infos.getYearDebitRpt() != null) {
                amt = infos.getYearDebitRpt();
                precision = companyInfo.getBaseCurrency().getPrecision();
                if (companyInfo.getReportCurrency() != null) {
                    precision = companyInfo.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearDebitRpt(amt);
            }
            if (infos.getYearCreditFor() != null) {
                amt = infos.getYearCreditFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearCreditFor(amt);
            }
            if (infos.getYearCreditLocal() != null) {
                amt = infos.getYearCreditLocal();
                amt = amt.setScale(companyInfo.getBaseCurrency().getPrecision(), 4);
                infos.setYearCreditLocal(amt);
            }
            if (infos.getYearCreditRpt() != null) {
                amt = infos.getYearCreditRpt();
                precision = companyInfo.getBaseCurrency().getPrecision();
                if (companyInfo.getReportCurrency() != null) {
                    precision = companyInfo.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearCreditRpt(amt);
            }
            if (infos.getBeginBalanceFor() != null) {
                amt = infos.getBeginBalanceFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setBeginBalanceFor(amt);
            }
            if (infos.getBeginBalanceLocal() != null) {
                amt = infos.getBeginBalanceLocal();
                amt = amt.setScale(companyInfo.getBaseCurrency().getPrecision(), 4);
                infos.setBeginBalanceLocal(amt);
            }
            if (infos.getBeginBalanceRpt() != null) {
                amt = infos.getBeginBalanceRpt();
                precision = companyInfo.getBaseCurrency().getPrecision();
                if (companyInfo.getReportCurrency() != null) {
                    precision = companyInfo.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setBeginBalanceRpt(amt);
            }
            if (infos.getYearPnLFor() != null) {
                amt = infos.getYearPnLFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearPnLFor(amt);
            }
            if (infos.getYearPnLLocal() != null) {
                amt = infos.getYearPnLLocal();
                amt = amt.setScale(companyInfo.getBaseCurrency().getPrecision(), 4);
                infos.setYearPnLLocal(amt);
            }
            if (infos.getYearPnLRpt() != null) {
                amt = infos.getYearPnLRpt();
                precision = companyInfo.getBaseCurrency().getPrecision();
                if (companyInfo.getReportCurrency() != null) {
                    precision = companyInfo.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearPnLRpt(amt);
            }
            if (!this.isSltImportUpdate()) {
                StringBuffer sqls = new StringBuffer();
                sqls.append("select fBeginBalanceFor, fBeginBalanceLocal, fBeginBalanceRpt, fBeginQty, ");
                sqls.append("fCreditFor, fCreditLocal, fCreditQty, fCreditRpt, ");
                sqls.append("fDebitFor, fDebitLocal, fDebitQty, fDebitRpt, ");
                sqls.append("fEndBalanceFor, fEndBalanceLocal, fEndBalanceRpt, fEndQty, ");
                sqls.append("fMonthPnLFor, fMonthPnLLocal, fMonthPnLRpt, fYearCreditFor, ");
                sqls.append("fYearCreditLocal, fYearCreditQty, fYearCreditRpt, fYearDebitFor, ");
                sqls.append("fYearDebitLocal, fYearDebitQty, fYearDebitRpt, fYearPnLFor, ");
                sqls.append("fYearPnLLocal, fYearPnLRpt ");
                sqls.append(" from t_gl_initaccountbalance a where a.faccountid = ? and a.fcurrencyid = ? ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqls.toString(), (Object[])new Object[]{this.accountid, this.currecyID});
                if (rs != null && rs.size() > 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1044_InitAccountBalanceImport", (Locale)ctx.getLocale()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return infos;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.curCompany.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)"11111111-1111-1111-1111-111111111111DEB58FDC", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)"22222222-2222-2222-2222-222222222222DEB58FDC", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("account.isLeaf", (Object)"1", CompareType.EQUALS));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        this.curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        return "com.kingdee.eas.fi.gl.app.acBalanceInitBalanceExportQuery";
    }

    private void getCurrencyPrecision(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo;
        Map paramMap = this.getContextMap();
        this.currencyMap = new HashMap();
        String orgId = (String)paramMap.get("orgunit.id");
        if (StringUtils.isEmpty((String)orgId)) {
            orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        this.baseCurrencyPrecision = (companyInfo = GlUtils.getCompanyById(ctx, orgId)).getBaseCurrency() == null ? 4 : companyInfo.getBaseCurrency().getPrecision();
        this.reportCurrencyPrecision = companyInfo.getReportCurrency() == null ? 4 : companyInfo.getReportCurrency().getPrecision();
        HashMap<String, String> glparam = new HashMap<String, String>();
        glparam.put("GL_002", orgId);
        IParamControl pc = null;
        pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmParam = pc.getParamHashMap(glparam);
        this.qtyScale = hmParam.get("GL_002") == null ? 0 : Integer.parseInt(hmParam.get("GL_002").toString());
        CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select id, precision ");
        for (CurrencyInfo currencyInfo : currencyColl) {
            this.currencyMap.put(currencyInfo.getId().toString(), currencyInfo.getPrecision());
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            this.getCurrencyPrecision(ctx);
            String currencyId = rs.getString("currency.id");
            int currencyPre = this.currencyMap.get(currencyId) == null ? 2 : Integer.parseInt(this.currencyMap.get(currencyId).toString());
            result.put("FOrgUnitID", this.curCompany.getNumber());
            result.put("FAccountID", rs.getString("account.number"));
            result.put("Fcurrency", rs.getString("currency.number"));
            result.put("FYearDebitQty", rs.getBigDecimal("yearDebitQty").setScale(this.qtyScale, 4));
            result.put("FYearDebitFor", rs.getBigDecimal("yearDebitFor").setScale(currencyPre, 4));
            result.put("FYearDebitLocal", rs.getBigDecimal("yearDebitLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearDebitRpt", rs.getBigDecimal("yearDebitRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FYearCreditQty", rs.getBigDecimal("yearCreditQty").setScale(this.qtyScale, 4));
            result.put("FYearCreditFor", rs.getBigDecimal("yearCreditFor").setScale(currencyPre, 4));
            result.put("FYearCreditLocal", rs.getBigDecimal("yearCreditLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearCreditRpt", rs.getBigDecimal("yearCreditRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FBeginQty", rs.getBigDecimal("beginQty").setScale(this.qtyScale, 4));
            result.put("FBeginBalanceFor", rs.getBigDecimal("beginBalanceFor").setScale(currencyPre, 4));
            result.put("FBeginBalanceLocal", rs.getBigDecimal("beginBalanceLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FBeginBalanceRpt", rs.getBigDecimal("beginBalanceRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FYearPnLFor", rs.getBigDecimal("yearPnLFor").setScale(currencyPre, 4));
            result.put("FYearPnLLocal", rs.getBigDecimal("yearPnLLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearPnLRpt", rs.getBigDecimal("yearPnLRpt").setScale(this.reportCurrencyPrecision, 4));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected String getType() {
        return "InitAccountBalance";
    }
}

