/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.eas.fi.gl.TemplateVoucherIOSparser;
import com.kingdee.eas.fi.gl.VoucherExpImpException;
import com.kingdee.eas.fi.gl.VoucherIOSparser;
import org.apache.log4j.Logger;

public class SparserFactory {
    private static final Logger logger = Logger.getLogger(SparserFactory.class);
    public static final String SPARSER = "com.kingdee.eas.fi.gl.Voucher";
    public static final String TEMPSPARSER = "com.kingdee.eas.fi.gl.TemplateVoucher";

    public static VoucherIOSparser getSparserInstance(String extension) throws VoucherExpImpException {
        Object sparser = null;
        String jdkVersion = System.getProperty("java.version");
        String type = extension.toUpperCase();
        if ("DBF".equalsIgnoreCase(type) && jdkVersion != null && jdkVersion.contains("1.8.")) {
            type = type + "New";
        }
        String clsName = SPARSER + type + "Sparser";
        try {
            sparser = Class.forName(clsName).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new VoucherExpImpException(VoucherExpImpException.FILE_SPARSER_NOTCORRECT, e);
        }
        return sparser;
    }

    public static TemplateVoucherIOSparser getTempSparserInstance(String extension) throws VoucherExpImpException {
        Object sparser = null;
        String jdkVersion = System.getProperty("java.version");
        String type = extension.toUpperCase();
        if ("DBF".equalsIgnoreCase(type) && jdkVersion != null && jdkVersion.contains("1.8.")) {
            type = type + "New";
        }
        String clsName = TEMPSPARSER + type + "Sparser";
        try {
            sparser = Class.forName(clsName).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new VoucherExpImpException(VoucherExpImpException.FILE_SPARSER_NOTCORRECT, e);
        }
        return sparser;
    }
}

