/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgBizChecker;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import org.apache.log4j.Logger;

public class VoucherChecker
implements IOrgBizChecker {
    private static final Logger logger = Logger.getLogger(VoucherChecker.class);

    public void checkBizClear(Context ctx, FullOrgUnitInfo unit, OrgType type) throws EASBizException {
        if (unit != null && type.getValue() == 1) {
            try {
                VoucherCollection col;
                IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)VoucherStatusEnum.CANCELLED, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)VoucherStatusEnum.TEMP, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)unit.getId().toString()));
                PeriodInfo curPeriod = null;
                try {
                    curPeriod = GlUtils.getCurrentPeriod(ctx, unit.getId().toString());
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                if (curPeriod != null) {
                    filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)curPeriod.getId().toString()));
                }
                if ((col = voucher.getVoucherCollection(view)) != null && col.size() > 0) {
                    throw new VoucherException(VoucherException.BIZNOTENDED);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }

    public void bizUpdateWhenBizParentChanged(Context ctx, String unitID, String oldBizParentID, String newBizParentID, OrgType orgType) throws EASBizException {
    }
}

