/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountFacade;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FeeTypeEnum;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GLTaskLogger;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAssistCustomizedProperty;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherConverter {
    protected static final Logger logger = CoreUIObject.getLogger(VoucherConverter.class);
    private GLTaskLogger taskLogger = null;
    private final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private Map<String, AccountViewInfo> accounts = new HashMap<String, AccountViewInfo>();
    private Map<String, CurrencyInfo> currencys = new HashMap<String, CurrencyInfo>();
    private Map<String, ProfitCenterOrgUnitInfo> profitCenters = new HashMap<String, ProfitCenterOrgUnitInfo>();
    private Map<String, MeasureUnitInfo> measureUnits = new HashMap<String, MeasureUnitInfo>();
    private Map<String, AsstAccountInfo> caas = new HashMap<String, AsstAccountInfo>();
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
    private Map<String, AssistantHGInfo> hgs = new HashMap<String, AssistantHGInfo>();
    private Map<String, Map<String, Object>> asstActss = new HashMap<String, Map<String, Object>>();
    private Map<String, Set<String>> customizedPropertyss = new HashMap<String, Set<String>>();
    private Map<String, SettlementTypeInfo> settlementTypes = new HashMap<String, SettlementTypeInfo>();
    private Map<String, CustomerInfo> customers = new HashMap<String, CustomerInfo>();
    private Map<String, SupplierInfo> suppliers = new HashMap<String, SupplierInfo>();
    private Map<String, CompanyOrgUnitInfo> orgUnits = new HashMap<String, CompanyOrgUnitInfo>();
    private Map<String, MaterialInfo> materials = new HashMap<String, MaterialInfo>();
    private Locale locale;
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public VoucherConverter(Locale locale) {
        this.locale = locale;
    }

    public String getResource(String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)this.locale);
    }

    public String toJSON(Context ctx, VoucherInfo voucher) throws BOSException {
        Map<String, Object> map = this.toMap(ctx, voucher);
        return JSON.toJSONString(map);
    }

    public String toJSON(Context ctx, VoucherEntryCollection entries, VoucherInfo voucher) throws BOSException {
        List<Map> list = this.toList(ctx, entries, voucher);
        return JSON.toJSONString(list);
    }

    public String toJSON(Context ctx, VoucherAssistRecordCollection records, VoucherEntryInfo entry, VoucherInfo voucher) throws BOSException {
        List list = this.toList(ctx, records, entry, voucher);
        return JSON.toJSONString((Object)list);
    }

    protected Map<String, Object> toMap(Context ctx, VoucherInfo voucher) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (voucher == null) {
            return map;
        }
        if (voucher.getId() != null) {
            map.put("id", voucher.getId().toString());
        }
        if (voucher.getNumber() != null) {
            map.put("number", voucher.getNumber());
        }
        if (voucher.getBizDate() != null) {
            map.put("bizDate", this.DATE_FORMAT.format(voucher.getBizDate()));
        }
        if (voucher.getBookedDate() != null) {
            map.put("bookedDate", this.DATE_FORMAT.format(voucher.getBookedDate()));
        }
        map.put("entries", this.toList(ctx, voucher.getEntries(), voucher));
        return map;
    }

    protected List<Map> toList(Context ctx, VoucherEntryCollection entries, VoucherInfo voucher) throws BOSException {
        ProfitCenterOrgUnitCollection coll;
        SelectorItemCollection selector;
        FilterInfo filter;
        Object view;
        if (entries == null) {
            return new ArrayList<Map>();
        }
        HashSet<String> profitCenterIds = new HashSet<String>();
        HashSet<String> accountIds = new HashSet<String>();
        HashSet<String> currencyIds = new HashSet<String>();
        HashSet<String> measureUnitIds = new HashSet<String>();
        HashMap hgIdss = new HashMap();
        HashSet<String> settlementTypeIds = new HashSet<String>();
        HashSet<String> customerIds = new HashSet<String>();
        HashSet<String> supplierIds = new HashSet<String>();
        HashSet<String> orgUnitIds = new HashSet<String>();
        HashSet<String> materialIds = new HashSet<String>();
        for (VoucherEntryInfo entry : entries) {
            String id;
            if (entry.getProfitCenter() != null && !this.profitCenters.containsKey(id = entry.getProfitCenter().getId().toString())) {
                if (entry.getProfitCenter().getNumber() != null) {
                    this.profitCenters.put(id, entry.getProfitCenter());
                } else {
                    profitCenterIds.add(id);
                }
            }
            if (entry.getAccount() != null && !this.accounts.containsKey(id = entry.getAccount().getId().toString())) {
                if (entry.getAccount().getNumber() != null) {
                    this.accounts.put(id, entry.getAccount());
                } else {
                    accountIds.add(id);
                }
            }
            if (entry.getCurrency() != null && !this.currencys.containsKey(id = entry.getCurrency().getId().toString())) {
                if (entry.getCurrency().getNumber() != null) {
                    this.currencys.put(id, entry.getCurrency());
                } else {
                    currencyIds.add(id);
                }
            }
            if (entry.getMeasureUnit() != null && !this.measureUnits.containsKey(id = entry.getMeasureUnit().getId().toString())) {
                if (entry.getMeasureUnit().getNumber() != null) {
                    this.measureUnits.put(id, entry.getMeasureUnit());
                } else {
                    measureUnitIds.add(id);
                }
            }
            if (entry.getCustomer() != null && !this.customers.containsKey(id = entry.getCustomer().getId().toString())) {
                if (entry.getCustomer().getNumber() != null) {
                    this.customers.put(id, entry.getCustomer());
                } else {
                    customerIds.add(id);
                }
            }
            if (entry.getAssistRecords() == null || entry.getAssistRecords().size() <= 0) continue;
            AsstActTypeCollection aats = null;
            HashSet<String> hgIds = null;
            if (entry.getCAA() != null && entry.getCAA().getId() != null) {
                String caaId = entry.getCAA().getId().toString();
                aats = this.getAsstActTypes(ctx, caaId);
                hgIds = (HashSet<String>)hgIdss.get(caaId);
                if (hgIds == null) {
                    hgIds = new HashSet<String>();
                    hgIdss.put(caaId, hgIds);
                }
            }
            for (VoucherAssistRecordInfo record : entry.getAssistRecords()) {
                String id2;
                String hgId;
                if (record.getAssGrp() != null && hgIds != null && aats != null && !this.hgs.containsKey(hgId = record.getAssGrp().getId().toString())) {
                    boolean found = false;
                    for (int i = 0; i < aats.size(); ++i) {
                        if (record.getAssGrp().get(aats.get(i).getAsstHGAttribute()) == null) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        this.hgs.put(hgId, record.getAssGrp());
                    } else {
                        hgIds.add(hgId);
                    }
                }
                if (record.getMeasureUnit() != null && !this.measureUnits.containsKey(id2 = record.getMeasureUnit().getId().toString())) {
                    if (record.getMeasureUnit().getNumber() != null) {
                        this.measureUnits.put(id2, record.getMeasureUnit());
                    } else {
                        measureUnitIds.add(id2);
                    }
                }
                if (record.getSettlementType() != null && !this.settlementTypes.containsKey(id2 = record.getSettlementType().getId().toString())) {
                    if (record.getSettlementType().getNumber() != null) {
                        this.settlementTypes.put(id2, record.getSettlementType());
                    } else {
                        settlementTypeIds.add(id2);
                    }
                }
                if (record.getCustomer() != null && !this.customers.containsKey(id2 = record.getCustomer().getId().toString())) {
                    if (record.getCustomer().getNumber() != null) {
                        this.customers.put(id2, record.getCustomer());
                    } else {
                        customerIds.add(id2);
                    }
                }
                if (record.getSupplier() != null && !this.suppliers.containsKey(id2 = record.getSupplier().getId().toString())) {
                    if (record.getSupplier().getNumber() != null) {
                        this.suppliers.put(id2, record.getSupplier());
                    } else {
                        supplierIds.add(id2);
                    }
                }
                if (record.getOrgUnit() != null && !this.orgUnits.containsKey(id2 = record.getOrgUnit().getId().toString())) {
                    if (record.getOrgUnit().getNumber() != null) {
                        this.orgUnits.put(id2, record.getOrgUnit());
                    } else {
                        orgUnitIds.add(id2);
                    }
                }
                if (record.getMaterial() == null || this.materials.containsKey(id2 = record.getMaterial().getId().toString())) continue;
                if (record.getMaterial().getNumber() != null) {
                    this.materials.put(id2, record.getMaterial());
                    continue;
                }
                materialIds.add(id2);
            }
        }
        if (profitCenterIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", profitCenterIds, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = this.getProfitCenterSelector();
            view.setSelector(selector);
            IProfitCenterOrgUnit iProfitCenterOrgUnit = ctx != null ? ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx) : ProfitCenterOrgUnitFactory.getRemoteInstance();
            coll = iProfitCenterOrgUnit.getProfitCenterOrgUnitCollection((EntityViewInfo)view);
            for (ProfitCenterOrgUnitInfo info : coll) {
                this.profitCenters.put(info.getId().toString(), info);
            }
        }
        if (accountIds.size() > 0) {
            SelectorItemCollection selector2 = this.getAccountSelector();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", accountIds, CompareType.INCLUDE));
            EntityViewInfo view2 = new EntityViewInfo();
            view2.setSelector(selector2);
            view2.setFilter(filter);
            IAccountView iAccountView = ctx != null ? AccountViewFactory.getLocalInstance((Context)ctx) : AccountViewFactory.getRemoteInstance();
            coll = iAccountView.getAccountViewCollection(view2);
            for (AccountViewInfo account : coll) {
                this.accounts.put(account.getId().toString(), account);
            }
        }
        if (currencyIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", currencyIds, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = this.getCurrencySelector();
            view.setSelector(selector);
            ICurrency iCurrency = ctx != null ? CurrencyFactory.getLocalInstance((Context)ctx) : CurrencyFactory.getRemoteInstance();
            coll = iCurrency.getCurrencyCollection((EntityViewInfo)view);
            for (ProfitCenterOrgUnitInfo info : coll) {
                this.currencys.put(info.getId().toString(), (CurrencyInfo)info);
            }
        }
        if (measureUnitIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", measureUnitIds, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = this.getMeasureUnitSelector();
            view.setSelector(selector);
            IMeasureUnit iMeasureUnit = ctx != null ? MeasureUnitFactory.getLocalInstance((Context)ctx) : MeasureUnitFactory.getRemoteInstance();
            coll = iMeasureUnit.getMeasureUnitCollection((EntityViewInfo)view);
            for (ProfitCenterOrgUnitInfo info : coll) {
                this.measureUnits.put(info.getId().toString(), (MeasureUnitInfo)info);
            }
        }
        for (String caaId : hgIdss.keySet()) {
            Set hgIds = (Set)hgIdss.get(caaId);
            if (hgIds.size() == 0) continue;
            EntityViewInfo view3 = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("id", (Object)hgIds, CompareType.INCLUDE));
            view3.setFilter(filter2);
            SelectorItemCollection selector3 = new SelectorItemCollection();
            selector3.add("id");
            selector3.add("asstAccount.id");
            AsstActTypeCollection aats = this.getAsstActTypes(ctx, caaId);
            for (AsstActTypeInfo aat : aats) {
                String attribute = aat.getAsstHGAttribute();
                selector3.add(attribute + ".id");
                selector3.add(attribute + ".number");
                selector3.add(attribute + ".name");
                if (!aat.isUseLongNumber()) continue;
                selector3.add(attribute + ".longNumber");
            }
            view3.setSelector(selector3);
            IAssistantHG iAssistantHG = ctx != null ? AssistantHGFactory.getLocalInstance((Context)ctx) : AssistantHGFactory.getRemoteInstance();
            AssistantHGCollection coll2 = iAssistantHG.getAssistantHGCollection(view3);
            for (AssistantHGInfo info : coll2) {
                this.hgs.put(info.getId().toString(), info);
            }
        }
        if (settlementTypeIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", settlementTypeIds, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = this.getSettlementTypeSelector();
            view.setSelector(selector);
            ISettlementType iSettlementType = ctx != null ? SettlementTypeFactory.getLocalInstance((Context)ctx) : SettlementTypeFactory.getRemoteInstance();
            coll = iSettlementType.getSettlementTypeCollection((EntityViewInfo)view);
            for (ProfitCenterOrgUnitInfo info : coll) {
                this.settlementTypes.put(info.getId().toString(), (SettlementTypeInfo)info);
            }
        }
        if (customerIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", customerIds, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = this.getCustomerSelector();
            view.setSelector(selector);
            ICustomer iCustomer = ctx != null ? CustomerFactory.getLocalInstance((Context)ctx) : CustomerFactory.getRemoteInstance();
            coll = iCustomer.getCustomerCollection((EntityViewInfo)view);
            for (ProfitCenterOrgUnitInfo info : coll) {
                this.customers.put(info.getId().toString(), (CustomerInfo)info);
            }
        }
        if (supplierIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", supplierIds, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = this.getSupplierSelector();
            view.setSelector(selector);
            ISupplier iSupplier = ctx != null ? SupplierFactory.getLocalInstance((Context)ctx) : SupplierFactory.getRemoteInstance();
            coll = iSupplier.getSupplierCollection((EntityViewInfo)view);
            for (ProfitCenterOrgUnitInfo info : coll) {
                this.suppliers.put(info.getId().toString(), (SupplierInfo)info);
            }
        }
        if (orgUnitIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", orgUnitIds, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = this.getMaterialSelector();
            view.setSelector(selector);
            ICompanyOrgUnit iCompanyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
            coll = iCompanyOrgUnit.getCompanyOrgUnitCollection((EntityViewInfo)view);
            for (ProfitCenterOrgUnitInfo info : coll) {
                this.orgUnits.put(info.getId().toString(), (CompanyOrgUnitInfo)info);
            }
        }
        if (materialIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", materialIds, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = this.getMaterialSelector();
            view.setSelector(selector);
            IMaterial iMaterial = ctx != null ? MaterialFactory.getLocalInstance((Context)ctx) : MaterialFactory.getRemoteInstance();
            coll = iMaterial.getMaterialCollection((EntityViewInfo)view);
            for (ProfitCenterOrgUnitInfo info : coll) {
                this.materials.put(info.getId().toString(), (MaterialInfo)info);
            }
        }
        ArrayList<Map> list = new ArrayList<Map>(entries.size());
        for (VoucherEntryInfo entry : entries) {
            list.add(this.toMap(ctx, entry, voucher));
        }
        return list;
    }

    protected Map toMap(Context ctx, VoucherEntryInfo entry, VoucherInfo voucher) throws BOSException {
        CustomerInfo customer;
        MeasureUnitInfo measureUnit;
        CurrencyInfo currency;
        AccountViewInfo account;
        ProfitCenterOrgUnitInfo profitCenter;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", entry.getDescription());
        if (entry.getProfitCenter() != null && (profitCenter = this.profitCenters.get(entry.getProfitCenter().getId().toString())) != null && profitCenter.getNumber() != null) {
            map.put("profitCenterNumber", profitCenter.getNumber());
        }
        if (entry.getAccount() != null && (account = this.accounts.get(entry.getAccount().getId().toString())) != null && account.getNumber() != null) {
            map.put("accountNumber", account.getNumber());
        }
        if (entry.getCurrency() != null && (currency = this.currencys.get(entry.getCurrency().getId().toString())) != null && currency.getNumber() != null) {
            map.put("currencyNumber", currency.getNumber());
        }
        if (entry.getEntryDC() != null) {
            map.put("entryDC", entry.getEntryDC().getValue());
        }
        map.put("originalAmount", entry.getOriginalAmount() != null ? entry.getOriginalAmount() : GlUtils.pointzero);
        map.put("localAmount", entry.getLocalAmount() != null ? entry.getLocalAmount() : GlUtils.pointzero);
        map.put("reportingAmount", entry.getReportingAmount() != null ? entry.getReportingAmount() : GlUtils.pointzero);
        if (entry.getLocalExchangeRate() != null) {
            map.put("localExchangeRate", entry.getLocalExchangeRate());
        }
        if (entry.getReportingExchangeRate() != null) {
            map.put("reportingExchangeRate", entry.getReportingExchangeRate());
        }
        if (entry.getMeasureUnit() != null && (measureUnit = this.measureUnits.get(entry.getMeasureUnit().getId().toString())) != null && measureUnit.getNumber() != null) {
            map.put("measureUnitNumber", measureUnit.getNumber());
        }
        map.put("quantity", entry.getQuantity() != null ? entry.getQuantity() : GlUtils.pointzero);
        map.put("standardQuantity", entry.getStandardQuantity() != null ? entry.getStandardQuantity() : GlUtils.pointzero);
        map.put("price", entry.getPrice() != null ? entry.getPrice() : GlUtils.pointzero);
        if (entry.getCustomer() != null && (customer = this.customers.get(entry.getCustomer().getId().toString())) != null && customer.getNumber() != null) {
            map.put("customerNumber", customer.getNumber());
        }
        map.put("records", this.toList(ctx, entry.getAssistRecords(), entry, voucher));
        return map;
    }

    protected List toList(Context ctx, VoucherAssistRecordCollection records, VoucherEntryInfo entry, VoucherInfo voucher) throws BOSException {
        if (records == null) {
            return new ArrayList();
        }
        ArrayList<Map> list = new ArrayList<Map>(records.size());
        for (VoucherAssistRecordInfo record : records) {
            list.add(this.toMap(ctx, record, entry, voucher));
        }
        return list;
    }

    protected Map toMap(Context ctx, VoucherAssistRecordInfo record, VoucherEntryInfo entry, VoucherInfo voucher) throws BOSException {
        MaterialInfo material;
        OrgUnitInfo orgUnit;
        SupplierInfo supplier;
        CustomerInfo customer;
        SettlementTypeInfo settlementType;
        MeasureUnitInfo measureUnit;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (record.getBizDate() != null) {
            map.put("bizDate", this.DATE_FORMAT.format(record.getBizDate()));
        }
        if (record.getEndDate() != null) {
            map.put("endDate", this.DATE_FORMAT.format(record.getEndDate()));
        }
        map.put("description", record.getDescription());
        AsstAccountInfo asstAccount = entry.getCAA();
        if (asstAccount != null && asstAccount.getId() != null && record.getAssGrp() != null && record.getAssGrp().getId() != null) {
            AssistantHGInfo hg = this.hgs.get(record.getAssGrp().getId().toString());
            HashMap<String, String> assGrp = new HashMap<String, String>();
            if (hg != null) {
                AsstActTypeCollection aats = this.getAsstActTypes(ctx, asstAccount.getId().toString());
                for (AsstActTypeInfo aat : aats) {
                    String attribute = aat.getAsstHGAttribute();
                    DataBaseInfo db = (DataBaseInfo)hg.get(attribute);
                    if (db == null) continue;
                    if (aat.isUseLongNumber()) {
                        String longNumber = (String)db.get("longNumber");
                        if (longNumber == null) continue;
                        assGrp.put(attribute, longNumber.replace('!', '.'));
                        continue;
                    }
                    assGrp.put(attribute, db.getNumber());
                }
            }
            map.put("assGrp", assGrp);
        }
        if (record.getMeasureUnit() != null && (measureUnit = this.measureUnits.get(record.getMeasureUnit().getId().toString())) != null && measureUnit.getNumber() != null) {
            map.put("measureUnitNumber", measureUnit.getNumber());
        }
        map.put("quantity", record.getQuantity() != null ? record.getQuantity() : GlUtils.pointzero);
        map.put("standardQuantity", record.getStandardQuantity() != null ? record.getStandardQuantity() : GlUtils.pointzero);
        map.put("price", record.getPrice() != null ? record.getPrice() : GlUtils.pointzero);
        map.put("originalAmount", record.getOriginalAmount() != null ? record.getOriginalAmount() : GlUtils.pointzero);
        map.put("localAmount", record.getLocalAmount() != null ? record.getLocalAmount() : GlUtils.pointzero);
        map.put("reportingAmount", record.getReportingAmount() != null ? record.getReportingAmount() : GlUtils.pointzero);
        if (record.getSettlementType() != null && (settlementType = this.settlementTypes.get(record.getSettlementType().getId().toString())) != null && settlementType.getNumber() != null) {
            map.put("settlementTypeNumber", settlementType.getNumber());
        }
        if (record.getSettlementCode() != null) {
            map.put("settlementCode", record.getSettlementCode());
        }
        if (record.getBizNumber() != null) {
            map.put("bizNumber", record.getBizNumber());
        }
        if (record.getCustomer() != null && (customer = this.customers.get(record.getCustomer().getId().toString())) != null && customer.getNumber() != null) {
            map.put("customerNumber", customer.getNumber());
        }
        if (record.getSupplier() != null && (supplier = this.suppliers.get(record.getSupplier().getId().toString())) != null && supplier.getNumber() != null) {
            map.put("supplierNumber", supplier.getNumber());
        }
        if (record.getOrgUnit() != null && (orgUnit = (OrgUnitInfo)this.orgUnits.get(record.getOrgUnit().getId().toString())) != null && orgUnit.getNumber() != null) {
            map.put("orgUnitNumber", orgUnit.getNumber());
        }
        if (record.getMaterial() != null && (material = this.materials.get(record.getMaterial().getId().toString())) != null && material.getNumber() != null) {
            map.put("materialNumber", material.getNumber());
        }
        if (record.getTicketNumber() != null) {
            map.put("ticketNumber", record.getTicketNumber());
        }
        if (record.getInvoiceNumber() != null) {
            map.put("invoiceNumber", record.getInvoiceNumber());
        }
        if (record.getFeeType() != null) {
            map.put("feeType", record.getFeeType().getValue());
        }
        return map;
    }

    public VoucherInfo toVoucher(Context ctx, String voucherJson) throws EASBizException, BOSException {
        return null;
    }

    public VoucherEntryCollection toEntries(Context ctx, String entryJson, VoucherInfo voucher) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = voucher.getCompany();
        if (company == null || company.getId() == null || company.getAccountTable() == null || company.getAccountTable().getId() == null || voucher.getPeriod() == null || voucher.getPeriod().getId() == null || entryJson == null) {
            return new VoucherEntryCollection();
        }
        List listEntries = null;
        try {
            this.showInfo(this.getResource("json>java"));
            listEntries = (List)JSON.parseObject((String)entryJson, List.class);
        }
        catch (JSONException e) {
            this.showError(this.getResource("data_format_error"), e);
            return new VoucherEntryCollection();
        }
        return this.toEntries(ctx, listEntries, voucher);
    }

    public VoucherAssistRecordCollection toRecords(Context ctx, String recordJson, VoucherEntryInfo entry, VoucherInfo voucher) throws BOSException, EASBizException {
        List listRecords = null;
        try {
            listRecords = (List)JSON.parseObject((String)recordJson, List.class);
        }
        catch (JSONException e) {
            this.showError(this.getResource("data_format_error"), e);
            return new VoucherAssistRecordCollection();
        }
        VoucherInfo v = new VoucherInfo();
        v.putAll((IObjectValue)voucher);
        VoucherEntryCollection entries = new VoucherEntryCollection();
        entries.add(entry);
        v.setEntries((AbstractObjectCollection)entries);
        return this.toRecords(ctx, listRecords, entry, voucher);
    }

    protected VoucherEntryCollection toEntries(Context ctx, List listEntries, VoucherInfo voucher) throws EASBizException, BOSException {
        CurrencyCollection coll;
        Object view;
        FilterInfo filter;
        SelectorItemCollection selector;
        EntityViewInfo view2;
        VoucherEntryCollection entries = new VoucherEntryCollection();
        if (listEntries == null) {
            return entries;
        }
        this.showInfo(this.getResource("collect_objects"));
        CompanyOrgUnitInfo company = voucher.getCompany();
        for (VoucherEntryInfo entry : voucher.getEntries()) {
            AccountViewInfo info;
            if (entry.getAccount() != null && entry.getAccount().getNumber() != null && !this.accounts.containsKey((info = entry.getAccount()).getNumber())) {
                this.accounts.put(info.getNumber(), info);
            }
            if (entry.getCurrency() != null && entry.getCurrency().getNumber() != null && !this.currencys.containsKey((info = entry.getCurrency()).getNumber())) {
                this.currencys.put(info.getNumber(), (CurrencyInfo)info);
            }
            if (entry.getMeasureUnit() != null && entry.getMeasureUnit().getNumber() != null && !this.measureUnits.containsKey((info = entry.getMeasureUnit()).getNumber())) {
                this.measureUnits.put(info.getNumber(), (MeasureUnitInfo)info);
            }
            if (entry.getProfitCenter() != null && entry.getProfitCenter().getNumber() != null && !this.profitCenters.containsKey((info = entry.getProfitCenter()).getNumber())) {
                this.profitCenters.put(info.getNumber(), (ProfitCenterOrgUnitInfo)info);
            }
            if (entry.getAssistRecords() == null) continue;
            for (VoucherAssistRecordInfo record : entry.getAssistRecords()) {
                MeasureUnitInfo info2;
                if (record.getMeasureUnit() != null && record.getMeasureUnit().getNumber() != null && !this.measureUnits.containsKey((info2 = record.getMeasureUnit()).getNumber())) {
                    this.measureUnits.put(info2.getNumber(), info2);
                }
                if (record.getSettlementType() != null && record.getSettlementType().getNumber() != null && !this.settlementTypes.containsKey((info2 = record.getSettlementType()).getNumber())) {
                    this.settlementTypes.put(info2.getNumber(), (SettlementTypeInfo)info2);
                }
                if (record.getCustomer() != null && record.getCustomer().getNumber() != null && !this.customers.containsKey((info2 = record.getCustomer()).getNumber())) {
                    this.customers.put(info2.getNumber(), (CustomerInfo)info2);
                }
                if (record.getSupplier() != null && record.getSupplier().getNumber() != null && !this.suppliers.containsKey((info2 = record.getSupplier()).getNumber())) {
                    this.suppliers.put(info2.getNumber(), (SupplierInfo)info2);
                }
                if (record.getOrgUnit() != null && record.getOrgUnit().getNumber() != null && !this.orgUnits.containsKey((info2 = record.getOrgUnit()).getNumber())) {
                    this.orgUnits.put(info2.getNumber(), (CompanyOrgUnitInfo)info2);
                }
                if (record.getMaterial() == null || record.getMaterial().getNumber() == null || this.materials.containsKey((info2 = record.getMaterial()).getNumber())) continue;
                this.materials.put(info2.getNumber(), (MaterialInfo)info2);
            }
        }
        this.showInfo(this.getResource("collect_numbers"));
        HashSet<String> notExistAccountNumbers = new HashSet<String>();
        HashSet<String> allAccountNumbers = new HashSet<String>();
        HashSet<String> notExistCurrencyNumbers = new HashSet<String>();
        HashSet<String> notExistMeasureUnitNumbers = new HashSet<String>();
        HashSet<String> notExistProfitCenterNumbers = new HashSet<String>();
        HashSet<String> notExistSettlementTypeNumbers = new HashSet<String>();
        HashSet<String> notExistCustomerNumbers = new HashSet<String>();
        HashSet<String> notExistSupplierNumbers = new HashSet<String>();
        HashSet<String> notExistOrgUnitNumbers = new HashSet<String>();
        HashSet<String> notExistMaterialNumbers = new HashSet<String>();
        Object object = null;
        for (Object objectEntry : listEntries) {
            String str;
            if (!(objectEntry instanceof Map)) continue;
            Map mapEntry = (Map)objectEntry;
            object = mapEntry.get("accountNumber");
            if (object != null && object.toString().trim().length() > 0) {
                str = object.toString().trim();
                allAccountNumbers.add(str);
                if (!this.accounts.containsKey(str)) {
                    notExistAccountNumbers.add(str);
                }
            }
            if ((object = mapEntry.get("currencyNumber")) != null && object.toString().trim().length() > 0 && !this.currencys.containsKey(str = object.toString().trim())) {
                notExistCurrencyNumbers.add(str);
            }
            if ((object = mapEntry.get("measureUnitNumber")) != null && object.toString().trim().length() > 0 && !this.measureUnits.containsKey(str = object.toString().trim())) {
                notExistMeasureUnitNumbers.add(str);
            }
            if ((object = mapEntry.get("profitCenterNumber")) != null && object.toString().trim().length() > 0 && !this.profitCenters.containsKey(str = object.toString().trim())) {
                notExistProfitCenterNumbers.add(str);
            }
            if ((object = mapEntry.get("records")) == null || !(object instanceof List)) continue;
            List listRecords = (List)object;
            for (Object objectRecord : listRecords) {
                String str2;
                if (!(objectRecord instanceof Map)) continue;
                Map mapRecord = (Map)objectRecord;
                object = mapRecord.get("measureUnitNumber");
                if (object != null && object.toString().trim().length() > 0 && !this.measureUnits.containsKey(str2 = object.toString().trim())) {
                    notExistMeasureUnitNumbers.add(str2);
                }
                if ((object = mapRecord.get("settlementTypeNumber")) != null && object.toString().trim().length() > 0 && !this.settlementTypes.containsKey(str2 = object.toString().trim())) {
                    notExistSettlementTypeNumbers.add(str2);
                }
                if ((object = mapRecord.get("customerNumber")) != null && object.toString().trim().length() > 0 && !this.customers.containsKey(str2 = object.toString().trim())) {
                    notExistCustomerNumbers.add(str2);
                }
                if ((object = mapRecord.get("supplierNumber")) != null && object.toString().trim().length() > 0 && !this.suppliers.containsKey(str2 = object.toString().trim())) {
                    notExistSupplierNumbers.add(str2);
                }
                if ((object = mapRecord.get("orgUnitNumber")) != null && object.toString().trim().length() > 0 && !this.orgUnits.containsKey(str2 = object.toString().trim())) {
                    notExistOrgUnitNumbers.add(str2);
                }
                if ((object = mapRecord.get("materialNumber")) == null || object.toString().trim().length() <= 0 || this.materials.containsKey(str2 = object.toString().trim())) continue;
                notExistMaterialNumbers.add(str2);
            }
        }
        if (notExistAccountNumbers.size() > 0) {
            this.showInfo(this.getResource("load_accounts"));
            SelectorItemCollection selector2 = this.getAccountSelector();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            filter2.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
            filter2.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
            filter2.getFilterItems().add(new FilterItemInfo("number", notExistAccountNumbers, CompareType.INCLUDE));
            view2 = new EntityViewInfo();
            view2.setSelector(selector2);
            view2.setFilter(filter2);
            IAccountView iAccountView = ctx != null ? AccountViewFactory.getLocalInstance((Context)ctx) : AccountViewFactory.getRemoteInstance();
            AccountViewCollection coll2 = iAccountView.getAccountViewCollection(view2);
            for (AccountViewInfo info : coll2) {
                this.accounts.put(info.getNumber(), info);
            }
        }
        HashSet<String> accountIds = new HashSet<String>();
        HashSet<String> cpAccountIds = new HashSet<String>();
        for (String number : allAccountNumbers) {
            AccountViewInfo account = this.accounts.get(number);
            if (account == null) continue;
            String accountId = account.getId().toString();
            if (!this.caas.containsKey(accountId)) {
                accountIds.add(account.getId().toString());
            }
            if (!account.isHasUserProperty() || this.customizedPropertyss.containsKey(accountId)) continue;
            cpAccountIds.add(account.getId().toString());
        }
        if (accountIds.size() > 0) {
            IAccountFacade iAccountFacade = ctx != null ? AccountFacadeFactory.getLocalInstance((Context)ctx) : AccountFacadeFactory.getRemoteInstance();
            Map tcaas = iAccountFacade.getCAAsByPeriod(accountIds, voucher.getPeriod().getId().toString());
            this.caas.putAll(tcaas);
        }
        if (cpAccountIds.size() > 0) {
            this.showInfo(this.getResource("load_userproperties"));
            view2 = new EntityViewInfo();
            SelectorItemCollection sic = view2.getSelector();
            sic.add(new SelectorItemInfo("account.id"));
            sic.add(new SelectorItemInfo("isNecessary"));
            sic.add(new SelectorItemInfo("isCreditNecessary"));
            sic.add(new SelectorItemInfo("isDebitNecessary"));
            sic.add(new SelectorItemInfo("customizedType.id"));
            sic.add(new SelectorItemInfo("customizedType.name"));
            sic.add(new SelectorItemInfo("customizedType.mappingPropName"));
            SorterItemCollection sorters = view2.getSorter();
            sorters.add(new SorterItemInfo("seq"));
            FilterInfo filter3 = new FilterInfo();
            view2.setFilter(filter3);
            FilterItemCollection fic = filter3.getFilterItems();
            fic.add(new FilterItemInfo("account.id", cpAccountIds, CompareType.INCLUDE));
            fic.add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
            IAssistCustomizedProperty iAssistCustomizedProperty = ctx != null ? AssistCustomizedPropertyFactory.getLocalInstance(ctx) : AssistCustomizedPropertyFactory.getRemoteInstance();
            AssistCustomizedPropertyCollection props = iAssistCustomizedProperty.getAssistCustomizedPropertyCollection(view2);
            Iterator it = props.iterator();
            while (it.hasNext()) {
                AssistCustomizedPropertyInfo property = (AssistCustomizedPropertyInfo)it.next();
                String accountId = property.getAccount().getId().toString();
                Set<String> customizedPropertys = this.customizedPropertyss.get(accountId);
                if (customizedPropertys == null) {
                    customizedPropertys = new HashSet<String>();
                    this.customizedPropertyss.put(accountId, customizedPropertys);
                }
                customizedPropertys.add(property.getCustomizedType().getMappingPropName());
            }
        }
        if (notExistCurrencyNumbers.size() > 0) {
            this.showInfo(this.getResource("load_curr"));
            selector = this.getCurrencySelector();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", notExistCurrencyNumbers, CompareType.INCLUDE));
            view = new EntityViewInfo();
            view.setSelector(selector);
            view.setFilter(filter);
            ICurrency iCurrency = ctx != null ? CurrencyFactory.getLocalInstance((Context)ctx) : CurrencyFactory.getRemoteInstance();
            coll = iCurrency.getCurrencyCollection((EntityViewInfo)view);
            for (CurrencyInfo info : coll) {
                this.currencys.put(info.getNumber(), info);
            }
        }
        if (notExistMeasureUnitNumbers.size() > 0) {
            this.showInfo(this.getResource("load_measureunit"));
            selector = this.getMeasureUnitSelector();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", notExistMeasureUnitNumbers, CompareType.INCLUDE));
            view = new EntityViewInfo();
            view.setSelector(selector);
            view.setFilter(filter);
            IMeasureUnit iMeasureUnit = ctx != null ? MeasureUnitFactory.getLocalInstance((Context)ctx) : MeasureUnitFactory.getRemoteInstance();
            coll = iMeasureUnit.getMeasureUnitCollection((EntityViewInfo)view);
            for (CurrencyInfo info : coll) {
                this.measureUnits.put(info.getNumber(), (MeasureUnitInfo)info);
            }
        }
        if (notExistProfitCenterNumbers.size() > 0) {
            this.showInfo(this.getResource("load_profitcenter"));
            selector = this.getProfitCenterSelector();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", notExistProfitCenterNumbers, CompareType.INCLUDE));
            view = new EntityViewInfo();
            view.setSelector(selector);
            view.setFilter(filter);
            IProfitCenterOrgUnit iProfitCenterOrgUnit = ctx != null ? ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx) : ProfitCenterOrgUnitFactory.getRemoteInstance();
            coll = iProfitCenterOrgUnit.getProfitCenterOrgUnitCollection((EntityViewInfo)view);
            for (CurrencyInfo info : coll) {
                this.profitCenters.put(info.getNumber(), (ProfitCenterOrgUnitInfo)info);
            }
        }
        if (notExistSettlementTypeNumbers.size() > 0) {
            this.showInfo(this.getResource("load_settlementType"));
            selector = this.getSettlementTypeSelector();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", notExistSettlementTypeNumbers, CompareType.INCLUDE));
            view = new EntityViewInfo();
            view.setSelector(selector);
            view.setFilter(filter);
            ISettlementType iSettlementType = ctx != null ? SettlementTypeFactory.getLocalInstance((Context)ctx) : SettlementTypeFactory.getRemoteInstance();
            coll = iSettlementType.getSettlementTypeCollection((EntityViewInfo)view);
            for (CurrencyInfo info : coll) {
                this.settlementTypes.put(info.getNumber(), (SettlementTypeInfo)info);
            }
        }
        if (notExistCustomerNumbers.size() > 0) {
            this.showInfo(this.getResource("load_customer"));
            selector = this.getCustomerSelector();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", notExistCustomerNumbers, CompareType.INCLUDE));
            view = new EntityViewInfo();
            view.setSelector(selector);
            view.setFilter(filter);
            ICustomer iCustomer = ctx != null ? CustomerFactory.getLocalInstance((Context)ctx) : CustomerFactory.getRemoteInstance();
            coll = iCustomer.getCustomerCollection((EntityViewInfo)view);
            for (CurrencyInfo info : coll) {
                this.customers.put(info.getNumber(), (CustomerInfo)info);
            }
        }
        if (notExistSupplierNumbers.size() > 0) {
            this.showInfo(this.getResource("load_provider"));
            selector = this.getSupplierSelector();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", notExistSupplierNumbers, CompareType.INCLUDE));
            view = new EntityViewInfo();
            view.setSelector(selector);
            view.setFilter(filter);
            ISupplier iSupplier = ctx != null ? SupplierFactory.getLocalInstance((Context)ctx) : SupplierFactory.getRemoteInstance();
            coll = iSupplier.getSupplierCollection((EntityViewInfo)view);
            for (CurrencyInfo info : coll) {
                this.suppliers.put(info.getNumber(), (SupplierInfo)info);
            }
        }
        if (notExistOrgUnitNumbers.size() > 0) {
            this.showInfo(this.getResource("load_org"));
            selector = this.getOrgUnitSelector();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", notExistOrgUnitNumbers, CompareType.INCLUDE));
            view = new EntityViewInfo();
            view.setSelector(selector);
            view.setFilter(filter);
            ICompanyOrgUnit iCompanyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
            coll = iCompanyOrgUnit.getCompanyOrgUnitCollection((EntityViewInfo)view);
            for (CurrencyInfo info : coll) {
                this.orgUnits.put(info.getNumber(), (CompanyOrgUnitInfo)info);
            }
        }
        if (notExistMaterialNumbers.size() > 0) {
            this.showInfo(this.getResource("load_material"));
            selector = this.getMaterialSelector();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", notExistMaterialNumbers, CompareType.INCLUDE));
            view = new EntityViewInfo();
            view.setSelector(selector);
            view.setFilter(filter);
            IMaterial iMaterial = ctx != null ? MaterialFactory.getLocalInstance((Context)ctx) : MaterialFactory.getRemoteInstance();
            coll = iMaterial.getMaterialCollection((EntityViewInfo)view);
            for (CurrencyInfo info : coll) {
                this.materials.put(info.getNumber(), (MaterialInfo)info);
            }
        }
        HashMap<String, HashSet<String>> asstActNumberss = new HashMap<String, HashSet<String>>();
        HashMap<String, AsstActTypeInfo> asstActTypes = new HashMap<String, AsstActTypeInfo>();
        for (Object objectEntry : listEntries) {
            AsstAccountInfo caa;
            AccountViewInfo account;
            Map mapEntry;
            if (!(objectEntry instanceof Map) || (object = (mapEntry = (Map)objectEntry).get("accountNumber")) == null || !(object instanceof String) || (account = this.accounts.get(((String)object).trim())) == null || (caa = this.caas.get(account.getId().toString())) == null || caa.getId() == null || (object = mapEntry.get("records")) == null || !(object instanceof List)) continue;
            List listRecords = (List)object;
            AsstActTypeCollection aats = this.getAsstActTypes(ctx, caa.getId().toString());
            for (Object objectRecord : listRecords) {
                Map mapRecord;
                if (!(objectRecord instanceof Map) || !((object = (mapRecord = (Map)objectRecord).get("assGrp")) instanceof Map)) continue;
                Map mapAssGrp = (Map)object;
                for (AsstActTypeInfo aat : aats) {
                    Object number = mapAssGrp.get(aat.getAsstHGAttribute());
                    if (number == null || number.toString().trim().length() <= 0) continue;
                    HashSet<String> asstActNumbers = (HashSet<String>)asstActNumberss.get(aat.getAsstHGAttribute());
                    if (asstActNumbers == null) {
                        asstActNumbers = new HashSet<String>();
                        asstActNumberss.put(aat.getAsstHGAttribute(), asstActNumbers);
                    }
                    asstActNumbers.add(number.toString().trim());
                    if (asstActTypes.containsKey(aat.getAsstHGAttribute())) continue;
                    asstActTypes.put(aat.getAsstHGAttribute(), aat);
                }
            }
        }
        if (asstActNumberss.size() > 0) {
            this.showInfo(this.getResource("load_assistact"));
        }
        for (String attribute : asstActNumberss.keySet()) {
            Set asstActNumbers = (Set)asstActNumberss.get(attribute);
            if (asstActNumbers.size() <= 0) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            AsstActTypeInfo aat = (AsstActTypeInfo)asstActTypes.get(attribute);
            params.put("asstActType", aat);
            params.put("asstActNumbers", asstActNumbers);
            params.put("company", company);
            params.put("cuId", company.getCU().getId().toString());
            if (ctx != null) {
                params.put("userId", ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            } else {
                params.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            }
            IGLGeneralFacade iGLGeneralFacade = ctx != null ? GLGeneralFacadeFactory.getLocalInstance(ctx) : GLGeneralFacadeFactory.getRemoteInstance();
            Map asstActs = iGLGeneralFacade.findAsstActs(params);
            this.asstActss.put(attribute, asstActs);
        }
        int count = listEntries.size();
        int batch = count < 10 ? 1 : (count < 100 ? 10 : (count < 1000 ? 100 : 200));
        for (int i = 0; i < count; ++i) {
            VoucherEntryInfo entry;
            Object objectEntry = listEntries.get(i);
            if (batch == 1 || (i + 1) % batch == 1) {
                this.showInfo(this.getResource("build_voucherentry") + count + ":" + (i + 1));
            }
            if (!(objectEntry instanceof Map) || (entry = this.toEntry(ctx, (Map)objectEntry, voucher)) == null) continue;
            entries.add(entry);
        }
        return entries;
    }

    protected VoucherEntryInfo toEntry(Context ctx, Map mapEntry, VoucherInfo voucher) throws BOSException, EASBizException {
        String str;
        String str2;
        if (mapEntry == null) {
            return null;
        }
        VoucherEntryInfo entry = new VoucherEntryInfo();
        Object object = mapEntry.get("description");
        if (object != null) {
            entry.setDescription(object.toString().trim());
        }
        EntryDC dc = EntryDC.DEBIT;
        object = mapEntry.get("entryDC");
        if (object != null) {
            str2 = object.toString().trim();
            dc = str2.equals("1") ? EntryDC.DEBIT : EntryDC.CREDIT;
        }
        entry.setEntryDC(dc);
        object = mapEntry.get("accountNumber");
        if (object != null && object.toString().trim().length() > 0) {
            str2 = object.toString().trim();
            AccountViewInfo account = this.accounts.get(str2);
            entry.setAccount(account);
            if (account != null) {
                entry.setCAA(this.caas.get(account.getId().toString()));
            }
        }
        if ((object = mapEntry.get("currencyNumber")) != null && object.toString().trim().length() > 0) {
            str2 = object.toString().trim();
            CurrencyInfo currency = this.currencys.get(str2);
            entry.setCurrency(currency);
        }
        BigDecimal originalAmount = GlUtils.pointzero;
        object = mapEntry.get("originalAmount");
        if (object != null) {
            if (object instanceof BigDecimal) {
                originalAmount = (BigDecimal)object;
            } else {
                String str3 = object.toString().trim();
                if (str3.length() > 0) {
                    originalAmount = new BigDecimal(str3);
                }
            }
        }
        entry.setOriginalAmount(originalAmount);
        BigDecimal localAmount = GlUtils.pointzero;
        object = mapEntry.get("localAmount");
        if (object != null) {
            if (object instanceof BigDecimal) {
                localAmount = (BigDecimal)object;
            } else {
                String str4 = object.toString().trim();
                if (str4.length() > 0) {
                    localAmount = new BigDecimal(str4);
                }
            }
        }
        entry.setLocalAmount(localAmount);
        BigDecimal reportingAmount = GlUtils.pointzero;
        object = mapEntry.get("reportingAmount");
        if (object != null) {
            if (object instanceof BigDecimal) {
                reportingAmount = (BigDecimal)object;
            } else {
                String str5 = object.toString().trim();
                if (str5.length() > 0) {
                    reportingAmount = new BigDecimal(str5);
                }
            }
        }
        entry.setReportingAmount(reportingAmount);
        BigDecimal localExchangeRate = null;
        object = mapEntry.get("localExchangeRate");
        if (object != null) {
            if (object instanceof BigDecimal) {
                localExchangeRate = (BigDecimal)object;
            } else {
                String str6 = object.toString().trim();
                if (str6.length() > 0) {
                    localExchangeRate = new BigDecimal(str6);
                }
            }
        }
        entry.setLocalExchangeRate(localExchangeRate);
        BigDecimal reportingExchangeRate = null;
        object = mapEntry.get("reportingExchangeRate");
        if (object != null) {
            if (object instanceof BigDecimal) {
                reportingExchangeRate = (BigDecimal)object;
            } else {
                str = object.toString().trim();
                if (str.length() > 0) {
                    reportingExchangeRate = new BigDecimal(str);
                }
            }
        }
        entry.setReportingExchangeRate(reportingExchangeRate);
        object = mapEntry.get("measureUnitNumber");
        if (object != null && object.toString().trim().length() > 0) {
            str = object.toString().trim();
            MeasureUnitInfo measureUnit = this.measureUnits.get(str);
            entry.setMeasureUnit(measureUnit);
        }
        if ((object = mapEntry.get("profitCenterNumber")) != null && object.toString().trim().length() > 0) {
            str = object.toString().trim();
            ProfitCenterOrgUnitInfo profitCenter = this.profitCenters.get(str);
            entry.setProfitCenter(profitCenter);
        }
        BigDecimal quantity = GlUtils.pointzero;
        object = mapEntry.get("quantity");
        if (object != null) {
            if (object instanceof BigDecimal) {
                quantity = (BigDecimal)object;
            } else {
                String str7 = object.toString().trim();
                if (str7.length() > 0) {
                    quantity = new BigDecimal(str7);
                }
            }
        }
        entry.setQuantity(quantity);
        BigDecimal standardQuantity = GlUtils.pointzero;
        object = mapEntry.get("standardQuantity");
        if (object != null) {
            if (object instanceof BigDecimal) {
                standardQuantity = (BigDecimal)object;
            } else {
                String str8 = object.toString().trim();
                if (str8.length() > 0) {
                    standardQuantity = new BigDecimal(str8);
                }
            }
        }
        entry.setStandardQuantity(standardQuantity);
        BigDecimal price = GlUtils.pointzero;
        object = mapEntry.get("price");
        if (object != null) {
            if (object instanceof BigDecimal) {
                price = (BigDecimal)object;
            } else {
                String str9 = object.toString().trim();
                if (str9.length() > 0) {
                    price = new BigDecimal(str9);
                }
            }
        }
        entry.setPrice(price);
        if (entry.getAccount() == null) {
            return entry;
        }
        object = mapEntry.get("records");
        if (object != null && object instanceof List) {
            entry.setAssistRecords((AbstractObjectCollection)this.toRecords(ctx, (List)object, entry, voucher));
        }
        return entry;
    }

    protected VoucherAssistRecordCollection toRecords(Context ctx, List listRecords, VoucherEntryInfo entry, VoucherInfo voucher) throws BOSException, EASBizException {
        VoucherAssistRecordCollection records = new VoucherAssistRecordCollection();
        if (listRecords == null) {
            return records;
        }
        for (Object objectRecord : listRecords) {
            VoucherAssistRecordInfo record;
            if (!(objectRecord instanceof Map) || (record = this.toRecord(ctx, (Map)objectRecord, entry, voucher)) == null) continue;
            records.add(record);
        }
        return records;
    }

    protected VoucherAssistRecordInfo toRecord(Context ctx, Map mapRecord, VoucherEntryInfo entry, VoucherInfo voucher) throws BOSException, EASBizException {
        SettlementTypeInfo info;
        Map mapAssGrp;
        if (mapRecord == null) {
            return null;
        }
        VoucherAssistRecordInfo record = new VoucherAssistRecordInfo();
        Object object = mapRecord.get("bizDate");
        if (object != null && object.toString().trim().length() > 0) {
            try {
                record.setBizDate(this.DATE_FORMAT.parse(object.toString().trim()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((object = mapRecord.get("endDate")) != null && object.toString().trim().length() > 0) {
            try {
                record.setEndDate(this.DATE_FORMAT.parse(object.toString().trim()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((object = mapRecord.get("description")) != null) {
            record.setDescription(object.toString().trim());
        }
        BigDecimal originalAmount = GlUtils.pointzero;
        object = mapRecord.get("originalAmount");
        if (object != null) {
            if (object instanceof BigDecimal) {
                originalAmount = (BigDecimal)object;
            } else {
                String str = object.toString().trim();
                if (str.length() > 0) {
                    originalAmount = new BigDecimal(str);
                }
            }
        }
        record.setOriginalAmount(originalAmount);
        BigDecimal localAmount = GlUtils.pointzero;
        object = mapRecord.get("localAmount");
        if (object != null) {
            if (object instanceof BigDecimal) {
                localAmount = (BigDecimal)object;
            } else {
                String str = object.toString().trim();
                if (str.length() > 0) {
                    localAmount = new BigDecimal(str);
                }
            }
        }
        record.setLocalAmount(localAmount);
        BigDecimal reportingAmount = GlUtils.pointzero;
        object = mapRecord.get("reportingAmount");
        if (object != null) {
            if (object instanceof BigDecimal) {
                reportingAmount = (BigDecimal)object;
            } else {
                String str = object.toString().trim();
                if (str.length() > 0) {
                    reportingAmount = new BigDecimal(str);
                }
            }
        }
        record.setReportingAmount(reportingAmount);
        object = mapRecord.get("measureUnitNumber");
        if (object != null && object.toString().trim().length() > 0) {
            MeasureUnitInfo info2 = this.measureUnits.get(object.toString().trim());
            record.setMeasureUnit(info2);
        }
        BigDecimal quantity = GlUtils.pointzero;
        object = mapRecord.get("quantity");
        if (object != null) {
            if (object instanceof BigDecimal) {
                quantity = (BigDecimal)object;
            } else {
                String str = object.toString().trim();
                if (str.length() > 0) {
                    quantity = new BigDecimal(str);
                }
            }
        }
        record.setQuantity(quantity);
        BigDecimal standardQuantity = GlUtils.pointzero;
        object = mapRecord.get("standardQuantity");
        if (object != null) {
            if (object instanceof BigDecimal) {
                standardQuantity = (BigDecimal)object;
            } else {
                String str = object.toString().trim();
                if (str.length() > 0) {
                    standardQuantity = new BigDecimal(str);
                }
            }
        }
        record.setStandardQuantity(standardQuantity);
        BigDecimal price = GlUtils.pointzero;
        object = mapRecord.get("price");
        if (object != null) {
            if (object instanceof BigDecimal) {
                price = (BigDecimal)object;
            } else {
                String str = object.toString().trim();
                if (str.length() > 0) {
                    price = new BigDecimal(str);
                }
            }
        }
        record.setPrice(price);
        object = mapRecord.get("assGrp");
        if (object != null && object instanceof Map && entry.getCAA() != null && entry.getCAA().getId() != null && (mapAssGrp = (Map)object).size() > 0) {
            AsstActTypeCollection aats = this.getAsstActTypes(ctx, entry.getCAA().getId().toString());
            AssistantHGInfo assGrp = new AssistantHGInfo();
            assGrp.setAsstAccount(entry.getCAA());
            int count = 0;
            String key = entry.getCAA().getId().toString();
            for (AsstActTypeInfo aat : aats) {
                Object asstAct;
                String attribute = aat.getAsstHGAttribute();
                object = mapAssGrp.get(attribute);
                key = key + "_" + attribute;
                if (object == null || object.toString().trim().length() <= 0) continue;
                String number = object.toString().trim();
                key = key + "_" + number;
                Map<String, Object> asstActs = this.asstActss.get(attribute);
                if (asstActs == null || !((asstAct = asstActs.get(number)) instanceof DataBaseInfo)) continue;
                assGrp.put(attribute, asstAct);
                ++count;
            }
            if (count > 0) {
                if (this.hgs.containsKey(key)) {
                    assGrp = this.hgs.get(key);
                } else {
                    IAssistantHG iAssistantHG = ctx != null ? AssistantHGFactory.getLocalInstance((Context)ctx) : AssistantHGFactory.getRemoteInstance();
                    assGrp.put("aatok", (Object)Boolean.TRUE);
                    assGrp = iAssistantHG.getAssistantHG(assGrp, entry.getCAA().getId().toString(), aats);
                    this.hgs.put(key, assGrp);
                }
                record.setAssGrp(assGrp);
            }
        }
        if (!entry.getAccount().isHasUserProperty()) {
            return record;
        }
        Set<String> customizedPropertys = this.customizedPropertyss.get(entry.getAccount().getId().toString());
        if (customizedPropertys == null || customizedPropertys.size() == 0) {
            return record;
        }
        if (customizedPropertys.contains("settlementType") && (object = mapRecord.get("settlementTypeNumber")) != null && object.toString().trim().length() > 0) {
            info = this.settlementTypes.get(object.toString().trim());
            record.setSettlementType(info);
        }
        if (customizedPropertys.contains("settlementCode") && (object = mapRecord.get("settlementCode")) != null) {
            record.setSettlementCode(object.toString().trim());
        }
        if (customizedPropertys.contains("bizNumber") && (object = mapRecord.get("bizNumber")) != null) {
            record.setBizNumber(object.toString().trim());
        }
        if (customizedPropertys.contains("customer") && (object = mapRecord.get("customerNumber")) != null && object.toString().trim().length() > 0) {
            info = this.customers.get(object.toString().trim());
            record.setCustomer((CustomerInfo)info);
        }
        if (customizedPropertys.contains("supplier") && (object = mapRecord.get("supplierNumber")) != null && object.toString().trim().length() > 0) {
            info = this.suppliers.get(object.toString().trim());
            record.setSupplier((SupplierInfo)info);
        }
        if (customizedPropertys.contains("orgUnit") && (object = mapRecord.get("orgUnitNumber")) != null && object.toString().trim().length() > 0) {
            info = this.orgUnits.get(object.toString().trim());
            record.setOrgUnit((CompanyOrgUnitInfo)info);
        }
        if (customizedPropertys.contains("material") && (object = mapRecord.get("materialNumber")) != null && object.toString().trim().length() > 0) {
            info = this.materials.get(object.toString().trim());
            record.setMaterial((MaterialInfo)info);
        }
        if (customizedPropertys.contains("ticketNumber") && (object = mapRecord.get("ticketNumber")) != null) {
            record.setTicketNumber(object.toString().trim());
        }
        if (customizedPropertys.contains("invoiceNumber") && (object = mapRecord.get("invoiceNumber")) != null) {
            record.setInvoiceNumber(object.toString().trim());
        }
        if (customizedPropertys.contains("feeType")) {
            object = mapRecord.get("feeType");
            FeeTypeEnum feeType = null;
            if (object instanceof Integer) {
                feeType = FeeTypeEnum.getEnum((int)((Integer)object));
            }
            record.setFeeType(feeType);
        }
        return record;
    }

    protected SelectorItemCollection getProfitCenterSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("displayName"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("isSealUp"));
        return sic;
    }

    protected SelectorItemCollection getAccountSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("bw"));
        sic.add(new SelectorItemInfo("ACNotice"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isSelfFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("isChangeCurrency"));
        sic.add(new SelectorItemInfo("companyID.id"));
        sic.add(new SelectorItemInfo("accountTableID.id"));
        sic.add(new SelectorItemInfo("currencyID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.number"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("category"));
        sic.add(new SelectorItemInfo("diffType"));
        return sic;
    }

    protected SelectorItemCollection getCurrencySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        return sic;
    }

    protected SelectorItemCollection getMeasureUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("coefficient"));
        sic.add(new SelectorItemInfo("isDisabled"));
        sic.add(new SelectorItemInfo("measureUnitGroup.id"));
        return sic;
    }

    protected SelectorItemCollection getSettlementTypeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    protected SelectorItemCollection getCustomerSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    protected SelectorItemCollection getSupplierSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    protected SelectorItemCollection getOrgUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    protected SelectorItemCollection getMaterialSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    private AsstActTypeCollection getAsstActTypes(Context ctx, String asstAccountId) throws BOSException {
        if (this.asstActTypess.containsKey(asstAccountId)) {
            return this.asstActTypess.get(asstAccountId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.useLongNumber"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        IAsstActGroupDetail iAsstActGroupDetail = ctx != null ? AsstActGroupDetailFactory.getLocalInstance((Context)ctx) : AsstActGroupDetailFactory.getRemoteInstance();
        AsstActGroupDetailCollection asstcol = iAsstActGroupDetail.getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        this.asstActTypess.put(asstAccountId, asstActTypes);
        return asstActTypes;
    }

    public void setTaskLogger(GLTaskLogger taskLogger) {
        this.taskLogger = taskLogger;
    }

    public void showInfo(String message) {
        if (this.taskLogger != null) {
            this.taskLogger.showInfo(message);
        }
    }

    public void showWarn(String message) {
        if (this.taskLogger != null) {
            this.taskLogger.showWarn(message);
        }
    }

    public void showError(String message, Throwable t) {
        if (this.taskLogger != null) {
            this.taskLogger.showError(message, t);
        }
    }
}

