/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FeeTypeEnum;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.ImpVoucherStructure;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherExpImpException;
import com.kingdee.eas.fi.gl.VoucherIOSparser;
import com.kingdee.eas.fi.gl.VoucherImpExpParam;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class VoucherDBFSparser
extends VoucherIOSparser {
    private boolean gl_111 = false;
    private boolean hasCompanyNum = false;

    public VoucherDBFSparser() {
        try {
            this.gl_111 = Boolean.valueOf(GlUtils.getParamByKey(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), "GL_111").toString());
        }
        catch (Exception e) {
            this.gl_111 = false;
        }
    }

    private WSVoucherCollection getCashFlowMap(boolean isSelectCash, String path, VoucherImpExpParam filterParam) throws VoucherExpImpException {
        if (!isSelectCash) {
            return null;
        }
        WSVoucherCollection cashs = new WSVoucherCollection();
        WSVoucherInfo wsvoucher = null;
        Connection conn = null;
        PreparedStatement stmtVoucher = null;
        ResultSet rsVoucher = null;
        try {
            conn = this.getConnetion(path);
            this.hasCompanyNum = this.hasCompanyNum(conn, path);
            StringBuffer cashSelector = new StringBuffer();
            if (this.hasCompanyNum) {
                cashSelector.append(" SELECT FDATE,FPERIOD,FCYID,FCLSNAME1,FOBJID1,FOBJNAME1,FCLSNAME2,FOBJID2,FOBJNAME2,FCLSNAME3,FOBJID3,FOBJNAME3,");
                cashSelector.append(" FCLSNAME4,FOBJID4,FOBJNAME4,FCLSNAME5,FOBJID5,FOBJNAME5,FCLSNAME6,FOBJID6,FOBJNAME6,");
                cashSelector.append(" FCLSNAME7,FOBJID7,FOBJNAME7,FCLSNAME8,FOBJID8,FOBJNAME8, ");
                cashSelector.append(" FGROUP,FGROUPID , FNUM,FENTRYID ,FOPPENTRYI , FNUMBER,FSUBNUMBER,FAMOUNTFOR , FAMOUNTLOC ,FAMOUNTRPT ,FPRICOEF ,FSUPCOEF,FTYPE from " + path + " ");
            } else {
                cashSelector.append(" SELECT FDATE,FPERIOD,FCYID,FCLSNAME1,FOBJID1,FOBJNAME1,FCLSNAME2,FOBJID2,FOBJNAME2,FCLSNAME3,FOBJID3,FOBJNAME3,");
                cashSelector.append(" FCLSNAME4,FOBJID4,FOBJNAME4,FCLSNAME5,FOBJID5,FOBJNAME5,FCLSNAME6,FOBJID6,FOBJNAME6,");
                cashSelector.append(" FCLSNAME7,FOBJID7,FOBJNAME7,FCLSNAME8,FOBJID8,FOBJNAME8, ");
                cashSelector.append(" FGROUP,FNUM,FENTRYID ,FOPPENTRYI , FNUMBER,FSUBNUMBER,FAMOUNTFOR , FAMOUNTLOC ,FAMOUNTRPT ,FPRICOEF ,FSUPCOEF,FTYPE  from " + path + " ");
            }
            stmtVoucher = conn.prepareStatement(cashSelector.toString());
            rsVoucher = stmtVoucher.executeQuery();
            int rows = 0;
            while (rsVoucher.next()) {
                wsvoucher = new WSVoucherInfo();
                wsvoucher.put("lineNum", new Integer(rows + 1));
                wsvoucher.setItemFlag(1);
                if (!this.hasCompanyNum) {
                    wsvoucher.setCompanyNumber(this.getCompany().getNumber());
                } else {
                    wsvoucher.setCompanyNumber(rsVoucher.getString("FGROUPID"));
                }
                Date voucherDate = rsVoucher.getDate("FDATE");
                wsvoucher.setBookedDate(voucherDate);
                int periodNum = rsVoucher.getInt("FPERIOD");
                wsvoucher.setPeriodNumber(periodNum);
                if (voucherDate != null) {
                    wsvoucher.setPeriodYear(voucherDate.getYear() + 1900);
                }
                String voucherTypeNum = rsVoucher.getString("FGROUP");
                wsvoucher.setVoucherType(voucherTypeNum);
                String vouchernumber = rsVoucher.getString("FNUM");
                wsvoucher.setVoucherNumber(vouchernumber);
                String curNumber = rsVoucher.getString("FCYID");
                wsvoucher.setCurrencyNumber(curNumber);
                int entryesq = rsVoucher.getInt("FENTRYID");
                wsvoucher.setEntrySeq(entryesq);
                int entryoppesq = rsVoucher.getInt("FOPPENTRYI");
                wsvoucher.put("cashOppEntrySeq", entryoppesq);
                String primarynumber = rsVoucher.getString("FNUMBER");
                wsvoucher.setPrimaryItem(primarynumber);
                String supplynumber = rsVoucher.getString("FSUBNUMBER");
                wsvoucher.setSupplyItem(supplynumber);
                BigDecimal originalAmount = rsVoucher.getBigDecimal("FAMOUNTFOR");
                wsvoucher.setCashflowAmountOriginal(originalAmount.doubleValue());
                BigDecimal localamount = rsVoucher.getBigDecimal("FAMOUNTLOC");
                wsvoucher.setCashflowAmountLocal(localamount.doubleValue());
                BigDecimal reportamount = rsVoucher.getBigDecimal("FAMOUNTRPT");
                wsvoucher.setCashflowAmountRpt(reportamount.doubleValue());
                int primarycoef = rsVoucher.getInt("FPRICOEF");
                wsvoucher.setPrimaryCoef(primarycoef);
                int supplycoef = rsVoucher.getInt("FSUPCOEF");
                wsvoucher.setSupplyCoef(supplycoef);
                String type = rsVoucher.getString("FTYPE");
                wsvoucher.setType(type);
                int assistCount = 0;
                for (int k = 0; k < 8; ++k) {
                    String obj1 = rsVoucher.getString("FCLSNAME" + (k + 1));
                    String obj2 = rsVoucher.getString("FOBJID" + (k + 1));
                    String obj3 = rsVoucher.getString("FOBJNAME" + (k + 1));
                    if (!(obj1 != null && !"".equals(obj1) || obj2 != null && !"".equals(obj2) || obj3 != null && !"".equals(obj3))) continue;
                    String strAsstActTypeName = null;
                    if (obj1 != null) {
                        strAsstActTypeName = String.valueOf(obj1);
                        wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                    }
                    String strAsstActID = null;
                    if (obj2 != null) {
                        strAsstActID = obj2;
                        wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                    }
                    String strAsstActName = null;
                    if (obj3 != null) {
                        strAsstActName = obj3;
                        wsvoucher.put("asstActName" + assistCount, strAsstActName);
                    }
                    ++assistCount;
                }
                wsvoucher.put("assistCount", new Integer(assistCount));
                cashs.add(wsvoucher);
                ++rows;
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"read dbf file error:", (Throwable)e);
                throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtVoucher, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtVoucher, (Connection)conn);
        return cashs;
    }

    private WSVoucherCollection getVchList(String path, VoucherImpExpParam filterParam) throws VoucherExpImpException {
        WSVoucherCollection vchs = new WSVoucherCollection();
        Connection conn = null;
        WSVoucherInfo wsvoucher = null;
        JdbcRowSet rsVoucher = null;
        PreparedStatement stmtVoucher = null;
        Date begin = filterParam.getDateBegin();
        Date end = filterParam.getDateEnd();
        String numberBegin = filterParam.getINumberBegin();
        String numberEnd = filterParam.getINumberEnd();
        VoucherTypeInfo filteVoucherTypeInfo = filterParam.getVoucherTypeInfo();
        try {
            conn = this.getConnetion(path);
            this.hasCompanyNum = this.hasCompanyNum(conn, path);
            StringBuffer voucherSelector = null;
            voucherSelector = this.getIsForeign() == false ? this.getVoucherSelector() : this.getVoucherForSelector();
            StringBuffer voucherFilter = this.getVoucherFilter(path, filterParam);
            String voucherSorter = this.getVoucherSorter();
            StringBuffer voucherSQL = new StringBuffer();
            voucherSQL.append(voucherSelector).append(voucherFilter).append(voucherSorter);
            try {
                rsVoucher = new JdbcRowSet();
                stmtVoucher = conn.prepareStatement(voucherSQL.toString());
                int index = 1;
                stmtVoucher.setDate(index++, filterParam.getDateBegin());
                stmtVoucher.setDate(index++, filterParam.getDateEnd());
                if (filterParam.getVoucherTypeInfo() != null) {
                    String strTypeVoucherInfo = filterParam.getVoucherTypeInfo().getName().trim();
                    stmtVoucher.setString(index++, strTypeVoucherInfo);
                }
                rsVoucher.populate(stmtVoucher.executeQuery());
            }
            catch (Exception _ex) {
                try {
                    logger.error((Object)"read dbf file error:", (Throwable)_ex);
                    throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmtVoucher, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmtVoucher, (Connection)conn);
            int rows = 0;
            while (rsVoucher.next()) {
                Date asstBizDate;
                String objSupplier;
                String objCompanyOrgUnit;
                String objMaterial;
                String objHandler;
                String objFeeType;
                String objCustomer;
                String strTicketNumber;
                BigDecimal cAmount;
                BigDecimal dAmount;
                BigDecimal price;
                BigDecimal quantity;
                wsvoucher = new WSVoucherInfo();
                wsvoucher.put("lineNum", new Integer(rows + 1));
                if (!this.hasCompanyNum) {
                    wsvoucher.setCompanyNumber(this.getCompany().getNumber());
                } else {
                    wsvoucher.setCompanyNumber(rsVoucher.getString("FGROUPID"));
                }
                Date voucherDate = rsVoucher.getDate("FDATE");
                wsvoucher.setBookedDate(voucherDate);
                if (voucherDate != null && (voucherDate.before(begin) || voucherDate.after(end))) continue;
                wsvoucher.setBizDate(rsVoucher.getDate("FTRANSDATE"));
                int periodNum = rsVoucher.getInt("FPERIOD");
                wsvoucher.setPeriodNumber(periodNum);
                if (voucherDate != null) {
                    wsvoucher.setPeriodYear(voucherDate.getYear() + 1900);
                } else if (rsVoucher.getDate("FTRANSDATE") != null) {
                    wsvoucher.setPeriodYear(rsVoucher.getDate("FTRANSDATE").getYear() + 1900);
                }
                String voucherTypeNum = rsVoucher.getString("FGROUP");
                wsvoucher.setVoucherType(voucherTypeNum);
                String vouchernumber = rsVoucher.getString("FNUM");
                wsvoucher.setVoucherNumber(vouchernumber);
                if ((numberBegin != null && numberBegin.trim().length() > 0 || numberEnd != null && numberEnd.trim().length() > 0) && (filteVoucherTypeInfo != null && !voucherTypeNum.equals(filteVoucherTypeInfo.getName()) || numberBegin != null && numberBegin.trim().length() > 0 && vouchernumber.compareTo(numberBegin.trim()) < 0 || numberEnd != null && numberEnd.trim().length() > 0 && vouchernumber.compareTo(numberEnd.trim()) > 0) || filteVoucherTypeInfo != null && !voucherTypeNum.equals(filteVoucherTypeInfo.getName())) continue;
                int iSeq = rsVoucher.getInt("FENTRYID");
                wsvoucher.setEntrySeq(iSeq);
                String voucherAbstract = rsVoucher.getString("FEXP");
                wsvoucher.setVoucherAbstract(voucherAbstract);
                if (this.gl_111) {
                    wsvoucher.setProfitCenterNumber(rsVoucher.getString("FPROFITCEN"));
                }
                String strAccountView = rsVoucher.getString("FACCTID");
                wsvoucher.setAccountNumber(strAccountView);
                String strCurrenyISOcode = rsVoucher.getString("FCYID");
                wsvoucher.setCurrencyNumber(strCurrenyISOcode);
                BigDecimal exchangeRate = rsVoucher.getBigDecimal("FEXCHRATE");
                if (exchangeRate != null) {
                    exchangeRate = exchangeRate.setScale(10, 4);
                }
                wsvoucher.setLocalRate(exchangeRate.doubleValue());
                int asstDC = rsVoucher.getInt("FDC");
                wsvoucher.setEntryDC(asstDC);
                BigDecimal originalAmount = rsVoucher.getBigDecimal("FFCYAMT");
                if (originalAmount != null) {
                    wsvoucher.setOriginalAmount(originalAmount.doubleValue());
                }
                if ((quantity = rsVoucher.getBigDecimal("FQTY")) != null) {
                    wsvoucher.setQty(quantity.doubleValue());
                }
                BigDecimal qty = GlUtils.zero;
                try {
                    qty = rsVoucher.getBigDecimal("FASSISTQTY");
                }
                catch (Exception e) {
                    qty = GlUtils.zero;
                }
                if (qty != null) {
                    wsvoucher.put("assistQty", qty);
                }
                if ((price = rsVoucher.getBigDecimal("FPRICE")) != null) {
                    wsvoucher.setPrice(price.doubleValue());
                }
                if ((dAmount = rsVoucher.getBigDecimal("FDEBIT")) != null) {
                    wsvoucher.setDebitAmount(dAmount.doubleValue());
                }
                if ((cAmount = rsVoucher.getBigDecimal("FCREDIT")) != null) {
                    wsvoucher.setCreditAmount(cAmount.doubleValue());
                }
                String strCreator = rsVoucher.getString("FPREPARE");
                wsvoucher.setCreator(strCreator);
                int iAttachments = rsVoucher.getInt("FATTCHMENT");
                wsvoucher.setAttaches(iAttachments);
                wsvoucher.put("module", null);
                wsvoucher.put("deleted", null);
                wsvoucher.put("pingzhengxuhao", rsVoucher.getString("FSERIALNO"));
                String strUnitName = rsVoucher.getString("FUNITNAME");
                wsvoucher.setMeasurement(strUnitName);
                try {
                    String strAssistUnitName = rsVoucher.getString("FASSISTUNI");
                    wsvoucher.put("assistUnit", strAssistUnitName);
                }
                catch (Exception e) {
                    wsvoucher.put("assistUnit", null);
                }
                String description = rsVoucher.getString("FREFERENCE");
                wsvoucher.setDescription(description);
                wsvoucher.put("cashflowFlag", null);
                int itemFlag = 0;
                wsvoucher.setItemFlag(itemFlag);
                String bizNumber = rsVoucher.getString("FTRANSID");
                wsvoucher.setBizNumber(bizNumber);
                String objSettleCode = rsVoucher.getString("FSETTLCODE");
                wsvoucher.setSettlementType(objSettleCode);
                String strSettleNumber = rsVoucher.getString("FSETTLENO");
                wsvoucher.setSettlementNumber(strSettleNumber);
                String des = rsVoucher.getString("FDES");
                wsvoucher.put("asstAbstract", des);
                int assistCount = 0;
                for (int k = 0; k < 8; ++k) {
                    String obj1 = rsVoucher.getString("FCLSNAME" + (k + 1));
                    String obj2 = rsVoucher.getString("FOBJID" + (k + 1));
                    String obj3 = rsVoucher.getString("FOBJNAME" + (k + 1));
                    if (!(obj1 != null && !"".equals(obj1) || obj2 != null && !"".equals(obj2) || obj3 != null && !"".equals(obj3))) continue;
                    String strAsstActTypeName = null;
                    if (obj1 != null) {
                        strAsstActTypeName = String.valueOf(obj1);
                        wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                    }
                    String strAsstActID = null;
                    if (obj2 != null) {
                        strAsstActID = obj2;
                        wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                    }
                    String strAsstActName = null;
                    if (obj3 != null) {
                        strAsstActName = obj3;
                        wsvoucher.put("asstActName" + assistCount, strAsstActName);
                    }
                    ++assistCount;
                }
                wsvoucher.put("assistCount", new Integer(assistCount));
                String strInvoiceNumber = rsVoucher.getString("FINVNUM");
                if (strInvoiceNumber != null) {
                    wsvoucher.setInvoiceNumber(strInvoiceNumber);
                }
                if ((strTicketNumber = rsVoucher.getString("FTICKETNUM")) != null) {
                    wsvoucher.put("ticketNumber", strTicketNumber.toString());
                }
                if ((objCustomer = rsVoucher.getString("FCUSTOMER")) != null) {
                    wsvoucher.put("customer", objCustomer);
                }
                if ((objFeeType = rsVoucher.getString("FFEETYPE")) != null) {
                    wsvoucher.put("feeType", objFeeType);
                }
                if ((objHandler = rsVoucher.getString("FHANDLER")) != null) {
                    wsvoucher.put("handler", objHandler);
                }
                if ((objMaterial = rsVoucher.getString("FMATERIAL")) != null) {
                    wsvoucher.put("material", objMaterial);
                }
                if ((objCompanyOrgUnit = rsVoucher.getString("FORGUNIT")) != null) {
                    wsvoucher.put("orgUnit", objCompanyOrgUnit);
                }
                if ((objSupplier = rsVoucher.getString("FSUPPLIER")) != null) {
                    wsvoucher.put("supplier", objSupplier);
                }
                if ((asstBizDate = rsVoucher.getDate("FBIZDATE")) != null) {
                    wsvoucher.setAssistBizDate(asstBizDate);
                }
                Date endDate = rsVoucher.getDate("FENDDATE");
                wsvoucher.setAssistEndDate(endDate);
                vchs.add(wsvoucher);
                ++rows;
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"read dbf file error:", (Throwable)e);
                throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtVoucher, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtVoucher, (Connection)conn);
        return vchs;
    }

    @Override
    public IObjectCollection getImpVoucherList(String strFullName, String strPath, String strFileName, VoucherImpExpParam filterParam) throws EASBizException, BOSException {
        WSVoucherCollection vchs = this.getVchList(strFullName, filterParam);
        if (filterParam.isSelectCash()) {
            int iIndex = strFullName.toLowerCase().lastIndexOf(".dbf");
            String strCFFullFile = strFullName.substring(0, iIndex);
            strCFFullFile = strCFFullFile + "CF.dbf";
            WSVoucherCollection cashs = this.getCashFlowMap(filterParam.isSelectCash(), strCFFullFile, filterParam);
            vchs.addCollection(cashs);
        }
        return vchs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasCompanyNum(Connection conn, String strFullName) {
        boolean hasComNum = false;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("select top 1 * from " + strFullName);
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            hasComNum = "FGROUPID".equalsIgnoreCase(rsmd.getColumnName(1));
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        catch (SQLException e) {
            hasComNum = false;
        }
        finally {
            SQLUtils.cleanup(rs, ps);
        }
        return hasComNum;
    }

    @Override
    public void checkFileValidate(String strFilePath, String strFileName) throws EASBizException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        boolean isUpFrom530 = true;
        try {
            conn = this.getConnetion(strFilePath);
            StringBuffer strBuffer = new StringBuffer("select ");
            strBuffer.append("  fdate,fperiod,");
            strBuffer.append("   fgroup,fnum,fentryid,");
            strBuffer.append("   fexp,facctid,");
            strBuffer.append("   fclsname1,fobjid1,fobjname1,");
            strBuffer.append("   fclsname2,fobjid2,fobjname2,");
            strBuffer.append("   fclsname3,fobjid3,fobjname3,");
            strBuffer.append("   fclsname4,fobjid4,fobjname4,");
            strBuffer.append("   fclsname5,fobjid5,fobjname5,");
            strBuffer.append("   fclsname6,fobjid6,fobjname6,");
            strBuffer.append("   fclsname7,fobjid7,fobjname7,");
            strBuffer.append("   fclsname8,fobjid8,fobjname8,");
            strBuffer.append("   ftransid,fcyid,fexchrate,");
            strBuffer.append("   fdc,ffcyamt, fqty,");
            strBuffer.append("   fprice,fdebit,fcredit, ");
            strBuffer.append("   fsettlcode,fsettleno,fprepare,");
            strBuffer.append("   fpay,fcash,  fposter,");
            strBuffer.append("   fchecker, fattchment, fposted,");
            strBuffer.append("   fmodule , fdeleted , fserialno ,");
            strBuffer.append("   funitname ,freference ,fcashflow ");
            if (!isUpFrom530) {
                strBuffer.append("   ,finvnum,fticketnum,fcustomer,ffeetype,");
                strBuffer.append("   fmaterial,forgunit,fhandler,fsupplier,fbizdate,fenddate, ");
            }
            strBuffer.append(" from ").append(strFilePath + strFileName);
            logger.debug((Object)strBuffer);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(strBuffer.toString());
        }
        catch (SQLException sqlE) {
            try {
                throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void setExtraData(String strFilePath, String strFileName, KDTextField tfVoucherNumberBegin, KDTextField tfVoucherNumberEnd) throws EASBizException {
        String jdkVersion = System.getProperty("java.version");
        if (jdkVersion != null && jdkVersion.contains("1.8.")) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnetion(strFilePath);
            String strTotal = "SELECT min(FNum) as minFNum,Max(FNum) as maxFNum FROM " + strFilePath + "\\" + strFileName + " where FNum >0 ";
            stmt = conn.createStatement();
            logger.debug((Object)"conn.createStatement();");
            rs = stmt.executeQuery(strTotal);
            logger.debug((Object)"stmt.executeQuery(strTotal);");
            String iMinNum = null;
            String iMaxNum = null;
            if (rs.next()) {
                iMinNum = rs.getString("minFNum");
                iMaxNum = rs.getString("maxFNum");
            }
            logger.debug((Object)("iMinNum" + iMinNum));
            logger.debug((Object)("iMaxNum" + iMaxNum));
            tfVoucherNumberBegin.setText(iMinNum == null ? "" : iMinNum);
            tfVoucherNumberEnd.setText(iMaxNum == null ? "" : iMaxNum);
        }
        catch (SQLException sqlE) {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
            return;
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    @Override
    public Map getExtraData(String strFilePath, String strFileName, VoucherImpExpParam filterParam) throws EASBizException {
        HashMap extraDataMap = new HashMap();
        Connection conn = null;
        StringBuffer sqlBuffer = new StringBuffer("SELECT distinct   fserialno  ");
        if (this.hasCompanyNum) {
            sqlBuffer.append(" , FGROUPID ");
        }
        sqlBuffer.append(this.getVoucherFilter(strFilePath + "\\" + strFileName, filterParam));
        logger.debug((Object)("sqlBuffer:" + sqlBuffer));
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            conn = this.getConnetion(strFilePath);
            stmt = conn.prepareStatement(sqlBuffer.toString());
            int index = 1;
            stmt.setDate(index++, filterParam.getDateBegin());
            stmt.setDate(index++, filterParam.getDateEnd());
            if (filterParam.getVoucherTypeInfo() != null) {
                stmt.setString(index++, filterParam.getVoucherTypeInfo().getName().trim());
            }
            rs = stmt.executeQuery();
            String sId = null;
            String companyNumber = null;
            while (rs.next()) {
                sId = String.valueOf(rs.getInt("fserialno"));
                companyNumber = this.hasCompanyNum ? rs.getString("FGROUPID") : this.getCompany().getNumber();
                list.add(companyNumber + "&" + sId);
            }
        }
        catch (SQLException sqlE) {
            try {
                logger.error((Object)sqlE);
                throw new VoucherExpImpException(VoucherExpImpException.IMP_SETNUMBERRANGE_EXCEPTION, sqlE);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        extraDataMap.put("fserialnoList", list);
        return extraDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map expVoucher(String strFullName, String strFilePath, String strFileName, boolean overide, VoucherImpExpParam filterParam) throws Exception {
        this.info("Export start");
        Map<String, StringBuffer> map = new HashMap<String, StringBuffer>();
        StringBuffer areaInfo = new StringBuffer();
        map.put("areainfo", areaInfo);
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(currentTime);
        int expCount = 0;
        String strPeriodInfoMidTitle = this.getResx(EXP_RES_NAME, "PeriodInfoMid");
        String strPeriodNumberTitle = this.getResx(EXP_RES_NAME, "PeriodNumber");
        String strVoucherTitle = this.getResx(EXP_RES_NAME, "Voucher");
        String strExpOKTitle = this.getResx(EXP_RES_NAME, "ExpOK");
        String strExpNotOKTitle = this.getResx(EXP_RES_NAME, "ExpNotOK");
        String expResult_before = this.getResx(EXP_RES_NAME, "ExpResult_before");
        String expResult_after = this.getResx(EXP_RES_NAME, "ExpResult_after");
        IGLGeneralFacade facade = GLGeneralFacadeFactory.getRemoteInstance();
        Calendar start = Calendar.getInstance();
        this.info("Get voucher pks ...");
        FilterInfo filter = this.getFilterInfo(filterParam);
        IObjectPK[] pkList = this.getVoucherPkList(filter);
        Calendar end = Calendar.getInstance();
        logger.debug((Object)("1 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
        int size = pkList.length;
        FileNameHelp help = new FileNameHelp(strFullName);
        for (int cu = 0; cu < size; cu += 100) {
            this.info("Get vouchers " + cu + "/" + size + " ...");
            VoucherCollection voucherCollection = this.getVoucherPkList(cu, size, pkList, filter);
            this.info("Build dbf " + cu + "/" + size + " ...");
            end = Calendar.getInstance();
            logger.debug((Object)("2." + (cu + 1) + " " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
            if (voucherCollection != null && voucherCollection.size() > 0) {
                if (cu > 0) {
                    overide = false;
                }
                logger.debug((Object)(GLResUtil.getRes("import_result_info_tip") + strFullName));
                Connection conn = null;
                try {
                    conn = this.createTable(help, overide);
                    for (int i = 0; i < voucherCollection.size(); ++i) {
                        VoucherInfo tmpVoucher = voucherCollection.get(i);
                        end = Calendar.getInstance();
                        logger.debug((Object)("3." + (i + 1) + " " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
                        CompanyOrgUnitInfo tmpCompany = GlUtils.getCompanyById(tmpVoucher.getCompany().getId().toString());
                        String companyName = " " + tmpCompany.getName() + " ";
                        int iPeriodYear = tmpVoucher.getPeriod().getPeriodYear();
                        int iPeriodNumber = tmpVoucher.getPeriod().getPeriodNumber();
                        String strVoucherTypeInfo = null;
                        if (tmpVoucher.getVoucherType() != null && tmpVoucher.getVoucherType().getName() != null) {
                            strVoucherTypeInfo = tmpVoucher.getVoucherType().getName().trim();
                        }
                        String strVoucherNumber = "";
                        if (tmpVoucher.getNumber() != null) {
                            strVoucherNumber = tmpVoucher.getNumber().trim();
                        }
                        String strVoucher = strVoucherTitle + GLResUtil.getRes("sign_colon") + companyName + iPeriodYear + strPeriodInfoMidTitle;
                        strVoucher = strVoucher + iPeriodNumber + strPeriodNumberTitle;
                        strVoucher = strVoucher + strVoucherTypeInfo + strVoucherNumber;
                        try {
                            this.chechVoucherAssit(tmpVoucher, filterParam);
                            this.exportSingleVoucher(conn, help, tmpVoucher, expCount, facade, filterParam);
                            logger.debug((Object)("expCount:" + ++expCount));
                            areaInfo.append(this.getMessageBuffer(strVoucher, strExpOKTitle));
                            continue;
                        }
                        catch (Exception _ex) {
                            logger.error((Object)_ex.getMessage(), (Throwable)_ex);
                            areaInfo.append(this.getMessageBuffer(strVoucher, strExpNotOKTitle));
                            this.info(GlUtils.printStackTrace(_ex));
                            this.core.handUIException((Throwable)_ex);
                        }
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(conn);
                    map.put("areainfo", areaInfo);
                    StringBuffer resultInfo = new StringBuffer(expResult_before + expCount + expResult_after);
                    map.put("resultinfo", resultInfo);
                    throw throwable;
                }
                SQLUtils.cleanup((Connection)conn);
                map.put("areainfo", areaInfo);
                StringBuffer resultInfo = new StringBuffer(expResult_before + expCount + expResult_after);
                map.put("resultinfo", resultInfo);
            }
            end = Calendar.getInstance();
            logger.debug((Object)("4 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
            if (size == 0) {
                map = this.haveNoVoucher(expResult_before, expResult_after);
                continue;
            }
            try {
                File file;
                if (expCount > 0) {
                    try {
                        file = new File(help.getCFFullFileName());
                        file.renameTo(new File(help.getCFFullFileName()));
                        file = new File(help.getFullFileName());
                        file.renameTo(new File(help.getFullFileName()));
                    }
                    catch (Exception _ignore) {
                        logger.error((Object)_ignore);
                    }
                    continue;
                }
                file = new File(help.getCFFullFileName());
                if (file.exists()) {
                    try {
                        file.delete();
                    }
                    catch (Exception _ignore) {
                        logger.error((Object)_ignore);
                    }
                }
                if (!(file = new File(help.getFullFileName())).exists()) continue;
                try {
                    file.delete();
                }
                catch (Exception _ignore) {
                    logger.error((Object)_ignore);
                }
                continue;
            }
            catch (Exception _ignore) {
                logger.error((Object)_ignore);
            }
        }
        end = Calendar.getInstance();
        logger.debug((Object)("5 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
        if (size == 0) {
            map = this.haveNoVoucher(expResult_before, expResult_after);
        }
        this.info("Export end");
        return map;
    }

    private StringBuffer getVoucherSelector() {
        StringBuffer strBuffer = new StringBuffer();
        if (this.hasCompanyNum) {
            strBuffer.append("  SELECT distinct FGROUPID,FDATE,FTRANSDATE,FPERIOD,FGROUP,FNUM,");
        } else {
            strBuffer.append("  SELECT distinct FDATE,FTRANSDATE,FPERIOD,FGROUP,FNUM,");
        }
        strBuffer.append("FPREPARE,FPAY,FCASH,FPOSTER,FCHECKER,FATTCHMENT,FPOSTED,");
        strBuffer.append("FMODULE,FDELETED,FSERIALNO,FREFERENCE,FCASHFLOW ");
        if (this.gl_111) {
            strBuffer.append(",FPROFITCEN");
        }
        strBuffer.append(" ,FENTRYID,FEXP,FACCTID,FCYID,FEXCHRATE,FDC,FPRICE,FUNITNAME ");
        strBuffer.append("  ,FCLSNAME1,FOBJID1,FOBJNAME1,FCLSNAME2,FOBJID2,FOBJNAME2,FCLSNAME3,FOBJID3,FOBJNAME3,");
        strBuffer.append(" FCLSNAME4,FOBJID4,FOBJNAME4,FCLSNAME5,FOBJID5,FOBJNAME5,FCLSNAME6,FOBJID6,FOBJNAME6,");
        strBuffer.append(" FCLSNAME7,FOBJID7,FOBJNAME7,FCLSNAME8,FOBJID8,FOBJNAME8, ");
        strBuffer.append(" FDES,FTRANSID,FFCYAMT,FQTY,fassistqty,FDEBIT,FCREDIT,FSETTLCODE,FSETTLENO, ");
        strBuffer.append("   fassistuni,finvnum,fticketnum,fcustomer,ffeetype,");
        strBuffer.append("   fmaterial,forgunit,fhandler,fsupplier,fbizdate,fenddate ");
        return strBuffer;
    }

    private StringBuffer getVoucherForSelector() {
        StringBuffer strBuffer = new StringBuffer();
        if (this.hasCompanyNum) {
            strBuffer.append("  SELECT distinct FGROUPID,FDATE,FTRANSDATE,FPERIOD,FGROUP,FNUM,FCYID,");
        } else {
            strBuffer.append("  SELECT distinct FDATE,FTRANSDATE,FPERIOD,FGROUP,FNUM,FCYID,");
        }
        strBuffer.append("FPREPARE,FPAY,FCASH,FPOSTER,FCHECKER,FATTCHMENT,FPOSTED,");
        strBuffer.append("FREFERENCE, ");
        strBuffer.append("FMODULE,FDELETED,FSERIALNO,FREFERENCE,FCASHFLOW ");
        if (this.gl_111) {
            strBuffer.append(",FPROFITCEN");
        }
        strBuffer.append(" ,FENTRYID,FEXP,FACCTID,FCYID,FEXCHRATE,FDC,FPRICE,FUNITNAME ");
        strBuffer.append("  ,FCLSNAME1,FOBJID1,FOBJNAME1,FCLSNAME2,FOBJID2,FOBJNAME2,FCLSNAME3,FOBJID3,FOBJNAME3,");
        strBuffer.append(" FCLSNAME4,FOBJID4,FOBJNAME4,FCLSNAME5,FOBJID5,FOBJNAME5,FCLSNAME6,FOBJID6,FOBJNAME6,");
        strBuffer.append(" FCLSNAME7,FOBJID7,FOBJNAME7,FCLSNAME8,FOBJID8,FOBJNAME8, ");
        strBuffer.append(" FDES,FTRANSID,FFCYAMT,FQTY,fassistqty,FDEBIT,FCREDIT,FSETTLCODE,FSETTLENO, ");
        strBuffer.append("   fassistuni,finvnum,fticketnum,fcustomer,ffeetype,");
        strBuffer.append("   fmaterial,forgunit,fhandler,fsupplier,fbizdate,fenddate ");
        return strBuffer;
    }

    private String getVoucherSorter() {
        return " ORDER BY FPERIOD,FGROUP,FNUM ";
    }

    private StringBuffer getVoucherEntrySelector() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("  SELECT distinct fnum,FENTRYID,FEXP,FACCTID,FCYID,FEXCHRATE,FDC,FPRICE,FUNITNAME ");
        return strBuffer;
    }

    private String getVoucherEntryFilter(String strFileName, ImpVoucherStructure impVoucher) {
        String filter = " FROM " + strFileName + " WHERE FNUM = ? AND FGROUP=? ";
        if (this.hasCompanyNum) {
            filter = filter + " and FGROUPID = ? ";
        }
        return filter;
    }

    private String getVoucherEntrySorter() {
        return " ORDER BY FENTRYID";
    }

    private StringBuffer getVoucherAssistSelector() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("  SELECT FCLSNAME1,FOBJID1,FOBJNAME1,FCLSNAME2,FOBJID2,FOBJNAME2,FCLSNAME3,FOBJID3,FOBJNAME3,");
        strBuffer.append(" FCLSNAME4,FOBJID4,FOBJNAME4,FCLSNAME5,FOBJID5,FOBJNAME5,FCLSNAME6,FOBJID6,FOBJNAME6,");
        strBuffer.append(" FCLSNAME7,FOBJID7,FOBJNAME7,FCLSNAME8,FOBJID8,FOBJNAME8, ");
        strBuffer.append(" FDES,FTRANSID,FDATE,ftransdate,FDC,FFCYAMT,FQTY,fassistqty,FDEBIT,FCREDIT,FSETTLCODE,FSETTLENO,FPRICE,FUNITNAME, ");
        strBuffer.append("   fassistuni,finvnum,fticketnum,fcustomer,ffeetype,");
        strBuffer.append("   FENTRYID,fnum,");
        strBuffer.append("   fmaterial,forgunit,fhandler,fsupplier,fbizdate,fenddate,FAssistPrice");
        return strBuffer;
    }

    private String getVoucherAssistFilter(String strFileName) {
        String filter = " FROM " + strFileName + " WHERE FNUM = ? AND FENTRYID = ?  AND FGROUP=? ";
        if (this.hasCompanyNum) {
            filter = filter + " and FGROUPID = ? ";
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer formatSqlToRedundancyField(Connection conn, StringBuffer strSql, String StrTable, ArrayList importDBFField) {
        String str1 = strSql.toString().toUpperCase().replaceAll(" ", "").replaceFirst("SELECT", "");
        StringBuffer newStrSql = new StringBuffer(str1 + ",");
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("select top 1 * from " + StrTable);
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int rsmdCount = rsmd.getColumnCount();
            for (int i = 0; i < rsmdCount; ++i) {
                importDBFField.add(rsmd.getColumnName(i + 1).toUpperCase());
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        catch (SQLException e) {
            logger.error((Object)"conn close");
        }
        finally {
            SQLUtils.cleanup(rs, ps);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(newStrSql.toString(), ",");
        while (stringTokenizer.hasMoreElements()) {
            String temp = stringTokenizer.nextToken();
            if (importDBFField.contains(temp.trim())) continue;
            int tempSize = new String(temp + ",").length();
            int index = newStrSql.indexOf(temp + ",");
            newStrSql.replace(index, index + tempSize, "");
        }
        newStrSql.insert(0, "select ").replace(newStrSql.length() - 1, newStrSql.length(), "");
        return newStrSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getImpVoucheAssist(String strFileName, VoucherEntryInfo entry, ImpVoucherStructure impVoucher, VoucherImpExpParam filterParam, StringBuffer areaInfo) throws EASBizException, BOSException {
        StringBuffer voucherAssistSelector = this.getVoucherAssistSelector();
        JdbcRowSet rsVoucherAssist = null;
        PreparedStatement stmtVoucherAsst = null;
        ResultSet rsVoucherAsstRS = null;
        Connection conn = null;
        ArrayList importDBFField = new ArrayList();
        try {
            conn = this.getConnetion(strFileName);
            voucherAssistSelector = this.formatSqlToRedundancyField(conn, voucherAssistSelector, strFileName, importDBFField);
            String voucherAssistFilter = this.getVoucherAssistFilter(strFileName);
            StringBuffer voucherAssistSQL = new StringBuffer();
            voucherAssistSQL.append(voucherAssistSelector).append(voucherAssistFilter);
            rsVoucherAssist = new JdbcRowSet();
            stmtVoucherAsst = conn.prepareStatement(voucherAssistSQL.toString());
            int indexEntry = 1;
            stmtVoucherAsst.setString(indexEntry++, impVoucher.getIVoucherNumber());
            stmtVoucherAsst.setInt(indexEntry++, entry.getSeq());
            stmtVoucherAsst.setString(indexEntry++, impVoucher.getVoucherInfo().getVoucherType().getName());
            if (this.hasCompanyNum) {
                stmtVoucherAsst.setString(indexEntry++, impVoucher.getVoucherInfo().getCompany().getNumber());
            }
            rsVoucherAsstRS = stmtVoucherAsst.executeQuery();
            rsVoucherAssist.populate(rsVoucherAsstRS);
        }
        catch (Exception _ex) {
            try {
                logger.error((Object)_ex);
                throw new BOSException((Throwable)_ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsVoucherAsstRS, stmtVoucherAsst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsVoucherAsstRS, (Statement)stmtVoucherAsst, (Connection)conn);
        AccountViewInfo acc = entry.getAccount();
        try {
            int assistCount = 0;
            BigDecimal entry_originalAmount = SysConstant.BIGZERO;
            BigDecimal entry_localAmount = SysConstant.BIGZERO;
            BigDecimal entry_qunatity = SysConstant.BIGZERO;
            while (rsVoucherAssist.next()) {
                String message;
                StringBuffer sb;
                String INDEX;
                BigDecimal price;
                String strSettleNumber;
                BigDecimal quantity;
                String message2;
                String bizNumber;
                VoucherAssistRecordInfo assitInfo = new VoucherAssistRecordInfo();
                assitInfo.setOprStatus(1);
                assitInfo.setSeq(assistCount);
                int iSeq = rsVoucherAssist.getInt("FENTRYID");
                String voucherNumber = rsVoucherAssist.getString("FNUM");
                StringBuffer sb5 = new StringBuffer();
                sb5.append(voucherNumber).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1054_VoucherDBFSparser"));
                sb5.append(iSeq).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1055_VoucherDBFSparser"));
                String msg = sb5.toString();
                if (importDBFField.contains("FDES")) {
                    String des = rsVoucherAssist.getString("FDES");
                    assitInfo.setDescription(des);
                }
                if ((bizNumber = rsVoucherAssist.getString("FTRANSID")) != null) {
                    assitInfo.setBizNumber(bizNumber.trim());
                }
                boolean isUpFrom530 = false;
                Date bizDate = null;
                Date endDate1 = null;
                String invnum = null;
                try {
                    bizDate = rsVoucherAssist.getDate("fbizdate");
                    endDate1 = rsVoucherAssist.getDate("fenddate");
                    invnum = rsVoucherAssist.getString("finvnum");
                }
                catch (Exception e) {
                    isUpFrom530 = true;
                }
                if (!isUpFrom530) {
                    Date asstBizDate = bizDate;
                    if (asstBizDate != null) {
                        assitInfo.setBizDate((java.util.Date)asstBizDate);
                        VoucherInfo voucherInfo = impVoucher.getVoucherInfo();
                        Date assitbizDate = new Date(assitInfo.getBizDate().getYear(), assitInfo.getBizDate().getMonth(), assitInfo.getBizDate().getDate());
                        Date bookDate = new Date(voucherInfo.getBookedDate().getYear(), voucherInfo.getBookedDate().getMonth(), voucherInfo.getBookedDate().getDate());
                        if (assitbizDate.after(bookDate)) {
                            String ASsistBizDateNotBook;
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            String INDEX2 = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                            String errMsg = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource", (String)"ASsistBizDateNotBook");
                            StringBuffer sb6 = new StringBuffer(voucherInfo.getCompany().getNumber());
                            sb6.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                            sb6.append(INDEX2).append(entry.getSeq()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"353_VoucherLeadControlControllerBean")).append(errMsg);
                            message2 = ASsistBizDateNotBook = sb6.toString();
                            impVoucher.getLstErrorInfo().add(message2);
                            areaInfo.append(message2);
                            areaInfo.append("\r\n");
                        }
                    }
                    Date endDate = endDate1;
                    if (acc.isAC()) {
                        if (endDate == null) {
                            assitInfo.setEndDate(assitInfo.getBizDate());
                        } else {
                            assitInfo.setEndDate((java.util.Date)endDate);
                        }
                    }
                }
                if ((quantity = rsVoucherAssist.getBigDecimal("FQTY")) == null) {
                    quantity = GlUtils.zero;
                }
                assitInfo.setQuantity(quantity);
                BigDecimal asstquantity = null;
                try {
                    asstquantity = rsVoucherAssist.getBigDecimal("fassistqty");
                }
                catch (Exception e) {
                    asstquantity = GlUtils.zero;
                }
                if (asstquantity == null) {
                    asstquantity = GlUtils.zero;
                }
                assitInfo.setAssistQty(asstquantity);
                BigDecimal originalAmount = rsVoucherAssist.getBigDecimal("FFCYAMT");
                String strDC = rsVoucherAssist.getString("FDC");
                BigDecimal asstprice = new BigDecimal(0);
                if (strDC.trim().equals("1")) {
                    BigDecimal debitAmount = rsVoucherAssist.getBigDecimal("FDEBIT");
                    assitInfo.setLocalAmount(debitAmount);
                    assitInfo.setReportingAmount(debitAmount);
                    if (asstquantity.intValue() != 0) {
                        asstprice = debitAmount.divide(asstquantity, 2, 5);
                    }
                } else {
                    BigDecimal creditAmount = rsVoucherAssist.getBigDecimal("FCREDIT");
                    assitInfo.setLocalAmount(creditAmount);
                    assitInfo.setReportingAmount(creditAmount);
                    if (asstquantity.intValue() != 0) {
                        asstprice = creditAmount.divide(asstquantity, 2, 5);
                    }
                }
                if (originalAmount != null && assitInfo.getLocalAmount() != null && entry.getCurrency() != null && impVoucher.getVoucherInfo().getCompany().getBaseCurrency() != null && entry.getCurrency().getId().toString().equals(impVoucher.getVoucherInfo().getCompany().getBaseCurrency().getId().toString())) {
                    if (originalAmount.compareTo(GlUtils.zero) == 0) {
                        originalAmount = assitInfo.getLocalAmount();
                    }
                    if (originalAmount.compareTo(assitInfo.getLocalAmount()) != 0) {
                        impVoucher.setBreak(true);
                        impVoucher.setBNoWrong(false);
                        String INDEX3 = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                        String errMsg = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "oAmount_notEquanls_locAmount");
                        StringBuffer sb7 = new StringBuffer(impVoucher.getVoucherInfo().getCompany().getNumber());
                        sb7.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                        sb7.append(INDEX3).append(entry.getSeq()).append(errMsg);
                        message2 = sb7.toString();
                        impVoucher.getLstErrorInfo().add(message2);
                        areaInfo.append(message2);
                        areaInfo.append("\r\n");
                        return;
                    }
                }
                assitInfo.setOriginalAmount(originalAmount);
                assitInfo.setAssistPrice(asstprice);
                String strSettleCode = rsVoucherAssist.getString("FSETTLCODE");
                if (strSettleCode != null) {
                    SettlementTypeInfo settlementTypeInfo = this.findSettelmentTypeByName(strSettleCode);
                    if (settlementTypeInfo == null) {
                        impVoucher.setBreak(true);
                        impVoucher.setBNoWrong(false);
                        StringBuffer sb8 = new StringBuffer(msg);
                        sb8.append(impVoucher.getVoucherInfo().getCompany().getNumber());
                        sb8.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1058_VoucherDBFSparser"));
                        sb8.append(strSettleCode).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                        message2 = sb8.toString();
                        impVoucher.getLstErrorInfo().add(message2);
                        areaInfo.append(message2);
                        areaInfo.append("\r\n");
                        return;
                    }
                    assitInfo.setSettlementType(settlementTypeInfo);
                }
                if ((strSettleNumber = rsVoucherAssist.getString("FSETTLENO")) != null) {
                    assitInfo.setSettlementCode(strSettleNumber.trim());
                }
                if (!isUpFrom530) {
                    String strSupplier;
                    String strCompanyOrgUnit;
                    String strMaterial;
                    String strHandler;
                    String strFeeType;
                    String strCustomer;
                    String strTicketNumber;
                    String strInvoiceNumber = invnum;
                    if (strInvoiceNumber != null) {
                        assitInfo.setInvoiceNumber(strInvoiceNumber);
                    }
                    if ((strTicketNumber = rsVoucherAssist.getString("fticketnum")) != null) {
                        assitInfo.setTicketNumber(strTicketNumber);
                    }
                    if (this.isNullString(strCustomer = rsVoucherAssist.getString("fcustomer"))) {
                        strCustomer = null;
                    }
                    if (strCustomer != null) {
                        CustomerInfo customerInfo = this.findCustomerByName(strCustomer, impVoucher.getVoucherInfo().getCompany().getId().toString());
                        if (customerInfo == null) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            StringBuffer sb9 = new StringBuffer(msg);
                            sb9.append(impVoucher.getVoucherInfo().getCompany().getNumber());
                            sb9.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1059_VoucherDBFSparser"));
                            sb9.append(strCustomer).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                            String message3 = sb9.toString();
                            impVoucher.getLstErrorInfo().add(message3);
                            areaInfo.append(message3);
                            areaInfo.append("\r\n");
                            return;
                        }
                        assitInfo.setCustomer(customerInfo);
                    }
                    if (this.isNullString(strFeeType = rsVoucherAssist.getString("ffeetype"))) {
                        strFeeType = null;
                    }
                    if (strFeeType != null) {
                        assitInfo.setFeeType(FeeTypeEnum.getEnum((int)Integer.parseInt(strFeeType)));
                    }
                    if (this.isNullString(strHandler = rsVoucherAssist.getString("fhandler"))) {
                        strHandler = null;
                    }
                    if (strHandler != null) {
                        UserInfo handlerInfo = this.findUserUByNumber(strHandler);
                        if (handlerInfo == null) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            StringBuffer sb2 = new StringBuffer(msg);
                            sb2.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1060_VoucherDBFSparser"));
                            sb2.append(strHandler).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                            String message4 = sb2.toString();
                            impVoucher.getLstErrorInfo().add(message4);
                            areaInfo.append(message4);
                            areaInfo.append("\r\n");
                            return;
                        }
                        assitInfo.setHandler(handlerInfo);
                    }
                    if (this.isNullString(strMaterial = rsVoucherAssist.getString("fmaterial"))) {
                        strMaterial = null;
                    }
                    if (strMaterial != null) {
                        MaterialInfo materialInfo = this.findMaterialByName(strMaterial, impVoucher.getVoucherInfo().getCompany().getId().toString());
                        if (materialInfo == null) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            StringBuffer sb3 = new StringBuffer(msg);
                            sb3.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1061_VoucherDBFSparser"));
                            sb3.append(strMaterial).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                            String message5 = sb3.toString();
                            impVoucher.getLstErrorInfo().add(message5);
                            areaInfo.append(message5);
                            areaInfo.append("\r\n");
                            return;
                        }
                        assitInfo.setMaterial(materialInfo);
                    }
                    if (this.isNullString(strCompanyOrgUnit = rsVoucherAssist.getString("forgunit"))) {
                        strCompanyOrgUnit = null;
                    }
                    if (strCompanyOrgUnit != null) {
                        CompanyOrgUnitInfo orgUnitInfo = this.findCompanyOrgUnitByName(strCompanyOrgUnit);
                        if (orgUnitInfo == null) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            StringBuffer sb4 = new StringBuffer(msg);
                            sb4.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1062_VoucherDBFSparser"));
                            sb4.append(strCompanyOrgUnit).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                            String message6 = sb4.toString();
                            impVoucher.getLstErrorInfo().add(message6);
                            areaInfo.append(message6);
                            areaInfo.append("\r\n");
                            return;
                        }
                        assitInfo.setOrgUnit(orgUnitInfo);
                    }
                    if (this.isNullString(strSupplier = rsVoucherAssist.getString("fsupplier"))) {
                        strSupplier = null;
                    }
                    if (strSupplier != null) {
                        SupplierInfo supplier = this.findSupplierByName(strSupplier, impVoucher.getVoucherInfo().getCompany().getId().toString());
                        if (strSupplier == null) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            StringBuffer sb6 = new StringBuffer(msg);
                            sb6.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1063_VoucherDBFSparser"));
                            sb6.append(strSupplier).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1027_VoucherXLSSparser"));
                            String message7 = sb6.toString();
                            impVoucher.getLstErrorInfo().add(message7);
                            areaInfo.append(message7);
                            areaInfo.append("\r\n");
                            return;
                        }
                        assitInfo.setSupplier(supplier);
                    }
                }
                if ((price = rsVoucherAssist.getBigDecimal("FPRICE")) == null) {
                    price = GlUtils.zero;
                }
                assitInfo.setPrice(price);
                String strUnitName = rsVoucherAssist.getString("FUNITNAME");
                MeasureUnitInfo measureUnitInfo = this.findUnitByName(strUnitName, acc);
                assitInfo.setMeasureUnit(measureUnitInfo);
                AssistantHGInfo assistantHGInfo = new AssistantHGInfo();
                String strAsstUnitName = null;
                try {
                    strAsstUnitName = rsVoucherAssist.getString("fassistuni");
                }
                catch (Exception e) {
                    strAsstUnitName = "";
                }
                MeasureUnitInfo measureAsstUnitInfo = this.findUnitByName(strAsstUnitName, acc);
                assitInfo.setAssistUnit(measureAsstUnitInfo);
                boolean isHasAssist = false;
                boolean isAssist = false;
                int entrySeq = entry.getSeq();
                AsstActTypeCollection arrayAsstActTypeIndfo = new AsstActTypeCollection();
                String strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME1");
                String strAsstActID = rsVoucherAssist.getString("FOBJID1");
                String strAsstActName = rsVoucherAssist.getString("FOBJNAME1");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 1, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                boolean isChkHalfInivableSaveVoucher = filterParam.isChkHalfInviableSaveVoucher();
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME2");
                strAsstActID = rsVoucherAssist.getString("FOBJID2");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME2");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 2, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME3");
                strAsstActID = rsVoucherAssist.getString("FOBJID3");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME3");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 3, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME4");
                strAsstActID = rsVoucherAssist.getString("FOBJID4");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME4");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 4, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME5");
                strAsstActID = rsVoucherAssist.getString("FOBJID5");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME5");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 5, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME6");
                strAsstActID = rsVoucherAssist.getString("FOBJID6");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME6");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 6, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME7");
                strAsstActID = rsVoucherAssist.getString("FOBJID7");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME7");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 7, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                strAsstActTypeName = rsVoucherAssist.getString("FCLSNAME8");
                strAsstActID = rsVoucherAssist.getString("FOBJID8");
                strAsstActName = rsVoucherAssist.getString("FOBJNAME8");
                isAssist = this.constructAssistInfo(impVoucher.getVoucherInfo().getCompany(), assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstActName, arrayAsstActTypeIndfo, impVoucher, null, filterParam, areaInfo, entrySeq, 8, acc, entry.getCurrency(), impVoucher.getVoucherInfo().getCreator().getId().toString());
                if (isAssist) {
                    isHasAssist = true;
                }
                if (impVoucher.isBreak() && !isChkHalfInivableSaveVoucher) {
                    return;
                }
                if (isHasAssist && acc.getCAA() == null) {
                    impVoucher.setBreak(true);
                    impVoucher.setBNoWrong(false);
                    INDEX = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                    String NOT_MATCH_ACC = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "NOT_MATCH_ACC");
                    sb = new StringBuffer(msg);
                    sb.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                    sb.append(INDEX).append(entry.getSeq()).append(NOT_MATCH_ACC);
                    message = sb.toString();
                    impVoucher.getLstErrorInfo().add(message);
                    areaInfo.append(message);
                    areaInfo.append("\r\n");
                    return;
                }
                if (!isHasAssist && acc.getCAA() != null) {
                    impVoucher.setBreak(true);
                    impVoucher.setBNoWrong(false);
                    INDEX = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                    String NOT_ACC_ASSISt = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "NOT_ACC_ASSIST");
                    sb = new StringBuffer(msg);
                    sb.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                    sb.append(INDEX).append(entry.getSeq()).append(NOT_ACC_ASSISt);
                    message = sb.toString();
                    impVoucher.getLstErrorInfo().add(message);
                    areaInfo.append(message);
                    areaInfo.append("\r\n");
                    return;
                }
                if (!isHasAssist && acc.getCAA() == null && !acc.isHasUserProperty()) {
                    entry.setOriginalAmount(assitInfo.getOriginalAmount());
                    entry.setLocalAmount(assitInfo.getLocalAmount());
                    entry.setReportingAmount(assitInfo.getReportingAmount());
                    entry.setQuantity(assitInfo.getQuantity());
                    return;
                }
                if (isHasAssist && acc.getCAA() != null || acc.isHasUserProperty()) {
                    StringBuffer sb7;
                    try {
                        if (acc.getCAA() != null) {
                            IAssistantHG igCtrl = AssistantHGFactory.getRemoteInstance();
                            AssistantHGInfo actualAssistantHGInfo = igCtrl.getAssistantHG(assistantHGInfo, entry.getAccount().getCAA().getId().toString(), arrayAsstActTypeIndfo);
                            assitInfo.setAssGrp(actualAssistantHGInfo);
                        }
                        assitInfo.setEntry(entry);
                        VoucherInfo voucher = impVoucher.getVoucherInfo();
                        assitInfo.setBill(voucher);
                        assitInfo.setBizDate(voucher.getBizDate());
                        entry_originalAmount = entry_originalAmount.add(assitInfo.getOriginalAmount());
                        entry_localAmount = entry_localAmount.add(assitInfo.getLocalAmount());
                        entry_qunatity = entry_qunatity.add(assitInfo.getQuantity());
                        boolean canSaveZero = false;
                        try {
                            canSaveZero = Boolean.valueOf(GlUtils.getParamByKey(null, voucher.getCompany().getId().toString(), "GL_0301").toString());
                        }
                        catch (EASBizException e) {
                            logger.error((Object)e);
                        }
                        if (filterParam.isPost() && !canSaveZero && GlUtils.isAllZeroOrNull(new BigDecimal[]{assitInfo.getQuantity(), assitInfo.getOriginalAmount(), assitInfo.getLocalAmount()})) {
                            impVoucher.setBreak(true);
                            impVoucher.setBNoWrong(false);
                            String INDEX4 = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                            sb7 = new StringBuffer(voucher.getCompany().getNumber());
                            sb7.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                            sb7.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource", (String)"recordZero"));
                            String NOT_ACC_ASSIST = sb7.toString();
                            StringBuffer sb1 = new StringBuffer(INDEX4);
                            sb1.append(entry.getSeq()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1031_VoucherXLSSparser"));
                            sb1.append(NOT_ACC_ASSIST);
                            String message8 = sb1.toString();
                            impVoucher.getLstErrorInfo().add(message8);
                            areaInfo.append(message8);
                            areaInfo.append("\r\n");
                            if (!isChkHalfInivableSaveVoucher) {
                                return;
                            }
                        }
                        entry.getAssistRecords().add(assitInfo);
                    }
                    catch (Exception exAssist) {
                        impVoucher.setBreak(true);
                        impVoucher.setBNoWrong(false);
                        String INDEX5 = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                        String NOT_ACC_ASSIST = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "NOT_ACC_ASSIST");
                        sb7 = new StringBuffer(msg);
                        sb7.append(impVoucher.getVoucherInfo().getCompany().getNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                        sb7.append(INDEX5).append(entry.getSeq()).append(NOT_ACC_ASSIST);
                        String message9 = sb7.toString();
                        impVoucher.getLstErrorInfo().add(message9);
                        areaInfo.append(message9);
                        areaInfo.append("\r\n");
                        logger.error((Object)exAssist);
                        return;
                    }
                }
                ++assistCount;
            }
            if (impVoucher.isBNoWrong() && assistCount == 0) {
                impVoucher.setBreak(true);
                impVoucher.setBNoWrong(false);
                String INDEX = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "INDEX");
                String NOT_ASSIST_COUNT = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "NOT_ASSIST_COUNT");
                StringBuffer sb = new StringBuffer(impVoucher.getVoucherInfo().getCompany().getNumber());
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
                sb.append(INDEX).append(entry.getSeq()).append(NOT_ASSIST_COUNT);
                String message = sb.toString();
                impVoucher.getLstErrorInfo().add(message);
                areaInfo.append(message);
                areaInfo.append("\r\n");
            }
            entry.setOriginalAmount(entry_originalAmount);
            entry.setLocalAmount(entry_localAmount);
            entry.setReportingAmount(entry_localAmount);
            entry.setQuantity(entry_qunatity);
        }
        catch (SQLException _exEntry) {
            impVoucher.setBreak(true);
            impVoucher.setBNoWrong(false);
            String CANNT_GET_ENTRY = this.getResx("com.kingdee.eas.fi.gl.VoucherImpWizardUI", "CANNT_GET_ENTRY");
            impVoucher.getLstErrorInfo().add(CANNT_GET_ENTRY);
            areaInfo.append(CANNT_GET_ENTRY);
            areaInfo.append("\r\n");
            logger.error((Object)_exEntry);
        }
    }

    private boolean isNullString(String strValue) {
        if (strValue == null) {
            return true;
        }
        return "null".equalsIgnoreCase(strValue) || strValue.trim().length() == 0;
    }

    private StringBuffer getVoucherFilter(String strFileName, VoucherImpExpParam filterParam) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" FROM " + strFileName);
        strBuffer.append("  WHERE ( Fdate >= ?  AND FDate <= ? ) or FDate is null ");
        if (filterParam.getVoucherTypeInfo() != null) {
            strBuffer.append("     AND FGroup = ? ");
        }
        if (filterParam.isIncludeNoPost() && !filterParam.isIncludePost()) {
            strBuffer.append("   AND FPosted = false ");
        } else if (!filterParam.isIncludeNoPost() && filterParam.isIncludePost()) {
            strBuffer.append("   AND FPosted = true ");
        } else if (filterParam.isIncludeNoPost() || !filterParam.isIncludePost()) {
            // empty if block
        }
        return strBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSingleVoucher(Connection conn, FileNameHelp help, VoucherInfo tmpVoucher, int expCount, IGLGeneralFacade facade, VoucherImpExpParam filterParam) throws SQLException, EASBizException, BOSException {
        block61: {
            int iLen;
            PreparedStatement stmt = null;
            PreparedStatement cashFlowStmt = null;
            CompanyOrgUnitInfo company = GlUtils.getCompanyById(tmpVoucher.getCompany().getId().toString());
            Date voucherBookDate = (Date)tmpVoucher.getBookedDate();
            logger.debug((Object)(GLResUtil.getRes("voucher_date") + voucherBookDate));
            Date voucherBizDate = (Date)tmpVoucher.getBizDate();
            PeriodInfo periodInfo = tmpVoucher.getPeriod();
            int iPeriodNumber = periodInfo.getPeriodNumber();
            VoucherTypeInfo voucherTypeInfo = tmpVoucher.getVoucherType();
            String strVoucherTypeInfo = "";
            if (voucherTypeInfo != null) {
                strVoucherTypeInfo = voucherTypeInfo.getName().trim();
            }
            String iNumber = tmpVoucher.getNumber();
            if (!filterParam.isRetainOrgNumber()) {
                iNumber = String.valueOf(expCount);
            }
            UserInfo userPrepare = tmpVoucher.getCreator();
            String strPrepare = null;
            if (userPrepare != null) {
                strPrepare = userPrepare.getNumber().trim();
            }
            UserInfo userPost = tmpVoucher.getPoster();
            String strPoster = null;
            if (userPost != null) {
                strPoster = userPost.getNumber().trim();
            }
            UserInfo userCheck = tmpVoucher.getAuditor();
            String strChecker = null;
            if (userCheck != null) {
                strChecker = userCheck.getNumber().trim();
            }
            int iAttachement = tmpVoucher.getAttachments();
            VoucherStatusEnum status = tmpVoucher.getBizStatus();
            boolean isPosted = false;
            if (status.getValue() == VoucherStatusEnum.POSTED.getValue()) {
                isPosted = true;
            }
            String strModule = "";
            SystemEnum systemEnum = tmpVoucher.getSourceSys();
            SourceType sourceType = tmpVoucher.getSourceType();
            if (sourceType.getValue() != 0 && systemEnum.getValue() != 6 && (strModule = systemEnum.getName()) != null && (iLen = (strModule = strModule.trim()).length()) > 10) {
                strModule = strModule.substring(0, iLen);
            }
            boolean isDeleted = false;
            String iVoucherTotalNumber = String.valueOf(System.currentTimeMillis()) + "--" + expCount;
            String description = tmpVoucher.getDescription();
            String strRefrence = "";
            if (description != null) {
                strRefrence = tmpVoucher.getDescription().trim();
            }
            try {
                StringBuffer strBuffer = new StringBuffer();
                strBuffer.append(" insert into " + help.getFullFileName());
                strBuffer.append(" Values(?,?,?,?,?,?,?,?,?,?,?,");
                strBuffer.append("        ?,?,?,?,?,?,?,?,?,?,");
                strBuffer.append("        ?,?,?,?,?,?,?,?,?,?,");
                strBuffer.append("        ?,?,?,?,?,?,?,?,?,?,");
                strBuffer.append("        ?,?,?,?,?,?,?,?,?,?,");
                strBuffer.append("        ?,?,?,?,?,?,?,");
                strBuffer.append("        ?,?,?,?,?,?,?,?,?,?");
                strBuffer.append("        ,?,?");
                if (this.gl_111) {
                    strBuffer.append(",?");
                }
                strBuffer.append(")");
                VoucherEntryCollection voucherLines = tmpVoucher.getEntries();
                logger.debug((Object)("1.strBuffer:" + strBuffer));
                if (voucherLines == null || voucherLines.size() == 0) {
                    return;
                }
                stmt = conn.prepareStatement(strBuffer.toString());
                strBuffer = new StringBuffer();
                strBuffer.append(" insert into " + help.getCFFullFileName());
                strBuffer.append(" Values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
                strBuffer.append("        ?,?,?,?,?,?,?,?,?,?,");
                strBuffer.append("        ?,?,?,?,?,?,?,?,?,?,");
                strBuffer.append("        ?,?,?,?,?");
                strBuffer.append(")");
                cashFlowStmt = conn.prepareStatement(strBuffer.toString());
                for (int i = 0; i < voucherLines.size(); ++i) {
                    boolean isHasCashFlow;
                    MeasureUnitInfo measureUnitInfo;
                    VoucherEntryInfo voucherEntryInfo = voucherLines.get(i);
                    int iEntryNumber = voucherEntryInfo.getSeq();
                    logger.debug((Object)("2.iEntryNumber:" + iEntryNumber));
                    String entryDes = voucherEntryInfo.getDescription();
                    String strEntryRemark = "";
                    if (entryDes != null) {
                        strEntryRemark = voucherEntryInfo.getDescription().trim();
                    }
                    AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
                    String strAccountViewInfo = accountViewInfo.getNumber();
                    CurrencyInfo currencyInfo = voucherEntryInfo.getCurrency();
                    String strCurrencyInfo = currencyInfo.getNumber();
                    BigDecimal exchangeRate = voucherEntryInfo.getLocalExchangeRate();
                    EntryDC dc = voucherEntryInfo.getEntryDC();
                    int iDC = 0;
                    if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                        iDC = 1;
                    }
                    BigDecimal originalAmount = voucherEntryInfo.getOriginalAmount();
                    BigDecimal qty = voucherEntryInfo.getQuantity();
                    BigDecimal price = voucherEntryInfo.getPrice();
                    BigDecimal localDebit = SysConstant.BIGZERO;
                    BigDecimal localCredit = SysConstant.BIGZERO;
                    if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                        localDebit = voucherEntryInfo.getLocalAmount();
                    } else {
                        localCredit = voucherEntryInfo.getLocalAmount();
                    }
                    String strMeasureUnitInfo = null;
                    if (!filterParam.isQtyByAsst()) {
                        measureUnitInfo = voucherEntryInfo.getMeasureUnit();
                        strMeasureUnitInfo = null;
                        if (measureUnitInfo != null) {
                            strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                        }
                    }
                    CashflowRecordCollection cashFlowRecordCollection = voucherEntryInfo.getCashflowRecords();
                    VoucherAssistRecordCollection assitRecordCollection = voucherEntryInfo.getAssistRecords();
                    logger.debug((Object)("3." + assitRecordCollection));
                    if (assitRecordCollection == null || assitRecordCollection.size() == 0) {
                        int index = 1;
                        stmt.setString(index++, company.getNumber());
                        stmt.setDate(index++, voucherBookDate);
                        stmt.setDate(index++, voucherBizDate);
                        stmt.setInt(index++, iPeriodNumber);
                        stmt.setString(index++, strVoucherTypeInfo);
                        stmt.setString(index++, iNumber);
                        stmt.setInt(index++, iEntryNumber);
                        stmt.setString(index++, strEntryRemark);
                        if (this.gl_111) {
                            stmt.setString(index++, voucherEntryInfo.getProfitCenter() != null ? voucherEntryInfo.getProfitCenter().getNumber() : "");
                        }
                        stmt.setString(index++, strAccountViewInfo);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, strCurrencyInfo);
                        stmt.setBigDecimal(index++, exchangeRate);
                        stmt.setString(index++, new Integer(iDC).toString());
                        stmt.setBigDecimal(index++, originalAmount);
                        stmt.setBigDecimal(index++, qty);
                        stmt.setBigDecimal(index++, new BigDecimal(0));
                        stmt.setBigDecimal(index++, price);
                        stmt.setBigDecimal(index++, localDebit);
                        stmt.setBigDecimal(index++, localCredit);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, strPrepare);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, strPoster);
                        stmt.setString(index++, strChecker);
                        stmt.setInt(index++, iAttachement);
                        stmt.setBoolean(index++, isPosted);
                        stmt.setString(index++, strModule);
                        stmt.setBoolean(index++, isDeleted);
                        stmt.setString(index++, iVoucherTotalNumber);
                        stmt.setString(index++, strMeasureUnitInfo);
                        stmt.setString(index++, null);
                        stmt.setString(index++, strRefrence);
                        stmt.setInt(index++, tmpVoucher.getCashflowFlag().getValue());
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setString(index++, null);
                        stmt.setDate(index++, null);
                        stmt.setDate(index++, null);
                        logger.debug((Object)"4.1");
                        try {
                            stmt.executeUpdate();
                        }
                        catch (Exception e) {
                            logger.debug((Object)e.getMessage());
                            logger.error((Object)e);
                        }
                        logger.debug((Object)"4.2");
                    } else {
                        Calendar start = Calendar.getInstance();
                        for (int j = 0; j < assitRecordCollection.size(); ++j) {
                            String strTicketNumber;
                            String strInvoiceNumber;
                            String strSettleCode;
                            String strDescripton;
                            VoucherAssistRecordInfo tmpAssistRecordInfo = assitRecordCollection.get(j);
                            Calendar end = Calendar.getInstance();
                            StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1067_VoucherDBFSparser"));
                            sb.append(i).append(".").append(j).append(" ").append(GLResUtil.getRes("use_time"));
                            sb.append(end.getTimeInMillis() - start.getTimeInMillis());
                            logger.debug((Object)sb.toString());
                            originalAmount = tmpAssistRecordInfo.getOriginalAmount();
                            String strBizNumber = tmpAssistRecordInfo.getBizNumber();
                            if (strBizNumber != null) {
                                strBizNumber = strBizNumber.trim();
                            }
                            if ((strDescripton = tmpAssistRecordInfo.getDescription()) != null) {
                                strDescripton = strDescripton.trim();
                            }
                            SettlementTypeInfo settlementTypeInfo = tmpAssistRecordInfo.getSettlementType();
                            String strSettleTypeInfo = null;
                            if (settlementTypeInfo != null && settlementTypeInfo.getName() != null) {
                                strSettleTypeInfo = settlementTypeInfo.getName().trim();
                            }
                            if ((strSettleCode = tmpAssistRecordInfo.getSettlementCode()) != null) {
                                strSettleCode = strSettleCode.trim();
                            }
                            if ((strInvoiceNumber = tmpAssistRecordInfo.getInvoiceNumber()) != null) {
                                strInvoiceNumber = strInvoiceNumber.trim();
                            }
                            if ((strTicketNumber = tmpAssistRecordInfo.getTicketNumber()) != null) {
                                strTicketNumber = strTicketNumber.trim();
                            }
                            CustomerInfo customerInfo = tmpAssistRecordInfo.getCustomer();
                            String strCustomerInfo = null;
                            if (customerInfo != null) {
                                strCustomerInfo = customerInfo.getName().trim();
                            }
                            FeeTypeEnum feeType = tmpAssistRecordInfo.getFeeType();
                            String strFeeType = null;
                            if (feeType != null) {
                                strFeeType = String.valueOf(feeType.getValue());
                            }
                            UserInfo handlerInfo = tmpAssistRecordInfo.getHandler();
                            String strHandlerInfo = null;
                            if (handlerInfo != null) {
                                strHandlerInfo = handlerInfo.getNumber().trim();
                            }
                            MaterialInfo materialInfo = tmpAssistRecordInfo.getMaterial();
                            String strMaterialInfo = null;
                            if (materialInfo != null) {
                                strMaterialInfo = materialInfo.getName().trim();
                            }
                            CompanyOrgUnitInfo companyOrgUnitInfo = tmpAssistRecordInfo.getOrgUnit();
                            String strCompanyOrgUnitInfo = null;
                            if (companyOrgUnitInfo != null) {
                                strCompanyOrgUnitInfo = companyOrgUnitInfo.getName().trim();
                            }
                            SupplierInfo supplierInfo = tmpAssistRecordInfo.getSupplier();
                            String strSupplierInfo = null;
                            if (supplierInfo != null) {
                                strSupplierInfo = supplierInfo.getName().trim();
                            }
                            Date asstBizDate = (Date)tmpAssistRecordInfo.getBizDate();
                            Date endDate = (Date)tmpAssistRecordInfo.getEndDate();
                            BigDecimal asstOriginalAmount = tmpAssistRecordInfo.getOriginalAmount();
                            BigDecimal assLocalDebit = SysConstant.BIGZERO;
                            BigDecimal assLocalCredit = SysConstant.BIGZERO;
                            if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                                assLocalDebit = tmpAssistRecordInfo.getLocalAmount();
                            } else {
                                assLocalCredit = tmpAssistRecordInfo.getLocalAmount();
                            }
                            if (filterParam.isQtyByAsst()) {
                                measureUnitInfo = tmpAssistRecordInfo.getMeasureUnit();
                                strMeasureUnitInfo = null;
                                if (measureUnitInfo != null) {
                                    strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                                }
                            }
                            String strAsstMeasureUnitInfo = null;
                            BigDecimal asstQty = new BigDecimal(0);
                            if (filterParam.isQtyByAsst() && accountViewInfo.isIsQty() && filterParam.isUnitByAsst()) {
                                measureUnitInfo = tmpAssistRecordInfo.getAssistUnit();
                                if (measureUnitInfo != null) {
                                    strAsstMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                                }
                                if (tmpAssistRecordInfo.getAssistQty() != null) {
                                    asstQty = tmpAssistRecordInfo.getAssistQty();
                                }
                            }
                            BigDecimal assQty = tmpAssistRecordInfo.getQuantity();
                            String[] asstTypes = new String[8];
                            String[] asstItemNumbers = new String[8];
                            String[] asstItemNames = new String[8];
                            if (tmpAssistRecordInfo.getAssGrp() != null) {
                                BOSUuid assGrpId = tmpAssistRecordInfo.getAssGrp().getId();
                                HashMap<String, String> key = new HashMap<String, String>();
                                key.put("key", assGrpId.toString());
                                Map result = facade.dealTask("getAsstItem", key);
                                if (result != null) {
                                    AsstActTypeCollection col = (AsstActTypeCollection)result.get("value");
                                    int count = 0;
                                    if (col != null) {
                                        count = col.size();
                                    }
                                    for (int k = 0; k < count; ++k) {
                                        AsstActTypeInfo data = col.get(k);
                                        asstTypes[k] = (String)data.get("asstTypes");
                                        asstItemNumbers[k] = (String)data.get("asstItemNumbers");
                                        asstItemNames[k] = (String)data.get("asstItemNames");
                                    }
                                }
                            }
                            int index = 1;
                            stmt.setString(index++, company.getNumber());
                            stmt.setDate(index++, voucherBookDate);
                            stmt.setDate(index++, voucherBizDate);
                            stmt.setInt(index++, iPeriodNumber);
                            stmt.setString(index++, strVoucherTypeInfo);
                            stmt.setString(index++, iNumber);
                            stmt.setInt(index++, iEntryNumber);
                            stmt.setString(index++, strEntryRemark);
                            if (this.gl_111) {
                                stmt.setString(index++, voucherEntryInfo.getProfitCenter() != null ? voucherEntryInfo.getProfitCenter().getNumber() : "");
                            }
                            stmt.setString(index++, strAccountViewInfo);
                            stmt.setString(index++, asstTypes[0]);
                            stmt.setString(index++, asstItemNumbers[0]);
                            stmt.setString(index++, asstItemNames[0]);
                            stmt.setString(index++, asstTypes[1]);
                            stmt.setString(index++, asstItemNumbers[1]);
                            stmt.setString(index++, asstItemNames[1]);
                            stmt.setString(index++, asstTypes[2]);
                            stmt.setString(index++, asstItemNumbers[2]);
                            stmt.setString(index++, asstItemNames[2]);
                            stmt.setString(index++, asstTypes[3]);
                            stmt.setString(index++, asstItemNumbers[3]);
                            stmt.setString(index++, asstItemNames[3]);
                            stmt.setString(index++, asstTypes[4]);
                            stmt.setString(index++, asstItemNumbers[4]);
                            stmt.setString(index++, asstItemNames[4]);
                            stmt.setString(index++, asstTypes[5]);
                            stmt.setString(index++, asstItemNumbers[5]);
                            stmt.setString(index++, asstItemNames[5]);
                            stmt.setString(index++, asstTypes[6]);
                            stmt.setString(index++, asstItemNumbers[6]);
                            stmt.setString(index++, asstItemNames[6]);
                            stmt.setString(index++, asstTypes[7]);
                            stmt.setString(index++, asstItemNumbers[7]);
                            stmt.setString(index++, asstItemNames[7]);
                            stmt.setString(index++, strDescripton);
                            stmt.setString(index++, strBizNumber);
                            stmt.setString(index++, strCurrencyInfo);
                            stmt.setBigDecimal(index++, exchangeRate);
                            stmt.setString(index++, new Integer(iDC).toString());
                            stmt.setBigDecimal(index++, asstOriginalAmount);
                            stmt.setBigDecimal(index++, assQty);
                            stmt.setBigDecimal(index++, asstQty);
                            stmt.setBigDecimal(index++, price);
                            stmt.setBigDecimal(index++, assLocalDebit);
                            stmt.setBigDecimal(index++, assLocalCredit);
                            stmt.setString(index++, strSettleTypeInfo);
                            stmt.setString(index++, strSettleCode);
                            stmt.setString(index++, strPrepare);
                            stmt.setString(index++, null);
                            stmt.setString(index++, null);
                            stmt.setString(index++, strPoster);
                            stmt.setString(index++, strChecker);
                            stmt.setInt(index++, iAttachement);
                            stmt.setBoolean(index++, isPosted);
                            stmt.setString(index++, strModule);
                            stmt.setBoolean(index++, isDeleted);
                            stmt.setString(index++, iVoucherTotalNumber);
                            stmt.setString(index++, strMeasureUnitInfo);
                            stmt.setString(index++, strAsstMeasureUnitInfo);
                            stmt.setString(index++, strRefrence);
                            stmt.setInt(index++, tmpVoucher.getCashflowFlag().getValue());
                            stmt.setString(index++, strInvoiceNumber);
                            stmt.setString(index++, strTicketNumber);
                            stmt.setString(index++, strCustomerInfo);
                            stmt.setString(index++, strFeeType);
                            stmt.setString(index++, strCompanyOrgUnitInfo);
                            stmt.setString(index++, strMaterialInfo);
                            stmt.setString(index++, strHandlerInfo);
                            stmt.setString(index++, strSupplierInfo);
                            stmt.setDate(index++, asstBizDate);
                            stmt.setDate(index++, endDate);
                            logger.debug((Object)(GLResUtil.getRes("master_table_info") + "2:stmt" + stmt));
                            stmt.executeUpdate();
                        }
                    }
                    boolean bl = isHasCashFlow = tmpVoucher.getCashflowFlag().getValue() > 0;
                    if (!isHasCashFlow) continue;
                    for (int l = 0; l < cashFlowRecordCollection.size(); ++l) {
                        CashflowRecordInfo cashFlowRecordInfo = cashFlowRecordCollection.get(l);
                        CashFlowItemInfo primaryCashFlowItemInfo = cashFlowRecordInfo.getPrimaryItem();
                        String strPrimaryCashFlowItemInfo = null;
                        if (primaryCashFlowItemInfo != null) {
                            strPrimaryCashFlowItemInfo = primaryCashFlowItemInfo.getNumber();
                        }
                        CashFlowItemInfo subCashFlowItemInfo = cashFlowRecordInfo.getSupplementaryItem();
                        String strSubCashFlowItemInfo = null;
                        if (subCashFlowItemInfo != null) {
                            strSubCashFlowItemInfo = subCashFlowItemInfo.getNumber();
                        }
                        BigDecimal cashFlowAmountFor = cashFlowRecordInfo.getOriginalAmount();
                        BigDecimal cashFlowAmountLocal = cashFlowRecordInfo.getLocalAmount();
                        String type = cashFlowRecordInfo.getType().toString();
                        int iCashFlow = 1;
                        String[] asstTypes = new String[8];
                        String[] asstItemNumbers = new String[8];
                        String[] asstItemNames = new String[8];
                        if (cashFlowRecordInfo.getAssGrp() != null) {
                            BOSUuid assGrpId = cashFlowRecordInfo.getAssGrp().getId();
                            HashMap<String, String> key = new HashMap<String, String>();
                            key.put("key", assGrpId.toString());
                            Map result = facade.dealTask("getAsstItem", key);
                            if (result != null) {
                                AsstActTypeCollection col = (AsstActTypeCollection)result.get("value");
                                int count = 0;
                                if (col != null) {
                                    count = col.size();
                                }
                                for (int k = 0; k < count; ++k) {
                                    AsstActTypeInfo data = col.get(k);
                                    asstTypes[k] = (String)data.get("asstTypes");
                                    asstItemNumbers[k] = (String)data.get("asstItemNumbers");
                                    asstItemNames[k] = (String)data.get("asstItemNames");
                                }
                            }
                            cashFlowStmt.setString(iCashFlow++, company.getNumber());
                            cashFlowStmt.setDate(iCashFlow++, voucherBizDate);
                            cashFlowStmt.setInt(iCashFlow++, iPeriodNumber);
                            cashFlowStmt.setString(iCashFlow++, strVoucherTypeInfo);
                            cashFlowStmt.setString(iCashFlow++, iNumber);
                            cashFlowStmt.setString(iCashFlow++, strCurrencyInfo);
                            cashFlowStmt.setInt(iCashFlow++, cashFlowRecordInfo.getEntry().getSeq());
                            cashFlowStmt.setInt(iCashFlow++, cashFlowRecordInfo.getOpposingAccountEntry().getSeq());
                            cashFlowStmt.setString(iCashFlow++, strPrimaryCashFlowItemInfo);
                            cashFlowStmt.setString(iCashFlow++, strSubCashFlowItemInfo);
                            cashFlowStmt.setBigDecimal(iCashFlow++, cashFlowAmountFor);
                            cashFlowStmt.setBigDecimal(iCashFlow++, cashFlowAmountLocal);
                            cashFlowStmt.setBigDecimal(iCashFlow++, cashFlowRecordInfo.getReportingAmount());
                            cashFlowStmt.setInt(iCashFlow++, cashFlowRecordInfo.getPrimaryCoefficient());
                            cashFlowStmt.setInt(iCashFlow++, cashFlowRecordInfo.getSupplementaryCoefficient());
                            cashFlowStmt.setString(iCashFlow++, cashFlowRecordInfo.getType().toString());
                            cashFlowStmt.setString(iCashFlow++, asstTypes[0]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNumbers[0]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNames[0]);
                            cashFlowStmt.setString(iCashFlow++, asstTypes[1]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNumbers[1]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNames[1]);
                            cashFlowStmt.setString(iCashFlow++, asstTypes[2]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNumbers[2]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNames[2]);
                            cashFlowStmt.setString(iCashFlow++, asstTypes[3]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNumbers[3]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNames[3]);
                            cashFlowStmt.setString(iCashFlow++, asstTypes[4]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNumbers[4]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNames[4]);
                            cashFlowStmt.setString(iCashFlow++, asstTypes[5]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNumbers[5]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNames[5]);
                            cashFlowStmt.setString(iCashFlow++, asstTypes[6]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNumbers[6]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNames[6]);
                            cashFlowStmt.setString(iCashFlow++, asstTypes[7]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNumbers[7]);
                            cashFlowStmt.setString(iCashFlow++, asstItemNames[7]);
                            cashFlowStmt.executeUpdate();
                            logger.debug((Object)("cashFlowStmt" + cashFlowStmt));
                            continue;
                        }
                        cashFlowStmt.setString(iCashFlow++, company.getNumber());
                        cashFlowStmt.setDate(iCashFlow++, voucherBizDate);
                        cashFlowStmt.setInt(iCashFlow++, iPeriodNumber);
                        cashFlowStmt.setString(iCashFlow++, strVoucherTypeInfo);
                        cashFlowStmt.setString(iCashFlow++, iNumber);
                        cashFlowStmt.setString(iCashFlow++, strCurrencyInfo);
                        cashFlowStmt.setInt(iCashFlow++, cashFlowRecordInfo.getEntry().getSeq());
                        cashFlowStmt.setInt(iCashFlow++, cashFlowRecordInfo.getOpposingAccountEntry().getSeq());
                        cashFlowStmt.setString(iCashFlow++, strPrimaryCashFlowItemInfo);
                        cashFlowStmt.setString(iCashFlow++, strSubCashFlowItemInfo);
                        cashFlowStmt.setBigDecimal(iCashFlow++, cashFlowAmountFor);
                        cashFlowStmt.setBigDecimal(iCashFlow++, cashFlowAmountLocal);
                        cashFlowStmt.setBigDecimal(iCashFlow++, cashFlowRecordInfo.getReportingAmount());
                        cashFlowStmt.setInt(iCashFlow++, cashFlowRecordInfo.getPrimaryCoefficient());
                        cashFlowStmt.setInt(iCashFlow++, cashFlowRecordInfo.getSupplementaryCoefficient());
                        cashFlowStmt.setString(iCashFlow++, cashFlowRecordInfo.getType().toString());
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.setString(iCashFlow++, null);
                        cashFlowStmt.executeUpdate();
                        logger.debug((Object)("cashFlowStmt" + cashFlowStmt));
                    }
                }
                SQLUtils.cleanup((Statement)stmt);
            }
            catch (Exception e) {
                logger.error((Object)e);
                break block61;
            }
            finally {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(cashFlowStmt);
            }
            SQLUtils.cleanup((Statement)cashFlowStmt);
        }
    }

    private Connection createTable(FileNameHelp help, boolean overide) throws EASBizException {
        Connection conn = null;
        if (conn != null && !overide) {
            return conn;
        }
        Statement stmt = null;
        try {
            conn = this.getConnetion(help.getPathDirection());
            stmt = conn.createStatement();
            if (overide) {
                File file = new File(help.getFullFileName());
                if (file.exists()) {
                    file.delete();
                }
                if ((file = new File(help.getCFFullFileName())).exists()) {
                    file.delete();
                }
            }
            logger.debug((Object)("help.getPathDirection()" + help.getPathDirection()));
            logger.debug((Object)("help.getFullFileName()" + help.getFullFileName()));
            logger.debug((Object)("help.getFileName()" + help.getFileName()));
            logger.debug((Object)("help.getCFFileName()" + help.getCFFileName()));
            String strStructure = this.getExpCFStructure(help.getCFFullFileName());
            stmt.execute(strStructure);
            strStructure = this.getExpVoucherStructureSql(help.getFullFileName());
            stmt.execute(strStructure);
        }
        catch (SQLException e) {
            throw new VoucherExpImpException(VoucherExpImpException.FILE_CANTCREATEFILE);
        }
        return conn;
    }

    private String getExpVoucherStructureSql(String strTableName) {
        if (StringUtil.isEmptyString((String)strTableName)) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("  CREATE TABLE " + strTableName);
        strBuffer.append("  (FGROUPID char(50),fdate date,ftransdate date,fperiod numeric,   \r\n");
        strBuffer.append("   fgroup char(80),fnum char(80), fentryid numeric,fexp char(180),\r\n");
        if (this.gl_111) {
            strBuffer.append(" FPROFITCEN char(80),");
        }
        strBuffer.append("   facctid char(40),fclsname1 char(80),fobjid1 char(80),fobjname1 char(80), \r\n");
        strBuffer.append("   fclsname2 char(80),fobjid2 char(80),fobjname2 char(80), \r\n");
        strBuffer.append("   fclsname3 char(80),fobjid3 char(80),fobjname3 char(80), \r\n");
        strBuffer.append("   fclsname4 char(80),fobjid4 char(80),fobjname4 char(80),\r\n");
        strBuffer.append("   fclsname5 char(80),fobjid5 char(80),fobjname5 char(80),\r\n");
        strBuffer.append("   fclsname6 char(80),fobjid6 char(80),fobjname6 char(80),\r\n");
        strBuffer.append("   fclsname7 char(10),fobjid7 char(10),fobjname7 char(10),\r\n");
        strBuffer.append("   fclsname8 char(10),fobjid8 char(10),fobjname8 char(10), \r\n");
        strBuffer.append("   FDES char(180),");
        strBuffer.append("   ftransid char(80),fcyid char(10),fexchrate numeric,\r\n");
        strBuffer.append("   fdc char(1),ffcyamt numeric, fqty numeric,fassistqty numeric, \r\n");
        strBuffer.append("   fprice numeric,fdebit numeric,fcredit numeric, \r\n");
        strBuffer.append("   fsettlcode char(80),fsettleno char(40),fprepare char(80),\r\n");
        strBuffer.append("   fpay char(80),  fcash char(80),  fposter char(80),\r\n");
        strBuffer.append("   fchecker char(80), fattchment numeric, fposted logical,\r\n");
        strBuffer.append("   fmodule char(10), fdeleted logical, fserialno char(80),\r\n");
        strBuffer.append("   funitname char(80),fassistuni char(80), freference char(80),fcashflow numeric,\r\n");
        strBuffer.append("finvnum char(80),fticketnum char(80),fcustomer char(80),\r\n");
        strBuffer.append("ffeetype char(10),forgunit char(80),fmaterial char(80),fhandler char(80),fsupplier char(80),fbizdate date,fenddate date \r\n");
        strBuffer.append(")");
        return strBuffer.toString();
    }

    private String getExpCFStructure(String strTableName) {
        if (StringUtil.isEmptyString((String)strTableName)) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("  CREATE TABLE " + strTableName);
        strBuffer.append("  (FGROUPID char(80),fdate Date,fperiod numeric,fgroup char(80),   \r\n");
        strBuffer.append("   fnum char(80),fcyid char(80),fentryid numeric,foppentryid numeric, \r\n");
        strBuffer.append("   fnumber char(80),fsubnumber char(80),famountfor numeric,  \r\n");
        strBuffer.append("   famountlocal numeric,famountrpt numeric,fpricoef numeric,fsupcoef numeric, ftype char(10), \r\n");
        strBuffer.append("   fclsname1 char(80),fobjid1 char(80),fobjname1 char(80), \r\n");
        strBuffer.append("   fclsname2 char(80),fobjid2 char(80),fobjname2 char(80), \r\n");
        strBuffer.append("   fclsname3 char(80),fobjid3 char(80),fobjname3 char(80), \r\n");
        strBuffer.append("   fclsname4 char(80),fobjid4 char(80),fobjname4 char(80),\r\n");
        strBuffer.append("   fclsname5 char(80),fobjid5 char(80),fobjname5 char(80),\r\n");
        strBuffer.append("   fclsname6 char(80),fobjid6 char(80),fobjname6 char(80),\r\n");
        strBuffer.append("   fclsname7 char(10),fobjid7 char(10),fobjname7 char(10),\r\n");
        strBuffer.append("   fclsname8 char(10),fobjid8 char(10),fobjname8 char(10) \r\n");
        strBuffer.append(")");
        return strBuffer.toString();
    }

    public static class FileNameHelp {
        String fullFileName = null;
        String postfix_CF = "CF";
        String extend = null;

        public FileNameHelp(String fullFileName) {
            this.fullFileName = fullFileName;
            int iIndex = fullFileName.lastIndexOf(".");
            this.extend = fullFileName.substring(iIndex + 1).toLowerCase();
        }

        public String getExtend() {
            return this.extend;
        }

        public String getPostfix_CF() {
            return this.postfix_CF;
        }

        public void setExtend(String string) {
            this.extend = string;
        }

        public void setPostfix_CF(String string) {
            this.postfix_CF = string;
        }

        public String getPathDirection() {
            int iIndex = this.fullFileName.lastIndexOf(File.separatorChar);
            return this.fullFileName.substring(0, iIndex);
        }

        public String getFileName() {
            int index = this.fullFileName.lastIndexOf(File.separatorChar);
            String fn = this.fullFileName.substring(index + 1);
            return fn.substring(0, fn.indexOf(46));
        }

        public String getCFFileName() {
            String strFileName = this.getFileName();
            String strCFFile = strFileName + this.postfix_CF;
            return strCFFile;
        }

        public String getCFFullFileName() {
            String strFileName = this.fullFileName;
            int iIndex = strFileName.toLowerCase().lastIndexOf("." + this.extend.toLowerCase());
            String strCFFile = strFileName.substring(0, iIndex);
            strCFFile = strCFFile + this.postfix_CF + "." + this.extend;
            return strCFFile;
        }

        public String getFullFileName() {
            this.fullFileName = this.fullFileName.replace('/', File.separatorChar);
            this.fullFileName = this.fullFileName.replace('\\', File.separatorChar);
            return this.fullFileName;
        }
    }
}

