/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucherPostProcessor;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherPostProcessorCollection;
import com.kingdee.eas.fi.gl.VoucherPostProcessorFactory;
import com.kingdee.eas.fi.gl.VoucherPostProcessorInfo;
import com.kingdee.eas.fi.gl.VoucherPostProcessorTypeEnum;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherAntiAuditPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherAntiCancelPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherAntiPostPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherAuditPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherCancelPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherDeletePostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPostPostProcessor;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherSubmitPostProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherPostProcessorInvokeFactory {
    private static final Logger logger = Logger.getLogger(VoucherPostProcessorInvokeFactory.class);
    private static IVoucherPostProcessor iProcessor = null;
    private static Map postProcessorMap = new HashMap();

    public static void invokeVoucherSubmitPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = VoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.SUBMIT).iterator();
        while (it.hasNext()) {
            ((IVoucherSubmitPostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    public static void invokeVoucherCancelPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = VoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.CANCEL).iterator();
        while (it.hasNext()) {
            ((IVoucherCancelPostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    public static void invokeVoucherAntiCancelPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = VoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.ANTICANCEL).iterator();
        while (it.hasNext()) {
            ((IVoucherAntiCancelPostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    public static void invokeVoucherPostPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = VoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.POST).iterator();
        while (it.hasNext()) {
            ((IVoucherPostPostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    public static void invokeVoucherAntiPostPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = VoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.ANTIPOST).iterator();
        while (it.hasNext()) {
            ((IVoucherAntiPostPostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    public static void invokeVoucherDeletePostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = VoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.DELETE).iterator();
        while (it.hasNext()) {
            ((IVoucherDeletePostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    public static void invokeVoucherAuditPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = VoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.AUDIT).iterator();
        while (it.hasNext()) {
            ((IVoucherAuditPostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    public static void invokeVoucherAntiAuditPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = VoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.ANTIAUDIT).iterator();
        while (it.hasNext()) {
            ((IVoucherAntiAuditPostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    private static List getProcessorInstances(Context ctx, VoucherPostProcessorTypeEnum processorType) throws BOSException {
        VoucherPostProcessorCollection invokeCollection = VoucherPostProcessorInvokeFactory.getVoucherProcessor(ctx, processorType);
        ArrayList<Object> instances = new ArrayList<Object>();
        Iterator it = invokeCollection.iterator();
        while (it.hasNext()) {
            VoucherPostProcessorInfo processor = (VoucherPostProcessorInfo)it.next();
            String className = processor.getProcessorClass();
            Object classObj = null;
            try {
                if (className == null || className.length() < 0) continue;
                classObj = Class.forName(className).newInstance();
                instances.add(classObj);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e);
                throw new BOSException("ClassNotFoundException:" + className, (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error((Object)e);
                throw new BOSException("InstantiationException:" + className, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
                throw new BOSException("IllegalAccessException:" + className, (Throwable)e);
            }
        }
        return instances;
    }

    private static VoucherPostProcessorCollection getVoucherProcessor(Context ctx, VoucherPostProcessorTypeEnum processorType) throws BOSException {
        if (!postProcessorMap.containsKey((Object)processorType)) {
            VoucherPostProcessorCollection collection = VoucherPostProcessorInvokeFactory.getVoucherPostProcessorCollection(ctx, processorType);
            postProcessorMap.put(processorType, collection);
        }
        return (VoucherPostProcessorCollection)((Object)postProcessorMap.get((Object)processorType));
    }

    private static VoucherPostProcessorCollection getVoucherPostProcessorCollection(Context ctx, VoucherPostProcessorTypeEnum processorType) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("processorType"));
        coll.add(new SelectorItemInfo("processorClass"));
        evi.setSelector(coll);
        if (processorType != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("processorType", (Object)processorType.getValue(), CompareType.EQUALS));
            evi.setFilter(filter);
        }
        VoucherPostProcessorCollection collection = VoucherPostProcessorInvokeFactory.getBizInterface(ctx).getCollection(evi);
        return collection;
    }

    private static IVoucherPostProcessor getBizInterface(Context ctx) throws BOSException {
        if (iProcessor == null) {
            iProcessor = VoucherPostProcessorFactory.getLocalInstance(ctx);
        }
        return iProcessor;
    }
}

