/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class XmlUtil {
    public static String getRootName(String xmlStr) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlStr));
        Element root = doc.getRootElement();
        return root.getName();
    }

    public static Map xml2Map(String xmlStr) throws JDOMException, IOException {
        HashMap rtnMap = new HashMap();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlStr));
        Element root = doc.getRootElement();
        String rootName = root.getName();
        XmlUtil.convert(root, rtnMap, rootName);
        return rtnMap;
    }

    public static void convert(Element e, Map map, String lastname) {
        if (e.getAttributes().size() > 0) {
            for (Attribute attribute : e.getAttributes()) {
                String attrname = attribute.getName();
                String attrvalue = e.getAttributeValue(attrname);
                map.put(attrname, attrvalue);
            }
        }
        Map sMap = lastname == "setting" ? map : new HashMap();
        List children = e.getChildren();
        for (Element child : children) {
            String name = child.getName();
            if (child.getChildren().size() > 0) {
                XmlUtil.convert(child, sMap, name);
                continue;
            }
            sMap.put(name, child.getText());
            if (child.getAttributes().size() <= 0) continue;
            for (Attribute attribute : child.getAttributes()) {
                String attrname = attribute.getName();
                String attrvalue = child.getAttributeValue(attrname);
                sMap.put(attrname, attrvalue);
            }
        }
        if (lastname != "setting") {
            map.put(lastname, sMap);
        }
    }

    public static List<Map<String, String>> xml2List(String xmlStr) throws JDOMException, IOException {
        ArrayList<Map<String, String>> rtnList = new ArrayList<Map<String, String>>();
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlStr));
        Element root = doc.getRootElement();
        String rootName = root.getName();
        rtnMap.put("root.name", rootName);
        XmlUtil.convert2List(root, rtnMap, rootName, rtnList);
        if (rtnList.size() == 0) {
            rtnList.add(rtnMap);
        }
        return rtnList;
    }

    public static void convert2List(Element e, Map<String, String> map, String lastname, List<Map<String, String>> list) {
        if (e.getAttributes().size() > 0) {
            for (Attribute attribute : e.getAttributes()) {
                String attrname = attribute.getName();
                String attrvalue = e.getAttributeValue(attrname);
                map.put(lastname + "." + attrname, attrvalue);
            }
        }
        List children = e.getChildren();
        for (Element child : children) {
            String name = lastname + "." + child.getName();
            if (child.getChildren().size() > 0) {
                XmlUtil.convert(child, map, name);
            } else {
                map.put(name, child.getText());
                if (child.getAttributes().size() > 0) {
                    for (Attribute attribute : child.getAttributes()) {
                        String attrname = attribute.getName();
                        String attrvalue = child.getAttributeValue(attrname);
                        map.put(name + "." + attrname, attrvalue);
                    }
                }
            }
            if (e.getChildren(child.getName()).size() <= 1) continue;
            HashMap<String, String> aMap = new HashMap<String, String>();
            aMap.putAll(map);
            list.add(aMap);
            map = new HashMap<String, String>();
            map.put("root.name", (String)aMap.get("root.name"));
        }
    }
}

