/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.util.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipUtils {
    public static String gzip(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return str;
        }
        byte[] bs = ZipUtils.doGzip(str.getBytes("UTF-8"));
        return Base64Encoder.byteArrayToBase64((byte[])bs);
    }

    public static String gunzip(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return str;
        }
        byte[] data = Base64Encoder.base64ToByteArray((String)str);
        return new String(ZipUtils.doGunzip(data), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doGzip(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(data);
        }
        finally {
            try {
                if (gzip != null) {
                    gzip.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] doGunzip(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = null;
        GZIPInputStream gin = null;
        try {
            in = new ByteArrayInputStream(data);
            gin = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = gin.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (gin != null) {
                    gin.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

