/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountFacade;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeFactory;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ItemStructureInfo;
import com.kingdee.eas.fi.gl.app.AbstractAccountAgeFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.AccountAgeFacadeControllerBeanOld;
import com.kingdee.eas.fi.gl.app.AccountAgeParam;
import com.kingdee.eas.fi.gl.app.GLAcctAgeNewUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.app.QueryAgeType;
import com.kingdee.eas.fi.gl.app.RptAgeCalculation;
import com.kingdee.eas.fi.gl.app.dataProcess.DataProcessEngine;
import com.kingdee.eas.fi.gl.app.dataProcess.FieldType;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.DataSet;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.DateDiffType;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.Field;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FieldObjectFactory;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FunctionField;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.SumField;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.SumFieldObjectFactory;
import com.kingdee.eas.fi.gl.app.dataProcess.function.CommonFunction;
import com.kingdee.eas.fi.gl.app.dataProcess.function.DateDiffFunction;
import com.kingdee.eas.fi.gl.app.dataProcess.function.RoundFunction;
import com.kingdee.eas.fi.gl.app.voucher.AutoVerifyService;
import com.kingdee.eas.fi.gl.common.ACAuditCancelFilterHelper;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.log4j.Logger;

public class AccountAgeFacadeControllerBean
extends AbstractAccountAgeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)AccountAgeFacadeControllerBean.class.getClass().getName());
    private List<String> lstHgOutSideRemoveFields;
    private Map<String, String> tempTableFieldType = new HashMap<String, String>();
    private String acTmpTable = null;
    private String tempTableComVeriMode = null;
    private String tempTableAcSum = null;
    private Map<String, String> tempAcSumTableMap = new ConcurrentHashMap<String, String>();
    private ThreadPoolExecutor tpool = null;
    private CountDownLatch cdl;
    private Object lock = new Object();

    @Override
    protected HashMap _getAsstItems(Context ctx, String accountFrom, String accountTo, String companyId, int indexType, Date bizDate, HashMap othersParam) throws BOSException, EASBizException {
        CompanyOrgUnitInfo _company;
        CompanyOrgUnitInfo curCompany = _company = GlUtils.getCompanyById(ctx, companyId);
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion(_company);
        if (!isIsOnlyUnion) {
            curCompany = GlUtils.getCompanyById(ctx, companyId);
        }
        String acctTableId = null;
        PeriodInfo period = null;
        if (bizDate == null) {
            acctTableId = curCompany.getAccountTable().getId().toString();
        } else {
            PeriodInfo _period;
            period = _period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)curCompany);
            int _periodYear = _period == null ? bizDate.getYear() + 1900 : _period.getPeriodYear();
            int _periodNumber = _period == null ? (bizDate.getMonth() + 3) / 3 : _period.getPeriodNumber();
            acctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyId, (String)curCompany.getAccountTable().getId().toString(), (int)_periodYear, (int)_periodNumber);
        }
        if (period == null) {
            throw new GLException(GLException.NOPERIODLIST);
        }
        Map accountParams = GLAcctAgeNewUtils.getAccountParam(accountFrom, accountTo);
        accountFrom = (String)accountParams.get("accountFrom");
        accountTo = (String)accountParams.get("accountTo");
        HashMap allItems = new HashMap();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer("select fid id,fnumber fnumber,fname_").append(loc).append(" fname, account.fcaa from T_BD_AccountView \r\n account where fisleaf=1 and fac=1 and fcaa is not null");
        if (isIsOnlyUnion) {
            acctTableId = othersParam.get("accountTableid").toString();
            String companyIds = othersParam.get("companyIds").toString();
            sql.append(" and fcompanyid is not null and  fcompanyid in (").append(companyIds).append(") ");
        } else {
            sql.append(" and fcompanyid=? ");
        }
        GLAcctAgeNewUtils.buildAccountSql(sql, accountParams, "fnumber");
        sql.append(" and faccounttableid = ? ");
        AccountViewCollection accounts = new AccountViewCollection();
        HashSet<String> accountIds = new HashSet<String>();
        HashMap caaCache = new HashMap();
        ArrayList crossItems = new ArrayList();
        Map caaMap = new HashMap();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            int index = 1;
            ps = con.prepareStatement(sql.toString());
            if (!isIsOnlyUnion) {
                ps.setString(index++, companyId);
            }
            if (accountFrom != null && !accountFrom.equals("")) {
                ps.setString(index++, accountFrom);
            }
            if (accountTo != null && !accountTo.equals("")) {
                ps.setString(index++, accountTo + "zzzzzz");
            }
            ps.setString(index++, acctTableId);
            rs = ps.executeQuery();
            while (rs.next()) {
                AccountViewInfo account = new AccountViewInfo();
                account.put("id", (Object)rs.getString("id"));
                account.put("number", (Object)rs.getString("fnumber"));
                account.put("name", (Object)rs.getString("fname"));
                accounts.add(account);
                accountIds.add(rs.getString("id"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            if (accountIds.size() == 0) {
                throw new GLException(GLException.NOACCTACCOUNT);
            }
            IAccountFacade iaf = AccountFacadeFactory.getLocalInstance((Context)ctx);
            caaMap = iaf.getCAAIdsByPeriod(accountIds, period.getId().toString());
            String caaIds = "''";
            Iterator it = caaMap.values().iterator();
            while (it.hasNext()) {
                caaIds = caaIds + ",'" + (String)it.next() + "'";
            }
            sql = new StringBuffer();
            sql.append("select distinct rel.fid relid,rel.Fseq seq,item.fid id,item.fisforcompany fisforcompany,item.fnumber fnumber,item.fdefaultqueryname queryname,item.frealtiondataobject tablename, item.fassthgattribute propname, item.fmappingfieldname fieldname,item.fname_");
            sql.append(loc);
            sql.append(" fname, item.FGLAsstActTypeGrpID,item.FUseLongNumber useLongNUmber,rel.fasstaccountid caaid ").append(" from T_BD_AsstActGroupDetail rel ").append(" inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid");
            sql.append(" where rel.fasstaccountid in( ").append(caaIds).append(")");
            ps = con.prepareStatement(sql.toString());
            rs = ps.executeQuery();
            HashSet<String> hmCount = new HashSet<String>();
            while (rs.next()) {
                String id = rs.getString("id");
                String caaid = rs.getString("caaid");
                if (!caaCache.containsKey(caaid)) {
                    caaCache.put(caaid, new HashSet());
                }
                ((Set)caaCache.get(caaid)).add(id);
                if (hmCount.contains(id)) continue;
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("id", id);
                item.put("relid", rs.getString("relid"));
                item.put("seq", rs.getInt("seq") - 1);
                item.put("isforcompany", rs.getBoolean("fisforcompany"));
                item.put("number", rs.getString("fnumber"));
                item.put("name", rs.getString("fname"));
                item.put("queryname", rs.getString("queryname"));
                item.put("propname", rs.getString("propname"));
                item.put("fieldname", rs.getString("fieldname"));
                item.put("tablename", rs.getString("tablename"));
                item.put("FGLAsstActTypeGrpID", rs.getString("FGLAsstActTypeGrpID"));
                item.put("useLongNUmber", rs.getBoolean("useLongNUmber"));
                item.put("caaid", caaid);
                crossItems.add(item);
                hmCount.add(id);
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        HashMap<String, Object> alAcResult = new HashMap<String, Object>();
        alAcResult.put("accounts", accounts);
        alAcResult.put("caaMap", caaMap);
        alAcResult.put("caaCache", caaCache);
        alAcResult.put("items", crossItems);
        return alAcResult;
    }

    @Override
    protected ArrayList _queryAge(Context ctx, Map param) throws BOSException, EASBizException {
        boolean isWebService;
        AccountAgeParam paramAge = new AccountAgeParam();
        String accountid = (String)param.get("accountid");
        String currencyid = (String)param.get("currencyid");
        int[] days = (int[])param.get("days");
        int[] undays = (int[])param.get("undays");
        boolean isShowUmexpired = (Boolean)param.get("isShowUmexpired");
        HashMap hmItems = (HashMap)param.get("hmItems");
        Date endDate = (Date)param.get("endDate");
        Date historyDate = (Date)param.get("historyDate");
        boolean isIncludeUnPosted = (Boolean)param.get("includeUnPosted");
        boolean isIncludeInit = (Boolean)param.get("includeInit");
        boolean isIncludeVerifyVch = param.get("includeVerifyVch") == null ? false : (Boolean)param.get("includeVerifyVch");
        boolean isBizCode = param.get("isBizCode") != null && (Boolean)param.get("isBizCode") != false;
        String companyid = (String)param.get("companyid");
        int dateType = (Integer)param.get("dateType");
        if (param.get("isSumAccount") != null) {
            boolean isSumAccount = (Boolean)param.get("isSumAccount");
            paramAge.setSumAccount(isSumAccount);
        }
        int indexType = (Integer)param.get("indexType");
        Object accountFrom = param.get("accountFrom");
        Object accountTo = param.get("accountTo");
        QueryAgeType queryAgeType = param.get("queryAgeType") == null ? QueryAgeType.STANDRAD : (QueryAgeType)((Object)param.get("queryAgeType"));
        CompanyOrgUnitInfo _company = null;
        boolean isIsOnlyUnion = false;
        boolean bl = isWebService = queryAgeType == QueryAgeType.WEBSERVICE_AGE_DAYS;
        if (!isWebService) {
            _company = GlUtils.getCurrentCompany(ctx);
            isIsOnlyUnion = GlUtils.isCompanyUnion(_company);
        } else {
            paramAge.put("adjExchDate", param.get("adjExchDate"));
        }
        paramAge.setType(queryAgeType);
        paramAge.setAccountNumbers((String[])param.get("accountNumbers"));
        HashMap params = new HashMap();
        params.put("itemsize", param.get("itemsize"));
        paramAge.setParams(params);
        paramAge.setSumDC(param.containsKey("isSumDC"));
        int companyLevel = 0;
        String curCompanyid = null;
        HashMap otherInfo = null;
        boolean isfirstload = true;
        String accountViewNumber = null;
        String acctTableId = null;
        CompanyOrgUnitInfo curCompany = null;
        this.tempTableFieldType = GLAcctAgeNewUtils.getTempTableFieldType(ctx, "AccountAgeFacadeControllerBean", "acTable");
        if (isIsOnlyUnion) {
            companyid = (String)param.get("companyIdsForOnlyUnion");
            companyLevel = (Integer)param.get("curLevel");
            curCompanyid = (String)param.get("curCompanyid");
            otherInfo = (HashMap)param.get("otherInfo");
            isfirstload = param.get("firstLoad").toString().equals("true");
            if (param.get("accountViewNumber") != null) {
                accountViewNumber = (String)param.get("accountViewNumber");
                accountid = null;
            } else {
                if (otherInfo != null && otherInfo.get("accountViewNumber") != null) {
                    accountViewNumber = otherInfo.get("accountViewNumber").toString();
                }
                otherInfo = null;
            }
            acctTableId = param.get("accountTable").toString();
            int displayMode = (Integer)param.get("displayMode");
            boolean isDisplayLeafCompany = param.get("isDisplayLeafCompany").toString().equals("true");
            String hgid = (String)param.get("hgid");
            GLAcctAgeNewUtils.prepareAccountAgeParam(paramAge, ctx, _company, isIsOnlyUnion, accountid, currencyid, days, undays, isShowUmexpired, hmItems, endDate, isIncludeUnPosted, isIncludeInit, companyid, dateType, indexType, accountFrom, accountTo, companyLevel, curCompanyid, accountViewNumber, otherInfo, acctTableId, isfirstload, isIncludeVerifyVch, isBizCode, historyDate, displayMode, isDisplayLeafCompany, hgid);
            if (isIsOnlyUnion && paramAge.isBizCode() && !paramAge.isAccountList() && !paramAge.isIsfirstload() && hmItems.size() != 0) {
                if (param.get("bizCode") != null) {
                    paramAge.setBizCode((String)param.get("bizCode"));
                } else {
                    paramAge.setBizCode((String)((Map)param.get("otherInfo")).get("BizCodeNumber"));
                }
            }
            if (displayMode == 3) {
                paramAge.setCompanyExpandOnUnion(param.get("companyExpandOnUnion") == null ? false : Boolean.valueOf(param.get("companyExpandOnUnion").toString()));
                paramAge.setCurCompanyLevel(param.get("curCompanyLevel") == null ? 1 : Integer.parseInt(param.get("curCompanyLevel").toString()));
            }
            return this.queryAgeByBal(paramAge);
        }
        if (!isBizCode || indexType != 1) {
            String string = accountid = accountid != null && accountid.indexOf("'") == -1 ? "'" + accountid + "'" : accountid;
        }
        if (indexType == 0 && param.get("accountViewNumber") != null) {
            accountViewNumber = (String)param.get("accountViewNumber");
            accountid = null;
        }
        curCompany = companyid != null ? GLAcctAgeNewUtils.getCompanyById(ctx, companyid) : _company;
        GLAcctAgeNewUtils.prepareAccountAgeParam(paramAge, ctx, curCompany, isIsOnlyUnion, accountid, currencyid, days, undays, isShowUmexpired, hmItems, endDate, isIncludeUnPosted, isIncludeInit, companyid, dateType, indexType, accountFrom, accountTo, companyLevel, curCompanyid, accountViewNumber, otherInfo, acctTableId, isfirstload, isIncludeVerifyVch, isBizCode, historyDate, 0, false, null);
        return this.queryAgeByBal(paramAge);
    }

    @Override
    protected ArrayList _getInitData(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (company.getAccountPeriodType() == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        ArrayList<Object> alAcResult = new ArrayList<Object>();
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(false);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        alAcResult.add(curCol);
        HashMap hmParamValue = (HashMap)InitHelp.getInitParam(ctx, company);
        alAcResult.add(hmParamValue.get("GL_008"));
        alAcResult.add(hmParamValue.get("G001"));
        return alAcResult;
    }

    protected ArrayList queryAcctIndexNew(Context ctx, String[] accountIds, String currencyId, HashMap hmItems, Date endDate, boolean isIncludeUnPosted, boolean isIncludeInit, String companyId, int dateType, boolean isBizCode, boolean isIncludeVerifyVch, Map otherParams) throws BOSException, EASBizException {
        Map accountParams;
        AccountViewCollection colAccount;
        CompanyOrgUnitInfo _company;
        AccountAgeParam paramAge = new AccountAgeParam();
        CompanyOrgUnitInfo curCompany = _company = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion(_company);
        if (isIsOnlyUnion) {
            String companyIdTempTable = GLAcctAgeNewUtils.createIdsTempTable(ctx, companyId);
            if (!StringUtils.isEmpty((String)companyIdTempTable)) {
                companyId = "select fid from " + companyIdTempTable;
                GLAcctAgeNewUtils.idsTempTables.get().add(companyIdTempTable);
            }
            return this.queryAcctIndex_New(ctx, accountIds, currencyId, hmItems, endDate, isIncludeUnPosted, isIncludeInit, companyId, dateType, isBizCode, isIncludeVerifyVch, otherParams);
        }
        boolean isFilterAcctByAcctCussent = false;
        PeriodInfo currPeriod = null;
        PeriodInfo endPeriod = null;
        String currPeriodID = "";
        String endPeriodID = "";
        StringBuffer endAdjustPeriodID = new StringBuffer();
        String tempTableBal = "";
        StringBuffer inAccountNumber = null;
        int verifyMode = -1;
        curCompany = GlUtils.getCompanyById(ctx, companyId);
        verifyMode = GlUtils.getVerifyMode(ctx, companyId);
        if (verifyMode == 2) {
            isIncludeUnPosted = true;
        }
        if (verifyMode != 0 && !isIncludeVerifyVch) {
            isFilterAcctByAcctCussent = true;
        }
        int balType = isIncludeUnPosted ? 1 : 5;
        StringBuffer inAccount = null;
        if (accountIds != null) {
            inAccount = new StringBuffer("(");
            for (int i = 0; i < accountIds.length; ++i) {
                inAccount.append("'").append(accountIds[i]).append("',");
            }
            inAccount.deleteCharAt(inAccount.length() - 1);
            inAccount.append(")");
        }
        if ((colAccount = (AccountViewCollection)otherParams.get("accounts")) != null && colAccount.size() > 0) {
            inAccountNumber = new StringBuffer("(");
            for (int i = 0; i < colAccount.size(); ++i) {
                inAccountNumber.append("'").append(colAccount.get(i).getNumber()).append("',");
            }
            inAccountNumber.deleteCharAt(inAccountNumber.length() - 1);
            inAccountNumber.append(")");
        }
        Object[] accountFrom = null;
        Object[] accountTo = null;
        if (otherParams.get("accountFrom") != null) {
            accountFrom = (Object[])otherParams.get("accountFrom");
        }
        if (otherParams.get("accountTo") != null) {
            accountTo = (Object[])otherParams.get("accountTo");
        }
        int isEndPeriodInFuture = 0;
        if (!isFilterAcctByAcctCussent && !isIsOnlyUnion) {
            PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)endDate, (Date)endDate, (CompanyOrgUnitInfo)curCompany);
            if (periodColl.size() <= 0) {
                throw new GLException(GLException.NOPERIODLIST);
            }
            if (periodColl.size() > 1) {
                endAdjustPeriodID.append("(");
                for (int i = 0; i < periodColl.size(); ++i) {
                    endAdjustPeriodID.append("'").append(periodColl.get(i).getId().toString()).append("'");
                    if (i == periodColl.size() - 1) continue;
                    endAdjustPeriodID.append(",");
                }
                endAdjustPeriodID.append(")");
            }
            endPeriod = periodColl.get(0);
            endPeriodID = periodColl.get(0).getId().toString();
            isEndPeriodInFuture = endPeriodID.compareToIgnoreCase(currPeriodID = (currPeriod = GlUtils.getCurrentPeriod(ctx, companyId)).getId().toString()) == 0 ? 0 : (PeriodUtils.PeriodCompare((PeriodInfo)endPeriod, (PeriodInfo)currPeriod) ? 1 : -1);
        }
        GLAcctAgeNewUtils.setEnterDateType(paramAge);
        ArrayList<AccountViewInfo> alAcResult = new ArrayList<AccountViewInfo>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        boolean isAllCurr = false;
        if (currencyId.equals("AllCurrency")) {
            isAllCurr = true;
        }
        boolean isGeneralCy = false;
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyId)) {
            isGeneralCy = true;
        }
        StringBuffer from = new StringBuffer();
        String companyFieldName = "";
        String assgrpFieldName = "";
        ArrayList<Object> listParam = new ArrayList<Object>();
        boolean isDM = SQLUtil.isDM(ctx);
        if (isFilterAcctByAcctCussent) {
            from.append(" from t_gl_acctcussent CUSSENT  \r\n");
            companyFieldName = "fcompanyid";
            assgrpFieldName = "fassgrpid";
        } else {
            if (isDM && balType == 1) {
                from.append(" from t_gl_assistbalance_1F CUSSENT  \r\n");
            } else if (isDM && balType == 5) {
                from.append(" from t_gl_assistbalance_5F CUSSENT  \r\n");
            } else {
                from.append(" from t_gl_assistbalance CUSSENT  \r\n");
            }
            companyFieldName = "forgunitid";
            assgrpFieldName = "FAssistGrpID";
        }
        from.append(" inner join t_bd_accountview account on cussent.faccountid = account.fid  ");
        from.append("  and account.fcompanyid = ?  \r\n");
        listParam.add(companyId);
        from.append(" left outer join t_bd_accountview paccount on account.fparentid = paccount.fid ");
        from.append("  and paccount.fcompanyid = ?  \r\n");
        listParam.add(companyId);
        if (isBizCode && hmItems.size() > 0) {
            from.append(" inner join t_bd_assistanthg hg on cussent.").append(assgrpFieldName).append(" = hg.fid  \r\n");
        }
        StringBuffer innerJoinAsst = new StringBuffer();
        StringBuffer sqlGroupby = new StringBuffer();
        ArrayList alAstNumbers = new ArrayList();
        ArrayList alAstTables = new ArrayList();
        ArrayList alAstFields = new ArrayList();
        Iterator itemkeyit = hmItems.keySet().iterator();
        HashMap[] itemList = new HashMap[hmItems.keySet().size()];
        int k = 0;
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            Integer seq = (Integer)item.get("seq");
            if (seq != null) {
                itemList[seq.intValue()] = item;
            } else {
                itemList[k] = item;
            }
            ++k;
        }
        if (isBizCode && hmItems.size() > 0) {
            innerJoinAsst.append(" left join ").append("t_bd_customer").append(" cst").append(" on hg.").append("fcustomerid").append("=").append("cst").append(".fid             \r\n");
            innerJoinAsst.append(" left join T_BD_BizAnaylysisCode bac1 on bac1.fid = cst.FBizAnalysisCodeID \r\n");
            innerJoinAsst.append(" left join ").append("T_BD_Supplier").append(" sup").append(" on hg.").append("FProviderID").append("=").append("sup").append(".fid              \r\n");
            innerJoinAsst.append(" left join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID \r\n");
        }
        for (String number : alAstNumbers) {
            listParam.add(number);
        }
        StringBuffer hisWhere = new StringBuffer();
        StringBuffer where = new StringBuffer();
        StringBuffer whereCommon = new StringBuffer();
        StringBuffer whereCompany = new StringBuffer();
        StringBuffer wherePeriod = new StringBuffer();
        whereCompany.append(" \r\n where cussent.").append(companyFieldName).append("=?  \r\n");
        listParam.add(companyId);
        whereCommon.append(" and ACCOUNT.fac = 1   \r\n");
        if (!isIsOnlyUnion && inAccount != null) {
            whereCommon.append(" and cussent.faccountid in ").append(inAccount).append("  \r\n");
        }
        if ((accountParams = GLAcctAgeNewUtils.makeArrayToString(accountFrom, accountTo)) != null) {
            GLAcctAgeNewUtils.buildAccountSql(whereCommon, accountParams, "ACCOUNT.fnumber");
            String fromNumber = (String)accountParams.get("accountFrom");
            String toNumber = (String)accountParams.get("accountTo");
            if (fromNumber != null && !fromNumber.equals("")) {
                listParam.add(fromNumber);
            }
            if (toNumber != null && !toNumber.equals("")) {
                listParam.add(toNumber + "zzzzzz");
            }
        }
        if (!isGeneralCy && !isAllCurr) {
            whereCommon.append(" and cussent.fcurrencyid=?   \r\n");
            listParam.add(currencyId);
        }
        if (isFilterAcctByAcctCussent) {
            if (!isIncludeInit) {
                wherePeriod.append(" AND cussent.FPeriodID <> '").append("AAAAAAAAAAAAAAAAAAAAAII4jEw=").append("'  \r\n");
            }
        } else if (isDM) {
            wherePeriod.append(" AND pd.fid = '").append(endPeriodID).append("'  \r\n");
        } else {
            if (endAdjustPeriodID.length() > 0) {
                wherePeriod.append(" and cussent.FPeriodID in ").append(endAdjustPeriodID.toString()).append(" \r\n");
            } else {
                wherePeriod.append(" AND cussent.FPeriodID = '").append(endPeriodID).append("'  \r\n");
            }
            wherePeriod.append(" AND cussent.FBalType = ").append(balType).append("  \r\n");
        }
        ArrayList bizParams = new ArrayList();
        for (String number : bizParams) {
            listParam.add(number);
        }
        boolean accountShowLongName = Boolean.valueOf(GlUtils.getParamByKey(ctx, _company.getId().toString(), "GL_012").toString());
        String accountname = accountShowLongName ? "Flongname_" : "Fname_";
        StringBuffer selectAccount = new StringBuffer(" distinct account.fid id,account.fdc fdc,account.fnumber fnumber,account.").append(accountname).append(loc).append(" fname,account.FParentID parentId,account.FLongNumber longNumber,account.FIsLeaf isLeaf,paccount.fNumber pnumber, paccount.flongnumber plongnumber ");
        String orderByAcctNumber = " order by fnumber  \r\n";
        StringBuffer merge = new StringBuffer();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isDbTypeOracleDB2 = GLAcctAgeNewUtils.checkDbTypeIsOracleDB2(ctx);
        try {
            con = this.getConnection(ctx);
            if (!isFilterAcctByAcctCussent) {
                if (1 == isEndPeriodInFuture) {
                    PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currPeriod);
                    int[] periodRange = new int[]{nextPeriod.getPeriodYear(), nextPeriod.getPeriodNumber(), endPeriod.getPeriodYear(), endPeriod.getPeriodNumber()};
                    String string = " and " + SQLUtil.getPeriodCondition("pd.fperiodyear", "pd.fperiodnumber", periodRange) + "  \r\n";
                    whereCommon = whereCompany.append(whereCommon);
                    if (isDM) {
                        innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fnumber = cussent.FPeriod ");
                    } else {
                        innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fid = cussent.FPeriodID ");
                    }
                    tempTableBal = this.createTempTable4FuturePeriodAsstBal(ctx, con, isDbTypeOracleDB2, isIsOnlyUnion, tempTableBal, listParam, companyId, currPeriodID, endPeriodID, endAdjustPeriodID, balType, isEndPeriodInFuture, string, from, innerJoinAsst, whereCommon, isDM);
                    merge.append("select ").append(selectAccount).append(GLAcctAgeNewUtils.getResultSql4Acct(tempTableBal));
                } else {
                    if (isDM) {
                        innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fnumber = cussent.FPeriod ");
                    }
                    where.append(whereCompany).append(whereCommon).append(wherePeriod);
                    merge.append("select ").append(selectAccount).append(from).append(innerJoinAsst).append(where).append(sqlGroupby).append(orderByAcctNumber);
                }
            } else {
                StringBuilder hisWherePeriodBuilder = new StringBuilder();
                wherePeriod.append(" and cussent.FBookedDate <= ? ");
                hisWherePeriodBuilder.append(wherePeriod.toString()).append(" and cussent.FUnVerifiedAmtFor = 0 and his.FVerVchDate >? ");
                wherePeriod.append(" and cussent.FUnVerifiedAmtFor <> 0 ");
                where.append(whereCompany).append(whereCommon).append(wherePeriod);
                hisWhere.append(whereCompany).append(whereCommon).append((CharSequence)hisWherePeriodBuilder);
                merge.append("select ").append(selectAccount).append(from).append(innerJoinAsst).append(where).append(sqlGroupby);
                StringBuilder hisSql = new StringBuilder();
                hisSql.append(" select ").append(selectAccount).append(from).append(" inner join T_GL_ACCTCUSSENTHISTORY his on CUSSENT.FID = his.FCUSSENTIDID ").append(innerJoinAsst).append(hisWhere.toString()).append(sqlGroupby);
                merge.append(" union ").append(hisSql.toString());
                merge.append(orderByAcctNumber);
                listParam.add(new java.sql.Date(endDate.getTime()));
                listParam.addAll(listParam);
                listParam.add(new java.sql.Date(endDate.getTime()));
            }
            ps = con.prepareStatement(merge.toString());
            int index = 1;
            if (isFilterAcctByAcctCussent || (1 != isEndPeriodInFuture || isIsOnlyUnion) && !isIsOnlyUnion) {
                for (Object e : listParam) {
                    Object param;
                    if (e instanceof String) {
                        param = (String)e;
                        ps.setString(index++, (String)param);
                        continue;
                    }
                    if (e instanceof Integer) {
                        param = (Integer)e;
                        ps.setInt(index++, (Integer)param);
                        continue;
                    }
                    if (!(e instanceof java.sql.Date)) continue;
                    ps.setDate(index++, (java.sql.Date)e);
                }
            }
            rs = ps.executeQuery();
            HashMap<String, String> distinctMap = new HashMap<String, String>();
            Object var69_79 = null;
            while (rs.next()) {
                String string = rs.getString("fnumber");
                if (distinctMap.get(string) != null) continue;
                AccountViewInfo account = new AccountViewInfo();
                if (!isIsOnlyUnion && rs.getString("id") != null) {
                    account.put("id", (Object)rs.getString("id"));
                }
                account.put("dc", (Object)rs.getInt("fdc"));
                account.put("number", (Object)string);
                account.put("name", (Object)rs.getString("fname"));
                if (rs.getString("parentId") != null && rs.getString("parentId").length() > 0) {
                    AccountViewInfo parent = new AccountViewInfo();
                    parent.setId(BOSUuid.read((String)rs.getString("parentId")));
                    parent.setNumber(rs.getString("pnumber"));
                    parent.setLongNumber(rs.getString("plongnumber"));
                    account.setParent(parent);
                }
                account.setLongNumber(rs.getString("longNumber"));
                account.setIsLeaf(rs.getBoolean("isLeaf"));
                alAcResult.add(account);
                distinctMap.put(string, string);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return alAcResult;
    }

    protected ArrayList queryAcctIndex_New(Context ctx, String[] accountIds, String currencyId, HashMap hmItems, Date endDate, boolean isIncludeUnPosted, boolean isIncludeInit, String companyId, int dateType, boolean isBizCode, boolean isIncludeVerifyVch, Map otherParams) throws BOSException, EASBizException {
        PeriodCollection periodColl;
        AccountViewCollection colAccount;
        CompanyOrgUnitInfo _company;
        AccountAgeParam paramAge = new AccountAgeParam();
        CompanyOrgUnitInfo curCompany = _company = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion(_company);
        boolean isFilterAcctByAcctCussent = false;
        String endPeriodID = "";
        StringBuffer endAdjustPeriodID = new StringBuffer();
        String tempTableBal = "";
        int balType = isIncludeUnPosted ? 1 : 5;
        String acctTableID = _company.getAccountTable().getId().toString();
        StringBuffer inAccountNumber = null;
        if (isIsOnlyUnion) {
            isIncludeUnPosted = true;
            isFilterAcctByAcctCussent = !isIncludeVerifyVch;
        }
        boolean isDM = SQLUtil.isDM(ctx);
        StringBuffer inAccount = null;
        if (accountIds != null) {
            inAccount = new StringBuffer("(");
            for (int i = 0; i < accountIds.length; ++i) {
                inAccount.append("'").append(accountIds[i]).append("',");
            }
            inAccount.deleteCharAt(inAccount.length() - 1);
            inAccount.append(")");
        }
        if ((colAccount = (AccountViewCollection)otherParams.get("accounts")) != null && colAccount.size() > 0) {
            inAccountNumber = new StringBuffer("(");
            for (int i = 0; i < colAccount.size(); ++i) {
                inAccountNumber.append("'").append(colAccount.get(i).getNumber()).append("',");
            }
            inAccountNumber.deleteCharAt(inAccountNumber.length() - 1);
            inAccountNumber.append(")");
        }
        Object[] accountFrom = null;
        Object[] accountTo = null;
        if (otherParams.get("accountFrom") != null) {
            accountFrom = (Object[])otherParams.get("accountFrom");
        }
        if (otherParams.get("accountTo") != null) {
            accountTo = (Object[])otherParams.get("accountTo");
        }
        GLAcctAgeNewUtils.setEnterDateType(paramAge);
        ArrayList<AccountViewInfo> alAcResult = new ArrayList<AccountViewInfo>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        boolean isAllCurr = false;
        if (currencyId.equals("AllCurrency")) {
            isAllCurr = true;
        }
        boolean isGeneralCy = false;
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyId)) {
            isGeneralCy = true;
        }
        if ((periodColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)endDate, (Date)endDate, (IObjectPK)new ObjectUuidPK(curCompany.getId()))).size() <= 0) {
            throw new GLException(GLException.NOPERIODLIST);
        }
        if (periodColl.size() > 1) {
            endAdjustPeriodID.append("(");
            for (int i = 0; i < periodColl.size(); ++i) {
                endAdjustPeriodID.append("'").append(periodColl.get(i).getId().toString()).append("'");
                if (i == periodColl.size() - 1) continue;
                endAdjustPeriodID.append(",");
            }
            endAdjustPeriodID.append(")");
        }
        endPeriodID = periodColl.get(0).getId().toString();
        StringBuffer from = new StringBuffer();
        String companyFieldName = "";
        String assgrpFieldName = "";
        ArrayList<String> listParam = new ArrayList<String>();
        if (!isFilterAcctByAcctCussent) {
            listParam.add(endPeriodID);
        }
        if (isFilterAcctByAcctCussent) {
            from.append(" from t_gl_acctcussent CUSSENT  \r\n");
            companyFieldName = "fcompanyid";
            assgrpFieldName = "fassgrpid";
            from.append(" left outer join t_gl_voucher vch on vch.fid = cussent.fvoucherid  \r\n");
        } else {
            if (isDM && balType == 1) {
                from.append(" from t_gl_assistbalance_1f CUSSENT  \r\n");
            } else if (isDM && balType == 5) {
                from.append(" from t_gl_assistbalance_5f CUSSENT  \r\n");
            } else {
                from.append(" from t_gl_assistbalance CUSSENT  \r\n");
            }
            companyFieldName = "forgunitid";
            assgrpFieldName = "FAssistGrpID";
        }
        Map accountParams = GLAcctAgeNewUtils.makeArrayToString(accountFrom, accountTo);
        Connection con = null;
        String acctTmpTb = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid into accttmptable from t_bd_accountview  ");
        sql.append(" where fac = 1  ");
        sql.append(" and fcompanyid in(").append(companyId).append(") ");
        sql.append(" and faccounttableid = '").append(acctTableID).append("' ");
        SqlParams p = new SqlParams();
        if (accountParams != null) {
            GLAcctAgeNewUtils.buildAccountSql(sql, accountParams, "fnumber");
            String fromNumber = (String)accountParams.get("accountFrom");
            String toNumber = (String)accountParams.get("accountTo");
            if (fromNumber != null && !fromNumber.equals("")) {
                p.addString(fromNumber);
            }
            if (toNumber != null && !toNumber.equals("")) {
                p.addString(toNumber + "zzzzzz");
            }
        }
        if (inAccount != null) {
            sql.append("and fid in ").append(inAccount);
        }
        try {
            con = this.getConnection(ctx);
            acctTmpTb = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)p, (Connection)con).getTempTable();
            from.append(" inner join ").append(acctTmpTb).append(" actt on actt.fid = cussent.faccountid \r\n");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            logger.error((Object)e1.getMessage());
        }
        if (!isFilterAcctByAcctCussent) {
            sql.setLength(0);
            sql.append(" select ssc.fcompanyid,ssc.fcurrentperiodid,pd.fbegindate,pd.fenddate,pd.fnumber fcurnumber         \r\n");
            sql.append(" , case when npd.FNUMBER > pd.FNUMBER  then 1 else 0 end fisendinfutrue, npd.fnumber fendnumber        \r\n");
            sql.append(" into gl_systemstatus_tmp                                                     \r\n");
            sql.append(" from t_bd_systemstatus sst                                                   \r\n");
            sql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fsystemstatusid = sst.fid       \r\n");
            sql.append(" inner join t_bd_period pd on pd.fid = ssc.fcurrentperiodid                   \r\n");
            sql.append(" left join T_BD_PERIOD npd on npd.FTYPEID = pd.FTYPEID                        \r\n");
            sql.append(" where sst.fname='6'                                                          \r\n");
            sql.append(" and ssc.fcompanyid in (").append(companyId).append(")                        \r\n");
            sql.append(" and npd.fnumber = ?                                                         \r\n");
            sql.append(" and pd.FTYPEID = '").append(_company.getAccountPeriodType().getId().toString()).append("' ");
            String statusTmpTb = null;
            try {
                p.clear();
                int number = (endDate.getYear() + 1900) * 100 + (endDate.getMonth() + 1);
                p.addInt(number);
                statusTmpTb = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)p, (Connection)con).getTempTable();
                from.append(" inner join ").append(statusTmpTb).append(" status on status.fcompanyid = cussent.FORGUNITID \r\n");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            from.append(" inner join t_bd_accountview account on account.fid = actt.fid \r\n");
            from.append(" left outer join t_bd_accountview paccount on account.fparentid = paccount.fid  \r\n");
        }
        if (hmItems.size() > 0) {
            from.append(" inner join t_bd_assistanthg hg on cussent.").append(assgrpFieldName).append(" = hg.fid  \r\n");
        }
        StringBuffer innerJoinAsst = new StringBuffer();
        StringBuffer sqlGroupby = new StringBuffer();
        ArrayList alAstNumbers = new ArrayList();
        ArrayList alAstTables = new ArrayList();
        ArrayList alAstFields = new ArrayList();
        Iterator itemkeyit = hmItems.keySet().iterator();
        HashMap[] itemList = new HashMap[hmItems.keySet().size()];
        int k = 0;
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            Integer seq = (Integer)item.get("seq");
            if (seq != null) {
                itemList[seq.intValue()] = item;
            } else {
                itemList[k] = item;
            }
            ++k;
        }
        if (isBizCode && hmItems.size() > 0) {
            innerJoinAsst.append(" left join ").append("t_bd_customer").append(" cst").append(" on hg.").append("fcustomerid").append("=").append("cst").append(".fid             \r\n");
            innerJoinAsst.append(" left join T_BD_BizAnaylysisCode bac1 on bac1.fid = cst.FBizAnalysisCodeID \r\n");
            innerJoinAsst.append(" left join ").append("T_BD_Supplier").append(" sup").append(" on hg.").append("FProviderID").append("=").append("sup").append(".fid              \r\n");
            innerJoinAsst.append(" left join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID \r\n");
        }
        for (String number : alAstNumbers) {
            listParam.add(number);
        }
        StringBuffer where = new StringBuffer();
        StringBuffer whereCommon = new StringBuffer();
        StringBuffer whereCompany = new StringBuffer();
        whereCompany.append(" \r\n where cussent.").append(companyFieldName).append(" in (").append(companyId).append(")  \r\n");
        StringBuffer wherePeriod = new StringBuffer();
        if (!isGeneralCy && !isAllCurr) {
            whereCommon.append(" and cussent.fcurrencyid=?   \r\n");
            listParam.add(currencyId);
        }
        if (isFilterAcctByAcctCussent) {
            if (!isIncludeInit) {
                wherePeriod.append(" AND cussent.FPeriodID <> '").append("AAAAAAAAAAAAAAAAAAAAAII4jEw=").append("'  \r\n");
            }
        } else if (isDM) {
            wherePeriod.append(" AND pd.fid = '").append(endPeriodID).append("'  \r\n");
        } else {
            if (endAdjustPeriodID.length() > 0) {
                wherePeriod.append(" AND cussent.FPeriodID in ").append(endAdjustPeriodID).append(" \r\n");
            } else {
                wherePeriod.append(" AND cussent.FPeriodID = '").append(endPeriodID).append("'  \r\n");
            }
            wherePeriod.append(" AND cussent.FBalType = ").append(balType).append("  \r\n");
        }
        ArrayList bizParams = new ArrayList();
        for (String number : bizParams) {
            listParam.add(number);
        }
        String accountname = GlUtils.isAccountShowLongName(ctx, _company.getId().toString()) ? "Flongname_" : "Fname_";
        StringBuffer selectAccount = new StringBuffer(" distinct account.fid id,account.fdc fdc,account.fnumber fnumber,account.").append(accountname).append(loc).append(" fname,account.FParentID parentId,account.FLongNumber longNumber,account.FIsLeaf isLeaf,paccount.fNumber pnumber, paccount.flongnumber plongnumber ");
        String orderByAcctNumber = " order by account.fnumber  \r\n";
        StringBuffer merge = new StringBuffer();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (!isFilterAcctByAcctCussent) {
                StringBuffer whereCommonSub = new StringBuffer(" where 1 = 1 ");
                if (!isGeneralCy && !isAllCurr) {
                    whereCommonSub.append(" and cussent.fcurrencyid = ? ");
                }
                whereCommonSub.append(" and ((status.fisendinfutrue=1 and pd.fnumber <=status.fendnumber ) ");
                if (endAdjustPeriodID.length() > 0) {
                    whereCommonSub.append("or (status.fisendinfutrue=0 and cussent.fperiodid in ").append(endAdjustPeriodID).append(") ) \r\n");
                } else {
                    whereCommonSub.append("or (status.fisendinfutrue=0 and cussent.fperiodid ='" + endPeriodID + "') ) \r\n");
                }
                innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fid = cussent.FPeriodID ");
                long s = System.currentTimeMillis();
                tempTableBal = this.createTempTable4FuturePeriodAsstBal_New(ctx, con, listParam, balType, from, innerJoinAsst, whereCommonSub);
                logger.error((Object)("createtemptable-->" + (System.currentTimeMillis() - s)));
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                merge.append("select ").append(selectAccount).append(GLAcctAgeNewUtils.getResultSql4Acct(tempTableBal));
            } else {
                wherePeriod.append(" and (vch.FBookedDate <= ? or vch.fid is null)");
                where.append(whereCompany).append(whereCommon).append(wherePeriod);
                merge.append("select ").append(selectAccount).append(from).append(innerJoinAsst).append(where).append(sqlGroupby).append(orderByAcctNumber);
            }
            ps = con.prepareStatement(merge.toString());
            int index = 1;
            if (isFilterAcctByAcctCussent) {
                for (Object e : listParam) {
                    Object param;
                    if (e instanceof String) {
                        param = (String)e;
                        ps.setString(index++, (String)param);
                        continue;
                    }
                    if (!(e instanceof Integer)) continue;
                    param = (Integer)e;
                    ps.setInt(index++, (Integer)param);
                }
                ps.setDate(index++, new java.sql.Date(endDate.getTime()));
            }
            rs = ps.executeQuery();
            HashMap<String, String> distinctMap = new HashMap<String, String>();
            Object var66_78 = null;
            while (rs.next()) {
                String string = rs.getString("fnumber");
                if (distinctMap.get(string) != null) continue;
                AccountViewInfo account = new AccountViewInfo();
                account.put("dc", (Object)rs.getInt("fdc"));
                account.put("id", (Object)rs.getString("id"));
                account.put("number", (Object)string);
                account.put("name", (Object)rs.getString("fname"));
                if (rs.getString("parentId") != null && rs.getString("parentId").length() > 0) {
                    AccountViewInfo parent = new AccountViewInfo();
                    parent.setId(BOSUuid.read((String)rs.getString("parentId")));
                    parent.setNumber(rs.getString("pnumber"));
                    parent.setLongNumber(rs.getString("plongnumber"));
                    account.setParent(parent);
                }
                account.setLongNumber(rs.getString("longNumber"));
                account.setIsLeaf(rs.getBoolean("isLeaf"));
                alAcResult.add(account);
                distinctMap.put(string, string);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return alAcResult;
    }

    /*
     * WARNING - void declaration
     */
    protected ArrayList queryItemIndexNew(Context ctx, String[] accountIds, String currencyId, HashMap hmItems, Date endDate, boolean isIncludeUnPosted, boolean isIncludeInit, String companyId, int dateType, boolean isIncludeVerifyVch, Map otherParams) throws BOSException, EASBizException {
        CompanyOrgUnitInfo _company;
        CompanyOrgUnitInfo curCompany = _company = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion(_company);
        boolean isFilterAcctByAcctCussent = false;
        PeriodInfo currPeriod = null;
        PeriodInfo endPeriod = null;
        String currPeriodID = "";
        String endPeriodID = "";
        StringBuffer endAdjustPeriodID = new StringBuffer();
        int endPeriodNumber = 0;
        String tempTableBal = "";
        int balType = 1;
        String acctTableID = "";
        boolean isSumDC = otherParams.get("isSumDC") != null && (Boolean)otherParams.get("isSumDC") != false;
        boolean isDM = SQLUtil.isDM(ctx);
        int verifyMode = -1;
        if (isIsOnlyUnion) {
            isIncludeUnPosted = true;
            isFilterAcctByAcctCussent = !isIncludeVerifyVch;
            String companyIdTempTable = GLAcctAgeNewUtils.createIdsTempTable(ctx, companyId);
            if (!StringUtils.isEmpty((String)companyIdTempTable)) {
                companyId = "select fid from " + companyIdTempTable;
                GLAcctAgeNewUtils.idsTempTables.get().add(companyIdTempTable);
            }
        } else {
            curCompany = GlUtils.getCompanyById(ctx, companyId);
            verifyMode = GlUtils.getVerifyMode(ctx, companyId);
            if (verifyMode == 2) {
                isIncludeUnPosted = true;
            }
            if (verifyMode != 0 && !isIncludeVerifyVch) {
                isFilterAcctByAcctCussent = true;
            }
        }
        balType = isIncludeUnPosted ? 1 : 5;
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("GL_064", null);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
        Object isShowLongNumberObj = hmAllParam.get("GL_064");
        boolean isShowLongNumber = false;
        if (isShowLongNumberObj != null) {
            isShowLongNumber = Boolean.valueOf(isShowLongNumberObj.toString());
        }
        ArrayList<String> asstact = new ArrayList<String>();
        StringBuffer itemselect = new StringBuffer();
        ArrayList<String> param = new ArrayList<String>();
        int isEndPeriodInFuture = 0;
        if (!isFilterAcctByAcctCussent && !isIsOnlyUnion) {
            PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)endDate, (Date)endDate, (CompanyOrgUnitInfo)curCompany);
            if (periodColl.size() <= 0) {
                throw new GLException(GLException.NOPERIODLIST);
            }
            if (periodColl.size() > 1) {
                endAdjustPeriodID.append("(");
                for (int i = 0; i < periodColl.size(); ++i) {
                    endAdjustPeriodID.append("'").append(periodColl.get(i).getId().toString()).append("'");
                    if (i == periodColl.size() - 1) continue;
                    endAdjustPeriodID.append(",");
                }
                endAdjustPeriodID.append(")");
            }
            endPeriod = periodColl.get(0);
            endPeriodID = periodColl.get(0).getId().toString();
            endPeriodNumber = endAdjustPeriodID.length() > 0 ? periodColl.get(periodColl.size() - 1).getNumber() : periodColl.get(0).getNumber();
            currPeriod = GlUtils.getCurrentPeriod(ctx, curCompany.getId().toString());
            currPeriodID = currPeriod.getId().toString();
            isEndPeriodInFuture = endPeriodID.compareToIgnoreCase(currPeriodID) == 0 ? 0 : (PeriodUtils.PeriodCompare((PeriodInfo)endPeriod, (PeriodInfo)currPeriod) ? 1 : -1);
        }
        ArrayList alAcResult = new ArrayList();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer from = new StringBuffer();
        String companyFieldName = "";
        String assgrpFieldName = "";
        StringBuffer innerJoinAsst = new StringBuffer();
        StringBuffer innerJoinAsstNoFilter = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        StringBuffer select = new StringBuffer();
        StringBuffer where = new StringBuffer();
        StringBuffer whereCommon = new StringBuffer();
        StringBuffer whereCompany = new StringBuffer();
        StringBuffer wherePeriod = new StringBuffer();
        StringBuffer orderBy = new StringBuffer();
        StringBuffer whereItem = new StringBuffer();
        StringBuffer sqlGroupby = new StringBuffer();
        ArrayList alAstNumbers = new ArrayList();
        ArrayList alAstTables = new ArrayList();
        ArrayList alAstFields = new ArrayList();
        Iterator itemkeyit = hmItems.keySet().iterator();
        HashMap[] itemList = new HashMap[hmItems.keySet().size()];
        if (isFilterAcctByAcctCussent) {
            from.append(" from t_gl_acctcussent CUSSENT  \r\n");
            companyFieldName = "fcompanyid";
            assgrpFieldName = "fassgrpid";
            from.append(" left outer join t_gl_voucher vch on vch.fid = cussent.fvoucherid  \r\n");
        } else {
            if (isDM && balType == 1) {
                from.append(" from t_gl_assistbalance_1f CUSSENT  \r\n");
            } else if (isDM && balType == 5) {
                from.append(" from t_gl_assistbalance_5f CUSSENT  \r\n");
            } else {
                from.append(" from t_gl_assistbalance CUSSENT  \r\n");
            }
            companyFieldName = "forgunitid";
            assgrpFieldName = "FAssistGrpID";
        }
        if (isIsOnlyUnion) {
            whereCompany.append(" where cussent.").append(companyFieldName).append(" in (").append(companyId).append(")  \r\n");
        } else {
            whereCompany.append(" where cussent.").append(companyFieldName).append("=?  \r\n");
            param.add(companyId);
        }
        int k = 0;
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            Integer seq = (Integer)item.get("seq");
            if (seq != null) {
                itemList[seq.intValue()] = item;
            } else {
                itemList[k] = item;
            }
            ++k;
        }
        HashMap<String, String> numMap = new HashMap<String, String>();
        int j = 0;
        ArrayList<String> propeNames = new ArrayList<String>(itemList.length);
        for (int i = 0; i < itemList.length; ++i) {
            HashMap item = itemList[i];
            String[] numbers = (String[])hmItems.get(item);
            String table = (String)item.get("tablename");
            String field = (String)item.get("fieldname");
            String itemTypeid = (String)item.get("id");
            String propname = (String)item.get("propname");
            propeNames.add(propname);
            boolean isUseLongNumber = (Boolean)item.get("useLongNUmber");
            asstact.add(itemTypeid);
            itemselect.append(",t").append(j).append(".").append("fid").append(" as t").append(j).append("fid");
            numMap.put("t" + j + "Fnumber", propname);
            itemselect.append(",").append(isUseLongNumber ? "replace(t" + j + ".FLongNumber,'!','.') as t" : "t" + j + ".Fnumber as t").append(j).append("Fnumber");
            itemselect.append(",t").append(j).append(".").append("Fname_").append(loc).append(" as t").append(j).append("Fname");
            innerJoinAsst.append(" inner join ").append(table).append(" t").append(j).append(" on hg.").append(field).append("=").append("t").append(j).append(".fid");
            innerJoinAsstNoFilter.append(" inner join ").append(table).append(" t").append(j).append(" on hg.").append(field).append("=").append("t").append(j).append(".fid");
            if (numbers[0] != null) {
                if (!isUseLongNumber) {
                    whereItem.append(" and ").append("t").append(j).append(".fnumber>= '" + numbers[0] + "' ");
                } else {
                    numbers[0] = numbers[0].replace('.', '!');
                    whereItem.append(" and ").append("t").append(j).append(".flongnumber>= '" + numbers[0] + "'");
                }
            }
            if (numbers[1] != null) {
                if (!isUseLongNumber) {
                    whereItem.append(" and ").append("t").append(j).append(".fnumber<= '" + numbers[1] + "'");
                } else {
                    numbers[1] = numbers[1].replace('.', '!');
                    whereItem.append(" and ").append("t").append(j).append(".flongnumber<= '" + numbers[1] + "'");
                }
            }
            if (numbers[2] != null) {
                whereItem.append(" and ").append("t").append(i).append(".");
                String number2 = numbers[2];
                String fnumber = "fnumber";
                if (isUseLongNumber) {
                    number2 = number2.replace('.', '!');
                    fnumber = "flongnumber";
                }
                String[] nums = number2.split(",");
                whereItem.append(fnumber).append(" in(");
                for (String num : nums) {
                    whereItem.append("?,");
                    param.add(num);
                }
                whereItem.deleteCharAt(whereItem.lastIndexOf(",")).append(")");
            }
            ++j;
        }
        select.append("select distinct hg.fid as hgfid ");
        select.append(itemselect);
        if (isIsOnlyUnion) {
            from.append(" inner join (select * from t_bd_accountview t where t.fcompanyid in (").append(companyId).append(") )");
            from.append("  account on cussent.faccountid = account.fid  \r\n");
        } else {
            from.append(" inner join t_bd_accountview account on cussent.faccountid = account.fid  ");
            whereItem.append("  and account.fcompanyid = ?  \r\n");
            param.add(companyId);
        }
        from.append(" inner join t_bd_assistanthg hg on cussent.").append(assgrpFieldName).append(" = hg.fid  \r\n");
        whereCompany.append(whereItem);
        StringBuffer inAccount = null;
        if (accountIds != null) {
            inAccount = new StringBuffer("(");
            for (int i = 0; i < accountIds.length; ++i) {
                inAccount.append("'").append(accountIds[i]).append("',");
            }
            inAccount.deleteCharAt(inAccount.length() - 1);
            inAccount.append(")");
        }
        StringBuffer inAccountNumber = null;
        AccountViewCollection colAccount = (AccountViewCollection)otherParams.get("accounts");
        if (colAccount != null && colAccount.size() > 0) {
            inAccountNumber = new StringBuffer("(");
            for (int i = 0; i < colAccount.size(); ++i) {
                inAccountNumber.append("'").append(colAccount.get(i).getNumber()).append("',");
            }
            inAccountNumber.deleteCharAt(inAccountNumber.length() - 1);
            inAccountNumber.append(")");
        }
        if (isIsOnlyUnion && inAccountNumber != null) {
            whereCommon.append(" and ACCOUNT.fnumber in ").append(inAccountNumber).append("  \r\n");
        } else if (!isIsOnlyUnion && inAccount != null) {
            whereCommon.append(" and cussent.faccountid in ").append(inAccount).append("  \r\n");
        }
        boolean isAllCurr = false;
        if (currencyId.equals("AllCurrency")) {
            isAllCurr = true;
        }
        boolean isGeneralCy = false;
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyId)) {
            isGeneralCy = true;
        }
        if (!isGeneralCy && !isAllCurr) {
            whereCommon.append(" and cussent.fcurrencyid=?   \r\n");
            param.add(currencyId);
        }
        if (isFilterAcctByAcctCussent) {
            if (!isIncludeInit) {
                wherePeriod.append(" AND cussent.FPeriodID <> '").append("AAAAAAAAAAAAAAAAAAAAAII4jEw=").append("'  \r\n");
            }
        } else if (isDM) {
            if (isSumDC) {
                wherePeriod.append(" AND cussent.FPeriod <= ?  \r\n");
            } else if (endAdjustPeriodID.length() > 0) {
                wherePeriod.append(" and pd.fid in ").append(endAdjustPeriodID.toString()).append(" \r\n");
            } else {
                wherePeriod.append(" AND pd.fid = ?  \r\n");
            }
        } else {
            if (isSumDC) {
                wherePeriod.append(" AND cussent.FPeriod<= ?  \r\n");
            } else if (endAdjustPeriodID.length() > 0) {
                wherePeriod.append(" and cussent.FPeriodID in ").append(endAdjustPeriodID.toString()).append(" \r\n");
            } else {
                wherePeriod.append(" AND cussent.FPeriodID = ?  \r\n");
            }
            wherePeriod.append(" AND cussent.FBalType = ").append(balType).append("  \r\n");
        }
        if (asstact.size() > 0) {
            StringBuffer noinitwheresubWhere = new StringBuffer();
            whereCommon.append(" and hg.fasstaccountid  in ( ");
            whereCommon.append(" select ass.fid from t_bd_asstaccount ass join t_bd_asstactgroupdetail ast on ast.fasstaccountid=ass.fid ");
            noinitwheresubWhere.append(" where ");
            for (int i = 0; i < asstact.size(); ++i) {
                if (i == 0) {
                    noinitwheresubWhere.append(" ast.fasstacttypeid = ? ");
                } else {
                    whereCommon.append(" join t_bd_asstactgroupdetail ast" + i + " on ast" + i + ".fasstaccountid=ass.fid");
                    noinitwheresubWhere.append(" and ast" + i + ".fasstacttypeid = ? ");
                }
                param.add(asstact.get(i).toString());
            }
            whereCommon.append(noinitwheresubWhere);
            whereCommon.append(" ) ");
        }
        StringBuffer merge = new StringBuffer();
        orderBy.append(" order by");
        for (int start = 0; start < j; ++start) {
            if (start == 0) {
                orderBy.append(" t" + start + "fnumber");
                continue;
            }
            orderBy.append(" ,t" + start + "fnumber");
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isDbTypeOracleDB2 = GLAcctAgeNewUtils.checkDbTypeIsOracleDB2(ctx);
        try {
            con = this.getConnection(ctx);
            if (!isFilterAcctByAcctCussent) {
                if (!isIsOnlyUnion) {
                    if (1 == isEndPeriodInFuture) {
                        void var73_92;
                        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currPeriod);
                        int[] periodRange = new int[]{nextPeriod.getPeriodYear(), nextPeriod.getPeriodNumber(), endPeriod.getPeriodYear(), endPeriod.getPeriodNumber()};
                        String string = "";
                        if (isSumDC) {
                            String string2 = " and pd.fnumber<=" + endPeriodNumber;
                        } else {
                            String string3 = " and " + SQLUtil.getPeriodCondition("pd.fperiodyear", "pd.fperiodnumber", periodRange) + "  \r\n";
                        }
                        whereCommon = whereCompany.append(whereCommon);
                        if (isDM) {
                            innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fnumber = cussent.FPeriod ");
                        } else {
                            innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fid = cussent.FPeriodID ");
                        }
                        tempTableBal = this.createTempTable4FuturePeriodAsstBal(ctx, con, isDbTypeOracleDB2, isIsOnlyUnion, tempTableBal, param, companyId, currPeriodID, endPeriodID, endAdjustPeriodID, balType, isEndPeriodInFuture, (String)var73_92, from, innerJoinAsst, whereCommon, isDM);
                        merge.append(GLAcctAgeNewUtils.getResultSql4Item(tempTableBal, select, innerJoinAsstNoFilter, orderBy));
                    } else {
                        if (isDM) {
                            innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fnumber = cussent.FPeriod ");
                        }
                        where.append(whereCompany).append(whereCommon).append(wherePeriod);
                        merge.append(select).append(from).append(innerJoinAsst).append(where).append(sqlGroupby).append(orderBy);
                    }
                } else {
                    String subCompanyID = "";
                    java.sql.Date subEndDate = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer sqlTmp = new StringBuffer();
                    sqlTmp.append(" ----\u5404\u4e2a\u516c\u53f8\u7684\u5f53\u524d\u671f\u95f4                                                       \r\n");
                    sqlTmp.append(" select ssc.fcompanyid,ssc.fcurrentperiodid,pd.fbegindate,pd.fenddate         \r\n");
                    sqlTmp.append(" from t_bd_systemstatus sst                                                   \r\n");
                    sqlTmp.append(" inner join t_bd_systemstatusctrol ssc on ssc.fsystemstatusid = sst.fid       \r\n");
                    sqlTmp.append(" inner join t_bd_period pd on pd.fid = ssc.fcurrentperiodid                   \r\n");
                    sqlTmp.append(" where sst.fname='6'                                                          \r\n");
                    sqlTmp.append(" and ssc.fcompanyid in (").append(companyId).append(")                        \r\n");
                    ps = con.prepareStatement(sqlTmp.toString());
                    rs = ps.executeQuery();
                    if (isDM) {
                        innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fnumber = cussent.FPeriod ");
                    } else {
                        innerJoinAsst.append(" \r\n inner join t_bd_period pd on pd.fid = cussent.FPeriodID ");
                    }
                    while (rs.next()) {
                        subCompanyID = rs.getString(1);
                        currPeriodID = rs.getString(2);
                        subEndDate = rs.getDate(3);
                        PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)endDate, (Date)endDate, (IObjectPK)new ObjectUuidPK(subCompanyID));
                        if (periodColl.size() <= 0) {
                            throw new GLException(GLException.NOPERIODLIST);
                        }
                        endAdjustPeriodID.setLength(0);
                        if (periodColl.size() > 1) {
                            endAdjustPeriodID.append("(");
                            for (int i = 0; i < periodColl.size(); ++i) {
                                endAdjustPeriodID.append("'").append(periodColl.get(i).getId().toString()).append("'");
                                if (i == periodColl.size() - 1) continue;
                                endAdjustPeriodID.append(",");
                            }
                            endAdjustPeriodID.append(")");
                        }
                        endPeriod = periodColl.get(0);
                        endPeriodID = periodColl.get(0).getId().toString();
                        isEndPeriodInFuture = endPeriod.getEndDate().after(subEndDate) ? 1 : (endPeriod.getEndDate().before(subEndDate) ? -1 : 0);
                        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(currPeriodID));
                        int[] periodRange = new int[]{nextPeriod.getPeriodYear(), nextPeriod.getPeriodNumber(), endPeriod.getPeriodYear(), endPeriod.getPeriodNumber()};
                        String yearNumberFilter = " and " + SQLUtil.getPeriodCondition("pd.fperiodyear", "pd.fperiodnumber", periodRange) + "  \r\n";
                        whereCompany.setLength(0);
                        if (whereItem != null) {
                            whereCompany.append(whereItem);
                        }
                        whereCompany.append("\r\n and cussent.").append(companyFieldName).append(" = ?  \r\n");
                        stringBuffer.setLength(0);
                        stringBuffer.append("\r\n where 1=1 ");
                        stringBuffer.append(whereCommon).append(whereCompany);
                        tempTableBal = this.createTempTable4FuturePeriodAsstBal(ctx, con, isDbTypeOracleDB2, isIsOnlyUnion, tempTableBal, param, subCompanyID, currPeriodID, endPeriodID, endAdjustPeriodID, balType, isEndPeriodInFuture, yearNumberFilter, from, innerJoinAsst, stringBuffer, isDM);
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                    merge.append(GLAcctAgeNewUtils.getResultSql4Item(tempTableBal, select, innerJoinAsstNoFilter, orderBy));
                }
            } else {
                wherePeriod.append(" and (vch.FBookedDate <= ? or vch.FID is null)");
                where.append(whereCompany).append(whereCommon).append(wherePeriod);
                merge.append(select).append(from).append(innerJoinAsst).append(where).append(sqlGroupby).append(orderBy);
            }
            ps = con.prepareStatement(merge.toString());
            int index = 1;
            if (isFilterAcctByAcctCussent || (1 != isEndPeriodInFuture || isIsOnlyUnion) && !isIsOnlyUnion) {
                for (Object e : param) {
                    if (e instanceof String) {
                        String strParam = (String)e;
                        ps.setString(index++, strParam);
                        continue;
                    }
                    if (!(e instanceof Integer)) continue;
                    Integer iParam = (Integer)e;
                    ps.setInt(index++, iParam);
                }
                if (!isFilterAcctByAcctCussent) {
                    if (isSumDC) {
                        ps.setInt(index++, endPeriodNumber);
                    } else if (endAdjustPeriodID.length() == 0) {
                        ps.setString(index++, endPeriodID);
                    }
                } else {
                    ps.setDate(index++, new java.sql.Date(endDate.getTime()));
                }
            }
            TreeMap<String, ItemStructureInfo> resultMap = new TreeMap<String, ItemStructureInfo>();
            rs = ps.executeQuery();
            while (rs.next()) {
                ItemStructureInfo itemStructureInfo = new ItemStructureInfo();
                String hgfid = rs.getString("hgfid");
                StringBuffer itemNumbers = new StringBuffer();
                StringBuffer itemsId = new StringBuffer();
                for (int start = 0; start < j; ++start) {
                    HashMap<String, String> item = new HashMap<String, String>();
                    String itemNumber = rs.getString("t" + start + "Fnumber");
                    itemStructureInfo.getData().put(numMap.get("t" + start + "Fnumber"), itemNumber);
                    String itemid = rs.getString("t" + start + "fid");
                    itemNumbers.append(itemNumber);
                    itemsId.append(itemid);
                    item.put("hgfid", hgfid);
                    item.put("id", rs.getString("t" + start + "fid"));
                    item.put("number", itemNumber);
                    item.put("name", rs.getString("t" + start + "fname"));
                    item.put("propeName", (String)propeNames.get(start));
                    itemStructureInfo.getItem().add(item);
                }
                hgfid = "'" + hgfid + "'";
                itemStructureInfo.setHgid(hgfid);
                if (resultMap.containsKey(itemNumbers.toString())) {
                    ItemStructureInfo itemStructureInfo2 = (ItemStructureInfo)resultMap.get(itemNumbers.toString());
                    itemStructureInfo2.setHgid(itemStructureInfo2.getHgid() + "," + hgfid + "");
                    continue;
                }
                itemStructureInfo.setItemsid(itemsId.toString());
                resultMap.put(itemNumbers.toString(), itemStructureInfo);
            }
            alAcResult.addAll(resultMap.values());
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return alAcResult;
    }

    private ArrayList queryBizCodeIndex(Context ctx, String[] accountIds, String currencyId, HashMap hmItems, Date endDate, boolean isIncludeUnPosted, boolean isIncludeInit, String companyId, int dateType) throws BOSException, EASBizException {
        CompanyOrgUnitInfo _company;
        CompanyOrgUnitInfo curCompany = _company = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion(_company);
        ArrayList<BizAnalysisCodeInfo> alAcResult = new ArrayList<BizAnalysisCodeInfo>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" select bc.fid,bc.fnumber fbiznumber,bc.fname_").append(loc).append(" fbizname\r\nfrom T_BD_BizAnaylysisCode bc \r\nwhere ");
        Iterator itemkeyit = hmItems.keySet().iterator();
        int j = 0;
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            String[] numbers = (String[])hmItems.get(item);
            if (numbers[0] != null) {
                sql.append("bc.fnumber >='").append(numbers[0]).append("' and ");
            }
            if (numbers[1] != null) {
                sql.append("bc.fnumber <'").append(numbers[1]).append("~' and ");
            }
            if (numbers[2] != null) {
                String[] nums;
                sql.append("bc.fnumber in( ");
                for (String num : nums = numbers[2].split(",")) {
                    sql.append("'").append(num).append("',");
                }
                sql.deleteCharAt(sql.lastIndexOf(",")).append(") and ");
            }
            ++j;
        }
        if (isIsOnlyUnion) {
            String[] comid = (companyId == null ? "" : companyId).split(",");
            HashSet<String> comSet = new HashSet<String>();
            for (int i = 0; i < comid.length; ++i) {
                if (comid[i] != null && comid[i].length() > 1) {
                    comSet.add(comid[i].substring(1, comid[i].length() - 1));
                    continue;
                }
                comSet.add("");
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            EntityViewInfo view = new EntityViewInfo();
            sic = view.getSelector();
            sic.add(new SelectorItemInfo("cu.id"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", comSet, CompareType.INCLUDE));
            CompanyOrgUnitCollection col = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            ObjectUuidPK[] cuIds = new ObjectUuidPK[col.size()];
            for (int i = 0; col != null && i < col.size(); ++i) {
                CompanyOrgUnitInfo com = col.get(i);
                cuIds[i] = new ObjectUuidPK(com.getCU().getId().toString());
            }
            sql.append(BizAnalysisCodeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK[])cuIds, "bc.fid", "bc.fadmincuid"));
        } else {
            curCompany = GlUtils.getCompanyById(ctx, companyId);
            sql.append(BizAnalysisCodeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(curCompany.getCU().getId()), "bc.fid", "bc.fadmincuid"));
        }
        sql.append(" order by bc.fnumber ");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                BizAnalysisCodeInfo account = new BizAnalysisCodeInfo();
                if (!isIsOnlyUnion && rs.getString("fid") != null) {
                    account.put("id", (Object)rs.getString("fid"));
                }
                account.put("number", (Object)rs.getString("fbiznumber"));
                account.put("name", (Object)rs.getString("fbizname"));
                alAcResult.add(account);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return alAcResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList _queryAccount(Context ctx, String[] accountIds, String currencyId, HashMap hmItems, Date endDate, boolean isIncludeUnPosted, boolean isIncludeInit, String companyId, int dateType, int indexType, boolean isBizCode, boolean isIncludeVerifyVch, Map otherParams) throws BOSException, EASBizException {
        AccountViewCollection colAccount = (AccountViewCollection)otherParams.get("accounts");
        if (colAccount != null && colAccount.size() > 0) {
            accountIds = new String[colAccount.size()];
            for (int i = 0; i < accountIds.length; ++i) {
                accountIds[i] = colAccount.get(i).getId().toString();
            }
        }
        try {
            if (indexType == 0) {
                ArrayList arrayList = this.queryAcctIndexNew(ctx, accountIds, currencyId, hmItems, endDate, isIncludeUnPosted, isIncludeInit, companyId, dateType, isBizCode, isIncludeVerifyVch, otherParams);
                return arrayList;
            }
            if (isBizCode) {
                ArrayList arrayList = this.queryBizCodeIndex(ctx, accountIds, currencyId, hmItems, endDate, isIncludeUnPosted, isIncludeInit, companyId, dateType);
                return arrayList;
            }
            ArrayList arrayList = this.queryItemIndexNew(ctx, accountIds, currencyId, hmItems, endDate, isIncludeUnPosted, isIncludeInit, companyId, dateType, isIncludeVerifyVch, otherParams);
            return arrayList;
        }
        finally {
            GLAcctAgeNewUtils.releaseIdsTempTable(ctx);
        }
    }

    private StringBuffer getSql_InsertAcTemp(AccountAgeParam paramAge, boolean isInclude3SumOverDue, boolean isUseHgOutSideReal) {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into ").append(paramAge.getTempTableAcSum());
        sql.append("( ");
        if (paramAge.isIncludeVerifyVch() && isUseHgOutSideReal) {
            sql.append(paramAge.getSqlSelecthgoutsideReal());
        } else {
            sql.append(paramAge.getSqlSelecthgoutside());
        }
        if (isInclude3SumOverDue) {
            sql.append(",leftamount,sumall");
            sql.append(",sumoverdue");
        }
        sql.append(",sumunoverdue");
        if (paramAge.isRptQuery()) {
            sql.append(",sum0) ");
        } else {
            int j;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    sql.append(",sum" + j);
                }
            }
            int index = 0;
            for (int i = 0; i <= paramAge.getDaylen(); ++i) {
                index = j + i;
                sql.append(",sum" + index);
            }
            sql.append(") ");
        }
        return sql;
    }

    private void createTempTable_ByBal_AcSum(AccountAgeParam paramAge) throws BOSException, EASBizException {
        String tempTableAcSum = null;
        StringBuffer createTable = new StringBuffer();
        createTable.append("( ");
        if (paramAge.getSqlCreateHgTbl().length() > 0) {
            createTable.append(paramAge.getSqlCreateHgTbl());
        }
        createTable.append(" leftamount numeric(28,10) not null default 0,sumall numeric(28,10) not null default 0");
        createTable.append(",sumunoverdue numeric(28,10) not null default 0,sumoverdue numeric(28,10) not null default 0");
        if (paramAge.isRptQuery()) {
            createTable.append(",sum0 numeric(28,10) not null default 0 ");
        } else {
            int j;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                    createTable.append(",sum" + j + " numeric(28,10) not null default 0");
                }
            }
            int index = 0;
            for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
                index = j + i;
                createTable.append(",sum" + index + " numeric(28,10) not null default 0");
            }
        }
        createTable.append(")");
        tempTableAcSum = GLAcctAgeNewUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_age", createTable);
        paramAge.setTempTableAcSum(tempTableAcSum);
        if (paramAge.isRptQuery() && paramAge.getSqlCreateHgTbl().length() > 0) {
            this.tempAcSumTableMap.put(paramAge.getSqlCreateHgTbl().toString(), tempTableAcSum);
        }
    }

    private void createTempTable_ByBal_AcSum_AgeDays(AccountAgeParam paramAge) throws EASBizException, BOSException {
        String tempTableAcSum = null;
        StringBuffer createTable = new StringBuffer();
        createTable.append("( ");
        if (paramAge.getSqlCreateHgTbl().length() > 0) {
            createTable.append(paramAge.getSqlCreateHgTbl());
        }
        createTable.append("sumamt numeric(28,10) not null default 0,days int not null default 0 ");
        createTable.append(" )");
        tempTableAcSum = GLAcctAgeNewUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_age_days", createTable);
        paramAge.setTempTableAcSum(tempTableAcSum);
    }

    private StringBuffer getSql_ByAcctBal_AcNotInit(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        this.getSql_ByAcctBal_AcNotInit_Select_New(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_AcNotInit_From(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_AcNotInit_Where(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(paramAge.getSqlSelectNotInit()).append(paramAge.getSqlFromTable()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereNotInitBalNotZero());
        return sql;
    }

    private StringBuffer getSql_ByBal_AcVeriSum(AccountAgeParam paramAge) {
        String dateField = paramAge.getStrDateType_AC();
        dateField = !paramAge.isRptQuery() ? (!dateField.equalsIgnoreCase("fenddate") ? "cussent.fvarbizdate fbizDate," : "cussent.fenddate fbizDate,") : "cussent.fvarbizdate fbizDate,cussent.fenddate fenddate,";
        StringBuffer sql = new StringBuffer();
        StringBuffer sum = new StringBuffer();
        sum.append(" ").append(paramAge.getAmountField_veri()).append(" FUnVerifiedAmtFor, \r\n");
        sum.append(dateField);
        sum.append(" cussent.fbizNumber FBizNumber  \r\n");
        GLAcctAgeNewUtils.getSql_ByBal_AcVeriSum_From_New(paramAge);
        GLAcctAgeNewUtils.getSql_ByBal_AcVeriSum_Where_New(paramAge);
        String sqlSelectHg = paramAge.getSqlSelecthg().toString();
        sql.append("select ").append(sqlSelectHg).append(sum).append(paramAge.getSqlFromVeriSum()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereVeriSum());
        return sql;
    }

    private void getSql_ByAcctBal_AcNotInit_Select_New(AccountAgeParam paramAge) {
        StringBuffer sqlSelect = paramAge.getSqlSelectNotInit();
        if (paramAge.isRptQuery()) {
            sqlSelect.append(this.getRptSelectHeadSql(paramAge));
        } else {
            sqlSelect.append(this.getSelectHeadSql(paramAge));
        }
    }

    private StringBuffer getSql_ByAcctBal_AcInit(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        this.getSql_ByAcctBal_AcInit_Select_New(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_AcInit_From(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_AcInit_Where(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(paramAge.getSqlSelectInit()).append(paramAge.getSqlFromInit()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereInitBalNotZero());
        return sql;
    }

    private void getSql_ByAcctBal_AcInit_Select_New(AccountAgeParam paramAge) {
        StringBuffer sqlSelect = paramAge.getSqlSelectInit();
        if (paramAge.isRptQuery()) {
            sqlSelect.append(this.getRptSelectHeadSql(paramAge));
        } else {
            sqlSelect.append(this.getSelectHeadSql(paramAge));
        }
    }

    private ArrayList create_LastResult_ByAcctBal(AccountAgeParam paramAge, ResultSet rs) throws SQLException {
        ArrayList alAcResult = new ArrayList();
        String curreName = "";
        String max = GlUtils.getMaxChar(paramAge.getCtx());
        while (rs.next()) {
            int in_j;
            ArrayList<Object> listLine = new ArrayList<Object>();
            int itemSize = paramAge.getAlAstTables().size();
            if (paramAge.isAccountList() && !paramAge.isBizCode()) {
                itemSize = 1;
            } else if (paramAge.isBizCode() && paramAge.getHmItems().size() != 0) {
                if (rs.getString("fcurrid").equals(max)) {
                    listLine.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)paramAge.getCtx().getLocale()));
                } else {
                    listLine.add(rs.getString("T0fnumber") + "@_@" + rs.getString("T0fname"));
                }
            }
            for (int i = 0; i < itemSize; ++i) {
                String numkey = "T" + i + "fnumber";
                String namekey = "T" + i + "fname";
                if (rs.getString("fcurrid").equals(max)) {
                    listLine.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)paramAge.getCtx().getLocale()));
                    continue;
                }
                listLine.add(rs.getString(numkey) + "@_@" + rs.getString(namekey));
            }
            if (rs.getString("fcurrname") == null || rs.getString("fcurrname").length() == 0) {
                if (paramAge.getHmItems().size() == 0 || paramAge.isAccountBC()) {
                    listLine.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)paramAge.getCtx().getLocale()));
                } else {
                    listLine.add(curreName);
                }
            } else {
                curreName = rs.getString("fcurrname");
                if (paramAge.isIsOnlyUnion() && "total".equals(rs.getString("fsumcompanyid")) && paramAge.getHmItems().size() == 0) {
                    listLine.add(curreName + " " + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"35_RptAsstactGGUI", (Locale)paramAge.getCtx().getLocale()));
                } else {
                    listLine.add(curreName);
                }
            }
            if (paramAge.isIsOnlyUnion()) {
                listLine.add(rs.getString("fsumcompanyname"));
            }
            listLine.add(rs.getBigDecimal("sumall"));
            listLine.add(rs.getBigDecimal("sumunoverdue"));
            int index = 0;
            if (paramAge.isShowUmexpired()) {
                for (in_j = 0; in_j <= paramAge.getUndaylen(); ++in_j) {
                    listLine.add(rs.getBigDecimal("sum" + in_j));
                }
            }
            BigDecimal sumoverdue = rs.getBigDecimal("sumoverdue");
            listLine.add(sumoverdue);
            for (int i = 0; i <= paramAge.getDaylen(); ++i) {
                index = i + in_j;
                listLine.add(rs.getBigDecimal("sum" + index));
            }
            if (paramAge.isIsOnlyUnion()) {
                HashMap<Object, Object> otherInfo = new HashMap<Object, Object>();
                CompanyOrgUnitInfo companyUnit = new CompanyOrgUnitInfo();
                companyUnit.put("id", (Object)rs.getString("fsumcompanyid"));
                companyUnit.put("level", (Object)rs.getString("fsumcompanylevel"));
                companyUnit.put("isleaf", (Object)rs.getString("fsumcompanyisleaf"));
                companyUnit.put("name", (Object)rs.getString("fsumcompanyname"));
                for (int i = 0; i < itemSize; ++i) {
                    String key = paramAge.isAccountList() ? "Taccountid" : "T" + i + paramAge.getAlAstFields().get(i);
                    otherInfo.put(paramAge.getAlAstFields().get(i), rs.getString(key));
                    if (paramAge.getIndexType() != 1) continue;
                    otherInfo.put("accountViewNumber", rs.getString("T" + i + "fnumber"));
                }
                if (paramAge.isAccountBC() && !paramAge.isAccountBCNoType()) {
                    otherInfo.put("BizCodeNumber", rs.getString("T0fnumber"));
                } else if (paramAge.isBizCode() && !paramAge.isAccountBCNoType()) {
                    otherInfo.put("accountViewNumber", rs.getString("T0fnumber"));
                }
                if (!rs.getString("fcurrid").equals(max)) {
                    otherInfo.put("currencyid", rs.getString("fcurrid").toString());
                }
                otherInfo.put("sumall", rs.getBigDecimal("sumall"));
                companyUnit.put("otherInfo", otherInfo);
                listLine.add(companyUnit);
            } else if (paramAge.isAccountList()) {
                listLine.add(rs.getString("hgid"));
            } else {
                listLine.add(null);
            }
            this.addHiddenColumn(paramAge, rs, listLine, itemSize);
            alAcResult.add(listLine);
        }
        return alAcResult;
    }

    private void addHiddenColumn(AccountAgeParam paramAge, ResultSet rs, ArrayList listLine, int itemSize) throws SQLException {
        String max = GlUtils.getMaxChar(paramAge.getCtx());
        if (!paramAge.isAccountList() && paramAge.isBizCode() && paramAge.getHmItems().size() != 0) {
            if (rs.getString("fcurrid").equals(max)) {
                if (!paramAge.isAccountList()) {
                    listLine.add(null);
                }
            } else if (!paramAge.isAccountList()) {
                listLine.add(rs.getString("T0fnumber"));
            }
        }
        for (int i = 0; i < itemSize; ++i) {
            String numkey = "T" + i + "fnumber";
            String namekey = "T" + i + "fname";
            if (rs.getString("fcurrid").equals(max)) {
                if (paramAge.isAccountList()) continue;
                listLine.add(null);
                continue;
            }
            if (paramAge.isAccountList()) continue;
            listLine.add(rs.getString(numkey));
        }
        if (paramAge.isIsOnlyUnion() && rs.getString("fsumcompanyname") != null && !rs.getString("fsumcompanyname").equals("") && paramAge.isAccountList()) {
            listLine.add(rs.getString("hgid"));
        }
        listLine.add(rs.getString("fcurrid"));
    }

    private void calculateLocalAmt4GeneralCy(AccountAgeParam paramAge) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update ").append(paramAge.getTempTableAcSum());
        if (paramAge.isRptQuery()) {
            sql.append(" tmp set (sum0,sumunoverdue) = (select sum0 * isnull(tmpExch.FCONVERTRATEA,1), sumunoverdue*isnull(tmpExch.FCONVERTRATEA,1) ");
            sql.append(" from " + paramAge.getTempTableExchRate() + " tmpExch where tmpExch.fid = tmp.fcurrid ) ");
        } else {
            int i;
            sql.append(" tmp set (");
            int index = 0;
            if (paramAge.isShowUmexpired()) {
                index = paramAge.getUndaylen() + 1;
            }
            for (i = 0; i <= paramAge.getDaylen() + index; ++i) {
                sql.append("sum").append(i);
                sql.append(",");
            }
            sql.append("sumunoverdue");
            sql.append(" )");
            sql.append(" = ");
            sql.append(" ( select ");
            for (i = 0; i <= paramAge.getDaylen() + index; ++i) {
                sql.append("sum").append(i);
                sql.append(" * isnull(tmpExch.FCONVERTRATEA,1)");
                sql.append(",");
            }
            sql.append("sumunoverdue");
            sql.append(" * isnull(tmpExch.FCONVERTRATEA,1)");
            sql.append(" from " + paramAge.getTempTableExchRate() + " tmpExch where tmpExch.fid = tmp.fcurrid  \r\n");
            if (paramAge.isIsOnlyUnion()) {
                sql.append(" and tmpExch.fcompanyid = tmp.fsubCompanyId \r\n");
            }
            sql.append(" )");
        }
        DbUtil.execute((Context)paramAge.getCtx(), (String)sql.toString());
    }

    private int calculateLocalAmt4Deviation(AccountAgeParam paramAge) throws SQLException, BOSException {
        int iAdjust = 0;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int i;
            con = this.getConnection(paramAge.getCtx());
            int index = 1;
            StringBuffer sql = new StringBuffer();
            StringBuffer totalSum = new StringBuffer();
            int generalCyScale = paramAge.getGeneralCurrency().getPrecision();
            String tempTableAcSum = paramAge.getTempTableAcSum();
            if (!UUTN.isTempTable((String)tempTableAcSum) && !UUTN.isGlobalTempTable((String)tempTableAcSum)) {
                logger.error((Object)("illegal temptable name:" + tempTableAcSum));
                int n = iAdjust;
                return n;
            }
            int daylen = paramAge.getDaylen();
            BigDecimal sumunoverdue = GlUtils.zero;
            BigDecimal leftamount = GlUtils.zero;
            BigDecimal sumall = GlUtils.zero;
            BigDecimal sumoverdue = GlUtils.zero;
            BigDecimal sumallAdd = GlUtils.zero;
            BigDecimal delta = GlUtils.zero;
            String strFieldNameMaxAmount = "";
            String sumStr = "";
            String sumStrRound = "";
            int ide = 0;
            if (paramAge.isShowUmexpired()) {
                ide = paramAge.getUndaylen() + 1;
            }
            BigDecimal[] sum = new BigDecimal[1];
            if (paramAge.isRptQuery()) {
                sumStr = "sum0,";
                sumStrRound = "sum0=round(sum0," + generalCyScale + "),";
            } else {
                int i2;
                sum = new BigDecimal[daylen + ide + 1];
                for (i2 = 0; i2 <= daylen + ide; ++i2) {
                    sumStr = sumStr + "sum" + i2 + ",";
                }
                for (i2 = 0; i2 <= daylen + ide; ++i2) {
                    sumStrRound = sumStrRound + "sum" + i2 + "=round(sum" + i2 + "," + generalCyScale + "),";
                }
            }
            sql.setLength(0);
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            sql.append(sumStrRound);
            sql.append("sumunoverdue=round(sumunoverdue," + generalCyScale + "),");
            sql.append("leftamount=round(leftamount," + generalCyScale + "),");
            sql.append("sumall=round(sumall," + generalCyScale + "),");
            sql.append("sumoverdue=round(sumoverdue," + generalCyScale + ")");
            ps = con.prepareStatement(sql.toString());
            ps.execute();
            ps.close();
            boolean isIsOnlyUnionAdj = false;
            if (paramAge.isIsOnlyUnion() && !paramAge.isIsfirstload() && paramAge.getOtherInfo() != null && paramAge.getOtherInfo().get("sumall") != null) {
                isIsOnlyUnionAdj = true;
                leftamount = (BigDecimal)paramAge.getOtherInfo().get("sumall");
            }
            sql.setLength(0);
            sql.append(" select ");
            sql.append(sumStr);
            sql.append(" sumunoverdue,leftamount,sumall,sumoverdue");
            sql.append(" from ");
            sql.append(tempTableAcSum);
            ArrayList<String> paramList = new ArrayList<String>();
            if (!isIsOnlyUnionAdj) {
                sql.append(" where fcurrid = ? ");
                paramList.add(paramAge.getMaxChar());
            }
            ps = con.prepareStatement(sql.toString());
            for (i = 0; i < paramList.size(); ++i) {
                ps.setString(i + 1, (String)paramList.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                if (paramAge.isRptQuery()) {
                    sum[0] = rs.getBigDecimal("sum0");
                } else {
                    for (i = 0; i <= daylen + ide; ++i) {
                        sum[i] = rs.getBigDecimal("sum" + i);
                        sumallAdd = sumallAdd.add(sum[i]);
                    }
                }
                sumunoverdue = rs.getBigDecimal("sumunoverdue");
                leftamount = rs.getBigDecimal("leftamount");
                sumall = rs.getBigDecimal("sumall");
                sumoverdue = rs.getBigDecimal("sumoverdue");
                if (!paramAge.isShowUmexpired()) {
                    sumallAdd = sumallAdd.add(sumunoverdue);
                }
            } else {
                i = iAdjust;
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
                return i;
            }
            rs.close();
            ps.close();
            if (leftamount.compareTo(sumallAdd) != 0) {
                StringBuffer updateFilterRow;
                iAdjust = -1;
                delta = leftamount.subtract(sumallAdd);
                int iMaxCol = GLAcctAgeNewUtils.findMaxInSumArray(sum);
                strFieldNameMaxAmount = sumunoverdue.abs().compareTo(sum[iMaxCol].abs()) >= 0 ? "sumunoverdue" : "sum" + iMaxCol;
                if (!isIsOnlyUnionAdj) {
                    sql.setLength(0);
                    sql.append("Update ").append(tempTableAcSum);
                    sql.append(" set ");
                    sql.append(strFieldNameMaxAmount);
                    sql.append(" = ");
                    sql.append(strFieldNameMaxAmount);
                    sql.append(" + ? ");
                    sql.append(" where fcurrid = ? ");
                    ps = con.prepareStatement(sql.toString());
                    index = 1;
                    ps.setBigDecimal(index++, delta);
                    ps.setString(index++, paramAge.getMaxChar());
                    ps.executeUpdate();
                    ps.close();
                }
                if ((updateFilterRow = this.findMaxRowInTempTable(con, paramAge, strFieldNameMaxAmount)).length() > 0) {
                    sql.setLength(0);
                    sql.append("Update ").append(tempTableAcSum);
                    sql.append(" set ");
                    sql.append(strFieldNameMaxAmount);
                    sql.append(" = ");
                    sql.append(strFieldNameMaxAmount);
                    sql.append(" + ? ");
                    sql.append(" where fcurrid <> ? ");
                    sql.append(updateFilterRow);
                    ps = con.prepareStatement(sql.toString());
                    index = 1;
                    ps.setBigDecimal(index++, delta);
                    ps.setString(index++, paramAge.getMaxChar());
                    ps.executeUpdate();
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        }
        catch (SQLDataException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, ps, (Connection)con);
        }
        return iAdjust;
    }

    private StringBuffer findMaxRowInTempTable(Connection con, AccountAgeParam paramAge, String filedName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean index = true;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlWhere = new StringBuffer();
        String tempTableAcSum = paramAge.getTempTableAcSum();
        String max = GlUtils.getMaxChar(paramAge.getCtx());
        sql.append(" select * from ").append(tempTableAcSum).append(" tmp   \r\n");
        sql.append(" where abs(tmp.").append(filedName).append(") =                               \r\n");
        sql.append(" (                                              \r\n");
        sql.append("  select max(abs(tmp2.").append(filedName).append("))                    \r\n");
        sql.append("  from ").append(tempTableAcSum).append(" tmp2          \r\n");
        sql.append("  where tmp2.fcurrid <> '").append(max).append("' \r\n");
        sql.append(" )                                              \r\n");
        sql.append(" and tmp.fcurrid <> '").append(max).append("' \r\n");
        ps = con.prepareStatement(sql.toString());
        rs = ps.executeQuery();
        if (rs.next()) {
            String keyField = "";
            sqlWhere.append(" ");
            for (int i = 0; i < paramAge.getLstHgOutSide().size(); ++i) {
                keyField = (String)paramAge.getLstHgOutSide().get(i);
                if (keyField.indexOf("number") >= 0 || keyField.indexOf("name") >= 0 || paramAge.isGeneralCy() && keyField.indexOf("hgid") >= 0 || this.lstHgOutSideRemoveFields != null && this.lstHgOutSideRemoveFields.contains(keyField.toLowerCase())) continue;
                sqlWhere.append(" AND ");
                sqlWhere.append(keyField).append(" = ");
                sqlWhere.append("'").append(rs.getString(keyField)).append("'  \r\n");
            }
        }
        this.lstHgOutSideRemoveFields = null;
        rs.close();
        ps.close();
        return sqlWhere;
    }

    private void insertTotalSumLines4GeneralCurency(AccountAgeParam paramAge) throws SQLException, BOSException {
        String selecthgoutsiderealNoCy;
        StringBuffer sql = new StringBuffer();
        StringBuffer totalSum = new StringBuffer();
        int generalCyScale = paramAge.getGeneralCurrency().getPrecision();
        String tempTableAcSum = paramAge.getTempTableAcSum();
        int daylen = paramAge.getDaylen();
        if (paramAge.isAccountList()) {
            int i;
            String sumStr = "";
            String sumStrRound = "";
            int index = 0;
            if (paramAge.isShowUmexpired()) {
                index = paramAge.getUndaylen() + 1;
            }
            for (i = 0; i <= daylen + index; ++i) {
                sumStr = sumStr + "sum" + i + ",";
            }
            if (paramAge.isRptQuery()) {
                sumStrRound = "sum0 = round(sum0," + generalCyScale + "),";
            } else {
                for (i = 0; i <= daylen + index; ++i) {
                    sumStrRound = sumStrRound + "sum" + i + "=round(sum" + i + "," + generalCyScale + "),";
                }
            }
            sql.setLength(0);
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            sql.append(sumStrRound);
            sql.append("sumunoverdue=round(sumunoverdue," + generalCyScale + "),");
            sql.append("leftamount=round(leftamount," + generalCyScale + "),");
            sql.append("sumall=round(sumall," + generalCyScale + "),");
            sql.append("sumoverdue=round(sumoverdue," + generalCyScale + ")");
            DbUtil.execute((Context)paramAge.getCtx(), (String)sql.toString());
        }
        totalSum.append("select top 1 1 from ").append(paramAge.getTempTableAcSum());
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)paramAge.getCtx(), (String)totalSum.toString());
        if (!rs.next()) {
            return;
        }
        String selecthgoutsiderealGenCy = selecthgoutsiderealNoCy = paramAge.isIncludeVerifyVch() ? paramAge.getSqlSelecthgoutsideReal().toString().trim() : paramAge.getSqlSelecthgoutside().toString().trim();
        String strCy = "fcurrid,fcurrname,";
        String strGeneralCY = "'" + paramAge.getCurrency().getId().toString() + "' fcurrid,N'" + paramAge.getCurrency().getName() + "' fcurrname";
        int startPosi = selecthgoutsiderealNoCy.indexOf(strCy);
        if (startPosi < 0) {
            strCy = "fcurrid,fcurrname";
            startPosi = selecthgoutsiderealNoCy.indexOf(strCy);
        }
        if (startPosi >= 0) {
            selecthgoutsiderealNoCy = selecthgoutsiderealNoCy.replaceAll(strCy, "");
        }
        strCy = "fcurrid,fcurrname";
        selecthgoutsiderealGenCy = selecthgoutsiderealGenCy.replaceAll(strCy, strGeneralCY);
        if ((selecthgoutsiderealNoCy = selecthgoutsiderealNoCy.trim()).length() > 0 && selecthgoutsiderealNoCy.endsWith(",")) {
            selecthgoutsiderealNoCy = selecthgoutsiderealNoCy.substring(0, selecthgoutsiderealNoCy.length() - 1);
        }
        if ((selecthgoutsiderealGenCy = selecthgoutsiderealGenCy.trim()).length() > 0 && selecthgoutsiderealGenCy.endsWith(",")) {
            selecthgoutsiderealGenCy = selecthgoutsiderealGenCy.substring(0, selecthgoutsiderealGenCy.length() - 1);
        }
        totalSum.setLength(0);
        totalSum.append(this.getSql_InsertAcTemp(paramAge, false, true));
        totalSum.append("\r\n select  ");
        if (selecthgoutsiderealGenCy.length() > 0) {
            totalSum.append(selecthgoutsiderealGenCy).append(",");
        }
        totalSum.append("\r\n sum(sumunoverdue) sumunoverdue");
        if (!paramAge.isRptQuery()) {
            StringBuffer _tempSum = new StringBuffer("sum(sum1) sum1");
            int ide = 0;
            if (paramAge.isShowUmexpired()) {
                ide = paramAge.getUndaylen() + 1;
            }
            for (int i = 1; i < paramAge.getDaylen() + ide; ++i) {
                _tempSum.append(",sum(sum" + (i + 1) + ") as sum" + (i + 1));
            }
            totalSum.append("\r\n ,sum(sum0) sum0,").append(_tempSum);
        } else {
            totalSum.append(",sum(sum0) sum0 ");
        }
        totalSum.append("\r\n from ");
        totalSum.append(paramAge.getTempTableAcSum());
        if (selecthgoutsiderealNoCy.toString().trim().length() > 0) {
            totalSum.append(" group by ").append(selecthgoutsiderealNoCy);
        }
        totalSum.append("\r\n");
        DbUtil.execute((Context)paramAge.getCtx(), (String)totalSum.toString());
        totalSum.setLength(0);
        totalSum.append("delete from ").append(paramAge.getTempTableAcSum());
        totalSum.append(" where fcurrid <> ? ");
        DbUtil.execute((Context)paramAge.getCtx(), (String)totalSum.toString(), (Object[])new String[]{paramAge.getCurrency().getId().toString()});
    }

    private void insertTotalSumLines(AccountAgeParam paramAge) throws SQLException, BOSException {
        int index;
        StringBuffer totalSum = new StringBuffer();
        String sql = " select top 1 1 from " + paramAge.getTempTableAcSum();
        IRowSet rs = DbUtil.executeQuery((Context)paramAge.getCtx(), (String)sql);
        if (!rs.next()) {
            return;
        }
        String sqlSelect = this.getSql_InsertAcTemp(paramAge, true, paramAge.isIncludeVerifyVch()).toString();
        if (sqlSelect.indexOf(",hgid") > 0) {
            sqlSelect = sqlSelect.replace(",hgid", "");
        }
        if (sqlSelect.indexOf(",accountid") > 0) {
            sqlSelect = sqlSelect.replace(",accountid", "");
        }
        if (paramAge.isIsOnlyUnion() && sqlSelect.indexOf(",fsubcompanyid") > 0) {
            sqlSelect = sqlSelect.replace(",fsubcompanyid", "");
        }
        totalSum.append(sqlSelect);
        if (paramAge.isIsOnlyUnion()) {
            // empty if block
        }
        totalSum.append("\r\n select  ");
        for (int i = 0; i < paramAge.getAlAstFields().size(); ++i) {
            totalSum.append(" '").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("T" + i + paramAge.getAlAstFields().get(i).toString());
            totalSum.append(",");
            totalSum.append(" N'").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("T" + i + "fnumber ");
            totalSum.append(",");
            totalSum.append(" N'").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("T" + i + "fname ");
            totalSum.append(",");
            if (paramAge.isAccountList()) break;
        }
        if (paramAge.isBizCode() && !paramAge.isAccountBCNoType()) {
            totalSum.append(" '").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("Taccountid");
            totalSum.append(",");
            if (paramAge.isAccountList()) {
                totalSum.append("T0fnumber ");
            } else {
                totalSum.append(" N'").append(paramAge.getMaxChar()).append("' ");
            }
            totalSum.append(",");
            totalSum.append(" N'").append(paramAge.getMaxChar()).append("' ");
            totalSum.append("T0fname ");
            totalSum.append(",");
        }
        totalSum.append(" '").append(paramAge.getMaxChar()).append("' fcurrid, ");
        if (paramAge.isIsOnlyUnion() && paramAge.isAllCurr()) {
            totalSum.append("fcurrname fcurrname, ");
        } else {
            totalSum.append("N'' fcurrname, ");
        }
        if (paramAge.isIsOnlyUnion()) {
            totalSum.append(" 'total' fsumcompanyid,N'' fsumcompanyname,to_integer(null) fsumcompanylevel,to_integer(null) fsumcompanyisleaf,");
        }
        StringBuffer _tempSum = null;
        if (paramAge.isAllCurr() || !paramAge.isBizCode() && paramAge.getAlAstFields().size() > 0 || paramAge.isBizCode() && paramAge.isAccountBC() && !paramAge.isAccountBCNoType()) {
            int j;
            _tempSum = new StringBuffer();
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _tempSum.append(",sum(sum" + (j + 1) + ") as sum" + (j + 1));
                }
            }
            for (int i = index; i < paramAge.getDaylen(); ++i) {
                index = i + j + 1;
                _tempSum.append(",sum(sum" + index + ") as sum" + index);
            }
            totalSum.append("\r\n sum(leftamount) leftamount,sum(sumall) sumall").append("\r\n ,sum(sumoverdue) sumoverdue,sum(sumunoverdue) sumunoverdue").append("\r\n ,sum(sum0) sum0");
        } else if (paramAge.isIsOnlyUnion() && paramAge.isBizCode() && paramAge.isAccountList()) {
            int j;
            _tempSum = new StringBuffer();
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _tempSum.append(",sum(sum" + (j + 1) + ") as sum" + (j + 1));
                }
            }
            for (int i = index; i < paramAge.getDaylen(); ++i) {
                index = i + j + 1;
                _tempSum.append(",sum(sum" + index + ") as sum" + index);
            }
            totalSum.append("\r\n sum(leftamount) leftamount,sum(sumall) sumall").append("\r\n ,sum(sumoverdue) sumoverdue,sum(sumunoverdue) sumunoverdue").append("\r\n ,sum(sum0) sum0");
        } else {
            int j;
            _tempSum = new StringBuffer();
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _tempSum.append(",sum" + (j + 1));
                }
            }
            for (int i = index; i < paramAge.getDaylen(); ++i) {
                index = i + j + 1;
                _tempSum.append(",sum" + index);
            }
            totalSum.append("\r\n leftamount,sumall").append("\r\n ,sumoverdue,sumunoverdue").append("\r\n ,sum0");
        }
        totalSum.append(_tempSum);
        totalSum.append("\r\n from ");
        totalSum.append(paramAge.getTempTableAcSum());
        if (paramAge.isIsOnlyUnion()) {
            int rootCompanylevel = 1;
            sql = " select min(fsumcompanylevel) companyLevel from " + paramAge.getTempTableAcSum();
            rs = DbUtil.executeQuery((Context)paramAge.getCtx(), (String)sql);
            if (!rs.next()) {
                return;
            }
            rootCompanylevel = rs.getInt("companyLevel");
            totalSum.append("\r\n where fsumcompanylevel=").append(rootCompanylevel);
        }
        totalSum.append(" \r\n");
        if (paramAge.isAllCurr()) {
            totalSum.append("  group by fcurrid,fcurrname");
        }
        if (paramAge.isIsOnlyUnion() && paramAge.isBizCode() && !paramAge.isAccountBCNoType() && paramAge.isAccountList()) {
            if (paramAge.isAllCurr()) {
                totalSum.append(",T0fnumber");
            } else {
                totalSum.append("  group by T0fnumber");
            }
        }
        DbUtil.execute((Context)paramAge.getCtx(), (String)totalSum.toString());
    }

    private void calculateSumallSumOverdue(String tempTableAcSum, int daylen, boolean isSumLeft, AccountAgeParam paramAge) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlSum = new StringBuffer();
        StringBuffer unSqlSum = new StringBuffer();
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            if (paramAge.isRptQuery()) {
                unSqlSum.append("sum0");
                sqlSum.append("sum0");
            } else {
                int i;
                index = paramAge.getUndaylen() + 1;
                for (i = 0; i < index; ++i) {
                    unSqlSum.append("sum").append(i);
                    if (i >= paramAge.getUndaylen()) continue;
                    unSqlSum.append("+");
                }
                for (i = index; i <= daylen + index; ++i) {
                    sqlSum.append("sum").append(i);
                    if (i >= daylen + index) continue;
                    sqlSum.append("+");
                }
            }
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            if (paramAge.isRptQuery()) {
                sql.append(" sumunoverdue =").append("sumunoverdue");
            } else {
                sql.append(" sumunoverdue =").append("(").append(unSqlSum).append(")");
            }
            if (isSumLeft) {
                sql.append(", leftamount=").append("(").append(sqlSum).append("+").append(unSqlSum).append(")");
                sql.append(", sumall=").append("(").append(sqlSum).append("+").append(unSqlSum).append(")");
            }
            sql.append(",sumoverdue=").append("(").append(sqlSum).append(")");
        } else {
            if (paramAge.isRptQuery()) {
                sqlSum.append("sum0");
            } else {
                sqlSum.append("(");
                for (int i = 0; i <= daylen; ++i) {
                    sqlSum.append("sum").append(i);
                    if (i >= daylen) continue;
                    sqlSum.append("+");
                }
                sqlSum.append(")");
            }
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            if (isSumLeft) {
                sql.append(" leftamount=").append(sqlSum).append("+sumunoverdue,");
                sql.append(" sumall=").append(sqlSum).append("+sumunoverdue,");
            }
            sql.append(" sumoverdue=").append(sqlSum);
        }
        DbUtil.execute((Context)paramAge.getCtx(), (String)sql.toString());
    }

    private void deleteBalZeroAcFromTempTable(AccountAgeParam paramAge) throws SQLException, BOSException {
        String tempTableAcSum = paramAge.getTempTableAcSum();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from ").append(tempTableAcSum);
        sql.append(" where sumUnOverDue = 0 ");
        if (paramAge.isRptQuery()) {
            sql.append(" and sum0 = 0 ");
        } else {
            int j;
            int index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    sql.append(" and ").append("sum" + j).append(" = 0");
                }
            }
            for (int i = 0; i <= paramAge.getDaylen(); ++i) {
                index = i + j;
                sql.append(" and ").append("sum" + index).append(" = 0");
            }
        }
        DbUtil.execute((Context)paramAge.getCtx(), (String)sql.toString());
    }

    private StringBuffer getSql_ByAcctBal_LastResult_FromTempAcSum(AccountAgeParam paramAge) {
        int j;
        int index;
        StringBuffer sql = new StringBuffer();
        if (paramAge.isRptQuery()) {
            sql.append(" select sumunoverdue, sumoverdue, sum0 from ").append(paramAge.getTempTableAcSum());
            return sql;
        }
        if (paramAge.isIncludeVerifyVch() || paramAge.isSumAccount()) {
            if (!paramAge.isAccountList()) {
                sql.append("select ").append(paramAge.getSqlSelecthgoutsideReal());
            } else {
                sql.append("select ").append(paramAge.getSqlSelecthgoutside());
            }
        } else {
            sql.append("select ").append(paramAge.getSqlSelecthgoutside());
        }
        if (paramAge.isIsOnlyUnion()) {
            sql = new StringBuffer(sql.toString().replace(",fsubcompanyid", ""));
        }
        String group = "";
        if (!paramAge.isIsOnlyUnion() && !paramAge.isBizCode() && !paramAge.isAccountList() && paramAge.getAccountid() == null && paramAge.isSumAccount()) {
            sql.append(", sum(leftamount) as sumall");
            sql.append(",sum(sumunoverdue) as sumunoverdue");
            sql.append(",sum(sumoverdue) as sumoverdue");
            index = 0;
            String sumStr = "";
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    sumStr = "sum" + j;
                    sql.append(",sum(").append(sumStr).append(") as ").append(sumStr);
                }
            }
            for (int i = 0; i <= paramAge.getDaylen(); ++i) {
                index = i + j;
                sumStr = "sum" + index;
                sql.append(",sum(").append(sumStr).append(") as ").append(sumStr);
            }
            group = paramAge.getSqlGroupbyAge().toString();
            group = group.replace("accountid,", "");
            group = group.replace(",hgid", "");
        } else {
            sql.append("\r\n ,leftamount as sumall");
            sql.append(",sumunoverdue");
            sql.append(",sumoverdue");
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    sql.append(",sum" + j);
                }
            }
            for (int i = 0; i <= paramAge.getDaylen(); ++i) {
                index = i + j;
                sql.append(",sum" + index);
            }
        }
        sql.append("\r\n from ").append(paramAge.getTempTableAcSum());
        sql.append(group);
        StringBuffer orderby = new StringBuffer();
        for (int i = 0; i < paramAge.getAlAstTables().size(); ++i) {
            String numkey = "T" + i + "fnumber";
            String namekey = "T" + i + "fname";
            if (paramAge.isAccountList() && i != 0) continue;
            orderby.append(numkey).append(",");
        }
        if (!paramAge.isIsOnlyUnion()) {
            if (paramAge.isBizCode() && paramAge.isAccountList() && !paramAge.isAccountBCNoType()) {
                orderby.append("\r\n order by T0fnumber,fcurrid,fcurrname");
            } else if (orderby.length() > 0) {
                orderby = new StringBuffer("\r\n order by fcurrid,fcurrname,").append(orderby.substring(0, orderby.length() - 1));
            } else {
                orderby.append("\r\n order by fcurrid,fcurrname");
            }
        } else {
            StringBuffer orderby1 = new StringBuffer("\r\n order by ");
            if (paramAge.isAllCurr()) {
                orderby1.append(" fcurrname,");
            }
            if (paramAge.isAccountList() && !paramAge.isBizCode()) {
                orderby1.append(" hgid, ");
            }
            orderby1.append(orderby);
            if (paramAge.isBizCode() && paramAge.isAccountList()) {
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    orderby1.append(" T0Fnumber,T0Fname,fsumcompanylevel,fsumcompanyname");
                } else if (paramAge.getDisplayMode() == 3 && paramAge.isCompanyExpandOnUnion()) {
                    orderby1.append(" T0Fnumber,T0Fname,fsumcompanylevel,fsumcompanyname");
                } else {
                    orderby1.append(" Taccountid,fsumcompanylevel,fsumcompanyname");
                }
            } else {
                orderby1.append(" fsumcompanylevel,fsumcompanyname");
            }
            orderby = orderby1;
        }
        if (paramAge.isIsOnlyUnion()) {
            HashMap hmItems = paramAge.getHmItems();
            if (paramAge.isBizCode() && !paramAge.isAccountList() && hmItems.size() != 0) {
                sql.append(" order by fcurrid,Taccountid,fsumcompanylevel,fsumcompanyname");
            } else if (hmItems.size() == 0) {
                sql.append(" order by fcurrid,fsumcompanylevel,fsumcompanyname");
            } else {
                sql.append(orderby);
            }
        } else {
            sql.append(orderby);
        }
        return sql;
    }

    private void insertIntoTempTable_ByBal_SumVeri(AccountAgeParam paramAge, Connection con, StringBuffer sqlSumVeri) throws SQLException {
        int j;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(paramAge.getTempTableSumVeri()).append("\r\n (").append(paramAge.getSqlSelecthgoutside()).append(",SumVeri \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sql.append(",sum" + j);
            }
        } else {
            sql.append(",SumVeriUnOverDue \r\n");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sql.append(",sum" + index);
        }
        sql.append(") ");
        sql.append(sqlSumVeri);
        if (sql.indexOf("'' as Taccountid,") > 0) {
            sql = sql.replace(sql.indexOf("'' as Taccountid,"), sql.indexOf("'' as Taccountid,") + 17, "account.Fid as Taccountid,");
        }
        ps = con.prepareStatement(sql.toString());
        index = 1;
        String companyID = paramAge.getCurCompanyid();
        if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
            paramAge.setCurCompanyid(null);
        }
        index = GLAcctAgeNewUtils.setupParams_ByBal_InsertSumVeri(paramAge, ps, index, false);
        paramAge.setCurCompanyid(companyID);
        ps.execute();
        ps.close();
    }

    private String createTempTable4FuturePeriodAsstBal(Context ctx, Connection con, boolean isDbTypeOracleDB2, boolean isIsOnlyUnion, String tableName, List listParam, String companyID, String currPeriodID, String endPeriodID, StringBuffer endAdjustPeriodID, int balType, int isEndPeriodInFuture, String yearNumberFilter, StringBuffer from, StringBuffer innerJoinAsst, StringBuffer whereCommon, boolean isDM) throws EASBizException, BOSException {
        PreparedStatement ps = null;
        Object psUpdate = null;
        Object rs = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlUpdate = new StringBuffer();
        int index = 1;
        boolean indexUpdate = true;
        boolean iCountPsUpdate = false;
        String keyTable = "TMP_GL_AGEASSTBAL";
        try {
            if (StringUtils.isEmpty((String)tableName)) {
                sql.setLength(0);
                sql.append(" create table ").append(keyTable).append("                   \r\n");
                sql.append(" (                                                           \r\n");
                sql.append("   FORGUNITID         VARCHAR(44) not null,                 \r\n");
                if (!isDM) {
                    sql.append("   FBALTYPE           int not null,                   \r\n");
                }
                sql.append("   FPERIODID          VARCHAR(44) not null,                 \r\n");
                sql.append("   FACCOUNTID         VARCHAR(44) not null,                 \r\n");
                sql.append("   FASSISTGRPID       VARCHAR(44) not null,                 \r\n");
                sql.append("   FCURRENCYID        VARCHAR(44) not null,                 \r\n");
                sql.append("                                                             \r\n");
                sql.append("   FBEGINBALANCEFOR   decimal(19,4) default 0 not null,       \r\n");
                sql.append("   FDEBITFOR          decimal(19,4) default 0 not null,       \r\n");
                sql.append("   FCREDITFOR         decimal(19,4) default 0 not null,       \r\n");
                sql.append("   FENDBALANCEFOR     decimal(19,4) default 0 not null        \r\n");
                sql.append(" )                                                           \r\n");
                tableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
                try {
                    sql.setLength(0);
                    sql.append(" create index ").append(tableName).append("i on ").append(tableName).append("              \r\n");
                    if (isDM) {
                        sql.append("   (FORGUNITID, FASSISTGRPID, FACCOUNTID, FCURRENCYID,FPERIODID);  \r\n");
                    } else {
                        sql.append("   (FORGUNITID, FASSISTGRPID, FACCOUNTID, FCURRENCYID, FBALTYPE, FPERIODID);  \r\n");
                    }
                    ps = con.prepareStatement(sql.toString());
                    ps.execute();
                    ps.close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (1 != isEndPeriodInFuture) {
                sql.setLength(0);
                sql.append(" Insert into ").append(tableName).append("                                    \r\n");
                sql.append(" (                                                                            \r\n");
                if (!isDM) {
                    sql.append(" FBALTYPE,                                                                    \r\n");
                }
                sql.append(" FPERIODID,                                                                   \r\n");
                sql.append(" FORGUNITID,                                                                  \r\n");
                sql.append(" FACCOUNTID,                                                                  \r\n");
                sql.append(" FAssistGrpID,                                                                \r\n");
                sql.append(" FCURRENCYID,                                                                 \r\n");
                sql.append("                                                                              \r\n");
                sql.append(" fbeginbalancefor,                                                            \r\n");
                sql.append(" fendbalancefor                                                               \r\n");
                sql.append(" )                                                                            \r\n");
                sql.append("                                                                              \r\n");
                sql.append(" SELECT                                                                       \r\n");
                if (!isDM) {
                    sql.append("   cussent.FBALTYPE,                                                             \r\n");
                }
                sql.append("   ? as FPERIODID, --\u622a\u6b62\u671f\u95f4                                                 \r\n");
                sql.append("   cussent.FORGUNITID,                                                        \r\n");
                sql.append("   cussent.FACCOUNTID,                                                        \r\n");
                sql.append("   cussent.FAssistGrpID,                                                      \r\n");
                sql.append("   cussent.FCURRENCYID,                                                       \r\n");
                sql.append("                                                                              \r\n");
                sql.append("   cussent.fendbalancefor,                                                    \r\n");
                sql.append("   cussent.fendbalancefor                                                     \r\n");
                sql.append("                                                                              \r\n");
                sql.append(from).append(innerJoinAsst).append(whereCommon);
                sql.append("      --\u7279\u6b8a\u6761\u4ef6                                                              \r\n");
                if (isDM) {
                    sql.append("      and pd.fperiodid = ?  --\u622a\u6b62\u671f\u95f4\uff0c\u6216\u8005Year+Number                  \r\n");
                } else {
                    sql.append("      and cussent.FBalType=?                                                  \r\n");
                    if (endAdjustPeriodID.length() > 0) {
                        sql.append("      and cussent.fperiodid in ").append(endAdjustPeriodID.toString()).append(" \r\n");
                    } else {
                        sql.append("      and cussent.fperiodid = ?  --\u622a\u6b62\u671f\u95f4\uff0c\u6216\u8005Year+Number                  \r\n");
                    }
                }
                sql.append("      and cussent.FEndBalancefor<>0.0                                         \r\n");
                sql.append(" ;                                                                            \r\n");
                ps = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)endPeriodID);
                for (String param : listParam) {
                    DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)param);
                }
                if (isIsOnlyUnion) {
                    DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)companyID);
                }
                if (!isDM) {
                    ps.setInt(index++, balType);
                }
                if (endAdjustPeriodID.length() == 0) {
                    DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)endPeriodID);
                }
                ps.execute();
                ps.close();
            } else {
                sql.setLength(0);
                sql.append(" Insert into ").append(tableName).append("                                    \r\n");
                sql.append(" (                                                                            \r\n");
                if (!isDM) {
                    sql.append(" FBALTYPE,                                                                    \r\n");
                }
                sql.append(" FPERIODID,                                                                   \r\n");
                sql.append(" FORGUNITID,                                                                  \r\n");
                sql.append(" FACCOUNTID,                                                                  \r\n");
                sql.append(" FAssistGrpID,                                                                \r\n");
                sql.append(" FCURRENCYID,                                                                 \r\n");
                sql.append("                                                                              \r\n");
                sql.append(" fbeginbalancefor,                                                            \r\n");
                sql.append(" fendbalancefor                                                               \r\n");
                sql.append(" )                                                                            \r\n");
                sql.append("                                                                              \r\n");
                sql.append(" SELECT                                                                       \r\n");
                if (!isDM) {
                    sql.append("   cussent.FBALTYPE,                                                          \r\n");
                }
                sql.append("   ? as FPERIODID, --\u622a\u6b62\u671f\u95f4                                                 \r\n");
                sql.append("   cussent.FORGUNITID,                                                        \r\n");
                sql.append("   cussent.FACCOUNTID,                                                        \r\n");
                sql.append("   cussent.FAssistGrpID,                                                      \r\n");
                sql.append("   cussent.FCURRENCYID,                                                       \r\n");
                sql.append("                                                                              \r\n");
                sql.append("   cussent.fendbalancefor,                                                    \r\n");
                sql.append("   cussent.fendbalancefor                                                     \r\n");
                sql.append("                                                                              \r\n");
                sql.append(from).append(innerJoinAsst).append(whereCommon);
                if (isDM) {
                    sql.append("      and pd.fid = ?  --\u5f53\u524d\u671f\u95f4\uff0c\u6216\u8005Year+Number                  \r\n");
                } else {
                    sql.append("      --\u7279\u6b8a\u6761\u4ef6                                                              \r\n");
                    sql.append("      and cussent.FBalType=?                                                  \r\n");
                    sql.append("      and cussent.fperiodid = ?  --\u5f53\u524d\u671f\u95f4\uff0c\u6216\u8005Year+Number                  \r\n");
                }
                sql.append(" ;                                                                            \r\n");
                ps = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)endPeriodID);
                for (String param : listParam) {
                    ps.setString(index++, param);
                }
                if (isIsOnlyUnion) {
                    DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)companyID);
                }
                if (!isDM) {
                    ps.setInt(index++, balType);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)currPeriodID);
                ps.execute();
                ps.close();
                sql.setLength(0);
                sql.append(" Insert into ").append(tableName).append("                                    \r\n");
                sql.append(" (                                                                            \r\n");
                if (!isDM) {
                    sql.append(" FBALTYPE,                                                                    \r\n");
                }
                sql.append(" FPERIODID,                                                                   \r\n");
                sql.append(" FORGUNITID,                                                                  \r\n");
                sql.append(" FACCOUNTID,                                                                  \r\n");
                sql.append(" FAssistGrpID,                                                                \r\n");
                sql.append(" FCURRENCYID ,                                                                 \r\n");
                sql.append(" fbeginbalancefor,                                                            \r\n");
                sql.append(" fendbalancefor                                                               \r\n");
                sql.append(" )                                                                            \r\n");
                sql.append("                                                                              \r\n");
                sql.append("select  distinct                                                                    \r\n");
                if (!isDM) {
                    sql.append("    cussent.FBALTYPE,                                          \r\n");
                }
                sql.append("        ? as FPERIODID, --\u622a\u6b62\u671f\u95f4                                            \r\n");
                sql.append("        cussent.FORGUNITID,                                                   \r\n");
                sql.append("        cussent.FACCOUNTID,                                                   \r\n");
                sql.append("        cussent.FAssistGrpID,                                                 \r\n");
                sql.append("        cussent.FCURRENCYID,                                                   \r\n");
                sql.append("        cussent.fendbalancefor,                                                    \r\n");
                sql.append("        cussent.fendbalancefor                                                     \r\n");
                sql.append(from).append(innerJoinAsst);
                sql.append("    left outer join ").append(tableName).append(" tmp                         \r\n");
                sql.append("      on (                              \r\n");
                if (!isDM) {
                    sql.append("  tmp.fbaltype = cussent.fbaltype AND");
                }
                sql.append("      tmp.forgunitid = cussent.forgunitid AND                                 \r\n");
                sql.append("      tmp.faccountid = cussent.faccountid AND                                 \r\n");
                sql.append("      tmp.FAssistGrpID = cussent.FAssistGrpID AND                             \r\n");
                sql.append("      tmp.fcurrencyid = cussent.fcurrencyid)                                  \r\n");
                sql.append("                                                                              \r\n");
                sql.append(whereCommon);
                sql.append("      --\u7279\u6b8a\u7684\u6761\u4ef6                                                            \r\n");
                sql.append("      ----\u671f\u95f4\u8303\u56f4\uff1a\u5f53\u671f\u671f\u95f4\u7684\u540e\u4e00\u671f~~\u622a\u6b62\u671f\u95f4                                \r\n");
                if (!isDM) {
                    sql.append("      and cussent.FBalType=?                                                  \r\n");
                }
                sql.append(yearNumberFilter).append("                                                     \r\n");
                sql.append("      --\u66f4\u7279\u6b8a\u7684\u6761\u4ef6                                                          \r\n");
                sql.append(" ;                                                                            \r\n");
                ps = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)endPeriodID);
                if (isIsOnlyUnion) {
                    DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)companyID);
                }
                for (String param : listParam) {
                    ps.setString(index++, param);
                }
                if (!isDM) {
                    ps.setInt(index++, balType);
                }
                ps.execute();
                ps.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new SQLAccessException(e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String createTempTable4FuturePeriodAsstBal_New(Context ctx, Connection con, List listParam, int balType, StringBuffer from, StringBuffer innerJoinAsst, StringBuffer whereCommon) throws EASBizException, BOSException {
        PreparedStatement ps = null;
        Object psUpdate = null;
        Object rs = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlUpdate = new StringBuffer();
        int index = 1;
        boolean indexUpdate = true;
        boolean iCountPsUpdate = false;
        String keyTable = "TMP_GL_AGEASSTBAL";
        String tableName = null;
        try {
            sql.setLength(0);
            sql.append(" create table ").append(keyTable).append("                   \r\n");
            sql.append(" (                                                           \r\n");
            sql.append("   FBALTYPE           int not null,                   \r\n");
            sql.append("   FORGUNITID         VARCHAR(44) not null,                 \r\n");
            sql.append("   FPERIODID          VARCHAR(44) not null,                 \r\n");
            sql.append("   FACCOUNTID         VARCHAR(44) not null,                 \r\n");
            sql.append("   FASSISTGRPID       VARCHAR(44) not null,                 \r\n");
            sql.append("   FCURRENCYID        VARCHAR(44) not null,                 \r\n");
            sql.append("                                                             \r\n");
            sql.append("   FBEGINBALANCEFOR   decimal(19,4) default 0 not null,       \r\n");
            sql.append("   FDEBITFOR          decimal(19,4) default 0 not null,       \r\n");
            sql.append("   FCREDITFOR         decimal(19,4) default 0 not null,       \r\n");
            sql.append("   FENDBALANCEFOR     decimal(19,4) default 0 not null        \r\n");
            sql.append(" )                                                           \r\n");
            tableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            try {
                sql.setLength(0);
                sql.append(" create index ").append(tableName).append("i on ").append(tableName).append("              \r\n");
                sql.append("   (FORGUNITID, FASSISTGRPID, FACCOUNTID, FCURRENCYID, FBALTYPE, FPERIODID);  \r\n");
                ps = con.prepareStatement(sql.toString());
                ps.execute();
                ps.close();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            sql.setLength(0);
            sql.append(" Insert into ").append(tableName).append("                                    \r\n");
            sql.append(" (                                                                            \r\n");
            sql.append(" FBALTYPE,                                                                    \r\n");
            sql.append(" FORGUNITID,                                                                  \r\n");
            sql.append(" FPERIODID,                                                                   \r\n");
            sql.append(" FACCOUNTID,                                                                  \r\n");
            sql.append(" FAssistGrpID,                                                                \r\n");
            sql.append(" FCURRENCYID,                                                                 \r\n");
            sql.append("                                                                              \r\n");
            sql.append(" fbeginbalancefor,                                                            \r\n");
            sql.append(" fendbalancefor                                                               \r\n");
            sql.append(" )                                                                            \r\n");
            sql.append("                                                                              \r\n");
            sql.append(" SELECT cussent.FBALTYPE,                                                     \r\n");
            sql.append("   cussent.FORGUNITID,                                                        \r\n");
            sql.append("   ? as FPERIODID, --\u622a\u6b62\u671f\u95f4                                                 \r\n");
            sql.append("   cussent.FACCOUNTID,                                                        \r\n");
            sql.append("   cussent.FAssistGrpID,                                                      \r\n");
            sql.append("   cussent.FCURRENCYID,                                                       \r\n");
            sql.append("                                                                              \r\n");
            sql.append("   cussent.fendbalancefor,                                                    \r\n");
            sql.append("   cussent.fendbalancefor                                                     \r\n");
            sql.append("                                                                              \r\n");
            sql.append(from).append(innerJoinAsst).append(whereCommon);
            sql.append("      --\u7279\u6b8a\u6761\u4ef6                                                              \r\n");
            sql.append("      and cussent.FBalType=?                                                  \r\n");
            ps = con.prepareStatement(sql.toString());
            index = 1;
            logger.error((Object)("-zzz:" + listParam.toString() + " balType:" + balType));
            for (String param : listParam) {
                ps.setString(index++, param);
            }
            ps.setInt(index++, balType);
            ps.execute();
            ps.close();
            sql.setLength(0);
            sql.append(" Insert into ").append(tableName).append("                                    \r\n");
            sql.append(" (                                                                            \r\n");
            sql.append(" FBALTYPE,                                                                    \r\n");
            sql.append(" FORGUNITID,                                                                  \r\n");
            sql.append(" FPERIODID,                                                                   \r\n");
            sql.append(" FACCOUNTID,                                                                  \r\n");
            sql.append(" FAssistGrpID,                                                                \r\n");
            sql.append(" FCURRENCYID ,                                                                 \r\n");
            sql.append(" fbeginbalancefor,                                                            \r\n");
            sql.append(" fendbalancefor                                                               \r\n");
            sql.append(" )                                                                            \r\n");
            sql.append("                                                                              \r\n");
            sql.append(" SELECT distinct cussent.FBALTYPE,                                          \r\n");
            sql.append("        cussent.FORGUNITID,                                                   \r\n");
            sql.append("        ? as FPERIODID, --\u622a\u6b62\u671f\u95f4                                            \r\n");
            sql.append("        cussent.FACCOUNTID,                                                   \r\n");
            sql.append("        cussent.FAssistGrpID,                                                 \r\n");
            sql.append("        cussent.FCURRENCYID,                                                   \r\n");
            sql.append("        cussent.fendbalancefor,                                                    \r\n");
            sql.append("        cussent.fendbalancefor                                                     \r\n");
            sql.append(from).append(innerJoinAsst);
            sql.append("    left outer join ").append(tableName).append(" tmp                         \r\n");
            sql.append("      on (tmp.fbaltype = cussent.fbaltype AND                                 \r\n");
            sql.append("      tmp.forgunitid = cussent.forgunitid AND                                 \r\n");
            sql.append("      tmp.faccountid = cussent.faccountid AND                                 \r\n");
            sql.append("      tmp.FAssistGrpID = cussent.FAssistGrpID AND                             \r\n");
            sql.append("      tmp.fcurrencyid = cussent.fcurrencyid)                                  \r\n");
            sql.append("                                                                              \r\n");
            sql.append(whereCommon);
            sql.append("      and pd.fnumber > status.fcurnumber                                      \r\n");
            sql.append("      and pd.fnumber <= status.fendnumber                                     \r\n");
            sql.append("      and status.fisendinfutrue = 1                                           \r\n");
            sql.append("      and cussent.FBalType=?                                                  \r\n");
            ps = con.prepareStatement(sql.toString());
            index = 1;
            for (String param : listParam) {
                ps.setString(index++, param);
            }
            ps.setInt(index++, balType);
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new SQLAccessException(e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    @Override
    protected HashMap _getAccountDC4Age(Context ctx, HashMap param) throws BOSException, EASBizException {
        HashMap<String, Integer> alAcResult = new HashMap<String, Integer>();
        boolean isUnion = false;
        String companyid = null;
        String accountTableId = null;
        ArrayList lstAcctNumber = new ArrayList();
        boolean isSumAccount = false;
        CompanyOrgUnitInfo company = null;
        ArrayList<String> lstParam = new ArrayList<String>();
        String cuLongNumber = null;
        if (param.get("isUnion") != null) {
            isUnion = (Boolean)param.get("isUnion");
        }
        if (param.get("companyid") != null) {
            companyid = (String)param.get("companyid");
            company = GlUtils.getCompanyById(ctx, companyid);
            cuLongNumber = company.getCU().getLongNumber();
        }
        if (param.get("accountTableId") != null) {
            accountTableId = (String)param.get("accountTableId");
        }
        if (param.get("lstAcctNumber") != null) {
            lstAcctNumber = (ArrayList)param.get("lstAcctNumber");
        }
        if (param.get("isSumAccount") != null) {
            isSumAccount = (Boolean)param.get("isSumAccount");
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int index = 1;
        StringBuffer sql = new StringBuffer();
        boolean isShowLongName = GlUtils.isAccountShowLongName(ctx, companyid);
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String fieldName = (isShowLongName ? "flongname_" : "fname_") + loc;
        try {
            con = this.getConnection(ctx);
            StringBuffer whereAcct = new StringBuffer();
            String acctNumber = "";
            acctNumber = SQLUtil.stringListToString(lstAcctNumber);
            if (!isSumAccount) {
                sql.append(" select distinct av.fnumber,av.").append(fieldName).append(" fname,av.fdc         \r\n");
            } else {
                sql.append(" select /*+ no_merge(pav) */ distinct pav.fnumber,pav.").append(fieldName).append(" fname,pav.fdc    \r\n");
            }
            sql.append(" from t_bd_accountview av                                     \r\n");
            sql.append(" inner join T_ORG_CtrlUnit cu on cu.fid = av.fcontrolunitid   \r\n");
            if (isSumAccount) {
                sql.append(" inner join t_bd_accountview pav on charindex(pav.flongnumber||'!',av.flongnumber||'!')>0  \r\n");
            }
            whereAcct.append(" where CU.flongNumber like ? ");
            lstParam.add(cuLongNumber == null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber() : cuLongNumber + "%");
            if (isUnion) {
                if (!StringUtils.isEmpty((String)accountTableId)) {
                    whereAcct.append(" and av.faccounttableid = ? ");
                    lstParam.add(accountTableId);
                }
            } else if (!StringUtils.isEmpty((String)companyid)) {
                whereAcct.append(" and av.fcompanyid = ? ");
                lstParam.add(companyid);
            }
            if (StringUtils.isEmpty((String)acctNumber)) {
                whereAcct.append(" and av.fnumber = '@@@@zzzz@@@@'");
            } else {
                whereAcct.append(" and av.fnumber in (" + acctNumber + ")");
            }
            sql.append(whereAcct);
            ps = con.prepareStatement(sql.toString());
            String strParam2 = "";
            index = 1;
            for (String strParam2 : lstParam) {
                ps.setString(index++, strParam2);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                alAcResult.put(rs.getString("fnumber") + " " + rs.getString("fname"), new Integer(rs.getInt("fdc")));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return alAcResult;
    }

    private static StringBuffer getSqlWhereNotInit(AccountAgeParam paramAge) {
        StringBuffer whereNotInit = new StringBuffer();
        StringBuffer whereCussent = new StringBuffer();
        StringBuffer wherePeriod = new StringBuffer();
        StringBuffer whereVch = new StringBuffer();
        StringBuffer whereAH = new StringBuffer();
        StringBuffer whereCurr = new StringBuffer();
        StringBuffer whereKhis = new StringBuffer();
        whereNotInit.append(" WHERE \r\n");
        whereCussent.append(" cussent.fisinit<>1   \r\n");
        if (paramAge.isAccountList()) {
            if (paramAge.isBizCode() && !paramAge.isIsOnlyUnion()) {
                String accountid = paramAge.getAccountid();
                String[] accountids = accountid == null ? null : accountid.split(",");
                String id = "";
                String curCuid = paramAge.getCompany().getCU().getId().toString();
                if (accountids != null) {
                    for (int i = 0; i < accountids.length; ++i) {
                        id = id + "'" + accountids[i] + "',";
                    }
                    id = id.substring(0, id.length() - 1);
                }
                whereAH.append(" and T_Hgid.bacid in (" + id + ") \r\n");
            } else {
                whereAH.append(" and hg.FID in (" + paramAge.getAccountid() + ") \r\n");
            }
        } else if (paramAge.getAccountViewNumber() == null) {
            whereAH.append(" and cussent.faccountid in (" + paramAge.getAccountid() + ")   \r\n");
        } else if (paramAge.getIndexType() != 0) {
            whereAH.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
            whereAH.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
            whereAH.append(" and account.fnumber like '").append(paramAge.getAccountViewNumber()).append("%'  \r\n");
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereCussent.append(" and cussent.fcompanyid='" + paramAge.getCompanyId() + "'  \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereCussent.append(" and cussent.fcurrencyid='" + paramAge.getCurrencyid() + "'   \r\n");
        }
        wherePeriod.append(" and exists (select 1 from v_gl_acperiod acp where acp.fcompanyid=cussent.fcompanyid and cussent.fperiodid = acp.fperiodid)  \r\n");
        whereVch.append(" and exists (select 1 from t_gl_voucher voucher where cussent.fvoucherid = voucher.fid \r\n");
        if (paramAge.isIncludeVerifyVch()) {
            whereVch.append(" and voucher.fbookeddate >= to_date('" + AccountAgeFacadeControllerBean.getFormateDate(paramAge.getHistoryDate()) + "')   \r\n");
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereVch.append(" and voucher.fcompanyid='" + paramAge.getCompanyId() + "'  \r\n");
        }
        if (!paramAge.isIncludeUnPosted()) {
            whereVch.append(" and voucher.FBizStatus=5  \r\n");
        } else {
            whereVch.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2   \r\n");
        }
        whereVch.append(" )  \r\n");
        whereKhis.append(" and (cussent.funverifiedamtfor <> 0 or exists (\r\n");
        whereKhis.append(" select 1 from t_gl_acctcussenthistory khis where khis.fcussentidid = cussent.fid \r\n");
        whereKhis.append(" and khis.fvchdate <= to_date('" + AccountAgeFacadeControllerBean.getFormateDate(paramAge.getHistoryDate()) + "') \r\n");
        whereKhis.append("\r\n))");
        whereNotInit.append(whereCussent).append(whereAH).append(wherePeriod).append(whereVch).append(whereKhis);
        return whereNotInit;
    }

    private static String getFormateDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    private static String getFormateDateByDBType(Date date, boolean isOracleDB2) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (isOracleDB2) {
            return " to_date('" + format.format(date) + "')";
        }
        return "'" + format.format(date) + "'";
    }

    private void calculateSumForBizCode(AccountAgeParam paramAge) throws BOSException {
        String orignalTbl = paramAge.getTempTableAcSum();
        Connection con = null;
        try {
            int j;
            this.lstHgOutSideRemoveFields = new ArrayList<String>();
            String selectItems = paramAge.getSqlSelecthgoutside().toString().replace(",fsubcompanyid", "");
            this.lstHgOutSideRemoveFields.add("fsubcompanyid");
            if (!paramAge.isAccountList()) {
                selectItems = selectItems.replace(",hgid", "");
                selectItems = selectItems.replace(",accountid", "");
                this.lstHgOutSideRemoveFields.add("hgid");
                this.lstHgOutSideRemoveFields.add("accountid");
            }
            StringBuffer acSelectintoSql = new StringBuffer();
            acSelectintoSql.append("select " + selectItems);
            acSelectintoSql.append(", sum(leftamount) as leftamount,sum(sumall) as  sumall");
            acSelectintoSql.append(",sum(sumunoverdue) as sumunoverdue,sum(sumoverdue) as sumoverdue");
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                    acSelectintoSql.append(",sum(sum" + j + ") as sum" + j + "");
                }
            }
            int index = 0;
            for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
                index = j + i;
                acSelectintoSql.append(",sum(sum" + index + ") as sum" + index + "");
            }
            acSelectintoSql.append(" into tempTableforAcSum from ");
            acSelectintoSql.append(paramAge.getTempTableAcSum());
            acSelectintoSql.append(" group by ");
            List lstHgOutSide = paramAge.getLstHgOutSide();
            lstHgOutSide.remove("fsubcompanyid");
            String field = "";
            int size = lstHgOutSide.size();
            for (int i = 0; i < size; ++i) {
                field = (String)lstHgOutSide.get(i);
                if (!paramAge.isAccountList() && ("hgid".equals(field) || "accountid".equals(field))) continue;
                acSelectintoSql.append(field + ",");
            }
            String acSumNewSql = acSelectintoSql.substring(0, acSelectintoSql.length() - 1);
            con = this.getConnection(paramAge.getCtx());
            String acSumNewtempTable = DBUtil.executeSelectIntoForTempTable((Context)paramAge.getCtx(), (String)acSumNewSql, null, (Connection)con).getTempTable();
            paramAge.setTempTableAcSum(acSumNewtempTable);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                TempTablePool iPool = TempTablePool.getInstance((Context)paramAge.getCtx());
                if (!StringUtils.isEmpty((String)orignalTbl)) {
                    iPool.releaseTable(orignalTbl);
                }
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        TempTablePool iPool = TempTablePool.getInstance((Context)paramAge.getCtx());
        if (!StringUtils.isEmpty((String)orignalTbl)) {
            iPool.releaseTable(orignalTbl);
        }
        SQLUtils.cleanup((Connection)con);
    }

    private void deleteFsumcompanyId(AccountAgeParam paramAge) {
        if (paramAge.getSqlSelecthgoutside().indexOf(",fsubcompanyid") > 0) {
            paramAge.setSqlSelecthgoutside(new StringBuffer(paramAge.getSqlSelecthgoutside().toString().replace(",fsubcompanyid", "")));
        }
        if (paramAge.getSqlSelecthgoutsideReal().indexOf(",fsubcompanyid") > 0) {
            paramAge.setSqlSelecthgoutsideReal(new StringBuffer(paramAge.getSqlSelecthgoutsideReal().toString().replace(",fsubcompanyid", "")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRowSet queryRptAgeByBal(AccountAgeParam paramAge) throws BOSException, EASBizException {
        Connection con;
        block3: {
            IRowSet iRowSet;
            paramAge.setRptQuery(true);
            paramAge.setParams(new HashMap());
            con = null;
            try {
                con = this.getConnection(paramAge.getCtx());
                if (this.beforeVerify(paramAge)) break block3;
                iRowSet = null;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(con);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)con);
            return iRowSet;
        }
        String acTable = this.doVerify(paramAge);
        this.afterVerify(paramAge, acTable);
        SQLUtils.cleanup((Connection)con);
        return this.dealRptResult(paramAge);
    }

    protected String queryRptByBal(AccountAgeParam paramAge) throws BOSException, EASBizException {
        paramAge.setRptQuery(true);
        if (!this.beforeVerifyRpt(paramAge)) {
            return null;
        }
        return this.doVerifyRpt(paramAge);
    }

    private String doVerifyRpt(AccountAgeParam paramAge) throws BOSException, EASBizException {
        String acTable = "";
        if (this.acTmpTable == null) {
            this.acTmpTable = acTable = this.createAcTable(paramAge);
        } else {
            acTable = this.acTmpTable;
        }
        Map acMap = this.getAcRecordsSqlAndParams_Rpt(paramAge);
        Map param = this.createParam(paramAge);
        param.put("tempTable", acTable);
        param.put("selector", this.initRptSelector(paramAge));
        param.put("acMap", acMap);
        param.put("isAgeVerify", true);
        param.put("accountIdStrForRpt", paramAge.getAccountid());
        param.put("isRptQuery", paramAge.isRptQuery());
        param.put("accountDateTypeForRptQuery", paramAge.getAccountDateType());
        if (paramAge.isIncludeVerifyVch()) {
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.QUERYBYBAL, true);
        }
        if (paramAge.isAccountList()) {
            param.put("isAccountList", true);
        }
        if (paramAge.isRptQuery() || paramAge.isIsOnlyUnion()) {
            param.put("isActKey", true);
        }
        AutoVerifyService autoVerifyService = new AutoVerifyService();
        autoVerifyService.autoVerify(paramAge.getCtx(), param);
        return acTable;
    }

    private String initRptSelector(AccountAgeParam paramAge) {
        return paramAge.getSqlSelecthgoutside() + ",fid,fvoucherid,fvoucherType,fnumber,fbizDate,fendDate,FBizNumber,FBookedDate,FDC,FOriginalAmount,FUnVerifiedAmtFor";
    }

    private Map getAcRecordsSqlAndParams_Rpt(AccountAgeParam paramAge) throws EASBizException, BOSException {
        StringBuffer hisSql = null;
        ArrayList params = new ArrayList();
        StringBuffer notInitSql = this.getSql_ByAcctBal_AcNotInit(paramAge);
        StringBuffer initSql = this.getSql_ByAcctBal_AcInit(paramAge);
        try {
            int index = 1;
            index = GLAcctAgeNewUtils.setupParams_ByBal_InsertSum_Rpt(false, false, null, paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), params, index, null, paramAge.getLastPhaseBeginDate());
            if (paramAge.isIncludeInit()) {
                index = GLAcctAgeNewUtils.setupParams_ByBal_InsertSum_Rpt(false, true, null, paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), params, index, null, null);
            }
            hisSql = GLAcctAgeNewUtils.getHistorySqlUnAcVerify(paramAge);
            params.addAll(GLAcctAgeNewUtils.getUnVerifyParam(paramAge, true));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        notInitSql.append(" union all \r\n").append(initSql);
        String selector = paramAge.getSqlSelecthgoutside() + ",FUnVerifiedAmtFor,fbizDate,fendDate,FBizNumber";
        HashMap<String, Object> acMap = new HashMap<String, Object>();
        acMap.put("srcSql", notInitSql.toString());
        acMap.put("acSelector", selector);
        acMap.put("hisSql", hisSql.toString());
        acMap.put("hisSelector", selector);
        acMap.put("srcParams", params);
        StringBuffer sql6VeriSum = this.getSql_ByBal_AcVeriSum(paramAge);
        StringBuffer sql7HistorySql4Verified = GLAcctAgeNewUtils.getHistorySqlUnVerify(paramAge);
        if (paramAge.isIncludeVerifyVch()) {
            List veriParam = GLAcctAgeNewUtils.getUnVerifyParam(paramAge, false);
            acMap.put("desSql", sql6VeriSum.toString());
            acMap.put("desParams", veriParam);
            acMap.put("desSelector", selector);
            acMap.put("hisDesSql", sql7HistorySql4Verified.toString());
            veriParam = GLAcctAgeNewUtils.getUnVerifyParam(paramAge, true);
            veriParam.addAll(GLAcctAgeNewUtils.getUnVerifyParam(paramAge, true));
            acMap.put("initParams", veriParam);
        }
        return acMap;
    }

    private boolean beforeVerifyRpt(AccountAgeParam paramAge) throws BOSException, EASBizException {
        GLAcctAgeNewUtils.dealwithRpt_Param(paramAge);
        try {
            if (this.tempTableComVeriMode != null) {
                paramAge.setTempTableComVeriMode(this.tempTableComVeriMode);
            }
            GLAcctAgeNewUtils.prepareTempTableCompanyVerifyMode(paramAge);
            if (this.tempTableComVeriMode == null) {
                this.tempTableComVeriMode = paramAge.getTempTableComVeriMode();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        GLAcctAgeNewUtils.getSql_ByAcctBal_AmountField(paramAge);
        GLAcctAgeNewUtils.getRptSql_ByAcctBal_Param_AlDates(paramAge);
        GLAcctAgeNewUtils.prepareTempTableAdjExch(paramAge);
        GLAcctAgeNewUtils.getRptSql_ByAcctBal_SelectHgJoin(paramAge);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ArrayList queryAgeByBal(AccountAgeParam paramAge) throws BOSException, EASBizException {
        ArrayList result;
        block11: {
            boolean isWebService;
            String acTable;
            block9: {
                ArrayList arrayList;
                block10: {
                    result = null;
                    acTable = null;
                    isWebService = paramAge.getType() == QueryAgeType.WEBSERVICE_AGE_DAYS;
                    try {
                        GLAcctAgeNewUtils.cachePeriodData(paramAge.getCtx(), paramAge.getCompanyId());
                        if (this.beforeVerify(paramAge)) break block9;
                        arrayList = null;
                        if (isWebService) break block10;
                    }
                    catch (Throwable throwable) {
                        if (!isWebService) {
                            GLAcctAgeNewUtils.clearAllDataCache();
                            if (acTable != null) {
                                TempTablePool iPool = TempTablePool.getInstance((Context)paramAge.getCtx());
                                iPool.releaseTable(acTable);
                            }
                        }
                        GLAcctAgeNewUtils.releaseIdsTempTable(paramAge.getCtx());
                        throw throwable;
                    }
                    GLAcctAgeNewUtils.clearAllDataCache();
                    if (acTable != null) {
                        TempTablePool iPool = TempTablePool.getInstance((Context)paramAge.getCtx());
                        iPool.releaseTable(acTable);
                    }
                }
                GLAcctAgeNewUtils.releaseIdsTempTable(paramAge.getCtx());
                return arrayList;
            }
            if (isWebService) {
                List<Map<String, Object>> verifyData = this.doVerifyNoTempTable(paramAge);
                DataProcessEngine dataProcess = new DataProcessEngine(verifyData);
                this.afterVerifyAgeDaysNoTempTable(paramAge, verifyData, dataProcess);
                result = this.dealAgeDaysResultNoTempTable(paramAge, dataProcess);
            } else {
                acTable = this.doVerify(paramAge);
                this.afterVerify(paramAge, acTable);
                result = this.dealResult(paramAge);
            }
            if (isWebService) break block11;
            GLAcctAgeNewUtils.clearAllDataCache();
            if (acTable != null) {
                TempTablePool iPool = TempTablePool.getInstance((Context)paramAge.getCtx());
                iPool.releaseTable(acTable);
            }
        }
        GLAcctAgeNewUtils.releaseIdsTempTable(paramAge.getCtx());
        return result;
    }

    private String createAcTable(AccountAgeParam paramAge) throws EASBizException, BOSException {
        StringBuffer createSql = new StringBuffer();
        createSql.append("(fid VARCHAR(44), ");
        if (paramAge.isRptQuery()) {
            createSql.append(paramAge.getSqlCreateHgTbl());
            createSql.append("FendDate datetime, ");
        } else {
            createSql.append(paramAge.getSqlCreateHgTbl());
        }
        createSql.append("fvoucherid VARCHAR(44), ");
        createSql.append("FvoucherType VARCHAR(20), ");
        createSql.append("FNumber VARCHAR(40), ");
        createSql.append("FBizDate datetime, ");
        String bizNumberField = GLTempTableUtil.getDataType("FBizNumber", this.tempTableFieldType, "NVARCHAR(200)");
        createSql.append(bizNumberField).append(",");
        createSql.append("FBookedDate datetime, ");
        createSql.append("FDescription VARCHAR(120), ");
        createSql.append("FDC int, ");
        createSql.append("FOriginalAmount numeric(28,10), ");
        createSql.append("voucherAssistRecordID VARCHAR(44), ");
        createSql.append("FUnverifiedAmtFor numeric(28,10), ");
        createSql.append("FLastUpdateTime datetime)");
        return GLAcctAgeNewUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_datas", createSql);
    }

    private Map createParam(AccountAgeParam paramAge) {
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.EXCLUDEUNPOSTVCH, paramAge.isIncludeUnPosted());
        param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NEGATIVEVERIFY, true);
        param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM, true);
        param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME, false);
        param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME, false);
        return param;
    }

    private String initSelector(AccountAgeParam paramAge) {
        return paramAge.getSqlSelectorHgTbl() + "fid,fvoucherid,fvoucherType,fnumber,fbizDate,FBizNumber,FBookedDate,FDescription,FDC,FOriginalAmount,FUnVerifiedAmtFor";
    }

    private Map getAcRecordsSqlAndParams(AccountAgeParam paramAge) throws EASBizException, BOSException {
        StringBuffer hisSql = null;
        Object con = null;
        ArrayList params = new ArrayList();
        StringBuffer notInitSql = this.getSql_ByAcctBal_AcNotInit(paramAge);
        StringBuffer initSql = this.getSql_ByAcctBal_AcInit(paramAge);
        try {
            int index = 1;
            index = GLAcctAgeNewUtils.setupParams_ByBal_InsertSum(false, false, null, paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), params, index, null, paramAge.getLastPhaseBeginDate());
            if (paramAge.isIncludeInit()) {
                index = GLAcctAgeNewUtils.setupParams_ByBal_InsertSum(false, true, null, paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), params, index, null, null);
            }
            hisSql = GLAcctAgeNewUtils.getHistorySqlUnAcVerify(paramAge);
            params.addAll(GLAcctAgeNewUtils.getUnVerifyParam(paramAge, true));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        notInitSql.append(" union all \r\n").append(initSql);
        String selector = paramAge.getSqlSelectorHgTbl() + "FUnVerifiedAmtFor,fbizDate,FBizNumber";
        HashMap<String, Object> acMap = new HashMap<String, Object>();
        acMap.put("srcSql", notInitSql.toString());
        acMap.put("acSelector", selector);
        acMap.put("hisSql", hisSql.toString());
        acMap.put("hisSelector", selector);
        acMap.put("srcParams", params);
        if (paramAge.isIncludeVerifyVch()) {
            StringBuffer sql6VeriSum = this.getSql_ByBal_AcVeriSum(paramAge);
            StringBuffer sql7HistorySql4Verified = GLAcctAgeNewUtils.getHistorySqlUnVerify(paramAge);
            List veriParam = GLAcctAgeNewUtils.getUnVerifyParam(paramAge, false);
            acMap.put("desSql", sql6VeriSum.toString());
            acMap.put("desParams", veriParam);
            acMap.put("desSelector", selector);
            acMap.put("hisDesSql", sql7HistorySql4Verified.toString());
            veriParam = GLAcctAgeNewUtils.getUnVerifyParam(paramAge, true);
            veriParam.addAll(GLAcctAgeNewUtils.getUnVerifyParam(paramAge, true));
            acMap.put("initParams", veriParam);
        }
        return acMap;
    }

    private void insertVerifiedRecordsToAcSumTable(AccountAgeParam paramAge, String acTable) throws BOSException {
        int i;
        String amountFiled = "FUnVerifiedAmtFor";
        String dateFiled = "fbizDate";
        ArrayList param = new ArrayList();
        StringBuilder ageSql = new StringBuilder();
        StringBuilder vals = new StringBuilder();
        ageSql.append("select \r\n");
        String selectorHg = paramAge.getSqlSelectorHgTbl().toString();
        vals.append(selectorHg);
        if (paramAge.isIsOnlyUnion() && paramAge.isAccountList()) {
            selectorHg = selectorHg.replace("Taccountid", "N'' Taccountid");
        }
        if (!paramAge.isAccountList() || !paramAge.isSumDC()) {
            selectorHg = selectorHg.replace("hgid", "N'' hgid");
        }
        ageSql.append(selectorHg);
        ageSql.append("\r\n sum(case when " + dateFiled + ">=? then isnull(").append(amountFiled).append(", 0) else 0 end) as sumUnOverDue  \r\n");
        vals.append("sumUnOverDue,");
        StringBuilder sumOnePhase = new StringBuilder(" ,sum(case when ").append(dateFiled).append("<? and ").append(dateFiled).append(">=? then ").append(amountFiled).append(" else 0 end) as sum");
        StringBuilder sumUnOnePhase = new StringBuilder(" ,sum(case when ").append(dateFiled).append(">? and ").append(dateFiled).append("<=? then ").append(amountFiled).append(" else 0 end) as sum");
        if (paramAge.isRptQuery()) {
            vals.append("sum0 ");
            if (paramAge.isShowUmexpired()) {
                if (paramAge.getUndaylen() == 1) {
                    sumUnOnePhase = new StringBuilder();
                    sumUnOnePhase.append(",sum(case when ").append(dateFiled).append("> ? then ").append(amountFiled).append(" else 0 end) as sum");
                } else {
                    sumUnOnePhase = new StringBuilder(" ,sum(case when ").append(dateFiled).append(">=? and ").append(dateFiled).append("<=? then ").append(amountFiled).append(" else 0 end) as sum");
                }
                sumOnePhase = sumUnOnePhase;
            }
            ageSql.append((CharSequence)sumOnePhase).append("0 ");
        } else {
            int j;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j < paramAge.getUndaylen(); ++j) {
                    if (j == 0) {
                        ageSql.append(" ,sum(case when ").append(dateFiled).append(">=? and ").append(dateFiled).append("<=? then ").append(amountFiled).append(" else 0 end) as sum0   \r\n");
                    } else {
                        ageSql.append((CharSequence)sumUnOnePhase).append(j).append("  \r\n");
                    }
                    vals.append("sum").append(j).append(",");
                }
                ageSql.append(",sum(case when " + dateFiled + ">? then ").append(amountFiled).append(" else 0 end) as sum" + j + "\r\n");
                vals.append("sum").append(j).append(",");
                ++j;
            }
            int index = 0;
            ageSql.append((CharSequence)sumOnePhase).append(j + " \r\n");
            vals.append("sum").append(j).append(",");
            for (i = 1; i < paramAge.getDaylen(); ++i) {
                index = i + j;
                ageSql.append((CharSequence)sumOnePhase).append(index).append("  \r\n");
                vals.append("sum").append(index).append(",");
            }
            index = paramAge.getDaylen() + j;
            ageSql.append((CharSequence)sumOnePhase).append(index).append("  \r\n");
            vals.append("sum").append(index);
        }
        ageSql.append(" from ").append(acTable).append(" cussent ");
        String group = paramAge.getSqlGroupbyAge().toString();
        if (!StringUtils.isEmpty((String)group)) {
            if (paramAge.isIsOnlyUnion() && paramAge.isAccountList()) {
                group = group.replace("Taccountid,", "");
            }
            group = group.indexOf("hgid") > 0 && (!paramAge.isAccountList() || !paramAge.isSumDC()) ? group.substring(0, group.lastIndexOf("hgid") - 1) : group.substring(0, group.lastIndexOf(","));
        }
        ageSql.append(group);
        String insertSql = "insert into " + paramAge.getTempTableAcSum() + " (" + vals + ") " + ageSql.toString();
        i = 1;
        PreparedStatement ps = null;
        Connection con = null;
        try {
            con = this.getConnection(paramAge.getCtx());
            ps = con.prepareStatement(insertSql);
            ArrayList dateList = paramAge.getAlDates();
            for (java.sql.Date date : dateList) {
                ps.setDate(i++, date);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private boolean beforeVerify(AccountAgeParam paramAge) throws BOSException, EASBizException {
        if (!(paramAge.getDays() != null && paramAge.getDays().length >= 1 || paramAge.isRptQuery() && paramAge.isShowUmexpired() && (paramAge.getUndays() != null || paramAge.getDays().length > 0))) {
            return false;
        }
        GLAcctAgeNewUtils.dealwith_Param(paramAge);
        this.dealTempTables(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_AmountField(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_Param_AlDates(paramAge);
        GLAcctAgeNewUtils.prepareTempTableAdjExch(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_SelectHgJoin(paramAge);
        if (paramAge.isRptQuery()) {
            paramAge.setSqlGroupbyAge(new StringBuffer("group by fcurrid,fcurrname,accountid,"));
            paramAge.setSqlSelectorHgTbl(new StringBuilder("fcurrid,fcurrname,hgid,accountid,"));
        }
        StringBuffer sqlBizCodeHgid = new StringBuffer();
        if (paramAge.isBizCode() && paramAge.isAccountList()) {
            sqlBizCodeHgid = GLAcctAgeNewUtils.queryBizCodeHgid(paramAge);
        } else if (paramAge.isAccountBC() && (!paramAge.isAccountBCNoType() || paramAge.isIncludeVerifyVch())) {
            sqlBizCodeHgid = GLAcctAgeNewUtils.queryBizCodeHgid(paramAge);
        }
        paramAge.setSqlBizCodeHgid(sqlBizCodeHgid);
        return true;
    }

    private void dealTempTables(AccountAgeParam paramAge) throws EASBizException, BOSException {
        try {
            if (paramAge.isRptQuery() && this.tempTableComVeriMode != null) {
                paramAge.setTempTableComVeriMode(this.tempTableComVeriMode);
            }
            GLAcctAgeNewUtils.prepareTempTableCompanyVerifyMode(paramAge);
            if (paramAge.isRptQuery() && this.tempTableComVeriMode == null) {
                this.tempTableComVeriMode = paramAge.getTempTableComVeriMode();
            }
            GLAcctAgeNewUtils.prepareTempTableHg(paramAge);
            if (paramAge.isIsOnlyUnion()) {
                GLAcctAgeNewUtils.prepareTempTableCompanys(paramAge);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLAccessException(e);
        }
    }

    private String doVerify(AccountAgeParam paramAge) throws BOSException, EASBizException {
        String acTable = "";
        if (!paramAge.isRptQuery()) {
            acTable = this.createAcTable(paramAge);
        } else if (paramAge.isRptQuery()) {
            if (this.acTmpTable == null) {
                this.acTmpTable = acTable = this.createAcTable(paramAge);
            } else {
                acTable = this.acTmpTable;
            }
        }
        Map acMap = this.getAcRecordsSqlAndParams(paramAge);
        Map param = this.createParam(paramAge);
        param.put("tempTable", acTable);
        param.put("selector", this.initSelector(paramAge));
        param.put("acMap", acMap);
        param.put("isAgeVerify", true);
        if (paramAge.isIncludeVerifyVch()) {
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.QUERYBYBAL, true);
        }
        param.put("isSumDC", paramAge.isSumDC());
        if (paramAge.isAccountList()) {
            param.put("isAccountList", true);
        }
        if (paramAge.isRptQuery() || paramAge.isIsOnlyUnion() || paramAge.isSumAccount()) {
            param.put("isActKey", true);
        }
        AutoVerifyService autoVerifyService = new AutoVerifyService();
        autoVerifyService.autoVerify(paramAge.getCtx(), param);
        return acTable;
    }

    private List<Map<String, Object>> doVerifyNoTempTable(AccountAgeParam paramAge) throws BOSException, EASBizException {
        Map acMap = this.getAcRecordsSqlAndParams(paramAge);
        Map param = this.createParam(paramAge);
        param.put("noTempTable", true);
        param.put("selector", this.initSelector(paramAge));
        param.put("acMap", acMap);
        param.put("isAgeVerify", true);
        if (paramAge.isIncludeVerifyVch()) {
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.QUERYBYBAL, true);
        }
        if (paramAge.isAccountList()) {
            param.put("isAccountList", true);
        }
        if (paramAge.isRptQuery() || paramAge.isIsOnlyUnion()) {
            param.put("isActKey", true);
        }
        AutoVerifyService autoVerifyService = new AutoVerifyService();
        autoVerifyService.autoVerify(paramAge.getCtx(), param);
        return (List)param.get("acData");
    }

    private void afterVerify(AccountAgeParam paramAge, String acTable) throws BOSException, EASBizException {
        ArrayList alAcResult = new ArrayList();
        Statement ps = null;
        ResultSet rs = null;
        try {
            int iAdjust;
            int daylen = paramAge.getDaylen();
            int undaylen = paramAge.getUndaylen();
            if (this.tempTableAcSum == null) {
                if (this.tempTableAcSum == null) {
                    this.createTempTable_ByBal_AcSum(paramAge);
                    this.tempTableAcSum = paramAge.getTempTableAcSum();
                } else {
                    paramAge.setTempTableAcSum(this.tempTableAcSum);
                }
            } else {
                paramAge.setTempTableAcSum(this.tempTableAcSum);
            }
            this.insertVerifiedRecordsToAcSumTable(paramAge, acTable);
            if (paramAge.isGeneralCy()) {
                this.calculateLocalAmt4GeneralCy(paramAge);
                this.insertTotalSumLines4GeneralCurency(paramAge);
            }
            if (paramAge.isIsOnlyUnion() && !paramAge.isRptQuery()) {
                this.calculateSumForBizCode(paramAge);
                this.deleteFsumcompanyId(paramAge);
            }
            this.calculateSumallSumOverdue(paramAge.getTempTableAcSum(), daylen, true, paramAge);
            this.deleteBalZeroAcFromTempTable(paramAge);
            if (((!paramAge.isAllCurr() || paramAge.isGeneralCy()) && paramAge.isIsfirstload() || paramAge.isIsOnlyUnion()) && !paramAge.isRptQuery() && !paramAge.isSumDC()) {
                this.insertTotalSumLines(paramAge);
            }
            if (paramAge.isGeneralCy() && !paramAge.isAccountList() && (iAdjust = this.calculateLocalAmt4Deviation(paramAge)) != 0) {
                this.calculateSumallSumOverdue(paramAge.getTempTableAcSum(), daylen, true, paramAge);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            throw new SQLAccessException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, ps);
        }
    }

    private void afterVerifyAgeDaysNoTempTable(AccountAgeParam paramAge, List<Map<String, Object>> verifyData, DataProcessEngine dataProcess) throws BOSException, EASBizException {
        this.getVerifiedRecords_AgeDays(paramAge, dataProcess);
        if (paramAge.isGeneralCy()) {
            String adjustExchangeTable = "";
            adjustExchangeTable = paramAge.getCompany().getAdjustExchangeTable() == null ? paramAge.getCompany().getBaseExchangeTable().getId().toString() : paramAge.getCompany().getAdjustExchangeTable().getId().toString();
            if (!StringUtils.isEmpty((String)adjustExchangeTable)) {
                Date adjExchDate = paramAge.get("adjExchDate") == null ? paramAge.getHistoryDate() : (Date)paramAge.get("adjExchDate");
                String key = adjustExchangeTable + "$" + adjExchDate.toString();
                String adjExchTmpTable = GLAcctAgeNewUtils.adjExchTmpTableCache.get().get(key);
                if (!StringUtils.isEmpty((String)adjExchTmpTable)) {
                    this.calculateLocalAmt4GeneralCyNew(paramAge, key, adjExchTmpTable, dataProcess);
                }
            }
        }
    }

    private void calculateLocalAmt4GeneralCyNew(AccountAgeParam paramAge, String cacheKey, String adjExchTmpTable, DataProcessEngine dataProcess) throws BOSException {
        try {
            Map<String, GLAcctAgeNewUtils.CurrencyRateConvertInfo> adjExchData = GLAcctAgeNewUtils.getAdjExchData(paramAge.getCtx(), cacheKey, adjExchTmpTable);
            List<Map<String, Object>> tmpData = dataProcess.getTmpData();
            for (Map<String, Object> rowData : tmpData) {
                String currid = (String)rowData.get("fcurrid");
                BigDecimal sumamt = (BigDecimal)rowData.get("sumamt");
                GLAcctAgeNewUtils.CurrencyRateConvertInfo currencyRateConvertInfo = adjExchData.get(currid);
                if (currencyRateConvertInfo == null) continue;
                BigDecimal convertRate = currencyRateConvertInfo.getConvertRate();
                int precision = paramAge.getGeneralCurrency().getPrecision();
                sumamt = sumamt == null ? BigDecimal.ZERO : sumamt.multiply(convertRate).setScale(precision, 4);
                rowData.put("sumamt", sumamt);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query exchRate temp table error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void afterVerifyAgeDays(AccountAgeParam paramAge, String acTable) throws BOSException, EASBizException {
        ArrayList alAcResult = new ArrayList();
        if (this.tempTableAcSum == null) {
            if (this.tempTableAcSum == null) {
                this.createTempTable_ByBal_AcSum_AgeDays(paramAge);
                this.tempTableAcSum = paramAge.getTempTableAcSum();
            } else {
                paramAge.setTempTableAcSum(this.tempTableAcSum);
            }
        } else {
            paramAge.setTempTableAcSum(this.tempTableAcSum);
        }
        this.insertVerifiedRecordsToAcSumTable_AgeDays(paramAge, acTable);
        if (paramAge.isGeneralCy()) {
            StringBuilder sql = new StringBuilder();
            sql.append("Update ").append(paramAge.getTempTableAcSum());
            sql.append(" tmp set (sumamt) = (select sumamt * isnull(tmpExch.FCONVERTRATEA,1)");
            sql.append(" from " + paramAge.getTempTableExchRate() + " tmpExch where tmpExch.fid = tmp.fcurrid ) ");
            DbUtil.execute((Context)paramAge.getCtx(), (String)sql.toString());
        }
    }

    private ArrayList dealAgeDaysResult(AccountAgeParam paramAge) throws BOSException, EASBizException {
        StringBuilder select = new StringBuilder();
        StringBuilder orderby = new StringBuilder();
        ArrayList<String> asstCols = new ArrayList<String>();
        for (int i = 0; i < paramAge.getAlAstTables().size(); ++i) {
            String numkey = "T" + i + "fnumber";
            String namekey = "T" + i + "fname";
            select.append(numkey).append(",").append(namekey).append(",");
            asstCols.add(numkey);
            asstCols.add(namekey);
            orderby.append(numkey).append(",");
        }
        select.append("fcurrname,sumamt,days");
        orderby.append("fcurrname");
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append((CharSequence)select).append(",currency.FPRECISION,currency.fnumber currNumber,round(sumamt,currency.FPRECISION) amt").append(" from ").append(paramAge.getTempTableAcSum()).append(" temp");
        sql.append(" inner join T_BD_CURRENCY currency on temp.fcurrid = currency.fid");
        sql.append(" where sumamt<>0");
        sql.append(" order by ").append((CharSequence)orderby);
        IRowSet rowSet = DbUtil.executeQuery((Context)paramAge.getCtx(), (String)sql.toString());
        ArrayList result = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(asstCols.size() + 3);
                for (String col : asstCols) {
                    dataMap.put(col, rowSet.getObject(col));
                }
                dataMap.put("currencyName", rowSet.getString("fcurrname"));
                dataMap.put("currencyNumber", rowSet.getString("currNumber"));
                int precision = rowSet.getInt("FPRECISION");
                dataMap.put("sumamt", rowSet.getBigDecimal("amt").setScale(precision));
                dataMap.put("days", rowSet.getInt("days"));
                result.add(dataMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"webservice query age days exception.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            GLAcctAgeNewUtils.dropTempTable(paramAge, logger);
            GLAcctAgeNewUtils.hmParamIn.clear();
        }
        return result;
    }

    private ArrayList dealResult(AccountAgeParam paramAge) throws BOSException, EASBizException {
        ArrayList alAcResult = new ArrayList();
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection con = this.getConnection(paramAge.getCtx());
        try {
            StringBuffer merge = this.getSql_ByAcctBal_LastResult_FromTempAcSum(paramAge);
            ps = con.prepareStatement(merge.toString());
            rs = ps.executeQuery();
            alAcResult = this.create_LastResult_ByAcctBal(paramAge, rs);
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)sqle);
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                GLAcctAgeNewUtils.dropTempTable(paramAge, logger);
                GLAcctAgeNewUtils.hmParamIn.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        GLAcctAgeNewUtils.dropTempTable(paramAge, logger);
        GLAcctAgeNewUtils.hmParamIn.clear();
        return alAcResult;
    }

    private ArrayList dealAgeDaysResultNoTempTable(AccountAgeParam paramAge, DataProcessEngine dataProcess) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        try {
            List<Map<String, Object>> allCurrency = GLAcctAgeNewUtils.getAllCurrency(paramAge.getCtx());
            DataSet currencyDataSet = new DataSet(allCurrency, "currency");
            RoundFunction roundFunction = null;
            roundFunction = paramAge.isGeneralCy() ? new RoundFunction(paramAge.getGeneralCurrency().getPrecision(), "sumamt") : new RoundFunction("sumamt", "currency.fprecision");
            ArrayList<RoundFunction> roundFunctions = new ArrayList<RoundFunction>(1);
            roundFunctions.add(roundFunction);
            List<Map<String, Object>> dataProcessResult = dataProcess.join(currencyDataSet, "fcurrid", "fid").round(roundFunctions).getTmpData();
            ArrayList<String> asstCols = new ArrayList<String>();
            for (int i = 0; i < paramAge.getAlAstTables().size(); ++i) {
                String numkey = "T" + i + "fnumber";
                String namekey = "T" + i + "fname";
                asstCols.add(numkey);
                asstCols.add(namekey);
            }
            Iterator<Map<String, Object>> iterator = dataProcessResult.iterator();
            while (iterator.hasNext()) {
                HashMap<String, Object> finalResult = new HashMap<String, Object>();
                Map<String, Object> dataMap = iterator.next();
                for (String asstCol : asstCols) {
                    finalResult.put(asstCol, dataMap.get(asstCol));
                }
                finalResult.put("currencyName", dataMap.get("fcurrname"));
                finalResult.put("currencyNumber", dataMap.get("currency.fnumber"));
                finalResult.put("sumamt", dataMap.get("sumamt"));
                finalResult.put("days", dataMap.get("days"));
                result.add(finalResult);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query currency exception.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet dealRptResult(AccountAgeParam paramAge) throws BOSException, EASBizException {
        IRowSet rs = null;
        try {
            StringBuffer merge = this.getSql_ByAcctBal_LastResult_FromTempAcSum(paramAge);
            rs = DbUtil.executeQuery((Context)paramAge.getCtx(), (String)merge.toString());
        }
        finally {
            if (this.tempTableComVeriMode != null) {
                DbUtil.execute((Context)paramAge.getCtx(), (String)("delete from " + this.tempTableComVeriMode));
            }
            if (this.tempTableAcSum != null) {
                DbUtil.execute((Context)paramAge.getCtx(), (String)("delete from " + this.tempTableAcSum));
            }
        }
        return rs;
    }

    private String getSelectHeadSql(AccountAgeParam paramAge) {
        String dateField = paramAge.getStrDateType_AC();
        if (!dateField.equalsIgnoreCase("fenddate")) {
            dateField = "fvarbizdate";
        }
        StringBuilder select = new StringBuilder();
        select.append(paramAge.getAmountField()).append(" FUnVerifiedAmtFor");
        select.append(" ,cussent.").append(dateField).append(" FBizDate,cussent.FBizNumber FBizNumber \r\n");
        return select.toString();
    }

    private String getRptSelectHeadSql(AccountAgeParam paramAge) {
        StringBuilder select = new StringBuilder();
        select.append(paramAge.getAmountField()).append(" FUnVerifiedAmtFor");
        select.append(" ,cussent.fvarbizdate FBizDate,cussent.fenddate ,cussent.FBizNumber FBizNumber \r\n");
        return select.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchQueryAge(Context ctx, Map params) throws BOSException, EASBizException {
        String value;
        TempTablePool iPool;
        IRowSet rowset;
        List<Map<String, Object>> queryRptAge;
        String[] accountIdArray;
        String accountIds;
        String asstItemKey;
        AccountAgeParam accountAgeParam;
        AccountAgeParam value2;
        String acTable;
        HashMap<AccountAgeParam, String> acTableMap;
        HashMap<String, String> acctAndActTable;
        Map<String, AccountAgeParam> queryParamMap;
        if (params != null && !params.containsKey("queryParam")) {
            return new AccountAgeFacadeControllerBeanOld().batchQueryAge(ctx, params);
        }
        this.tempTableFieldType = GLTempTableUtil.getDataTypes(ctx, "AccountAgeFacadeControllerBean", "acTable");
        logger.error((Object)"_batchQueryAge.statrt-->");
        long s = System.currentTimeMillis();
        Set keys = params.keySet();
        Object companyid = null;
        Object accountids = null;
        StringBuffer log = new StringBuffer();
        this.cacheCurData(ctx, null);
        String companyids = (String)params.get("companyids");
        GLAcctAgeNewUtils.cachePeriodData(ctx, companyids);
        CompanyOrgUnitInfo _company = GlUtils.getCurrentCompany(ctx);
        Date historyDate22 = null;
        Map pMap = null;
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>(keys.size());
        Map queryMap = (Map)params.get("queryParam");
        Iterator it = queryMap.keySet().iterator();
        boolean useNewAgeCalcMode = Boolean.valueOf(GlUtils.getParamByKey(ctx, _company.getId().toString(), "GL_UseNewAgeCalcMode").toString());
        logger.error((Object)("use new age calc mode:" + useNewAgeCalcMode));
        HashSet<String> tmpTabList = new HashSet<String>();
        while (it.hasNext()) {
            historyDate22 = (Date)it.next();
            pMap = (Map)queryMap.get(historyDate22);
            queryParamMap = this.initAccountAgeParam2(ctx, pMap, historyDate22, _company);
            acctAndActTable = new HashMap<String, String>();
            acTableMap = new HashMap<AccountAgeParam, String>();
            for (Map.Entry<String, AccountAgeParam> entry : queryParamMap.entrySet()) {
                String string = entry.getKey();
                acTable = null;
                value2 = entry.getValue();
                if (acTableMap.containsKey(value2)) {
                    acTable = (String)acTableMap.get(value2);
                } else {
                    acTable = this.queryRptByBal(value2);
                    acTableMap.put(value2, acTable);
                }
                acctAndActTable.put(string, acTable);
                tmpTabList.add(acTable);
                this.acTmpTable = null;
            }
            try {
                String key2 = null;
                Iterator iterator = pMap.keySet().iterator();
                RptAgeCalculation rptAgeCalculation = new RptAgeCalculation();
                while (iterator.hasNext()) {
                    key2 = (String)iterator.next();
                    if ("companyids".equals(key2) || "accountids".equals(key2) || "isIncludeVerifyVch".equals(key2)) continue;
                    try {
                        accountAgeParam = (AccountAgeParam)pMap.get(key2);
                        asstItemKey = this.getAsstItemKey(accountAgeParam);
                        if (useNewAgeCalcMode) {
                            accountIds = accountAgeParam.getAccountid();
                            if (accountIds == null || "".equals(accountIds)) continue;
                            accountIdArray = accountIds.split(",");
                            queryRptAge = rptAgeCalculation.queryRptAge(accountAgeParam, (String)acctAndActTable.get(accountIdArray[0] + asstItemKey));
                            result.put(key2, queryRptAge);
                            continue;
                        }
                        accountIds = accountAgeParam.getAccountid();
                        if (accountIds == null || "".equals(accountIds)) continue;
                        accountIdArray = accountIds.split(",");
                        rowset = this.queryRptAgeByBal(accountAgeParam, (String)acctAndActTable.get(accountIdArray[0] + asstItemKey));
                        result.put(key2, rowset);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        result.put(key2, "error");
                    }
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"account age error.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    TempTablePool iPool2 = TempTablePool.getInstance((Context)ctx);
                    if (!StringUtils.isEmpty((String)this.acTmpTable)) {
                        iPool2.releaseTable(this.acTmpTable);
                    }
                    if (!StringUtils.isEmpty((String)this.tempTableComVeriMode)) {
                        iPool2.releaseTable(this.tempTableComVeriMode);
                    }
                    this.acTmpTable = null;
                    this.tempTableComVeriMode = null;
                    this.tempTableAcSum = null;
                    GLAcctAgeNewUtils.hmParamIn.clear();
                    for (Map.Entry<String, String> entry : GLAcctAgeNewUtils.adjustRateInfoCache.entrySet()) {
                        String value3 = entry.getValue();
                        if (value3 == null) continue;
                        iPool2.releaseTable(value3);
                    }
                    GLAcctAgeNewUtils.adjustRateInfoCache.clear();
                    RptAgeCalculation.exchRateMapCache.clear();
                    for (Map.Entry<String, String> entry : this.tempAcSumTableMap.entrySet()) {
                        String value3 = entry.getValue();
                        if (value3 == null) continue;
                        iPool2.releaseTable(value3);
                    }
                    this.tempAcSumTableMap.clear();
                    for (String tempTable : tmpTabList) {
                        iPool2.releaseTable(tempTable);
                    }
                    throw throwable;
                }
                iPool = TempTablePool.getInstance((Context)ctx);
                if (!StringUtils.isEmpty((String)this.acTmpTable)) {
                    iPool.releaseTable(this.acTmpTable);
                }
                if (!StringUtils.isEmpty((String)this.tempTableComVeriMode)) {
                    iPool.releaseTable(this.tempTableComVeriMode);
                }
                this.acTmpTable = null;
                this.tempTableComVeriMode = null;
                this.tempTableAcSum = null;
                GLAcctAgeNewUtils.hmParamIn.clear();
                for (Map.Entry<String, String> entry : GLAcctAgeNewUtils.adjustRateInfoCache.entrySet()) {
                    String value22 = entry.getValue();
                    if (value22 == null) continue;
                    iPool.releaseTable(value22);
                }
                GLAcctAgeNewUtils.adjustRateInfoCache.clear();
                RptAgeCalculation.exchRateMapCache.clear();
                for (Map.Entry<String, String> entry : this.tempAcSumTableMap.entrySet()) {
                    value = entry.getValue();
                    if (value == null) continue;
                    iPool.releaseTable(value);
                }
                this.tempAcSumTableMap.clear();
                for (String string : tmpTabList) {
                    iPool.releaseTable(string);
                }
                continue;
            }
            iPool = TempTablePool.getInstance((Context)ctx);
            if (!StringUtils.isEmpty((String)this.acTmpTable)) {
                iPool.releaseTable(this.acTmpTable);
            }
            if (!StringUtils.isEmpty((String)this.tempTableComVeriMode)) {
                iPool.releaseTable(this.tempTableComVeriMode);
            }
            this.acTmpTable = null;
            this.tempTableComVeriMode = null;
            this.tempTableAcSum = null;
            GLAcctAgeNewUtils.hmParamIn.clear();
            for (Map.Entry<String, String> entry : GLAcctAgeNewUtils.adjustRateInfoCache.entrySet()) {
                value = entry.getValue();
                if (value == null) continue;
                iPool.releaseTable(value);
            }
            GLAcctAgeNewUtils.adjustRateInfoCache.clear();
            RptAgeCalculation.exchRateMapCache.clear();
            for (Map.Entry<String, String> entry : this.tempAcSumTableMap.entrySet()) {
                value = entry.getValue();
                if (value == null) continue;
                iPool.releaseTable(value);
            }
            this.tempAcSumTableMap.clear();
            for (String string : tmpTabList) {
                iPool.releaseTable(string);
            }
        }
        queryMap = (Map)params.get("queryParam_Rel");
        for (Date historyDate22 : queryMap.keySet()) {
            pMap = (Map)queryMap.get(historyDate22);
            queryParamMap = this.initAccountAgeParam2(ctx, pMap, historyDate22, _company);
            acctAndActTable = new HashMap();
            acTableMap = new HashMap();
            for (Map.Entry entry : queryParamMap.entrySet()) {
                String string = (String)entry.getKey();
                acTable = null;
                value2 = (AccountAgeParam)entry.getValue();
                if (acTableMap.containsKey(value2)) {
                    acTable = (String)acTableMap.get(value2);
                } else {
                    acTable = this.queryRptByBal(value2);
                    acTableMap.put(value2, acTable);
                }
                acctAndActTable.put(string, acTable);
                tmpTabList.add(acTable);
                this.acTmpTable = null;
            }
            try {
                String key2 = null;
                RptAgeCalculation rptAgeCalculation = new RptAgeCalculation();
                for (String key2 : pMap.keySet()) {
                    if ("companyids".equals(key2) || "accountids".equals(key2) || "isIncludeVerifyVch".equals(key2)) continue;
                    try {
                        accountAgeParam = (AccountAgeParam)pMap.get(key2);
                        asstItemKey = this.getAsstItemKey(accountAgeParam);
                        if (useNewAgeCalcMode) {
                            accountIds = accountAgeParam.getAccountid();
                            if (accountIds == null || "".equals(accountIds)) continue;
                            accountIdArray = accountIds.split(",");
                            queryRptAge = rptAgeCalculation.queryRptAge(accountAgeParam, (String)acctAndActTable.get(accountIdArray[0] + asstItemKey));
                            result.put(key2, queryRptAge);
                            continue;
                        }
                        accountIds = accountAgeParam.getAccountid();
                        if (accountIds == null || "".equals(accountIds)) continue;
                        accountIdArray = accountIds.split(",");
                        rowset = this.queryRptAgeByBal(accountAgeParam, (String)acctAndActTable.get(accountIdArray[0] + asstItemKey));
                        result.put(key2, rowset);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        result.put(key2, "error");
                    }
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"calc age error.", (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    TempTablePool iPool2 = TempTablePool.getInstance((Context)ctx);
                    if (!StringUtils.isEmpty((String)this.acTmpTable)) {
                        iPool2.releaseTable(this.acTmpTable);
                    }
                    if (!StringUtils.isEmpty((String)this.tempTableComVeriMode)) {
                        iPool2.releaseTable(this.tempTableComVeriMode);
                    }
                    this.acTmpTable = null;
                    this.tempTableComVeriMode = null;
                    this.tempTableAcSum = null;
                    GLAcctAgeNewUtils.hmParamIn.clear();
                    for (Map.Entry<String, String> entry : GLAcctAgeNewUtils.adjustRateInfoCache.entrySet()) {
                        String value4 = entry.getValue();
                        if (value4 == null) continue;
                        iPool2.releaseTable(value4);
                    }
                    GLAcctAgeNewUtils.adjustRateInfoCache.clear();
                    RptAgeCalculation.exchRateMapCache.clear();
                    for (Map.Entry<String, String> entry : this.tempAcSumTableMap.entrySet()) {
                        String value4 = entry.getValue();
                        if (value4 == null) continue;
                        iPool2.releaseTable(value4);
                    }
                    this.tempAcSumTableMap.clear();
                    for (String tempTable : tmpTabList) {
                        iPool2.releaseTable(tempTable);
                    }
                    throw throwable;
                }
            }
            iPool = TempTablePool.getInstance((Context)ctx);
            if (!StringUtils.isEmpty((String)this.acTmpTable)) {
                iPool.releaseTable(this.acTmpTable);
            }
            if (!StringUtils.isEmpty((String)this.tempTableComVeriMode)) {
                iPool.releaseTable(this.tempTableComVeriMode);
            }
            this.acTmpTable = null;
            this.tempTableComVeriMode = null;
            this.tempTableAcSum = null;
            GLAcctAgeNewUtils.hmParamIn.clear();
            for (Map.Entry<String, String> entry : GLAcctAgeNewUtils.adjustRateInfoCache.entrySet()) {
                value = entry.getValue();
                if (value == null) continue;
                iPool.releaseTable(value);
            }
            GLAcctAgeNewUtils.adjustRateInfoCache.clear();
            RptAgeCalculation.exchRateMapCache.clear();
            for (Map.Entry<String, String> entry : this.tempAcSumTableMap.entrySet()) {
                value = entry.getValue();
                if (value == null) continue;
                iPool.releaseTable(value);
            }
            this.tempAcSumTableMap.clear();
            for (String string : tmpTabList) {
                iPool.releaseTable(string);
            }
        }
        long e = System.currentTimeMillis();
        logger.error((Object)("_batchQueryAge.cost-->" + (e - s)));
        logger.error((Object)("AccountAgeParam.size-->" + keys.size()));
        return result;
    }

    protected IRowSet queryRptAgeByBal(AccountAgeParam paramAge, String acTable) throws BOSException, EASBizException {
        paramAge.setRptQuery(true);
        if (!this.beforeVerifyRpt(paramAge)) {
            return null;
        }
        this.afterVerifyRpt(paramAge, acTable);
        return this.dealRptResult(paramAge);
    }

    private void afterVerifyRpt(AccountAgeParam paramAge, String acTable) throws BOSException, EASBizException {
        ArrayList alAcResult = new ArrayList();
        Statement ps = null;
        ResultSet rs = null;
        try {
            int iAdjust;
            int daylen = paramAge.getDaylen();
            int undaylen = paramAge.getUndaylen();
            this.tempTableAcSum = this.tempAcSumTableMap.get(paramAge.getSqlCreateHgTbl());
            if (this.tempTableAcSum == null) {
                this.createTempTable_ByBal_AcSum(paramAge);
                this.tempTableAcSum = paramAge.getTempTableAcSum();
            } else {
                paramAge.setTempTableAcSum(this.tempTableAcSum);
            }
            this.insertVerifiedRecordsToAcSumTable_Rpt(paramAge, acTable);
            if (paramAge.isGeneralCy()) {
                this.calculateLocalAmt4GeneralCy(paramAge);
                this.insertTotalSumLines4GeneralCurency(paramAge);
            }
            this.calculateSumallSumOverdue(paramAge.getTempTableAcSum(), daylen, true, paramAge);
            if (paramAge.isGeneralCy() && !paramAge.isAccountList() && (iAdjust = this.calculateLocalAmt4Deviation(paramAge)) != 0) {
                this.calculateSumallSumOverdue(paramAge.getTempTableAcSum(), daylen, true, paramAge);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            throw new SQLAccessException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, ps);
        }
    }

    private void getVerifiedRecords_AgeDays(AccountAgeParam paramAge, DataProcessEngine dataProcess) throws BOSException {
        StringBuilder vals = new StringBuilder();
        String selectorHg = paramAge.getSqlSelectorHgTbl().toString();
        vals.append(selectorHg).append("sumamt,days");
        String group = paramAge.getSqlGroupbyAge().toString();
        if (!StringUtils.isEmpty((String)group)) {
            group = group.indexOf("hgid") > 0 && !paramAge.isAccountList() ? group.substring(0, paramAge.getSqlGroupbyAge().lastIndexOf("hgid") - 1) : group.substring(0, group.lastIndexOf(","));
            group = group + ",fbizDate";
            group = group.replace("group by", "");
        }
        String[] groupByFieldArray = group.split(",");
        ArrayList<Field> groupByFields = new ArrayList<Field>(groupByFieldArray.length);
        for (String fieldName : groupByFieldArray) {
            fieldName = fieldName.trim();
            Field groupByField = null;
            groupByField = "fbizDate".equals(fieldName) ? FieldObjectFactory.getInstance(fieldName, FieldType.Date, fieldName) : FieldObjectFactory.getInstance(fieldName, FieldType.String, fieldName);
            groupByFields.add(groupByField);
        }
        ArrayList<FunctionField> sumFields = new ArrayList<FunctionField>(1);
        SumField sum0 = SumFieldObjectFactory.getInstance("FUnVerifiedAmtFor", FieldType.BigDecimal, "sumamt");
        sumFields.add(sum0);
        CommonFunction sumFunction = new CommonFunction(groupByFields, sumFields);
        DateDiffFunction dateDiffFunction = new DateDiffFunction();
        dateDiffFunction.setField(new Field("fbizDate", FieldType.Date, "days"));
        dateDiffFunction.setDateDiffType(DateDiffType.D);
        dataProcess.sum(sumFunction).dateDiff(dateDiffFunction, paramAge.getEndDate());
    }

    private void insertVerifiedRecordsToAcSumTable_AgeDays(AccountAgeParam paramAge, String acTable) throws BOSException {
        ArrayList param = new ArrayList();
        StringBuilder ageSql = new StringBuilder();
        StringBuilder vals = new StringBuilder();
        String selectorHg = paramAge.getSqlSelectorHgTbl().toString();
        vals.append(selectorHg).append("sumamt,days");
        if (!paramAge.isAccountList()) {
            selectorHg = selectorHg.replace("hgid", "N'' hgid");
            selectorHg = selectorHg.replaceAll("accountid|Taccountid", "N'' accountId");
        }
        ageSql.append("select \r\n");
        ageSql.append(selectorHg);
        ageSql.append("sum(FUnVerifiedAmtFor) as sumamt");
        ageSql.append(",datediff(dd,fbizDate,?) as days");
        ageSql.append(" from ").append(acTable).append(" cussent ");
        String group = paramAge.getSqlGroupbyAge().toString();
        if (!StringUtils.isEmpty((String)group)) {
            group = group.indexOf("hgid") > 0 && !paramAge.isAccountList() ? group.substring(0, paramAge.getSqlGroupbyAge().lastIndexOf("hgid") - 1) : group.substring(0, group.lastIndexOf(","));
        }
        ageSql.append(group).append(",fbizdate");
        String insertSql = "insert into " + paramAge.getTempTableAcSum() + " (" + vals + ") " + ageSql.toString();
        PreparedStatement ps = null;
        Connection con = null;
        try {
            con = this.getConnection(paramAge.getCtx());
            ps = con.prepareStatement(insertSql);
            ps.setDate(1, new java.sql.Date(paramAge.getEndDate().getTime()));
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private void insertVerifiedRecordsToAcSumTable_Rpt(AccountAgeParam paramAge, String acTable) throws BOSException {
        String amountFiled = "cussent.FUnVerifiedAmtFor";
        String dateFiled = paramAge.getStrDateType_AC();
        dateFiled = !"fenddate".equalsIgnoreCase(dateFiled.toLowerCase()) ? "cussent.fbizdate" : "cussent.fenddate";
        ArrayList param = new ArrayList();
        StringBuilder ageSql = new StringBuilder();
        ageSql.append("select \r\n");
        StringBuilder vals = new StringBuilder();
        vals.append(paramAge.getSqlSelecthgoutside());
        String selectorHg = paramAge.getSqlSelectorHgTbl().toString();
        selectorHg = selectorHg.replaceAll("cussent.hgid|hgid", "N'' hgid");
        ageSql.append(selectorHg);
        ageSql.append("\r\n sum(case when " + dateFiled + ">=? then isnull(").append(amountFiled).append(", 0) else 0 end) as sumUnOverDue  \r\n");
        vals.append(",sumUnOverDue");
        StringBuilder sumOnePhase = new StringBuilder(" ,sum(case when ").append(dateFiled).append("<? and ").append(dateFiled).append(">=? then ").append(amountFiled).append(" else 0 end) as sum");
        StringBuilder sumUnOnePhase = null;
        vals.append(",sum0 ");
        if (paramAge.isShowUmexpired()) {
            if (paramAge.getUndaylen() == 1) {
                sumUnOnePhase = new StringBuilder();
                sumUnOnePhase.append(",sum(case when ").append(dateFiled).append(">= ? then ").append(amountFiled).append(" else 0 end) as sum");
            } else {
                sumUnOnePhase = new StringBuilder(" ,sum(case when ").append(dateFiled).append(">=? and ").append(dateFiled).append("<=? then ").append(amountFiled).append(" else 0 end) as sum");
            }
            sumOnePhase = sumUnOnePhase;
        }
        ageSql.append((CharSequence)sumOnePhase).append("0 ");
        ageSql.append(" from ").append(acTable).append(" cussent ");
        GLAcctAgeNewUtils.getRptSql_ByAcctBal_AcNotInit_From(paramAge);
        GLAcctAgeNewUtils.getRptSql_ByAcctBal_AcNotInit_Where(paramAge);
        ageSql.append(paramAge.getSqlFromTable()).append(paramAge.getSqlInnerJoinRpt());
        ageSql.append(paramAge.getSqlWhereNotInit());
        String group = paramAge.getSqlGroupbyAge().toString();
        if (!StringUtils.isEmpty((String)group)) {
            group = group.indexOf("hgid") > 0 && !paramAge.isAccountList() ? group.substring(0, paramAge.getSqlGroupbyAge().lastIndexOf("hgid") - 1) : group.substring(0, group.lastIndexOf(","));
        }
        ageSql.append(group);
        String insertSql = "insert into " + paramAge.getTempTableAcSum() + " (" + vals + ") " + ageSql.toString();
        int i = 1;
        PreparedStatement ps = null;
        Connection con = null;
        try {
            con = this.getConnection(paramAge.getCtx());
            ps = con.prepareStatement(insertSql);
            ArrayList dateList = paramAge.getAlDates();
            for (java.sql.Date date : dateList) {
                ps.setDate(i++, date);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private Map<String, AccountAgeParam> initAccountAgeParam2(Context ctx, Map pMap, Date historyDate, CompanyOrgUnitInfo _company) {
        Iterator its = pMap.keySet().iterator();
        HashMap<String, AccountAgeParam> accountAgeParamMap = new HashMap<String, AccountAgeParam>();
        HashMap<String, Integer> accountDateType = new HashMap<String, Integer>();
        StringBuilder sb = new StringBuilder();
        Set companyids = (Set)pMap.get("companyids");
        String companyIdStr = null;
        if (companyids.size() > 0) {
            companyIdStr = SQLUtil.collection2InList(companyids);
            companyIdStr = companyIdStr.substring(1, companyIdStr.lastIndexOf(")"));
        }
        while (its.hasNext()) {
            String key = (String)its.next();
            if ("companyids".equals(key) || "accountids".equals(key) || "isIncludeVerifyVch".equals(key)) continue;
            AccountAgeParam rptQueryParam = (AccountAgeParam)pMap.get(key);
            String asstItemKey = this.getAsstItemKey(rptQueryParam);
            HashSet<String> accountIdSet = null;
            String accountIds = rptQueryParam.getAccountid();
            if (accountIds == null || "".equals(accountIds)) continue;
            AccountAgeParam ageParam = null;
            String[] accountIdArray = accountIds.split(",");
            accountIdSet = new HashSet<String>();
            for (String accountId : accountIdArray) {
                String groupKey = accountId + asstItemKey;
                if (accountAgeParamMap.containsKey(groupKey)) {
                    ageParam = (AccountAgeParam)accountAgeParamMap.get(groupKey);
                }
                accountIdSet.add(accountId);
                accountDateType.put(accountId, rptQueryParam.getDateType());
            }
            if (ageParam == null) {
                ageParam = new AccountAgeParam();
                ageParam.setHmItems(rptQueryParam.getHmItems());
                ageParam.setAccountDateType(accountDateType);
                ageParam.setAccountid(accountIds);
                ageParam.setCompanyId(companyIdStr == null ? "'" + rptQueryParam.getCompanyId() + "'" : companyIdStr);
                this.setCommonQueryParm(pMap, ageParam);
                ageParam.setCtx(ctx);
                ageParam.setCurCompanyid(_company.getId().toString());
                ageParam.setEndDate(historyDate);
                ageParam.setHistoryDate(historyDate);
                ageParam.put("isVerify", Boolean.TRUE);
                ageParam.put("accountSet", accountIdSet);
                ageParam.setIncludeUnPosted(rptQueryParam.isIncludeUnPosted());
            } else {
                ((Set)ageParam.get("accountSet")).addAll(accountIdSet);
            }
            Set accountSet = (Set)ageParam.get("accountSet");
            for (String id : accountSet) {
                sb.append(id).append(",");
                accountAgeParamMap.put(id + asstItemKey, ageParam);
            }
            ageParam.setAccountid(sb.deleteCharAt(sb.length() - 1).toString());
            sb.setLength(0);
        }
        return accountAgeParamMap;
    }

    private String getAsstItemKey(AccountAgeParam rptQueryParam) {
        HashMap hmItems = rptQueryParam.getHmItems();
        Iterator itemkeyit = hmItems.keySet().iterator();
        String asstItemKey = "";
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            String fieldName = item.get("fieldname").toString();
            asstItemKey = asstItemKey + fieldName;
        }
        return asstItemKey;
    }

    private Map<String, AccountAgeParam> initAccountAgeParam(Context ctx, Map pMap, Date historyDate, CompanyOrgUnitInfo _company) {
        Iterator its = pMap.keySet().iterator();
        HashMap<String, AccountAgeParam> accountAgeParamMap = new HashMap<String, AccountAgeParam>();
        HashMap<String, Integer> accountDateType = new HashMap<String, Integer>();
        while (its.hasNext()) {
            String[] accountIdArray;
            AccountAgeParam rptQueryParam;
            String accountIds;
            String key = (String)its.next();
            if ("companyids".equals(key) || "accountids".equals(key) || "isIncludeVerifyVch".equals(key) || (accountIds = (rptQueryParam = (AccountAgeParam)pMap.get(key)).getAccountid()) == null || "".equals(accountIds)) continue;
            for (String accountId : accountIdArray = accountIds.split(",")) {
                if (accountAgeParamMap.containsKey(accountId)) continue;
                accountDateType.put(accountId, rptQueryParam.getDateType());
                AccountAgeParam ageParam = new AccountAgeParam();
                ageParam.setHmItems(rptQueryParam.getHmItems());
                ageParam.setAccountDateType(accountDateType);
                ageParam.setAccountid(accountId);
                ageParam.setCompanyId("'" + rptQueryParam.getCompanyId() + "'");
                this.setCommonQueryParm(pMap, ageParam);
                ageParam.setCtx(ctx);
                ageParam.setCurCompanyid(_company.getId().toString());
                ageParam.setEndDate(historyDate);
                ageParam.setHistoryDate(historyDate);
                ageParam.put("isVerify", Boolean.TRUE);
                accountAgeParamMap.put(accountId, ageParam);
            }
        }
        return accountAgeParamMap;
    }

    private AccountAgeParam initAccountAgeParam(Map pMap) {
        AccountAgeParam queryParam = new AccountAgeParam();
        Iterator its = pMap.keySet().iterator();
        HashMap<String, Integer> accountDateType = new HashMap<String, Integer>();
        while (its.hasNext()) {
            String[] accountIdArray;
            AccountAgeParam rptQueryParam;
            String accountIds;
            String key = (String)its.next();
            if ("companyids".equals(key) || "accountids".equals(key) || "isIncludeVerifyVch".equals(key) || (accountIds = (rptQueryParam = (AccountAgeParam)pMap.get(key)).getAccountid()) == null || "".equals(accountIds)) continue;
            for (String accountId : accountIdArray = accountIds.split(",")) {
                accountDateType.put(accountId, rptQueryParam.getDateType());
            }
        }
        queryParam.setAccountDateType(accountDateType);
        Set companyids = (Set)pMap.get("companyids");
        Set accountids = (Set)pMap.get("accountids");
        if (companyids.size() <= 500) {
            String companyId = SQLUtil.collection2InList(companyids);
            companyId = companyId.substring(1, companyId.lastIndexOf(")"));
            queryParam.setCompanyId(companyId);
        }
        if (accountids.size() <= 500) {
            String accountid = SQLUtil.collection2InList(accountids);
            accountid = accountid.substring(1, accountid.lastIndexOf(")"));
            queryParam.setAccountid(accountid);
        }
        queryParam.setCurrencyid("AllCurrency");
        queryParam.setShowUmexpired(false);
        queryParam.setIncludeUnPosted(true);
        queryParam.setIncludeInit(true);
        queryParam.setIncludeVerifyVch((Boolean)pMap.get("isIncludeVerifyVch"));
        queryParam.setBizCode(false);
        queryParam.setDateType(0);
        boolean indexType = false;
        queryParam.setIndexType(0);
        queryParam.setAccountFrom(null);
        queryParam.setAccountTo(null);
        queryParam.setIsOnlyUnion(false);
        queryParam.setAcctTableId(null);
        queryParam.setIndexType(0);
        queryParam.setHmItems(new HashMap());
        int[] days = new int[]{10000};
        queryParam.setDays(days);
        queryParam.setUndays(days);
        queryParam.setDaylen(1);
        queryParam.setUndaylen(1);
        return queryParam;
    }

    private void setCommonQueryParm(Map pMap, AccountAgeParam queryParam) {
        queryParam.setCurrencyid("AllCurrency");
        queryParam.setShowUmexpired(false);
        queryParam.setIncludeInit(true);
        queryParam.setIncludeVerifyVch((Boolean)pMap.get("isIncludeVerifyVch"));
        queryParam.setBizCode(false);
        queryParam.setDateType(0);
        boolean indexType = false;
        queryParam.setIndexType(0);
        queryParam.setAccountFrom(null);
        queryParam.setAccountTo(null);
        queryParam.setIsOnlyUnion(false);
        queryParam.setAcctTableId(null);
        queryParam.setIndexType(0);
        int[] days = new int[]{10000};
        queryParam.setDays(days);
        queryParam.setUndays(days);
        queryParam.setDaylen(1);
        queryParam.setUndaylen(1);
    }

    private void cacheCurData(Context ctx, String curId) throws BOSException, EASBizException {
        CurrencyInfo cur = null;
        if (curId == null) {
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyCollection currencys = icurrency.getCurrencyCollection();
            for (int i = 0; i < currencys.size(); ++i) {
                cur = currencys.get(i);
                GLAcctAgeNewUtils.cacheCurInfo(cur);
            }
        } else {
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            cur = icurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(curId));
            GLAcctAgeNewUtils.cacheCurInfo(cur);
        }
    }

    class QueryTask
    implements Runnable {
        AccountAgeParam paramAge;
        StringBuffer log = null;
        Map result;
        String key;

        public QueryTask(AccountAgeParam paramAge, StringBuffer log, Map result, String key) {
            this.paramAge = paramAge;
            this.log = log;
            this.result = result;
            this.key = key;
        }

        @Override
        public void run() {
            try {
                this.result.put(this.key, AccountAgeFacadeControllerBean.this.queryRptAgeByBal(this.paramAge));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                this.result.put(this.key, "error");
                e.printStackTrace();
            }
            finally {
                AccountAgeFacadeControllerBean.this.cdl.countDown();
            }
        }
    }
}

