/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AccountBalance1FFactory;
import com.kingdee.eas.fi.gl.AccountBalance1LFactory;
import com.kingdee.eas.fi.gl.AccountBalance1RFactory;
import com.kingdee.eas.fi.gl.AccountBalance5FFactory;
import com.kingdee.eas.fi.gl.AccountBalance5LFactory;
import com.kingdee.eas.fi.gl.AccountBalance5RFactory;
import com.kingdee.eas.fi.gl.AccountBalanceCollection;
import com.kingdee.eas.fi.gl.AccountBalanceInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLAsstBalanceCollection;
import com.kingdee.eas.fi.gl.GLAsstBalanceInfo;
import com.kingdee.eas.fi.gl.GLAsstBalanceKey;
import com.kingdee.eas.fi.gl.GLBalanceCollection;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceKey;
import com.kingdee.eas.fi.gl.GLBalanceKeyCPCT;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractAccountBalanceControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountBalanceControllerBean
extends AbstractAccountBalanceControllerBean {
    private static final long serialVersionUID = -6899280010209202976L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.AccountBalanceControllerBean");
    private static final int GROUP_NUM = 5;

    @Override
    public AccountBalanceCollection getAccountBalanceCollection(Context ctx) throws BOSException {
        return this.getAccountBalanceCollection(ctx, (EntityViewInfo)null);
    }

    @Override
    public AccountBalanceCollection getAccountBalanceCollection(Context ctx, EntityViewInfo view) throws BOSException {
        Map<String, Object> translate = GLBalanceUtils.translateEntityViewInfo(ctx, view);
        Integer baltype = (Integer)translate.get("baltype");
        String currencyId = (String)translate.get("currencyId");
        boolean isQueryCurrency = (Boolean)translate.get("isQueryCurrency");
        boolean isQueryPeriod = (Boolean)translate.get("isQueryPeriod");
        AbstractObjectCollection old = baltype == 1 ? ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) ? AccountBalance1LFactory.getLocalInstance(ctx).getAccountBalance1LCollection(view) : ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) ? AccountBalance1RFactory.getLocalInstance(ctx).getAccountBalance1RCollection(view) : AccountBalance1FFactory.getLocalInstance(ctx).getAccountBalance1FCollection(view))) : ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) ? AccountBalance5LFactory.getLocalInstance(ctx).getAccountBalance5LCollection(view) : ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) ? AccountBalance5RFactory.getLocalInstance(ctx).getAccountBalance5RCollection(view) : AccountBalance5FFactory.getLocalInstance(ctx).getAccountBalance5FCollection(view)));
        try {
            AccountBalanceCollection coll = new AccountBalanceCollection();
            CurrencyInfo currency = null;
            if (isQueryCurrency && ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId))) {
                currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            }
            for (int i = 0; i < old.size(); ++i) {
                Object o;
                AbstractObjectValue value = (AbstractObjectValue)old.getObject(i);
                AccountBalanceInfo info = new AccountBalanceInfo();
                info.putAll((IObjectValue)value);
                info.setBalType(VoucherStatusEnum.getEnum((int)baltype));
                if (currency != null) {
                    info.setCurrency(currency);
                }
                if (isQueryPeriod && (o = info.remove("period")) instanceof Integer) {
                    int ip = (Integer)o;
                    PeriodInfo p = new PeriodInfo();
                    p.setNumber(ip);
                    p.setPeriodYear(ip / 100);
                    p.setPeriodNumber(ip % 100);
                    info.put("period", p);
                }
                coll.add(info);
            }
            return coll;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public AccountBalanceCollection getAccountBalanceCollection(Context ctx, String oql) throws BOSException {
        EntityViewInfo view;
        try {
            view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return this.getAccountBalanceCollection(ctx, view);
    }

    @Override
    protected Map _getBalance(Context ctx, Map queryMap) throws BOSException {
        throw new BOSException("method getBalance has deleted.");
    }

    @Override
    protected Map _getBalanceBatch(Context ctx, Map queryMap) throws BOSException, EASBizException {
        HashMap<String, Map> resultBatch = new HashMap<String, Map>();
        Set keySet = queryMap.keySet();
        for (String key : keySet) {
            Map query = (Map)queryMap.get(key);
            Map result = this._getBalance(ctx, query);
            resultBatch.put(key, result);
        }
        return resultBatch;
    }

    @Override
    protected GLBalanceCollection _getDeficitBalance(Context ctx, VoucherInfo oldVoucher, VoucherInfo voucher) throws BOSException, EASBizException {
        boolean acAlert;
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("GL_013");
        keys.add("GL_073");
        Map params = GlUtils.getParamsByKeys(ctx, voucher.getCompany().getId().toString(), keys);
        int acMode = Integer.valueOf(String.valueOf(params.get("GL_073")));
        int cashMode = Integer.valueOf(params.get("GL_013").toString());
        boolean cashAlert = cashMode == 0 || cashMode == 1;
        boolean bl = acAlert = acMode == 0 || acMode == 1;
        if (!cashAlert && !acAlert) {
            return null;
        }
        GLBalanceCollection amount = this.createBalance(voucher, true, cashAlert, acAlert);
        if (oldVoucher != null && oldVoucher.getBizStatus() == VoucherStatusEnum.SUBMITTED) {
            GLBalanceCollection oldBalColl = this.createBalance(oldVoucher, true, cashAlert, acAlert);
            Iterator it = oldBalColl.iterator();
            while (it.hasNext()) {
                GLBalanceInfo oldBalInfo = (GLBalanceInfo)it.next();
                amount.subtract(oldBalInfo);
            }
        }
        if (amount.size() == 0) {
            return amount;
        }
        amount.addAll(this.genGLBalance(ctx, amount.getBalanceKeySet(), false, false));
        amount.addGLAsstBalanceCollection(this.genGLAsstBalance(ctx, amount.getAsstBalanceKeySet(), false, false));
        return amount.getDeficitBalance();
    }

    @Override
    protected GLBalanceCollection _getDeficitBalance(Context ctx, VoucherInfo oldVoucher, VoucherInfo voucher, int actionType) throws BOSException, EASBizException {
        boolean acAlert;
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("GL_013");
        keys.add("GL_073");
        Map params = GlUtils.getParamsByKeys(ctx, voucher.getCompany().getId().toString(), keys);
        int acMode = Integer.valueOf(String.valueOf(params.get("GL_073")));
        int cashMode = Integer.valueOf(params.get("GL_013").toString());
        boolean cashAlert = cashMode == 0 || cashMode == 1;
        boolean bl = acAlert = acMode == 0 || acMode == 1;
        if (!cashAlert && !acAlert) {
            return null;
        }
        GLBalanceCollection amount = this.createBalance(voucher, true, cashAlert, acAlert);
        if (oldVoucher != null && oldVoucher.getBizStatus() == VoucherStatusEnum.SUBMITTED && actionType == 0) {
            GLBalanceCollection oldBalColl = this.createBalance(oldVoucher, true, cashAlert, acAlert);
            Iterator it = oldBalColl.iterator();
            while (it.hasNext()) {
                GLBalanceInfo oldBalInfo = (GLBalanceInfo)it.next();
                amount.subtract(oldBalInfo);
            }
        }
        if (amount.size() == 0) {
            return amount;
        }
        if (actionType == 0) {
            amount.addAll(this.genGLBalance(ctx, amount.getBalanceKeySet(), false, false));
            amount.addGLAsstBalanceCollection(this.genGLAsstBalance(ctx, amount.getAsstBalanceKeySet(), false, false));
        } else if (actionType == 1) {
            amount.subtractBAll(this.genGLBalance(ctx, amount.getBalanceKeySet(), false, false));
            amount.subtractBGLAsstBalanceCollection(this.genGLAsstBalance(ctx, amount.getAsstBalanceKeySet(), false, false));
        }
        return amount.getDeficitBalance();
    }

    @Override
    protected GLBalanceCollection _getDeficitBalance(Context ctx, Set voucherIds, VoucherStatusEnum bizStatus) throws BOSException, EASBizException {
        boolean acAlert;
        if (voucherIds == null || voucherIds.isEmpty()) {
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("GL_013");
        keys.add("GL_073");
        Map params = GlUtils.getParamsByKeys(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), keys);
        int acMode = Integer.valueOf(String.valueOf(params.get("GL_073")));
        int cashMode = Integer.valueOf(params.get("GL_013").toString());
        boolean cashAlert = cashMode == 0 || cashMode == 1;
        boolean bl = acAlert = acMode == 0 || acMode == 1;
        if (!cashAlert && !acAlert) {
            return null;
        }
        GLBalanceCollection amount = this.getBalanceCollection(ctx, voucherIds, bizStatus, acAlert, cashAlert);
        if (amount.size() == 0) {
            return amount;
        }
        if (bizStatus != VoucherStatusEnum.SUBMITTED) {
            amount.addAll(this.genGLBalance(ctx, amount.getBalanceKeySet(), false, false));
            amount.addGLAsstBalanceCollection(this.genGLAsstBalance(ctx, amount.getAsstBalanceKeySet(), false, false));
        } else {
            amount.subtractBAll(this.genGLBalance(ctx, amount.getBalanceKeySet(), false, false));
            amount.subtractBGLAsstBalanceCollection(this.genGLAsstBalance(ctx, amount.getAsstBalanceKeySet(), false, false));
        }
        return amount.getDeficitBalance();
    }

    @Override
    protected GLBalanceCollection _getDeficitBalance(Context ctx, Set voucherIds, int action) throws BOSException, EASBizException {
        if (voucherIds == null || voucherIds.isEmpty()) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company"));
        view.setSelector(sic);
        VoucherCollection voucherCollection = new VoucherCollection();
        if (voucherIds.size() > 500) {
            ArrayList parts = new ArrayList();
            HashSet<String> part = new HashSet<String>();
            for (Object e : voucherIds) {
                part.add(e.toString());
                if (part.size() < 500) continue;
                parts.add(part);
                part = new HashSet();
            }
            if (part.size() > 0) {
                parts.add(part);
            }
            for (Set set : parts) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                view.setFilter(filterInfo);
                voucherCollection.addCollection(VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(view));
            }
        } else {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)voucherIds, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            voucherCollection.addCollection(VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(view));
        }
        HashMap companyToVoucherMap = new HashMap();
        for (VoucherInfo voucher : voucherCollection) {
            Set<String> voucherSet;
            String string = voucher.getCompany().getId().toString();
            if (companyToVoucherMap.containsKey(string)) {
                voucherSet = (Set)companyToVoucherMap.get(string);
                voucherSet.add(voucher.getId().toString());
                continue;
            }
            voucherSet = new HashSet();
            voucherSet.add(voucher.getId().toString());
            companyToVoucherMap.put(string, voucherSet);
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("GL_013");
        paramList.add("GL_073");
        ArrayList arrayList = ParamControlFactory.getLocalInstance((Context)ctx).getParamListPatch(paramList, new ArrayList(companyToVoucherMap.keySet()));
        HashMap companyToParamMap = new HashMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            ParamSimpleInfo param = (ParamSimpleInfo)arrayList.get(i);
            String orgId = param.getOrgUnitPK().toString();
            if (companyToParamMap.containsKey(orgId)) {
                ((Map)companyToParamMap.get(orgId)).put(param.getParamNumber(), param.getParamValue());
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(param.getParamNumber(), param.getParamValue());
            companyToParamMap.put(orgId, map);
        }
        for (String companyId : companyToVoucherMap.keySet()) {
            GLBalanceCollection deficitBalance;
            boolean acAlert;
            Map paramMap = (Map)companyToParamMap.get(companyId);
            int acMode = Integer.valueOf(String.valueOf(paramMap.get("GL_073")));
            int cashMode = Integer.valueOf((String)paramMap.get("GL_013"));
            boolean cashAlert = cashMode == 0;
            boolean bl = acAlert = acMode == 0;
            if (!cashAlert && !acAlert || (deficitBalance = this.getDeficitBalanceByVoucherIds(ctx, voucherIds = (Set)companyToVoucherMap.get(companyId), action, cashAlert, acAlert)) == null || deficitBalance.size() == 0) continue;
            return deficitBalance;
        }
        return new GLBalanceCollection();
    }

    private GLBalanceCollection getDeficitBalanceByVoucherIds(Context ctx, Set voucherIds, int action, boolean cashAlert, boolean acAlert) throws BOSException, EASBizException {
        GLBalanceCollection submitedAmount = new GLBalanceCollection();
        GLBalanceCollection amount = new GLBalanceCollection();
        if (action == 1) {
            GLBalanceInfo oldBalInfo;
            submitedAmount = this.getBalanceCollection(ctx, voucherIds, VoucherStatusEnum.SUBMITTED, acAlert, cashAlert);
            Iterator itr = submitedAmount.iterator();
            while (itr.hasNext()) {
                oldBalInfo = (GLBalanceInfo)itr.next();
                submitedAmount.subtract(oldBalInfo);
            }
            amount = this.getBalanceCollection(ctx, voucherIds, VoucherStatusEnum.TEMP, acAlert, cashAlert);
            itr = amount.iterator();
            while (itr.hasNext()) {
                oldBalInfo = (GLBalanceInfo)itr.next();
                submitedAmount.add(oldBalInfo);
            }
            amount = submitedAmount;
        } else if (action == 6) {
            amount = this.getBalanceCollection(ctx, voucherIds, VoucherStatusEnum.CANCELLED, acAlert, cashAlert);
        } else if (action == 7 || action == 5) {
            amount = this.getBalanceCollection(ctx, voucherIds, VoucherStatusEnum.SUBMITTED, acAlert, cashAlert);
        }
        if (amount.size() == 0) {
            return amount;
        }
        if (action == 1 || action == 6) {
            amount.addAll(this.genGLBalance(ctx, amount.getBalanceKeySet(), false, false));
            amount.addGLAsstBalanceCollection(this.genGLAsstBalance(ctx, amount.getAsstBalanceKeySet(), false, false));
        } else {
            amount.subtractBAll(this.genGLBalance(ctx, amount.getBalanceKeySet(), false, false));
            amount.subtractBGLAsstBalanceCollection(this.genGLAsstBalance(ctx, amount.getAsstBalanceKeySet(), false, false));
        }
        return amount.getDeficitBalance();
    }

    private GLBalanceCollection getBalanceCollection(Context ctx, Set voucherIds, VoucherStatusEnum bizStatus, boolean acAlert, boolean cashAlert) throws BOSException {
        Iterator it = voucherIds.iterator();
        int count = 0;
        HashSet<String> idSet = null;
        GLBalanceCollection amount = new GLBalanceCollection();
        while (it.hasNext()) {
            if (count % 100 == 0) {
                if (idSet != null && !idSet.isEmpty()) {
                    amount.addAll(this.getGLBalanceCollection(ctx, idSet, bizStatus, cashAlert, acAlert));
                }
                idSet = new HashSet<String>();
            }
            if (null != idSet) {
                idSet.add(it.next().toString());
            }
            ++count;
        }
        if (idSet != null && !idSet.isEmpty()) {
            amount.addAll(this.getGLBalanceCollection(ctx, idSet, bizStatus, cashAlert, acAlert));
        }
        return amount;
    }

    private GLBalanceCollection getGLBalanceCollection(Context ctx, Set idSet, VoucherStatusEnum bizStatus, boolean cashAlert, boolean acAlert) throws BOSException {
        GLBalanceCollection balColl = null;
        VoucherCollection voucherColl = this.getVoucherCollection(ctx, idSet, bizStatus, cashAlert, acAlert);
        for (int i = 0; i < voucherColl.size(); ++i) {
            if (balColl == null) {
                balColl = this.createBalance(voucherColl.get(i), true, cashAlert, acAlert);
                continue;
            }
            balColl.addAll(this.createBalance(voucherColl.get(i), true, cashAlert, acAlert));
        }
        return balColl;
    }

    private VoucherCollection doGetVoucherCollection(Context ctx, Set voucherIds, VoucherStatusEnum bizStatus, boolean cashAlert, boolean acAlert) throws BOSException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    v.FID, v.FCompanyID, v.FBizStatus, \n");
        sql.append("    p.FID FPeriodID, p.FPeriodYear, p.FPeriodNumber, p.FNumber FPNumber, \n");
        sql.append("    av.FID FAccountID, av.FNumber FAccountNumber, \n");
        sql.append("    av.FIsCash, av.FIsBank, av.FIsCashEquivalent, av.FAC, av.FDC, \n");
        sql.append("    ve.FID FEntryID, ve.FCAA, ve.FEntryDC, ve.FOriginalAmount FEntryOriginalAmount, ve.FLocalAmount FEntryLocalAmount, \n");
        sql.append("    cy.FID FCurrencyID, cy.FName_" + loc + " FCurrencyName, \n");
        sql.append("    r.FID FRecordID, r.FAssGrpID, r.FOriginalAmount FRecordOriginalAmount, r.FLocalAmount FRecordLocalAmount \n");
        sql.append("from T_GL_Voucher v \n");
        sql.append("join T_BD_Period p on p.FID = v.FPeriodID \n");
        sql.append("join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
        sql.append("join T_BD_AccountView av on av.FID = ve.FAccountID \n");
        sql.append("join T_BD_Currency cy on cy.FID = ve.FCurrencyID \n");
        sql.append("left join T_GL_VoucherAssistRecord r on r.FEntryID = ve.FID \n");
        sql.append("where v.FID in " + AccountBalanceControllerBean.buildMarkSQL(voucherIds.size()) + "\n");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.addAll(voucherIds);
        sql.append(" and v.FBizStatus = ? \n");
        params.add(new Integer(bizStatus.getValue()));
        if (cashAlert || acAlert) {
            sql.append(" and ( \n");
            if (cashAlert) {
                sql.append("    av.FIsCash = 1 or av.FIsBank = 1 or av.FIsCashEquivalent = 1 ");
            }
            if (acAlert) {
                if (cashAlert) {
                    sql.append(" or av.FAC = 1 \n");
                } else {
                    sql.append(" av.FAC = 1 \n");
                }
            }
            sql.append(" ) \n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            VoucherCollection vCol = new VoucherCollection();
            HashMap<String, VoucherInfo> vouchers = new HashMap<String, VoucherInfo>();
            HashMap<String, VoucherEntryInfo> entries = new HashMap<String, VoucherEntryInfo>();
            while (rs.next()) {
                String recordId;
                String entryId;
                VoucherEntryInfo entry;
                String voucherId = rs.getString("FID");
                VoucherInfo voucher = (VoucherInfo)vouchers.get(voucherId);
                if (voucher == null) {
                    String periodId;
                    voucher = new VoucherInfo();
                    voucher.setId(BOSUuid.read((String)voucherId));
                    voucher.setBizStatus(VoucherStatusEnum.getEnum((int)rs.getInt("FBizStatus")));
                    vouchers.put(voucherId, voucher);
                    String companyId = rs.getString("FCompanyID");
                    if (companyId != null) {
                        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                        company.setId(BOSUuid.read((String)companyId));
                        voucher.setCompany(company);
                    }
                    if ((periodId = rs.getString("FPeriodId")) != null) {
                        PeriodInfo period = new PeriodInfo();
                        period.setId(BOSUuid.read((String)periodId));
                        voucher.setPeriod(period);
                        period.setPeriodYear(rs.getInt("FPeriodYear"));
                        period.setPeriodNumber(rs.getInt("FPeriodNumber"));
                        period.setNumber(rs.getInt("FPNumber"));
                    }
                    vCol.add(voucher);
                }
                if ((entry = (VoucherEntryInfo)entries.get(entryId = rs.getString("FEntryID"))) == null) {
                    String currencyId;
                    String accountId;
                    entry = new VoucherEntryInfo();
                    entry.setId(BOSUuid.read((String)entryId));
                    entry.setEntryDC(EntryDC.getEnum((int)rs.getInt("FEntryDC")));
                    entry.setOriginalAmount(rs.getBigDecimal("FEntryOriginalAmount"));
                    entry.setLocalAmount(rs.getBigDecimal("FEntryLocalAmount"));
                    String caa = rs.getString("FCAA");
                    if (caa != null) {
                        AsstAccountInfo aa = new AsstAccountInfo();
                        aa.setId(BOSUuid.read((String)caa));
                        entry.setCAA(aa);
                    }
                    if ((accountId = rs.getString("FAccountID")) != null) {
                        AccountViewInfo account = new AccountViewInfo();
                        account.setId(BOSUuid.read((String)accountId));
                        account.setIsCash(rs.getInt("FIsCash") == 1);
                        account.setIsBank(rs.getInt("FIsBank") == 1);
                        account.setIsCashEquivalent(rs.getInt("FIsCashEquivalent") == 1);
                        account.setAC(rs.getInt("FAC") == 1);
                        account.setDC(BalanceDirectionEnum.getEnum((int)rs.getInt("FDC")));
                        account.setNumber(rs.getString("FAccountNumber"));
                        account.setCAA(entry.getCAA());
                        entry.setAccount(account);
                    }
                    if ((currencyId = rs.getString("FCurrencyID")) != null) {
                        CurrencyInfo currency = new CurrencyInfo();
                        currency.setId(BOSUuid.read((String)currencyId));
                        currency.setName(rs.getString("FCurrencyName"));
                        entry.setCurrency(currency);
                    }
                    entries.put(entryId, entry);
                    voucher.getEntries().add(entry);
                }
                if ((recordId = rs.getString("FRecordID")) == null) continue;
                VoucherAssistRecordInfo record = new VoucherAssistRecordInfo();
                record.setId(BOSUuid.read((String)recordId));
                String assGrpId = rs.getString("FAssGrpID");
                if (assGrpId != null) {
                    AssistantHGInfo hg = new AssistantHGInfo();
                    hg.setId(BOSUuid.read((String)assGrpId));
                    record.setAssGrp(hg);
                }
                record.setOriginalAmount(rs.getBigDecimal("FRecordOriginalAmount"));
                record.setLocalAmount(rs.getBigDecimal("FRecordLocalAmount"));
                entry.getAssistRecords().add(record);
            }
            return vCol;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String buildMarkSQL(int count) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        return "(" + sql.toString() + ")";
    }

    private VoucherCollection getVoucherCollection(Context ctx, Set voucherIds, VoucherStatusEnum bizStatus, boolean cashAlert, boolean acAlert) throws BOSException {
        if (voucherIds.size() > 0) {
            ArrayList parts = new ArrayList();
            HashSet<String> part = new HashSet<String>();
            for (Object voucherId : voucherIds) {
                part.add(voucherId.toString());
                if (part.size() < 100) continue;
                parts.add(part);
                part = new HashSet();
            }
            if (part.size() > 0) {
                parts.add(part);
            }
            if (parts.size() == 1) {
                return this.doGetVoucherCollection(ctx, (Set)parts.get(0), bizStatus, cashAlert, acAlert);
            }
            VoucherCollection vCol = new VoucherCollection();
            for (Set set : parts) {
                vCol.addCollection(this.doGetVoucherCollection(ctx, set, bizStatus, cashAlert, acAlert));
            }
            return vCol;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection src = view.getSelector();
        src.add(new SelectorItemInfo("bill.id"));
        src.add(new SelectorItemInfo("bill.company.id"));
        src.add(new SelectorItemInfo("bill.period.id"));
        src.add(new SelectorItemInfo("bill.period.periodYear"));
        src.add(new SelectorItemInfo("bill.period.periodNumber"));
        src.add(new SelectorItemInfo("bill.period.number"));
        src.add(new SelectorItemInfo("bill.bizStatus"));
        src.add(new SelectorItemInfo("id"));
        src.add(new SelectorItemInfo("CAA"));
        src.add(new SelectorItemInfo("account.id"));
        src.add(new SelectorItemInfo("account.isCash"));
        src.add(new SelectorItemInfo("account.isBank"));
        src.add(new SelectorItemInfo("account.isCashEquivalent"));
        src.add(new SelectorItemInfo("account.CAA.id"));
        src.add(new SelectorItemInfo("account.AC"));
        src.add(new SelectorItemInfo("account.DC"));
        src.add(new SelectorItemInfo("account.number"));
        src.add(new SelectorItemInfo("currency.id"));
        src.add(new SelectorItemInfo("currency.name"));
        src.add(new SelectorItemInfo("entryDC"));
        src.add(new SelectorItemInfo("originalAmount"));
        src.add(new SelectorItemInfo("localAmount"));
        src.add(new SelectorItemInfo("assistRecords.id"));
        src.add(new SelectorItemInfo("assistRecords.assGrp.id"));
        src.add(new SelectorItemInfo("assistRecords.originalAmount"));
        src.add(new SelectorItemInfo("assistRecords.localAmount"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)voucherIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bill.bizStatus", (Object)new Integer(bizStatus.getValue())));
        Integer ONE = new Integer(1);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#0 and #1 and (");
        if (cashAlert) {
            filter.getFilterItems().add(new FilterItemInfo("account.isCash", (Object)ONE));
            filter.getFilterItems().add(new FilterItemInfo("account.isBank", (Object)ONE));
            filter.getFilterItems().add(new FilterItemInfo("account.isCashEquivalent", (Object)ONE));
            stringBuffer.append("#2 or #3 or #4");
        }
        if (acAlert) {
            filter.getFilterItems().add(new FilterItemInfo("account.AC", (Object)ONE));
            if (cashAlert) {
                stringBuffer.append(" or #5");
            } else {
                stringBuffer.append("#2");
            }
        }
        stringBuffer.append(")");
        filter.setMaskString(stringBuffer.toString());
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("bill.id"));
        VoucherEntryCollection entryColl = VoucherEntryFactory.getLocalInstance(ctx).getVoucherEntryCollection(view);
        return this.toVoucherCollection(entryColl);
    }

    private VoucherCollection toVoucherCollection(VoucherEntryCollection entryColl) {
        VoucherCollection voucherColl = new VoucherCollection();
        VoucherEntryInfo entry = null;
        VoucherInfo voucher = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entry = entryColl.get(i);
            if (voucher == null || !voucher.getId().equals((Object)entry.getBill().getId())) {
                voucher = entry.getBill();
                voucherColl.add(voucher);
            }
            voucher.getEntries().add(entry);
        }
        return voucherColl;
    }

    @Override
    protected GLBalanceInfo _getGLAccountBalance(Context ctx, VoucherInfo oldVoucher, VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency, boolean queryDebit, boolean queryCredit, boolean isEdit) throws BOSException, EASBizException {
        if (voucher == null || account == null || currency == null) {
            throw new BOSException("The voucher or account or currency is empty!");
        }
        GLBalanceInfo bal = this.createAccountBalance(voucher, account, currency, isEdit);
        if (isEdit && oldVoucher != null && oldVoucher.getBizStatus() == VoucherStatusEnum.SUBMITTED && oldVoucher.getPeriod().getId().equals((Object)voucher.getPeriod().getId())) {
            bal.subtract(this.createAccountBalance(oldVoucher, account, currency, isEdit));
        }
        GLBalanceKey key = bal.getKey();
        GLBalanceKeyCPCT cpct = new GLBalanceKeyCPCT(key);
        GLBalanceCollection coll = this.genAccountBalance(ctx, cpct, queryDebit, queryCredit);
        bal.add(coll.getGLBalanceInfo(key));
        return bal;
    }

    @Override
    protected GLAsstBalanceInfo _getGLAsstBalance(Context ctx, VoucherInfo oldVoucher, VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency, AssistantHGInfo hg, boolean queryDebit, boolean queryCredit, boolean isEdit) throws BOSException, EASBizException {
        if (voucher == null || account == null || currency == null || hg == null) {
            throw new BOSException("The voucher or account or currency or hg is empty!");
        }
        GLAsstBalanceInfo bal = this.createAssistBalance(voucher, account, currency, hg, isEdit);
        if (isEdit && oldVoucher != null && oldVoucher.getBizStatus() == VoucherStatusEnum.SUBMITTED && oldVoucher.getPeriod().getId().equals((Object)voucher.getPeriod().getId())) {
            bal.subtract(this.createAssistBalance(oldVoucher, account, currency, hg, isEdit));
        }
        GLAsstBalanceKey key = bal.getKey();
        GLBalanceKeyCPCT cpct = new GLBalanceKeyCPCT(key);
        GLAsstBalanceCollection coll = this.getAsstBalanceCollection(ctx, cpct, queryDebit, queryCredit);
        bal.add(coll.getGLAsstBalanceInfo(key));
        return bal;
    }

    private GLBalanceCollection genGLBalance(Context ctx, Set keySet, boolean queryDebit, boolean queryCredit) throws BOSException, EASBizException {
        GLBalanceCollection balColl = new GLBalanceCollection();
        GLBalanceKeyCPCT[] cpcts = GLBalanceKeyCPCT.getGLBalanceKeyCPCTs(keySet);
        for (int i = 0; i < cpcts.length; ++i) {
            balColl.addAll(this.genAccountBalance(ctx, cpcts[i], false, false));
        }
        return balColl;
    }

    private GLBalanceCollection createBalance(VoucherInfo voucher, boolean isEdit, boolean cashAlert, boolean acAlert) throws BOSException {
        GLBalanceCollection balColl = new GLBalanceCollection();
        Iterator entryIt = voucher.getEntries().iterator();
        VoucherEntryInfo entry = null;
        Object recordInfo = null;
        AccountViewInfo account = null;
        CurrencyInfo currency = null;
        GLBalanceInfo balInfo = null;
        Object asstBalInfo = null;
        while (entryIt.hasNext()) {
            entry = (VoucherEntryInfo)entryIt.next();
            account = entry.getAccount();
            currency = entry.getCurrency();
            if ((account == null || currency == null || !cashAlert || !account.isIsCash() && !account.isIsBank() && !account.isIsCashEquivalent()) && (account == null || !acAlert || !account.isAC())) continue;
            balInfo = this.createGLBalanceInfo(voucher, entry, isEdit);
            if (entry.getCAA() != null) {
                balInfo.addGLAsstBalCollection(this.createGLAsstBalanceCollection(voucher, entry, isEdit));
            }
            balColl.add(balInfo);
        }
        return balColl;
    }

    private GLAsstBalanceCollection createGLAsstBalanceCollection(VoucherInfo voucher, VoucherEntryInfo entry, boolean isEdit) throws BOSException {
        GLAsstBalanceCollection balColl = new GLAsstBalanceCollection();
        Iterator it = entry.getAssistRecords().iterator();
        VoucherAssistRecordInfo record = null;
        while (it.hasNext()) {
            record = (VoucherAssistRecordInfo)it.next();
            if (record.getAssGrp() == null) continue;
            balColl.add(this.createGLAsstBalanceInfo(voucher, entry, record, isEdit));
        }
        return balColl;
    }

    private GLBalanceInfo createAccountBalance(VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency, boolean isEdit) throws BOSException {
        if (account == null || currency == null) {
            return null;
        }
        Iterator entryIt = voucher.getEntries().iterator();
        VoucherEntryInfo entryInfo = null;
        Object recordInfo = null;
        AccountViewInfo accInfo = null;
        Object curInfo = null;
        GLBalanceInfo balInfo = this.createEmptyGLBalanceInfo(voucher, account, currency);
        if (!isEdit || voucher.getBizStatus() == VoucherStatusEnum.CANCELLED) {
            return balInfo;
        }
        while (entryIt.hasNext()) {
            entryInfo = (VoucherEntryInfo)entryIt.next();
            accInfo = entryInfo.getAccount();
            if (accInfo == null || !accInfo.getId().equals((Object)account.getId()) || entryInfo.getCurrency() == null || !entryInfo.getCurrency().getId().equals((Object)currency.getId())) continue;
            balInfo.add(this.createGLBalanceInfo(voucher, entryInfo, true));
        }
        return balInfo;
    }

    private GLAsstBalanceInfo createAssistBalance(VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency, AssistantHGInfo hg, boolean isEdit) throws BOSException {
        if (account == null || currency == null || hg == null) {
            return null;
        }
        Iterator entryIt = voucher.getEntries().iterator();
        VoucherEntryInfo entryInfo = null;
        VoucherAssistRecordInfo recordInfo2 = null;
        AccountViewInfo accInfo = null;
        Object curInfo = null;
        GLAsstBalanceInfo balInfo = this.createEmptyGLAsstBalanceInfo(voucher, account, currency, hg);
        if (!isEdit || voucher.getBizStatus() == VoucherStatusEnum.CANCELLED) {
            return balInfo;
        }
        while (entryIt.hasNext()) {
            entryInfo = (VoucherEntryInfo)entryIt.next();
            accInfo = entryInfo.getAccount();
            if (accInfo == null || accInfo.getCAA() == null || !accInfo.getId().equals((Object)account.getId()) || entryInfo.getCurrency() == null || !entryInfo.getCurrency().getId().equals((Object)currency.getId())) continue;
            for (VoucherAssistRecordInfo recordInfo2 : entryInfo.getAssistRecords()) {
                if (recordInfo2.getAssGrp() == null || !recordInfo2.getAssGrp().getId().equals((Object)hg.getId())) continue;
                balInfo.add(this.createGLAsstBalanceInfo(voucher, entryInfo, recordInfo2, isEdit));
            }
        }
        return balInfo;
    }

    private GLAsstBalanceInfo createGLAsstBalanceInfo(VoucherInfo voucher, VoucherEntryInfo entryInfo, VoucherAssistRecordInfo recordInfo, boolean isEdit) throws BOSException {
        GLAsstBalanceKey key = new GLAsstBalanceKey(voucher.getCompany(), entryInfo.getAccount(), entryInfo.getCurrency(), voucher.getPeriod(), recordInfo.getAssGrp(), voucher.getBizStatus() == VoucherStatusEnum.POSTED ? 5 : 1);
        GLAsstBalanceInfo asstBalInfo = new GLAsstBalanceInfo(key);
        if (!isEdit) {
            return asstBalInfo;
        }
        if (entryInfo.getEntryDC() == EntryDC.CREDIT) {
            if (recordInfo.getOriginalAmount() != null) {
                asstBalInfo.setCreditFor(recordInfo.getOriginalAmount());
                asstBalInfo.setOrigAmount(recordInfo.getOriginalAmount().negate());
            }
            if (recordInfo.getLocalAmount() != null) {
                asstBalInfo.setCreditLocal(recordInfo.getLocalAmount());
                asstBalInfo.setLocalAmount(recordInfo.getLocalAmount().negate());
            }
        } else {
            if (recordInfo.getOriginalAmount() != null) {
                asstBalInfo.setDebitFor(recordInfo.getOriginalAmount());
                asstBalInfo.setOrigAmount(recordInfo.getOriginalAmount());
            }
            if (recordInfo.getLocalAmount() != null) {
                asstBalInfo.setDebitLocal(recordInfo.getLocalAmount());
                asstBalInfo.setLocalAmount(recordInfo.getLocalAmount());
            }
        }
        return asstBalInfo;
    }

    private GLBalanceInfo createGLBalanceInfo(VoucherInfo voucher, VoucherEntryInfo entryInfo, boolean isEdit) throws BOSException {
        GLBalanceKey key = new GLBalanceKey(voucher.getCompany(), entryInfo.getAccount(), entryInfo.getCurrency(), voucher.getPeriod(), voucher.getBizStatus() == VoucherStatusEnum.POSTED ? 5 : 1);
        GLBalanceInfo balInfo = new GLBalanceInfo(key);
        if (!isEdit) {
            return balInfo;
        }
        if (entryInfo.getEntryDC() == EntryDC.CREDIT) {
            if (entryInfo.getOriginalAmount() != null) {
                balInfo.setCreditFor(entryInfo.getOriginalAmount());
                balInfo.setOrigAmount(entryInfo.getOriginalAmount().negate());
            }
            if (entryInfo.getLocalAmount() != null) {
                balInfo.setCreditLocal(entryInfo.getLocalAmount());
                balInfo.setLocalAmount(entryInfo.getLocalAmount().negate());
            }
        } else {
            if (entryInfo.getOriginalAmount() != null) {
                balInfo.setDebitFor(entryInfo.getOriginalAmount());
                balInfo.setOrigAmount(entryInfo.getOriginalAmount());
            }
            if (entryInfo.getLocalAmount() != null) {
                balInfo.setDebitLocal(entryInfo.getLocalAmount());
                balInfo.setLocalAmount(entryInfo.getLocalAmount());
            }
        }
        return balInfo;
    }

    private GLBalanceInfo createEmptyGLBalanceInfo(VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency) throws BOSException {
        GLBalanceKey key = new GLBalanceKey(voucher.getCompany(), account, currency, voucher.getPeriod(), voucher.getBizStatus() == VoucherStatusEnum.POSTED ? 5 : 1);
        return new GLBalanceInfo(key);
    }

    private GLAsstBalanceInfo createEmptyGLAsstBalanceInfo(VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency, AssistantHGInfo hg) throws BOSException {
        GLAsstBalanceKey key = new GLAsstBalanceKey(voucher.getCompany(), account, currency, voucher.getPeriod(), hg, voucher.getBizStatus() == VoucherStatusEnum.POSTED ? 5 : 1);
        return new GLAsstBalanceInfo(key);
    }

    private GLBalanceCollection genAccountBalance(Context ctx, GLBalanceKeyCPCT cpct, boolean queryDebit, boolean queryCredit) throws BOSException, EASBizException {
        GLBalanceCollection newBalColl = new GLBalanceCollection();
        if (cpct == null || cpct.getAccountViweCollection().size() == 0) {
            return newBalColl;
        }
        StringBuffer inSql = new StringBuffer();
        ArrayList<String> inParams = new ArrayList<String>();
        Iterator it = cpct.getAccountViweCollection().iterator();
        while (it.hasNext()) {
            if (inSql.length() > 0) {
                inSql.append(",");
            }
            inSql.append("?");
            inParams.add(((AccountViewInfo)it.next()).getId().toString());
        }
        PeriodInfo currPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(SystemEnum.GENERALLEDGER.getValue(), cpct.getCompany().getId().toString());
        ArrayList params = new ArrayList();
        String sql = this.getGLAccountBalanceSQL(cpct, inSql.toString(), params, inParams, currPeriod, queryDebit, queryCredit);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                newBalColl.addAll(this.createGLBalanceInfo(ctx, cpct, queryDebit, queryCredit, rs));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return newBalColl;
    }

    private GLBalanceCollection createGLBalanceInfo(Context ctx, GLBalanceKeyCPCT cpct, boolean queryDebit, boolean queryCredit, IRowSet rs) throws SQLException, BOSException {
        GLBalanceCollection balColl = new GLBalanceCollection();
        String accountId = rs.getString("faccountid");
        AccountViewInfo account = cpct.getAccountViweCollection().get((Object)BOSUuid.read((String)accountId));
        GLBalanceKey key = new GLBalanceKey(cpct.getCompany(), account, cpct.getCurrency(), cpct.getPeriod(), cpct.getBalType());
        GLBalanceInfo balInfo = new GLBalanceInfo(key);
        if (queryDebit) {
            balInfo.setDebitFor(rs.getBigDecimal("fdebitfor"));
            balInfo.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
        }
        if (queryCredit) {
            balInfo.setCreditFor(rs.getBigDecimal("fcreditfor"));
            balInfo.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
        }
        balInfo.setOrigAmount(rs.getBigDecimal("origAmount"));
        balInfo.setLocalAmount(rs.getBigDecimal("localAmount"));
        balColl.add(balInfo);
        return balColl;
    }

    private GLAsstBalanceCollection createGLAsstBalanceInfo(Context ctx, GLBalanceKeyCPCT cpct, boolean queryDebit, boolean queryCredit, IRowSet rs) throws SQLException, BOSException {
        GLAsstBalanceCollection balColl = new GLAsstBalanceCollection();
        String accountId = rs.getString("faccountid");
        String hgId = rs.getString("fassistgrpid");
        AccountViewInfo account = cpct.getAccountViweCollection().get((Object)BOSUuid.read((String)accountId));
        if (account == null) {
            return null;
        }
        AssistantHGCollection hgColl = cpct.getAssistantHGCollection(account.getId());
        if (hgColl == null || hgColl.isEmpty()) {
            return null;
        }
        AssistantHGInfo hgInfo = hgColl.get((Object)BOSUuid.read((String)hgId));
        if (hgInfo == null) {
            hgInfo = hgColl.get((Object)hgId);
        }
        if (hgInfo == null) {
            return null;
        }
        GLAsstBalanceKey key = new GLAsstBalanceKey(cpct.getCompany(), account, cpct.getCurrency(), cpct.getPeriod(), hgInfo, cpct.getBalType());
        GLAsstBalanceInfo balInfo = new GLAsstBalanceInfo(key);
        if (queryDebit) {
            balInfo.setDebitFor(rs.getBigDecimal("fdebitfor"));
            balInfo.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
        }
        if (queryCredit) {
            balInfo.setCreditFor(rs.getBigDecimal("fcreditfor"));
            balInfo.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
        }
        balInfo.setOrigAmount(rs.getBigDecimal("origAmount"));
        balInfo.setLocalAmount(rs.getBigDecimal("localAmount"));
        balColl.add(balInfo);
        return balColl;
    }

    private GLAsstBalanceCollection genGLAsstBalance(Context ctx, Set keySet, boolean queryDebit, boolean queryCredit) throws BOSException, EASBizException {
        if (keySet == null || keySet.isEmpty()) {
            return null;
        }
        GLAsstBalanceCollection balColl = new GLAsstBalanceCollection();
        GLBalanceKeyCPCT[] cpcts = GLBalanceKeyCPCT.getGLAsstBalanceKeyCPCTs(keySet);
        for (int i = 0; i < cpcts.length; ++i) {
            balColl.addAll(this.getAsstBalanceCollection(ctx, cpcts[i], false, false));
        }
        return balColl;
    }

    private GLAsstBalanceCollection getAsstBalanceCollection(Context ctx, GLBalanceKeyCPCT cpct, boolean queryDebit, boolean queryCredit) throws BOSException, EASBizException {
        GLAsstBalanceCollection newBalColl = new GLAsstBalanceCollection();
        if (cpct == null || cpct.getAccountViweCollection().size() == 0) {
            return newBalColl;
        }
        PeriodInfo currPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(SystemEnum.GENERALLEDGER.getValue(), cpct.getCompany().getId().toString());
        AccountViewCollection accountColl = cpct.getAccountViweCollection();
        Iterator accountIdListsIt = this.groupAccountIdList(accountColl).iterator();
        while (accountIdListsIt.hasNext()) {
            newBalColl.addAll(this.getAsstBalanceCollection(ctx, (List)accountIdListsIt.next(), cpct, currPeriod, queryDebit, queryCredit));
        }
        return newBalColl;
    }

    private GLAsstBalanceCollection getAsstBalanceCollection(Context ctx, List accountIdList, GLBalanceKeyCPCT cpct, PeriodInfo currPeriod, boolean queryDebit, boolean queryCredit) throws BOSException, EASBizException {
        GLAsstBalanceCollection balColl = new GLAsstBalanceCollection();
        int accountNum = accountIdList.size();
        String[] accountIds = new String[accountNum];
        String[] inSqls = new String[accountNum];
        List[] inParams = new List[accountNum];
        Object account = null;
        AssistantHGCollection hgColl = null;
        for (int i = 0; i < accountNum; ++i) {
            BOSUuid accountId = (BOSUuid)accountIdList.get(i);
            hgColl = cpct.getAssistantHGCollection(accountId);
            if (hgColl == null || hgColl.isEmpty()) continue;
            StringBuffer inSql = new StringBuffer();
            ArrayList<String> inParam = new ArrayList<String>();
            for (int j = 0; j < hgColl.size(); ++j) {
                if (inSql.length() > 0) {
                    inSql.append(",");
                }
                inSql.append("?");
                inParam.add(hgColl.get(j).getId().toString());
            }
            accountIds[i] = accountId.toString();
            inSqls[i] = inSql.toString();
            inParams[i] = inParam;
        }
        ArrayList params = new ArrayList();
        String sql = this.getGLAsstBalanceSQL(ctx, cpct, params, accountIds, inSqls, inParams, currPeriod, queryDebit, queryCredit);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                balColl.addAll(this.createGLAsstBalanceInfo(ctx, cpct, queryDebit, queryCredit, rs));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return balColl;
    }

    private List groupAccountIdList(AccountViewCollection accountColl) {
        ArrayList accountIdsList = new ArrayList();
        ArrayList<BOSUuid> accountIds = null;
        for (int i = 0; i < accountColl.size(); ++i) {
            if (accountIds == null || accountIds.size() >= 5) {
                accountIds = new ArrayList<BOSUuid>();
                accountIdsList.add(accountIds);
            }
            accountIds.add(accountColl.get(i).getId());
        }
        return accountIdsList;
    }

    private String getGLAccountBalanceSQL(GLBalanceKeyCPCT cpct, String inSql, ArrayList params, ArrayList inParams, PeriodInfo currPeriod, boolean queryDebit, boolean queryCredit) {
        if (cpct.getPeriod().getPeriodYear() * 100 + cpct.getPeriod().getPeriodNumber() > currPeriod.getNumber()) {
            return this.getLaterAccountBalanceSQL(cpct.getCompany().getId().toString(), cpct.getPeriod(), cpct.getCurrency().getId().toString(), cpct.getBalType(), inSql, params, inParams, currPeriod, queryDebit, queryCredit);
        }
        return this.getAccountBalanceSQL(cpct.getCompany().getId().toString(), cpct.getPeriod(), cpct.getCurrency().getId().toString(), cpct.getBalType(), inSql, params, inParams, queryDebit, queryCredit);
    }

    private String getGLAsstBalanceSQL(GLBalanceKeyCPCT cpct, List params, String[] accountIds, String[] inSqls, List[] inParams, PeriodInfo currPeriod, boolean queryDebit, boolean queryCredit) {
        return null;
    }

    private String getGLAsstBalanceSQL(Context ctx, GLBalanceKeyCPCT cpct, List params, String[] accountIds, String[] inSqls, List[] inParams, PeriodInfo currPeriod, boolean queryDebit, boolean queryCredit) throws BOSException {
        return cpct.getPeriod().getPeriodYear() * 100 + cpct.getPeriod().getPeriodNumber() > currPeriod.getNumber() ? this.getLaterAsstBalanceSQL(ctx, cpct.getCompany().getId().toString(), cpct.getPeriod(), cpct.getCurrency().getId().toString(), cpct.getBalType(), params, accountIds, inSqls, inParams, currPeriod, queryDebit, queryCredit) : this.getAsstBalanceSQL(ctx, cpct.getCompany().getId().toString(), cpct.getPeriod(), cpct.getCurrency().getId().toString(), cpct.getBalType(), params, accountIds, inSqls, inParams, queryDebit, queryCredit);
    }

    private String getAccountBalanceSQL(String companyId, PeriodInfo period, String currencyId, int balType, String inSql, ArrayList params, ArrayList inParams, boolean queryDebit, boolean queryCredit) {
        String T_BalanceTable = GLBalanceUtils.getBalanceTable(1, balType, currencyId);
        Integer periodNumber = new Integer(period.getPeriodYear() * 100 + period.getPeriodNumber());
        StringBuffer sql = new StringBuffer();
        sql.append("select t.faccountid, \r\n");
        if (queryDebit) {
            sql.append(" sum(t.fdebitfor) fdebitfor, sum(t.fdebitlocal) fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" sum(t.fcreditfor) fcreditfor, sum(t.fcreditlocal) fcreditlocal, \r\n");
        }
        sql.append(" sum(t.origAmount) origAmount, sum(t.localAmount) localAmount \r\n");
        sql.append(" from ( \r\n");
        sql.append(" select faccountid, \r\n");
        if (queryDebit) {
            sql.append(" fdebitfor, fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" fcreditfor, fcreditlocal, \r\n");
        }
        sql.append(" fendbalancefor origAmount, \r\n");
        sql.append(" fendbalancelocal localAmount \r\n");
        sql.append(" from " + T_BalanceTable + " \r\n");
        sql.append(" where forgunitid = ? and fcurrencyid = ? and fperiod = ? and faccountid in (");
        params.add(companyId);
        params.add(currencyId);
        params.add(periodNumber);
        sql.append(inSql.toString()).append(") \r\n");
        params.addAll(inParams);
        sql.append(" union all \r\n");
        sql.append(" select faccountid, \r\n");
        if (queryDebit) {
            sql.append(" isnull(fdebitfor,0) fdebitfor, isnull(fdebitlocal,0) fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" isnull(fcreditfor,0) fcreditfor, isnull(fcreditlocal,0) fcreditlocal, \r\n");
        }
        sql.append(" isnull(fdebitfor,0) - isnull(fcreditfor,0) origAmount, \r\n");
        sql.append(" isnull(fdebitlocal,0) - isnull(fcreditlocal,0) localAmount \r\n");
        sql.append(" from t_gl_voucher_log \r\n");
        sql.append(" where fcompanyid = ? and (fisupdating = 0 or fisupdating = 1) and fcurrencyid = ? and fperiodid = ? and fbaltype = ? and fisassist = 0 and faccountid in (");
        params.add(companyId);
        params.add(currencyId);
        params.add(period.getId().toString());
        params.add(new Integer(balType));
        sql.append(inSql.toString()).append(") \r\n");
        params.addAll(inParams);
        sql.append(" ) t \r\n");
        sql.append(" group by t.faccountid ");
        return sql.toString();
    }

    private String getLaterAccountBalanceSQL(String companyId, PeriodInfo period, String currencyId, int balType, String inSql, ArrayList params, ArrayList inParams, PeriodInfo currPeriod, boolean queryDebit, boolean queryCredit) {
        String T_BalanceTable = GLBalanceUtils.getBalanceTable(1, balType, currencyId);
        Integer periodNumber = new Integer(period.getPeriodYear() * 100 + period.getPeriodNumber());
        Integer currPeriodNumber = new Integer(currPeriod.getNumber());
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.faccountid, \r\n");
        if (queryDebit) {
            sql.append(" sum(t.fdebitfor) fdebitfor, sum(t.fdebitlocal) fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" sum(t.fcreditfor) fcreditfor, sum(t.fcreditlocal) fcreditlocal, \r\n");
        }
        sql.append(" sum(t.origAmount) origAmount, sum(t.localAmount) localAmount \r\n");
        sql.append(" from ( \r\n");
        sql.append(" select b.faccountid, \r\n");
        if (queryDebit) {
            sql.append(" case when b.fperiod = ? then b.fdebitfor else 0 end fdebitfor, \r\n");
            sql.append(" case when b.fperiod = ? then b.fdebitlocal else 0 end fdebitlocal, \r\n");
            params.add(periodNumber);
            params.add(periodNumber);
        }
        if (queryCredit) {
            sql.append(" case when b.fperiod = ? then b.fcreditfor else 0 end fcreditfor, \r\n");
            sql.append(" case when b.fperiod = ? then b.fcreditlocal else 0 end fcreditlocal, \r\n");
            params.add(periodNumber);
            params.add(periodNumber);
        }
        sql.append(" case when b.fperiod = ? then b.fendbalancefor else (b.fdebitfor - b.fcreditfor) end origAmount, \r\n");
        sql.append(" case when b.fperiod = ? then b.fendbalancelocal else (b.fdebitlocal - b.fcreditlocal) end localAmount \r\n");
        params.add(currPeriodNumber);
        params.add(currPeriodNumber);
        sql.append(" from " + T_BalanceTable + " b \r\n");
        sql.append(" where b.forgunitid = ? and b.fcurrencyid = ? and b.fperiod >= ? and b.fperiod <=? ");
        params.add(companyId);
        params.add(currencyId);
        params.add(currPeriodNumber);
        params.add(periodNumber);
        sql.append("and b.faccountid in (");
        sql.append(inSql).append(") \r\n");
        params.addAll(inParams);
        sql.append(" union all \r\n");
        sql.append(" select log.faccountid, \r\n");
        if (queryDebit) {
            sql.append(" case when pd.fnumber = ? then isnull(log.fdebitfor,0) else 0 end fdebitfor, \r\n");
            sql.append(" case when pd.fnumber = ? then isnull(log.fdebitlocal,0) else 0 end fdebitlocal, \r\n");
            params.add(periodNumber);
            params.add(periodNumber);
        }
        if (queryCredit) {
            sql.append(" case when pd.fnumber = ? then isnull(log.fcreditfor,0) else 0 end fcreditfor, \r\n");
            sql.append(" case when pd.fnumber = ? then isnull(log.fcreditlocal,0) else 0 end fcreditlocal, \r\n");
            params.add(periodNumber);
            params.add(periodNumber);
        }
        sql.append(" isnull(log.fdebitfor,0) - isnull(log.fcreditfor,0) origAmount, \r\n");
        sql.append(" isnull(log.fdebitlocal,0) - isnull(log.fcreditlocal,0) localAmount \r\n");
        sql.append(" from t_gl_voucher_log log \r\n");
        sql.append(" inner join t_bd_period pd on pd.fid = log.fperiodid \r\n");
        sql.append(" where log.fcompanyid = ? and (log.fisupdating = 0 or log.fisupdating = 1) and log.fcurrencyid = ? and pd.fnumber >= ? and pd.fnumber <= ? and log.fbaltype = ? and log.fisassist = 0 and log.faccountid in (");
        params.add(companyId);
        params.add(currencyId);
        params.add(currPeriodNumber);
        params.add(periodNumber);
        params.add(new Integer(balType));
        sql.append(inSql).append(") \r\n");
        params.addAll(inParams);
        sql.append(" ) t \r\n");
        sql.append(" group by t.faccountid ");
        return sql.toString();
    }

    private String getAsstBalanceSQL(String companyId, PeriodInfo period, String currencyId, int balType, List params, String[] accountIds, String[] inSqls, List[] inParams, boolean queryDebit, boolean queryCredit) {
        int i;
        String T_BalanceTable = GLBalanceUtils.getBalanceTable(2, balType, currencyId);
        Integer periodNumber = new Integer(period.getPeriodYear() * 100 + period.getPeriodNumber());
        StringBuffer sql = new StringBuffer();
        sql.append("select t.faccountid, t.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" sum(t.fdebitfor) fdebitfor, sum(t.fdebitlocal) fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" sum(t.fcreditfor) fcreditfor, sum(t.fcreditlocal) fcreditlocal, \r\n");
        }
        sql.append(" sum(t.origAmount) origAmount, \r\n");
        sql.append(" sum(t.localAmount) localAmount \r\n");
        sql.append(" from ( \r\n");
        sql.append(" select b.faccountid, b.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" b.fdebitfor, fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" b.fcreditfor, fcreditlocal, \r\n");
        }
        sql.append(" b.fendbalancefor origAmount, \r\n");
        sql.append(" b.fendbalancelocal localAmount \r\n");
        sql.append(" from " + T_BalanceTable + " b \r\n");
        sql.append(" where b.forgunitid = ? and b.fcurrencyid = ? and b.fperiod = ? ");
        params.add(companyId);
        params.add(currencyId);
        params.add(periodNumber);
        sql.append(" and (");
        for (i = 0; i < accountIds.length; ++i) {
            if (i > 0) {
                sql.append(" or ");
            }
            sql.append(" (b.faccountid = ? and b.fassistgrpid in (").append(inSqls[i]).append(")) ");
            params.add(accountIds[i]);
            params.addAll(inParams[i]);
        }
        sql.append(") \r\n");
        sql.append(" union all \r\n");
        sql.append(" select log.faccountid, log.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" isnull(log.fdebitfor,0) fdebitfor, isnull(log.fdebitlocal,0) fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" isnull(log.fcreditfor,0) fcreditfor, isnull(log.fcreditlocal,0) fcreditlocal, \r\n");
        }
        sql.append(" isnull(log.fdebitfor,0) - isnull(log.fcreditfor,0) origAmount, \r\n");
        sql.append(" isnull(log.fdebitlocal,0) - isnull(log.fcreditlocal,0) localAmount \r\n");
        sql.append(" from t_gl_voucher_log log \r\n");
        sql.append(" where log.fcompanyid = ? and (log.fisupdating = 0 or log.fisupdating = 1) and log.fcurrencyid = ? and log.fperiodid = ? and log.fbaltype = ? and log.fisassist = 1 ");
        params.add(companyId);
        params.add(currencyId);
        params.add(period.getId().toString());
        params.add(new Integer(balType));
        sql.append(" and (");
        for (i = 0; i < accountIds.length; ++i) {
            if (i > 0) {
                sql.append(" or ");
            }
            sql.append(" (log.faccountid = ? and log.fassistgrpid in (").append(inSqls[i]).append(")) ");
            params.add(accountIds[i]);
            params.addAll(inParams[i]);
        }
        sql.append(") \r\n");
        sql.append(" ) t \r\n");
        sql.append(" group by t.faccountid, t.fassistgrpid ");
        return sql.toString();
    }

    private String getLaterAsstBalanceSQL(String companyId, PeriodInfo period, String currencyId, int balType, List params, String[] accountIds, String[] inSqls, List[] inParams, PeriodInfo currPeriod, boolean queryDebit, boolean queryCredit) {
        int i;
        String T_BalanceTable = GLBalanceUtils.getBalanceTable(2, balType, currencyId);
        Integer periodNumber = new Integer(period.getPeriodYear() * 100 + period.getPeriodNumber());
        Integer currPeriodNumber = new Integer(currPeriod.getNumber());
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.faccountid, t.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" sum(t.fdebitfor) fdebitfor, sum(t.fdebitlocal) fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" sum(t.fcreditfor) fcreditfor, sum(t.fcreditlocal) fcreditlocal, \r\n");
        }
        sql.append(" sum(t.origAmount) origAmount, sum(t.localAmount) localAmount \r\n");
        sql.append(" from ( \r\n");
        sql.append(" select b.faccountid, b.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" case when b.fperiod = ? then b.fdebitfor else 0 end fdebitfor, \r\n");
            sql.append(" case when b.fperiod = ? then b.fdebitlocal else 0 end fdebitlocal, \r\n");
            params.add(periodNumber);
            params.add(periodNumber);
        }
        if (queryCredit) {
            sql.append(" case when b.fperiod = ? then b.fcreditfor else 0 end fcreditfor, \r\n");
            sql.append(" case when b.fperiod = ? then b.fcreditlocal else 0 end fcreditlocal, \r\n");
            params.add(periodNumber);
            params.add(periodNumber);
        }
        sql.append(" case when b.fperiod = ? then b.fendbalancefor else (b.fdebitfor - b.fcreditfor) end origAmount, \r\n");
        sql.append(" case when b.fperiod = ? then b.fendbalancelocal else (b.fdebitlocal - b.fcreditlocal) end localAmount \r\n");
        params.add(currPeriodNumber);
        params.add(currPeriodNumber);
        sql.append(" from " + T_BalanceTable + " b \r\n");
        sql.append(" where b.forgunitid = ? and b.fcurrencyid = ? and b.fperiod >= ? and b.fperiod <=? ");
        params.add(companyId);
        params.add(currencyId);
        params.add(currPeriodNumber);
        params.add(periodNumber);
        sql.append(" and (");
        for (i = 0; i < accountIds.length; ++i) {
            if (i > 0) {
                sql.append(" or ");
            }
            sql.append(" (b.faccountid = ? and b.fassistgrpid in (").append(inSqls[i]).append(")) ");
            params.add(accountIds[i]);
            params.addAll(inParams[i]);
        }
        sql.append(") \r\n");
        sql.append(" union all \r\n");
        sql.append(" select log.faccountid, log.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" case pd.fnumber when ").append(periodNumber).append(" then isnull(log.fdebitfor,0) else 0 end fdebitfor, \r\n");
            sql.append(" case pd.fnumber when ").append(periodNumber).append(" then isnull(log.fdebitlocal,0) else 0 end fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" case pd.fnumber when ").append(periodNumber).append(" then isnull(log.fcreditfor,0) else 0 end fcreditfor, \r\n");
            sql.append(" case pd.fnumber when ").append(periodNumber).append(" then isnull(log.fcreditlocal,0) else 0 end fcreditlocal, \r\n");
        }
        sql.append(" isnull(log.fdebitfor,0) - isnull(log.fcreditfor,0) origAmount, \r\n");
        sql.append(" isnull(log.fdebitlocal,0) - isnull(log.fcreditlocal,0) localAmount \r\n");
        sql.append(" from t_gl_voucher_log log \r\n");
        sql.append(" inner join t_bd_period pd on pd.fid = log.fperiodid \r\n");
        sql.append(" where log.fcompanyid = ? and (log.fisupdating = 0 or log.fisupdating = 1) and log.fcurrencyid = ? and pd.fnumber >= ? and pd.fnumber <= ? and log.fbaltype = ? and log.fisassist = 1 ");
        params.add(companyId);
        params.add(currencyId);
        params.add(currPeriodNumber);
        params.add(periodNumber);
        params.add(new Integer(balType));
        sql.append(" and (");
        for (i = 0; i < accountIds.length; ++i) {
            if (i > 0) {
                sql.append(" or ");
            }
            sql.append(" (log.faccountid = ? and log.fassistgrpid in (").append(inSqls[i]).append(")) ");
            params.add(accountIds[i]);
            params.addAll(inParams[i]);
        }
        sql.append(") \r\n");
        sql.append(" ) t \r\n");
        sql.append(" group by t.faccountid, t.fassistgrpid ");
        return sql.toString();
    }

    @Override
    protected void _recalculateBalance(Context ctx, String pk) throws BOSException {
        try {
            if (pk != null) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = view.getSelector();
                sic.add(new SelectorItemInfo("id"));
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("id", (Object)pk.trim()));
                ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitCollection cc = companyOrgUnit.getCompanyOrgUnitCollection(view);
                if (cc.size() <= 0) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"886_GLFlagControllerBean", (Locale)ctx.getLocale()) + pk + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"887_GLFlagControllerBean", (Locale)ctx.getLocale()));
                }
                ctx.put((Object)"choseCompanyID", (Object)cc.get(0).getId());
                GLBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(new String[]{cc.get(0).getId().toString()});
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"Update voucher balance error!", (Throwable)ex);
        }
    }

    private String getAsstBalanceSQL(Context ctx, String companyId, PeriodInfo period, String currencyId, int balType, List params, String[] accountIds, String[] inSqls, List[] inParams, boolean queryDebit, boolean queryCredit) throws BOSException {
        String selectSql;
        String tableName;
        int i;
        String T_BalanceTable = GLBalanceUtils.getBalanceTable(2, balType, currencyId);
        Integer periodNumber = new Integer(period.getPeriodYear() * 100 + period.getPeriodNumber());
        StringBuffer sql = new StringBuffer();
        sql.append("select t.faccountid, t.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" sum(t.fdebitfor) fdebitfor, sum(t.fdebitlocal) fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" sum(t.fcreditfor) fcreditfor, sum(t.fcreditlocal) fcreditlocal, \r\n");
        }
        sql.append(" sum(t.origAmount) origAmount, \r\n");
        sql.append(" sum(t.localAmount) localAmount \r\n");
        sql.append(" from ( \r\n");
        sql.append(" select b.faccountid, b.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" b.fdebitfor, fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" b.fcreditfor, fcreditlocal, \r\n");
        }
        sql.append(" b.fendbalancefor origAmount, \r\n");
        sql.append(" b.fendbalancelocal localAmount \r\n");
        sql.append(" from " + T_BalanceTable + " b \r\n");
        sql.append(" where b.forgunitid = ? and b.fcurrencyid = ? and b.fperiod = ? ");
        params.add(companyId);
        params.add(currencyId);
        params.add(periodNumber);
        sql.append(" and (");
        for (i = 0; i < accountIds.length; ++i) {
            if (i > 0) {
                sql.append(" or ");
            }
            if (inSqls[i].length() > 1000) {
                try {
                    tableName = this.getTempTableName(ctx, "tag", "ASSISTGRPID VARCHAR(44)");
                    AccountBalanceControllerBean.insertTempTable(ctx, inParams[i], tableName);
                    selectSql = "select top 1 * from " + tableName + " where " + tableName + ".ASSISTGRPID = b.fassistgrpid";
                    sql.append(" (b.faccountid = ? and exists (" + selectSql + "))");
                    params.add(accountIds[i]);
                    continue;
                }
                catch (BOSException e) {
                    throw new BOSException("SQL ERROR!", (Throwable)e);
                }
            }
            sql.append(" (b.faccountid = ? and b.fassistgrpid in (").append(inSqls[i]).append(")) ");
            params.add(accountIds[i]);
            params.addAll(inParams[i]);
        }
        sql.append(")  \r\n");
        sql.append(" union all \r\n");
        sql.append(" select log.faccountid, log.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" isnull(log.fdebitfor,0) fdebitfor, isnull(log.fdebitlocal,0) fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" isnull(log.fcreditfor,0) fcreditfor, isnull(log.fcreditlocal,0) fcreditlocal, \r\n");
        }
        sql.append(" isnull(log.fdebitfor,0) - isnull(log.fcreditfor,0) origAmount, \r\n");
        sql.append(" isnull(log.fdebitlocal,0) - isnull(log.fcreditlocal,0) localAmount \r\n");
        sql.append(" from t_gl_voucher_log log \r\n");
        sql.append(" where log.fcompanyid = ? and (log.fisupdating = 0 or log.fisupdating = 1) and log.fcurrencyid = ? and log.fperiodid = ? and log.fbaltype = ? and log.fisassist = 1 ");
        params.add(companyId);
        params.add(currencyId);
        params.add(period.getId().toString());
        params.add(new Integer(balType));
        sql.append(" and (");
        for (i = 0; i < accountIds.length; ++i) {
            if (i > 0) {
                sql.append(" or ");
            }
            if (inSqls[i].length() > 1000) {
                try {
                    tableName = this.getTempTableName(ctx, "tag", "ASSISTGRPID VARCHAR(44)");
                    AccountBalanceControllerBean.insertTempTable(ctx, inParams[i], tableName);
                    selectSql = "select top 1 * from " + tableName + " where " + tableName + ".ASSISTGRPID = log.fassistgrpid";
                    sql.append(" (log.faccountid = ? and exists (" + selectSql + "))");
                    params.add(accountIds[i]);
                    continue;
                }
                catch (BOSException e) {
                    throw new BOSException("SQL ERROR!", (Throwable)e);
                }
            }
            sql.append(" (log.faccountid = ? and log.fassistgrpid in (").append(inSqls[i]).append(")) ");
            params.add(accountIds[i]);
            params.addAll(inParams[i]);
        }
        sql.append(") \r\n");
        sql.append(" ) t \r\n");
        sql.append(" group by t.faccountid, t.fassistgrpid ");
        return sql.toString();
    }

    private String getLaterAsstBalanceSQL(Context ctx, String companyId, PeriodInfo period, String currencyId, int balType, List params, String[] accountIds, String[] inSqls, List[] inParams, PeriodInfo currPeriod, boolean queryDebit, boolean queryCredit) throws BOSException {
        String selectSql;
        String tableName;
        int i;
        String T_BalanceTable = GLBalanceUtils.getBalanceTable(2, balType, currencyId);
        Integer periodNumber = new Integer(period.getPeriodYear() * 100 + period.getPeriodNumber());
        Integer currPeriodNumber = new Integer(currPeriod.getNumber());
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.faccountid, t.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" sum(t.fdebitfor) fdebitfor, sum(t.fdebitlocal) fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" sum(t.fcreditfor) fcreditfor, sum(t.fcreditlocal) fcreditlocal, \r\n");
        }
        sql.append(" sum(t.origAmount) origAmount, sum(t.localAmount) localAmount \r\n");
        sql.append(" from ( \r\n");
        sql.append(" select b.faccountid, b.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" case when b.fperiod = ? then b.fdebitfor else 0 end fdebitfor, \r\n");
            sql.append(" case when b.fperiod = ? then b.fdebitlocal else 0 end fdebitlocal, \r\n");
            params.add(periodNumber);
            params.add(periodNumber);
        }
        if (queryCredit) {
            sql.append(" case when b.fperiod = ? then b.fcreditfor else 0 end fcreditfor, \r\n");
            sql.append(" case when b.fperiod = ? then b.fcreditlocal else 0 end fcreditlocal, \r\n");
            params.add(periodNumber);
            params.add(periodNumber);
        }
        sql.append(" case when b.fperiod = ? then b.fendbalancefor else (b.fdebitfor - b.fcreditfor) end origAmount, \r\n");
        sql.append(" case when b.fperiod = ? then b.fendbalancelocal else (b.fdebitlocal - b.fcreditlocal) end localAmount \r\n");
        params.add(currPeriodNumber);
        params.add(currPeriodNumber);
        sql.append(" from " + T_BalanceTable + " b \r\n");
        sql.append(" where b.forgunitid = ? and b.fcurrencyid = ? and b.fperiod >= ? and b.fperiod <=? ");
        params.add(companyId);
        params.add(currencyId);
        params.add(currPeriodNumber);
        params.add(periodNumber);
        sql.append(" and (");
        for (i = 0; i < accountIds.length; ++i) {
            if (i > 0) {
                sql.append(" or ");
            }
            if (inSqls[i].length() > 1000) {
                try {
                    tableName = this.getTempTableName(ctx, "tag", "ASSISTGRPID VARCHAR(44)");
                    AccountBalanceControllerBean.insertTempTable(ctx, inParams[i], tableName);
                    selectSql = "select top 1 * from " + tableName + " where " + tableName + ".ASSISTGRPID = b.fassistgrpid";
                    sql.append(" (b.faccountid = ? and exists (" + selectSql + "))");
                    params.add(accountIds[i]);
                    continue;
                }
                catch (BOSException e) {
                    throw new BOSException("SQL ERROR!", (Throwable)e);
                }
            }
            sql.append(" (b.faccountid = ? and b.fassistgrpid in (").append(inSqls[i]).append(")) ");
            params.add(accountIds[i]);
            params.addAll(inParams[i]);
        }
        sql.append(") \r\n");
        sql.append(" union all \r\n");
        sql.append(" select log.faccountid, log.fassistgrpid, \r\n");
        if (queryDebit) {
            sql.append(" case pd.fnumber when ").append(periodNumber).append(" then isnull(log.fdebitfor,0) else 0 end fdebitfor, \r\n");
            sql.append(" case pd.fnumber when ").append(periodNumber).append(" then isnull(log.fdebitlocal,0) else 0 end fdebitlocal, \r\n");
        }
        if (queryCredit) {
            sql.append(" case pd.fnumber when ").append(periodNumber).append(" then isnull(log.fcreditfor,0) else 0 end fcreditfor, \r\n");
            sql.append(" case pd.fnumber when ").append(periodNumber).append(" then isnull(log.fcreditlocal,0) else 0 end fcreditlocal, \r\n");
        }
        sql.append(" isnull(log.fdebitfor,0) - isnull(log.fcreditfor,0) origAmount, \r\n");
        sql.append(" isnull(log.fdebitlocal,0) - isnull(log.fcreditlocal,0) localAmount \r\n");
        sql.append(" from t_gl_voucher_log log \r\n");
        sql.append(" inner join t_bd_period pd on pd.fid = log.fperiodid \r\n");
        sql.append(" where log.fcompanyid = ? and (log.fisupdating = 0 or log.fisupdating = 1) and log.fcurrencyid = ? and pd.fnumber >= ? and pd.fnumber <= ? and log.fbaltype = ? and log.fisassist = 1 ");
        params.add(companyId);
        params.add(currencyId);
        params.add(currPeriodNumber);
        params.add(periodNumber);
        params.add(new Integer(balType));
        sql.append(" and (");
        for (i = 0; i < accountIds.length; ++i) {
            if (i > 0) {
                sql.append(" or ");
            }
            if (inSqls[i].length() > 1000) {
                try {
                    tableName = this.getTempTableName(ctx, "tag", "ASSISTGRPID VARCHAR(44)");
                    AccountBalanceControllerBean.insertTempTable(ctx, inParams[i], tableName);
                    selectSql = "select top 1 * from " + tableName + " where " + tableName + ".ASSISTGRPID = log.fassistgrpid";
                    sql.append(" (log.faccountid = ? and exists (" + selectSql + "))");
                    params.add(accountIds[i]);
                    continue;
                }
                catch (BOSException e) {
                    throw new BOSException("SQL ERROR!", (Throwable)e);
                }
            }
            sql.append(" (log.faccountid = ? and log.fassistgrpid in (").append(inSqls[i]).append(")) ");
            params.add(accountIds[i]);
            params.addAll(inParams[i]);
        }
        sql.append(") \r\n");
        sql.append(" ) t \r\n");
        sql.append(" group by t.faccountid, t.fassistgrpid ");
        return sql.toString();
    }

    private String getTempTableName(Context ctx, String name, String struct) throws BOSException {
        String csName = this.getClass().getName();
        name = csName.substring(csName.lastIndexOf(".") + 1) + name;
        String createTableSql = "create table " + name + " (" + struct + ")";
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
    }

    private static void insertTempTable(Context ctx, List assistgrpId, String tableName) throws BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        String tempSql = "insert into " + tableName + "(assistgrpid) values(?)";
        Set assistgrpIdSet = AccountBalanceControllerBean.List2Set(assistgrpId);
        if ("".equals(tableName) || tableName == null) {
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(tempSql);
            Iterator it = assistgrpIdSet.iterator();
            while (it.hasNext()) {
                stmt.setString(1, it.next().toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                if (tableName != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
                }
                throw new BOSException("SQL error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public static <T> Set<T> List2Set(List assistgrpId) {
        HashSet tSet = new HashSet(assistgrpId);
        return tSet;
    }

    @Override
    protected GLBalanceInfo _getGLAccountBalanceNew(Context ctx, Map param) throws BOSException, EASBizException {
        Map voucher = (Map)param.get("voucher");
        Map oldVoucher = (Map)param.get("oldVoucher");
        AccountViewInfo account = (AccountViewInfo)param.get("account");
        CurrencyInfo currency = (CurrencyInfo)param.get("currency");
        if (voucher == null || account == null || currency == null) {
            throw new BOSException("The voucher or account or currency is empty!");
        }
        boolean isEdit = (Boolean)param.get("isEdit");
        GLBalanceInfo bal = this.createAccountBalance(voucher, account, currency, isEdit);
        if (isEdit && oldVoucher != null && (VoucherStatusEnum)oldVoucher.get("status") == VoucherStatusEnum.SUBMITTED && ((PeriodInfo)oldVoucher.get("period")).getId().equals((Object)((PeriodInfo)voucher.get("period")).getId())) {
            bal.subtract(this.createAccountBalance(oldVoucher, account, currency, isEdit));
        }
        GLBalanceKey key = bal.getKey();
        GLBalanceKeyCPCT cpct = new GLBalanceKeyCPCT(key);
        boolean queryDebit = (Boolean)param.get("queryDebit");
        boolean queryCredit = (Boolean)param.get("queryCredit");
        GLBalanceCollection coll = this.genAccountBalance(ctx, cpct, queryDebit, queryCredit);
        bal.add(coll.getGLBalanceInfo(key));
        return bal;
    }

    @Override
    protected GLAsstBalanceInfo _getGLAsstBalanceNew(Context ctx, Map param) throws BOSException, EASBizException {
        Map voucher = (Map)param.get("voucher");
        Map oldVoucher = (Map)param.get("oldVoucher");
        AccountViewInfo account = (AccountViewInfo)param.get("account");
        CurrencyInfo currency = (CurrencyInfo)param.get("currency");
        AssistantHGInfo hg = (AssistantHGInfo)param.get("hg");
        if (voucher == null || account == null || currency == null || hg == null) {
            throw new BOSException("The voucher or account or currency or hg is empty!");
        }
        boolean isEdit = (Boolean)param.get("isEdit");
        GLAsstBalanceInfo bal = this.createAssistBalance(voucher, account, currency, hg, isEdit);
        if (isEdit && oldVoucher != null && (VoucherStatusEnum)oldVoucher.get("status") == VoucherStatusEnum.SUBMITTED && ((PeriodInfo)oldVoucher.get("period")).getId().equals((Object)((PeriodInfo)voucher.get("period")).getId())) {
            bal.subtract(this.createAssistBalance(oldVoucher, account, currency, hg, isEdit));
        }
        GLAsstBalanceKey key = bal.getKey();
        GLBalanceKeyCPCT cpct = new GLBalanceKeyCPCT(key);
        boolean queryDebit = (Boolean)param.get("queryDebit");
        boolean queryCredit = (Boolean)param.get("queryCredit");
        GLAsstBalanceCollection coll = this.getAsstBalanceCollection(ctx, cpct, queryDebit, queryCredit);
        bal.add(coll.getGLAsstBalanceInfo(key));
        return bal;
    }

    private GLBalanceInfo createAccountBalance(Map voucher, AccountViewInfo account, CurrencyInfo currency, boolean isEdit) throws BOSException {
        if (account == null || currency == null) {
            return null;
        }
        List entries = (List)voucher.get("entries");
        AccountViewInfo accInfo = null;
        CurrencyInfo curInfo = null;
        GLBalanceInfo balInfo = this.createEmptyGLBalanceInfo(voucher, account, currency);
        if (!isEdit || (VoucherStatusEnum)voucher.get("status") == VoucherStatusEnum.CANCELLED) {
            return balInfo;
        }
        Map entryInfo = null;
        Object recordInfo = null;
        Object dc = null;
        for (int i = 0; i < entries.size(); ++i) {
            entryInfo = (Map)entries.get(i);
            curInfo = (CurrencyInfo)entryInfo.get("currency");
            accInfo = (AccountViewInfo)entryInfo.get("account");
            if (accInfo == null || !accInfo.getId().equals((Object)account.getId()) || curInfo == null || !curInfo.getId().equals((Object)currency.getId())) continue;
            balInfo.add(this.createGLBalanceInfo(voucher, entryInfo, true));
        }
        return balInfo;
    }

    private GLAsstBalanceInfo createAssistBalance(Map voucher, AccountViewInfo account, CurrencyInfo currency, AssistantHGInfo hg, boolean isEdit) throws BOSException {
        if (account == null || currency == null || hg == null) {
            return null;
        }
        List entries = (List)voucher.get("entries");
        Map entryInfo = null;
        Map recordInfo = null;
        AccountViewInfo accInfo = null;
        CurrencyInfo curInfo = null;
        GLAsstBalanceInfo balInfo = this.createEmptyGLAsstBalanceInfo(voucher, account, currency, hg);
        if (!isEdit || (VoucherStatusEnum)voucher.get("status") == VoucherStatusEnum.CANCELLED) {
            return balInfo;
        }
        EntryDC dc = null;
        for (int i = 0; i < entries.size(); ++i) {
            entryInfo = (Map)entries.get(i);
            curInfo = (CurrencyInfo)entryInfo.get("currency");
            accInfo = (AccountViewInfo)entryInfo.get("account");
            dc = (EntryDC)entryInfo.get("dc");
            if (accInfo == null || accInfo.getCAA() == null || !accInfo.getId().equals((Object)account.getId()) || curInfo == null || !curInfo.getId().equals((Object)currency.getId())) continue;
            List assists = (List)entryInfo.get("assistRecords");
            for (int j = 0; j < assists.size(); ++j) {
                recordInfo = (Map)assists.get(j);
                if (recordInfo.get("assGrpId") == null || !recordInfo.get("assGrpId").equals(hg.getId())) continue;
                balInfo.add(this.createGLAsstBalanceInfo(voucher, account, dc, currency, hg, recordInfo, isEdit));
            }
        }
        return balInfo;
    }

    private GLBalanceInfo createEmptyGLBalanceInfo(Map voucher, AccountViewInfo account, CurrencyInfo currency) throws BOSException {
        GLBalanceKey key = new GLBalanceKey((CompanyOrgUnitInfo)voucher.get("company"), account, currency, (PeriodInfo)voucher.get("period"), (VoucherStatusEnum)voucher.get("status") == VoucherStatusEnum.POSTED ? 5 : 1);
        return new GLBalanceInfo(key);
    }

    private GLAsstBalanceInfo createEmptyGLAsstBalanceInfo(Map voucher, AccountViewInfo account, CurrencyInfo currency, AssistantHGInfo hg) throws BOSException {
        GLAsstBalanceKey key = new GLAsstBalanceKey((CompanyOrgUnitInfo)voucher.get("company"), account, currency, (PeriodInfo)voucher.get("period"), hg, (VoucherStatusEnum)voucher.get("status") == VoucherStatusEnum.POSTED ? 5 : 1);
        return new GLAsstBalanceInfo(key);
    }

    private GLBalanceInfo createGLBalanceInfo(Map voucher, Map entryInfo, boolean isEdit) throws BOSException {
        GLBalanceKey key = new GLBalanceKey((CompanyOrgUnitInfo)voucher.get("company"), (AccountViewInfo)entryInfo.get("account"), (CurrencyInfo)entryInfo.get("currency"), (PeriodInfo)voucher.get("period"), (VoucherStatusEnum)voucher.get("status") == VoucherStatusEnum.POSTED ? 5 : 1);
        GLBalanceInfo balInfo = new GLBalanceInfo(key);
        if (!isEdit) {
            return balInfo;
        }
        BigDecimal amount = null;
        if ((EntryDC)entryInfo.get("dc") == EntryDC.CREDIT) {
            amount = (BigDecimal)entryInfo.get("originalAmount");
            if (amount != null) {
                balInfo.setCreditFor(amount);
                balInfo.setOrigAmount(amount.negate());
            }
            if ((amount = (BigDecimal)entryInfo.get("localAmount")) != null) {
                balInfo.setCreditLocal(amount);
                balInfo.setLocalAmount(amount.negate());
            }
        } else {
            amount = (BigDecimal)entryInfo.get("originalAmount");
            if (amount != null) {
                balInfo.setDebitFor(amount);
                balInfo.setOrigAmount(amount);
            }
            if ((amount = (BigDecimal)entryInfo.get("localAmount")) != null) {
                balInfo.setDebitLocal(amount);
                balInfo.setLocalAmount(amount);
            }
        }
        return balInfo;
    }

    private GLAsstBalanceInfo createGLAsstBalanceInfo(Map voucher, AccountViewInfo account, EntryDC dc, CurrencyInfo currency, AssistantHGInfo hg, Map recordInfo, boolean isEdit) throws BOSException {
        GLAsstBalanceKey key = new GLAsstBalanceKey((CompanyOrgUnitInfo)voucher.get("company"), account, currency, (PeriodInfo)voucher.get("period"), hg, (VoucherStatusEnum)voucher.get("status") == VoucherStatusEnum.POSTED ? 5 : 1);
        GLAsstBalanceInfo asstBalInfo = new GLAsstBalanceInfo(key);
        if (!isEdit) {
            return asstBalInfo;
        }
        BigDecimal amount = null;
        if (dc == EntryDC.CREDIT) {
            amount = (BigDecimal)recordInfo.get("originalAmount");
            if (amount != null) {
                asstBalInfo.setCreditFor(amount);
                asstBalInfo.setOrigAmount(amount.negate());
            }
            if ((amount = (BigDecimal)recordInfo.get("localAmount")) != null) {
                asstBalInfo.setCreditLocal(amount);
                asstBalInfo.setLocalAmount(amount.negate());
            }
        } else {
            amount = (BigDecimal)recordInfo.get("originalAmount");
            if (amount != null) {
                asstBalInfo.setDebitFor(amount);
                asstBalInfo.setOrigAmount(amount);
            }
            if ((amount = (BigDecimal)recordInfo.get("localAmount")) != null) {
                asstBalInfo.setDebitLocal(amount);
                asstBalInfo.setLocalAmount(amount);
            }
        }
        return asstBalInfo;
    }
}

