/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentCollection;
import com.kingdee.eas.fi.gl.AcctCussentFactory;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeInfo;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLFlagInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAssistCustomizedProperty;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.InitException;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.app.AbstractAcctCussentInitFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GlAcctCussentGlFlagDeal;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AcctCussentInitFacadeControllerBean
extends AbstractAcctCussentInitFacadeControllerBean {
    private static final long serialVersionUID = 685012098638696101L;
    private static final String GL_RESOURCE = "com.kingdee.eas.fi.gl.GLResource";
    private Map importSeqMap = new HashMap();

    @Override
    protected void _save(Context ctx, IObjectCollection datas, HashMap otherCtx) throws BOSException, EASBizException {
        if (otherCtx.get("IsAllDeleted") != null && ((Boolean)otherCtx.get("IsAllDeleted")).booleanValue()) {
            IObjectPK[] pkArray = (IObjectPK[])otherCtx.get("pkArray");
            InitHelp.getAcctCussentCtrl(ctx).deleteBatchData(pkArray);
        }
        AcctCussentCollection col = (AcctCussentCollection)datas;
        int seq = -1;
        for (AcctCussentInfo as : col) {
            InitHelp.addRongYu4AcctCussent(ctx, as, as.getVchAssistRecord());
            if (as.get("persist_status").equals("new")) {
                as.getVchAssistRecord().setSeq(0);
                if (seq == -1) {
                    seq = this._getMaxInitSeq(ctx, otherCtx);
                }
                as.setSeq(++seq);
                InitHelp.getAcctCussentCtrl(ctx).addnew((CoreBaseInfo)as);
                continue;
            }
            if (as.get("persist_status").equals("dirty")) {
                as.getVchAssistRecord().setSeq(0);
                InitHelp.getAcctCussentCtrl(ctx).update((IObjectPK)new ObjectUuidPK(as.getId()), (CoreBaseInfo)as);
                continue;
            }
            if (!as.get("persist_status").equals("deleted")) continue;
            InitHelp.getAcctCussentCtrl(ctx).delete((IObjectPK)new ObjectUuidPK(as.getId()));
        }
    }

    public IRowSet getSum(Context ctx, String[] fieldInfo, String companyId, String accountId, String currencyId, String caaId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(" sum(VCHASSISTRECORD.FOriginalAmount)").append(" as OriginalAmount ");
        sql.append(" FROM T_GL_AcctCussent AS ACCTCUSSENT ");
        sql.append(" INNER JOIN T_GL_VoucherAssistRecord AS VCHASSISTRECORD ON ACCTCUSSENT.FVchAssistRecordID = VCHASSISTRECORD.FID ");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANY ON ACCTCUSSENT.FCompanyID = COMPANY.FID ");
        sql.append(" INNER JOIN T_BD_Currency AS CURRENCY ON ACCTCUSSENT.FCurrencyID = CURRENCY.FID ");
        sql.append(" INNER JOIN T_BD_AccountView AS ACCOUNT ON ACCTCUSSENT.FAccountID = ACCOUNT.FID ");
        sql.append(" WHERE ACCTCUSSENT.FCompanyID = '").append(companyId).append("'");
        if (StringUtils.isEmpty((String)currencyId)) {
            currencyId = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
        }
        sql.append(" AND ACCTCUSSENT.FCurrencyID ='" + currencyId + "'");
        if (!StringUtils.isEmpty((String)caaId)) {
            sql.append(" AND ACCOUNT.FCAA = '").append(caaId).append("'");
        }
        if (!StringUtils.isEmpty((String)accountId)) {
            sql.append(" AND ACCTCUSSENT.FAccountID = '").append(accountId).append("'");
        }
        sql.append("AND  ACCTCUSSENT.FISINIT ='1'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    @Override
    protected ArrayList _getCussentInitDataWithTypes(Context ctx, IObjectValue acc, IObjectValue currency, HashMap otherCtx) throws BOSException, EASBizException {
        AccountViewInfo account = (AccountViewInfo)acc;
        AssistCustomizedTypeCollection propcol = this.getCustomizedTypes(ctx, account);
        if (account.getCAA() == null) {
            IAccountView avctl = AccountViewFactory.getLocalInstance((Context)ctx);
            account = avctl.getAccountViewInfo((IObjectPK)new ObjectUuidPK(account.getId()));
        }
        AsstActTypeCollection tcol = InitHelp.getAsstActTypes(ctx, account.getCAA(), otherCtx);
        IObjectCollection cussentCol = this._getCussentInitData(ctx, (IObjectValue)account, (IObjectCollection)tcol, (IObjectCollection)propcol, currency, otherCtx);
        Boolean b = this.isInitClosed(ctx, account, otherCtx);
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(tcol);
        result.add((Object)propcol);
        result.add(cussentCol);
        result.add(b);
        return result;
    }

    private AssistCustomizedTypeCollection getCustomizedTypes(Context ctx, AccountViewInfo account) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("isNecessary"));
        sic.add(new SelectorItemInfo("customizedType.name"));
        sic.add(new SelectorItemInfo("customizedType.mappingPropName"));
        sic.add(new SelectorItemInfo("customizedType.dataType"));
        sic.add(new SelectorItemInfo("customizedType.defaultQueryName"));
        sic.add(new SelectorItemInfo("customizedType.precision"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("account.id", (Object)account.getId().toString()));
        fic.add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        IAssistCustomizedProperty cpCtrl = AssistCustomizedPropertyFactory.getLocalInstance(ctx);
        AssistCustomizedPropertyCollection props = cpCtrl.getAssistCustomizedPropertyCollection(view);
        AssistCustomizedTypeCollection result = new AssistCustomizedTypeCollection();
        Iterator itr = props.iterator();
        while (itr.hasNext()) {
            AssistCustomizedPropertyInfo prop = (AssistCustomizedPropertyInfo)itr.next();
            AssistCustomizedTypeInfo t = prop.getCustomizedType();
            t.put("isNecessary", prop.isIsNecessary());
            result.add(t);
        }
        return result;
    }

    @Override
    protected IObjectCollection _getCussentInitData(Context ctx, IObjectValue acc, IObjectCollection actAsstTypeCol, IObjectCollection customPropCol, IObjectValue cur, HashMap otherCtx) throws BOSException {
        int i;
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        AccountViewInfo account = (AccountViewInfo)acc;
        AsstActTypeCollection tcol = (AsstActTypeCollection)actAsstTypeCol;
        AssistCustomizedTypeCollection props = (AssistCustomizedTypeCollection)customPropCol;
        CurrencyInfo currency = (CurrencyInfo)cur;
        String currencyid = currency.getId().toString();
        StringBuffer oql = new StringBuffer();
        oql.append("select ");
        String[] s = InitHelp.getPropOql(ctx, "", new AcctCussentInfo().getBOSType());
        int count = s.length;
        for (i = 0; i < count; ++i) {
            oql.append(s[i]).append(",");
        }
        s = InitHelp.getPropOql(ctx, "vchAssistRecord.", new VoucherAssistRecordInfo().getBOSType());
        count = s.length - 1;
        for (i = 0; i < count; ++i) {
            oql.append(s[i]).append(",");
        }
        oql.append(s[s.length - 1]);
        oql.append(",vchAssistRecord.measureUnit.number");
        oql.append(",vchAssistRecord.measureUnit.name");
        oql.append(",vchAssistRecord.measureUnit.Coefficient");
        count = tcol.size();
        for (i = 0; i < count; ++i) {
            AsstActTypeInfo typeInfo;
            String asstTypeAttr = tcol.get(i).getAsstHGAttribute();
            oql.append(",vchAssistRecord.assGrp." + asstTypeAttr + ".id");
            oql.append(",vchAssistRecord.assGrp." + asstTypeAttr + ".name");
            oql.append(",vchAssistRecord.assGrp." + asstTypeAttr + ".number");
            if (tcol.get(i).isUseLongNumber()) {
                oql.append(",vchAssistRecord.assGrp." + asstTypeAttr + ".longNumber");
            }
            if (!(typeInfo = tcol.get(i)).isIsMultilevel()) continue;
            if (asstTypeAttr.equals("saleOrg") || asstTypeAttr.equals("profitOrg") || asstTypeAttr.equals("purchaseOrg") || asstTypeAttr.equals("storeageOrg") || asstTypeAttr.equals("companyOrg") || asstTypeAttr.equals("costOrg")) {
                oql.append(",vchAssistRecord.assGrp." + asstTypeAttr + ".isBizUnit");
                continue;
            }
            if (asstTypeAttr.startsWith("generalAssActType")) {
                oql.append(",vchAssistRecord.assGrp." + asstTypeAttr + ".longNumber");
                continue;
            }
            oql.append(",vchAssistRecord.assGrp." + asstTypeAttr + ".isLeaf");
        }
        if (props != null) {
            Iterator itr = props.iterator();
            while (itr.hasNext()) {
                AssistCustomizedTypeInfo t = (AssistCustomizedTypeInfo)itr.next();
                String propName = t.getMappingPropName();
                if (!t.getDataType().equals((Object)AssistCustomizedDataTypeEnum.BUSINESSOBJECT)) continue;
                oql.append(",vchAssistRecord.").append(propName).append(".name");
                oql.append(",vchAssistRecord.").append(propName).append(".number");
            }
        }
        oql.append(" where account.id='").append(account.getId().toString()).append("' and company.id='");
        oql.append(orgUnitId).append("' and isInit=1 ");
        oql.append(" and currency.id='").append(currencyid).append("'");
        oql.append(" and vchAssistRecord.assGrp.id is not null ");
        AcctCussentCollection col = null;
        try {
            String asstInitImport;
            EntityViewInfo view = new EntityViewInfo(oql.toString());
            col = InitHelp.getAcctCussentCtrl(ctx).getAcctCussentCollection(view);
            AcctCussentCollection result = new AcctCussentCollection();
            HashMap<String, AcctCussentInfo> hm = new HashMap<String, AcctCussentInfo>();
            AcctCussentInfo temp1 = null;
            AcctCussentInfo temp2 = null;
            if (currencyid.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || currencyid.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                int count2 = col.size();
                for (int i2 = 0; i2 < count2; ++i2) {
                    temp1 = col.get(i2);
                    String key = temp1.getVchAssistRecord().getAssGrp().getId().toString();
                    temp2 = (AcctCussentInfo)hm.get(key);
                    if (temp2 != null) {
                        VoucherAssistRecordInfo entry2 = temp2.getVchAssistRecord();
                        VoucherAssistRecordInfo entry1 = temp1.getVchAssistRecord();
                        entry2.setQuantity(InitHelp.zero.add(entry2.getQuantity()).add(entry1.getQuantity()));
                        entry2.setOriginalAmount(InitHelp.zero.add(entry2.getOriginalAmount()).add(entry1.getOriginalAmount()));
                        entry2.setLocalAmount(InitHelp.zero.add(entry2.getLocalAmount()).add(entry1.getLocalAmount()));
                        entry2.setReportingAmount(InitHelp.zero.add(entry2.getReportingAmount()).add(entry1.getReportingAmount()));
                        continue;
                    }
                    hm.put(temp1.getVchAssistRecord().getAssGrp().getId().toString(), temp1);
                    result.add(temp1);
                }
                col = result;
            }
            if ((asstInitImport = (String)otherCtx.get("AsstInitImport")) != null && col != null) {
                Iterator it = col.iterator();
                AcctCussentInfo acctCussentInfo = null;
                HashMap<String, AcctCussentInfo> keyCol = new HashMap<String, AcctCussentInfo>();
                while (it.hasNext()) {
                    acctCussentInfo = (AcctCussentInfo)it.next();
                    String key = "";
                    int count3 = tcol.size();
                    for (int i3 = 0; i3 < count3; ++i3) {
                        String asstTypeAttr = tcol.get(i3).getAsstHGAttribute();
                        CoreBaseInfo core = (CoreBaseInfo)acctCussentInfo.getVchAssistRecord().getAssGrp().get(asstTypeAttr);
                        key = key + core.getId().toString();
                    }
                    if (keyCol.containsKey(key)) {
                        AcctCussentInfo ac = (AcctCussentInfo)keyCol.get(key);
                        BigDecimal amount = ac.getVchAssistRecord().getLocalAmount();
                        BigDecimal report = ac.getVchAssistRecord().getReportingAmount();
                        BigDecimal original = ac.getVchAssistRecord().getOriginalAmount();
                        BigDecimal qty = ac.getVchAssistRecord().getQuantity();
                        BigDecimal standardQty = ac.getVchAssistRecord().getStandardQuantity();
                        BigDecimal coefficient = new BigDecimal("1.0");
                        if (ac.getVchAssistRecord().getMeasureUnit() != null && acctCussentInfo.getVchAssistRecord().getMeasureUnit() != null) {
                            coefficient = ac.getVchAssistRecord().getMeasureUnit().getCoefficient().divide(acctCussentInfo.getVchAssistRecord().getMeasureUnit().getCoefficient(), 6, 4);
                        }
                        BigDecimal amount1 = acctCussentInfo.getVchAssistRecord().getLocalAmount();
                        BigDecimal report1 = acctCussentInfo.getVchAssistRecord().getReportingAmount();
                        BigDecimal original1 = acctCussentInfo.getVchAssistRecord().getOriginalAmount();
                        BigDecimal qty1 = acctCussentInfo.getVchAssistRecord().getQuantity();
                        BigDecimal standardQty1 = acctCussentInfo.getVchAssistRecord().getStandardQuantity();
                        acctCussentInfo.getVchAssistRecord().setLocalAmount(amount1.add(amount == null ? BigDecimal.ZERO : amount));
                        acctCussentInfo.getVchAssistRecord().setReportingAmount(report1.add(report == null ? BigDecimal.ZERO : report));
                        acctCussentInfo.getVchAssistRecord().setOriginalAmount(original1.add(original == null ? BigDecimal.ZERO : original));
                        acctCussentInfo.getVchAssistRecord().setQuantity(qty1.add(coefficient.multiply(qty == null ? BigDecimal.ZERO : qty)));
                        acctCussentInfo.getVchAssistRecord().setStandardQuantity(standardQty1.add(standardQty == null ? BigDecimal.ZERO : standardQty));
                        keyCol.remove(key);
                    }
                    keyCol.put(key, acctCussentInfo);
                }
                Set set = keyCol.keySet();
                Iterator ite = set.iterator();
                result = new AcctCussentCollection();
                while (ite.hasNext()) {
                    String key = (String)ite.next();
                    acctCussentInfo = (AcctCussentInfo)keyCol.get(key);
                    result.add(acctCussentInfo);
                }
                col = result;
            }
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return col;
    }

    private boolean isInitClosed(Context ctx, AccountViewInfo account, HashMap otherCtx) throws BOSException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        String[] accounts = new String[]{account.getId().toString()};
        boolean[] result = flag.getCussentInitClosed(accounts, orgUnitId);
        return result[0];
    }

    @Override
    protected ArrayList _findInitData(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CurrencyCollection curCol;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (company.getAccountPeriodType() == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Map hmParamValue = InitHelp.getInitParam(ctx, company);
        result.add(hmParamValue.get("GL_002"));
        result.add(hmParamValue.get("GL_008"));
        result.add(hmParamValue.get("G001"));
        Boolean allowCussent = Boolean.valueOf((String)hmParamValue.get("GL_028"));
        if (otherCtx.get("module") == null && allowCussent.equals(Boolean.FALSE)) {
            throw new GLException(GLException.CUSSENTNOTALLOW);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2)));
        filter.setMaskString("#0 and (#1 or #2)");
        view.setFilter(filter);
        boolean isCurrency = AccountViewFactory.getLocalInstance((Context)ctx).exists(filter);
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        if (isCurrency) {
            curCol = curCtrl.getCurrencyCollection(true);
        } else {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)company.getBaseCurrency().getId().toString()));
            curCol = curCtrl.getCurrencyCollection(view);
        }
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        CurrencyCollection newAllCurrency = new CurrencyCollection();
        String bookCurrency = EASResource.getString((String)"com.kingdee.eas.fi.gl.InitResource", (String)"bookCurrency", (Locale)ctx.getOriginLocale());
        int count = curCol.size();
        for (int i = 0; i < count; ++i) {
            CurrencyInfo cur = curCol.get(i);
            if (cur.getId().equals((Object)company.getBaseCurrency().getId())) {
                if (cur.getName().contains(bookCurrency)) {
                    String name = cur.getName();
                    name = name.substring(0, name.indexOf(bookCurrency));
                    cur.setName(name + bookCurrency);
                } else {
                    cur.setName(cur.getName() + bookCurrency);
                }
                newAllCurrency.add(cur);
                continue;
            }
            newAllCurrency.add(cur);
        }
        curCol = newAllCurrency;
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select acPeriod.* where systemStatus.name=6 and company.id='" + company.getId().toString() + "'");
        PeriodInfo acPeriod = ctrols.size() > 0 && ctrols.get(0).getAcPeriod() != null ? ctrols.get(0).getAcPeriod() : null;
        PeriodInfo[] periods = this.getPeriods(ctx, company);
        result.add(acPeriod != null ? acPeriod : periods[0]);
        result.add(periods[2]);
        result.add(periods[1]);
        result.add(curCol);
        otherCtx.put("CURRENTPERIOD", periods[2]);
        boolean isAllClosed = this._isAllClosed(ctx, otherCtx);
        boolean isNonClosed = false;
        isNonClosed = this.isNonClosed(ctx, otherCtx);
        result.add(isAllClosed);
        result.add(isNonClosed);
        result.add(InitHelp.getAccountTableCollection(ctx));
        result.add(hmParamValue.get("G010"));
        otherCtx.put("CURRENTPERIOD", periods[2]);
        result.add(this.getAssistTypeList(ctx, otherCtx));
        String[] closedAccount = this.getAllInitClosed(ctx, otherCtx);
        result.add(closedAccount);
        try {
            result.add(this.getAllAcctCussentAccountBySql(ctx, otherCtx));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.add(hmParamValue.get("GL_012"));
        return result;
    }

    public ArrayList getCanClosedAndCancelAccounts(Context ctx, String asstAccountId, HashMap otherCtx) throws BOSException, EASBizException {
        ArrayList<Object> result = new ArrayList<Object>(4);
        try {
            LowTimer low = new LowTimer();
            low.reset();
            ArrayList allcolsed = this.getAllCloseAccount(ctx, otherCtx);
            low.reset();
            AccountViewCollection col = this.getAllAccount(ctx, asstAccountId, otherCtx);
            low.reset();
            AccountViewCollection canCloseInitAccount = new AccountViewCollection();
            AccountViewCollection cancelInitAccount = new AccountViewCollection();
            if (col != null && col.size() > 0) {
                for (int i = 0; i < col.size(); ++i) {
                    AccountViewInfo info = col.get(i);
                    if (allcolsed.contains(info.getId().toString())) {
                        cancelInitAccount.add(info);
                        continue;
                    }
                    canCloseInitAccount.add(info);
                }
            }
            result.add(canCloseInitAccount);
            result.add(cancelInitAccount);
            AccountViewCollection allAccountCol = this.getAllAccount(ctx, null, otherCtx);
            int allAccount = allAccountCol.size();
            low.reset();
            int hasColse = allcolsed.size();
            boolean isAllClosed = allAccount == hasColse;
            boolean isNonClosed = hasColse == 0;
            result.add(isAllClosed);
            result.add(isNonClosed);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public AccountViewCollection getAllAccount(Context ctx, String asstAccountId, HashMap otherCtx) throws BOSException {
        String companyid = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        String accountid = (String)otherCtx.get("Account");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyid));
        if (!StringUtils.isEmpty((String)accounttableid)) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accounttableid));
        }
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        if (!StringUtils.isEmpty((String)asstAccountId)) {
            filter.getFilterItems().add(new FilterItemInfo("CAA.id", (Object)asstAccountId));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("ac", (Object)new Integer(1)));
        if (!StringUtils.isEmpty((String)accountid)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountid));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("ac"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("accountTypeID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        return av.getAccountViewCollection(view);
    }

    private ArrayList getAllCloseAccount(Context ctx, HashMap otherCtx) throws BOSException, SQLException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttable = (String)otherCtx.get("ACCOUNTTABLEID");
        String sql = "select distinct fkey from t_gl_flag flag,t_BD_AccountView acc where flag.forgunitid=?  and flag.fname='cussentinit' and flag.fvalue='true' and acc.faccounttableid=? and acc.fid=flag.fkey and acc.fcaa is not null and acc.fisleaf=1 and acc.fac = 1 and acc.fcompanyid=? and fname = 'astinit' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId, accounttable, orgUnitId});
        ArrayList<String> result = new ArrayList<String>();
        if (rs != null) {
            while (rs.next()) {
                result.add(rs.getString("fkey"));
            }
        }
        return result;
    }

    public IObjectCollection getAllAcctCussentAccountBySql(Context ctx, HashMap otherCtx) throws BOSException, SQLException {
        AsstAccountCollection result = new AsstAccountCollection();
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String accouttable = (String)otherCtx.get("ACCOUNTTABLEID");
        String loc = ctx.getLocale().getLanguage();
        String sql = "select asstAccount.fid as asstAccountId,asstAccount.fcount as asstcount,asstAccount.fnumber as asstAccountNumber,asstAccount.fname_" + loc + " as asstAccountName ,asstAccount.fisqty,asstAccount.fmeasureunitid ,asstAccount.fmeasureunitgroupid, asstActType.fid as asstActTypeId, \t\n asstActType.fname_" + loc + " as asstActTypeName ,asstActType.fnumber asstActTypeNumber,asstActType.fdefaultf7ui,asstActType.fasstHGAttribute,asstActType.fdefaultQueryName,\n asstActType.fisForCompany,asstActType.fIsMultilevel,asstActType.fglAsstActTypeGrpid,asstActType.frealtionDataObject,asstActType.fmappingFieldName,m.fname_" + loc + " as fmeasureunitname,m.fcoefficient,b.fac,asstActType.FUseLongNumber \n from t_bd_asstactgroupdetail a\t \n inner join t_bd_accountview b on b.fcaa = a.fasstaccountid\n inner join t_bd_asstaccount asstAccount on a.fasstaccountid = asstAccount.fid\t\n inner join t_bd_asstacttype asstActType on a.fasstActTypeid = asstActType.fid\t\n left join t_bd_measureunit m on asstAccount.fmeasureunitid=m.fid \n where b.fcompanyid=? and b.faccounttableid=? and b.fisleaf=1 and b.fac = 1 \n order by asstAccountId desc,a.fseq,asstActTypeNumber  \n";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{curCompany.getId().toString(), accouttable});
        if (set != null) {
            HashMap<String, AsstAccountInfo> cache = new HashMap<String, AsstAccountInfo>();
            while (set.next()) {
                String asstid = set.getString("asstAccountId");
                AsstAccountInfo temp = null;
                if (cache.containsKey(asstid)) {
                    temp = (AsstAccountInfo)cache.get(asstid);
                    if (set.getBoolean("fac")) {
                        temp.setBoolean("isAc", true);
                    }
                } else {
                    temp = new AsstAccountInfo();
                    temp.setId(BOSUuid.read((String)asstid));
                    temp.setNumber(set.getString("asstAccountNumber"));
                    temp.setCount(set.getInt("asstcount"));
                    temp.setName(set.getString("asstAccountName"));
                    temp.put("asstTypeCol", (Object)new AsstActTypeCollection());
                    temp.setIsQty(set.getBoolean("fisqty"));
                    temp.setBoolean("isAc", set.getBoolean("fac"));
                    if (set.getString("fmeasureunitid") != null) {
                        MeasureUnitInfo unit = new MeasureUnitInfo();
                        unit.setId(BOSUuid.read((String)set.getString("fmeasureunitid")));
                        unit.setName(set.getString("fmeasureunitname"));
                        unit.setCoefficient(set.getBigDecimal("fcoefficient"));
                        temp.setMeasureUnit(unit);
                    }
                    if (set.getString("fmeasureunitgroupid") != null) {
                        MeasureUnitGroupInfo unitGroup = new MeasureUnitGroupInfo();
                        unitGroup.setId(BOSUuid.read((String)set.getString("fmeasureunitgroupid")));
                        temp.setMeasureUnitGroup(unitGroup);
                    }
                    result.add(temp);
                    cache.put(asstid, temp);
                }
                AsstActTypeInfo type = new AsstActTypeInfo();
                type.setId(BOSUuid.read((String)set.getString("asstActTypeId")));
                type.setNumber(set.getString("asstActTypeNumber"));
                type.setName(set.getString("asstActTypeName"));
                type.setAsstHGAttribute(set.getString("fasstHGAttribute"));
                type.setMappingFieldName(set.getString("fmappingFieldName"));
                type.setDefaultQueryName(set.getString("fdefaultQueryName"));
                type.setRealtionDataObject(set.getString("frealtionDataObject"));
                type.setDefaultF7UI(set.getString("fdefaultf7ui"));
                type.setIsForCompany(set.getBoolean("fisForCompany"));
                type.setUseLongNumber(set.getBoolean("FUseLongNumber"));
                type.setIsMultilevel(set.getBoolean("fIsMultilevel"));
                String fglAsstActTypeGrpid = set.getString("fglAsstActTypeGrpid");
                if (fglAsstActTypeGrpid != null) {
                    GeneralAsstActTypeGroupInfo info = new GeneralAsstActTypeGroupInfo();
                    info.setId(BOSUuid.read((String)fglAsstActTypeGrpid));
                    type.setGlAsstActTypeGrp(info);
                }
                ((AsstActTypeCollection)temp.get("asstTypeCol")).add(type);
            }
        }
        return result;
    }

    private PeriodInfo[] getPeriods(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return InitHelp.getPeriods(ctx, company);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _closeInit(Context ctx, IObjectCollection accounts, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select startPeriod.*,currentPeriod.*,acPeriod.* where systemStatus.name=6 and company.id='" + orgUnitId + "'");
        if (ctrols.size() > 0 && ctrols.get(0).getAcPeriod() != null && ctrols.get(0).getCurrentPeriod() != null && ctrols.get(0).getCurrentPeriod().getId().toString().equals(ctrols.get(0).getAcPeriod().getId().toString())) {
            otherCtx.put("isEnableACPeriod", Boolean.TRUE);
            otherCtx.put("ACPeriod", ctrols.get(0).getAcPeriod());
        }
        if (ctrols.size() > 0 && ctrols.get(0).getStartPeriod() != null && ctrols.get(0).getCurrentPeriod() != null) {
            boolean allowCussent;
            if (ctrols.get(0).getAcPeriod() != null && ctrols.get(0).getCurrentPeriod().getId().toString().equals(ctrols.get(0).getAcPeriod().getId().toString())) {
                otherCtx.put("isEnableACPeriod", Boolean.TRUE);
                otherCtx.put("ACPeriod", ctrols.get(0).getAcPeriod());
            }
            if (ctrols.get(0).getAcPeriod() != null && ctrols.get(0).getCurrentPeriod().getNumber() > ctrols.get(0).getAcPeriod().getNumber()) {
                otherCtx.put("isEnableACPeriod", Boolean.TRUE);
                otherCtx.put("ACPeriod", ctrols.get(0).getAcPeriod());
                otherCtx.put("isAfterAcPeriod", Boolean.TRUE);
            }
            if (ctrols.get(0).getAcPeriod() == null && (allowCussent = GlUtils.getDefaultGLParam(ctx, orgUnitId, "GL_028"))) {
                if (ctrols.get(0).getCurrentPeriod().getId().toString().equals(ctrols.get(0).getStartPeriod().getId().toString())) {
                    otherCtx.put("isEnableACPeriod", Boolean.TRUE);
                    otherCtx.put("ACPeriod", ctrols.get(0).getStartPeriod());
                } else {
                    otherCtx.put("isEnableACPeriod", Boolean.TRUE);
                    otherCtx.put("ACPeriod", ctrols.get(0).getStartPeriod());
                    otherCtx.put("isAfterAcPeriod", Boolean.TRUE);
                }
            }
        }
        AccountViewCollection col = (AccountViewCollection)accounts;
        PeriodInfo currentPeriod = (PeriodInfo)otherCtx.get("CURRENTPERIOD");
        if (col.size() == 1) {
            if (!InitHelp.acAccountInitPeriodIsCurrentPeriod(ctx, col.get(0), orgUnitId, currentPeriod)) {
                throw new InitException(InitException.CHECK_CANCLOSEINIT);
            }
        } else {
            accounts = InitHelp.getInitPeriodIsCurrentPeriodAccounts(ctx, col, orgUnitId, currentPeriod, true);
        }
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            this.checkCloseInit(ctx, accounts, otherCtx);
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
        }
        int size = accounts.size();
        String[] ids = new String[size];
        boolean[] flags = new boolean[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = col.get(i).getId().toString();
            flags[i] = true;
        }
        InitHelp.getFlagCtrl(ctx).setCussentInitClosed(ids, flags, orgUnitId);
        this.setCussentIsInitClosed(ctx, ids, true, orgUnitId);
    }

    private void setCussentIsInitClosed(Context ctx, String[] accountIds, boolean b, String orgUnitId) throws BOSException {
        if (accountIds == null || accountIds.length == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("update t_gl_acctcussent set fisinitclosed=? where fisinit=1 and fcompanyid=? and faccountid in (");
        int len = accountIds.length;
        for (int i = 0; i < len; ++i) {
            sql.append("?,");
        }
        sql.replace(sql.length() - 1, sql.length(), ")");
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            int index = 1;
            ps.setInt(index++, b ? 1 : 0);
            ps.setString(index++, orgUnitId);
            for (int i = 0; i < len; ++i) {
                ps.setString(index++, accountIds[i]);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private void checkDataIntegrity(Context ctx, String companyId, String[] accounts) throws EASBizException, BOSException {
        StringBuffer msgStr = new StringBuffer();
        if (accounts.length <= 0) {
            return;
        }
        HashSet<String> accountSet = new HashSet<String>();
        StringBuffer accountStr = new StringBuffer();
        for (int i = 0; i < accounts.length; ++i) {
            accountStr.append("'").append(accounts[i]).append("'");
            if (i == accounts.length - 1) continue;
            accountStr.append(",");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select bal.faccountid, acct.fnumber, ass.FASSGRPID as fassistgrpid, hg.FASSTACCOUNTID  from t_gl_acctcussent bal \r\n");
        sql.append("inner join t_bd_accountview acct on bal.faccountid = acct.fid \r\n");
        sql.append("inner join t_gl_voucherassistrecord ass on bal.FVCHASSISTRECORDID = ass.fid \r\n");
        sql.append("inner join t_bd_assistanthg hg on ass.FASSGRPID = hg.fid \r\n");
        sql.append("where bal.fcompanyid = ? and bal.faccountid in ( \r\n");
        sql.append(accountStr).append(") \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId});
        if (rs.size() > 0) {
            try {
                while (rs.next()) {
                    String faccountid = rs.getString("faccountid");
                    String fnumber = rs.getString("fnumber");
                    if (accountSet.contains(fnumber)) continue;
                    String fassistgrpid = rs.getString("fassistgrpid");
                    String fasstaccountid = rs.getString("fasstaccountid");
                    if (fasstaccountid == null || fassistgrpid == null) continue;
                    List typeList = this.getAsstAccountType(ctx, fasstaccountid);
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    String temp = null;
                    for (int i = 0; i < typeList.size(); ++i) {
                        temp = (String)typeList.get(i);
                        if ("bankAccount".equals(temp)) {
                            selectors.add(new SelectorItemInfo("bankAccount.*"));
                            continue;
                        }
                        selectors.add(new SelectorItemInfo(temp + ".id"));
                    }
                    AssistantHGInfo hgInfo = this.getHgInfo(ctx, fassistgrpid, selectors);
                    for (int i = 0; i < typeList.size(); ++i) {
                        String attr = (String)typeList.get(i);
                        if (hgInfo.getObjectValue(attr) != null) continue;
                        String msg = MessageFormat.format(EASResource.getString((String)GL_RESOURCE, (String)"1033"), fnumber);
                        msgStr.append(msg).append("\r\n");
                        accountSet.add(fnumber);
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (msgStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("103", msgStr.toString()));
        }
    }

    private AssistantHGInfo getHgInfo(Context ctx, String fassistgrpid, SelectorItemCollection selectors) throws EASBizException, BOSException {
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, this.getClass().getName() + "getHgInfo");
        if (datas.containsKey(fassistgrpid)) {
            return (AssistantHGInfo)datas.get(fassistgrpid);
        }
        AssistantHGInfo hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(fassistgrpid), selectors);
        datas.put(fassistgrpid, hgInfo);
        return hgInfo;
    }

    private List getAsstAccountType(Context ctx, String fasstaccountid) throws BOSException, SQLException {
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, this.getClass().getName() + "getAsstAccountType");
        if (datas.containsKey(fasstaccountid)) {
            return (List)datas.get(fasstaccountid);
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> typeList = new ArrayList<String>();
        sql.append("SELECT ty.fassthgattribute attr FROM T_BD_AsstActGroupDetail aagdChild   \r\n");
        sql.append("INNER JOIN T_BD_AsstActType ty on aagdChild.FAsstActTypeID = ty.fid    \r\n");
        sql.append("WHERE aagdChild.FAsstAccountID = ? \r\n");
        IRowSet typeRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{fasstaccountid});
        while (typeRs != null && typeRs.next()) {
            String actType = typeRs.getString("attr");
            typeList.add(actType);
        }
        datas.put(fasstaccountid, typeList);
        return typeList;
    }

    private void checkCloseInit(Context ctx, IObjectCollection accountCol, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String orgUnitId = company.getId().toString();
        AccountViewCollection col = (AccountViewCollection)accountCol;
        int size = col.size();
        String[] accounts = new String[size];
        for (int i = 0; i < size; ++i) {
            AccountViewInfo info = col.get(i);
            accounts[i] = info.getId().toString();
        }
        if (company.isIsAssistantOrg()) {
            String masterTable;
            CompanyOrgUnitInfo masterCompany = company.getMainOrg();
            String curTable = company.getAccountTable().getId().toString();
            if (curTable.equals(masterTable = masterCompany.getAccountTable().getId().toString())) {
                this.checkDataIntegrity(ctx, orgUnitId, accounts);
            }
        }
        col = InitHelp.getInitedAsstAccountViewCollection(ctx, accounts, orgUnitId);
        InitHelp.checkAsstEqualCussent(ctx, col, otherCtx);
    }

    @Override
    protected void _cancelInit(Context ctx, IObjectCollection accounts, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        AccountViewCollection col = (AccountViewCollection)accounts;
        PeriodInfo currentPeriod = (PeriodInfo)otherCtx.get("CURRENTPERIOD");
        if (col.size() == 1) {
            if (!InitHelp.acAccountInitPeriodIsCurrentPeriod(ctx, col.get(0), orgUnitId, currentPeriod)) {
                throw new InitException(InitException.CHECK_CANCELINIT);
            }
        } else {
            col = InitHelp.getInitPeriodIsCurrentPeriodAccounts(ctx, col, orgUnitId, currentPeriod, false);
        }
        InitHelp.checkCancelInitForCussent(ctx, col, otherCtx);
        int size = col.size();
        String[] ids = new String[size];
        boolean[] flags = new boolean[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = col.get(i).getId().toString();
            flags[i] = false;
        }
        InitHelp.getFlagCtrl(ctx).setCussentInitClosed(ids, flags, orgUnitId);
        this.setCussentIsInitClosed(ctx, ids, false, orgUnitId);
    }

    @Override
    protected IObjectValue _fillHGId(Context ctx, IObjectValue hg, String[] propNames) throws BOSException, EASBizException {
        return InitHelp.fillHGId(ctx, hg, propNames);
    }

    @Override
    protected void _closeAllInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        IObjectCollection col = InitHelp.getCanCloseInitAcctCussentAccountCurrentPeriod(ctx, otherCtx);
        this._closeInit(ctx, col, otherCtx);
    }

    @Override
    protected void _cancelAllInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        IObjectCollection col = this.getCanCancelInitAccount(ctx, otherCtx);
        this._cancelInit(ctx, col, otherCtx);
    }

    public String[] getAllInitClosed(Context ctx, HashMap otherCtx) throws BOSException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        PeriodInfo period = (PeriodInfo)otherCtx.get("CURRENTPERIOD");
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        String[] result = flag.getAllCussentInitClosedByPeriod(company, period);
        return result;
    }

    public IObjectCollection getCanCancelInitAccount(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String[] accountIds = this.getAllInitClosed(ctx, otherCtx);
        FilterInfo filter = new FilterInfo();
        StringBuffer str = new StringBuffer();
        if (accountIds == null) {
            return new AccountViewCollection();
        }
        for (int i = 0; i < accountIds.length; ++i) {
            str.append(",").append(accountIds[i]);
        }
        str.deleteCharAt(0);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        AccountViewCollection col = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        return col;
    }

    @Override
    protected boolean _isAllClosed(Context ctx, Map otherCtx) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            boolean bl;
            String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
            String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
            PeriodInfo currentPeriod = (PeriodInfo)otherCtx.get("CURRENTPERIOD");
            String sql = "select top 1 account.fid from t_BD_AccountView account  where account.fcompanyid=? and faccountTableid=? and account.fac=1 and account.fcaa is not null and account.fisleaf=1 and account.fid not in(select fkey from t_gl_flag flag inner join t_bd_period bp on bp.fid = flag.finitperiodid where flag.forgunitid=? and flag.fname=? and (flag.fvalue=? or bp.fnumber>?))";
            con = null;
            ps = null;
            rs = null;
            try {
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql);
                int index = 1;
                ps.setString(index++, orgUnitId);
                ps.setString(index++, accounttableid);
                ps.setString(index++, orgUnitId);
                ps.setString(index++, "cussentinit");
                ps.setString(index++, "true");
                ps.setInt(index++, currentPeriod.getNumber());
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                bl = false;
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return true;
    }

    private boolean isNonClosed(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            boolean bl;
            String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
            String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
            String sql = "select top 1 account.fid from t_BD_AccountView account  inner join (select flag.fkey from t_gl_flag flag where flag.forgunitid=? and flag.fname=? and flag.fvalue=?) flag on account.fid=flag.fkey where account.fcompanyid=? and faccountTableid=?  and account.fcaa is not null  and account.fac=1 and account.fisleaf=1";
            con = null;
            ps = null;
            rs = null;
            try {
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql);
                int index = 1;
                ps.setString(index++, orgUnitId);
                ps.setString(index++, "cussentinit");
                ps.setString(index++, "true");
                ps.setString(index++, orgUnitId);
                ps.setString(index++, accounttableid);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                bl = false;
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void _importBalance(Context ctx, IObjectValue _company, IObjectCollection _accounts, IObjectValue _currency) throws BOSException, EASBizException {
        company = (CompanyOrgUnitInfo)_company;
        accounts = (AccountViewCollection)_accounts;
        currency = (CurrencyInfo)_currency;
        allowCussent = GlUtils.getDefaultGLParam(ctx, company.getId().toString(), "GL_028");
        if (!allowCussent) {
            throw new GLException(GLException.CUSSENTNOTALLOW);
        }
        toImport = new AccountViewCollection();
        currentPeriod = GlUtils.getCurrentPeriod(ctx, company.getId().toString());
        unclosedAccounts = InitHelp.getCussentInitAccount(ctx, company, currentPeriod, false);
        if (unclosedAccounts != null && unclosedAccounts.length > 0) {
            unclosedAcct = Arrays.asList(unclosedAccounts);
            for (i = 0; i < accounts.size(); ++i) {
                if (!unclosedAcct.contains(accounts.get(i).getId().toString())) continue;
                toImport.add(accounts.get(i));
            }
        }
        if (toImport.size() > 0) {
            period = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
            startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(company.getId().toString()));
            accountInfoMap = new HashMap<String, AccountViewInfo>();
            accountidSet = new HashSet<String>();
            for (i = 0; i < toImport.size(); ++i) {
                accountid = toImport.get(i).getId().toString();
                accountInfoMap.put(accountid, accounts.get(i));
                accountidSet.add(accountid);
            }
            ids = this.idSetToStringSql(accountidSet);
            deleteAsst = "delete from t_gl_voucherassistrecord where fid in ";
            deleteAsst = deleteAsst + "(select FVCHASSISTRECORDID from t_gl_acctcussent where fisinit=1 and fcompanyid=? and faccountid in(" + ids + ") and fcurrencyid=?) ";
            deleteCussent = "delete from t_gl_acctcussent where fisinit=1 and fcompanyid=? and faccountid in(" + ids + ") and fcurrencyid=? ";
            rs1 = null;
            rs2 = null;
            sql = new StringBuffer();
            if (currentPeriod.getNumber() == startPeriod.getNumber()) {
                try {
                    sql.append("select a.fassistgrpid,a.faccountid,sum(a.FBEGINBALANCEFOR*v.fdc) fendbalancefor,sum(a.FBEGINBALANCELOCAL*v.fdc) fendbalancelocal,sum(a.FBEGINBALANCERPT*v.fdc) fendbalancerpt,sum(a.FBEGINQTY*v.fdc) fqty,a.FMEASUREUNITID  fmeasureunitid\r\n");
                    sql.append("from " + GLBalanceUtils.getAssistMeasureBalanceTable(1) + " a inner join t_bd_accountview v on v.fid=a.faccountid where a.faccountid in(").append(ids).append(") and a.fcurrencyid=? and a.forgunitid=? and a.fperiod=?                      \r\n");
                    sql.append("group by a.fassistgrpid,a.faccountid,a.FMEASUREUNITID order by a.fassistgrpid ");
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currency.getId().toString(), company.getId().toString(), currentPeriod.getNumber()});
                    while (rs1.next()) {
                        accountid = rs1.getString("faccountid");
                        if (!accountidSet.contains(accountid)) continue;
                        accountidSet.remove(accountid);
                    }
                    if (accountidSet.isEmpty()) ** GOTO lbl91
                    sql.setLength(0);
                    ids = this.idSetToStringSql(accountidSet);
                    sql.append("select a.fassistgrpid,a.faccountid,sum(a.FBEGINBALANCEFOR*v.fdc) fendbalancefor,sum(a.FBEGINBALANCELOCAL*v.fdc) fendbalancelocal,sum(a.FBEGINBALANCERPT*v.fdc) fendbalancerpt  \r\n");
                    sql.append("from " + GLBalanceUtils.getAssistBalanceTable(1) + " a inner join t_bd_accountview v on v.fid=a.faccountid where a.faccountid in(").append(ids).append(") and a.fcurrencyid=? and a.forgunitid=? and a.fperiod=?                      \r\n");
                    sql.append("group by a.fassistgrpid,a.faccountid order by a.fassistgrpid ");
                    rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currency.getId().toString(), company.getId().toString(), currentPeriod.getNumber()});
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                try {
                    sql.append("select a.fassistgrpid,a.faccountid,sum(a.fendbalancefor*v.fdc) fendbalancefor,sum(a.fendbalancelocal*v.fdc) fendbalancelocal,sum(a.fendbalancerpt*v.fdc) fendbalancerpt,sum(a.FBEGINQTY*v.fdc) fqty,a.FMEASUREUNITID  fmeasureunitid  \r\n");
                    sql.append("from " + GLBalanceUtils.getAssistMeasureBalanceTable(1) + " a inner join t_bd_accountview v on v.fid=a.faccountid where a.faccountid in(").append(ids).append(") and a.fcurrencyid=? and a.forgunitid=? and a.fperiod=?                      \r\n");
                    sql.append("group by a.fassistgrpid,a.faccountid,a.FMEASUREUNITID order by a.fassistgrpid ");
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currency.getId().toString(), company.getId().toString(), period.getNumber()});
                    while (rs1.next()) {
                        accountid = rs1.getString("faccountid");
                        if (!accountidSet.contains(accountid)) continue;
                        accountidSet.remove(accountid);
                    }
                    if (!accountidSet.isEmpty()) {
                        sql.setLength(0);
                        ids = this.idSetToStringSql(accountidSet);
                        sql.append("select a.fassistgrpid,a.faccountid,sum(a.fendbalancefor*v.fdc) fendbalancefor,sum(a.fendbalancelocal*v.fdc) fendbalancelocal,sum(a.fendbalancerpt*v.fdc) fendbalancerpt  \r\n");
                        sql.append("from " + GLBalanceUtils.getAssistBalanceTable(1) + " a inner join t_bd_accountview v on v.fid=a.faccountid where a.faccountid in(").append(ids).append(") and a.fcurrencyid=? and a.forgunitid=? and a.fperiod=?                      \r\n");
                        sql.append("group by a.fassistgrpid,a.faccountid order by a.fassistgrpid ");
                        rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currency.getId().toString(), company.getId().toString(), period.getNumber()});
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
lbl91:
            // 3 sources

            try {
                rs1.beforeFirst();
                if (rs2 != null) {
                    rs2.beforeFirst();
                }
                if (rs1.next() || rs2 != null && rs2.next()) {
                    DbUtil.execute((Context)ctx, (String)deleteAsst, (Object[])new Object[]{company.getId().toString(), currency.getId().toString()});
                    DbUtil.execute((Context)ctx, (String)deleteCussent, (Object[])new Object[]{company.getId().toString(), currency.getId().toString()});
                }
                rs1.beforeFirst();
                if (rs2 != null) {
                    rs2.beforeFirst();
                }
                measureUnitMap = new HashMap<String, MeasureUnitInfo>();
                if (rs1.next()) {
                    measureIds = new HashSet<String>();
                    while (rs1.next()) {
                        measureIds.add(rs1.getString("fmeasureunitid"));
                    }
                    ev = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", measureIds, CompareType.INCLUDE));
                    ev.setFilter(filter);
                    measureColl = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(ev);
                    for (i = 0; i < measureColl.size(); ++i) {
                        measure = measureColl.get(i);
                        measureUnitMap.put(measure.getId().toString(), measure);
                    }
                }
                rs1.beforeFirst();
                while (rs1.next()) {
                    this.insertCussentInfo(ctx, rs1, company, currentPeriod, currency, accountInfoMap, measureUnitMap);
                }
                while (rs2 != null && rs2.next()) {
                    this.insertCussentInfo(ctx, rs2, company, currentPeriod, currency, accountInfoMap, null);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private String idSetToStringSql(Set<String> idSet) {
        if (idSet == null || idSet.isEmpty()) {
            return "";
        }
        Iterator<String> itr = idSet.iterator();
        StringBuilder sb = new StringBuilder();
        while (itr.hasNext()) {
            sb.append("'").append(itr.next()).append("'").append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void insertCussentInfo(Context ctx, IRowSet rs, CompanyOrgUnitInfo company, PeriodInfo currentPeriod, CurrencyInfo currency, Map<String, AccountViewInfo> accountInfoMap, Map<String, MeasureUnitInfo> measureUnitMap) throws EASBizException, SQLException, BOSException {
        AcctCussentInfo cussent = new AcctCussentInfo();
        cussent.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        cussent.setCreateTime(new Timestamp(System.currentTimeMillis()));
        cussent.setCompany(company);
        AccountViewInfo account = new AccountViewInfo();
        account.setId(BOSUuid.read((String)rs.getString("faccountid")));
        cussent.setEntrydc(accountInfoMap.get(rs.getString("faccountid")).getDC().getValue());
        cussent.setAccount(account);
        cussent.setCurrency(currency);
        cussent.setUnVerifiedAmtFor(rs.getBigDecimal("fendbalancefor"));
        cussent.setUnHoldedAmtFor(rs.getBigDecimal("fendbalancefor"));
        cussent.setUnVerifiedAmtLocal(rs.getBigDecimal("fendbalancelocal"));
        cussent.setUnHoldedAmtLocal(rs.getBigDecimal("fendbalancelocal"));
        cussent.setUnVerifiedAmtRpt(rs.getBigDecimal("fendbalancerpt"));
        cussent.setUnHoldedAmtRpt(rs.getBigDecimal("fendbalancerpt"));
        cussent.setIsInit(true);
        cussent.setIsInitClosed(false);
        cussent.setCU(company.getCU());
        if (measureUnitMap != null) {
            MeasureUnitInfo measureUnit = measureUnitMap.get(rs.getString("fmeasureunitid"));
            cussent.setMeasureUnit(measureUnit);
            cussent.setQuantity(rs.getBigDecimal("fqty"));
        }
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        otherCtx.put("COMPANY", company);
        otherCtx.put("Account", account);
        otherCtx.put("Currency", currency);
        String key = company.getId().toString() + account.getId().toString() + currency.getId().toString();
        int seq = 1;
        if (!this.importSeqMap.containsKey(key)) {
            this.importSeqMap.put(key, this._getMaxInitSeq(ctx, otherCtx));
        }
        seq = Integer.parseInt(this.importSeqMap.get(key).toString());
        this.importSeqMap.put(key, ++seq);
        cussent.setSeq(seq);
        VoucherAssistRecordInfo asstinfo = new VoucherAssistRecordInfo();
        AssistantHGInfo hg = new AssistantHGInfo();
        hg.setId(BOSUuid.read((String)rs.getString("fassistgrpid")));
        asstinfo.setAssGrp(hg);
        asstinfo.setSeq(0);
        asstinfo.setBizDate(DateTimeUtils.addDay((Date)currentPeriod.getBeginDate(), (long)-1L));
        asstinfo.setOriginalAmount(rs.getBigDecimal("fendbalancefor"));
        asstinfo.setLocalAmount(rs.getBigDecimal("fendbalancelocal"));
        asstinfo.setReportingAmount(rs.getBigDecimal("fendbalancerpt"));
        BigDecimal qty = BigDecimal.ZERO;
        try {
            qty = rs.getBigDecimal("fqty");
        }
        catch (Exception e) {
            qty = BigDecimal.ZERO;
        }
        asstinfo.setQuantity(qty);
        asstinfo.setStandardQuantity(qty);
        if (measureUnitMap != null && measureUnitMap.size() > 0 && rs.getString("fmeasureunitid") != null && measureUnitMap.get(rs.getString("fmeasureunitid")) != null) {
            asstinfo.setStandardQuantity(measureUnitMap.get(rs.getString("fmeasureunitid")).getCoefficient().multiply(qty));
        }
        asstinfo.setEndDate(asstinfo.getBizDate());
        asstinfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"883_AcctCussentInitFacadeControllerBean", (Locale)ctx.getLocale()));
        cussent.setVchAssistRecord(asstinfo);
        InitHelp.addRongYu4AcctCussent(ctx, cussent, asstinfo);
        AcctCussentFactory.getLocalInstance(ctx).submit((CoreBaseInfo)cussent);
    }

    @Override
    protected boolean _isAcControlPeriod(Context ctx, IObjectValue company) throws BOSException, EASBizException {
        String sql = "select fid from t_bd_systemstatusctrol where facPeriodid is not null and facPeriodid=fcurrentperiodid and FCompanyID=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{company.get("id").toString()});
        try {
            return rs.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getAssistTypeList(Context ctx, Map otherCtx) throws BOSException, EASBizException {
        HashMap<String, AsstActTypeCollection> result = new HashMap<String, AsstActTypeCollection>();
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String accouttable = (String)otherCtx.get("ACCOUNTTABLEID");
        String loc = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        Object flg = otherCtx.get("ENABLE_ASST_CHANGE_VERSION");
        boolean isAsstChange = flg == null ? false : (Boolean)flg;
        Object[] param = null;
        sql.append("select p.fid as accountId, asstActType.fid as asstActTypeId, asstActType.fname_" + loc + " as asstActTypeName, \r\n");
        sql.append("asstActType.fnumber asstActTypeNumber, asstActType.fdefaultf7ui, asstActType.fasstHGAttribute, \r\n");
        sql.append("asstActType.fdefaultQueryName, asstActType.fisForCompany, asstActType.fIsMultilevel, \r\n");
        sql.append("asstActType.fglAsstActTypeGrpid, asstActType.frealtionDataObject, asstActType.fmappingFieldName, \r\n");
        sql.append("asstActType.FUseLongNumber from  \r\n");
        sql.append(" ( select distinct case when t.faccountid is not null then t.faccountid  else p.fid end fid,");
        sql.append("  case when t.faccountid is not null then t.fbeforeid  else p.fcaa end fcaa,");
        sql.append("  case when t.faccountid is not null then t.fasstActTypeid else p.fasstActTypeid end fasstActTypeid,");
        sql.append("  case when t.faccountid is not null then t.FSEQ  else p.FSEQ end FSEQ ");
        sql.append(" from ( select av.fid,  av.fcaa,asstdetail.fasstActTypeid, asstdetail.fseq ");
        sql.append("  from t_bd_asstactgroupdetail asstdetail ");
        sql.append(" left outer join t_bd_accountview av on av.fcaa = asstdetail.fasstaccountid ");
        sql.append(" where av.fcompanyid = ? and av.faccounttableid = ? and av.fisleaf = 1 and av.fac = 1) p ");
        sql.append(" left outer join (select aac.faccountid, aac.fbeforeid,aag.fasstActTypeid,aag.FSEQ  ");
        sql.append(" from T_BD_AsstAccountChange aac ");
        sql.append(" inner join T_BD_ACCOUNTVIEW avv on aac.faccountid = avv.FID ");
        sql.append(" inner join t_bd_asstactgroupdetail aag on aac.fbeforeid = aag.fasstaccountid ");
        sql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid = avv.fcompanyid ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.FSYSTEMSTATUSID ");
        if (isAsstChange) {
            PeriodInfo curPeriod = (PeriodInfo)otherCtx.get("CURRENTPERIOD");
            sql.append(" inner join t_bd_period pd on pd.fid = aac.fperiodid ");
            sql.append(" where avv.fcompanyid = ? and avv.faccounttableid = ? and avv.fisleaf = 1 and avv.fac = 1  ");
            sql.append(" and ss.fname = ? and pd.fnumber > ? and ssc.fstartperiodid <>  aac.fperiodid) t ");
            param = new Object[]{curCompany.getId().toString(), accouttable, curCompany.getId().toString(), accouttable, 6, curPeriod.getNumber()};
        } else {
            sql.append(" where avv.fcompanyid = ? and avv.faccounttableid = ? and avv.fisleaf = 1 and avv.fac = 1  ");
            sql.append(" and ss.fname = ? and ssc.fstartperiodid <>  aac.fperiodid) t ");
            param = new Object[]{curCompany.getId().toString(), accouttable, curCompany.getId().toString(), accouttable, 6};
        }
        sql.append(" on p.fid = t.faccountid  ) p \r\n");
        sql.append(" inner join t_bd_asstaccount asstAccount on p.fcaa = asstAccount.fid ");
        sql.append(" inner join t_bd_asstacttype asstActType on p.fasstActTypeid = asstActType.fid ");
        sql.append(" order by p.fid, asstAccount.fnumber, p.fseq ");
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (set != null) {
                while (set.next()) {
                    String accountId = set.getString("accountId");
                    AsstActTypeCollection asstTypes = new AsstActTypeCollection();
                    if (result.containsKey(accountId)) {
                        asstTypes = (AsstActTypeCollection)result.get(accountId);
                    } else {
                        result.put(accountId, asstTypes);
                    }
                    AsstActTypeInfo type = new AsstActTypeInfo();
                    type.setId(BOSUuid.read((String)set.getString("asstActTypeId")));
                    type.setNumber(set.getString("asstActTypeNumber"));
                    type.setName(set.getString("asstActTypeName"));
                    type.setAsstHGAttribute(set.getString("fasstHGAttribute"));
                    type.setMappingFieldName(set.getString("fmappingFieldName"));
                    type.setDefaultQueryName(set.getString("fdefaultQueryName"));
                    type.setRealtionDataObject(set.getString("frealtionDataObject"));
                    type.setDefaultF7UI(set.getString("fdefaultf7ui"));
                    type.setIsForCompany(set.getBoolean("fisForCompany"));
                    type.setUseLongNumber(set.getBoolean("FUseLongNumber"));
                    type.setIsMultilevel(set.getBoolean("fIsMultilevel"));
                    String fglAsstActTypeGrpid = set.getString("fglAsstActTypeGrpid");
                    if (fglAsstActTypeGrpid != null) {
                        GeneralAsstActTypeGroupInfo info = new GeneralAsstActTypeGroupInfo();
                        info.setId(BOSUuid.read((String)fglAsstActTypeGrpid));
                        type.setGlAsstActTypeGrp(info);
                    }
                    asstTypes.add(type);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected boolean _isAccountInitClosed(Context ctx, AccountViewInfo account, Map otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        String[] accounts = new String[]{account.getId().toString()};
        boolean[] result = flag.getCussentInitClosed(accounts, orgUnitId);
        return result.length > 0 ? result[0] : false;
    }

    @Override
    protected int _getMaxInitSeq(Context ctx, Map otherCtx) throws BOSException {
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accountId = ((AccountViewInfo)otherCtx.get("Account")).getId().toString();
        String currencyId = ((CurrencyInfo)otherCtx.get("Currency")).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select max(fseq) fseq from t_gl_acctcussent \r\n");
        sql.append("where fcompanyid = ? and faccountid = ? and fcurrencyid = ? and fisinit = 1 \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, accountId, currencyId});
        int maxSeq = 0;
        try {
            if (rs.next()) {
                maxSeq = rs.getInt("fseq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL Error while getting Max Seq!", (Throwable)e);
        }
        return maxSeq;
    }

    @Override
    protected boolean _isAcPeriodEquGLStartPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        boolean isOk = true;
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 1 from t_bd_systemstatusctrol ssc                           \r\n");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid    \r\n");
        sql.append(" where ss.fname = 6                                               \r\n");
        sql.append(" and ssc.fcompanyid = ?                                             \r\n");
        sql.append(" and ssc.FACPeriodID is not null                                    \r\n");
        sql.append(" and ssc.FStartPeriodID is not null                                    \r\n");
        sql.append(" and ssc.FStartPeriodID <> ssc.FACPeriodID                           \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId});
        try {
            if (rs.next()) {
                isOk = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isOk;
    }

    @Override
    protected IObjectValue _getAccountInitClosePeriod(Context ctx, String accountId, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        if (accountId == null || orgUnitId == null) {
            return null;
        }
        PeriodInfo result = InitHelp.getCussentInitPeriod(ctx, accountId, orgUnitId);
        return result;
    }

    @Override
    protected String[] _getCussentInitAccount(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean isClose) throws BOSException, EASBizException {
        if (company == null || period == null) {
            return new String[0];
        }
        return InitHelp.getCussentInitAccount(ctx, company, period, isClose);
    }

    @Override
    protected void _dealInitFlagWithAccountToAC(Context ctx, IObjectCollection accounts) throws BOSException, EASBizException {
        AccountViewCollection accountCol = (AccountViewCollection)accounts;
        if (accountCol == null || accountCol.isEmpty()) {
            return;
        }
        GlAcctCussentGlFlagDeal glAcFlagDeal = new GlAcctCussentGlFlagDeal();
        glAcFlagDeal.deal(ctx, accountCol);
    }

    @Override
    protected void _assign4FInitPeriodIDOfFlagTab(Context ctx, String companyId) throws BOSException, EASBizException {
        PeriodInfo startPeriod;
        boolean isAllowCussent = Boolean.valueOf(GlUtils.getParamByKey(ctx, companyId, "GL_028").toString());
        if (!isAllowCussent) {
            return;
        }
        SystemStatusCtrolCollection ctrols = null;
        ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select currentPeriod.*,startPeriod.* where systemStatus.name=6 and company.id='" + companyId + "'");
        PeriodInfo currentPeriod = ctrols.size() > 0 && ctrols.get(0).getCurrentPeriod() != null ? ctrols.get(0).getCurrentPeriod() : null;
        PeriodInfo periodInfo = startPeriod = ctrols.size() > 0 && ctrols.get(0).getStartPeriod() != null ? ctrols.get(0).getStartPeriod() : null;
        if (startPeriod == null || currentPeriod == null) {
            return;
        }
        if (currentPeriod.getId().toString().equals(startPeriod.getId().toString())) {
            StringBuffer sqlInsert = new StringBuffer();
            sqlInsert.append(" insert into t_gl_flag (fid, fname, fvalue, forgunitid, fkey, finitperiodid) ");
            sqlInsert.append(" select newbosid('").append(new GLFlagInfo().getBOSType().toString()).append("'),");
            sqlInsert.append(" 'cussentinit', 'false',").append(" a.fcompanyid, a.fid, \r\n");
            sqlInsert.append(" '").append(startPeriod.getId().toString()).append("' ");
            sqlInsert.append(" from t_bd_accountview a ");
            sqlInsert.append(" inner join t_org_company c on c.fid = a.fcompanyid and c.faccounttableid = a.faccounttableid ");
            sqlInsert.append(" where a.fisleaf=1 and a.fcaa is not null  and a.fac=1  ");
            sqlInsert.append(" and a.fcompanyid=? and not exists (select fid from t_gl_flag f where f.fkey=a.fid and f.fname='cussentinit' and f.forgunitid = ?)");
            DbUtil.execute((Context)ctx, (String)sqlInsert.toString(), (Object[])new Object[]{companyId, companyId});
        }
        String sql = "UPDATE T_GL_FLAG set FInitPeriodID = (select isnull(ssc.facperiodid, ssc.fstartperiodid) \nfrom t_bd_systemstatusctrol ssc \ninner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid\nwhere ssc.fcompanyid = T_GL_FLAG.forgunitid  and ss.fname = 6)\nwhere fname = 'cussentinit'\nand FInitPeriodID is null and FOrgUnitId=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{companyId});
    }
}

