/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.AcctCussentHistoryInfo;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.AcctcusssentVerifyParam;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLMutexException;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GLVerifyTypeEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VerifyManualAutoEnum;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AcctCussentVerifyUtils;
import com.kingdee.eas.fi.gl.app.IAcctCussentVerifyService;
import com.kingdee.eas.fi.gl.common.ACAuditCancelFilterHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AcctCussentVerifyService
implements IAcctCussentVerifyService {
    private static Logger logger = Logger.getLogger((String)AcctCussentVerifyService.class.getClass().getName());
    public static final int INTIME_VERIFY_BALTYPE_VALUE = 6;
    public static final int NOT_INTIME_VERIFY_BALTYPE_VALUE = 5;
    public java.util.Date endTime;
    public String companyNumber;
    public String preCompanyNumber;
    public int verifyCount;
    public static int negativeVerifyCnt = 0;
    private MutexParameter mp;
    private IMutexServiceControl mutex;
    private final BigDecimal ZERO = new BigDecimal("0");
    public static final String RES = "com.kingdee.eas.fi.gl.GLMutexResource";
    private long sqlStartTime;
    private long sqlEndTime;
    int cussentNum = 0;
    int verifyNum = 0;
    private long longval = 86400000L;

    public static String getString(Context ctx, String resName) {
        if (ctx != null) {
            return ResourceBase.getString((String)RES, (String)resName, (Locale)ctx.getLocale());
        }
        return EASResource.getString((String)RES, (String)resName);
    }

    @Override
    public void autoVerifyForTransaction(Context ctx, String companyNumbers, boolean uncheckBizNumber, boolean nullBizNumIsNotSame, boolean notIncludeUnpostVch, boolean amtMustSame, boolean negativeVerify, int dayInterval) throws BOSException, EASBizException {
        this.autoVerifyForTransaction(ctx, companyNumbers, uncheckBizNumber, nullBizNumIsNotSame, notIncludeUnpostVch, amtMustSame, false, negativeVerify, dayInterval);
    }

    public void autoVerifyForTransaction(Context ctx, String companyNumbers, boolean uncheckBizNumber, boolean nullBizNumIsNotSame, boolean notIncludeUnpostVch, boolean amtMustSame, boolean verifySameByAmt, boolean negativeVerify, int dayInterval) throws BOSException, EASBizException {
        AcctcusssentVerifyParam verifyParam = null;
        try {
            AcctCussentVerifyUtils.checkParamBeforeStart(uncheckBizNumber, nullBizNumIsNotSame, amtMustSame, verifySameByAmt, negativeVerify);
            String[] companyNums = companyNumbers.split(";");
            if (StringUtils.isEmpty((String)companyNumbers)) {
                companyNums = null;
            }
            verifyParam = this.getVerifyParam(ctx, companyNums, uncheckBizNumber, nullBizNumIsNotSame, notIncludeUnpostVch, amtMustSame, verifySameByAmt, negativeVerify);
            List result = this.getConditionData(ctx, companyNums, verifyParam.getCon());
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM, uncheckBizNumber);
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME, nullBizNumIsNotSame);
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.EXCLUDEUNPOSTVCH, notIncludeUnpostVch);
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME, amtMustSame);
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYSAMEBYAMT, verifySameByAmt);
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NEGATIVEVERIFY, negativeVerify);
            param.put("isTask", true);
            String[] val = null;
            CompanyOrgUnitInfo company = null;
            AccountViewInfo acct = null;
            CurrencyInfo currency = null;
            for (int i = 0; i < result.size(); ++i) {
                val = (String[])result.get(i);
                company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)val[0]));
                param.put("company", company);
                int verifyMode = GlUtils.getVerifyMode(ctx, val[0]);
                if (verifyMode == 1) {
                    param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.EXCLUDEUNPOSTVCH, true);
                } else {
                    if (verifyMode == 0) continue;
                    param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.EXCLUDEUNPOSTVCH, notIncludeUnpostVch);
                }
                acct = new AccountViewInfo();
                acct.setId(BOSUuid.read((String)val[1]));
                param.put("account", acct);
                currency = new CurrencyInfo();
                currency.setId(BOSUuid.read((String)val[2]));
                param.put("currency", currency);
                param.put("companyid", val[0]);
                param.put("accountid", val[1]);
                param.put("actNumber", val[3]);
                param.put("rowMult", dayInterval);
                try {
                    Map rMap = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).verifyDetail(param);
                    boolean completeTx = (Boolean)rMap.get("completeTX");
                    if (completeTx || (completeTx = ((Boolean)(rMap = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).verifyDetail(param)).get("completeTX")).booleanValue())) continue;
                    AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).verifyDetail(param);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof GLMutexException) {
                        logger.error((Object)(logger.getClass() + e.getMessage()));
                        continue;
                    }
                    throw new BOSException((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (verifyParam != null && verifyParam.getCon() != null) {
                SQLUtils.cleanup((Connection)verifyParam.getCon());
            }
        }
    }

    private boolean executeTask(Context ctx, int dayInterval, Map<String, Object> param) throws EASBizException, BOSException {
        try {
            if (dayInterval > 0) {
                long sysTime = System.currentTimeMillis();
                long time = 0L;
                if (param.get("dateFrom") == null) {
                    PeriodInfo p = GlUtils.getStartPeriod(ctx, (String)param.get("companyid"));
                    java.util.Date bDate = p.getBeginDate();
                    time = bDate.getTime();
                } else {
                    time = (Long)param.get("dateFrom");
                }
                while (time < sysTime) {
                    param.put("dateFrom", time);
                    param.put("dateTo", new Date(time += this.longval * (long)dayInterval));
                    AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).verifyDetail(param);
                }
            } else {
                AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).verifyDetail(param);
            }
            return true;
        }
        catch (Exception e) {
            if (e.getCause() instanceof FetchedTooMuchRowsException) {
                dayInterval = this.throwBizExecption(param, e);
                logger.error((Object)("FetchedTooMuchRowsException --> logic 1 ---->" + dayInterval));
                long dateFrom = 0L;
                if (param.get("dateFrom") != null) {
                    dateFrom = (Long)param.get("dateFrom");
                }
                if (dayInterval == 1) {
                    logger.error((Object)("last succucess end date -->" + new Date(dateFrom)));
                    return false;
                }
                param.put("dayInterval", dayInterval);
                return this.executeTask(ctx, dayInterval, param);
            }
            if (e.getMessage() != null && e.getMessage().contains("FetchedTooMuchRowsException")) {
                dayInterval = this.throwBizExecption(param, e);
                logger.error((Object)("FetchedTooMuchRowsException --> logic 2 ---->" + dayInterval));
                long dateFrom = 0L;
                if (param.get("dateFrom") != null) {
                    dateFrom = (Long)param.get("dateFrom");
                }
                if (dayInterval == 1) {
                    logger.error((Object)("last succucess end date -->" + new Date(dateFrom)));
                    return false;
                }
                param.put("dayInterval", dayInterval);
                return this.executeTask(ctx, dayInterval, param);
            }
            throw new BOSException((Throwable)e);
        }
    }

    private int throwBizExecption(Map param, Exception e) {
        int dayInterval = (Integer)param.get("dayInterval");
        switch (dayInterval) {
            case 0: {
                dayInterval = 365;
                break;
            }
            case 365: {
                dayInterval = 100;
                break;
            }
            case 100: {
                dayInterval = 30;
                break;
            }
            case 30: {
                dayInterval = 10;
                break;
            }
            case 10: {
                dayInterval = 1;
                break;
            }
            default: {
                dayInterval = dayInterval > 365 ? 365 : (dayInterval > 100 ? 100 : (dayInterval > 30 ? 30 : 10));
            }
        }
        return dayInterval;
    }

    public AcctcusssentVerifyParam getVerifyParam(Context ctx, String[] companyNums, boolean uncheckBizNumber, boolean nullBizNumIsNotSame, boolean notIncludeUnpostVch, boolean amtMustSame, boolean gativeVerify) throws BOSException {
        return new AcctcusssentVerifyParam(ctx, companyNums, uncheckBizNumber, nullBizNumIsNotSame, notIncludeUnpostVch, amtMustSame, gativeVerify);
    }

    public AcctcusssentVerifyParam getVerifyParam(Context ctx, String[] companyNums, boolean uncheckBizNumber, boolean nullBizNumIsNotSame, boolean notIncludeUnpostVch, boolean amtMustSame, boolean verifySameByAmt, boolean gativeVerify) throws BOSException {
        return new AcctcusssentVerifyParam(ctx, companyNums, uncheckBizNumber, nullBizNumIsNotSame, notIncludeUnpostVch, amtMustSame, verifySameByAmt, gativeVerify);
    }

    public void verfiy(AcctcusssentVerifyParam param) throws BOSException, EASBizException {
        String[] ids = null;
        int count = param.getCount();
        for (int i = 1; i <= count; ++i) {
            try {
                this.recordPreCompanyNumber();
                ids = this.getExecuteCondition(param.getCtx(), param.getCon(), param.getConditionTable(), i);
                param.setIds(ids);
                this.insertDirtyData(param);
                if (AcctCussentVerifyUtils.isTimeOut(this.endTime)) break;
                if (ids[0] == null || ids[1] == null || ids[2] == null || ids[3] != null) {
                    // empty if block
                }
                if (!AcctCussentVerifyUtils.isTimeOut(this.endTime)) continue;
                break;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    public void verifyDetail(AcctcusssentVerifyParam param, String[] ids) throws BOSException, EASBizException {
        try {
            Object[] vouchers = this.getExecuteVouchers(param, ids);
            HashMap pair = new HashMap();
            HashMap dateMap = new HashMap();
            ArrayList verifyAsstIds = new ArrayList();
            this.setMutex(param.getCtx(), ids);
            int pairSize = this.dealAcctAndAuditVch(vouchers, verifyAsstIds, pair, dateMap, param, ids[3]);
            if (pairSize > 0) {
                this.doVerify(param, ids[0], verifyAsstIds.toArray(new String[0]), pair, dateMap, null);
                if (this.verifyCount != 0) {
                    this.insertVerifyCount(param.getCon(), ids, this.verifyCount);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (this.mp != null) {
                try {
                    this.mutex.releaseMutex(this.mp.getRequestId());
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(AcctCussentVerifyService.getString(null, "GL_ReleaseMutexFailure"));
                }
            }
        }
    }

    public void afterVerfiy(AcctcusssentVerifyParam param) throws BOSException, EASBizException {
    }

    public void insertVerifyCount(Connection con, String[] ids, int verifyCount) throws BOSException {
        PreparedStatement ps = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("insert into T_gl_autoVerifyReport(companyID,accountID,currencyID,hgID,endtime,verifyCount) values(?,?,?,?,?,?)");
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, ids[0]);
            ps.setString(2, ids[1]);
            ps.setString(3, ids[2]);
            ps.setString(4, ids[3]);
            ps.setTimestamp(5, new Timestamp(new java.util.Date().getTime()));
            ps.setInt(6, verifyCount);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
    }

    public void doVerify(AcctcusssentVerifyParam param, String companyID, String[] verifyAsstIds, Map pair, Map dateMap, VerifyManualAutoEnum verifyManualAuto) throws EASBizException, BOSException {
        if (param.isNegativeVerify()) {
            this.autoNegativeVerify(param, verifyAsstIds, pair, dateMap);
        } else {
            this.autoVerify(param, verifyAsstIds, pair, dateMap, VerifyManualAutoEnum.Auto);
        }
    }

    public void autoNegativeVerify(AcctcusssentVerifyParam param, String[] verifyAsstIds, Map pair, Map dateMap) throws BOSException, EASBizException {
        Context ctx = param.getCtx();
        HashSet cussSet = new HashSet();
        for (int i = 0; i < verifyAsstIds.length; ++i) {
            List cussentVchIds = (List)pair.get(verifyAsstIds[i]);
            if (dateMap == null || dateMap.size() <= 0) continue;
            cussSet.addAll(cussentVchIds);
        }
        AcctCussentVerifyUtils.checkBeforeVerify(param, cussSet.toArray(new String[0]), false, dateMap);
        AcctCussentVerifyUtils.checkBeforeVerify(param, verifyAsstIds, true, dateMap);
        Connection con = param.getCon();
        PreparedStatement sqlInsert = null;
        try {
            sqlInsert = con.prepareStatement(this.getInsertSQL());
            Map mapVeriVchEntryIds = AcctCussentVerifyUtils.getVerifyVchIds(param, verifyAsstIds);
            Counter counterInsert = new Counter();
            ArrayList verifiedSrc = new ArrayList();
            int verifyCnt = 0;
            for (int i = 0; i < verifyAsstIds.length; ++i) {
                List cussentVchIds = (List)pair.get(verifyAsstIds[i]);
                verifyCnt += this.commonVerify(ctx, cussentVchIds.toArray(new String[0]), new String[]{verifyAsstIds[i]}, true, GLVerifyTypeEnum.NEGATIVE_VERIFY, verifiedSrc, sqlInsert, counterInsert, mapVeriVchEntryIds, param.getIds(), param.getCon());
            }
            if (counterInsert.getValue() > 0) {
                sqlInsert.executeBatch();
                sqlInsert.clearBatch();
                counterInsert.clear();
            }
            this.verifyCount = negativeVerifyCnt += verifyCnt;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sqlInsert);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sqlInsert);
    }

    public void autoVerify(AcctcusssentVerifyParam param, String[] verifyAsstIds, Map pair, Map dateMap, VerifyManualAutoEnum verifyManualAuto) throws BOSException, EASBizException {
        Context ctx = param.getCtx();
        HashSet cussSet = new HashSet();
        for (int i = 0; i < verifyAsstIds.length; ++i) {
            List cussentVchIds = (List)pair.get(verifyAsstIds[i]);
            if (dateMap == null || dateMap.size() <= 0) continue;
            cussSet.addAll(cussentVchIds);
        }
        AcctCussentVerifyUtils.checkBeforeVerify(param, cussSet.toArray(new String[0]), false, dateMap);
        AcctCussentVerifyUtils.checkBeforeVerify(param, verifyAsstIds, true, dateMap);
        this.sqlStartTime = System.currentTimeMillis();
        Map mapVeriVchEntryIds = AcctCussentVerifyUtils.getVerifyVchIds(param, verifyAsstIds);
        this.sqlEndTime = System.currentTimeMillis();
        Connection con = param.getCon();
        PreparedStatement sqlInsert = null;
        try {
            boolean isFromVchUI;
            sqlInsert = con.prepareStatement(this.getInsertSQL());
            Counter counterInsert = new Counter();
            ArrayList verifiedSrc = new ArrayList();
            GLVerifyTypeEnum glVerifyType = GLVerifyTypeEnum.COMMON_VERIFY;
            int verifyCnt = 0;
            for (int i = 0; i < verifyAsstIds.length; ++i) {
                List cussentVchIds = (List)pair.get(verifyAsstIds[i]);
                cussentVchIds.removeAll(verifiedSrc);
                verifyCnt += this.commonVerify(ctx, cussentVchIds.toArray(new String[0]), new String[]{verifyAsstIds[i]}, false, glVerifyType, verifiedSrc, sqlInsert, counterInsert, mapVeriVchEntryIds, verifyManualAuto, param.getIds(), param.getCon());
            }
            if (counterInsert.getValue() > 0) {
                sqlInsert.executeBatch();
                sqlInsert.clearBatch();
                counterInsert.clear();
            }
            boolean bl = isFromVchUI = dateMap == null || dateMap.size() == 0;
            if (isFromVchUI && verifyCnt == 0) {
                throw new GLException(GLException.CUSSENT_VERIFY_NO_MATCH_RECORD);
            }
            this.verifyCount = verifyCnt;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sqlInsert);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sqlInsert);
    }

    private String createVerifyOrderTable(Context ctx) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("(").append("KSQL_SEQ INT IDENTITY (1, 1) ").append(",companyID VARCHAR(44) ").append(",companyNumber VARCHAR(44)").append(",companyName VARCHAR(100)").append(",accountID VARCHAR(44)").append(",accountNumber VARCHAR(44)").append(",accountName VARCHAR(100)").append(",currencyID VARCHAR(44)").append(",currencyNumber VARCHAR(44)").append(",currencyName VARCHAR(100)").append(",hgID VARCHAR(44)").append(",hgFnumberGroup VARCHAR(400)").append(")");
        String tempTable = AcctCussentVerifyUtils.createTempTableByDDL(ctx, "gl_acct_condition", sql);
        return tempTable;
    }

    private List getConditionData(Context ctx, String[] companyNums, Connection con) throws BOSException, EASBizException {
        ArrayList<String[]> arrayList;
        ResultSet rs = null;
        PreparedStatement ps = null;
        PreparedStatement ps1 = null;
        ArrayList<String[]> result = new ArrayList<String[]>();
        try {
            String filterSql = "SELECT i.FORGUNITID FROM T_BAS_PARAM p inner join T_BAS_PARAMITEM i on p.FID  = i.FKEYID where p.FNUMBER ='GL_052' AND I.FVALUE_L2 > 0";
            StringBuffer companyIDs = new StringBuffer();
            if (companyNums == null) {
                companyIDs.append(filterSql);
            } else {
                StringBuffer companyNumbers = new StringBuffer();
                int size = companyNums.length;
                for (int i = 0; i < size; ++i) {
                    companyNumbers.append("'").append(companyNums[i]).append("',");
                }
                companyNumbers = new StringBuffer(companyNumbers.substring(0, companyNumbers.length() - 1));
                logger.error((Object)("companyNumbers:" + companyNumbers));
                StringBuffer sql = new StringBuffer("select fid from t_org_company where fnumber in (");
                sql.append(companyNumbers).append(")");
                ps = con.prepareStatement(sql.toString());
                rs = ps.executeQuery();
                while (rs.next()) {
                    companyIDs.append("'").append(rs.getString("FID")).append("',");
                }
                companyIDs = new StringBuffer(companyIDs.substring(0, companyIDs.length() - 1));
            }
            StringBuffer insertSql = new StringBuffer();
            insertSql.append(" SELECT distinct t.FCompanyID, t.faccountid, t.fcurrencyid, v.fnumber actNumber FROM (  \r\n").append(" SELECT distinct FCompanyID, faccountid, fcurrencyid FROM T_GL_ACCTCUSSENT  where FCompanyID in( \r\n ").append(companyIDs).append(") and FASSGRPID is not null  \r\n").append(" union all  \r\n").append(" SELECT distinct FCompanyID, faccountid, fcurrencyid FROM T_GL_AcctVerify  where FCompanyID in( \r\n ").append(companyIDs).append(") and FASSGRPID is not null  \r\n").append(") t inner join t_bd_accountview v on t.faccountid = v.fid order by t.FCompanyID, t.faccountid, t.fcurrencyid ");
            ps1 = con.prepareStatement(insertSql.toString());
            rs = ps1.executeQuery();
            String companyID = null;
            String accountID = null;
            String currencyID = null;
            String actNumber = null;
            while (rs.next()) {
                companyID = rs.getString("FCompanyID");
                accountID = rs.getString("faccountid");
                currencyID = rs.getString("fcurrencyid");
                actNumber = rs.getString("actNumber");
                result.add(new String[]{companyID, accountID, currencyID, actNumber});
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                SQLUtils.cleanup(ps1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        SQLUtils.cleanup((Statement)ps1);
        return arrayList;
    }

    public String[] getExecuteCondition(Context ctx, Connection con, String conditionTabel, int count) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        PreparedStatement ps = null;
        ResultSet rs = null;
        String[] ids = null;
        try {
            sql.append("select companyID,accountID,currencyID,hgID,companyNumber \r\n").append("from ").append(conditionTabel).append(" where ksql_seq = ?");
            ps = con.prepareStatement(sql.toString());
            ps.setInt(1, count);
            rs = ps.executeQuery();
            ids = new String[4];
            if (rs.next()) {
                ids[0] = rs.getString("companyID");
                System.out.println("===========companyID" + ids[0]);
                ids[1] = rs.getString("accountID");
                System.out.println("===========accountID" + ids[1]);
                ids[2] = rs.getString("currencyID");
                System.out.println("===========currencyID" + ids[2]);
                ids[3] = rs.getString("hgID");
                System.out.println("===========hgID" + ids[3]);
                this.companyNumber = rs.getString("companyNumber");
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return ids;
    }

    public void recordPreCompanyNumber() {
        if (this.companyNumber != null) {
            this.preCompanyNumber = this.companyNumber;
        }
    }

    public Object[] getExecuteVouchers(AcctcusssentVerifyParam param, String[] ids) throws BOSException, EASBizException {
        ArrayList cussentVouchers = this.getCussentVoucher(param, ids);
        ArrayList verifyVouchers = this.getVerifyVoucher(param, ids);
        Object[] vouchers = new Object[]{cussentVouchers, verifyVouchers};
        return vouchers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList getVerifyVoucher(AcctcusssentVerifyParam verifyParm, String[] ids) throws EASBizException, BOSException {
        String companyID = ids[0];
        String accountID = ids[1];
        String currencyID = ids[2];
        String hgID = ids[3];
        if (companyID == null) return null;
        if (currencyID == null) {
            return null;
        }
        Context ctx = verifyParm.getCtx();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        boolean exclueUnpostVch = Boolean.TRUE.equals(new Boolean(verifyParm.isNotIncludeUnpostVch()));
        StringBuffer sql = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        String verifyAmtSql = " ( SELECT isnull(sum(FOroginalAmount),0) FVERIFIEDAMTFOR  \r\n  FROM t_gl_acctcussenthistory his  \r\n  where FCompanyID = ? AND Faccountid = ? AND FCurrencyID = ? AND FVoucherAsstIDID = c.fid )  \r\n";
        list.add(companyID);
        list.add(accountID);
        list.add(currencyID);
        StringBuffer select = new StringBuffer("select ");
        sql.append(" a.fid fvoucherid,c.fid fid,vts.fname_").append(loc).append(" FvoucherType,a.FNumber FNumber, c.FBizDate FBizDate,c.FBizNumber FBizNumber,c.FendDate FBookedDate,\t\t \t \r\n \t  ");
        sql.append(" c.FDescription FDescription,b.FEntryDC FEntryDC,c.FOriginalAmount FOriginalAmount,       \t\t\t \r\n \t  ");
        sql.append(" c.FLocalAmount FLocalAmount,c.FReportingAmount FReportingAmount,c.FQuantity FQuantity,\t\t\t\t \r\n \t  ");
        sql.append(" c.FAssGrpID FAssGrpID, c.fid voucherAssistRecordID,  \t\t\t\t\t\t\t\t\t\t\t\r\n \t  ");
        sql.append(" a.FLastUpdateTime as FLastUpdateTime,  \r\n");
        sql.append(" ").append(verifyAmtSql).append("    FVERIFIEDAMTFOR  \r\n");
        sql.append(" from t_gl_Voucher a  \r\n");
        sql.append(" inner join t_bd_vouchertypes vts on vts.fid = a.fvouchertypeid  \r\n");
        sql.append(" inner join t_gl_Voucherentry b on b.FBillID = a.fid    \t\t\t\t\t\t\t\t\t\t\t\r\n  ");
        sql.append(" inner join T_GL_VoucherAssistRecord c on c.FBillID = a.fid  and  c.FEntryID = b.fid  \r\n");
        sql.append(" inner join T_bd_assistanthg hg on c.FassgrpId =hg.fid \t\t\t\t\t\t\t\t\t\t\r\n  ");
        sql.append(" inner join t_bd_period pe ON pe.fid = a.fperiodid\t \r\n");
        sql.append(" where a.FIsAC = 1 and b.FIsVerify = 1  \r\n ");
        if (exclueUnpostVch) {
            sql.append("and a.fbizstatus = 5 \r\n");
        } else {
            sql.append("and a.fbizstatus <> 0 and a.fbizstatus <> 2 \r\n");
        }
        sql.append(" and pe.fnumber >=(SELECT p.fnumber FROM t_bd_systemstatusctrol C, t_bd_period P WHERE (c.facperiodid IS NOT NULL and  p.fid = c.facperiodid or p.fid = c.fstartperiodid) AND c.fsystemstatusid =(SELECT fid FROM t_bd_systemstatus WHERE fname = 6) and c.fcompanyid = ?)");
        sql.append("and a.FCompanyID = ? and b.Faccountid=? and b.FCurrencyID = ? and hg.fid = ?\r\n");
        sql.append(" and c.FOriginalAmount <> 0 ");
        sql.append(" and c.FBizDate <=  ");
        sql.append(AcctCussentVerifyUtils.getCurrentDate());
        sql.append(" order by FBizNumber,FBizDate,fnumber");
        list.add(companyID);
        list.add(companyID);
        list.add(accountID);
        list.add(currencyID);
        list.add(hgID);
        Object[] params = list.toArray();
        select.append(sql);
        ArrayList result = new ArrayList();
        HashMap<String, AssistantHGInfo> cacheAssGrp = new HashMap<String, AssistantHGInfo>();
        PreparedStatement ps = null;
        PreparedStatement ps1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        try {
            ps = verifyParm.getCon().prepareStatement(select.toString(), 1003, 1007);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            this.sqlStartTime = System.currentTimeMillis();
            rs = ps.executeQuery();
            this.sqlEndTime = System.currentTimeMillis();
            String excludeSql = "select FveriAsstID from " + verifyParm.getDirtyDataTable() + " where FveriAsstID = ?";
            while (rs.next()) {
                if (rs.getBigDecimal("FVerifiedAmtFor").compareTo(rs.getBigDecimal("FOriginalAmount")) == 0) continue;
                HashMap<String, Object> item = new HashMap<String, Object>();
                String id = rs.getString("fid");
                try {
                    ps1 = verifyParm.getCon().prepareStatement(excludeSql);
                    ps1.setString(1, id);
                    rs1 = ps1.executeQuery();
                    if (!rs1.next()) {
                        item.put("voucherAssistRecordId", id);
                        item.put("FNumber", rs.getString("FNumber"));
                        item.put("fvoucherid", rs.getString("fvoucherid"));
                        item.put("FvoucherType", rs.getString("FvoucherType"));
                        item.put("FBizDate", rs.getDate("FBizDate"));
                        item.put("FBookedDate", rs.getDate("FBookedDate"));
                        item.put("FDescription", rs.getString("FDescription"));
                        item.put("FEntryDC", new Integer(rs.getInt("FEntryDC")));
                        item.put("FOriginalAmount", rs.getBigDecimal("FOriginalAmount"));
                        item.put("FVerifiedAmtFor", rs.getBigDecimal("FVerifiedAmtFor"));
                        item.put("FUnverifiedAmtFor", rs.getBigDecimal("FOriginalAmount").subtract(rs.getBigDecimal("FVerifiedAmtFor")));
                        AssistantHGInfo hgInfo = null;
                        if (cacheAssGrp.containsKey(rs.getString("FAssGrpID"))) {
                            hgInfo = (AssistantHGInfo)cacheAssGrp.get(rs.getString("FAssGrpID"));
                        } else {
                            this.sqlStartTime = System.currentTimeMillis();
                            hgInfo = AcctCussentVerifyUtils.getHgInfo(ctx, rs.getString("FAssGrpID"), hgID, verifyParm.getCon());
                            this.sqlEndTime = System.currentTimeMillis();
                            cacheAssGrp.put(rs.getString("FAssGrpID"), hgInfo);
                        }
                        item.put("FAssGrpID", rs.getString("FAssGrpID"));
                        item.put("hg", hgInfo);
                        item.put("FBizNumber", rs.getString("FBizNumber"));
                        item.put("FLastUpdateTime", rs.getTimestamp("FLastUpdateTime"));
                        result.add(item);
                    }
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs1, (Statement)ps1);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs1, (Statement)ps1);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList getCussentVoucher(AcctcusssentVerifyParam verifyParm, String[] ids) throws EASBizException, BOSException {
        String companyID = ids[0];
        String accountID = ids[1];
        String currencyID = ids[2];
        String hgID = ids[3];
        if (accountID == null) return null;
        if (currencyID == null) {
            return null;
        }
        Context ctx = verifyParm.getCtx();
        int verifyMode = GlUtils.getVerifyMode(verifyParm.getCtx(), ids[0]);
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid fid,' ' fvoucherid, N' ' FvoucherType,N' ' FNumber, a.fvarbizdate FBizDate,a.FBizNumber FBizNumber,null FBookedDate,\t\r\n");
        sql.append(" a.FDescription FDescription,v.FDC FDC,  \r\n");
        sql.append(" a.FOriginalAmount FOriginalAmount,a.FAssGrpID FAssGrpID,a.fvchassistrecordid voucherAssistRecordID,\t \r\n");
        sql.append(" a.FUnverifiedAmtFor FUnverifiedAmtFor,  \r\n");
        sql.append(" a.FLastUpdateTime as FLastUpdateTime \r\n");
        sql.append(" from T_GL_AcctCussent a  \r\n");
        sql.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid \r\n");
        sql.append(" inner join T_bd_assistanthg hg on a.FassgrpId =hg.fid  \r\n");
        sql.append(" \r\n where  a.FUnverifiedAmtFor <> 0 and a.FIsInit=1 \r\n");
        sql.append(" and a.FCompanyID = ? and a.FCurrencyID = ? and a.FAccountID = ? \r\n");
        sql.append(" and a.fvarbizdate <= ");
        sql.append(AcctCussentVerifyUtils.getCurrentDate());
        sql.append(" and hg.fid = ?");
        params.add(companyID);
        params.add(currencyID);
        params.add(accountID);
        params.add(hgID);
        sql.append(" \r\n");
        sql.append(" union all \r\n");
        sql.append("select a.fid fid,d.fid fvoucherid,vts.fname_l2 FvoucherType,d.FNumber FNumber,  \r\n");
        sql.append(" a.fvarbizdate FBizDate,a.FBizNumber FBizNumber, \r\n");
        sql.append(" d.FBookedDate FBookedDate, a.FDescription FDescription,v.FDC FDC, \r\n");
        sql.append(" a.FOriginalAmount FOriginalAmount,a.FAssGrpID FAssGrpID,a.fvchassistrecordid voucherAssistRecordID, \r\n");
        sql.append(" a.FUnverifiedAmtFor FUnverifiedAmtFor,   \r\n");
        sql.append(" a.FLastUpdateTime as FLastUpdateTime \r\n");
        sql.append(" from T_GL_AcctCussent a   \r\n");
        sql.append(" inner join T_GL_Voucher d on a.FVoucherID =d.fid and d.FIsAC = 1 \r\n");
        sql.append(" inner join T_bd_VoucherTypes vts on vts.fid = d.FVoucherTypeID \r\n");
        sql.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid  \r\n");
        sql.append(" inner join v_gl_acperiod acp on acp.fperiodid=d.fperiodid \r\n");
        sql.append(" inner join T_bd_assistanthg hg on a.FassgrpId = hg.fid  \r\n");
        sql.append(" \r\n where a.FUnverifiedAmtFor <> 0 and a.FIsInit=0 \r\n");
        sql.append(" and d.FIsAC = 1 \r\n");
        if (verifyMode == 1) {
            sql.append("and d.fbizstatus = 5");
        } else {
            sql.append("and d.fbizstatus <> 0 and d.fbizstatus <> 2");
        }
        sql.append(" and a.FCompanyID = ?  and a.FCurrencyID = ? and a.FAccountID = ? \r\n");
        sql.append(" and acp.fcompanyid = ? \r\n");
        sql.append(" and a.fvarbizdate <= ");
        sql.append(AcctCussentVerifyUtils.getCurrentDate());
        sql.append(" and hg.fid = ? ");
        sql.append(" order by FBizNumber,FBizDate,fnumber");
        params.add(companyID);
        params.add(currencyID);
        params.add(accountID);
        params.add(companyID);
        params.add(hgID);
        sql.append(" \r\n");
        ArrayList result = new ArrayList();
        ResultSet rs = null;
        ResultSet rs1 = null;
        PreparedStatement ps = null;
        PreparedStatement ps1 = null;
        try {
            ps = verifyParm.getCon().prepareStatement(sql.toString(), 1003, 1007);
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params.get(i));
            }
            this.sqlStartTime = System.currentTimeMillis();
            rs = ps.executeQuery();
            this.sqlEndTime = System.currentTimeMillis();
            HashMap<String, AssistantHGInfo> cacheAssGrp = new HashMap<String, AssistantHGInfo>();
            String excluedeSql = "select cussentID from " + verifyParm.getDirtyDataTable() + " where cussentID = ?";
            while (rs.next()) {
                try {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    String id = rs.getString("fid");
                    ps1 = verifyParm.getCon().prepareStatement(excluedeSql);
                    ps1.setString(1, id);
                    rs1 = ps1.executeQuery();
                    if (!rs1.next()) {
                        item.put("voucherAssistRecordId", rs.getString("voucherAssistRecordID"));
                        item.put("acctCussentId", id);
                        item.put("FvoucherType", rs.getString("FvoucherType"));
                        item.put("fvoucherid", rs.getString("fvoucherid"));
                        item.put("FNumber", rs.getString("FNumber"));
                        item.put("FBizDate", rs.getDate("FBizDate"));
                        item.put("FBookedDate", rs.getDate("FBookedDate"));
                        item.put("FDescription", rs.getString("FDescription"));
                        item.put("FDC", new Integer(rs.getInt("FDC")));
                        item.put("FOriginalAmount", rs.getBigDecimal("FOriginalAmount"));
                        item.put("FUnverifiedAmtFor", rs.getBigDecimal("FUnverifiedAmtFor"));
                        item.put("FVerifiedAmtFor", rs.getBigDecimal("FOriginalAmount").subtract(rs.getBigDecimal("FUnverifiedAmtFor")));
                        AssistantHGInfo hgInfo = null;
                        if (cacheAssGrp.containsKey(rs.getString("FAssGrpID"))) {
                            hgInfo = (AssistantHGInfo)cacheAssGrp.get(rs.getString("FAssGrpID"));
                        } else {
                            this.sqlStartTime = System.currentTimeMillis();
                            hgInfo = AcctCussentVerifyUtils.getHgInfo(ctx, rs.getString("FAssGrpID"), hgID, verifyParm.getCon());
                            this.sqlEndTime = System.currentTimeMillis();
                            cacheAssGrp.put(rs.getString("FAssGrpID"), hgInfo);
                        }
                        item.put("FAssGrpID", rs.getString("FAssGrpID"));
                        item.put("hg", hgInfo);
                        item.put("FBizNumber", rs.getString("FBizNumber"));
                        item.put("FLastUpdateTime", rs.getTimestamp("FLastUpdateTime"));
                        result.add(item);
                    }
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs1, ps1);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs1, (Statement)ps1);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return result;
    }

    public int dealAcctAndAuditVch(Object[] vouchers, List verifyAsstIds, Map pair, Map dateMap, AcctcusssentVerifyParam verifyParam, String assgrpID) throws BOSException, EASBizException {
        boolean isAmtMustSame = verifyParam.isAmtMustSame();
        boolean isNegativeVerify = verifyParam.isNegativeVerify();
        boolean uncheckBizNumber = verifyParam.isUncheckBizNumber();
        boolean nullBizNumIsNotSame = verifyParam.isNullBizNumIsNotSame();
        BigDecimal willAmt = null;
        BigDecimal amount = null;
        BigDecimal orginalWillAmt = GlUtils.zero;
        BigDecimal orginalAmount = GlUtils.zero;
        ArrayList verifySrcData = (ArrayList)vouchers[0];
        ArrayList verifyDesData = (ArrayList)vouchers[1];
        for (int i = 0; i < verifyDesData.size(); ++i) {
            HashMap item = (HashMap)verifyDesData.get(i);
            String assgrp = (String)item.get("FAssGrpID");
            String upid = (String)item.get("voucherAssistRecordId");
            String bizNumber = item.get("FBizNumber") == null ? "" : (String)item.get("FBizNumber");
            willAmt = GlUtils.zero;
            if (item.get("FUnverifiedAmtFor") != null) {
                willAmt = (BigDecimal)item.get("FUnverifiedAmtFor");
            }
            if (item.get("FOriginalAmount") != null) {
                orginalWillAmt = (BigDecimal)item.get("FOriginalAmount");
                if (isAmtMustSame && orginalWillAmt.compareTo(willAmt) != 0) continue;
            }
            ArrayList<String> sbDown = new ArrayList<String>();
            ArrayList<String> sbDownAmtSame = new ArrayList<String>();
            for (int j = 0; j < verifySrcData.size(); ++j) {
                HashMap item2 = (HashMap)verifySrcData.get(j);
                String assgrp2 = (String)item2.get("FAssGrpID");
                String upid2 = (String)item2.get("acctCussentId");
                String bizNumber2 = item2.get("FBizNumber") == null ? "" : (String)item2.get("FBizNumber");
                amount = GlUtils.zero;
                if (item2.get("FUnverifiedAmtFor") != null) {
                    amount = (BigDecimal)item2.get("FUnverifiedAmtFor");
                }
                if (item2.get("FOriginalAmount") != null) {
                    orginalAmount = (BigDecimal)item2.get("FOriginalAmount");
                    if (isAmtMustSame && orginalAmount.compareTo(amount) != 0) continue;
                }
                if (!AcctCussentVerifyUtils.checkCanVerify(uncheckBizNumber, nullBizNumIsNotSame, bizNumber, bizNumber2)) continue;
                if (isAmtMustSame && willAmt.compareTo(amount) == 0) {
                    sbDownAmtSame.add(upid2);
                } else {
                    sbDown.add(upid2);
                }
                dateMap.put(upid2, item2.get("FLastUpdateTime"));
            }
            if (isAmtMustSame && sbDownAmtSame.size() == 0 || sbDown.size() <= 0 && sbDownAmtSame.size() <= 0) continue;
            verifyAsstIds.add(upid);
            sbDownAmtSame.addAll(sbDown);
            pair.put(upid, sbDownAmtSame);
            dateMap.put(upid, item.get("FLastUpdateTime"));
        }
        int pairSize = pair.size();
        return pairSize;
    }

    private int commonVerify(Context ctx, String[] srcIDs, String[] objIDs, boolean isNegative, GLVerifyTypeEnum verifyType, List verifiedSrc, PreparedStatement sqlInsert, Counter counter, Map mapVeriVchEntryIds, String[] ids, Connection con) throws BOSException, EASBizException {
        return this.commonVerify(ctx, srcIDs, objIDs, isNegative, verifyType, verifiedSrc, sqlInsert, counter, mapVeriVchEntryIds, VerifyManualAutoEnum.Manual, ids, con);
    }

    private int commonVerify(Context ctx, String[] srcIDs, String[] objIDs, boolean isNegative, GLVerifyTypeEnum verifyType, List verifiedSrc, PreparedStatement sqlInsert, Counter counter, Map mapVeriVchEntryIds, VerifyManualAutoEnum verifyManualAuto, String[] ids, Connection con) throws BOSException, EASBizException {
        int verifyCnt = 0;
        BigDecimal originalAmount = null;
        BigDecimal localAmount = null;
        BigDecimal reportingAmount = null;
        BigDecimal qty = null;
        BigDecimal unverifiedAmtFor = null;
        BigDecimal unverifiedAmtLocal = null;
        BigDecimal unverifiedAmtRpt = null;
        BigDecimal unverifiedAmtQty = null;
        boolean flag = false;
        java.util.Date verifyDate = new java.util.Date();
        java.util.Date verifyDate1 = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        String verifyNumber = this.getAcctcussentHistoryNumber(ctx, verifyDate1, ids, con);
        int Seq = 1;
        block0: for (int i = 0; i < objIDs.length && !flag; ++i) {
            Map amountHxMap = this.getVerifyAmount(ctx, objIDs[i], con);
            BigDecimal tempO = (BigDecimal)amountHxMap.get("FUnverifiedAmtFor");
            BigDecimal tempL = (BigDecimal)amountHxMap.get("FUnverifiedAmtLocal");
            BigDecimal tempR = (BigDecimal)amountHxMap.get("FUnverifiedAmtRpt");
            BigDecimal tempQ = (BigDecimal)amountHxMap.get("FUnverifiedAmtQty");
            if (tempO.compareTo(this.ZERO) == 0) continue;
            if (originalAmount == null || originalAmount.compareTo(this.ZERO) <= 0 && !isNegative || originalAmount.compareTo(this.ZERO) >= 0 && isNegative) {
                originalAmount = tempO;
                localAmount = tempL;
                reportingAmount = tempR;
                qty = tempQ;
                if (originalAmount.compareTo(this.ZERO) < 0 && !isNegative || originalAmount.compareTo(this.ZERO) > 0 && isNegative) continue;
            }
            for (int j = 0; !(j >= srcIDs.length || originalAmount.compareTo(this.ZERO) <= 0 && !isNegative || originalAmount.compareTo(this.ZERO) >= 0 && isNegative); ++j) {
                if (verifiedSrc.contains(srcIDs[j])) continue;
                Map amountGzMap = this.getUnverifiedAmt(ctx, srcIDs[j], con);
                BigDecimal tempU = (BigDecimal)amountGzMap.get("FUnverifiedAmtFor");
                BigDecimal tempUL = (BigDecimal)amountGzMap.get("FUnverifiedAmtLocal");
                BigDecimal tempUR = (BigDecimal)amountGzMap.get("FUnverifiedAmtRpt");
                BigDecimal tempUQ = (BigDecimal)amountGzMap.get("FUnverifiedQty");
                if (tempU.compareTo(this.ZERO) == 0) {
                    verifiedSrc.add(srcIDs[j]);
                    continue;
                }
                if (unverifiedAmtFor == null || unverifiedAmtFor.compareTo(this.ZERO) <= 0 && !isNegative || unverifiedAmtFor.compareTo(this.ZERO) >= 0 && isNegative) {
                    unverifiedAmtFor = tempU;
                    unverifiedAmtLocal = tempUL;
                    unverifiedAmtRpt = tempUR;
                    unverifiedAmtQty = tempUQ;
                    if (tempU.compareTo(this.ZERO) < 0 && !isNegative || tempU.compareTo(this.ZERO) > 0 && isNegative) {
                        verifiedSrc.add(srcIDs[j]);
                        continue;
                    }
                }
                amountGzMap.put("FNumber", verifyNumber);
                amountGzMap.put("FVerifyDate", verifyDate);
                amountGzMap.put("FSeq", new Integer(Seq++));
                AcctCussentHistoryInfo acctCussentHistoryInfo = this.createAcctCussentHistoryInfo(ctx, amountGzMap, srcIDs[j], objIDs[i], verifyType, (String[])mapVeriVchEntryIds.get(objIDs[i]), verifyManualAuto);
                if (originalAmount.compareTo(unverifiedAmtFor) > 0 && !isNegative || originalAmount.compareTo(unverifiedAmtFor) < 0 && isNegative) {
                    acctCussentHistoryInfo.setOroginalAmount(unverifiedAmtFor);
                    acctCussentHistoryInfo.setOriginalBalance(GlUtils.zero);
                    originalAmount = originalAmount.subtract(unverifiedAmtFor);
                    if (unverifiedAmtLocal.compareTo(localAmount) <= 0) {
                        acctCussentHistoryInfo.setLocalAmount(unverifiedAmtLocal);
                        acctCussentHistoryInfo.setLocalBalance(GlUtils.zero);
                        localAmount = localAmount.subtract(unverifiedAmtLocal);
                    } else {
                        acctCussentHistoryInfo.setLocalAmount(localAmount);
                        acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                        localAmount = GlUtils.zero;
                    }
                    if (unverifiedAmtRpt.compareTo(reportingAmount) <= 0) {
                        acctCussentHistoryInfo.setReportAmount(unverifiedAmtRpt);
                        acctCussentHistoryInfo.setReportBanlance(GlUtils.zero);
                        reportingAmount = reportingAmount.subtract(unverifiedAmtRpt);
                    } else {
                        acctCussentHistoryInfo.setReportAmount(reportingAmount);
                        acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                        reportingAmount = GlUtils.zero;
                    }
                    if (unverifiedAmtQty.compareTo(qty) <= 0) {
                        acctCussentHistoryInfo.setQty(unverifiedAmtQty);
                        acctCussentHistoryInfo.setQtyBalance(GlUtils.zero);
                        qty = qty.subtract(unverifiedAmtQty);
                    } else {
                        acctCussentHistoryInfo.setQty(qty);
                        acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                        qty = GlUtils.zero;
                    }
                    this.insertHistory(ctx, acctCussentHistoryInfo, verifyType, sqlInsert, counter, ids, con);
                    ++verifyCnt;
                    this.updateUnverifiedAmtFor(ctx, srcIDs[j], acctCussentHistoryInfo, con);
                    unverifiedAmtFor = GlUtils.zero;
                    unverifiedAmtLocal = GlUtils.zero;
                    unverifiedAmtRpt = GlUtils.zero;
                    unverifiedAmtQty = GlUtils.zero;
                    verifiedSrc.add(srcIDs[j]);
                    if (j + 1 < srcIDs.length) continue;
                    flag = true;
                    continue block0;
                }
                if (originalAmount.compareTo(unverifiedAmtFor) < 0 && !isNegative || originalAmount.compareTo(unverifiedAmtFor) > 0 && isNegative) {
                    acctCussentHistoryInfo.setOroginalAmount(originalAmount);
                    acctCussentHistoryInfo.setLocalAmount(localAmount);
                    acctCussentHistoryInfo.setReportAmount(reportingAmount);
                    acctCussentHistoryInfo.setQty(qty);
                    acctCussentHistoryInfo.setOriginalBalance(unverifiedAmtFor.subtract(originalAmount));
                    acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                    acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                    acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                    this.insertHistory(ctx, acctCussentHistoryInfo, verifyType, sqlInsert, counter, ids, con);
                    ++verifyCnt;
                    this.changeVerifiedStatus(ctx, objIDs[i], con);
                    this.updateUnverifiedAmtFor(ctx, srcIDs[j], acctCussentHistoryInfo, con);
                    unverifiedAmtFor = unverifiedAmtFor.subtract(originalAmount);
                    unverifiedAmtLocal = unverifiedAmtLocal.subtract(localAmount);
                    unverifiedAmtRpt = unverifiedAmtRpt.subtract(reportingAmount);
                    unverifiedAmtQty = unverifiedAmtQty.subtract(qty);
                    originalAmount = GlUtils.zero;
                    localAmount = GlUtils.zero;
                    reportingAmount = GlUtils.zero;
                    qty = GlUtils.zero;
                    if (i + 1 < objIDs.length) {
                        if (j + 1 < srcIDs.length) continue;
                        continue block0;
                    }
                    flag = true;
                    continue block0;
                }
                acctCussentHistoryInfo.setOroginalAmount(originalAmount);
                acctCussentHistoryInfo.setLocalAmount(localAmount);
                acctCussentHistoryInfo.setReportAmount(reportingAmount);
                acctCussentHistoryInfo.setQty(qty);
                acctCussentHistoryInfo.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                this.insertHistory(ctx, acctCussentHistoryInfo, verifyType, sqlInsert, counter, ids, con);
                ++verifyCnt;
                this.changeVerifiedStatus(ctx, objIDs[i], con);
                this.updateUnverifiedAmtFor(ctx, srcIDs[j], acctCussentHistoryInfo, con);
                unverifiedAmtFor = GlUtils.zero;
                unverifiedAmtLocal = GlUtils.zero;
                unverifiedAmtRpt = GlUtils.zero;
                unverifiedAmtQty = GlUtils.zero;
                originalAmount = GlUtils.zero;
                localAmount = GlUtils.zero;
                reportingAmount = GlUtils.zero;
                qty = GlUtils.zero;
                verifiedSrc.add(srcIDs[j]);
                if (i + 1 < objIDs.length) {
                    if (j + 1 < srcIDs.length) continue;
                    flag = true;
                    continue block0;
                }
                flag = true;
                continue block0;
            }
        }
        return verifyCnt;
    }

    private String getInsertSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_GL_AcctCussentHistory (\t\t\t\t\t\t\t\t\r\n");
        sql.append("FID,FOroginalAmount,FLocalAmount,FReportAmount,FQty,\t\t\t\r\n");
        sql.append("ForiginalBalance,FlocalBalance,FreportBanlance,FqtyBalance,\t\r\n");
        sql.append("FCussentidID,FVoucherAsstIDID,FDC,FVerifyDate,FAccountID,\t\t\r\n");
        sql.append("FAssGrpID,FCurrencyID,FCreatorID,FCompanyId,\t\t\t\t\t\t\r\n");
        sql.append("FNumber,FSeq,FBalType,FVchNumber,FVchDate,FBizDate,FbizNumber,FDescription, \r\n");
        sql.append("FVerifyManualAuto,FVeriVchID,FVeriEntryID,                                 \r\n");
        sql.append(" FCussVchID,FCussEntryID,         \r\n");
        sql.append(" FCussPeriod,FVeriPeriod,         \r\n");
        sql.append(" FCussOriginalAmount,             \r\n");
        sql.append(" FCussLocalAmount,                \r\n");
        sql.append(" FCussReportAmount,               \r\n");
        sql.append(" FCussQty )                        \r\n");
        sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
        sql.append(" ?,?,?,?,?,?,?,?)                   \r\n");
        return sql.toString();
    }

    private void insertHistory(Context ctx, AcctCussentHistoryInfo info, GLVerifyTypeEnum verifyType, PreparedStatement sqlInsert, Counter counter, String[] ids, Connection con) throws BOSException, EASBizException {
        try {
            if (verifyType.equals((Object)GLVerifyTypeEnum.INTIME_VERIFY)) {
                this._deleteAcctCussHistory(ctx, info.getVoucherAsstID().getId().toString(), con);
            }
            int index = 1;
            sqlInsert.setString(index++, info.getId().toString());
            sqlInsert.setBigDecimal(index++, info.getOroginalAmount());
            sqlInsert.setBigDecimal(index++, info.getLocalAmount());
            sqlInsert.setBigDecimal(index++, info.getReportAmount());
            sqlInsert.setBigDecimal(index++, info.getQty());
            sqlInsert.setBigDecimal(index++, info.getOriginalBalance());
            sqlInsert.setBigDecimal(index++, info.getLocalBalance());
            sqlInsert.setBigDecimal(index++, info.getReportBanlance());
            sqlInsert.setBigDecimal(index++, info.getQtyBalance());
            sqlInsert.setString(index++, info.getCussentid().getId().toString());
            sqlInsert.setString(index++, info.getVoucherAsstID().getId().toString());
            if (verifyType.equals((Object)GLVerifyTypeEnum.INTIME_VERIFY)) {
                if (info.getOroginalAmount().signum() < 0) {
                    sqlInsert.setInt(index++, 2);
                } else {
                    sqlInsert.setInt(index++, 0);
                }
            } else {
                sqlInsert.setInt(index++, verifyType.getValue());
            }
            java.util.Date verifyDate = info.getVerifyDate() == null ? new java.util.Date() : info.getVerifyDate();
            verifyDate = DateTimeUtils.truncateDate((java.util.Date)verifyDate);
            sqlInsert.setTimestamp(index++, new Timestamp(verifyDate.getTime()));
            sqlInsert.setString(index++, ids[1]);
            sqlInsert.setString(index++, ids[3]);
            sqlInsert.setString(index++, ids[2]);
            String userID = info.getCreator().getId().toString();
            try {
                userID = info.getCreator().getId().toString();
            }
            catch (Exception e) {
                userID = "00000000-0000-0000-0000-00000000000013B7DE7F";
            }
            sqlInsert.setString(index++, userID);
            sqlInsert.setString(index++, ids[0]);
            sqlInsert.setString(index++, info.getNumber());
            sqlInsert.setInt(index++, info.getSeq());
            if (verifyType.equals((Object)GLVerifyTypeEnum.INTIME_VERIFY)) {
                sqlInsert.setInt(index++, 6);
            } else {
                sqlInsert.setInt(index++, 5);
            }
            if (info.getVchNumber() != null) {
                sqlInsert.setString(index++, info.getVchNumber());
            } else {
                sqlInsert.setString(index++, null);
            }
            if (info.getVchDate() != null) {
                sqlInsert.setDate(index++, new Date(info.getVchDate().getTime()));
            } else {
                sqlInsert.setDate(index++, null);
            }
            if (info.getBizDate() != null) {
                sqlInsert.setDate(index++, new Date(info.getBizDate().getTime()));
            } else {
                sqlInsert.setDate(index++, null);
            }
            if (info.getBizNumber() != null) {
                sqlInsert.setString(index++, info.getBizNumber());
            } else {
                sqlInsert.setString(index++, null);
            }
            if (info.getDescription() != null) {
                sqlInsert.setString(index++, info.getDescription());
            } else {
                sqlInsert.setString(index++, null);
            }
            if (info.getVerifyManualAuto() == null) {
                info.setVerifyManualAuto(VerifyManualAutoEnum.Manual);
            }
            sqlInsert.setInt(index++, info.getVerifyManualAuto().getValue());
            if (info.getVeriVch() != null) {
                sqlInsert.setString(index++, info.getVeriVch().getId().toString());
                sqlInsert.setString(index++, info.getVeriEntry().getId().toString());
            } else {
                sqlInsert.setString(index++, null);
                sqlInsert.setString(index++, null);
            }
            if (info.getCussVch() != null) {
                sqlInsert.setString(index++, info.getCussVch().getId().toString());
                sqlInsert.setString(index++, info.getCussEntry().getId().toString());
            } else {
                sqlInsert.setString(index++, null);
                sqlInsert.setString(index++, null);
            }
            sqlInsert.setInt(index++, info.getCussPeriod());
            sqlInsert.setInt(index++, info.getVeriPeriod());
            sqlInsert.setBigDecimal(index++, info.getCussOriginalAmount());
            sqlInsert.setBigDecimal(index++, info.getCussLocalAmount());
            sqlInsert.setBigDecimal(index++, info.getCussReportAmount());
            sqlInsert.setBigDecimal(index++, info.getCussQty() == null ? GlUtils.zero : info.getCussQty());
            sqlInsert.addBatch();
            counter.add();
            if (counter.getValue() % 2000 == 0) {
                sqlInsert.executeBatch();
                sqlInsert.clearBatch();
                counter.clear();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void updateUnverifiedAmtFor(Context ctx, String srcID, AcctCussentHistoryInfo acctCussentHistoryInfo, Connection con) throws BOSException {
        String sql = "update T_GL_AcctCussent set FUnverifiedAmtFor = ? , FUnverifiedAmtLocal=? , FUnverifiedAmtRpt=? , FUnverifiedQty=? where fid = ? ";
        BigDecimal unverifiedAmtFor = acctCussentHistoryInfo.getOriginalBalance();
        BigDecimal unverifiedAmtLocal = acctCussentHistoryInfo.getLocalBalance();
        BigDecimal unverifiedAmtRpt = acctCussentHistoryInfo.getReportBanlance();
        BigDecimal unverifiedAmtQty = acctCussentHistoryInfo.getQtyBalance();
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            Object[] params = new Object[]{unverifiedAmtFor, unverifiedAmtLocal, unverifiedAmtRpt, unverifiedAmtQty, srcID};
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
        }
    }

    private void changeVerifiedStatus(Context ctx, String objID, Connection con) throws BOSException {
        PreparedStatement ps = null;
        String sql = null;
        try {
            sql = "update T_GL_VoucherAssistRecord set FIsVierified = 1 where fid = ? ";
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, objID);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        try {
            sql = "update t_gl_acctcussent set FIsVierified = 1 where fvchassistrecordid = ? ";
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, objID);
            ps.execute();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
        }
    }

    protected void _deleteAcctCussHistory(Context ctx, String asstID, Connection con) throws BOSException {
        PreparedStatement ps = null;
        try {
            String sql = "delete from T_GL_AcctCussentHistory where FVoucherAsstIDID=? ";
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, asstID);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
    }

    private AcctCussentHistoryInfo createAcctCussentHistoryInfo(Context ctx, Map temp, String srcID, String objID, GLVerifyTypeEnum verifyType, String[] strVeriVchEntryIds, VerifyManualAutoEnum verifyManualAuto) throws BOSException, EASBizException {
        AcctCussentHistoryInfo acctCussentHistoryInfo = this.createAcctCussentHistoryInfo(ctx, temp, srcID, objID, verifyType, strVeriVchEntryIds);
        acctCussentHistoryInfo.setVerifyManualAuto(verifyManualAuto);
        return acctCussentHistoryInfo;
    }

    private Map getUnverifiedAmt(Context ctx, String srcID, Connection con) throws BOSException {
        String sql = "select a.FUnverifiedAmtFor,a.FUnverifiedAmtLocal,a.FUnverifiedAmtRpt,a.FUnverifiedQty ,\r\n\ta.fcompanyid,a.faccountid,a.fcurrencyid,a.fassgrpid,\r\n\ta.FVarBizDate FBizdate,a.Fdescription,a.fbizNumber,\r\n\tv.fnumber FVchNumber,v.fbookeddate,\r\n a.FOriginalAmount,a.FLocalAmount,a.FReportingAmount,a.FQuantity,\r\n a.fvoucherid fcussvchid,a.FEntryID fcussentryid, \r\n\tisnull(pd.fnumber,0) FPeriodNumber  \r\n\tfrom T_GL_AcctCussent a             \r\n\tleft join t_GL_voucher v on a.fvoucherid=v.fid \r\n left join t_bd_period pd on pd.fid = v.fperiodid \r\n\twhere a.fid = ? \r\n";
        PreparedStatement ps = null;
        ResultSet rowset = null;
        HashMap<String, Object> amountMap = null;
        try {
            ps = con.prepareStatement(sql.toString());
            ps.setObject(1, srcID);
            rowset = ps.executeQuery();
            amountMap = new HashMap<String, Object>();
            if (rowset.next()) {
                int index = 1;
                amountMap.put("FUnverifiedAmtFor", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedAmtLocal", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedAmtRpt", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedQty", rowset.getBigDecimal(index++));
                amountMap.put("FCompanyID", rowset.getString(index++));
                amountMap.put("FAccountID", rowset.getString(index++));
                amountMap.put("FCurrencyID", rowset.getString(index++));
                amountMap.put("FAssGrpID", rowset.getString(index++));
                amountMap.put("FBizDate", rowset.getDate(index++));
                amountMap.put("FDescription", rowset.getString(index++));
                amountMap.put("FBizNumber", rowset.getString(index++));
                amountMap.put("FVchNumber", rowset.getString(index++));
                amountMap.put("FBookedDate", rowset.getDate(index++));
                amountMap.put("FOriginalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FLocalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FReportingAmount", rowset.getBigDecimal(index++));
                amountMap.put("FQuantity", rowset.getBigDecimal(index++));
                amountMap.put("FCussVchID", rowset.getString(index++));
                amountMap.put("FCussEntryID", rowset.getString(index++));
                amountMap.put("FPeriodNumber", new Integer(rowset.getInt(index++)));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset, (Statement)ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowset, (Statement)ps);
        return amountMap;
    }

    private AcctCussentHistoryInfo createAcctCussentHistoryInfo(Context ctx, Map temp, String srcID, String objID, GLVerifyTypeEnum verifyType, String[] strVeriVchEntryIds) throws BOSException, EASBizException {
        AcctCussentHistoryInfo acctCussentHistoryInfo = new AcctCussentHistoryInfo();
        acctCussentHistoryInfo.setNumber((String)temp.get("FNumber"));
        acctCussentHistoryInfo.setSeq((Integer)temp.get("FSeq"));
        acctCussentHistoryInfo.setVerifyDate((java.util.Date)temp.get("FVerifyDate"));
        AcctCussentInfo acctCussentInfo = new AcctCussentInfo();
        acctCussentInfo.setId(BOSUuid.read((String)srcID));
        acctCussentHistoryInfo.setCussentid(acctCussentInfo);
        acctCussentHistoryInfo.setId(BOSUuid.create((BOSObjectType)acctCussentHistoryInfo.getBOSType()));
        try {
            acctCussentHistoryInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            acctCussentHistoryInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        AccountViewInfo account = new AccountViewInfo();
        account.setId(BOSUuid.read((String)((String)temp.get("FAccountID"))));
        acctCussentHistoryInfo.setAccount(account);
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)((String)temp.get("FCurrencyID"))));
        acctCussentHistoryInfo.setCurrency(currency);
        AssistantHGInfo assgrp = new AssistantHGInfo();
        assgrp.setId(BOSUuid.read((String)((String)temp.get("FAssGrpID"))));
        acctCussentHistoryInfo.setAssgrp(assgrp);
        acctCussentHistoryInfo.setVchNumber((String)temp.get("FVchNumber"));
        acctCussentHistoryInfo.setVchDate((java.util.Date)temp.get("FBookedDate"));
        acctCussentHistoryInfo.setBizDate((java.util.Date)temp.get("FBizDate"));
        acctCussentHistoryInfo.setBizNumber((String)temp.get("FBizNumber"));
        acctCussentHistoryInfo.setDescription((String)temp.get("FDescription"));
        acctCussentHistoryInfo.setCussOriginalAmount((BigDecimal)temp.get("FOriginalAmount"));
        acctCussentHistoryInfo.setCussLocalAmount((BigDecimal)temp.get("FLocalAmount"));
        acctCussentHistoryInfo.setCussReportAmount((BigDecimal)temp.get("FReportingAmount"));
        acctCussentHistoryInfo.setCussQty((BigDecimal)temp.get("FQuantity"));
        VoucherInfo cussVchInfo = null;
        VoucherEntryInfo cussEntryInfo = null;
        if (temp.get("FCussVchID") != null) {
            cussVchInfo = new VoucherInfo();
            cussVchInfo.setId(BOSUuid.read((String)temp.get("FCussVchID").toString()));
            cussEntryInfo = new VoucherEntryInfo();
            cussEntryInfo.setId(BOSUuid.read((String)temp.get("FCussEntryID").toString()));
        }
        acctCussentHistoryInfo.setCussVch(cussVchInfo);
        acctCussentHistoryInfo.setCussEntry(cussEntryInfo);
        if (objID != null) {
            VoucherAssistRecordInfo voucherAssistRecordInfo = new VoucherAssistRecordInfo();
            voucherAssistRecordInfo.setId(BOSUuid.read((String)objID));
            acctCussentHistoryInfo.setVoucherAsstID(voucherAssistRecordInfo);
        }
        if (temp.get("FPeriodNumber") != null) {
            acctCussentHistoryInfo.setCussPeriod((Integer)temp.get("FPeriodNumber"));
        }
        acctCussentHistoryInfo.setDc(verifyType);
        if (strVeriVchEntryIds != null && strVeriVchEntryIds.length > 1 && !StringUtils.isEmpty((String)strVeriVchEntryIds[0]) && !StringUtils.isEmpty((String)strVeriVchEntryIds[1])) {
            VoucherInfo veriVchInfo = new VoucherInfo();
            veriVchInfo.setId(BOSUuid.read((String)strVeriVchEntryIds[0]));
            acctCussentHistoryInfo.setVeriVch(veriVchInfo);
            VoucherEntryInfo veriEntryInfo = new VoucherEntryInfo();
            veriEntryInfo.setId(BOSUuid.read((String)strVeriVchEntryIds[1]));
            acctCussentHistoryInfo.setVeriEntry(veriEntryInfo);
            acctCussentHistoryInfo.setVeriPeriod(new Integer(strVeriVchEntryIds[2]));
        }
        acctCussentHistoryInfo.setVerifyManualAuto(VerifyManualAutoEnum.Manual);
        return acctCussentHistoryInfo;
    }

    private Map getVerifyAmount(Context ctx, String objID, Connection con) throws BOSException {
        HashMap<String, Object> hashMap;
        PreparedStatement ps = null;
        ResultSet rowset = null;
        try {
            HashMap<String, Object> amountMap = new HashMap<String, Object>();
            BigDecimal unVerifyAmtFor = new BigDecimal("0");
            BigDecimal unVerifyAmtLocal = new BigDecimal("0");
            BigDecimal unVerifyAmtRpt = new BigDecimal("0");
            BigDecimal unVerifyAmtQty = new BigDecimal("0");
            String sql = "select a.FOriginalAmount-(case when t.FVerifiedAmtFor is null then 0 else t.FVerifiedAmtFor end) ,a.FLocalAmount-(case when t.FVerifiedAmtLocal is null then 0 else t.FVerifiedAmtLocal end), a.FReportingAmount-(case when t.FVerifiedAmtRpt is null then 0 else t.FVerifiedAmtRpt end),a.FQuantity-(case when t.FVerifiedQty is null then 0 else t.FVerifiedQty end), b.fcompanyid,e.faccountid,e.fcurrencyid,a.fassgrpid,a.fbizdate,a.fdescription,a.fbiznumber,b.fnumber,b.fbookeddate   from T_GL_VoucherAssistRecord a inner join t_gl_voucher b on a.fbillid = b.fid inner join t_gl_voucherentry e on a.fentryid = e.fid                                                       left join (select sum(FOroginalAmount) FVerifiedAmtFor,sum(FLocalAmount) FVerifiedAmtLocal,sum(FReportAmount) FVerifiedAmtRpt,sum(FQty) FVerifiedQty,FVoucherAsstIDID                                 from t_gl_acctcussenthistory where FVoucherAsstIDID = ? group by FVoucherAsstIDID) t on t.FVoucherAsstIDID = a.fid                               where a.fid = ?                                                                                                                                            ";
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, objID);
            ps.setString(2, objID);
            rowset = ps.executeQuery();
            while (rowset.next()) {
                unVerifyAmtFor = unVerifyAmtFor.add(rowset.getBigDecimal(1));
                unVerifyAmtLocal = unVerifyAmtLocal.add(rowset.getBigDecimal(2));
                unVerifyAmtRpt = unVerifyAmtRpt.add(rowset.getBigDecimal(3));
                unVerifyAmtQty = unVerifyAmtQty.add(rowset.getBigDecimal(4));
                amountMap.put("FCompanyID", rowset.getString(5));
                amountMap.put("FAccountID", rowset.getString(6));
                amountMap.put("FCurrencyID", rowset.getString(7));
                amountMap.put("FAssGrpID", rowset.getString(8));
                amountMap.put("FBizDate", rowset.getDate(9));
                amountMap.put("FDescription", rowset.getString(10));
                amountMap.put("FBizNumber", rowset.getString(11));
                amountMap.put("FVchNumber", rowset.getString(12));
                amountMap.put("FBookedDate", rowset.getDate(13));
            }
            amountMap.put("FUnverifiedAmtFor", unVerifyAmtFor);
            amountMap.put("FUnverifiedAmtLocal", unVerifyAmtLocal);
            amountMap.put("FUnverifiedAmtRpt", unVerifyAmtRpt);
            amountMap.put("FUnverifiedAmtQty", unVerifyAmtQty);
            hashMap = amountMap;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowset, (Statement)ps);
        return hashMap;
    }

    private String getAcctcussentHistoryNumber(Context ctx, java.util.Date date, String[] ids, Connection con) throws BOSException {
        String number = null;
        String sql = "select max(TO_INTEGER(fnumber)) FNumber from T_GL_AcctCussentHistory where  FcompanyID=? and  FVerifyDate = ?";
        Object[] params = new Object[]{ids[0], new Date(DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()).getTime())};
        PreparedStatement ps = null;
        ResultSet row = null;
        try {
            ps = con.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            row = ps.executeQuery();
            if (row != null && row.next()) {
                number = row.getString("FNumber");
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(row, (Statement)ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)row, (Statement)ps);
        if (number == null) {
            number = "1";
        } else {
            int value = Integer.parseInt(number);
            number = String.valueOf(value + 1);
        }
        return StringUtils.fixNumber((int)Integer.parseInt(number), (int)8);
    }

    public boolean setMutex(Context ctx, String[] ids) throws BOSException, EASBizException {
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : "00000000-0000-0000-0000-00000000000013B7DE7F";
        this.mp = GLMutexUtils.buildModifyMutexParameter(ctx, ctx.getAIS(), ids[0], ids[1] + ids[2] + ids[3], userID, "GL_Verify", MutexLockType.EXCLUSIVE_LOCK);
        this.mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLockSucceed = false;
        if (this.mp != null && !(isLockSucceed = this.mutex.requestMutex(this.mp))) {
            Map requestMaps = this.mutex.getMutexList();
            String actionName = null;
            if (requestMaps != null && requestMaps.size() > 0) {
                Iterator it = requestMaps.keySet().iterator();
                if (it.hasNext()) {
                    MutexParameter mp1 = (MutexParameter)requestMaps.get(it.next());
                    actionName = mp1.getActionName();
                }
            } else {
                actionName = this.mp.getDescription();
            }
            throw new BOSException(AcctCussentVerifyService.getString(ctx, "GL_MutexNow"));
        }
        return isLockSucceed;
    }

    private boolean setMutex(Context ctx, String[] ids, String action) throws BOSException, EASBizException {
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : "00000000-0000-0000-0000-00000000000013B7DE7F";
        this.mp = GLMutexUtils.buildModifyMutexParameter(ctx, ctx.getAIS(), ids[0], "", userID, action, MutexLockType.EXCLUSIVE_LOCK);
        this.mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLockSucceed = false;
        if (this.mp != null && !(isLockSucceed = this.mutex.requestMutex(this.mp))) {
            Map requestMaps = this.mutex.getMutexList();
            String actionName = null;
            if (requestMaps != null && requestMaps.size() > 0) {
                Iterator it = requestMaps.keySet().iterator();
                if (it.hasNext()) {
                    MutexParameter mp1 = (MutexParameter)requestMaps.get(it.next());
                    actionName = mp1.getActionName();
                    logger.error((Object)("release Mutex failure:" + actionName + " \r\n describe->" + mp1.toString()));
                }
            } else {
                actionName = this.mp.getDescription();
            }
            throw new BOSException(AcctCussentVerifyService.getString(ctx, "GL_MutexNow"));
        }
        return isLockSucceed;
    }

    public void createTempTableForDirtyDate(AcctcusssentVerifyParam verifyParam) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("(").append("CUSSENTID VARCHAR(44) ").append(",ACCOUNtNumber VARCHAR(44)").append(",FveriAsstID VARCHAR(44)").append(")");
        String tempTable = AcctCussentVerifyUtils.createTempTableByDDL(verifyParam.getCtx(), "gl_acct_dirtydata", sql);
        verifyParam.setDirtyDataTable(tempTable);
    }

    public void insertDirtyData(AcctcusssentVerifyParam verifyParam) throws EASBizException, BOSException {
        PreparedStatement ps = null;
        try {
            if (this.preCompanyNumber == null || !this.preCompanyNumber.equals(this.companyNumber)) {
                this.createTempTableForDirtyDate(verifyParam);
                String sql = this.getDirtyDataSQL(verifyParam.getDirtyDataTable(), this.companyNumber, verifyParam.getIds());
                ps = verifyParam.getCon().prepareStatement(sql.toString());
                this.sqlStartTime = System.currentTimeMillis();
                ps.execute();
                this.sqlEndTime = System.currentTimeMillis();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(ps);
        }
    }

    public String getDirtyDataSQL(String dirtyDataTableName, String companyNumber, String[] ids) {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(dirtyDataTableName).append(" \r\n ").append(" (CUSSENTID,ACCOUNtNumber,FveriAsstID)").append(" \r\n ").append(" select CUSSENTID,AcctNum,FveriAsstID ").append(" \r\n ").append(" from ").append(" \r\n ").append(" (").append(" \r\n ").append(" SELECT CussentID,AcctNum,CompanyNum,CussentAmt").append(" \r\n ").append(" ,UNVERIFIEDAMTFOR,SumVerifiedAmt,FveriAsstID ").append(" \r\n ").append(" FROM (").append(" \r\n ").append("\t SELECT res.CussentID,res.AcctNum,res.CompanyNum,res.CussentAmt").append(" \r\n ").append("\t ,res.UNVERIFIEDAMTFOR,sum(res.VerifiedAmtTotle) SumVerifiedAmt,res.FveriAsstID").append(" \r\n ").append("\t FROM (").append(" \r\n ").append("\t \t\t(").append(" \r\n ").append("\t\t\tSELECT t0.FID CussentID,t1.FNumber AcctNum,t6.FNumber CompanyNum").append(" \r\n ").append("\t\t\t,t4.FORIGINALAMOUNT CussentAmt,t0.FUNVERIFIEDAMTFOR UNVERIFIEDAMTFOR").append(" \r\n ").append("\t\t\t,sum(t5.FOROGINALAMOUNT) VerifiedAmtTotle,t8.FID  FveriAsstID").append(" \r\n ").append("\t\t\tFROM t_gl_acctcussent t0").append(" \r\n ").append("\t\t\tINNER JOIN t_bd_accountview t1 ON t0.Faccountid = t1.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_voucherassistrecord t4 ON t0.Fvchassistrecordid = t4.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_acctcussenthistory t5 ON t0.FID = t5.FCussentIDID").append(" \r\n ").append("\t\t\tINNER JOIN t_org_company t6 ON t0.FCompanyID = t6.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_voucher t7 ON t5.FVERIVchID = t7.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_voucherassistrecord t8 ON t5.FVoucherAsstIDID = t8.FID").append(" \r\n ").append("\t\t\tWHERE t7.FBizStatus NOT IN (0,2)").append(" \r\n ").append("\t\t\tAND t0.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND t5.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND t6.fid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND t7.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND (t6.FNumber = '").append(companyNumber).append("')").append(" \r\n ").append("\t\t\tGROUP BY t1.FNumber,t6.FNumber,t0.FID,t4.FORIGINALAMOUNT").append(" \r\n ").append("\t\t\t,t0.FUNVERIFIEDAMTFOR,t8.FID").append(" \r\n ").append("\t\t\tHAVING ((t4.FOriginalAmount - t0.FUnVerifiedAmtFor) <> sum(t5.FOROGINALAMOUNT))").append(" \r\n ").append("\t\t\t)").append(" \r\n ").append("\t\t\tUNION ALL").append(" \r\n ").append("\t\t\t(").append(" \r\n ").append("\t\t\tSELECT t0.FID CussentID,t1.FNumber AcctNum,t6.FNumber CompanyNum").append(" \r\n ").append("\t\t\t,t4.FORIGINALAMOUNT CussentAmt,t0.FUNVERIFIEDAMTFOR UNVERIFIEDAMTFOR").append(" \r\n ").append("\t\t\t,sum(t5.FOROGINALAMOUNT) VerifiedAmtTotle,t5.FVoucherAsstIDID  FveriAsstID").append(" \r\n ").append("\t\t\tFROM t_gl_acctcussent t0").append(" \r\n ").append("\t\t\tINNER JOIN t_bd_accountview t1 ON t0.Faccountid = t1.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_voucherassistrecord t4 ON t0.Fvchassistrecordid = t4.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_acctcussenthistory t5 ON t0.FID = t5.FCussentIDID").append(" \r\n ").append("\t\t\tINNER JOIN t_org_company t6 ON t0.FCompanyID = t6.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_voucher t7 ON t5.FVERIVchID = t7.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_acctcussent t8 ON t5.FVoucherAsstIDID = t8.FID").append(" \r\n ").append("\t\t\tWHERE t7.FBizStatus NOT IN (0,2)").append(" \r\n ").append("\t\t\tAND t0.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND t5.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND t6.fid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND t7.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND t8.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND (t6.FNumber = '").append(companyNumber).append("')").append(" \r\n ").append("\t\t\tGROUP BY t1.FNumber,t6.FNumber,t0.FID,t4.FORIGINALAMOUNT").append(" \r\n ").append("\t\t\t,t0.FUNVERIFIEDAMTFOR,t5.FVoucherAsstIDID").append(" \r\n ").append("\t\t\tHAVING ((t4.FOriginalAmount - t0.FUnVerifiedAmtFor) <> sum(t5.FOROGINALAMOUNT))").append(" \r\n ").append("\t\t\t)").append(" \r\n ").append("\t\t\tUNION ALL").append(" \r\n ").append("\t\t\t(").append(" \r\n ").append("\t\t\tSELECT t0.FID CussentID,t1.FNumber AcctNum").append(" \r\n ").append("\t\t\t,t6.FNumber CompanyNum,t4.FORIGINALAMOUNT CussentAmt").append(" \r\n ").append("\t\t\t,t0.FUNVERIFIEDAMTFOR UNVERIFIEDAMTFOR,sum(t5.FOROGINALAMOUNT) VerifiedAmtTotle").append(" \r\n ").append("\t\t\t,t5.FVoucherAsstIDID  FveriAsstID").append(" \r\n ").append("\t\t\tFROM t_gl_acctcussent t0").append(" \r\n ").append("\t\t\tINNER JOIN t_bd_accountview t1 ON t0.Faccountid = t1.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_voucherassistrecord t4 ON t0.Fvchassistrecordid = t4.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_acctcussenthistory t5 ON t0.FID = t5.FCussentIDID").append(" \r\n ").append("\t\t\tINNER JOIN t_org_company t6 ON t0.FCompanyID = t6.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_acctcussent t8 ON t5.FVoucherAsstIDID = t8.FID").append(" \r\n ").append("\t\t\tWHERE t8.FISINIT = 1").append(" \r\n ").append("\t\t\tAND t0.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND t5.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND t6.fid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND t8.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tAND (t6.FNumber = '").append(companyNumber).append("')").append(" \r\n ").append("\t\t\tGROUP BY t1.FNumber,t6.FNumber,t0.FID").append(" \r\n ").append("\t\t\t,t4.FORIGINALAMOUNT,t0.FUNVERIFIEDAMTFOR,t5.FVoucherAsstIDID").append(" \r\n ").append("\t\t\tHAVING ((t4.FOriginalAmount - t0.FUnVerifiedAmtFor) <> sum(t5.FOROGINALAMOUNT))").append(" \r\n ").append("\t\t\t)").append(" \r\n ").append("\t\t\tUNION ALL").append(" \r\n ").append("\t\t\t(").append(" \r\n ").append("\t\t\tSELECT t0.FID CussentID,t1.FNumber AcctNum").append(" \r\n ").append("\t\t\t,t6.FNumber CompanyNum,t4.FORIGINALAMOUNT CussentAmt").append(" \r\n ").append("\t\t\t,t0.FUNVERIFIEDAMTFOR UNVERIFIEDAMTFOR,0").append(" \r\n ").append("\t\t\t,'' FveriAsstID").append(" \r\n ").append("\t\t\tFROM t_gl_acctcussent t0").append(" \r\n ").append("\t\t\tINNER JOIN t_bd_accountview t1 ON t0.Faccountid = t1.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_gl_voucherassistrecord t4 ON t0.Fvchassistrecordid = t4.FID").append(" \r\n ").append("\t\t\tINNER JOIN t_org_company t6 ON t0.FCompanyID = t6.FID").append(" \r\n ").append("\t\t\tAND t0.fcompanyid = '").append(ids[0]).append("'").append(" \r\n ").append("\t\t\tWHERE (t6.FNumber = '").append(companyNumber).append("')").append(" \r\n ").append("\t\t\tAND t0.FID NOT IN (").append(" \r\n ").append("\t\t\t\tSELECT FCussentIDID").append(" \r\n ").append("\t\t\t\tFROM t_gl_acctcussenthistory").append(" \r\n ").append("\t\t\t\tWHERE FCompanyID = ").append(" \r\n ").append("\t\t\t\t\t(SELECT FID").append(" \r\n ").append("\t\t\t\t\t FROM t_org_company").append(" \r\n ").append("\t\t\t\t \t WHERE FNumber = '").append(companyNumber).append("')").append(" \r\n ").append("\t\t\t\t)").append(" \r\n ").append("\t\t\tAND t0.FUnVerifiedAmtFor <> t4.FOriginalAmount").append(" \r\n ").append("\t\t\t)").append(" \r\n ").append("\t) res").append(" \r\n ").append("\tGROUP BY").append(" \r\n ").append("\tres.CussentID,res.AcctNum,res.CompanyNum,res.CussentAmt").append(" \r\n ").append("\t,res.UNVERIFIEDAMTFOR,res.FveriAsstID").append(" \r\n ").append("\tHAVING (res.CussentAmt - res.UNVERIFIEDAMTFOR) <> sum(res.VerifiedAmtTotle)").append(" \r\n ").append(") as temp_table1").append(" \r\n ").append(") as temp_table2");
        return sql.toString();
    }

    static class Counter {
        private int counter = 0;

        Counter() {
        }

        public void add() {
            ++this.counter;
        }

        public void clear() {
            this.counter = 0;
        }

        public int getValue() {
            return this.counter;
        }
    }
}

