/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctcusssentVerifyParam;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AcctCussentVerifyUtils {
    public static String VERIFY_TRANSACTION_ENDTIME = "VERIFY_TRANSACTION_ENDTIME";

    public static Map getVerifyVchIds(AcctcusssentVerifyParam param, String[] verifyAsstIds) throws BOSException, EASBizException {
        String sql;
        HashMap<String, String[]> verifyVchIds = new HashMap<String, String[]>();
        if (verifyAsstIds == null || verifyAsstIds.length <= 0) {
            return verifyVchIds;
        }
        AcctCussentVerifyUtils.checkId(verifyAsstIds);
        String[] strIds = null;
        PreparedStatement ps = null;
        ResultSet rs1 = null;
        PreparedStatement ps1 = null;
        String tempTableName = null;
        try {
            sql = "select vst.fid,vst.fbillid,vst.fentryid,pd.fnumber from t_gl_voucherassistrecord vst inner join t_gl_voucher v on v.fid = vst.fbillid inner join t_bd_period pd on pd.fid = v.fperiodid where vst.fid in ";
            if (verifyAsstIds.length > 500) {
                long time = System.currentTimeMillis();
                tempTableName = "gl_verifyAsstId" + time;
                StringBuffer tempTableSql = new StringBuffer();
                tempTableSql.append("create table ").append(tempTableName).append(" (").append("FID VARCHAR(44) ").append(")");
                ps = param.getCon().prepareStatement(tempTableSql.toString());
                ps.execute();
                ps.close();
                String insertSql = " insert into " + tempTableName + " (FID) values(?)";
                ps = param.getCon().prepareStatement(insertSql);
                int count = 0;
                int len = verifyAsstIds.length;
                for (int i = 0; i < len; ++i) {
                    ps.setString(1, verifyAsstIds[i]);
                    ps.addBatch();
                    if (++count < 200) continue;
                    count = 0;
                    ps.executeBatch();
                    ps.clearBatch();
                }
                if (count > 0) {
                    count = 0;
                    ps.executeBatch();
                    ps.clearBatch();
                }
                sql = sql + "( select FID from " + tempTableName + ")";
            } else {
                sql = sql + SQLUtil.arrayToInList(verifyAsstIds);
            }
            ps1 = param.getCon().prepareStatement(sql);
            rs1 = ps1.executeQuery();
            while (rs1.next()) {
                strIds = new String[]{rs1.getString("fbillid"), rs1.getString("fentryid"), rs1.getString("fnumber")};
                verifyVchIds.put(rs1.getString("fid"), strIds);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(rs1, ps1);
                if (tempTableName != null) {
                    String sql2 = "drop table " + tempTableName;
                    try {
                        ps = param.getCon().prepareStatement(sql2);
                        ps.execute();
                        ps.close();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((ResultSet)rs1, (Statement)ps1);
        if (tempTableName != null) {
            sql = "drop table " + tempTableName;
            try {
                ps = param.getCon().prepareStatement(sql);
                ps.execute();
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return verifyVchIds;
    }

    public static AssistantHGInfo getHgInfo(Context ctx, String FAssGrpID, String caa, Connection con) throws BOSException, EASBizException {
        AssistantHGInfo info = new AssistantHGInfo();
        info.setId(BOSUuid.read((String)FAssGrpID));
        StringBuffer sql = new StringBuffer();
        sql.append("  select c.fassthgattribute from t_bd_asstaccount a  ");
        sql.append("  inner join t_bd_asstactgroupdetail b on a.fid=b.fasstaccountid ");
        sql.append("  inner join t_bd_asstacttype c on b.fasstacttypeid=c.fid ");
        sql.append("  where a.fid=? ");
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, caa);
            rs = ps.executeQuery();
            IGLGeneralFacade geFacade = GLGeneralFacadeFactory.getLocalInstance(ctx);
            if (rs != null) {
                while (rs.next()) {
                    String assgrp = rs.getString("fassthgattribute");
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("id", FAssGrpID);
                    param.put("asstribute", assgrp);
                    Map result = geFacade.dealTask("GetDataBaseInfo", param);
                    DataBaseInfo dabaseInfo = (DataBaseInfo)result.get("DataBaseInfo");
                    info.put(assgrp, (Object)dabaseInfo);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return info;
    }

    public boolean isTimeOut(Time endTime) {
        return true;
    }

    public static String createTempTableByDDL(Context ctx, String keyDesc, StringBuffer strFields) throws BOSException, EASBizException {
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(keyDesc).append(strFields);
        TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
        String tempateTable = "";
        try {
            tempateTable = iPool.createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempateTable;
    }

    public static void dropTempTable(Context ctx, String tableName, Logger logger) {
        TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
        iPool.releaseTable(tableName);
    }

    public static Connection getConnection(Context ctx) throws BOSException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
    }

    public static boolean isTimeOut(Date endTime) {
        int end = new Date().compareTo(endTime);
        return end >= 0;
    }

    public static String getCurrentDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return "to_date('" + format.format(new Date()) + "')";
    }

    public static boolean checkCanVerify(boolean uncheckBizNumber, boolean nullBizNumIsNotSame, String bizNumber, String bizNumber2) {
        boolean checkBizNum = !uncheckBizNumber;
        boolean checkNullBizNumIsNotSame = nullBizNumIsNotSame;
        return !checkBizNum || (checkNullBizNumIsNotSame || bizNumber.equals(bizNumber2)) && (!checkNullBizNumIsNotSame || bizNumber.equals(bizNumber2) && !StringUtils.isEmpty((String)bizNumber) && !StringUtils.isEmpty((String)bizNumber2));
    }

    public static void checkBeforeVerify(AcctcusssentVerifyParam param, String[] ids, boolean isAsst, Map dateMap) throws GLException, BOSException {
        if (ids.length == 0 || dateMap == null) {
            return;
        }
        String sqlSelect = null;
        sqlSelect = isAsst ? "select a.fid,v.flastupdatetime from t_gl_voucherassistrecord a inner join t_gl_voucher v on v.fid=a.fbillid where a.fid in ({0}) " : "select fid,flastupdatetime from t_gl_acctcussent where fid in ({0}) ";
        int count = 0;
        StringBuffer sqlVars = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        HashMap<String, Timestamp> selectResult = new HashMap<String, Timestamp>();
        ResultSet rs1 = null;
        PreparedStatement ps1 = null;
        for (int i = 0; i < ids.length; ++i) {
            try {
                sqlVars.append(",?");
                params.add(ids[i]);
                if (++count % 500 != 0) continue;
                sqlVars.deleteCharAt(0);
                String sql = MessageFormat.format(sqlSelect, sqlVars.toString());
                ps1 = param.getCon().prepareStatement(sql);
                int size = params.size();
                for (int m = 0; m < size; ++m) {
                    ps1.setObject(m + 1, params.get(m));
                }
                rs1 = ps1.executeQuery();
                while (rs1.next()) {
                    selectResult.put(rs1.getString(1), rs1.getTimestamp(2));
                }
                AcctCussentVerifyUtils.compareDate(selectResult, dateMap, params);
                count = 0;
                sqlVars.delete(0, sqlVars.length());
                params.clear();
                selectResult.clear();
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup(rs1, ps1);
            }
        }
        if (count > 0) {
            try {
                sqlVars.deleteCharAt(0);
                String sql = MessageFormat.format(sqlSelect, sqlVars.toString());
                ps1 = param.getCon().prepareStatement(sql);
                int size = params.size();
                for (int i = 0; i < size; ++i) {
                    ps1.setObject(i + 1, params.get(i));
                }
                rs1 = ps1.executeQuery();
                while (rs1.next()) {
                    selectResult.put(rs1.getString(1), rs1.getTimestamp(2));
                }
                AcctCussentVerifyUtils.compareDate(selectResult, dateMap, params);
                count = 0;
                sqlVars.delete(0, sqlVars.length());
                params.clear();
                selectResult.clear();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs1, ps1);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs1, (Statement)ps1);
        }
    }

    public static void compareDate(Map selectResult, Map dateMap, List params) throws GLException {
        Iterator it = params.iterator();
        String key = null;
        while (it.hasNext()) {
            key = (String)it.next();
            Date oldDate = (Date)dateMap.get(key);
            Timestamp newDate = (Timestamp)selectResult.get(key);
            if (oldDate == null && newDate == null) continue;
            if (oldDate == null) {
                throw new GLException(GLException.DATA_HAS_MODIFIED);
            }
            if (newDate == null) {
                throw new GLException(GLException.DATA_HAS_MODIFIED);
            }
            if (oldDate.compareTo(newDate) == 0) continue;
            throw new GLException(GLException.DATA_HAS_MODIFIED);
        }
    }

    public static void checkParamBeforeStart(boolean uncheckBizNumber, boolean nullBizNumIsNotSame, boolean amtMustSame, boolean gativeVerify) throws EASBizException {
        AcctCussentVerifyUtils.checkParamBeforeStart(uncheckBizNumber, nullBizNumIsNotSame, amtMustSame, false, gativeVerify);
    }

    public static void checkParamBeforeStart(boolean uncheckBizNumber, boolean nullBizNumIsNotSame, boolean amtMustSame, boolean verifySameByAmt, boolean gativeVerify) throws EASBizException {
        if (uncheckBizNumber && nullBizNumIsNotSame) {
            throw new GLException(GLException.UNCHECKBIZNUMBERANDNULLBIZNUMISNOTSAME);
        }
        if (amtMustSame && verifySameByAmt) {
            throw new GLException(GLException.AUTOVERIFYPARAMCTRL1);
        }
    }

    public static Date getVerifyEndTime(Context ctx, String companyID) throws BOSException, EASBizException, ParseException {
        HashMap<String, String> hmParamIn = new HashMap<String, String>();
        ObjectUuidPK comPK = null;
        if (companyID != null) {
            comPK = new ObjectUuidPK(companyID);
        }
        hmParamIn.put(VERIFY_TRANSACTION_ENDTIME, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        IParamControl pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        String endtime = (String)hmAllParam.get(VERIFY_TRANSACTION_ENDTIME);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateTime = df.format(new Date()) + " " + endtime;
        return df2.parse(dateTime);
    }

    public static void checkId(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        for (String id : ids) {
            BOSUuid.read((String)id);
        }
    }
}

