/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryCollection;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryFactory;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryInfo;
import com.kingdee.eas.fi.gl.AdjustExchangeRateCollection;
import com.kingdee.eas.fi.gl.AdjustExchangeRateException;
import com.kingdee.eas.fi.gl.AdjustExchangeRateFactory;
import com.kingdee.eas.fi.gl.AdjustExchangeRateInfo;
import com.kingdee.eas.fi.gl.AdjustExchangeRate_AeAccCollection;
import com.kingdee.eas.fi.gl.AdjustExchangeRate_LocCurCollection;
import com.kingdee.eas.fi.gl.AdjustExchangeRate_LocCurFactory;
import com.kingdee.eas.fi.gl.AdjustExchangeRate_LocCurInfo;
import com.kingdee.eas.fi.gl.AdjustExchangeRate_RptCurCollection;
import com.kingdee.eas.fi.gl.AdjustExchangeRate_RptCurFactory;
import com.kingdee.eas.fi.gl.AdjustExchangeRate_RptCurInfo;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAdjExchRateHistory;
import com.kingdee.eas.fi.gl.ProduceInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractAdjustExchangeRateControllerBean;
import com.kingdee.eas.fi.gl.app.AdjustExchangeRateGenVchService;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdjustExchangeRateControllerBean
extends AbstractAdjustExchangeRateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.AdjustExchangeRateControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdjustExchangeRateInfo info = (AdjustExchangeRateInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("FICompany.id", (Object)info.getFICompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            throw new AdjustExchangeRateException(AdjustExchangeRateException.NUMBER_EXISTS);
        }
        return super._submit(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected Map _fetchInitData(Context ctx, String currentCompanyID) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SelectorItemCollection sic1 = GlUtils.getCompanySic();
        sic1.add(new SelectorItemInfo("baseExchangeTable.isMulExchange"));
        sic1.add(new SelectorItemInfo("reportExchangeTable.isMulExchange"));
        CompanyOrgUnitInfo com = GlUtils.getCurrentCompany(ctx, currentCompanyID, sic1, true);
        String cuid = com.getCU().getId().toString();
        map.put("company", com);
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)currentCompanyID));
        FilterInfo filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "adminCU");
        map.put("filterVT", filterVT);
        HashMap adjExchRate = GLPeriodEndFacadeFactory.getLocalInstance(ctx).getAdjExchRate(currentCompanyID);
        map.put("adjExchRate", adjExchRate);
        String[] paramList = new String[]{"G001", "GL_008", "G010", "GL_067", "GL_072", AccountConstant.GovermentAccountingSystem};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)currentCompanyID);
        boolean useReportingCurrency = glParam.getBoolean("G001");
        if (useReportingCurrency && com.getReportCurrency() == null) {
            throw new GLException(GLException.NOREPORTINGCUR);
        }
        map.put(AccountConstant.GovermentAccountingSystem, glParam.getBoolean(AccountConstant.GovermentAccountingSystem));
        map.put("G001", useReportingCurrency);
        map.put("GL_072", glParam.getBoolean("GL_072"));
        map.put("G010", glParam.getBoolean("G010"));
        map.put("GL_067", "1".equals(glParam.getString("GL_067")));
        return map;
    }

    @Override
    protected List _getRepeatedAccounts(Context ctx, AdjustExchangeRateInfo info) throws BOSException, EASBizException {
        String companyID = info.getFICompany().getId().toString();
        AdjustExchangeRate_AeAccCollection aeaColl = info.get_AeAcc();
        HashSet<String> accountIDSet = new HashSet<String>();
        int j = aeaColl.size();
        for (int i = 0; i < j; ++i) {
            accountIDSet.add(aeaColl.get(i).getAccID());
        }
        Set idSetCurrency = this.getSameCurrencyData(ctx, info);
        if (idSetCurrency == null || idSetCurrency.size() == 0) {
            return null;
        }
        String idString = SQLUtil.arrayToInList(idSetCurrency.toArray(new String[idSetCurrency.size()]));
        boolean allAccountExist = false;
        StringBuffer sql1 = new StringBuffer();
        sql1.append("select arate.fid from t_gl_AdjustExchangeRate arate");
        sql1.append(" where arate.FFICOMPANYID ='" + companyID + "'");
        sql1.append(" and arate.FisSetAccount =0 ");
        sql1.append(" and arate.fid in").append(idString);
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
        try {
            if (rowSet1.next()) {
                allAccountExist = true;
            }
        }
        catch (SQLException e1) {
            throw new BOSException("SQL ERROR!", (Throwable)e1);
        }
        if (accountIDSet == null || accountIDSet.size() == 0) {
            if (allAccountExist) {
                throw new AdjustExchangeRateException(AdjustExchangeRateException.ONE_COMPANY_ONE_ALL);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select acc.fnumber as number from t_gl_AdjustExchangeRate_AeAcc aacc");
            sql.append(" inner join t_gl_AdjustExchangeRate  arate on aacc.fparentid=arate.fid");
            sql.append(" inner join t_bd_accountview acc on aacc.faccid=acc.fid ");
            sql.append(" where arate.FFICOMPANYID ='" + companyID + "'");
            sql.append(" and aacc.fparentid in").append(idString);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> list = new ArrayList<String>();
            try {
                while (rowSet.next()) {
                    String number = rowSet.getString("number");
                    list.add(number);
                }
            }
            catch (SQLException e) {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            return list;
        }
        if (allAccountExist) {
            StringBuffer sql = new StringBuffer();
            sql.append("select fnumber as number from t_bd_accountview ");
            sql.append(" where fid in ").append(SQLUtil.arrayToInList(accountIDSet.toArray(new String[accountIDSet.size()])));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> list = new ArrayList<String>();
            try {
                while (rowSet.next()) {
                    String number = rowSet.getString("number");
                    list.add(number);
                }
            }
            catch (SQLException e) {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            return list;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select acc.fnumber as number from t_gl_AdjustExchangeRate_AeAcc aacc");
        sql.append(" inner join t_gl_AdjustExchangeRate  arate on aacc.fparentid=arate.fid");
        sql.append(" inner join t_bd_accountview acc on aacc.faccid=acc.fid ");
        sql.append(" where arate.FFICOMPANYID ='" + companyID + "'");
        sql.append(" and aacc.faccid in ").append(SQLUtil.arrayToInList(accountIDSet.toArray(new String[accountIDSet.size()])));
        sql.append(" and aacc.fparentid in").append(idString);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String number = rowSet.getString("number");
                list.add(number);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return list;
    }

    private Set getSameCurrencyData(Context ctx, AdjustExchangeRateInfo info) throws BOSException {
        AdjustExchangeRate_LocCurCollection locColl;
        StringBuffer sql = new StringBuffer();
        sql.append("select arate.fid  id from t_gl_AdjustExchangeRate arate");
        sql.append("  left join T_GL_AdjustExchangeRate_LocCur loc on loc.FParentID=arate.fid");
        sql.append("  left join T_GL_AdjustExchangeRate_RptCur rpt on rpt.FParentID=arate.fid");
        sql.append(" where arate.FFICOMPANYID ='" + info.getFICompany().getId().toString() + "'");
        if (info.getId() != null) {
            sql.append(" and arate.fid <>'" + info.getId().toString() + "'");
        }
        if ((locColl = info.get_LocCur()) == null || locColl.size() == 0) {
            sql.append(" and  loc.FcurrencyID is null ");
        } else {
            StringBuffer idstr = new StringBuffer();
            idstr.append("(");
            int j = locColl.size();
            for (int i = 0; i < j; ++i) {
                idstr.append("'" + locColl.get(i).getCurrencyID() + "',");
            }
            idstr.deleteCharAt(idstr.length() - 1);
            idstr.append(")");
            sql.append(" and loc.FcurrencyID in").append(idstr);
            sql.append("  and not exists( ");
            sql.append(" \tselect 1 from T_GL_AdjustExchangeRate_LocCur l");
            sql.append("\twhere l.FParentID =arate.fid");
            sql.append("\t and l.FcurrencyID  not in").append(idstr);
            sql.append(")");
            sql.append("  and exists( ");
            sql.append(" \tselect 1 from T_GL_AdjustExchangeRate_LocCur l");
            sql.append("\twhere l.FParentID =arate.fid");
            sql.append("\t\tgroup by l.FParentID ");
            sql.append("\t  having count(1)=").append(locColl.size());
            sql.append(")");
        }
        AdjustExchangeRate_RptCurCollection rptColl = info.get_RptCur();
        if (rptColl == null || rptColl.size() == 0) {
            sql.append(" and  rpt.FcurrencyID is null ");
        } else {
            StringBuffer idstr = new StringBuffer();
            idstr.append("(");
            int j = rptColl.size();
            for (int i = 0; i < j; ++i) {
                idstr.append("'" + rptColl.get(i).getCurrencyID() + "',");
            }
            idstr.deleteCharAt(idstr.length() - 1);
            idstr.append(")");
            sql.append(" and rpt.FcurrencyID in").append(idstr);
            sql.append("  and not exists( ");
            sql.append(" \tselect 1 from T_GL_AdjustExchangeRate_RptCur r");
            sql.append("\twhere r.FParentID =arate.fid");
            sql.append("\t and r.FcurrencyID  not in").append(idstr);
            sql.append(")");
            sql.append("  and exists( ");
            sql.append(" \tselect 1 from T_GL_AdjustExchangeRate_RptCur r");
            sql.append("\twhere r.FParentID =arate.fid");
            sql.append("\t\tgroup by r.FParentID ");
            sql.append("\t  having count(1)=").append(rptColl.size());
            sql.append(")");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> set = new HashSet<String>();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("id");
                set.add(id);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return set;
    }

    @Override
    protected Map _generateVoucherCollection(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Map> initDataMap = new HashMap<String, Map>();
        ArrayList<ProduceInfo> produceInfos = new ArrayList<ProduceInfo>();
        CurrencyCollection allCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(true);
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            ProduceInfo produceInfo = new ProduceInfo();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long startTime = System.currentTimeMillis();
            produceInfo.setStartTime(formatter.format(new Date()));
            Map resultMap = null;
            String companyId = null;
            try {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)it.next())));
                AdjustExchangeRateInfo adjRateInfo = (AdjustExchangeRateInfo)this._getValue(ctx, (IObjectPK)pk, AdjustExchangeRateInfo.getDefaultSelector());
                if (adjRateInfo.getIsUsing() == 0) {
                    produceInfo.setCompany(adjRateInfo.getFICompany().getName());
                    produceInfo.setAutoTransNumber(adjRateInfo.getNumber());
                    produceInfo.setAutoTransName(adjRateInfo.getName());
                    produceInfo.setId(pk.toString());
                    produceInfo.setErrInfo(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.AdjustExchangeRateResource", (String)"AdjustExchangeRateListUI_noAllow", (Locale)ctx.getLocale()));
                    produceInfo.setSuccess(false);
                    long endTime = System.currentTimeMillis();
                    produceInfo.setEndTime(formatter.format(new Date()));
                    produceInfo.setUseTime(endTime - startTime);
                    produceInfos.add(produceInfo);
                    continue;
                }
                companyId = adjRateInfo.getFICompany().getId().toString();
                Map initData = (Map)initDataMap.get(companyId);
                if (initData == null) {
                    GLBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(new String[]{companyId});
                    initData = this._fetchInitData(ctx, companyId);
                    initDataMap.put(companyId, initData);
                }
                produceInfo.setCompany(adjRateInfo.getFICompany().getName());
                produceInfo.setAutoTransNumber(adjRateInfo.getNumber());
                produceInfo.setAutoTransName(adjRateInfo.getName());
                produceInfo.setId(pk.toString());
                initData.put("allCurrency", allCurrency);
                resultMap = AdjustExchangeRateFactory.getLocalInstance(ctx).generateVoucher(adjRateInfo, idSet.size() >= 1, initData);
                result.put(pk.toString(), resultMap);
                VoucherInfo vch1 = (VoucherInfo)resultMap.get("vch1");
                VoucherInfo vch2 = (VoucherInfo)resultMap.get("vch2");
                String voucherId = "";
                String voucherNumber = "";
                String voucherWebNumber = "";
                if (vch1 != null) {
                    voucherNumber = voucherNumber + vch1.getNumber();
                    voucherWebNumber = "[" + vch1.getVoucherType().getName() + "]" + vch1.getNumber() + "  ";
                    voucherId = vch1.getId().toString();
                }
                if (vch2 != null) {
                    if (!"".equals(voucherNumber)) {
                        voucherNumber = voucherNumber + ";";
                    }
                    voucherNumber = voucherNumber + vch2.getNumber();
                    voucherWebNumber = voucherWebNumber + ";";
                    voucherWebNumber = voucherWebNumber + "[" + vch2.getVoucherType().getName() + "]" + vch2.getNumber() + "  ";
                    voucherId = voucherId + ";";
                    voucherId = voucherId + vch2.getId().toString();
                }
                produceInfo.setVoucherNumber(voucherNumber);
                produceInfo.setVoucherWebNumber(voucherWebNumber);
                produceInfo.setVoucherId(voucherId);
                produceInfo.setSuccess(true);
            }
            catch (EASBizException ex) {
                if (ex instanceof GLPeriodEndException && "89-042".equals(((GLPeriodEndException)ex).getCode())) {
                    produceInfo.setDealFunction("showVoucher");
                    if (companyId != null) {
                        PeriodInfo period = GlUtils.getCurrentPeriod(ctx, companyId);
                        produceInfo.setPeriodId(period.getId().toString());
                        produceInfo.setPeriodNumber(period.getNumber());
                    }
                }
                produceInfo.setErrInfo(ex.getMessage());
                produceInfo.setSuccess(false);
            }
            if (!produceInfo.isSuccess() && (produceInfo.getErrInfo() == null || produceInfo.getErrInfo().equals(""))) {
                produceInfo.setErrInfo("unKnownErrProduceVoucher");
            }
            long endTime = System.currentTimeMillis();
            produceInfo.setEndTime(formatter.format(new Date()));
            produceInfo.setUseTime(endTime - startTime);
            produceInfos.add(produceInfo);
        }
        result.put("error", produceInfos);
        return result;
    }

    @Override
    protected Map _generateVoucher(Context ctx, AdjustExchangeRateInfo adjRateInfo, boolean isSaveVoucher, Map paramMap) throws BOSException, EASBizException {
        AdjustExchangeRateGenVchService service = new AdjustExchangeRateGenVchService(ctx, adjRateInfo, isSaveVoucher, paramMap);
        return service.generateVoucher();
    }

    @Override
    protected void _saveAdjHistory(Context ctx, String voucherID, String companyID, AdjExchRateHistoryCollection adjHisColl) throws BOSException, EASBizException {
        if (adjHisColl == null) {
            return;
        }
        SelectorItemCollection sic = GlUtils.getCompanySic();
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, companyID, sic, true);
        String curCompanyID = company.getId().toString();
        PeriodInfo period = GlUtils.getCurrentPeriod(ctx, curCompanyID);
        String curPeriodID = period.getId().toString();
        Connection con = null;
        PreparedStatement stmt = null;
        StringBuffer sql = new StringBuffer();
        int index = 0;
        try {
            con = this.getConnection(ctx);
            sql = new StringBuffer();
            sql.append("Delete From t_gl_AdjExchRateHistory                                                   \r\n");
            sql.append("Where FCompanyID = ?\t                                                             \r\n");
            sql.append("\tand FPeriodID = ?                                                                 \r\n");
            sql.append("\tand FAdjExchRateType = ?   and FVoucherId not in ( select fid from t_gl_voucher where FCompanyID=? and FPeriodID=? and FBizStatus<>2 )                                                              \r\n");
            sql.append("; \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curPeriodID);
            stmt.setInt(index++, 1);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curPeriodID);
            stmt.executeUpdate();
            IAdjExchRateHistory adjCtrl = AdjExchRateHistoryFactory.getLocalInstance(ctx);
            for (int i = 0; i < adjHisColl.size(); ++i) {
                AdjExchRateHistoryInfo adjInfo = adjHisColl.get(i);
                if (voucherID != null && voucherID.length() > 0) {
                    VoucherInfo voucher = new VoucherInfo();
                    voucher.setId(BOSUuid.read((String)voucherID));
                    adjInfo.setVoucher(voucher);
                }
                adjCtrl.addnew((CoreBaseInfo)adjInfo);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    @Override
    protected Map _fetchInitData(Context ctx, String currentCompanyID, Set locCurIDSet, Set rptCurIDSet) throws BOSException {
        ctx.put((Object)"currCompanyID", (Object)currentCompanyID);
        ctx.put((Object)"locCurIDSet", (Object)locCurIDSet);
        ctx.put((Object)"rptCurIDSet", (Object)rptCurIDSet);
        HashMap result = null;
        try {
            result = GLPeriodEndFacadeFactory.getLocalInstance(ctx).getAdjExchRate();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected void _updateHistoryRecord(Context ctx, Set companyIdSet) throws BOSException, EASBizException {
        String companyID2 = null;
        for (String companyID2 : companyIdSet) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("_LocCur.id"));
            sic.add(new SelectorItemInfo("_LocCur.currencyID"));
            sic.add(new SelectorItemInfo("_RptCur.id"));
            sic.add(new SelectorItemInfo("_RptCur.currencyID"));
            FilterInfo ficCF = new FilterInfo();
            view.setFilter(ficCF);
            ficCF.getFilterItems().add(new FilterItemInfo("FICompany.id", (Object)companyID2));
            ficCF.getFilterItems().add(new FilterItemInfo("isAllCurChoose", (Object)true));
            AdjustExchangeRateCollection conllection = AdjustExchangeRateFactory.getLocalInstance(ctx).getAdjustExchangeRateCollection(view);
            if (conllection.size() == 0) continue;
            AdjustExchangeRateInfo adjustExchangeRate = conllection.get(0);
            HashMap adjExchRate = GLPeriodEndFacadeFactory.getLocalInstance(ctx).getAdjExchRate(companyID2);
            Object aerl = null;
            boolean isContainded = false;
            AdjustExchangeRate_LocCurCollection locCurCollection = adjustExchangeRate.get_LocCur();
            AdjustExchangeRate_LocCurInfo adjustExchangeRate_LocCur = null;
            HashMap localAdjust = (HashMap)adjExchRate.get("LocalAdjust");
            ArrayList<String> isNotisContaindedCurrency_local = new ArrayList<String>();
            Iterator local = localAdjust.entrySet().iterator();
            int seq = 1;
            while (local.hasNext()) {
                Map.Entry entry = local.next();
                String currencyID = (String)entry.getKey();
                int size = locCurCollection.size();
                for (int i = 0; i < size; ++i) {
                    adjustExchangeRate_LocCur = locCurCollection.get(i);
                    if (!adjustExchangeRate_LocCur.getCurrencyID().equals(currencyID)) continue;
                    isContainded = true;
                    ++seq;
                    break;
                }
                if (!isContainded) {
                    isNotisContaindedCurrency_local.add(currencyID);
                    isContainded = false;
                    continue;
                }
                isContainded = false;
            }
            if (isNotisContaindedCurrency_local.size() != 0) {
                int size = isNotisContaindedCurrency_local.size();
                for (int i = 0; i < size; ++i) {
                    adjustExchangeRate_LocCur = new AdjustExchangeRate_LocCurInfo();
                    adjustExchangeRate_LocCur.setParent(adjustExchangeRate);
                    adjustExchangeRate_LocCur.setCurrencyID((String)isNotisContaindedCurrency_local.get(i));
                    adjustExchangeRate_LocCur.setSeq(seq++);
                    AdjustExchangeRate_LocCurFactory.getLocalInstance(ctx).addnew(adjustExchangeRate_LocCur);
                }
            }
            seq = 1;
            AdjustExchangeRate_RptCurCollection rptCurCollection = adjustExchangeRate.get_RptCur();
            AdjustExchangeRate_RptCurInfo adjustExchangeRate_RptCur = null;
            HashMap rptCurAdjust = (HashMap)adjExchRate.get("RptAdjust");
            ArrayList<String> isNotisContaindedCurrency_rptCur = new ArrayList<String>();
            for (Map.Entry entry : rptCurAdjust.entrySet()) {
                String currencyID = (String)entry.getKey();
                int size = rptCurCollection.size();
                for (int i = 0; i < size; ++i) {
                    adjustExchangeRate_RptCur = rptCurCollection.get(i);
                    if (!adjustExchangeRate_RptCur.getCurrencyID().equals(currencyID)) continue;
                    isContainded = true;
                    ++seq;
                    break;
                }
                if (!isContainded) {
                    isNotisContaindedCurrency_rptCur.add(currencyID);
                    isContainded = false;
                    continue;
                }
                isContainded = false;
            }
            if (isNotisContaindedCurrency_rptCur.size() == 0) continue;
            int size = isNotisContaindedCurrency_rptCur.size();
            for (int i = 0; i < size; ++i) {
                adjustExchangeRate_RptCur = new AdjustExchangeRate_RptCurInfo();
                adjustExchangeRate_RptCur.setParent(adjustExchangeRate);
                adjustExchangeRate_RptCur.setCurrencyID((String)isNotisContaindedCurrency_rptCur.get(i));
                adjustExchangeRate_RptCur.setSeq(seq++);
                AdjustExchangeRate_RptCurFactory.getLocalInstance(ctx).addnew(adjustExchangeRate_RptCur);
            }
        }
    }

    @Override
    protected void _updateUseStates(Context ctx, Set idSet, int state) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        String id = null;
        String sql = "UPDATE T_GL_ADJUSTEXCHANGERATE SET FISUSING = ? WHERE FID = ?";
        while (it.hasNext()) {
            id = (String)it.next();
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{state, id});
        }
    }
}

