/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.ApplyAccountBillFactory;
import com.kingdee.eas.fi.gl.ApplyAccountBillInfo;
import com.kingdee.eas.fi.gl.ApplyAccountBillStatus;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractApplyAccountBillControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ApplyAccountBillControllerBean
extends AbstractApplyAccountBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.ApplyAccountBillControllerBean");

    @Override
    protected void _actionSummit(Context ctx, ArrayList idList) throws BOSException, EASBizException {
    }

    @Override
    protected void _batchAuditBill(Context ctx, ArrayList idList) throws BOSException, EASBizException {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        BillImageFacadeFactory.getRemoteInstance().getImageNumber(this.getBOSType().toString(), pk.toString());
        return pk;
    }

    @Override
    protected IRowSet _getRowSet(Context ctx, String queryName, Set idSet) throws BOSException {
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK(queryName);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(fi);
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        return rows;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        ApplyAccountBillInfo bill = this.getApplyAccountBillInfo(ctx, pk);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)bill.getBOSType(), (IObjectPK)new ObjectUuidPK(bill.getId().toString()), (String)(EASResource.getString((String)"com.kingdee.eas.fi.gl.ApplyAccountBill", (String)"applyAccountBillDelete") + bill.getId().toString()), (String)bill.getId().toString());
        if (bill.getBillstatus() == ApplyAccountBillStatus.AUDITING) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gl.ApplyAccountBill", (String)"bill_is_working")));
        }
        if (bill.getBillstatus() == ApplyAccountBillStatus.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gl.ApplyAccountBill", (String)"voucher_audited")));
        }
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected boolean _auditBill(Context ctx, IObjectPK pk, BOSUuid auditorId) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _auditFail(Context ctx, IObjectPK pk, BOSUuid auditorId) throws BOSException, EASBizException {
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        int size = sourceBillCollection.size();
        for (int i = 0; i < size; ++i) {
            String billId = ((ApplyAccountBillInfo)sourceBillCollection.getObject(i)).getId().toString();
            ApplyAccountBillInfo applyAccountBillInfo = ApplyAccountBillFactory.getRemoteInstance().getApplyAccountBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billId)));
            if (applyAccountBillInfo.getBillstatus() == ApplyAccountBillStatus.AUDITED) continue;
            throw new EASBizException(new NumericExceptionSubItem("14", EASResource.getString((String)"com.kingdee.eas.fi.gl.ApplyAccountBill", (String)"auto_voucher_is_not_audited")));
        }
        try {
            DAPTransformResult dapTransformResult = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
            int size2 = sourceBillCollection.size();
            for (int i = 0; i < size2; ++i) {
                String billId = ((ApplyAccountBillInfo)sourceBillCollection.getObject(i)).getId().toString();
                ApplyAccountBillInfo applyAccountBillInfo = ApplyAccountBillFactory.getRemoteInstance().getApplyAccountBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billId)));
                applyAccountBillInfo.setFiVouchered(true);
                ObjectUuidPK pk = new ObjectUuidPK(billId);
                this._update(ctx, (IObjectPK)pk, (IObjectValue)applyAccountBillInfo);
            }
            return dapTransformResult;
        }
        catch (Exception e) {
            throw new BOSException(e.getCause());
        }
    }

    @Override
    protected void _setApproveState(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateState(ctx, pk, ApplyAccountBillStatus.AUDITING);
    }

    @Override
    protected void _setAuditFailState(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateState(ctx, pk, ApplyAccountBillStatus.AUDITFAIL);
    }

    @Override
    protected void _setAuditedState(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateState(ctx, pk, ApplyAccountBillStatus.AUDITED);
    }

    private void updateState(Context ctx, IObjectPK pk, ApplyAccountBillStatus state) throws EASBizException, BOSException {
        ApplyAccountBillInfo bill;
        if (pk != null && this._exists(ctx, pk)) {
            bill = this.getApplyAccountBillInfo(ctx, pk);
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
            bill.setAuditor(user);
            if (state != null) {
                bill.setBillstatus(state);
            }
        } else {
            throw new EASBizException(VoucherException.VOUCHER_NOT_EXIST);
        }
        this._update(ctx, pk, (IObjectValue)bill);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        logger.log(Priority.INFO, (Object)"_reverseSave_start");
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo((Context)ctx, (IObjectValue)bOTRelationInfo);
        ObjectUuidPK pk = new ObjectUuidPK(srcBillVO.get("id").toString());
        ApplyAccountBillInfo bill = this.getApplyAccountBillInfo(ctx, (IObjectPK)pk);
        if (voucher != null && voucher.getId() != null) {
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
                bill.setFiVouchered(true);
                bill.setVouchernumber(voucher.getNumber());
            } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.EDIT) {
                bill.setFiVouchered(true);
                bill.setVouchernumber(voucher.getNumber());
            }
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
        if (new VoucherInfo().getBOSType().toString().equals(bOTRelationInfo.get("destentityid")) && bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
            bill.setFiVouchered(false);
            bill.setVouchernumber(null);
        }
        this._update(ctx, (IObjectPK)pk, (IObjectValue)bill);
        logger.log(Priority.INFO, (Object)"_reverseSave_start");
    }
}

