/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ApplyAccountBillStatus;
import com.kingdee.eas.fi.gl.app.AbstractApplyAccountBillFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.log4j.Logger;

public class ApplyAccountBillFacadeControllerBean
extends AbstractApplyAccountBillFacadeControllerBean {
    private static final long serialVersionUID = 3388846952415639069L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.ApplyAccountBillFacadeControllerBean");

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        this.setBillState(ctx, billId, auditorId, ApplyAccountBillStatus.AUDITING);
    }

    @Override
    protected void _setAuditedState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        this.setBillState(ctx, billId, auditorId, ApplyAccountBillStatus.AUDITED);
    }

    @Override
    protected void _setSubmitState(Context ctx, BOSUuid billId, BOSUuid approverId) throws BOSException, EASBizException {
        this.setBillState(ctx, billId, approverId, ApplyAccountBillStatus.SUBMITED);
    }

    @Override
    protected void _setAuditFailState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        this.setBillState(ctx, billId, auditorId, ApplyAccountBillStatus.AUDITFAIL);
    }

    private void setBillState(Context ctx, BOSUuid billId, BOSUuid auditorId, ApplyAccountBillStatus status) throws EASBizException, BOSException {
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String userId = ctx.getCaller().toString();
        if (auditorId != null) {
            userId = auditorId.toString();
        }
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        boolean isCheck = false;
        sql.append("update ");
        sql.append(table);
        sql.append(" set FBillstatus=?");
        if (ApplyAccountBillStatus.AUDITED.equals((Object)status) || ApplyAccountBillStatus.AUDITFAIL.equals((Object)status) || ApplyAccountBillStatus.AUDITING.equals((Object)status)) {
            sql.append(", FAuditorID=?");
            sql.append(" ,FAuditDate=?");
        }
        sql.append(" ,FLastUpdateTime=?");
        sql.append(" where FID=?");
        String sql_state = sql.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        int index = 0;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql_state);
            stmt.setObject(++index, status.getValue());
            if (isCheck) {
                stmt.setString(++index, userId);
                stmt.setDate(++index, new Date(System.currentTimeMillis()));
            }
            stmt.setDate(++index, new Date(System.currentTimeMillis()));
            stmt.setString(++index, billId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    public void _batchUpdateAttachments(Context ctx, Set idSet) {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder("update T_GL_ApplyAccountBill t set FAttachments = (select COUNT(FID) from T_BAS_BoAttchAsso baa where t.FID = baa.FBoID) where t.FID in (");
        Object[] ids = new String[idSet.size()];
        int i = 0;
        for (Object s : idSet) {
            ids[i++] = (String)s;
            sql.append("?,");
        }
        sql.replace(sql.length() - 1, sql.length(), ")");
        try {
            DbUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])ids);
        }
        catch (SQLException e) {
            logger.error((Object)"update applyAccountBill's attachments fail:", (Throwable)e);
        }
    }
}

