/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.app.AbstractAssistCustomizedPropertyControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AssistCustomizedPropertyControllerBean
extends AbstractAssistCustomizedPropertyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.AssistCustomizedPropertyControllerBean");

    @Override
    public void _deleteByAccount(Context ctx, IObjectValue account) throws BOSException, EASBizException {
        this.checkAccountUsed(ctx, account);
        String sql = "delete from T_GL_AssistCustomizedProperty where faccountid=?";
        String accountid = account.get("id").toString();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{accountid});
        this._updateAccount(ctx, accountid, false);
        this.deleteVoucherAssistRecord(ctx, accountid);
    }

    private void deleteVoucherAssistRecord(Context ctx, String accountid) throws BOSException {
    }

    @Override
    public void _saveCollection(Context ctx, IObjectCollection props) throws BOSException, EASBizException {
        AssistCustomizedPropertyCollection col = (AssistCustomizedPropertyCollection)props;
        if (props.size() == 0) {
            return;
        }
        AssistCustomizedPropertyInfo info = (AssistCustomizedPropertyInfo)props.getObject(0);
        String accountID = info.getAccount().getId().toString();
        if (this.isNeedCheckAccountUsed(ctx, accountID, col)) {
            this.checkAccountUsed(ctx, (IObjectValue)info.getAccount());
        }
        Iterator iter = col.iterator();
        ArrayList<String> accountid = new ArrayList<String>();
        HashSet<String> needUpdateAcctIds = new HashSet<String>();
        while (iter.hasNext()) {
            info = (AssistCustomizedPropertyInfo)iter.next();
            needUpdateAcctIds.add(info.getAccount().getId().toString());
            if ("new".equals(info.get("persist_status"))) {
                super.addnew(ctx, (CoreBaseInfo)info);
                if (accountid.contains(info.getAccount().getId().toString())) continue;
                accountid.add(info.getAccount().getId().toString());
                continue;
            }
            if ("deleted".equals(info.get("persist_status"))) {
                super.delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
                continue;
            }
            super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
        if (accountid.size() > 0) {
            int count = accountid.size();
            for (int i = 0; i < count; ++i) {
                this._updateAccount(ctx, (String)accountid.get(i), true);
                this.addVoucherAssistRecord(ctx, (String)accountid.get(i));
            }
        }
        String sqlSet = "update t_bd_accountview set fhasuserproperty=1 where exists(select 1 from T_GL_AssistCustomizedProperty a where a.FACCOUNTID=t_bd_accountview.fid and a.FDELETEDSTATUS=1)and fid=?";
        Iterator itUpdate = needUpdateAcctIds.iterator();
        while (itUpdate.hasNext()) {
            String acctId = String.valueOf(itUpdate.next());
            DbUtil.execute((Context)ctx, (String)sqlSet, (Object[])new Object[]{acctId});
            ORMValueCacheService.getInstance().remove(ctx, new AccountViewInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(acctId));
        }
    }

    private void addVoucherAssistRecord(Context ctx, String accountid) throws BOSException {
        if (!this.isHasBizData(ctx, accountid)) {
            this.insertVoucherAssistRecord(ctx, accountid);
        }
    }

    private boolean isHasBizData(Context ctx, String accountid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 va.fid \r\n");
        sql.append(" from T_gl_voucherassistrecord va \r\n");
        sql.append(" where va.fentryid in  \r\n");
        sql.append(" (select fid from t_gl_voucherentry where faccountid = ?) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountid});
        try {
            if (rowSet != null && rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"sql error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void checkAccountUsed(Context ctx, IObjectValue account) throws BOSException, EASBizException {
        String sql = "select b.fmappingfieldname from t_gl_assistcustomizedproperty a inner join t_gl_assistcustomizedtype  b on a.fcustomizedtypeid=b.fid where faccountid=? ";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String id = account.get("id").toString();
        String name = account.toString();
        try {
            String sql1 = "select top 1 a.fid from t_gl_acctcussent a inner join t_gl_voucherassistrecord b on a.fvchassistrecordid=b.fid where a.faccountid=? and b.";
            String sql2 = "select top 1 a.fid from t_gl_voucherentry a inner join t_gl_voucherassistrecord b on a.fid=b.fentryid where a.faccountid=? and b.";
            String isNotNull = " is not null";
            String isBetween = " in (1,2,3,4,5,6,7,8,9,10)";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
            if (rowSet == null) {
                return;
            }
            con = this.getConnection(ctx);
            while (rowSet.next()) {
                String fmappingfieldname = rowSet.getString("fmappingfieldname");
                if ("FBizNumberID".equalsIgnoreCase(fmappingfieldname)) {
                    fmappingfieldname = "FBizNumber";
                }
                ps = "FFeeType".equalsIgnoreCase(rowSet.getString("fmappingfieldname")) ? con.prepareStatement(sql1 + fmappingfieldname + isBetween) : con.prepareStatement(sql1 + fmappingfieldname + isNotNull);
                ps.setString(1, id);
                rs = ps.executeQuery();
                if (rs.next()) {
                    throw new GLException(GLException.CANTMODIFYCUSTOMPROPERTY, new Object[]{name});
                }
                ps = "FFeeType".equalsIgnoreCase(rowSet.getString("fmappingfieldname")) ? con.prepareStatement(sql2 + fmappingfieldname + isBetween) : con.prepareStatement(sql2 + fmappingfieldname + isNotNull);
                ps.setString(1, id);
                rs = ps.executeQuery();
                if (!rs.next()) continue;
                throw new GLException(GLException.CANTMODIFYCUSTOMPROPERTY, new Object[]{name});
            }
            SQLUtils.cleanup(rs, ps, (Connection)con);
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup(rs, ps, con);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AssistCustomizedPropertyInfo info = (AssistCustomizedPropertyInfo)super._getValue(ctx, pk);
        AccountViewInfo accountInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getAccount().getId()));
        if (accountInfo != null && accountInfo.getName() != null) {
            return accountInfo.getName();
        }
        return "";
    }

    @Override
    protected void _doApprove(Context ctx, String id, DeletedStatusEnum isApprove) throws BOSException {
        String sql = "update T_GL_AssistCustomizedProperty set FDeletedStatus=? where fid=?";
        PreparedStatement ps = null;
        Connection con = this.getConnection(ctx);
        try {
            ps = con.prepareStatement(sql);
            ps.setInt(1, isApprove.getValue());
            ps.setString(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)con);
        }
    }

    @Override
    protected void _updateAccount(Context ctx, String accountId, boolean isApprove) throws BOSException {
        String sql = "update t_BD_AccountView set fhasuserproperty=? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{isApprove, accountId});
        ORMValueCacheService.getInstance().remove(ctx, new AccountViewInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(accountId));
    }

    @Override
    protected void _dealAssistRecordAndAccount(Context ctx, String accountId, boolean isApprove) throws BOSException {
        if (isApprove) {
            this.addVoucherAssistRecord(ctx, accountId);
        } else {
            this.deleteVoucherAssistRecord(ctx, accountId);
        }
        this._updateAccount(ctx, accountId, isApprove);
    }

    private void insertVoucherAssistRecord(Context ctx, String accountId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_gl_voucherassistrecord \r\n");
        sql.append(" (fid,fentryid,fseq,fbillid,fcompanyid,fperiodid,faccountid,fbizdate,fdescription,flocalamount");
        sql.append(" ,foriginalamount,freportingamount,fquantity,fstandardquantity,fenddate )\r\n");
        sql.append(" select newbosid('0FFFBCAA'),ve.fid,1,vch.fid,vch.fcompanyid,vch.fperiodid,ve.faccountid,vch.fbizdate,ve.fdescription,ve.flocalamount,");
        sql.append(" ve.foriginalamount,ve.freportingamount,ve.fquantity,ve.fstandardquantity,vch.fbizdate \r\n");
        sql.append(" from t_gl_voucherentry ve \r\n");
        sql.append(" inner join t_gl_voucher vch on vch.fid = ve.fbillid \r\n");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid \r\n");
        sql.append(" where av.fid = ? and av.fcaa is null ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountId});
    }

    private boolean isNeedCheckAccountUsed(Context ctx, String accountid, AssistCustomizedPropertyCollection acpc) throws BOSException {
        boolean isUsed = false;
        ArrayList<String> ids = new ArrayList<String>();
        Iterator it = acpc.iterator();
        while (it.hasNext()) {
            AssistCustomizedPropertyInfo info = (AssistCustomizedPropertyInfo)it.next();
            if ("deleted".equals(info.get("persist_status"))) continue;
            ids.add(info.getCustomizedType().getId().toString());
        }
        String sql = "select fcustomizedtypeid fid from t_gl_assistcustomizedproperty acp where faccountid = ?";
        Connection con = null;
        PreparedStatement stm = null;
        try {
            con = this.getConnection(ctx);
            stm = con.prepareStatement(sql);
            stm.setString(1, accountid);
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                if (ids.contains(rs.getString("fid"))) continue;
                isUsed = true;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stm, (Connection)con);
        return isUsed;
    }
}

