/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentCollection;
import com.kingdee.eas.fi.gl.AcctCussentFactory;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.AcctCussentInitFacadeFactory;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLFlagInfo;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.IAcctCussentInitFacade;
import com.kingdee.eas.fi.gl.IGLBalanceFacade;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.IInitAssistBalance;
import com.kingdee.eas.fi.gl.InitAssistBalanceCollection;
import com.kingdee.eas.fi.gl.InitAssistBalanceFactory;
import com.kingdee.eas.fi.gl.InitAssistBalanceInfo;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.app.AbstractAssistInitFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AssistInitFacadeControllerBean
extends AbstractAssistInitFacadeControllerBean {
    private static final long serialVersionUID = 6056533846399416626L;
    private static final String GL_RESOURCE = "com.kingdee.eas.fi.gl.GLResource";
    private Map asstActInfoClasses = new HashMap();

    private IObjectCollection getSomeAssistInitData(Context ctx, IObjectCollection accounts, AsstActTypeCollection tcol, String currencyId, String orgUnitId, String accounttable, boolean getAssgrp) throws BOSException {
        if (accounts == null) {
            return null;
        }
        InitAssistBalanceCollection col = new InitAssistBalanceCollection();
        if (accounts.size() == 0) {
            return col;
        }
        ArrayList<String> disList = new ArrayList<String>();
        SelectorItemCollection selector = new SelectorItemCollection();
        if (tcol != null) {
            for (int i = 0; i < tcol.size(); ++i) {
                String asstHGAttribute = tcol.get(i).getAsstHGAttribute();
                selector.add(new SelectorItemInfo(asstHGAttribute + ".id"));
                disList.add(asstHGAttribute);
            }
        }
        CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
        org.setId(BOSUuid.read((String)orgUnitId));
        CurrencyInfo currency = new CurrencyInfo();
        String loc = ctx.getLocale().getLanguage();
        String selectSql = null;
        Object[] objs = null;
        if (currencyId != null) {
            currency.setId(BOSUuid.read((String)currencyId));
            selectSql = "select asst.*,m.fname_" + loc + " as fmeasureunitname,m.fcoefficient from t_gl_initassistbalance asst inner join t_bd_accountview account on account.fid = asst.faccountid left join t_bd_measureunit m on asst.fmeasureunitid=m.fid left join t_bd_assistanthg hg on asst.fassistgrpid = hg.fid where asst.forgunitid=? and asst.fcurrencyid=? and asst.faccountid in " + this.getAccountListString(accounts);
            selectSql = selectSql + " order by account.flongnumber,hg.fdisplaynamegroup_" + loc;
            objs = new Object[]{orgUnitId, currencyId};
        } else {
            selectSql = "select asst.*,m.fname_" + loc + " as fmeasureunitname,m.fcoefficient from t_gl_initassistbalance asst inner join t_bd_accountview account on account.fid = asst.faccountid left join t_bd_measureunit m on asst.fmeasureunitid=m.fid left join t_bd_assistanthg hg on asst.fassistgrpid = hg.fid where asst.forgunitid=?  and asst.faccountid in " + this.getAccountListString(accounts);
            selectSql = selectSql + " order by account.flongnumber,hg.fdisplaynamegroup_" + loc;
            objs = new Object[]{orgUnitId};
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])objs);
        if (rs != null) {
            try {
                AssistantHGCollection hgColl = new AssistantHGCollection();
                if (getAssgrp) {
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection sic = view.getSelector();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    for (int i = 0; i < disList.size(); ++i) {
                        String key = (String)disList.get(i);
                        sic.add(new SelectorItemInfo(key + ".id"));
                        sic.add(new SelectorItemInfo(key + ".number"));
                        sic.add(new SelectorItemInfo(key + ".name"));
                        sic.add(new SelectorItemInfo(key + ".displayName"));
                        String sql = "select frealtiondataobject,fassthgattribute,fgrouptablename,fgroupMappingFieldName,fismultilevel from t_bd_asstacttype where fassthgattribute=? ";
                        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{key});
                        if (rowset == null || !rowset.next()) continue;
                        String mappingFieldName = rowset.getString("fassthgattribute");
                        String fgrouptablename = rowset.getString("fgrouptablename");
                        int fismultilevel = rowset.getInt("fismultilevel");
                        if (fismultilevel == 0) {
                            if (!"bankAccount".equalsIgnoreCase(mappingFieldName)) continue;
                            sic.add(new SelectorItemInfo(key + ".isByCurrency"));
                            continue;
                        }
                        if (mappingFieldName.toLowerCase().startsWith("generalassacttype")) {
                            sic.add(new SelectorItemInfo(key + ".longnumber"));
                            continue;
                        }
                        if (fgrouptablename != null) {
                            if ("customer".equalsIgnoreCase(mappingFieldName) || "provider".equalsIgnoreCase(mappingFieldName)) {
                                sic.add(new SelectorItemInfo(key + ".browseGroup.id"));
                                sic.add(new SelectorItemInfo(key + ".browseGroup.name"));
                                sic.add(new SelectorItemInfo(key + ".browseGroup.displayName"));
                                sic.add(new SelectorItemInfo(key + ".browseGroup.number"));
                                sic.add(new SelectorItemInfo(key + ".browseGroup.longnumber"));
                                continue;
                            }
                            if (!"material".equalsIgnoreCase(mappingFieldName)) continue;
                            sic.add(new SelectorItemInfo(key + ".materialGroup.id"));
                            sic.add(new SelectorItemInfo(key + ".materialGroup.name"));
                            sic.add(new SelectorItemInfo(key + ".materialGroup.displayName"));
                            sic.add(new SelectorItemInfo(key + ".materialGroup.number"));
                            sic.add(new SelectorItemInfo(key + ".materialGroup.longnumber"));
                            continue;
                        }
                        if (mappingFieldName.equals("saleOrg") || mappingFieldName.equals("profitOrg") || mappingFieldName.equals("purchaseOrg") || mappingFieldName.equals("storeageOrg") || mappingFieldName.equals("companyOrg") || mappingFieldName.equals("costOrg")) {
                            sic.add(new SelectorItemInfo(key + ".longnumber"));
                            sic.add(new SelectorItemInfo(key + ".isBizUnit"));
                            sic.add(new SelectorItemInfo(key + ".isLeaf"));
                            continue;
                        }
                        if (mappingFieldName == null || mappingFieldName.toLowerCase().indexOf("generalassacttype") == -1) continue;
                        sic.add(new SelectorItemInfo(key + ".longnumber"));
                    }
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    HashSet<String> hgIdSet = new HashSet<String>();
                    while (rs.next()) {
                        String fassgrpid;
                        if (!getAssgrp || (fassgrpid = rs.getString("fassistgrpid")) == null || fassgrpid.trim().length() == 0) continue;
                        for (int i = 0; i < disList.size(); ++i) {
                            hgIdSet.add(fassgrpid);
                        }
                    }
                    if (hgIdSet.size() > 0) {
                        filter.getFilterItems().add(new FilterItemInfo("id", hgIdSet, CompareType.INCLUDE));
                        hgColl = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGCollection(view);
                    }
                }
                rs.beforeFirst();
                while (rs.next()) {
                    InitAssistBalanceInfo data = new InitAssistBalanceInfo();
                    data.setBeginBalanceFor(rs.getBigDecimal("fbeginbalancefor"));
                    data.setBeginBalanceLocal(rs.getBigDecimal("fbeginbalancelocal"));
                    data.setBeginBalanceRpt(rs.getBigDecimal("fbeginbalancerpt"));
                    data.setBeginQty(rs.getBigDecimal("fbeginqty"));
                    data.setEndBalanceFor(rs.getBigDecimal("fendbalancefor"));
                    data.setEndBalanceLocal(rs.getBigDecimal("fendbalancelocal"));
                    data.setEndBalanceRpt(rs.getBigDecimal("fendbalancerpt"));
                    data.setEndQty(rs.getBigDecimal("fendqty"));
                    data.setYearCreditFor(rs.getBigDecimal("fyearcreditfor"));
                    data.setYearCreditLocal(rs.getBigDecimal("fyearcreditlocal"));
                    data.setYearCreditQty(rs.getBigDecimal("fyearcreditqty"));
                    data.setYearCreditRpt(rs.getBigDecimal("fyearcreditrpt"));
                    data.setYearDebitFor(rs.getBigDecimal("fyeardebitfor"));
                    data.setYearDebitLocal(rs.getBigDecimal("fyeardebitlocal"));
                    data.setYearDebitQty(rs.getBigDecimal("fyeardebitqty"));
                    data.setYearDebitRpt(rs.getBigDecimal("fyeardebitrpt"));
                    data.setYearPnLFor(rs.getBigDecimal("fyearpnlfor"));
                    data.setYearPnLLocal(rs.getBigDecimal("fyearpnllocal"));
                    data.setYearPnLRpt(rs.getBigDecimal("fyearpnlrpt"));
                    data.setCreditFor(rs.getBigDecimal("fcreditfor"));
                    data.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
                    data.setCreditQty(rs.getBigDecimal("fcreditqty"));
                    data.setCreditRpt(rs.getBigDecimal("fcreditrpt"));
                    data.setDebitFor(rs.getBigDecimal("fdebitfor"));
                    data.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
                    data.setDebitQty(rs.getBigDecimal("fdebitqty"));
                    data.setDebitRpt(rs.getBigDecimal("fdebitrpt"));
                    data.setAccount((AccountViewInfo)accounts.getObject((Object)BOSUuid.read((String)rs.getString("faccountid"))));
                    data.setOrgUnit(org);
                    currency = new CurrencyInfo();
                    currency.setId(BOSUuid.read((String)rs.getString("FCurrencyID")));
                    data.setCurrency(currency);
                    if (rs.getString("fmeasureunitid") != null) {
                        MeasureUnitInfo unit = new MeasureUnitInfo();
                        unit.setId(BOSUuid.read((String)rs.getString("fmeasureunitid")));
                        unit.setName(rs.getString("fmeasureunitname"));
                        unit.setCoefficient(rs.getBigDecimal("fcoefficient"));
                        data.setMesureUnit(unit);
                    }
                    data.setStabdardYearDebitQty(rs.getBigDecimal("fstandardyeardebitqty"));
                    data.setStabdardYearCreditQty(rs.getBigDecimal("fstandardyearcreditqty"));
                    data.setStabdardBeginQty(rs.getBigDecimal("fstandardbeginqty"));
                    String fassgrpid = rs.getString("fassistgrpid");
                    AssistantHGInfo item = new AssistantHGInfo();
                    item.setId(BOSUuid.read((String)fassgrpid));
                    if (getAssgrp) {
                        AssistantHGInfo hgInfo = new AssistantHGInfo();
                        hgInfo.setId(BOSUuid.read((String)fassgrpid));
                        for (int i = 0; i < hgColl.size(); ++i) {
                            String name;
                            if (!hgColl.get(i).getId().toString().equals(fassgrpid)) continue;
                            hgInfo = hgColl.get(i);
                            if (hgInfo.getCustomer() != null) {
                                name = hgInfo.getCustomer().getBrowseGroup() == null ? hgInfo.getCustomer().getName() : hgInfo.getCustomer().getBrowseGroup().getDisplayName() + "_" + hgInfo.getCustomer().getName();
                                hgInfo.getCustomer().put("displayName", (Object)name);
                                break;
                            }
                            if (hgInfo.getProvider() != null) {
                                name = hgInfo.getProvider().getBrowseGroup() == null ? hgInfo.getProvider().getName() : hgInfo.getProvider().getBrowseGroup().getDisplayName() + "_" + hgInfo.getProvider().getName();
                                hgInfo.getProvider().put("displayName", (Object)name);
                                break;
                            }
                            if (hgInfo.getMaterial() == null) break;
                            name = hgInfo.getMaterial().getMaterialGroup() == null ? hgInfo.getMaterial().getName() : hgInfo.getMaterial().getMaterialGroup().getDisplayName() + "_" + hgInfo.getMaterial().getName();
                            hgInfo.getMaterial().put("displayName", (Object)name);
                            break;
                        }
                        data.setAssistGrp(hgInfo);
                    } else {
                        data.setAssistGrp(item);
                    }
                    col.add(data);
                }
            }
            catch (SQLException e) {
                new BOSException((Throwable)e);
            }
        }
        return col;
    }

    private DataBaseInfo getInfoInstance(String key) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Class<?> keyInfoClass = (Class<?>)this.asstActInfoClasses.get(key);
        if (this.asstActInfoClasses.get(key) == null) {
            String property = key.substring(0, 1).toUpperCase().concat(key.substring(1));
            Method method = AssistantHGInfo.class.getMethod("get" + property, new Class[]{null});
            keyInfoClass = method.getReturnType();
            this.asstActInfoClasses.put(key, keyInfoClass);
        }
        return (DataBaseInfo)keyInfoClass.newInstance();
    }

    private AssistantHGInfo constructHGInfo(Context ctx, IRowSet rs, AssistantHGInfo hgInfo, AsstActTypeCollection actColl) throws BOSException, SQLException {
        if (actColl == null) {
            return hgInfo;
        }
        for (int i = 0; i < actColl.size(); ++i) {
            AsstActTypeInfo aatInfo = actColl.get(i);
            String key = aatInfo.getAsstHGAttribute();
            DataBaseInfo baseInfo = null;
            try {
                baseInfo = this.getInfoInstance(key);
                baseInfo.setId(BOSUuid.read((String)rs.getString(key + "_fid")));
                baseInfo.setName(rs.getString(key + "_fname"));
                baseInfo.setNumber(rs.getString(key + "_fnumber"));
                hgInfo.put(key, (Object)baseInfo);
                if (!aatInfo.isIsMultilevel()) {
                    if ("bankAccount".equalsIgnoreCase(key)) {
                        baseInfo.setBoolean("isByCurrency", rs.getBoolean(key + "_FIsByCurrency"));
                    }
                } else if (key.toLowerCase().startsWith("generalassacttype")) {
                    baseInfo.setString("displayName", rs.getString(key + "_dspname"));
                    baseInfo.setString("longNumber", rs.getString(key + "_Lnum"));
                } else if (aatInfo.getGroupTableName() != null) {
                    String browseGroupID;
                    CSSPGroupInfo gpInfo;
                    if ("customer".equalsIgnoreCase(key)) {
                        gpInfo = new CSSPGroupInfo();
                        browseGroupID = rs.getString("browseGroup1_Fid");
                        if (browseGroupID != null) {
                            gpInfo.setId(BOSUuid.read((String)browseGroupID));
                            gpInfo.setName(rs.getString("browseGroup1_fname"));
                            gpInfo.setDisplayName(rs.getString("browseGroup1_fdisplayName"));
                            gpInfo.setNumber(rs.getString("browseGroup1_Fnumber"));
                            gpInfo.setLongNumber(rs.getString("browseGroup1_Lnum"));
                            baseInfo.put("browseGroup", (Object)gpInfo);
                            baseInfo.put("displayName", (Object)(gpInfo.getDisplayName() + "_" + baseInfo.getName()));
                        } else {
                            baseInfo.put("displayName", (Object)baseInfo.getName());
                        }
                    } else if ("provider".equalsIgnoreCase(key)) {
                        gpInfo = new CSSPGroupInfo();
                        browseGroupID = rs.getString("browseGroup2_Fid");
                        if (browseGroupID != null) {
                            gpInfo.setId(BOSUuid.read((String)browseGroupID));
                            gpInfo.setName(rs.getString("browseGroup2_fname"));
                            gpInfo.setDisplayName(rs.getString("browseGroup2_fdisplayName"));
                            gpInfo.setNumber(rs.getString("browseGroup2_Fnumber"));
                            gpInfo.setLongNumber(rs.getString("browseGroup2_Lnum"));
                            baseInfo.put("browseGroup", (Object)gpInfo);
                            baseInfo.put("displayName", (Object)(gpInfo.getDisplayName() + "_" + baseInfo.getName()));
                        } else {
                            baseInfo.put("displayName", (Object)baseInfo.getName());
                        }
                    } else if ("material".equalsIgnoreCase(key)) {
                        gpInfo = new MaterialGroupInfo();
                        String materialGroupID = rs.getString("materialGroup_Fid");
                        if (materialGroupID != null) {
                            gpInfo.setId(BOSUuid.read((String)materialGroupID));
                            gpInfo.setName(rs.getString("materialGroup_fname"));
                            gpInfo.setDisplayName(rs.getString("materialGroup_fdisplayName"));
                            gpInfo.setNumber(rs.getString("materialGroup_Fnumber"));
                            gpInfo.setLongNumber(rs.getString("materialGroup_Lnum"));
                            baseInfo.put("materialGroup", (Object)gpInfo);
                            baseInfo.put("displayName", (Object)(gpInfo.getDisplayName() + "_" + baseInfo.getName()));
                        } else {
                            baseInfo.put("displayName", (Object)baseInfo.getName());
                        }
                    }
                } else if (key.equals("saleOrg") || key.equals("profitOrg") || key.equals("purchaseOrg") || key.equals("storeageOrg") || key.equals("companyOrg") || key.equals("costOrg")) {
                    baseInfo.setBoolean("isBizUnit", rs.getBoolean(key + "_FisBizUnit"));
                    baseInfo.setString("longNumber", rs.getString(key + "_Lnum"));
                    baseInfo.setBoolean("isLeaf", rs.getBoolean(key + "_FisLeaf"));
                    baseInfo.setString("displayName", rs.getString(key + "_dspname"));
                } else if (key != null && key.toLowerCase().indexOf("generalassacttype") != -1) {
                    baseInfo.setString("longNumber", rs.getString(key + "_Lnum"));
                    baseInfo.setString("displayName", rs.getString(key + "_dspname"));
                }
                hgInfo.put(key, (Object)baseInfo);
                continue;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return hgInfo;
    }

    private String getAccountListString(IObjectCollection accounts) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        int len = accounts.size();
        for (int i = 0; i < len; ++i) {
            sb.append('\'').append(((AccountViewInfo)accounts.getObject(i)).getId().toString()).append('\'').append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    @Override
    protected IObjectCollection _getAllAssistInitData(Context ctx, IObjectValue ov, String currencyId, HashMap otherCtx) throws BOSException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accountid = (String)otherCtx.get("ACCOUNTTABLEID");
        AsstAccountInfo asstAccount = (AsstAccountInfo)ov;
        IObjectCollection coll = this.getAccountFromAsstAccount(ctx, asstAccount.getId().toString(), orgUnitId, accountid, null, null);
        AsstActTypeCollection tcol = (AsstActTypeCollection)asstAccount.get("asstTypeCol");
        IObjectCollection obj = null;
        obj = this.getSomeAssistInitData(ctx, coll, tcol, currencyId, orgUnitId, accountid, true);
        return obj;
    }

    @Override
    protected ArrayList _findInitData(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CurrencyCollection curCol;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (company.getAccountPeriodType() == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2)));
        filter.setMaskString("#0 or #1");
        view.setFilter(filter);
        boolean isCurrency = AccountViewFactory.getLocalInstance((Context)ctx).exists(filter);
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        if (isCurrency) {
            curCol = curCtrl.getCurrencyCollection(false);
        } else {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)company.getBaseCurrency().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID));
            filter.setMaskString("#0 or #1");
            curCol = curCtrl.getCurrencyCollection(view);
        }
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        Map hmParamValue = InitHelp.getInitParam(ctx, company);
        result.add(hmParamValue.get("GL_002"));
        result.add(hmParamValue.get("GL_008"));
        result.add(hmParamValue.get("G001"));
        result.add(curCol);
        PeriodInfo[] periods = this.getPeriods(ctx, company);
        result.add(periods[0]);
        result.add(periods[2]);
        result.add(periods[1]);
        LowTimer low = new LowTimer();
        low.reset();
        try {
            result.add(this._getAllAssistAccountBySql(ctx, otherCtx));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        low.reset();
        result.add(this._getAllInitClosed(ctx, otherCtx));
        result.add(InitHelp.getAccountTableCollection(ctx));
        result.add(hmParamValue.get("G010"));
        result.add(hmParamValue.get("GL_028"));
        low.reset();
        return result;
    }

    protected IObjectCollection _getAllAssistAccountBySql(Context ctx, HashMap otherCtx) throws BOSException, SQLException {
        AsstAccountCollection result = new AsstAccountCollection();
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String accouttable = (String)otherCtx.get("ACCOUNTTABLEID");
        String loc = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" select asstAccount.fid as asstAccountId,asstAccount.fcount as asstcount,asstAccount.fnumber as asstAccountNumber,asstAccount.fname_").append(loc);
        sql.append(" as asstAccountName ,asstAccount.fisqty,asstAccount.fmeasureunitid ,asstAccount.fmeasureunitgroupid, asstActType.fid as asstActTypeId, \r\n");
        sql.append(" asstActType.fname_").append(loc);
        sql.append(" as asstActTypeName ,asstActType.fnumber asstActTypeNumber,asstActType.fdefaultf7ui,asstActType.fasstHGAttribute,asstActType.fdefaultQueryName, \r\n");
        sql.append(" asstActType.fisForCompany,asstActType.fIsMultilevel,asstActType.fglAsstActTypeGrpid,asstActType.frealtionDataObject,asstActType.fmappingFieldName,mu.fname_").append(loc);
        sql.append(" as fmeasureunitname,mu.fcoefficient,p.fac,asstActType.FUseLongNumber from \r\n");
        sql.append(" ( select distinct case when t.faccountid is not null then t.faccountid  else p.fid end fid,");
        sql.append("  case when t.faccountid is not null then t.fbeforeid  else p.fcaa end fcaa,");
        sql.append("  case when t.faccountid is not null then t.fac  else p.fac end fac,");
        sql.append("  case when t.faccountid is not null then t.fasstActTypeid else p.fasstActTypeid end fasstActTypeid,");
        sql.append("  case when t.faccountid is not null then t.FSEQ  else p.FSEQ end FSEQ ");
        sql.append(" from ( select av.fid,  av.fcaa,av.fac, asstdetail.fasstActTypeid, asstdetail.fseq ");
        sql.append("  from t_bd_asstactgroupdetail asstdetail ");
        sql.append(" left outer join t_bd_accountview av on av.fcaa = asstdetail.fasstaccountid ");
        sql.append(" where av.fcompanyid = ? and av.faccounttableid = ? and av.fisleaf = 1) p ");
        sql.append(" left outer join (select aac.faccountid, aac.fbeforeid, avv.fac, aag.fasstActTypeid,aag.FSEQ  ");
        sql.append(" from T_BD_AsstAccountChange aac ");
        sql.append(" inner join T_BD_ACCOUNTVIEW avv on aac.faccountid = avv.FID ");
        sql.append("  inner join t_bd_asstactgroupdetail aag on aac.fbeforeid = aag.fasstaccountid ");
        sql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid = avv.fcompanyid ");
        sql.append(" where avv.fcompanyid = ? and avv.faccounttableid = ? and avv.fisleaf = 1  and  ssc.fstartperiodid <>  aac.fperiodid ) t ");
        sql.append(" on p.fid = t.faccountid  ) p \r\n");
        sql.append(" inner join t_bd_asstaccount asstAccount  on p.fcaa = asstAccount.fid  ");
        sql.append(" inner join t_bd_asstacttype asstActType on p.fasstActTypeid = asstActType.fid  ");
        sql.append(" left join t_bd_measureunit mu on asstAccount.fmeasureunitid = mu.fid ");
        sql.append(" order by asstAccountId desc, p.fseq, asstActTypeNumber ");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompany.getId().toString(), accouttable, curCompany.getId().toString(), accouttable});
        if (set != null) {
            HashMap<String, AsstAccountInfo> cache = new HashMap<String, AsstAccountInfo>();
            while (set.next()) {
                String asstid = set.getString("asstAccountId");
                AsstAccountInfo temp = null;
                if (cache.containsKey(asstid)) {
                    temp = (AsstAccountInfo)cache.get(asstid);
                    if (set.getBoolean("fac")) {
                        temp.setBoolean("isAc", true);
                    }
                } else {
                    temp = new AsstAccountInfo();
                    temp.setId(BOSUuid.read((String)asstid));
                    temp.setNumber(set.getString("asstAccountNumber"));
                    temp.setCount(set.getInt("asstcount"));
                    temp.setName(set.getString("asstAccountName"));
                    temp.put("asstTypeCol", (Object)new AsstActTypeCollection());
                    temp.setIsQty(set.getBoolean("fisqty"));
                    temp.setBoolean("isAc", set.getBoolean("fac"));
                    if (set.getString("fmeasureunitid") != null) {
                        MeasureUnitInfo unit = new MeasureUnitInfo();
                        unit.setId(BOSUuid.read((String)set.getString("fmeasureunitid")));
                        unit.setName(set.getString("fmeasureunitname"));
                        unit.setCoefficient(set.getBigDecimal("fcoefficient"));
                        temp.setMeasureUnit(unit);
                    }
                    if (set.getString("fmeasureunitgroupid") != null) {
                        MeasureUnitGroupInfo unitGroup = new MeasureUnitGroupInfo();
                        unitGroup.setId(BOSUuid.read((String)set.getString("fmeasureunitgroupid")));
                        temp.setMeasureUnitGroup(unitGroup);
                    }
                    result.add(temp);
                    cache.put(asstid, temp);
                }
                AsstActTypeInfo type = new AsstActTypeInfo();
                type.setId(BOSUuid.read((String)set.getString("asstActTypeId")));
                type.setNumber(set.getString("asstActTypeNumber"));
                type.setName(set.getString("asstActTypeName"));
                type.setAsstHGAttribute(set.getString("fasstHGAttribute"));
                type.setMappingFieldName(set.getString("fmappingFieldName"));
                if (null != type.getAsstHGAttribute() && "region".equals(type.getAsstHGAttribute())) {
                    type.setDefaultQueryName("com.kingdee.eas.fi.gl.app.F7BankQuery");
                } else {
                    type.setDefaultQueryName(set.getString("fdefaultQueryName"));
                }
                type.setRealtionDataObject(set.getString("frealtionDataObject"));
                type.setDefaultF7UI(set.getString("fdefaultf7ui"));
                type.setIsForCompany(set.getBoolean("fisForCompany"));
                type.setUseLongNumber(set.getBoolean("FUseLongNumber"));
                type.setIsMultilevel(set.getBoolean("fIsMultilevel"));
                String fglAsstActTypeGrpid = set.getString("fglAsstActTypeGrpid");
                if (fglAsstActTypeGrpid != null) {
                    GeneralAsstActTypeGroupInfo info = new GeneralAsstActTypeGroupInfo();
                    info.setId(BOSUuid.read((String)fglAsstActTypeGrpid));
                    type.setGlAsstActTypeGrp(info);
                }
                ((AsstActTypeCollection)temp.get("asstTypeCol")).add(type);
            }
        }
        return result;
    }

    @Override
    protected IObjectCollection _getAllAssistAccount(Context ctx, HashMap otherCtx) throws BOSException {
        AsstAccountCollection result = new AsstAccountCollection();
        String cuid = (String)otherCtx.get("CUID");
        String accouttable = (String)otherCtx.get("ACCOUNTTABLEID");
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuid));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accouttable));
        filter.getFilterItems().add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CAA.id"));
        AccountViewCollection avCol = av.getAccountViewCollection(view);
        IAsstActGroupDetail aa = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
        view = new EntityViewInfo();
        filter = new FilterInfo();
        String mask = "";
        int i = 0;
        for (AccountViewInfo account : avCol) {
            if (account.getCAA() == null) continue;
            filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)account.getCAA().getId().toString()));
            mask = mask + "#" + i++ + " or ";
        }
        if (i <= 0) {
            return result;
        }
        mask = mask.substring(0, mask.length() - 4);
        filter.setMaskString("(" + mask + ")");
        view.setFilter(filter);
        selector = view.getSelector();
        selector.add(new SelectorItemInfo());
        selector.add(new SelectorItemInfo("asstAccount.id"));
        selector.add(new SelectorItemInfo("asstAccount.number"));
        selector.add(new SelectorItemInfo("asstAccount.name"));
        selector.add(new SelectorItemInfo("asstActType.id"));
        selector.add(new SelectorItemInfo("asstActType.name"));
        selector.add(new SelectorItemInfo("asstActType.number"));
        selector.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        selector.add(new SelectorItemInfo("asstActType.defaultQueryName"));
        selector.add(new SelectorItemInfo("asstActType.isForCompany"));
        selector.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        selector.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        selector.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        SorterItemCollection sorter = view.getSorter();
        sorter.add(new SorterItemInfo("asstAccount.number"));
        AsstActGroupDetailCollection col = aa.getAsstActGroupDetailCollection(view);
        HashMap<String, AsstAccountInfo> cache = new HashMap<String, AsstAccountInfo>();
        for (i = 0; i < col.size(); ++i) {
            AsstActGroupDetailInfo detail = col.get(i);
            AsstAccountInfo asst = detail.getAsstAccount();
            AsstActTypeInfo type = detail.getAsstActType();
            AsstAccountInfo temp = null;
            if (cache.containsKey(asst.getId().toString())) {
                temp = (AsstAccountInfo)cache.get(asst.getId().toString());
            } else {
                temp = asst;
                asst.put("asstTypeCol", (Object)new AsstActTypeCollection());
                result.add(asst);
                cache.put(temp.getId().toString(), temp);
            }
            ((AsstActTypeCollection)temp.get("asstTypeCol")).add(type);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _closeInit(Context ctx, IObjectCollection accounts, String[] asstTypeAttrs, HashMap otherCtx) throws BOSException, EASBizException {
        String userId;
        MutexParameter mp;
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter current = mutex.requestMutex3(mp = GLMutexUtils.buildModifyBalanceParameter(ctx, orgUnitId, userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), "GL_Init"));
        if (current != null) {
            throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
        }
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            this.checkCloseInit(ctx, accounts, otherCtx);
            AccountViewCollection col = (AccountViewCollection)accounts;
            int size = accounts.size();
            StringBuffer ids = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    ids.append(",");
                }
                ids.append("'").append(col.get(i).getId().toString()).append("'");
            }
            IGLBalanceFacade updateBalance = GLBalanceFacadeFactory.getLocalInstance(ctx);
            updateBalance.initAssistBalance(orgUnitId, accounts, startPeriod.getId().toString(), firstPeriod.getId().toString(), null);
            updateBalance.initAssistMeasureBalance(orgUnitId, accounts, startPeriod.getId().toString(), firstPeriod.getId().toString(), null);
            StringBuffer sql = new StringBuffer();
            sql.append("delete from t_gl_flag where forgUnitid = '").append(orgUnitId).append("' and fname = 'astinit' and fkey in (").append(ids).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append("insert into t_gl_flag(fid,fname,fvalue,forgunitid,fkey) select newbosid('").append(new GLFlagInfo().getBOSType().toString()).append("')");
            sql.append(",'astinit','true','").append(orgUnitId).append("',av.fid from t_bd_accountview av where av.fid in (").append(ids).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
            mutex.releaseMutex(mp.getRequestId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _cancelInit(Context ctx, IObjectCollection accounts, String[] asstTypeAttrs, HashMap otherCtx) throws BOSException, EASBizException {
        String userId;
        MutexParameter mp;
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter current = mutex.requestMutex3(mp = GLMutexUtils.buildModifyBalanceParameter(ctx, orgUnitId, userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), "GL_Uninit"));
        if (current != null) {
            throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
        }
        try {
            AccountViewCollection col = (AccountViewCollection)accounts;
            InitHelp.checkCancelInit(ctx, orgUnitId);
            int size = accounts.size();
            StringBuffer ids = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    ids.append(",");
                }
                ids.append("'").append(col.get(i).getId().toString()).append("'");
            }
            IGLBalanceFacade updateBalance = GLBalanceFacadeFactory.getLocalInstance(ctx);
            if (accounts != null && accounts.size() > 0) {
                ctx.put((Object)"accounts", (Object)accounts);
            }
            updateBalance.antiInitBalance(orgUnitId, startPeriod.getId().toString(), firstPeriod.getId().toString(), "T_GL_AssistBalance");
            updateBalance.antiInitBalance(orgUnitId, startPeriod.getId().toString(), firstPeriod.getId().toString(), "T_GL_AssistMeasureBalance");
            StringBuffer sql = new StringBuffer();
            sql.append("delete from t_gl_flag where forgUnitid = '").append(orgUnitId).append("' and fname = 'astinit' and fkey in (").append(ids).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append("insert into t_gl_flag(fid,fname,fvalue,forgunitid,fkey) select newbosid('").append(new GLFlagInfo().getBOSType().toString()).append("')");
            sql.append(",'astinit','false','").append(orgUnitId).append("',av.fid from t_bd_accountview av where av.fid in (").append(ids).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            if (accounts != null && accounts.size() > 0) {
                ctx.remove((Object)"accounts");
            }
        }
        finally {
            mutex.releaseMutex(mp.getRequestId());
        }
    }

    @Override
    protected boolean[] _getInitClosed(Context ctx, String[] accountIds, HashMap otherCtx) throws BOSException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        boolean[] result = flag.getAstInitClosed(accountIds, orgUnitId);
        return result;
    }

    @Override
    protected String[] _getAllInitClosed(Context ctx, HashMap otherCtx) throws BOSException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        String[] result = flag.getAllAstInitClosed(orgUnitId);
        return result;
    }

    @Override
    protected IObjectCollection _getCanCloseInitAccount(Context ctx, String asstAccountId, HashMap otherCtx) throws BOSException, EASBizException {
        return this.getAccountCol(ctx, asstAccountId, otherCtx, true);
    }

    @Override
    protected IObjectCollection _getCanCancelInitAccount(Context ctx, String asstAccountId, HashMap otherCtx) throws BOSException, EASBizException {
        return this.getAccountCol(ctx, asstAccountId, otherCtx, false);
    }

    private IObjectCollection getAccountCol(Context ctx, String asstAccountId, HashMap otherCtx, boolean isCanClose) throws EASBizException, BOSException {
        String companyid = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
        String accountid = (String)otherCtx.get("Account");
        String[] accountIds = this._getAllInitClosed(ctx, otherCtx);
        FilterInfo filter = new FilterInfo();
        StringBuffer str = new StringBuffer();
        if (accountIds != null) {
            for (int i = 0; i < accountIds.length; ++i) {
                str.append(",").append(accountIds[i]);
            }
            str.deleteCharAt(0);
            if (isCanClose) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.NOTINCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INCLUDE));
            }
            filter.setMaskString(" #0 ");
        }
        AccountViewCollection accounts = (AccountViewCollection)this.getAccountFromAsstAccount(ctx, asstAccountId, companyid, accounttableid, accountid, filter);
        return accounts;
    }

    private IObjectCollection getAccountFromAsstAccount(Context ctx, String asstAccountId, String orgUnitId, String accounttableid, String accountId, FilterInfo filter) throws BOSException {
        Map<String, AsstAccountInfo> caas;
        Object view;
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        HashSet<String> accountIds = new HashSet<String>();
        try {
            PeriodInfo start = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(orgUnitId));
            if (accountId != null) {
                accountIds.add(accountId);
            } else {
                int index;
                String mask;
                view = new EntityViewInfo();
                if (filter == null) {
                    filter = new FilterInfo();
                }
                if ((mask = filter.getMaskString()) == null) {
                    mask = "";
                }
                if ((index = filter.getFilterItems().size()) > 0) {
                    mask = mask + " and ";
                }
                filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)orgUnitId));
                mask = mask + "#" + index++;
                filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                mask = mask + " and #" + index++;
                filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accounttableid));
                mask = mask + " and #" + index++;
                filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
                mask = mask + " and #" + index++;
                filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
                mask = mask + " and #" + index++;
                filter.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
                mask = mask + " and #" + index++;
                filter.setMaskString(mask);
                view.setFilter(filter);
                SelectorItemCollection sic = view.getSelector();
                sic.add(new SelectorItemInfo("id"));
                AccountViewCollection coll = av.getAccountViewCollection((EntityViewInfo)view);
                Iterator it = coll.iterator();
                while (it.hasNext()) {
                    accountIds.add(((AccountViewInfo)it.next()).getId().toString());
                }
            }
            caas = GLAsstAccountUtils.getCAAs(ctx, accountIds, start.getId().toString(), null);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        HashSet<String> okAccountIds = new HashSet<String>();
        for (String id : accountIds) {
            AsstAccountInfo caa = caas.get(id);
            if (caa == null || asstAccountId != null && !asstAccountId.equals(caa.getId().toString())) continue;
            okAccountIds.add(id);
        }
        if (okAccountIds.size() == 0) {
            return new AccountViewCollection();
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", okAccountIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("accountTypeID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
        AccountViewCollection coll = av.getAccountViewCollection((EntityViewInfo)view);
        for (AccountViewInfo account : coll) {
            account.setCAA(caas.get(account.getId().toString()));
        }
        return coll;
    }

    private void checkDataIntegrity(Context ctx, String companyId, String[] accounts) throws EASBizException, BOSException {
        StringBuffer msgStr = new StringBuffer();
        if (accounts.length <= 0) {
            return;
        }
        HashSet<String> accountSet = new HashSet<String>();
        StringBuffer accountStr = new StringBuffer();
        for (int i = 0; i < accounts.length; ++i) {
            accountStr.append("'").append(accounts[i]).append("'");
            if (i == accounts.length - 1) continue;
            accountStr.append(",");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select bal.faccountid, acct.fnumber, bal.fassistgrpid, hg.fasstaccountid from t_gl_initassistbalance bal \r\n");
        sql.append("inner join t_bd_accountview acct on bal.faccountid = acct.fid \r\n");
        sql.append("inner join t_bd_assistanthg hg on bal.fassistgrpid = hg.fid \r\n");
        sql.append("where bal.forgunitid = ? and bal.faccountid in ( \r\n");
        sql.append(accountStr).append(") \r\n");
        sql.append("and bal.fcurrencyid <> ? and bal.fcurrencyid <> ? \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString()});
        if (rs.size() > 0) {
            try {
                while (rs.next()) {
                    String faccountid = rs.getString("faccountid");
                    String fnumber = rs.getString("fnumber");
                    if (accountSet.contains(fnumber)) continue;
                    String fassistgrpid = rs.getString("fassistgrpid");
                    String fasstaccountid = rs.getString("fasstaccountid");
                    if (fasstaccountid == null || fassistgrpid == null) continue;
                    List typeList = this.getAsstAccountType(ctx, fasstaccountid);
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    String temp = null;
                    for (int i = 0; i < typeList.size(); ++i) {
                        temp = (String)typeList.get(i);
                        if ("bankAccount".equals(temp)) {
                            selectors.add(new SelectorItemInfo("bankAccount.*"));
                            continue;
                        }
                        selectors.add(new SelectorItemInfo(temp + ".id"));
                    }
                    AssistantHGInfo hgInfo = this.getHgInfo(ctx, fassistgrpid, selectors);
                    for (int i = 0; i < typeList.size(); ++i) {
                        String attr = (String)typeList.get(i);
                        if (hgInfo.getObjectValue(attr) != null) continue;
                        String msg = MessageFormat.format(EASResource.getString((String)GL_RESOURCE, (String)"1033"), fnumber);
                        msgStr.append(msg).append("\r\n");
                        accountSet.add(fnumber);
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (msgStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("103", msgStr.toString()));
        }
    }

    private AssistantHGInfo getHgInfo(Context ctx, String fassistgrpid, SelectorItemCollection selectors) throws EASBizException, BOSException {
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, this.getClass().getName() + "getHgInfo");
        if (datas.containsKey(fassistgrpid)) {
            return (AssistantHGInfo)datas.get(fassistgrpid);
        }
        AssistantHGInfo hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(fassistgrpid), selectors);
        datas.put(fassistgrpid, hgInfo);
        return hgInfo;
    }

    private List getAsstAccountType(Context ctx, String fasstaccountid) throws BOSException, SQLException {
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, this.getClass().getName() + "getAsstAccountType");
        if (datas.containsKey(fasstaccountid)) {
            return (List)datas.get(fasstaccountid);
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> typeList = new ArrayList<String>();
        sql.append("SELECT ty.fassthgattribute attr FROM T_BD_AsstActGroupDetail aagdChild   \r\n");
        sql.append("INNER JOIN T_BD_AsstActType ty on aagdChild.FAsstActTypeID = ty.fid    \r\n");
        sql.append("WHERE aagdChild.FAsstAccountID = ? \r\n");
        IRowSet typeRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{fasstaccountid});
        while (typeRs != null && typeRs.next()) {
            String actType = typeRs.getString("attr");
            typeList.add(actType);
        }
        datas.put(fasstaccountid, typeList);
        return typeList;
    }

    private void checkCloseInit(Context ctx, IObjectCollection selectedAccount, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String orgUnitId = company.getId().toString();
        AccountViewCollection col = (AccountViewCollection)selectedAccount;
        int size = col.size();
        if (this.isGLClosed(ctx, orgUnitId)) {
            InitHelp.checkAsstEqualGL(ctx, col, otherCtx);
        }
        String[] accounts = new String[size];
        for (int i = 0; i < size; ++i) {
            AccountViewInfo info = col.get(i);
            accounts[i] = info.getId().toString();
        }
        if (company.isIsAssistantOrg()) {
            String masterTable;
            CompanyOrgUnitInfo masterCompany = company.getMainOrg();
            String curTable = company.getAccountTable().getId().toString();
            if (curTable.equals(masterTable = masterCompany.getAccountTable().getId().toString())) {
                this.checkDataIntegrity(ctx, orgUnitId, accounts);
            }
        }
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)orgUnitId));
        HashMap<String, ObjectUuidPK> hmNumAndOrgId = new HashMap<String, ObjectUuidPK>();
        hmNumAndOrgId.put("GL_028", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmNumAndOrgId);
        Boolean allowCussent = Boolean.valueOf((String)hmAllParam.get("GL_028"));
        if (allowCussent.equals(Boolean.FALSE)) {
            return;
        }
        col = InitHelp.getInitedCussentAccountViewCollection(ctx, accounts, orgUnitId);
        InitHelp.checkAsstEqualCussent(ctx, col, otherCtx);
    }

    private boolean isGLClosed(Context ctx, String orgUnitId) throws BOSException {
        return this.getFlagCtrl(ctx).getGLInitClosed(orgUnitId);
    }

    private PeriodInfo[] getPeriods(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return InitHelp.getPeriods(ctx, company);
    }

    @Override
    protected Object[] _fetchExchangeRate(Context ctx, Object[] info) throws BOSException, EASBizException {
        return VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchExchangeRate(info);
    }

    @Override
    protected void _save(Context ctx, IObjectCollection datas, HashMap otherCtx) throws BOSException, EASBizException {
        String sql = "select max(Fseq) maxseq from T_GL_InitAssistBalance";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int seq = 0;
        try {
            if (rs.next()) {
                seq = rs.getInt("maxseq");
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        Object delete = otherCtx.get("deleted");
        if (delete != null && delete instanceof List) {
            List deleteKeys = (List)delete;
            String[] keys = null;
            for (int i = 0; i < deleteKeys.size(); ++i) {
                keys = ((String)deleteKeys.get(i)).split("@");
                this.myDelete1(ctx, keys[0], otherCtx.get("accountID").toString(), otherCtx.get("orgID").toString(), otherCtx.get("currencyID").toString());
            }
        }
        for (int i = 0; i < datas.size(); ++i) {
            InitAssistBalanceInfo as = (InitAssistBalanceInfo)datas.getObject(i);
            if (as.get("persist_status").equals("new")) {
                if (!"true".equals(as.get("modAssit"))) {
                    as.setSeq(++seq);
                }
                this.getInitAssistBalanceCtrl(ctx).addnew(as);
                continue;
            }
            if (!as.get("persist_status").equals("dirty")) continue;
            this.myUpdate(ctx, as);
        }
        this.saveGeneral(ctx, datas, otherCtx);
    }

    private void saveGeneral(Context ctx, IObjectCollection datas, HashMap otherCtx) throws BOSException, EASBizException {
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String glcid = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
        String grcid = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
        boolean isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
        String sumSql = new StringBuffer("select ").append("sum(balance.fbeginbalanceLocal) fbeginbalanceLocal,sum(balance.fyeardebitLocal) fyeardebitLocal,sum(balance.fyearcreditLocal) fyearcreditLocal").append(",sum(balance.fdebitlocal) fdebitlocal,sum(balance.fcreditlocal) fcreditlocal,sum(balance.fendbalancelocal) fendbalancelocal").append(",sum(balance.fbeginbalancerpt) fbeginbalancerpt,sum(balance.fyeardebitrpt) fyeardebitrpt,sum(balance.fyearcreditrpt) fyearcreditrpt").append(",sum(balance.fdebitrpt) fdebitrpt,sum(balance.fcreditrpt) fcreditrpt,sum(balance.fendbalancerpt) fendbalancerpt").append(",sum(balance.fbeginqty) fbeginqty,sum(balance.fyeardebitqty) fyeardebitqty,sum(balance.fyearcreditqty) fyearcreditqty").append(",sum(balance.fdebitqty) fdebitqty,sum(balance.fcreditqty) fcreditqty,sum(balance.fendqty) fendqty").append(",sum(balance.fStandardbeginqty) fStandardbeginqty,sum(balance.fStandardyeardebitqty) fStandardyeardebitqty,sum(balance.fStandardyearcreditqty) fStandardyearcreditqty").append(",sum(balance.fStandarddebitqty) fStandarddebitqty,sum(balance.fStandardcreditqty) fStandardcreditqty,sum(balance.fStandardendqty) fStandardendqty").append(",sum(balance.fyearpnllocal) fyearpnllocal,sum(balance.fyearpnlrpt) fyearpnlrpt").append(" from t_gl_initassistbalance balance where balance.forgunitid=?  and balance.faccountid=? and balance.fassistgrpid=? ").append(" and balance.fcurrencyid<>? and balance.fcurrencyid<>?").toString();
        String existSql = "select top 1 * from t_gl_initassistbalance balance where balance.forgunitid=? and balance.faccountid=?  and balance.fassistgrpid=? and balance.fcurrencyid=? ";
        String newSql = new StringBuffer("insert into t_gl_initassistBalance(forgunitid,faccountid,fassistgrpid,fcurrencyid,fmeasureUnitid,").append("fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fendbalancefor,fendbalancelocal,fendbalancerpt,").append("fyeardebitfor,fyeardebitlocal,fyeardebitrpt,fyearcreditfor,fyearcreditlocal,fyearcreditrpt,").append("fbeginqty,fendqty,fyeardebitqty,fyearcreditqty,").append("fStandardbeginqty,fStandardendqty,fStandardyeardebitqty,fStandardyearcreditqty,").append("fyearpnlfor,fyearpnllocal,fyearpnlrpt) ").append("values(?,?,?,?,?,").append("?,?,?,?,?,?,?,?,?,?,?,?,").append("?,?,?,?,").append("?,?,?,?,").append("?,?,?)").toString();
        String updateSql = new StringBuffer("update t_gl_initassistBalance ").append("set fbeginbalancefor=?,fbeginbalancelocal=?,fbeginbalancerpt=?,fendbalancefor=?,fendbalancelocal=?,fendbalancerpt=?,").append("fyeardebitfor=?,fyeardebitlocal=?,fyeardebitrpt=?,fyearcreditfor=?,fyearcreditlocal=?,fyearcreditrpt=?,").append("fbeginqty=?,fendqty=?,fyeardebitqty=?,fyearcreditqty=?,").append("fStandardbeginqty=?,fStandardendqty=?,fStandardyeardebitqty=?,fStandardyearcreditqty=?,").append("fyearpnlfor=?,fyearpnllocal=?,fyearpnlrpt=?,fmeasureUnitid =?").append(" where forgunitid=? and faccountid=? and fassistgrpid=? and fcurrencyid=?").toString();
        String deleteSql = "delete from t_gl_initassistBalance where forgunitid=? and faccountid=? and fassistgrpid=? and (fcurrencyid=? or fcurrencyid=?)";
        Connection con = null;
        PreparedStatement stmt = null;
        PreparedStatement update_stmt = null;
        PreparedStatement new_stmt = null;
        Statement clear_stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            update_stmt = con.prepareStatement(updateSql);
            new_stmt = con.prepareStatement(newSql);
            for (int i = 0; i < datas.size(); ++i) {
                InitAssistBalanceInfo as = (InitAssistBalanceInfo)datas.getObject(i);
                String accountId = as.getAccount().getId().toString();
                String hgId = as.getAssistGrp().getId().toString();
                String measureUnitid = null;
                if (as.getMesureUnit() != null) {
                    measureUnitid = as.getMesureUnit().getId().toString();
                }
                stmt = con.prepareStatement(sumSql);
                int index = 1;
                stmt.setString(index++, companyId);
                stmt.setString(index++, accountId);
                stmt.setString(index++, hgId);
                stmt.setString(index++, glcid);
                stmt.setString(index++, grcid);
                rs = stmt.executeQuery();
                if (!rs.next()) continue;
                InitAssistBalanceInfo data = new InitAssistBalanceInfo();
                data.put("account", accountId);
                data.put("assistGrp", hgId);
                data.put("measureUnitid", measureUnitid);
                data.setBeginBalanceLocal(rs.getBigDecimal("fbeginbalancelocal"));
                data.setBeginBalanceRpt(rs.getBigDecimal("fbeginbalancerpt"));
                data.setBeginQty(rs.getBigDecimal("fbeginqty"));
                data.setStabdardBeginQty(rs.getBigDecimal("fStandardbeginqty"));
                data.setEndBalanceLocal(rs.getBigDecimal("fendbalancelocal"));
                data.setEndBalanceRpt(rs.getBigDecimal("fendbalancerpt"));
                data.setEndQty(rs.getBigDecimal("fendqty"));
                data.setStabdardEndQty(rs.getBigDecimal("fStandardendqty"));
                data.setYearCreditLocal(rs.getBigDecimal("fyearcreditlocal"));
                data.setYearCreditQty(rs.getBigDecimal("fyearcreditqty"));
                data.setStabdardYearCreditQty(rs.getBigDecimal("fStandardyearcreditqty"));
                data.setYearCreditRpt(rs.getBigDecimal("fyearcreditrpt"));
                data.setYearDebitLocal(rs.getBigDecimal("fyeardebitlocal"));
                data.setYearDebitQty(rs.getBigDecimal("fyeardebitqty"));
                data.setStabdardYearDebitQty(rs.getBigDecimal("fStandardyeardebitqty"));
                data.setYearDebitRpt(rs.getBigDecimal("fyeardebitrpt"));
                data.setYearPnLLocal(rs.getBigDecimal("fyearpnllocal"));
                data.setYearPnLRpt(rs.getBigDecimal("fyearpnlrpt"));
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                if (data.getBeginBalanceLocal() == null) {
                    stmt = con.prepareStatement(deleteSql);
                    index = 1;
                    stmt.setString(index++, companyId);
                    stmt.setString(index++, accountId);
                    stmt.setString(index++, hgId);
                    stmt.setString(index++, glcid);
                    stmt.setString(index++, grcid);
                    stmt.executeUpdate();
                    SQLUtils.cleanup((Statement)stmt);
                    continue;
                }
                stmt = con.prepareStatement(existSql);
                index = 1;
                stmt.setString(index++, companyId);
                stmt.setString(index++, accountId);
                stmt.setString(index++, hgId);
                stmt.setString(index++, glcid);
                rs = stmt.executeQuery();
                boolean flag = rs.next();
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                if (flag) {
                    index = 1;
                    update_stmt.setBigDecimal(index++, data.getBeginBalanceLocal());
                    update_stmt.setBigDecimal(index++, data.getBeginBalanceLocal());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getEndBalanceLocal());
                    update_stmt.setBigDecimal(index++, data.getEndBalanceLocal());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getYearDebitLocal());
                    update_stmt.setBigDecimal(index++, data.getYearDebitLocal());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getYearCreditLocal());
                    update_stmt.setBigDecimal(index++, data.getYearCreditLocal());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getBeginQty());
                    update_stmt.setBigDecimal(index++, data.getEndQty());
                    update_stmt.setBigDecimal(index++, data.getYearDebitQty());
                    update_stmt.setBigDecimal(index++, data.getYearCreditQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardBeginQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardEndQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardYearDebitQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardYearCreditQty());
                    update_stmt.setBigDecimal(index++, data.getYearPnLLocal());
                    update_stmt.setBigDecimal(index++, data.getYearPnLLocal());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setString(index++, measureUnitid);
                    update_stmt.setString(index++, companyId);
                    update_stmt.setString(index++, accountId);
                    update_stmt.setString(index++, hgId);
                    update_stmt.setString(index++, glcid);
                    update_stmt.executeUpdate();
                } else {
                    index = 1;
                    new_stmt.setString(index++, companyId);
                    new_stmt.setString(index++, accountId);
                    new_stmt.setString(index++, hgId);
                    new_stmt.setString(index++, glcid);
                    new_stmt.setString(index++, measureUnitid);
                    new_stmt.setBigDecimal(index++, data.getBeginBalanceLocal());
                    new_stmt.setBigDecimal(index++, data.getBeginBalanceLocal());
                    new_stmt.setBigDecimal(index++, InitHelp.zero);
                    new_stmt.setBigDecimal(index++, data.getEndBalanceLocal());
                    new_stmt.setBigDecimal(index++, data.getEndBalanceLocal());
                    new_stmt.setBigDecimal(index++, InitHelp.zero);
                    new_stmt.setBigDecimal(index++, data.getYearDebitLocal());
                    new_stmt.setBigDecimal(index++, data.getYearDebitLocal());
                    new_stmt.setBigDecimal(index++, InitHelp.zero);
                    new_stmt.setBigDecimal(index++, data.getYearCreditLocal());
                    new_stmt.setBigDecimal(index++, data.getYearCreditLocal());
                    new_stmt.setBigDecimal(index++, InitHelp.zero);
                    new_stmt.setBigDecimal(index++, data.getBeginQty());
                    new_stmt.setBigDecimal(index++, data.getEndQty());
                    new_stmt.setBigDecimal(index++, data.getYearDebitQty());
                    new_stmt.setBigDecimal(index++, data.getYearCreditQty());
                    new_stmt.setBigDecimal(index++, data.getStabdardBeginQty());
                    new_stmt.setBigDecimal(index++, data.getStabdardEndQty());
                    new_stmt.setBigDecimal(index++, data.getStabdardYearDebitQty());
                    new_stmt.setBigDecimal(index++, data.getStabdardYearCreditQty());
                    new_stmt.setBigDecimal(index++, data.getYearPnLLocal());
                    new_stmt.setBigDecimal(index++, data.getYearPnLLocal());
                    new_stmt.setBigDecimal(index++, InitHelp.zero);
                    new_stmt.executeUpdate();
                }
                if (!isUseReport) continue;
                stmt = con.prepareStatement(existSql);
                index = 1;
                stmt.setString(index++, companyId);
                stmt.setString(index++, accountId);
                stmt.setString(index++, hgId);
                stmt.setString(index++, grcid);
                rs = stmt.executeQuery();
                flag = rs.next();
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                if (flag) {
                    index = 1;
                    update_stmt.setBigDecimal(index++, data.getBeginBalanceRpt());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getBeginBalanceRpt());
                    update_stmt.setBigDecimal(index++, data.getEndBalanceRpt());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getEndBalanceRpt());
                    update_stmt.setBigDecimal(index++, data.getYearDebitRpt());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getYearDebitRpt());
                    update_stmt.setBigDecimal(index++, data.getYearCreditRpt());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getYearCreditRpt());
                    update_stmt.setBigDecimal(index++, data.getBeginQty());
                    update_stmt.setBigDecimal(index++, data.getEndQty());
                    update_stmt.setBigDecimal(index++, data.getYearDebitQty());
                    update_stmt.setBigDecimal(index++, data.getYearCreditQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardBeginQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardEndQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardYearDebitQty());
                    update_stmt.setBigDecimal(index++, data.getStabdardYearCreditQty());
                    update_stmt.setBigDecimal(index++, data.getYearPnLRpt());
                    update_stmt.setBigDecimal(index++, InitHelp.zero);
                    update_stmt.setBigDecimal(index++, data.getYearPnLRpt());
                    update_stmt.setString(index++, measureUnitid);
                    update_stmt.setString(index++, companyId);
                    update_stmt.setString(index++, accountId);
                    update_stmt.setString(index++, hgId);
                    update_stmt.setString(index++, grcid);
                    update_stmt.executeUpdate();
                    continue;
                }
                index = 1;
                new_stmt.setString(index++, companyId);
                new_stmt.setString(index++, accountId);
                new_stmt.setString(index++, hgId);
                new_stmt.setString(index++, grcid);
                new_stmt.setString(index++, measureUnitid);
                new_stmt.setBigDecimal(index++, data.getBeginBalanceRpt());
                new_stmt.setBigDecimal(index++, InitHelp.zero);
                new_stmt.setBigDecimal(index++, data.getBeginBalanceRpt());
                new_stmt.setBigDecimal(index++, data.getEndBalanceRpt());
                new_stmt.setBigDecimal(index++, InitHelp.zero);
                new_stmt.setBigDecimal(index++, data.getEndBalanceRpt());
                new_stmt.setBigDecimal(index++, data.getYearDebitRpt());
                new_stmt.setBigDecimal(index++, InitHelp.zero);
                new_stmt.setBigDecimal(index++, data.getYearDebitRpt());
                new_stmt.setBigDecimal(index++, data.getYearCreditRpt());
                new_stmt.setBigDecimal(index++, InitHelp.zero);
                new_stmt.setBigDecimal(index++, data.getYearCreditRpt());
                new_stmt.setBigDecimal(index++, data.getBeginQty());
                new_stmt.setBigDecimal(index++, data.getEndQty());
                new_stmt.setBigDecimal(index++, data.getYearDebitQty());
                new_stmt.setBigDecimal(index++, data.getYearCreditQty());
                new_stmt.setBigDecimal(index++, data.getStabdardBeginQty());
                new_stmt.setBigDecimal(index++, data.getStabdardEndQty());
                new_stmt.setBigDecimal(index++, data.getStabdardYearDebitQty());
                new_stmt.setBigDecimal(index++, data.getStabdardYearCreditQty());
                new_stmt.setBigDecimal(index++, data.getYearPnLRpt());
                new_stmt.setBigDecimal(index++, InitHelp.zero);
                new_stmt.setBigDecimal(index++, data.getYearPnLRpt());
                new_stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(clear_stmt);
                SQLUtils.cleanup(new_stmt);
                SQLUtils.cleanup((Statement)update_stmt);
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(clear_stmt);
        SQLUtils.cleanup((Statement)new_stmt);
        SQLUtils.cleanup((Statement)update_stmt);
        SQLUtils.cleanup(rs, stmt, (Connection)con);
    }

    private void myDelete(Context ctx, InitAssistBalanceInfo as, String curAsstAccountid) throws BOSException {
        AssistantHGInfo hg = as.getAssistGrp();
        String deleteBalance = null;
        String hgId = null;
        String orgunitid = as.getOrgUnit().get(as.getOrgUnit().getPKField()).toString();
        String currencyid = as.getCurrency().getId().toString();
        String accountid = null;
        deleteBalance = "delete from t_gl_initassistbalance where forgunitid=? and faccountid=? and fcurrencyid=? and fassistgrpid=?";
        hgId = hg.getId().toString();
        accountid = as.getAccount().getId().toString();
        Connection con = null;
        PreparedStatement ps2 = null;
        try {
            con = this.getConnection(ctx);
            ps2 = con.prepareStatement(deleteBalance);
            int i = 1;
            ps2.setString(i++, orgunitid);
            ps2.setString(i++, accountid);
            ps2.setString(i++, currencyid);
            ps2.setString(i++, hgId);
            ps2.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps2, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps2, (Connection)con);
    }

    private void myDelete1(Context ctx, String hgId, String accountid, String orgunitid, String currencyid) throws BOSException {
        String deleteBalance = "delete from t_gl_initassistbalance where forgunitid=? and faccountid=? and fcurrencyid=? and fassistgrpid=?";
        Connection con = null;
        PreparedStatement ps2 = null;
        try {
            con = this.getConnection(ctx);
            ps2 = con.prepareStatement(deleteBalance);
            int i = 1;
            ps2.setString(i++, orgunitid);
            ps2.setString(i++, accountid);
            ps2.setString(i++, currencyid);
            ps2.setString(i++, hgId);
            ps2.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps2, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps2, (Connection)con);
    }

    private void myUpdate(Context ctx, InitAssistBalanceInfo as) throws BOSException {
        AssistantHGInfo hg = as.getAssistGrp();
        String hgId = hg.getId().toString();
        String orgunitid = as.getOrgUnit().get(as.getOrgUnit().getPKField()).toString();
        String accountid = as.getAccount().getId().toString();
        String currencyid = as.getCurrency().getId().toString();
        String updateSql = "update t_gl_initassistBalance set fbeginbalancefor=?,fbeginbalancelocal=?,fbeginbalancerpt=?,fendbalancefor=?,fendbalancelocal=?,fendbalancerpt=?,fyeardebitfor=?,fyeardebitlocal=?,fyeardebitrpt=?,fyearcreditfor=?,fyearcreditlocal=?,fyearcreditrpt=?,fbeginqty=?,fendqty=?,fyeardebitqty=?,fyearcreditqty=?,fyearpnlfor=?,fyearpnllocal=?,fyearpnlrpt=?,fmeasureunitid=?,fstandardyeardebitqty=?,fstandardyearcreditqty=?,fstandardbeginqty=? ,fstandardendqty=? where forgunitid=? and faccountid=? and fassistgrpid=? and fcurrencyid=?";
        InitAssistBalanceInfo data = as;
        int index = 1;
        Connection con = null;
        PreparedStatement update_stmt = null;
        try {
            con = this.getConnection(ctx);
            update_stmt = con.prepareStatement(updateSql);
            update_stmt.setBigDecimal(index++, data.getBeginBalanceFor());
            update_stmt.setBigDecimal(index++, data.getBeginBalanceLocal());
            update_stmt.setBigDecimal(index++, data.getBeginBalanceRpt());
            update_stmt.setBigDecimal(index++, data.getEndBalanceFor());
            update_stmt.setBigDecimal(index++, data.getEndBalanceLocal());
            update_stmt.setBigDecimal(index++, data.getEndBalanceRpt());
            update_stmt.setBigDecimal(index++, data.getYearDebitFor());
            update_stmt.setBigDecimal(index++, data.getYearDebitLocal());
            update_stmt.setBigDecimal(index++, data.getYearDebitRpt());
            update_stmt.setBigDecimal(index++, data.getYearCreditFor());
            update_stmt.setBigDecimal(index++, data.getYearCreditLocal());
            update_stmt.setBigDecimal(index++, data.getYearCreditRpt());
            update_stmt.setBigDecimal(index++, data.getBeginQty());
            update_stmt.setBigDecimal(index++, data.getEndQty());
            update_stmt.setBigDecimal(index++, data.getYearDebitQty());
            update_stmt.setBigDecimal(index++, data.getYearCreditQty());
            update_stmt.setBigDecimal(index++, data.getYearPnLFor());
            update_stmt.setBigDecimal(index++, data.getYearPnLLocal());
            update_stmt.setBigDecimal(index++, data.getYearPnLRpt());
            update_stmt.setString(index++, data.getMesureUnit() == null ? null : data.getMesureUnit().getId().toString());
            update_stmt.setBigDecimal(index++, data.getStabdardYearDebitQty() == null ? data.getYearDebitQty() : data.getStabdardYearDebitQty());
            update_stmt.setBigDecimal(index++, data.getStabdardYearCreditQty() == null ? data.getYearCreditQty() : data.getStabdardYearCreditQty());
            update_stmt.setBigDecimal(index++, data.getStabdardBeginQty() == null ? data.getBeginQty() : data.getStabdardBeginQty());
            update_stmt.setBigDecimal(index++, data.getStabdardEndQty() == null ? data.getEndQty() : data.getStabdardEndQty());
            update_stmt.setString(index++, orgunitid);
            update_stmt.setString(index++, accountid);
            update_stmt.setString(index++, hgId);
            update_stmt.setString(index++, currencyid);
            update_stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(update_stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)update_stmt, (Connection)con);
    }

    @Override
    protected IObjectValue _fillHGId(Context ctx, IObjectValue hg, String[] propNames) throws BOSException, EASBizException {
        return InitHelp.fillHGId(ctx, hg, propNames);
    }

    private IInitAssistBalance getInitAssistBalanceCtrl(Context ctx) throws BOSException {
        return InitAssistBalanceFactory.getLocalInstance(ctx);
    }

    private IGLFlag getFlagCtrl(Context ctx) throws BOSException {
        return GLFlagFactory.getLocalInstance(ctx);
    }

    @Override
    protected ArrayList _getCanClosedAndCancelAccounts(Context ctx, String asstAccountId, HashMap otherCtx) throws BOSException, EASBizException {
        ArrayList<Object> result = new ArrayList<Object>(4);
        try {
            LowTimer low = new LowTimer();
            low.reset();
            ArrayList allcolsed = this.getAllCloseAccount(ctx, otherCtx);
            low.reset();
            AccountViewCollection col = this.getAllAccount(ctx, asstAccountId, otherCtx);
            low.reset();
            AccountViewCollection canCloseInitAccount = new AccountViewCollection();
            AccountViewCollection cancelInitAccount = new AccountViewCollection();
            if (col != null && col.size() > 0) {
                for (int i = 0; i < col.size(); ++i) {
                    AccountViewInfo info = col.get(i);
                    if (allcolsed.contains(info.getId().toString())) {
                        cancelInitAccount.add(info);
                        continue;
                    }
                    canCloseInitAccount.add(info);
                }
            }
            result.add(canCloseInitAccount);
            result.add(cancelInitAccount);
            AccountViewCollection newCol = this.getAllCount(ctx, otherCtx);
            low.reset();
            boolean isAllClosed = true;
            boolean isNonClosed = true;
            if (newCol != null && newCol.size() > 0) {
                for (int i = 0; i < newCol.size(); ++i) {
                    AccountViewInfo info = newCol.get(i);
                    if (allcolsed.contains(info.getId().toString())) {
                        isNonClosed = false;
                        continue;
                    }
                    isAllClosed = false;
                }
            }
            result.add(isAllClosed);
            result.add(isNonClosed);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private AccountViewCollection getAllCount(Context ctx, HashMap otherCtx) throws BOSException, SQLException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttable = (String)otherCtx.get("ACCOUNTTABLEID");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)orgUnitId));
        if (!StringUtils.isEmpty((String)accounttable)) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accounttable));
        }
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        view.setSelector(selector);
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewCollection coll = av.getAccountViewCollection(view);
        HashSet<String> accountIds = new HashSet<String>();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            accountIds.add(((AccountViewInfo)it.next()).getId().toString());
        }
        PeriodInfo start = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(orgUnitId));
        Map<String, AsstAccountInfo> caas = GLAsstAccountUtils.getCAAs(ctx, accountIds, start.getId().toString(), null);
        HashSet<String> okAccountIds = new HashSet<String>();
        for (String id : accountIds) {
            AsstAccountInfo caa = caas.get(id);
            if (caa == null) continue;
            okAccountIds.add(id);
        }
        if (okAccountIds.size() == 0) {
            return new AccountViewCollection();
        }
        EntityViewInfo newView = new EntityViewInfo();
        FilterInfo newFilter = new FilterInfo();
        newFilter.getFilterItems().add(new FilterItemInfo("id", okAccountIds, CompareType.INCLUDE));
        newView.setFilter(newFilter);
        SelectorItemCollection sic = newView.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("accountTypeID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
        SorterItemCollection sorters = newView.getSorter();
        sorters.add(new SorterItemInfo("number"));
        AccountViewCollection newColl = av.getAccountViewCollection(newView);
        for (AccountViewInfo account : newColl) {
            account.setCAA(caas.get(account.getId().toString()));
        }
        return newColl;
    }

    private ArrayList getAllCloseAccount(Context ctx, HashMap otherCtx) throws BOSException, SQLException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttable = (String)otherCtx.get("ACCOUNTTABLEID");
        String sql = "select distinct fkey from t_gl_flag flag,t_BD_AccountView acc where flag.forgunitid=?  and flag.fname='astinit' and flag.fvalue='true' and acc.faccounttableid=? and acc.fid=flag.fkey and acc.fisleaf=1 and acc.fcompanyid=? and fname = 'astinit' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId, accounttable, orgUnitId});
        ArrayList<String> result = new ArrayList<String>();
        if (rs != null) {
            while (rs.next()) {
                result.add(rs.getString("fkey"));
            }
        }
        return result;
    }

    private AccountViewCollection getAllAccount(Context ctx, String asstAccountId, HashMap otherCtx) throws BOSException, EASBizException {
        String companyid = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
        String accountid = (String)otherCtx.get("Account");
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        PeriodInfo start = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyid));
        HashSet<String> accountIds = new HashSet<String>();
        if (!StringUtils.isEmpty((String)accountid)) {
            accountIds.add(accountid);
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyid));
            if (!StringUtils.isEmpty((String)accounttableid)) {
                filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accounttableid));
            }
            filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            view.setSelector(selector);
            AccountViewCollection coll = av.getAccountViewCollection(view);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                accountIds.add(((AccountViewInfo)it.next()).getId().toString());
            }
        }
        Map<String, AsstAccountInfo> caas = GLAsstAccountUtils.getCAAs(ctx, accountIds, start.getId().toString(), null);
        HashSet<String> okAccountIds = new HashSet<String>();
        for (String id : accountIds) {
            AsstAccountInfo caa = caas.get(id);
            if (caa == null || asstAccountId != null && !asstAccountId.equals(caa.getId().toString())) continue;
            okAccountIds.add(id);
        }
        if (okAccountIds.size() == 0) {
            return new AccountViewCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", okAccountIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("accountTypeID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        AccountViewCollection coll = av.getAccountViewCollection(view);
        for (AccountViewInfo account : coll) {
            account.setCAA(caas.get(account.getId().toString()));
        }
        return coll;
    }

    @Override
    protected void _closeAllInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        otherCtx.put("Account", null);
        IObjectCollection accounts = this._getCanCloseInitAccount(ctx, null, otherCtx);
        if (accounts == null || accounts.size() <= 0) {
            return;
        }
        this._closeInit(ctx, accounts, null, otherCtx);
    }

    @Override
    protected void _cancelAllInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        otherCtx.put("Account", null);
        IObjectCollection accounts = this._getCanCancelInitAccount(ctx, null, otherCtx);
        if (accounts == null || accounts.size() <= 0) {
            return;
        }
        this._cancelInit(ctx, accounts, null, otherCtx);
    }

    @Override
    protected IObjectCollection _getAssistInitDataFromAcct(Context ctx, IObjectValue ov, String currencyId, HashMap otherCtx) throws EASBizException, BOSException {
        InitAssistBalanceCollection result = new InitAssistBalanceCollection();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String orgUnitId = company.get(company.getPKField()).toString();
        String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
        AsstAccountInfo asstAccount = (AsstAccountInfo)ov;
        AsstActTypeCollection tcol = (AsstActTypeCollection)asstAccount.get("asstTypeCol");
        String accountid = otherCtx.get("curAccountid") != null ? otherCtx.get("curAccountid").toString() : null;
        IObjectCollection coll = this.getAccountFromAsstAccount(ctx, asstAccount.getId().toString(), orgUnitId, accounttableid, accountid, null);
        IAcctCussentInitFacade facade = AcctCussentInitFacadeFactory.getLocalInstance(ctx);
        CurrencyInfo currency = (CurrencyInfo)otherCtx.get("ALLCURRENCYID");
        InitAssistBalanceCollection acctObjCols = null;
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            AccountViewInfo accountInfo = (AccountViewInfo)coll.getObject(i);
            otherCtx.put("AsstInitImport", "AsstInitImport");
            AcctCussentCollection temp = facade.getCussentInitData(accountInfo, tcol, null, currency, otherCtx);
            if (temp == null) continue;
            acctObjCols = this.transAcctCussent2AssistBalance((IObjectCollection)temp, tcol, accountInfo, currency);
            result.addCollection(acctObjCols);
        }
        return result;
    }

    private InitAssistBalanceCollection transAcctCussent2AssistBalance(IObjectCollection acctObjCols, AsstActTypeCollection tcol, AccountViewInfo accountInfo, CurrencyInfo currency) throws EASBizException, BOSException {
        InitAssistBalanceCollection result = new InitAssistBalanceCollection();
        AcctCussentCollection col = (AcctCussentCollection)acctObjCols;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            AcctCussentInfo ac = (AcctCussentInfo)col.getObject(i);
            InitAssistBalanceInfo as = new InitAssistBalanceInfo();
            AssistantHGInfo hg = ac.getVchAssistRecord().getAssGrp();
            as.setAssistGrp(hg);
            as.setAccount(accountInfo);
            as.setCurrency(currency);
            BigDecimal amount = ac.getVchAssistRecord().getLocalAmount();
            BigDecimal report = ac.getVchAssistRecord().getReportingAmount();
            BigDecimal original = ac.getVchAssistRecord().getOriginalAmount();
            BigDecimal qty = ac.getVchAssistRecord().getQuantity();
            as.setBeginBalanceFor(original);
            as.setEndBalanceFor(original);
            as.setBeginBalanceLocal(amount);
            as.setEndBalanceLocal(amount);
            as.setBeginBalanceRpt(report);
            as.setEndBalanceRpt(report);
            as.setMesureUnit(ac.getVchAssistRecord().getMeasureUnit());
            as.setStabdardBeginQty(ac.getVchAssistRecord().getStandardQuantity());
            as.setStabdardEndQty(ac.getVchAssistRecord().getStandardQuantity());
            as.setBeginQty(qty);
            as.setEndQty(qty);
            result.add(as);
        }
        return result;
    }

    @Override
    protected void _clearData(Context ctx) throws BOSException {
    }

    @Override
    protected void _importAcBalance(Context ctx, AccountViewCollection actViewCol, CurrencyCollection currencyCol, Map otherCtx) throws BOSException, EASBizException {
        boolean isCover = otherCtx.get("isCover") == null ? false : (Boolean)otherCtx.get("isCover");
        otherCtx.remove("deleted");
        for (int i = 0; i < actViewCol.size(); ++i) {
            AccountViewInfo curAccount = actViewCol.get(i);
            for (int j = 0; j < currencyCol.size(); ++j) {
                otherCtx.put("curAccountid", curAccount.getId());
                CurrencyInfo curCur = currencyCol.get(j);
                otherCtx.put("ALLCURRENCYID", curCur);
                this.getAllTypeForAccountView(ctx, curAccount, otherCtx);
                otherCtx.put("curAsstAccountid", curAccount.getCAA().getId().toString());
                InitAssistBalanceCollection col = (InitAssistBalanceCollection)this._getAssistInitDataFromAcct(ctx, (IObjectValue)curAccount.getCAA(), curCur.getId().toString(), (HashMap)otherCtx);
                InitAssistBalanceCollection newcol = new InitAssistBalanceCollection();
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    InitAssistBalanceInfo as = (InitAssistBalanceInfo)it.next();
                    if (!curAccount.getId().toString().equalsIgnoreCase(as.getAccount().getId().toString())) continue;
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)as.getAccount().getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)as.getCurrency().getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("assistGrp.id", (Object)as.getAssistGrp().getId().toString()));
                    InitAssistBalanceCollection sourceColl = InitAssistBalanceFactory.getLocalInstance(ctx).getInitAssistBalanceCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null));
                    if (isCover) {
                        if (sourceColl != null && sourceColl.size() > 0) {
                            InitAssistBalanceInfo source = sourceColl.get(0);
                            as.setYearDebitFor(source.getYearDebitFor());
                            as.setYearDebitLocal(source.getYearDebitLocal());
                            as.setYearDebitRpt(source.getYearDebitRpt());
                            as.setYearDebitQty(source.getYearDebitQty());
                            as.setYearCreditFor(source.getYearCreditFor());
                            as.setYearCreditLocal(source.getYearCreditLocal());
                            as.setYearCreditRpt(source.getYearCreditRpt());
                            as.setYearCreditQty(source.getYearCreditQty());
                            as.setYearPnLFor(source.getYearPnLFor());
                            as.setYearPnLLocal(source.getYearPnLLocal());
                            as.setYearPnLRpt(source.getYearPnLRpt());
                            as.put("persist_status", "dirty");
                        } else {
                            as.put("persist_status", "new");
                        }
                    } else {
                        if (sourceColl != null && sourceColl.size() != 0) continue;
                        as.put("persist_status", "new");
                    }
                    as.setOrgUnit((CompanyOrgUnitInfo)otherCtx.get("COMPANY"));
                    newcol.add(as);
                }
                this._save(ctx, (IObjectCollection)newcol, (HashMap)otherCtx);
            }
        }
    }

    @Override
    protected List _checkDuplicate(Context ctx, Map paramMap) throws BOSException, EASBizException {
        int i;
        ArrayList<String> duplicate = new ArrayList<String>();
        List addList = (List)paramMap.get("addList");
        List deleteList = (List)paramMap.get("deleteList");
        String companyId = (String)paramMap.get("companyId");
        String accountId = (String)paramMap.get("accountId");
        String currencyId = (String)paramMap.get("currencyId");
        StringBuffer sql = new StringBuffer();
        sql.append("select FAssistGrpID from T_GL_InitAssistBalance where FOrgUnitID = ? and FAccountID = ? and FCurrencyID= ?");
        if (deleteList.size() > 0) {
            sql.append(" and FAssistGrpID not in (");
            for (i = 0; i < deleteList.size(); ++i) {
                if (i == 0) {
                    sql.append("'");
                } else {
                    sql.append(",'");
                }
                String delete = (String)deleteList.get(i);
                sql.append(delete);
                sql.append("'");
            }
            sql.append(") ");
        }
        if (addList.size() > 0) {
            sql.append(" and FAssistGrpID in (");
            for (i = 0; i < addList.size(); ++i) {
                if (i == 0) {
                    sql.append("'");
                } else {
                    sql.append(",'");
                }
                String add = (String)addList.get(i);
                sql.append(add);
                sql.append("'");
            }
            sql.append(") ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, accountId, currencyId});
        try {
            while (rs.next()) {
                duplicate.add(rs.getString("FAssistGrpID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return duplicate;
    }

    private void getAllTypeForAccountView(Context ctx, AccountViewInfo account, Map otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String orgUnitId = company.get(company.getPKField()).toString();
        PeriodInfo start = null;
        Map<Object, Object> caas = new HashMap();
        AsstAccountInfo asstAccount = null;
        start = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(orgUnitId));
        HashSet<String> accountIds = new HashSet<String>();
        accountIds.add(account.getId().toString());
        caas = GLAsstAccountUtils.getCAAs(ctx, accountIds, start.getId().toString(), null);
        if (caas == null || caas.size() == 0) {
            return;
        }
        asstAccount = (AsstAccountInfo)caas.get(account.getId().toString());
        if (asstAccount == null) {
            account.setCAA(null);
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo());
        selector.add(new SelectorItemInfo("asstAccount.id"));
        selector.add(new SelectorItemInfo("asstAccount.number"));
        selector.add(new SelectorItemInfo("asstAccount.name"));
        selector.add(new SelectorItemInfo("asstAccount.isQty"));
        selector.add(new SelectorItemInfo("asstAccount.measureUnit.id"));
        selector.add(new SelectorItemInfo("asstActType.measureUnitGroup.id"));
        selector.add(new SelectorItemInfo("asstActType.measureUnitGroup.name"));
        selector.add(new SelectorItemInfo("asstActType.measureUnitGroup.defaultUnit.id"));
        selector.add(new SelectorItemInfo("asstActType.measureUnitGroup.defaultUnit.name"));
        selector.add(new SelectorItemInfo("asstActType.name"));
        selector.add(new SelectorItemInfo("asstActType.number"));
        selector.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        selector.add(new SelectorItemInfo("asstActType.defaultQueryName"));
        selector.add(new SelectorItemInfo("asstActType.isForCompany"));
        selector.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        selector.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        selector.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        selector.add(new SelectorItemInfo("asstActType.isQty"));
        selector.add(new SelectorItemInfo("asstAccount.measureUnit.id"));
        selector.add(new SelectorItemInfo("asstAccount.measureUnit.coefficient"));
        selector.add(new SelectorItemInfo("asstAccount.measureUnit.name"));
        selector.add(new SelectorItemInfo("asstActType.measureUnitGroup.id"));
        selector.add(new SelectorItemInfo("asstActType.measureUnitGroup.defaultUnit.id"));
        selector.add(new SelectorItemInfo("asstActType.measureUnitGroup.defaultUnit.name"));
        selector.add(new SelectorItemInfo("asstActType.measureUnitGroup.defaultUnit.coefficient"));
        SorterItemCollection sorter = view.getSorter();
        sorter.add(new SorterItemInfo("seq"));
        sorter.add(new SorterItemInfo("asstAccount.number"));
        filter.appendFilterItem("asstAccount.id", (Object)asstAccount.getId().toString());
        AsstActGroupDetailCollection col = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        if (col == null || col.size() <= 0) {
            return;
        }
        HashMap cache = new HashMap();
        AsstActTypeCollection asstTypeCol = new AsstActTypeCollection();
        asstAccount.put("asstTypeCol", (Object)asstTypeCol);
        for (int i = 0; i < col.size(); ++i) {
            AsstActGroupDetailInfo detail = col.get(i);
            AsstActTypeInfo type = detail.getAsstActType();
            asstTypeCol.add(type);
        }
        account.setCAA(asstAccount);
    }

    @Override
    protected IObjectCollection _getInitedACAccount(Context ctx, Map paramMap) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("isInit", (Object)1, CompareType.EQUALS));
        if (paramMap.get("ISINITCLOSED") != null && ((Boolean)paramMap.get("ISINITCLOSED")).booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("isInitClosed", (Object)1, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)((String)paramMap.get("COMPANYID")), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("account.*"));
        view.setSelector(selector);
        AcctCussentCollection actCol = AcctCussentFactory.getLocalInstance(ctx).getAcctCussentCollection(view);
        AccountViewCollection col = new AccountViewCollection();
        if (actCol == null) {
            return null;
        }
        for (int i = 0; i < actCol.size(); ++i) {
            col.add(actCol.get(i).getAccount());
        }
        return col;
    }
}

