/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GLPeriodEndFilter;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractBaseVoucherControllerBean;
import com.kingdee.eas.fi.gl.app.voucher.IAntiAuditVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiCancelVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiCheckVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiPostVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAuditVoucherCollectionService;
import com.kingdee.eas.fi.gl.app.voucher.IAuditVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ICancelVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ICheckVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IDeleteVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IPostVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ISaveVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ISubmitVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ITransactVoucherColService;
import com.kingdee.eas.fi.gl.app.voucher.PreViewVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.TransactVoucherColParameter;
import com.kingdee.eas.fi.gl.app.voucher.VoucherServiceFactory;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.cslacct.CheckViewInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class BaseVoucherControllerBean
extends AbstractBaseVoucherControllerBean {
    private static final long serialVersionUID = 5643769600176691851L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.BaseVoucherControllerBean");
    protected static final String IS_REQUIRED_TRANSACTION = "isRequiredTransaction";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)model;
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, voucherInfo, "GL_VoucherSave");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        try {
            ISaveVoucherService service = this.getSaveVoucherService(ctx);
            IObjectPK iObjectPK = service.save(ctx, voucherInfo);
            return iObjectPK;
        }
        finally {
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isFromDAP;
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)model;
        voucherInfo.put("old_bizStatus", (Object)voucherInfo.getBizStatus());
        boolean bl = isFromDAP = SourceType.NONE == voucherInfo.getSourceType() || voucherInfo.getSourceType() == SourceType.OTHER_IMPORT || voucherInfo.getSourceBillId() != null;
        if (voucherInfo.getLocalCreditAmount() != null && new BigDecimal("0.00").compareTo(voucherInfo.getLocalCreditAmount()) < 0 && (voucherInfo.getEntries() == null || voucherInfo.getEntries().size() == 0) || isFromDAP && (voucherInfo.getEntries() == null || voucherInfo.getEntries().size() == 0)) {
            ObjectUuidPK pk = new ObjectUuidPK(voucherInfo.getId());
            voucherInfo = this.getInfo(ctx, (IObjectPK)pk);
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, voucherInfo, "GL_VoucherSubmit");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl2 = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        try {
            ISubmitVoucherService service = this.getSubmitVoucherService(ctx, voucherInfo);
            IObjectPK iObjectPK = service.submitVoucher(ctx, voucherInfo);
            return iObjectPK;
        }
        finally {
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectPK _submitVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = this.getInfo(ctx, pk);
        voucherInfo.put("old_bizStatus", (Object)voucherInfo.getBizStatus());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, voucherInfo, "GL_VoucherSubmit");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            voucherInfo.setPostedByUI(true);
            voucherInfo.setNotChanged(true);
            if (SourceType.NONE == voucherInfo.getSourceType() || voucherInfo.getSourceBillId() != null) {
                IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                BOTRelationCollection relations = iBTPManager.getRelationCollection(voucherInfo.getId().toString());
                IObjectPK iObjectPK = iBTPManager.submitRelations((CoreBillBaseInfo)voucherInfo, relations);
                return iObjectPK;
            }
            IObjectPK iObjectPK = this.submit(ctx, (CoreBaseInfo)voucherInfo);
            return iObjectPK;
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    @Override
    protected IObjectPK _submitVoucherNewTrans(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this._submitVoucher(ctx, pk);
    }

    @Override
    protected void _auditVoucher(Context ctx, IObjectPK pk, BOSUuid auditorId) throws BOSException, EASBizException {
        if (auditorId == null) {
            auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        }
        IAuditVoucherService service = this.getAuditVoucherServie(ctx);
        service.audit(ctx, pk, auditorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _antiAuditVoucher(Context ctx, IObjectPK pk, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            IAntiAuditVoucherService service = this.getAntiAuditService(ctx);
            service.antiAuditVoucher(ctx, pk, preStatus);
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _post(Context ctx, IObjectPK pk, Map checkViews) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this._getValue(ctx, pk, this.getPostSelector());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, voucherInfo, "GL_VoucherPost");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            IPostVoucherService service = this.getPostService(ctx, voucherInfo);
            service.postVoucher(ctx, voucherInfo, checkViews);
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _antiPostVoucher(Context ctx, IObjectPK pk, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this._getValue(ctx, pk, BaseVoucherInfo.getDefaultProcessSelector());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, voucherInfo, "GL_VoucherUnpost");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            IAntiPostVoucherService service = this.getAntiPostService(ctx);
            service.antiPostVoucher(ctx, voucherInfo, preStatus);
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    @Override
    protected void _autoAntiPostvoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._antiPostVoucher(ctx, pk, VoucherStatusEnum.AUDITTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _cancelVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this._getValue(ctx, pk, VoucherInfo.getDefaultProcessSelector());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, voucherInfo, "GL_VoucherDisable");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            ICancelVoucherService service = this.getCancelVoucherService(ctx);
            service.cancelVoucher(ctx, pk);
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _antiCancelVoucher(Context ctx, IObjectPK pk, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this._getValue(ctx, pk, VoucherInfo.getDefaultProcessSelector());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, voucherInfo, "GL_VoucherEnable");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            IAntiCancelVoucherService service = this.getAntiCancelVoucherService(ctx, voucherInfo);
            service.antiCancelVoucher(ctx, voucherInfo, preStatus);
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk, SystemEnum fromSys) throws BOSException, EASBizException {
        boolean isFromGL = SystemEnum.GENERALLEDGER.equals((Object)fromSys);
        this.delete(ctx, pk, isFromGL);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ObjectUpdateLock lock = mutexService.getObjectUpdateLock(pk.toString());
        if (lock != null) {
            throw new VoucherException(VoucherException.VOUCHER_IN_EDITING);
        }
        this.delete(ctx, pk, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(Context ctx, IObjectPK pk, boolean isFromGL) throws EASBizException, BOSException {
        BaseVoucherInfo voucherInfo = (BaseVoucherInfo)this._getValue(ctx, pk, VoucherInfo.getDefaultProcessSelector());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, voucherInfo, "GL_VoucherDelete");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            IDeleteVoucherService service = this.getDeleteVoucherService(ctx, voucherInfo);
            service.deleteVoucher(ctx, voucherInfo, isFromGL);
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    @Override
    protected String _getVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        String number = null;
        Throwable ex = null;
        try {
            this.addCtxParamOnNeed(ctx, voucherInfo);
            number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)voucherInfo, this.getOrgIDStr(voucherInfo), "bizStatus", "");
        }
        catch (BOSException e) {
            ex = e;
            throw e;
        }
        catch (CodingRuleException e) {
            String name = this.getCompanyName(voucherInfo);
            String message = e.getMessage();
            ex = e;
            throw new EASBizException(new NumericExceptionSubItem("101", name + message));
        }
        catch (EASBizException e) {
            ex = e;
            throw e;
        }
        finally {
            ctx.remove((Object)IS_REQUIRED_TRANSACTION);
            boolean isLogVoucherNumber = false;
            if (ctx.get((Object)"GL_VOUCHERNUMBER_LOG") != null) {
                isLogVoucherNumber = Boolean.valueOf(ctx.get((Object)"GL_VOUCHERNUMBER_LOG").toString());
            }
            if (isLogVoucherNumber) {
                this.logVoucherNumber(ctx, voucherInfo, number, "getNumber", (Exception)ex);
            }
        }
        return number;
    }

    private String getCompanyName(BaseVoucherInfo voucherInfo) {
        String name = "";
        try {
            PcVoucherInfo pcVoucherInfo = (PcVoucherInfo)voucherInfo;
            ProfitCenterOrgUnitInfo profitCenter = pcVoucherInfo.getProfitCenter();
            if (profitCenter != null) {
                name = profitCenter.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    protected void addCtxParamOnNeed(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        ctx.put((Object)IS_REQUIRED_TRANSACTION, (Object)"true");
    }

    @Override
    protected void _recycleVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        Throwable ex = null;
        try {
            this.addCtxParamOnNeed(ctx, voucherInfo);
            CodingRuleManagerFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)voucherInfo, this.getOrgIDStr(voucherInfo), "bizStatus", "", voucherNumber);
        }
        catch (BOSException e) {
            ex = e;
            throw e;
        }
        catch (EASBizException e) {
            ex = e;
            throw e;
        }
        finally {
            ctx.remove((Object)IS_REQUIRED_TRANSACTION);
            boolean isLogVoucherNumber = false;
            if (ctx.get((Object)"GL_VOUCHERNUMBER_LOG") != null) {
                isLogVoucherNumber = Boolean.valueOf(ctx.get((Object)"GL_VOUCHERNUMBER_LOG").toString());
            }
            if (isLogVoucherNumber) {
                this.logVoucherNumber(ctx, voucherInfo, voucherNumber, "recycleNumber", (Exception)ex);
            }
        }
    }

    @Override
    protected void _submitVoucherCollection(Context ctx, List voucherIdList) throws BOSException, EASBizException {
        if (voucherIdList == null || voucherIdList.size() == 0) {
            return;
        }
        ITransactVoucherColService service = this.getSubmitVoucherCollectionService();
        TransactVoucherColParameter parameterObject = new TransactVoucherColParameter(ctx, voucherIdList);
        service.transactVoucherCol(parameterObject);
    }

    @Override
    protected Map _submitVouchers(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return new HashMap();
        }
        ITransactVoucherColService service = this.getSubmitVoucherCollectionService();
        TransactVoucherColParameter parameterObject = new TransactVoucherColParameter(ctx, ids);
        return service.transactVouchers(parameterObject);
    }

    @Override
    protected void _auditVoucherCollection(Context ctx, List voucherIdList) throws BOSException, EASBizException {
        IAuditVoucherCollectionService service = this.getAuditVoucherCollectionServie(ctx);
        service.audit(ctx, voucherIdList);
    }

    @Override
    protected void _auditVoucherCollection(Context ctx, List voucherIdList, BOSUuid auditorId) throws BOSException, EASBizException {
        IAuditVoucherCollectionService service = this.getAuditVoucherCollectionServie(ctx);
        service.audit(ctx, voucherIdList, auditorId);
    }

    @Override
    protected void _postVoucherCollection(Context ctx, List pkList, Map checkViews) throws BOSException, EASBizException {
        ITransactVoucherColService service = this.getPostVoucherCollectionService();
        TransactVoucherColParameter parameterObject = new TransactVoucherColParameter(ctx, pkList);
        parameterObject.setCheckViews(checkViews);
        service.transactVoucherCol(parameterObject);
    }

    @Override
    protected void _antiCancelVoucherCollection(Context ctx, List voucherIdList, VoucherStatusEnum preStatus) throws BOSException, EASBizException {
        ITransactVoucherColService service = this.getAntiCancelVoucherCollectionService();
        TransactVoucherColParameter parameterObject = new TransactVoucherColParameter(ctx, voucherIdList);
        parameterObject.setPreStatus(preStatus);
        service.transactVoucherCol(parameterObject);
    }

    @Override
    protected void _deleteVoucherCollection(Context ctx, List voucherIdList, SystemEnum fromSys) throws BOSException, EASBizException {
        ITransactVoucherColService service = this.getDeleteVoucherCollectionService();
        TransactVoucherColParameter parameterObject = new TransactVoucherColParameter(ctx, voucherIdList);
        parameterObject.setSys(fromSys);
        service.transactVoucherCol(parameterObject);
    }

    @Override
    protected void _antiBgAndAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _antiBgAuditVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _antiCheckVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _antiCheckVoucherByEntry(Context ctx, IObjectPK entryPK) throws BOSException, EASBizException {
    }

    @Override
    protected void _autoPostVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK[] _batchSave(Context ctx, IObjectCollection voucherCols) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _bgAndAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _bgAuditVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _chechVoucherBatch(Context ctx, List pkList) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkACNoticeCorrelation(Context ctx, String vchId) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkVoucher(Context ctx, IObjectCollection journalCollection, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkVoucher(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkVoucherByEntries(Context ctx, Set idsset) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkVoucherByEntry(Context ctx, String entryId) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkVoucherByEntry(Context ctx, IObjectCollection coll, IObjectPK entrypk) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkVoucherCollection(Context ctx, List pkList) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _checkVoucherForAudit(Context ctx, IObjectPK id, String accountNumber, int entryDc, String settlementTypeNumber, BigDecimal amount, String comparetype) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _checkVoucherValidForChecking(Context ctx, String voucherId, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkVoucherValidForCheckingByEntry(Context ctx, String entryid, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteBySys(Context ctx, Vector vecPK, SystemEnum sys) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteFun(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteWebService(Context ctx, Vector vctPK, IObjectValue companyOrgUnitInfomation) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _existsCashOrBankAccount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected IObjectPK _exteriorSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectPK _exteriorSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected HashMap _fetchAllCustProp(Context ctx, Vector entryIds) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected BigDecimal _getAmoutBySettlement(Context ctx, IObjectPK id, String accountNUmber, int entryDc, String settlementNumber, BigDecimal amount, String compareType) throws BOSException {
        return null;
    }

    @Override
    protected String _getAvaiableVoucherNumber(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Collection _getReq(Context ctx, BOSUuid vchId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Collection _getReq(Context ctx, CheckViewInfo cond) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _getVoucherWithoutPermissionCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected boolean _hasVoucherInCurrentPeriod(Context ctx, BOSUuid prdId, SystemEnum sys) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _isAuditStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _isHandcraftVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _isNumberAccordRule(Context ctx, VoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _isPostStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _postCheckValid(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _postSingleVoucher(Context ctx, Map allParam, String vchid, int vchIndex) throws BOSException, EASBizException {
    }

    @Override
    protected void _postVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _postVoucherCollection(Context ctx, List pkList, GLPeriodEndFilter filter, Map checkViews) throws BOSException, EASBizException {
    }

    @Override
    protected void _postVoucherOneByOne(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected List _requisitionCheckData(Context ctx, String strPeriod, int unChecked, int checked) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectPK _reverseSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectPK _reverseSaveBatch(Context ctx, List pkList) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _setAuditStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _setCheckStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _setSubmitStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _submitAccountAdjustVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected boolean _unclosePeriod(Context ctx, IObjectValue model) throws BOSException {
        return false;
    }

    protected void logVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo, String number, String action, Exception ex) throws BOSException, EASBizException {
    }

    protected BaseVoucherInfo getInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected String getOrgIDStr(BaseVoucherInfo voucherInfo) {
        return voucherInfo.getCompany().getId().toString();
    }

    protected SelectorItemCollection getPostSelector() {
        return BaseVoucherInfo.getPostVoucherSelector();
    }

    protected ITransactVoucherColService getSubmitVoucherCollectionService() {
        return null;
    }

    protected IAuditVoucherCollectionService getAuditVoucherCollectionServie(Context ctx) throws BOSException {
        return null;
    }

    protected IAuditVoucherService getAuditVoucherServie(Context ctx) throws BOSException {
        return null;
    }

    protected IAntiAuditVoucherService getAntiAuditService(Context ctx) throws BOSException {
        return null;
    }

    protected IPostVoucherService getPostService(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        return null;
    }

    protected IAntiPostVoucherService getAntiPostService(Context ctx) throws BOSException {
        return null;
    }

    protected ICancelVoucherService getCancelVoucherService(Context ctx) throws BOSException {
        return null;
    }

    protected IAntiCancelVoucherService getAntiCancelVoucherService(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        return null;
    }

    protected ITransactVoucherColService getAntiCancelVoucherCollectionService() {
        return VoucherServiceFactory.getAntiCancelVoucherCollectionService();
    }

    protected ITransactVoucherColService getPostVoucherCollectionService() {
        return VoucherServiceFactory.getPostVoucherCollectionService();
    }

    protected IDeleteVoucherService getDeleteVoucherService(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        return null;
    }

    protected ITransactVoucherColService getDeleteVoucherCollectionService() {
        return null;
    }

    protected ISaveVoucherService getSaveVoucherService(Context ctx) throws BOSException {
        return null;
    }

    protected ISubmitVoucherService getSubmitVoucherService(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException {
        return null;
    }

    protected IAntiCheckVoucherService getAntiCheckVoucherService(Context ctx) throws BOSException {
        return null;
    }

    protected MutexParameter buildModifyMutexParameter(Context ctx, BaseVoucherInfo voucherInfo, String actionResName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void previewVoucher(Context ctx, BaseVoucherInfo model) throws BOSException, EASBizException {
        BaseVoucherInfo voucherInfo = model;
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = this.buildModifyMutexParameter(ctx, voucherInfo, "GL_VoucherSave");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
            }
        }
        try {
            new PreViewVoucherService(ctx).save(ctx, voucherInfo);
        }
        finally {
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    protected ICheckVoucherService getCheckVoucherService(Context ctx) throws BOSException {
        return null;
    }

    @Override
    protected IObjectValue _getVoucherWithoutPermissionCheck(Context ctx, IObjectPK pk, SelectorItemCollection selectors) throws BOSException, EASBizException {
        return null;
    }
}

