/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryDefaultInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CussentStatusEnum;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.common.LicenseChecker;
import com.kingdee.eas.fi.gl.cslacct.ReqStatusEnum;
import com.kingdee.eas.framework.ObjectBaseInfo;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BudgetConstrastProcessor {
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
    private Map<String, Object> asstActObjects = new HashMap<String, Object>();
    private Map<String, AssistantHGInfo> assistantHGs = new HashMap<String, AssistantHGInfo>();
    private Map<String, AssistantHGInfo> oldAssistantHGs = new HashMap<String, AssistantHGInfo>();
    private Map<String, CurrencyInfo> currencys = new HashMap<String, CurrencyInfo>();
    private Map<String, MeasureUnitInfo> caaMeasureUnits = new HashMap<String, MeasureUnitInfo>();
    DateFormat df = DateFormat.getDateInstance(1, Locale.CHINA);
    protected HashMap hmLocalExchangeRate = new HashMap();
    protected HashMap hmReportingExchangeRate = new HashMap();
    protected Map exmap = new HashMap();
    public static final BigDecimal zero = GlUtils.pointzero;
    static final int AMOUNT_ROUND_MODE = 4;

    public static String getAccountRefConstrastId(Context ctx, String companyId, String tableId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledAcctTable", (Object)tableId));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("refType", (Object)4));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("oldAcct.id"));
        view.setSelector(sic);
        AccountRefContrastCollection col = AccountRefContrastFactory.getLocalInstance((Context)ctx).getAccountRefContrastCollection(view);
        if (col.size() > 0) {
            return col.get(0).getId().toString();
        }
        return null;
    }

    private Map<String, AccountRefContrastEntryInfo> getAccountRefConstrast(Context ctx, String constrastId, Set<String> accountIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("acctRefContrast.id", (Object)constrastId));
        filter.getFilterItems().add(new FilterItemInfo("oldAcct.id", accountIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("oldAcct.id"));
        sic.add(new SelectorItemInfo("newAcct.id"));
        sic.add(new SelectorItemInfo("defaultEntry.*"));
        view.setSelector(sic);
        HashMap<String, AccountRefContrastEntryInfo> contrasts = new HashMap<String, AccountRefContrastEntryInfo>();
        AccountRefContrastEntryCollection col = AccountRefContrastEntryFactory.getLocalInstance((Context)ctx).getAccountRefContrastEntryCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            contrasts.put(col.get(i).getOldAcct().getId().toString(), col.get(i));
        }
        return contrasts;
    }

    public List<VoucherEntryInfo> process(Context ctx, VoucherInfo voucher, String constrastId, Map<String, Object> params) throws BOSException, EASBizException, SQLException {
        SelectorItemCollection selector;
        FilterInfo filter;
        EntityViewInfo view;
        ArrayList<VoucherEntryInfo> budgetEntries = new ArrayList<VoucherEntryInfo>();
        HashMap<String, AccountViewInfo> financeAccounts = new HashMap<String, AccountViewInfo>();
        HashMap<String, AccountViewInfo> budgetAccounts = new HashMap<String, AccountViewInfo>();
        LicenseChecker.check(ctx);
        HashSet<String> existFinanceAccountIds = new HashSet<String>();
        HashSet<String> existBudgetAccountIds = new HashSet<String>();
        for (int i = 0; i < voucher.getEntries().size(); ++i) {
            VoucherEntryInfo entry = voucher.getEntries().get(i);
            AccountViewInfo account = entry.getAccount();
            if (account == null) continue;
            String accountId = account.getId().toString();
            if (account.isBudget()) {
                existBudgetAccountIds.add(accountId);
            } else {
                existFinanceAccountIds.add(accountId);
                financeAccounts.put(accountId, account);
            }
            CurrencyInfo currency = entry.getCurrency();
            if (currency == null) continue;
            this.currencys.put(currency.getId().toString(), currency);
        }
        if (existFinanceAccountIds.size() == 0) {
            return budgetEntries;
        }
        String companyId = voucher.getCompany().getId().toString();
        String tableId = voucher.getCompany().getAccountTable().getId().toString();
        if (constrastId == null) {
            constrastId = BudgetConstrastProcessor.getAccountRefConstrastId(ctx, companyId, tableId);
        }
        if (constrastId == null) {
            return budgetEntries;
        }
        Map<String, AccountRefContrastEntryInfo> contrasts = this.getAccountRefConstrast(ctx, constrastId, existFinanceAccountIds);
        if (contrasts.size() == 0) {
            return budgetEntries;
        }
        HashSet<String> contrastFinanceAccountIds = new HashSet<String>();
        HashSet<String> contrastBudgetAccountIds = new HashSet<String>();
        for (String contrastFinanceAccountId : contrasts.keySet()) {
            contrastFinanceAccountIds.add(contrastFinanceAccountId);
            AccountRefContrastEntryInfo contrast = contrasts.get(contrastFinanceAccountId);
            String contrastBudgetAccountId = contrast.getNewAcct().getId().toString();
            contrastBudgetAccountIds.add(contrastBudgetAccountId);
        }
        if (contrastFinanceAccountIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", contrastFinanceAccountIds, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = new SelectorItemCollection();
            selector.add("accountingcurrency");
            selector.add("accountCurrency.id");
            selector.add("accountCurrency.currency");
            selector.add("accountCurrency.currency.id");
            selector.add("measureUnitGroupID.id");
            view.setSelector(selector);
            AccountViewCollection coll = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                AccountViewInfo info = coll.get(i);
                AccountViewInfo account = (AccountViewInfo)financeAccounts.get(info.getId().toString());
                if (account == null) continue;
                account.setAccountingcurrency(info.getAccountingcurrency());
                account.put("accountCurrency", (Object)info.getAccountCurrency());
                if (account.getMeasureUnitGroupID() != null) continue;
                account.setMeasureUnitGroupID(info.getMeasureUnitGroupID());
            }
        }
        if (contrastBudgetAccountIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", contrastBudgetAccountIds, CompareType.INCLUDE));
            view.setFilter(filter);
            selector = new SelectorItemCollection();
            String prefix = "entries.account.";
            SelectorItemCollection voucherSelector = VoucherInfo.getDefaultSelector2((boolean)false, (boolean)false, (boolean)false);
            for (int i = 0; i < voucherSelector.size(); ++i) {
                String name = voucherSelector.get(i).getPropertyName();
                if (!name.startsWith(prefix)) continue;
                String field = name.substring(prefix.length());
                selector.add(field);
            }
            selector.add("accountingcurrency");
            selector.add("accountCurrency.id");
            selector.add("accountCurrency.currency");
            selector.add("accountCurrency.currency.id");
            selector.add("measureUnitID.id");
            selector.add("measureUnitID.name");
            selector.add("measureUnitID.coefficient");
            view.setSelector(selector);
            AccountViewCollection coll = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                budgetAccounts.put(coll.get(i).getId().toString(), coll.get(i));
            }
        }
        Map<Object, Object> caas = new HashMap();
        HashSet<String> contrastAccountIds = new HashSet<String>();
        contrastAccountIds.addAll(contrastFinanceAccountIds);
        contrastAccountIds.addAll(contrastBudgetAccountIds);
        if (contrastAccountIds.size() > 0) {
            caas = GLAsstAccountUtils.getCAAs(ctx, contrastAccountIds, voucher.getPeriod().getId().toString(), null);
        }
        for (int i = 0; i < voucher.getEntries().size(); ++i) {
            VoucherAssistRecordInfo record;
            int j;
            AccountViewInfo budgetAccount;
            String budgetAccountId;
            String financeAccountId;
            AccountRefContrastEntryInfo contrast;
            AccountViewInfo account;
            VoucherEntryInfo entry = voucher.getEntries().get(i);
            if (entry.getAccount() == null || (account = entry.getAccount()).isBudget() || (contrast = contrasts.get(financeAccountId = entry.getAccount().getId().toString())) == null || existBudgetAccountIds.contains(budgetAccountId = contrast.getNewAcct().getId().toString()) || (budgetAccount = (AccountViewInfo)budgetAccounts.get(budgetAccountId)) == null) continue;
            account.setCAA((AsstAccountInfo)caas.get(account.getId().toString()));
            budgetAccount.setCAA((AsstAccountInfo)caas.get(budgetAccount.getId().toString()));
            VoucherEntryInfo budgetEntry = new VoucherEntryInfo();
            budgetEntries.add(budgetEntry);
            budgetEntry.putAll((IObjectValue)entry);
            budgetEntry.setIsHand(true);
            budgetEntry.setId(null);
            budgetEntry.setOprStatus(1);
            budgetEntry.setCussent(CussentStatusEnum.NONE);
            budgetEntry.setAccount(budgetAccount);
            budgetEntry.setCAA(budgetAccount.getCAA());
            VoucherAssistRecordCollection records = new VoucherAssistRecordCollection();
            budgetEntry.put("assistRecords", (Object)records);
            if (budgetAccount.getCAA() != null) {
                if (account.getCAA() == null) {
                    VoucherAssistRecordInfo record2 = new VoucherAssistRecordInfo();
                    record2.setEntry(budgetEntry);
                    record2.setId(null);
                    record2.setVerifiedCussent(null);
                    record2.setReqCheckStatus(ReqStatusEnum.UNCHECKED);
                    record2.put("verify_cussent_id", null);
                    record2.setOprStatus(1);
                    record2.setBizDate(voucher.getBizDate());
                    record2.setEndDate(voucher.getBizDate());
                    record2.setDescription(budgetEntry.getDescription());
                    record2.setOriginalAmount(budgetEntry.getOriginalAmount());
                    record2.setLocalAmount(budgetEntry.getLocalAmount());
                    record2.setReportingAmount(budgetEntry.getReportingAmount());
                    record2.setQuantity(budgetEntry.getQuantity());
                    record2.setStandardQuantity(budgetEntry.getStandardQuantity());
                    AsstActTypeCollection coll = this.getAsstActTypes(ctx, budgetAccount.getCAA().getId().toString());
                    HashMap<String, AsstActTypeInfo> asstActTypes = new HashMap<String, AsstActTypeInfo>();
                    for (int j2 = 0; j2 < coll.size(); ++j2) {
                        asstActTypes.put(coll.get(j2).getId().toString(), coll.get(j2));
                    }
                    HashMap<AsstActTypeInfo, Object> defaultVal = new HashMap<AsstActTypeInfo, Object>();
                    for (int j3 = 0; j3 < contrast.getDefaultEntry().size(); ++j3) {
                        AccountRefContrastEntryDefaultInfo contrastDdefault = contrast.getDefaultEntry().get(j3);
                        if (contrastDdefault.getAsstActType() == null || contrastDdefault.getDefaultId() == null) continue;
                        AsstActTypeInfo asstActType = (AsstActTypeInfo)asstActTypes.get(contrastDdefault.getAsstActType().getId().toString());
                        Object value = this.findAsstActObject(ctx, asstActType.getAsstHGAttribute(), contrastDdefault.getDefaultId().toString());
                        defaultVal.put(asstActType, value);
                    }
                    AssistantHGInfo hg = this.getAssistantHg(ctx, budgetAccount.getCAA(), null, defaultVal);
                    record2.setAssGrp(hg);
                    records.add(record2);
                } else if (budgetAccount.getCAA().getId().equals((Object)account.getCAA().getId())) {
                    for (int j4 = 0; j4 < entry.getAssistRecords().size(); ++j4) {
                        VoucherAssistRecordInfo record3 = new VoucherAssistRecordInfo();
                        record3.putAll((IObjectValue)entry.getAssistRecords().get(j4));
                        record3.setEntry(budgetEntry);
                        record3.setId(null);
                        record3.setVerifiedCussent(null);
                        record3.setReqCheckStatus(ReqStatusEnum.UNCHECKED);
                        record3.put("verify_cussent_id", null);
                        record3.setOprStatus(1);
                        records.add(record3);
                    }
                } else {
                    AsstActTypeCollection coll = this.getAsstActTypes(ctx, budgetAccount.getCAA().getId().toString());
                    HashMap<String, AsstActTypeInfo> asstActTypes = new HashMap<String, AsstActTypeInfo>();
                    for (j = 0; j < coll.size(); ++j) {
                        asstActTypes.put(coll.get(j).getId().toString(), coll.get(j));
                    }
                    HashMap<AsstActTypeInfo, Object> defaultVal = new HashMap<AsstActTypeInfo, Object>();
                    for (int j5 = 0; j5 < contrast.getDefaultEntry().size(); ++j5) {
                        AccountRefContrastEntryDefaultInfo contrastDdefault = contrast.getDefaultEntry().get(j5);
                        if (contrastDdefault.getAsstActType() == null || contrastDdefault.getDefaultId() == null) continue;
                        AsstActTypeInfo asstActType = (AsstActTypeInfo)asstActTypes.get(contrastDdefault.getAsstActType().getId().toString());
                        Object value = this.findAsstActObject(ctx, asstActType.getAsstHGAttribute(), contrastDdefault.getDefaultId().toString());
                        defaultVal.put(asstActType, value);
                    }
                    Map<String, AssistantHGInfo> oldHgs = this.getOldAssistantHgs(ctx, account.getCAA(), entry.getAssistRecords());
                    for (int j6 = 0; j6 < entry.getAssistRecords().size(); ++j6) {
                        VoucherAssistRecordInfo record4 = new VoucherAssistRecordInfo();
                        record4.putAll((IObjectValue)entry.getAssistRecords().get(j6));
                        record4.setEntry(budgetEntry);
                        record4.setId(null);
                        record4.setVerifiedCussent(null);
                        record4.setReqCheckStatus(ReqStatusEnum.UNCHECKED);
                        record4.put("verify_cussent_id", null);
                        record4.setOprStatus(1);
                        AssistantHGInfo oldHg = entry.getAssistRecords().get(j6).getAssGrp();
                        if (oldHg != null) {
                            oldHg = oldHgs.get(oldHg.getId().toString());
                        }
                        AssistantHGInfo hg = this.getAssistantHg(ctx, budgetAccount.getCAA(), oldHg, defaultVal);
                        record4.setAssGrp(hg);
                        records.add(record4);
                    }
                }
            }
            String baseCurrencyId = voucher.getCompany().getBaseCurrency().getId().toString();
            String targetCurrencyId = null;
            if (AccountingCurrencyEnum.ALLCURRENCY.equals((Object)budgetAccount.getAccountingcurrency())) {
                targetCurrencyId = entry.getCurrency().getId().toString();
            } else if (AccountingCurrencyEnum.NOCURRENCY.equals((Object)budgetAccount.getAccountingcurrency())) {
                targetCurrencyId = baseCurrencyId;
            } else if (AccountingCurrencyEnum.ONECURRENCY.equals((Object)budgetAccount.getAccountingcurrency())) {
                int j7;
                for (j7 = 0; j7 < budgetAccount.getAccountCurrency().size(); ++j7) {
                    if (!budgetAccount.getAccountCurrency().get(j7).getCurrency().getId().equals((Object)entry.getCurrency().getId())) continue;
                    targetCurrencyId = entry.getCurrency().getId().toString();
                    break;
                }
                if (targetCurrencyId == null) {
                    for (j7 = 0; j7 < budgetAccount.getAccountCurrency().size(); ++j7) {
                        if (!budgetAccount.getAccountCurrency().get(j7).getCurrency().getId().equals((Object)baseCurrencyId)) continue;
                        targetCurrencyId = baseCurrencyId;
                        break;
                    }
                }
                if (targetCurrencyId == null && budgetAccount.getAccountCurrency().size() > 0) {
                    targetCurrencyId = budgetAccount.getAccountCurrency().get(0).getCurrency().getId().toString();
                }
                if (targetCurrencyId == null) {
                    targetCurrencyId = baseCurrencyId;
                }
            }
            if (entry.getCurrency().getId().toString().equals(targetCurrencyId)) {
                System.out.println();
            } else if (baseCurrencyId.equals(targetCurrencyId)) {
                budgetEntry.setCurrency(this.getCurrency(ctx, targetCurrencyId));
                budgetEntry.setOriginalAmount(budgetEntry.getLocalAmount());
                budgetEntry.setLocalExchangeRate(GlUtils.one);
                if (budgetAccount.getCAA() != null) {
                    for (int j8 = 0; j8 < budgetEntry.getAssistRecords().size(); ++j8) {
                        VoucherAssistRecordInfo record5 = budgetEntry.getAssistRecords().get(j8);
                        record5.setOriginalAmount(record5.getLocalAmount());
                    }
                }
            } else {
                budgetEntry.setCurrency(this.getCurrency(ctx, targetCurrencyId));
                VoucherInfo.ExchangeRateWithValue ex = this.getCachedLocalExchangeRate(ctx, voucher, targetCurrencyId, params);
                if (ex != null) {
                    int precision;
                    if (ex.getPresion() > 0) {
                        precision = ex.getPresion();
                    } else {
                        boolean useReportingCurrency = (Boolean)params.get("useReportingCurrency");
                        precision = this.getEx(voucher.getCompany(), budgetEntry.getCurrency(), voucher.getCompany().getBaseCurrency(), useReportingCurrency);
                    }
                    BigDecimal exValue = ex.getValue();
                    exValue = GlUtils.setScale(exValue, precision);
                    BigDecimal amnt = this.computeAmnt(budgetEntry.getLocalAmount(), ex, exValue, budgetEntry.getCurrency());
                    budgetEntry.setOriginalAmount(amnt);
                    budgetEntry.setLocalExchangeRate(exValue);
                    if (budgetAccount.getCAA() != null) {
                        BigDecimal total = zero;
                        for (int j9 = 0; j9 < budgetEntry.getAssistRecords().size(); ++j9) {
                            record = budgetEntry.getAssistRecords().get(j9);
                            amnt = this.computeAmnt(record.getLocalAmount(), ex, exValue, budgetEntry.getCurrency());
                            record.setOriginalAmount(amnt);
                            total = total.add(amnt);
                        }
                        budgetEntry.setOriginalAmount(total);
                    }
                }
            }
            if (budgetAccount.isIsQty()) {
                boolean isQtyByAcct = (Boolean)params.get("isQtyByAcct");
                int quantityPrecision = (Integer)params.get("quantityPrecision");
                int QUANTITY_ROUND_MODE = (Integer)params.get("QUANTITY_ROUND_MODE");
                int pricePrecision = (Integer)params.get("pricePrecision");
                int DEFAULT_ROUND_MODE = (Integer)params.get("DEFAULT_ROUND_MODE");
                if (isQtyByAcct && budgetAccount.getCAA() != null && budgetAccount.getCAA().isIsQty()) {
                    if (account.isIsQty() && account.getCAA() != null && account.getCAA().isIsQty()) {
                        if (budgetAccount.getCAA().getMeasureUnitGroup() == null || budgetAccount.getCAA().getMeasureUnitGroup() != null && account.getCAA().getMeasureUnitGroup() != null && budgetAccount.getCAA().getMeasureUnitGroup().getId().equals((Object)account.getCAA().getMeasureUnitGroup().getId())) continue;
                        budgetEntry.setMeasureUnit(null);
                        BigDecimal tQuantity = zero;
                        BigDecimal tStandardQuantity = zero;
                        for (int j10 = 0; j10 < budgetEntry.getAssistRecords().size(); ++j10) {
                            MeasureUnitInfo unit;
                            VoucherAssistRecordInfo record6 = budgetEntry.getAssistRecords().get(j10);
                            if (!(record6.getMeasureUnit() != null && record6.getMeasureUnit().getMeasureUnitGroup() != null && record6.getMeasureUnit().getMeasureUnitGroup().getId().equals((Object)budgetAccount.getCAA().getMeasureUnitGroup().getId()) || (unit = this.getCAAMeasureUnitInfo(ctx, budgetAccount.getCAA())) == null)) {
                                record6.setMeasureUnit(unit);
                                BigDecimal standardQuantity = record6.getStandardQuantity();
                                if (standardQuantity == null || standardQuantity.compareTo(zero) == 0) {
                                    standardQuantity = GlUtils.one;
                                    record6.setStandardQuantity(standardQuantity);
                                }
                                BigDecimal qty = standardQuantity.divide(unit.getCoefficient(), quantityPrecision, QUANTITY_ROUND_MODE);
                                record6.setQuantity(qty);
                                record6.setPrice(record6.getOriginalAmount().divide(qty, pricePrecision, DEFAULT_ROUND_MODE));
                            }
                            tQuantity = tQuantity.add(record6.getQuantity());
                            tStandardQuantity = tStandardQuantity.add(record6.getStandardQuantity());
                        }
                        budgetEntry.setQuantity(tQuantity);
                        budgetEntry.setStandardQuantity(tStandardQuantity);
                        continue;
                    }
                    budgetEntry.setMeasureUnit(null);
                    budgetEntry.setQuantity(zero);
                    budgetEntry.setStandardQuantity(zero);
                    budgetEntry.setPrice(zero);
                    for (int j11 = 0; j11 < budgetEntry.getAssistRecords().size(); ++j11) {
                        record = budgetEntry.getAssistRecords().get(j11);
                        record.setMeasureUnit(null);
                        record.setQuantity(zero);
                        record.setStandardQuantity(zero);
                        record.setPrice(zero);
                    }
                    continue;
                }
                if (account.isIsQty()) {
                    if (budgetAccount.getMeasureUnitGroupID() != null && account.getMeasureUnitGroupID() != null && budgetAccount.getMeasureUnitGroupID().getId().equals((Object)account.getMeasureUnitGroupID().getId())) continue;
                    budgetEntry.setMeasureUnit(null);
                    budgetEntry.setQuantity(zero);
                    budgetEntry.setStandardQuantity(zero);
                    budgetEntry.setPrice(zero);
                    for (int j12 = 0; j12 < budgetEntry.getAssistRecords().size(); ++j12) {
                        record = budgetEntry.getAssistRecords().get(j12);
                        record.setMeasureUnit(null);
                        record.setQuantity(zero);
                        record.setStandardQuantity(zero);
                        record.setPrice(zero);
                    }
                    continue;
                }
                budgetEntry.setMeasureUnit(null);
                budgetEntry.setQuantity(zero);
                budgetEntry.setStandardQuantity(zero);
                budgetEntry.setPrice(zero);
                for (int j13 = 0; j13 < budgetEntry.getAssistRecords().size(); ++j13) {
                    record = budgetEntry.getAssistRecords().get(j13);
                    record.setMeasureUnit(null);
                    record.setQuantity(zero);
                    record.setStandardQuantity(zero);
                    record.setPrice(zero);
                }
                continue;
            }
            budgetEntry.setMeasureUnit(null);
            budgetEntry.setQuantity(zero);
            budgetEntry.setStandardQuantity(zero);
            budgetEntry.setPrice(zero);
            for (j = 0; j < budgetEntry.getAssistRecords().size(); ++j) {
                VoucherAssistRecordInfo record7 = budgetEntry.getAssistRecords().get(j);
                record7.setMeasureUnit(null);
                record7.setQuantity(zero);
                record7.setStandardQuantity(zero);
                record7.setPrice(zero);
            }
        }
        return budgetEntries;
    }

    private AsstActTypeCollection getAsstActTypes(Context ctx, String caaId) throws BOSException {
        if (this.asstActTypess.containsKey(caaId)) {
            return this.asstActTypess.get(caaId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        this.asstActTypess.put(caaId, asstActTypes);
        return asstActTypes;
    }

    private Object findAsstActObject(Context ctx, String asstHGAttribute, String id) throws BOSException {
        String key = asstHGAttribute + "_" + id;
        if (this.asstActObjects.containsKey(key)) {
            return this.asstActObjects.get(key);
        }
        ObjectBaseInfo value = GlWebServiceUtil.findAsstActObject(ctx, asstHGAttribute, id);
        this.asstActObjects.put(key, value);
        return value;
    }

    private Map<String, AssistantHGInfo> getOldAssistantHgs(Context ctx, AsstAccountInfo caa, VoucherAssistRecordCollection records) throws BOSException {
        HashSet<String> hgIds = new HashSet<String>();
        for (int i = 0; i < records.size(); ++i) {
            VoucherAssistRecordInfo record = records.get(i);
            if (record.getAssGrp() == null) continue;
            hgIds.add(record.getAssGrp().getId().toString());
        }
        return this.getOldAssistantHgs(ctx, caa.getId().toString(), hgIds);
    }

    private Map<String, AssistantHGInfo> getOldAssistantHgs(Context ctx, String caa, Set<String> oldHgIds) throws BOSException {
        HashSet<String> hgIds = new HashSet<String>();
        for (String oldHgId : oldHgIds) {
            if (this.oldAssistantHGs.containsKey(oldHgId)) continue;
            hgIds.add(oldHgId);
        }
        if (hgIds.size() <= 0) {
            return this.oldAssistantHGs;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("asstAccount.id"));
        AsstActTypeCollection asstActTypeList = this.getAsstActTypes(ctx, caa);
        if (asstActTypeList != null && asstActTypeList.size() > 0) {
            for (int i = 0; i < asstActTypeList.size(); ++i) {
                AsstActTypeInfo asstActType = asstActTypeList.get(i);
                String attr = asstActType.getAsstHGAttribute();
                selectors.add(attr + ".id");
                selectors.add(attr + ".name");
                if ("provider".equals(attr) || "customer".equals(attr)) {
                    selectors.add(attr + ".browseGroup.displayName");
                } else if ("material".equals(asstActType.getAsstHGAttribute())) {
                    selectors.add(attr + ".materialGroup.displayName");
                } else if (asstActType.isIsMultilevel()) {
                    selectors.add(attr + ".displayName");
                }
                selectors.add(attr + ".number");
            }
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", hgIds, CompareType.INCLUDE));
        IAssistantHG assistanthg = AssistantHGFactory.getLocalInstance((Context)ctx);
        AssistantHGCollection assistantHgColl = assistanthg.getAssistantHGCollection(view);
        for (int i = 0; i < assistantHgColl.size(); ++i) {
            AssistantHGInfo hg = assistantHgColl.get(i);
            String hgFid = hg.getId().toString();
            this.oldAssistantHGs.put(hgFid, assistantHgColl.get(i));
        }
        return this.oldAssistantHGs;
    }

    private AssistantHGInfo getAssistantHg(Context ctx, AsstAccountInfo item, AssistantHGInfo oldHgInfo, Map<AsstActTypeInfo, Object> defaultVal) throws EASBizException, BOSException, SQLException {
        AssistantHGInfo hgInfo = new AssistantHGInfo();
        hgInfo.setId(null);
        hgInfo.setAsstAccount(item);
        int count = 0;
        for (AsstActTypeInfo asstActType : defaultVal.keySet()) {
            String asstHGAttribute = asstActType.getAsstHGAttribute();
            if (defaultVal.get(asstActType) == null) continue;
            hgInfo.put(asstHGAttribute, defaultVal.get(asstActType));
            ++count;
        }
        AsstActTypeCollection asstActTypes = this.getAsstActTypes(ctx, item.getId().toString());
        if (oldHgInfo != null) {
            for (int i = 0; i < asstActTypes.size(); ++i) {
                String asstHGAttribute = asstActTypes.get(i).getAsstHGAttribute();
                Object value = oldHgInfo.get(asstHGAttribute);
                if (value == null) continue;
                hgInfo.put(asstHGAttribute, value);
                ++count;
            }
        }
        if (count <= 0) {
            return null;
        }
        hgInfo = this.findAssistantHG(ctx, item, asstActTypes, hgInfo);
        return hgInfo;
    }

    public CurrencyInfo getCurrency(Context ctx, String currencyId) throws EASBizException, BOSException {
        if (this.currencys.containsKey(currencyId)) {
            return this.currencys.get(currencyId);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("precision");
        selector.add("isoCode");
        selector.add("deletedStatus");
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId), selector);
        this.currencys.put(currencyId, currency);
        return currency;
    }

    public AssistantHGInfo findAssistantHG(Context ctx, AsstAccountInfo caa, AsstActTypeCollection types, AssistantHGInfo inHg) throws BOSException, EASBizException {
        String key = caa.getId().toString();
        for (int i = 0; i < types.size(); ++i) {
            AsstActTypeInfo type = types.get(i);
            String attr = type.getAsstHGAttribute();
            ObjectBaseInfo dataInfo = (ObjectBaseInfo)inHg.get(attr);
            String id = dataInfo == null ? "noneid" : dataInfo.getId().toString();
            key = key + "_" + attr + "_" + id;
        }
        if (this.assistantHGs.containsKey(key)) {
            return this.assistantHGs.get(key);
        }
        AssistantHGInfo info = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(inHg, caa.getId().toString(), types);
        info.setAsstAccount(caa);
        this.assistantHGs.put(key, info);
        return info;
    }

    public VoucherInfo.ExchangeRateWithValue getCachedLocalExchangeRate(Context ctx, VoucherInfo voucher, String orgCurId, Map<String, Object> params) throws EASBizException, BOSException {
        CurrencyInfo localCurrency = voucher.getCompany().getBaseCurrency();
        CurrencyInfo reportingCurrency = voucher.getCompany().getReportCurrency();
        boolean foreignCurrencySU = (Boolean)params.get("foreignCurrencySU");
        String lexTableId = (String)params.get("lexTableId");
        String rexTableId = (String)params.get("rexTableId");
        boolean isByBizDate = (Boolean)params.get("isByBizDate");
        boolean exchangeRateMustSameDate = (Boolean)params.get("exchangeRateMustSameDate");
        String localCurrencyId = localCurrency.getId().toString();
        if (foreignCurrencySU || orgCurId.equals(localCurrencyId)) {
            return VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        }
        VoucherInfo.ExchangeRateWithValue ex = (VoucherInfo.ExchangeRateWithValue)this.hmLocalExchangeRate.get(orgCurId);
        if (ex == null) {
            Object[] info = new Object[8];
            if (lexTableId == null) {
                throw new GLException(GLException.NOLOCALEXTABLE);
            }
            info[0] = voucher.getSourceType() != null && voucher.getSourceType().equals((Object)SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT) ? voucher.getCompany().getAdjustExchangeTable().getId().toString() : lexTableId;
            info[1] = rexTableId;
            info[2] = orgCurId;
            info[3] = localCurrencyId;
            info[4] = reportingCurrency.getId().toString();
            info[7] = voucher.getCompany().getId().toString();
            Date currentDate = null;
            if (isByBizDate) {
                info[5] = voucher.getBizDate();
                currentDate = voucher.getBizDate();
            } else {
                info[5] = voucher.getBookedDate();
                currentDate = voucher.getBookedDate();
            }
            info[6] = voucher.getPeriod().getBeginDate();
            Object[] exes = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchExchangeRate(info);
            ex = (VoucherInfo.ExchangeRateWithValue)exes[0];
            if (ex == null) {
                if (exchangeRateMustSameDate) {
                    Object[] param = new String[]{GlUtils.formatDate(this.df, currentDate)};
                    throw new GLException(GLException.NOLOCALTHISDATE, param);
                }
                throw new GLException(GLException.NOLOCALEX);
            }
            this.hmLocalExchangeRate.put(orgCurId, ex);
            this.hmReportingExchangeRate.put(orgCurId, exes[1]);
        }
        return ex;
    }

    public int getEx(CompanyOrgUnitInfo companyInVoucher, CurrencyInfo srcCur, CurrencyInfo objCur, boolean useReportingCurrency) {
        if (companyInVoucher != null && companyInVoucher.getId() != null) {
            this.exmap.put("companyInVoucher", companyInVoucher);
        }
        return GlUtils.getEx(null, srcCur, objCur, this.exmap, useReportingCurrency);
    }

    protected BigDecimal computeAmnt(BigDecimal lr, VoucherInfo.ExchangeRateWithValue objEx, BigDecimal ex, CurrencyInfo cur) {
        BigDecimal result = zero;
        int pre = cur.getPrecision();
        if (lr != null && objEx != null && ex != null && zero.compareTo(ex) != 0) {
            result = ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)objEx.getConvertMode()) ? lr.divide(ex, pre, 4) : lr.multiply(ex).setScale(pre, 4);
        }
        return GlUtils.setScale(result, pre);
    }

    private MeasureUnitInfo getCAAMeasureUnitInfo(Context ctx, AsstAccountInfo caa) throws BOSException {
        if (caa.getMeasureUnit() != null) {
            return caa.getMeasureUnit();
        }
        if (this.caaMeasureUnits.containsKey(caa.getId().toString())) {
            return this.caaMeasureUnits.get(caa.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("coefficient");
        selector.add("measureUnitGroup.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBaseUnit", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.id", (Object)caa.getMeasureUnitGroup().getId().toString()));
        view.setFilter(filter);
        MeasureUnitCollection coll = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(view);
        MeasureUnitInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        this.caaMeasureUnits.put(caa.getId().toString(), info);
        return info;
    }
}

