/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CFRequisitionCollection;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.CFRequisitionInfo;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.RequisitionStatusEnum;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractCFRequisitionControllerBean;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CFRequisitionControllerBean
extends AbstractCFRequisitionControllerBean {
    private static final String CFREQ_CHANGED = "CFReqChanged";
    private static final String EMPTY_STRING = "";
    private static final String NOT_ALL_CORRELATION = "NotAllCorrelation";
    private static final String CURRENT_NOT_CORRELATION = "CurrentNotCorrelation";
    private static final String IN_NOT_EQUALS_OUT = "InNotEqualsOut";
    private static final String CURRENCY_NOT_SAME = "CurrencyNotSame";
    private static final String BASECURRENCY_NOT_SAME_2 = "CurrencyNotSame_2";
    private static final String BASECURRENCY_NOT_SAME = "BaseCurrencyNotSame";
    private static final String DIFFCY_CURRENCY_SAME = "Currency_Same";
    private static final String COMPANY_NOT_SAME = "CompanyNotSame";
    private static final String SUM_NOT_EQUAL_ZERO = "SumNotEqualZero";
    private static final String LOCAL_AMT_SUM_NOT_EQUAL_ZERO = "SumLocalAmtNotEqualZero";
    private static final String VOUCHER_NOT_AUDIT = "VoucherNotAudit";
    private static final String CORRELATOR_NOT_CONFIGURED = "CorrelatorNotConfigured";
    private static final String UNABLE_CORRELATION = "UnableCorrelation";
    private static final String UNABLE_CORRELATIONZ = "UnableCorrelationz";
    private static final String CORRELATION_WAY_AUTO = "2";
    private static final String CORRELATION_WAY_MANUAL = "1";
    public static final String HAS_CORRELATED = "HasCorrelated";
    public static final String GET_PARAM_ALLOW_CFREQ_FAILED = "GetParamAllowCFReqFailed";
    private static final String PARAM_ALLOW_CFREQ_VALUE_UNENABLE = "false";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CFRequisitionControllerBean");
    public static final String CFREQ_RES = "com.kingdee.eas.fi.gl.CFRequisitionResource";
    public static final String LINE_SEPARATOR = "\r\n";
    public static final String TEMP_TABLE_PRE_RECEIVED = "CF_REQ_RECEIVED";
    public static final String TEMP_TABLE_PRE_SENT = "CF_REQ_SENT";
    private static final String STRUCT_SQL_KEY = "STRUCT_SQL";

    @Override
    protected void _clearRequisition(Context ctx, IObjectPK voucherId) throws BOSException, EASBizException {
        String msg = this._checkReqCorrelation(ctx, voucherId.toString());
        if (msg != null) {
            throw new BOSException(msg);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cfRecord.voucher.id", (Object)voucherId.toString()));
        this.delete(ctx, filter);
    }

    @Override
    protected int _clearRequisition(Context ctx, FilterInfo filter, String companyID) throws BOSException, EASBizException {
        if (filter == null) {
            return 0;
        }
        if (!this._isEnableCFRequisition(ctx, companyID)) {
            return 0;
        }
        return this.delete(ctx, filter).length;
    }

    @Override
    protected void _sendRequisition(Context ctx, IObjectPK voucherId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherId.toString()));
        this.doSendRequisition(ctx, filter);
    }

    @Override
    protected int _sendRequisition(Context ctx, Set idSet, String companyID, boolean clear) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return 0;
        }
        if (clear) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("cfRecord", (Object)idSet, CompareType.INCLUDE));
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("cfRecord.id"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)2));
            CFRequisitionCollection colReq = CFRequisitionFactory.getLocalInstance(ctx).getCFRequisitionCollection(view);
            if (colReq != null && colReq.size() > 0) {
                for (int i = 0; i < colReq.size(); ++i) {
                    idSet.remove(colReq.get(i).getCfRecord().getId().toString());
                }
            }
            if (!idSet.isEmpty()) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("cfRecord", (Object)idSet, CompareType.INCLUDE));
                this.delete(ctx, filter);
            }
        }
        if (!idSet.isEmpty()) {
            FilterInfo sendFilter = new FilterInfo();
            sendFilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            return this.doSendRequisition(ctx, sendFilter);
        }
        return 0;
    }

    private int doSendRequisition(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        if (filter == null) {
            return 0;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("voucher.company.id"));
        sic.add(new SelectorItemInfo("voucher.bizStatus"));
        sic.add(new SelectorItemInfo("voucher.period.number"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.description"));
        sic.add(new SelectorItemInfo("assGrp.asstAccount.id"));
        sic.add(new SelectorItemInfo("assGrp.companyOrg.id"));
        sic.add(new SelectorItemInfo("assGrp.customer.internalCompany.id"));
        sic.add(new SelectorItemInfo("assGrp.customer.isInternalCompany"));
        sic.add(new SelectorItemInfo("assGrp.provider.internalCompany.id"));
        sic.add(new SelectorItemInfo("assGrp.provider.isInternalCompany"));
        sic.add(new SelectorItemInfo("oppVoucherAssistRecord.id"));
        sic.add(new SelectorItemInfo("oppVoucherAssistRecord.description"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        view.setFilter(filter);
        CashflowRecordCollection cfRecords = CashflowRecordFactory.getLocalInstance(ctx).getCashflowRecordCollection(view);
        if (cfRecords == null || cfRecords.size() == 0) {
            return 0;
        }
        if (cfRecords.get(0).getVoucher() == null) {
            return 0;
        }
        if (VoucherStatusEnum.TEMP.equals((Object)cfRecords.get(0).getVoucher().getBizStatus())) {
            return 0;
        }
        int count = 0;
        HashMap<String, VoucherInfo.DynamicColumnInfo[]> assColumnInfoMap = new HashMap<String, VoucherInfo.DynamicColumnInfo[]>();
        int size = cfRecords.size();
        for (int i = 0; i < size; ++i) {
            CashflowRecordInfo cfRecord = cfRecords.get(i);
            if (!cfRecord.getType().equals((Object)CashflowTypeEnum.IN) || cfRecord.getAssGrp() == null) continue;
            String asstActTypeID = cfRecord.getAssGrp().getAsstAccount().getId().toString();
            CompanyOrgUnitInfo oppCompany = null;
            if (cfRecord.getAssGrp().getCompanyOrg() != null) {
                oppCompany = cfRecord.getAssGrp().getCompanyOrg();
            } else {
                VoucherInfo.DynamicColumnInfo[] itemCols = null;
                if (assColumnInfoMap.get(asstActTypeID) == null) {
                    Object[] info = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchAssColumnInfo(null, asstActTypeID, null);
                    itemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
                    assColumnInfoMap.put(asstActTypeID, itemCols);
                } else {
                    itemCols = (VoucherInfo.DynamicColumnInfo[])assColumnInfoMap.get(asstActTypeID);
                }
                if (itemCols != null) {
                    for (int j = 0; j < itemCols.length; ++j) {
                        String key = itemCols[j].getMappingPropName();
                        if ("customer".equals(key)) {
                            if (cfRecord.getAssGrp().getCustomer() == null || !cfRecord.getAssGrp().getCustomer().isIsInternalCompany()) continue;
                            oppCompany = cfRecord.getAssGrp().getCustomer().getInternalCompany();
                            break;
                        }
                        if (!"provider".equals(key) || cfRecord.getAssGrp().getProvider() == null || !cfRecord.getAssGrp().getProvider().isIsInternalCompany()) continue;
                        oppCompany = cfRecord.getAssGrp().getProvider().getInternalCompany();
                        break;
                    }
                }
            }
            if (oppCompany == null || oppCompany.getId().toString().equals(cfRecord.getVoucher().getCompany().getId().toString()) || !this.isEnableCFRequisition(ctx, oppCompany.getId().toString())) continue;
            GlParam paramMap = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_074"}, (String)cfRecord.getVoucher().getCompany().getId().toString());
            boolean GL_074 = paramMap.getBoolean("GL_074");
            if (GL_074) {
                StringBuffer sql = new StringBuffer();
                sql.append("select ssc.FCOMPANYID ,p.FNUMBER periodNumber   from T_BD_SystemStatusCtrol ssc \r\n");
                sql.append("inner join T_BD_SystemStatus ss on ss.fid = ssc.fsystemstatusid \n");
                sql.append("inner join T_bd_period p ON SSC.FSTARTPERIODID = P.FID \n");
                sql.append("where  ssc.fisstart = 1 and ss.fname = 6 and ssc.FCOMPANYID =? \n");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oppCompany.getId().toString()});
                try {
                    boolean isSatified = false;
                    if (rs.next()) {
                        int periodNumber = rs.getInt("periodNumber");
                        boolean bl = isSatified = cfRecord.getVoucher().getPeriod().getNumber() >= periodNumber;
                    }
                    if (!isSatified) {
                        continue;
                    }
                }
                catch (SQLException exception) {
                    exception.printStackTrace();
                }
            }
            CFRequisitionInfo reqInfo = new CFRequisitionInfo();
            reqInfo.setStatus(RequisitionStatusEnum.UNCHECKED);
            reqInfo.setSender(cfRecord.getVoucher().getCompany());
            reqInfo.setCfRecord(cfRecord);
            reqInfo.setReceiver(oppCompany);
            java.util.Date now = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
            reqInfo.setSendDate(now);
            reqInfo.setBizDate(now);
            reqInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            reqInfo.setCreateTime(new Timestamp(now.getTime()));
            reqInfo.setBizDate(now);
            if (cfRecord.getOppVoucherAssistRecord() != null && cfRecord.getOppVoucherAssistRecord().getDescription() != null) {
                reqInfo.setDescription(cfRecord.getOppVoucherAssistRecord().getDescription());
            } else {
                reqInfo.setDescription(cfRecord.getEntry().getDescription());
            }
            this._addnew(ctx, (IObjectValue)reqInfo);
            ++count;
        }
        return count;
    }

    @Override
    protected boolean _isEnableCFRequisition(Context ctx, String companyId) throws BOSException, EASBizException {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT 1 FROM T_BD_SystemStatusCtrol ssc inner join T_BD_SystemStatus ss on ssc.FSYSTEMSTATUSID  = ss.FID \r\n");
            sql.append("where ssc.FCOMPANYID = ? and ssc.FISSTART = 1 and ss.FNAME =6");
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId});
            if (!result.next()) {
                return false;
            }
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            ParamItemInfo paramAsst = pc.getParamItemByNumberAndOrg("GL_0152", companyId);
            if (paramAsst == null || !"0".equals(paramAsst.getValue())) {
                return false;
            }
            ParamItemInfo paramCashflow = pc.getParamItemByNumberAndOrg("GL_070", companyId);
            if (paramCashflow == null || PARAM_ALLOW_CFREQ_VALUE_UNENABLE.equals(paramCashflow.getValue())) {
                return false;
            }
        }
        catch (Exception e) {
            throw new BOSException(this.getResource(ctx, GET_PARAM_ALLOW_CFREQ_FAILED, new Object[]{e.getMessage()}), (Throwable)e);
        }
        return true;
    }

    @Override
    protected String _checkReqCorrelation(Context ctx, String voucherId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cfRecord.voucher.id", (Object)voucherId));
        Map<String, Object> result = this.doCheckReqCorrelation(ctx, filter);
        if (result != null) {
            return result.get("detail") != null ? (String)result.get("detail") : null;
        }
        return null;
    }

    @Override
    protected Map _checkReqCorrelation(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        return this.doCheckReqCorrelation(ctx, filter);
    }

    private Map<String, Object> doCheckReqCorrelation(Context ctx, FilterInfo filter) throws BOSException {
        if (filter == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("correlationOrg.name"));
        sic.add(new SelectorItemInfo("cfRecord.primaryItem.name"));
        sic.add(new SelectorItemInfo("cfRecord.oppAccount.name"));
        sic.add(new SelectorItemInfo("cfRecord.originalAmount"));
        sic.add(new SelectorItemInfo("cfRecord.primaryCoefficient"));
        sic.add(new SelectorItemInfo("cfRecord.entry.currency.name"));
        sic.add(new SelectorItemInfo("cfRecord.id"));
        sic.add(new SelectorItemInfo("cfRecord.voucher.number"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)2));
        ICFRequisition iCFReq = CFRequisitionFactory.getLocalInstance(ctx);
        CFRequisitionCollection colReq = iCFReq.getCFRequisitionCollection(view);
        if (colReq == null || colReq.size() == 0) {
            return null;
        }
        String message = ResourceBase.getString((String)CFREQ_RES, (String)HAS_CORRELATED, (Locale)ctx.getLocale());
        StringBuffer messages = new StringBuffer();
        CFRequisitionInfo cfReq = null;
        Object[] params = null;
        HashSet<String> idSet = new HashSet<String>();
        int size = colReq.size();
        for (int i = 0; i < size; ++i) {
            cfReq = colReq.get(i);
            idSet.add(cfReq.getCfRecord().getId().toString());
            params = new Object[6];
            String voucherNumber = cfReq.getCfRecord().getVoucher().getNumber();
            params[0] = voucherNumber;
            params[1] = cfReq.getCfRecord().getOppAccount().getName();
            if (cfReq.getCfRecord().getPrimaryItem() != null) {
                params[2] = cfReq.getCfRecord().getPrimaryItem().getName();
            }
            if (cfReq.getCfRecord().getOriginalAmount() != null) {
                params[3] = cfReq.getCfRecord().getOriginalAmount().multiply(new BigDecimal(String.valueOf(cfReq.getCfRecord().getPrimaryCoefficient())));
            }
            if (cfReq.getCfRecord().getEntry() != null) {
                params[4] = cfReq.getCfRecord().getEntry().getCurrency().getName();
            }
            if (cfReq.getCorrelationOrg() != null) {
                params[5] = cfReq.getCorrelationOrg().getName();
            }
            messages.append(MessageFormat.format(message, params));
            messages.append(LINE_SEPARATOR);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("detail", messages.toString());
        result.put("idSet", idSet);
        return result;
    }

    private String getDetailQueryString(Context ctx, Map params, String tempTableName, List sqlParams, boolean isReceive) {
        String localeName = "fname_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        boolean isOnlyDisplayCanCheck = params.get("query_DisplayCanCheck") == null ? false : (Boolean)params.get("query_DisplayCanCheck");
        boolean isNeedJoinSettingTableQuery = false;
        HashMap cachedCorrelator = new HashMap();
        String curCompany = (String)params.get("currentCompanyId");
        try {
            this.prepareSetting(ctx, curCompany, cachedCorrelator);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        isNeedJoinSettingTableQuery = cachedCorrelator.size() != 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,fsenderid,freceiverid,fprimaryitemid,fperiodid,fcurrencyid,fstatus,\r\n");
        sql.append("fsendername,freceivername,fsendernumber,freceivernumber,fcurrencyname,fcurrencynumber,fprecision,\r\n");
        sql.append("fprimaryitemname,fprimaryitemnumber, fprimaryitemdirection,fcorrelationnum,\r\n");
        sql.append("fvoucherperiod,fvouchercreator,fperiodnumber,foriginalamount,fdescription,fvouchertype,fvouchernumber,fvchnumber,isAvoidCheck,\r\n ");
        sql.append("flocalAmount,fbaseCurrencyId,fbaseCurrencyPrecision\r\n ");
        String structSql = "fid VARCHAR(44), fsenderid VARCHAR(44), freceiverid VARCHAR(44), fprimaryitemid VARCHAR(44), fperiodid VARCHAR(44), fcurrencyid VARCHAR(44), fstatus VARCHAR(80), fsendername NVARCHAR(500), freceivername NVARCHAR(500), fsendernumber VARCHAR(80), freceivernumber VARCHAR(80), fcurrencyname NVARCHAR(500), fcurrencynumber VARCHAR(80), fprecision INT, fprimaryitemname NVARCHAR(500), fprimaryitemnumber VARCHAR(80), fprimaryitemdirection NVARCHAR(512), fcorrelationnum VARCHAR(80), fvoucherperiod VARCHAR(80), fvouchercreator VARCHAR(80), fperiodnumber VARCHAR(80), foriginalamount NUMERIC(29,10), fdescription NVARCHAR(512), fvouchertype NVARCHAR(500), fvouchernumber NVARCHAR(80), fvchnumber NVARCHAR(80),isAvoidCheck int,flocalAmount NUMERIC(29,10),fbaseCurrencyId VARCHAR(44),fbaseCurrencyPrecision INT";
        params.put(STRUCT_SQL_KEY, structSql);
        sql.append("into ").append(tempTableName).append(" from \r\n");
        sql.append("(\r\n");
        sql.append("select receiver.").append(localeName).append(" as freceivername, receiver.fnumber as freceivernumber,\r\n");
        sql.append("sender.").append(localeName).append(" as fsendername, sender.fnumber as fsendernumber,\r\n");
        sql.append("((to_char(period.fperiodyear) || '.') || to_char(period.fperiodnumber)) as fvoucherperiod, \r\n");
        sql.append("period.fnumber as fperiodnumber, \r\n");
        sql.append("vouchertype.").append(localeName).append(" as fvouchertype, \r\n");
        sql.append("creator.").append(localeName).append(" as fvouchercreator, \r\n");
        sql.append("voucher.fnumber as fvchnumber, \r\n");
        sql.append("vouchertype.").append(localeName).append(" || voucher.fnumber as fvouchernumber, \r\n");
        sql.append("primaryitem.").append(localeName).append(" as fprimaryitemname,");
        sql.append("primaryitem.fnumber as fprimaryitemnumber,\r\n");
        sql.append("primaryitem.fdirection as fprimaryitemdirection, \r\n");
        sql.append("currency.").append(localeName).append(" as fcurrencyname,");
        sql.append("currency.fnumber as fcurrencynumber,currency.fprecision fprecision, \r\n");
        sql.append("cfrecord.foriginalamount * cfrecord.fprimarycoeffient as foriginalamount, \r\n");
        sql.append("cfrequisition.fstatus as fstatus, \r\n");
        sql.append("cfrequisition.fcorrelationnum as fcorrelationnum, \r\n");
        sql.append("cfrequisition.fid as fid,sender.fid as fsenderid, receiver.fid as freceiverid,\r\n");
        sql.append("cfrecord.fprimaryitemid as fprimaryitemid,period.fid as fperiodid,\r\n");
        sql.append("currency.fid as fcurrencyid,cfrequisition.fdescription as fdescription, \r\n");
        sql.append("0 as fischecked,\r\n");
        sql.append("cfrequisition.fisAvoidCheck isAvoidCheck, \r\n");
        sql.append("cfrecord.FLocalAmount*cfrecord.fprimarycoeffient flocalAmount,");
        sql.append("BASECURRENCY.FID fbaseCurrencyId,BASECURRENCY.FPrecision fbaseCurrencyPrecision \r\n");
        sql.append("from t_gl_cfrequisition as cfrequisition  \r\n");
        sql.append("inner join t_gl_cashflowrecord as cfrecord  \r\n");
        sql.append("on cfrequisition.fcfrecordid = cfrecord.fid  \r\n");
        sql.append("inner join t_org_company as receiver  \r\n");
        sql.append("on cfrequisition.freceiverid = receiver.fid  \r\n");
        sql.append("inner join t_org_company as sender  \r\n");
        sql.append("on cfrequisition.fsenderid = sender.fid  \r\n");
        sql.append("inner join t_bd_cashflowitem as primaryitem  \r\n");
        sql.append("on cfrecord.fprimaryitemid = primaryitem.fid  \r\n");
        sql.append("inner join t_gl_voucherentry as entry  \r\n");
        sql.append("on cfrecord.fentryid = entry.fid  \r\n");
        sql.append("inner join t_gl_voucher as voucher  \r\n");
        sql.append("on cfrecord.fvoucherid = voucher.fid  \r\n");
        sql.append("inner join t_bd_vouchertypes as vouchertype  \r\n");
        sql.append("on vouchertype.fid = voucher.fvouchertypeid  \r\n");
        sql.append("inner join t_bd_currency as currency  \r\n");
        sql.append("on entry.fcurrencyid = currency.fid  \r\n");
        sql.append("inner join t_bd_period as period  \r\n");
        sql.append("on voucher.fperiodid = period.fid  \r\n");
        sql.append("inner join T_PM_User as creator \r\n");
        sql.append("on voucher.fcreatorid = creator.fid \r\n");
        sql.append("INNER JOIN T_BD_Currency AS BASECURRENCY ");
        sql.append("ON SENDER.FBaseCurrencyID = BASECURRENCY.FID ");
        if (isOnlyDisplayCanCheck) {
            sql.append("left join T_BD_CFCorrelationSetting sett on (receiver.fid = sett.FReceiverId and sender.fid = sett.FSenderId)");
        }
        sql.append(this.computeWhere(ctx, params, isReceive, sqlParams));
        if (isOnlyDisplayCanCheck) {
            if (isNeedJoinSettingTableQuery) {
                sql.append("  and (sett.FCorrelatorId = ? )");
            } else {
                sql.append("  and (sett.FCorrelatorId is null or  sett.FCorrelatorId = ? )");
            }
            sqlParams.add(params.get("currentCompanyId"));
        }
        sql.append(" \r\n");
        sql.append(") t \r\n");
        return sql.toString();
    }

    private String getCollectQueryString(Context ctx, Map params, String tempTableName, List sqlParams, boolean isReceive) {
        String localeName = "fname_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        boolean isOnlyDisplayCanCheck = params.get("query_DisplayCanCheck") == null ? false : (Boolean)params.get("query_DisplayCanCheck");
        boolean isNeedJoinSettingTableQuery = false;
        HashMap cachedCorrelator = new HashMap();
        String curCompany = (String)params.get("currentCompanyId");
        try {
            this.prepareSetting(ctx, curCompany, cachedCorrelator);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        isNeedJoinSettingTableQuery = cachedCorrelator.size() != 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,fsenderid,freceiverid,fprimaryitemid,fperiodid,fcurrencyid,fstatus,\r\n");
        sql.append("fsendername,freceivername,fsendernumber,freceivernumber,fcurrencyname,fcurrencynumber,fprecision, \r\n");
        sql.append("fprimaryitemname,fprimaryitemnumber, fprimaryitemdirection,N'default' as fcorrelationnum, \r\n");
        sql.append("fvoucherperiod,fperiodnumber,foriginalamount,N'default' as fdescription,N'default' as fvouchernumber,\r\n");
        sql.append("flocalAmount,fbaseCurrencyId,fbaseCurrencyPrecision\r\n");
        String structSql = "fid VARCHAR(44), fsenderid VARCHAR(44), freceiverid VARCHAR(44), fprimaryitemid VARCHAR(44), fperiodid VARCHAR(44), fcurrencyid VARCHAR(44), fstatus VARCHAR(80), fsendername NVARCHAR(500), freceivername NVARCHAR(500), fsendernumber VARCHAR(80), freceivernumber VARCHAR(80), fcurrencyname NVARCHAR(500), fcurrencynumber VARCHAR(80), fprecision INT, fprimaryitemname NVARCHAR(500), fprimaryitemnumber VARCHAR(80), fprimaryitemdirection NVARCHAR(512), fcorrelationnum VARCHAR(80), fvoucherperiod VARCHAR(80), fperiodnumber VARCHAR(80), foriginalamount NUMERIC(29,10), fdescription NVARCHAR(512), fvouchernumber NVARCHAR(80),flocalAmount NUMERIC(29,10),fbaseCurrencyId VARCHAR(44),fbaseCurrencyPrecision INT";
        params.put(STRUCT_SQL_KEY, structSql);
        sql.append(" into ").append(tempTableName).append(" from \r\n");
        sql.append("( \r\n");
        sql.append("select newbosid('00000000') as fid, fsenderid,freceiverid,fprimaryitemid,\r\n");
        sql.append("fperiodid,fcurrencyid,fstatus,\r\n");
        sql.append("sender.").append(localeName).append(" as fsendername,");
        sql.append("sender.fnumber as fsendernumber,");
        sql.append("receiver.").append(localeName).append(" as freceivername,");
        sql.append("receiver.fnumber as freceivernumber,");
        sql.append("primaryitem.").append(localeName).append(" as fprimaryitemname,primaryitem.fnumber as fprimaryitemnumber,");
        sql.append("primaryitem.fdirection as fprimaryitemdirection, \r\n");
        sql.append("currency.").append(localeName).append(" as fcurrencyname,currency.fnumber as fcurrencynumber, currency.fprecision fprecision, \r\n");
        sql.append("((to_char(period.fperiodyear) || '.') || to_char(period.fperiodnumber)) as fvoucherperiod, \r\n");
        sql.append("period.fnumber as fperiodnumber,");
        sql.append("cfrequisition.foriginalamount as foriginalamount, \r\n");
        sql.append("cfrequisition.flocalAmount as flocalAmount, \r\n");
        sql.append("BASECURRENCY.FID fbaseCurrencyId,BASECURRENCY.FPrecision fbaseCurrencyPrecision \r\n");
        sql.append("from \r\n");
        sql.append("(\r\n");
        sql.append("select cfrequisition.fsenderid fsenderid,cfrequisition.freceiverid freceiverid,\r\n");
        sql.append("cfrecord.fprimaryitemid fprimaryitemid,voucher.fperiodid fperiodid,\r\n");
        sql.append("entry.fcurrencyid fcurrencyid,cfrequisition.fstatus, \r\n");
        sql.append("sum(cfrecord.foriginalamount * cfrecord.fprimarycoeffient) foriginalamount, \r\n");
        sql.append("sum(cfrecord.FLocalAmount * cfrecord.fprimarycoeffient) flocalAmount \r\n");
        sql.append("from t_gl_cfrequisition as cfrequisition  \r\n");
        sql.append("inner join t_gl_cashflowrecord as cfrecord  \r\n");
        sql.append("on cfrequisition.fcfrecordid = cfrecord.fid  \r\n");
        sql.append("inner join t_org_company as receiver  \r\n");
        sql.append("on cfrequisition.freceiverid = receiver.fid  \r\n");
        sql.append("inner join t_org_company as sender  \r\n");
        sql.append("on cfrequisition.fsenderid = sender.fid  \r\n");
        sql.append("inner join t_bd_cashflowitem as primaryitem  \r\n");
        sql.append("on cfrecord.fprimaryitemid = primaryitem.fid  \r\n");
        sql.append("inner join t_gl_voucherentry as entry  \r\n");
        sql.append("on cfrecord.fentryid = entry.fid  \r\n");
        sql.append("inner join t_gl_voucher as voucher  \r\n");
        sql.append("on cfrecord.fvoucherid = voucher.fid  \r\n");
        sql.append("inner join T_PM_User as creator \r\n");
        sql.append("on voucher.fcreatorid = creator.fid \r\n");
        sql.append("inner join t_bd_currency as currency  \r\n");
        sql.append("on entry.fcurrencyid = currency.fid  \r\n");
        sql.append("inner join t_bd_period as period  \r\n");
        sql.append("on voucher.fperiodid = period.fid  \r\n");
        if (isOnlyDisplayCanCheck) {
            sql.append("left join T_BD_CFCorrelationSetting sett on (receiver.fid = sett.FReceiverId and sender.fid = sett.FSenderId)");
        }
        sql.append(this.computeWhere(ctx, params, isReceive, sqlParams)).append(LINE_SEPARATOR);
        if (isOnlyDisplayCanCheck) {
            if (isNeedJoinSettingTableQuery) {
                sql.append("  and (sett.FCorrelatorId = ? )");
            } else {
                sql.append("  and (sett.FCorrelatorId is null or  sett.FCorrelatorId = ? )");
            }
            sqlParams.add(params.get("currentCompanyId"));
        }
        sql.append("group by cfrequisition.fsenderid, \r\n");
        sql.append("         cfrequisition.freceiverid, \r\n");
        sql.append("         cfrecord.fprimaryitemid, \r\n");
        sql.append("         voucher.fperiodid, \r\n");
        sql.append("         entry.fcurrencyid, \r\n");
        sql.append("         cfrequisition.fstatus \r\n");
        sql.append(") cfrequisition \r\n");
        sql.append("inner join t_org_company as sender \r\n");
        sql.append("on cfrequisition.fsenderid = sender.fid \r\n");
        sql.append("inner join t_org_company as receiver \r\n");
        sql.append("on cfrequisition.freceiverid = receiver.fid \r\n");
        sql.append("inner join t_bd_cashflowitem as primaryitem \r\n");
        sql.append("on cfrequisition.fprimaryitemid = primaryitem.fid \r\n");
        sql.append("inner join t_bd_currency as currency \r\n");
        sql.append("on cfrequisition.fcurrencyid = currency.fid \r\n");
        sql.append("inner join t_bd_period as period  \r\n");
        sql.append("on cfrequisition.fperiodid = period.fid  \r\n");
        sql.append("INNER JOIN T_BD_Currency AS BASECURRENCY ");
        sql.append("ON SENDER.FBaseCurrencyID = BASECURRENCY.FID ");
        sql.append(")t1 \r\n");
        return sql.toString();
    }

    public static String executeSelectInto(String sql, Object[] params, Context ctx, String structSql) throws BOSException {
        String tableName = GLTempTableUtil.createDBSysTempTable(ctx, structSql);
        char[] chs = sql.toCharArray();
        int intoPos = -1;
        StringBuilder sf = new StringBuilder();
        int quote = 0;
        for (int i = 0; i < chs.length; ++i) {
            char ch = chs[i];
            if (ch == '\'') {
                ++quote;
            } else if (ch == ' ' && quote % 2 == 0 && (intoPos = CFRequisitionControllerBean.nextIsInto(chs, i + 1)) != -1) {
                sf.append(ch);
                break;
            }
            sf.append(ch);
        }
        String selectSql = sf.toString();
        int tabPos = intoPos + "into ".length();
        String intoTableName = CFRequisitionControllerBean.nextWord(chs, tabPos);
        String buf = sql.substring(tabPos);
        int fromWherePos = buf.indexOf(intoTableName);
        String fromWhereSql = buf.substring(fromWherePos + intoTableName.length() + 1);
        String insertSql = "insert into " + tableName + " " + selectSql + fromWhereSql;
        DbUtil.execute((Context)ctx, (String)insertSql, (Object[])params);
        return tableName;
    }

    private static int nextIsInto(char[] chs, int from) {
        int beginPos = -1;
        StringBuilder sb = new StringBuilder();
        int len = chs.length;
        boolean enterWord = false;
        for (int i = from; i < len; ++i) {
            char ch = chs[i];
            if (ch == ' ') {
                if (!enterWord) continue;
                break;
            }
            if (!enterWord) {
                enterWord = true;
                beginPos = i;
            }
            sb.append(ch);
        }
        if ("into".equalsIgnoreCase(sb.toString())) {
            return beginPos;
        }
        return -1;
    }

    private static String nextWord(char[] chs, int from) {
        StringBuilder sb = new StringBuilder();
        int len = chs.length;
        boolean enterWord = false;
        for (int i = from; i < len; ++i) {
            char ch = chs[i];
            if (ch == ' ' || ch == '\n') {
                if (!enterWord) continue;
                break;
            }
            if (!enterWord) {
                enterWord = true;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private String computeWhere(Context ctx, Map params, boolean isReceive, List sqlParams) {
        String filterStr;
        FilterInfo filter;
        String dateFashion;
        StringBuffer sqlWhere = new StringBuffer(" where ");
        if (isReceive) {
            sqlWhere.append(" receiver.fid=?");
        } else {
            sqlWhere.append(" sender.fid=?");
        }
        sqlParams.add(params.get("currentCompanyId"));
        if (params.get("oppCompany") != null) {
            if (isReceive) {
                sqlWhere.append(" and sender.fid=?");
            } else {
                sqlWhere.append(" and receiver.fid=?");
            }
            sqlParams.add(params.get("oppCompany"));
        }
        if ("byPeriod".equals(dateFashion = (String)params.get("date_fashion"))) {
            sqlWhere.append(" and period.fnumber >= ? and period.fnumber <= ?");
            int from = Integer.parseInt(String.valueOf(params.get("periodyearfrom"))) * 100 + Integer.parseInt(String.valueOf(params.get("periodnumberfrom")));
            sqlParams.add(new Integer(from));
            int to = Integer.parseInt(String.valueOf(params.get("periodyearto"))) * 100 + Integer.parseInt(String.valueOf(params.get("periodnumberto")));
            sqlParams.add(new Integer(to));
        } else {
            sqlWhere.append(" and voucher.fbookedDate >= ?");
            sqlParams.add(params.get("startDate"));
            sqlWhere.append(" and voucher.fbookedDate <= ?");
            sqlParams.add(params.get("endDate"));
        }
        if (params.get("primaryItem") != null) {
            sqlWhere.append(" and primaryitem.fid=?");
            sqlParams.add(params.get("primaryItem"));
        }
        if (params.get("currency") != null) {
            sqlWhere.append(" and currency.fid=?");
            sqlParams.add(params.get("currency"));
        }
        if (params.get("status") != null) {
            sqlWhere.append(" and cfrequisition.fstatus=?");
            sqlParams.add(String.valueOf(params.get("status")));
        }
        if ((filter = (FilterInfo)params.get("cus_filter")) != null && (filterStr = filter.toString()) != null && filterStr.trim().length() != 0) {
            sqlWhere.append(" and ").append(this.processFilterStr(ctx, filterStr));
        }
        return sqlWhere.toString();
    }

    private String processFilterStr(Context ctx, String filterStr) {
        filterStr = filterStr.replaceAll("fsenderNumber", "sender.fnumber");
        filterStr = filterStr.replaceAll("sender.number", "sender.fnumber");
        filterStr = filterStr.replaceAll("freceiverNumber", "receiver.fnumber");
        filterStr = filterStr.replaceAll("vouchertype.name", "vouchertype.fname_" + ctx.getLocale().toString());
        filterStr = filterStr.replaceAll("fvouchernumber", "voucher.fnumber");
        filterStr = filterStr.replaceAll("fprimaryItemNumber", "primaryItem.fnumber");
        filterStr = filterStr.replaceAll("fprimaryItemDirection", "primaryItem.fdirection");
        filterStr = filterStr.replaceAll("fcurrencyNumber", "currency.fnumber");
        filterStr = filterStr.replaceAll("currency.number", "currency.fnumber");
        filterStr = filterStr.replaceAll("fvoucherCreator", "creator.fname_l2");
        filterStr = filterStr.replaceAll("foriginalAmount", "cfRecord.foriginalAmount * cfRecord.fprimaryCoeffient");
        filterStr = filterStr.replaceAll("fstatus", "cfrequisition.fstatus");
        filterStr = filterStr.replaceAll("fdescription", "cfrequisition.fdescription");
        filterStr = filterStr.replaceAll("fvoucherPeriod", "((to_char(period.fperiodyear) || '.') || to_char(period.fperiodnumber))");
        filterStr = filterStr.replace("isAvoidCheck", "cfrequisition.fisAvoidCheck");
        return filterStr;
    }

    private String computeOrder(Context ctx, Map params) {
        SorterItemCollection sorters = (SorterItemCollection)params.get("cus_order");
        if (sorters == null || sorters.size() == 0) {
            return EMPTY_STRING;
        }
        StringBuffer order = new StringBuffer(" order by ");
        String propertyName = null;
        int size = sorters.size();
        for (int i = 0; i < size; ++i) {
            SorterItemInfo sorter = sorters.get(i);
            propertyName = sorter.getPropertyName();
            SortType sortType = sorter.getSortType();
            order.append(this.replacePropertyName(ctx, propertyName)).append(SortType.ASCEND.equals((Object)sortType) ? " asc" : " desc");
            order.append(",");
        }
        order.deleteCharAt(order.length() - 1);
        return order.toString();
    }

    private String replacePropertyName(Context ctx, String propertyName) {
        if ("fsenderNumber".equalsIgnoreCase(propertyName) || "sender.number".equalsIgnoreCase(propertyName)) {
            return "fsendernumber";
        }
        if ("freceiverNumber".equalsIgnoreCase(propertyName)) {
            return "freceivernumber";
        }
        if ("fvouchernumber".equalsIgnoreCase(propertyName)) {
            return "fvchnumber";
        }
        if ("fvouchertype".equalsIgnoreCase(propertyName) || "vouchertype.name".equalsIgnoreCase(propertyName)) {
            return "fvouchertype";
        }
        if ("fprimaryItemNumber".equalsIgnoreCase(propertyName)) {
            return "fprimaryitemnumber";
        }
        if ("fprimaryItemDirection".equalsIgnoreCase(propertyName)) {
            return "fprimaryItemDirection";
        }
        if ("fcurrencyNumber".equalsIgnoreCase(propertyName) || "currency.number".equalsIgnoreCase(propertyName)) {
            return "fcurrencynumber";
        }
        if ("foriginalAmount".equalsIgnoreCase(propertyName)) {
            return "foriginalAmount";
        }
        if ("fstatus".equalsIgnoreCase(propertyName)) {
            return "fstatus";
        }
        if ("fdescription".equalsIgnoreCase(propertyName)) {
            return "fdescription";
        }
        if ("fvoucherperiod".equalsIgnoreCase(propertyName)) {
            return "fperiodnumber";
        }
        return propertyName;
    }

    @Override
    protected Map _queryReceivedCFRequistionFirst(Context ctx, Map params, int startRowIndex, int rowCount) throws BOSException, EASBizException {
        String sql = null;
        String queryFashion = (String)params.get("query_fashion");
        ArrayList sqlParams = new ArrayList();
        sql = "detail".equals(queryFashion) ? this.getDetailQueryString(ctx, params, TEMP_TABLE_PRE_RECEIVED, sqlParams, true) : this.getCollectQueryString(ctx, params, TEMP_TABLE_PRE_RECEIVED, sqlParams, true);
        String structSql = params.get(STRUCT_SQL_KEY) == null ? null : (String)params.get(STRUCT_SQL_KEY);
        String tableName = CFRequisitionControllerBean.executeSelectInto(sql, sqlParams.toArray(), ctx, structSql);
        sql = "select top " + rowCount + " * from " + tableName + this.computeOrder(ctx, params);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String isWeb = (String)params.get("isWeb");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (isWeb != null && isWeb.equals("true")) {
            sql = "select count(*) fsize from " + tableName + this.computeOrder(ctx, params);
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs1.next()) {
                    result.put("totalSize", rs1.getInt("fsize"));
                } else {
                    result.put("totalSize", 0);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        result.put("tempTableName", tableName);
        result.put("rs", rs);
        return result;
    }

    @Override
    protected Map _querySentCFRequistionFirst(Context ctx, Map params, int startRowIndex, int rowCounts) throws BOSException, EASBizException {
        String sql = null;
        String queryFashion = (String)params.get("query_fashion");
        ArrayList sqlParams = new ArrayList();
        sql = "detail".equals(queryFashion) ? this.getDetailQueryString(ctx, params, TEMP_TABLE_PRE_SENT, sqlParams, false) : this.getCollectQueryString(ctx, params, TEMP_TABLE_PRE_SENT, sqlParams, false);
        String structSql = params.get(STRUCT_SQL_KEY) == null ? null : (String)params.get(STRUCT_SQL_KEY);
        String tableName = CFRequisitionControllerBean.executeSelectInto(sql, sqlParams.toArray(), ctx, structSql);
        sql = "select top " + rowCounts + " * from " + tableName + this.computeOrder(ctx, params);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, Object> result = new HashMap<String, Object>();
        String isWeb = (String)params.get("isWeb");
        if (isWeb != null && isWeb.equals("true")) {
            sql = "select count(*) fsize from " + tableName + this.computeOrder(ctx, params);
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs1.next()) {
                    result.put("totalSize", rs1.getInt("fsize"));
                } else {
                    result.put("totalSize", 0);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        result.put("tempTableName", tableName);
        result.put("rs", rs);
        return result;
    }

    @Override
    protected void _dropTempTable(Context ctx, List tempTableNames) throws BOSException, EASBizException {
        if (tempTableNames == null || tempTableNames.size() == 0) {
            return;
        }
        for (int i = 0; i < tempTableNames.size(); ++i) {
            String tableName = (String)tempTableNames.get(i);
            if (tableName == null) continue;
            try {
                GLTempTableUtil.dropDBSysTempTable(ctx, tableName);
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected int _autoCorrelation(Context ctx, Map params) throws BOSException, EASBizException {
        String queryFashion = (String)params.get("query_fashion");
        boolean isDiffCyCorrelation = params.containsKey("isDiffCyCorrelation") && (Boolean)params.get("isDiffCyCorrelation") != false;
        GlParam paramMap = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_124"}, null);
        String GL_124 = paramMap.getString("GL_124");
        params.put("manualAudit", GL_124);
        HashMap cachedCorrelator = new HashMap();
        String curCompany = (String)params.get("currentCompanyId");
        this.prepareSetting(ctx, curCompany, cachedCorrelator);
        if ("detail".equals(queryFashion)) {
            ArrayList sqlReceiveParams = new ArrayList();
            ArrayList sqlSendParams = new ArrayList();
            String receiveSql = this.getCanCorrelationQueryString(ctx, params, sqlReceiveParams, true, isDiffCyCorrelation);
            IRowSet rsReceive = DbUtil.executeQuery((Context)ctx, (String)receiveSql, (Object[])sqlReceiveParams.toArray());
            String sendSql = this.getCanCorrelationQueryString(ctx, params, sqlSendParams, false, isDiffCyCorrelation);
            IRowSet rsSend = DbUtil.executeQuery((Context)ctx, (String)sendSql, (Object[])sqlSendParams.toArray());
            try {
                return this.autoCorrelation(ctx, params, rsReceive, rsSend, cachedCorrelator, isDiffCyCorrelation);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        ArrayList sqlReceiveParams = new ArrayList();
        ArrayList sqlSendParams = new ArrayList();
        String receiveSql = this.getCanCorrelationQueryString(ctx, params, sqlReceiveParams, true, isDiffCyCorrelation);
        IRowSet rsReceive = DbUtil.executeQuery((Context)ctx, (String)receiveSql, (Object[])sqlReceiveParams.toArray());
        String sendSql = this.getCanCorrelationQueryString(ctx, params, sqlSendParams, false, isDiffCyCorrelation);
        IRowSet rsSend = DbUtil.executeQuery((Context)ctx, (String)sendSql, (Object[])sqlSendParams.toArray());
        try {
            return this.autoCollectCorrelation(ctx, params, rsReceive, rsSend, cachedCorrelator, isDiffCyCorrelation);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected int _autoSpecialCorrelation(Context ctx, Map params) throws BOSException, EASBizException {
        GlParam paramMap = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_124"}, null);
        String GL_124 = paramMap.getString("GL_124");
        params.put("manualAudit", GL_124);
        String queryFashion = (String)params.get("query_fashion");
        HashMap cachedCorrelator = new HashMap();
        String curCompany = (String)params.get("currentCompanyId");
        this.prepareSetting(ctx, curCompany, cachedCorrelator);
        if ("detail".equals(queryFashion)) {
            String correlateReceive = (String)params.get("correlateReceive");
            String sql = null;
            ArrayList sqlParams = new ArrayList();
            sql = "true".equals(correlateReceive) ? this.getCanCorrelationQueryString(ctx, params, sqlParams, true) : this.getCanCorrelationQueryString(ctx, params, sqlParams, false);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])sqlParams.toArray());
            try {
                if ("true".equals(correlateReceive)) {
                    return this.autoSpecialCorrelation(ctx, params, rs, true, cachedCorrelator);
                }
                return this.autoSpecialCorrelation(ctx, params, rs, false, cachedCorrelator);
            }
            catch (NumberFormatException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        String correlateReceive = (String)params.get("correlateReceive");
        String sql = null;
        ArrayList sqlParams = new ArrayList();
        sql = "true".equals(correlateReceive) ? this.getCanCorrelationQueryString(ctx, params, sqlParams, true) : this.getCanCorrelationQueryString(ctx, params, sqlParams, false);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])sqlParams.toArray());
        try {
            if ("true".equals(correlateReceive)) {
                return this.autoCollectSpecialCorrelation(ctx, params, rs, true, cachedCorrelator);
            }
            return this.autoCollectSpecialCorrelation(ctx, params, rs, false, cachedCorrelator);
        }
        catch (NumberFormatException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _manualCorrelation(Context ctx, Map params) throws BOSException, EASBizException {
        String queryFashion = (String)params.get("query_fashion");
        boolean isDiffCyCorrelation = params.containsKey("isDiffCyCorrelation") && (Boolean)params.get("isDiffCyCorrelation") != false;
        HashMap cachedCorrelator = new HashMap();
        String curCompany = (String)params.get("currentCompanyId");
        this.prepareSetting(ctx, curCompany, cachedCorrelator);
        if ("detail".equals(queryFashion)) {
            List receiveIds = (List)params.get("selectedReceiveIds");
            String receiveSql = this.getSelectedDetailRequisition(ctx, params, receiveIds, isDiffCyCorrelation);
            IRowSet rsReceive = DbUtil.executeQuery((Context)ctx, (String)receiveSql);
            List sendIds = (List)params.get("selectedSendIds");
            String sendSql = this.getSelectedDetailRequisition(ctx, params, sendIds, isDiffCyCorrelation);
            IRowSet rsSend = DbUtil.executeQuery((Context)ctx, (String)sendSql);
            try {
                this.manualCorrelation(ctx, params, rsReceive, rsSend, cachedCorrelator, isDiffCyCorrelation);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        List receiveIds = (List)params.get("selectedReceiveIds");
        ArrayList sqlReceiveParams = new ArrayList();
        String receiveSql = this.getSelectedCollectRequisition(ctx, params, receiveIds, sqlReceiveParams, true, isDiffCyCorrelation);
        IRowSet rsReceive = DbUtil.executeQuery((Context)ctx, (String)receiveSql, (Object[])sqlReceiveParams.toArray());
        List sendIds = (List)params.get("selectedSendIds");
        ArrayList sqlSendParams = new ArrayList();
        String sendSql = this.getSelectedCollectRequisition(ctx, params, sendIds, sqlSendParams, false, isDiffCyCorrelation);
        IRowSet rsSend = DbUtil.executeQuery((Context)ctx, (String)sendSql, (Object[])sqlSendParams.toArray());
        try {
            this.manualCollectCorrelation(ctx, params, rsReceive, rsSend, cachedCorrelator, isDiffCyCorrelation);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _manualSpecialCorrelation(Context ctx, Map params) throws BOSException, EASBizException {
        String queryFashion = (String)params.get("query_fashion");
        HashMap cachedCorrelator = new HashMap();
        String curCompany = (String)params.get("currentCompanyId");
        this.prepareSetting(ctx, curCompany, cachedCorrelator);
        if ("detail".equals(queryFashion)) {
            String correlateReceive = (String)params.get("correlateReceive");
            List ids = (List)params.get("selectedIds");
            String sql = this.getSelectedDetailRequisition(ctx, params, ids);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            StringBuffer correlationMsg = new StringBuffer();
            try {
                if ("true".equals(correlateReceive)) {
                    this.manualSpecialCorrelation(ctx, params, rs, true, correlationMsg, cachedCorrelator);
                } else {
                    this.manualSpecialCorrelation(ctx, params, rs, false, correlationMsg, cachedCorrelator);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (correlationMsg.length() > 0) {
                throw new BOSException(correlationMsg.toString());
            }
        } else {
            List ids = (List)params.get("selectedIds");
            ArrayList sqlParams = new ArrayList();
            String correlateReceive = (String)params.get("correlateReceive");
            String sql = null;
            sql = "true".equals(correlateReceive) ? this.getSelectedCollectRequisition(ctx, params, ids, sqlParams, true) : this.getSelectedCollectRequisition(ctx, params, ids, sqlParams, false);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])sqlParams.toArray());
            StringBuffer correlationMsg = new StringBuffer();
            try {
                if ("true".equals(correlateReceive)) {
                    this.manualSpecialCorrelation(ctx, params, rs, true, correlationMsg, cachedCorrelator);
                } else {
                    this.manualSpecialCorrelation(ctx, params, rs, false, correlationMsg, cachedCorrelator);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (correlationMsg.length() > 0) {
                throw new BOSException(correlationMsg.toString());
            }
        }
    }

    private void manualCollectCorrelation(Context ctx, Map params, IRowSet rsReceive, IRowSet rsSend, Map cachedCorrelator, boolean isDiffCyCorrelation) throws BOSException, SQLException, EASBizException {
        ArrayList reqIdsCollector = new ArrayList();
        StringBuffer msgCollector = new StringBuffer();
        if (!this.canMakeCorrelation(ctx, params, rsReceive, rsSend, reqIdsCollector, msgCollector, cachedCorrelator, isDiffCyCorrelation)) {
            throw new BOSException(msgCollector.toString());
        }
        this.correlateRequisition(ctx, params, reqIdsCollector, CORRELATION_WAY_MANUAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int autoCollectSpecialCorrelation(Context ctx, Map params, IRowSet rs, boolean isReceive, Map cachedCorrelator) throws SQLException, BOSException, EASBizException {
        HashMap group = new HashMap();
        while (rs.next()) {
            this.addGroup(group, rs, isReceive);
        }
        LinkedList keys = new LinkedList(group.keySet());
        int correlatedCount = 0;
        String curCompany = (String)params.get("currentCompanyId");
        try {
            CollectKey receiveKey = null;
            CollectKey sendKey = null;
            block4: for (int i = keys.size() - 1; i >= 0; --i) {
                receiveKey = (CollectKey)keys.get(i);
                for (int j = i - 1; j >= 0; --j) {
                    sendKey = (CollectKey)keys.get(j);
                    if (!receiveKey.canSpecialCorrelation(sendKey) || !this.curCompanyIsCorrelaotr(ctx, curCompany, sendKey.getCompanyId(), cachedCorrelator)) continue;
                    receiveKey.getRequisitionIds().addAll(sendKey.getRequisitionIds());
                    this.correlateRequisition(ctx, params, receiveKey.getRequisitionIds(), CORRELATION_WAY_AUTO);
                    correlatedCount += receiveKey.getRequisitionIds().size();
                    keys.remove(j);
                    --i;
                    continue block4;
                }
            }
        }
        finally {
            group.clear();
            keys.clear();
        }
        return correlatedCount;
    }

    private int autoCollectCorrelation(Context ctx, Map params, IRowSet rsReceive, IRowSet rsSend, Map cachedCorrelator) throws SQLException, BOSException, EASBizException {
        return this.autoCollectCorrelation(ctx, params, rsReceive, rsSend, cachedCorrelator, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int autoCollectCorrelation(Context ctx, Map params, IRowSet rsReceive, IRowSet rsSend, Map cachedCorrelator, boolean isDiffCyCorrelation) throws SQLException, BOSException, EASBizException {
        HashMap receiveGroup = new HashMap();
        while (rsReceive.next()) {
            this.addGroup(receiveGroup, rsReceive, true, isDiffCyCorrelation);
        }
        HashMap sendGroup = new HashMap();
        while (rsSend.next()) {
            this.addGroup(sendGroup, rsSend, false, isDiffCyCorrelation);
        }
        LinkedList sendKeys = new LinkedList(sendGroup.keySet());
        LinkedList receiveKeys = new LinkedList(receiveGroup.keySet());
        int correlatedCount = 0;
        String curCompany = (String)params.get("currentCompanyId");
        try {
            CollectKey receiveKey = null;
            CollectKey sendKey = null;
            StringBuffer msgCollector = new StringBuffer();
            block5: for (int i = receiveKeys.size() - 1; i >= 0; --i) {
                receiveKey = (CollectKey)receiveKeys.get(i);
                for (int j = sendKeys.size() - 1; j >= 0; --j) {
                    sendKey = (CollectKey)sendKeys.get(j);
                    if (!receiveKey.canCorrelation(sendKey, isDiffCyCorrelation)) continue;
                    if (!this.curCompanyIsCorrelaotr(ctx, curCompany, sendKey.getCompanyId(), msgCollector, cachedCorrelator)) {
                        msgCollector.delete(0, msgCollector.length() - 1);
                        continue;
                    }
                    receiveKey.getRequisitionIds().addAll(sendKey.getRequisitionIds());
                    this.correlateRequisition(ctx, params, receiveKey.getRequisitionIds(), CORRELATION_WAY_AUTO);
                    correlatedCount += receiveKey.getRequisitionIds().size();
                    sendKeys.remove(j);
                    continue block5;
                }
            }
        }
        finally {
            receiveGroup.clear();
            sendGroup.clear();
            receiveKeys.clear();
            sendKeys.clear();
        }
        return correlatedCount;
    }

    private void addGroup(Map group, IRowSet rs, boolean isReceive) throws SQLException {
        this.addGroup(group, rs, isReceive, false);
    }

    private void addGroup(Map group, IRowSet rs, boolean isReceive, boolean isDiffCyCorrelation) throws SQLException {
        String fieldName = null;
        fieldName = isReceive ? "fsenderid" : "freceiverid";
        CollectKey key = new CollectKey(rs.getString(fieldName), rs.getString("fprimaryItemId"), rs.getString("fcurrencyId"), rs.getString("fperiodId"), rs.getInt("fstatus"), rs.getInt("fdirection"));
        Object object = group.get(key);
        if (object == null) {
            group.put(key, key);
            object = key;
        }
        ((CollectKey)object).addAmount(rs.getBigDecimal("foriginalamount"));
        ((CollectKey)object).addRequsitionId(rs.getString("fid"));
        if (isDiffCyCorrelation) {
            key.setBaseCurrcncyId(rs.getString("fbaseCurrencyId"));
            key.addTotalAmount(rs.getBigDecimal("flocalAmount"));
        }
    }

    private void manualSpecialCorrelation(Context ctx, Map params, IRowSet rsReq, boolean isReceiveReq, StringBuffer msgCollector, Map cachedCorrelator) throws SQLException, BOSException, EASBizException {
        String companyField = null;
        companyField = isReceiveReq ? "fsenderid" : "freceiverid";
        StringBuffer sbStatus = new StringBuffer();
        BigDecimal totalAmount = GlUtils.zero;
        String preCompany = null;
        String preCurrency = null;
        boolean isFirst = true;
        ArrayList<String> reqIds = new ArrayList<String>();
        boolean hasRecord = false;
        GlParam paramMap = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_124"}, null);
        String GL_124 = paramMap.getString("GL_124");
        while (rsReq.next()) {
            hasRecord = true;
            if (isFirst) {
                preCompany = rsReq.getString(companyField);
                preCurrency = rsReq.getString("fcurrencyid");
                isFirst = false;
            }
            if (preCompany != null && !preCompany.equals(rsReq.getString(companyField))) {
                msgCollector.append(this.getResource(ctx, COMPANY_NOT_SAME, null));
                return;
            }
            if (preCurrency != null && !preCurrency.equals(rsReq.getString("fcurrencyid"))) {
                msgCollector.append(this.getResource(ctx, CURRENCY_NOT_SAME, null));
                return;
            }
            totalAmount = rsReq.getInt("fdirection") == 1 ? totalAmount.add(rsReq.getBigDecimal("foriginalamount")) : totalAmount.add(rsReq.getBigDecimal("foriginalamount").negate());
            preCompany = rsReq.getString(companyField);
            preCurrency = rsReq.getString("fcurrencyid");
            reqIds.add(rsReq.getString("fid"));
            String statusMsg = this.getVoucherStatusMessage(ctx, rsReq, GL_124);
            if (EMPTY_STRING.equals(statusMsg)) continue;
            sbStatus.append(statusMsg).append(LINE_SEPARATOR);
        }
        if (!hasRecord) {
            return;
        }
        if (totalAmount.signum() != 0) {
            msgCollector.append(this.getResource(ctx, CFREQ_CHANGED, null) + LINE_SEPARATOR + this.getResource(ctx, IN_NOT_EQUALS_OUT, null));
            return;
        }
        if (sbStatus.length() != 0) {
            msgCollector.append(sbStatus);
            return;
        }
        String curCompany = (String)params.get("currentCompanyId");
        if (!this.curCompanyIsCorrelaotr(ctx, curCompany, preCompany, msgCollector, cachedCorrelator)) {
            return;
        }
        this.correlateRequisition(ctx, params, reqIds, CORRELATION_WAY_MANUAL);
    }

    private boolean canMakeCorrelation(Context ctx, Map params, IRowSet rsReceive, IRowSet rsSend, List reqIdsCollector, StringBuffer msgCollector, Map cachedCorrelator) throws BOSException, SQLException, EASBizException {
        return this.canMakeCorrelation(ctx, params, rsReceive, rsSend, reqIdsCollector, msgCollector, cachedCorrelator, false);
    }

    private boolean canMakeCorrelation(Context ctx, Map params, IRowSet rsReceive, IRowSet rsSend, List reqIdsCollector, StringBuffer msgCollector, Map cachedCorrelator, boolean isDiffCyCorrelation) throws BOSException, SQLException, EASBizException {
        BigDecimal receiveAmount = GlUtils.zero;
        BigDecimal sendAmount = GlUtils.zero;
        BigDecimal receiveLocalAmount = GlUtils.zero;
        BigDecimal sendLocalAmount = GlUtils.zero;
        StringBuffer sbStatus = new StringBuffer();
        String preCompany = null;
        String preCurrency = null;
        String preBaseCurrency = null;
        boolean isFirst = true;
        GlParam paramMap = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_124"}, null);
        String GL_124 = paramMap.getString("GL_124");
        while (rsReceive.next()) {
            if (isFirst) {
                preCompany = rsReceive.getString("fsenderid");
                preCurrency = rsReceive.getString("fcurrencyid");
                preBaseCurrency = isDiffCyCorrelation ? rsReceive.getString("fbaseCurrencyId") : null;
                isFirst = false;
            }
            if (preCompany != null && !preCompany.equals(rsReceive.getString("fsenderid"))) {
                msgCollector.append(this.getResource(ctx, COMPANY_NOT_SAME, null));
                return false;
            }
            if (preCurrency != null && !preCurrency.equals(rsReceive.getString("fcurrencyid"))) {
                msgCollector.append(this.getResource(ctx, CURRENCY_NOT_SAME, null));
                return false;
            }
            if (isDiffCyCorrelation && preBaseCurrency != null && !preBaseCurrency.equals(rsReceive.getString("fbaseCurrencyId"))) {
                msgCollector.append(this.getResource(ctx, BASECURRENCY_NOT_SAME, null));
                return false;
            }
            if (rsReceive.getInt("fdirection") == 1) {
                receiveAmount = receiveAmount.add(rsReceive.getBigDecimal("foriginalamount"));
                if (isDiffCyCorrelation) {
                    receiveLocalAmount = receiveLocalAmount.add(rsReceive.getBigDecimal("flocalAmount"));
                }
            } else {
                receiveAmount = receiveAmount.add(rsReceive.getBigDecimal("foriginalamount").negate());
                if (isDiffCyCorrelation) {
                    receiveLocalAmount = receiveLocalAmount.add(rsReceive.getBigDecimal("flocalAmount").negate());
                }
            }
            preCompany = rsReceive.getString("fsenderid");
            preCurrency = rsReceive.getString("fcurrencyid");
            preBaseCurrency = isDiffCyCorrelation ? rsReceive.getString("fbaseCurrencyId") : null;
            reqIdsCollector.add(rsReceive.getString("fid"));
            String statusMsg = this.getVoucherStatusMessage(ctx, rsReceive, GL_124);
            if (EMPTY_STRING.equals(statusMsg)) continue;
            sbStatus.append(statusMsg).append(LINE_SEPARATOR);
        }
        String preCurrencySend = null;
        while (rsSend.next()) {
            if (preCompany != null && !preCompany.equals(rsSend.getString("freceiverid"))) {
                msgCollector.append(this.getResource(ctx, COMPANY_NOT_SAME, null));
                return false;
            }
            if (preCurrencySend == null) {
                preCurrencySend = rsSend.getString("fcurrencyid");
            }
            if (isDiffCyCorrelation) {
                if (preCurrency != null && preCurrency.equals(rsSend.getString("fcurrencyid"))) {
                    msgCollector.append(this.getResource(ctx, DIFFCY_CURRENCY_SAME, null));
                    return false;
                }
                if (!preCurrencySend.equals(rsSend.getString("fcurrencyid"))) {
                    msgCollector.append(this.getResource(ctx, BASECURRENCY_NOT_SAME_2, null));
                    return false;
                }
                if (preBaseCurrency != null && !preBaseCurrency.equals(rsSend.getString("fbaseCurrencyId"))) {
                    msgCollector.append(this.getResource(ctx, BASECURRENCY_NOT_SAME, null));
                }
            } else if (preCurrency != null && !preCurrency.equals(preCurrencySend) || !preCurrencySend.equals(rsSend.getString("fcurrencyid"))) {
                msgCollector.append(this.getResource(ctx, CURRENCY_NOT_SAME, null));
                return false;
            }
            if (rsSend.getInt("fdirection") == 1) {
                if (isDiffCyCorrelation) {
                    sendLocalAmount = sendLocalAmount.add(rsSend.getBigDecimal("flocalAmount"));
                } else {
                    sendAmount = sendAmount.add(rsSend.getBigDecimal("foriginalamount"));
                }
            } else if (isDiffCyCorrelation) {
                sendLocalAmount = sendLocalAmount.add(rsSend.getBigDecimal("flocalAmount").negate());
            } else {
                sendAmount = sendAmount.add(rsSend.getBigDecimal("foriginalamount").negate());
            }
            preCompany = rsSend.getString("freceiverid");
            preCurrencySend = rsSend.getString("fcurrencyid");
            preBaseCurrency = isDiffCyCorrelation ? rsSend.getString("fbaseCurrencyId") : null;
            reqIdsCollector.add(rsSend.getString("fid"));
            String statusMsg = this.getVoucherStatusMessage(ctx, rsSend, GL_124);
            if (EMPTY_STRING.equals(statusMsg)) continue;
            sbStatus.append(statusMsg).append(LINE_SEPARATOR);
        }
        if (isDiffCyCorrelation) {
            if (receiveLocalAmount.add(sendLocalAmount).signum() != 0) {
                msgCollector.append(this.getResource(ctx, CFREQ_CHANGED, null) + LINE_SEPARATOR + this.getResource(ctx, LOCAL_AMT_SUM_NOT_EQUAL_ZERO, new Object[]{receiveLocalAmount, sendLocalAmount}));
                return false;
            }
        } else if (receiveAmount.add(sendAmount).signum() != 0) {
            msgCollector.append(this.getResource(ctx, CFREQ_CHANGED, null) + LINE_SEPARATOR + this.getResource(ctx, SUM_NOT_EQUAL_ZERO, new Object[]{receiveAmount, sendAmount}));
            return false;
        }
        if (sbStatus.length() != 0) {
            msgCollector.append(sbStatus);
            return false;
        }
        String curCompany = (String)params.get("currentCompanyId");
        return this.curCompanyIsCorrelaotr(ctx, curCompany, preCompany, msgCollector, cachedCorrelator);
    }

    private String getVoucherStatusMessage(Context ctx, IRowSet rs, String manualAuditParam) throws SQLException, EASBizException, BOSException {
        if (PARAM_ALLOW_CFREQ_VALUE_UNENABLE.equals(manualAuditParam)) {
            return EMPTY_STRING;
        }
        if (3 == rs.getInt("fvoucherbizstatus") || 5 == rs.getInt("fvoucherbizstatus")) {
            return EMPTY_STRING;
        }
        StringBuffer message = new StringBuffer();
        message.append(this.getResource(ctx, VOUCHER_NOT_AUDIT, new Object[]{rs.getString("fvouchercompanyname"), rs.getString("fvoucherperiod"), rs.getString("fvouchernumber")}));
        return message.toString();
    }

    private boolean curCompanyIsCorrelaotr(Context ctx, String curCompany, String oppCompany, StringBuffer msgCollector, Map cachedCorrelator) throws BOSException, SQLException {
        CorrelatorKey correlator = this.getCorrelator(ctx, curCompany, oppCompany, cachedCorrelator);
        if (correlator == null || correlator.getCorrelatorId() == null) {
            return true;
        }
        if (!curCompany.equals(correlator.getCorrelatorId())) {
            msgCollector.append(this.getResource(ctx, "CorrelatorNotCorrect", new Object[]{correlator.getCorrelatorName()}));
            return false;
        }
        return true;
    }

    private boolean curCompanyIsCorrelaotr(Context ctx, String curCompany, String oppCompany, Map cachedCorrelator) throws BOSException, SQLException {
        CorrelatorKey correlator = this.getCorrelator(ctx, curCompany, oppCompany, cachedCorrelator);
        if (correlator == null || correlator.getCorrelatorId() == null) {
            return true;
        }
        return curCompany.equals(correlator.getCorrelatorId());
    }

    private CorrelatorKey getCorrelator(Context ctx, String curCompany, String oppCompany, Map cachedCorrelator) throws BOSException, SQLException {
        CorrelatorKey comparedKey = new CorrelatorKey();
        comparedKey.setSenderId(curCompany);
        comparedKey.setReceiverId(oppCompany);
        return (CorrelatorKey)cachedCorrelator.get(comparedKey);
    }

    private void prepareSetting(Context ctx, String curCompany, Map cachedCorrelator) throws BOSException {
        String localeName = "fname_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = "select t2.fid,t2." + localeName + ",t1.freceiverid from t_bd_cfcorrelationsetting t1 inner join t_org_company t2 on t1.fcorrelatorid=t2.fid where fsenderid=?";
        Object[] sqlParams = new Object[]{curCompany};
        IRowSet rsSetting = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])sqlParams);
        try {
            while (rsSetting.next()) {
                CorrelatorKey key = new CorrelatorKey();
                key.setSenderId(curCompany);
                key.setReceiverId(rsSetting.getString(3));
                key.setCorrelatorId(rsSetting.getString(1));
                key.setCorrelatorName(rsSetting.getString(2));
                cachedCorrelator.put(key, key);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void correlateRequisition(Context ctx, Map params, List requisitionIds, String correlationWay) throws BOSException, EASBizException {
        int i;
        ArrayList<Object> sqlUpdateParams = new ArrayList<Object>();
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update t_gl_cfrequisition set fstatus=?,fcorrelationnum=?,");
        updateSql.append(" fcorrelationdate=?,fcorrelationorgid=?,fcorrelationuserid=?,fcorrelationway=");
        updateSql.append(correlationWay);
        java.util.Date now = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        sqlUpdateParams.add(Integer.valueOf(CORRELATION_WAY_AUTO));
        sqlUpdateParams.add(this.getNextCorrelationNumber((CompanyOrgUnitInfo)params.get("currentCompany")));
        sqlUpdateParams.add(new Date(now.getTime()));
        sqlUpdateParams.add(params.get("currentCompanyId"));
        sqlUpdateParams.add(user.getId().toString());
        updateSql.append(" where fid in(''");
        int size = requisitionIds.size();
        for (i = 0; i < size; ++i) {
            updateSql.append(",?");
            sqlUpdateParams.add(requisitionIds.get(i));
        }
        updateSql.append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])sqlUpdateParams.toArray());
        updateSql.setLength(0);
        sqlUpdateParams.clear();
        updateSql.append("update t_gl_cfrequisition set fIsAvoidCheck = 0");
        updateSql.append(" where fid in(''");
        size = requisitionIds.size();
        for (i = 0; i < size; ++i) {
            updateSql.append(",?");
            sqlUpdateParams.add(requisitionIds.get(i));
        }
        updateSql.append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])sqlUpdateParams.toArray());
    }

    private String getNextCorrelationNumber(CompanyOrgUnitInfo correlationCompany) {
        String companyNumber = correlationCompany.getNumber();
        String date = DateTimeUtils.format((java.util.Date)new java.util.Date());
        return companyNumber + " " + date;
    }

    private void manualCorrelation(Context ctx, Map params, IRowSet rsReceive, IRowSet rsSend, Map cachedCorrelator, boolean isDiffCyCorrelation) throws SQLException, BOSException, EASBizException {
        ArrayList reqIdsCollector = new ArrayList();
        StringBuffer msgCollector = new StringBuffer();
        if (!this.canMakeCorrelation(ctx, params, rsReceive, rsSend, reqIdsCollector, msgCollector, cachedCorrelator, isDiffCyCorrelation)) {
            throw new BOSException(msgCollector.toString());
        }
        this.correlateRequisition(ctx, params, reqIdsCollector, CORRELATION_WAY_MANUAL);
    }

    protected ICodingRuleManager getCodingRuleCtrl(Context ctx) throws BOSException {
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx);
    }

    private int autoCorrelation(Context ctx, Map params, IRowSet rsReceive, IRowSet rsSend, Map cachedCorrelator) throws SQLException, NumberFormatException, BOSException, EASBizException {
        return this.autoCorrelation(ctx, params, rsReceive, rsSend, cachedCorrelator, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int autoCorrelation(Context ctx, Map params, IRowSet rsReceive, IRowSet rsSend, Map cachedCorrelator, boolean isDiffCyCorrelation) throws SQLException, NumberFormatException, BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update t_gl_cfrequisition set fstatus=?,fcorrelationnum=?,");
        updateSql.append(" fcorrelationdate=?,fcorrelationorgid=?,fcorrelationuserid=?,fcorrelationway=");
        updateSql.append(CORRELATION_WAY_AUTO);
        updateSql.append(" where fid=? or fid=?");
        java.util.Date now = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String curCompany = (String)params.get("currentCompanyId");
        int batchCount = 0;
        int correlatedCount = 0;
        Connection con = null;
        PreparedStatement st = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            st = con.prepareStatement(updateSql.toString());
            List listReceive = this.translateRowSet(rsReceive, isDiffCyCorrelation);
            List listSend = this.translateRowSet(rsSend, isDiffCyCorrelation);
            CFRequisition cfReceive = null;
            CFRequisition cfSend = null;
            int rSize = listReceive.size();
            block2: for (int i = 0; i < rSize; ++i) {
                for (int j = listSend.size() - 1; j >= 0; --j) {
                    cfReceive = (CFRequisition)listReceive.get(i);
                    if (!this.canCFRequisitionAutoCorrelation(ctx, curCompany, cfReceive, cfSend = (CFRequisition)listSend.get(j), cachedCorrelator, isDiffCyCorrelation)) continue;
                    int paramIndex = 1;
                    st.setInt(paramIndex++, Integer.valueOf(CORRELATION_WAY_AUTO));
                    DbUtil.prepareVarcharParam((PreparedStatement)st, (int)paramIndex++, (String)this.getNextCorrelationNumber((CompanyOrgUnitInfo)params.get("currentCompany")));
                    st.setDate(paramIndex++, new Date(now.getTime()));
                    DbUtil.prepareVarcharParam((PreparedStatement)st, (int)paramIndex++, (String)curCompany);
                    DbUtil.prepareVarcharParam((PreparedStatement)st, (int)paramIndex++, (String)user.getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)st, (int)paramIndex++, (String)cfReceive.getId());
                    DbUtil.prepareVarcharParam((PreparedStatement)st, (int)paramIndex++, (String)cfSend.getId());
                    st.addBatch();
                    ++correlatedCount;
                    if (++batchCount % 2000 == 0) {
                        batchCount = 0;
                        st.executeBatch();
                        st.clearBatch();
                    }
                    listSend.remove(j);
                    continue block2;
                }
            }
            if (batchCount > 0) {
                st.executeBatch();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(st, (Connection)con);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)st, (Connection)con);
        return correlatedCount * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int autoSpecialCorrelation(Context ctx, Map params, IRowSet rs, boolean isReceive, Map cachedCorrelator) throws SQLException, NumberFormatException, BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update t_gl_cfrequisition set fstatus=?,fcorrelationnum=?,");
        updateSql.append(" fcorrelationdate=?,fcorrelationorgid=?,fcorrelationuserid=?,fcorrelationway=");
        updateSql.append(CORRELATION_WAY_AUTO);
        updateSql.append(" where fid=? or fid=?");
        java.util.Date now = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String curCompany = (String)params.get("currentCompanyId");
        int batchCount = 0;
        int correlatedCount = 0;
        Connection con = null;
        PreparedStatement st = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            st = con.prepareStatement(updateSql.toString());
            List listReceive = this.translateRowSet(rs);
            CFRequisition cfCurrent = null;
            CFRequisition cfPrev = null;
            block2: for (int i = listReceive.size() - 1; i >= 0; --i) {
                for (int j = i - 1; j >= 0; --j) {
                    cfCurrent = (CFRequisition)listReceive.get(i);
                    if (!this.canCFRequisitionAutoSpecialCorrelation(ctx, curCompany, cfCurrent, cfPrev = (CFRequisition)listReceive.get(j), isReceive, cachedCorrelator)) continue;
                    int paramIndex = 1;
                    st.setInt(paramIndex++, Integer.valueOf(CORRELATION_WAY_AUTO));
                    DbUtil.prepareVarcharParam((PreparedStatement)st, (int)paramIndex++, (String)this.getNextCorrelationNumber((CompanyOrgUnitInfo)params.get("currentCompany")));
                    st.setDate(paramIndex++, new Date(now.getTime()));
                    DbUtil.prepareVarcharParam((PreparedStatement)st, (int)paramIndex++, (String)curCompany);
                    DbUtil.prepareVarcharParam((PreparedStatement)st, (int)paramIndex++, (String)user.getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)st, (int)paramIndex++, (String)cfCurrent.getId());
                    DbUtil.prepareVarcharParam((PreparedStatement)st, (int)paramIndex++, (String)cfPrev.getId());
                    st.addBatch();
                    ++correlatedCount;
                    if (++batchCount % 2000 == 0) {
                        batchCount = 0;
                        st.executeBatch();
                        st.clearBatch();
                    }
                    listReceive.remove(j);
                    --i;
                    continue block2;
                }
            }
            if (batchCount > 0) {
                st.executeBatch();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(st, (Connection)con);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)st, (Connection)con);
        return correlatedCount * 2;
    }

    private boolean canCFRequisitionAutoCorrelation(Context ctx, String curCompany, CFRequisition cfReceive, CFRequisition cfSend, Map cachedCorrelator, boolean isDiffCyCorrelation) throws BOSException, SQLException {
        if (isDiffCyCorrelation) {
            BigDecimal sendLocalAmt;
            if (!cfReceive.getSenderId().equals(cfSend.getReceiverId()) || cfReceive.getCurrencyId().equals(cfSend.getCurrencyId()) || !cfReceive.getBaseCurrencyId().equals(cfSend.getBaseCurrencyId())) {
                return false;
            }
            BigDecimal receiveLocalAmt = cfReceive.getLocalAmt().multiply(cfReceive.getDirection() == 1 ? GlUtils.one : GlUtils.negone);
            if (receiveLocalAmt.add(sendLocalAmt = cfSend.getLocalAmt().multiply(cfSend.getDirection() == 1 ? GlUtils.one : GlUtils.negone)).signum() != 0) {
                return false;
            }
        } else {
            BigDecimal sendAmt;
            if (!cfReceive.getSenderId().equals(cfSend.getReceiverId()) || !cfReceive.getCurrencyId().equals(cfSend.getCurrencyId())) {
                return false;
            }
            BigDecimal receiveAmt = cfReceive.getAmount().multiply(cfReceive.getDirection() == 1 ? GlUtils.one : GlUtils.negone);
            if (receiveAmt.add(sendAmt = cfSend.getAmount().multiply(cfSend.getDirection() == 1 ? GlUtils.one : GlUtils.negone)).signum() != 0) {
                return false;
            }
        }
        return this.curCompanyIsCorrelaotr(ctx, curCompany, cfReceive.getSenderId(), cachedCorrelator);
    }

    private boolean canCFRequisitionAutoSpecialCorrelation(Context ctx, String curCompany, CFRequisition cfCurrent, CFRequisition cfPrev, boolean isReceive, Map cachedCorrelator) throws BOSException, SQLException {
        BigDecimal preDirection;
        if (isReceive ? !cfCurrent.getSenderId().equals(cfPrev.getSenderId()) || !cfCurrent.getCurrencyId().equals(cfPrev.getCurrencyId()) : !cfCurrent.getReceiverId().equals(cfPrev.getReceiverId()) || !cfCurrent.getCurrencyId().equals(cfPrev.getCurrencyId())) {
            return false;
        }
        BigDecimal curDirection = cfCurrent.getDirection() == 1 ? GlUtils.one : GlUtils.negone;
        BigDecimal bigDecimal = preDirection = cfPrev.getDirection() == 1 ? GlUtils.one : GlUtils.negone;
        if (cfCurrent.getAmount().multiply(curDirection).add(cfPrev.getAmount().multiply(preDirection)).signum() != 0) {
            return false;
        }
        String oppCompany = null;
        oppCompany = isReceive ? cfCurrent.getSenderId() : cfCurrent.getReceiverId();
        return this.curCompanyIsCorrelaotr(ctx, curCompany, oppCompany, cachedCorrelator);
    }

    @Override
    protected String _cancelCorrelation(Context ctx, Map params) throws BOSException, EASBizException {
        List receiveIds = (List)params.get("selectedReceiveIds");
        List sendIds = (List)params.get("selectedSendIds");
        receiveIds.addAll(sendIds);
        String curCompany = (String)params.get("currentCompanyId");
        if (receiveIds == null || receiveIds.size() == 0) {
            return null;
        }
        ArrayList sqlQueryParams = new ArrayList();
        StringBuffer sqlQuery = new StringBuffer();
        sqlQuery.append("select distinct fcorrelationnum,fcorrelationorgid from t_gl_cfrequisition where fid in(''");
        int size = receiveIds.size();
        for (int i = 0; i < size; ++i) {
            sqlQuery.append(",?");
            sqlQueryParams.add(receiveIds.get(i));
        }
        sqlQuery.append(") \r\n");
        ArrayList<String> correlationNumbers = new ArrayList<String>();
        StringBuffer msgCollector = new StringBuffer();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlQuery.toString(), (Object[])sqlQueryParams.toArray());
        StringBuffer sqlSetting = new StringBuffer();
        sqlSetting.append("select cf.fcorrelatorid,");
        sqlSetting.append("com.fname_").append(ctx.getLocale().toString());
        sqlSetting.append(" from t_bd_cfcorrelationsetting cf ");
        sqlSetting.append(" inner join t_org_company com on cf.fcorrelatorid = com.fid");
        sqlSetting.append(" where fsenderid=? and freceiverid=?");
        StringBuffer sqlCFReq = new StringBuffer();
        sqlCFReq.append("select cf.fsenderid,cf.freceiverid,cf.FCorrelationOrgID,");
        sqlCFReq.append("com.fname_").append(ctx.getLocale().toString());
        sqlCFReq.append(" from t_gl_cfrequisition cf ");
        sqlCFReq.append(" inner join t_org_company com on cf.FCorrelationOrgID = com.fid");
        sqlCFReq.append(" where fcorrelationnum=?");
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        ParamItemInfo paramAsst = pc.getParamItemByNumberAndOrg("GL_123", curCompany);
        boolean postRequired = "true".equals(paramAsst.getValue());
        try {
            while (rs.next()) {
                IRowSet rsCFReq = DbUtil.executeQuery((Context)ctx, (String)sqlCFReq.toString(), (Object[])new Object[]{rs.getString(1)});
                if (!rsCFReq.next()) continue;
                IRowSet rsSetting = DbUtil.executeQuery((Context)ctx, (String)sqlSetting.toString(), (Object[])new Object[]{rsCFReq.getString(1), rsCFReq.getString(2)});
                if (!rsSetting.next()) {
                    if (postRequired && !curCompany.equals(rsCFReq.getString(3))) {
                        msgCollector.append(this.getResource(ctx, UNABLE_CORRELATION, new Object[]{rs.getString(1), rsCFReq.getString(4)}));
                        msgCollector.append(LINE_SEPARATOR);
                        continue;
                    }
                    correlationNumbers.add(rs.getString(1));
                    continue;
                }
                if (postRequired && curCompany.equals(rsSetting.getString(1)) && curCompany.equals(rsCFReq.getString(3))) {
                    correlationNumbers.add(rs.getString(1));
                    continue;
                }
                msgCollector.append(this.getResource(ctx, UNABLE_CORRELATIONZ, new Object[]{rs.getString(1), rsCFReq.getString(4), rsSetting.getString(2)}));
                msgCollector.append(LINE_SEPARATOR);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList<Integer> sqlParams = new ArrayList<Integer>();
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update t_gl_cfrequisition set fstatus=?,");
        updateSql.append(" fcorrelationnum=null,");
        updateSql.append(" fcorrelationdate=null,fcorrelationorgid=null,");
        updateSql.append(" fcorrelationuserid=null");
        updateSql.append(" where fcorrelationnum in (''");
        sqlParams.add(Integer.valueOf(CORRELATION_WAY_MANUAL));
        int size2 = correlationNumbers.size();
        for (int i = 0; i < size2; ++i) {
            updateSql.append(",?");
            sqlParams.add((Integer)correlationNumbers.get(i));
        }
        updateSql.append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])sqlParams.toArray());
        if (msgCollector.length() > 0) {
            return msgCollector.toString();
        }
        return null;
    }

    private String getSelectedDetailRequisition(Context ctx, Map params, List selectedIds) {
        return this.getSelectedDetailRequisition(ctx, params, selectedIds, false);
    }

    private String getSelectedDetailRequisition(Context ctx, Map params, List selectedIds, boolean isDiffCyCorrelation) {
        String localeName = "fname_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select cfrequisition.fid as fid,\r\n");
        sql.append("       sender.fid as fsenderid,\r\n");
        sql.append("       receiver.fid as freceiverid,\r\n");
        sql.append("       entry.fcurrencyid as fcurrencyid,\r\n");
        sql.append("     cfrecord.foriginalamount * cfrecord.fprimarycoeffient as foriginalamount,\r\n");
        if (isDiffCyCorrelation) {
            sql.append("       cfrecord.FLocalAmount*cfrecord.fprimarycoeffient flocalAmount,");
            sql.append("       BASECURRENCY.FID fbaseCurrencyId,BASECURRENCY.FPrecision fbaseCurrencyPrecision, \r\n");
        }
        sql.append("       primaryitem.fdirection as fdirection, \r\n");
        sql.append("       voucher.fbizstatus as fvoucherbizstatus, \r\n");
        sql.append("       ((to_char(period.fperiodyear) || '.') || to_char(period.fperiodnumber)) as fvoucherperiod, \r\n");
        sql.append("       voucher.fnumber as fvouchernumber, \r\n");
        sql.append("       vouchercompany.").append(localeName).append(" as fvouchercompanyname \r\n");
        sql.append("from t_gl_cfrequisition as cfrequisition  \r\n");
        sql.append("inner join t_gl_cashflowrecord as cfrecord  \r\n");
        sql.append("on cfrequisition.fcfrecordid = cfrecord.fid  \r\n");
        sql.append("inner join t_org_company as receiver  \r\n");
        sql.append("on cfrequisition.freceiverid = receiver.fid  \r\n");
        sql.append("inner join t_org_company as sender  \r\n");
        sql.append("on cfrequisition.fsenderid = sender.fid  \r\n");
        sql.append("inner join t_bd_cashflowitem as primaryitem  \r\n");
        sql.append("on cfrecord.fprimaryitemid = primaryitem.fid  \r\n");
        sql.append("inner join t_gl_voucherentry as entry  \r\n");
        sql.append("on cfrecord.fentryid = entry.fid  \r\n");
        sql.append("inner join t_gl_voucher as voucher  \r\n");
        sql.append("on cfrecord.fvoucherid = voucher.fid  \r\n");
        sql.append("inner join t_bd_period as period  \r\n");
        sql.append("on voucher.fperiodid = period.fid  \r\n");
        sql.append("inner join t_org_company as vouchercompany  \r\n");
        sql.append("on voucher.fcompanyid = vouchercompany.fid  \r\n");
        if (isDiffCyCorrelation) {
            sql.append("INNER JOIN T_BD_Currency AS BASECURRENCY ");
            sql.append("ON SENDER.FBaseCurrencyID = BASECURRENCY.FID ");
        }
        sql.append("where cfrequisition.fid in (''");
        int size = selectedIds.size();
        for (int i = 0; i < size; ++i) {
            sql.append(",'").append(selectedIds.get(i)).append("'");
        }
        sql.append(")\r\n");
        sql.append(" and cfrequisition.fstatus='");
        sql.append(CORRELATION_WAY_MANUAL).append("'");
        return sql.toString();
    }

    private String getSelectedCollectRequisition(Context ctx, Map params, List receiveIds, List sqlParams, boolean isReceive) {
        return this.getSelectedCollectRequisition(ctx, params, receiveIds, sqlParams, isReceive, false);
    }

    private String getSelectedCollectRequisition(Context ctx, Map params, List receiveIds, List sqlParams, boolean isReceive, boolean isDiffCy) {
        String localeName = "fname_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        boolean isOnlyDisplayCanCheck = params.get("query_DisplayCanCheck") == null ? false : (Boolean)params.get("query_DisplayCanCheck");
        boolean isNeedJoinSettingTableQuery = false;
        HashMap cachedCorrelator = new HashMap();
        String curCompany = (String)params.get("currentCompanyId");
        try {
            this.prepareSetting(ctx, curCompany, cachedCorrelator);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        isNeedJoinSettingTableQuery = cachedCorrelator.size() != 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select * from \r\n");
        sql.append("(\r\n");
        sql.append("select cfrequisition.fid as fid,\r\n");
        sql.append("       sender.fid as fsenderid,\r\n");
        sql.append("       receiver.fid as freceiverid,\r\n");
        sql.append("       entry.fcurrencyid as fcurrencyid,\r\n");
        sql.append("       cfrecord.foriginalamount * cfrecord.fprimarycoeffient as foriginalamount,\r\n");
        sql.append("       primaryitem.fdirection as fdirection, \r\n");
        sql.append("       voucher.fbizstatus as fvoucherbizstatus, \r\n");
        sql.append("       ((to_char(period.fperiodyear) || '.') || to_char(period.fperiodnumber)) as fvoucherperiod, \r\n");
        sql.append("       voucher.fnumber as fvouchernumber, \r\n");
        sql.append("       vouchercompany.").append(localeName).append(" as fvouchercompanyname, \r\n");
        if (isDiffCy) {
            sql.append("       cfrecord.FLocalAmount*cfrecord.fprimarycoeffient flocalAmount,");
            sql.append("       BASECURRENCY.FID fbaseCurrencyId,BASECURRENCY.FPrecision fbaseCurrencyPrecision, \r\n");
        }
        if (isReceive) {
            sql.append("       sender.fid||currency.fid||primaryitem.fid||period.fid||fstatus as fspecial \r\n");
        } else {
            sql.append("       receiver.fid||currency.fid||primaryitem.fid||period.fid||fstatus as fspecial \r\n");
        }
        sql.append("from t_gl_cfrequisition as cfrequisition  \r\n");
        sql.append("inner join t_gl_cashflowrecord as cfrecord  \r\n");
        sql.append("on cfrequisition.fcfrecordid = cfrecord.fid  \r\n");
        sql.append("inner join t_gl_voucherentry as entry  \r\n");
        sql.append("on cfrecord.fentryid = entry.fid  \r\n");
        sql.append("inner join t_gl_voucher as voucher  \r\n");
        sql.append("on cfrecord.fvoucherid = voucher.fid  \r\n");
        sql.append("inner join t_org_company as receiver  \r\n");
        sql.append("on cfrequisition.freceiverid = receiver.fid  \r\n");
        sql.append("inner join t_org_company as sender  \r\n");
        sql.append("on cfrequisition.fsenderid = sender.fid  \r\n");
        sql.append("inner join t_bd_cashflowitem as primaryitem  \r\n");
        sql.append("on cfrecord.fprimaryitemid = primaryitem.fid  \r\n");
        sql.append("inner join t_bd_currency as currency  \r\n");
        sql.append("on entry.fcurrencyid = currency.fid  \r\n");
        sql.append("inner join t_bd_period as period  \r\n");
        sql.append("on voucher.fperiodid = period.fid  \r\n");
        sql.append("inner join t_org_company as vouchercompany  \r\n");
        sql.append("on voucher.fcompanyid = vouchercompany.fid  \r\n");
        if (isDiffCy) {
            sql.append("INNER JOIN T_BD_Currency AS BASECURRENCY ");
            sql.append("ON SENDER.FBaseCurrencyID = BASECURRENCY.FID ");
        }
        if (isOnlyDisplayCanCheck) {
            sql.append("left join T_BD_CFCorrelationSetting sett on (receiver.fid = sett.FReceiverId and sender.fid = sett.FSenderId)");
        }
        sql.append(this.computeWhere(ctx, params, isReceive, sqlParams)).append(LINE_SEPARATOR);
        if (isOnlyDisplayCanCheck) {
            if (isNeedJoinSettingTableQuery) {
                sql.append("  and (sett.FCorrelatorId = ? )");
            } else {
                sql.append("  and (sett.FCorrelatorId is null or  sett.FCorrelatorId = ? )");
            }
            sqlParams.add(params.get("currentCompanyId"));
        }
        sql.append(" and cfrequisition.fstatus='");
        sql.append(CORRELATION_WAY_MANUAL).append("'");
        sql.append(") t \r\n");
        sql.append(" where fspecial in (''");
        int size = receiveIds.size();
        for (int i = 0; i < size; ++i) {
            sql.append(",?");
            sqlParams.add(receiveIds.get(i));
        }
        sql.append(")");
        return sql.toString();
    }

    private String getCanCorrelationQueryString(Context ctx, Map params, List sqlParams, boolean isReceive) {
        return this.getCanCorrelationQueryString(ctx, params, sqlParams, isReceive, false);
    }

    private String getCanCorrelationQueryString(Context ctx, Map params, List sqlParams, boolean isReceive, boolean isDiffCy) {
        StringBuffer sql = new StringBuffer();
        boolean isOnlyDisplayCanCheck = params.get("query_DisplayCanCheck") == null ? false : (Boolean)params.get("query_DisplayCanCheck");
        boolean isNeedJoinSettingTableQuery = false;
        HashMap cachedCorrelator = new HashMap();
        String curCompany = (String)params.get("currentCompanyId");
        try {
            this.prepareSetting(ctx, curCompany, cachedCorrelator);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        isNeedJoinSettingTableQuery = cachedCorrelator.size() != 0;
        sql.append("select cfrequisition.fid as fid,\r\n");
        sql.append("       sender.fid as fsenderid,\r\n");
        sql.append("       receiver.fid as freceiverid,\r\n");
        sql.append("       currency.fid as fcurrencyid,\r\n");
        sql.append("       period.fid as fperiodid,\r\n");
        sql.append("       primaryitem.fid as fprimaryitemid,\r\n");
        sql.append("       cfrecord.foriginalamount * cfrecord.fprimarycoeffient as foriginalamount,\r\n");
        if (isDiffCy) {
            sql.append("       cfrecord.FLocalAmount*cfrecord.fprimarycoeffient flocalAmount,");
            sql.append("       BASECURRENCY.FID fbaseCurrencyId,BASECURRENCY.FPrecision fbaseCurrencyPrecision, \r\n");
        }
        sql.append("       primaryitem.fdirection as fdirection, \r\n");
        sql.append("       cfrequisition.fstatus as fstatus \r\n");
        sql.append("from t_gl_cfrequisition as cfrequisition  \r\n");
        sql.append("inner join t_gl_cashflowrecord as cfrecord  \r\n");
        sql.append("on cfrequisition.fcfrecordid = cfrecord.fid  \r\n");
        sql.append("inner join t_org_company as receiver  \r\n");
        sql.append("on cfrequisition.freceiverid = receiver.fid  \r\n");
        sql.append("inner join t_org_company as sender  \r\n");
        sql.append("on cfrequisition.fsenderid = sender.fid  \r\n");
        sql.append("inner join t_bd_cashflowitem as primaryitem  \r\n");
        sql.append("on cfrecord.fprimaryitemid = primaryitem.fid  \r\n");
        sql.append("inner join t_gl_voucherentry as entry  \r\n");
        sql.append("on cfrecord.fentryid = entry.fid  \r\n");
        sql.append("inner join t_gl_voucher as voucher  \r\n");
        sql.append("on cfrecord.fvoucherid = voucher.fid  \r\n");
        sql.append("inner join t_bd_currency as currency  \r\n");
        sql.append("on entry.fcurrencyid = currency.fid  \r\n");
        if (isDiffCy) {
            sql.append("INNER JOIN T_BD_Currency AS BASECURRENCY ");
            sql.append("ON SENDER.FBaseCurrencyID = BASECURRENCY.FID ");
        }
        sql.append("inner join t_bd_period as period  \r\n");
        sql.append("on voucher.fperiodid = period.fid  \r\n");
        if (isOnlyDisplayCanCheck) {
            sql.append("left join T_BD_CFCorrelationSetting sett on (receiver.fid = sett.FReceiverId and sender.fid = sett.FSenderId)");
        }
        sql.append(this.computeWhere(ctx, params, isReceive, sqlParams)).append(LINE_SEPARATOR);
        if (isOnlyDisplayCanCheck) {
            if (isNeedJoinSettingTableQuery) {
                sql.append("  and (sett.FCorrelatorId = ? )");
            } else {
                sql.append("  and (sett.FCorrelatorId is null or  sett.FCorrelatorId = ? )");
            }
            sqlParams.add(params.get("currentCompanyId"));
        }
        if ("true".equals(params.get("manualAudit"))) {
            sql.append(" and (voucher.fbizstatus=? or voucher.fbizstatus=?)");
            sqlParams.add(new Integer(3));
            sqlParams.add(new Integer(5));
        }
        sql.append(" and cfrequisition.fstatus='");
        sql.append(CORRELATION_WAY_MANUAL).append("'");
        return sql.toString();
    }

    @Override
    protected IRowSet _queryCorrelationCFRequisition(Context ctx, Map params) throws BOSException, EASBizException {
        String localeName = "fname_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select receiver.").append(localeName).append(" as freceivername, receiver.fnumber as freceivernumber,\r\n");
        sql.append("sender.").append(localeName).append(" as fsendername, sender.fnumber as fsendernumber,\r\n");
        sql.append("((to_char(period.fperiodyear) || '.') || to_char(period.fperiodnumber)) as fvoucherperiod, \r\n");
        sql.append("period.fnumber as fperiodnumber, \r\n");
        sql.append("voucher.fnumber as fvouchernumber, \r\n");
        sql.append("primaryitem.").append(localeName).append(" as fprimaryitemname,");
        sql.append("primaryitem.fnumber as fprimaryitemnumber,\r\n");
        sql.append("primaryitem.fdirection as fprimaryitemdirection, \r\n");
        sql.append("currency.").append(localeName).append(" as fcurrencyname,");
        sql.append("currency.fnumber as fcurrencynumber,currency.fprecision as fprecision, \r\n");
        sql.append("cfrecord.foriginalamount  * cfrecord.fprimarycoeffient as foriginalamount, \r\n");
        sql.append("cfrequisition.fstatus as fstatus, \r\n");
        sql.append("cfrequisition.fcorrelationnum as fcorrelationnum, \r\n");
        sql.append("cfrequisition.fid as fid,sender.fid as fsenderid, receiver.fid as freceiverid,\r\n");
        sql.append("cfrecord.fprimaryitemid as fprimaryitemid,period.fid as fperiodid,\r\n");
        sql.append("currency.fid as fcurrencyid,cfrequisition.fdescription as fdescription,0 as fischecked \r\n");
        sql.append("from t_gl_cfrequisition as cfrequisition  \r\n");
        sql.append("inner join t_gl_cashflowrecord as cfrecord  \r\n");
        sql.append("on cfrequisition.fcfrecordid = cfrecord.fid  \r\n");
        sql.append("inner join t_org_company as receiver  \r\n");
        sql.append("on cfrequisition.freceiverid = receiver.fid  \r\n");
        sql.append("inner join t_org_company as sender  \r\n");
        sql.append("on cfrequisition.fsenderid = sender.fid  \r\n");
        sql.append("inner join t_bd_cashflowitem as primaryitem  \r\n");
        sql.append("on cfrecord.fprimaryitemid = primaryitem.fid  \r\n");
        sql.append("inner join t_gl_voucherentry as entry  \r\n");
        sql.append("on cfrecord.fentryid = entry.fid  \r\n");
        sql.append("inner join t_gl_voucher as voucher  \r\n");
        sql.append("on cfrecord.fvoucherid = voucher.fid  \r\n");
        sql.append("inner join t_bd_currency as currency  \r\n");
        sql.append("on entry.fcurrencyid = currency.fid  \r\n");
        sql.append("inner join t_bd_period as period  \r\n");
        sql.append("on voucher.fperiodid = period.fid  \r\n");
        List receiveIds = (List)params.get("selectedReceiveIds");
        List sendIds = (List)params.get("selectedSendIds");
        receiveIds.addAll(sendIds);
        ArrayList sqlParams = new ArrayList();
        sql.append("where cfrequisition.fcorrelationnum in (select fcorrelationnum from t_gl_cfrequisition where fid in(''");
        int size = receiveIds.size();
        for (int i = 0; i < size; ++i) {
            sql.append(",?");
            sqlParams.add(receiveIds.get(i));
        }
        sql.append(") \r\n");
        sql.append(") \r\n");
        sql.append("order by cfrequisition.fcorrelationnum asc \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlParams.toArray());
        return rs;
    }

    @Override
    protected IObjectCollection _getRelatedVoucher(Context ctx, Map params) throws BOSException, EASBizException {
        String cfReqId = (String)params.get("selectedId");
        if (cfReqId == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fvoucherid from t_gl_cfrequisition cfrequisition \r\n");
        sql.append("inner join t_gl_cashflowrecord cfrecord on cfrequisition.fcfrecordid=cfrecord.fid \r\n");
        sql.append("where cfrequisition.fid=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{cfReqId});
        String voucherId = null;
        try {
            if (rs.next()) {
                voucherId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (voucherId == null) {
            return null;
        }
        VoucherInfo voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherId), VoucherInfo.getDefaultSelector());
        if (voucher == null) {
            return null;
        }
        VoucherCollection collection = new VoucherCollection();
        collection.add(voucher);
        return collection;
    }

    @Override
    protected IRowSet _queryCFRequisition(Context ctx, Map params, boolean isCollect) throws BOSException, EASBizException {
        ArrayList sqlParams = new ArrayList();
        boolean isOnlyDisplayCanCheck = params.get("query_DisplayCanCheck") == null ? false : (Boolean)params.get("query_DisplayCanCheck");
        boolean isNeedJoinSettingTableQuery = false;
        HashMap cachedCorrelator = new HashMap();
        String curCompany = (String)params.get("currentCompanyId");
        this.prepareSetting(ctx, curCompany, cachedCorrelator);
        isNeedJoinSettingTableQuery = cachedCorrelator.size() != 0;
        String receiveStr = (String)params.get("isReceive");
        boolean isReceive = true;
        if (!"true".equals(receiveStr)) {
            isReceive = false;
        }
        String localeName = "fname_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        if (isCollect) {
            sql.append("select * from \r\n");
            sql.append("( \r\n");
            sql.append("select N'default-00000000' as fid, fsenderid,freceiverid,fprimaryitemid,\r\n");
            sql.append("fperiodid,fcurrencyid,fstatus,\r\n");
            sql.append("sender.").append(localeName).append(" as fsendername,");
            sql.append("sender.fnumber as fsendernumber,");
            sql.append("receiver.").append(localeName).append(" as freceivername,");
            sql.append("receiver.fnumber as freceivernumber,");
            sql.append("primaryitem.").append(localeName).append(" as fprimaryitemname,primaryitem.fnumber as fprimaryitemnumber,");
            sql.append("primaryitem.fdirection as fprimaryitemdirection, \r\n");
            sql.append("currency.").append(localeName).append(" as fcurrencyname,currency.fnumber as fcurrencynumber,currency.fprecision as fprecision, \r\n");
            sql.append("((to_char(period.fperiodyear) || '.') || to_char(period.fperiodnumber)) as fvoucherperiod, \r\n");
            sql.append("period.fnumber as fperiodnumber,");
            sql.append("cfrequisition.foriginalamount as foriginalamount, \r\n");
            if (isReceive) {
                sql.append("sender.fid||currency.fid||primaryitem.fid||period.fid||fstatus as fspecial \r\n");
            } else {
                sql.append("receiver.fid||currency.fid||primaryitem.fid||period.fid||fstatus as fspecial \r\n");
            }
            sql.append("from \r\n");
            sql.append("(\r\n");
            sql.append("select cfrequisition.fsenderid fsenderid,cfrequisition.freceiverid freceiverid,\r\n");
            sql.append("cfrecord.fprimaryitemid fprimaryitemid,voucher.fperiodid fperiodid,\r\n");
            sql.append("entry.fcurrencyid fcurrencyid,cfrequisition.fstatus, \r\n");
            sql.append("sum(cfrecord.foriginalamount * cfrecord.fprimarycoeffient) foriginalamount \r\n");
            sql.append("from t_gl_cfrequisition as cfrequisition  \r\n");
            sql.append("inner join t_gl_cashflowrecord as cfrecord  \r\n");
            sql.append("on cfrequisition.fcfrecordid = cfrecord.fid  \r\n");
            sql.append("inner join t_org_company as receiver  \r\n");
            sql.append("on cfrequisition.freceiverid = receiver.fid  \r\n");
            sql.append("inner join t_org_company as sender  \r\n");
            sql.append("on cfrequisition.fsenderid = sender.fid  \r\n");
            sql.append("inner join t_bd_cashflowitem as primaryitem  \r\n");
            sql.append("on cfrecord.fprimaryitemid = primaryitem.fid  \r\n");
            sql.append("inner join t_gl_voucherentry as entry  \r\n");
            sql.append("on cfrecord.fentryid = entry.fid  \r\n");
            sql.append("inner join t_gl_voucher as voucher  \r\n");
            sql.append("on cfrecord.fvoucherid = voucher.fid  \r\n");
            sql.append("inner join t_bd_currency as currency  \r\n");
            sql.append("on entry.fcurrencyid = currency.fid  \r\n");
            sql.append("inner join t_bd_period as period  \r\n");
            sql.append("on voucher.fperiodid = period.fid  \r\n");
            if (isOnlyDisplayCanCheck) {
                sql.append("left join T_BD_CFCorrelationSetting sett on (receiver.fid = sett.FReceiverId and sender.fid = sett.FSenderId)");
            }
            sql.append(this.computeWhere(ctx, params, isReceive, sqlParams)).append(LINE_SEPARATOR);
            if (isOnlyDisplayCanCheck) {
                if (isNeedJoinSettingTableQuery) {
                    sql.append("  and (sett.FCorrelatorId = ? )");
                } else {
                    sql.append("  and (sett.FCorrelatorId is null or  sett.FCorrelatorId = ? )");
                }
                sqlParams.add(params.get("currentCompanyId"));
            }
            sql.append("group by cfrequisition.fsenderid, \r\n");
            sql.append("         cfrequisition.freceiverid, \r\n");
            sql.append("         cfrecord.fprimaryitemid, \r\n");
            sql.append("         voucher.fperiodid, \r\n");
            sql.append("         entry.fcurrencyid, \r\n");
            sql.append("         cfrequisition.fstatus \r\n");
            sql.append(") cfrequisition \r\n");
            sql.append("inner join t_org_company as sender \r\n");
            sql.append("on cfrequisition.fsenderid = sender.fid \r\n");
            sql.append("inner join t_org_company as receiver \r\n");
            sql.append("on cfrequisition.freceiverid = receiver.fid \r\n");
            sql.append("inner join t_bd_cashflowitem as primaryitem \r\n");
            sql.append("on cfrequisition.fprimaryitemid = primaryitem.fid \r\n");
            sql.append("inner join t_bd_currency as currency \r\n");
            sql.append("on cfrequisition.fcurrencyid = currency.fid \r\n");
            sql.append("inner join t_bd_period as period  \r\n");
            sql.append("on cfrequisition.fperiodid = period.fid  \r\n");
            sql.append(")t1 \r\n");
            sql.append(" where fspecial=?");
            sqlParams.add(params.get("selectedId"));
        } else {
            sql.append("select * from \r\n");
            sql.append("(\r\n");
            sql.append("select receiver.").append(localeName).append(" as freceivername, receiver.fnumber as freceivernumber,\r\n");
            sql.append("sender.").append(localeName).append(" as fsendername, sender.fnumber as fsendernumber,\r\n");
            sql.append("((to_char(period.fperiodyear) || '.') || to_char(period.fperiodnumber)) as fvoucherperiod, \r\n");
            sql.append("period.fnumber as fperiodnumber, \r\n");
            sql.append("voucher.fnumber as fvouchernumber, \r\n");
            sql.append("primaryitem.").append(localeName).append(" as fprimaryitemname,");
            sql.append("primaryitem.fnumber as fprimaryitemnumber,\r\n");
            sql.append("primaryitem.fdirection as fprimaryitemdirection, \r\n");
            sql.append("currency.").append(localeName).append(" as fcurrencyname,");
            sql.append("currency.fnumber as fcurrencynumber,currency.fprecision as fprecision, \r\n");
            sql.append("cfrecord.foriginalamount * cfrecord.fprimarycoeffient as foriginalamount, \r\n");
            sql.append("cfrequisition.fstatus as fstatus, \r\n");
            sql.append("cfrequisition.fcorrelationnum as fcorrelationnum, \r\n");
            sql.append("cfrequisition.fid as fid,sender.fid as fsenderid, receiver.fid as freceiverid,\r\n");
            sql.append("cfrecord.fprimaryitemid as fprimaryitemid,period.fid as fperiodid,\r\n");
            sql.append("currency.fid as fcurrencyid,cfrequisition.fdescription as fdescription,0 as fischecked, \r\n");
            if (isReceive) {
                sql.append("sender.fid||currency.fid||primaryitem.fid||period.fid||fstatus as fspecial \r\n");
            } else {
                sql.append("receiver.fid||currency.fid||primaryitem.fid||period.fid||fstatus as fspecial \r\n");
            }
            sql.append("from t_gl_cfrequisition as cfrequisition  \r\n");
            sql.append("inner join t_gl_cashflowrecord as cfrecord  \r\n");
            sql.append("on cfrequisition.fcfrecordid = cfrecord.fid  \r\n");
            sql.append("inner join t_org_company as receiver  \r\n");
            sql.append("on cfrequisition.freceiverid = receiver.fid  \r\n");
            sql.append("inner join t_org_company as sender  \r\n");
            sql.append("on cfrequisition.fsenderid = sender.fid  \r\n");
            sql.append("inner join t_bd_cashflowitem as primaryitem  \r\n");
            sql.append("on cfrecord.fprimaryitemid = primaryitem.fid  \r\n");
            sql.append("inner join t_gl_voucherentry as entry  \r\n");
            sql.append("on cfrecord.fentryid = entry.fid  \r\n");
            sql.append("inner join t_gl_voucher as voucher  \r\n");
            sql.append("on cfrecord.fvoucherid = voucher.fid  \r\n");
            sql.append("inner join t_bd_currency as currency  \r\n");
            sql.append("on entry.fcurrencyid = currency.fid  \r\n");
            sql.append("inner join t_bd_period as period  \r\n");
            sql.append("on voucher.fperiodid = period.fid  \r\n");
            if (isOnlyDisplayCanCheck) {
                sql.append("left join T_BD_CFCorrelationSetting sett on (receiver.fid = sett.FReceiverId and sender.fid = sett.FSenderId)");
            }
            sql.append(this.computeWhere(ctx, params, isReceive, sqlParams)).append(LINE_SEPARATOR);
            if (isOnlyDisplayCanCheck) {
                if (isNeedJoinSettingTableQuery) {
                    sql.append("  and (sett.FCorrelatorId = ? )");
                } else {
                    sql.append("  and (sett.FCorrelatorId is null or  sett.FCorrelatorId = ? )");
                }
                sqlParams.add(params.get("currentCompanyId"));
            }
            sql.append(") t \r\n");
            sql.append(" where fspecial=? \r\n");
            sqlParams.add(params.get("selectedId"));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlParams.toArray());
        return rs;
    }

    private List translateRowSet(IRowSet rs) throws SQLException {
        return this.translateRowSet(rs, false);
    }

    private List translateRowSet(IRowSet rs, boolean isDiffCyCorrelation) throws SQLException {
        LinkedList<CFRequisition> result = new LinkedList<CFRequisition>();
        CFRequisition req = null;
        while (rs.next()) {
            req = new CFRequisition();
            req.setId(rs.getString("fid"));
            req.setSenderId(rs.getString("fsenderid"));
            req.setReceiverId(rs.getString("freceiverid"));
            req.setCurrencyId(rs.getString("fcurrencyId"));
            req.setPeriodId(rs.getString("fperiodid"));
            req.setPrimaryItemId(rs.getString("fprimaryitemid"));
            req.setDirection(rs.getInt("fdirection"));
            req.setAmount(rs.getBigDecimal("foriginalamount"));
            if (isDiffCyCorrelation) {
                req.setLocalAmt(rs.getBigDecimal("flocalAmount"));
                req.setBaseCurrencyId(rs.getString("fbaseCurrencyId"));
            }
            result.add(req);
        }
        return result;
    }

    @Override
    protected List _queryAllReceivedIds(Context ctx, Map params, String tempTableName) throws BOSException, EASBizException {
        String sql = "select fid from " + tempTableName + this.computeOrder(ctx, params);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rs.next()) {
                idList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idList;
    }

    @Override
    protected List _queryAllSentIds(Context ctx, Map params, String tempTableName) throws BOSException, EASBizException {
        String sql = "select fid from " + tempTableName + this.computeOrder(ctx, params);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rs.next()) {
                idList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idList;
    }

    @Override
    protected IRowSet _queryReceivedCFRequisition(Context ctx, Map params, List idList, String tempTableName) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ").append(tempTableName).append(" where ");
        if (idList.size() == 0) {
            sql.append(" fid in ('')");
            return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        StringBuffer fid = new StringBuffer("fid in ( ? ");
        int n = idList.size();
        for (int i = 1; i < n; ++i) {
            fid.append(", ? ");
        }
        fid.append(" ) ");
        sql.append(fid);
        sql.append(this.computeOrder(ctx, params));
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])idList.toArray());
    }

    @Override
    protected IRowSet _querySentCFRequisition(Context ctx, Map params, List idList, String tempTableName) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ").append(tempTableName).append(" where ");
        if (idList.size() == 0) {
            sql.append(" fid in ('')");
            return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        StringBuffer fid = new StringBuffer("fid in ( ? ");
        int n = idList.size();
        for (int i = 1; i < n; ++i) {
            fid.append(", ? ");
        }
        fid.append(" ) ");
        sql.append(fid);
        sql.append(this.computeOrder(ctx, params));
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])idList.toArray());
    }

    private String getResource(Context ctx, String key, Object[] params) {
        String message = ResourceBase.getString((String)CFREQ_RES, (String)key, (Locale)ctx.getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }

    @Override
    protected String _checkCanClosePeriod(Context ctx, IObjectPK comPK, IObjectPK currentPeriodPK, int currentPeriodNumber) throws BOSException {
        String msg = null;
        try {
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            ParamItemInfo paramAsst = pc.getParamItemByNumberAndOrg("GL_0152", comPK.toString());
            if (paramAsst == null || !"0".equals(paramAsst.getValue())) {
                return null;
            }
            ParamItemInfo paramCashflow = pc.getParamItemByNumberAndOrg("GL_070", comPK.toString());
            if (paramCashflow == null || PARAM_ALLOW_CFREQ_VALUE_UNENABLE.equals(paramCashflow.getValue())) {
                return null;
            }
            ParamItemInfo paramClose = pc.getParamItemByNumberAndOrg("GL_071", comPK.toString());
            ParamItemInfo noticeType = pc.getParamItemByNumberAndOrg("GL_121", comPK.toString());
            if (CORRELATION_WAY_MANUAL.equals(paramClose.getValue())) {
                StringBuffer sql = new StringBuffer();
                sql.append("select cfrequisition.fid from t_gl_cfrequisition cfrequisition \r\n");
                sql.append("inner join t_gl_cashflowrecord cfrecord on cfrequisition.fcfrecordid=cfrecord.fid \r\n");
                sql.append("inner join t_gl_voucher voucher on cfrecord.fvoucherid=voucher.fid \r\n");
                sql.append("inner join t_bd_period period on voucher.fperiodid=period.fid \r\n");
                sql.append("where cfrequisition.fstatus=?  and period.fid=? and cfrequisition.fIsAvoidCheck=0 \r\n");
                Object[] params = null;
                if (CORRELATION_WAY_MANUAL.equals(noticeType.getValue())) {
                    sql.append(" and (cfrequisition.FSENDERID = ? or  cfrequisition.FRECEIVERID = ?) ");
                    params = new Object[]{CORRELATION_WAY_MANUAL, currentPeriodPK.toString(), comPK.toString(), comPK.toString()};
                } else {
                    sql.append(" and voucher.fcompanyid=? ");
                    params = new Object[]{CORRELATION_WAY_MANUAL, currentPeriodPK.toString(), comPK.toString()};
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                if (rs.next()) {
                    msg = this.getResource(ctx, CURRENT_NOT_CORRELATION, null);
                }
            } else if ("0".equals(paramClose.getValue())) {
                StringBuffer sql = new StringBuffer();
                sql.append("select cfrequisition.fid from t_gl_cfrequisition cfrequisition \r\n");
                sql.append("inner join t_gl_cashflowrecord cfrecord on cfrequisition.fcfrecordid=cfrecord.fid \r\n");
                sql.append("inner join t_gl_voucher voucher on cfrecord.fvoucherid=voucher.fid \r\n");
                sql.append("inner join t_bd_period period on voucher.fperiodid=period.fid \r\n");
                sql.append("where cfrequisition.fstatus=? and period.fnumber<=? and cfrequisition.fIsAvoidCheck=0 \r\n");
                Object[] params = null;
                if (CORRELATION_WAY_MANUAL.equals(noticeType.getValue())) {
                    sql.append(" and (cfrequisition.FSENDERID = ? or cfrequisition.FRECEIVERID = ?) ");
                    params = new Object[]{CORRELATION_WAY_MANUAL, new Integer(currentPeriodNumber), comPK.toString(), comPK.toString()};
                } else {
                    sql.append(" and voucher.fcompanyid= ? ");
                    params = new Object[]{CORRELATION_WAY_MANUAL, new Integer(currentPeriodNumber), comPK.toString()};
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                if (rs.next()) {
                    msg = this.getResource(ctx, NOT_ALL_CORRELATION, null);
                }
            }
        }
        catch (Exception e) {
            msg = null;
        }
        return msg;
    }

    @Override
    protected void _updateCheckStatus(Context ctx, ArrayList requisitionIds, boolean status) throws BOSException {
        if (requisitionIds == null || requisitionIds.size() <= 0) {
            return;
        }
        int check = status ? 0 : 1;
        StringBuilder sb = new StringBuilder();
        String idStrs = EMPTY_STRING;
        int size = requisitionIds.size();
        for (int i = 0; i < size; ++i) {
            String id = (String)requisitionIds.get(i);
            sb.append("'").append(id).append("',");
        }
        idStrs = sb.substring(0, sb.length() - 1);
        sb.setLength(0);
        sb.append("update t_gl_cfrequisition set fisavoidcheck =").append(check);
        sb.append(" where fid in (").append(idStrs).append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private static class CollectKey {
        String companyId = null;
        String cashflowItemId = null;
        String currencyId = null;
        String periodId = null;
        int reqStatus = 0;
        String baseCurrcncyId = null;
        BigDecimal totalLocalAmt = GlUtils.zero;
        BigDecimal totalAmount = GlUtils.zero;
        List reqIds = new ArrayList();
        int direction = 0;

        public CollectKey(String companyId, String cashflowItemId, String currencyId, String periodId, int reqStatus, int direction) {
            this.companyId = companyId;
            this.cashflowItemId = cashflowItemId;
            this.currencyId = currencyId;
            this.periodId = periodId;
            this.reqStatus = reqStatus;
            this.direction = direction;
        }

        public void addAmount(BigDecimal amount) {
            this.totalAmount = this.totalAmount.add(amount);
        }

        public void addTotalAmount(BigDecimal amount) {
            this.totalLocalAmt = this.totalLocalAmt.add(amount);
        }

        public boolean canCorrelation(CollectKey oppKey) {
            return this.canCorrelation(oppKey, false);
        }

        public boolean canCorrelation(CollectKey oppKey, boolean isDiffCyCorrelation) {
            return isDiffCyCorrelation ? this.companyId.equals(oppKey.getCompanyId()) && !this.currencyId.equals(oppKey.getCurrencyId()) && this.baseCurrcncyId.equals(oppKey.getBaseCurrcncyId()) && this.getDirection() != oppKey.getDirection() && this.getTotalLocalAmt().compareTo(oppKey.getTotalLocalAmt()) == 0 : this.companyId.equals(oppKey.getCompanyId()) && this.currencyId.equals(oppKey.getCurrencyId()) && this.getDirection() != oppKey.getDirection() && this.getTotalAmount().compareTo(oppKey.getTotalAmount()) == 0;
        }

        public boolean canSpecialCorrelation(CollectKey oppKey) {
            BigDecimal oppDirectin;
            if (!this.companyId.equals(oppKey.getCompanyId()) || !this.currencyId.equals(oppKey.getCurrencyId())) {
                return false;
            }
            BigDecimal selfDirectin = this.direction == 1 ? GlUtils.one : GlUtils.negone;
            BigDecimal bigDecimal = oppDirectin = oppKey.getDirection() == 1 ? GlUtils.one : GlUtils.negone;
            return this.totalAmount.multiply(selfDirectin).add(oppKey.getTotalAmount().multiply(oppDirectin)).signum() == 0;
        }

        public void addRequsitionId(String reqId) {
            this.reqIds.add(reqId);
        }

        public List getRequisitionIds() {
            return this.reqIds;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CollectKey)) {
                return false;
            }
            CollectKey oppKey = (CollectKey)object;
            return this.companyId.equals(oppKey.getCompanyId()) && this.currencyId.equals(oppKey.getCurrencyId()) && this.cashflowItemId.equals(oppKey.getCashflowItemId()) && this.periodId.equals(oppKey.getPeriodId()) && this.reqStatus == oppKey.getReqStatus();
        }

        public int hashCode() {
            return this.companyId.hashCode() + this.currencyId.hashCode() + this.cashflowItemId.hashCode() + this.periodId.hashCode() + this.reqStatus;
        }

        public String getCompanyId() {
            return this.companyId;
        }

        public String getCashflowItemId() {
            return this.cashflowItemId;
        }

        public String getCurrencyId() {
            return this.currencyId;
        }

        public String getPeriodId() {
            return this.periodId;
        }

        public int getReqStatus() {
            return this.reqStatus;
        }

        public BigDecimal getTotalAmount() {
            return this.totalAmount;
        }

        public int getDirection() {
            return this.direction;
        }

        public String getBaseCurrcncyId() {
            return this.baseCurrcncyId;
        }

        public void setBaseCurrcncyId(String baseCurrcncyId) {
            this.baseCurrcncyId = baseCurrcncyId;
        }

        public BigDecimal getTotalLocalAmt() {
            return this.totalLocalAmt;
        }
    }

    private static class CorrelatorKey {
        private String senderId;
        private String receiverId;
        private String correlatorId;
        private String correlatorName;

        private CorrelatorKey() {
        }

        public String getSenderId() {
            return this.senderId;
        }

        public void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public String getReceiverId() {
            return this.receiverId;
        }

        public void setReceiverId(String receiverId) {
            this.receiverId = receiverId;
        }

        public String getCorrelatorId() {
            return this.correlatorId;
        }

        public void setCorrelatorId(String correlatorId) {
            this.correlatorId = correlatorId;
        }

        public String getCorrelatorName() {
            return this.correlatorName;
        }

        public void setCorrelatorName(String correlatorName) {
            this.correlatorName = correlatorName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.receiverId == null ? 0 : this.receiverId.hashCode());
            result = 31 * result + (this.senderId == null ? 0 : this.senderId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CorrelatorKey other = (CorrelatorKey)obj;
            if (this.receiverId.equals(other.getReceiverId()) && this.senderId.equals(other.getSenderId())) {
                return true;
            }
            return this.senderId.equals(other.getReceiverId()) && this.receiverId.equals(other.getSenderId());
        }
    }

    private static class CFRequisition {
        private String id = null;
        private String senderId = null;
        private String receiverId = null;
        private String primaryItemId = null;
        private int direction = 1;
        private String currencyId = null;
        private String periodId = null;
        private BigDecimal amount = GlUtils.zero;
        private BigDecimal localAmt = GlUtils.zero;
        private String baseCurrencyId = null;

        private CFRequisition() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSenderId() {
            return this.senderId;
        }

        public void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public String getReceiverId() {
            return this.receiverId;
        }

        public void setReceiverId(String receiverId) {
            this.receiverId = receiverId;
        }

        public String getPrimaryItemId() {
            return this.primaryItemId;
        }

        public void setPrimaryItemId(String primaryItemId) {
            this.primaryItemId = primaryItemId;
        }

        public int getDirection() {
            return this.direction;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public String getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(String currencyId) {
            this.currencyId = currencyId;
        }

        public String getPeriodId() {
            return this.periodId;
        }

        public void setPeriodId(String periodId) {
            this.periodId = periodId;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public BigDecimal getLocalAmt() {
            return this.localAmt;
        }

        public void setLocalAmt(BigDecimal localAmt) {
            this.localAmt = localAmt;
        }

        public String getBaseCurrencyId() {
            return this.baseCurrencyId;
        }

        public void setBaseCurrencyId(String baseCurrencyId) {
            this.baseCurrencyId = baseCurrencyId;
        }
    }
}

