/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowAttachedListFacadeFactory;
import com.kingdee.eas.fi.gl.CashflowAttachedListInfo;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordFactory;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.ICashFlowAttachedListFacade;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.ICashflowSplitRecord;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractCashFlowAttachedListFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.CashFlowAttachedListDao;
import com.kingdee.eas.fi.gl.app.CashFlowUtils;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.fi.gl.app.TAccountSplitStrategyFactory;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashFlowAttachedListFacadeControllerBean
extends AbstractCashFlowAttachedListFacadeControllerBean {
    private static final long serialVersionUID = -3532698458647893254L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CashFlowAttachedListFacadeControllerBean");
    private static final String SPLIT_REC_COLL_KEY = "splitRecordColl";
    private static final String CFACCDIFF_CACHE_KEY = "cfAccountDiffMap";

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        RptParams rp = new RptParams();
        rp.setObject("getAllCurrency", (Object)RptServerUtil.getAllCurrency(company.getId().toString(), ctx));
        company.setDescription(null);
        rp.setObject("pe", (Object)new PeriodEntity(RptServerUtil.getPeriodRange(ctx, company)));
        rp.setObject("currentPeriod", (Object)this.getCurrentPeriodInfo(ctx, company));
        return rp;
    }

    @Override
    protected List _queryCashflowAttachedList(Context ctx, CashflowQueryParam condition, CashflowAttachedListInfo parent, int action) throws BOSException, EASBizException {
        switch (action) {
            case 0: {
                return this.getSumAll(ctx, condition, parent);
            }
            case 1: {
                return this.getSumChildrenAccount(ctx, condition, parent);
            }
            case 2: {
                return this.getSumOppAccount(ctx, condition, parent);
            }
            case 3: {
                return this.getSumSuppItem(ctx, condition, parent);
            }
        }
        return null;
    }

    @Override
    protected List _getVoucherIdList(Context ctx, CashflowQueryParam condition, CashflowAttachedListInfo info) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).getVoucherIdList(info);
    }

    @Override
    protected void _applyCashflowItem(Context ctx, CashflowQueryParam condition, CashflowAttachedListInfo info, CashFlowItemInfo cfItem) throws BOSException, EASBizException {
        if (info == null || cfItem == null) {
            return;
        }
        this.getDao(ctx, condition).applyCashflowItem(info, cfItem);
    }

    @Override
    protected void _removeCashflowItem(Context ctx, CashflowQueryParam condition, CashflowAttachedListInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        this.getDao(ctx, condition).removeCashflowItem(info);
    }

    @Override
    protected void _applyDefaultCashflowItem(Context ctx, CashflowQueryParam condition, boolean isCover) throws BOSException, EASBizException {
        this.getDao(ctx, condition).applyDefaultCashflowItem(isCover);
    }

    @Override
    protected void _splitPLVoucher(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        ITAccountSplitStrategy strategy;
        CashflowSplitRecordCollection splitResult;
        Map cfAccountDiffMap = (Map)ctx.get((Object)CFACCDIFF_CACHE_KEY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cashflowAccountDiff", cfAccountDiffMap);
        params.put("cashflowRecords", voucherInfo.getCashflowRecords());
        CashflowSplitRecordCollection splitColl = (CashflowSplitRecordCollection)voucherInfo.get(SPLIT_REC_COLL_KEY);
        params.put("cashflowSplitRecords", splitColl);
        String voucherId = voucherInfo.getId().toString();
        CashFlowAttachedListDao dao = this.getDao(ctx, null);
        if (dao.isUpdated(voucherInfo.getId().toString(), voucherInfo.getLastUpdateTime())) {
            dao.setVoucherSplited(voucherId);
            voucherInfo = dao.getVoucherInfo(voucherId);
            if (voucherInfo != null) {
                params.put("cashflowRecords", voucherInfo.getCashflowRecords());
                params.put("cashflowSplitRecords", this.getCFSplitColl(ctx, voucherId));
            }
        } else {
            dao.setVoucherSplited(voucherId);
        }
        if (voucherInfo != null && (splitResult = (strategy = TAccountSplitStrategyFactory.getSplitStrategy("pl")).split(ctx, voucherInfo, params)) != null && !splitResult.isEmpty()) {
            CashflowSplitRecordFactory.getLocalInstance(ctx).addBatch((IObjectCollection)splitResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _splitPLVoucher(Context ctx, CashflowQueryParam condition) throws BOSException, EASBizException {
        CashFlowAttachedListDao dao = this.getDao(ctx, condition);
        List idList = dao.getNoSplitPLVoucherIdSet();
        if (idList == null || idList.isEmpty()) {
            return;
        }
        ICashFlowAttachedListFacade iAttached = CashFlowAttachedListFacadeFactory.getLocalInstance(ctx);
        ICashflowRecord iCf = CashflowRecordFactory.getLocalInstance(ctx);
        ICashflowSplitRecord iSplit = CashflowSplitRecordFactory.getLocalInstance(ctx);
        Map cfAccountDiffMap = CashFlowUtils.getDifferenceMap(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        ctx.put((Object)CFACCDIFF_CACHE_KEY, (Object)cfAccountDiffMap);
        try {
            boolean finished = false;
            while (!finished && idList.size() > 0) {
                finished = this.splitPLVoucher(ctx, dao, idList, iCf, iSplit, iAttached);
            }
        }
        finally {
            ctx.remove((Object)CFACCDIFF_CACHE_KEY);
        }
    }

    private List getSumAll(Context ctx, CashflowQueryParam condition, CashflowAttachedListInfo parent) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).getSumAll(parent);
    }

    private List getSumChildrenAccount(Context ctx, CashflowQueryParam condition, CashflowAttachedListInfo parent) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).getSumChildrenAccount(parent);
    }

    private List getSumOppAccount(Context ctx, CashflowQueryParam condition, CashflowAttachedListInfo parent) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).getSumOppAccount(parent);
    }

    private List getSumSuppItem(Context ctx, CashflowQueryParam condition, CashflowAttachedListInfo parent) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).getSumSuppItem(parent);
    }

    private boolean splitPLVoucher(Context ctx, CashFlowAttachedListDao dao, List idList, ICashflowRecord icf, ICashflowSplitRecord iSplit, ICashFlowAttachedListFacade iAttached) throws BOSException, EASBizException {
        VoucherCollection voucherColl = dao.getVoucherCollection(idList);
        if (voucherColl.isEmpty()) {
            return true;
        }
        Set idSet = this.getVoucherIdSet(voucherColl);
        Map vchSplitMap = this.getSplitRecordCollMap(idSet, iSplit);
        Map vchcfRecordMap = this.getCashflowRecordCollMap(idSet, icf);
        Iterator it = voucherColl.iterator();
        VoucherInfo voucher = null;
        while (it.hasNext()) {
            voucher = (VoucherInfo)it.next();
            voucher.setCashflowRecords((AbstractObjectCollection)((CashflowRecordCollection)vchcfRecordMap.get(voucher.getId())));
            voucher.put(SPLIT_REC_COLL_KEY, (Object)((CashflowSplitRecordCollection)vchSplitMap.get(voucher.getId())));
            iAttached.splitPLVoucher(voucher);
        }
        return false;
    }

    private Set getVoucherIdSet(VoucherCollection voucherColl) {
        Iterator it = voucherColl.iterator();
        HashSet<String> idSet = new HashSet<String>();
        while (it.hasNext()) {
            idSet.add(((VoucherInfo)it.next()).getId().toString());
        }
        return idSet;
    }

    private Map getSplitRecordCollMap(Set idSet, ICashflowSplitRecord iSplit) throws BOSException {
        EntityViewInfo splitView = new EntityViewInfo();
        splitView.setSelector(this.getCashflowSplitRecordSelector());
        FilterInfo splitFilter = new FilterInfo();
        splitFilter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)idSet, CompareType.INCLUDE));
        splitView.setFilter(splitFilter);
        splitView.getSorter().add(new SorterItemInfo("voucher.id"));
        CashflowSplitRecordCollection splitColl = iSplit.getCashflowSplitRecordCollection(splitView);
        Iterator splitIt = splitColl.iterator();
        HashMap<BOSUuid, CashflowSplitRecordCollection> vchSplitMap = new HashMap<BOSUuid, CashflowSplitRecordCollection>();
        while (splitIt.hasNext()) {
            CashflowSplitRecordInfo split = (CashflowSplitRecordInfo)splitIt.next();
            CashflowSplitRecordCollection tempColl = (CashflowSplitRecordCollection)vchSplitMap.get(split.getVoucher().getId());
            if (tempColl == null) {
                tempColl = new CashflowSplitRecordCollection();
                vchSplitMap.put(split.getVoucher().getId(), tempColl);
            }
            tempColl.add(split);
        }
        return vchSplitMap;
    }

    private Map getCashflowRecordCollMap(Set idSet, ICashflowRecord icfRecord) throws BOSException {
        EntityViewInfo cfView = new EntityViewInfo();
        cfView.setSelector(this.getCashflowRecordSelector());
        FilterInfo cfFilter = new FilterInfo();
        cfFilter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)idSet, CompareType.INCLUDE));
        cfView.setFilter(cfFilter);
        cfView.getSorter().add(new SorterItemInfo("voucher.id"));
        CashflowRecordCollection cfColl = icfRecord.getCashflowRecordCollection(cfView);
        Iterator cfIt = cfColl.iterator();
        HashMap<BOSUuid, CashflowRecordCollection> vchCfRecordMap = new HashMap<BOSUuid, CashflowRecordCollection>();
        while (cfIt.hasNext()) {
            CashflowRecordInfo cfRecord = (CashflowRecordInfo)cfIt.next();
            CashflowRecordCollection tempColl = (CashflowRecordCollection)vchCfRecordMap.get(cfRecord.getVoucher().getId());
            if (tempColl == null) {
                tempColl = new CashflowRecordCollection();
                vchCfRecordMap.put(cfRecord.getVoucher().getId(), tempColl);
            }
            tempColl.add(cfRecord);
        }
        return vchCfRecordMap;
    }

    private CashflowSplitRecordCollection getCFSplitColl(Context ctx, String voucherId) throws BOSException {
        EntityViewInfo splitView = new EntityViewInfo();
        splitView.setSelector(this.getCashflowSplitRecordSelector());
        FilterInfo splitFilter = new FilterInfo();
        splitFilter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherId));
        splitView.setFilter(splitFilter);
        return CashflowSplitRecordFactory.getLocalInstance(ctx).getCashflowSplitRecordCollection(splitView);
    }

    protected PeriodInfo getCurrentPeriodInfo(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue())));
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod.id"));
        sic.add(new SelectorItemInfo("currentPeriod.type.id"));
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
        PeriodInfo currentPeriod = null;
        if (col.size() > 0) {
            currentPeriod = col.get(0).getCurrentPeriod();
        }
        return currentPeriod;
    }

    private SelectorItemCollection getCashflowSplitRecordSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("voucher.id"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("entryDC"));
        sic.add(new SelectorItemInfo("opposingAccountEntry.id"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("oppEntryDC"));
        sic.add(new SelectorItemInfo("originalAmount"));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("reportingAmount"));
        sic.add(new SelectorItemInfo("itemFlag"));
        sic.add(new SelectorItemInfo("isSupItem"));
        return sic;
    }

    private SelectorItemCollection getCashflowRecordSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("voucher.id"));
        sic.add(new SelectorItemInfo("itemFlag"));
        sic.add(new SelectorItemInfo("originalAmount"));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("reportingAmount"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("entryDC"));
        sic.add(new SelectorItemInfo("opposingAccountEntry.id"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("oppEntryDC"));
        return sic;
    }

    @Override
    protected boolean _existNoSelectCFItemVoucher(Context ctx, CashflowQueryParam conditon) throws BOSException, EASBizException {
        ArrayList sqlParams = new ArrayList();
        Integer startPeriod = new Integer(conditon.getStartYear() * 100 + conditon.getStartPeriod());
        Integer endPeriod = new Integer(conditon.getEndYear() * 100 + conditon.getEndPeriod());
        String sql = CashFlowUtils.getPrimaryItemVocuherSql(conditon.getCompanyId(), conditon.isIndcludeNoPosted(), conditon.isPeriod(), startPeriod, endPeriod, conditon.getStartDate(), conditon.getEndDate(), sqlParams, 2);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select top 1 * from (" + sql + ") t"), (Object[])sqlParams.toArray());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return false;
    }

    protected CashFlowAttachedListDao getDao(Context ctx, CashflowQueryParam conditon) {
        return new CashFlowAttachedListDao(ctx, conditon);
    }
}

