/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordFactory;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTAccountInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.ICashflowSplitRecord;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.TAccountCashflowInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.CashFlowTAccountSQLFactory;
import com.kingdee.eas.fi.gl.app.CashFlowUtils;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.fi.gl.app.TAccountSplitStrategyFactory;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.utils.SqlUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashFlowTAccountDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CashFlowTAccountDao");
    public static final int BATCH_COUNT = 1000;
    private Context ctx;
    private CashflowQueryParam condition;
    private final Map<String, Object> processResult = new HashMap<String, Object>();

    public CashFlowTAccountDao(Context ctx, CashflowQueryParam condition) {
        this.ctx = ctx;
        this.condition = condition;
    }

    protected List[] getCashflowTAccount() throws BOSException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getChildrenAccountSQL(this.ctx, this.condition, null, sp);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sp.toArray());
        List[] infos = new List[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
        try {
            while (rs.next()) {
                BigDecimal cashAmount = rs.getBigDecimal("fCashAmount");
                BigDecimal amount = rs.getBigDecimal("famount");
                this.addCashflowTAccountInfo(infos, this.getCashflowTAccountInfo(rs, cashAmount, true));
                this.addCashflowTAccountInfo(infos, this.getCashflowTAccountInfo(rs, amount, false));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return infos;
    }

    protected List expandChildren(CashflowTAccountInfo parent) throws BOSException, EASBizException {
        if (parent == null) {
            return null;
        }
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getChildrenAccountSQL(this.ctx, this.condition, parent, sp);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sp.toArray());
        ArrayList<CashflowTAccountInfo> infos = new ArrayList<CashflowTAccountInfo>();
        try {
            while (rs.next()) {
                infos.add(this.getAccountTAccountInfo(rs, parent));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return infos;
    }

    protected List expandAssistantHG(CashflowTAccountInfo parent) throws BOSException, EASBizException {
        if (parent == null) {
            return null;
        }
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getAssistHGSQL(this.ctx, this.condition, parent, sp);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sp.toArray());
        ArrayList<CashflowTAccountInfo> infos = new ArrayList<CashflowTAccountInfo>();
        try {
            CashflowTAccountInfo notHgTAccount = null;
            CashflowTAccountInfo tAccount = null;
            while (rs.next()) {
                tAccount = this.getHGTAccountInfo(parent, rs);
                if (tAccount.getHg() == null) {
                    notHgTAccount = tAccount;
                    continue;
                }
                infos.add(tAccount);
            }
            if (notHgTAccount != null) {
                infos.add(notHgTAccount);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return infos;
    }

    protected List expandOppAssistantHG(CashflowTAccountInfo parent) throws BOSException, EASBizException {
        if (parent == null) {
            return null;
        }
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getOppAssistHGSQL(this.ctx, this.condition, parent, sp);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sp.toArray());
        ArrayList<CashflowTAccountInfo> infos = new ArrayList<CashflowTAccountInfo>();
        try {
            CashflowTAccountInfo notHgTAccount = null;
            CashflowTAccountInfo tAccount = null;
            while (rs.next()) {
                tAccount = this.getOppHGTAccountInfo(parent, rs);
                if (tAccount.getOppHg() == null) {
                    notHgTAccount = tAccount;
                    continue;
                }
                infos.add(tAccount);
            }
            if (notHgTAccount != null) {
                infos.add(notHgTAccount);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return infos;
    }

    protected List expandCashflowItem(CashflowTAccountInfo parent) throws BOSException, EASBizException {
        if (parent == null) {
            return null;
        }
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getCashflowItemSQL(this.ctx, this.condition, parent, sp);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sp.toArray());
        ArrayList<CashflowTAccountInfo> infos = new ArrayList<CashflowTAccountInfo>();
        try {
            CashflowTAccountInfo notCFItemTAccount = null;
            CashflowTAccountInfo tAccount = null;
            while (rs.next()) {
                tAccount = this.getCFItemTAccountInfo(parent, rs);
                if (tAccount.getCfItem() == null) {
                    notCFItemTAccount = tAccount;
                    continue;
                }
                infos.add(tAccount);
            }
            if (notCFItemTAccount != null) {
                infos.add(notCFItemTAccount);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return infos;
    }

    protected Map applyCashflowItem(CashflowTAccountInfo info, CashFlowItemInfo cfItem) throws BOSException, EASBizException {
        boolean notAllowModify = this.notModifyAfterAudit();
        if (info == null || info.getCfItem() == null || info.getCfItem() != null && info.getCfItem().getId() != null) {
            this.applyCFItemToCFRec(info, cfItem, notAllowModify);
        }
        if (info == null || (info.getCfItem() == null || info.getCfItem() != null && info.getCfItem().getId() == null) && (info.getHg() == null || info.getHg() != null && info.getHg().getId() == null)) {
            this.applyCFItemToSplitRec(info, cfItem, notAllowModify);
        }
        return this.processResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map applyDefaultCashflowItem(boolean isCover) throws BOSException, EASBizException {
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        String companyId = this.condition.getCompanyId();
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        MutexParameter mp = GLMutexUtils.buildCFApplyParameter(this.ctx, companyId, userId, "GL_applyDefaultCashflowItem");
        boolean isSucceed = false;
        if (mp != null) {
            MutexParameter current = mutex.requestMutex3(mp);
            boolean bl = isSucceed = current == null;
            if (!isSucceed) {
                throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(this.ctx, current, mp)));
            }
        }
        try {
            Map<String, Object> map;
            block10: {
                String tmpTableName = null;
                try {
                    boolean notAllowModify = this.notModifyAfterAudit();
                    tmpTableName = this.createCFSplitRecordIdTempTable();
                    this.applyDefCFItemToCFRecord(isCover, notAllowModify);
                    this.applyDefCFItemToCFSplitRecord(tmpTableName, isCover, notAllowModify);
                    this.autoSetCFRecordAsst(isCover, notAllowModify);
                    map = this.processResult;
                    if (tmpTableName == null) break block10;
                }
                catch (Throwable throwable) {
                    if (tmpTableName != null) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable(tmpTableName);
                    }
                    throw throwable;
                }
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tmpTableName);
            }
            return map;
        }
        finally {
            if (isSucceed) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Map cancelCFItemToSplitRec(CashflowTAccountInfo info) throws BOSException, EASBizException {
        block19: {
            block18: {
                block17: {
                    notAllowModify = this.notModifyAfterAudit();
                    sp = new ArrayList<E>();
                    sql = CashFlowTAccountSQLFactory.getCashflowRecordIDSQL(this.condition, info, sp, notAllowModify);
                    conn = null;
                    ps = null;
                    rs = null;
                    tempTable = "";
                    conn = this.getConnection();
                    ps = conn.prepareStatement(sql);
                    for (i = 0; i < sp.size(); ++i) {
                        ps.setObject(i + 1, sp.get(i));
                    }
                    rs = ps.executeQuery();
                    idSet = new HashSet<String>();
                    while (rs.next()) {
                        idSet.add(rs.getString("fid"));
                    }
                    if (idSet.size() != 0) break block17;
                    var10_12 = this.processResult;
                    if (!StringUtils.isEmpty((String)tempTable)) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                    return var10_12;
                }
                filter = new FilterInfo();
                if (idSet.size() >= 500) ** GOTO lbl65
                checkCFFilter = new FilterInfo();
                checkCFFilter.getFilterItems().add(new FilterItemInfo("cfRecord", idSet, CompareType.INCLUDE));
                checkResult = CFRequisitionFactory.getLocalInstance(this.ctx).checkReqCorrelation(checkCFFilter);
                if (checkResult != null) {
                    checkedIds = (Set)checkResult.get("idSet");
                    checkMsg = (String)checkResult.get("detail");
                    this.processResult.put("cancelCFRFailureCount", checkedIds.size());
                    this.processResult.put("cancelCFRFailureDetail", checkMsg);
                    idSet.removeAll(checkedIds);
                }
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                recordColl = this.getCashflowRecordCollection(filter);
                if (recordColl != null && recordColl.size() != 0) break block18;
                checkMsg = this.processResult;
                if (!StringUtils.isEmpty((String)tempTable)) {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                return checkMsg;
            }
            splitColl = this.toCashflowSplitCollection(recordColl);
            CashflowSplitRecordFactory.getLocalInstance(this.ctx).addBatch((IObjectCollection)splitColl);
            cfReqFilter = new FilterInfo();
            cfReqFilter.getFilterItems().add(new FilterItemInfo("cfRecord", idSet, CompareType.INCLUDE));
            cancelCFRSuccCount = CFRequisitionFactory.getLocalInstance(this.ctx).clearRequisition(cfReqFilter, this.condition.getCompanyId());
            this.processResult.put("cancelCFRSuccCount", cancelCFRSuccCount);
            CashflowRecordFactory.getLocalInstance(this.ctx).delete(filter);
            ** GOTO lbl107
lbl65:
            // 1 sources

            createTableSql = "create table gl_temp_table (fid varchar(44))";
            paramsList = new ArrayList<String[]>();
            tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSql);
            for (String id : idSet) {
                paramsList.add(new String[]{id});
            }
            insertSql = "insert into " + tempTable + " values(?)";
            DbUtil.executeBatch((Context)this.ctx, (String)insertSql, paramsList);
            checkCFFilter = new FilterInfo();
            checkCFFilter.getFilterItems().add(new FilterItemInfo("cfRecord in (select fid from " + tempTable + " )"));
            checkResult = CFRequisitionFactory.getLocalInstance(this.ctx).checkReqCorrelation(checkCFFilter);
            if (checkResult != null) {
                checkMsg = (String)checkResult.get("detail");
                checkedIds = (Set)checkResult.get("idSet");
                this.processResult.put("cancelCFRFailureCount", checkedIds.size());
                this.processResult.put("cancelCFRFailureDetail", checkMsg);
            }
            DbUtil.execute((Context)this.ctx, (String)("delete from " + tempTable + " tmp where exists (select 1 from t_gl_cfrequisition cfrq where tmp.fid = cfrq.fcfrecordid and cfrq.fstatus = '2')"));
            filter.getFilterItems().add(new FilterItemInfo("id in (select fid from " + tempTable + ")"));
            recordColl = this.getCashflowRecordCollection(filter);
            if (recordColl != null && recordColl.size() != 0) break block19;
            checkedIds = this.processResult;
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return checkedIds;
        }
        try {
            splitColl = this.toCashflowSplitCollection(recordColl);
            CashflowSplitRecordFactory.getLocalInstance(this.ctx).addBatch((IObjectCollection)splitColl);
            cfReqFilter = new FilterInfo();
            cfReqFilter.getFilterItems().add(new FilterItemInfo("cfRecord in (select fid from " + tempTable + ")"));
            cancelCFRSuccCount = CFRequisitionFactory.getLocalInstance(this.ctx).clearRequisition(cfReqFilter, this.condition.getCompanyId());
            this.processResult.put("cancelCFRSuccCount", cancelCFRSuccCount);
            CashflowRecordFactory.getLocalInstance(this.ctx).delete(filter);
lbl107:
            // 2 sources

            var11_14 = this.processResult;
        }
        catch (Exception e) {
            try {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            catch (Throwable var20_28) {
                if (!StringUtils.isEmpty((String)tempTable)) {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw var20_28;
            }
        }
        if (!StringUtils.isEmpty((String)tempTable)) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return var11_14;
    }

    protected Set getUnAssignedCFIVoucherIds(CashflowTAccountInfo info) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        if (info.getCfItem() != null && info.getCfItem().getId() != null || info.getHg() != null && info.getHg().getId() != null) {
            return idSet;
        }
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getUnAssignedCFIVoucherIdsSQL(this.condition, info, sp);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < sp.size(); ++i) {
                ps.setObject(i + 1, sp.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                idSet.add(rs.getString("fvoucherid"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return idSet;
    }

    protected Set getVoucherIds(CashflowTAccountInfo info) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getVoucherIdsSQL(this.condition, info, sp);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < sp.size(); ++i) {
                ps.setObject(i + 1, sp.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                idSet.add(rs.getString("fvoucherid"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return idSet;
    }

    protected Map getVoucherIdsTemp(CashflowTAccountInfo info) throws BOSException, EASBizException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getVoucherIdsSQL(this.condition, info, sp);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Connection conn = null;
        PreparedStatement ps = null;
        TempTablePool iPool = null;
        ResultSet rs = null;
        String tablename = null;
        try {
            iPool = TempTablePool.getInstance((Context)this.ctx);
            conn = this.getConnection();
            tablename = this.createTempTable4Result(iPool, conn);
            sql = "insert into " + tablename + " (FId) " + sql;
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < sp.size(); ++i) {
                ps.setObject(i + 1, sp.get(i));
            }
            ps.execute();
            sql = "select count(*) counts from " + tablename;
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                result.put("oVTableCounts", Integer.valueOf(rs.getString("counts")));
            }
            result.put("originalVoucherTable", tablename);
        }
        catch (SQLException e) {
            try {
                if (null != iPool && null != tablename) {
                    iPool.releaseTable(tablename);
                }
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return result;
    }

    private String createTempTable4Result(TempTablePool iPool, Connection conn) throws EASBizException, BOSException {
        String keyDesc = "T_GL_VoucherTemp";
        StringBuffer sql = new StringBuffer();
        sql.append("( \r\n");
        sql.append("    FId varChar(44) ) \r\n");
        return SqlUtils.createTempTableByDDL(iPool, conn, keyDesc, sql);
    }

    protected Map getTAccountCashflowInfos(CashflowTAccountInfo info, boolean includeAssigned) throws BOSException {
        HashMap<String, TAccountCashflowInfo> cshflowMap = new HashMap<String, TAccountCashflowInfo>();
        boolean cfRecordTable = false;
        if (includeAssigned && (info.getCfItem() == null || info.getCfItem() != null && info.getCfItem().getId() != null || info.getHg() != null && info.getHg().getId() != null)) {
            cfRecordTable = true;
        }
        boolean cfSplitRecordTable = false;
        if ((info.getCfItem() == null || info.getCfItem() != null && info.getCfItem().getId() == null) && (info.getHg() == null || info.getHg() != null && info.getHg().getId() == null)) {
            cfSplitRecordTable = true;
        }
        if (!cfRecordTable && !cfSplitRecordTable) {
            return cshflowMap;
        }
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getTAccountCashflowInfos(this.ctx, this.condition, info, includeAssigned, sp);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < sp.size(); ++i) {
                ps.setObject(i + 1, sp.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                TAccountCashflowInfo cfInfo = this.toTAccountCashflowInfo(rs);
                cshflowMap.put(cfInfo.getId(), cfInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return cshflowMap;
    }

    private TAccountCashflowInfo toTAccountCashflowInfo(ResultSet rs) throws SQLException {
        TAccountCashflowInfo info = new TAccountCashflowInfo();
        info.setId(rs.getString("fid"));
        info.setSourceType(rs.getInt("fsourcetype"));
        info.setVoucherId(rs.getString("fvoucherid"));
        info.setVoucherBookedDate(rs.getDate("fbookedDate"));
        info.setVoucherPeriodYear(rs.getInt("fperiodyear"));
        info.setVoucherPeriodNumber(rs.getInt("fperiodnumber"));
        info.setVoucherTypeName(rs.getString("voucherTypeName"));
        info.setVoucherNumber(rs.getString("voucherNumber"));
        info.setVoucherStatus(rs.getInt("fbizstatus"));
        info.setEntryId(rs.getString("fentryid"));
        info.setEntryDebit(rs.getInt("fentrydc") == 1);
        info.setCurrencyId(rs.getString("fcurrencyid"));
        info.setEntryAccountId(rs.getString("saccountid"));
        info.setEntryAccountNumber(rs.getString("saccountNumber"));
        info.setEntryAccountLongName(rs.getString("saccountName"));
        info.setOpposingEntryId(rs.getString("foppentryid"));
        info.setOpposingEntrySeq(rs.getInt("oppEntrySeq"));
        info.setOpposingEntryDescription(rs.getString("oppEntryDesc"));
        info.setOpposingEntryAccountId(rs.getString("oaccountid"));
        info.setOpposingEntryAccountNumber(rs.getString("oaccountnumber"));
        info.setOpposingEntryAccountLongName(rs.getString("oaccountName"));
        info.setOpposingEntryDebit(rs.getInt("foppentrydc") == 1);
        String oppVoucherAssistRecordId = rs.getString("foppvoucherassistrecordid");
        if (oppVoucherAssistRecordId != null) {
            info.setOpposingEntryAssitRecordId(oppVoucherAssistRecordId);
            info.setAccountAssistId(rs.getString("foppassgrpid"));
            String hgName = rs.getString("hgName");
            if (hgName != null) {
                hgName = hgName.replaceAll("_!", " ");
            }
            info.setAccountAssistLongNameGroup(hgName);
        }
        info.setOriginalAmount(rs.getBigDecimal("famount"));
        if (!SQLUtil.isOracle(this.ctx) && ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.condition.getCurrency().getId().toString()) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.condition.getCurrency().getId().toString()))) {
            if (rs.getString("flamount") != null && rs.getString("flamount").length() > 0) {
                info.setLocalAmount(rs.getBigDecimal("flamount"));
            } else {
                info.setLocalAmount(rs.getBigDecimal("famount"));
            }
            if (rs.getString("framount") != null && rs.getString("framount").length() > 0) {
                info.setLocalAmount(rs.getBigDecimal("framount"));
            } else {
                info.setLocalAmount(rs.getBigDecimal("famount"));
            }
        } else {
            if (rs.getBigDecimal("flamount") != null) {
                info.setLocalAmount(rs.getBigDecimal("flamount"));
            } else {
                info.setLocalAmount(rs.getBigDecimal("famount"));
            }
            if (rs.getBigDecimal("framount") != null) {
                info.setReportingAmount(rs.getBigDecimal("framount"));
            } else {
                info.setReportingAmount(rs.getBigDecimal("famount"));
            }
        }
        info.setAccountAssistTypeId(rs.getString("AsstTypeId"));
        return info;
    }

    private void addCashflowTAccountInfo(List[] infos, CashflowTAccountInfo info) {
        if (info.getAmount().doubleValue() == 0.0) {
            return;
        }
        if (info.isCredit()) {
            if (info.isCash()) {
                infos[2].add(info);
            } else {
                infos[3].add(info);
            }
        } else if (info.isCash()) {
            infos[0].add(info);
        } else {
            infos[1].add(info);
        }
    }

    private CashflowTAccountInfo getCashflowTAccountInfo(IRowSet rs, BigDecimal amount, boolean isCash) throws SQLException {
        CashflowTAccountInfo info = new CashflowTAccountInfo();
        if (!this.condition.isCashColl()) {
            info.setAccount(this.getAccountViewInfo(rs));
            info.setType(1);
        } else {
            info.setType(0);
            if (isCash) {
                info.setRootName(EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)"CashType", (Locale)this.ctx.getOriginLocale()));
            } else {
                info.setRootName(EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)"NoCashType", (Locale)this.ctx.getOriginLocale()));
            }
        }
        info.setAmount(amount);
        info.setLevel(1);
        info.setCredit(rs.getInt("fentrydc") == 0);
        info.setCash(isCash);
        return info;
    }

    private CashflowTAccountInfo getAccountTAccountInfo(IRowSet rs, CashflowTAccountInfo parent) throws SQLException {
        CashflowTAccountInfo info = new CashflowTAccountInfo();
        info.setAmount(rs.getBigDecimal("famount"));
        AccountViewInfo account = this.getAccountViewInfo(rs);
        info.setAccount(account);
        info.setCredit(parent.isCredit());
        info.setCash(parent.isCash());
        info.setLevel(parent.getLevel() + 1);
        info.setCfItem(parent.getCfItem());
        info.setHg(parent.getHg());
        info.setOppHg(parent.getOppHg());
        info.setType(1);
        return info;
    }

    private CashflowTAccountInfo getHGTAccountInfo(CashflowTAccountInfo parent, IRowSet rs) throws SQLException {
        CashflowTAccountInfo info = new CashflowTAccountInfo();
        info.setAmount(rs.getBigDecimal("famount"));
        String hgId = rs.getString("hgId");
        AssistantHGInfo hg = new AssistantHGInfo();
        if (hgId != null) {
            hg.setId(BOSUuid.read((String)hgId));
            hg.setLongNameGroup(rs.getString("hgName"));
        } else {
            hg.setLongNameGroup(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"188_TreeTAccount", (Locale)this.ctx.getOriginLocale()));
        }
        info.setHg(hg);
        info.setOppHg(parent.getOppHg());
        info.setAccount(parent.getAccount());
        info.setCredit(parent.isCredit());
        info.setCash(parent.isCash());
        info.setLevel(parent.getLevel() + 1);
        info.setCfItem(parent.getCfItem());
        info.setType(2);
        return info;
    }

    private CashflowTAccountInfo getOppHGTAccountInfo(CashflowTAccountInfo parent, IRowSet rs) throws SQLException {
        CashflowTAccountInfo info = new CashflowTAccountInfo();
        info.setAmount(rs.getBigDecimal("famount"));
        String hgId = rs.getString("hgId");
        AssistantHGInfo hg = new AssistantHGInfo();
        if (hgId != null) {
            hg.setId(BOSUuid.read((String)hgId));
            hg.setLongNameGroup(rs.getString("hgName"));
        } else {
            hg.setLongNameGroup(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"188_TreeTAccount", (Locale)this.ctx.getOriginLocale()));
        }
        info.setOppHg(hg);
        info.setHg(parent.getHg());
        info.setAccount(parent.getAccount());
        info.setCredit(parent.isCredit());
        info.setCash(parent.isCash());
        info.setLevel(parent.getLevel() + 1);
        info.setCfItem(parent.getCfItem());
        info.setType(3);
        return info;
    }

    private CashflowTAccountInfo getCFItemTAccountInfo(CashflowTAccountInfo parent, IRowSet rs) throws SQLException {
        CashflowTAccountInfo info = new CashflowTAccountInfo();
        if (rs.getBigDecimal("fprimarycoeffient") != null) {
            info.setAmount(rs.getBigDecimal("famount").multiply(rs.getBigDecimal("fprimarycoeffient")));
        } else {
            info.setAmount(rs.getBigDecimal("famount"));
        }
        String cfItemId = rs.getString("cfItemId");
        CashFlowItemInfo cfItem = new CashFlowItemInfo();
        if (cfItemId != null) {
            cfItem.setId(BOSUuid.read((String)cfItemId));
            cfItem.setNumber(rs.getString("cfItemNumber"));
            cfItem.setName(rs.getString("cfItemName"));
            String sstAccountId = rs.getString("fasstaccountid");
            if (sstAccountId != null) {
                AsstAccountInfo asst = new AsstAccountInfo();
                asst.setId(BOSUuid.read((String)sstAccountId));
                cfItem.setAsstAccount(asst);
            }
        } else {
            info.setRootName(EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)"NotDealCashflow", (Locale)this.ctx.getOriginLocale()));
        }
        info.setCfItem(cfItem);
        info.setAccount(parent.getAccount());
        info.setHg(parent.getHg());
        info.setOppHg(parent.getOppHg());
        info.setCredit(parent.isCredit());
        info.setCash(parent.isCash());
        info.setLevel(parent.getLevel() + 1);
        info.setType(4);
        return info;
    }

    private AccountViewInfo getAccountViewInfo(IRowSet rs) throws SQLException {
        AccountViewInfo account = new AccountViewInfo();
        account.setId(BOSUuid.read((String)rs.getString("accountId")));
        account.setNumber(rs.getString("accountNumber"));
        account.setName(rs.getString("accountName"));
        account.setLevel(rs.getInt("accountLevel"));
        account.setIsLeaf(rs.getInt("accountIsLeaf") == 1);
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDefCFItemToCFRecord(boolean isCover, boolean notAllowModify) throws BOSException, EASBizException {
        if (!isCover) {
            return;
        }
        String tmpTableName = "";
        try {
            ArrayList sp = new ArrayList();
            tmpTableName = this.createCFRecordIdTempTable();
            String sql = CashFlowTAccountSQLFactory.insertCFRecToTemptableSQL(this.condition, null, sp, notAllowModify, tmpTableName, true);
            DbUtil.execute((Context)this.ctx, (String)sql, (Object[])sp.toArray());
            sp.clear();
            FilterInfo checkCFFilter = new FilterInfo();
            checkCFFilter.getFilterItems().add(new FilterItemInfo("cfRecord in (select fid from " + tmpTableName + " )"));
            Map checkResult = CFRequisitionFactory.getLocalInstance(this.ctx).checkReqCorrelation(checkCFFilter);
            if (checkResult != null) {
                Set checkedIds = (Set)checkResult.get("idSet");
                String checkMsg = (String)checkResult.get("detail");
                this.processResult.put("coverFailureCount", checkedIds.size());
                this.processResult.put("coverFailureDetail", checkMsg);
            }
            DbUtil.execute((Context)this.ctx, (String)("delete from " + tmpTableName + " tmp where exists (select 1 from t_gl_cfrequisition cfrq where tmp.fid = cfrq.fcfrecordid and cfrq.fstatus = '2')"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("cfRecord in (select fid from " + tmpTableName + " )"));
            CFRequisitionFactory.getLocalInstance(this.ctx).clearRequisition(filter, this.condition.getCompanyId());
            String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
            sql = CashFlowTAccountSQLFactory.applyDefCFItemToCFRecordSQL(this.ctx, this.condition, sp, userId, notAllowModify, tmpTableName);
            DbUtil.execute((Context)this.ctx, (String)sql, (Object[])sp.toArray());
        }
        finally {
            if (!StringUtils.isEmpty((String)tmpTableName)) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tmpTableName);
            }
        }
    }

    private void applyDefCFItemToCFSplitRecord(String tmpTableName, boolean isCover, boolean notAllowModify) throws BOSException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.insertSplitRecToTemptableSQL(this.condition, sp, tmpTableName, notAllowModify);
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])sp.toArray());
        sp = new ArrayList();
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString();
        sql = CashFlowTAccountSQLFactory.applyDefCFItemToCFSplitRecordSQL(this.condition, isCover, sp, tmpTableName, userId, cuId);
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])sp.toArray());
        DbUtil.execute((Context)this.ctx, (String)CashFlowTAccountSQLFactory.deleteCashflowsplitrecordSQL(tmpTableName));
    }

    private String createCFSplitRecordIdTempTable() throws BOSException {
        try {
            return TempTablePool.getInstance((Context)this.ctx).createTempTable(CashFlowTAccountSQLFactory.getCFSplitRecordIdTempTableSQL());
        }
        catch (Exception e) {
            throw new BOSException("Create tempTable error!", (Throwable)e);
        }
    }

    private String createCFRecordIdTempTable() throws BOSException {
        try {
            return TempTablePool.getInstance((Context)this.ctx).createTempTable("create table T_GL_applyDefOverCFRecordID (fid varchar(44))");
        }
        catch (Exception e) {
            throw new BOSException("Create tempTable error!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCFItemToCFRec(CashflowTAccountInfo info, CashFlowItemInfo cfItem, boolean notAllowModify) throws BOSException, EASBizException {
        String tmpTableName = "";
        try {
            ArrayList sp = new ArrayList();
            String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
            tmpTableName = this.createCFRecordIdTempTable();
            String sql = CashFlowTAccountSQLFactory.insertCFRecToTemptableSQL(this.condition, info, sp, notAllowModify, tmpTableName, false);
            DbUtil.execute((Context)this.ctx, (String)sql, (Object[])sp.toArray());
            sp.clear();
            FilterInfo checkCFFilter = new FilterInfo();
            checkCFFilter.getFilterItems().add(new FilterItemInfo("cfRecord in (select fid from " + tmpTableName + " )"));
            Map checkResult = CFRequisitionFactory.getLocalInstance(this.ctx).checkReqCorrelation(checkCFFilter);
            if (checkResult != null) {
                Set checkedIds = (Set)checkResult.get("idSet");
                String checkMsg = (String)checkResult.get("detail");
                this.processResult.put("coverFailureCount", checkedIds.size());
                this.processResult.put("coverFailureDetail", checkMsg);
            }
            DbUtil.execute((Context)this.ctx, (String)("delete from " + tmpTableName + " tmp where exists (select 1 from t_gl_cfrequisition cfrq where tmp.fid = cfrq.fcfrecordid and cfrq.fstatus = '2')"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("cfRecord in (select fid from " + tmpTableName + " )"));
            CFRequisitionFactory.getLocalInstance(this.ctx).clearRequisition(filter, this.condition.getCompanyId());
            sql = CashFlowTAccountSQLFactory.applyCFItemToCFRecSQL(this.condition, info, cfItem, userId, sp, notAllowModify, tmpTableName);
            DbUtil.execute((Context)this.ctx, (String)sql, (Object[])sp.toArray());
        }
        finally {
            if (!StringUtils.isEmpty((String)tmpTableName)) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tmpTableName);
            }
        }
    }

    private void applyCFItemToSplitRec(CashflowTAccountInfo info, CashFlowItemInfo cfItem, boolean notAllowModify) throws BOSException, EASBizException {
        CashflowSplitRecordCollection splitColl;
        FilterInfo filter;
        String tempTable;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        String sql;
        block16: {
            HashSet<String> idSet;
            block15: {
                ArrayList sp = new ArrayList();
                sql = CashFlowTAccountSQLFactory.getCashflowSplitRecordIDSQL(this.condition, info, sp, notAllowModify);
                conn = null;
                ps = null;
                rs = null;
                tempTable = "";
                conn = this.getConnection();
                ps = conn.prepareStatement(sql);
                for (int i = 0; i < sp.size(); ++i) {
                    ps.setObject(i + 1, sp.get(i));
                }
                rs = ps.executeQuery();
                idSet = new HashSet<String>();
                while (rs.next()) {
                    idSet.add(rs.getString("fid"));
                }
                if (idSet.size() != 0) break block15;
                if (!StringUtils.isEmpty((String)tempTable)) {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                return;
            }
            filter = new FilterInfo();
            if (idSet.size() <= 5000) {
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            } else {
                String createTableSql = "create table gl_temp_table (id varchar(44))";
                ArrayList<String[]> paramsList = new ArrayList<String[]>();
                tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSql);
                for (String id : idSet) {
                    paramsList.add(new String[]{id});
                }
                String insertSql = "insert into " + tempTable + " values(?)";
                DbUtil.executeBatch((Context)this.ctx, (String)insertSql, paramsList);
                filter.getFilterItems().add(new FilterItemInfo("id in (select id from " + tempTable + ")"));
            }
            splitColl = this.getCashflowSplitRecordCollection(filter);
            if (splitColl != null && splitColl.size() != 0) break block16;
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return;
        }
        try {
            CashflowRecordCollection records = this.toCashflowCollection(splitColl, cfItem);
            CashflowRecordFactory.getLocalInstance(this.ctx).addNewBatch(records);
            CashflowSplitRecordFactory.getLocalInstance(this.ctx).delete(filter);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"sql error!", (Throwable)e);
                throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                if (!StringUtils.isEmpty((String)tempTable)) {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)tempTable)) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    protected void autoSetCFRecordAsst(boolean isCover, boolean notAllowModify) throws BOSException, EASBizException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getAutoSetAsstCFRecordSQL(this.condition, isCover, sp, notAllowModify);
        Connection conn = null;
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        HashSet<String> cfids = new HashSet<String>();
        int sendCount = 0;
        ICFRequisition cfRequisition = CFRequisitionFactory.getLocalInstance(this.ctx);
        boolean enableSendCFR = cfRequisition.isEnableCFRequisition(this.condition.getCompanyId());
        try {
            conn = this.getConnection();
            ps1 = conn.prepareStatement(sql);
            for (int i = 0; i < sp.size(); ++i) {
                ps1.setObject(i + 1, sp.get(i));
            }
            rs = ps1.executeQuery();
            HashMap hmDynamicColumnInfo = new HashMap();
            ps2 = conn.prepareStatement(CashFlowTAccountSQLFactory.updateCashflowRecordAssGrpSQL());
            int count = 0;
            Object obj = GlUtils.getParamByKey(this.ctx, this.condition.getCompanyId(), "GL_0152");
            boolean isSimpleMode = "0".equals(obj.toString());
            while (rs.next()) {
                String fassgrpid;
                String asstAccountId = rs.getString("fasstaccountid");
                if (asstAccountId == null || !isCover && (fassgrpid = rs.getString("fassgrpid")) != null && !"".equals(fassgrpid.trim())) continue;
                Object[] asstInfo = this.getCachedColumnInfo(this.ctx, hmDynamicColumnInfo, asstAccountId);
                if (this.setCashflowRecordAssGrp(ps2, rs, asstAccountId, asstInfo, isSimpleMode, cfids)) {
                    ++count;
                }
                if (count < 1000) continue;
                ps2.executeBatch();
                ps2.clearBatch();
                if (enableSendCFR) {
                    sendCount += cfRequisition.sendRequisition(cfids, this.condition.getCompanyId(), true);
                }
                cfids.clear();
                count = 0;
            }
            if (count > 0) {
                ps2.executeBatch();
                if (enableSendCFR) {
                    sendCount += cfRequisition.sendRequisition(cfids, this.condition.getCompanyId(), true);
                }
            }
            if (!enableSendCFR) {
                this.processResult.put("enableSendCFR", false);
            }
            this.processResult.put("sendSuccCount", sendCount);
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps1);
                SQLUtils.cleanup(ps2);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps1);
        SQLUtils.cleanup((Statement)ps2);
        SQLUtils.cleanup((Connection)conn);
    }

    private boolean setCashflowRecordAssGrp(PreparedStatement ps, ResultSet rs, String asstAccountId, Object[] asstInfo, boolean isSimpleMode, Set<String> cfids) throws BOSException, EASBizException, SQLException {
        if (asstInfo == null) {
            return false;
        }
        CashflowTypeEnum type = CashflowTypeEnum.OUT;
        VoucherInfo.DynamicColumnInfo[] cfiActTypeCols = (VoucherInfo.DynamicColumnInfo[])asstInfo[0];
        AssistantHGInfo group = new AssistantHGInfo();
        String id = rs.getString("fid");
        if (isSimpleMode) {
            AssistantHGInfo hgInfo = GlUtils.dynamicLoadAssistangHG(this.ctx, new HashMap(), rs.getString("hgId"), cfiActTypeCols);
            Object foundValue = null;
            for (int i = 0; i < cfiActTypeCols.length; ++i) {
                String key = cfiActTypeCols[i].getMappingPropName();
                Object object = foundValue = hgInfo == null ? null : hgInfo.get(key);
                if (foundValue == null) {
                    foundValue = this.getAssistValue(rs, key);
                }
                if (foundValue == null) continue;
                if ("customer".equals(key)) {
                    if (((CustomerInfo)foundValue).isIsInternalCompany() || ((CustomerInfo)foundValue).getInternalCompany() != null) {
                        type = CashflowTypeEnum.IN;
                    }
                } else if ("provider".equals(key)) {
                    if (((SupplierInfo)foundValue).isIsInternalCompany() || ((SupplierInfo)foundValue).getInternalCompany() != null) {
                        type = CashflowTypeEnum.IN;
                    }
                } else if ("companyOrg".equals(key)) {
                    type = CashflowTypeEnum.IN;
                }
                if ("customer".equals(key) || "provider".equals(key) || "companyOrg".equals(key)) {
                    cfids.add(id);
                }
                group.put(key, foundValue);
            }
        }
        AsstAccountInfo asstAccount = new AsstAccountInfo();
        asstAccount.setId(BOSUuid.read((String)asstAccountId));
        group.setAsstAccount(asstAccount);
        AssistantHGInfo hg = VoucherFacadeFactory.getLocalInstance((Context)this.ctx).confirmAssGrp(group, asstAccountId, cfiActTypeCols);
        this.batchUpdateCFAssGrp(ps, id, hg.getId().toString(), type);
        return true;
    }

    private Object getAssistValue(ResultSet rs, String key) throws SQLException {
        String companyOrgId = rs.getString("fcompanyorgid");
        String customerId = rs.getString("fcustomerid");
        String custCompanyId = rs.getString("custCompanyId");
        String providerId = rs.getString("fproviderid");
        String suppCompanyId = rs.getString("suppCompanyId");
        String custBizCode = rs.getString("custBizCode");
        String suppBizCode = rs.getString("suppBizCode");
        String bizAnalysisCodeId = custBizCode != null ? custBizCode : suppBizCode;
        Object foundValue = null;
        if ("companyOrg".equals(key)) {
            String companyId = null;
            if (companyOrgId != null) {
                companyId = companyOrgId;
            } else if (custCompanyId != null) {
                companyId = custCompanyId;
            } else if (suppCompanyId != null) {
                companyId = suppCompanyId;
            }
            if (companyId != null) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)companyId));
                foundValue = company;
            }
        } else if ("customer".equals(key)) {
            if (customerId != null) {
                CustomerInfo customer = new CustomerInfo();
                customer.setId(BOSUuid.read((String)customerId));
                if (custCompanyId != null || companyOrgId != null) {
                    customer.setIsInternalCompany(true);
                } else {
                    customer.setIsInternalCompany(false);
                }
                foundValue = customer;
            } else {
                try {
                    foundValue = com.kingdee.eas.fi.gl.CashFlowUtils.getCustomerOrSupplier(this.ctx, companyOrgId, bizAnalysisCodeId, key);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if ("provider".equals(key)) {
            if (providerId != null) {
                SupplierInfo supplier = new SupplierInfo();
                supplier.setId(BOSUuid.read((String)providerId));
                if (suppCompanyId != null || companyOrgId != null) {
                    supplier.setIsInternalCompany(true);
                } else {
                    supplier.setIsInternalCompany(false);
                }
                foundValue = supplier;
            } else {
                try {
                    foundValue = com.kingdee.eas.fi.gl.CashFlowUtils.getCustomerOrSupplier(this.ctx, companyOrgId, bizAnalysisCodeId, key);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return foundValue;
    }

    private void batchUpdateCFAssGrp(PreparedStatement ps, String cfId, String hgId, CashflowTypeEnum type) throws SQLException {
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        ps.setObject(1, hgId);
        ps.setObject(2, new Integer(type.getValue()));
        ps.setObject(3, userId);
        ps.setObject(4, new Timestamp(System.currentTimeMillis()));
        ps.setObject(5, cfId);
        ps.addBatch();
    }

    private Object[] getCachedColumnInfo(Context ctx, Map hmDynamicColumnInfo, String typeGroupId) throws EASBizException, BOSException {
        if (typeGroupId == null) {
            return null;
        }
        Object[] colInfo = (Object[])hmDynamicColumnInfo.get(typeGroupId);
        if (colInfo == null) {
            colInfo = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchAssColumnInfo(null, typeGroupId, null);
            hmDynamicColumnInfo.put(typeGroupId, colInfo);
        }
        return colInfo;
    }

    private FilterInfo getIDFilter(ResultSet rs) throws SQLException {
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        while (rs.next()) {
            idSet.add(rs.getString("fid"));
        }
        if (idSet.size() == 0) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        return filter;
    }

    private CashflowRecordCollection getCashflowRecordCollection(FilterInfo filter) throws BOSException {
        if (filter == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isSupItem"));
        view.getSelector().add(new SelectorItemInfo("voucher.id"));
        view.getSelector().add(new SelectorItemInfo("entry.id"));
        view.getSelector().add(new SelectorItemInfo("account.id"));
        view.getSelector().add(new SelectorItemInfo("currency.id"));
        view.getSelector().add(new SelectorItemInfo("entryDC"));
        view.getSelector().add(new SelectorItemInfo("opposingAccountEntry.id"));
        view.getSelector().add(new SelectorItemInfo("oppAccount.id"));
        view.getSelector().add(new SelectorItemInfo("oppEntryDC"));
        view.getSelector().add(new SelectorItemInfo("oppVoucherAssistRecord.id"));
        view.getSelector().add(new SelectorItemInfo("oppAssGrp.id"));
        view.getSelector().add(new SelectorItemInfo("originalAmount"));
        view.getSelector().add(new SelectorItemInfo("localAmount"));
        view.getSelector().add(new SelectorItemInfo("reportingAmount"));
        view.setFilter(filter);
        return CashflowRecordFactory.getLocalInstance(this.ctx).getCashflowRecordCollection(view);
    }

    private CashflowSplitRecordCollection getCashflowSplitRecordCollection(FilterInfo filter) throws BOSException {
        if (filter == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isSupItem"));
        view.getSelector().add(new SelectorItemInfo("voucher.id"));
        view.getSelector().add(new SelectorItemInfo("entry.id"));
        view.getSelector().add(new SelectorItemInfo("account.id"));
        view.getSelector().add(new SelectorItemInfo("currency.id"));
        view.getSelector().add(new SelectorItemInfo("entryDC"));
        view.getSelector().add(new SelectorItemInfo("opposingAccountEntry.id"));
        view.getSelector().add(new SelectorItemInfo("oppAccount.id"));
        view.getSelector().add(new SelectorItemInfo("oppEntryDC"));
        view.getSelector().add(new SelectorItemInfo("oppVoucherAssistRecord.id"));
        view.getSelector().add(new SelectorItemInfo("oppAssGrp.id"));
        view.getSelector().add(new SelectorItemInfo("originalAmount"));
        view.getSelector().add(new SelectorItemInfo("localAmount"));
        view.getSelector().add(new SelectorItemInfo("reportingAmount"));
        view.setFilter(filter);
        return CashflowSplitRecordFactory.getLocalInstance(this.ctx).getCashflowSplitRecordCollection(view);
    }

    private CashflowRecordCollection toCashflowCollection(CashflowSplitRecordCollection splitColl, CashFlowItemInfo cfItem) {
        CashflowRecordCollection coll = new CashflowRecordCollection();
        Iterator it = splitColl.iterator();
        CashflowSplitRecordInfo splitInfo = null;
        while (it.hasNext()) {
            splitInfo = (CashflowSplitRecordInfo)it.next();
            coll.add(this.createCashflowRecordInfo(cfItem, splitInfo));
        }
        return coll;
    }

    private CashflowRecordInfo createCashflowRecordInfo(CashFlowItemInfo cfItem, CashflowSplitRecordInfo splitInfo) {
        CashflowRecordInfo record = new CashflowRecordInfo();
        record.setVoucher(splitInfo.getVoucher());
        record.setEntry(splitInfo.getEntry());
        record.setAccount(splitInfo.getAccount());
        record.setCurrency(splitInfo.getCurrency());
        record.setEntryDC(splitInfo.getEntryDC());
        record.setOpposingAccountEntry(splitInfo.getOpposingAccountEntry());
        record.setOppAccount(splitInfo.getOppAccount());
        record.setOppEntryDC(splitInfo.getOppEntryDC());
        record.setOppVoucherAssistRecord(splitInfo.getOppVoucherAssistRecord());
        record.setOppAssGrp(splitInfo.getOppAssGrp());
        record.setOriginalAmount(splitInfo.getOriginalAmount());
        record.setLocalAmount(splitInfo.getLocalAmount());
        record.setReportingAmount(splitInfo.getReportingAmount());
        record.setPrimaryItem(cfItem);
        int coeff = splitInfo.getEntryDC() == EntryDC.DEBIT && cfItem.getDirection() == CashFlowDirection.OUT || splitInfo.getEntryDC() == EntryDC.CREDIT && cfItem.getDirection() == CashFlowDirection.IN ? -1 : 1;
        record.setPrimaryCoefficient(coeff);
        record.setItemFlag(ItemFlag.PRIMARY);
        record.setIsSupItem(splitInfo.isIsSupItem());
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        record.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        record.setCreateTime(nowTime);
        record.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        record.setLastUpdateTime(nowTime);
        return record;
    }

    private CashflowSplitRecordCollection toCashflowSplitCollection(CashflowRecordCollection recordColl) {
        if (recordColl == null) {
            return null;
        }
        CashflowSplitRecordCollection coll = new CashflowSplitRecordCollection();
        Iterator it = recordColl.iterator();
        CashflowRecordInfo record = null;
        while (it.hasNext()) {
            record = (CashflowRecordInfo)it.next();
            coll.add(this.createCashflowSplitRecordInfo(record));
        }
        return coll;
    }

    private CashflowSplitRecordInfo createCashflowSplitRecordInfo(CashflowRecordInfo record) {
        CashflowSplitRecordInfo splitInfo = new CashflowSplitRecordInfo();
        splitInfo.setVoucher(record.getVoucher());
        splitInfo.setEntry(record.getEntry());
        splitInfo.setAccount(record.getAccount());
        splitInfo.setCurrency(record.getCurrency());
        splitInfo.setEntryDC(record.getEntryDC());
        splitInfo.setOpposingAccountEntry(record.getOpposingAccountEntry());
        splitInfo.setOppAccount(record.getOppAccount());
        splitInfo.setOppEntryDC(record.getOppEntryDC());
        splitInfo.setOppAssGrp(record.getOppAssGrp());
        splitInfo.setOppVoucherAssistRecord(record.getOppVoucherAssistRecord());
        splitInfo.setOriginalAmount(record.getOriginalAmount());
        splitInfo.setLocalAmount(record.getLocalAmount());
        splitInfo.setReportingAmount(record.getReportingAmount());
        splitInfo.setItemFlag(ItemFlag.PRIMARY);
        splitInfo.setIsSupItem(record.isIsSupItem());
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        splitInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        splitInfo.setCreateTime(nowTime);
        splitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        splitInfo.setLastUpdateTime(nowTime);
        return splitInfo;
    }

    protected void splitTAccountVoucher() throws BOSException, EASBizException {
        Set searchResult = this.searchUnsplitVoucher(this.ctx, this.condition);
        if (searchResult.size() > 0) {
            this.updateFinishedVoucher(this.ctx, this.condition);
            Set unFinished = this.queryUnfinishAssignVoucher(this.ctx, this.condition);
            this.deleteCashflowRecordOfUnFinishedVoucher(this.ctx, this.condition, unFinished);
            this.deleteCashflowSplitRecordOfUnFinishedVoucher(this.ctx, this.condition, unFinished);
            this.splitUnfinishedVoucher(this.ctx, unFinished);
        }
    }

    private Set searchUnsplitVoucher(Context ctx, CashflowQueryParam param) throws BOSException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowTAccountSQLFactory.getUnSplitVoucherSQL(param, sp);
        IRowSet rsUnsplit = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])sp.toArray());
        HashSet<String> unsplitVoucher = new HashSet<String>();
        try {
            while (rsUnsplit.next()) {
                unsplitVoucher.add(rsUnsplit.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return unsplitVoucher;
    }

    private void updateFinishedVoucher(Context ctx, CashflowQueryParam param) throws BOSException {
        ArrayList params = new ArrayList();
        String sqlFinished = null;
        sqlFinished = param.isPeriod() ? CashFlowUtils.getPrimaryItemVocuherSql(param.getCompanyId(), param.isIndcludeNoPosted(), true, new Integer(param.getStartYear() * 100 + param.getStartPeriod()), new Integer(param.getEndYear() * 100 + param.getEndPeriod()), null, null, params, 1) : CashFlowUtils.getPrimaryItemVocuherSql(param.getCompanyId(), param.isIndcludeNoPosted(), false, null, null, param.getStartDate(), param.getEndDate(), params, 1);
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append("update t_gl_voucher set fcashflowflag = 6 where fid in (\r\n");
        sqlUpdate.append(sqlFinished);
        sqlUpdate.append(") and fcashflowflag <> ").append(0).append(" \r\n");
        DbUtil.execute((Context)ctx, (String)sqlUpdate.toString(), (Object[])params.toArray());
    }

    private Set queryUnfinishAssignVoucher(Context ctx, CashflowQueryParam param) throws BOSException {
        ArrayList params = new ArrayList();
        String sql = null;
        sql = param.isPeriod() ? CashFlowUtils.getPrimaryItemVocuherSql(param.getCompanyId(), param.isIndcludeNoPosted(), true, new Integer(param.getStartYear() * 100 + param.getStartPeriod()), new Integer(param.getEndYear() * 100 + param.getEndPeriod()), null, null, params, 2) : CashFlowUtils.getPrimaryItemVocuherSql(param.getCompanyId(), param.isIndcludeNoPosted(), false, null, null, param.getStartDate(), param.getEndDate(), params, 2);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params.toArray());
        HashSet<String> ids = new HashSet<String>();
        try {
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sqlSelect = new StringBuffer();
        ArrayList<Object> selectParams = new ArrayList<Object>();
        sqlSelect.append("select v.fid from t_gl_voucher v \r\n");
        sqlSelect.append("inner join t_bd_period p on v.fperiodid=p.fid \r\n");
        sqlSelect.append("where v.fcompanyid=? \r\n");
        selectParams.add(param.getCompanyId());
        if (param.isPeriod()) {
            sqlSelect.append("and p.fnumber >= ? and p.fnumber <= ? \r\n");
            selectParams.add(new Integer(param.getStartYear() * 100 + param.getStartPeriod()));
            selectParams.add(new Integer(param.getEndYear() * 100 + param.getEndPeriod()));
        } else {
            sqlSelect.append("and v.fbookeddate >= ? and v.fbookeddate <= ? \r\n");
            selectParams.add(param.getStartDate());
            selectParams.add(param.getEndDate());
        }
        sqlSelect.append("and v.fhascashaccount = 1 and v.fcashflowflag =").append(0).append(" \r\n");
        if (!param.isIndcludeNoPosted()) {
            sqlSelect.append("  and v.fbizstatus = 5 ");
        } else {
            sqlSelect.append("  and v.fbizstatus <> 0  and v.fbizstatus <> 2 ");
        }
        IRowSet rsUnsplit = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString(), (Object[])selectParams.toArray());
        try {
            while (rsUnsplit.next()) {
                ids.add(rsUnsplit.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    private void deleteCashflowRecordOfUnFinishedVoucher(Context ctx, CashflowQueryParam param, Set unFinished) throws BOSException {
        String sqlDelete = "delete from t_gl_cashflowrecord where fvoucherid in (%s)";
        ArrayList<String> params = new ArrayList<String>();
        int deleteSize = 200;
        int currentSize = 0;
        StringBuffer sqlCondition = new StringBuffer();
        for (String voucherId : unFinished) {
            sqlCondition.append("?");
            params.add(voucherId);
            if (++currentSize % deleteSize == 0) {
                DbUtil.execute((Context)ctx, (String)sqlDelete.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
                params.clear();
                sqlCondition.delete(0, sqlCondition.length());
                continue;
            }
            sqlCondition.append(",");
        }
        if (params.size() > 0) {
            sqlCondition.deleteCharAt(sqlCondition.length() - 1);
            DbUtil.execute((Context)ctx, (String)sqlDelete.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
        }
    }

    private void deleteCashflowSplitRecordOfUnFinishedVoucher(Context ctx, CashflowQueryParam param, Set unFinished) throws BOSException {
        String sqlDelete = "delete from t_gl_cashflowsplitrecord where fvoucherid in (%s)";
        ArrayList<String> params = new ArrayList<String>();
        int deleteSize = 200;
        int currentSize = 0;
        StringBuffer sqlCondition = new StringBuffer();
        for (String voucherId : unFinished) {
            sqlCondition.append("?");
            params.add(voucherId);
            if (++currentSize % deleteSize == 0) {
                DbUtil.execute((Context)ctx, (String)sqlDelete.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
                params.clear();
                sqlCondition.delete(0, sqlCondition.length());
                continue;
            }
            sqlCondition.append(",");
        }
        if (params.size() > 0) {
            sqlCondition.deleteCharAt(sqlCondition.length() - 1);
            DbUtil.execute((Context)ctx, (String)sqlDelete.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
        }
    }

    private void splitUnfinishedVoucher(Context ctx, Set unFinished) throws BOSException, EASBizException {
        HashSet idSet = new HashSet();
        int currentSize = 0;
        Iterator it = unFinished.iterator();
        while (it.hasNext()) {
            idSet.add(it.next());
            if (++currentSize != 100) continue;
            this.splitVoucherCollection(ctx, idSet);
            idSet.clear();
            currentSize = 0;
        }
        if (!idSet.isEmpty()) {
            this.splitVoucherCollection(ctx, idSet);
        }
    }

    private void splitVoucherCollection(Context ctx, Set unFinished) throws BOSException, EASBizException {
        VoucherCollection voucherCol = this.getVoucherCollection(unFinished, ctx);
        ITAccountSplitStrategy strategy = TAccountSplitStrategyFactory.getSplitStrategy("default");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("number"));
        CompanyOrgUnitInfo curCompany = GlUtils.getCurrentCompany(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), sic, false);
        HashMap<String, Object> splitParams = new HashMap<String, Object>();
        splitParams.put("CurrentCompany", curCompany);
        CashflowSplitRecordCollection splitResult = new CashflowSplitRecordCollection();
        int size = voucherCol.size();
        for (int i = 0; i < size; ++i) {
            CashflowSplitRecordCollection result = strategy.split(ctx, voucherCol.get(i), splitParams);
            splitResult.addCollection(result);
        }
        ICashflowSplitRecord cfSplit = CashflowSplitRecordFactory.getLocalInstance(ctx);
        cfSplit.addBatch((IObjectCollection)splitResult);
        String sqlUpdate = CashFlowTAccountSQLFactory.updateVoucherCashFlagSQL();
        ArrayList<String> params = new ArrayList<String>();
        int updateSize = 200;
        int currentSize = 0;
        StringBuffer sqlCondition = new StringBuffer();
        for (String voucherId : unFinished) {
            sqlCondition.append("?");
            params.add(voucherId);
            if (++currentSize % updateSize == 0) {
                DbUtil.execute((Context)ctx, (String)sqlUpdate.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
                params.clear();
                sqlCondition.delete(0, sqlCondition.length());
                continue;
            }
            sqlCondition.append(",");
        }
        if (params.size() > 0) {
            sqlCondition.deleteCharAt(sqlCondition.length() - 1);
            DbUtil.execute((Context)ctx, (String)sqlUpdate.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
        }
    }

    private VoucherCollection getVoucherCollection(Set voucherIds, Context ctx) throws BOSException, EASBizException {
        if (voucherIds.size() == 0) {
            return new VoucherCollection();
        }
        EntityViewInfo v = new EntityViewInfo();
        v.getSelector().addObjectCollection((IObjectCollection)VoucherInfo.getCashflowSelector());
        SorterItemCollection sorters = v.getSorter();
        SorterItemInfo sort = new SorterItemInfo("entries.seq");
        sorters.add(sort);
        VoucherCollection vchCol = new VoucherCollection();
        int length = 0;
        Iterator iter = voucherIds.iterator();
        HashSet<String> tempIdSet = new HashSet<String>();
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        while (iter.hasNext()) {
            String id = (String)iter.next();
            tempIdSet.add(id);
            if (++length != 100) continue;
            FilterInfo filter = new FilterInfo();
            v.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", tempIdSet, CompareType.INCLUDE));
            vchCol.addCollection(iVoucher.getVoucherCollection(v));
            length = 0;
            tempIdSet.clear();
        }
        if (tempIdSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            v.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", tempIdSet, CompareType.INCLUDE));
            vchCol.addCollection(iVoucher.getVoucherCollection(v));
        }
        return vchCol;
    }

    private boolean notModifyAfterAudit() throws BOSException, EASBizException {
        Object obj = GlUtils.getParamByKey(this.ctx, ContextUtil.getCurrentFIUnit((Context)this.ctx).getId().toString(), "GL_014");
        boolean notAllowModify = false;
        if (obj != null) {
            notAllowModify = Integer.parseInt(obj.toString()) == 1;
        }
        return notAllowModify;
    }

    private Connection getConnection() throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        return conn;
    }
}

