/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTAccountInfo;
import java.util.ArrayList;
import java.util.List;

public class CashFlowTAccountSQLFactory {
    protected static String getChildrenAccountSQL(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo parent, List sp) throws BOSException {
        boolean selectAccount = parent != null || !condition.isCashColl();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.fentrydc, ");
        if (selectAccount) {
            sql.append("av.fid accountId,");
            sql.append("av.fnumber accountNumber,");
            sql.append("av.fname_").append(ctx.getLocale().toString()).append(" accountName,");
            sql.append("av.flevel accountLevel, ");
            sql.append("av.fisleaf accountIsLeaf, ");
        }
        if (parent == null) {
            sql.append("sum(t.fcashAmount) fcashAmount, \r\n");
        }
        sql.append("sum(t.famount) famount \r\n");
        sql.append(" from (");
        sql.append(CashFlowTAccountSQLFactory.getQueryCashflowRecordSQL(condition, parent, sp));
        sql.append(") t \r\n");
        if (selectAccount) {
            sql.append(" inner join t_bd_accountview lav on lav.fid = t.foppaccountid \r\n");
            sql.append(" inner join t_bd_accountview av on charIndex(av.FNumber, lav.FNumber) = 1 and av.flevel = ? and lav.fcompanyid = av.fcompanyid and lav.faccounttableid = av.faccounttableid \r\n");
            int accountLevel = parent == null || parent.getAccount() == null ? 1 : parent.getAccount().getLevel() + 1;
            sp.add(new Integer(accountLevel));
        }
        sql.append(" group by t.fentrydc");
        if (selectAccount) {
            sql.append(", av.fid, av.fnumber, av.fname_").append(ctx.getLocale().toString()).append(", av.fisleaf, av.flevel \r\n");
            sql.append(" order by av.fnumber ");
        }
        return sql.toString();
    }

    protected static String getOppAssistHGSQL(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo parent, List sp) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select tt.fentrydc, tt.famount, hg.fid hgId, hg.flongNameGroup_").append(ctx.getLocale().toString()).append(" hgName ");
        sql.append(" from (select t.fentrydc, t.foppassgrpid,");
        sql.append(" sum(t.famount) famount from (");
        sql.append(CashFlowTAccountSQLFactory.getQueryCashflowRecordSQL(condition, parent, sp));
        sql.append(" ) t \r\n");
        sql.append(" group by t.fentrydc, t.foppassgrpid ) tt \r\n");
        sql.append(" left outer join t_bd_assistanthg hg on hg.fid = tt.foppassgrpid \r\n");
        sql.append(" order by hg.flongNameGroup_").append(ctx.getLocale().toString());
        return sql.toString();
    }

    protected static String getAssistHGSQL(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo parent, List sp) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select tt.fentrydc, tt.famount, hg.fid hgId, hg.flongNameGroup_").append(ctx.getLocale().toString()).append(" hgName ");
        sql.append(" from (select t.fentrydc, t.fassgrpid,");
        sql.append(" sum(t.famount) famount from (");
        sql.append(CashFlowTAccountSQLFactory.getQueryCashflowRecordSQL(condition, parent, sp));
        sql.append(" ) t \r\n");
        sql.append(" group by t.fentrydc, t.fassgrpid ) tt \r\n");
        sql.append(" left outer join t_bd_assistanthg hg on hg.fid = tt.fassgrpid \r\n");
        sql.append(" order by hg.flongNameGroup_").append(ctx.getLocale().toString());
        return sql.toString();
    }

    protected static String getCashflowItemSQL(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo parent, List sp) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ");
        if (parent == null) {
            sql.append(" tt.fentrydc, ");
        }
        sql.append(" tt.famount, tt.fprimarycoeffient, cfItem.fid cfItemId, cfItem.fnumber cfItemNumber, cfItem.fname_").append(ctx.getLocale().toString()).append(" cfItemName,cfItem.fasstaccountid ");
        sql.append(" from (select ");
        if (parent == null) {
            sql.append(" t.fentrydc,");
        }
        sql.append(" t.fprimaryitemid, t.fprimarycoeffient fprimarycoeffient ,");
        sql.append(" sum(t.famount) famount from (");
        sql.append(CashFlowTAccountSQLFactory.getQueryCashflowRecordSQL(condition, parent, sp));
        sql.append(" ) t \r\n");
        sql.append(" group by ");
        if (parent == null) {
            sql.append(" t.fentrydc, ");
        }
        sql.append(" t.fprimaryitemid,fprimarycoeffient ) tt \r\n");
        sql.append(" left outer join t_bd_cashflowitem cfItem on cfItem.fid = tt.fprimaryitemid \r\n");
        sql.append(" order by cfItem.fnumber ");
        return sql.toString();
    }

    protected static String getUnAssignedCFIVoucherIdsSQL(CashflowQueryParam condition, CashflowTAccountInfo parent, List sp) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.fvoucherid from (");
        sql.append(CashFlowTAccountSQLFactory.getCashflowSplitRecordSQL(condition, parent, sp, false));
        sql.append(") t");
        return sql.toString();
    }

    protected static String getVoucherIdsSQL(CashflowQueryParam condition, CashflowTAccountInfo parent, List sp) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.fvoucherid from (");
        sql.append(CashFlowTAccountSQLFactory.getQueryCashflowRecordSQL(condition, parent, sp));
        sql.append(") t");
        return sql.toString();
    }

    protected static String getTAccountCashflowInfos(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo parent, boolean includeAssigned, List sp) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String loc = ctx.getLocale().toString();
        sql.append("select oav.FCAA AsstTypeId,t.fid,t.fvoucherid,v.fnumber voucherNumber, v.fbizstatus, vt.fname_").append(loc).append(" voucherTypeName,");
        sql.append("v.fbookedDate, period.fperiodyear, period.fperiodnumber, ve.fseq oppEntrySeq, ve.fdescription oppEntryDesc,");
        sql.append("t.fassgrpid, t.foppassgrpid, hg.fdisplayNameGroup_").append(loc).append(" hgName, ");
        sql.append("t.faccountid saccountid, sav.fnumber saccountNumber, sav.fname_").append(loc).append(" saccountName,");
        sql.append("t.foppaccountid oaccountid, oav.fnumber oaccountnumber, oav.fname_").append(loc).append(" oaccountName, t.foppvoucherassistrecordid, t.fcurrencyid, t.fprimaryitemid,");
        sql.append("t.famount, t.fsourcetype, t.fentryid, t.fentrydc, t.foppentryid, t.foppentrydc, t.famount, t.flamount, t.framount from (");
        String assignedSQL = null;
        if (includeAssigned && (parent.getCfItem() == null || parent.getCfItem() != null && parent.getCfItem().getId() != null || parent.getHg() != null && parent.getHg().getId() != null)) {
            assignedSQL = CashFlowTAccountSQLFactory.getCashflowRecordSQL(condition, parent, sp, false);
        }
        String unAssignedSQL = null;
        if ((parent.getCfItem() == null || parent.getCfItem() != null && parent.getCfItem().getId() == null) && (parent.getHg() == null || parent.getHg() != null && parent.getHg().getId() == null)) {
            unAssignedSQL = CashFlowTAccountSQLFactory.getCashflowSplitRecordSQL(condition, parent, sp, false);
        }
        if (assignedSQL != null) {
            sql.append(assignedSQL);
        }
        if (unAssignedSQL != null) {
            if (assignedSQL != null) {
                sql.append("\r\n union all \r\n");
            }
            sql.append(unAssignedSQL);
        }
        sql.append(") t \r\n");
        sql.append("inner join t_gl_voucher v on v.fid = t.fvoucherid \r\n");
        sql.append("inner join t_bd_period period on period.fid = v.fperiodid \r\n");
        sql.append("inner join t_bd_vouchertypes vt on vt.fid = v.fvouchertypeid \r\n");
        sql.append("inner join t_gl_voucherentry ve on ve.fbillid = v.fid and ve.fid = t.foppentryid \r\n");
        sql.append("inner join t_bd_accountview sav on sav.fid = t.faccountid and sav.fcompanyid = ? \r\n");
        sql.append("inner join t_bd_accountview oav on oav.fid = t.foppaccountid and oav.fcompanyid = ? \r\n");
        sql.append("left outer join t_bd_assistanthg hg on hg.fid = t.foppassgrpid \r\n");
        sql.append("order by v.fnumber");
        sp.add(condition.getCompanyId());
        sp.add(condition.getCompanyId());
        return sql.toString();
    }

    private static String getQueryCashflowRecordSQL(CashflowQueryParam param, CashflowTAccountInfo parent, List sp) throws BOSException {
        if (parent != null && (parent.getCfItem() != null && parent.getCfItem().getId() != null || parent.getHg() != null && parent.getHg().getId() != null)) {
            return CashFlowTAccountSQLFactory.getCashflowRecordSQL(param, parent, sp, false);
        }
        if (parent != null && parent.getCfItem() != null && parent.getCfItem().getId() == null) {
            return CashFlowTAccountSQLFactory.getCashflowSplitRecordSQL(param, parent, sp, false);
        }
        return CashFlowTAccountSQLFactory.getCashflowRecordSQL(param, parent, sp, false) + "\r\n union all \r\n" + CashFlowTAccountSQLFactory.getCashflowSplitRecordSQL(param, parent, sp, false);
    }

    private static String getCashflowRecordSQL(CashflowQueryParam param, CashflowTAccountInfo parent, List sp, boolean notAllowModify) {
        StringBuffer sql = new StringBuffer();
        sql.append("select cf.fid,cf.fvoucherid, cf.fassgrpid, cf.foppassgrpid, cf.fcurrencyid, cf.faccountid, cf.foppaccountid, cf.fprimaryitemid,");
        if (parent == null) {
            sql.append(CashFlowTAccountSQLFactory.getIsCashAmountSQL("cf", param));
        } else {
            sql.append(CashFlowTAccountSQLFactory.getAmountSQL("cf", param));
        }
        sql.append(1).append(" fsourcetype, \r\n");
        sql.append("cf.fentryid, cf.fentrydc, cf.fopposingaccountentryid foppentryid, cf.foppentrydc, cf.foppvoucherassistrecordid \r\n");
        sql.append(", cf.fprimarycoeffient fprimarycoeffient \r\n");
        sql.append(" from t_gl_cashflowrecord cf \r\n");
        sql.append(" inner join t_bd_accountview oav on oav.fid = cf.foppaccountid \r\n");
        sql.append(" inner join t_bd_accountview sav on sav.fid = cf.faccountid \r\n");
        sql.append(" where ");
        sql.append(CashFlowTAccountSQLFactory.getVoucherFilterSQL(param, sp, "cf", notAllowModify));
        if (param.getCurrency() != null && !param.getCurrency().getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !param.getCurrency().getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sql.append(" and cf.fcurrencyid=? \r\n");
            sp.add(param.getCurrency().getId().toString());
        }
        sql.append(CashFlowTAccountSQLFactory.getParentFilterSQL(parent, sp, "cf"));
        sql.append(" and (sav.fisCash=1 or sav.fisBank=1 or sav.fisCashEquivalent=1) \r\n");
        if (parent != null) {
            if (parent.isCash()) {
                sql.append(" and (oav.fisCash=1 or oav.fisBank=1 or oav.fisCashEquivalent=1) \r\n");
            } else {
                sql.append(" and (oav.fisCash=0 and oav.fisBank=0 and oav.fisCashEquivalent=0) \r\n");
            }
            sql.append(" and cf.fentrydc = ? ");
            sp.add(new Integer(parent.isCredit() ? 0 : 1));
        }
        sql.append(" and oav.fcompanyid = ? and sav.fcompanyid = ? ");
        sp.add(param.getCompanyId());
        sp.add(param.getCompanyId());
        return sql.toString();
    }

    private static String getCashflowSplitRecordSQL(CashflowQueryParam param, CashflowTAccountInfo parent, List sp, boolean notAllowModify) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select cfs.fid, cfs.fvoucherid, null fassgrpid, cfs.foppassgrpid, cfs.fcurrencyid, cfs.faccountid,cfs.foppaccountid, null fprimaryitemid,");
        if (parent == null) {
            sql.append(CashFlowTAccountSQLFactory.getIsCashAmountSQL("cfs", param));
        } else {
            sql.append(CashFlowTAccountSQLFactory.getAmountSQL("cfs", param));
        }
        sql.append(2).append(" fsourcetype, \r\n");
        sql.append(" cfs.fentryid, cfs.fentrydc, cfs.fopposingaccountentryid foppentryid, cfs.foppentrydc, cfs.foppvoucherassistrecordid \r\n");
        sql.append(", null fprimarycoeffient \r\n");
        sql.append(" from t_gl_cashflowsplitrecord cfs \r\n");
        sql.append(" inner join t_bd_accountview oav on oav.fid = cfs.foppaccountid \r\n");
        sql.append(" where ");
        sql.append(CashFlowTAccountSQLFactory.getVoucherFilterSQL(param, sp, "cfs", notAllowModify));
        sql.append(" and cfs.fitemflag=").append(1);
        if (param.getCurrency() != null && !param.getCurrency().getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !param.getCurrency().getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sql.append(" and cfs.fcurrencyid=?");
            sp.add(param.getCurrency().getId().toString());
        }
        sql.append(CashFlowTAccountSQLFactory.getParentFilterSQL(parent, sp, "cfs"));
        if (parent != null) {
            if (parent.isCash()) {
                sql.append(" and (oav.fisCash=1 or oav.fisBank=1 or oav.fisCashEquivalent=1) \r\n");
            } else {
                sql.append(" and (oav.fisCash=0 and oav.fisBank=0 and oav.fisCashEquivalent=0) \r\n");
            }
            sql.append(" and cfs.fentrydc = ? ");
            sp.add(new Integer(parent.isCredit() ? 0 : 1));
        }
        sql.append(" and oav.fcompanyid = ? ");
        sp.add(param.getCompanyId());
        return sql.toString();
    }

    private static String getAmountSQL(String tabAlias, CashflowQueryParam param) {
        StringBuffer sql = new StringBuffer();
        CurrencyInfo currency = param.getCurrency();
        if (currency != null && currency.getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            sql.append(tabAlias).append(".flocalamount famount,");
            sql.append("'' framount,");
            sql.append("'' flamount,");
        } else if (currency != null && currency.getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sql.append(tabAlias).append(".freportingamount famount,");
            sql.append("'' framount,");
            sql.append("'' flamount,");
        } else {
            sql.append(tabAlias).append(".foriginalamount famount,");
            sql.append(tabAlias).append(".freportingamount framount,");
            sql.append(tabAlias).append(".flocalamount flamount,");
        }
        return sql.toString();
    }

    private static String getIsCashAmountSQL(String tabAlias, CashflowQueryParam param) {
        StringBuffer sql = new StringBuffer();
        CurrencyInfo currency = param.getCurrency();
        if (currency != null && currency.getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            sql.append("case when oav.fisCash = 1 or oav.fisBank = 1 or oav.fisCashEquivalent = 1 then ").append(tabAlias).append(".flocalamount else 0 end fCashAmount,");
            sql.append("case when oav.fisCash = 0 and oav.fisBank = 0 and oav.fisCashEquivalent = 0 then ").append(tabAlias).append(".flocalamount else 0 end famount,");
            sql.append("'' framount,");
            sql.append("'' flamount,");
        } else if (currency != null && currency.getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sql.append("case when oav.fisCash = 1 or oav.fisBank = 1 or oav.fisCashEquivalent = 1 then ").append(tabAlias).append(".freportingamount else 0 end fCashAmount,");
            sql.append("case when oav.fisCash = 0 and oav.fisBank = 0 and oav.fisCashEquivalent = 0 then ").append(tabAlias).append(".freportingamount else 0 end famount,");
            sql.append("'' framount,");
            sql.append("'' flamount,");
        } else {
            sql.append("case when oav.fisCash = 1 or oav.fisBank = 1 or oav.fisCashEquivalent = 1 then ").append(tabAlias).append(".foriginalamount else 0 end fCashAmount,");
            sql.append("case when oav.fisCash = 0 and oav.fisBank = 0 and oav.fisCashEquivalent = 0 then ").append(tabAlias).append(".foriginalamount else 0 end famount,");
            sql.append(tabAlias).append(".freportingamount framount,");
            sql.append(tabAlias).append(".flocalamount flamount,");
        }
        return sql.toString();
    }

    private static String getVoucherFilterSQL(CashflowQueryParam param, List sp, String tabAlias, boolean notAllowModify) {
        StringBuffer sql = new StringBuffer();
        sql.append(tabAlias).append(".fvoucherid in ( \r\n");
        sql.append(" select v.fid from t_gl_voucher v \r\n");
        if (param.isPeriod()) {
            sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid \r\n");
        }
        if (!param.isCashFilt()) {
            sql.append(" inner join t_gl_voucherentry ve on v.fid = ve.fbillid   \r\n");
            sql.append(" inner join t_bd_accountview av on ve.faccountid = av.fid and av.fcompanyid = v.fcompanyid\t\r\n");
        }
        sql.append(" where v.fcompanyid=? \r\n");
        sp.add(param.getCompanyId());
        if (param.isPeriod()) {
            sql.append(" and pd.fnumber >= ? and pd.fnumber <= ? \r\n");
            sp.add(new Integer(param.getStartYear() * 100 + param.getStartPeriod()));
            sp.add(new Integer(param.getEndYear() * 100 + param.getEndPeriod()));
        } else {
            sql.append(" and v.fbookeddate >= ? and v.fbookeddate <= ? \r\n");
            sp.add(param.getStartDate());
            sp.add(param.getEndDate());
        }
        if (!param.isIndcludeNoPosted()) {
            sql.append(" and v.fbizstatus = ").append(5);
        } else {
            if (notAllowModify) {
                sql.append(" and v.fbizstatus < ").append(3);
            }
            sql.append(" and v.fbizstatus <> ").append(0).append(" and v.fbizstatus <> ").append(2);
        }
        if (!param.isCashFilt()) {
            sql.append(" and av.fnumber like ? \r\n");
            sp.add(param.getAccount().getNumber() + "%");
        }
        sql.append(") \r\n");
        return sql.toString();
    }

    private static String getParentFilterSQL(CashflowTAccountInfo parent, List sp, String tabAlias) {
        StringBuffer sql = new StringBuffer();
        if (parent != null) {
            if (parent.getAccount() != null) {
                sql.append(" and oav.fnumber like ? ");
                sp.add(parent.getAccount().getNumber() + "%");
            }
            if (parent.getHg() != null) {
                if (parent.getHg().getId() != null) {
                    sql.append(" and ").append(tabAlias).append(".fassgrpid = ? ");
                    sp.add(parent.getHg().getId().toString());
                } else if ("cf".equals(tabAlias)) {
                    sql.append(" and ").append(tabAlias).append(".fassgrpid is null ");
                }
            }
            if (parent.getOppHg() != null) {
                if (parent.getOppHg().getId() != null) {
                    sql.append(" and ").append(tabAlias).append(".foppassgrpid = ? ");
                    sp.add(parent.getOppHg().getId().toString());
                } else {
                    sql.append(" and ").append(tabAlias).append(".foppassgrpid is null ");
                }
            }
            if (parent.getCfItem() != null) {
                if (parent.getCfItem().getId() != null) {
                    sql.append(" and ").append(tabAlias).append(".fprimaryitemid = ? ");
                    sp.add(parent.getCfItem().getId().toString());
                } else if ("cf".equals(tabAlias)) {
                    sql.append(" and ").append(tabAlias).append(".fprimaryitemid is null ");
                }
            }
            sql.append(" and ").append(tabAlias).append(".fentrydc = ? ");
            sp.add(parent.isCredit() ? new Integer("0") : new Integer("1"));
        }
        return sql.toString();
    }

    protected static String applyDefCFItemToCFRecordSQL(Context ctx, CashflowQueryParam condition, ArrayList sp, String userId, boolean notAllowModify, String tmpTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_gl_cashflowrecord set (fprimaryitemid, fprimarycoeffient, fitemflag, ftype, fassgrpid, flastupdateuserid, flastupdatetime) = \t\r\n");
        sql.append("(select t.cfitemid,case when ((t.fentrydc = ").append(1).append(" and t.fdirection = ").append(2).append(") or (t.fentrydc = ").append(0).append(" and t.fdirection = ").append(1).append(")) then -1 else 1 end fprimarycoeffient, \r\n");
        sql.append(" case when t.fitemflag = ").append(3).append(" then ").append(3).append(" else ").append(1).append(" end itemflag, \r\n");
        sql.append(2).append(",null fassgrpid,'").append(userId).append("' userId, getDate() flastupdatetime ");
        sql.append(" from (select cfr.cfid,cfr.fitemflag,cfr.fentrydc,cfr.cfItemid,cfi.fdirection from (\t\t\t\t\t\t\t \r\n");
        sql.append(" select cf.fid cfid,cf.fitemflag,cf.fentrydc,  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \r\n");
        sql.append(" case when cf.foppentrydc = 1 then av.fborrowerMainCashFlowItemid else av.flenderMainCashFlowItemid end cfItemid \r\n");
        sql.append(" from t_gl_cashflowrecord cf\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \r\n");
        sql.append(" inner join t_bd_accountview av on av.fid = cf.foppaccountid) cfr \t\t\t\t\t\t\t\t\t\t\t\t \r\n");
        sql.append(" left outer join t_bd_cashflowitem cfi on cfi.fid = cfr.cfItemid ) t\t\t\t\t\t\t\t\t\t\t\t \r\n");
        sql.append(" where t.cfid = fid)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \r\n");
        sql.append(" where fid in (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \r\n");
        sql.append(" select cf.fid from " + tmpTableName + " cf ");
        sql.append(")");
        return sql.toString();
    }

    protected static String getCFSplitRecordIdTempTableSQL() throws Exception {
        return "create table T_GL_applyDefMainCashflowItem (fid varchar(44), fprimaryitemid varchar(44))";
    }

    protected static String insertSplitRecToTemptableSQL(CashflowQueryParam condition, ArrayList sp, String tmpTableName, boolean notAllowModify) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select cfs.fid, case when cfs.foppentrydc =1 then oav.fborrowerMainCashFlowItemid when cfs.foppentrydc =0 then oav.flenderMainCashFlowItemid else null end fprimaryitemid \r\n");
        sql.append(" from (").append(CashFlowTAccountSQLFactory.getCashflowSplitRecordSQL(condition, null, sp, notAllowModify));
        sql.append(") cfs \r\n");
        sql.append(" inner join t_bd_accountview oav on oav.fid = cfs.foppaccountid \r\n");
        sql.append(" where ((cfs.foppentrydc =1 and oav.fborrowerMainCashFlowItemid is not null) or (cfs.foppentrydc =0 and oav.flenderMainCashFlowItemid is not null))");
        return "insert into " + tmpTableName + sql.toString();
    }

    protected static String applyDefCFItemToCFSplitRecordSQL(CashflowQueryParam condition, boolean isCover, ArrayList sp, String tmpTableName, String userId, String cuId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into t_gl_cashflowrecord(fid, fcreatorid, fcreatetime,flastupdateuserid,flastupdatetime,fvoucherid,fentryid,faccountid,fcurrencyid,fentrydc,");
        sql.append(" fopposingaccountentryid,foppaccountid,foppentrydc,foppvoucherassistrecordid,foppassgrpid,foriginalamount,flocalamount,fitemflag,fprimarycoeffient,");
        sql.append(" fprimaryitemid,freportingamount,fcontrolunitid,fissupitem,ftype) \r\n");
        sql.append(" select newbosid('").append(new CashflowRecordInfo().getBOSType()).append("'), '").append(userId).append("' fcreatorid, getDate() fcreatetime, '").append(userId).append("' flastupdateuserid, getDate() flastupdatetime, ");
        sql.append(" cfs.fvoucherid,cfs.fentryid,cfs.faccountid,cfs.fcurrencyid,cfs.fentrydc,cfs.fopposingaccountentryid,cfs.foppaccountid,cfs.foppentrydc,");
        sql.append(" cfs.foppvoucherassistrecordid,cfs.foppassgrpid, cfs.foriginalamount, cfs.flocalamount,cfs.fitemflag,");
        sql.append(" case when ((cfs.fentrydc = ").append(1).append(" and cfi.fdirection = ").append(2).append(") or (cfs.fentrydc = ").append(0).append(" and cfi.fdirection = ").append(1).append(")) then -1 else 1 end fprimarycoeffient, ");
        sql.append(" t.fprimaryitemid,cfs.freportingamount,'").append(cuId).append("' fcontrolunitid,");
        sql.append(" cfs.fissupitem, ").append(2).append(" ftype ");
        sql.append(" from t_gl_cashflowsplitrecord cfs \r\n");
        sql.append(" inner join t_bd_accountview oav on oav.fid = cfs.foppaccountid \r\n");
        sql.append(" inner join ").append(tmpTableName).append(" t on t.fid = cfs.fid \r\n");
        sql.append(" inner join t_bd_cashflowitem cfi on cfi.fid = t.fprimaryitemid \r\n");
        return sql.toString();
    }

    protected static String updateCashflowRecordAssGrpSQL() {
        return "update t_gl_cashflowrecord set fassgrpid = ?, ftype = ?, flastupdateuserid = ?, flastupdatetime =? where fid = ? ";
    }

    protected static String deleteCashflowsplitrecordSQL(String tmpTableName) {
        return " delete from t_gl_cashflowsplitrecord where fid in ( select fid from " + tmpTableName + ")";
    }

    protected static String getAutoSetAsstCFRecordSQL(CashflowQueryParam condition, boolean isCover, ArrayList sp, boolean notAllowModify) {
        StringBuffer sql = new StringBuffer();
        sql.append("select cf.fid, cfi.fasstaccountid,cf.fassgrpid, hg.fcompanyorgid, hg.fcustomerid, cust.finternalcompanyid custCompanyId, hg.fid hgId, hg.fproviderid, supp.finternalcompanyid suppCompanyId, supp.fbizanalysiscodeid suppBizCode, cust.fbizanalysiscodeid custBizCode \r\n");
        sql.append(" from ( \r\n").append(CashFlowTAccountSQLFactory.getCashflowRecordSQL(condition, null, sp, notAllowModify)).append(" ) cf \r\n");
        sql.append(" inner join t_bd_cashflowitem cfi on cfi.fid = cf.fprimaryitemid \t\r\n");
        sql.append(" inner join t_bd_assistanthg hg on hg.fid = cf.foppassgrpid \t\t\r\n");
        sql.append(" left outer join t_bd_customer cust on cust.fid = hg.fcustomerid \t\r\n");
        sql.append(" left outer join t_bd_supplier supp on supp.fid = hg.fproviderid \t\r\n");
        sql.append(" where exists (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" select 1 from t_bd_AsstActGroupDetail det\t\t\t\t\t\t\t\r\n");
        sql.append(" inner join t_bd_asstacttype act on act.fid = det.fasstacttypeid\t\r\n");
        sql.append(" where (act.fassthgattribute = 'companyOrg' or act.fassthgattribute = 'customer' or act.fassthgattribute = 'provider')\t\r\n");
        sql.append(" and cfi.fasstaccountid = det.fasstaccountid\t\r\n");
        sql.append(" ) \r\n");
        sql.append(" and (hg.fcompanyorgid is not null or hg.fcustomerid is not null or hg.fproviderid is not null) \r\n");
        return sql.toString();
    }

    protected static String applyCFItemToCFRecSQL(CashflowQueryParam condition, CashflowTAccountInfo info, CashFlowItemInfo cfItem, String userId, List sp, boolean notAllowModify, String tmpTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_gl_cashflowrecord set (fprimaryitemid, fprimarycoeffient,fsupplementaryItemid,fsupplementarycoeffient, fitemflag, flastupdateuserid, flastupdatetime) = \r\n");
        int direction = cfItem.getDirection().getValue();
        sql.append(" (select '").append(cfItem.getId().toString()).append("' fprimaryitemid, case when ((t.fentrydc = ").append(1).append(" and ").append(direction).append(" = ").append(2).append(") or (t.fentrydc = ").append(0).append(" and ").append(direction).append(" = ").append(1).append(")) then -1 else 1 end fprimarycoeffient \r\n");
        sql.append(" ,null fsupplementaryItemid,0 fsupplementarycoeffient \r\n");
        sql.append(" , ").append(1).append(" itemflag, \r\n");
        sql.append(" '").append(userId).append("' flastupdateuserid, getDate() flastupdatetime ");
        sql.append(" from (\t\r\n");
        sql.append(" select cf.fid cfid, cf.fentrydc, cf.fitemflag \r\n");
        sql.append(" from t_gl_cashflowrecord cf) t \r\n");
        sql.append(" where t.cfid = fid)\t\r\n");
        sql.append(" where fid in (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \r\n");
        sql.append(" select cf.fid from " + tmpTableName + " cf ");
        sql.append(")");
        return sql.toString();
    }

    protected static String getCashflowRecordIDSQL(CashflowQueryParam condition, CashflowTAccountInfo info, List sp, boolean notAllowModify) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.fid from (").append(CashFlowTAccountSQLFactory.getCashflowRecordSQL(condition, info, sp, notAllowModify));
        sql.append(") t");
        return sql.toString();
    }

    protected static String insertCFRecToTemptableSQL(CashflowQueryParam condition, CashflowTAccountInfo info, List sp, boolean notAllowModify, String tmpTableName, boolean isDef) {
        CashflowTAccountInfo parent = info;
        CashflowQueryParam param = condition;
        StringBuffer sql = new StringBuffer();
        sql.append(" select cf.fid from (");
        sql.append(" select cf.fid, cf.foppaccountid,cf.foppentrydc\n");
        sql.append(" from t_gl_cashflowrecord cf \r\n");
        sql.append(" inner join t_bd_accountview oav on oav.fid = cf.foppaccountid \r\n");
        sql.append(" inner join t_bd_accountview sav on sav.fid = cf.faccountid \r\n");
        sql.append(" where ");
        sql.append(CashFlowTAccountSQLFactory.getVoucherFilterSQL(param, sp, "cf", notAllowModify));
        if (param.getCurrency() != null && !param.getCurrency().getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !param.getCurrency().getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sql.append(" and cf.fcurrencyid=? \r\n");
            sp.add(param.getCurrency().getId().toString());
        }
        sql.append(CashFlowTAccountSQLFactory.getParentFilterSQL(parent, sp, "cf"));
        sql.append(" and (sav.fisCash=1 or sav.fisBank=1 or sav.fisCashEquivalent=1) \r\n");
        if (parent != null) {
            if (parent.isCash()) {
                sql.append(" and (oav.fisCash=1 or oav.fisBank=1 or oav.fisCashEquivalent=1) \r\n");
            } else {
                sql.append(" and (oav.fisCash=0 and oav.fisBank=0 and oav.fisCashEquivalent=0) \r\n");
            }
            sql.append(" and cf.fentrydc = ? ");
            sp.add(new Integer(parent.isCredit() ? 0 : 1));
        }
        sql.append(" and oav.fcompanyid = ? and sav.fcompanyid = ? ");
        sql.append(") cf");
        sp.add(param.getCompanyId());
        sp.add(param.getCompanyId());
        if (isDef) {
            sql.append(" inner join t_bd_accountview oav\n");
            sql.append(" on oav.fid = cf.foppaccountid\n");
            sql.append(" where ((cf.foppentrydc = 1 and\n");
            sql.append(" oav.fborrowerMainCashFlowItemid is not null) or\n");
            sql.append(" (cf.foppentrydc = 0 and\n");
            sql.append(" oav.flenderMainCashFlowItemid is not null))");
        }
        return "insert into " + tmpTableName + sql.toString();
    }

    protected static String getCashflowSplitRecordIDSQL(CashflowQueryParam condition, CashflowTAccountInfo info, List sp, boolean notAllowModify) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.fid from (").append(CashFlowTAccountSQLFactory.getCashflowSplitRecordSQL(condition, info, sp, notAllowModify));
        sql.append(") t");
        return sql.toString();
    }

    protected static String getUnSplitVoucherSQL(CashflowQueryParam condition, List sp) {
        StringBuffer sql = new StringBuffer();
        sql.append("select v.fid from t_gl_voucher v \r\n");
        sql.append("inner join t_bd_period p on v.fperiodid=p.fid \r\n");
        sql.append("where v.fcompanyid=? \r\n");
        sp.add(condition.getCompanyId());
        if (condition.isPeriod()) {
            sql.append(" and p.fnumber >= ? and p.fnumber <= ? \r\n");
            sp.add(new Integer(condition.getStartYear() * 100 + condition.getStartPeriod()));
            sp.add(new Integer(condition.getEndYear() * 100 + condition.getEndPeriod()));
        } else {
            sql.append(" and v.fbookeddate >= ? and v.fbookeddate <= ? \r\n");
            sp.add(condition.getStartDate());
            sp.add(condition.getEndDate());
        }
        sql.append(" and v.fhascashaccount = 1 and v.fcashflowflag <> ").append(4);
        sql.append(" and v.fcashflowflag <> ").append(6);
        sql.append(" and v.fcashflowflag <> ").append(0).append(" \r\n");
        if (!condition.isIndcludeNoPosted()) {
            sql.append("  and v.fbizstatus = 5 ");
        } else {
            sql.append("  and v.fbizstatus <> 0  and v.fbizstatus <> 2 ");
        }
        return sql.toString();
    }

    protected static String updateVoucherCashFlagSQL() {
        return "update t_gl_voucher set fcashflowflag = 6 where fid in (%s)";
    }
}

