/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemViewFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowInitException;
import com.kingdee.eas.fi.gl.CashflowInitCollection;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.app.AbstractCashflowInitControllerBean;
import com.kingdee.eas.fi.gl.app.CashFlowUtils;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CashflowInitControllerBean
extends AbstractCashflowInitControllerBean {
    private static final long serialVersionUID = -7657483310386783844L;
    CompanyOrgUnitInfo curCompany = null;
    private static final String RESCLASSNAME = "com.kingdee.eas.fi.gl.app.CashFlowDispayResource";
    private static final String RECFLOW = "com.kingdee.eas.fi.gl.CashflowInitResource";
    private int lineIndex = 1;
    final Integer INTESUB1 = new Integer(11000000);
    final Integer INTESUB2 = new Integer(12000000);
    final Integer INTEPURGE1 = new Integer(11000000);
    final Integer INTEPURGE2 = new Integer(12000000);
    final Integer PRIMARYWORK = new Integer(30000000);
    final Integer SECONDARYWORK = new Integer(30000001);
    final Integer PRIMARYCASH = new Integer(40000000);
    final Integer SECONDARYCASH = new Integer(40000001);
    private String itemFilterSql = null;
    static final BigDecimal ZERO = new BigDecimal("0");

    @Override
    protected Map _findInitData(Context ctx, Map otherCtx) throws BOSException, EASBizException {
        CurrencyCollection curCol;
        HashMap<String, Object> map = new HashMap<String, Object>();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (company.getAccountPeriodType() == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2)));
        filter.setMaskString("#0 or #1");
        view.setFilter(filter);
        boolean isCurrency = AccountViewFactory.getLocalInstance((Context)ctx).exists(filter);
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        if (isCurrency) {
            curCol = curCtrl.getCurrencyCollection(false);
        } else {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)company.getBaseCurrency().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID));
            filter.setMaskString("#0 or #1");
            curCol = curCtrl.getCurrencyCollection(view);
        }
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        map.put("initParam", InitHelp.getInitParam(ctx, company));
        map.put("periods", this.getPeriods(ctx, company));
        map.put("AssistAccount", this.getAllAssistAccountBySql(ctx));
        map.put("allCurrency", curCol);
        return map;
    }

    protected Map getAllAssistAccountBySql(Context ctx) throws BOSException {
        AsstAccountCollection result = new AsstAccountCollection();
        HashMap<String, AsstAccountInfo> cache = new HashMap<String, AsstAccountInfo>();
        String loc = ctx.getLocale().getLanguage();
        try {
            String sql = "select \tasstAccount.fid as asstAccountId,asstAccount.fcount as asstcount,asstAccount.fnumber as asstAccountNumber,asstAccount.fname_" + loc + " as asstAccountName ,asstAccount.fisqty,asstAccount.fmeasureunitid ,asstAccount.fmeasureunitgroupid, asstActType.fid as asstActTypeId, \t\n asstActType.fname_" + loc + " as asstActTypeName ,asstActType.fnumber asstActTypeNumber,asstActType.fdefaultf7ui,asstActType.fasstHGAttribute,asstActType.fdefaultQueryName,\n asstActType.fisForCompany,asstActType.fIsMultilevel,asstActType.fglAsstActTypeGrpid,asstActType.frealtionDataObject,asstActType.fmappingFieldName,m.fname_" + loc + " as fmeasureunitname,m.fcoefficient,asstActType.FUseLongNumber \n from t_bd_asstactgroupdetail a\t \n inner join t_bd_asstaccount asstAccount on a.fasstaccountid = asstAccount.fid\t\n inner join t_bd_asstacttype asstActType on a.fasstActTypeid = asstActType.fid\t\n left join t_bd_measureunit m on asstAccount.fmeasureunitid=m.fid \n";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (set != null) {
                while (set.next()) {
                    String asstid = set.getString("asstAccountId");
                    AsstAccountInfo temp = null;
                    if (cache.containsKey(asstid)) {
                        temp = (AsstAccountInfo)cache.get(asstid);
                    } else {
                        temp = new AsstAccountInfo();
                        temp.setId(BOSUuid.read((String)asstid));
                        temp.setNumber(set.getString("asstAccountNumber"));
                        temp.setCount(set.getInt("asstcount"));
                        temp.setName(set.getString("asstAccountName"));
                        temp.put("asstTypeCol", (Object)new AsstActTypeCollection());
                        temp.setIsQty(set.getBoolean("fisqty"));
                        if (set.getString("fmeasureunitid") != null) {
                            MeasureUnitInfo unit = new MeasureUnitInfo();
                            unit.setId(BOSUuid.read((String)set.getString("fmeasureunitid")));
                            unit.setName(set.getString("fmeasureunitname"));
                            unit.setCoefficient(set.getBigDecimal("fcoefficient"));
                            temp.setMeasureUnit(unit);
                        }
                        if (set.getString("fmeasureunitgroupid") != null) {
                            MeasureUnitGroupInfo unitGroup = new MeasureUnitGroupInfo();
                            unitGroup.setId(BOSUuid.read((String)set.getString("fmeasureunitgroupid")));
                            temp.setMeasureUnitGroup(unitGroup);
                        }
                        result.add(temp);
                        cache.put(asstid, temp);
                    }
                    AsstActTypeInfo type = new AsstActTypeInfo();
                    type.setId(BOSUuid.read((String)set.getString("asstActTypeId")));
                    type.setNumber(set.getString("asstActTypeNumber"));
                    type.setName(set.getString("asstActTypeName"));
                    type.setAsstHGAttribute(set.getString("fasstHGAttribute"));
                    type.setMappingFieldName(set.getString("fmappingFieldName"));
                    type.setDefaultQueryName(set.getString("fdefaultQueryName"));
                    type.setRealtionDataObject(set.getString("frealtionDataObject"));
                    type.setDefaultF7UI(set.getString("fdefaultf7ui"));
                    type.setIsForCompany(set.getBoolean("fisForCompany"));
                    type.setUseLongNumber(set.getBoolean("FUseLongNumber"));
                    type.setIsMultilevel(set.getBoolean("fIsMultilevel"));
                    String fglAsstActTypeGrpid = set.getString("fglAsstActTypeGrpid");
                    if (fglAsstActTypeGrpid != null) {
                        GeneralAsstActTypeGroupInfo info = new GeneralAsstActTypeGroupInfo();
                        info.setId(BOSUuid.read((String)fglAsstActTypeGrpid));
                        type.setGlAsstActTypeGrp(info);
                    }
                    ((AsstActTypeCollection)temp.get("asstTypeCol")).add(type);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return cache;
    }

    private PeriodInfo[] getPeriods(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return InitHelp.getPeriods(ctx, company);
    }

    @Override
    protected ArrayList _getCashflowInitValue(Context ctx, IObjectValue curInfo) throws BOSException, EASBizException {
        this.curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        this.itemFilterSql = CashFlowItemViewFactory.getLocalInstance((Context)ctx).getCashFlowItemViewSql(cu.getId().toString());
        CurrencyInfo curinfo = (CurrencyInfo)curInfo;
        CurrencyCollection currencyCollection = new CurrencyCollection();
        currencyCollection.add(curinfo);
        Map balance = this.getCashBalance(ctx, currencyCollection);
        List ltItem = this.selectDataFromDB(ctx, curInfo, 0);
        if (!ltItem.isEmpty()) {
            ltItem = this.formatAddSpace(ctx, ltItem, curInfo, (QueryData[])balance.get(curinfo.getId()));
        }
        ltItem.addAll(this.formatSeconary(ctx, this.selectDataFromDB(ctx, curInfo, 1), curInfo));
        ltItem.addAll(this.selectDataFromDB(ctx, curInfo, 2));
        if (!ltItem.isEmpty()) {
            this.addCashSum(ctx, ltItem, curInfo, (QueryData[])balance.get(curinfo.getId()));
            ltItem = this.formatSeq(ctx, ltItem);
        }
        return (ArrayList)ltItem;
    }

    private List addCashSum(Context ctx, List ltItem, IObjectValue curInfo, QueryData[] balance) throws BOSException, EASBizException {
        Object[] tempObject = (Object[])ltItem.get(0);
        Object[] array1 = (Object[])tempObject.clone();
        array1[2] = ResourceBase.getString((String)RESCLASSNAME, (String)"strAdd", (Locale)ctx.getLocale());
        array1[11] = this.INTEPURGE1;
        array1[12] = this.INTEPURGE2;
        array1[16] = null;
        array1[17] = null;
        array1[18] = null;
        ltItem.add(array1);
        Object[] array2 = (Object[])tempObject.clone();
        array2[2] = this.getBlankString(2) + ResourceBase.getString((String)RESCLASSNAME, (String)"strCashEnd", (Locale)ctx.getLocale());
        array2[1] = new Integer(this.lineIndex++);
        array2[16] = balance[1].getOriginalAmount();
        array2[17] = balance[1].getLocalAmount();
        array2[18] = balance[1].getReportingAmount();
        array2[11] = this.INTEPURGE1;
        array2[12] = this.INTEPURGE2;
        ltItem.add(array2);
        Object[] array3 = (Object[])tempObject.clone();
        array3[2] = this.getBlankString(2) + ResourceBase.getString((String)RESCLASSNAME, (String)"strJCahsBegin", (Locale)ctx.getLocale());
        array3[1] = new Integer(this.lineIndex++);
        array3[16] = balance[0].getOriginalAmount();
        array3[17] = balance[0].getLocalAmount();
        array3[18] = balance[0].getReportingAmount();
        array3[11] = this.INTEPURGE1;
        array3[12] = this.INTEPURGE2;
        ltItem.add(array3);
        Object[] array4 = (Object[])tempObject.clone();
        array4[0] = "";
        array4[2] = this.getBlankString(2) + ResourceBase.getString((String)RESCLASSNAME, (String)"strAddSjdjwEnd", (Locale)ctx.getLocale());
        array4[1] = new Integer(this.lineIndex++);
        array4[16] = balance[3].getOriginalAmount();
        array4[17] = balance[3].getLocalAmount();
        array4[18] = balance[3].getReportingAmount();
        array4[11] = this.INTEPURGE1;
        array4[12] = this.INTEPURGE2;
        ltItem.add(array4);
        Object[] array5 = (Object[])tempObject.clone();
        array5[2] = this.getBlankString(2) + ResourceBase.getString((String)RESCLASSNAME, (String)"strJSjdjwEnd", (Locale)ctx.getLocale());
        array5[1] = new Integer(this.lineIndex++);
        array5[16] = balance[2].getOriginalAmount();
        array5[17] = balance[2].getLocalAmount();
        array5[18] = balance[2].getReportingAmount();
        array5[11] = this.INTEPURGE1;
        array5[12] = this.INTEPURGE2;
        ltItem.add(array5);
        Object[] array6 = (Object[])tempObject.clone();
        array6[2] = this.getBlankString(2) + ResourceBase.getString((String)RESCLASSNAME, (String)"strCashAndXjdjw", (Locale)ctx.getLocale());
        array6[1] = new Integer(this.lineIndex++);
        array6[16] = balance[1].getOriginalAmount().subtract(balance[0].getOriginalAmount()).add(balance[3].getOriginalAmount()).subtract(balance[2].getOriginalAmount());
        array6[17] = balance[1].getLocalAmount().subtract(balance[0].getLocalAmount()).add(balance[3].getLocalAmount()).subtract(balance[2].getLocalAmount());
        array6[18] = balance[1].getReportingAmount().subtract(balance[0].getReportingAmount()).add(balance[3].getReportingAmount()).subtract(balance[2].getReportingAmount());
        array6[11] = this.INTEPURGE1;
        array6[12] = this.INTEPURGE2;
        array6[20] = this.SECONDARYCASH;
        ltItem.add(array6);
        return ltItem;
    }

    private List selectDataFromDB(Context ctx, IObjectValue curInfo, int itemType) throws BOSException, EASBizException {
        ArrayList<Object[]> ltItem = new ArrayList<Object[]>();
        CurrencyInfo curinfo = (CurrencyInfo)curInfo;
        String generalLocal = null;
        String generalReport = null;
        StringBuffer sbSql = new StringBuffer();
        generalLocal = this.getGeneralLocalCurrency();
        generalReport = this.getGeneralReportCurrency();
        StringBuffer sbFName = new StringBuffer(" cfi.FName_");
        String strLocal = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sbFName.append(strLocal);
        sbSql.append(" SELECT cfi.FId FidItem,  cfi.FLongNumber \t\t\tFLongNumber, \r\n");
        sbSql.append(sbFName);
        sbSql.append(" \t\t\t\t\t\tFName,  cfi.FType \t\t\t\tFType,  cfi.FIsFreeze \t\t\tFIsFreeze,  cfi.FIsDealActivity \t\tFIsDealActivity,  cfi.FDirection \t\t\tFDirection,  cfi.FIsProfit \t\t\tFIsProfit,  cfi.FIsEnable \t\t\tFIsEnable, cfi.FIsExChange \t\t\tFIsExChange,  cfi.FAsstAccountID\t\tFAsstAccountID,  cfi.FIsLeaf \t\t\t\tFIsLeaf,  cfi.FLevel \t\t\t\tFLevel, \r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" cfit.Fid\t\t\tFidInit, \r\n");
        }
        sbSql.append(" cfit.FSeq \t\t\tFSeq, \r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" cfit.FCurrencyID FCurrencyID, \r\n");
        }
        sbSql.append(" cfit.FOriginalAmount FOriginalAmount,  cfit.FLocalAmount \t\tFLocalAmount,  cfit.FReportingAmount \tFReportingAmount, cfit.FCompanyID \t\t\tFCompanyID \r\n");
        sbSql.append(" FROM T_BD_CashFlowItem cfi \t\t\t\r\n");
        sbSql.append(" LEFT OUTER JOIN (\t\t\t\t\t\r\n");
        sbSql.append(" SELECT FCashflowItemID, \t\t\t\t\r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" Fid,\t\t\t\t\t\t\t\t\r\n");
        }
        sbSql.append(" FSeq,\t\t\t\t\t\t\t\t\r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" FCurrencyID,\t FOriginalAmount, FLocalAmount, FReportingAmount,\t\t\t\t\t\t\r\n");
        } else {
            sbSql.append(" SUM(FOriginalAmount) FOriginalAmount,  SUM(FLocalAmount) FLocalAmount, SUM(FReportingAmount) FReportingAmount, \r\n");
        }
        sbSql.append(" FCompanyID \t\t\t\t\t\t\t\r\n");
        sbSql.append(" FROM T_GL_CashflowInit \t\t\t\t\r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" WHERE FCurrencyID = ? AND FCompanyID = ? ) cfit \r\n");
        } else {
            sbSql.append(" WHERE FCompanyID = ?  GROUP BY FCashflowItemID,  FSeq, FCompanyID\t) cfit \t\t\t\t\t\r\n");
        }
        sbSql.append(" ON cfi.fid = cfit.FCashflowItemID \t\r\n");
        sbSql.append(" WHERE cfi.FType = ");
        sbSql.append(itemType);
        if (this.itemFilterSql != null) {
            sbSql.append(" and cfi.fid in ( ").append(this.itemFilterSql).append(" ) ");
        }
        sbSql.append(" ORDER BY cfi.FType, cfi.FLongNumber  \r\n");
        Object[] obj = null;
        int iComma = 0;
        int n = sbSql.toString().length();
        for (int i = 0; i < n; ++i) {
            if (sbSql.toString().charAt(i) != ',') continue;
            ++iComma;
        }
        Object[] params = null;
        params = !curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport) ? new Object[]{curinfo.getId().toString(), this.curCompany.getId().toString()} : new Object[]{this.curCompany.getId().toString()};
        Map parentNodeData = new HashMap();
        parentNodeData = this.getParentNodeData(ctx, curInfo, itemType);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            while (rs.next()) {
                Object[] parentData;
                obj = new Object[iComma + 1];
                obj[0] = rs.getString("FidItem");
                obj[1] = rs.getString("FLongNumber");
                if (itemType == 2) {
                    int level = rs.getInt("FLevel") + 1;
                    StringBuffer sbBlank = new StringBuffer();
                    for (int i = 1; i < level; ++i) {
                        sbBlank.append("    ");
                    }
                    obj[2] = sbBlank.toString() + rs.getString("FName");
                } else {
                    obj[2] = rs.getString("FName");
                }
                obj[3] = rs.getString("FType");
                obj[4] = rs.getString("FIsFreeze");
                obj[5] = rs.getString("FIsDealActivity");
                obj[6] = new Integer(rs.getInt("FDirection"));
                obj[7] = new Integer(rs.getInt("FIsProfit"));
                obj[8] = new Integer(rs.getInt("FIsEnable"));
                obj[9] = new Integer(rs.getInt("FIsExChange"));
                obj[10] = rs.getString("FAsstAccountID");
                obj[11] = new Integer(rs.getInt("FisLeaf"));
                obj[12] = new Integer(rs.getInt("FLevel"));
                if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
                    obj[13] = rs.getString("FidInit");
                }
                obj[14] = new Integer(rs.getInt("FSeq"));
                if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
                    obj[15] = rs.getString("FCurrencyID");
                }
                if (rs.getInt("FLevel") != 1 || rs.getInt("FisLeaf") == 1) {
                    obj[16] = rs.getBigDecimal("FOriginalAmount");
                    obj[17] = rs.getBigDecimal("FLocalAmount");
                    obj[18] = rs.getBigDecimal("FReportingAmount");
                    obj[19] = rs.getString("FCompanyID");
                }
                if (rs.getString("FidItem") != null && rs.getString("FidItem").length() > 0 && (parentData = (Object[])parentNodeData.get(rs.getString("FidItem"))) != null && parentData.length > 0) {
                    obj[16] = parentData[2];
                    obj[17] = parentData[3];
                    obj[18] = parentData[4];
                }
                ltItem.add(obj);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ltItem;
    }

    private Map getParentNodeData(Context ctx, IObjectValue curInfo, int itemType) throws BOSException, EASBizException {
        HashMap<String, Object[]> parentNodeData = new HashMap<String, Object[]>();
        CurrencyInfo curinfo = (CurrencyInfo)curInfo;
        String generalLocal = null;
        String generalReport = null;
        StringBuffer sbSql = new StringBuffer();
        generalLocal = this.getGeneralLocalCurrency();
        generalReport = this.getGeneralReportCurrency();
        StringBuffer sbFName = new StringBuffer(" cfi.FName_");
        String strLocal = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sbFName.append(strLocal);
        sbSql.append(" SELECT cfi.FId FidItem,  cfi.FLongNumber \t\t\tFLongNumber, \r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" sum(cfit.FOriginalAmount *(case cfi.FDirection when 2 then -1 else 1 end) * (case cfit.FDirection when 2 then -1 else 1 end)) FOriginalAmount, \r\n");
            sbSql.append(" sum(cfit.FLocalAmount *(case cfi.FDirection when 2 then -1 else 1 end) * (case cfit.FDirection when 2 then -1 else 1 end)) FLocalAmount, \r\n");
            sbSql.append(" sum(cfit.FReportingAmount*(case cfi.FDirection when 2 then -1 else 1 end) * (case cfit.FDirection when 2 then -1 else 1 end)) FReportingAmount, \r\n");
            sbSql.append(" cfit.FCompanyID \tFCompanyID \r\n");
        } else {
            sbSql.append(" sum(cfit.FOriginalAmount) FOriginalAmount,  sum(cfit.FLocalAmount) \t\tFLocalAmount,  sum(cfit.FReportingAmount) \tFReportingAmount,  cfit.FCompanyID \t\t\tFCompanyID \r\n");
        }
        sbSql.append(" FROM T_BD_CashFlowItem cfi \t\t\t\r\n");
        sbSql.append(" inner join T_BD_CashFlowItem cfi0 \t\t\t\r\n");
        sbSql.append(" on (charindex(cfi.FLongNumber || '!', cfi0.FLongNumber) = 1)\t\r\n");
        sbSql.append(" LEFT OUTER JOIN (\t\t\t\t\t\r\n");
        sbSql.append(" SELECT init.FCashflowItemID, \t\t\t\t\r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" init.Fid,\t\t\t\t\t\t\t\t\r\n");
        }
        sbSql.append(" init.FSeq,\t\t\t\t\t\t\t\t\r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" init.FCurrencyID,\t init.FOriginalAmount, init.FLocalAmount, init.FReportingAmount,cf.FDirection,  \r\n");
        } else {
            sbSql.append(" SUM(init.FOriginalAmount) FOriginalAmount,  SUM(init.FLocalAmount) FLocalAmount, SUM(init.FReportingAmount) FReportingAmount, \r\n");
        }
        sbSql.append(" init.FCompanyID \t\t \r\n");
        sbSql.append(" FROM T_GL_CashflowInit \tinit\t\t\r\n");
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" INNER JOIN T_BD_CashFlowItem cf on  init.FCashflowItemID = cf.fid  \r\n");
        }
        if (!curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport)) {
            sbSql.append(" WHERE init.FCurrencyID = ? AND init.FCompanyID = ?  ) cfit \r\n");
        } else {
            sbSql.append(" WHERE FCompanyID = ?  GROUP BY FCashflowItemID,  FSeq, FCompanyID\t) cfit \t\t\t\t\t\r\n");
        }
        sbSql.append(" ON cfi0.fid = cfit.FCashflowItemID \t\r\n");
        sbSql.append(" WHERE cfi.FType = ");
        sbSql.append(itemType);
        sbSql.append(" \r\n  and cfi0.Fisleaf =1 ");
        sbSql.append(" \r\n  and cfi.FLevel <>1 ");
        sbSql.append(" \r\n  GROUP BY cfi.FId,cfi.FLongNumber,cfit.FCompanyID \r\n");
        sbSql.append(" ORDER BY cfi.FLongNumber  \r\n");
        Object[] obj = null;
        int iComma = 0;
        int n = sbSql.toString().length();
        for (int i = 0; i < n; ++i) {
            if (sbSql.toString().charAt(i) != ',') continue;
            ++iComma;
        }
        Object[] params = null;
        params = !curinfo.getId().toString().equals(generalLocal) && !curinfo.getId().toString().equals(generalReport) ? new Object[]{curinfo.getId().toString(), this.curCompany.getId().toString()} : new Object[]{this.curCompany.getId().toString()};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            while (rs.next()) {
                obj = new Object[iComma + 1];
                obj[0] = rs.getString("FidItem");
                obj[1] = rs.getString("FLongNumber");
                obj[2] = rs.getBigDecimal("FOriginalAmount");
                obj[3] = rs.getBigDecimal("FLocalAmount");
                obj[4] = rs.getBigDecimal("FReportingAmount");
                obj[5] = rs.getString("FCompanyID");
                parentNodeData.put(rs.getString("FidItem"), obj);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return parentNodeData;
    }

    private List formatAddSpace(Context ctx, List ltItem, IObjectValue curInfo, QueryData[] balance) throws EASBizException, BOSException {
        ArrayList<Object[]> ltItemReturn = new ArrayList<Object[]>();
        CashFlowItemCollection col = CashFlowItemFactory.getLocalInstance((Context)ctx).getCashFlowItemCollection("select level order by level desc");
        int maxLevel = col.get(0).getLevel();
        BigDecimal bdSubtotalOriginal = ZERO;
        BigDecimal bdSubtotalLocal = ZERO;
        BigDecimal bdSubtotalReporting = ZERO;
        BigDecimal bdInSumOriginal = ZERO;
        BigDecimal bdInSumLocal = ZERO;
        BigDecimal bdInSumReporting = ZERO;
        BigDecimal bdOutSumOriginal = ZERO;
        BigDecimal bdOutSumLocal = ZERO;
        BigDecimal bdOutSumReporting = ZERO;
        BigDecimal bdCashSumOriginal = ZERO;
        BigDecimal bdCashSumLocal = ZERO;
        BigDecimal bdCashSumReporting = ZERO;
        BigDecimal cashSumOriginal = ZERO;
        BigDecimal cashSumLocal = ZERO;
        BigDecimal cashSumReport = ZERO;
        int iLevel = 1;
        Object[] objItem = null;
        Object[] objData = null;
        String cflowItemName = null;
        int thisDirection = 0;
        int thisIsLeaf = 0;
        int thisLevel = 0;
        String purge = null;
        Object objCashflowItemID = null;
        int n = ltItem.size();
        for (int i = 0; i < n; ++i) {
            objItem = (Object[])ltItem.get(i);
            objData = (Object[])objItem.clone();
            cflowItemName = objItem[2] != null ? objItem[2].toString() : "";
            thisDirection = (Integer)objItem[6];
            thisIsLeaf = (Integer)objItem[11];
            thisLevel = (Integer)objItem[12];
            BigDecimal bdOriginal = objItem[16] == null ? ZERO : (BigDecimal)objItem[16];
            BigDecimal bdLocal = objItem[17] == null ? ZERO : (BigDecimal)objItem[17];
            BigDecimal bdReporting = objItem[18] == null ? ZERO : (BigDecimal)objItem[18];
            ltItemReturn.add(objData);
            if (thisLevel == 1) {
                objData[2] = ResourceBase.getString((String)RECFLOW, (String)String.valueOf(iLevel++), (Locale)ctx.getLocale()) + this.getBlankString(thisLevel) + cflowItemName;
                purge = cflowItemName;
            } else {
                objData[2] = this.getBlankString(thisLevel) + cflowItemName;
            }
            if (thisIsLeaf == 0 && thisLevel == 1) {
                objCashflowItemID = objData[0];
            }
            if (thisDirection != 0) {
                if (thisIsLeaf == 1 || maxLevel == 1 && thisLevel == 2 || maxLevel > 1 && thisLevel == maxLevel) {
                    bdSubtotalOriginal = bdSubtotalOriginal.add(bdOriginal);
                    bdSubtotalLocal = bdSubtotalLocal.add(bdLocal);
                    bdSubtotalReporting = bdSubtotalReporting.add(bdReporting);
                }
                if (i + 1 == ltItem.size() || (Integer)((Object[])ltItem.get(i + 1))[6] != thisDirection) {
                    Object[] objSubtotal = (Object[])objItem.clone();
                    objSubtotal[2] = thisDirection == 1 ? this.getBlankString(thisLevel) + this.getResource(ctx, "strInTotal") : this.getBlankString(thisLevel) + this.getResource(ctx, "strOutTotal");
                    objSubtotal[0] = objCashflowItemID;
                    objSubtotal[11] = this.INTESUB1;
                    objSubtotal[12] = this.INTESUB2;
                    objSubtotal[16] = bdSubtotalOriginal;
                    objSubtotal[17] = bdSubtotalLocal;
                    objSubtotal[18] = bdSubtotalReporting;
                    if (maxLevel != 1) {
                        ltItemReturn.add(objSubtotal);
                    }
                    bdSubtotalOriginal = ZERO;
                    bdSubtotalLocal = ZERO;
                    bdSubtotalReporting = ZERO;
                }
            }
            if (thisLevel == 2 && thisIsLeaf == 1 || thisIsLeaf == 1 || maxLevel == 1 && thisLevel == 2 || maxLevel > 1 && thisLevel == maxLevel) {
                if (thisDirection == 1) {
                    bdInSumOriginal = bdInSumOriginal.add(bdOriginal);
                    bdInSumLocal = bdInSumLocal.add(bdLocal);
                    bdInSumReporting = bdInSumReporting.add(bdReporting);
                } else if (thisDirection == 2) {
                    bdOutSumOriginal = bdOutSumOriginal.add(bdOriginal);
                    bdOutSumLocal = bdOutSumLocal.add(bdLocal);
                    bdOutSumReporting = bdOutSumReporting.add(bdReporting);
                }
            }
            if (i + 1 != ltItem.size() && (Integer)((Object[])ltItem.get(i + 1))[12] != 1) continue;
            Object[] objPurge = (Object[])objItem.clone();
            objPurge[0] = objCashflowItemID;
            objPurge[2] = this.getBlankString(thisLevel) + this.getSumString(ctx, purge);
            objPurge[11] = this.INTEPURGE1;
            objPurge[12] = this.INTEPURGE2;
            bdCashSumOriginal = bdCashSumOriginal.add(bdInSumOriginal.subtract(bdOutSumOriginal));
            objPurge[16] = bdCashSumOriginal;
            bdCashSumLocal = bdCashSumLocal.add(bdInSumLocal.subtract(bdOutSumLocal));
            objPurge[17] = bdCashSumLocal;
            bdCashSumReporting = bdCashSumReporting.add(bdInSumReporting.subtract(bdOutSumReporting));
            objPurge[18] = bdCashSumReporting;
            if (objPurge[5].toString().equals("1")) {
                objPurge[20] = this.PRIMARYWORK;
            }
            cashSumOriginal = cashSumOriginal.add(bdCashSumOriginal);
            cashSumLocal = cashSumLocal.add(bdCashSumLocal);
            cashSumReport = cashSumReport.add(bdCashSumReporting);
            bdInSumOriginal = ZERO;
            bdInSumLocal = ZERO;
            bdInSumReporting = ZERO;
            bdOutSumOriginal = ZERO;
            bdOutSumLocal = ZERO;
            bdOutSumReporting = ZERO;
            bdCashSumOriginal = ZERO;
            bdCashSumLocal = ZERO;
            bdCashSumReporting = ZERO;
            ltItemReturn.add(objPurge);
        }
        Object[] objCashSum = (Object[])((Object[])ltItem.get(0)).clone();
        objCashSum[2] = this.getResource(ctx, String.valueOf(iLevel++)) + ResourceBase.getString((String)RESCLASSNAME, (String)"strCashSum", (Locale)ctx.getLocale());
        objCashSum[1] = new Integer(this.lineIndex++);
        objCashSum[16] = cashSumOriginal;
        objCashSum[17] = cashSumLocal;
        objCashSum[18] = cashSumReport;
        objCashSum[4] = Boolean.TRUE;
        objCashSum[11] = this.INTEPURGE1;
        objCashSum[12] = this.INTEPURGE2;
        objCashSum[20] = this.PRIMARYCASH;
        ltItemReturn.add(objCashSum);
        if (objItem != null) {
            objCashSum = (Object[])objItem.clone();
            objCashSum[0] = "";
            objCashSum[2] = this.getBlankString(2) + ResourceBase.getString((String)RESCLASSNAME, (String)"strAddCashAndXjdjwBegin", (Locale)ctx.getLocale());
            objCashSum[1] = new Integer(this.lineIndex++);
            objCashSum[16] = balance[0].getOriginalAmount().add(balance[2].getOriginalAmount());
            objCashSum[17] = balance[0].getLocalAmount().add(balance[2].getLocalAmount());
            objCashSum[18] = balance[0].getReportingAmount().add(balance[2].getReportingAmount());
            objCashSum[4] = Boolean.FALSE;
            objCashSum[11] = this.INTEPURGE1;
            objCashSum[12] = this.INTEPURGE2;
            ltItemReturn.add(objCashSum);
            objCashSum = (Object[])objItem.clone();
            objCashSum[0] = "";
            objCashSum[2] = this.getResource(ctx, String.valueOf(iLevel++)) + ResourceBase.getString((String)RESCLASSNAME, (String)"strCashAndXjdjwEndBanlance", (Locale)ctx.getLocale());
            objCashSum[1] = new Integer(this.lineIndex++);
            objCashSum[16] = balance[1].getOriginalAmount().add(balance[3].getOriginalAmount());
            objCashSum[17] = balance[1].getLocalAmount().add(balance[3].getLocalAmount());
            objCashSum[18] = balance[1].getReportingAmount().add(balance[3].getReportingAmount());
            objCashSum[4] = Boolean.TRUE;
            objCashSum[11] = this.INTEPURGE1;
            objCashSum[12] = this.INTEPURGE2;
            ltItemReturn.add(objCashSum);
        }
        return ltItemReturn;
    }

    private List formatSeconary(Context ctx, List ltItem, IObjectValue curInfo) throws EASBizException, BOSException {
        if (ltItem == null || ltItem.isEmpty()) {
            return new ArrayList();
        }
        CurrencyInfo curinfo = (CurrencyInfo)curInfo;
        CurrencyCollection currencyCollection = new CurrencyCollection();
        currencyCollection.add(curinfo);
        Map profit = this.getRetainedProfits(ctx, currencyCollection);
        QueryData profitData = (QueryData)profit.get(curinfo.getId());
        BigDecimal bdTotal = ZERO;
        BigDecimal bdTotalLocal = ZERO;
        BigDecimal bdTotalRpt = ZERO;
        Object[] arrayObj = null;
        int sizeVec = ltItem.size();
        for (int i = 0; i < sizeVec; ++i) {
            arrayObj = (Object[])ltItem.get(i);
            int thisLevel = Integer.parseInt(arrayObj[12].toString());
            if (thisLevel <= 2) {
                arrayObj[2] = this.getBlankString(thisLevel + 1) + arrayObj[2];
                continue;
            }
            arrayObj[2] = this.getBlankString(thisLevel + 1) + arrayObj[2];
            arrayObj[1] = new Integer(this.lineIndex++);
            if (Integer.parseInt(arrayObj[7].toString()) == 1) {
                arrayObj[16] = profitData.getOriginalAmount();
                arrayObj[17] = profitData.getLocalAmount();
                arrayObj[18] = profitData.getReportingAmount();
                arrayObj[11] = this.INTEPURGE1;
                arrayObj[12] = this.INTEPURGE2;
                continue;
            }
            if (arrayObj[16] != null && 1 == (Integer)arrayObj[11]) {
                bdTotal = bdTotal.add((BigDecimal)arrayObj[16]);
            }
            if (arrayObj[17] != null && 1 == (Integer)arrayObj[11]) {
                bdTotalLocal = bdTotalLocal.add((BigDecimal)arrayObj[17]);
            }
            if (arrayObj[18] == null || 1 != (Integer)arrayObj[11]) continue;
            bdTotalRpt = bdTotalRpt.add((BigDecimal)arrayObj[18]);
        }
        if (arrayObj != null) {
            Object[] array5 = (Object[])arrayObj.clone();
            array5[2] = this.getBlankString(2) + ResourceBase.getString((String)RESCLASSNAME, (String)"strWork", (Locale)ctx.getLocale());
            array5[1] = new Integer(this.lineIndex++);
            array5[16] = profitData.getOriginalAmount().add(bdTotal);
            array5[17] = profitData.getLocalAmount().add(bdTotalLocal);
            array5[18] = profitData.getReportingAmount().add(bdTotalRpt);
            array5[4] = Boolean.TRUE;
            array5[11] = this.INTEPURGE1;
            array5[12] = this.INTEPURGE2;
            array5[20] = this.SECONDARYWORK;
            ltItem.add(array5);
        }
        return ltItem;
    }

    private Map getRetainedProfits(Context ctx, CurrencyCollection currencyCollection) throws BOSException, EASBizException {
        StringBuffer sbCurrencyIds = new StringBuffer();
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            sbCurrencyIds.append("'").append(currency.getId().toString()).append("',");
        }
        String diffAccountSet = CashFlowUtils.getDiff(ctx);
        sbCurrencyIds.deleteCharAt(sbCurrencyIds.length() - 1);
        StringBuffer sbSql = new StringBuffer("Select balance.FCurrencyID,");
        sbSql.append(" sum(case account.FDC when -1 then FYearPnLFor else (-1)*FYearPnLFor end) FAmount ,");
        sbSql.append(" sum(case account.FDC when -1 then FYearPnLLocal else (-1)*FYearPnLLocal end) FAmountLocal ,");
        sbSql.append(" sum(case account.FDC when -1 then FYearPnLRpt else (-1)*FYearPnLRpt end) FAmountRpt ");
        sbSql.append(" from T_GL_InitAccountBalance balance join T_BD_AccountView account");
        sbSql.append(" on balance.FAccountID = account.FID ");
        sbSql.append(" where account.FIsLeaf = 1 and account.FPLType>0");
        sbSql.append(" and balance.FOrgUnitId = ?");
        sbSql.append(" and balance.FCurrencyID in (").append(sbCurrencyIds).append(")");
        if (diffAccountSet != null && diffAccountSet.length() > 0) {
            sbSql.append(" and account.FID not in (" + diffAccountSet + ")");
        }
        sbSql.append(" group by  balance.FCurrencyID");
        Object[] params = new Object[]{this.curCompany.getId().toString()};
        HashMap<BOSUuid, QueryData> result = new HashMap<BOSUuid, QueryData>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            while (rs.next()) {
                QueryData data = new QueryData();
                data.setCurrency(currencyCollection.get((Object)BOSUuid.read((String)rs.getString("fcurrencyid"))));
                data.setOriginalAmount(rs.getBigDecimal("FAmount") == null ? ZERO : rs.getBigDecimal("FAmount"));
                data.setLocalAmount(rs.getBigDecimal("FAmountLocal") == null ? ZERO : rs.getBigDecimal("FAmountLocal"));
                data.setReportingAmount(rs.getBigDecimal("FAmountRpt") == null ? ZERO : rs.getBigDecimal("FAmountRpt"));
                result.put(data.getCurrency().getId(), data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.checkQueryResult(currencyCollection, result);
        return result;
    }

    private Map getCashBalance(Context ctx, CurrencyCollection currencyCollection) throws BOSException, EASBizException {
        PeriodInfo[] periods = this.getPeriods(ctx, this.curCompany);
        AccountRefContrastInfo accountInfo = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(this.curCompany.getCU().getId().toString(), this.curCompany.getAccountTable().getId().toString(), periods[2].getPeriodYear(), periods[2].getPeriodNumber());
        String curAcctTableID = null;
        curAcctTableID = accountInfo != null && accountInfo.getDisabledAcctTable() != null ? accountInfo.getDisabledAcctTable().getId().toString() : this.curCompany.getAccountTable().getId().toString();
        StringBuffer sbCurrencyIds = new StringBuffer();
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            sbCurrencyIds.append("'").append(currency.getId().toString()).append("',");
        }
        sbCurrencyIds.deleteCharAt(sbCurrencyIds.length() - 1);
        Map cashBegin = this.getAmountFromBalance(ctx, currencyCollection, true, true, sbCurrencyIds.toString(), curAcctTableID);
        Map cashEnd = this.getAmountFromBalance(ctx, currencyCollection, true, false, sbCurrencyIds.toString(), curAcctTableID);
        Map equBegin = this.getAmountFromBalance(ctx, currencyCollection, false, true, sbCurrencyIds.toString(), curAcctTableID);
        Map equEnd = this.getAmountFromBalance(ctx, currencyCollection, false, false, sbCurrencyIds.toString(), curAcctTableID);
        HashMap<BOSUuid, QueryData[]> result = new HashMap<BOSUuid, QueryData[]>();
        QueryData[] data = null;
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            data = new QueryData[]{(QueryData)cashBegin.get(currency.getId()), (QueryData)cashEnd.get(currency.getId()), (QueryData)equBegin.get(currency.getId()), (QueryData)equEnd.get(currency.getId())};
            result.put(currency.getId(), data);
        }
        return result;
    }

    private Map getAmountFromBalance(Context ctx, CurrencyCollection currencyCollection, boolean isCash, boolean isBegin, String currencyIds, String accountTableId) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer("Select balance.FCurrencyID,");
        if (isBegin) {
            sbSql.append(" sum(case account.FDC when 1 then (FYearCreditFor-FYearDebitFor+FBeginBalanceFor) else (FYearDebitFor-FYearCreditFor+(-1)*FBeginBalanceFor) end) FAmount, ");
            sbSql.append(" sum(case account.FDC when 1 then (FYearCreditLocal-FYearDebitLocal+FBeginBalanceLocal) else (FYearDebitLocal-FYearCreditLocal+(-1)*FBeginBalanceLocal) end) FAmountLocal, ");
            sbSql.append(" sum(case account.FDC when 1 then (FYearCreditRpt-FYearDebitRpt+FBeginBalanceRpt) else (FYearDebitRpt-FYearCreditRpt+(-1)*FBeginBalanceRpt) end) FAmountRpt ");
        } else {
            sbSql.append(" sum(case account.FDC when 1 then FBeginBalanceFor else (-1)*FBeginBalanceFor end) FAmount, ");
            sbSql.append(" sum(case account.FDC when 1 then FBeginBalanceLocal else (-1)*FBeginBalanceLocal end) FAmountLocal, ");
            sbSql.append(" sum(case account.FDC when 1 then FBeginBalanceRpt else (-1)*FBeginBalanceRpt end) FAmountRpt ");
        }
        sbSql.append(" from T_GL_InitAccountBalance balance join T_BD_AccountView account");
        sbSql.append(" on balance.FAccountID = account.FID ");
        sbSql.append(" where account.FIsLeaf = 1");
        sbSql.append(" and balance.FOrgUnitId = ?");
        sbSql.append(" and balance.FCurrencyID in (").append(currencyIds).append(")");
        sbSql.append(" and account.FaccountTableId = ?");
        if (isCash) {
            sbSql.append(" and (account.FIsCash = 1 or account.FIsBank = 1) ");
        } else {
            sbSql.append(" and account.FIsCashEquivalent = 1");
        }
        sbSql.append(" group by  balance.FCurrencyID");
        HashMap<BOSUuid, QueryData> result = new HashMap<BOSUuid, QueryData>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{this.curCompany.getId().toString(), accountTableId});
            while (rs.next()) {
                QueryData data = new QueryData();
                data.setCurrency(currencyCollection.get((Object)BOSUuid.read((String)rs.getString("fcurrencyid"))));
                data.setOriginalAmount(rs.getBigDecimal("FAmount") == null ? ZERO : rs.getBigDecimal("FAmount"));
                data.setLocalAmount(rs.getBigDecimal("FAmountLocal") == null ? ZERO : rs.getBigDecimal("FAmountLocal"));
                data.setReportingAmount(rs.getBigDecimal("FAmountRpt") == null ? ZERO : rs.getBigDecimal("FAmountRpt"));
                result.put(data.getCurrency().getId(), data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.checkQueryResult(currencyCollection, result);
        return result;
    }

    private List formatSeq(Context ctx, List ltItem) throws EASBizException, BOSException {
        ArrayList<Object[]> ltItemReturn = new ArrayList<Object[]>();
        Object[] objItem = null;
        Object[] objData = null;
        int iSeq = 1;
        int n = ltItem.size();
        for (int i = 0; i < n; ++i) {
            objItem = (Object[])ltItem.get(i);
            objData = (Object[])objItem.clone();
            int thisLevel = (Integer)objItem[12];
            objData[14] = thisLevel == 1 ? null : new Integer(iSeq++);
            ltItemReturn.add(objData);
        }
        return ltItemReturn;
    }

    private String getGeneralLocalCurrency() {
        return CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
    }

    private String getGeneralReportCurrency() {
        return CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
    }

    private String getResource(Context ctx, String name) {
        return ResourceBase.getString((String)RECFLOW, (String)name, (Locale)ctx.getLocale());
    }

    private String getBlankString(int level) {
        StringBuffer sbBlank = new StringBuffer();
        for (int i = 1; i < level; ++i) {
            sbBlank.append("        ");
        }
        return sbBlank.toString();
    }

    private String getSumString(Context ctx, String sumName) {
        StringBuffer sbReturn = new StringBuffer(this.getResource(ctx, "strSum"));
        int pos = sbReturn.indexOf("@");
        if (sumName == null) {
            sumName = "";
        }
        if (pos >= 0) {
            sbReturn.replace(pos, pos + 1, sumName);
            return sbReturn.toString();
        }
        return sumName + sbReturn;
    }

    @Override
    protected void _saveCashflowInit(Context ctx, CashflowInitCollection cfInitCollection) throws BOSException, EASBizException {
        int size = cfInitCollection.size();
        if (size == 0) {
            return;
        }
        String currencyId = cfInitCollection.get(0).getCurrency().getId().toString();
        String companyId = cfInitCollection.get(0).getCompany().getId().toString();
        String sqlDel = "delete from t_gl_cashflowinit where fcurrencyid=? and fcompanyid=?";
        DbUtil.execute((Context)ctx, (String)sqlDel, (Object[])new Object[]{currencyId, companyId});
        for (int i = 0; i < size; ++i) {
            this.submit(ctx, (CoreBaseInfo)cfInitCollection.get(i));
        }
    }

    @Override
    protected boolean _isClosedInitForCashflowInit(Context ctx, HashMap otherCtx) throws BOSException {
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String orgUnitId = company.getId().toString();
        return flag.getCashflowInitClosed(orgUnitId);
    }

    @Override
    protected void _closeInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        this._checkInitCash(ctx, otherCtx);
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        flag.setCashflowInitClosed(true, orgUnitId);
    }

    @Override
    protected void _checkInitCash(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        company = GlUtils.getCompanyById(ctx, company.getId().toString());
        Map hmParamValue = InitHelp.getInitParam(ctx, company);
        boolean isForeignCurrency = (Boolean)hmParamValue.get("GL_008");
        boolean isUseReportCurrency = (Boolean)hmParamValue.get("G001");
        CurrencyCollection curCol = this.getCurrency(ctx, company, isUseReportCurrency);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        boolean isNeedCheck = true;
        String sql = "select top 1 FID from T_BD_CashFlowItem where FType = 1 and FIsFreeze = 0";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (!rs.next()) {
                isNeedCheck = false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (isNeedCheck) {
            this.checkSupItem(ctx, curCol, isForeignCurrency);
        }
        this.checkMasterItem(ctx, curCol, isForeignCurrency);
        this.checkAsstIsEqual(ctx, otherCtx);
    }

    private void checkMasterItem(Context ctx, CurrencyCollection curCol, boolean isForeignCurrency) throws BOSException, EASBizException, CashFlowInitException {
        String generalLocal = this.getGeneralLocalCurrency();
        String generalReport = this.getGeneralReportCurrency();
        boolean isGeneralLocal = false;
        boolean isGeneralReport = false;
        Map primaryCash = this.selectWorkDataFromDB(ctx, curCol, 0, 0);
        Map balance = this.getCashBalance(ctx, curCol);
        QueryData primaryCashData = null;
        CurrencyInfo currency = null;
        QueryData[] balanceData = null;
        BigDecimal cashAmt = ZERO;
        for (Object key : primaryCash.keySet()) {
            primaryCashData = (QueryData)primaryCash.get(key);
            currency = primaryCashData.getCurrency();
            balanceData = (QueryData[])balance.get(key);
            isGeneralLocal = generalLocal.equals(currency.getId().toString());
            isGeneralReport = generalReport.equals(currency.getId().toString());
            BigDecimal[] secondaryCash = new BigDecimal[]{balanceData[1].getOriginalAmount().subtract(balanceData[0].getOriginalAmount()).add(balanceData[3].getOriginalAmount()).subtract(balanceData[2].getOriginalAmount()), balanceData[1].getLocalAmount().subtract(balanceData[0].getLocalAmount()).add(balanceData[3].getLocalAmount()).subtract(balanceData[2].getLocalAmount()), balanceData[1].getReportingAmount().subtract(balanceData[0].getReportingAmount()).add(balanceData[3].getReportingAmount()).subtract(balanceData[2].getReportingAmount())};
            cashAmt = primaryCashData.getOriginalAmount().subtract(secondaryCash[0]);
            cashAmt = cashAmt.setScale(currency.getPrecision(), 1);
            if (!isGeneralLocal && !isGeneralReport && cashAmt.compareTo(ZERO) != 0) {
                Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber(primaryCashData.getOriginalAmount(), currency.getPrecision()), GlUtils.formatNumber(secondaryCash[0], currency.getPrecision())};
                throw new CashFlowInitException(CashFlowInitException.CASH_ORIGINAL_NOT_EQUAL, params);
            }
            cashAmt = primaryCashData.getLocalAmount().subtract(secondaryCash[1]);
            cashAmt = cashAmt.setScale(currency.getPrecision(), 1);
            if ((isGeneralLocal || isForeignCurrency) && cashAmt.compareTo(ZERO) != 0) {
                Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber(primaryCashData.getLocalAmount(), currency.getPrecision()), GlUtils.formatNumber(secondaryCash[1], currency.getPrecision())};
                throw new CashFlowInitException(CashFlowInitException.CASH_LOCAL_NOT_EQUAL, params);
            }
            cashAmt = primaryCashData.getReportingAmount().subtract(secondaryCash[2]);
            cashAmt = cashAmt.setScale(currency.getPrecision(), 1);
            if (!isGeneralReport && !isForeignCurrency || cashAmt.compareTo(ZERO) == 0) continue;
            Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber(primaryCashData.getReportingAmount(), currency.getPrecision()), GlUtils.formatNumber(secondaryCash[2], currency.getPrecision())};
            throw new CashFlowInitException(CashFlowInitException.CASH_REPORT_NOT_EQUAL, params);
        }
    }

    private void checkSupItem(Context ctx, CurrencyCollection curCol, boolean isForeignCurrency) throws BOSException, EASBizException, CashFlowInitException {
        String generalLocal = this.getGeneralLocalCurrency();
        String generalReport = this.getGeneralReportCurrency();
        boolean isGeneralLocal = false;
        boolean isGeneralReport = false;
        Map primaryWork = this.selectWorkDataFromDB(ctx, curCol, 0, 1);
        Map secondaryWork = this.getSecondaryWorkData(ctx, curCol);
        CurrencyInfo currency = null;
        QueryData primaryData = null;
        QueryData secondaryData = null;
        BigDecimal workAmt = ZERO;
        for (Object key : primaryWork.keySet()) {
            primaryData = (QueryData)primaryWork.get(key);
            currency = primaryData.getCurrency();
            secondaryData = (QueryData)secondaryWork.get(key);
            if (!primaryData.getCurrency().getId().toString().equals(secondaryData.getCurrency().getId().toString())) continue;
            isGeneralLocal = generalLocal.equals(currency.getId().toString());
            isGeneralReport = generalReport.equals(currency.getId().toString());
            workAmt = workAmt.setScale(currency.getPrecision());
            workAmt = primaryData.getOriginalAmount().subtract(secondaryData.getOriginalAmount());
            workAmt = workAmt.setScale(currency.getPrecision(), 1);
            if (!isGeneralLocal && !isGeneralReport && workAmt.compareTo(ZERO) != 0) {
                Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber(primaryData.getOriginalAmount(), currency.getPrecision()), GlUtils.formatNumber(secondaryData.getOriginalAmount(), currency.getPrecision())};
                throw new CashFlowInitException(CashFlowInitException.WORK_ORIGINAL_NOT_EQUAL, params);
            }
            workAmt = primaryData.getLocalAmount().subtract(secondaryData.getLocalAmount());
            workAmt = workAmt.setScale(currency.getPrecision(), 1);
            if ((isGeneralLocal || isForeignCurrency) && workAmt.compareTo(ZERO) != 0) {
                Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber(primaryData.getLocalAmount(), currency.getPrecision()), GlUtils.formatNumber(secondaryData.getLocalAmount(), currency.getPrecision())};
                throw new CashFlowInitException(CashFlowInitException.WORK_LOCAL_NOT_EQUAL, params);
            }
            workAmt = primaryData.getReportingAmount().subtract(secondaryData.getReportingAmount());
            workAmt = workAmt.setScale(currency.getPrecision(), 1);
            if (!isGeneralReport && !isForeignCurrency || workAmt.compareTo(ZERO) == 0) continue;
            Object[] params = new Object[]{currency.getName(ctx.getLocale()), GlUtils.formatNumber(primaryData.getReportingAmount(), currency.getPrecision()), GlUtils.formatNumber(secondaryData.getReportingAmount(), currency.getPrecision())};
            throw new CashFlowInitException(CashFlowInitException.WORK_REPORT_NOT_EQUAL, params);
        }
    }

    private CurrencyCollection getCurrency(Context ctx, CompanyOrgUnitInfo company, boolean isUseReportCurrency) throws BOSException, EASBizException {
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = null;
        EntityViewInfo currencyView = new EntityViewInfo();
        FilterInfo currencyFilter = new FilterInfo();
        currencyView.setFilter(currencyFilter);
        currencyFilter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID));
        currencyFilter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID));
        currencyFilter.setMaskString("#0 or #1");
        curCol = curCtrl.getCurrencyCollection(currencyView);
        if (curCol != null) {
            CurrencyInfo cur = null;
            for (int i = 0; i < curCol.size(); ++i) {
                cur = curCol.get(i);
                if (this.getGeneralLocalCurrency().equals(cur.getId().toString())) {
                    cur.setPrecision(company.getBaseCurrency().getPrecision());
                    continue;
                }
                if (isUseReportCurrency && this.getGeneralReportCurrency().equals(cur.getId().toString())) {
                    cur.setPrecision(company.getReportCurrency().getPrecision());
                    continue;
                }
                if (isUseReportCurrency || !this.getGeneralReportCurrency().equals(cur.getId().toString())) continue;
                curCol.removeObject(i);
            }
        }
        return curCol;
    }

    private Map getSecondaryWorkData(Context ctx, CurrencyCollection currencyCollection) throws BOSException, EASBizException {
        Map secondaryWork = this.selectWorkDataFromDB(ctx, currencyCollection, 1, 0);
        Map profits = this.getRetainedProfits(ctx, currencyCollection);
        for (Object key : secondaryWork.keySet()) {
            QueryData secondaryData = (QueryData)secondaryWork.get(key);
            QueryData profitData = (QueryData)profits.get(key);
            secondaryData.setOriginalAmount(secondaryData.getOriginalAmount() == null ? (profitData.getOriginalAmount() == null ? GlUtils.zero : profitData.getOriginalAmount()) : secondaryData.getOriginalAmount().add(profitData.getOriginalAmount() == null ? GlUtils.zero : profitData.getOriginalAmount()));
            secondaryData.setLocalAmount(secondaryData.getLocalAmount() == null ? (profitData.getLocalAmount() == null ? GlUtils.zero : profitData.getLocalAmount()) : secondaryData.getLocalAmount().add(profitData.getLocalAmount() == null ? GlUtils.zero : profitData.getLocalAmount()));
            secondaryData.setReportingAmount(secondaryData.getReportingAmount() == null ? (profitData.getReportingAmount() == null ? GlUtils.zero : profitData.getReportingAmount()) : secondaryData.getReportingAmount().add(profitData.getReportingAmount() == null ? GlUtils.zero : profitData.getReportingAmount()));
        }
        return secondaryWork;
    }

    private Map selectWorkDataFromDB(Context ctx, CurrencyCollection currencyCollection, int itemType, int isDealActivity) throws BOSException, EASBizException {
        this.curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        String generalLocal = this.getGeneralLocalCurrency();
        String generalReport = this.getGeneralReportCurrency();
        boolean hasGeneralLocal = false;
        boolean hasGeneralReport = false;
        boolean hasOtherCurrency = false;
        StringBuffer sbCurrencyIds = new StringBuffer();
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            if (generalLocal.equals(currency.getId().toString())) {
                hasGeneralLocal = true;
                continue;
            }
            if (generalReport.equals(currency.getId().toString())) {
                hasGeneralReport = true;
                continue;
            }
            sbCurrencyIds.append("'").append(currency.getId().toString()).append("',");
            hasOtherCurrency = true;
        }
        if (hasOtherCurrency) {
            sbCurrencyIds.deleteCharAt(sbCurrencyIds.length() - 1);
        }
        StringBuffer sbSql = new StringBuffer();
        if (hasOtherCurrency) {
            sbSql.append(this.getOtherCurrencySql(itemType, isDealActivity, sbCurrencyIds.toString()));
        }
        if (hasGeneralLocal) {
            if (sbSql.length() > 0) {
                sbSql.append(" union all ");
            }
            sbSql.append(this.getGeneralCurrencySql(itemType, isDealActivity, generalLocal));
        }
        if (hasGeneralReport) {
            if (sbSql.length() > 0) {
                sbSql.append(" union all ");
            }
            sbSql.append(this.getGeneralCurrencySql(itemType, isDealActivity, generalReport));
        }
        int paramCount = 0;
        if (hasOtherCurrency) {
            ++paramCount;
        }
        if (hasGeneralLocal) {
            ++paramCount;
        }
        if (hasGeneralReport) {
            ++paramCount;
        }
        Object[] params = new Object[paramCount];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.curCompany.getId().toString();
        }
        HashMap<BOSUuid, QueryData> result = new HashMap<BOSUuid, QueryData>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            while (rs.next()) {
                if (rs.getString("fcurrencyid") == null) continue;
                QueryData data = new QueryData();
                data.setCurrency(currencyCollection.get((Object)BOSUuid.read((String)rs.getString("fcurrencyid"))));
                data.setOriginalAmount(rs.getBigDecimal("FOriginalAmount") == null ? ZERO : rs.getBigDecimal("FOriginalAmount"));
                data.setLocalAmount(rs.getBigDecimal("FLocalAmount") == null ? ZERO : rs.getBigDecimal("FLocalAmount"));
                data.setReportingAmount(rs.getBigDecimal("FReportingAmount") == null ? ZERO : rs.getBigDecimal("FReportingAmount"));
                result.put(data.getCurrency().getId(), data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.checkQueryResult(currencyCollection, result);
        return result;
    }

    private void checkQueryResult(CurrencyCollection currencyCollection, Map result) {
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            if (result.containsKey(currency.getId())) continue;
            QueryData data = new QueryData();
            data.setCurrency(currency);
            data.setOriginalAmount(ZERO);
            data.setLocalAmount(ZERO);
            data.setReportingAmount(ZERO);
            result.put(data.getCurrency().getId(), data);
        }
    }

    private String getOtherCurrencySql(int itemType, int isDealActivity, String currencyIds) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("    SELECT  ");
        if (itemType == 0) {
            sbSql.append("    cfit.fcurrencyid,sum(case cfi.fdirection when 1 then FOriginalAmount else (-1)*FOriginalAmount end) FOriginalAmount, ");
            sbSql.append("    sum(case cfi.fdirection when 1 then FLocalAmount else (-1)*FLocalAmount end) FLocalAmount,");
            sbSql.append("    sum(case cfi.fdirection when 1 then FReportingAmount else (-1)*FReportingAmount end) FReportingAmount");
        } else {
            sbSql.append("    cfit.fcurrencyid,sum(FOriginalAmount) FOriginalAmount,sum(FLocalAmount) FLocalAmount,sum(FReportingAmount) FReportingAmount");
        }
        sbSql.append("    FROM T_BD_CashFlowItem cfi LEFT OUTER JOIN ( ");
        sbSql.append("    SELECT FCurrencyID,FCompanyID,FCashflowItemID,FOriginalAmount, FLocalAmount, FReportingAmount");
        sbSql.append("    FROM T_GL_CashflowInit");
        sbSql.append("    WHERE");
        sbSql.append("    FCurrencyID IN (").append(currencyIds).append(")");
        sbSql.append("    AND FCompanyID = ? ) cfit ");
        sbSql.append("    ON cfi.fid = cfit.FCashflowItemID");
        sbSql.append("    WHERE cfi.fisprofit=0 AND  cfi.FType = ");
        sbSql.append(itemType);
        sbSql.append("  and cfi.fisleaf = 1 ");
        if (isDealActivity == 1) {
            sbSql.append("   and cfi.FIsDealActivity=1");
        }
        sbSql.append(" group by fcurrencyid");
        return sbSql.toString();
    }

    private String getGeneralCurrencySql(int itemType, int isDealActivity, String generalCurrency) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("    SELECT  ");
        sbSql.append("'").append(generalCurrency).append("' fcurrencyid,");
        if (itemType == 0) {
            sbSql.append("    sum(case cfi.fdirection when 1 then FOriginalAmount else (-1)*FOriginalAmount end) FOriginalAmount, ");
            sbSql.append("    sum(case cfi.fdirection when 1 then FLocalAmount else (-1)*FLocalAmount end) FLocalAmount,");
            sbSql.append("    sum(case cfi.fdirection when 1 then FReportingAmount else (-1)*FReportingAmount end) FReportingAmount");
        } else {
            sbSql.append("    sum(FOriginalAmount) FOriginalAmount,sum(FLocalAmount) FLocalAmount,sum(FReportingAmount) FReportingAmount");
        }
        sbSql.append("    FROM T_BD_CashFlowItem cfi LEFT OUTER JOIN ( ");
        sbSql.append("    SELECT FCurrencyID,FCashflowItemID,FOriginalAmount, FLocalAmount, FReportingAmount");
        sbSql.append("    FROM T_GL_CashflowInit");
        sbSql.append("    WHERE");
        sbSql.append("    FCompanyID = ? ) cfit ");
        sbSql.append("    ON cfi.fid = cfit.FCashflowItemID");
        sbSql.append("    WHERE cfi.fisprofit=0 AND  cfi.FType = ");
        sbSql.append(itemType);
        sbSql.append("  and cfi.fisleaf = 1 ");
        if (isDealActivity == 1) {
            sbSql.append("   and cfi.FIsDealActivity=1");
        }
        return sbSql.toString();
    }

    @Override
    protected void _cancelInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        flag.setCashflowInitClosed(false, orgUnitId);
    }

    @Override
    protected boolean _isClosedInitForCashflowGrpAsst(Context ctx, HashMap otherCtx) throws BOSException {
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String companyid = company.getId().toString();
        return flag.getCashflowGrpAsstClosed(companyid);
    }

    @Override
    protected void _closeInitForCashflowGrpAsst(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        this.checkAsstIsEqual(ctx, otherCtx);
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        flag.setCashflowGrpAsstClosed(true, orgUnitId);
    }

    @Override
    protected void _cancelInitForCashflowGrpAsst(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        flag.setCashflowGrpAsstClosed(false, orgUnitId);
    }

    private void checkAsstIsEqual(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        List items = this.getInitItemWithGsst(ctx);
        for (Object[] obj : items) {
            BigDecimal[] asstAmount = this.getAsstValue(ctx, otherCtx, obj[0].toString());
            int precision = Integer.parseInt(obj[5].toString());
            String currencyName = obj[4].toString();
            String itemName = obj[6] + "";
            BigDecimal bdOriginalAmount = ((BigDecimal)obj[1]).setScale(precision, 1);
            BigDecimal bdLocalAmount = ((BigDecimal)obj[2]).setScale(precision, 1);
            BigDecimal bdRptAmount = ((BigDecimal)obj[3]).setScale(precision, 1);
            BigDecimal asstOriginalAmount = asstAmount[0].setScale(precision, 1);
            BigDecimal asstLocalAmount = asstAmount[1].setScale(precision, 1);
            BigDecimal asstReportAmount = asstAmount[2].setScale(precision, 1);
            if (bdOriginalAmount.compareTo(asstOriginalAmount) != 0) {
                Object[] params = new Object[]{currencyName, GlUtils.formatNumber(bdOriginalAmount, precision), GlUtils.formatNumber(asstOriginalAmount, precision), itemName};
                throw new CashFlowInitException(CashFlowInitException.ASST_ORIGINAL_NOT_EQUAL, params);
            }
            if (bdLocalAmount.compareTo(asstLocalAmount) != 0) {
                Object[] params = new Object[]{currencyName, GlUtils.formatNumber(bdLocalAmount, precision), GlUtils.formatNumber(asstLocalAmount, precision), itemName};
                throw new CashFlowInitException(CashFlowInitException.ASST_LOCALL_NOT_EQUAL, params);
            }
            if (bdRptAmount.compareTo(asstReportAmount) == 0) continue;
            Object[] params = new Object[]{currencyName, GlUtils.formatNumber(bdRptAmount, precision), GlUtils.formatNumber(asstReportAmount, precision), itemName};
            throw new CashFlowInitException(CashFlowInitException.ASST_REPORT_NOT_EQUAL, params);
        }
    }

    private List getInitItemWithGsst(Context ctx) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer(" select FName_");
        sbSql.append(ctx.getLocale());
        sbSql.append(" cfItemName,FInitid ,FCashflowItemID ,foriginalamount,FLocalAmount,freportingamount, curname,Fprecision FROM T_BD_CashFlowItem cfi");
        sbSql.append(" INNER JOIN ( SELECT cinit.fid FInitid,FCashflowItemID  , curname ,Fprecision, FOriginalAmount,   FLocalAmount,  FReportingAmount");
        sbSql.append(" FROM T_GL_CashflowInit   cinit ");
        sbSql.append(" inner join ( select fid,fname_");
        sbSql.append(ctx.getLocale());
        sbSql.append("  curname,Fprecision from t_bd_currency ) cur on cinit.fcurrencyid = cur.fid");
        sbSql.append("  WHERE   FCompanyID = ?) cfit");
        sbSql.append(" ON cfi.fid = cfit.FCashflowItemID where cfi.FIsEnable=1 and cfi.FISLEAF = 1 and FAsstAccountID is not null");
        Object[] params = null;
        this.curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        params = new Object[]{this.curCompany.getId().toString()};
        ArrayList<Object[]> items = new ArrayList<Object[]>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            while (rs.next()) {
                Object[] obj = new Object[]{rs.getString("FInitid"), rs.getBigDecimal("foriginalamount") == null ? ZERO : rs.getBigDecimal("FOriginalAmount"), rs.getBigDecimal("FLocalAmount") == null ? ZERO : rs.getBigDecimal("FLocalAmount"), rs.getBigDecimal("freportingamount") == null ? ZERO : rs.getBigDecimal("freportingamount"), rs.getString("curname"), rs.getString("Fprecision"), rs.getString("cfItemName")};
                items.add(obj);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return items;
    }

    private BigDecimal[] getAsstValue(Context ctx, HashMap otherCtx, String cFlowInitID) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer(" SELECT  sum(FOriginalAmount) FOriginalAmount, sum(FLocalAmount) FLocalAmount, sum(FReportingAmount) FReportingAmount ");
        sbSql.append(" FROM T_GL_CashflowGrpAsst");
        sbSql.append(" WHERE FCflowInitID = ?");
        Object[] params = null;
        params = new Object[]{cFlowInitID};
        BigDecimal[] obj = new BigDecimal[]{ZERO, ZERO, ZERO};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])params);
            if (rs.next()) {
                obj[0] = rs.getBigDecimal("FOriginalAmount") == null ? ZERO : rs.getBigDecimal("FOriginalAmount");
                obj[1] = rs.getBigDecimal("FLocalAmount") == null ? ZERO : rs.getBigDecimal("FLocalAmount");
                obj[2] = rs.getBigDecimal("FReportingAmount") == null ? ZERO : rs.getBigDecimal("FReportingAmount");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return obj;
    }

    @Override
    protected ArrayList _getEnabledGrpAsst(Context ctx) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" SELECT FAsstAccountID FROM T_BD_CashFlowItem WHERE fisenable=1 and FAsstAccountID is not null");
        ArrayList<String> items = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
            while (rs.next()) {
                items.add(rs.getString("FAsstAccountID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return items;
    }

    @Override
    protected List _getCashflowInitValue4Web(Context ctx, IObjectValue currecyInfo, IObjectValue company) throws BOSException, EASBizException {
        this.curCompany = (CompanyOrgUnitInfo)company;
        CtrlUnitInfo cu = this.curCompany.getCU();
        if (cu == null || cu.getId() == null) {
            CompanyOrgUnitInfo companyInfo = GlUtils.getCompanyById(ctx, this.curCompany.getId().toString());
            cu = companyInfo.getCU();
        }
        this.itemFilterSql = CashFlowItemViewFactory.getLocalInstance((Context)ctx).getCashFlowItemViewSql(cu.getId().toString());
        CurrencyInfo curinfo = (CurrencyInfo)currecyInfo;
        CurrencyCollection currencyCollection = new CurrencyCollection();
        currencyCollection.add(curinfo);
        Map balance = this.getCashBalance(ctx, currencyCollection);
        List ltItem = this.selectDataFromDB(ctx, currecyInfo, 0);
        if (!ltItem.isEmpty()) {
            ltItem = this.formatAddSpace(ctx, ltItem, currecyInfo, (QueryData[])balance.get(curinfo.getId()));
        }
        ltItem.addAll(this.formatSeconary(ctx, this.selectDataFromDB(ctx, currecyInfo, 1), currecyInfo));
        ltItem.addAll(this.selectDataFromDB(ctx, currecyInfo, 2));
        if (!ltItem.isEmpty()) {
            this.addCashSum(ctx, ltItem, currecyInfo, (QueryData[])balance.get(curinfo.getId()));
            ltItem = this.formatSeq(ctx, ltItem);
        }
        return (ArrayList)ltItem;
    }

    private static class QueryData {
        private CurrencyInfo currency = null;
        private BigDecimal originalAmount = ZERO;
        private BigDecimal LocalAmount = ZERO;
        private BigDecimal reportingAmount = ZERO;

        private QueryData() {
        }

        public CurrencyInfo getCurrency() {
            return this.currency;
        }

        public void setCurrency(CurrencyInfo currency) {
            this.currency = currency;
        }

        public BigDecimal getOriginalAmount() {
            return this.originalAmount;
        }

        public void setOriginalAmount(BigDecimal originalAmount) {
            this.originalAmount = originalAmount;
        }

        public BigDecimal getLocalAmount() {
            return this.LocalAmount;
        }

        public void setLocalAmount(BigDecimal localAmount) {
            this.LocalAmount = localAmount;
        }

        public BigDecimal getReportingAmount() {
            return this.reportingAmount;
        }

        public void setReportingAmount(BigDecimal reportingAmount) {
            this.reportingAmount = reportingAmount;
        }
    }
}

