/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.fi.gl.app.GLQuartzJob;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DeleteVoucherLogJob
extends GLQuartzJob {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.DeleteVoucherLogJob");

    public void execute(JobExecutionContext jctx) throws JobExecutionException {
        Vector ctxs = (Vector)jctx.getJobDetail().getJobDataMap().get((Object)"ctxs");
        for (int i = 0; i < ctxs.size(); ++i) {
            Context ctx = (Context)ctxs.get(i);
            if (!this.isContextUsable(ctx, "GL delete voucher log error,")) continue;
            try {
                this.deleteVoucherLog(ctx);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)"GL delete voucher log error!", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVoucherLog(Context ctx) throws Exception {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fdefaultval_l2 val from t_bas_param where fnumber = 'GL_VOUCHER_LOG'");
        boolean log = false;
        if (rs.next() && "true".equalsIgnoreCase(rs.getString("val"))) {
            log = true;
        }
        MutexParameter mp = DeleteVoucherLogJob.buildMutexParameter(ctx);
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLockSucceed = mutex.requestMutex(mp);
        if (!isLockSucceed) {
            return;
        }
        try {
            if (log) {
                this.archiveGlLog(ctx);
                DbUtil.execute((Context)ctx, (String)"delete from t_gl_voucher_log where fisupdating = 2 ");
            } else {
                DbUtil.execute((Context)ctx, (String)"delete from t_gl_voucher_log where fisupdating = 2 ");
                DbUtil.execute((Context)ctx, (String)"delete from t_pca_pcvoucherlog where fisupdating = 2 ");
            }
        }
        finally {
            mutex.releaseMutex(mp.getRequestId());
        }
    }

    private void archiveGlLog(Context ctx) throws BOSException {
        StringBuffer moveSql = new StringBuffer();
        moveSql.append("insert into T_GL_VCHLOGARCHIVE ( \n");
        moveSql.append("    FISASSIST, FVOUCHERID, FCREATETIME, FACTION, \n");
        moveSql.append("    FCOMPANYID, FPERIODID, FACCOUNTID, FCURRENCYID, \n");
        moveSql.append("    FBALTYPE, FASSISTGRPID, FMEASUREUNITID, \n");
        moveSql.append("    FDEBITFOR, FDEBITLOCAL, FDEBITRPT, FDEBITQTY, FSTANDARDDEBITQTY, \n");
        moveSql.append("    FCREDITFOR, FCREDITLOCAL, FCREDITRPT, FCREDITQTY, FSTANDARDCREDITQTY, \n");
        moveSql.append("    FMONTHPNLFOR, FMONTHPNLLOCAL, FMONTHPNLRPT, \n");
        moveSql.append("    FISUPDATING, FVeCount, FEntryID, FAssistID, FActionID, FInsertID, FCalculateID \n");
        moveSql.append(") \n");
        moveSql.append("select /*+ LEADING(vl) */ \n");
        moveSql.append("    FISASSIST, FVOUCHERID, FCREATETIME, FACTION, \n");
        moveSql.append("    FCOMPANYID, FPERIODID, FACCOUNTID, FCURRENCYID, \n");
        moveSql.append("    FBALTYPE, FASSISTGRPID, FMEASUREUNITID, \n");
        moveSql.append("    FDEBITFOR, FDEBITLOCAL, FDEBITRPT, FDEBITQTY, FSTANDARDDEBITQTY, \n");
        moveSql.append("    FCREDITFOR, FCREDITLOCAL, FCREDITRPT, FCREDITQTY, FSTANDARDCREDITQTY, \n");
        moveSql.append("    FMONTHPNLFOR, FMONTHPNLLOCAL, FMONTHPNLRPT, \n");
        moveSql.append("    FISUPDATING, FVeCount, FEntryID, FAssistID, FActionID, FInsertID, FCalculateID \n");
        moveSql.append("from t_gl_voucher_log vl \n");
        moveSql.append("join T_GL_ObjectLabel ol \n");
        moveSql.append("    on ol.FObjectID = vl.FCompanyID and ol.FLabel = 'VoucherLogBackup' and ol.FIsEnable = 1 \n");
        moveSql.append("where vl.fisupdating = 2 \n");
        DbUtil.execute((Context)ctx, (String)moveSql.toString());
    }

    protected static MutexParameter buildMutexParameter(Context ctx) {
        MutexParameter mp = new MutexParameter();
        Uuid requestId = Uuid.create();
        mp.setRequestId(requestId);
        mp.setMutexName("GLVoucherLogArchive");
        mp.setActionName("GLVoucherLogArchive");
        mp.setOrgUnitID(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        mp.setUserID(BOSUuid.read((String)"00000000-0000-0000-0000-00000000000013B7DE7F"));
        mp.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        String dcName = ctx.getAIS();
        if (dcName == null) {
            dcName = "";
        }
        mp.setDcName(dcName);
        mp.setDescription("GLVoucherLogArchive");
        return mp;
    }
}

