/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.ORMEngine;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AbstractAccountRefContrastProcess;
import com.kingdee.eas.basedata.master.account.AccountRefContrastUtil;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.BizBalanceException;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CussentStatusEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLBaseDataCheckException;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.IVoucherAssistRecord;
import com.kingdee.eas.fi.gl.IVoucherFacade;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.MockVoucherControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LRUMap;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLAccountRefContrastProcess
extends AbstractAccountRefContrastProcess {
    private Logger mylog = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLAccountRefContrastProcess");
    private Map asstActGroupDetailMap;
    private Map assistantHGInfoMap;
    private Map<String, DefaultAssistantHgValue> asstActObjectMap = new HashMap<String, DefaultAssistantHgValue>();
    private boolean opposite = false;
    private BigDecimal transCoefficient = new BigDecimal("-1");
    private LRUMap hgMapCache = new LRUMap();
    private int maxCacheSize = 10000;
    private boolean isQtyAsst = true;
    private final String cussentSourceFunction = "CussentAcctRef";
    private String actTable = "t_gl_acctcussent";

    public boolean enable(Context ctx, String companyID, String acrefID) throws BOSException, EASBizException {
        int systemEnum = 6;
        String curPeriodId = super.getCurrentPeriod(ctx, systemEnum, companyID);
        if (StringUtils.isEmpty((String)curPeriodId)) {
            return false;
        }
        PeriodInfo perInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)curPeriodId)));
        if (!this.isStartSystem(ctx, systemEnum, companyID)) {
            return false;
        }
        if (!perInfo.isIsAdjustPeriod()) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"974_GLAccountRefContrastProcess", (Locale)ctx.getLocale()), null);
        }
        this.bizEnableChecker(ctx, companyID, acrefID, perInfo);
        this.hgMapCache.setMaxSize(this.maxCacheSize);
        this.makeTransVouchs(ctx, companyID, acrefID);
        HashMap hmAllParam = this.isPNLAcctMustZero(ctx, (IObjectPK)new ObjectUuidPK(companyID));
        Boolean allowCussent = Boolean.valueOf(hmAllParam.get("GL_028").toString());
        if (allowCussent.booleanValue()) {
            this.makeTransAcctCussent(ctx, companyID, acrefID);
        }
        String templeTable = super.createEnableTempleTable(ctx, acrefID);
        this.checkNotDetailAccount(ctx, new Object[]{companyID}, true);
        this.updateGLBaseData(ctx, companyID, templeTable);
        super.updateAccountBaseDate(ctx, companyID, templeTable);
        this.hgMapCache.clear();
        return true;
    }

    private void checkNotDetailAccount(Context ctx, Object[] conpanyId, boolean isEnable) throws EASBizException {
        String accountField = isEnable ? "tba.FOLDACCTID" : "tba.FNEWACCTID";
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT tga.FACCOUNTID old_accId,tb.fnumber old_accNum,tba.FNEWACCTID new_accId FROM T_GL_AutoTransEntry tga");
        sql.append(" LEFT OUTER JOIN T_BD_ACCTREFCONTRASTENTRY tba on tga.FACCOUNTID = ").append(accountField);
        sql.append(" LEFT OUTER JOIN T_BD_ACCOUNTVIEW tb on tga.FACCOUNTID=tb.fid");
        sql.append(" where tga.FAutoTransID in (select fid from T_GL_AutoTrans where fcompanyid=?)");
        StringBuilder sql1 = new StringBuilder();
        sql1.append("SELECT tga.FACCOUNTVIEWID old_accId,tb.fnumber old_accNum,tba.FNEWACCTID new_accId FROM T_GL_TRANSPLPROGRAMENTRY tga");
        sql1.append(" LEFT OUTER JOIN T_BD_ACCTREFCONTRASTENTRY tba on tga.FACCOUNTVIEWID = ").append(accountField);
        sql1.append(" LEFT OUTER JOIN T_BD_ACCOUNTVIEW tb on tga.FACCOUNTVIEWID=tb.fid");
        sql1.append(" where tga.FPARENTID in (select fid from T_GL_TRANSPLPROGRAM where fcompanyid=?)");
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])conpanyId);
            while (result.next()) {
                String new_acctId = result.getString("new_accId");
                if (!StringUtils.isEmpty((String)new_acctId)) continue;
                String old_acctNumber = result.getString("old_accNum");
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"autoTransCheckNotDetailAcct", (Locale)ctx.getLocale())), new Object[]{old_acctNumber});
            }
            IRowSet result1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString(), (Object[])conpanyId);
            while (result1.next()) {
                String new_acctId = result1.getString("new_accId");
                if (!StringUtils.isEmpty((String)new_acctId)) continue;
                String old_acctNumber = result1.getString("old_accNum");
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"transPLCheckNotDetailAcct", (Locale)ctx.getLocale())), new Object[]{old_acctNumber});
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void updateGLBaseData(Context ctx, String companyID, String templeTable) throws BOSException {
        String sql = "update T_GL_TransPLProgram set (FYearProfitAcctID) =  (select top 1 tem.fnewacctid from " + templeTable + " tem where  tem.foldacctid= T_GL_TransPLProgram.FYearProfitAcctID)  where fcompanyid='" + companyID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_GL_TransPLProgramEntry set FAccountViewID =  (select top 1 tem.fnewacctid from " + templeTable + " tem where  tem.foldacctid= T_GL_TransPLProgramEntry.FAccountViewID  )  where  FParentID in (select fid from T_GL_TransPLProgram where fcompanyid='" + companyID + "')";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_GL_AdjustExchangeRate set (FPLAccountID) =  (select top 1 tem.fnewacctid from " + templeTable + " tem where  tem.foldacctid= T_GL_AdjustExchangeRate.FPLAccountID)  where FFICompanyID='" + companyID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_GL_AdjustExchangeRate_AeAcc set FaccID =  (select top 1 tem.fnewacctid from " + templeTable + " tem where  tem.foldacctid= T_GL_AdjustExchangeRate_AeAcc.FaccID  )  where  FParentID in (select fid from T_GL_AdjustExchangeRate where FFICompanyID='" + companyID + "')";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_GL_AutoTransEntry set FAccountID =  (select top 1 tem.fnewacctid from " + templeTable + " tem where  tem.foldacctid= T_GL_AutoTransEntry.FAccountID  )  where  FAutoTransID in (select fid from T_GL_AutoTrans where fcompanyid='" + companyID + "')";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void bizEnableChecker(Context ctx, String companyId, String acrefId, PeriodInfo period) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String fname = "FName_" + ctx.getLocale().toString();
        sql.append(" \tselect com.").append(fname).append("  from t_gl_voucher voucher \t\t\t\r\n").append("\tinner join t_org_company com on voucher.fcompanyid=com.fid\t\t\t\t\r\n").append("\tinner join t_bd_period period on voucher.fperiodid=period.fid\t\t\t\t\r\n").append("\tinner join t_gl_voucherentry entry on entry.fbillid=voucher.fid \t\t\t\t\r\n").append("\tinner join t_bd_accountview aview on entry.faccountid=aview.fid\t\t\t\r\n ").append(" \tinner join T_BD_AcctRefContrast acref on acref.FDisabledAcctTableID = aview.FAccountTableID \r\n").append("  and acref.fcompanyid = com.fid\t\t\r\n").append(" \twhere voucher.fbizstatus<>5 and  voucher.fbizstatus<>2 and  voucher.fbizstatus<>0\t\t\t\r\n").append(" \tand com.fid=? and  acref.fid=? \tand com.fisBizUnit=1\t\t\r\n").append(" \tand period.fnumber=? \t\t\r\n");
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, acrefId, new Integer(period.getNumber())});
            if (set != null && set.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.HAS_UNPOSTVOUCHER, new Object[]{set.getString(fname)});
            }
            StringBuffer sqlCheckLaterPeriod = new StringBuffer();
            sqlCheckLaterPeriod.append("select top 1 com.").append(fname).append(" ,period.fperiodYear,period.fperiodNumber \r\n").append("from t_gl_voucher voucher \r\n").append("inner join t_org_company com on voucher.fcompanyid=com.fid\t\r\n").append("inner join t_bd_period period on voucher.fperiodid=period.fid\t\r\n").append("inner join t_gl_voucherentry entry on entry.fbillid=voucher.fid \r\n").append("inner join t_bd_accountview aview on entry.faccountid=aview.fid \r\n").append("inner join T_BD_AcctRefContrast acref on acref.FDisabledAcctTableID=aview.faccounttableid \r\n").append("where com.fid=? and  acref.fid=? \tand com.fisBizUnit=1 and  period.fperiodyear>? \r\n");
            set = DbUtil.executeQuery((Context)ctx, (String)sqlCheckLaterPeriod.toString(), (Object[])new Object[]{companyId, acrefId, new Integer(period.getPeriodYear())});
            if (set != null && set.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.LP_VOUCHER, new Object[]{String.valueOf(set.getInt("fperiodYear")), String.valueOf(set.getInt("fperiodNumber"))});
            }
        }
        catch (BOSException e) {
            throw new BizReferenceException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        catch (SQLException e) {
            throw new BizReferenceException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        catch (GLBaseDataCheckException e) {
            throw new BizReferenceException(new NumericExceptionSubItem(e.getCode(), e.getMessage()), (Throwable)((Object)e));
        }
        StringBuffer sqlcur = new StringBuffer();
        sqlcur.append(" select com.fid as comid, fcurrentperiodid, p.fnumber from t_bd_systemstatusctrol ctrl \t\t\t\r\n ").append(" inner join t_bd_systemstatus status on ctrl.fsystemstatusid=status.fid \t\t\t\r\n").append(" inner join t_org_company com on com.fid=ctrl.fcompanyid \t\t\t\r\n").append(" left join t_bd_period p on p.fid = ctrl.fcurrentperiodid \r\n").append(" where status.fname=6 and com.fid=? and com.fisBizUnit=1\t\t\t\r\n");
        sql = new StringBuffer();
        sql.append("Select 1 where exists (Select 1                                                                \t\t\t\r\n");
        sql.append("From " + GLBalanceUtils.getAccountBalanceTable(5) + " bal,                                                             \r\n");
        sql.append("\tt_bd_accountview acct,                                                                \r\n");
        sql.append("\tt_BD_AccountType aType                                                                \r\n");
        sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
        sql.append("\tand bal.FPeriod = ?                                                                 \r\n");
        sql.append("\tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0 ) \t\t\t\t\t\t  \r\n");
        sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
        sql.append("\tand aType.FID = acct.FAccountTypeID                                                   \r\n");
        sql.append("\tand aType.FProperty = 4                                                               \r\n");
        sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
        sql.append("\tand acct.FCAA is null                                                               \r\n");
        sql.append(")                                               \t\t\t\t\t\t\r\n");
        sql.append("; \r\n");
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlcur.toString(), (Object[])new Object[]{companyId});
            while (set != null && set.next()) {
                String comid = set.getString("comid");
                String currentperiodid = set.getString("fcurrentperiodid");
                HashMap hmAllParam = this.isPNLAcctMustZero(ctx, (IObjectPK)new ObjectUuidPK(comid));
                Boolean bParam = Boolean.valueOf(hmAllParam.get("GL_011").toString());
                if (StringUtils.isEmpty((String)currentperiodid) || !bParam.booleanValue()) continue;
                int periodNumber = set.getInt("fnumber");
                IRowSet set2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{comid, periodNumber});
                if (set2 == null || !set2.next()) continue;
                throw new GLPeriodEndException(GLPeriodEndException.CLOSE_PNLBAL_NOT_ZERO, (Throwable)((Object)new GLPeriodEndException(GLPeriodEndException.CLOSE_PNLBAL_NOT_ZERO)));
            }
        }
        catch (BOSException e) {
            throw new BizReferenceException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        catch (SQLException e) {
            throw new BizReferenceException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        catch (BizReferenceException e) {
            throw new BizReferenceException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        catch (EASBizException e) {
            throw new BizReferenceException(new NumericExceptionSubItem(e.getCode(), e.getMessage()), (Throwable)e);
        }
    }

    private HashMap isPNLAcctMustZero(Context ctx, IObjectPK comPK) throws BOSException, EASBizException {
        HashMap<String, IObjectPK> hmParamIn = new HashMap<String, IObjectPK>();
        hmParamIn.put("GL_011", comPK);
        hmParamIn.put("GL_052", comPK);
        hmParamIn.put("GL_028", comPK);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
        return hmAllParam;
    }

    public boolean disEnable(Context ctx, String companyID, String acrefID) throws EASBizException, BOSException {
        int systemEnum = 6;
        String curPeriodId = super.getCurrentPeriod(ctx, systemEnum, companyID);
        if (StringUtils.isEmpty((String)curPeriodId)) {
            return false;
        }
        PeriodInfo perInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)curPeriodId)));
        if (!this.isStartSystem(ctx, systemEnum, companyID)) {
            return false;
        }
        if (!perInfo.isIsAdjustPeriod()) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"974_GLAccountRefContrastProcess", (Locale)ctx.getLocale()), null);
        }
        this.checkAcctCussentHistory(ctx, companyID, acrefID);
        this.deleteTransAcctCussent(ctx, companyID, acrefID, perInfo);
        this.deleteTransVouchs(ctx, companyID, perInfo);
        String templeTable = super.createDisableTempleTable(ctx, acrefID);
        this.checkNotDetailAccount(ctx, new Object[]{companyID}, false);
        this.updateGLBaseData(ctx, companyID, templeTable);
        super.updateAccountBaseDate(ctx, companyID, templeTable);
        return true;
    }

    private void checkAcctCussentHistory(Context ctx, String companyID, String acrefID) throws EASBizException, BOSException {
        StringBuilder sb = new StringBuilder();
        sb.append("select aview.fnumber as acctNumber from t_gl_acctCussentHistory ach ");
        sb.append("\tinner join t_bd_accountview aview on ach.faccountid=aview.fid\t\r\n ");
        sb.append(" inner join t_bd_acctrefcontrastentry ae on aview.fid = ae.fnewacctid \r\n");
        sb.append(" inner join T_BD_AcctRefContrast acref on acref.fid = ae.FAcctRefContrastID \r\n");
        sb.append("and acref.FEnabledAcctTableID = aview.faccounttableid \r\n");
        sb.append(" \twhere acref.fid=? and ach.fcompanyid=? \r\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{acrefID, companyID});
            sb.setLength(0);
            HashSet<String> accountSet = new HashSet<String>();
            while (rowSet.next()) {
                String acctNumber = rowSet.getString("acctNumber");
                if (accountSet.contains(acctNumber)) continue;
                sb.append("'").append(acctNumber).append("',");
                accountSet.add(acctNumber);
            }
            if (sb.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"ActHis_ActRef", (Locale)ctx.getLocale())), new Object[]{sb.toString().substring(0, sb.length() - 1)});
            }
        }
        catch (BOSException e) {
            this.mylog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            this.mylog.error((Object)e.getMessage(), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("", ""), (Throwable)e);
        }
    }

    private void deleteTransVouchs(Context ctx, String companyID, PeriodInfo curPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_gl_voucher where fcompanyid='" + companyID + "' and fperiodid='" + curPeriod.getId().toString() + "' and FSourceType=7");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> listPK = new ArrayList<String>();
        try {
            while (rs.next()) {
                listPK.add(rs.getString("fid"));
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        MockVoucherControllerBean voucher = new MockVoucherControllerBean();
        try {
            String id;
            int i;
            HashMap<String, HashMap> params = new HashMap<String, HashMap>();
            HashMap param = GlUtils.getDefaultGLParam(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
            params.put("sysParam", param);
            for (i = 0; i < listPK.size(); ++i) {
                id = (String)listPK.get(i);
                voucher.antiPostVoucher(ctx, (IObjectPK)new ObjectUuidPK(id), VoucherStatusEnum.POSTED);
            }
            this.antiAuditCheckVoucher(ctx, listPK);
            for (i = 0; i < listPK.size(); ++i) {
                id = (String)listPK.get(i);
                voucher.delete(ctx, (IObjectPK)new ObjectUuidPK(id));
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String getDefaultVoucherType(Context ctx) throws BOSException, EASBizException {
        VoucherTypeInfo info;
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("adminCU.*");
        evi.setSelector(sic);
        IVoucherType v = VoucherTypeFactory.getLocalInstance((Context)ctx);
        String ctrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        ObjectUuidPK ctrlUnitPK = new ObjectUuidPK(ctrlUnit);
        filter = v.getDatabaseDFilter((IObjectPK)ctrlUnitPK, "id", "adminCU.id");
        evi.setFilter(filter);
        VoucherTypeCollection coll = VoucherTypeFactory.getLocalInstance((Context)ctx).getVoucherTypes(ctrlUnit, filter);
        if (coll.size() == 0) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1102_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("", msg));
        }
        String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1103_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!msg.equals(info.getName())) continue;
            return info.getId().toString();
        }
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!info.isPretermit()) continue;
            return info.getId().toString();
        }
        return coll.get(0).getId().toString();
    }

    private void makeTransVouchs(Context ctx, String companyid, String acrefid) throws EASBizException, BOSException {
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        ParamItemInfo isQtyAsstInfo = pc.getParamItemByNumberAndOrg("G010", null);
        if (isQtyAsstInfo != null) {
            this.isQtyAsst = Boolean.valueOf(isQtyAsstInfo.toString());
        }
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection voucherColl = new VoucherCollection();
        String voucherTypeId = this.getDefaultVoucherType(ctx);
        IVoucherType voucherType = VoucherTypeFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK typePK = new ObjectUuidPK(BOSUuid.read((String)voucherTypeId));
        VoucherTypeInfo voucherTypeInfo = voucherType.getVoucherTypeInfo((IObjectPK)typePK);
        int systemEnum = 6;
        String curPeriodId = super.getCurrentPeriod(ctx, systemEnum, companyid);
        IPeriod period = PeriodFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK periodPk = new ObjectUuidPK(BOSUuid.read((String)curPeriodId));
        PeriodInfo periodInfo = period.getPeriodInfo((IObjectPK)periodPk);
        String descri975 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"975_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri976 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"976_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri977 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"977_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri978 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"978_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri979 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"979_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri980 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"980_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri981 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"981_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri982 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"982_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri983 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"983_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri984 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"984_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri985 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"985_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri986 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"986_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri987 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"987_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        SelectorItemCollection pSelector = new SelectorItemCollection();
        pSelector.add("id");
        pSelector.add("number");
        pSelector.add("endDate");
        PeriodInfo curPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(curPeriodId), pSelector);
        ObjectUuidPK pk = new ObjectUuidPK(companyid);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk, sic);
        ArrayList<IObjectPK> pkList = new ArrayList<IObjectPK>();
        StringBuffer assActDefaultSql = new StringBuffer();
        assActDefaultSql.append("SELECT TYPE.fassthgattribute AS attribute,");
        assActDefaultSql.append("        def.fdefaultid AS defaultvalue,");
        assActDefaultSql.append("        refentry.fnewacctid AS nweacctid,");
        assActDefaultSql.append("        refentry.foldacctid AS oldacctid");
        assActDefaultSql.append(" FROM   t_bd_acctrefcontrastentry refentry");
        assActDefaultSql.append("        INNER JOIN t_ac_acctrefcontrastentrydef def ON refentry.fid = def.fparentid");
        assActDefaultSql.append("        INNER JOIN t_bd_asstacttype TYPE ON def.fasstacttypeid = TYPE.fid");
        assActDefaultSql.append(" WHERE  refentry.facctrefcontrastid = '" + acrefid + "'");
        IRowSet defSet = DbUtil.executeQuery((Context)ctx, (String)assActDefaultSql.toString());
        try {
            while (defSet.next()) {
                DefaultAssistantHgValue value;
                String key = defSet.getString("nweacctid") + defSet.getString("oldacctid");
                String attribute = defSet.getString("attribute");
                IObjectValue objValue = (IObjectValue)super.getAsstActObject(ctx, defSet.getString("defaultvalue"));
                if (this.asstActObjectMap.get(key) == null) {
                    value = new DefaultAssistantHgValue();
                    value.setKey(key);
                    value.getDefaultValueMap().put(attribute, objValue);
                    this.asstActObjectMap.put(value.getKey(), value);
                    continue;
                }
                value = this.asstActObjectMap.get(key);
                value.getDefaultValueMap().put(attribute, objValue);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("SELECT  distinct srcAcct.fdc AS srcdc,");
        sqlStr.append("        desAcct.fdc AS desdc,");
        sqlStr.append("        srcAcct.FMeasureUnitID AS srcMeasureUnit,");
        sqlStr.append("        desAcct.FMeasureUnitID AS desMeasureUnit,");
        sqlStr.append("        srcAcct.FMeasureUnitGroupID AS srcMeasureUnitGroup,");
        sqlStr.append("        desAcct.FMeasureUnitGroupID AS desMeasureUnitGroup,");
        sqlStr.append("        refentry.foldacctid AS srcacctid,");
        sqlStr.append("        refentry.fnewacctid AS desacctid,");
        sqlStr.append("        bal.fcurrencyid AS currencyid,");
        sqlStr.append("        cy.fprecision,");
        sqlStr.append("        bal.fendbalancefor,");
        sqlStr.append("        bal.fendbalancelocal,");
        sqlStr.append("        bal.fendbalancerpt,");
        sqlStr.append("        bal.fendqty AS quantity,");
        sqlStr.append("        srcAcct.fisqty AS srcisqty,");
        sqlStr.append("        desAcct.fisqty AS desisqty,");
        sqlStr.append("        srcAcct.fcaa AS srccaa,");
        sqlStr.append("        desAcct.fcaa AS descaa,");
        sqlStr.append("        srcAcct.fnumber AS srcAcctNumber,");
        sqlStr.append("        desAcct.fnumber AS desAcctNumber");
        sqlStr.append(" FROM   " + GLBalanceUtils.getAccountBalanceTable(5) + " bal ");
        sqlStr.append("        INNER JOIN t_bd_currency cy ON cy.fid = bal.fcurrencyid ");
        sqlStr.append("        inner JOIN t_bd_acctrefcontrastentry refentry ON bal.faccountid = refentry.foldacctid");
        sqlStr.append("        left outer JOIN t_bd_accountview srcAcct ON srcAcct.fid = refentry.foldacctid");
        sqlStr.append("        left outer JOIN t_bd_accountview desacct ON desacct.fid = refentry.fnewacctid");
        sqlStr.append(" WHERE  refentry.foldacctid = bal.faccountid");
        sqlStr.append("        AND srcacct.fisleaf = 1");
        sqlStr.append("        AND bal.forgunitid = '" + companyid + "'");
        sqlStr.append("        AND (bal.fendbalancefor <> 0 or bal.fendbalancelocal <> 0 or (bal.fendbalancefor = 0 and").append("\t\t\t exists (select 1 from " + GLBalanceUtils.getAssistBalanceTable(5) + " asb where asb.faccountid = bal.faccountid ").append("\t\t\t and asb.fperiod = bal.fperiod").append("\t\t\t and asb.fcurrencyid = bal.fcurrencyid and asb.forgunitid = bal.forgunitid").append("\t\t\t and asb.fendbalancefor <> 0)))");
        sqlStr.append("        AND fperiod = " + curPeriod.getNumber());
        sqlStr.append("        AND refentry.facctrefcontrastid = '" + acrefid + "'");
        LowTimer low = new LowTimer();
        low.reset();
        IRowSet set = null;
        set = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        this.mylog.info((Object)("sqltimetest:GL.makeTransVouchs1" + low.msValue()));
        this.createAsstActGroupDetailMap(ctx, set);
        try {
            set.beforeFirst();
            while (set.next()) {
                low.reset();
                VoucherInfo vInfo = new VoucherInfo();
                VoucherEntryCollection vEntryCollection = new VoucherEntryCollection();
                VoucherEntryInfo enInfo = new VoucherEntryInfo();
                VoucherEntryInfo newEnInfo = new VoucherEntryInfo();
                BigDecimal balAmount = set.getBigDecimal("fendBalanceFor");
                BigDecimal balLocalAmount = set.getBigDecimal("fendBalancelocal");
                BigDecimal balRptAmount = set.getBigDecimal("fendBalancerpt");
                int adc = set.getInt("srcdc");
                int desadc = set.getInt("desdc");
                if (adc != desadc) {
                    this.mylog.info((Object)("error:" + adc + "," + desadc));
                }
                if (balAmount.doubleValue() != 0.0) {
                    enInfo.setLocalExchangeRate(set.getBigDecimal("fendBalancelocal").divide(balAmount, 10, 4));
                    enInfo.setReportingExchangeRate(set.getBigDecimal("fendBalancerpt").divide(balAmount, 10, 4));
                    newEnInfo.setLocalExchangeRate(set.getBigDecimal("fendBalancelocal").divide(balAmount, 10, 4));
                    newEnInfo.setReportingExchangeRate(set.getBigDecimal("fendBalancerpt").divide(balAmount, 10, 4));
                }
                this.opposite = false;
                if (adc == 1) {
                    enInfo.setEntryDC(EntryDC.CREDIT);
                    newEnInfo.setEntryDC(EntryDC.DEBIT);
                } else {
                    enInfo.setEntryDC(EntryDC.DEBIT);
                    newEnInfo.setEntryDC(EntryDC.CREDIT);
                    this.opposite = true;
                    if (balAmount.compareTo(BigDecimal.ZERO) != 0) {
                        balAmount = balAmount.multiply(this.transCoefficient);
                    }
                    if (balLocalAmount.compareTo(BigDecimal.ZERO) != 0) {
                        balLocalAmount = balLocalAmount.multiply(this.transCoefficient);
                    }
                    if (balRptAmount.compareTo(BigDecimal.ZERO) != 0) {
                        balRptAmount = balRptAmount.multiply(this.transCoefficient);
                    }
                }
                enInfo.setOriginalAmount(balAmount);
                enInfo.setLocalAmount(balLocalAmount);
                enInfo.setReportingAmount(balRptAmount);
                newEnInfo.setOriginalAmount(balAmount);
                newEnInfo.setLocalAmount(balLocalAmount);
                newEnInfo.setReportingAmount(balRptAmount);
                AccountViewInfo oldAcctInfo = new AccountViewInfo();
                String oldAcctID = set.getString("srcAcctID");
                oldAcctInfo.setId(BOSUuid.read((String)oldAcctID));
                String oldAcctNumber = set.getString("srcAcctNumber");
                oldAcctInfo.setNumber(oldAcctNumber);
                String newAcctID = set.getString("desAcctID");
                AccountViewInfo newAcctInfo = new AccountViewInfo();
                newAcctInfo.setId(BOSUuid.read((String)newAcctID));
                String newAcctNumber = set.getString("desAcctNumber");
                oldAcctInfo.setNumber(newAcctNumber);
                enInfo.setAccount(oldAcctInfo);
                newEnInfo.setAccount(newAcctInfo);
                String oldCaa = set.getString("srccaa");
                String newCaa = set.getString("descaa");
                if (!StringUtils.isEmpty((String)oldCaa)) {
                    BOSUuid oldCaaId = BOSUuid.read((String)oldCaa);
                    AsstAccountInfo oldAsstacc = new AsstAccountInfo();
                    oldAsstacc.setId(oldCaaId);
                    oldAcctInfo.setCAA(oldAsstacc);
                    enInfo.setCAA(oldAsstacc);
                }
                if (!StringUtils.isEmpty((String)newCaa)) {
                    BOSUuid newCaaId = BOSUuid.read((String)newCaa);
                    AsstAccountInfo newAsstacc = new AsstAccountInfo();
                    newAsstacc.setId(newCaaId);
                    newAcctInfo.setCAA(newAsstacc);
                    newEnInfo.setCAA(newAsstacc);
                }
                CurrencyInfo currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)set.getString("currencyID")));
                currencyInfo.setPrecision(set.getInt("fprecision"));
                enInfo.setCurrency(currencyInfo);
                newEnInfo.setCurrency(currencyInfo);
                enInfo.setDescription(descri975);
                newEnInfo.setDescription(descri976);
                enInfo.setSeq(1);
                newEnInfo.setSeq(2);
                enInfo.setOprStatus(1);
                newEnInfo.setOprStatus(1);
                enInfo.setCussent(CussentStatusEnum.NONE);
                newEnInfo.setCussent(CussentStatusEnum.NONE);
                AccountRefContrastUtil util = new AccountRefContrastUtil();
                boolean isMuForAcct = true;
                MeasureUnitInfo srcMInfo = null;
                MeasureUnitInfo desMInfo = null;
                String srcmeasureUnit = set.getString("srcMeasureUnit");
                String desmeasureUnit = set.getString("desMeasureUnit");
                if (isMuForAcct && !StringUtils.isEmpty((String)srcmeasureUnit)) {
                    srcMInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)srcmeasureUnit)));
                }
                if (isMuForAcct && !StringUtils.isEmpty((String)desmeasureUnit)) {
                    desMInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)desmeasureUnit)));
                }
                if (!StringUtils.isEmpty((String)srcmeasureUnit)) {
                    enInfo.setMeasureUnit(srcMInfo);
                }
                if (!StringUtils.isEmpty((String)desmeasureUnit)) {
                    newEnInfo.setMeasureUnit(desMInfo);
                }
                int oldIsQty = set.getInt("srcIsQty");
                int newIsQty = set.getInt("desIsQty");
                BigDecimal quantity = set.getBigDecimal("quantity");
                if (this.opposite) {
                    quantity = quantity.multiply(this.transCoefficient);
                }
                if (newIsQty != 0 && oldIsQty != 0) {
                    BigDecimal srcTransQty = quantity;
                    if (srcMInfo != null) {
                        srcTransQty = quantity.divide(srcMInfo.getCoefficient(), 4, RoundingMode.HALF_UP);
                    }
                    enInfo.setQuantity(srcTransQty);
                    enInfo.setStandardQuantity(srcTransQty);
                    enInfo.setPrice(balAmount.divide(srcTransQty.compareTo(this.zero) == 0 ? this.one : srcTransQty, 4, RoundingMode.HALF_UP));
                    BigDecimal desTransQty = quantity;
                    if (desMInfo != null) {
                        desTransQty = quantity.divide(desMInfo.getCoefficient(), 4, RoundingMode.HALF_UP);
                    }
                    newEnInfo.setQuantity(desTransQty);
                    newEnInfo.setStandardQuantity(desTransQty);
                    newEnInfo.setPrice(balAmount.divide(desTransQty.compareTo(this.zero) == 0 ? this.one : desTransQty, 4, RoundingMode.HALF_UP));
                }
                VoucherAssistRecordCollection vAssistRecordColl = new VoucherAssistRecordCollection();
                VoucherAssistRecordCollection newVAssistRecordColl = new VoucherAssistRecordCollection();
                low.reset();
                HashMap map = this.getAssistRecordColl(ctx, enInfo, newEnInfo, oldCaa, newCaa, oldAcctID, newAcctID, oldIsQty, balAmount, srcMInfo, desMInfo, companyid, curPeriod);
                vAssistRecordColl = (VoucherAssistRecordCollection)map.get("oldCollection");
                newVAssistRecordColl = (VoucherAssistRecordCollection)map.get("newCollection");
                if (!StringUtils.isEmpty((String)oldCaa) && StringUtils.isEmpty((String)newCaa) && newIsQty != 0 && oldIsQty != 0) {
                    BigDecimal sumQty;
                    BigDecimal newQty = sumQty = (BigDecimal)map.get("sumQty");
                    if (desMInfo != null) {
                        newQty = sumQty.divide(desMInfo.getCoefficient(), 4, RoundingMode.HALF_UP);
                    }
                    newEnInfo.setQuantity(newQty);
                    newEnInfo.setStandardQuantity(newQty);
                    newEnInfo.setPrice(balAmount.divide(newQty.compareTo(this.zero) == 0 ? this.one : newQty, 4, RoundingMode.HALF_UP));
                }
                if (!StringUtils.isEmpty((String)newCaa) && newIsQty != 0 && this.isQtyAsst) {
                    newEnInfo.setMeasureUnit(null);
                    newEnInfo.setPrice(null);
                }
                if (!StringUtils.isEmpty((String)oldCaa) && oldIsQty != 0 && this.isQtyAsst) {
                    enInfo.setMeasureUnit(null);
                    enInfo.setPrice(null);
                }
                this.mylog.info((Object)("sqltimetest:GL.makeTransVouchs4:" + low.msValue() + descri977 + (vAssistRecordColl.size() + newVAssistRecordColl.size()) + descri978));
                if (!StringUtils.isEmpty((String)oldCaa)) {
                    enInfo.getAssistRecords().addCollection(vAssistRecordColl);
                }
                if (!StringUtils.isEmpty((String)newCaa)) {
                    if (StringUtils.isEmpty((String)oldCaa)) {
                        VoucherAssistRecordInfo newAssistRecodInfo = newVAssistRecordColl.get(0);
                        newAssistRecodInfo.setOriginalAmount(newEnInfo.getOriginalAmount());
                        newAssistRecodInfo.setLocalAmount(newEnInfo.getLocalAmount());
                        newAssistRecodInfo.setReportingAmount(newEnInfo.getReportingAmount());
                    }
                    newEnInfo.getAssistRecords().addCollection(newVAssistRecordColl);
                }
                enInfo.setIsHand(false);
                newEnInfo.setIsHand(false);
                enInfo.setBill(vInfo);
                newEnInfo.setBill(vInfo);
                vInfo.setCurrency(newEnInfo.getCurrency());
                vEntryCollection.add(enInfo);
                vEntryCollection.add(newEnInfo);
                vInfo.setEntries((AbstractObjectCollection)vEntryCollection);
                if (vEntryCollection.size() > 0) {
                    vInfo.setVoucherAbstract(vEntryCollection.get(0).getDescription());
                }
                vInfo.setEntryCount(vEntryCollection.size());
                vInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                vInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                vInfo.setCompany(companyInfo);
                vInfo.setPeriod(periodInfo);
                vInfo.setVoucherType(voucherTypeInfo);
                vInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
                vInfo.setBookedDate((Date)vInfo.getPeriod().getEndDate());
                vInfo.setBizDate((Date)vInfo.getPeriod().getEndDate());
                vInfo.setSourceType(SourceType.ACCOUNTADJUST);
                vInfo.setSourceSys(SystemEnum.GENERALLEDGER);
                vInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                vInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                vInfo.setCalSubmitBal(0);
                voucherColl.add(vInfo);
                this.mylog.info((Object)("sqltimetest:GL.makeTransVouchs:" + low.msValue() + descri979));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < voucherColl.size(); ++i) {
            low.reset();
            VoucherInfo info = voucherColl.get(i);
            VoucherEntryInfo voucherEntryInfo = info.getEntries().get(0);
            this.mylog.info((Object)(descri980 + voucherEntryInfo.getAccount().getId() + ",amount:" + voucherEntryInfo.getOriginalAmount()));
            IObjectPK vPK = null;
            try {
                vPK = voucher.submitAccountAdjustVoucher((BaseVoucherInfo)info);
            }
            catch (VoucherException ex) {
                this.mylog.error((Object)(descri981 + voucherEntryInfo.getAccount().getNumber() + " FID: " + voucherEntryInfo.getAccount().getId() + descri982 + ex.getMessage()), (Throwable)((Object)ex));
                throw this.util.getEASBizException(descri981 + voucherEntryInfo.getAccount().getNumber() + descri983 + ex.getMessage(), (Exception)((Object)ex));
            }
            pkList.add(vPK);
            this.mylog.error((Object)("sqltimetest:GL.makeTransVouchs:" + low.msValue() + descri984));
        }
        low.reset();
        this.auditCheckVoucher(ctx, pkList);
        this.mylog.error((Object)("auditcheck pkList=" + pkList + "sqltimetest:GL.makeTransVouchs:" + low.msValue() + descri985));
        low.reset();
        voucher.postVoucherCollection(pkList, null);
        this.mylog.error((Object)("post pkList=" + pkList + "sqltimetest:GL.makeTransVouchs:" + low.msValue() + descri986 + pkList.size() + descri987));
    }

    private void auditCheckVoucher(Context ctx, ArrayList pkList) throws BOSException {
        String voStr = ToolUtils.aryToStr((List)pkList, (boolean)true);
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String updateSql = "update t_gl_voucher set fischeck =1 , FBizStatus=3, fauditorid='" + userID + "',  fcashierid='" + userID + "' where\u3000fid in (" + voStr + ") ";
        DbUtil.execute((Context)ctx, (String)updateSql);
        String dpdatesql2 = "update T_GL_VoucherEntry set fischeck =1 , fcashierid= '" + userID + "' where FBillID in (" + voStr + ")";
        DbUtil.execute((Context)ctx, (String)dpdatesql2);
    }

    private void antiAuditCheckVoucher(Context ctx, ArrayList pkList) throws BOSException {
        String voStr = ToolUtils.aryToStr((List)pkList, (boolean)true);
        String updateSql = "update t_gl_voucher set fischeck =0 , FBizStatus=1, fauditorid=null,  fcashierid=null where\u3000fid in (" + voStr + ") ";
        DbUtil.execute((Context)ctx, (String)updateSql);
        String dpdatesql2 = "update T_GL_VoucherEntry set fischeck =0 , fcashierid= null  where FBillID in (" + voStr + ")";
        DbUtil.execute((Context)ctx, (String)dpdatesql2);
    }

    private HashMap getAssistRecordColl(Context ctx, VoucherEntryInfo enInfo, VoucherEntryInfo newEnInfo, String oldCaa, String newCaa, String oldAcctid, String newAcctid, int oldIsQty, BigDecimal accountBal, MeasureUnitInfo srcMInfo, MeasureUnitInfo desMInfo, String companyId, PeriodInfo period) throws BOSException, EASBizException {
        IRowSet assistSet = this.getAssistSet(ctx, companyId, period, oldAcctid, oldIsQty);
        this.createAssistantHGInfoMap(ctx, assistSet, oldCaa);
        String key = newAcctid + oldAcctid;
        HashMap<String, Object> map = new HashMap<String, Object>();
        VoucherAssistRecordCollection oldCollection = new VoucherAssistRecordCollection();
        VoucherAssistRecordCollection newCollection = new VoucherAssistRecordCollection();
        String descri976 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"976_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri975 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"975_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        boolean needQuantity = false;
        BigDecimal sumQty = BigDecimal.ZERO;
        try {
            if (!StringUtils.isEmpty((String)oldCaa) && StringUtils.isEmpty((String)newCaa)) {
                needQuantity = true;
            }
            if (StringUtils.isEmpty((String)oldCaa) && !StringUtils.isEmpty((String)newCaa)) {
                VoucherAssistRecordInfo newAInfo = new VoucherAssistRecordInfo();
                AssistantHGInfo newHgInfo = new AssistantHGInfo();
                AsstAccountInfo type = new AsstAccountInfo();
                type.setId(BOSUuid.read((String)newCaa));
                newHgInfo.setAsstAccount(type);
                DefaultAssistantHgValue value = this.asstActObjectMap.get(key);
                if (value != null) {
                    Map<String, IObjectValue> objValueMap = value.getDefaultValueMap();
                    Set<String> set = objValueMap.keySet();
                    Iterator<String> it = set.iterator();
                    while (it.hasNext()) {
                        String atr = it.next().toString();
                        IObjectValue objValue = objValueMap.get(atr);
                        if (objValue == null) continue;
                        newHgInfo.put(atr, (Object)objValue);
                    }
                }
                IVoucherFacade iVoucherFacade = VoucherFacadeFactory.getLocalInstance((Context)ctx);
                Object[] info = iVoucherFacade.fetchAssColumnInfo(newAcctid.toString(), newCaa.toString(), null);
                VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
                for (int i = 0; i < assItemCols.length; ++i) {
                    VoucherInfo.DynamicColumnInfo colInfo = assItemCols[i];
                    newHgInfo.put(colInfo.getMappingPropName(), newHgInfo.get(colInfo.getMappingPropName()));
                }
                AssistantHGInfo hgInfo = this.getHgFromCache(newCaa, newHgInfo);
                if (hgInfo == null) {
                    newHgInfo.put("aatok", (Object)true);
                    newHgInfo = iVoucherFacade.confirmAssGrp(newHgInfo, newCaa, assItemCols);
                    this.cacheHg(newCaa, newHgInfo);
                } else {
                    newHgInfo = hgInfo;
                }
                newAInfo.setAssGrp(newHgInfo);
                newAInfo.setDescription(descri976);
                newAInfo.setEntry(newEnInfo);
                newAInfo.setSeq(1);
                newAInfo.setMeasureUnit(enInfo.getMeasureUnit());
                newAInfo.setOriginalAmount(accountBal);
                newAInfo.setQuantity(enInfo.getQuantity());
                newAInfo.setStandardQuantity(enInfo.getQuantity());
                newAInfo.setPrice(enInfo.getPrice());
                newAInfo.setAssGrp(newHgInfo);
                newAInfo.setBizDate((Date)period.getEndDate());
                newAInfo.setEndDate((Date)period.getEndDate());
                newCollection.add(newAInfo);
            }
            assistSet.beforeFirst();
            while (assistSet.next()) {
                String accountId = assistSet.getString("accountid");
                String currencyId = assistSet.getString("fcurrencyId");
                int seqCount = 1;
                if (!accountId.equals(oldAcctid) || !currencyId.equals(newEnInfo.getCurrency().getId().toString())) continue;
                VoucherAssistRecordInfo aInfo = new VoucherAssistRecordInfo();
                VoucherAssistRecordInfo newAInfo = new VoucherAssistRecordInfo();
                AssistantHGInfo hgInfo = null;
                if (!StringUtils.isEmpty((String)oldCaa)) {
                    String hgFid = assistSet.getString("hgFid");
                    hgInfo = (AssistantHGInfo)this.assistantHGInfoMap.get(hgFid);
                    aInfo.setAssGrp(hgInfo);
                }
                BigDecimal endAmount = assistSet.getBigDecimal("fendbalancefor");
                BigDecimal localAmount = assistSet.getBigDecimal("fendBalancelocal");
                BigDecimal rptAmount = assistSet.getBigDecimal("fendBalancerpt");
                BigDecimal endQty = assistSet.getBigDecimal("fendqty");
                MeasureUnitInfo unitInfo = desMInfo;
                if (oldIsQty != 0 && this.isQtyAsst) {
                    String unitInfoId = assistSet.getString("fmeasureunitid");
                    unitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitInfoId)));
                    if (needQuantity) {
                        sumQty = sumQty.add(unitInfo.getCoefficient().multiply(endQty));
                    }
                }
                if (this.opposite) {
                    endAmount = endAmount.multiply(this.transCoefficient);
                    localAmount = localAmount.multiply(this.transCoefficient);
                    rptAmount = rptAmount.multiply(this.transCoefficient);
                }
                if (!StringUtils.isEmpty((String)newCaa) && !StringUtils.isEmpty((String)oldCaa)) {
                    AssistantHGInfo newHgInfo = new AssistantHGInfo();
                    if (newCaa.equals(oldCaa)) {
                        newHgInfo = hgInfo;
                        this.cacheHg(newCaa, newHgInfo);
                    } else {
                        AssistantHGInfo hg;
                        List asstActTypeList = (List)this.asstActGroupDetailMap.get(newCaa);
                        AsstActTypeCollection actTypes = new AsstActTypeCollection();
                        for (int i = 0; i < asstActTypeList.size(); ++i) {
                            AsstActTypeInfo asstActType = (AsstActTypeInfo)asstActTypeList.get(i);
                            actTypes.add(asstActType);
                        }
                        AsstAccountInfo type = new AsstAccountInfo();
                        type.setId(BOSUuid.read((String)newCaa));
                        newHgInfo.setAsstAccount(type);
                        DefaultAssistantHgValue value = this.asstActObjectMap.get(key);
                        if (value != null) {
                            Map<String, IObjectValue> objValueMap = value.getDefaultValueMap();
                            Set<String> set = objValueMap.keySet();
                            Iterator<String> it = set.iterator();
                            while (it.hasNext()) {
                                String atr = it.next().toString();
                                IObjectValue objValue = objValueMap.get(atr);
                                if (objValue == null) continue;
                                newHgInfo.put(atr, (Object)objValue);
                            }
                        }
                        if (hgInfo != null) {
                            for (int k = 0; k < asstActTypeList.size(); ++k) {
                                String attribute = ((AsstActTypeInfo)asstActTypeList.get(k)).getAsstHGAttribute();
                                PropertyContainer objValue = (PropertyContainer)hgInfo.get(attribute);
                                if (objValue == null) continue;
                                newHgInfo.put(attribute, (Object)objValue);
                            }
                        }
                        if ((hg = this.getHgFromCache(newCaa, newHgInfo)) == null) {
                            newHgInfo.put("aatok", (Object)true);
                            IAssistantHG assistanthg = AssistantHGFactory.getLocalInstance((Context)ctx);
                            newHgInfo = assistanthg.getAssistantHG(newHgInfo, type.getId().toString(), actTypes);
                            this.cacheHg(newCaa, newHgInfo);
                        } else {
                            newHgInfo = hg;
                        }
                    }
                    newAInfo.setAssGrp(newHgInfo);
                    newAInfo.setDescription(descri976);
                    newAInfo.setEntry(newEnInfo);
                    newAInfo.setSeq(seqCount + 1);
                    newAInfo.setOriginalAmount(endAmount);
                    newAInfo.setLocalAmount(localAmount);
                    newAInfo.setReportingAmount(rptAmount);
                    newAInfo.setMeasureUnit(unitInfo);
                    if (this.opposite) {
                        endQty = endQty.multiply(this.transCoefficient);
                    }
                    if (endQty.doubleValue() != 0.0) {
                        newAInfo.setQuantity(endQty);
                        newAInfo.setStandardQuantity(endQty);
                        newAInfo.setPrice(endAmount.divide(endQty.compareTo(this.zero) == 0 ? this.one : endQty, 2));
                    }
                    newAInfo.setBizDate((Date)period.getEndDate());
                    newAInfo.setEndDate((Date)period.getEndDate());
                }
                aInfo.setEntry(enInfo);
                aInfo.setSeq(seqCount);
                aInfo.setDescription(descri975);
                aInfo.setOriginalAmount(endAmount);
                aInfo.setLocalAmount(localAmount);
                aInfo.setReportingAmount(rptAmount);
                aInfo.setMeasureUnit(unitInfo);
                if (this.opposite) {
                    endQty = endQty.multiply(this.transCoefficient);
                }
                if (endQty.doubleValue() != 0.0) {
                    aInfo.setQuantity(endQty);
                    aInfo.setStandardQuantity(endQty);
                    aInfo.setPrice(endAmount.divide(endQty.compareTo(this.zero) == 0 ? this.one : endQty, 2));
                }
                aInfo.setBizDate((Date)period.getEndDate());
                aInfo.setEndDate((Date)period.getEndDate());
                seqCount += 2;
                if (aInfo != null && !StringUtils.isEmpty((String)oldCaa)) {
                    oldCollection.add(aInfo);
                }
                if (newAInfo == null || StringUtils.isEmpty((String)newCaa)) continue;
                newCollection.add(newAInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        map.put("oldCollection", oldCollection);
        map.put("newCollection", newCollection);
        if (needQuantity) {
            map.put("sumQty", sumQty);
        }
        return map;
    }

    private void cacheHg(String newCaa, AssistantHGInfo newHgInfo) {
        BOSUuid id = newHgInfo.getId();
        newHgInfo.setId(null);
        String hgCachKey = newHgInfo.toString() + newCaa;
        newHgInfo.setId(id);
        this.hgMapCache.put((Object)hgCachKey, (Object)newHgInfo);
    }

    private AssistantHGInfo getHgFromCache(String newCaa, AssistantHGInfo newHgInfo) {
        BOSUuid id = newHgInfo.getId();
        newHgInfo.setId(null);
        String hgCachKey = newHgInfo.toString() + newCaa;
        newHgInfo.setId(id);
        return (AssistantHGInfo)this.hgMapCache.get((Object)hgCachKey);
    }

    private IRowSet getAssistSet(Context ctx, String companyId, PeriodInfo period, String accountId, int oldIsQty) throws BOSException {
        StringBuffer assistSql = new StringBuffer();
        assistSql.append("SELECT DISTINCT bal.faccountid AS accountid,");
        assistSql.append("                 bal.fcurrencyid,");
        if (oldIsQty != 0 && this.isQtyAsst) {
            assistSql.append("                 bal.fmeasureunitid,");
        }
        assistSql.append("                 '" + period.getId().toString() + "' fperiodid,");
        assistSql.append("                 5 fbaltype,");
        assistSql.append("                 bal.forgunitid,");
        assistSql.append("                 bal.fassistgrpid,");
        assistSql.append("                 bal.fendqty,");
        assistSql.append("                 bal.fendbalancefor,");
        assistSql.append("                 bal.fendbalancelocal,");
        assistSql.append("                 bal.fendbalancerpt,");
        assistSql.append("                 hg.fid AS hgfid,");
        assistSql.append("                 hg.fasstaccountid AS asstaccountid ");
        if (oldIsQty != 0 && this.isQtyAsst) {
            assistSql.append(" FROM   " + GLBalanceUtils.getAssistMeasureBalanceTable(5) + " bal");
        } else {
            assistSql.append(" FROM   " + GLBalanceUtils.getAssistBalanceTable(5) + " bal");
        }
        assistSql.append("        INNER JOIN t_bd_assistanthg hg ON hg.fid = bal.fassistgrpid");
        assistSql.append("        INNER JOIN t_bd_asstaccount asstype ON hg.fasstaccountid = asstype.fid");
        assistSql.append("        INNER JOIN t_bd_asstactgroupdetail detail ON detail.fasstaccountid = asstype.fid");
        assistSql.append(" WHERE  bal.forgunitid = '" + companyId + "'");
        assistSql.append("        AND (bal.fendbalancefor <> 0 or bal.fendbalancelocal <> 0)");
        assistSql.append("        AND fperiod = " + period.getNumber());
        assistSql.append("        AND faccountid = '" + accountId + "'");
        IRowSet assistSet = DbUtil.executeQuery((Context)ctx, (String)assistSql.toString());
        return assistSet;
    }

    private String getACAccountviews(Context ctx, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select src.fid as oldFid from t_bd_acctrefcontrastentry frentry ");
        sql.append("inner join t_bd_accountview src on src.fid=frentry.foldacctid ");
        sql.append("inner join t_bd_accountview des on des.fid=frentry.fnewacctid ");
        sql.append("where src.fac=1 and des.fac=1 and src.fac=des.fac and frentry.facctrefcontrastid='" + acrefID + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer acStr = new StringBuffer();
        try {
            while (rs.next()) {
                acStr.append("'" + rs.getString("oldFid") + "',");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        acStr.append("''");
        return acStr.toString();
    }

    private void makeTransAcctCussent(Context ctx, String companyID, String acrefID) throws BOSException, EASBizException {
        String acStr = this.getACAccountviews(ctx, acrefID);
        String curPeriod = super.getCurrentPeriod(ctx, 6, companyID);
        PeriodInfo perInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)curPeriod)));
        this.deleteTransAcctCussent(ctx, companyID, acrefID, perInfo);
        this.makeNewVchAssistData(ctx, companyID, acrefID, acStr);
        this.makeNewAcctData(ctx, companyID, acrefID, curPeriod, acStr);
        this.upateAcctData(ctx, companyID, curPeriod, acrefID);
        this.actTable = "t_gl_acctverify";
        this.makeNewVchAssistData(ctx, companyID, acrefID, acStr);
        this.makeNewAcctData(ctx, companyID, acrefID, curPeriod, acStr);
        this.upateAcctData(ctx, companyID, curPeriod, acrefID);
    }

    private void makeNewVchAssistData(Context ctx, String companyID, String acrefID, String acStr) throws BOSException {
        StringBuffer assistRecordSql = new StringBuffer();
        assistRecordSql.append("INSERT INTO t_gl_voucherassistrecord(");
        assistRecordSql.append("             fid,");
        assistRecordSql.append("             FSOURCEBILLID,");
        assistRecordSql.append("             FSOURCEFUNCTION,");
        assistRecordSql.append("             fassgrpid,");
        assistRecordSql.append("             fseq,");
        assistRecordSql.append("             fbizdate,");
        assistRecordSql.append("             foriginalamount,");
        assistRecordSql.append("             flocalamount,");
        assistRecordSql.append("             freportingamount,");
        assistRecordSql.append("             fquantity,");
        assistRecordSql.append("             fdescription,");
        assistRecordSql.append("             fsettlementtypeid,");
        assistRecordSql.append("             fsettlementcode,");
        assistRecordSql.append("             fstandardquantity,");
        assistRecordSql.append("             fbiznumber,");
        assistRecordSql.append("             fenddate,");
        assistRecordSql.append("             fcustomerid,");
        assistRecordSql.append("             finvoicenumber,");
        assistRecordSql.append("             fticketnumber)");
        assistRecordSql.append(" SELECT Newbosid('0FFFBCAA'),");
        assistRecordSql.append("        c.fid,");
        assistRecordSql.append("'").append("CussentAcctRef").append("',");
        assistRecordSql.append("        c.fassgrpid,");
        assistRecordSql.append("        c.fseq,");
        assistRecordSql.append("        c.fbizdate,");
        assistRecordSql.append("        a.funverifiedamtfor,");
        assistRecordSql.append("        a.funverifiedamtlocal,");
        assistRecordSql.append("        a.funverifiedamtrpt,");
        assistRecordSql.append("        a.funverifiedqty,");
        assistRecordSql.append("        c.fdescription,");
        assistRecordSql.append("        c.fsettlementtypeid,");
        assistRecordSql.append("        c.fsettlementcode,");
        assistRecordSql.append("        a.funverifiedqty,");
        assistRecordSql.append("        c.fbiznumber,");
        assistRecordSql.append("        c.fenddate,");
        assistRecordSql.append("        c.fcustomerid,");
        assistRecordSql.append("        c.finvoicenumber,");
        assistRecordSql.append("        c.fticketnumber");
        assistRecordSql.append(" FROM   ").append(this.actTable).append(" a,");
        assistRecordSql.append("        t_bd_acctrefcontrastentry b,");
        assistRecordSql.append("        t_gl_voucherassistrecord c");
        assistRecordSql.append(" WHERE  b.facctrefcontrastid ='" + acrefID + "' ");
        assistRecordSql.append("        AND a.faccountid = b.foldacctid");
        assistRecordSql.append("        AND a.fcompanyid = '" + companyID + "'");
        assistRecordSql.append("        AND a.funverifiedamtfor <> 0");
        assistRecordSql.append("        AND a.fvchassistrecordid = c.fid");
        if (!StringUtils.isEmpty((String)acStr)) {
            assistRecordSql.append("        AND a.faccountid in(" + acStr + ")");
        }
        DbUtil.execute((Context)ctx, (String)assistRecordSql.toString());
    }

    private void makeNewAcctData(Context ctx, String companyID, String acrefID, String curPeriod, String acStr) throws BOSException {
        StringBuffer cusSentSql = new StringBuffer();
        cusSentSql.append("INSERT INTO ").append(this.actTable).append(" ( ");
        cusSentSql.append("             fid,");
        cusSentSql.append("             fcompanyid,");
        cusSentSql.append("             faccountid,");
        cusSentSql.append("             fcurrencyid,");
        cusSentSql.append("             fisinit,");
        cusSentSql.append("             fisinitclosed,");
        cusSentSql.append("             fvchassistrecordid,");
        cusSentSql.append("             fperiodid,");
        cusSentSql.append("             fsourcebillid,");
        cusSentSql.append("             fcreatorid,");
        cusSentSql.append("             fcreatetime,");
        cusSentSql.append("             flastupdateuserid,");
        cusSentSql.append("             flastupdatetime,              \r\n");
        cusSentSql.append("             funverifiedamtfor,");
        cusSentSql.append("             funholdedamtfor,");
        cusSentSql.append("             funverifiedamtlocal,");
        cusSentSql.append("             funholdedamtlocal,");
        cusSentSql.append("             funverifiedamtrpt,");
        cusSentSql.append("             funholdedamtrpt,");
        cusSentSql.append("             fmeasureunitid,");
        cusSentSql.append("             funverifiedqty,");
        cusSentSql.append("             funholdedqty,");
        cusSentSql.append("             funverifiedstdqty,");
        cusSentSql.append("             funholdedstdqty,               \r\n");
        cusSentSql.append("    FAssGrpID,FVARBizDate,FendDate, \r\n");
        cusSentSql.append("    Fquantity,ForiginalAmount,FlocalAmount,FreportingAmount, \r\n");
        cusSentSql.append("\t   FsettlementTypeID,FsettlementCode,FbizNumber,\r\n");
        cusSentSql.append("\t   FcustomerID,FsupplierID,ForgUnitID,FmaterialID,\r\n");
        cusSentSql.append("\t   FticketNumber,FinvoiceNumber,FfeeType, \r\n  ");
        cusSentSql.append("    FIsVierified,FEntryDC,FIsPost,FBookedDate,FVchNumber,FDescription,FVoucherTypeId)");
        cusSentSql.append(" SELECT Newbosid('CE2D850A'),");
        cusSentSql.append("        a.fcompanyid,");
        cusSentSql.append("        b.fnewacctid,");
        cusSentSql.append("        a.fcurrencyid,");
        cusSentSql.append("        1,");
        cusSentSql.append("        1,");
        cusSentSql.append("        a.fvchassistrecordid oldid, ");
        cusSentSql.append("        '" + curPeriod + "',");
        cusSentSql.append("        '11111111',");
        cusSentSql.append("        fcreatorid,");
        cusSentSql.append("        fcreatetime,");
        cusSentSql.append("        flastupdateuserid,");
        cusSentSql.append("        flastupdatetime,");
        cusSentSql.append("        funverifiedamtfor,");
        cusSentSql.append("        funholdedamtfor,");
        cusSentSql.append("        funverifiedamtlocal,");
        cusSentSql.append("        funholdedamtlocal,");
        cusSentSql.append("        funverifiedamtrpt,");
        cusSentSql.append("        funholdedamtrpt,");
        cusSentSql.append("        fmeasureunitid,");
        cusSentSql.append("        funverifiedqty,");
        cusSentSql.append("        funholdedqty,");
        cusSentSql.append("        funverifiedstdqty,");
        cusSentSql.append("        funholdedstdqty,");
        cusSentSql.append("    FAssGrpID,FVARBizDate,FendDate, \r\n");
        cusSentSql.append("    Fquantity,ForiginalAmount,FlocalAmount,FreportingAmount, \r\n");
        cusSentSql.append("\t   FsettlementTypeID,FsettlementCode,FbizNumber,\r\n");
        cusSentSql.append("\t   FcustomerID,FsupplierID,ForgUnitID,FmaterialID,\r\n");
        cusSentSql.append("\t   FticketNumber,FinvoiceNumber,FfeeType, \r\n  ");
        cusSentSql.append("    FIsVierified,FEntryDC,FIsPost,FBookedDate,FVchNumber,FDescription,FVoucherTypeId");
        cusSentSql.append(" FROM   ").append(this.actTable).append(" a,");
        cusSentSql.append("        t_bd_acctrefcontrastentry b");
        cusSentSql.append(" WHERE  b.facctrefcontrastid = '" + acrefID + "'");
        cusSentSql.append("        AND a.faccountid = b.foldacctid");
        cusSentSql.append("        AND a.fcompanyid = '" + companyID + "'");
        cusSentSql.append("        AND a.funverifiedamtfor <> 0 ");
        if (!StringUtils.isEmpty((String)acStr)) {
            cusSentSql.append("        AND a.faccountid in(" + acStr + ")");
        }
        DbUtil.execute((Context)ctx, (String)cusSentSql.toString());
    }

    private void upateAcctData(Context ctx, String companyID, String curPeriod, String acrefID) throws BOSException, EASBizException {
        String cusTemple = null;
        String accountTemp = null;
        try {
            cusTemple = this.createTempleForCus(ctx, companyID, curPeriod);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ").append(this.actTable).append(" act SET fvchassistrecordid = (SELECT tem.FnewID from ").append(cusTemple);
            sql.append(" tem where tem.FoldId = act.fvchassistrecordid and tem.FnewId is not null ) ");
            sql.append(" where fsourcebillid='11111111' and fcompanyid='").append(companyID).append("' and fperiodid='").append(curPeriod).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            accountTemp = this.createTempleForAccountRef(ctx, companyID, cusTemple);
            sql = new StringBuffer();
            String newAcctTable = super.getNewAcctTableID(ctx, acrefID);
            sql.append(" select distinct temp.fnewaccountid as newAcctID,temp.foldaccountid as oldAcctID,temp.fnewassistid as recordID,newAcct.fcaa as newCaa,oldAcct.fcaa as oldcaa ");
            sql.append(" from ").append(accountTemp).append(" temp ");
            sql.append(" inner join t_bd_accountview newAcct on newAcct.fid = temp.fnewaccountid ");
            sql.append(" inner join t_bd_accountview oldAcct on oldAcct.fid = temp.foldAccountid ");
            sql.append(" where  newAcct.faccounttableid='").append(newAcctTable).append("'");
            sql.append(" and oldAcct.fcaa <> newAcct.fcaa ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            CoreBaseCollection vrColl = this.genVoucherRecord(ctx, rs);
            ORMEngine.updateColl((Context)ctx, (IObjectCollection)vrColl, (String[])new String[]{"assGrp"});
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update ").append(this.actTable).append(" act set fassgrpid = \r\n");
            updateSql.append("(select assist.fassgrpid from t_gl_voucherassistrecord assist where assist.fid = act.fvchassistrecordid) \r\n");
            updateSql.append(" where act.fsourcebillid = '11111111' \r\n");
            updateSql.append(" and act.fcompanyid = '").append(companyID).append("'\r\n");
            updateSql.append(" and act.fperiodid = '").append(curPeriod).append("' \r\n");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
                if (!StringUtils.isEmpty((String)cusTemple)) {
                    iPool.releaseTable(cusTemple);
                }
                if (!StringUtils.isEmpty(accountTemp)) {
                    iPool.releaseTable(accountTemp);
                }
                throw throwable;
            }
        }
        TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)cusTemple)) {
            iPool.releaseTable(cusTemple);
        }
        if (!StringUtils.isEmpty((String)accountTemp)) {
            iPool.releaseTable(accountTemp);
        }
    }

    private CoreBaseCollection genVoucherRecord(Context ctx, IRowSet rs) throws SQLException, BOSException, EASBizException {
        IVoucherFacade iVoucherFacade = VoucherFacadeFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection vrColl = new CoreBaseCollection();
        VoucherAssistRecordCollection vrCollection = new VoucherAssistRecordCollection();
        HashMap<String, Object[]> cache = new HashMap<String, Object[]>();
        HashMap cache2 = new HashMap();
        IVoucherAssistRecord vr = VoucherAssistRecordFactory.getLocalInstance(ctx);
        ArrayList recordIdList = new ArrayList();
        HashSet<String> recordIdSet = new HashSet<String>();
        int index = 0;
        while (rs.next()) {
            recordIdSet.add(rs.getString("recordID"));
            if (++index % 400 != 0) continue;
            recordIdList.add(recordIdSet);
            recordIdSet = new HashSet();
        }
        recordIdList.add(recordIdSet);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add("*");
        selectors.add("assGrp.*");
        for (int i = 0; i < recordIdList.size(); ++i) {
            Set idSet = (Set)recordIdList.get(i);
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            VoucherAssistRecordCollection coll = vr.getVoucherAssistRecordCollection(view);
            if (coll.size() <= 0) continue;
            vrCollection.addCollection(coll);
        }
        rs.beforeFirst();
        while (rs.next()) {
            Object[] info;
            AssistantHGInfo newHGInfo;
            AssistantHGInfo hgInfo;
            String newCaa = rs.getString("newCaa");
            String oldCaa = rs.getString("oldCaa");
            String oldAcctID = rs.getString("oldAcctID");
            String newAcctID = rs.getString("newAcctID");
            if (newCaa.equals(oldCaa)) continue;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("assGrp.*");
            VoucherAssistRecordInfo vrInfo = vrCollection.get((Object)BOSUuid.read((String)rs.getString("recordID")));
            if (vrInfo == null) {
                vrInfo = (VoucherAssistRecordInfo)vr.getBillBaseInfo((IObjectPK)new ObjectUuidPK(rs.getString("recordID")), selector);
            }
            if ((hgInfo = vrInfo.getAssGrp()) == null) {
                this.mylog.error((Object)("not find hginfo`s voucherassistrecordid:" + vrInfo.getId()));
                newHGInfo = new AssistantHGInfo();
            } else {
                newHGInfo = hgInfo;
            }
            newHGInfo.setId(null);
            AsstAccountInfo type = new AsstAccountInfo();
            type.setId(BOSUuid.read((String)newCaa));
            newHGInfo.setAsstAccount(type);
            String key = newAcctID.toString() + oldAcctID.toString();
            DefaultAssistantHgValue value = this.asstActObjectMap.get(key);
            if (value != null) {
                Map<String, IObjectValue> objValueMap = value.getDefaultValueMap();
                Set<String> set = objValueMap.keySet();
                Iterator<String> it = set.iterator();
                while (it.hasNext()) {
                    String atr = it.next().toString();
                    IObjectValue objValue = objValueMap.get(atr);
                    if (objValue == null) continue;
                    newHGInfo.put(atr, (Object)objValue);
                }
            }
            if ((info = (Object[])cache.get(key)) == null) {
                info = iVoucherFacade.fetchAssColumnInfo(newAcctID.toString(), newCaa.toString(), null);
                cache.put(key, info);
            }
            VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
            for (int i = 0; i < assItemCols.length; ++i) {
                VoucherInfo.DynamicColumnInfo colInfo = assItemCols[i];
                newHGInfo.put(colInfo.getMappingPropName(), newHGInfo.get(colInfo.getMappingPropName()));
            }
            String key2 = newHGInfo.toString() + newCaa;
            AssistantHGInfo newHGInfo2 = (AssistantHGInfo)this.hgMapCache.get((Object)key2);
            if (newHGInfo2 == null) {
                newHGInfo.put("aatok", (Object)true);
                newHGInfo.setId(BOSUuid.create((BOSObjectType)newHGInfo.getBOSType()));
                newHGInfo2 = iVoucherFacade.confirmAssGrp(newHGInfo, newCaa, assItemCols);
                this.hgMapCache.put((Object)key2, (Object)newHGInfo2);
            }
            vrInfo.setAssGrp(newHGInfo2);
            vrColl.add((CoreBaseInfo)vrInfo);
        }
        return vrColl;
    }

    public String createTempleForCus(Context ctx, String companyID, String periodID) throws BOSException {
        String tempTableName = "Gl_AcctRef_Temp";
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table ");
        createSql.append(tempTableName);
        createSql.append("(");
        createSql.append("FnewID \tVARCHAR(44), ");
        createSql.append("FoldID\tVARCHAR(44), ");
        createSql.append("FAccountID VARCHAR(44) ");
        createSql.append(")");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createSql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTable, "FoldID", false, false);
        }
        catch (Exception e) {
            this.mylog.error((Object)"create temp table error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(tempTable);
        insertSql.append("(fnewid,foldId,FAccountID) select distinct vas.fid as FnewID,vas.Fsourcebillid as FoldID,cus.faccountid ");
        insertSql.append("from T_gl_voucherassistrecord vas ");
        insertSql.append("inner join ").append(this.actTable).append(" cus ");
        insertSql.append("on vas.Fsourcebillid= cus.fvchassistrecordid ");
        insertSql.append("where cus.fcompanyid='" + companyID + "' ");
        insertSql.append("and cus.fsourcebillid='11111111' ");
        insertSql.append("and cus.fperiodid='" + periodID + "' ");
        insertSql.append("and vas.FSOURCEFUNCTION='CussentAcctRef' ");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        return tempTable;
    }

    private String createTempleForAccountRef(Context ctx, String companyID, String tempCusTable) throws BOSException {
        String tempTableName = "Gl_AcctRef_Account_Temp";
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table ");
        createSql.append(tempTableName);
        createSql.append("(");
        createSql.append("FnewAccountID VARCHAR(44), ");
        createSql.append("FOldAccountID\tVARCHAR(44), ");
        createSql.append("FNewAssistID VARCHAR(44),");
        createSql.append("FOldAssistID VARCHAR(44) ");
        createSql.append(")");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createSql.toString());
        }
        catch (Exception e) {
            this.mylog.error((Object)"create temp table error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(tempTable);
        insertSql.append("(FnewAccountID,FOldAccountID,FNewAssistID,FOldAssistID) ");
        insertSql.append("select temp.faccountid as FnewAccountID,cus.faccountid as FOldAccountID,temp.fnewid FNewAssistID, temp.foldid FOldAssistID");
        insertSql.append(" from ").append(tempCusTable).append(" temp ");
        insertSql.append("inner join ").append(this.actTable).append(" cus ");
        insertSql.append("on temp.foldid = cus.fvchassistrecordid ");
        insertSql.append("where cus.fcompanyid='").append(companyID).append("' ");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        return tempTable;
    }

    private void deleteTransAcctCussent(Context ctx, String companyID, String acrefID, PeriodInfo perInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from t_gl_voucherassistrecord where fid in(");
        sql.append("select fvchassistrecordid from t_gl_acctcussent where ");
        sql.append(" t_gl_acctcussent.FPeriodID ='").append(perInfo.getId().toString()).append("'");
        sql.append(" and t_gl_acctcussent.fsourcebillid='11111111' and t_gl_acctcussent.fcompanyid = '").append(companyID).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        sql.append("delete from t_gl_acctcussent where fperiodid='").append(perInfo.getId().toString()).append("'");
        sql.append(" and fsourcebillid='11111111' and fcompanyid = '").append(companyID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        sql.append("delete from t_gl_voucherassistrecord where fid in(");
        sql.append("select fvchassistrecordid from t_gl_acctverify where ");
        sql.append(" t_gl_acctverify.FPeriodID ='").append(perInfo.getId().toString()).append("'");
        sql.append(" and t_gl_acctverify.fsourcebillid='11111111' and t_gl_acctverify.fcompanyid = '").append(companyID).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        sql.append("delete from t_gl_acctverify where fperiodid='").append(perInfo.getId().toString()).append("'");
        sql.append(" and fsourcebillid='11111111' and fcompanyid = '").append(companyID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void createAsstActGroupDetailMap(Context ctx, IRowSet set) throws BOSException {
        this.asstActGroupDetailMap = new HashMap();
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (set.next()) {
                String oldCaa = set.getString("srccaa");
                String newCaa = set.getString("descaa");
                if (!StringUtils.isEmpty((String)oldCaa)) {
                    idSet.add(oldCaa);
                }
                if (StringUtils.isEmpty((String)newCaa)) continue;
                idSet.add(newCaa);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        AsstActGroupDetailCollection rels = new AsstActGroupDetailCollection();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        StringBuffer idSetStr = new StringBuffer();
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        Iterator it = idSet.iterator();
        idSetStr.append("'").append(it.next()).append("'");
        while (it.hasNext()) {
            idSetStr.append(",'").append(it.next()).append("'");
        }
        fic.add(new FilterItemInfo("asstAccount.id", (Object)idSetStr.toString(), CompareType.INNER));
        rels = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        for (int i = 0; i < rels.size(); ++i) {
            List<AsstActTypeInfo> asstActTypeList;
            AsstAccountInfo asstAccount = rels.get(i).getAsstAccount();
            String asstAccountId = asstAccount.getId().toString();
            if (this.asstActGroupDetailMap.get(asstAccountId) != null) {
                asstActTypeList = (List)this.asstActGroupDetailMap.get(asstAccountId);
                asstActTypeList.add(rels.get(i).getAsstActType());
                continue;
            }
            asstActTypeList = new ArrayList<AsstActTypeInfo>();
            asstActTypeList.add(rels.get(i).getAsstActType());
            this.asstActGroupDetailMap.put(asstAccountId, asstActTypeList);
        }
    }

    private void createAssistantHGInfoMap(Context ctx, IRowSet assistSet, String oldCaa) throws BOSException {
        if (StringUtils.isEmpty((String)oldCaa)) {
            return;
        }
        this.assistantHGInfoMap = new HashMap();
        IAssistantHG assistanthg = AssistantHGFactory.getLocalInstance((Context)ctx);
        HashSet<String> idSet = new HashSet<String>();
        try {
            assistSet.beforeFirst();
            while (assistSet.next()) {
                String hgFid = assistSet.getString("hgFid");
                idSet.add(hgFid);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("asstAccount.id"));
        List asstActTypeList = (List)this.asstActGroupDetailMap.get(oldCaa);
        if (asstActTypeList != null && asstActTypeList.size() > 0) {
            for (int i = 0; i < asstActTypeList.size(); ++i) {
                AsstActTypeInfo asstActType = (AsstActTypeInfo)asstActTypeList.get(i);
                String attr = asstActType.getAsstHGAttribute();
                selectors.add(attr + ".id");
                selectors.add(attr + ".name");
                if ("provider".equals(attr) || "customer".equals(attr)) {
                    selectors.add(attr + ".browseGroup.displayName");
                } else if ("material".equals(asstActType.getAsstHGAttribute())) {
                    selectors.add(attr + ".materialGroup.displayName");
                } else if (asstActType.isIsMultilevel()) {
                    selectors.add(attr + ".displayName");
                }
                selectors.add(attr + ".number");
            }
        }
        List<List<String>> idList = this.split(new ArrayList<String>(idSet), 400);
        for (int i = 0; i < idList.size(); ++i) {
            List<String> ids = idList.get(i);
            HashSet<String> set = new HashSet<String>(ids);
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            AssistantHGCollection assistantHgColl = assistanthg.getAssistantHGCollection(view);
            for (int j = 0; j < assistantHgColl.size(); ++j) {
                AssistantHGInfo hg = assistantHgColl.get(j);
                String hgFid = hg.getId().toString();
                this.assistantHGInfoMap.put(hgFid, assistantHgColl.get(j));
            }
        }
    }

    private List<List<String>> split(List<String> set, int size) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        if (set.size() <= size) {
            ArrayList<String> part = new ArrayList<String>();
            part.addAll(set);
            list.add(part);
        } else {
            ArrayList<String> part = new ArrayList<String>();
            for (String str : set) {
                part.add(str);
                if (part.size() < size) continue;
                list.add(part);
                part = new ArrayList();
            }
            if (part.size() > 0) {
                list.add(part);
            }
        }
        return list;
    }

    class DefaultAssistantHgValue {
        private String key;
        private Map<String, IObjectValue> defaultValueMap = new HashMap<String, IObjectValue>();

        DefaultAssistantHgValue() {
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setDefaultValueMap(Map<String, IObjectValue> defaultValueMap) {
            this.defaultValueMap = defaultValueMap;
        }

        public Map<String, IObjectValue> getDefaultValueMap() {
            return this.defaultValueMap;
        }
    }
}

