/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastUtil;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CussentStatusEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLBalanceRepairFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.IVoucherFacade;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractGLAccountRefContrastProcessFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLBalanceFacadeControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LRUMap;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLAccountRefContrastProcessFacadeControllerBean
extends AbstractGLAccountRefContrastProcessFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLAccountRefContrastProcessFacadeControllerBean");
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";
    private Map asstActGroupDetailMap;
    private Map assistantHGInfoMap;
    private Map<String, DefaultAssistantHgValue> asstActObjectMap = new HashMap<String, DefaultAssistantHgValue>();
    private boolean opposite = false;
    private BigDecimal transCoefficient = new BigDecimal("-1");
    private LRUMap hgMapCache = new LRUMap();
    private int maxCacheSize = 10000;
    private boolean isQtyAsst = true;
    public BigDecimal zero = new BigDecimal(0);
    public BigDecimal one = new BigDecimal(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _transfer(Context ctx, Map params) throws BOSException, EASBizException {
        MutexParameter mp = null;
        IMutexServiceControl mutex = null;
        try {
            String refId;
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            ParamItemInfo isQtyAsstInfo = pc.getParamItemByNumberAndOrg("G010", null);
            if (isQtyAsstInfo != null) {
                this.isQtyAsst = Boolean.valueOf(isQtyAsstInfo.toString());
            }
            IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
            VoucherCollection voucherColl = new VoucherCollection();
            HashMap<String, Object> result = new HashMap<String, Object>();
            String companyId = (String)params.get("companyId");
            Integer periodNumber = (Integer)params.get("periodNumber");
            PeriodInfo periodInfo = (PeriodInfo)params.get("periodInfo");
            PeriodInfo periodTo = GlUtils.getCurrentPeriod(ctx, companyId);
            ObjectUuidPK pk = new ObjectUuidPK(companyId);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk, sic);
            String voucherTypeId = this.getVoucherType(ctx);
            IVoucherType voucherType = VoucherTypeFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK typePK = new ObjectUuidPK(BOSUuid.read((String)voucherTypeId));
            VoucherTypeInfo voucherTypeInfo = voucherType.getVoucherTypeInfo((IObjectPK)typePK);
            IPeriod period = PeriodFactory.getLocalInstance((Context)ctx);
            String descri975 = ResourceBase.getString((String)RESOURCE, (String)"975_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri976 = ResourceBase.getString((String)RESOURCE, (String)"976_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri977 = ResourceBase.getString((String)RESOURCE, (String)"977_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri978 = ResourceBase.getString((String)RESOURCE, (String)"978_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri979 = ResourceBase.getString((String)RESOURCE, (String)"979_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri980 = ResourceBase.getString((String)RESOURCE, (String)"980_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri981 = ResourceBase.getString((String)RESOURCE, (String)"981_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri982 = ResourceBase.getString((String)RESOURCE, (String)"982_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri983 = ResourceBase.getString((String)RESOURCE, (String)"983_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri984 = ResourceBase.getString((String)RESOURCE, (String)"984_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri985 = ResourceBase.getString((String)RESOURCE, (String)"985_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri986 = ResourceBase.getString((String)RESOURCE, (String)"986_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            String descri987 = ResourceBase.getString((String)RESOURCE, (String)"987_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            boolean isTry = true;
            Object o = params.get("isTry");
            if (o != null) {
                String str = o.toString();
                isTry = str.equals("true");
            }
            if (StringUtils.isEmpty((String)(refId = GLAccountRefContrastProcessFacadeControllerBean.getAccountRefConstrastId(ctx, companyId, periodNumber)))) {
                result.put("error", this.getResource(ctx, "not_accountview_ref_relation"));
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            ArrayList<IObjectPK> pkList = new ArrayList<IObjectPK>();
            StringBuffer assActDefaultSql = new StringBuffer();
            assActDefaultSql.append("SELECT TYPE.fassthgattribute AS attribute,");
            assActDefaultSql.append("        def.fdefaultid AS defaultvalue,");
            assActDefaultSql.append("        refentry.fnewacctid AS nweacctid,");
            assActDefaultSql.append("        refentry.foldacctid AS oldacctid");
            assActDefaultSql.append(" FROM   t_bd_acctrefcontrastentry refentry");
            assActDefaultSql.append("        INNER JOIN t_ac_acctrefcontrastentrydef def ON refentry.fid = def.fparentid");
            assActDefaultSql.append("        INNER JOIN t_bd_asstacttype TYPE ON def.fasstacttypeid = TYPE.fid");
            assActDefaultSql.append(" WHERE  refentry.facctrefcontrastid = '" + refId + "'");
            IRowSet defSet = DbUtil.executeQuery((Context)ctx, (String)assActDefaultSql.toString());
            try {
                while (defSet.next()) {
                    DefaultAssistantHgValue value;
                    String key = defSet.getString("nweacctid") + defSet.getString("oldacctid");
                    String attribute = defSet.getString("attribute");
                    IObjectValue objValue = (IObjectValue)this.getAsstActObject(ctx, defSet.getString("defaultvalue"));
                    if (this.asstActObjectMap.get(key) == null) {
                        value = new DefaultAssistantHgValue();
                        value.setKey(key);
                        value.getDefaultValueMap().put(attribute, objValue);
                        this.asstActObjectMap.put(value.getKey(), value);
                        continue;
                    }
                    value = this.asstActObjectMap.get(key);
                    value.getDefaultValueMap().put(attribute, objValue);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            HashSet<String> needRepairAcct = new HashSet<String>();
            HashSet<String> repairAcct = new HashSet<String>();
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct srcacct.fdc as srcdc, \r\n");
            sql.append("desacct.fdc as desdc, \r\n");
            sql.append("srcAcct.fmeasureunitid as srcmeasureunit, \r\n");
            sql.append("desacct.fmeasureunitid as desmeasureunit, \r\n");
            sql.append("srcacct.fmeasureunitgroupid as srcmeasureunitgroup, \r\n");
            sql.append("desacct.fmeasureunitgroupid as desmeasureunitgroup, \r\n");
            sql.append("refentry.foldacctid as srcacctid, \r\n");
            sql.append("refentry.fnewacctid as desacctid, \r\n");
            sql.append("bal.fcurrencyid as currencyid, \r\n");
            sql.append("cy.fprecision, \r\n");
            sql.append("cy.fname_l2 as currencyname, \r\n");
            sql.append("bal.fendbalancefor, \r\n");
            sql.append("bal.fendbalancelocal, \r\n");
            sql.append("bal.fendbalancerpt, \r\n");
            sql.append("bal.fendqty as quantity, \r\n");
            sql.append("srcacct.fisqty as srcisqty, \r\n");
            sql.append("desacct.fisqty as desisqty, \r\n");
            sql.append("srcacct.fcaa as srccaa, \r\n");
            sql.append("desacct.fcaa as descaa, \r\n");
            sql.append("srcacct.fnumber as srcacctnumber, \r\n");
            sql.append("desacct.fnumber as desacctnumber \r\n");
            sql.append("from t_gl_accountbalance_5f bal \r\n");
            sql.append("inner join t_bd_currency cy on cy.fid = bal.fcurrencyid \r\n");
            sql.append("inner join t_bd_acctrefcontrastentry refentry on bal.faccountid = refentry.foldacctid \r\n");
            sql.append("left outer join t_bd_accountview srcacct on srcacct.fid = refentry.foldacctid \r\n");
            sql.append("left outer join t_bd_accountview desacct on desacct.fid = refentry.fnewacctid \r\n");
            sql.append("where refentry.foldacctid = bal.faccountid \r\n");
            sql.append("and srcacct.fisleaf = 1 \r\n");
            sql.append("and bal.forgunitid = ? \r\n");
            sql.append("and (bal.fendbalancefor <> 0 or bal.fendbalancelocal <> 0 or (bal.fendbalancefor = 0 and ");
            sql.append("exists (select 1 from t_gl_assistbalance_5f asb where asb.faccountid = bal.faccountid ");
            sql.append("and asb.fperiod = bal.fperiod ");
            sql.append("and asb.fcurrencyid = bal.fcurrencyid and asb.forgunitid = bal.forgunitid ");
            sql.append("and asb.fendbalancefor <> 0))) ");
            sql.append("and fperiod = ? \r\n");
            sql.append("and refentry.facctrefcontrastid = ? \r\n");
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodNumber, refId});
            try {
                while (set.next()) {
                    String srcacctnumber = set.getString("srcacctnumber");
                    needRepairAcct.add(srcacctnumber);
                    String desacctnumber = set.getString("desacctnumber");
                    repairAcct.add(srcacctnumber);
                    repairAcct.add(desacctnumber);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (needRepairAcct == null || needRepairAcct.size() == 0) {
                result.put("error", this.getResource(ctx, "not_error_data_to_repair"));
                HashMap<String, Object> e = result;
                return e;
            }
            try {
                set.beforeFirst();
                this.createAsstActGroupDetailMap(ctx, set);
                set.beforeFirst();
                while (set.next()) {
                    int desadc;
                    VoucherInfo vInfo = new VoucherInfo();
                    VoucherEntryCollection vEntryCollection = new VoucherEntryCollection();
                    VoucherEntryInfo enInfo = new VoucherEntryInfo();
                    VoucherEntryInfo newEnInfo = new VoucherEntryInfo();
                    BigDecimal balAmount = set.getBigDecimal("fendBalanceFor");
                    BigDecimal balLocalAmount = set.getBigDecimal("fendBalancelocal");
                    BigDecimal balRptAmount = set.getBigDecimal("fendBalancerpt");
                    int adc = set.getInt("srcdc");
                    if (adc != (desadc = set.getInt("desdc"))) {
                        logger.info((Object)("error:" + adc + "," + desadc));
                    }
                    if (balAmount.doubleValue() != 0.0) {
                        enInfo.setLocalExchangeRate(set.getBigDecimal("fendBalancelocal").divide(balAmount, 10, 4));
                        enInfo.setReportingExchangeRate(set.getBigDecimal("fendBalancerpt").divide(balAmount, 10, 4));
                        newEnInfo.setLocalExchangeRate(set.getBigDecimal("fendBalancelocal").divide(balAmount, 10, 4));
                        newEnInfo.setReportingExchangeRate(set.getBigDecimal("fendBalancerpt").divide(balAmount, 10, 4));
                    }
                    this.opposite = false;
                    if (adc == 1) {
                        enInfo.setEntryDC(EntryDC.CREDIT);
                        newEnInfo.setEntryDC(EntryDC.DEBIT);
                    } else {
                        enInfo.setEntryDC(EntryDC.DEBIT);
                        newEnInfo.setEntryDC(EntryDC.CREDIT);
                        this.opposite = true;
                        if (balAmount.compareTo(BigDecimal.ZERO) != 0) {
                            balAmount = balAmount.multiply(this.transCoefficient);
                        }
                        if (balLocalAmount.compareTo(BigDecimal.ZERO) != 0) {
                            balLocalAmount = balLocalAmount.multiply(this.transCoefficient);
                        }
                        if (balRptAmount.compareTo(BigDecimal.ZERO) != 0) {
                            balRptAmount = balRptAmount.multiply(this.transCoefficient);
                        }
                    }
                    enInfo.setOriginalAmount(balAmount);
                    enInfo.setLocalAmount(balLocalAmount);
                    enInfo.setReportingAmount(balRptAmount);
                    newEnInfo.setOriginalAmount(balAmount);
                    newEnInfo.setLocalAmount(balLocalAmount);
                    newEnInfo.setReportingAmount(balRptAmount);
                    AccountViewInfo oldAcctInfo = new AccountViewInfo();
                    String oldAcctID = set.getString("srcAcctID");
                    oldAcctInfo.setId(BOSUuid.read((String)oldAcctID));
                    String oldAcctNumber = set.getString("srcAcctNumber");
                    oldAcctInfo.setNumber(oldAcctNumber);
                    String newAcctID = set.getString("desAcctID");
                    AccountViewInfo newAcctInfo = new AccountViewInfo();
                    newAcctInfo.setId(BOSUuid.read((String)newAcctID));
                    String newAcctNumber = set.getString("desAcctNumber");
                    newAcctInfo.setNumber(newAcctNumber);
                    enInfo.setAccount(oldAcctInfo);
                    newEnInfo.setAccount(newAcctInfo);
                    String oldCaa = set.getString("srccaa");
                    String newCaa = set.getString("descaa");
                    if (oldCaa != null) {
                        BOSUuid oldCaaId = BOSUuid.read((String)oldCaa);
                        AsstAccountInfo oldAsstacc = new AsstAccountInfo();
                        oldAsstacc.setId(oldCaaId);
                        oldAcctInfo.setCAA(oldAsstacc);
                        enInfo.setCAA(oldAsstacc);
                    }
                    if (newCaa != null) {
                        BOSUuid newCaaId = BOSUuid.read((String)newCaa);
                        AsstAccountInfo newAsstacc = new AsstAccountInfo();
                        newAsstacc.setId(newCaaId);
                        newAcctInfo.setCAA(newAsstacc);
                        newEnInfo.setCAA(newAsstacc);
                    }
                    CurrencyInfo currencyInfo = new CurrencyInfo();
                    currencyInfo.setId(BOSUuid.read((String)set.getString("currencyID")));
                    currencyInfo.setName(set.getString("currencyName"));
                    currencyInfo.setPrecision(set.getInt("fprecision"));
                    enInfo.setCurrency(currencyInfo);
                    newEnInfo.setCurrency(currencyInfo);
                    enInfo.setDescription(descri975);
                    newEnInfo.setDescription(descri976);
                    enInfo.setSeq(1);
                    newEnInfo.setSeq(2);
                    enInfo.setOprStatus(1);
                    newEnInfo.setOprStatus(1);
                    enInfo.setCussent(CussentStatusEnum.NONE);
                    newEnInfo.setCussent(CussentStatusEnum.NONE);
                    AccountRefContrastUtil util = new AccountRefContrastUtil();
                    boolean isMuForAcct = true;
                    MeasureUnitInfo srcMInfo = null;
                    MeasureUnitInfo desMInfo = null;
                    String srcmeasureUnit = set.getString("srcMeasureUnit");
                    String desmeasureUnit = set.getString("desMeasureUnit");
                    if (isMuForAcct && srcmeasureUnit != null) {
                        srcMInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)srcmeasureUnit)));
                    }
                    if (isMuForAcct && desmeasureUnit != null) {
                        desMInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)desmeasureUnit)));
                    }
                    if (srcmeasureUnit != null) {
                        enInfo.setMeasureUnit(srcMInfo);
                    }
                    if (desmeasureUnit != null) {
                        newEnInfo.setMeasureUnit(desMInfo);
                    }
                    int oldIsQty = set.getInt("srcIsQty");
                    int newIsQty = set.getInt("desIsQty");
                    BigDecimal quantity = set.getBigDecimal("quantity");
                    if (this.opposite) {
                        quantity = quantity.multiply(this.transCoefficient);
                    }
                    if (newIsQty != 0 && oldIsQty != 0) {
                        BigDecimal srcTransQty = quantity;
                        if (srcMInfo != null) {
                            srcTransQty = quantity.divide(srcMInfo.getCoefficient(), 4, RoundingMode.HALF_UP);
                        }
                        enInfo.setQuantity(srcTransQty);
                        enInfo.setStandardQuantity(srcTransQty);
                        enInfo.setPrice(balAmount.divide(srcTransQty.compareTo(this.zero) == 0 ? this.one : srcTransQty, 4, RoundingMode.HALF_UP));
                        BigDecimal desTransQty = quantity;
                        if (desMInfo != null) {
                            desTransQty = quantity.divide(desMInfo.getCoefficient(), 4, RoundingMode.HALF_UP);
                        }
                        newEnInfo.setQuantity(desTransQty);
                        newEnInfo.setStandardQuantity(desTransQty);
                        newEnInfo.setPrice(balAmount.divide(desTransQty.compareTo(this.zero) == 0 ? this.one : desTransQty, 4, RoundingMode.HALF_UP));
                    }
                    VoucherAssistRecordCollection vAssistRecordColl = new VoucherAssistRecordCollection();
                    VoucherAssistRecordCollection newVAssistRecordColl = new VoucherAssistRecordCollection();
                    HashMap map = this.getAssistRecordColl(ctx, enInfo, newEnInfo, oldCaa, newCaa, oldAcctID, newAcctID, oldIsQty, balAmount, srcMInfo, desMInfo, companyId, periodInfo);
                    vAssistRecordColl = (VoucherAssistRecordCollection)map.get("oldCollection");
                    newVAssistRecordColl = (VoucherAssistRecordCollection)map.get("newCollection");
                    if (oldCaa != null && newCaa == null && newIsQty != 0 && oldIsQty != 0) {
                        BigDecimal sumQty;
                        BigDecimal newQty = sumQty = (BigDecimal)map.get("sumQty");
                        if (desMInfo != null) {
                            newQty = sumQty.divide(desMInfo.getCoefficient(), 4, RoundingMode.HALF_UP);
                        }
                        newEnInfo.setQuantity(newQty);
                        newEnInfo.setStandardQuantity(newQty);
                        newEnInfo.setPrice(balAmount.divide(newQty.compareTo(this.zero) == 0 ? this.one : newQty, 4, RoundingMode.HALF_UP));
                    }
                    if (newCaa != null && newIsQty != 0 && this.isQtyAsst) {
                        newEnInfo.setMeasureUnit(null);
                        newEnInfo.setPrice(null);
                    }
                    if (oldCaa != null && oldIsQty != 0 && this.isQtyAsst) {
                        enInfo.setMeasureUnit(null);
                        enInfo.setPrice(null);
                    }
                    if (oldCaa != null) {
                        enInfo.getAssistRecords().addCollection(vAssistRecordColl);
                    }
                    if (newCaa != null) {
                        if (oldCaa == null) {
                            VoucherAssistRecordInfo newAssistRecodInfo = newVAssistRecordColl.get(0);
                            newAssistRecodInfo.setOriginalAmount(newEnInfo.getOriginalAmount());
                            newAssistRecodInfo.setLocalAmount(newEnInfo.getLocalAmount());
                            newAssistRecodInfo.setReportingAmount(newEnInfo.getReportingAmount());
                        }
                        newEnInfo.getAssistRecords().addCollection(newVAssistRecordColl);
                    }
                    enInfo.setIsHand(false);
                    newEnInfo.setIsHand(false);
                    enInfo.setBill(vInfo);
                    newEnInfo.setBill(vInfo);
                    vInfo.setCurrency(newEnInfo.getCurrency());
                    vEntryCollection.add(enInfo);
                    vEntryCollection.add(newEnInfo);
                    vInfo.setEntries((AbstractObjectCollection)vEntryCollection);
                    if (vEntryCollection.size() > 0) {
                        vInfo.setVoucherAbstract(vEntryCollection.get(0).getDescription());
                    }
                    vInfo.setEntryCount(vEntryCollection.size());
                    vInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                    vInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    vInfo.setCompany(company);
                    vInfo.setPeriod(periodInfo);
                    vInfo.setVoucherType(voucherTypeInfo);
                    vInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
                    vInfo.setBookedDate((Date)vInfo.getPeriod().getEndDate());
                    vInfo.setBizDate((Date)vInfo.getPeriod().getEndDate());
                    vInfo.setSourceType(SourceType.ACCOUNTADJUST);
                    vInfo.setSourceSys(SystemEnum.GENERALLEDGER);
                    vInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    vInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    vInfo.setCalSubmitBal(0);
                    voucherColl.add(vInfo);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            Map repairResult = new HashMap();
            if (!isTry) {
                boolean periodValidate = false;
                Object o1 = params.get("periodValidate");
                if (o1 != null) {
                    String str = o1.toString();
                    periodValidate = str.equals("true");
                }
                for (int i = 0; i < voucherColl.size(); ++i) {
                    VoucherInfo info = voucherColl.get(i);
                    VoucherEntryInfo voucherEntryInfo = info.getEntries().get(0);
                    logger.info((Object)(descri980 + voucherEntryInfo.getAccount().getId() + ",amount:" + voucherEntryInfo.getOriginalAmount()));
                    IObjectPK vPK = null;
                    try {
                        vPK = voucher.submitAccountAdjustVoucher((BaseVoucherInfo)info);
                    }
                    catch (VoucherException e) {
                        logger.error((Object)(descri981 + voucherEntryInfo.getAccount().getNumber() + " FID: " + voucherEntryInfo.getAccount().getId() + descri982 + e.getMessage()), (Throwable)((Object)e));
                        e.printStackTrace();
                        throw e;
                    }
                    pkList.add(vPK);
                }
                this.auditCheckVoucher(ctx, pkList);
                HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>();
                paramMap.put("periodValidate", periodValidate);
                voucher.postVoucherCollection(pkList, paramMap);
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                mp = GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId, "GL_RefBalRep");
                mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                boolean isLockSucceed = mutex.requestMutex(mp);
                if (!isLockSucceed) {
                    throw new BOSException(this.getResource(ctx, "other_thread_updating_balance"));
                }
                String[] companyIds = new String[]{company.getId().toString()};
                GLBalanceFacadeControllerBean b = new GLBalanceFacadeControllerBean();
                b.updateVoucherBalance(ctx, companyIds);
                HashMap<String, Object> repairParams = new HashMap<String, Object>();
                repairParams.put("companyId", companyId);
                repairParams.put("periodfrom", periodInfo);
                repairParams.put("periodto", periodTo);
                repairParams.put("accountNumbers", repairAcct);
                repairParams.put("repairAccount", true);
                repairParams.put("repairAssist", true);
                repairParams.put("repairMeasure", true);
                repairParams.put("onlyClean", false);
                result.put("repairParams", repairParams);
                repairResult = GLBalanceRepairFacadeFactory.getLocalInstance(ctx).repairCompany(repairParams);
            }
            if (repairResult != null && repairResult.size() > 0) {
                result.put("repairResult", repairResult);
            }
            result.put("buildVouchers", voucherColl);
            result.put("needRepairAcct", needRepairAcct);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (mp != null && mutex != null) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    private void auditCheckVoucher(Context ctx, ArrayList pkList) throws BOSException {
        String voStr = ToolUtils.aryToStr((List)pkList, (boolean)true);
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String updateSql = "update t_gl_voucher set fischeck =1 , FBizStatus=3, fauditorid='" + userID + "',  fcashierid='" + userID + "' where\u3000fid in (" + voStr + ") ";
        DbUtil.execute((Context)ctx, (String)updateSql);
        String dpdatesql2 = "update T_GL_VoucherEntry set fischeck =1 , fcashierid= '" + userID + "' where FBillID in (" + voStr + ")";
        DbUtil.execute((Context)ctx, (String)dpdatesql2);
    }

    public String getVoucherType(Context ctx) throws BOSException, EASBizException {
        VoucherTypeInfo info;
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("adminCU.*");
        evi.setSelector(sic);
        IVoucherType v = VoucherTypeFactory.getLocalInstance((Context)ctx);
        String ctrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        ObjectUuidPK ctrlUnitPK = new ObjectUuidPK(ctrlUnit);
        filter = v.getDatabaseDFilter((IObjectPK)ctrlUnitPK, "id", "adminCU.id");
        evi.setFilter(filter);
        VoucherTypeCollection coll = VoucherTypeFactory.getLocalInstance((Context)ctx).getVoucherTypes(ctrlUnit, filter);
        if (coll.size() == 0) {
            String msg = ResourceBase.getString((String)RESOURCE, (String)"1102_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("", msg));
        }
        String msg = ResourceBase.getString((String)RESOURCE, (String)"1103_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!msg.equals(info.getName())) continue;
            return info.getId().toString();
        }
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!info.isPretermit()) continue;
            return info.getId().toString();
        }
        return coll.get(0).getId().toString();
    }

    private IRowSet getAssistSet(Context ctx, String companyId, PeriodInfo period, String accountId, int oldIsQty) throws BOSException {
        StringBuffer assistSql = new StringBuffer();
        assistSql.append("SELECT DISTINCT bal.faccountid AS accountid,");
        assistSql.append("                 bal.fcurrencyid,");
        if (oldIsQty != 0 && this.isQtyAsst) {
            assistSql.append("                 bal.fmeasureunitid,");
        }
        assistSql.append("                 '" + period.getId().toString() + "' fperiodid,");
        assistSql.append("                 5 fbaltype,");
        assistSql.append("                 bal.forgunitid,");
        assistSql.append("                 bal.fassistgrpid,");
        assistSql.append("                 bal.fendqty,");
        assistSql.append("                 bal.fendbalancefor,");
        assistSql.append("                 bal.fendbalancelocal,");
        assistSql.append("                 bal.fendbalancerpt,");
        assistSql.append("                 hg.fid AS hgfid,");
        assistSql.append("                 hg.fasstaccountid AS asstaccountid ");
        if (oldIsQty != 0 && this.isQtyAsst) {
            assistSql.append(" FROM   " + GLBalanceUtils.getAssistMeasureBalanceTable(5) + " bal");
        } else {
            assistSql.append(" FROM   " + GLBalanceUtils.getAssistBalanceTable(5) + " bal");
        }
        assistSql.append("        INNER JOIN t_bd_assistanthg hg ON hg.fid = bal.fassistgrpid");
        assistSql.append("        INNER JOIN t_bd_asstaccount asstype ON hg.fasstaccountid = asstype.fid");
        assistSql.append("        INNER JOIN t_bd_asstactgroupdetail detail ON detail.fasstaccountid = asstype.fid");
        assistSql.append(" WHERE  bal.forgunitid = '" + companyId + "'");
        assistSql.append("        AND (bal.fendbalancefor <> 0 or bal.fendbalancelocal <> 0)");
        assistSql.append("        AND fperiod = " + period.getNumber());
        assistSql.append("        AND faccountid = '" + accountId + "'");
        IRowSet assistSet = DbUtil.executeQuery((Context)ctx, (String)assistSql.toString());
        return assistSet;
    }

    private void createAssistantHGInfoMap(Context ctx, IRowSet assistSet, String oldCaa) throws BOSException {
        if (oldCaa == null) {
            return;
        }
        this.assistantHGInfoMap = new HashMap();
        IAssistantHG assistanthg = AssistantHGFactory.getLocalInstance((Context)ctx);
        HashSet<String> idSet = new HashSet<String>();
        try {
            assistSet.beforeFirst();
            while (assistSet.next()) {
                String hgFid = assistSet.getString("hgFid");
                idSet.add(hgFid);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("asstAccount.id"));
        selectors.add(new SelectorItemInfo("displaynamegroup"));
        List asstActTypeList = (List)this.asstActGroupDetailMap.get(oldCaa);
        if (asstActTypeList != null && asstActTypeList.size() > 0) {
            for (int i = 0; i < asstActTypeList.size(); ++i) {
                AsstActTypeInfo asstActType = (AsstActTypeInfo)asstActTypeList.get(i);
                String attr = asstActType.getAsstHGAttribute();
                selectors.add(attr + ".id");
                selectors.add(attr + ".name");
                if ("provider".equals(attr) || "customer".equals(attr)) {
                    selectors.add(attr + ".browseGroup.displayName");
                } else if ("material".equals(asstActType.getAsstHGAttribute())) {
                    selectors.add(attr + ".materialGroup.displayName");
                } else if (asstActType.isIsMultilevel()) {
                    selectors.add(attr + ".displayName");
                }
                selectors.add(attr + ".number");
            }
        }
        List<List<String>> idList = this.split(new ArrayList<String>(idSet), 400);
        for (int i = 0; i < idList.size(); ++i) {
            List<String> ids = idList.get(i);
            HashSet<String> set = new HashSet<String>(ids);
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            AssistantHGCollection assistantHgColl = assistanthg.getAssistantHGCollection(view);
            for (int j = 0; j < assistantHgColl.size(); ++j) {
                AssistantHGInfo hg = assistantHgColl.get(j);
                String hgFid = hg.getId().toString();
                this.assistantHGInfoMap.put(hgFid, assistantHgColl.get(j));
            }
        }
    }

    private List<List<String>> split(List<String> set, int size) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        if (set.size() <= size) {
            ArrayList<String> part = new ArrayList<String>();
            part.addAll(set);
            list.add(part);
        } else {
            ArrayList<String> part = new ArrayList<String>();
            for (String str : set) {
                part.add(str);
                if (part.size() < size) continue;
                list.add(part);
                part = new ArrayList();
            }
            if (part.size() > 0) {
                list.add(part);
            }
        }
        return list;
    }

    private AssistantHGInfo getHgFromCache(String newCaa, AssistantHGInfo newHgInfo) {
        BOSUuid id = newHgInfo.getId();
        newHgInfo.setId(null);
        String hgCachKey = newHgInfo.toString() + newCaa;
        newHgInfo.setId(id);
        return (AssistantHGInfo)this.hgMapCache.get((Object)hgCachKey);
    }

    private HashMap getAssistRecordColl(Context ctx, VoucherEntryInfo enInfo, VoucherEntryInfo newEnInfo, String oldCaa, String newCaa, String oldAcctid, String newAcctid, int oldIsQty, BigDecimal accountBal, MeasureUnitInfo srcMInfo, MeasureUnitInfo desMInfo, String companyId, PeriodInfo period) throws BOSException, EASBizException {
        IRowSet assistSet = this.getAssistSet(ctx, companyId, period, oldAcctid, oldIsQty);
        this.createAssistantHGInfoMap(ctx, assistSet, oldCaa);
        String key = newAcctid + oldAcctid;
        HashMap<String, Object> map = new HashMap<String, Object>();
        VoucherAssistRecordCollection oldCollection = new VoucherAssistRecordCollection();
        VoucherAssistRecordCollection newCollection = new VoucherAssistRecordCollection();
        String descri976 = ResourceBase.getString((String)RESOURCE, (String)"976_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        String descri975 = ResourceBase.getString((String)RESOURCE, (String)"975_GLAccountRefContrastProcess", (Locale)ctx.getLocale());
        boolean needQuantity = false;
        BigDecimal sumQty = BigDecimal.ZERO;
        try {
            if (oldCaa != null && newCaa == null) {
                needQuantity = true;
            }
            if (oldCaa == null && newCaa != null) {
                VoucherAssistRecordInfo newAInfo = new VoucherAssistRecordInfo();
                AssistantHGInfo newHgInfo = new AssistantHGInfo();
                AsstAccountInfo type = new AsstAccountInfo();
                type.setId(BOSUuid.read((String)newCaa));
                newHgInfo.setAsstAccount(type);
                DefaultAssistantHgValue value = this.asstActObjectMap.get(key);
                if (value != null) {
                    Map<String, IObjectValue> objValueMap = value.getDefaultValueMap();
                    Set<String> set = objValueMap.keySet();
                    Iterator<String> it = set.iterator();
                    while (it.hasNext()) {
                        String atr = it.next().toString();
                        IObjectValue objValue = objValueMap.get(atr);
                        if (objValue == null) continue;
                        newHgInfo.put(atr, (Object)objValue);
                    }
                }
                IVoucherFacade iVoucherFacade = VoucherFacadeFactory.getLocalInstance((Context)ctx);
                Object[] info = iVoucherFacade.fetchAssColumnInfo(newAcctid.toString(), newCaa.toString(), null);
                VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
                for (int i = 0; i < assItemCols.length; ++i) {
                    VoucherInfo.DynamicColumnInfo colInfo = assItemCols[i];
                    newHgInfo.put(colInfo.getMappingPropName(), newHgInfo.get(colInfo.getMappingPropName()));
                }
                AssistantHGInfo hgInfo = this.getHgFromCache(newCaa, newHgInfo);
                if (hgInfo == null) {
                    newHgInfo.put("aatok", (Object)true);
                    newHgInfo = iVoucherFacade.confirmAssGrp(newHgInfo, newCaa, assItemCols);
                    this.cacheHg(newCaa, newHgInfo);
                } else {
                    newHgInfo = hgInfo;
                }
                newAInfo.setAssGrp(newHgInfo);
                newAInfo.setDescription(descri976);
                newAInfo.setEntry(newEnInfo);
                newAInfo.setSeq(1);
                newAInfo.setMeasureUnit(enInfo.getMeasureUnit());
                newAInfo.setOriginalAmount(accountBal);
                newAInfo.setQuantity(enInfo.getQuantity());
                newAInfo.setStandardQuantity(enInfo.getQuantity());
                newAInfo.setPrice(enInfo.getPrice());
                newAInfo.setAssGrp(newHgInfo);
                newAInfo.setBizDate((Date)period.getEndDate());
                newAInfo.setEndDate((Date)period.getEndDate());
                newCollection.add(newAInfo);
            }
            assistSet.beforeFirst();
            while (assistSet.next()) {
                String accountId = assistSet.getString("accountid");
                String currencyId = assistSet.getString("fcurrencyId");
                int seqCount = 1;
                if (!accountId.equals(oldAcctid) || !currencyId.equals(newEnInfo.getCurrency().getId().toString())) continue;
                VoucherAssistRecordInfo aInfo = new VoucherAssistRecordInfo();
                VoucherAssistRecordInfo newAInfo = new VoucherAssistRecordInfo();
                AssistantHGInfo hgInfo = null;
                if (oldCaa != null) {
                    String hgFid = assistSet.getString("hgFid");
                    hgInfo = (AssistantHGInfo)this.assistantHGInfoMap.get(hgFid);
                    aInfo.setAssGrp(hgInfo);
                }
                BigDecimal endAmount = assistSet.getBigDecimal("fendbalancefor");
                BigDecimal localAmount = assistSet.getBigDecimal("fendBalancelocal");
                BigDecimal rptAmount = assistSet.getBigDecimal("fendBalancerpt");
                BigDecimal endQty = assistSet.getBigDecimal("fendqty");
                MeasureUnitInfo unitInfo = desMInfo;
                if (oldIsQty != 0 && this.isQtyAsst) {
                    String unitInfoId = assistSet.getString("fmeasureunitid");
                    unitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitInfoId)));
                    if (needQuantity) {
                        sumQty = sumQty.add(unitInfo.getCoefficient().multiply(endQty));
                    }
                }
                if (this.opposite) {
                    endAmount = endAmount.multiply(this.transCoefficient);
                    localAmount = localAmount.multiply(this.transCoefficient);
                    rptAmount = rptAmount.multiply(this.transCoefficient);
                }
                if (newCaa != null && oldCaa != null) {
                    AssistantHGInfo newHgInfo = new AssistantHGInfo();
                    if (newCaa.equals(oldCaa)) {
                        newHgInfo = hgInfo;
                        this.cacheHg(newCaa, newHgInfo);
                    } else {
                        AssistantHGInfo hg;
                        List asstActTypeList = (List)this.asstActGroupDetailMap.get(newCaa);
                        AsstActTypeCollection actTypes = new AsstActTypeCollection();
                        for (int i = 0; i < asstActTypeList.size(); ++i) {
                            AsstActTypeInfo asstActType = (AsstActTypeInfo)asstActTypeList.get(i);
                            actTypes.add(asstActType);
                        }
                        AsstAccountInfo type = new AsstAccountInfo();
                        type.setId(BOSUuid.read((String)newCaa));
                        newHgInfo.setAsstAccount(type);
                        DefaultAssistantHgValue value = this.asstActObjectMap.get(key);
                        if (value != null) {
                            Map<String, IObjectValue> objValueMap = value.getDefaultValueMap();
                            Set<String> set = objValueMap.keySet();
                            Iterator<String> it = set.iterator();
                            while (it.hasNext()) {
                                String atr = it.next().toString();
                                IObjectValue objValue = objValueMap.get(atr);
                                if (objValue == null) continue;
                                newHgInfo.put(atr, (Object)objValue);
                            }
                        }
                        if (hgInfo != null) {
                            for (int k = 0; k < asstActTypeList.size(); ++k) {
                                String attribute = ((AsstActTypeInfo)asstActTypeList.get(k)).getAsstHGAttribute();
                                PropertyContainer objValue = (PropertyContainer)hgInfo.get(attribute);
                                if (objValue == null) continue;
                                newHgInfo.put(attribute, (Object)objValue);
                            }
                        }
                        if ((hg = this.getHgFromCache(newCaa, newHgInfo)) == null) {
                            newHgInfo.put("aatok", (Object)true);
                            IAssistantHG assistanthg = AssistantHGFactory.getLocalInstance((Context)ctx);
                            newHgInfo = assistanthg.getAssistantHG(newHgInfo, type.getId().toString(), actTypes);
                            this.cacheHg(newCaa, newHgInfo);
                        } else {
                            newHgInfo = hg;
                        }
                    }
                    newAInfo.setAssGrp(newHgInfo);
                    newAInfo.setDescription(descri976);
                    newAInfo.setEntry(newEnInfo);
                    newAInfo.setSeq(seqCount + 1);
                    newAInfo.setOriginalAmount(endAmount);
                    newAInfo.setLocalAmount(localAmount);
                    newAInfo.setReportingAmount(rptAmount);
                    newAInfo.setMeasureUnit(unitInfo);
                    if (this.opposite) {
                        endQty = endQty.multiply(this.transCoefficient);
                    }
                    if (endQty.doubleValue() != 0.0) {
                        newAInfo.setQuantity(endQty);
                        newAInfo.setStandardQuantity(endQty);
                        newAInfo.setPrice(endAmount.divide(endQty.compareTo(this.zero) == 0 ? this.one : endQty, 2));
                    }
                    newAInfo.setBizDate((Date)period.getEndDate());
                    newAInfo.setEndDate((Date)period.getEndDate());
                }
                aInfo.setEntry(enInfo);
                aInfo.setSeq(seqCount);
                aInfo.setDescription(descri975);
                aInfo.setOriginalAmount(endAmount);
                aInfo.setLocalAmount(localAmount);
                aInfo.setReportingAmount(rptAmount);
                aInfo.setMeasureUnit(unitInfo);
                if (this.opposite) {
                    endQty = endQty.multiply(this.transCoefficient);
                }
                if (endQty.doubleValue() != 0.0) {
                    aInfo.setQuantity(endQty);
                    aInfo.setStandardQuantity(endQty);
                    aInfo.setPrice(endAmount.divide(endQty.compareTo(this.zero) == 0 ? this.one : endQty, 2));
                }
                aInfo.setBizDate((Date)period.getEndDate());
                aInfo.setEndDate((Date)period.getEndDate());
                seqCount += 2;
                if (aInfo != null && oldCaa != null) {
                    oldCollection.add(aInfo);
                }
                if (newAInfo == null || newCaa == null) continue;
                newCollection.add(newAInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        map.put("oldCollection", oldCollection);
        map.put("newCollection", newCollection);
        if (needQuantity) {
            map.put("sumQty", sumQty);
        }
        return map;
    }

    private void createAsstActGroupDetailMap(Context ctx, IRowSet set) throws BOSException {
        this.asstActGroupDetailMap = new HashMap();
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (set.next()) {
                String oldCaa = set.getString("srccaa");
                String newCaa = set.getString("descaa");
                if (oldCaa != null) {
                    idSet.add(oldCaa);
                }
                if (newCaa == null) continue;
                idSet.add(newCaa);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        AsstActGroupDetailCollection rels = new AsstActGroupDetailCollection();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        StringBuffer idSetStr = new StringBuffer();
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        Iterator it = idSet.iterator();
        idSetStr.append("'").append(it.next()).append("'");
        while (it.hasNext()) {
            idSetStr.append(",'").append(it.next()).append("'");
        }
        fic.add(new FilterItemInfo("asstAccount.id", (Object)idSetStr.toString(), CompareType.INNER));
        rels = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        for (int i = 0; i < rels.size(); ++i) {
            List<AsstActTypeInfo> asstActTypeList;
            AsstAccountInfo asstAccount = rels.get(i).getAsstAccount();
            String asstAccountId = asstAccount.getId().toString();
            if (this.asstActGroupDetailMap.get(asstAccountId) != null) {
                asstActTypeList = (List)this.asstActGroupDetailMap.get(asstAccountId);
                asstActTypeList.add(rels.get(i).getAsstActType());
                continue;
            }
            asstActTypeList = new ArrayList<AsstActTypeInfo>();
            asstActTypeList.add(rels.get(i).getAsstActType());
            this.asstActGroupDetailMap.put(asstAccountId, asstActTypeList);
        }
    }

    public Object getAsstActObject(Context ctx, String value) throws BOSException {
        EntityObjectInfo eoi = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSUuid.read((String)value).getType());
        BOSUuid bosid = BOSUuid.read((String)value);
        String classValue = eoi.getObjectValueClass();
        IObjectValue objectValue = null;
        try {
            objectValue = (IObjectValue)Class.forName(classValue).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        objectValue.put("id", (Object)bosid);
        return objectValue;
    }

    private static String getAccountRefConstrastId(Context ctx, String companyId, Integer periodNumber) throws BOSException {
        String refId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select \r\n");
        sql.append("c.fid \r\n");
        sql.append("from t_bd_acctrefcontrast c \r\n");
        sql.append("inner join t_bd_period p on p.fid = c.fenabledperiodid \r\n");
        sql.append("where c.fcompanyid = ? \r\n");
        sql.append("and c.freftype = 1 \r\n");
        sql.append("and p.fnumber = ? \r\n");
        sql.append("and c.fisenabled = 1 \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodNumber});
        try {
            if (rs.next()) {
                refId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return refId;
    }

    private static Set<String> getAccountRefConstrastOldAcct(Context ctx, String refId) throws BOSException {
        HashSet<String> oldAcctSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select \r\n");
        sql.append("entry.foldacctid \r\n");
        sql.append("from t_bd_acctrefcontrastentry entry \r\n");
        sql.append("inner join t_bd_acctrefcontrast c on entry.facctrefcontrastid = c.fid \r\n");
        sql.append("where c.fid = ? \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{refId});
        try {
            while (rs.next()) {
                String foldacctid = rs.getString("foldacctid");
                oldAcctSet.add(foldacctid);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return oldAcctSet;
    }

    private void cacheHg(String newCaa, AssistantHGInfo newHgInfo) {
        BOSUuid id = newHgInfo.getId();
        newHgInfo.setId(null);
        String hgCachKey = newHgInfo.toString() + newCaa;
        newHgInfo.setId(id);
        this.hgMapCache.put((Object)hgCachKey, (Object)newHgInfo);
    }

    public String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    class DefaultAssistantHgValue {
        private String key;
        private Map<String, IObjectValue> defaultValueMap = new HashMap<String, IObjectValue>();

        DefaultAssistantHgValue() {
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setDefaultValueMap(Map<String, IObjectValue> defaultValueMap) {
            this.defaultValueMap = defaultValueMap;
        }

        public Map<String, IObjectValue> getDefaultValueMap() {
            return this.defaultValueMap;
        }
    }
}

