/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AccountAgeParam;
import com.kingdee.eas.fi.gl.app.GLAcctAgeUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.app.QueryAgeType;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class GLAcctAgeNewUtils {
    private static Logger logger = Logger.getLogger((String)GLAcctAgeNewUtils.class.getClass().getName());
    public static final int BATCH_COUNT = 2000;
    public static final int ID_LIMIT = 500;
    public static final String IS_VERIFY = "isVerify";
    public static Map<String, String> adjustRateInfoCache = new ConcurrentHashMap<String, String>();
    public static final String functionName = "AccountAgeFacadeControllerBean";
    public static final String acTableName = "acTable";
    public static final String bizNumber = "FBizNumber";
    public static final String asstActNumer = "asstActNumber";
    public static final String tempTableFields = "tempTableFields";
    private static Map<String, CurrencyInfo> curCache = new ConcurrentHashMap<String, CurrencyInfo>();
    private static Map<String, PeriodInfo> startPeriodCache = new ConcurrentHashMap<String, PeriodInfo>();
    private static Map<String, PeriodInfo> periodCache = new ConcurrentHashMap<String, PeriodInfo>();
    private static Map<String, CompanyOrgUnitInfo> companyCache = new ConcurrentHashMap<String, CompanyOrgUnitInfo>();
    private static Map<String, Map<String, String>> tempFieldInfoCache = new ConcurrentHashMap<String, Map<String, String>>();
    private static Map<String, Integer> verifyModelCache = new ConcurrentHashMap<String, Integer>();
    private static List<Map<String, Object>> allCurrencyCache = Collections.synchronizedList(new ArrayList());
    private static Map<String, Map<String, CurrencyRateConvertInfo>> exchRateMapCache = new ConcurrentHashMap<String, Map<String, CurrencyRateConvertInfo>>();
    public static ThreadLocal<Map<String, String>> adjExchTmpTableCache = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    public static ThreadLocal<List<String>> idsTempTables = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };
    public static Map<String, Map<String, Object>> hmParamIn = new HashMap<String, Map<String, Object>>();

    public static Map<String, CurrencyRateConvertInfo> getAdjExchData(Context ctx, String cacheKey, String adjExchTempTable) throws BOSException, SQLException {
        Map<String, CurrencyRateConvertInfo> adjExchData = null;
        if (exchRateMapCache.containsKey(cacheKey)) {
            adjExchData = exchRateMapCache.get(cacheKey);
        } else if (!StringUtils.isEmpty((String)adjExchTempTable)) {
            String sql = "select FID, FCONVERTRATEA from " + adjExchTempTable;
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql);
            HashMap<String, CurrencyRateConvertInfo> map = new HashMap<String, CurrencyRateConvertInfo>(3);
            while (result.next()) {
                CurrencyRateConvertInfo currRateInfo = new CurrencyRateConvertInfo();
                String currId = result.getString("FID");
                currRateInfo.setCurrid(currId);
                currRateInfo.setConvertRate(result.getBigDecimal("FCONVERTRATEA"));
                map.put(currId, currRateInfo);
            }
            adjExchData = map;
            exchRateMapCache.put(cacheKey, map);
        }
        return adjExchData;
    }

    public static void clearAdjExchDataCache() {
        exchRateMapCache.clear();
    }

    public static void cacheCurInfo(CurrencyInfo curInfo) {
        if (curInfo.getId() != null) {
            curCache.put(curInfo.getId().toString(), curInfo);
        }
    }

    public static CurrencyInfo getCacheCurInfo(Context ctx, String id) throws EASBizException, BOSException {
        if (curCache.containsKey(id)) {
            return curCache.get(id);
        }
        CurrencyInfo cur = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
        curCache.put(id, cur);
        return cur;
    }

    public static void clearCurrencyCache() {
        curCache.clear();
    }

    public static void cachePeriodInfo(String companyid, PeriodInfo period) {
        if (period != null && period.getId() != null) {
            startPeriodCache.put(companyid, period);
        }
    }

    public static PeriodInfo getCachePeriodInfo(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo periodInfo = startPeriodCache.get(companyId);
        if (periodInfo == null) {
            periodInfo = GLAcctAgeNewUtils.getAcPeriodInfo(ctx, companyId);
            startPeriodCache.put(companyId, periodInfo);
        }
        return periodInfo;
    }

    public static void clearStartPeriodCache() {
        startPeriodCache.clear();
    }

    public static Map<String, PeriodInfo> getStartPeriodCache() {
        return startPeriodCache;
    }

    public static void cacheHmParam(Context ctx, String key, String comKey) throws EASBizException, BOSException {
        HashMap<String, String> hmMap = new HashMap<String, String>();
        hmMap.put(key, comKey);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmMap);
        if (hmParamIn.containsKey(comKey)) {
            hmParamIn.get(comKey).putAll(hmAllParam);
        } else {
            hmParamIn.put(comKey, hmAllParam);
        }
    }

    public static Object getHmParam(Context ctx, String comKey, String key) throws EASBizException, BOSException {
        if (hmParamIn.containsKey(comKey)) {
            return hmParamIn.get(comKey).get(key);
        }
        HashMap<String, String> hmMap = new HashMap<String, String>();
        hmMap.put(key, comKey);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmMap);
        hmParamIn.put(comKey, hmAllParam);
        return hmAllParam.get(key);
    }

    public static void cachePeriodData(Context ctx, String companyids) throws BOSException, EASBizException {
        StringBuilder companyIdStr = new StringBuilder();
        String[] companyIdArray = companyids.replace("'", "").split(",");
        ArrayList<String> companyIdList = new ArrayList<String>();
        for (String companyId : companyIdArray) {
            PeriodInfo periodInfo = GLAcctAgeNewUtils.getStartPeriodCache().get(companyId);
            if (periodInfo != null) continue;
            companyIdStr.append("'").append(companyId).append("',");
            companyIdList.add(companyId);
        }
        if (companyIdStr.length() > 0) {
            String companyIdsTempTable;
            boolean isSuc = false;
            if (companyIdList.size() >= 500 && !StringUtils.isEmpty((String)(companyIdsTempTable = GLAcctAgeNewUtils.createIdsTempTable(ctx, companyIdList)))) {
                companyids = "select fid from " + companyIdsTempTable;
                idsTempTables.get().add(companyIdsTempTable);
                isSuc = true;
            }
            if (!isSuc) {
                companyids = companyIdStr.substring(0, companyIdStr.length() - 1);
            }
            SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select company.id, acPeriod.* where systemStatus.name=6 and company.id in(" + companyids + ")");
            SystemStatusCtrolInfo sscInfo = null;
            CompanyOrgUnitInfo com = null;
            PeriodInfo period = null;
            for (int i = 0; i < ctrols.size(); ++i) {
                sscInfo = ctrols.get(i);
                period = sscInfo.getAcPeriod();
                com = sscInfo.getCompany();
                if (period == null) {
                    period = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)com);
                }
                GLAcctAgeNewUtils.cachePeriodInfo(com.getId().toString(), period);
            }
        }
    }

    public static PeriodInfo getAcPeriodInfo(Context ctx, String companyId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)companyId)) {
            return null;
        }
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select company.id, acPeriod.* where systemStatus.name=6 and company.id = '" + companyId + "'");
        PeriodInfo period = null;
        if (ctrols.size() > 0) {
            SystemStatusCtrolInfo sscInfo = ctrols.get(0);
            period = sscInfo.getAcPeriod();
            CompanyOrgUnitInfo com = sscInfo.getCompany();
            if (period == null) {
                period = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)com);
            }
        }
        return period;
    }

    public static void prepareAccountAgeParam(AccountAgeParam paramAge, Context ctx, CompanyOrgUnitInfo company, boolean isIsOnlyUnion, String accountid, String currencyid, int[] days, int[] undays, boolean isShowUmexpired, HashMap hmItems, java.util.Date endDate, boolean isIncludeUnPosted, boolean isIncludeInit, String companyid, int dateType, int indexType, Object accountFrom, Object accountTo, int companyLevel, String curCompanyid, String accountViewNumber, HashMap otherInfo, String acctTableId, boolean isfirstload, boolean isIncludeVerifyVch, boolean isBizCode, java.util.Date historyDate, int displayMode, boolean isDisplayLeafCompany, String hgid) throws EASBizException, BOSException {
        paramAge.setCtx(ctx);
        paramAge.setCompany(company);
        paramAge.setIsOnlyUnion(isIsOnlyUnion);
        paramAge.setCompanyId(companyid);
        if (indexType == 1 && !StringUtils.isEmpty((String)accountid)) {
            String[] accountIdArray = accountid.split(",");
            if (accountIdArray.length > 1000) {
                String hgTmpTable = GLAcctAgeNewUtils.getHgTmptable(paramAge, ctx, accountIdArray);
                paramAge.setHgIdTmpTable(hgTmpTable);
                String selectHgSql = "select fhgId from " + hgTmpTable + " where fhgId = hg.fid";
                paramAge.setAccountid(selectHgSql);
            } else {
                paramAge.setAccountid(accountid);
            }
        } else {
            paramAge.setAccountid(accountid);
        }
        paramAge.setAccountid(accountid);
        paramAge.setAccountViewNumber(accountViewNumber);
        paramAge.setAccountFrom(accountFrom);
        paramAge.setAccountTo(accountTo);
        paramAge.setDays(days);
        paramAge.setUndays(undays);
        paramAge.setShowUmexpired(isShowUmexpired);
        paramAge.setEndDate(endDate);
        paramAge.setHistoryDate(historyDate);
        paramAge.setBizCode(isBizCode);
        paramAge.setCurrencyid(currencyid);
        paramAge.setIncludeUnPosted(isIncludeUnPosted);
        paramAge.setIncludeInit(isIncludeInit);
        paramAge.setIncludeVerifyVch(isIncludeVerifyVch);
        paramAge.setDateType(dateType);
        paramAge.setIndexType(indexType);
        paramAge.setHmItems(hmItems);
        paramAge.setCompanyLevel(companyLevel);
        if (isIsOnlyUnion) {
            paramAge.setCurCompanyid(curCompanyid);
            paramAge.setDisplayMode(displayMode);
            paramAge.setDisplayLeafCompany(isDisplayLeafCompany);
        } else {
            paramAge.setCurCompanyid(companyid);
        }
        paramAge.setOtherInfo(otherInfo);
        paramAge.setAcctTableId(acctTableId);
        paramAge.setIsfirstload(isfirstload);
        paramAge.setHgid(hgid);
    }

    private static String getHgTmptable(AccountAgeParam paramAge, Context ctx, String[] accountIdArray) throws BOSException {
        ArrayList<String[]> params = new ArrayList<String[]>(accountIdArray.length);
        for (String accountId : accountIdArray) {
            params.add(new String[]{accountId.replace("'", "")});
        }
        String hgTmpTable = GLTempTableUtil.createTempTable(ctx, "fhgId varchar(100)");
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(hgTmpTable, "fhgId", false, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        String insertSql = "insert into " + hgTmpTable + " values(?)";
        DbUtil.executeBatch((Context)ctx, (String)insertSql, params);
        return hgTmpTable;
    }

    public static void dealwith_Param(AccountAgeParam paramAge) throws EASBizException, BOSException {
        int _periodNumber;
        int i;
        Object[] v;
        int daylen = paramAge.getDays().length;
        int undaylen = paramAge.getUndays().length;
        boolean isAccountList = paramAge.getIndexType() == 1;
        boolean isAccountBC = !isAccountList && paramAge.isBizCode();
        boolean isAccountBCNoType = isAccountBC && paramAge.getHmItems().size() == 0;
        String accountFromNumber = "";
        String accountToNumber = "";
        String bizCodeFromNumber = null;
        String bizCodeToNumber = null;
        Object accountFrom = paramAge.getAccountFrom();
        Object accountTo = paramAge.getAccountTo();
        if (accountFrom instanceof AccountViewInfo) {
            accountFromNumber = ((AccountViewInfo)accountFrom).getNumber();
        } else if (accountFrom instanceof Object[]) {
            v = (Object[])accountFrom;
            accountFromNumber = "";
            for (i = 0; i < v.length; ++i) {
                if (v[i] == null) continue;
                accountFromNumber = accountFromNumber + ((AccountViewInfo)v[i]).getNumber() + ";";
            }
        } else {
            accountFromNumber = (String)accountFrom;
        }
        if (accountTo instanceof AccountViewInfo) {
            accountToNumber = ((AccountViewInfo)accountTo).getNumber();
        } else if (accountTo instanceof Object[]) {
            v = (Object[])accountTo;
            accountToNumber = "";
            for (i = 0; i < v.length; ++i) {
                if (v[i] == null) continue;
                accountToNumber = accountToNumber + ((AccountViewInfo)v[i]).getNumber() + ";";
            }
        } else {
            accountToNumber = (String)accountTo;
        }
        Map accountParams = GLAcctAgeNewUtils.getAccountParam(accountFromNumber, accountToNumber);
        accountFromNumber = (String)accountParams.get("accountFrom");
        accountToNumber = (String)accountParams.get("accountTo");
        Iterator itemkeyit = paramAge.getHmItems().keySet().iterator();
        if (paramAge.isBizCode()) {
            while (itemkeyit.hasNext()) {
                HashMap item = (HashMap)itemkeyit.next();
                String[] numbers = (String[])paramAge.getHmItems().get(item);
                bizCodeFromNumber = numbers[0];
                bizCodeToNumber = numbers[1];
                if (numbers.length < 3 || numbers[2] == null) continue;
                paramAge.setBizCodeDistNumbers(numbers[2]);
            }
        }
        paramAge.setEndDate(DateTimeUtils.truncateDate((java.util.Date)paramAge.getEndDate()));
        paramAge.setHistoryDate(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
        GLAcctAgeNewUtils.setEnterDateType(paramAge);
        String loc = LocaleUtils.getLocaleString((Locale)paramAge.getCtx().getLocale());
        boolean isAllCurr = false;
        if (paramAge.getCurrencyid().equals("AllCurrency")) {
            isAllCurr = true;
        }
        Object icurrency = null;
        CurrencyInfo currency = null;
        if (!isAllCurr) {
            currency = GLAcctAgeNewUtils.getCacheCurInfo(paramAge.getCtx(), paramAge.getCurrencyid());
        }
        CurrencyInfo generalCurrency = null;
        boolean isGeneralCy = false;
        int localOrRpt = 1;
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(paramAge.getCurrencyid())) {
            localOrRpt = 1;
            isGeneralCy = true;
            generalCurrency = paramAge.getCompany().getBaseCurrency();
        } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(paramAge.getCurrencyid())) {
            localOrRpt = 2;
            isGeneralCy = true;
            generalCurrency = paramAge.getCompany().getReportCurrency();
        }
        if (isGeneralCy) {
            generalCurrency = GLAcctAgeNewUtils.getCacheCurInfo(paramAge.getCtx(), generalCurrency.getId().toString());
        }
        boolean isSetCurrency = !isGeneralCy && !isAllCurr;
        String acctTableId = paramAge.getAcctTableId();
        PeriodInfo _periodHis = GLAcctAgeNewUtils.getPeriodInfo(paramAge.getCtx(), paramAge.getHistoryDate(), paramAge.getCompany());
        if (_periodHis == null) {
            throw new GLException(GLException.NOPERIODLIST);
        }
        int _periodYear = _periodHis == null ? paramAge.getHistoryDate().getYear() + 1900 : _periodHis.getPeriodYear();
        int n = _periodNumber = _periodHis == null ? (paramAge.getHistoryDate().getMonth() + 3) / 3 : _periodHis.getPeriodNumber();
        if (acctTableId == null) {
            acctTableId = AccountTools.getCurrentAcctTable((Context)paramAge.getCtx(), (String)paramAge.getCompany().getId().toString(), (String)paramAge.getCompany().getAccountTable().getId().toString(), (int)_periodYear, (int)_periodNumber);
        }
        Object lastPhaseBeginDate = null;
        Object lastPhaseEndDate = null;
        int verifyMode = GLAcctAgeNewUtils.getVerifyModel(paramAge.getCtx(), paramAge.getCurCompanyid());
        boolean isInTimeVerify = verifyMode == 0;
        boolean isIncludeUnPosted = paramAge.isIncludeUnPosted();
        if (verifyMode == 2) {
            isIncludeUnPosted = true;
        }
        if (paramAge.isIsOnlyUnion()) {
            isIncludeUnPosted = true;
            isInTimeVerify = false;
        }
        boolean isJoinHgTable = false;
        if (paramAge.getHmItems().size() > 0 || paramAge.isBizCode() && paramAge.isIncludeVerifyVch()) {
            isJoinHgTable = true;
        }
        String maxChar = GlUtils.getMaxChar(paramAge.getCtx());
        paramAge.setAccountBC(isAccountBC);
        paramAge.setAccountBCNoType(isAccountBCNoType);
        paramAge.setBizCodeFromNumber(bizCodeFromNumber);
        paramAge.setBizCodeToNumber(bizCodeToNumber);
        paramAge.setDaylen(daylen);
        paramAge.setUndaylen(undaylen);
        paramAge.setAccountList(isAccountList);
        paramAge.setAccountParams(accountParams);
        paramAge.setAccountFromNumber(accountFromNumber);
        paramAge.setAccountToNumber(accountToNumber);
        paramAge.setAcctTableId(acctTableId);
        paramAge.setAllCurr(isAllCurr);
        paramAge.setGeneralCy(isGeneralCy);
        paramAge.setLocalOrRpt(localOrRpt);
        paramAge.setSetCurrency(isSetCurrency);
        paramAge.setCurrency(currency);
        paramAge.setGeneralCurrency(generalCurrency);
        paramAge.setIncludeUnPosted(isIncludeUnPosted);
        paramAge.setInTimeVerify(isInTimeVerify);
        paramAge.setJoinHgTable(isJoinHgTable);
        paramAge.setLoc(loc);
        paramAge.setMaxChar(maxChar);
    }

    public static void prepareTempTableAdjExch(AccountAgeParam paramAge) throws EASBizException, BOSException {
        String tempTableExchRate = "";
        if (paramAge.isGeneralCy()) {
            String exchangeTableId = "";
            exchangeTableId = paramAge.getCompany().getAdjustExchangeTable() == null ? paramAge.getCompany().getBaseExchangeTable().getId().toString() : paramAge.getCompany().getAdjustExchangeTable().getId().toString();
            String key = exchangeTableId + "$" + paramAge.getHistoryDate().toString();
            if (paramAge.getType() == QueryAgeType.WEBSERVICE_AGE_DAYS) {
                java.util.Date adjExchDate = paramAge.get("adjExchDate") == null ? paramAge.getHistoryDate() : (java.util.Date)paramAge.get("adjExchDate");
                key = exchangeTableId + "$" + adjExchDate.toString();
                Map<String, String> map = adjExchTmpTableCache.get();
                if (map.containsKey(key)) {
                    tempTableExchRate = map.get(key);
                } else {
                    tempTableExchRate = GLAcctAgeNewUtils.creatAdjexchTempTable(paramAge);
                    map.put(key, tempTableExchRate);
                }
            } else if (paramAge.isRptQuery() && adjustRateInfoCache.containsKey(key)) {
                tempTableExchRate = adjustRateInfoCache.get(key);
            } else {
                tempTableExchRate = paramAge.isIsOnlyUnion() ? GLAcctAgeNewUtils.creatAdjexchTempTableWhenUnion(paramAge) : GLAcctAgeNewUtils.creatAdjexchTempTable(paramAge);
                if (paramAge.isRptQuery()) {
                    adjustRateInfoCache.put(key, tempTableExchRate);
                }
            }
        }
        paramAge.setTempTableExchRate(tempTableExchRate);
    }

    public static void getSql_ByAcctBal_AmountField(AccountAgeParam paramAge) {
        String amountField = "";
        amountField = paramAge.isIsOnlyUnion() && paramAge.isIncludeUnPosted() ? "case when comvm.FVerifyMode = '0' then cussent.funholdedAmtFor else cussent.funVerifiedAmtFor end" : (paramAge.isIncludeUnPosted() && paramAge.isInTimeVerify() ? "cussent.FUnholdedAmtFor" : "cussent.FUnVerifiedAmtFor");
        String amountField_Veri = "cussent.FOriginalAmount";
        if (paramAge.isIncludeVerifyVch()) {
            amountField_Veri = "cussent.FUnVerifiedAmtFor";
        }
        paramAge.setAmountField(amountField);
        paramAge.setAmountField_veri(amountField_Veri);
    }

    public static StringBuffer getAdjexchTempTableSubSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct aux.FSourceCurrencyID,");
        sql.append(" case when aux.FConvertMode=0 then exch.FConvertRate else 1/exch.FConvertRate end FConvertRateA,");
        sql.append(" CASE WHEN fquoteprice = 2 THEN 4 ELSE fquoteprice END FQUOTEPRICE  ");
        sql.append(" ,aux.FPRECISION  ");
        sql.append(" from T_BD_ExchangeAux aux  ");
        sql.append(" inner join T_BD_ExchangeRate exch on exch.FExchangeAuxID = aux.FID ");
        sql.append(" inner join  ( ");
        sql.append(" select aux.FSourceCurrencyID, aux.FTargetCurrencyID,max(exch.FAvailTime) FAvailTime ");
        sql.append(" from T_BD_ExchangeAux aux ");
        sql.append(" inner join T_BD_ExchangeRate exch on exch.FExchangeAuxID = aux.FID ");
        sql.append(" where aux.FExchangeTableId = ? ");
        sql.append(" and exch.FIsUsedBG = 0  ");
        sql.append(" and exch.FAvailTime <= ? ");
        sql.append(" group by aux.FExchangeTableId,aux.FSourceCurrencyID, aux.FTargetCurrencyID    )   extemp ");
        sql.append(" on extemp.FSourceCurrencyID=aux.FSourceCurrencyID ");
        sql.append(" and  extemp.FTargetCurrencyID=aux.FTargetCurrencyID and extemp.FAvailTime=exch.FAvailTime ");
        sql.append(" where aux.FExchangeTableId = ?  ");
        sql.append(" and exch.FIsUsedBG = 0 ");
        sql.append(" and exch.FAvailTime <= ?  ");
        sql.append(" and aux.FTargetCurrencyID = ? ");
        return sql;
    }

    public static String getDay(java.util.Date day) {
        return "TO_DATE('" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(day) + "')";
    }

    public static StringBuffer appendFromHead(StringBuffer sql, String subStr) {
        String strOut = sql.toString();
        sql.setLength(0);
        sql.append(subStr).append(strOut);
        return sql;
    }

    public static StringBuffer truncateStringHeadDot(StringBuffer sql) {
        String strOut = sql.toString().trim();
        if (strOut.startsWith(",")) {
            strOut = strOut.substring(1, strOut.length());
            sql.setLength(0);
            sql.append(strOut);
        }
        return sql;
    }

    public static StringBuffer truncateStringTailDot(StringBuffer sql) {
        if (sql.toString().endsWith(",")) {
            int delimiterIdx = sql.lastIndexOf(",");
            String strOut = sql.toString().substring(0, delimiterIdx);
            sql.setLength(0);
            sql.append(strOut);
        }
        return sql;
    }

    public static StringBuffer getResultSql4Acct(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("  FROM  ").append(tableName).append(" CUSSENT                                                \r\n");
        sql.append("   inner join t_bd_accountview ACCOUNT on cussent.faccountid = account.fid    \r\n");
        sql.append("   left outer join t_bd_accountview paccount on account.fparentid = paccount.fid ");
        sql.append("  WHERE cussent.FEndBalancefor<>0.0  --\u4f59\u989d\u4e0d\u4e3a0                              \r\n");
        sql.append("  ORDER BY account.fnumber ASC                                                \r\n");
        sql.append("                                                                              \r\n");
        return sql;
    }

    public static StringBuffer getResultSql4Item(String tableName, StringBuffer select, StringBuffer innerJoinAsst, StringBuffer orderBy) {
        StringBuffer sql = new StringBuffer();
        sql.append(select);
        sql.append("  FROM  ").append(tableName).append(" CUSSENT                                                \r\n");
        sql.append("   inner join t_bd_assistanthg HG on CUSSENT.FAssistGrpID=hg.fid    \r\n");
        sql.append(innerJoinAsst);
        sql.append("  WHERE cussent.FEndBalancefor<>0.0  --\u4f59\u989d\u4e0d\u4e3a0                              \r\n");
        sql.append(orderBy);
        return sql;
    }

    public static boolean checkDbTypeIsOracleDB2(Context ctx) {
        boolean isDBType = false;
        String strDbType = ContextUtil.getDbType((Context)ctx);
        if (strDbType.compareToIgnoreCase("oracle") == 0 || strDbType.compareToIgnoreCase("db2") == 0) {
            isDBType = true;
        }
        return isDBType;
    }

    public static boolean checkDbTypeIsOracle(Context ctx) {
        boolean isDBType = false;
        String strDbType = ContextUtil.getDbType((Context)ctx);
        if (strDbType.compareToIgnoreCase("oracle") == 0) {
            isDBType = true;
        }
        return isDBType;
    }

    public static boolean checkDbTypeIsDB2(Context ctx) {
        boolean isDBType = false;
        String strDbType = ContextUtil.getDbType((Context)ctx);
        if (strDbType.compareToIgnoreCase("db2") == 0) {
            isDBType = true;
        }
        return isDBType;
    }

    public static boolean checkDbTypeIsSQLServer(Context ctx) {
        boolean isDBType = false;
        String strDbType = ContextUtil.getDbType((Context)ctx);
        if (strDbType.compareToIgnoreCase("sqlserver") == 0) {
            isDBType = true;
        }
        return isDBType;
    }

    public static int findMaxInSumArray(BigDecimal[] sum) {
        int iMax = 0;
        int length = sum.length;
        if (length == 0) {
            return iMax;
        }
        BigDecimal max = sum[0].abs();
        for (int i = 0; i < length; ++i) {
            if (max.compareTo(sum[i].abs()) >= 0) continue;
            iMax = i;
            max = sum[i].abs();
        }
        return iMax;
    }

    public static void dropTempTable(AccountAgeParam paramAge, Logger logger) {
        try {
            TempTablePool iPool = TempTablePool.getInstance((Context)paramAge.getCtx());
            if (!paramAge.isQueryAgeSub() && !StringUtils.isEmpty((String)paramAge.getTempTableAcSum())) {
                iPool.releaseTable(paramAge.getTempTableAcSum());
            }
            if (!StringUtils.isEmpty((String)paramAge.getTempTableHistory())) {
                iPool.releaseTable(paramAge.getTempTableHistory());
            }
            if (!StringUtils.isEmpty((String)paramAge.getTempTableExchRate())) {
                iPool.releaseTable(paramAge.getTempTableExchRate());
            }
            if (!StringUtils.isEmpty((String)paramAge.getTempTableSumVeri())) {
                iPool.releaseTable(paramAge.getTempTableSumVeri());
            }
            if (!StringUtils.isEmpty((String)paramAge.getTempTableComVeriMode())) {
                iPool.releaseTable(paramAge.getTempTableComVeriMode());
            }
            if (!StringUtils.isEmpty((String)paramAge.getHgIdTmpTable())) {
                iPool.releaseTable(paramAge.getHgIdTmpTable());
            }
            if (!StringUtils.isEmpty((String)paramAge.getTempTableCompany())) {
                iPool.releaseTable(paramAge.getTempTableCompany());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static void buildAccountSql(StringBuffer sql, Map accountParams, String columnName) {
        String accountFrom = (String)accountParams.get("accountFrom");
        String accountTo = (String)accountParams.get("accountTo");
        String accountIns = (String)accountParams.get("accountIns");
        if (accountIns != null && accountIns.length() > 0) {
            sql.append(" and (" + columnName + " in (" + accountIns + ") ");
            if (accountFrom != null && accountFrom.length() > 0 || accountTo != null && accountTo.length() > 0) {
                sql.append("or 1=1 ");
                if (accountFrom != null && accountFrom.length() > 0) {
                    sql.append(" and " + columnName + ">=? ");
                }
                if (accountTo != null && accountTo.length() > 0) {
                    sql.append(" and " + columnName + "<=? ");
                }
            }
            sql.append(")");
        } else {
            if (accountFrom != null && !accountFrom.equals("")) {
                sql.append(" and " + columnName + ">=? ");
            }
            if (accountTo != null && !accountTo.equals("")) {
                sql.append(" and " + columnName + "<=? ");
            }
        }
    }

    public static void buildAccountSqlInTimeVerify(StringBuffer sql, List sqlParams, Map accountParams, String columnName) {
        String accountFrom = (String)accountParams.get("accountFrom");
        String accountTo = (String)accountParams.get("accountTo");
        String accountIns = (String)accountParams.get("accountIns");
        if (accountIns != null && accountIns.length() > 0) {
            sql.append(" and (" + columnName + " in (" + accountIns + ") ");
            if (accountFrom != null && accountFrom.length() > 0 || accountTo != null && accountTo.length() > 0) {
                String subSql = null;
                if (accountFrom != null && accountFrom.length() > 0) {
                    subSql = columnName + " >= ?";
                    sqlParams.add(accountFrom);
                }
                if (accountTo != null && accountTo.length() > 0) {
                    subSql = subSql != null ? subSql + " and " + columnName + " <=? " : columnName + " <=? ";
                    sqlParams.add(accountTo + "zzzzzz");
                }
                sql.append(" or (").append(subSql).append(" )");
            }
            sql.append(")");
        } else {
            if (accountFrom != null && !accountFrom.equals("")) {
                sql.append(" and " + columnName + ">=? ");
                sqlParams.add(accountFrom);
            }
            if (accountTo != null && !accountTo.equals("")) {
                sql.append(" and " + columnName + "<=? ");
                sqlParams.add(accountTo + "zzzzzz");
            }
        }
    }

    public static Map getAccountParam(String accountFrom, String accountTo) {
        HashMap<String, String> alAcResult = new HashMap<String, String>();
        String[] acctFroms = new String[]{};
        if (accountFrom != null) {
            acctFroms = accountFrom.split(";");
        }
        String[] acctTos = new String[]{};
        if (accountTo != null) {
            acctTos = accountTo.split(";");
        }
        String acctIns = "";
        if (acctFroms.length > 0 && acctTos.length > 0) {
            if (acctFroms[acctFroms.length - 1].compareTo(acctTos[0]) > 0) {
                int i;
                for (i = 0; i < acctFroms.length; ++i) {
                    acctIns = acctIns + "'" + acctFroms[i] + "',";
                }
                for (i = 0; i < acctTos.length; ++i) {
                    acctIns = acctIns + "'" + acctTos[i] + "',";
                }
                accountFrom = null;
                accountTo = null;
            } else {
                int i;
                for (i = 0; i < acctFroms.length - 1; ++i) {
                    acctIns = acctIns + "'" + acctFroms[i] + "',";
                }
                for (i = 1; i < acctTos.length; ++i) {
                    acctIns = acctIns + "'" + acctTos[i] + "',";
                }
                accountFrom = acctFroms[acctFroms.length - 1];
                accountTo = acctTos[0];
            }
        } else if (acctFroms.length > 0) {
            for (int i = 0; i < acctFroms.length - 1; ++i) {
                acctIns = acctIns + "'" + acctFroms[i] + "',";
            }
            accountFrom = acctFroms[acctFroms.length - 1];
        } else if (acctTos.length > 0) {
            for (int i = 1; i < acctTos.length; ++i) {
                acctIns = acctIns + "'" + acctTos[i] + "',";
            }
            accountTo = acctTos[0];
        }
        alAcResult.put("accountFrom", accountFrom);
        alAcResult.put("accountTo", accountTo);
        alAcResult.put("accountIns", acctIns.length() > 0 ? acctIns.substring(0, acctIns.length() - 1) : "");
        return alAcResult;
    }

    public static Map makeArrayToString(Object[] accountFromArray, Object[] accountToArray) {
        int i;
        StringBuffer accountFrom = new StringBuffer();
        StringBuffer accountTo = new StringBuffer();
        if (accountFromArray != null && accountFromArray.length != 0) {
            for (i = 0; i < accountFromArray.length; ++i) {
                accountFrom.append(((AccountViewInfo)accountFromArray[i]).getNumber()).append(";");
            }
            accountFrom.deleteCharAt(accountFrom.lastIndexOf(";"));
        }
        if (accountToArray != null && accountToArray.length != 0) {
            for (i = 0; i < accountToArray.length; ++i) {
                accountTo.append(((AccountViewInfo)accountToArray[i]).getNumber()).append(";");
            }
            accountTo.deleteCharAt(accountTo.lastIndexOf(";"));
        }
        return GLAcctAgeNewUtils.getAccountParam(accountFrom != null ? accountFrom.toString() : null, accountTo != null ? accountTo.toString() : null);
    }

    public static String createTempTableByDDL(Context ctx, String keyDesc, StringBuffer strFields) throws BOSException, EASBizException {
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(keyDesc).append(strFields);
        TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
        String tempateTable = "";
        try {
            tempateTable = iPool.createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempateTable;
    }

    public static String createTempTableByDDL(Context ctx, String keyDesc, String strFields) throws BOSException, EASBizException {
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(keyDesc).append(strFields);
        TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
        String tempateTable = "";
        try {
            tempateTable = iPool.createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempateTable;
    }

    public static void setEnterDateType(AccountAgeParam paramAge) {
        if (paramAge.getDateType() == 0) {
            paramAge.setStrDateType("FBizDate");
            paramAge.setStrDateType_AC("FVarBizDate");
        }
    }

    public static String creatAdjexchTempTable(AccountAgeParam paramAge) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = paramAge.getCompany();
        java.util.Date historyDate = null;
        historyDate = paramAge.getType() == QueryAgeType.WEBSERVICE_AGE_DAYS ? (paramAge.get("adjExchDate") == null ? paramAge.getHistoryDate() : (java.util.Date)paramAge.get("adjExchDate")) : paramAge.getHistoryDate();
        String tempTable = GLAcctAgeNewUtils.createAdjExchTempTable(paramAge.getCtx());
        GLAcctAgeNewUtils.createAdjExchTempTableDataForSingleCompany(paramAge, company, historyDate, tempTable);
        return tempTable;
    }

    private static void createAdjExchTempTableDataForSingleCompany(AccountAgeParam paramAge, CompanyOrgUnitInfo company, java.util.Date historyDate, String tempateTable) throws BOSException {
        String companyId = company.getId().toString();
        ExchangeTableInfo adjTable = company.getAdjustExchangeTable();
        ExchangeTableInfo adjRptTable = null;
        String localCurrencyID = null;
        String reportCurrencyID = null;
        int reportConvertMode = -1;
        localCurrencyID = company.getBaseCurrency().getId().toString();
        if (adjTable == null) {
            adjTable = company.getBaseExchangeTable();
        }
        if (paramAge.getLocalOrRpt() != 1 && company.getReportCurrency() != null) {
            reportCurrencyID = company.getReportCurrency().getId().toString();
            reportConvertMode = company.getReportConvertMode().getValue();
            if (3 == reportConvertMode) {
                adjRptTable = company.getReportExchangeTable();
            } else {
                adjTable = company.getReportExchangeTable();
                localCurrencyID = reportCurrencyID;
            }
        }
        String adjustTableID = "";
        String currencyID = "";
        if (!StringUtils.isEmpty(reportCurrencyID) && 1 == reportConvertMode && !localCurrencyID.equalsIgnoreCase(reportCurrencyID) && adjRptTable != null) {
            adjustTableID = adjRptTable.getId().toString();
            currencyID = reportCurrencyID;
        } else {
            adjustTableID = adjTable.getId().toString();
            currencyID = localCurrencyID;
        }
        GLAcctAgeNewUtils.insertAdjExchTempTableData(paramAge, historyDate, tempateTable, companyId, adjustTableID, currencyID);
        String adjustRptTableID = adjTable.getId().toString();
        if (!StringUtils.isEmpty((String)reportCurrencyID) && 3 == reportConvertMode && !localCurrencyID.equalsIgnoreCase(reportCurrencyID)) {
            GLAcctAgeNewUtils.insertAdjExchTempTableRptData(paramAge, historyDate, tempateTable, companyId, localCurrencyID, reportCurrencyID, adjustRptTableID);
        }
    }

    public static String creatAdjexchTempTableWhenUnion(AccountAgeParam paramAge) throws BOSException, EASBizException {
        String companyIdStr = paramAge.getCompanyId();
        if (StringUtils.isEmpty((String)companyIdStr)) {
            return null;
        }
        java.util.Date historyDate = paramAge.getHistoryDate();
        CompanyOrgUnitCollection allCompany = GLAcctAgeNewUtils.getCompanys(paramAge.getCtx(), companyIdStr, GLAcctAgeNewUtils.getCompanySelectorAboutAdjust());
        if (paramAge.getLocalOrRpt() == 1) {
            paramAge.setGeneralCurrency(allCompany.get(0).getBaseCurrency());
        } else if (paramAge.getLocalOrRpt() == 2) {
            paramAge.setGeneralCurrency(allCompany.get(0).getReportCurrency());
        }
        String tempTable = GLAcctAgeNewUtils.createAdjExchTempTable(paramAge.getCtx());
        for (int i = 0; i < allCompany.size(); ++i) {
            CompanyOrgUnitInfo company = allCompany.get(i);
            GLAcctAgeNewUtils.createAdjExchTempTableDataForSingleCompany(paramAge, company, historyDate, tempTable);
        }
        return tempTable;
    }

    private static void insertAdjExchTempTableRptData(AccountAgeParam paramAge, java.util.Date historyDate, String tempateTable, String companyId, String localCurrencyID, String reportCurrencyID, String adjustRptTableID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempateTable);
        sql.append(" values('").append(localCurrencyID).append("','").append(companyId).append("',1.0,1.0 ) \r\n");
        DbUtil.execute((Context)paramAge.getCtx(), (String)sql.toString());
        IRowSet rs = null;
        sql.setLength(0);
        sql.append(" select aa.FSourceCurrencyID fid, ? FCompanyId,aa.FCONVERTRATEA,aa.FPRECISION  \r\n");
        sql.append(" from (  \r\n");
        sql.append(GLAcctAgeNewUtils.getAdjexchTempTableSubSql());
        sql.append(" and aux.FSourceCurrencyID = ? ");
        sql.append(" ) aa inner join (  \r\n");
        sql.append(" select FSourceCurrencyID, ? FCompanyId,min(FQUOTEPRICE) FQUOTEPRICE  \r\n");
        sql.append(" from (  \r\n");
        sql.append(GLAcctAgeNewUtils.getAdjexchTempTableSubSql());
        sql.append(" and aux.FSourceCurrencyID = ? ");
        sql.append(" ) bb  group by FSourceCurrencyID ) b_bb  \r\n");
        sql.append(" on aa.FSourceCurrencyID = b_bb.FSourceCurrencyID  \r\n");
        sql.append(" and aa.FQUOTEPRICE = b_bb.FQUOTEPRICE  \r\n");
        Object[] params = new Object[14];
        int index = 0;
        params[index++] = companyId;
        params[index++] = adjustRptTableID;
        params[index++] = new Timestamp(historyDate.getTime());
        params[index++] = adjustRptTableID;
        params[index++] = new Timestamp(historyDate.getTime());
        params[index++] = reportCurrencyID;
        params[index++] = localCurrencyID;
        params[index++] = companyId;
        params[index++] = adjustRptTableID;
        params[index++] = new Timestamp(historyDate.getTime());
        params[index++] = adjustRptTableID;
        params[index++] = new Timestamp(historyDate.getTime());
        params[index++] = reportCurrencyID;
        params[index++] = localCurrencyID;
        rs = DbUtil.executeQuery((Context)paramAge.getCtx(), (String)sql.toString(), (Object[])params);
        try {
            if (rs.next()) {
                BigDecimal local2RptExchRate = rs.getBigDecimal("FCONVERTRATEA");
                sql.setLength(0);
                sql.append("update " + tempateTable);
                sql.append(" set FCONVERTRATEA = FCONVERTRATEA*?");
                params = new Object[1];
                index = 0;
                params[index++] = local2RptExchRate;
                DbUtil.execute((Context)paramAge.getCtx(), (String)sql.toString(), (Object[])params);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private static void insertAdjExchTempTableData(AccountAgeParam paramAge, java.util.Date historyDate, String tempateTable, String companyId, String adjustTableID, String currencyID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("\r\n select aa.FSourceCurrencyID fid, ? FCompanyId,aa.FCONVERTRATEA,aa.FPRECISION  \r\n");
        sql.append(" from (  \r\n");
        sql.append(GLAcctAgeNewUtils.getAdjexchTempTableSubSql());
        sql.append(" ) aa inner join (  \r\n");
        sql.append(" select FSourceCurrencyID,? FCompanyId,min(FQUOTEPRICE) FQUOTEPRICE  \r\n");
        sql.append(" from (  \r\n");
        sql.append(GLAcctAgeNewUtils.getAdjexchTempTableSubSql());
        sql.append(" ) bb  group by FSourceCurrencyID ) b_bb  \r\n");
        sql.append(" on aa.FSourceCurrencyID = b_bb.FSourceCurrencyID  \r\n");
        sql.append(" and aa.FQUOTEPRICE = b_bb.FQUOTEPRICE  \r\n");
        int index = 0;
        Object[] params = new Object[12];
        params[index++] = companyId;
        params[index++] = adjustTableID;
        params[index++] = new Timestamp(historyDate.getTime());
        params[index++] = adjustTableID;
        params[index++] = new Timestamp(historyDate.getTime());
        params[index++] = currencyID;
        params[index++] = companyId;
        params[index++] = adjustTableID;
        params[index++] = new Timestamp(historyDate.getTime());
        params[index++] = adjustTableID;
        params[index++] = new Timestamp(historyDate.getTime());
        params[index++] = currencyID;
        IRowSet rs1 = DbUtil.executeQuery((Context)paramAge.getCtx(), (String)sql.toString(), (Object[])params);
        try {
            String insertAdjexsql = " insert into " + tempateTable + "(FID,FCompanyId,FCONVERTRATEA, FPRECISION) values  (?,?,?, ?) ";
            if (rs1 != null) {
                while (rs1.next()) {
                    String fid = rs1.getString("fid");
                    String fCompanyId = rs1.getString("FCompanyId");
                    BigDecimal fconvertratea = rs1.getBigDecimal("FCONVERTRATEA");
                    BigDecimal fprecision = rs1.getBigDecimal("FPRECISION");
                    DbUtil.execute((Context)paramAge.getCtx(), (String)insertAdjexsql, (Object[])new Object[]{fid, fCompanyId, fconvertratea, fprecision});
                }
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs1);
        }
    }

    private static String createAdjExchTempTable(Context ctx) throws BOSException {
        String craeteTableSQL = "CREATE TABLE AccountAgeAdjExchTempTable (FID varchar (44) NOT NULL,FCompanyId varchar(44) NOT NULL,FConvertRateA  NUMERIC(28,10),FPRECISION  NUMERIC(28,10))";
        try {
            String tempateTable = TempTablePool.getInstance((Context)ctx).createTempTable(craeteTableSQL);
            return tempateTable;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static CompanyOrgUnitCollection getCompanys(Context ctx, String compnayIdStr, SelectorItemCollection selector) throws BOSException {
        if (StringUtils.isEmpty((String)compnayIdStr)) {
            return null;
        }
        String[] companyIdArray = compnayIdStr.replace("'", "").split(",");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        filterItems.add(new FilterItemInfo("id", new HashSet<String>(Arrays.asList(companyIdArray)), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(selector);
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(viewInfo);
    }

    private static SelectorItemCollection getCompanySelectorAboutAdjust() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("baseCurrency.id");
        selector.add("baseCurrency.precision");
        selector.add("reportCurrency.id");
        selector.add("reportCurrency.precision");
        selector.add("baseExchangeTable.id");
        selector.add("reportExchangeTable.id");
        selector.add("adjustExchangeTable.id");
        selector.add("reportConvertMode");
        return selector;
    }

    public static int setupLeftParam(String accountid, String currencyid, String companyid, boolean isAccountList, String accountFromNumber, String accountToNumber, boolean isSetCurrency, ArrayList alAstNumbers, PreparedStatement ps, List params, int index, String accountViewNumber, SqlParams spp) throws SQLException {
        for (String number : alAstNumbers) {
            ps.setString(index++, number);
            spp.setString(index, number);
            params.add(number);
        }
        if (!isAccountList && accountViewNumber == null && accountid != null) {
            ps.setString(index++, accountid);
            spp.setString(index, accountid);
            params.add(accountid);
        }
        if (companyid != null && companyid.length() > 0) {
            ps.setString(index++, companyid);
            spp.setString(index, companyid);
            params.add(companyid);
        }
        if (isSetCurrency) {
            ps.setString(index++, currencyid);
            spp.setString(index, currencyid);
            params.add(currencyid);
        }
        if (isAccountList) {
            if (accountFromNumber != null) {
                ps.setString(index++, accountFromNumber);
                spp.setString(index, accountFromNumber);
                params.add(accountFromNumber);
            }
            if (accountToNumber != null) {
                ps.setString(index++, accountToNumber + "zzzzzz");
                spp.setString(index, accountToNumber + "zzzzzz");
                params.add(accountToNumber + "zzzzzz");
            }
        }
        return index;
    }

    public static int setupParams_ByBal_InsertSum(boolean isOnlyUnion, boolean isInitParam, String accountid, AccountAgeParam paramAge, java.util.Date historyDate, ArrayList alDates, List params, int index, String accountViewNumber, java.util.Date lastPhaseBeginDate) throws SQLException {
        String currencyid = paramAge.getCurrencyid();
        String companyid = paramAge.getCompanyId();
        if (paramAge.isIsOnlyUnion()) {
            companyid = paramAge.getCurCompanyid();
        }
        boolean isAccountList = paramAge.isAccountList();
        String accountFromNumber = paramAge.getAccountFromNumber();
        String accountToNumber = paramAge.getAccountToNumber();
        boolean isSetCurrency = paramAge.isSetCurrency();
        ArrayList alAstNumbers = paramAge.getAlAstNumbers();
        Iterator iter = null;
        for (String number : alAstNumbers) {
            params.add(number);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(historyDate);
        params.add(new Date(cal.getTimeInMillis()));
        if (!isAccountList && StringUtils.isEmpty((String)accountViewNumber) && !StringUtils.isEmpty((String)accountid)) {
            params.add(accountid);
        }
        if (!(StringUtils.isEmpty((String)companyid) || paramAge.isIsOnlyUnion() && !paramAge.isIsfirstload() && paramAge.getDisplayMode() == 4)) {
            if (paramAge.isCompanyExpandOnUnion()) {
                params.add(paramAge.getCurCompanyLevel());
            } else {
                params.add(companyid);
            }
        }
        if (lastPhaseBeginDate != null) {
            cal.setTime(lastPhaseBeginDate);
            params.add(new Date(cal.getTimeInMillis()));
        }
        if (isSetCurrency) {
            params.add(currencyid);
        }
        if (isAccountList) {
            if (accountFromNumber != null) {
                params.add(accountFromNumber);
            }
            if (accountToNumber != null) {
                params.add(accountToNumber + "zzzzzz");
            }
        }
        return index;
    }

    public static int setupParams_ByAcctBal_InsertSum(boolean isOnlyUnion, boolean isInitParam, String accountid, AccountAgeParam paramAge, java.util.Date historyDate, ArrayList alDates, PreparedStatement ps, List params, int index, String accountViewNumber, SqlParams spp, java.util.Date lastPhaseBeginDate) throws SQLException {
        String currencyid = paramAge.getCurrencyid();
        String companyid = paramAge.getCompanyId();
        if (paramAge.isIsOnlyUnion()) {
            companyid = paramAge.getCurCompanyid();
        }
        boolean isAccountList = paramAge.isAccountList();
        String accountFromNumber = paramAge.getAccountFromNumber();
        String accountToNumber = paramAge.getAccountToNumber();
        boolean isSetCurrency = paramAge.isSetCurrency();
        ArrayList alAstNumbers = paramAge.getAlAstNumbers();
        Iterator iter = null;
        if (!paramAge.isIncludeVerifyVch()) {
            for (Date date : alDates) {
                ps.setDate(index++, date);
                spp.setDate(index, date);
                params.add(date);
            }
        }
        for (String number : alAstNumbers) {
            ps.setString(index++, number);
            spp.setString(index, number);
            params.add(number);
        }
        Calendar cal = Calendar.getInstance();
        if (!isInitParam) {
            cal.setTime(historyDate);
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
            spp.setDate(index, new Date(cal.getTimeInMillis()));
            params.add(new Date(cal.getTimeInMillis()));
        }
        if (!isAccountList && StringUtils.isEmpty((String)accountViewNumber) && !StringUtils.isEmpty((String)accountid)) {
            ps.setString(index++, accountid);
            spp.setString(index, accountid);
            params.add(accountid);
        }
        if (!StringUtils.isEmpty((String)companyid)) {
            ps.setString(index++, companyid);
            spp.setString(index, companyid);
            params.add(companyid);
            if (!isOnlyUnion && !isInitParam) {
                ps.setString(index++, companyid);
                spp.setString(index, companyid);
                params.add(companyid);
            }
        }
        if (lastPhaseBeginDate != null) {
            cal.setTime(lastPhaseBeginDate);
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
            spp.setDate(index, new Date(cal.getTimeInMillis()));
            params.add(new Date(cal.getTimeInMillis()));
        }
        if (isSetCurrency) {
            ps.setString(index++, currencyid);
            spp.setString(index, currencyid);
            params.add(currencyid);
        }
        if (isAccountList) {
            if (accountFromNumber != null) {
                ps.setString(index++, accountFromNumber);
                spp.setString(index, accountFromNumber);
                params.add(accountFromNumber);
            }
            if (accountToNumber != null) {
                ps.setString(index++, accountToNumber + "zzzzzz");
                spp.setString(index, accountToNumber + "zzzzzz");
                params.add(accountToNumber + "zzzzzz");
            }
        }
        return index;
    }

    public static int setupParams_ByBal_InsertBal(String companyid, String accountid, String currencyid, boolean isAccountList, String accountFromNumber, String accountToNumber, boolean isSetCurrency, ArrayList alAstNumbers, PreparedStatement ps, int index, String accountViewNumber, String lastPhaseEndPeriodId) throws SQLException {
        for (String number : alAstNumbers) {
            ps.setString(index++, number);
        }
        if (isAccountList || accountViewNumber != null || accountid != null) {
            // empty if block
        }
        if (companyid != null && companyid.length() > 0) {
            ps.setString(index++, companyid);
        }
        if (isSetCurrency) {
            ps.setString(index++, currencyid);
        }
        if (isAccountList) {
            if (accountFromNumber != null) {
                ps.setString(index++, accountFromNumber);
            }
            if (accountToNumber != null) {
                ps.setString(index++, accountToNumber + "zzzzzz");
            }
        }
        ps.setString(index++, lastPhaseEndPeriodId);
        return index;
    }

    public static int setupParams_ByBal_InsertSumVeri(AccountAgeParam paramAge, PreparedStatement ps, int index, boolean isInit) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        HashMap map = paramAge.getParams();
        if (map == null) {
            map = new HashMap();
        }
        map.put("veriParam", params);
        for (String number : paramAge.getAlAstNumbers()) {
            ps.setString(index++, number);
            params.add(number);
        }
        Calendar cal = Calendar.getInstance();
        Date date = null;
        if (!isInit) {
            cal.setTime(paramAge.getHistoryDate());
            date = new Date(cal.getTimeInMillis());
            ps.setDate(index++, date);
            params.add(date);
        }
        if (paramAge.isAccountList() || paramAge.getAccountViewNumber() != null || paramAge.getAccountid() != null) {
            // empty if block
        }
        if (!StringUtils.isEmpty((String)paramAge.getCurCompanyid())) {
            ps.setString(index++, paramAge.getCurCompanyid());
            params.add(paramAge.getCurCompanyid());
        }
        if (!isInit && paramAge.getLastPhaseBeginDate() != null) {
            cal.setTime(paramAge.getLastPhaseBeginDate());
            date = new Date(cal.getTimeInMillis());
            ps.setDate(index++, date);
            params.add(date);
        }
        if (paramAge.isSetCurrency()) {
            ps.setString(index++, paramAge.getCurrencyid());
            params.add(paramAge.getCurrencyid());
        }
        if (paramAge.isAccountList()) {
            if (!StringUtils.isEmpty((String)paramAge.getAccountFromNumber())) {
                ps.setString(index++, paramAge.getAccountFromNumber());
                params.add(paramAge.getAccountFromNumber());
            }
            if (!StringUtils.isEmpty((String)paramAge.getAccountToNumber())) {
                ps.setString(index++, paramAge.getAccountToNumber() + "zzzzzz");
                params.add(paramAge.getAccountToNumber() + "zzzzzz");
            }
        }
        return index;
    }

    public static int setupParams_updateTempTable_ByBal_AcSumFromSumVeri(PreparedStatement ps, int index, List lstParam) throws SQLException {
        for (String number : lstParam) {
            DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)number);
        }
        return index;
    }

    public static StringBuffer queryBizCodeHgid(AccountAgeParam paramAge) throws EASBizException, BOSException {
        StringBuffer queryBizCodeHgid = new StringBuffer();
        Context ctx = paramAge.getCtx();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String accountid = null;
        if (!paramAge.isAccountBC()) {
            accountid = paramAge.getAccountid();
        }
        String bizCodeFromNumber = paramAge.getBizCodeFromNumber();
        String bizCodeToNumber = paramAge.getBizCodeToNumber();
        String bizCodeDistNumbers = paramAge.getBizCodeDistNumbers();
        String companyid = paramAge.getCompanyId();
        StringBuffer sqlSelectHead = new StringBuffer();
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFromCust = new StringBuffer();
        StringBuffer sqlFromSupp = new StringBuffer();
        StringBuffer sqlWhereCommon = new StringBuffer();
        StringBuffer sqlWhere1CUid = new StringBuffer();
        StringBuffer sqlWhere2Assign = new StringBuffer();
        StringBuffer sqlSelectEnd = new StringBuffer();
        sqlSelectHead.append("(select distinct * from (  \r\n");
        sqlSelect.append(" select hg.fid,bac.fid bacid,bac.fnumber bacnumber,bac.fname_").append(loc).append(" bacname  \r\n");
        sqlFromCust.append(" from t_bd_assistanthg hg inner join t_bd_customer cst on hg.fcustomerid = cst.fid  \r\n");
        sqlFromCust.append("   inner join T_BD_BizAnaylysisCode bac on bac.fid = cst.FBizAnalysisCodeID  \r\n");
        sqlFromSupp.append(" from t_bd_assistanthg hg inner join T_BD_Supplier sup on hg.FProviderID = sup.fid  \r\n");
        sqlFromSupp.append("   inner join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID  \r\n");
        sqlSelectEnd.append(") T_Hgid0)  T_Hgid ");
        if (bizCodeDistNumbers != null) {
            String bizCodeDistSqlInStr = GLAcctAgeNewUtils.getSqlIn(Arrays.asList(bizCodeDistNumbers.split(",")));
            sqlWhereCommon.append(" and bac.fnumber in(").append(bizCodeDistSqlInStr).append(") ");
        } else {
            if (bizCodeFromNumber != null) {
                sqlWhereCommon.append(" and bac.fnumber >= '");
                sqlWhereCommon.append(bizCodeFromNumber).append("'");
            }
            if (bizCodeToNumber != null) {
                sqlWhereCommon.append(" and bac.fnumber < '");
                sqlWhereCommon.append(bizCodeToNumber).append("~'");
            }
        }
        if (paramAge.isIsOnlyUnion()) {
            ObjectUuidPK[] cuIds = GLAcctAgeNewUtils.getCuIds(paramAge, ctx);
            if (cuIds == null || cuIds.length == 0) {
                sqlWhere1CUid.append(" where bac.fadmincuid in  (select fcontrolunitid from t_org_company where fid in (").append(companyid).append(")) ");
            } else {
                GLAcctAgeNewUtils.getBizCodeFilter(ctx, sqlWhere1CUid, sqlWhere2Assign, cuIds);
            }
            if (!paramAge.isIsfirstload() && paramAge.isBizCode() && !paramAge.isAccountList() && paramAge.getHmItems().size() != 0) {
                sqlWhere1CUid.append(" and bac.fnumber = '").append(paramAge.getBizCode()).append("'");
            }
            if (accountid != null) {
                if (accountid.indexOf("'") >= 0) {
                    sqlWhereCommon.append(" and bac.fnumber = ");
                    sqlWhereCommon.append(accountid).append("  \r\n");
                } else {
                    sqlWhereCommon.append(" and bac.fnumber = '");
                    sqlWhereCommon.append(accountid).append("'  \r\n");
                }
            }
        } else {
            String[] accountids = accountid == null ? null : accountid.split(",");
            String id = "";
            String curCuid = paramAge.getCompany().getCU().getId().toString();
            if (accountids != null) {
                for (int i = 0; i < accountids.length; ++i) {
                    id = id + "'" + accountids[i] + "',";
                }
                id = id.substring(0, id.length() - 1);
            }
            GLAcctAgeNewUtils.getBizCodeFilter(ctx, sqlWhere1CUid, sqlWhere2Assign, new ObjectUuidPK[]{new ObjectUuidPK(curCuid)});
            if (!id.equals("")) {
                sqlWhereCommon.append(" and bac.fid in (");
                sqlWhereCommon.append(id).append(")  \r\n");
            }
        }
        queryBizCodeHgid.append(sqlSelectHead);
        queryBizCodeHgid.append(sqlSelect);
        queryBizCodeHgid.append(sqlFromCust);
        queryBizCodeHgid.append(sqlWhere1CUid);
        queryBizCodeHgid.append(sqlWhereCommon);
        if (sqlWhere2Assign.length() > 0) {
            queryBizCodeHgid.append("\r\n union all \r\n");
            queryBizCodeHgid.append(sqlSelect);
            queryBizCodeHgid.append(sqlFromCust);
            queryBizCodeHgid.append(sqlWhere2Assign);
            queryBizCodeHgid.append(sqlWhereCommon);
        }
        queryBizCodeHgid.append("\r\n union all \r\n");
        queryBizCodeHgid.append(sqlSelect);
        queryBizCodeHgid.append(sqlFromSupp);
        queryBizCodeHgid.append(sqlWhere1CUid);
        queryBizCodeHgid.append(sqlWhereCommon);
        if (sqlWhere2Assign.length() > 0) {
            queryBizCodeHgid.append("\r\n union all \r\n");
            queryBizCodeHgid.append(sqlSelect);
            queryBizCodeHgid.append(sqlFromSupp);
            queryBizCodeHgid.append(sqlWhere2Assign);
            queryBizCodeHgid.append(sqlWhereCommon);
        }
        queryBizCodeHgid.append(sqlSelectEnd);
        return queryBizCodeHgid;
    }

    private static ObjectUuidPK[] getCuIds(AccountAgeParam paramAge, Context ctx) throws BOSException {
        String companyId = paramAge.getCompanyId();
        String[] comid = (companyId == null ? "" : companyId).split(",");
        HashSet<String> comSet = new HashSet<String>();
        for (int i = 0; i < comid.length; ++i) {
            if (comid[i] != null && comid[i].length() > 1) {
                comSet.add(comid[i].substring(1, comid[i].length() - 1));
                continue;
            }
            comSet.add("");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        EntityViewInfo view = new EntityViewInfo();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("cu.id"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", comSet, CompareType.INCLUDE));
        CompanyOrgUnitCollection col = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        ObjectUuidPK[] cuIds = new ObjectUuidPK[col.size()];
        for (int i = 0; col != null && i < col.size(); ++i) {
            CompanyOrgUnitInfo com = col.get(i);
            cuIds[i] = new ObjectUuidPK(com.getCU().getId().toString());
        }
        return cuIds;
    }

    private static void getBizCodeFilter(Context ctx, StringBuffer sqlWhere1CUid, StringBuffer sqlWhere2Assign, ObjectUuidPK[] cuIds) throws BOSException, EASBizException {
        FilterInfo filter = BizAnalysisCodeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK[])cuIds, "bac.fid", "bac.fadmincuid");
        String strFilter = filter.toString().trim();
        String filter1 = "";
        String filter2 = "";
        int posOfOr = strFilter.indexOf("OR");
        if (posOfOr > 1) {
            filter1 = strFilter.substring(1, posOfOr - 1);
            filter2 = strFilter.substring(posOfOr + 2, strFilter.length() - 1);
        } else {
            filter1 = strFilter;
        }
        sqlWhere1CUid.append(" where ");
        sqlWhere1CUid.append(filter1);
        if (filter2.length() > 0) {
            sqlWhere2Assign.append(" where ");
            sqlWhere2Assign.append(filter2);
        }
    }

    public static String createTempTable4QueryHistory4InTime(AccountAgeParam paramAge) throws BOSException, EASBizException {
        String tempateTable = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx()).getTableName("gl_temp");
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(tempateTable);
        createTable.append("( FCUSSENTID varchar (44) NOT NULL,fdc int");
        createTable.append(", sumoro numeric(28,10) not null default 0)");
        ITableManagerFacade tableManagerFacade = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx());
        tableManagerFacade.createTable(createTable.toString());
        paramAge.setTempTableHistory(tempateTable);
        return tempateTable;
    }

    public static void getSql_ByAcctBal_Param_AlDates(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int[] days = paramAge.getDays();
        int[] undays = paramAge.getUndays();
        java.util.Date endDate = paramAge.getEndDate();
        int daylen = paramAge.getDaylen();
        int undaylen = paramAge.getUndaylen();
        ArrayList<Date> alDates = new ArrayList<Date>(daylen * 2 + 3);
        Date lastPhaseEndDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        alDates.add(new Date(cal.getTimeInMillis()));
        if (paramAge.isRptQuery()) {
            if (paramAge.isShowUmexpired()) {
                days = undays;
            }
            cal.setTime(endDate);
            cal.add(5, -1 * days[0]);
            alDates.add(new Date(cal.getTimeInMillis()));
            if (days.length == 2) {
                cal.setTime(endDate);
                cal.add(5, -1 * days[1]);
                alDates.add(new Date(cal.getTimeInMillis()));
            } else if (!paramAge.isShowUmexpired()) {
                cal.set(1900, 0, 1);
                alDates.add(new Date(cal.getTimeInMillis()));
            }
        } else {
            int i;
            if (paramAge.isShowUmexpired()) {
                cal.setTime(endDate);
                alDates.add(new Date(cal.getTimeInMillis()));
                for (i = 0; i < undaylen; ++i) {
                    cal.setTime(endDate);
                    cal.add(5, -1 * undays[i]);
                    alDates.add(new Date(cal.getTimeInMillis()));
                    cal.setTime(endDate);
                    cal.add(5, -1 * undays[i]);
                    alDates.add(new Date(cal.getTimeInMillis()));
                }
            }
            cal.setTime(endDate);
            alDates.add(new Date(cal.getTimeInMillis()));
            cal.setTime(endDate);
            cal.add(5, -1 * days[0]);
            alDates.add(new Date(cal.getTimeInMillis()));
            for (i = 1; i < daylen; ++i) {
                cal.setTime(endDate);
                cal.add(5, -1 * days[i - 1]);
                alDates.add(new Date(cal.getTimeInMillis()));
                cal.setTime(endDate);
                cal.add(5, -1 * days[i]);
                alDates.add(new Date(cal.getTimeInMillis()));
            }
            cal.setTime(endDate);
            cal.add(5, -1 * days[daylen - 1]);
            lastPhaseEndDate = new Date(cal.getTimeInMillis());
            alDates.add(lastPhaseEndDate);
            cal.set(1900, 0, 1);
            alDates.add(new Date(cal.getTimeInMillis()));
        }
        paramAge.setAlDates(alDates);
        if (!paramAge.isIncludeVerifyVch()) {
            paramAge.setLastPhaseBeginDate(null);
            paramAge.setLastPhaseEndDate(null);
        } else {
            if (!paramAge.isIsOnlyUnion()) {
                PeriodInfo acPeriod = GLAcctAgeNewUtils.getCachePeriodInfo(paramAge.getCtx(), paramAge.getCompanyId());
                if (acPeriod.getBeginDate() != null) {
                    paramAge.setLastPhaseBeginDate(acPeriod.getBeginDate());
                } else {
                    int year = acPeriod.getPeriodYear();
                    int periodNumber = acPeriod.getPeriodNumber();
                    cal.set(year, periodNumber - 1, 1);
                    Date lastPhaseBeginDate = new Date(cal.getTimeInMillis());
                    paramAge.setLastPhaseBeginDate(lastPhaseBeginDate);
                }
            } else {
                cal.set(1900, 9, 1);
                Date lastPhaseBeginDate = new Date(cal.getTimeInMillis());
                paramAge.setLastPhaseBeginDate(lastPhaseBeginDate);
            }
            paramAge.setLastPhaseEndDate(lastPhaseEndDate);
        }
    }

    public static List getListFromSelecthgoutside(StringBuffer sqlSelecthgoutside) {
        ArrayList<String> lst = new ArrayList<String>();
        String sep = ",";
        String sub = "";
        String sql = sqlSelecthgoutside.toString().trim();
        String[] sqlFields = sql.split(sep);
        for (int i = 0; i < sqlFields.length; ++i) {
            lst.add(sqlFields[i]);
        }
        return lst;
    }

    public static int setupParams_ByAcctBal_InsertSub(boolean isInitParam, String accountid, AccountAgeParam paramAge, java.util.Date historyDate, ArrayList alDates, List params, int index, String accountViewNumber, java.util.Date lastPhaseBeginDate) throws SQLException {
        String currencyid = paramAge.getCurrencyid();
        String companyid = paramAge.getCompanyId();
        boolean isAccountList = paramAge.isAccountList();
        String accountFromNumber = paramAge.getAccountFromNumber();
        String accountToNumber = paramAge.getAccountToNumber();
        boolean isSetCurrency = paramAge.isSetCurrency();
        ArrayList alAstNumbers = paramAge.getAlAstNumbers();
        for (String number : alAstNumbers) {
            params.add(number);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(historyDate);
        params.add(new Date(cal.getTimeInMillis()));
        if (!isAccountList && accountViewNumber == null && accountid != null) {
            params.add(accountid);
        }
        if (companyid != null && companyid.length() > 0) {
            params.add(companyid);
        }
        if (lastPhaseBeginDate != null) {
            cal.setTime(lastPhaseBeginDate);
            params.add(new Date(cal.getTimeInMillis()));
        }
        if (isSetCurrency) {
            params.add(currencyid);
        }
        if (isAccountList) {
            if (accountFromNumber != null) {
                params.add(accountFromNumber);
            }
            if (accountToNumber != null) {
                params.add(accountToNumber + "zzzzzz");
            }
        }
        return index;
    }

    public static int setupParams_ByAcctBal_InsertSub_ExistsFutureVeri(boolean isInitParam, String accountid, String currencyid, java.util.Date historyDate, String companyid, boolean isAccountList, String accountFromNumber, String accountToNumber, boolean isSetCurrency, ArrayList alDates, ArrayList alAstNumbers, PreparedStatement ps, List params, int index, String accountViewNumber, SqlParams spp, java.util.Date lastPhaseBeginDate) throws SQLException {
        for (int i = 0; i < 2; ++i) {
            if (companyid != null && companyid.length() > 0) {
                ps.setString(index++, companyid);
                spp.setString(index, companyid);
                params.add(companyid);
                ps.setString(index++, companyid);
                spp.setString(index, companyid);
                params.add(companyid);
            }
            if (!isAccountList && accountViewNumber == null && accountid != null) {
                ps.setString(index++, accountid);
                spp.setString(index, accountid);
                params.add(accountid);
            }
            if (isSetCurrency) {
                ps.setString(index++, currencyid);
                spp.setString(index, currencyid);
                params.add(currencyid);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(historyDate);
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
            spp.setDate(index, new Date(cal.getTimeInMillis()));
            params.add(new Date(cal.getTimeInMillis()));
        }
        return index;
    }

    public static int setupParams_ByAcctBal_InsertSub_ExistsFutureVeri(boolean isInitParam, String accountid, String currencyid, java.util.Date historyDate, String companyid, boolean isAccountList, String accountFromNumber, String accountToNumber, boolean isSetCurrency, ArrayList alDates, ArrayList alAstNumbers, List params, int index, String accountViewNumber, java.util.Date lastPhaseBeginDate) throws SQLException {
        for (int i = 0; i < 2; ++i) {
            if (companyid != null && companyid.length() > 0) {
                params.add(companyid);
                params.add(companyid);
            }
            if (!isAccountList && accountViewNumber == null && accountid != null) {
                params.add(accountid);
            }
            if (isSetCurrency) {
                params.add(currencyid);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(historyDate);
            params.add(new Date(cal.getTimeInMillis()));
        }
        return index;
    }

    public static void getSql_ByBal_AcVeriSum_From(AccountAgeParam paramAge) {
        StringBuffer fromSumVeri = paramAge.getSqlFromVeriSum();
        fromSumVeri.setLength(0);
        fromSumVeri.append(" from t_gl_voucherassistrecord cussent                      \r\n");
        fromSumVeri.append(" inner join t_gl_voucherentry entry on cussent.fentryid=entry.fid  \r\n");
        fromSumVeri.append(" inner join t_gl_voucher voucher on entry.fbillid=voucher.fid     \r\n");
        if (paramAge.isQueryAgeSub() && !paramAge.isIncludeVerifyVch()) {
            fromSumVeri.append(" inner join t_bd_vouchertypes vchType on vchType.fid = voucher.fvouchertypeid  \r\n");
            fromSumVeri.append(" inner join t_bd_period prd on prd.fid = voucher.fperiodid       \r\n");
        }
        fromSumVeri.append(" inner join t_bd_accountview account on entry.faccountid=account.fid  \r\n");
        if (paramAge.isIsOnlyUnion()) {
            fromSumVeri.append(paramAge.getSbCompany4UnionSumVeri());
        }
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            fromSumVeri.append(" inner join t_bd_Currency currency on entry.fcurrencyid = currency.fid  \r\n");
        }
        if (paramAge.isJoinHgTable()) {
            fromSumVeri.append(" inner join t_bd_assistanthg hg on cussent.fassgrpid=hg.fid  \r\n");
        }
        if (paramAge.getSqlBizCodeHgid().length() > 0) {
            fromSumVeri.append(" inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid  \r\n");
        }
    }

    public static void getSql_ByBal_AcVeriSum_From_New(AccountAgeParam paramAge) {
        StringBuffer fromSumVeri = paramAge.getSqlFromVeriSum();
        fromSumVeri.setLength(0);
        fromSumVeri.append(" from T_GL_AcctVerify cussent                      \r\n");
        if (paramAge.isQueryAgeSub()) {
            // empty if block
        }
        if (paramAge.isAccountList() || paramAge.getAccountid() == null || paramAge.isIsOnlyUnion()) {
            fromSumVeri.append(" inner join t_bd_accountview account on cussent.faccountid=account.fid  \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            fromSumVeri.append(paramAge.getSbCompany4UnionSumVeri());
        }
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            fromSumVeri.append(" inner join t_bd_Currency currency on cussent.fcurrencyid = currency.fid  \r\n");
        }
        if (paramAge.isJoinHgTable()) {
            fromSumVeri.append(" inner join t_bd_assistanthg hg on cussent.fassgrpid=hg.fid  \r\n");
        }
        if (paramAge.getSqlBizCodeHgid().length() > 0) {
            fromSumVeri.append(" inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid  \r\n");
        }
    }

    public static void getSql_ByBal_AcVeriSum_Where(AccountAgeParam paramAge) {
        StringBuffer whereSumVeri = paramAge.getSqlWhereVeriSum();
        whereSumVeri.append(" where voucher.fbookeddate <= ?   \r\n");
        if (paramAge.getHgid() != null && paramAge.getHgid().length() > 0) {
            if (paramAge.isBizCode()) {
                whereSumVeri.append(" and T_Hgid.bacid ='").append(paramAge.getHgid()).append("' ");
            } else {
                whereSumVeri.append(" and cussent.fassgrpid = '").append(paramAge.getHgid()).append("' ");
            }
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
        } else {
            whereSumVeri.append(" and account.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
        }
        whereSumVeri.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
        whereSumVeri.append(" and account.FAC = 1   \r\n");
        if (paramAge.isAccountList()) {
            if (paramAge.isBizCode()) {
                // empty if block
            }
        } else if (paramAge.getAccountViewNumber() == null) {
            if (paramAge.isIsOnlyUnion()) {
                whereSumVeri.append(" and entry.faccountid=? ");
            } else {
                whereSumVeri.append(" and entry.faccountid in (" + paramAge.getAccountid() + ")   \r\n");
            }
        } else {
            String accountNumberParam = GLAcctAgeUtils.getNumberForAccountSum(paramAge);
            if (!accountNumberParam.trim().equals("") && accountNumberParam != null) {
                whereSumVeri.append(" and account.Fnumber in (" + accountNumberParam + ")   \r\n");
            } else if (paramAge.isIsOnlyUnion() && !paramAge.isAccountList() && paramAge.getAccountViewNumber() != null) {
                whereSumVeri.append(" and account.Fnumber like '" + paramAge.getAccountViewNumber() + "%'   \r\n");
            }
        }
        if (paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" \r\n and voucher.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" ) ");
            whereSumVeri.append(" \r\n and company.fid in ( ").append(paramAge.getCompanyId()).append(" ) and ");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                whereSumVeri.append(" (");
            }
            whereSumVeri.append(" sumcompany");
            if (paramAge.isIsfirstload()) {
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    whereSumVeri.append(".fid = ?");
                    whereSumVeri.append(" or sumcompany.fisleaf = 1 )");
                } else if (paramAge.isCompanyExpandOnUnion()) {
                    whereSumVeri.append(".flevel >=? ");
                } else {
                    whereSumVeri.append(".fid = ? ");
                }
            } else if (paramAge.getDisplayMode() == 4) {
                whereSumVeri.append(".fisleaf = 1");
            } else {
                whereSumVeri.append(".fparentid = ?");
            }
        } else {
            whereSumVeri.append(" and voucher.fcompanyid = ?   \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" and voucher.fperiodid in (select fperiodid from v_gl_acperiod where fcompanyid=voucher.fcompanyid) \r\n");
        }
        whereSumVeri.append(" and voucher.fbookeddate >= ?   \r\n");
        if (!paramAge.isIncludeUnPosted() && paramAge.isIncludeVerifyVch()) {
            whereSumVeri.append(" and voucher.FBizStatus=5  \r\n");
        } else {
            whereSumVeri.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2   \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereSumVeri.append(" and entry.fcurrencyid = ?   \r\n");
        }
        if (paramAge.isAccountList()) {
            GLAcctAgeUtils.buildAccountSql(whereSumVeri, paramAge.getAccountParams(), "account.fnumber");
        }
        whereSumVeri.append("  \r\n and ((entry.fentrydc * 2) - 1) <> account.fdc  \r\n");
    }

    public static List getUnVerifyParam(AccountAgeParam paramAge, boolean isHistory) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (String number : paramAge.getAlAstNumbers()) {
            params.add(number);
        }
        Calendar cal = Calendar.getInstance();
        Date date = null;
        cal.setTime(paramAge.getHistoryDate());
        date = new Date(cal.getTimeInMillis());
        params.add(date);
        if (isHistory) {
            params.add(date);
        }
        if (!StringUtils.isEmpty((String)paramAge.getCurCompanyid()) && !paramAge.isRptQuery()) {
            if (!paramAge.isIsOnlyUnion()) {
                params.add(paramAge.getCurCompanyid());
            } else if (paramAge.isIsfirstload()) {
                if (paramAge.getDisplayMode() != 4 && paramAge.isCompanyExpandOnUnion()) {
                    params.add(paramAge.getCurCompanyLevel());
                } else {
                    params.add(paramAge.getCurCompanyid());
                }
            } else if (paramAge.getDisplayMode() != 4) {
                params.add(paramAge.getCurCompanyid());
            }
        }
        if (paramAge.getLastPhaseBeginDate() != null && !isHistory) {
            cal.setTime(paramAge.getLastPhaseBeginDate());
            date = new Date(cal.getTimeInMillis());
            params.add(date);
        }
        if (paramAge.isSetCurrency()) {
            params.add(paramAge.getCurrencyid());
        }
        if (paramAge.isAccountList()) {
            if (!StringUtils.isEmpty((String)paramAge.getAccountFromNumber())) {
                params.add(paramAge.getAccountFromNumber());
            }
            if (!StringUtils.isEmpty((String)paramAge.getAccountToNumber())) {
                params.add(paramAge.getAccountToNumber() + "zzzzzz");
            }
        }
        return params;
    }

    public static StringBuffer getHistorySqlUnVerify(AccountAgeParam paramAge) throws BOSException, EASBizException {
        StringBuffer historySql = new StringBuffer();
        String amountField = "khis.FOroginalAmount";
        String dateField = paramAge.getStrDateType_AC();
        dateField = !paramAge.isRptQuery() ? (!dateField.equalsIgnoreCase("fenddate") ? "cussent.fvarbizdate fbizDate," : "cussent.fenddate fbizDate,") : "cussent.fvarbizdate fbizDate,cussent.fenddate fenddate,";
        StringBuilder selector = new StringBuilder();
        if (paramAge.isQueryAgeSub()) {
            selector.append(paramAge.getSqlSelecthg());
            Map param = paramAge.getParams();
            selector.append(param.get("selector"));
        } else {
            selector.append(paramAge.getSqlSelecthg()).append(amountField).append(" FUnVerifiedAmtFor,").append(dateField).append("cussent.fbiznumber FBizNumber");
        }
        historySql.append("select ").append((CharSequence)selector).append(" \r\n").append(GLAcctAgeNewUtils.getSql_ByBal_Verified_From(paramAge, false, true)).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(GLAcctAgeNewUtils.getSql_ByBal_Verified_Where(paramAge, false, true));
        historySql.append("\r\n UNION ALL \r\n");
        historySql.append("select ").append((CharSequence)selector).append(" \r\n").append(GLAcctAgeNewUtils.getSql_ByBal_Verified_From(paramAge, false, false)).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(GLAcctAgeNewUtils.getSql_ByBal_Verified_Where(paramAge, false, false)).append(" \r\n");
        return historySql;
    }

    public static StringBuffer getHistorySqlUnAcVerify(AccountAgeParam paramAge) throws BOSException, EASBizException {
        StringBuffer historySql = new StringBuffer();
        String amountField = "khis.FOroginalAmount";
        String dateField = paramAge.getStrDateType_AC();
        dateField = !paramAge.isRptQuery() ? (!dateField.equalsIgnoreCase("fenddate") ? "cussent.fvarbizdate fbizDate," : "cussent.fenddate fbizDate,") : "cussent.fvarbizdate fbizDate,cussent.fenddate fenddate,";
        StringBuilder selector = new StringBuilder();
        if (paramAge.isQueryAgeSub()) {
            selector.append(paramAge.getSqlSelecthg());
            Map param = paramAge.getParams();
            selector.append(param.get("selector"));
        } else {
            selector.append(paramAge.getSqlSelecthg()).append(amountField).append(" FUnVerifiedAmtFor,").append(dateField).append("cussent.fbiznumber FBizNumber");
        }
        historySql.append("select ").append((CharSequence)selector).append(" \r\n").append(GLAcctAgeNewUtils.getSql_ByBal_Verified_From(paramAge, true, true)).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(GLAcctAgeNewUtils.getSql_ByBal_Verified_Where(paramAge, true, true));
        return historySql;
    }

    public static void getSql_ByBal_AcVeriSum_Where_New(AccountAgeParam paramAge) {
        StringBuffer whereSumVeri = paramAge.getSqlWhereVeriSum();
        whereSumVeri.append(" where cussent.fbookeddate <= ?   \r\n");
        if (paramAge.getHgid() != null && paramAge.getHgid().length() > 0) {
            if (paramAge.isBizCode()) {
                whereSumVeri.append(" and T_Hgid.bacid ='").append(paramAge.getHgid()).append("' ");
            } else {
                whereSumVeri.append(" and cussent.fassgrpid = '").append(paramAge.getHgid()).append("' ");
            }
        }
        if (paramAge.isAccountList()) {
            // empty if block
        }
        if (paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" and ");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                whereSumVeri.append(" (");
            }
            whereSumVeri.append(" sumcompany");
            if (paramAge.isIsfirstload()) {
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    whereSumVeri.append(".fid = ?");
                    whereSumVeri.append(" or sumcompany.fisleaf = 1 )");
                } else if (paramAge.isCompanyExpandOnUnion()) {
                    whereSumVeri.append(".flevel >=? ");
                } else {
                    whereSumVeri.append(".fid = ? ");
                }
            } else if (paramAge.getDisplayMode() == 4) {
                whereSumVeri.append(".fisleaf = 1");
            } else {
                whereSumVeri.append(".fparentid = ?");
            }
        } else if (paramAge.isRptQuery()) {
            whereSumVeri.append(" and  cussent.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )");
        } else {
            whereSumVeri.append(" and cussent.fcompanyid = ?   \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" and cussent.fperiodid in (select fperiodid from v_gl_acperiod where fcompanyid=cussent.fcompanyid) \r\n");
        }
        whereSumVeri.append(" and cussent.fbookeddate >= ?   \r\n");
        if (!paramAge.isIncludeUnPosted() && paramAge.isIncludeVerifyVch()) {
            whereSumVeri.append(" and cussent.FIsPost = 1  \r\n");
        } else {
            whereSumVeri.append(" and cussent.FIsPost > -1  \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereSumVeri.append(" and cussent.fcurrencyid = ?   \r\n");
        }
        GLAcctAgeNewUtils.buildAccountFilterOfNumber(paramAge, whereSumVeri, "cussent");
        whereSumVeri.append(" and cussent.funVerifiedAmtFor <> 0   \r\n");
    }

    public static String getSql_ByBal_Verified_From(AccountAgeParam paramAge, boolean isAc, boolean isSameVeri) {
        String table = "T_GL_AcctVerify cussent";
        String cuField = "cussent.FVchAssistRecordID";
        String hisField = "khis.FCUSSENTIDID";
        if (isAc) {
            table = "T_GL_AcctCussent cussent";
            cuField = "cussent.FID";
        }
        if (!isAc && !isSameVeri) {
            hisField = "khis.FVOUCHERASSTIDID";
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" from t_gl_acctcussenthistory khis        \r\n");
        sql.append(" inner join ").append(table).append(" on ").append(cuField).append(" = ").append(hisField);
        if (paramAge.isIsOnlyUnion() && paramAge.isIncludeUnPosted()) {
            sql.append(" inner join ").append(paramAge.getTempTableComVeriMode()).append(" comvm on comvm.FCompanyID = cussent.FCompanyID ");
        }
        if (isAc && !paramAge.isIncludeUnPosted() && (paramAge.isInTimeVerify() || paramAge.isRptQuery())) {
            sql.append(" inner join t_gl_voucher vch on khis.FVERIVCHID = vch.fid and vch.FBizStatus = 5  \r\n");
        }
        if (paramAge.isAccountList() || paramAge.getAccountid() == null || paramAge.isIsOnlyUnion()) {
            sql.append(" inner join t_bd_AccountView account on account.fid = khis.faccountid  \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            sql.append(paramAge.getSbCompany4UnionSumVeri());
        }
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            sql.append(" inner join t_bd_Currency currency on currency.fid = khis.fcurrencyid  \r\n");
        }
        if (paramAge.isJoinHgTable()) {
            sql.append(" inner join t_bd_assistanthg hg on hg.fid = khis.fassgrpid  \r\n");
        }
        if (paramAge.getSqlBizCodeHgid().length() > 0) {
            sql.append(" inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid  \r\n");
        }
        return sql.toString();
    }

    public static String getSql_ByBal_Verified_Where(AccountAgeParam paramAge, boolean isAC, boolean isSameVeri) {
        StringBuffer sql = new StringBuffer();
        if (isAC) {
            sql.append(" where khis.FVCHDATE <= ?    \r\n");
            sql.append(" and khis.FVerVchDate > ?     \r\n");
            sql.append(" and khis.FDC <> 3       \r\n");
        } else if (isSameVeri) {
            sql.append(" where khis.FVCHDATE <= ?    \r\n");
            sql.append(" and khis.FVerVchDate > ?     \r\n");
            sql.append(" and khis.FDC = 3       \r\n");
        } else {
            sql.append(" where khis.FVCHDATE > ?    \r\n");
            sql.append(" and khis.FVerVchDate <= ?     \r\n");
            sql.append(" and khis.FDC in (0, 2)       \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            if (paramAge.isIsfirstload()) {
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    sql.append(" and (sumcompany.fid = ? or sumcompany.fisleaf = 1 ) ");
                } else if (paramAge.isCompanyExpandOnUnion()) {
                    sql.append(" and sumcompany.flevel >=? ");
                } else {
                    sql.append(" and sumcompany.fid = ? ");
                }
            } else if (paramAge.getDisplayMode() == 4) {
                sql.append("and sumcompany.fisleaf = 1 ");
            } else {
                sql.append("and sumcompany.fparentid = ? ");
            }
        } else if (paramAge.isRptQuery()) {
            sql.append(" and khis.FCOMPANYID in(").append(paramAge.getCompanyId()).append(") ");
        } else {
            sql.append(" and khis.FCOMPANYID = ?       \r\n");
        }
        if (paramAge.isAccountList()) {
            // empty if block
        }
        if (paramAge.isSetCurrency()) {
            sql.append(" and khis.FCURRENCYID = ?      \r\n");
        }
        GLAcctAgeNewUtils.buildAccountFilterOfNumber(paramAge, sql, "khis");
        return sql.toString();
    }

    private static void buildAccountFilterOfNumber(AccountAgeParam paramAge, StringBuffer sql, String alias) {
        if (paramAge.isIsOnlyUnion() || paramAge.getAccountid() == null) {
            String companyids = paramAge.getCompanyId();
            if (paramAge.getTempTableCompany() != null) {
                sql.append(" and account.fcompanyid in (select fid from ").append(paramAge.getTempTableCompany()).append(")  \r\n");
            } else if (!StringUtils.isEmpty((String)companyids) && companyids.startsWith("'") && companyids.endsWith("'")) {
                sql.append(" and account.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
            } else {
                sql.append(" and account.fcompanyid in ( '").append(paramAge.getCompanyId()).append("' )  \r\n");
            }
            sql.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
            sql.append(" and account.FAC = 1   \r\n");
        } else if (paramAge.getIndexType() == 1 && paramAge.getAcctTableId() != null) {
            sql.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
        }
        if (paramAge.isAccountList()) {
            GLAcctAgeUtils.buildAccountSql(sql, paramAge.getAccountParams(), "account.fnumber");
        } else if (paramAge.getAccountid() != null) {
            sql.append(" and ").append(alias).append(".FACCOUNTID in( ").append(paramAge.getAccountid()).append(")  \r\n");
        } else if (paramAge.getAccountViewNumber() != null) {
            String accountNumberParam = GLAcctAgeUtils.getNumberForAccountSum(paramAge);
            if (!accountNumberParam.trim().equals("") && accountNumberParam != null) {
                sql.append(" and account.Fnumber in (" + accountNumberParam + ")   \r\n");
            } else if (paramAge.isIsOnlyUnion() && !paramAge.isAccountList() && paramAge.getAccountViewNumber() != null) {
                sql.append(" and account.Fnumber like '" + paramAge.getAccountViewNumber() + "%'   \r\n");
            }
        }
    }

    public static void getSql_ByBal_VerifiedSum_NotInit_From(AccountAgeParam paramAge) {
        StringBuffer fromSumVeri = paramAge.getSqlFromVerifiedSum_NotInit();
        fromSumVeri.setLength(0);
        fromSumVeri.append(" from t_gl_acctcussenthistory khis        \r\n");
        fromSumVeri.append(" inner join t_gl_voucher voucher on voucher.fid = khis.FVeriVchID           \r\n");
        fromSumVeri.append(" INNER JOIN t_gl_voucherassistrecord cussent on cussent.fid =khis.FVoucherAsstIDID     ---\u6309\u6838\u9500\u51ed\u8bc1\u7684\u65e5\u671f\u5206\u8d26\u9f84        \r\n");
        fromSumVeri.append(" inner join t_bd_accountview account on account.fid  = khis.faccountid       \r\n");
        if (paramAge.isIsOnlyUnion()) {
            fromSumVeri.append(paramAge.getSbCompany4UnionSumVeri());
        }
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            fromSumVeri.append(" inner join t_bd_Currency currency on currency.fid = khis.fcurrencyid  \r\n");
        }
        if (paramAge.isJoinHgTable()) {
            fromSumVeri.append(" inner join t_bd_assistanthg hg on hg.fid = khis.fassgrpid  \r\n");
        }
        if (paramAge.getSqlBizCodeHgid().length() > 0) {
            fromSumVeri.append(" inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid  \r\n");
        }
    }

    public static void getSql_ByBal_VerifiedSum_Init_From(AccountAgeParam paramAge) {
        StringBuffer fromSumVeri = paramAge.getSqlFromVerifiedSum_Init();
        fromSumVeri.append(" from t_gl_acctcussenthistory khis        \r\n");
        fromSumVeri.append(" inner join t_gl_voucher voucher on voucher.fid = khis.FVeriVchID        \r\n");
        fromSumVeri.append(" INNER JOIN t_gl_voucherassistrecord cussent on cussent.fid = khis.FVoucherAsstIDID     ---\u6838\u9500\u8d26\u51ed\u8bc1\u7684\u65e5\u671f\u5206\u8d26\u9f84        \r\n");
        fromSumVeri.append(" inner join t_bd_accountview account on khis.faccountid = account.fid        \r\n");
        if (paramAge.isIsOnlyUnion()) {
            String sb = paramAge.getSbCompany4UnionSumVeri().toString();
            sb = sb.replaceAll("on voucher.fcompanyid", "on khis.fcompanyid");
            fromSumVeri.append(sb);
        }
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            fromSumVeri.append(" inner join t_bd_Currency currency on khis.fcurrencyid=currency.fid  \r\n");
        }
        if (paramAge.isJoinHgTable()) {
            fromSumVeri.append(" inner join t_bd_assistanthg hg on khis.fassgrpid=hg.fid  \r\n");
        }
        if (paramAge.getSqlBizCodeHgid().length() > 0) {
            fromSumVeri.append(" inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid  \r\n");
        }
    }

    public static void getSql_ByBal_VerifiedSum_NotInit_Where(AccountAgeParam paramAge) {
        StringBuffer whereSumVeri = paramAge.getSqlWhereVerifiedSum_NotInit();
        whereSumVeri.setLength(0);
        whereSumVeri.append(" where khis.fdc IN (0, 2) AND khis.fvchdate <= ?                        \r\n");
        if (paramAge.getHgid() != null && paramAge.getHgid().length() > 0) {
            if (paramAge.isBizCode()) {
                whereSumVeri.append(" and T_Hgid.bacid ='").append(paramAge.getHgid()).append("' ");
            } else {
                whereSumVeri.append(" and cussent.fassgrpid = '").append(paramAge.getHgid()).append("' ");
            }
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
        } else {
            whereSumVeri.append(" and account.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
        }
        whereSumVeri.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
        if (paramAge.isAccountList()) {
            if (paramAge.isBizCode()) {
                // empty if block
            }
        } else if (paramAge.getAccountViewNumber() == null) {
            whereSumVeri.append(" and khis.faccountid in (" + paramAge.getAccountid() + ")   \r\n");
        } else {
            String accountNumberParam = GLAcctAgeUtils.getNumberForAccountSum(paramAge);
            if (!accountNumberParam.trim().equals("") && accountNumberParam != null) {
                whereSumVeri.append(" and account.Fnumber in (" + accountNumberParam + ")   \r\n");
            } else if (paramAge.isIsOnlyUnion() && !paramAge.isAccountList() && paramAge.getAccountViewNumber() != null) {
                whereSumVeri.append(" and account.Fnumber like '" + paramAge.getAccountViewNumber() + "%'   \r\n");
            }
        }
        if (paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" \r\n and khis.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" ) ");
            whereSumVeri.append(" \r\n and company.fid in ( ").append(paramAge.getCompanyId()).append(" ) and ");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                whereSumVeri.append(" (");
            }
            whereSumVeri.append(" sumcompany");
            if (paramAge.isIsfirstload()) {
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    whereSumVeri.append(".fid = ?");
                    whereSumVeri.append(" or sumcompany.fisleaf = 1 )");
                } else if (paramAge.isCompanyExpandOnUnion()) {
                    whereSumVeri.append(".flevel >=? ");
                } else {
                    whereSumVeri.append(".fid = ? ");
                }
            } else if (paramAge.getDisplayMode() == 4) {
                whereSumVeri.append(".fisleaf = 1");
            } else {
                whereSumVeri.append(".fparentid = ?");
            }
        } else {
            whereSumVeri.append(" and khis.fcompanyid = ?   \r\n");
        }
        whereSumVeri.append(" and voucher.fbookeddate >= ?   \r\n");
        if (!paramAge.isIncludeUnPosted()) {
            whereSumVeri.append(" and voucher.FBizStatus=5  \r\n");
        } else {
            whereSumVeri.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2   \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereSumVeri.append(" and khis.fcurrencyid = ?   \r\n");
        }
        if (paramAge.isAccountList()) {
            GLAcctAgeUtils.buildAccountSql(whereSumVeri, paramAge.getAccountParams(), "account.fnumber");
        }
        whereSumVeri.append("   AND voucher.fbookeddate <=  ?  \r\n");
    }

    public static void getSql_ByBal_VerifiedSum_Init_Where(AccountAgeParam paramAge) {
        StringBuffer whereSumVeri = paramAge.getSqlWhereVerifiedSum_Init();
        whereSumVeri.setLength(0);
        whereSumVeri.append(" where khis.fdc IN (0, 2) AND khis.fvchdate is null                       \r\n");
        if (paramAge.getHgid() != null && paramAge.getHgid().length() > 0) {
            if (paramAge.isBizCode()) {
                whereSumVeri.append(" and T_Hgid.bacid ='").append(paramAge.getHgid()).append("' ");
            } else {
                whereSumVeri.append(" and cussent.fassgrpid = '").append(paramAge.getHgid()).append("' ");
            }
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
        } else {
            whereSumVeri.append(" and account.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
        }
        whereSumVeri.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
        if (paramAge.isAccountList()) {
            if (paramAge.isBizCode()) {
                // empty if block
            }
        } else if (paramAge.getAccountViewNumber() == null) {
            whereSumVeri.append(" and khis.faccountid in (" + paramAge.getAccountid() + ")   \r\n");
        } else {
            String accountNumberParam = GLAcctAgeUtils.getNumberForAccountSum(paramAge);
            if (!accountNumberParam.trim().equals("") && accountNumberParam != null) {
                whereSumVeri.append(" and account.Fnumber in (" + accountNumberParam + ")   \r\n");
            }
        }
        if (paramAge.isIsOnlyUnion()) {
            whereSumVeri.append(" \r\n and khis.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" ) ");
            whereSumVeri.append(" \r\n and company.fid in ( ").append(paramAge.getCompanyId()).append(" ) and ");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                whereSumVeri.append(" (");
            }
            whereSumVeri.append(" sumcompany");
            if (paramAge.isIsfirstload()) {
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    whereSumVeri.append(".fid = ?");
                    whereSumVeri.append(" or sumcompany.fisleaf = 1 )");
                } else if (paramAge.isCompanyExpandOnUnion()) {
                    whereSumVeri.append(".flevel >=? ");
                } else {
                    whereSumVeri.append(".fid = ? ");
                }
            } else if (paramAge.getDisplayMode() == 4) {
                whereSumVeri.append(".fisleaf = 1");
            } else {
                whereSumVeri.append(".fparentid = ?");
            }
        } else {
            whereSumVeri.append(" and khis.fcompanyid = ?   \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereSumVeri.append(" and khis.fcurrencyid = ?   \r\n");
        }
        if (paramAge.isAccountList()) {
            GLAcctAgeUtils.buildAccountSql(whereSumVeri, paramAge.getAccountParams(), "account.fnumber");
        }
        whereSumVeri.append(" and voucher.fbookeddate <= ?     \r\n");
    }

    public static void getSql_ByAcctBal_AcNotInit_From(AccountAgeParam paramAge) {
        StringBuffer fromTable = paramAge.getSqlFromTable();
        fromTable.append("\r\n  from t_gl_acctcussent cussent  \r\n");
        if (paramAge.isIsOnlyUnion()) {
            // empty if block
        }
        if (paramAge.isQueryAgeSub()) {
            // empty if block
        }
        if (paramAge.isAccountList() || paramAge.getAccountid() == null || paramAge.isIsOnlyUnion() || paramAge.getIndexType() == 1 && paramAge.getAcctTableId() != null) {
            fromTable.append(" inner join t_bd_accountview account on cussent.faccountid=account.fid  \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            StringBuffer sbCompany4Union = paramAge.getSbCompany4Union();
            StringBuffer sbCompany4UnionSumVeri = paramAge.getSbCompany4UnionSumVeri();
            StringBuffer sbJoinTempTableComVeriMode = new StringBuffer();
            sbCompany4Union.append(" \r\n inner join t_org_company company on cussent.fcompanyid = company.fid ");
            sbCompany4Union.append(" \r\n inner join t_org_company sumcompany on charindex(sumcompany.FLongNumber ||'!',company.FLongNumber || '!') = 1  \r\n");
            sbCompany4UnionSumVeri.append(" \r\n inner join t_org_company company on cussent.fcompanyid = company.fid ");
            sbCompany4UnionSumVeri.append(" \r\n inner join t_org_company sumcompany on charindex(sumcompany.FLongNumber ||'!',company.FLongNumber || '!') = 1  \r\n");
            if (paramAge.isIncludeUnPosted()) {
                sbJoinTempTableComVeriMode.append(" \r\n inner join ").append(paramAge.getTempTableComVeriMode()).append(" comvm on comvm.FCompanyID = cussent.FCompanyID ");
            }
            fromTable.append(sbCompany4Union);
            fromTable.append(sbJoinTempTableComVeriMode);
        }
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            fromTable.append(" \r\n inner join t_bd_Currency currency on cussent.fcurrencyid = currency.fid");
        }
        if (paramAge.isJoinHgTable()) {
            fromTable.append(" \r\n inner join t_bd_assistanthg hg on cussent.fassgrpid=hg.fid \r\n");
        }
        if (paramAge.getSqlBizCodeHgid().length() > 0) {
            fromTable.append("\r\n inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid ");
        }
    }

    public static void getSql_ByAcctBal_AcNotInit_Where(AccountAgeParam paramAge) {
        StringBuffer whereNotInit = paramAge.getSqlWhereNotInit();
        StringBuffer whereNotInitBalNotZero = paramAge.getSqlWhereNotInitBalNotZero();
        whereNotInit.append(" \r\n where cussent.fbookeddate <= ?  \r\n");
        whereNotInit.append(" and cussent.fisinit<>1   \r\n");
        if (paramAge.getHgid() != null && paramAge.getHgid().length() > 0) {
            if (paramAge.isBizCode()) {
                whereNotInit.append(" and T_Hgid.bacid ='").append(paramAge.getHgid()).append("' ");
            } else {
                whereNotInit.append(" and cussent.fassgrpid = '").append(paramAge.getHgid()).append("' ");
            }
        }
        if (paramAge.isAccountList()) {
            // empty if block
        }
        if (paramAge.isIsOnlyUnion()) {
            whereNotInit.append(" and ");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                whereNotInit.append(" (");
            }
            whereNotInit.append(" sumcompany");
            if (paramAge.isIsfirstload()) {
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    whereNotInit.append(".fid = ?");
                    whereNotInit.append(" or sumcompany.fisleaf = 1 )");
                } else if (paramAge.isCompanyExpandOnUnion()) {
                    whereNotInit.append(".flevel >=? ");
                } else {
                    whereNotInit.append(".fid = ? ");
                }
            } else if (paramAge.getDisplayMode() == 4) {
                whereNotInit.append(".fisleaf = 1");
            } else {
                whereNotInit.append(".fparentid = ?");
            }
        } else if (paramAge.isRptQuery()) {
            whereNotInit.append(" \r\n and cussent.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" ) ");
        } else {
            whereNotInit.append(" and cussent.fcompanyid = ?  \r\n");
        }
        whereNotInit.append(" and cussent.fperiodid in (select fperiodid from v_gl_acperiod where fcompanyid=cussent.fcompanyid)  \r\n");
        if (paramAge.isIncludeVerifyVch()) {
            whereNotInit.append(" and cussent.fbookeddate >= ?   \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereNotInit.append(" and cussent.fcurrencyid = ?   \r\n");
        }
        GLAcctAgeNewUtils.buildAccountFilterOfNumber(paramAge, whereNotInit, "cussent");
        if (!paramAge.isIncludeUnPosted()) {
            whereNotInit.append(" and cussent.FIsPost = 1  \r\n");
        } else {
            whereNotInit.append(" and cussent.FIsPost > -1  \r\n");
        }
        whereNotInitBalNotZero.append(whereNotInit);
        whereNotInitBalNotZero.append(" and ").append(paramAge.getAmountField()).append(" <> 0.0  \r\n");
    }

    public static void getSql_ByAcctBal_AcInit_From(AccountAgeParam paramAge) {
        StringBuffer initFrom = paramAge.getSqlFromInit();
        initFrom.append(" \r\n from t_gl_acctcussent cussent \r\n");
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            initFrom.append(" \r\n inner join t_bd_Currency currency on cussent.fcurrencyid = currency.fid");
        }
        if (paramAge.isJoinHgTable()) {
            initFrom.append(" \r\n inner join t_bd_assistanthg hg on cussent.fassgrpid = hg.fid");
        }
        if (paramAge.getSqlBizCodeHgid().length() > 0) {
            initFrom.append("\r\n inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid ");
        }
        if (paramAge.isAccountList() || paramAge.getAccountid() == null || paramAge.isIsOnlyUnion()) {
            initFrom.append(" \r\n inner join t_bd_accountview account on cussent.faccountid=account.fid  \r\n");
        }
        if (paramAge.isIsOnlyUnion()) {
            initFrom.append(paramAge.getSbCompany4Union());
            StringBuffer sbJoinTempTableComVeriMode = new StringBuffer();
            if (paramAge.isIncludeUnPosted()) {
                sbJoinTempTableComVeriMode.append(" \r\n inner join ").append(paramAge.getTempTableComVeriMode()).append(" comvm on comvm.FCompanyID = cussent.FCompanyID ");
            }
            initFrom.append(sbJoinTempTableComVeriMode);
        }
    }

    public static void getSql_ByAcctBal_AcInit_Where(AccountAgeParam paramAge) {
        StringBuffer initWhere = paramAge.getSqlWhereInit();
        StringBuffer initWhereBalNotZero = paramAge.getSqlWhereInitBalNotZero();
        initWhere.append("\r\n where 1=1  \r\n");
        initWhere.append(" and cussent.fentryid is null and cussent.fisinit=1 and cussent.fisinitclosed=1  \r\n");
        initWhere.append(" and cussent.fbookeddate <= ? \r\n");
        if (paramAge.getHgid() != null && paramAge.getHgid().length() > 0) {
            if (paramAge.isBizCode()) {
                initWhere.append(" and T_Hgid.bacid ='").append(paramAge.getHgid()).append("' ");
            } else {
                initWhere.append(" and cussent.fassgrpid = '").append(paramAge.getHgid()).append("' ");
            }
        }
        if (paramAge.isAccountList()) {
            // empty if block
        }
        if (paramAge.isIsOnlyUnion()) {
            if (paramAge.getTempTableCompany() != null) {
                initWhere.append(" \r\n and company.fid in (select fid from ").append(paramAge.getTempTableCompany()).append(")  and ");
            } else {
                initWhere.append(" \r\n and company.fid in ( ").append(paramAge.getCompanyId()).append(" ) and ");
            }
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                initWhere.append(" (");
            }
            initWhere.append(" sumcompany");
            if (paramAge.isIsfirstload()) {
                if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                    initWhere.append(".fid = ?");
                    initWhere.append(" or sumcompany.fisleaf = 1 )");
                } else if (paramAge.isCompanyExpandOnUnion()) {
                    initWhere.append(".flevel >=? ");
                } else {
                    initWhere.append(".fid = ? ");
                }
            } else if (paramAge.getDisplayMode() == 4) {
                initWhere.append(".fisleaf = 1 ");
            } else {
                initWhere.append(".fparentid = ? ");
            }
        } else if (paramAge.isRptQuery()) {
            initWhere.append(" \r\n and cussent.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" ) ");
        } else {
            initWhere.append(" and cussent.fcompanyid = ?    \r\n");
        }
        if (paramAge.isSetCurrency()) {
            initWhere.append(" and cussent.fcurrencyid = ?   \r\n");
        }
        GLAcctAgeNewUtils.buildAccountFilterOfNumber(paramAge, initWhere, "cussent");
        initWhereBalNotZero.append(initWhere);
        initWhereBalNotZero.append(" and ").append(paramAge.getAmountField()).append(" <> 0.0  \r\n");
    }

    public static StringBuffer getSql_ByBal_AcSub_WhereExistsFutureVeri(AccountAgeParam paramAge) {
        String accountNumberParam;
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append("  or exists(  \r\n");
        sqlWhere.append("    select 1  \r\n");
        sqlWhere.append("    FROM t_gl_acctcussenthistory khis  \r\n");
        sqlWhere.append("      inner join t_gl_voucher voucher on khis.fverivchid = voucher.fid  \r\n");
        sqlWhere.append("      inner join t_bd_accountview account on khis.faccountid = account.fid  \r\n");
        sqlWhere.append("    WHERE khis.fcussentidid = cussent.fid  \r\n");
        sqlWhere.append("      AND khis.fdc IN (0, 2)  \r\n");
        sqlWhere.append("      AND khis.fcompanyid = ?    \r\n");
        sqlWhere.append("      AND voucher.fcompanyid = ?    \r\n");
        if (!paramAge.isIsOnlyUnion()) {
            sqlWhere.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
        } else {
            sqlWhere.append(" and account.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
        }
        sqlWhere.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
        if (paramAge.getAccountViewNumber() == null) {
            sqlWhere.append(" and cussent.faccountid in (" + paramAge.getAccountid() + ")   \r\n");
        } else {
            accountNumberParam = GLAcctAgeUtils.getNumberForAccountSum(paramAge);
            if (!accountNumberParam.trim().equals("") && accountNumberParam != null) {
                sqlWhere.append(" and account.Fnumber in (" + accountNumberParam + ")   \r\n");
            }
        }
        if (paramAge.isSetCurrency()) {
            sqlWhere.append("      AND khis.fcurrencyid = ?    \r\n");
        }
        sqlWhere.append("      AND voucher.fbookeddate > ?  \r\n");
        sqlWhere.append("      AND voucher.fbizstatus <> 0 and voucher.fbizstatus<>2  \r\n");
        sqlWhere.append("      )    \r\n");
        sqlWhere.append("  or exists(  \r\n");
        sqlWhere.append("    select 1  \r\n");
        sqlWhere.append("    FROM t_gl_acctcussenthistory khis  \r\n");
        sqlWhere.append("      inner join t_gl_acctcussenthistory k2  \r\n");
        sqlWhere.append("      on k2.fvoucherasstidid = khis.fcussentidid AND k2.fcussentidid = khis.fvoucherasstidid  \r\n");
        sqlWhere.append("      inner join t_bd_accountview account on khis.faccountid = account.fid  \r\n");
        sqlWhere.append("    WHERE khis.fcussentidid = cussent.fid  \r\n");
        sqlWhere.append("      AND khis.fdc IN (1)  \r\n");
        sqlWhere.append("      AND khis.fcompanyid = ?    \r\n");
        sqlWhere.append("      AND k2.fcompanyid = ?    \r\n");
        if (!paramAge.isIsOnlyUnion()) {
            sqlWhere.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
        } else {
            sqlWhere.append(" and account.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
        }
        sqlWhere.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
        if (paramAge.getAccountViewNumber() == null) {
            sqlWhere.append(" and cussent.faccountid in (" + paramAge.getAccountid() + ")   \r\n");
        } else {
            accountNumberParam = GLAcctAgeUtils.getNumberForAccountSum(paramAge);
            if (!accountNumberParam.trim().equals("") && accountNumberParam != null) {
                sqlWhere.append(" and account.Fnumber in (" + accountNumberParam + ")   \r\n");
            }
        }
        if (paramAge.isSetCurrency()) {
            sqlWhere.append("      AND khis.fcurrencyid = ?    \r\n");
        }
        sqlWhere.append("      AND k2.fvchdate > ?  \r\n");
        sqlWhere.append("      )    \r\n");
        return sqlWhere;
    }

    public static void getSql_ByAcctBal_SelectHgJoin(AccountAgeParam paramAge) throws EASBizException, BOSException {
        String asstActNumberDef;
        HashMap hmItems = paramAge.getHmItems();
        StringBuffer sqlSelecthg = paramAge.getSqlSelecthg();
        StringBuffer sqlInnerJoin = paramAge.getSqlInnerJoin();
        StringBuffer sqlGroupbyAge = paramAge.getSqlGroupbyAge();
        StringBuffer sqlSelecthgoutside = paramAge.getSqlSelecthgoutside();
        StringBuffer sqlCreateHgTbl = paramAge.getSqlCreateHgTbl();
        StringBuilder sqlSelectorHgTbl = paramAge.getSqlSelectorHgTbl();
        StringBuffer sqlSelecthgoutsideReal = paramAge.getSqlSelecthgoutsideReal();
        boolean isAddFieldHgid = paramAge.isAddFieldHgid();
        int gi = 0;
        ArrayList alAstNumbers = paramAge.getAlAstNumbers();
        ArrayList alAstTables = paramAge.getAlAstTables();
        ArrayList alAstFields = paramAge.getAlAstFields();
        ArrayList verifyFields = paramAge.getVerifyFields();
        ArrayList alAstAlias = paramAge.getAlAstAlias();
        int tablei = 0;
        String accountname = GlUtils.isAccountShowLongName(paramAge.getCtx(), paramAge.getCurCompanyid()) ? "Flongname_" : "Fname_";
        Map tempTableFieldMap = (Map)paramAge.get(tempTableFields);
        String string = asstActNumberDef = tempTableFieldMap == null ? "NVARCHAR(100)" : GLTempTableUtil.FieldDef(asstActNumer, tempTableFieldMap, "NVARCHAR(100)");
        if (paramAge.isAccountList()) {
            sqlGroupbyAge.append("group by ###,");
        }
        if (!paramAge.isBizCode()) {
            int i;
            Object isShowLongNumberObj = GLAcctAgeNewUtils.getHmParam(paramAge.getCtx(), paramAge.getCurCompanyid(), "GL_064");
            boolean isShowLongNumber = false;
            if (isShowLongNumberObj != null) {
                isShowLongNumber = Boolean.valueOf(isShowLongNumberObj.toString());
            }
            Iterator itemkeyit = hmItems.keySet().iterator();
            HashMap[] itemList = new HashMap[hmItems.keySet().size()];
            int itemSize = 8;
            if (paramAge.getParams() != null && paramAge.getParams().get("itemsize") != null) {
                itemSize = (Integer)paramAge.getParams().get("itemsize");
            }
            HashMap[] list = new HashMap[itemSize];
            while (itemkeyit.hasNext()) {
                HashMap item = (HashMap)itemkeyit.next();
                Integer seq = (Integer)item.get("seq");
                list[seq.intValue()] = item;
            }
            int k = 0;
            for (i = 0; i < list.length; ++i) {
                if (list[i] == null) continue;
                itemList[k++] = list[i];
            }
            if ((paramAge.isIncludeVerifyVch() || paramAge.isSumAccount()) && !paramAge.isAccountList()) {
                sqlGroupbyAge.append(" group by accountid,");
            }
            for (i = 0; i < itemList.length; ++i) {
                HashMap item = itemList[i];
                boolean isGeneralActType = item.get("FGLAsstActTypeGrpID") != null;
                boolean isUseLongNumber = (Boolean)item.get("useLongNUmber");
                String numberFieldNumber = "fnumber";
                String[] numbers = (String[])hmItems.get(item);
                if (isUseLongNumber && GLAcctAgeNewUtils.isLongNumber(numbers)) {
                    numberFieldNumber = "flongnumber";
                    for (int ll = 0; ll < numbers.length; ++ll) {
                        if (numbers[ll] == null) continue;
                        numbers[ll] = numbers[ll].replace(".", "!");
                    }
                }
                String table = (String)item.get("tablename");
                String field = (String)item.get("fieldname");
                alAstTables.add(table);
                alAstFields.add(field);
                alAstAlias.add((String)item.get("name"));
                if (paramAge.isSumDC()) {
                    verifyFields.add("hg." + field);
                }
                sqlInnerJoin.append(" inner join ").append(table).append(" ").append("T").append(tablei).append(" on hg.").append(field).append("=").append("T").append(tablei).append(".fid");
                if (paramAge.isIsOnlyUnion() && paramAge.getOtherInfo() != null && paramAge.getOtherInfo().get(field) != null) {
                    sqlInnerJoin.append(" and hg.").append(field).append(" = '").append(paramAge.getOtherInfo().get(field).toString()).append("' ");
                }
                if (numbers.length == 3 && numbers[2] != null) {
                    sqlInnerJoin.append(" and ").append("T").append(tablei).append(".").append(numberFieldNumber).append(" in ( ");
                    String[] nms = numbers[2].split(",");
                    String nmvs = "";
                    for (String nm : nms) {
                        alAstNumbers.add(nm);
                        nmvs = nmvs + "?,";
                    }
                    nmvs = nmvs.substring(0, nmvs.lastIndexOf(","));
                    sqlInnerJoin.append(nmvs).append(") ");
                } else {
                    if (numbers[0] != null) {
                        alAstNumbers.add(numbers[0]);
                        sqlInnerJoin.append(" and ").append("T").append(tablei).append(".").append(numberFieldNumber).append(" >= ? ");
                    }
                    if (numbers[1] != null) {
                        alAstNumbers.add(numbers[1]);
                        sqlInnerJoin.append(" and ").append("T").append(tablei).append(".").append(numberFieldNumber).append(" <= ? ");
                    }
                }
                sqlInnerJoin.append("  \r\n");
                if (!paramAge.isAccountList()) {
                    if (sqlGroupbyAge.length() == 0) {
                        sqlGroupbyAge.append(" group by ");
                    }
                    verifyFields.add("hg." + field);
                    sqlSelecthg.append("hg.").append(field).append(" as ").append("T").append(tablei).append(field).append(",");
                    sqlSelectorHgTbl.append("T").append(tablei).append(field).append(",");
                    sqlGroupbyAge.append("T").append(tablei).append(field).append(",");
                    if (isShowLongNumber && item.get("propname") != null && item.get("propname").toString().startsWith("general")) {
                        sqlSelecthg.append("replace(T").append(tablei).append(".flongnumber,'!','.') as ").append("T").append(tablei).append("fnumber,");
                    } else {
                        sqlSelecthg.append("T").append(tablei).append(".fnumber as ").append("T").append(tablei).append("fnumber,");
                    }
                    sqlSelectorHgTbl.append("T").append(tablei).append("fnumber,");
                    sqlGroupbyAge.append("T").append(tablei).append("fnumber,");
                    sqlSelecthg.append("T").append(tablei).append(".fname_").append(paramAge.getLoc()).append(" as ").append("T").append(tablei).append("fname,");
                    sqlSelectorHgTbl.append("T").append(tablei).append("fname,");
                    sqlGroupbyAge.append("T").append(tablei).append("fname,");
                    sqlSelecthgoutside.append("T").append(tablei).append(field).append(",T").append(tablei).append("fnumber,").append("T").append(tablei).append("fname,");
                    sqlCreateHgTbl.append("T").append(tablei).append(field).append(" varchar(44),").append("T").append(tablei).append("fnumber ").append(asstActNumberDef).append(",").append("T").append(tablei).append("fname nvarchar(255),");
                }
                ++tablei;
                ++gi;
            }
            if (paramAge.isAccountList()) {
                sqlSelecthgoutside.append("Taccountid,T0fnumber,T0fname,");
                sqlSelecthg.append("account.FID as Taccountid,account.Fnumber as T0fnumber,account.").append(accountname).append(paramAge.getLoc()).append(" as T0fname,");
                sqlCreateHgTbl.append("Taccountid varchar(44),").append("T0fnumber ").append(asstActNumberDef).append(",").append("T0fname nvarchar(255),");
                sqlSelectorHgTbl.append("Taccountid,T0fnumber,T0fname,");
                String tempField = "Taccountid,T0fnumber,T0fname";
                int s = sqlGroupbyAge.indexOf("###");
                sqlGroupbyAge.replace(s, s + 3, tempField);
            }
        } else if (!paramAge.isAccountBC()) {
            sqlSelecthg.append("account.FID as Taccountid,account.Fnumber as T0fnumber,account.").append(accountname).append(paramAge.getLoc()).append(" as T0fname,");
            sqlSelecthgoutside.append("Taccountid,T0fnumber,T0fname,");
            sqlCreateHgTbl.append("Taccountid varchar(44), T0fnumber ").append(asstActNumberDef).append(",").append("T0fname nvarchar(255),");
            sqlSelectorHgTbl.append("Taccountid,T0fnumber,T0fname,");
            sqlGroupbyAge.setLength(0);
            sqlGroupbyAge.append(" group by Taccountid,T0fnumber,T0fname,");
        } else if (paramAge.isAccountBC() && !paramAge.isAccountBCNoType()) {
            sqlSelecthg.append("T_Hgid.bacid as Taccountid").append(",T_Hgid.bacnumber as T0fnumber, T_Hgid.bacname as T0fname,");
            sqlSelecthgoutside.append("Taccountid,T0fnumber,T0fname,");
            sqlCreateHgTbl.append("Taccountid varchar(44), T0fnumber ").append(asstActNumberDef).append(",").append("T0fname nvarchar(255),");
            sqlSelectorHgTbl.append("Taccountid,T0fnumber,T0fname,");
            sqlGroupbyAge.setLength(0);
            sqlGroupbyAge.append(" group by Taccountid,T0fnumber,T0fname,");
        }
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            sqlSelecthg.append("currency.fid fcurrid,currency.Fname_" + paramAge.getLoc() + " fcurrname,");
        } else {
            sqlSelecthg.append("'" + paramAge.getCurrency().getId() + "' fcurrid,N'" + paramAge.getCurrency().getName() + "' fcurrname,");
        }
        sqlCreateHgTbl.append("fcurrid varchar(44),fcurrname nvarchar(100),");
        sqlSelectorHgTbl.append("fcurrid,fcurrname,");
        sqlSelecthgoutside.append("fcurrid,fcurrname,");
        if (paramAge.isIsOnlyUnion()) {
            sqlSelecthg.append(" sumcompany.fid fsumcompanyid,sumcompany.Fname_" + paramAge.getLoc() + " fsumcompanyname,sumcompany.flevel fsumcompanylevel,sumcompany.fisleaf fsumcompanyisleaf,");
            sqlSelecthgoutside.append("fsumcompanyid,fsumcompanyname,fsumcompanylevel,fsumcompanyisleaf,");
            sqlCreateHgTbl.append("fsumcompanyid varchar(44),fsumcompanyname nvarchar(100),fsumcompanylevel int,fsumcompanyisleaf int,");
            sqlSelecthg.append(" company.fid fsubcompanyid,");
            sqlSelecthgoutside.append("fsubcompanyid,");
            sqlCreateHgTbl.append("fsubcompanyid varchar(44),");
            sqlSelectorHgTbl.append("fsumcompanyid,fsumcompanyname,fsumcompanylevel,fsumcompanyisleaf,fsubcompanyid,");
        }
        String hgField = "";
        if (verifyFields != null) {
            for (int i = 0; i < verifyFields.size(); ++i) {
                hgField = i == verifyFields.size() - 1 ? hgField + verifyFields.get(i) : hgField + verifyFields.get(i) + "||";
            }
        }
        if (paramAge.isAccountList()) {
            if (paramAge.isBizCode()) {
                sqlSelecthg.append("T_Hgid.bacid as hgid,");
                sqlCreateHgTbl.append("hgid varchar(44),");
            } else {
                sqlSelecthg.append(hgField == "" ? "cussent.fassgrpid" : hgField).append(" as hgid,");
                sqlCreateHgTbl.append("hgid varchar(440),");
            }
            sqlSelectorHgTbl.append("hgid,");
            sqlSelecthgoutside.append("hgid,");
        }
        if (paramAge.isIncludeVerifyVch() || paramAge.isSumAccount()) {
            sqlSelecthgoutsideReal.append(sqlSelecthgoutside);
            if (!paramAge.isAccountList()) {
                isAddFieldHgid = true;
                paramAge.setAddFieldHgid(isAddFieldHgid);
                if (paramAge.isBizCode()) {
                    if (!paramAge.isAccountBCNoType()) {
                        sqlSelecthg.append("T_Hgid.bacid as hgid,");
                        sqlSelectorHgTbl.append("hgid,");
                        sqlCreateHgTbl.append("hgid varchar(44),");
                    }
                } else {
                    sqlSelecthg.append(hgField == "" ? "cussent.fassgrpid" : hgField).append(" as hgid, cussent.faccountid as accountid,");
                    sqlSelectorHgTbl.append("hgid,accountid,");
                    sqlCreateHgTbl.append("hgid varchar(440),");
                }
                sqlCreateHgTbl.append("accountid varchar(44),");
                sqlSelecthgoutside.append("hgid,accountid,");
            }
        }
        List lstHgOutSide = GLAcctAgeUtils.getListFromSelecthgoutside(sqlSelecthgoutside);
        paramAge.setLstHgOutSide(lstHgOutSide);
        sqlSelecthgoutsideReal = GLAcctAgeUtils.truncateStringTailDot(sqlSelecthgoutsideReal);
        sqlSelecthgoutside = GLAcctAgeUtils.truncateStringTailDot(sqlSelecthgoutside);
        if (sqlGroupbyAge.length() == 0) {
            sqlGroupbyAge.append(" group by ");
        }
        sqlGroupbyAge.append(" fcurrid,fcurrname,");
        if (paramAge.isIsOnlyUnion()) {
            sqlGroupbyAge.append("fsumcompanyid,fsumcompanyname,fsumcompanylevel,fsumcompanyisleaf,fsubcompanyid,");
        }
        if (paramAge.isAccountList()) {
            sqlGroupbyAge.append("hgid,");
        }
        if (!paramAge.isAccountList()) {
            if (paramAge.isBizCode()) {
                sqlGroupbyAge.append("hgid,");
            } else {
                sqlGroupbyAge.append("hgid");
            }
        }
    }

    private static boolean isLongNumber(String[] numbers) {
        if (numbers == null) {
            return false;
        }
        if (numbers.length == 3 && numbers[2] != null && (numbers[2].contains(".") || numbers[2].contains("!"))) {
            return true;
        }
        for (String number : numbers) {
            if (number == null || !number.contains(".") && !number.contains("!")) continue;
            return true;
        }
        return false;
    }

    public static void prepareTempTableCompanyVerifyMode(AccountAgeParam paramAge) throws BOSException, EASBizException, SQLException {
        if (!paramAge.isIsOnlyUnion()) {
            return;
        }
        if (paramAge.getTempTableComVeriMode() == null) {
            StringBuffer sql = new StringBuffer("(FCompanyID varchar(44),FVerifyMode varchar(10))");
            String tempTable = GLAcctAgeNewUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_age", sql);
            paramAge.setTempTableComVeriMode(tempTable);
        }
        GLAcctAgeNewUtils.insertIntoTempTable_CompanyVerifyMode(paramAge.getCtx(), paramAge);
    }

    public static void prepareTempTableHg(AccountAgeParam paramAge) throws EASBizException, BOSException {
        if (paramAge.isAccountList() && !paramAge.isBizCode()) {
            String acids = paramAge.getAccountid();
            String[] ids = (acids = acids.replaceAll("'", "")).split(",");
            if (ids.length >= 500) {
                String table = GLAcctAgeNewUtils.createTempTableByDDL(paramAge.getCtx(), "temp_table_hg", "(fid varchar(44))");
                paramAge.setTempTableHg(table);
                GLAcctAgeNewUtils.insertIdToTempTable(paramAge, ids, table);
            }
        }
    }

    public static void prepareTempTableCompanys(AccountAgeParam paramAge) throws EASBizException, BOSException {
        String idsStr = paramAge.getCompanyId();
        String[] ids = (idsStr = idsStr.replaceAll("'", "")).split(",");
        if (ids.length >= 500) {
            String table = GLAcctAgeNewUtils.createTempTableByDDL(paramAge.getCtx(), "temp_table_company", "(fid varchar(44))");
            paramAge.setTempTableCompany(table);
            GLAcctAgeNewUtils.insertIdToTempTable(paramAge, ids, table);
        }
    }

    private static void insertIdToTempTable(AccountAgeParam paramAge, String[] ids, String tmpTable) throws EASBizException, BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(tmpTable).append("(fid) values(?)");
        Connection con = null;
        PreparedStatement ps = null;
        try {
            int c = 0;
            con = EJBFactory.getConnection((Context)paramAge.getCtx());
            ps = con.prepareStatement(sql.toString());
            for (int i = 0; i < ids.length; ++i) {
                ps.setString(1, ids[i]);
                ps.addBatch();
                if (++c % 2000 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            if (c > 0) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private static void insertIntoTempTable_CompanyVerifyMode(Context ctx, AccountAgeParam paramAge) throws SQLException, BOSException {
        java.util.Date historyDate = paramAge.getHistoryDate();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = simpleDateFormat.format(historyDate);
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(paramAge.getTempTableComVeriMode());
        sql.append(" (FCompanyID, FVerifyMode)                     \r\n");
        sql.append("(select com.fid,pi.fvalue_").append(paramAge.getLoc()).append("                  \r\n");
        sql.append(" from T_Org_Company com                                             \r\n");
        sql.append(" inner join t_bas_paramitem pi on pi.forgunitid = com.fid           \r\n");
        sql.append(" inner join t_bas_param p on pi.fkeyid = p.fid                      \r\n");
        sql.append(" inner join t_bas_paramitem pi1 on pi1.forgunitid = com.fid         \r\n");
        sql.append(" inner join t_bas_param p1 on pi1.fkeyid = p1.fid                   \r\n");
        sql.append(" inner join t_bd_systemstatusctrol sc on sc.FCOMPANYID = com.fid ");
        sql.append(" inner join t_bd_systemstatus ss on sc.FSYSTEMSTATUSID = ss.FID ");
        sql.append(" inner join t_bd_period bp on sc.FSTARTPERIODID = bp.FID ");
        sql.append(" where p1.fnumber = 'GL_028' and pi1.fvalue_").append(paramAge.getLoc()).append(" = 'true' and         \r\n");
        sql.append("  p.fnumber = 'GL_052'                                              \r\n");
        sql.append("  and com.fid in                                                    \r\n");
        sql.append("  (                                                               \r\n");
        sql.append(paramAge.getCompanyId());
        sql.append("  )                                                                 \r\n");
        sql.append(" and sc.FACPeriodID is null and ss.FNAME =6 and sc.FISSTART =1 and bp.FBEGINDATE <= ").append("to_date('").append(dateStr).append("')");
        sql.append(" union ");
        sql.append(" select com.fid,pi.fvalue_").append(paramAge.getLoc()).append("                  \r\n");
        sql.append(" from T_Org_Company com                                             \r\n");
        sql.append(" inner join t_bas_paramitem pi on pi.forgunitid = com.fid           \r\n");
        sql.append(" inner join t_bas_param p on pi.fkeyid = p.fid                      \r\n");
        sql.append(" inner join t_bas_paramitem pi1 on pi1.forgunitid = com.fid         \r\n");
        sql.append(" inner join t_bas_param p1 on pi1.fkeyid = p1.fid                   \r\n");
        sql.append(" inner join t_bd_systemstatusctrol sc on sc.FCOMPANYID = com.fid ");
        sql.append(" inner join t_bd_systemstatus ss on sc.FSYSTEMSTATUSID = ss.FID ");
        sql.append(" inner join t_bd_period bp on sc.FACPeriodID = bp.FID ");
        sql.append(" where p1.fnumber = 'GL_028' and pi1.fvalue_").append(paramAge.getLoc()).append(" = 'true' and         \r\n");
        sql.append("  p.fnumber = 'GL_052'                                              \r\n");
        sql.append("  and com.fid in                                                    \r\n");
        sql.append("  (                                                               \r\n");
        sql.append(paramAge.getCompanyId());
        sql.append("  )                                                                 \r\n");
        sql.append(" and ss.FNAME =6 and sc.FISSTART =1 and bp.FBEGINDATE <= ").append("to_date('").append(dateStr).append("')");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public void getRs(Connection con, String tableName) throws SQLException {
        int count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) count from ").append(tableName);
        ps = con.prepareStatement(sql.toString());
        rs = ps.executeQuery();
        if (rs.next()) {
            count = rs.getInt("count");
        }
        rs.close();
        ps.close();
        sql.setLength(0);
        sql.append("select * from ").append(tableName);
        ps = con.prepareStatement(sql.toString());
        rs = ps.executeQuery();
        rs.close();
        ps.close();
    }

    public static ArrayList getAllPhaseDates(AccountAgeParam paramAge) {
        int j;
        int index = 0;
        ArrayList<Date> allPhaseDates = new ArrayList<Date>();
        Calendar _cal = Calendar.getInstance();
        _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
        Date _dayIndex = new Date(_cal.getTimeInMillis());
        Date _day1 = null;
        Date _day2 = new Date(_cal.getTime().getTime());
        java.util.Date endDate = paramAge.getEndDate();
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                _cal = Calendar.getInstance();
                if (j == 0) {
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.add(5, -1 * paramAge.getUndays()[0]);
                    _day2 = new Date(_cal.getTime().getTime());
                } else if (j == paramAge.getDaylen()) {
                    _cal.set(2949, 0, 1);
                    _day2 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getUndays()[j - 1]);
                    _day1 = new Date(_cal.getTime().getTime());
                } else {
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getUndays()[j - 1]);
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    if (j < paramAge.getUndays().length) {
                        _cal.add(5, -1 * paramAge.getUndays()[j]);
                        _day2 = new Date(_cal.getTime().getTime());
                    }
                }
                allPhaseDates.add(_day1);
                allPhaseDates.add(_day2);
            }
        }
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            index = i + j;
            _cal = Calendar.getInstance();
            if (i == 0) {
                _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                _cal.add(5, -1 * paramAge.getDays()[0]);
                _day1 = new Date(_cal.getTime().getTime());
                _day2 = new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime());
            } else if (i == paramAge.getDaylen()) {
                _cal.set(1900, 0, 1);
                _day1 = new Date(_cal.getTime().getTime());
                _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                _cal.add(5, -1 * paramAge.getDays()[i - 1]);
                _day2 = new Date(_cal.getTime().getTime());
            } else {
                _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                _cal.add(5, -1 * paramAge.getDays()[i]);
                _day1 = new Date(_cal.getTime().getTime());
                _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                _cal.add(5, -1 * paramAge.getDays()[i - 1]);
                _day2 = new Date(_cal.getTime().getTime());
            }
            allPhaseDates.add(_day1);
            allPhaseDates.add(_day2);
        }
        return allPhaseDates;
    }

    public static StringBuffer getPhaseSql(AccountAgeParam paramAge, String dateField) {
        int j;
        StringBuffer sqlSelect = new StringBuffer(" select ");
        StringBuffer sumOnePhase = new StringBuffer(" ,sum(case when temp.").append(dateField).append("<? and temp.").append(dateField).append(">=? then ").append(" temp.foriginalamt ").append(" else 0 end) as sum");
        sqlSelect.append("\r\n sum(case when temp." + dateField + ">=? then ").append(" temp.foriginalamt ").append(" else 0 end) as sumUnOverDue  \r\n");
        if (paramAge.isShowUmexpired()) {
            StringBuffer sumUnOnePhase = new StringBuffer(" ,sum(case when temp.").append(dateField).append(">? and temp.").append(dateField).append("<=? then ").append(" temp.foriginalamt ").append(" else 0 end) as sum");
            for (j = 0; j < paramAge.getUndaylen(); ++j) {
                if (j == 0) {
                    sqlSelect.append(" ,sum(case when temp.").append(dateField).append(">=? and temp.").append(dateField).append("<=? then ").append(" temp.foriginalamt ").append(" else 0 end) as sum0   \r\n");
                    continue;
                }
                sqlSelect.append(sumUnOnePhase).append(j).append("  \r\n");
            }
            sqlSelect.append(",sum(case when temp." + dateField + ">? then ").append(" temp.foriginalamt ").append(" else 0 end) as sum" + j + "\r\n");
            ++j;
        }
        int index = 0;
        sqlSelect.append(sumOnePhase).append(j + " \r\n");
        for (int i = 1; i < paramAge.getDaylen(); ++i) {
            index = i + j;
            sqlSelect.append(sumOnePhase).append(index).append("  \r\n");
        }
        index = paramAge.getDaylen() + j;
        sqlSelect.append(sumOnePhase).append(index).append("  \r\n");
        return sqlSelect;
    }

    public static int setupParams_ByBal_InsertSumVeri(AccountAgeParam paramAge, PreparedStatement ps, int index, boolean isInit, Map map) throws SQLException {
        for (String number : paramAge.getAlAstNumbers()) {
            map.put(index, number);
            ps.setString(index++, number);
        }
        Calendar cal = Calendar.getInstance();
        if (!isInit) {
            cal.setTime(paramAge.getHistoryDate());
            map.put(index, new Date(cal.getTimeInMillis()));
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
        }
        if (paramAge.isAccountList() || paramAge.getAccountViewNumber() != null || paramAge.getAccountid() != null) {
            // empty if block
        }
        if (!StringUtils.isEmpty((String)paramAge.getCurCompanyid())) {
            map.put(index, paramAge.getCurCompanyid());
            ps.setString(index++, paramAge.getCurCompanyid());
        }
        if (!isInit && paramAge.getLastPhaseBeginDate() != null) {
            cal.setTime(paramAge.getLastPhaseBeginDate());
            map.put(index, new Date(cal.getTimeInMillis()));
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
        }
        if (paramAge.isSetCurrency()) {
            map.put(index, paramAge.getCurrencyid());
            ps.setString(index++, paramAge.getCurrencyid());
        }
        if (paramAge.isAccountList()) {
            if (!StringUtils.isEmpty((String)paramAge.getAccountFromNumber())) {
                map.put(index, paramAge.getAccountFromNumber());
                ps.setString(index++, paramAge.getAccountFromNumber());
            }
            if (!StringUtils.isEmpty((String)paramAge.getAccountToNumber())) {
                map.put(index, paramAge.getAccountToNumber() + "zzzzzz");
                ps.setString(index++, paramAge.getAccountToNumber() + "zzzzzz");
            }
        }
        return index;
    }

    public static String getNumberForAccountSum(AccountAgeParam paramAge) {
        String[] accountNumbers = paramAge.getAccountNumbers();
        String accountViewNumber = paramAge.getAccountViewNumber();
        String account2 = null;
        StringBuffer accountsBuf = new StringBuffer();
        if (accountNumbers != null) {
            for (String account2 : accountNumbers) {
                if (account2.indexOf(accountViewNumber) != 0 || account2.equals(accountViewNumber)) continue;
                accountsBuf.append("'").append(account2).append("',");
            }
        } else {
            accountsBuf.append("'").append(accountViewNumber).append("',");
        }
        if (accountsBuf.length() > 1) {
            return accountsBuf.toString().substring(0, accountsBuf.length() - 1);
        }
        return accountsBuf.toString();
    }

    public static int setupParams_ByBal_InsertSum_Rpt(boolean isOnlyUnion, boolean isInitParam, String accountid, AccountAgeParam paramAge, java.util.Date historyDate, ArrayList alDates, List params, int index, String accountViewNumber, java.util.Date lastPhaseBeginDate) throws SQLException {
        String currencyid = paramAge.getCurrencyid();
        String companyid = paramAge.getCompanyId();
        companyid = paramAge.getCurCompanyid();
        boolean isSetCurrency = paramAge.isSetCurrency();
        Calendar cal = Calendar.getInstance();
        cal.setTime(historyDate);
        params.add(new Date(cal.getTimeInMillis()));
        if (!StringUtils.isEmpty((String)accountid)) {
            params.add(accountid);
        }
        if (!(StringUtils.isEmpty((String)companyid) || paramAge.isIsOnlyUnion() && !paramAge.isIsfirstload() && paramAge.getDisplayMode() == 4 || paramAge.isRptQuery())) {
            params.add(companyid);
        }
        if (lastPhaseBeginDate != null) {
            cal.setTime(lastPhaseBeginDate);
            params.add(new Date(cal.getTimeInMillis()));
        }
        if (isSetCurrency) {
            params.add(currencyid);
        }
        return index;
    }

    public static void dealwithRpt_Param(AccountAgeParam paramAge) throws EASBizException, BOSException {
        int i;
        Object[] v;
        int daylen = paramAge.getDays().length;
        int undaylen = paramAge.getUndays().length;
        boolean isAccountList = false;
        boolean isAccountBC = false;
        boolean isAccountBCNoType = false;
        String accountFromNumber = "";
        String accountToNumber = "";
        String bizCodeFromNumber = null;
        String bizCodeToNumber = null;
        Object accountFrom = paramAge.getAccountFrom();
        Object accountTo = paramAge.getAccountTo();
        if (accountFrom instanceof AccountViewInfo) {
            accountFromNumber = ((AccountViewInfo)accountFrom).getNumber();
        } else if (accountFrom instanceof Object[]) {
            v = (Object[])accountFrom;
            accountFromNumber = "";
            for (i = 0; i < v.length; ++i) {
                if (v[i] == null) continue;
                accountFromNumber = accountFromNumber + ((AccountViewInfo)v[i]).getNumber() + ";";
            }
        } else {
            accountFromNumber = (String)accountFrom;
        }
        if (accountTo instanceof AccountViewInfo) {
            accountToNumber = ((AccountViewInfo)accountTo).getNumber();
        } else if (accountTo instanceof Object[]) {
            v = (Object[])accountTo;
            accountToNumber = "";
            for (i = 0; i < v.length; ++i) {
                if (v[i] == null) continue;
                accountToNumber = accountToNumber + ((AccountViewInfo)v[i]).getNumber() + ";";
            }
        } else {
            accountToNumber = (String)accountTo;
        }
        Map accountParams = GLAcctAgeNewUtils.getAccountParam(accountFromNumber, accountToNumber);
        accountFromNumber = (String)accountParams.get("accountFrom");
        accountToNumber = (String)accountParams.get("accountTo");
        Iterator itemkeyit = paramAge.getHmItems().keySet().iterator();
        if (paramAge.isBizCode()) {
            while (itemkeyit.hasNext()) {
                HashMap item = (HashMap)itemkeyit.next();
                String[] numbers = (String[])paramAge.getHmItems().get(item);
                bizCodeFromNumber = numbers[0];
                bizCodeToNumber = numbers[1];
            }
        }
        paramAge.setEndDate(DateTimeUtils.truncateDate((java.util.Date)paramAge.getEndDate()));
        paramAge.setHistoryDate(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
        GLAcctAgeNewUtils.setEnterDateType(paramAge);
        String loc = LocaleUtils.getLocaleString((Locale)paramAge.getCtx().getLocale());
        boolean isAllCurr = false;
        if (paramAge.getCurrencyid().equals("AllCurrency")) {
            isAllCurr = true;
        }
        CurrencyInfo currency = null;
        if (!isAllCurr) {
            currency = GLAcctAgeNewUtils.getCacheCurInfo(paramAge.getCtx(), paramAge.getCurrencyid());
        }
        CurrencyInfo generalCurrency = null;
        boolean isGeneralCy = false;
        int localOrRpt = 1;
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(paramAge.getCurrencyid())) {
            localOrRpt = 1;
            isGeneralCy = true;
            generalCurrency = paramAge.getCompany().getBaseCurrency();
        } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(paramAge.getCurrencyid())) {
            localOrRpt = 2;
            isGeneralCy = true;
            generalCurrency = paramAge.getCompany().getReportCurrency();
        }
        if (isGeneralCy) {
            generalCurrency = GLAcctAgeNewUtils.getCacheCurInfo(paramAge.getCtx(), generalCurrency.getId().toString());
        }
        boolean isSetCurrency = !isGeneralCy && !isAllCurr;
        boolean isJoinHgTable = false;
        if (paramAge.getHmItems().size() > 0 || paramAge.isBizCode() && paramAge.isIncludeVerifyVch()) {
            isJoinHgTable = true;
        }
        String maxChar = GlUtils.getMaxChar(paramAge.getCtx());
        paramAge.setAccountBC(isAccountBC);
        paramAge.setAccountBCNoType(isAccountBCNoType);
        paramAge.setBizCodeFromNumber(bizCodeFromNumber);
        paramAge.setBizCodeToNumber(bizCodeToNumber);
        paramAge.setDaylen(daylen);
        paramAge.setUndaylen(undaylen);
        paramAge.setAccountList(isAccountList);
        paramAge.setAccountParams(accountParams);
        paramAge.setAccountFromNumber(accountFromNumber);
        paramAge.setAccountToNumber(accountToNumber);
        paramAge.setAllCurr(isAllCurr);
        paramAge.setGeneralCy(isGeneralCy);
        paramAge.setLocalOrRpt(localOrRpt);
        paramAge.setSetCurrency(isSetCurrency);
        paramAge.setCurrency(currency);
        paramAge.setGeneralCurrency(generalCurrency);
        paramAge.setJoinHgTable(isJoinHgTable);
        paramAge.setLoc(loc);
        paramAge.setMaxChar(maxChar);
    }

    public static void getRptSql_ByAcctBal_Param_AlDates(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int[] days = paramAge.getDays();
        int[] undays = paramAge.getUndays();
        java.util.Date endDate = paramAge.getEndDate();
        int daylen = paramAge.getDaylen();
        int undaylen = paramAge.getUndaylen();
        ArrayList<Date> alDates = new ArrayList<Date>(daylen * 2 + 3);
        java.util.Date lastPhaseEndDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        alDates.add(new Date(cal.getTimeInMillis()));
        if (paramAge.isShowUmexpired()) {
            days = undays;
        }
        cal.setTime(endDate);
        cal.add(5, -1 * days[0]);
        alDates.add(new Date(cal.getTimeInMillis()));
        if (days.length == 2) {
            cal.setTime(endDate);
            cal.add(5, -1 * days[1]);
            alDates.add(new Date(cal.getTimeInMillis()));
        } else if (!paramAge.isShowUmexpired()) {
            cal.set(1900, 0, 1);
            alDates.add(new Date(cal.getTimeInMillis()));
        }
        paramAge.setAlDates(alDates);
        cal.set(1900, 9, 1);
        Date lastPhaseBeginDate = new Date(cal.getTimeInMillis());
        if (!paramAge.isIncludeVerifyVch()) {
            lastPhaseBeginDate = null;
            lastPhaseEndDate = null;
        }
        paramAge.setLastPhaseBeginDate(lastPhaseBeginDate);
        paramAge.setLastPhaseEndDate(lastPhaseEndDate);
    }

    public static void getRptSql_ByAcctBal_SelectHgJoin(AccountAgeParam paramAge) throws EASBizException, BOSException {
        StringBuffer sqlSelecthg = paramAge.getSqlSelecthg();
        StringBuffer sqlGroupbyAge = paramAge.getSqlGroupbyAge();
        StringBuffer sqlSelecthgoutside = paramAge.getSqlSelecthgoutside();
        StringBuffer sqlCreateHgTbl = paramAge.getSqlCreateHgTbl();
        StringBuilder sqlSelectorHgTbl = paramAge.getSqlSelectorHgTbl();
        StringBuffer sqlSelecthgoutsideReal = paramAge.getSqlSelecthgoutsideReal();
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            sqlSelecthg.append("currency.fid fcurrid,currency.Fname_" + paramAge.getLoc() + " fcurrname,");
        } else {
            sqlSelecthg.append("'" + paramAge.getCurrency().getId() + "' fcurrid,N'" + paramAge.getCurrency().getName() + "' fcurrname,");
        }
        sqlSelecthg.append(" cussent.fcompanyid fcompanyid,");
        sqlSelectorHgTbl.append("cussent.fcurrid,cussent.fcurrname,cussent.fcompanyid,");
        sqlCreateHgTbl.append("fcurrid varchar(44),fcurrname nvarchar(100),fcompanyid varchar(44),");
        sqlSelecthgoutside.append("fcurrid,fcurrname,fcompanyid,");
        sqlGroupbyAge.append("group by cussent.fcurrid,cussent.fcurrname,cussent.fcompanyid,");
        GLAcctAgeNewUtils.dealHgJoin(paramAge);
        ArrayList verifyFields = paramAge.getVerifyFields();
        String hgField = "";
        if (verifyFields != null) {
            for (int i = 0; i < verifyFields.size(); ++i) {
                hgField = i == verifyFields.size() - 1 ? hgField + verifyFields.get(i) : hgField + verifyFields.get(i) + "||";
            }
        }
        paramAge.setAddFieldHgid(false);
        sqlSelecthg.append(hgField == "" ? "cussent.fassgrpid" : hgField).append(" as hgid, cussent.faccountid as faccountid,");
        sqlSelecthgoutsideReal.append(sqlSelecthgoutside);
        paramAge.setAddFieldHgid(false);
        sqlSelectorHgTbl.append("cussent.hgid,cussent.faccountid,");
        sqlCreateHgTbl.append("hgid varchar(512),faccountid varchar(44),");
        sqlSelecthgoutside.append("hgid,faccountid,");
        sqlGroupbyAge.append("cussent.faccountid,");
        List lstHgOutSide = GLAcctAgeUtils.getListFromSelecthgoutside(sqlSelecthgoutside);
        paramAge.setLstHgOutSide(lstHgOutSide);
        sqlSelecthgoutsideReal = GLAcctAgeUtils.truncateStringTailDot(sqlSelecthgoutsideReal);
        sqlSelecthgoutside = GLAcctAgeUtils.truncateStringTailDot(sqlSelecthgoutside);
    }

    private static void dealHgJoin(AccountAgeParam paramAge) throws EASBizException, BOSException {
        HashMap hmItems = paramAge.getHmItems();
        StringBuffer sqlSelecthg = paramAge.getSqlSelecthg();
        StringBuffer sqlInnerJoin = paramAge.getSqlInnerJoin();
        StringBuffer sqlInnerJoinRpt = paramAge.getSqlInnerJoinRpt();
        StringBuffer sqlSelecthgoutside = paramAge.getSqlSelecthgoutside();
        StringBuffer sqlCreateHgTbl = paramAge.getSqlCreateHgTbl();
        StringBuilder sqlSelectorHgTbl = paramAge.getSqlSelectorHgTbl();
        StringBuffer sqlGroupbyAge = paramAge.getSqlGroupbyAge();
        Iterator itemkeyit = hmItems.keySet().iterator();
        ArrayList<HashMap> itemMapList = new ArrayList<HashMap>();
        boolean k = false;
        ArrayList<String> existItems = new ArrayList<String>();
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            if (existItems.contains(item.get("fieldname"))) continue;
            itemMapList.add(item);
            existItems.add(item.get("fieldname").toString());
        }
        ArrayList verifyFields = paramAge.getVerifyFields();
        int t = 0;
        String tA = "";
        HashMap[] itemList = itemMapList.toArray(new HashMap[0]);
        if (itemList.length > 0) {
            ArrayList<String[][]> asstActList = new ArrayList<String[][]>();
            paramAge.setAsstActNumbers(asstActList);
        }
        for (int i = 0; i < itemList.length; ++i) {
            boolean isVerify;
            HashMap item = itemList[i];
            boolean isGeneralActType = item.get("FGLAsstActTypeGrpID") != null;
            boolean isUseLongNumber = (Boolean)item.get("useLongNUmber");
            String numberFieldNumber = "fnumber";
            String[] numbers = (String[])hmItems.get(item);
            if (isUseLongNumber) {
                numberFieldNumber = "flongnumber";
                for (int ll = 0; ll < numbers.length; ++ll) {
                    if (numbers[ll] == null) continue;
                    numbers[ll] = numbers[ll].replace(".", "!");
                }
            }
            String table = (String)item.get("tablename");
            String field = (String)item.get("fieldname");
            tA = "T" + t;
            sqlInnerJoin.append(" inner join ").append(table).append(" ").append(tA).append(" on hg.").append(field).append("=").append(tA).append(".fid");
            sqlInnerJoinRpt.append(" inner join ").append(table).append(" ").append(tA).append(" on cussent.").append(tA).append(field).append("=").append(tA).append(".fid");
            if (paramAge.isIsOnlyUnion() && paramAge.getOtherInfo() != null && paramAge.getOtherInfo().get(field) != null) {
                sqlInnerJoin.append(" and hg.").append(field).append(" = '").append(paramAge.getOtherInfo().get(field).toString()).append("' ");
            }
            boolean bl = isVerify = paramAge.get(IS_VERIFY) != null && (Boolean)paramAge.get(IS_VERIFY) != false;
            if (numbers[0] != null && !isVerify) {
                sqlInnerJoin.append(" and ").append(tA).append(".").append(numberFieldNumber).append(" >= '").append(numbers[0]).append("' ");
                sqlInnerJoinRpt.append(" and ").append(tA).append(".").append(numberFieldNumber).append(" >= '").append(numbers[0]).append("' ");
            }
            if (numbers[1] != null && !isVerify) {
                sqlInnerJoin.append(" and ").append(tA).append(".").append(numberFieldNumber).append(" <= '").append(numbers[1]).append("' ");
                sqlInnerJoinRpt.append(" and ").append(tA).append(".").append(numberFieldNumber).append(" <= '").append(numbers[1]).append("' ");
            }
            if (!isVerify) {
                List<String[][]> asstActList = paramAge.getAsstActNumbers();
                String[][] asstActInfo = new String[2][2];
                if (numbers[0] != null) {
                    asstActInfo[0][0] = tA + "fnumber";
                    String string = asstActInfo[0][1] = isUseLongNumber ? numbers[0].replace("!", ".") : numbers[0];
                }
                if (numbers[1] != null) {
                    asstActInfo[1][0] = tA + "fnumber";
                    asstActInfo[1][1] = isUseLongNumber ? numbers[1].replace("!", ".") : numbers[1];
                }
                asstActList.add(asstActInfo);
            }
            sqlInnerJoin.append("  \r\n");
            verifyFields.add("hg." + field);
            sqlSelecthg.append("hg.").append(field).append(" as ").append("T").append(t).append(field).append(",");
            sqlSelectorHgTbl.append("T").append(t).append(field).append(",");
            if (isUseLongNumber && item.get("propname") != null && item.get("propname").toString().startsWith("general")) {
                sqlSelecthg.append("replace(T").append(t).append(".flongnumber,'!','.') as ").append("T").append(t).append("fnumber,");
            } else {
                sqlSelecthg.append("T").append(t).append(".fnumber as ").append("T").append(t).append("fnumber,");
            }
            sqlGroupbyAge.append("T").append(t).append(field).append(",");
            sqlSelectorHgTbl.append("T").append(t).append("fnumber,");
            sqlGroupbyAge.append("T").append(t).append("fnumber,");
            sqlSelecthg.append("T").append(t).append(".fname_").append(paramAge.getLoc()).append(" as ").append("T").append(t).append("fname,");
            sqlSelectorHgTbl.append("T").append(t).append("fname,");
            sqlGroupbyAge.append("T").append(t).append("fname,");
            sqlSelecthgoutside.append("T").append(t).append(field).append(",T").append(t).append("fnumber,").append("T").append(t).append("fname,");
            sqlCreateHgTbl.append("T").append(t).append(field).append(" varchar(44),").append("T").append(t).append("fnumber nvarchar(80),").append("T").append(t).append("fname nvarchar(255),");
            ++t;
        }
    }

    public static void getRptSql_ByAcctBal_AcNotInit_From(AccountAgeParam paramAge) {
        StringBuffer fromTable = paramAge.getSqlFromTable();
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            fromTable.append(" \r\n inner join t_bd_Currency currency on cussent.fcurrid = currency.fid");
        }
        if (paramAge.isJoinHgTable()) {
            // empty if block
        }
    }

    public static void getRptSql_ByAcctBal_AcNotInit_Where(AccountAgeParam paramAge) {
        StringBuffer whereNotInit = paramAge.getSqlWhereNotInit();
        if (paramAge.isIsOnlyUnion()) {
            whereNotInit.append(" where cussent.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" ) ");
            whereNotInit.append(" and cussent.faccountid in ( ").append(paramAge.getAccountid()).append(" )  ");
        } else {
            whereNotInit.append(" where cussent.fcompanyid in ( '").append(paramAge.getCompanyId()).append("' ) ");
            whereNotInit.append(" and cussent.faccountid in ( ").append(paramAge.getAccountid()).append(" ) ");
        }
        if (paramAge.isSetCurrency()) {
            whereNotInit.append(" and cussent.fcurrid = '" + paramAge.getCurrencyid() + "'   \r\n");
        }
    }

    public static String getSqlIn(List pkList) {
        StringBuffer sql = new StringBuffer();
        for (Object e : pkList) {
            if (e == null) continue;
            sql.append("'").append(e.toString()).append("'").append(",");
        }
        if (sql.length() > 0) {
            sql.deleteCharAt(sql.length() - 1);
        }
        return sql.toString();
    }

    public static Map<String, String> getTempTableFieldType(Context ctx, String function, String tableName) throws BOSException {
        String key = function + tableName;
        Map<String, String> dataTypes = tempFieldInfoCache.get(key);
        if (dataTypes == null) {
            dataTypes = GLTempTableUtil.getDataTypes(ctx, function, tableName);
            tempFieldInfoCache.put(key, dataTypes);
        }
        return dataTypes;
    }

    public static void clearTempTableFieldCache() {
        tempFieldInfoCache.clear();
    }

    public static CompanyOrgUnitInfo getCompanyById(Context ctx, String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = companyCache.get(companyId);
        if (company == null) {
            company = GlUtils.getCompanyById(ctx, companyId);
            companyCache.put(companyId, company);
        }
        return company;
    }

    public static void clearCompanyCache() {
        companyCache.clear();
    }

    public static PeriodInfo getPeriodInfo(Context ctx, java.util.Date date, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        String key = String.valueOf(date.getTime()) + companyInfo.getId().toString();
        PeriodInfo periodInfo = periodCache.get(key);
        if (periodInfo == null) {
            periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)date, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                return null;
            }
            periodCache.put(key, periodInfo);
        }
        return periodInfo;
    }

    public static void clearPeriodCache() {
        periodCache.clear();
    }

    public static int getVerifyModel(Context ctx, String companyId) throws EASBizException, BOSException {
        Integer verifyModel = verifyModelCache.get(companyId);
        if (verifyModel == null) {
            verifyModel = GlUtils.getVerifyMode(ctx, companyId);
            verifyModelCache.put(companyId, verifyModel);
        }
        return verifyModel;
    }

    public static void clearVerifyModelCache() {
        verifyModelCache.clear();
    }

    public static List<Map<String, Object>> getAllCurrency(Context ctx) throws SQLException, BOSException {
        if (allCurrencyCache.size() == 0) {
            String currencySql = "SELECT FID,FNUMBER,FPRECISION  FROM T_BD_CURRENCY";
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)currencySql);
            while (result.next()) {
                HashMap<String, Object> currencyMap = new HashMap<String, Object>(2);
                currencyMap.put("fid", result.getString(1));
                currencyMap.put("fnumber", result.getString(2));
                currencyMap.put("fprecision", result.getInt(3));
                allCurrencyCache.add(currencyMap);
            }
        }
        return allCurrencyCache;
    }

    public static void clearAllCurrencyCache() {
        allCurrencyCache.clear();
    }

    public static void clearAllDataCache() {
        GLAcctAgeNewUtils.clearTempTableFieldCache();
        GLAcctAgeNewUtils.clearStartPeriodCache();
        GLAcctAgeNewUtils.clearCompanyCache();
        GLAcctAgeNewUtils.clearCurrencyCache();
        GLAcctAgeNewUtils.clearVerifyModelCache();
        GLAcctAgeNewUtils.clearPeriodCache();
        GLAcctAgeNewUtils.clearCompanyCache();
    }

    public static String createIdsTempTable(Context ctx, String idsStr) {
        if (StringUtils.isEmpty((String)idsStr)) {
            return null;
        }
        String[] companyIdArray = idsStr.replace("'", "").split(",");
        String tempTable = null;
        if (companyIdArray.length >= 500) {
            tempTable = GLAcctAgeNewUtils.createIdsTempTable(ctx, new ArrayList<String>(Arrays.asList(companyIdArray)));
        }
        return tempTable;
    }

    public static String createIdsTempTable(Context ctx, List<String> idList) {
        if (idList == null || idList.size() <= 0) {
            return null;
        }
        String createTableSql = "create table ac_ids_temp_table (fid varchar(44))";
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
            String sql = "insert into " + tempTable + " values(?)";
            ArrayList<String[]> paramsList = new ArrayList<String[]>();
            for (String id : idList) {
                paramsList.add(new String[]{id.toString()});
            }
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
        catch (Exception e) {
            logger.error((Object)"Age query create idsTempTable error.", (Throwable)e);
            tempTable = null;
        }
        return tempTable;
    }

    public static void releaseIdsTempTable(Context ctx) {
        List<String> list = idsTempTables.get();
        for (String idsTempTable : list) {
            TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
            iPool.releaseTable(idsTempTable);
        }
        idsTempTables.remove();
    }

    public static class CurrencyRateConvertInfo {
        private String currid = null;
        private BigDecimal convertRate = null;

        public String getCurrid() {
            return this.currid;
        }

        public void setCurrid(String currid) {
            this.currid = currid;
        }

        public BigDecimal getConvertRate() {
            return this.convertRate;
        }

        public void setConvertRate(BigDecimal convertRate) {
            this.convertRate = convertRate;
        }
    }
}

