/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeCollection;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeEntryInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeFactory;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractGLAsstAccountChangeFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLAsstAccountChangeTransfer;
import com.kingdee.eas.fi.gl.app.GLBalanceRepairer;
import com.kingdee.eas.fi.gl.app.MockVoucherControllerBean;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLAsstAccountChangeFacadeControllerBean
extends AbstractGLAsstAccountChangeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLAsstAccountChangeFacadeControllerBean");

    @Override
    protected Map _transfer(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String action = (String)params.get("action");
        String companyId = (String)params.get("companyId");
        String accountId = (String)params.get("accountId");
        Integer periodFrom = (Integer)params.get("periodFrom");
        Integer periodTo = (Integer)params.get("periodTo");
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (startPeriod.getNumber() > periodFrom) {
            periodFrom = startPeriod.getNumber();
        }
        boolean isTry = true;
        Object o = params.get("isTry");
        if (o != null) {
            String str = o.toString();
            isTry = str.equals("true");
        }
        ArrayList<String> deleteIds = new ArrayList<String>();
        if ("delete".equals(action) || "rebuild".equals(action)) {
            List<Map<String, Object>> vouchers = this.deleteChangeVoucher(ctx, params, company, periodFrom, periodTo, accountId);
            for (Map<String, Object> voucher : vouchers) {
                deleteIds.add((String)voucher.get("id"));
            }
            result.put("existVouchers", vouchers);
            if ("delete".equals(action)) {
                return result;
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("account.id");
        selector.add("period.id");
        selector.add("before.id");
        selector.add("after.id");
        selector.add("entries.id");
        selector.add("entries.asstActType.id");
        selector.add("entries.asstAct");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.companyID.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)periodFrom, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)periodTo, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("account.isLeaf", (Object)1));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("period.number");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        view.setSorter(sorter);
        AsstAccountChangeCollection changes = AsstAccountChangeFactory.getLocalInstance((Context)ctx).getAsstAccountChangeCollection(view);
        if (changes.size() == 0) {
            result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"no_change_log", (Locale)ctx.getLocale()));
            return result;
        }
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId), selector);
        ArrayList<Map> vouchers = new ArrayList<Map>();
        result.put("buildVouchers", vouchers);
        for (int i = 0; i < changes.size(); ++i) {
            Map voucher;
            AsstAccountChangeInfo change = changes.get(i);
            if (isTry) {
                change.put("isTry", (Object)true);
                if ("rebuild".equals(action)) {
                    change.put("isTotal", (Object)true);
                }
            }
            if (!(voucher = GLAsstAccountChangeTransfer.process(ctx, change, null)).containsKey("entries") && !voucher.containsKey("id")) continue;
            vouchers.add(voucher);
            voucher.put("period", change.getPeriod().getNumber());
            if (isTry) break;
            HashMap<String, Object> rparams = new HashMap<String, Object>();
            rparams.put("companyId", companyId);
            HashSet<String> accNumbers = new HashSet<String>();
            accNumbers.add(account.getNumber());
            rparams.put("accountNumbers", accNumbers);
            rparams.put("periodfrom", change.getPeriod());
            if (i == changes.size() - 1) {
                PeriodInfo pt = change.getPeriod();
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select max(FPeriod) FPeriod from T_GL_AssistBalance_1F where FOrgUnitID = ? and FAccountID = ?", (Object[])new String[]{companyId, accountId});
                try {
                    while (rs.next()) {
                        int n = rs.getInt("FPeriod");
                        if (n <= pt.getNumber()) continue;
                        pt = new PeriodInfo();
                        pt.setNumber(n);
                    }
                }
                catch (SQLException sQLException) {
                    throw new BOSException((Throwable)sQLException);
                }
                rparams.put("periodto", pt);
            } else {
                rparams.put("periodto", changes.get(i + 1).getPeriod());
            }
            rparams.put("repairAccount", true);
            rparams.put("repairAssist", true);
            rparams.put("repairMeasure", true);
            rparams.put("onlyClean", false);
            String sql = "update T_GL_Voucher_Log set FIsUpdating = 2 where FVoucherID = ? and FIsUpdating = 0";
            if (deleteIds.size() > 0) {
                for (Object e : deleteIds) {
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{e});
                }
                deleteIds.clear();
            }
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucher.get("id")});
            GLBalanceRepairer.repair(ctx, rparams);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> deleteChangeVoucher(Context ctx, Map params, CompanyOrgUnitInfo company, int periodFrom, int periodTo, String accountId) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    v.FID, v.FNumber, v.FBizStatus, p.FNumber FPeriod \n");
        sql.append("from t_gl_voucher v \n");
        sql.append("join t_bd_period p on p.FID = v.FPeriodID \n");
        sql.append("where v.fcompanyid=? and v.FSourceType=11 \n");
        sql.append("and p.FNumber >= ? \n");
        sql.append("and p.FNumber <= ? \n");
        sql.append("and exists ( \n");
        sql.append("  select 1 from t_gl_voucherentry ve where ve.FBILLID = v.FID and ve.FACCOUNTID = ? \n");
        sql.append(") \n");
        sql.append("order by p.FNumber \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), periodFrom, periodTo, accountId});
        HashMap<String, Integer> listPK = new HashMap<String, Integer>();
        boolean foundPosted = false;
        try {
            while (rs.next()) {
                listPK.put(rs.getString("FID"), rs.getInt("FBizStatus"));
                if (rs.getInt("FBizStatus") == 5) {
                    foundPosted = true;
                }
                HashMap<String, String> v = new HashMap<String, String>();
                v.put("id", rs.getString("FID"));
                v.put("number", rs.getString("FNumber"));
                v.put("period", rs.getString("FPeriod"));
                list.add(v);
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        boolean isTry = true;
        Object o = params.get("isTry");
        if (o != null) {
            String str = o.toString();
            isTry = str.equals("true");
        }
        if (isTry) {
            return list;
        }
        sql.setLength(0);
        sql.append("delete from T_GL_AcctCussentHistory where FVOUCHERASSTIDID in ( \n");
        sql.append("  select FID from T_GL_AcctCussent where FVchAssistRecordID in ( \n");
        sql.append("    select FID from T_GL_VoucherAssistRecord where FBILLID = ? \n");
        sql.append("  ) \n");
        sql.append(") \n");
        for (String id : listPK.keySet()) {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{id});
        }
        MockVoucherControllerBean voucher = new MockVoucherControllerBean();
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            if (foundPosted) {
                VoucherProcessCache.initCache(ctx, cacheId);
                VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
                cache.getDatasFromCache(ctx, "aac").put("aac", Boolean.TRUE);
            }
            for (String id : listPK.keySet()) {
                if ((Integer)listPK.get(id) != 5) continue;
                voucher.antiPostVoucher(ctx, (IObjectPK)new ObjectUuidPK(id), VoucherStatusEnum.POSTED);
            }
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
        }
        boolean association = VoucherUtil.isAssociationCashManagement(ctx, company);
        if (association) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            for (String id : listPK.keySet()) {
                if (!this.isBookByEntry(ctx, id)) {
                    bookNotifyFacade.antiBook(id);
                    continue;
                }
                bookNotifyFacade.batchAntiBook(this.getEntryIds(ctx, id));
            }
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(listPK.keySet());
        this.antiAuditCheckVoucher(ctx, ids);
        for (String id : listPK.keySet()) {
            voucher.delete(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
        return list;
    }

    private boolean isBookByEntry(Context ctx, String vid) throws BOSException, EASBizException {
        String sql = "select fid from t_cas_journal where FBillID= ?";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vid});
        return rowset == null || rowset.size() == 0;
    }

    private Set<String> getEntryIds(Context ctx, String vid) throws BOSException {
        String sql = "select FID from t_gl_voucherentry where FBillID = ?";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vid});
        HashSet<String> ids = new HashSet<String>();
        try {
            while (rowset.next()) {
                ids.add(rowset.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    private void antiAuditCheckVoucher(Context ctx, List<String> pkList) throws BOSException {
        String voStr = ToolUtils.aryToStr(pkList, (boolean)true);
        String updateSql = "update t_gl_voucher set fischeck =0 , FBizStatus=1, fauditorid=null,  fcashierid=null where\u3000fid in (" + voStr + ") ";
        DbUtil.execute((Context)ctx, (String)updateSql);
        String dpdatesql2 = "update T_GL_VoucherEntry set fischeck =0 , fcashierid= null  where FBillID in (" + voStr + ")";
        DbUtil.execute((Context)ctx, (String)dpdatesql2);
    }

    @Override
    protected Map _getDefaultVals(Context ctx, Map params) throws BOSException, EASBizException {
        SelectorItemCollection selector;
        HashMap result = new HashMap();
        String accountId = (String)params.get("accountId");
        if (accountId == null || accountId.trim().length() == 0) {
            return result;
        }
        accountId = accountId.trim();
        Integer periodNumber = (Integer)params.get("periodNumber");
        if (periodNumber == null) {
            String periodId = (String)params.get("periodId");
            if (periodId == null || periodId.trim().length() == 0) {
                return result;
            }
            periodId = periodId.trim();
            selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId), selector);
            periodNumber = period.getNumber();
        } else if (periodNumber <= 190000 || periodNumber >= 209999) {
            return result;
        }
        EntityViewInfo view = new EntityViewInfo();
        selector = new SelectorItemCollection();
        selector.add("before.id");
        selector.add("after.id");
        selector.add("period.id");
        selector.add("entries.asstActType.id");
        selector.add("entries.asstAct");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        filter.getFilterItems().add(new FilterItemInfo("period.number", (Object)periodNumber, CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo si = new SorterItemInfo("period.number");
        si.setSortType(SortType.DESCEND);
        sorter.add(si);
        view.setSorter(sorter);
        AsstAccountChangeCollection changes = AsstAccountChangeFactory.getLocalInstance((Context)ctx).getAsstAccountChangeCollection(view);
        if (changes.size() == 0) {
            return result;
        }
        AsstAccountInfo aa = changes.get(0).getAfter();
        if (aa == null) {
            return result;
        }
        HashMap<String, String> defaultIds = new HashMap<String, String>();
        HashMap<String, AsstActTypeInfo> aats = new HashMap<String, AsstActTypeInfo>();
        AsstActTypeCollection coll = GLAsstAccountUtils.getAsstActTypes(ctx, aa.getId().toString());
        for (AsstActTypeInfo aat : coll) {
            aats.put(aat.getId().toString(), aat);
        }
        for (AsstAccountChangeInfo change : changes) {
            for (AsstAccountChangeEntryInfo entry : change.getEntries()) {
                if (entry.getAsstActType() == null || entry.getAsstAct() == null) continue;
                String aatId = entry.getAsstActType().getId().toString();
                String asstActId = entry.getAsstAct().trim();
                if (!aats.containsKey(aatId) || asstActId.length() <= 0 || defaultIds.get(aatId) != null) continue;
                defaultIds.put(aatId, asstActId);
            }
            if (defaultIds.size() < aats.size()) continue;
            break;
        }
        for (String aatId : defaultIds.keySet()) {
            ObjectBaseInfo value;
            String asstActId = (String)defaultIds.get(aatId);
            if (asstActId == null || (value = GlWebServiceUtil.findAsstActObject(ctx, ((AsstActTypeInfo)aats.get(aatId)).getAsstHGAttribute(), asstActId)) == null) continue;
            result.put(aats.get(aatId), value);
        }
        return result;
    }
}

