/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLBalanceTransfer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLBalanceTransfer");
    public static final String BatchCount = "GL_Close_BatchCount";
    public static final String UseDialect = "GL_Close_UseDialect";
    public static final String ClearBegin = "GL_Close_ClearBegin";

    public static void toNextPeriod(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currPeriod, PeriodInfo nextPeriod, Set<String> accountIds) throws BOSException, EASBizException {
        String accountTableId;
        String str;
        GLBalanceTransfer.initCompany(ctx, company);
        GLBalanceTransfer.initPeriod(ctx, currPeriod, nextPeriod);
        boolean clearBegin = true;
        boolean useDialect = false;
        int batchCount = 0;
        HashMap<String, String> inParams = new HashMap<String, String>();
        inParams.put(ClearBegin, company.getId().toString());
        inParams.put(UseDialect, company.getId().toString());
        inParams.put(BatchCount, company.getId().toString());
        HashMap outParams = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(inParams);
        if (outParams.get(ClearBegin) != null && "false".equals(str = outParams.get(ClearBegin).toString())) {
            clearBegin = false;
        }
        if (outParams.get(UseDialect) != null && "true".equals(str = outParams.get(UseDialect).toString())) {
            useDialect = GLBalanceTransfer.isOracle10gOver(ctx);
        }
        if (outParams.get(BatchCount) != null) {
            try {
                str = outParams.get(BatchCount).toString();
                batchCount = Integer.parseInt(str);
            }
            catch (Exception e) {
                logger.warn((Object)"", (Throwable)e);
            }
        }
        if (batchCount < 0 || batchCount > 50) {
            batchCount = 0;
        }
        boolean isNextYear = false;
        if (nextPeriod.getPeriodYear() != currPeriod.getPeriodYear()) {
            isNextYear = true;
        }
        if (accountIds != null && accountIds.size() > 0) {
            GLBalanceTransfer.transAccountBalance(ctx, company, currPeriod, nextPeriod, isNextYear, accountIds, clearBegin, useDialect);
            GLBalanceTransfer.transAssistBalance(ctx, company, currPeriod, nextPeriod, isNextYear, accountIds, clearBegin, useDialect);
            GLBalanceTransfer.transMeasureBalance(ctx, company, currPeriod, nextPeriod, isNextYear, accountIds, clearBegin, useDialect);
            return;
        }
        if (batchCount == 0) {
            GLBalanceTransfer.transAccountBalance(ctx, company, currPeriod, nextPeriod, isNextYear, null, clearBegin, useDialect);
            GLBalanceTransfer.transAssistBalance(ctx, company, currPeriod, nextPeriod, isNextYear, null, clearBegin, useDialect);
            GLBalanceTransfer.transMeasureBalance(ctx, company, currPeriod, nextPeriod, isNextYear, null, clearBegin, useDialect);
            return;
        }
        GLBalanceTransfer.transAccountBalance(ctx, company, currPeriod, nextPeriod, isNextYear, null, clearBegin, useDialect);
        Map<String, Object> constrast = GLBalanceTransfer.getAccountRefConstrast(ctx, company.getId().toString(), currPeriod);
        if (constrast == null) {
            accountTableId = company.getAccountTable().getId().toString();
        } else {
            int periodNumber = (Integer)constrast.get("periodNumber");
            String disableAcctTableId = (String)constrast.get("disableAcctTableID");
            String enabledAcctTableId = (String)constrast.get("enabledAcctTableID");
            accountTableId = currPeriod.getNumber() == periodNumber ? enabledAcctTableId : disableAcctTableId;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isLeaf");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1));
        view.setFilter(filter);
        AccountViewCollection accounts = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        if (accounts == null || accounts.size() == 0) {
            return;
        }
        if (batchCount == 1) {
            for (int i = 0; i < accounts.size(); ++i) {
                AccountViewInfo account = accounts.get(i);
                if (!account.isIsLeaf()) continue;
                HashSet<String> ids = new HashSet<String>();
                ids.add(account.getId().toString());
                GLBalanceTransfer.transAssistBalance(ctx, company, currPeriod, nextPeriod, isNextYear, ids, clearBegin, useDialect);
                GLBalanceTransfer.transMeasureBalance(ctx, company, currPeriod, nextPeriod, isNextYear, ids, clearBegin, useDialect);
            }
        } else {
            ArrayList idss = new ArrayList();
            HashSet<String> items = new HashSet<String>();
            for (int i = 0; i < accounts.size(); ++i) {
                AccountViewInfo accountViewInfo = accounts.get(i);
                if (!accountViewInfo.isIsLeaf()) continue;
                items.add(accountViewInfo.getId().toString());
                if (items.size() < batchCount) continue;
                idss.add(items);
                items = new HashSet();
            }
            if (items.size() > 0) {
                idss.add(items);
            }
            for (Set set : idss) {
                GLBalanceTransfer.transAssistBalance(ctx, company, currPeriod, nextPeriod, isNextYear, set, clearBegin, useDialect);
                GLBalanceTransfer.transMeasureBalance(ctx, company, currPeriod, nextPeriod, isNextYear, set, clearBegin, useDialect);
            }
        }
    }

    private static Map<String, Object> getAccountRefConstrast(Context ctx, String companyId, PeriodInfo startPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  p.FNumber FPeriodNumber, c.FDisabledAcctTableID, c.FEnabledAcctTableID \n");
        sql.append("from T_bd_AcctRefContrast c \n");
        sql.append("join T_bd_Period p on p.FID = c.FEnabledPeriodID \n");
        sql.append("where c.FCompanyID = ? \n");
        sql.append("  and FRefType = 1 \n");
        sql.append("  and FIsEnabled = 1 \n");
        sql.append("  and p.FNumber >= ? \n");
        sql.append("order by p.FNumber \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, startPeriod.getNumber()});
        try {
            if (rs.next()) {
                HashMap<String, Object> constrast = new HashMap<String, Object>();
                constrast.put("periodNumber", rs.getInt("FPeriodNumber"));
                constrast.put("disableAcctTableID", rs.getString("FDisabledAcctTableID"));
                constrast.put("enabledAcctTableID", rs.getString("FEnabledAcctTableID"));
                return constrast;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static void transAccountBalance(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currPeriod, PeriodInfo nextPeriod, boolean isNextYear, Set<String> ids, boolean clearBegin, boolean useDialect) throws BOSException, EASBizException {
        if (useDialect) {
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 1, null, clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 5, null, clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", clearBegin);
        } else {
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 1, null);
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 5, null);
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 1, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        }
        if (clearBegin) {
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 1, 1, null);
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 1, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 1, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 1, 5, null);
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 1, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 1, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        }
    }

    public static void transAssistBalance(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currPeriod, PeriodInfo nextPeriod, boolean isNextYear, Set<String> ids, boolean clearBegin, boolean useDialect) throws BOSException, EASBizException {
        if (useDialect) {
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 1, null, clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 5, null, clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", clearBegin);
        } else {
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 1, null);
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 5, null);
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 2, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        }
        if (clearBegin) {
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 2, 1, null);
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 2, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 2, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 2, 5, null);
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 2, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 2, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        }
    }

    public static void transMeasureBalance(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currPeriod, PeriodInfo nextPeriod, boolean isNextYear, Set<String> ids, boolean clearBegin, boolean useDialect) throws BOSException, EASBizException {
        if (useDialect) {
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 1, null, clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 5, null, clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", clearBegin);
            GLBalanceTransfer.transBalanceForOracle(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", clearBegin);
        } else {
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 1, null);
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 5, null);
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.transBalanceForKsql(ctx, company, currPeriod, nextPeriod, isNextYear, ids, 3, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        }
        if (clearBegin) {
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 3, 1, null);
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 3, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 3, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 3, 5, null);
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 3, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceTransfer.clearBeginBalance(ctx, company, currPeriod, nextPeriod, ids, 3, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        }
    }

    public static void transBalanceForKsql(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currPeriod, PeriodInfo nextPeriod, boolean isNextYear, Set<String> ids, int balanceType, int balType, String currencyId) throws BOSException, EASBizException {
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        String T_GL_Balance = GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_GL_Balance + " ( \n");
        sql.append("  forgunitid, faccountid, \n");
        if (balanceType == 2 || balanceType == 3) {
            sql.append("  fassistgrpid, \n");
        }
        if (balanceType == 3) {
            sql.append("  fmeasureunitid, \n");
        }
        if (isForCurrency) {
            sql.append("  fcurrencyid, \n");
        }
        sql.append("  fperiod \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  ab.forgunitid, ab.faccountid, \n");
        if (balanceType == 2 || balanceType == 3) {
            sql.append("  ab.fassistgrpid, \n");
        }
        if (balanceType == 3) {
            sql.append("  ab.fmeasureunitid, \n");
        }
        if (isForCurrency) {
            sql.append("  ab.fcurrencyid, \n");
        }
        sql.append("  ? fperiod \n");
        sql.append("from " + T_GL_Balance + " ab \n");
        sql.append("where ab.forgunitid = ? and ab.fperiod = ? \n");
        if (ids != null && ids.size() > 0) {
            if (ids.size() == 1) {
                sql.append("  and ab.FAccountID = ? \n");
            } else {
                sql.append("  and ab.FAccountID in (" + GLBalanceTransfer.buildMark(ids.size()) + ") \n");
            }
        }
        if (balanceType == 2 || balanceType == 3) {
            sql.append("  and ( \n");
            if (isForCurrency) {
                sql.append("    ab.fendbalancefor<>0 or \n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("    ab.fendbalancelocal<>0 or \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("    ab.fendbalancerpt<>0 or \n");
            }
            sql.append("    ab.fendqty<>0 \n");
            if (!isNextYear) {
                if (isForCurrency) {
                    sql.append("    or ab.fyeardebitfor<>0 or ab.fyearcreditfor<>0 or ab.fyearpnlfor<>0 ");
                }
                if (isLocaCurrency || isForCurrency) {
                    sql.append("    or ab.fyeardebitlocal<>0 or ab.fyearcreditlocal<>0 or ab.fyearpnllocal<>0 ");
                }
                if (isRptCurrency || isForCurrency) {
                    sql.append("    or ab.fyeardebitrpt<>0 or ab.fyearcreditrpt<>0 or ab.fyearpnlrpt<>0 ");
                }
                sql.append("    or ab.fyeardebitqty<>0 or ab.fyearcreditqty<>0 or isNull(ab.fyearpnlqty,0)<>0 ");
                sql.append("    or isNull(ab.FDetailCount,0) <> 0 ");
            }
            sql.append("  ) \n");
        }
        sql.append("  and not exists ( \n");
        sql.append("    select 1 from " + T_GL_Balance + " ab1 \n");
        sql.append("    where ab1.forgunitid = ? and ab1.fperiod = ? \n");
        sql.append("    and ab1.faccountid = ab.faccountid \n");
        if (balanceType == 2 || balanceType == 3) {
            sql.append("    and ab1.fassistgrpid=ab.fassistgrpid \n");
        }
        if (balanceType == 3) {
            sql.append("    and ab1.fmeasureunitid=ab.fmeasureunitid \n");
        }
        if (isForCurrency) {
            sql.append("    and ab1.fcurrencyid = ab.fcurrencyid \n");
        }
        sql.append("  ) \n");
        params.add(nextPeriod.getNumber());
        params.add(company.getId().toString());
        params.add(currPeriod.getNumber());
        if (ids != null && ids.size() > 0) {
            params.addAll(ids);
        }
        params.add(company.getId().toString());
        params.add(nextPeriod.getNumber());
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        sql.setLength(0);
        params = new ArrayList();
        sql.append("update " + T_GL_Balance + " set ( \n");
        if (isForCurrency) {
            sql.append("  fyeardebitfor, fyearcreditfor, fyearpnlfor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("  fyeardebitlocal, fyearcreditlocal, fyearpnllocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  fyeardebitrpt, fyearcreditrpt, fyearpnlrpt, \n");
        }
        sql.append("  fyeardebitqty, fyearcreditqty, fyearpnlqty, \n");
        if (isForCurrency) {
            sql.append("  fbeginbalancefor, fendbalancefor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("  fbeginbalancelocal, fendbalancelocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  fbeginbalancerpt, fendbalancerpt, \n");
        }
        sql.append("  fbeginqty, fendqty \n");
        sql.append(") = ( \n");
        sql.append("  select \n");
        if (isNextYear) {
            if (isForCurrency) {
                sql.append("    fdebitfor+0, fcreditfor+0, fmonthpnlfor+0, \n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("    fdebitlocal+0, fcreditlocal+0, fmonthpnllocal+0, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("    fdebitrpt+0, fcreditrpt+0, fmonthpnlrpt+0, \n");
            }
            sql.append("    fdebitqty+0, fcreditqty+0, isNull(fmonthpnlqty,0)+0, \n");
        } else {
            if (isForCurrency) {
                sql.append("    yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, yearpnlfor + fmonthpnlfor, \n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("    yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, yearpnllocal + fmonthpnllocal, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("    yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, yearpnlrpt + fmonthpnlrpt, \n");
            }
            sql.append("    yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, isNull(yearpnlqty,0) + isNull(fmonthpnlqty,0), \n");
        }
        if (isForCurrency) {
            sql.append("    endbalancefor, endbalancefor + fdebitfor - fcreditfor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("    endbalancelocal, endbalancelocal + fdebitlocal - fcreditlocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("    endbalancerpt, endbalancerpt + fdebitrpt - fcreditrpt, \n");
        }
        sql.append("    endqty, endqty + fdebitqty - fcreditqty \n");
        sql.append("  from ( \n");
        sql.append("    select \n");
        sql.append("      ab.faccountid accountid, \n");
        if (balanceType == 2 || balanceType == 3) {
            sql.append("      ab.fassistgrpid assistgrpid, \n");
        }
        if (balanceType == 3) {
            sql.append("      ab.fmeasureunitid measureunitid, \n");
        }
        if (isForCurrency) {
            sql.append("      ab.fcurrencyid currencyid, \n");
        }
        if (!isNextYear) {
            if (isForCurrency) {
                sql.append("      ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fyearpnlfor yearpnlfor, \n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("      ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fyearpnllocal yearpnllocal, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("      ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fyearpnlrpt yearpnlrpt, \n");
            }
            sql.append("      ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fyearpnlqty yearpnlqty, \n");
        }
        if (isForCurrency) {
            sql.append("      ab.fendbalancefor endbalancefor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("      ab.fendbalancelocal endbalancelocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("      ab.fendbalancerpt endbalancerpt, \n");
        }
        sql.append("      ab.fendqty endqty \n");
        sql.append("    from " + T_GL_Balance + " ab \n");
        sql.append("    where ab.forgunitid=? and ab.fperiod=? \n");
        if (ids != null && ids.size() > 0) {
            if (ids.size() == 1) {
                sql.append("      and ab.FAccountID = ? \n");
            } else {
                sql.append("      and ab.FAccountID in (" + GLBalanceTransfer.buildMark(ids.size()) + ") \n");
            }
        }
        sql.append("  ) t \n");
        sql.append("  where accountid = faccountid \n");
        if (balanceType == 2 || balanceType == 3) {
            sql.append("    and assistgrpid = fassistgrpid \n");
        }
        if (balanceType == 3) {
            sql.append("    and measureunitid = fmeasureunitid \n");
        }
        if (isForCurrency) {
            sql.append("    and currencyid = fcurrencyid \n");
        }
        sql.append(") \n");
        sql.append("where forgunitid = ? and fperiod = ? \n");
        if (ids != null && ids.size() > 0) {
            if (ids.size() == 1) {
                sql.append("  and FAccountID = ? \n");
            } else {
                sql.append("  and FAccountID in (" + GLBalanceTransfer.buildMark(ids.size()) + ") \n");
            }
        }
        params.add(company.getId().toString());
        params.add(currPeriod.getNumber());
        if (ids != null && ids.size() > 0) {
            params.addAll(ids);
        }
        params.add(company.getId().toString());
        params.add(nextPeriod.getNumber());
        if (ids != null && ids.size() > 0) {
            params.addAll(ids);
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    public static void transBalanceForOracle(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currPeriod, PeriodInfo nextPeriod, boolean isNextYear, Set<String> ids, int balanceType, int balType, String currencyId, boolean clearBegin) throws BOSException, EASBizException {
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        String T_GL_Balance = GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ MERGE INTO " + T_GL_Balance + " tin USING ( \n");
        sql.append("  select * from " + T_GL_Balance + " \n");
        sql.append("  where forgunitid = ? and fperiod = ? \n");
        if (ids != null && ids.size() > 0) {
            if (ids.size() == 1) {
                sql.append("  and FAccountID = ? \n");
            } else {
                sql.append("  and FAccountID in (" + GLBalanceTransfer.buildMark(ids.size()) + ") \n");
            }
        }
        sql.append(") tout on (tin.forgunitid = tout.forgunitid \n");
        sql.append("    and tin.faccountid = tout.faccountid \n");
        if (isForCurrency) {
            sql.append("    and tin.fcurrencyid = tout.fcurrencyid \n");
        }
        if (balanceType == 2 || balanceType == 3) {
            sql.append("    and tin.fassistgrpid = tout.fassistgrpid \n");
        }
        if (balanceType == 3) {
            sql.append("    and tin.fmeasureunitid = tout.fmeasureunitid \n");
        }
        sql.append("    and tin.fperiod = ?) \n");
        sql.append("WHEN MATCHED THEN \n");
        sql.append("UPDATE SET \n");
        if (isForCurrency) {
            sql.append("  tin.fbeginbalancefor = tout.fendbalancefor, \n");
            sql.append("  tin.fendbalancefor = tout.fendbalancefor + tin.fdebitfor - tin.fcreditfor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("  tin.fbeginbalancelocal = tout.fendbalancelocal, \n");
            sql.append("  tin.fendbalancelocal = tout.fendbalancelocal + tin.fdebitlocal - tin.fcreditlocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  tin.fbeginbalancerpt = tout.fendbalancerpt, \n");
            sql.append("  tin.fendbalancerpt = tout.fendbalancerpt + tin.fdebitrpt - tin.fcreditrpt, \n");
        }
        sql.append("  tin.fbeginqty = tout.fendqty, \n");
        sql.append("  tin.fendqty = tout.fendqty + tin.fdebitqty - tin.fcreditqty, \n");
        if (isNextYear) {
            if (isForCurrency) {
                sql.append("  tin.fyeardebitfor = tin.fdebitfor, \n");
                sql.append("  tin.fyearcreditfor = tin.fcreditfor, \n");
                sql.append("  tin.fyearpnlfor = tin.fmonthpnlfor, \n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("  tin.fyeardebitlocal = tin.fdebitlocal, \n");
                sql.append("  tin.fyearcreditlocal = tin.fcreditlocal, \n");
                sql.append("  tin.fyearpnllocal = tin.fmonthpnllocal, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("  tin.fyeardebitrpt = tin.fdebitrpt, \n");
                sql.append("  tin.fyearcreditrpt = tin.fcreditrpt, \n");
                sql.append("  tin.fyearpnlrpt = tin.fmonthpnlrpt, \n");
            }
            sql.append("  tin.fyeardebitqty = tin.fdebitqty, \n");
            sql.append("  tin.fyearcreditqty = tin.fcreditqty, \n");
            sql.append("  tin.fyearpnlqty = nvl(tin.fmonthpnlqty,0) \n");
        } else {
            if (isForCurrency) {
                sql.append("  tin.fyeardebitfor = tout.fyeardebitfor + tin.fdebitfor, \n");
                sql.append("  tin.fyearcreditfor = tout.fyearcreditfor + tin.fcreditfor, \n");
                sql.append("  tin.fyearpnlfor = tout.fyearpnlfor + tin.fmonthpnlfor, \n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("  tin.fyeardebitlocal = tout.fyeardebitlocal + tin.fdebitlocal, \n");
                sql.append("  tin.fyearcreditlocal = tout.fyearcreditlocal + tin.fcreditlocal, \n");
                sql.append("  tin.fyearpnllocal = tout.fyearpnllocal + tin.fmonthpnllocal, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("  tin.fyeardebitrpt = tout.fyeardebitrpt + tin.fdebitrpt, \n");
                sql.append("  tin.fyearcreditrpt = tout.fyearcreditrpt + tin.fcreditrpt, \n");
                sql.append("  tin.fyearpnlrpt = tout.fyearpnlrpt + tin.fmonthpnlrpt, \n");
            }
            sql.append("  tin.fyeardebitqty = tout.fyeardebitqty + tin.fdebitqty, \n");
            sql.append("  tin.fyearcreditqty = tout.fyearcreditqty + tin.fcreditqty, \n");
            sql.append("  tin.fyearpnlqty = nvl(tout.fyearpnlqty,0) + nvl(tin.fmonthpnlqty,0) \n");
        }
        if (!clearBegin) {
            sql.append("where \n");
            sql.append("  tin.fbeginqty <> tout.fendqty \n");
            sql.append("  or tin.fendqty <> tout.fendqty + tin.fdebitqty - tin.fcreditqty \n");
            if (isForCurrency) {
                sql.append("  or tin.fbeginbalancefor <> tout.fendbalancefor \n");
                sql.append("  or tin.fendbalancefor <> tout.fendbalancefor + tin.fdebitfor - tin.fcreditfor \n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("  or tin.fbeginbalancelocal <> tout.fendbalancelocal \n");
                sql.append("  or tin.fendbalancelocal <> tout.fendbalancelocal + tin.fdebitlocal - tin.fcreditlocal \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("  or tin.fbeginbalancerpt <> tout.fendbalancerpt \n");
                sql.append("  or tin.fendbalancerpt <> tout.fendbalancerpt + tin.fdebitrpt - tin.fcreditrpt \n");
            }
            if (isNextYear) {
                if (isForCurrency) {
                    sql.append("  or tin.fyeardebitfor <> tin.fdebitfor \n");
                    sql.append("  or tin.fyearcreditfor <> tin.fcreditfor \n");
                    sql.append("  or tin.fyearpnlfor <> tin.fmonthpnlfor \n");
                }
                if (isLocaCurrency || isForCurrency) {
                    sql.append("  or tin.fyeardebitlocal <> tin.fdebitlocal \n");
                    sql.append("  or tin.fyearcreditlocal <> tin.fcreditlocal \n");
                    sql.append("  or tin.fyearpnllocal <> tin.fmonthpnllocal \n");
                }
                if (isRptCurrency || isForCurrency) {
                    sql.append("  or tin.fyeardebitrpt <> tin.fdebitrpt \n");
                    sql.append("  or tin.fyearcreditrpt <> tin.fcreditrpt \n");
                    sql.append("  or tin.fyearpnlrpt <> tin.fmonthpnlrpt \n");
                }
                sql.append("  or tin.fyeardebitqty <> tin.fdebitqty \n");
                sql.append("  or tin.fyearcreditqty <> tin.fcreditqty \n");
                sql.append("  or nvl(tin.fyearpnlqty,0) <> nvl(tin.fmonthpnlqty,0) \n");
            } else {
                if (isForCurrency) {
                    sql.append("  or tin.fyeardebitfor <> tout.fyeardebitfor + tin.fdebitfor \n");
                    sql.append("  or tin.fyearcreditfor <> tout.fyearcreditfor + tin.fcreditfor \n");
                    sql.append("  or tin.fyearpnlfor <> tout.fyearpnlfor + tin.fmonthpnlfor \n");
                }
                if (isLocaCurrency || isForCurrency) {
                    sql.append("  or tin.fyeardebitlocal <> tout.fyeardebitlocal + tin.fdebitlocal \n");
                    sql.append("  or tin.fyearcreditlocal <> tout.fyearcreditlocal + tin.fcreditlocal \n");
                    sql.append("  or tin.fyearpnllocal <> tout.fyearpnllocal + tin.fmonthpnllocal \n");
                }
                if (isRptCurrency || isForCurrency) {
                    sql.append("  or tin.fyeardebitrpt <> tout.fyeardebitrpt + tin.fdebitrpt \n");
                    sql.append("  or tin.fyearcreditrpt <> tout.fyearcreditrpt + tin.fcreditrpt \n");
                    sql.append("  or tin.fyearpnlrpt <> tout.fyearpnlrpt + tin.fmonthpnlrpt \n");
                }
                sql.append("  or tin.fyeardebitqty <> tout.fyeardebitqty + tin.fdebitqty \n");
                sql.append("  or tin.fyearcreditqty <> tout.fyearcreditqty + tin.fcreditqty \n");
                sql.append("  or nvl(tin.fyearpnlqty,0) <> nvl(tout.fyearpnlqty,0) + nvl(tin.fmonthpnlqty,0) \n");
            }
        }
        sql.append("WHEN NOT MATCHED THEN \n");
        sql.append("INSERT ( \n");
        sql.append("  forgunitid, fperiod, faccountid, \n");
        if (isForCurrency) {
            sql.append("  fcurrencyid, \n");
        }
        if (balanceType == 2 || balanceType == 3) {
            sql.append("  fassistgrpid, \n");
        }
        if (balanceType == 3) {
            sql.append("  fmeasureunitid, \n");
        }
        if (isForCurrency) {
            sql.append("  fbeginbalancefor, fendbalancefor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("  fbeginbalancelocal, fendbalancelocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  fbeginbalancerpt, fendbalancerpt, \n");
        }
        sql.append("  fbeginqty, fendqty, \n");
        if (isForCurrency) {
            sql.append("  fyeardebitfor, fyearcreditfor, fyearpnlfor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("  fyeardebitlocal, fyearcreditlocal, fyearpnllocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  fyeardebitrpt, fyearcreditrpt, fyearpnlrpt, \n");
        }
        sql.append("  fyeardebitqty, fyearcreditqty, fyearpnlqty, \n");
        sql.append("  fdetailcount \n");
        sql.append(") \n");
        sql.append("VALUES ( \n");
        sql.append("  tout.forgunitid, ?, tout.faccountid, \n");
        if (isForCurrency) {
            sql.append("  tout.fcurrencyid, \n");
        }
        if (balanceType == 2 || balanceType == 3) {
            sql.append("  tout.fassistgrpid, \n");
        }
        if (balanceType == 3) {
            sql.append("  tout.fmeasureunitid, \n");
        }
        if (isForCurrency) {
            sql.append("  tout.fendbalancefor, tout.fendbalancefor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("  tout.fendbalancelocal, tout.fendbalancelocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  tout.fendbalancerpt, tout.fendbalancerpt, \n");
        }
        sql.append("  tout.fendqty, tout.fendqty, \n");
        if (isNextYear) {
            if (isForCurrency) {
                sql.append("  0, 0, 0, \n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("  0, 0, 0, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("  0, 0, 0, \n");
            }
            sql.append("  0, 0, 0, \n");
        } else {
            if (isForCurrency) {
                sql.append("  tout.fyeardebitfor, tout.fyearcreditfor, tout.fyearpnlfor, \n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("  tout.fyeardebitlocal, tout.fyearcreditlocal, tout.fyearpnllocal, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("  tout.fyeardebitrpt, tout.fyearcreditrpt, tout.fyearpnlrpt, \n");
            }
            sql.append("  tout.fyeardebitqty, tout.fyearcreditqty, nvl(tout.fyearpnlqty,0), \n");
        }
        sql.append("  0 \n");
        sql.append(") \n");
        if (balanceType == 2 || balanceType == 3) {
            sql.append("where ( \n");
            if (isForCurrency) {
                sql.append("  tout.fendbalancefor<>0 or \n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("  tout.fendbalancelocal<>0 or \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("  tout.fendbalancerpt<>0 or \n");
            }
            sql.append("  tout.fendqty<>0 \n");
            if (!isNextYear) {
                if (isForCurrency) {
                    sql.append("  or tout.fyeardebitfor<>0 or tout.fyearcreditfor<>0 or tout.fyearpnlfor<>0 \n");
                }
                if (isLocaCurrency || isForCurrency) {
                    sql.append("  or tout.fyeardebitlocal<>0 or tout.fyearcreditlocal<>0 or tout.fyearpnllocal<>0 \n");
                }
                if (isRptCurrency || isForCurrency) {
                    sql.append("  or tout.fyeardebitrpt<>0 or tout.fyearcreditrpt<>0 or tout.fyearpnlrpt<>0 \n");
                }
                sql.append("  or tout.fyeardebitqty<>0 or tout.fyearcreditqty<>0 or nvl(tout.fyearpnlqty,0)<>0 \n");
                sql.append("  or nvl(tout.FDetailCount,0)<>0 \n");
            }
            sql.append(") \n");
        }
        params.add(company.getId().toString());
        params.add(currPeriod.getNumber());
        if (ids != null && ids.size() > 0) {
            params.addAll(ids);
        }
        params.add(nextPeriod.getNumber());
        params.add(nextPeriod.getNumber());
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    public static void clearBeginBalance(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currPeriod, PeriodInfo nextPeriod, Set<String> ids, int balanceType, int balType, String currencyId) throws BOSException {
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        String T_GL_Balance = GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("update " + T_GL_Balance + " set \n");
        if (isForCurrency) {
            sql.append("fbeginbalancefor = 0.0, fyeardebitfor = fdebitfor, fyearcreditfor = fcreditfor, fendbalancefor = fdebitfor - fcreditfor, \n");
            sql.append("fyearpnlfor = fmonthpnlfor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("fbeginbalancelocal = 0.0, fyeardebitlocal = fdebitlocal, fyearcreditlocal = fcreditlocal, fendbalancelocal = fdebitlocal - fcreditlocal, \n");
            sql.append("fyearpnllocal = fmonthpnllocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("fbeginbalancerpt = 0.0, fyeardebitrpt = fdebitrpt, fyearcreditrpt = fcreditrpt, fendbalancerpt = fdebitrpt - fcreditrpt, \n");
            sql.append("fyearpnlrpt = fmonthpnlrpt, \n");
        }
        sql.append("fbeginqty = 0.0, fyeardebitqty = fdebitqty, fyearcreditqty = fcreditqty, fendqty = fdebitqty - fcreditqty, \n");
        sql.append("fyearpnlqty = isNull(fmonthpnlqty,0) \n");
        sql.append("where forgunitid = ? and fperiod = ? \n");
        params.add(company.getId().toString());
        params.add(nextPeriod.getNumber());
        if (ids != null && ids.size() > 0) {
            if (ids.size() == 1) {
                sql.append("  and FAccountID = ? \n");
            } else {
                sql.append("  and FAccountID in (" + GLBalanceTransfer.buildMark(ids.size()) + ") \n");
            }
            params.addAll(ids);
        }
        sql.append("  and not exists ( \n");
        sql.append("    select 1 from " + T_GL_Balance + " tout \n");
        sql.append("    where tout.FOrgUnitID = " + T_GL_Balance + ".FOrgUnitID \n");
        sql.append("      and tout.FAccountID = " + T_GL_Balance + ".FAccountID \n");
        if (isForCurrency) {
            sql.append("      and tout.FCurrencyID = " + T_GL_Balance + ".FCurrencyID \n");
        }
        if (balanceType == 2 || balanceType == 3) {
            sql.append("      and tout.FAssistGrpID = " + T_GL_Balance + ".FAssistGrpID \n");
        }
        if (balanceType == 3) {
            sql.append("      and tout.FMeasureUnitID = " + T_GL_Balance + ".FMeasureUnitID \n");
        }
        sql.append("      and tout.fperiod = ? \n");
        sql.append("  ) \n");
        params.add(currPeriod.getNumber());
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    public static void toNextYear(Context ctx, CompanyOrgUnitInfo company, PeriodInfo fromPeriod, PeriodInfo toPeriod, Set<String> ids) throws BOSException, EASBizException {
        GLBalanceTransfer.initCompany(ctx, company);
        GLBalanceTransfer.initPeriod(ctx, fromPeriod, toPeriod);
        StringBuffer sql = new StringBuffer();
        sql.append("select p.FID, p.FNumber, p.FPeriodYear, p.FPeriodNumber \n");
        sql.append("from t_bd_period p \n");
        sql.append("join t_org_company c on c.faccountperiodid = p.ftypeid \n");
        sql.append("where c.fid = ? \n");
        sql.append("  and p.fnumber >= ? and p.fnumber <= ? \n");
        sql.append("order by p.fnumber \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), fromPeriod.getNumber(), toPeriod.getNumber()});
        if (rs.size() < 2) {
            return;
        }
        ArrayList<PeriodInfo> periods = new ArrayList<PeriodInfo>(rs.size());
        try {
            while (rs.next()) {
                PeriodInfo p = new PeriodInfo();
                p.setId(BOSUuid.read((String)rs.getString("FID")));
                p.setNumber(rs.getInt("FNumber"));
                p.setPeriodYear(rs.getInt("FPeriodYear"));
                p.setPeriodNumber(rs.getInt("FPeriodNumber"));
                periods.add(p);
            }
        }
        catch (SQLException ex) {
            throw new BOSException("SQL ERROR!", (Throwable)ex);
        }
        PeriodInfo from = (PeriodInfo)periods.get(0);
        for (int i = 1; i < periods.size(); ++i) {
            PeriodInfo to = (PeriodInfo)periods.get(i);
            GLBalanceTransfer.toNextPeriod(ctx, company, from, to, ids);
            from = to;
        }
    }

    public static void initCompany(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company.getAccountTable() == null || company.getAccountTable().getId() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("accountTable.id");
            selector.add("accountTable.number");
            selector.add("accountTable.name");
            CompanyOrgUnitInfo tCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector);
            company.setAccountTable(tCompany.getAccountTable());
        }
    }

    public static void initPeriod(Context ctx, PeriodInfo period1, PeriodInfo period2) throws EASBizException, BOSException {
        if (!(period1.containsKey("number") && period2.containsKey("number") && period1.containsKey("periodYear") && period2.containsKey("periodYear") && period1.containsKey("periodNumber") && period2.containsKey("periodNumber"))) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("periodYear");
            selector.add("periodNumber");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            HashSet<String> ids = new HashSet<String>();
            ids.add(period1.getId().toString());
            ids.add(period2.getId().toString());
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            PeriodCollection periods = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
            for (int i = 0; i < periods.size(); ++i) {
                PeriodInfo p = periods.get(i);
                if (p.getId().equals((Object)period1.getId())) {
                    period1.setNumber(p.getNumber());
                    period1.setPeriodYear(p.getPeriodYear());
                    period1.setPeriodNumber(p.getPeriodNumber());
                    continue;
                }
                if (!p.getId().equals((Object)period2.getId())) continue;
                period2.setNumber(p.getNumber());
                period2.setPeriodYear(p.getPeriodYear());
                period2.setPeriodNumber(p.getPeriodNumber());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isOracle10gOver(Context ctx) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isMore10Oracle = false;
        try {
            String version;
            String bigVersion;
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            if ((2 == dbType || 8 == dbType || 7 == dbType) && (rs = (stmt = conn.prepareStatement("select top 1 version from product_component_version")).executeQuery()).next() && Integer.parseInt(bigVersion = (version = rs.getString("version")).split("\\.")[0]) >= 10) {
                isMore10Oracle = true;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
        catch (SQLException e) {
            logger.error((Object)"Query oracle version error when gl period close !", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
        return isMore10Oracle;
    }

    public static String buildMark(int count) {
        StringBuffer mark = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                mark.append("?");
                continue;
            }
            mark.append(", ?");
        }
        return mark.toString();
    }
}

