/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordFactory;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.fi.gl.app.TAccountSplitStrategyFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLCashflowRepair {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLCashflowRepair");
    private int VOUCHER_NUM = 20;
    private Context ctx;
    private String companyID;
    private int gl_078 = 0;

    public GLCashflowRepair(Context ctx, String companyID) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.companyID = companyID;
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_078"}, (String)companyID);
        this.gl_078 = glParam.getInt("GL_078");
    }

    public void repairSplitRecord(int startPeriod, int endPeriod) throws Exception {
        if (startPeriod > endPeriod) {
            return;
        }
        boolean splitByOpposite = this.gl_078 == 1;
        Set<String> ids = this.getNeedRepairVoucherIds(this.ctx, startPeriod, endPeriod, this.companyID);
        String deleteSql = "delete from t_gl_cashflowrecord where fvoucherid = ?";
        Set<Set<String>> batchs = this.splitIds(ids, this.VOUCHER_NUM);
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)this.ctx);
        ITAccountSplitStrategy defaultStrategy = TAccountSplitStrategyFactory.getSplitStrategy("default");
        ITAccountSplitStrategy plStrategy = TAccountSplitStrategyFactory.getSplitStrategy("pl");
        ITAccountSplitStrategy byOppositStrategy = TAccountSplitStrategyFactory.getSplitStrategy("byOpposite");
        for (Set<String> batch : batchs) {
            VoucherCollection allVoucherColl = iVoucher.getVoucherCollection(this.getEntityView(batch));
            for (int i = 0; i < allVoucherColl.size(); ++i) {
                VoucherInfo voucherInfo = allVoucherColl.get(i);
                if (voucherInfo.getBizStatus() == VoucherStatusEnum.TEMP || voucherInfo.getSourceType() == SourceType.ACCOUNTADJUST || SourceType.PROFIT_AND_LOSS == voucherInfo.getSourceType()) {
                    return;
                }
                CashflowFlag cfFlag = CashFlowUtils.computeCashflowFlag(voucherInfo);
                if (cfFlag == CashflowFlag.NONE || cfFlag == CashflowFlag.BOTHNONE) continue;
                CashflowSplitRecordCollection cashSplitRecords = null;
                if (splitByOpposite) {
                    cashSplitRecords = byOppositStrategy.split(this.ctx, voucherInfo, new HashMap<String, Object>());
                } else {
                    cashSplitRecords = defaultStrategy.split(this.ctx, voucherInfo, new HashMap<String, Object>());
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("cashflowSplitRecords", cashSplitRecords);
                    CashflowSplitRecordCollection plSplitRecords = plStrategy.split(this.ctx, voucherInfo, params);
                    if (cashSplitRecords.size() > 0) {
                        for (int j = 0; j < plSplitRecords.size(); ++j) {
                            CashflowSplitRecordInfo splitRecordInfo = plSplitRecords.get(i);
                            splitRecordInfo.setIsSupItem(true);
                        }
                    }
                    cashSplitRecords.addCollection(plSplitRecords);
                }
                DbUtil.execute((Context)this.ctx, (String)deleteSql, (Object[])new Object[]{voucherInfo.getId().toString()});
                if (cashSplitRecords == null || cashSplitRecords.size() <= 0) continue;
                CashflowSplitRecordFactory.getLocalInstance(this.ctx).addBatch((IObjectCollection)cashSplitRecords);
            }
        }
    }

    private Set<String> getNeedRepairVoucherIds(Context ctx, int startPeriod, int endPeriod, String companyID) throws BOSException, SQLException {
        Connection conn;
        HashSet<String> ids;
        block9: {
            ids = new HashSet<String>();
            HashSet<String> bothNotExistids = new HashSet<String>();
            String tempTable = null;
            conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                tempTable = CashFlowUtils.creatVocuherIDTable(ctx, conn, companyID, true, true, startPeriod, endPeriod, null, null);
                StringBuilder sql = new StringBuilder();
                sql.append("\tselect t1.fid\r\n");
                sql.append("  from (select v.fid\r\n");
                sql.append("\tfrom ").append(tempTable).append(" v\r\n");
                sql.append("\tleft join t_gl_cashflowrecord cf on  v.fid = cf.FVOUCHERID\r\n");
                sql.append("\twhere cf.fid is null) t1\r\n");
                sql.append("\tinner join (select v.fid\r\n");
                sql.append("\tfrom ").append(tempTable).append(" v\r\n");
                sql.append("\tleft join t_gl_cashflowsplitrecord cfs on v.fid = cfs.FVOUCHERID \r\n");
                sql.append("\twhere cfs.fid is null) t2\r\n");
                sql.append("\ton t1.fid = t2.fid\r\n");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    bothNotExistids.add(rs.getString("fid"));
                }
                sql.setLength(0);
                sql.append("SELECT v.fid fid\n").append("FROM t_gl_voucher v \n").append("inner join ").append(tempTable).append(" temp ").append(" on v.fid = temp.fid \n").append("left join t_gl_cashflowsplitrecord cfs on cfs.fvoucherid = v.fid \n").append("WHERE EXISTS ( \n").append("    SELECT 1 \n").append("    FROM t_gl_cashflowrecord cf \n").append("    WHERE cf.fvoucherid = v.fid \n").append("    GROUP BY cf.fvoucherid \n").append("    HAVING COUNT(*) = SUM(CASE WHEN cf.fitemflag = 5 THEN 1 ELSE 0 END) \n").append(")\n").append("and cfs.fid is null");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    ids.add(rs.getString("fid"));
                }
                ids.addAll(bothNotExistids);
                if (tempTable == null) break block9;
            }
            catch (Exception exception) {
                try {
                    throw new BOSException((Throwable)exception);
                }
                catch (Throwable throwable) {
                    if (tempTable != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    throw throwable;
                }
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        if (conn != null) {
            conn.close();
        }
        return ids;
    }

    protected EntityViewInfo getEntityView(Set idSet) {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(VoucherInfo.getDefaultSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return view;
    }

    protected Set<Set<String>> splitIds(Set<String> ids, int batchSize) {
        HashSet<Set<String>> batchs = new HashSet<Set<String>>();
        if (ids == null || ids.isEmpty()) {
            return batchs;
        }
        HashSet<String> idSet = new HashSet<String>();
        int num = 0;
        int index = 0;
        for (String id : ids) {
            if (index == num * batchSize) {
                idSet = new HashSet();
                ++num;
                batchs.add(idSet);
            }
            idSet.add(id);
            ++index;
        }
        return batchs;
    }
}

