/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLClosePeriodFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLBalanceFacade;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.PeriodTransFacadeFactory;
import com.kingdee.eas.fi.gl.PostVoucherCheckReturn;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.app.AbstractGLClosePeriodFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLAsstAccountChangeTransfer;
import com.kingdee.eas.fi.gl.app.GLBalanceTransfer;
import com.kingdee.eas.fi.gl.app.GLClosePeriodUtils;
import com.kingdee.eas.fi.gl.app.GLPeriodEndFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.check.CtrlType;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLClosePeriodFacadeControllerBean
extends AbstractGLClosePeriodFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLClosePeriodFacadeControllerBean");
    private static final String RESOURCE_NAME = "com.kingdee.eas.fi.gl.GLClosePeriodResource";
    public static final String MUTEX_CLOSE = "Pzx7To7SU0qxDmmWynrePBI0Vng=_";
    private boolean isAjust = false;

    private static CompanyOrgUnitInfo getCurrentCompany(Context ctx, String curCompanyID) throws BOSException, EASBizException {
        SelectorItemCollection sic = GlUtils.getCompanySic();
        return GlUtils.getCurrentCompany(ctx, curCompanyID, sic, true);
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue())));
        fic.add(new FilterItemInfo("company.id", (Object)companyId));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod.id"));
        sic.add(new SelectorItemInfo("currentPeriod.type.id"));
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        sic.add(new SelectorItemInfo("currentPeriod.isAdjustPeriod"));
        sic.add(new SelectorItemInfo("currentPeriod.number"));
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        SystemStatusCtrolCollection col = ctrl.getSystemStatusCtrolCollection(view);
        PeriodInfo prd = null;
        if (col.size() == 1) {
            prd = col.get(0).getCurrentPeriod();
        }
        if (prd == null) {
            throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
        }
        return prd;
    }

    public static boolean isExitAdjOfLastYear(Context ctx, int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        boolean isLastPeriod = false;
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.TRUE, CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            isLastPeriod = true;
        }
        return isLastPeriod;
    }

    private boolean isInitClosed(Context ctx, String companyID) throws BOSException, EASBizException {
        IGLFlag flagCtrl = GLFlagFactory.getLocalInstance(ctx);
        return flagCtrl.getGLInitClosed(companyID);
    }

    private void autoSetACParam(Context ctx, CompanyOrgUnitInfo company, boolean setflag) throws BOSException, EASBizException {
        try {
            IRowSet rs;
            if (!setflag) {
                StringBuffer sql = new StringBuffer();
                sql.append("select fid from t_gl_flag where FOrgUnitId=? and fvalue=? and fname=? ");
                sql.append(" and exists (select fid from t_bd_systemstatusctrol where fcompanyid =? and fsystemstatusid=(select fid from t_bd_systemstatus where fname=6) \r\n");
                sql.append("             and facperiodid is not null and facperiodid=fcurrentperiodid)");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), "true", "cussentinit", company.getId().toString()});
                if (rs.next()) {
                    throw new GLException(GLException.UNINIT_CUSSENT_WHEN_PERIODUNCLOSE);
                }
            }
            StringBuffer updateACParam = new StringBuffer();
            updateACParam.append("select fid from t_bas_paramitem where fkeyid =(select fid from t_bas_param where fnumber='GL_028') and forgunitid=?                                        \r\n");
            updateACParam.append(" and exists (select fid from t_bd_systemstatusctrol where fcompanyid =? and fsystemstatusid=(select fid from t_bd_systemstatus where fname=6)         \r\n");
            updateACParam.append("             and facperiodid is not null and facperiodid=fcurrentperiodid)");
            rs = DbUtil.executeQuery((Context)ctx, (String)updateACParam.toString(), (Object[])new Object[]{company.getId().toString(), company.getId().toString()});
            if (rs.next()) {
                IParamItem iParam = ParamItemFactory.getLocalInstance((Context)ctx);
                ParamItemInfo paramItem = iParam.getParamItemInfo((IObjectPK)new ObjectUuidPK(rs.getString(1)));
                paramItem.setValue(setflag ? "true" : "false");
                paramItem.setValueAlias(setflag ? "true" : "false");
                iParam.update((IObjectPK)new ObjectUuidPK(paramItem.getId()), (CoreBaseInfo)paramItem);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map<String, Object> getSystemStatusCtrol(Context ctx, String orgId) throws BOSException, EASBizException {
        String loc = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    c.FNumber FOrgNumber, c.FName_" + loc + " FOrgName, \n");
        sql.append("    c.FControlUnitID, c.FAccountTableID, \n");
        sql.append("    p.FID FPeriodID, p.FPeriodYear, p.FPeriodNumber FPeriodMonth, p.FBeginDate, p.FEndDate, \n");
        sql.append("    sc.FStartPeriodID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_BD_Period p on p.FID = sc.FCurrentPeriodID \n");
        sql.append("where c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append("    and s.FName = 6 \n");
        sql.append("    and c.FID = '" + orgId + "' \n");
        sql.append("\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next()) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("orgId", orgId);
                info.put("orgName", rowSet.getString("FOrgName"));
                info.put("orgNumber", rowSet.getString("FOrgNumber"));
                info.put("cuId", rowSet.getString("FControlUnitID"));
                info.put("accountTableId", rowSet.getString("FAccountTableID"));
                info.put("periodId", rowSet.getString("FPeriodID"));
                String periodYear = rowSet.getString("FPeriodYear");
                String periodMonth = rowSet.getString("FPeriodMonth");
                if (periodMonth != null && periodMonth.toString().length() == 1) {
                    periodMonth = "0" + periodMonth;
                }
                String periodNumber = periodYear + periodMonth;
                String periodName = periodYear + this.getLocaleString(ctx, "YEAR") + periodMonth + this.getLocaleString(ctx, "PERIOD");
                info.put("periodYear", periodYear);
                info.put("periodMonth", periodMonth);
                info.put("periodNumber", periodNumber);
                info.put("periodName", periodName);
                info.put("beginDate", rowSet.getDate("FBeginDate"));
                info.put("endDate", rowSet.getDate("FEndDate"));
                info.put("startPeriodId", rowSet.getString("FStartPeriodID"));
                return info;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected String getLocaleString(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE_NAME, (String)resName, (Locale)ctx.getLocale());
    }

    @Override
    protected Map _getData(Context ctx, Map params) throws BOSException, EASBizException {
        int length;
        String permissionName;
        BOSUuid userId;
        IPermission iPermission;
        FullOrgUnitCollection orgs;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        LinkedList data = new LinkedList();
        result.put("records", Integer.valueOf(0));
        result.put("total", Integer.valueOf(0));
        result.put("page", Integer.valueOf(0));
        result.put("rows", data);
        CompanyOrgUnitInfo org = ContextUtil.getCurrentFIUnit((Context)ctx);
        String loc = ctx.getLocale().toString();
        boolean isFssc = false;
        String fssc = (String)params.get("module");
        if (fssc != null && fssc.equals("FSSC_GL")) {
            isFssc = true;
        }
        if ((orgs = (iPermission = PermissionFactory.getLocalInstance((Context)ctx)).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId()), OrgType.Company, null, permissionName = "gl_closePeriod")) == null || orgs.size() == 0) {
            return result;
        }
        String orgIds = "";
        if (params.get("orgIds") != null) {
            orgIds = params.get("orgIds").toString();
        }
        String periodNumber = "";
        if (params.get("period") != null) {
            periodNumber = params.get("period").toString();
        }
        StringBuffer orgFilter = new StringBuffer();
        if (isFssc) {
            orgFilter.append("(");
            if (orgIds.length() > 0) {
                String[] orgStrs = orgIds.split(",");
                int length2 = orgStrs.length;
                for (int i = 0; i < length2; ++i) {
                    orgFilter.append("'" + orgStrs[i] + "',");
                }
            } else {
                length = orgs.size();
                for (int i = 0; i < length; ++i) {
                    orgFilter.append("'" + orgs.get(i).getId() + "',");
                }
            }
            orgFilter.deleteCharAt(orgFilter.length() - 1);
            orgFilter.append(")");
        } else {
            length = orgs.size();
            for (int i = 0; i < length; ++i) {
                if (!org.getId().toString().equals(orgs.get(i).getId().toString())) continue;
                orgFilter.append("('" + orgs.get(i).getId() + "')");
                break;
            }
        }
        if (orgFilter.length() <= 0) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    sc.FID, \n");
        sql.append("    c.FID FOrgID, c.FNumber FOrgNumber, c.FName_" + loc + " FOrgName, \n");
        sql.append("    p.FID FPeriodID, p.FPeriodYear, p.FPeriodNumber FPeriodMonth \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_BD_Period p on p.FID = sc.FCurrentPeriodID \n");
        sql.append("where c.FIsBizUnit = 1 and c.FIsSealup = 0 and sc.FIsStart = 1 \n");
        sql.append("    and s.FName = 6 \n");
        sql.append("    and c.FID in " + orgFilter + " \n");
        sql.append("\n");
        String companyFilter = (String)params.get("company");
        if (companyFilter != null && companyFilter.trim().length() > 0) {
            sql.append("  and (c.fnumber like '%" + companyFilter + "%' or c.FName_" + loc + " like '%" + companyFilter + "%') \n ");
        }
        if (periodNumber.length() > 0 && !periodNumber.equals("0")) {
            if (params.get("isFromGUI") != null) {
                sql.append("  and p.fnumber <= ").append(periodNumber).append(" \n ");
            } else {
                sql.append("  and p.fnumber = ").append(periodNumber).append(" \n ");
            }
        }
        if ("period".equals((String)params.get("order"))) {
            sql.append("  order by p.fnumber, c.fnumber \n ");
        } else {
            sql.append("  order by c.fnumber \n ");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String id = rowSet.getString("FID");
                String orgId = rowSet.getString("FOrgID");
                String orgName = rowSet.getString("FOrgName");
                String orgNumber = rowSet.getString("FOrgNumber");
                String periodId = rowSet.getString("FPeriodID");
                String periodMonth = rowSet.getString("FPeriodMonth");
                String periodYear = rowSet.getString("FPeriodYear");
                if (periodMonth != null && periodMonth.toString().length() == 1) {
                    periodMonth = "0" + periodMonth;
                }
                String periodName = periodYear + this.getLocaleString(ctx, "YEAR") + periodMonth + this.getLocaleString(ctx, "PERIOD");
                map.put("id", id);
                map.put("orgId", orgId);
                map.put("orgName", orgName);
                map.put("orgNumber", orgNumber);
                map.put("periodId", periodId);
                map.put("periodName", periodName);
                data.add(map);
            }
            int records = rowSet.size();
            result.put("records", Integer.valueOf(records));
            result.put("total", Integer.valueOf(1));
            result.put("page", Integer.valueOf(1));
            result.put("rows", data);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _closeCheck(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "error");
        HashSet ignores = new HashSet();
        if (params.get("ignores") instanceof List) {
            ignores.addAll((List)params.get("ignores"));
        }
        params.put("ignores", ignores);
        ArrayList<Map<String, Object>> errors = new ArrayList<Map<String, Object>>();
        result.put("errors", errors);
        String id = (String)params.get("id");
        int errorIndex = errors.size();
        String orgId = (String)params.get("orgId");
        String periodId = (String)params.get("periodId");
        String[] companyids = new String[]{orgId};
        GlUtils.updateBalance(ctx, companyids);
        if (orgId == null || periodId == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "ORG_PERIOD_CANNOT_EMPTY"));
            error.put("operation", this.getLocaleString(ctx, "PROCESS"));
            errors.add(error);
            return result;
        }
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean hasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(orgId), "gl_closePeriod");
        if (!hasPer) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLPeriodEndResource", (String)"noPerm_close", (Locale)ctx.getLocale()));
            errors.add(error);
            return result;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(ctx, orgId);
        if (sscInfo == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "GL_SYSTEM_STATUS_ERROR"));
            errors.add(error);
            return result;
        }
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", MessageFormat.format(this.getLocaleString(ctx, "CLOSE_PERIOD_ERROR"), sscInfo.get("periodName")));
            errors.add(error);
            return result;
        }
        this.checkCanClosePeriod(ctx, errors, params, sscInfo);
        if (errors.size() > 0) {
            return result;
        }
        result.put("status", "success");
        return result;
    }

    private void checkCanClosePeriod(Context ctx, List<Map<String, Object>> errors, Map condition, Map<String, Object> sscInfo) throws BOSException, EASBizException, GLPeriodEndException {
        PeriodInfo nextPeriod;
        SystemStatusCtrolCollection coll;
        HashMap<String, String> error;
        boolean notice;
        boolean plAccount;
        HashMap<String, Object> error2;
        boolean saveVoucher;
        Set ignores = (Set)condition.get("ignores");
        String id = (String)condition.get("id");
        int errorIndex = errors.size();
        String orgId = (String)condition.get("orgId");
        String periodId = (String)condition.get("periodId");
        String orgName = (String)sscInfo.get("orgName");
        String cuId = (String)sscInfo.get("cuId");
        String accountTableId = (String)sscInfo.get("accountTableId");
        String periodYear = (String)sscInfo.get("periodYear");
        String periodMonth = (String)sscInfo.get("periodMonth");
        String periodNumber = (String)sscInfo.get("periodNumber");
        java.sql.Date beginDate = (java.sql.Date)sscInfo.get("beginDate");
        java.sql.Date endDate = (java.sql.Date)sscInfo.get("endDate");
        PeriodInfo curPeriodInfo = new PeriodInfo();
        curPeriodInfo.setId(BOSUuid.read((String)periodId));
        curPeriodInfo.setPeriodYear(Integer.parseInt(periodYear));
        curPeriodInfo.setPeriodNumber(Integer.parseInt(periodMonth));
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        int periodNum = period.getNumber();
        boolean checkCussent = GlUtils.getDefaultGLParam(ctx, orgId, "GL_028");
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        ParamItemInfo paramCashflow = pc.getParamItemByNumberAndOrg("GL_070", orgId);
        boolean cashflow = false;
        boolean cashFlowIsCheck = false;
        String cashFlowMsg = null;
        if (paramCashflow == null || "false".equals(paramCashflow.getValue())) {
            cashflow = true;
            cashFlowIsCheck = true;
        } else {
            ParamItemInfo paramClose = pc.getParamItemByNumberAndOrg("GL_071", orgId);
            if ("2".equals(paramClose.getValue())) {
                cashflow = true;
                cashFlowIsCheck = true;
            } else {
                cashflow = false;
                String msg = CFRequisitionFactory.getLocalInstance(ctx).checkCanClosePeriod((IObjectPK)new ObjectUuidPK(orgId), (IObjectPK)new ObjectUuidPK(periodId), Integer.parseInt(periodNumber));
                if (msg != null) {
                    cashFlowIsCheck = false;
                    cashFlowMsg = msg;
                } else {
                    cashFlowIsCheck = true;
                }
            }
        }
        boolean isClose = GLClosePeriodUtils.checkCloseInit(ctx, orgId, cuId, accountTableId, true, true, checkCussent);
        if (!isClose) {
            HashMap<String, String> error3 = new HashMap<String, String>();
            error3.put("id", id + "_" + ++errorIndex);
            error3.put("orgName", this.getLocaleString(ctx, "GL_NOT_INIT"));
            errors.add(error3);
            return;
        }
        HashMap hmAllParam = GLClosePeriodUtils.getDefaultGLParam(ctx, orgId);
        if (!ignores.contains("ignoreSaveVoucher") && !(saveVoucher = Boolean.valueOf(hmAllParam.get("G011").toString()).booleanValue()) && (saveVoucher = GLClosePeriodUtils.checkSaveVoucher(ctx, orgId, periodId))) {
            error2 = new HashMap();
            error2.put("id", id + "_" + ++errorIndex);
            error2.put("orgName", this.getLocaleString(ctx, "EXIST_SAVE_VOUCHER"));
            error2.put("operation", this.getLocaleString(ctx, "PROCESS"));
            error2.put("operatfunction", "showTempVoucher");
            error2.put("periodId", periodId);
            error2.put("periodNumber", periodNum);
            error2.put("orgId", orgId);
            errors.add(error2);
        }
        if (!ignores.contains("ignoreUnPostVoucher")) {
            boolean unPost;
            boolean bl = unPost = !GLClosePeriodUtils.checkCanAdjRate(ctx, orgId, periodId);
            if (unPost) {
                error2 = new HashMap<String, Object>();
                error2.put("id", id + "_" + ++errorIndex);
                error2.put("orgName", this.getLocaleString(ctx, "EXIST_UNPOST_VOUCHER"));
                error2.put("operation", this.getLocaleString(ctx, "PROCESS"));
                error2.put("operatfunction", "showUnPostVoucher");
                error2.put("periodId", periodId);
                error2.put("periodNumber", periodNum);
                error2.put("orgId", orgId);
                errors.add(error2);
            }
        }
        if (!ignores.contains("ignoreBreakNumber")) {
            boolean notAllowBreakNumber;
            boolean bl = notAllowBreakNumber = Integer.parseInt(hmAllParam.get("GL_051").toString()) == 2;
            if (notAllowBreakNumber) {
                period = new PeriodInfo();
                period.setPeriodNumber(Integer.parseInt(periodMonth));
                period.setPeriodYear(Integer.parseInt(periodYear));
                period.setId(BOSUuid.read((String)periodId));
                period.setBeginDate((Date)beginDate);
                boolean existsBreakNumber = GLClosePeriodUtils.voucherNumber(ctx, orgId, period, cuId);
                if (existsBreakNumber) {
                    HashMap<String, Object> error4 = new HashMap<String, Object>();
                    error4.put("id", id + "_" + ++errorIndex);
                    error4.put("orgName", this.getLocaleString(ctx, "EXIST_BREAK_NUMBER_VOUCHER"));
                    error4.put("operation", this.getLocaleString(ctx, "PROCESS"));
                    error4.put("operatfunction", "showAllVoucher");
                    error4.put("periodId", periodId);
                    error4.put("periodNumber", periodNum);
                    error4.put("orgId", orgId);
                    errors.add(error4);
                }
            }
        }
        if (!ignores.contains("ignorePlAccount") && (plAccount = Boolean.valueOf(hmAllParam.get("GL_011").toString()).booleanValue()) && (plAccount = GLClosePeriodUtils.checkPlAccount(ctx, orgId, periodNum))) {
            HashMap<String, String> error5 = new HashMap<String, String>();
            error5.put("id", id + "_" + ++errorIndex);
            error5.put("orgName", this.getLocaleString(ctx, "EXIST_PL_ACCOUNT_BALANCE"));
            error5.put("operation", this.getLocaleString(ctx, "PROCESS"));
            error5.put("operatfunction", "showTransPL");
            error5.put("periodId", periodId);
            error5.put("orgId", orgId);
            errors.add(error5);
        }
        if (!ignores.contains("ignoreExistNotice") && !(notice = Boolean.valueOf(hmAllParam.get("GL_026").toString()).booleanValue()) && (notice = GLClosePeriodUtils.checkNotice(ctx, orgId, beginDate, endDate))) {
            HashMap<String, String> error6 = new HashMap<String, String>();
            error6.put("id", id + "_" + ++errorIndex);
            error6.put("orgName", this.getLocaleString(ctx, "EXIST_NONE_CHECKED_NOTICE"));
            errors.add(error6);
        }
        if (!(ignores.contains("ignoreCashflow") || cashflow || cashFlowIsCheck)) {
            HashMap<String, String> error7 = new HashMap<String, String>();
            error7.put("id", id + "_" + ++errorIndex);
            error7.put("orgName", this.getLocaleString(ctx, "EXIST_NONE_CHECKED_CASHFLOW"));
            error7.put("operation", this.getLocaleString(ctx, "PROCESS"));
            errors.add(error7);
        }
        if (!ignores.contains("ignoreCheckBalance")) {
            boolean fcSU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
            boolean isUserReportCurr = Boolean.valueOf(hmAllParam.get("G001").toString());
            Boolean isCheckBalance = Boolean.valueOf(hmAllParam.get("GL_103").toString());
            boolean isbalanceCorrect = false;
            if (isCheckBalance.booleanValue()) {
                isbalanceCorrect = GLPeriodEndFacadeFactory.getLocalInstance(ctx).checkBalanceCorrect(fcSU, orgId, periodId, isUserReportCurr);
            }
            if (isCheckBalance.booleanValue() && !isbalanceCorrect) {
                error = new HashMap<String, String>();
                error.put("id", id + "_" + ++errorIndex);
                error.put("orgName", this.getLocaleString(ctx, "CHECK_NOT_BALANCE"));
                errors.add(error);
            }
        }
        if (!ignores.contains("ignoreRelatedSystem") && (coll = GLClosePeriodUtils.getRelatedNotCloseSystem(ctx, orgId, curPeriodInfo, nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(periodId)))).size() > 0) {
            StringBuffer systems = new StringBuffer();
            for (int i = 0; i < coll.size(); ++i) {
                SystemStatusCtrolInfo info = coll.get(i);
                if (info.getSystemStatus() == null) continue;
                systems.append(info.getSystemStatus().getName() + ",");
            }
            if (systems.length() > 0) {
                systems.deleteCharAt(systems.length() - 1);
            }
            HashMap<String, String> error8 = new HashMap<String, String>();
            error8.put("id", id + "_" + ++errorIndex);
            error8.put("orgName", systems + this.getLocaleString(ctx, "RELATED_NOT_CLOSE"));
            errors.add(error8);
        }
        boolean closePeriodCheck = Boolean.valueOf(GlUtils.getParamByKey(ctx, orgId, "Gl_IsCheckOut Check").toString());
        if (!ignores.contains("ignoreCheckScheme") && closePeriodCheck) {
            List<String> sCheckSchemeResults;
            List<String> wCheckSchemeResults;
            if ("closeCheck".equals(condition.get("action")) && (wCheckSchemeResults = GlUtils.checkSchemeResultList(ctx, orgId, CtrlType.WeakCtrl)) != null && wCheckSchemeResults.size() > 0) {
                for (String result : wCheckSchemeResults) {
                    error = new HashMap();
                    error.put("id", id + "_" + ++errorIndex);
                    error.put("orgName", ResourceBase.getString((String)RESOURCE_NAME, (String)"wCheckScheme", (Locale)ctx.getLocale(), (Object[])new String[]{result}));
                    errors.add(error);
                }
            }
            if ((sCheckSchemeResults = GlUtils.checkSchemeResultList(ctx, orgId, CtrlType.StrongCtrl)) != null && sCheckSchemeResults.size() > 0) {
                for (String result : sCheckSchemeResults) {
                    error = new HashMap();
                    error.put("id", id + "_" + ++errorIndex);
                    error.put("orgName", ResourceBase.getString((String)RESOURCE_NAME, (String)"sCheckScheme", (Locale)ctx.getLocale(), (Object[])new String[]{result}));
                    errors.add(error);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _closePeriod(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "error");
        ArrayList errors = new ArrayList();
        result.put("errors", errors);
        String orgId = (String)params.get("orgId");
        String userId = (String)params.get("userId");
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = GLMutexUtils.buildModifyBalanceParameter(ctx, orgId, userId, "GL_Close");
        MutexParameter current = mutex.requestMutex3(mp);
        try {
            HashMap<String, Object> id;
            if (current == null) {
                params.put("result", result);
                GLClosePeriodFacadeFactory.getLocalInstance(ctx).doClosePeriod(params);
            } else {
                id = (String)params.get("id");
                int errorIndex = errors.size();
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("id", (String)((Object)id) + "_" + ++errorIndex);
                error.put("orgName", GLMutexUtils.getMutexMessage(ctx, current, mp));
                errors.add(error);
            }
            if (errors.size() > 0) {
                id = result;
                return id;
            }
            result.put("status", "success");
            id = result;
            return id;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            String id = (String)params.get("id");
            int errorIndex = errors.size();
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (current == null) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    @Override
    protected Map _doClosePeriod(Context ctx, Map params) throws BOSException, EASBizException {
        Map result = (Map)params.get("result");
        List errors = (List)result.get("errors");
        params.put("ignores", new HashSet());
        String id = (String)params.get("id");
        int errorIndex = errors.size();
        String orgId = (String)params.get("orgId");
        String periodId = (String)params.get("periodId");
        String[] companyids = new String[]{orgId};
        GlUtils.updateBalance(ctx, companyids);
        if (orgId == null || periodId == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "ORG_PERIOD_CANNOT_EMPTY"));
            error.put("operation", this.getLocaleString(ctx, "PROCESS"));
            errors.add(error);
            return result;
        }
        PeriodInfo currentPeriod = null;
        try {
            currentPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        }
        catch (Exception e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            return result;
        }
        GLPeriodEndFacadeControllerBean.checkBooksPeriod(ctx, orgId, periodId, false);
        if (currentPeriod != null && currentPeriod.isIsAdjustPeriod()) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "NONEED_UNCLOSE_MONTH"));
            errors.add(error);
            return result;
        }
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean hasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(orgId), "gl_closePeriod");
        if (!hasPer) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLPeriodEndResource", (String)"noPerm_close", (Locale)ctx.getLocale()));
            errors.add(error);
            return result;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(ctx, orgId);
        if (sscInfo == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "GL_SYSTEM_STATUS_ERROR"));
            errors.add(error);
            return result;
        }
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", MessageFormat.format(this.getLocaleString(ctx, "CLOSE_PERIOD_ERROR"), sscInfo.get("periodName")));
            errors.add(error);
            return result;
        }
        String orgName = (String)sscInfo.get("orgName");
        String cuId = (String)sscInfo.get("cuId");
        String accountTableId = (String)sscInfo.get("accountTableId");
        try {
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), GlUtils.getCompanySic());
            Map hmParamValue = InitHelp.getInitParam(ctx, companyOrgUnitInfo);
            InitHelp.checkAcctCussentInit(ctx, companyOrgUnitInfo, hmParamValue, true);
        }
        catch (EASBizException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            return result;
        }
        try {
            InitHelp.doColseInit(ctx, orgId, accountTableId);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.checkCanClosePeriod(ctx, errors, params, sscInfo);
        for (Map error : errors) {
            error.remove("orgNumber");
        }
        if (errors.size() > 0) {
            return result;
        }
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put("id", orgId);
        idMap.put("name", orgName);
        idMap.put("cuid", cuId);
        idMap.put("accounttableid", accountTableId);
        idMap.put("periodId", periodId);
        Map map = PeriodTransFacadeFactory.getLocalInstance(ctx).closePeriodSingle(idMap);
        currentPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        String periodYear = String.valueOf(currentPeriod.getPeriodYear());
        String periodMonth = String.valueOf(currentPeriod.getPeriodNumber());
        if (periodMonth != null && periodMonth.toString().length() == 1) {
            periodMonth = "0" + periodMonth;
        }
        String periodName = periodYear + this.getLocaleString(ctx, "YEAR") + periodMonth + this.getLocaleString(ctx, "PERIOD");
        result.put("periodId", currentPeriod.getId().toString());
        result.put("periodName", periodName);
        GLAsstAccountChangeTransfer.process(ctx, orgId, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _unClosePeriod(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "error");
        ArrayList errors = new ArrayList();
        result.put("errors", errors);
        String orgId = (String)params.get("orgId");
        String periodId = (String)params.get("periodId");
        String userId = (String)params.get("userId");
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        CompanyOrgUnitInfo lc = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), selector);
        SelectorItemCollection periodSelector = new SelectorItemCollection();
        periodSelector.add(new SelectorItemInfo("description"));
        PeriodInfo curPeriodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId), periodSelector);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"unClosePeriod", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(orgId), (String)(lc.getName() + " - " + curPeriodInfo.getDescription()), (String)"gl_PeriodEnd_UnClose");
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = GLMutexUtils.buildModifyBalanceParameter(ctx, orgId, userId, "GL_Unclose");
        MutexParameter current = mutex.requestMutex3(mp);
        try {
            HashMap<String, Object> id;
            if (current == null) {
                params.put("result", result);
                GLClosePeriodFacadeFactory.getLocalInstance(ctx).doUnClosePeriod(params);
            } else {
                id = (String)params.get("id");
                int errorIndex = errors.size();
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("id", (String)((Object)id) + "_" + ++errorIndex);
                error.put("orgName", GLMutexUtils.getMutexMessage(ctx, current, mp));
                errors.add(error);
            }
            if (errors.size() > 0) {
                id = result;
                return id;
            }
            result.put("status", "success");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            id = result;
            return id;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            String id = (String)params.get("id");
            int errorIndex = errors.size();
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (current == null) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    @Override
    protected Map _doUnClosePeriod(Context ctx, Map params) throws BOSException, EASBizException {
        PeriodInfo prePeriod;
        PeriodInfo acPeriod;
        AccountRefContrastInfo ojbValue;
        Iterator it;
        SystemStatusCtrolCollection col;
        Map result = (Map)params.get("result");
        List errors = (List)result.get("errors");
        params.put("ignores", new HashSet());
        String id = (String)params.get("id");
        int errorIndex = errors.size();
        String orgId = (String)params.get("orgId");
        String periodId = (String)params.get("periodId");
        if (orgId == null || periodId == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "ORG_PERIOD_CANNOT_EMPTY"));
            error.put("operation", this.getLocaleString(ctx, "PROCESS"));
            errors.add(error);
            return result;
        }
        PeriodInfo currentPeriod = null;
        try {
            currentPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        }
        catch (Exception e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            return result;
        }
        GLPeriodEndFacadeControllerBean.checkBooksPeriod(ctx, orgId, periodId, true);
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean hasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(orgId), "gl_unclosePeriod");
        if (!hasPer) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLPeriodEndResource", (String)"noPerm_unclose", (Locale)ctx.getLocale()));
            errors.add(error);
            return result;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(ctx, orgId);
        if (sscInfo == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "GL_SYSTEM_STATUS_ERROR"));
            errors.add(error);
            return result;
        }
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", MessageFormat.format(this.getLocaleString(ctx, "UNCLOSE_PERIOD_ERROR"), sscInfo.get("periodName")));
            errors.add(error);
            return result;
        }
        if (periodId.equals(sscInfo.get("startPeriodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "UNCLOSE_ON_START_PERIOD"));
            errors.add(error);
            return result;
        }
        String accountTableId = (String)sscInfo.get("accountTableId");
        PeriodInfo curPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        boolean isCanNotClosedAfterReport = GlParam.getGlParams((Context)ctx, (String)"GL_068", (String)orgId).getBoolean("GL_068");
        if (isCanNotClosedAfterReport) {
            String errInfo;
            PeriodInfo prevPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)curPeriod);
            PeriodInfo newPeriodInfo = curPeriod;
            if (prevPeriod != null && prevPeriod.isIsAdjustPeriod()) {
                newPeriodInfo = (PeriodInfo)curPeriod.clone();
                newPeriodInfo.setPeriodNumber(newPeriodInfo.getPeriodNumber() + 1);
            }
            if ((errInfo = CslRptUtil.isHasReportSubmited((Context)ctx, (PeriodInfo)newPeriodInfo, (String)orgId)) != null) {
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("id", id + "_" + ++errorIndex);
                error.put("orgName", errInfo + this.getLocaleString(ctx, "NOT_ALLOW_UNCLOSE"));
                errors.add(error);
                return result;
            }
        }
        if ((col = InitHelp.checkIsAlia(ctx, curPeriod, orgId)) != null && (it = col.iterator()).hasNext()) {
            SystemStatusCtrolInfo info = (SystemStatusCtrolInfo)it.next();
            String msg = this.getLocaleString(ctx, "Notic_RelateGeneralSystem");
            msg = MessageFormat.format(msg, info.getSystemStatus().getName().getAlias());
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", msg);
            errors.add(error);
            return result;
        }
        String acPrepPeriodid = curPeriod.getId().toString();
        if (curPeriod.isIsAdjustPeriod() && (ojbValue = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(orgId, accountTableId, periodId)) != null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", MessageFormat.format(this.getLocaleString(ctx, "NOT_ALLOW_UNCLOSE_ON_NEW_ACCOUNT"), String.valueOf(curPeriod.getNumber())));
            errors.add(error);
            return result;
        }
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select acPeriod.* where company.id='" + orgId + "' and systemStatus.name=6");
        PeriodInfo periodInfo = acPeriod = ctrols.size() > 0 && ctrols.get(0).getAcPeriod() != null ? ctrols.get(0).getAcPeriod() : null;
        if (acPeriod == null || acPrepPeriodid.equals(acPeriod.getId().toString())) {
            // empty if block
        }
        PostVoucherCheckReturn[] checkReturn = null;
        try {
            checkReturn = InitHelp.getCussentInitInPeriod(ctx, orgId);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        if (checkReturn != null && checkReturn.length > 0 && checkReturn[0].getAccountNumber() != null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", checkReturn[0].getAccountNumber() + this.getLocaleString(ctx, "EXISTS_INITCUSSENT_NOT_UNCLOSE"));
            errors.add(error);
            return result;
        }
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        boolean hasArch = GlUtils.glHasArch(ctx, company, prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(periodId)));
        if (hasArch) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "Gl_HASARCH"));
            errors.add(error);
            return result;
        }
        if (errors.size() > 0) {
            return result;
        }
        this.doUnClosePeriod2(ctx, params, result);
        if (errors.size() > 0) {
            return result;
        }
        currentPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        String periodYear = String.valueOf(currentPeriod.getPeriodYear());
        String periodMonth = String.valueOf(currentPeriod.getPeriodNumber());
        if (periodMonth != null && periodMonth.toString().length() == 1) {
            periodMonth = "0" + periodMonth;
        }
        String periodName = periodYear + this.getLocaleString(ctx, "YEAR") + periodMonth + this.getLocaleString(ctx, "PERIOD");
        result.put("periodId", currentPeriod.getId().toString());
        result.put("periodName", periodName);
        return result;
    }

    protected void doUnClosePeriod2(Context ctx, Map params, Map<String, Object> result) throws BOSException, EASBizException {
        String curCompanyID = (String)params.get("orgId");
        CompanyOrgUnitInfo company = GLClosePeriodFacadeControllerBean.getCurrentCompany(ctx, curCompanyID);
        PeriodInfo[] aryPrd = GlUtils.getStartCurrentPeriod(ctx, curCompanyID);
        PeriodInfo period = aryPrd[1];
        String curPeriodID = period.getId().toString();
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
        if (!this.isInitClosed(ctx, curCompanyID)) {
            throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
        }
        GLPeriodEndFacadeControllerBean.checkBooksPeriod(ctx, curCompanyID, curPeriodID, true);
        if (prePeriod.isIsAdjustPeriod()) {
            String clssql = "update t_GL_Voucher set FIsClose=0 where FCompanyID = ? and FPeriodID = ? and FIsClose=1 ";
            DbUtil.execute((Context)ctx, (String)clssql, (Object[])new Object[]{curCompanyID, prePeriod.getId().toString()});
        }
        IGLBalanceFacade updateBalance = GLBalanceFacadeFactory.getLocalInstance(ctx);
        updateBalance.antiTransBalanceToPrevPeriod(curCompanyID, curPeriodID);
        this.autoSetACParam(ctx, company, false);
        ISystemStatusCtrol sysStatus = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        sysStatus.prePeriod(SystemEnum.GENERALLEDGER, (OrgUnitInfo)company);
        PeriodInfo[] aryPrd2 = GlUtils.getStartCurrentPeriod(ctx, curCompanyID);
        PeriodInfo period2 = aryPrd2[1];
        if (!prePeriod.getId().equals((Object)period2.getId())) {
            throw new GLPeriodEndException(GLPeriodEndException.HASUNCLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _closeYear(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "error");
        ArrayList errors = new ArrayList();
        result.put("errors", errors);
        String orgId = (String)params.get("orgId");
        String userId = (String)params.get("userId");
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        CompanyOrgUnitInfo lc = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), selector);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"closeYear", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(orgId), (String)lc.getName(), (String)"gl_PeriodTrans_ClosePeriod");
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = GLMutexUtils.buildModifyBalanceParameter(ctx, orgId, userId, "GL_CloseYear");
        MutexParameter current = mutex.requestMutex3(mp);
        try {
            HashMap<String, Object> id;
            if (current == null) {
                params.put("result", result);
                GLClosePeriodFacadeFactory.getLocalInstance(ctx).doCloseYear(params);
            } else {
                id = (String)params.get("id");
                int errorIndex = errors.size();
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("id", (String)((Object)id) + "_" + ++errorIndex);
                error.put("orgName", GLMutexUtils.getMutexMessage(ctx, current, mp));
                errors.add(error);
            }
            if (errors.size() > 0) {
                id = result;
                return id;
            }
            result.put("status", "success");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            id = result;
            return id;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            String id = (String)params.get("id");
            int errorIndex = errors.size();
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (current == null) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    @Override
    protected Map _doCloseYear(Context ctx, Map params) throws BOSException, EASBizException {
        Map result = (Map)params.get("result");
        List errors = (List)result.get("errors");
        params.put("ignores", new HashSet());
        String id = (String)params.get("id");
        int errorIndex = errors.size();
        String orgId = (String)params.get("orgId");
        String periodId = (String)params.get("periodId");
        if (orgId == null || periodId == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "ORG_PERIOD_CANNOT_EMPTY"));
            errors.add(error);
            return result;
        }
        PeriodInfo currentPeriod = null;
        try {
            currentPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        }
        catch (Exception e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            return result;
        }
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean hasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(orgId), "gl_closeYear");
        if (!hasPer) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLPeriodEndResource", (String)"noPerm_closeyear", (Locale)ctx.getLocale()));
            errors.add(error);
            return result;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(ctx, orgId);
        if (sscInfo == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "GL_SYSTEM_STATUS_ERROR"));
            errors.add(error);
            return result;
        }
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", MessageFormat.format(this.getLocaleString(ctx, "CLOSE_YEAR_ERROR"), sscInfo.get("periodName")));
            errors.add(error);
            return result;
        }
        if (errors.size() > 0) {
            return result;
        }
        this.doCloseYear2(ctx, params, result);
        if (errors.size() > 0) {
            return result;
        }
        currentPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        String periodYear = String.valueOf(currentPeriod.getPeriodYear());
        String periodMonth = String.valueOf(currentPeriod.getPeriodNumber());
        if (periodMonth != null && periodMonth.toString().length() == 1) {
            periodMonth = "0" + periodMonth;
        }
        String periodName = periodYear + this.getLocaleString(ctx, "YEAR") + periodMonth + this.getLocaleString(ctx, "PERIOD");
        result.put("periodId", currentPeriod.getId().toString());
        result.put("periodName", periodName);
        result.put("status", "success");
        return result;
    }

    protected void doCloseYear2(Context ctx, Map params, Map<String, Object> result) throws BOSException, EASBizException {
        List errors = (List)result.get("errors");
        String id = (String)params.get("id");
        int errorIndex = errors.size();
        String orgId = (String)params.get("orgId");
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, orgId, GlUtils.getCompanySic(), true);
        PeriodInfo curPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        boolean isExt = GLClosePeriodFacadeControllerBean.isExitAdjOfLastYear(ctx, curPeriod.getPeriodYear(), curPeriod.getPeriodNumber(), company);
        if (!isExt && !curPeriod.isIsAdjustPeriod()) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "NONEED_CLOSE_YEAR"));
            errors.add(error);
            return;
        }
        PeriodInfo period = PeriodUtils.getPreAdjPeriodInfo((Context)ctx, (PeriodInfo)curPeriod);
        String periodID = null;
        int periodNumber = 0;
        PeriodInfo fromPeriod = null;
        if (curPeriod.isIsAdjustPeriod()) {
            periodID = curPeriod.getId().toString();
            periodNumber = curPeriod.getNumber();
            fromPeriod = curPeriod;
            this.isAjust = true;
        } else {
            String periodSql = "select p.fid, p.FNumber from t_bd_period p , t_org_company com where com.fid = ? and p.FTypeID = com.FAccountPeriodID and p.fperiodyear=?  order by p.fnumber desc";
            try {
                IRowSet periodRS = DbUtil.executeQuery((Context)ctx, (String)periodSql, (Object[])new Object[]{company.getId().toString(), curPeriod.getPeriodYear() - 1});
                if (periodRS.next()) {
                    periodID = periodRS.getString("FID");
                    periodNumber = periodRS.getInt("FNumber");
                    fromPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodID));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (StringUtil.isEmptyString((String)periodID)) {
            return;
        }
        if (periodID == null) {
            return;
        }
        if (period == null) {
            period = curPeriod;
        }
        this.checkCanCloseYear(ctx, periodID, periodNumber, period, company, params, result);
        if (errors.size() > 0) {
            return;
        }
        if (curPeriod.isIsAdjustPeriod()) {
            IGLPeriodEndFacade periodEndCtrl = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
            periodEndCtrl.closePeriod(company.getId().toString(), true);
        } else {
            HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
            hmParamIn.put("GL_Close_SplitAccount", null);
            HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
            boolean splitAccount = false;
            Object pv = hmAllParam.get("GL_Close_SplitAccount");
            if (pv != null && "true".equals(pv.toString())) {
                splitAccount = true;
            }
            if (splitAccount) {
                GLBalanceTransfer.toNextYear(ctx, company, fromPeriod, curPeriod, null);
            } else {
                IGLBalanceFacade updateBalance = GLBalanceFacadeFactory.getLocalInstance(ctx);
                updateBalance.transBalanceToNextYear(company.getId().toString(), periodID, curPeriod.getId().toString(), null);
            }
            if (!curPeriod.isIsAdjustPeriod() && fromPeriod != null && fromPeriod.isIsAdjustPeriod()) {
                String sql = "update t_GL_Voucher set FIsClose=1 where FCompanyID = ? and FPeriodID = ? and FIsClose=0 ";
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), periodID});
            }
        }
    }

    private void checkCanCloseYear(Context ctx, String periodid, int periodNumber, PeriodInfo curPeriod, CompanyOrgUnitInfo company, Map params, Map<String, Object> result) throws BOSException, EASBizException {
        boolean plAccount;
        List errors = (List)result.get("errors");
        String id = (String)params.get("id");
        int errorIndex = errors.size();
        StringBuffer sql = new StringBuffer();
        sql.append("Select 1 where exists (Select * From t_GL_Voucher                                       \r\n");
        sql.append("Where FCompanyID = ?\t                                                             \r\n");
        sql.append("\tand FPeriodID = ?                                                                \r\n");
        sql.append("\tand FBizStatus <> 5   and FBizStatus <> 2  and   FBizStatus <>0    and FIsClose=0           \r\n");
        sql.append(")                                               \t\t\t\t\t\t\r\n");
        sql.append("; \r\n");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), curPeriod.getId().toString()});
        try {
            if (set != null && set.next()) {
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("id", id + "_" + ++errorIndex);
                error.put("orgName", this.getLocaleString(ctx, "EXIST_UNPOST_VOUCHER_ADJUST"));
                errors.add(error);
                return;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap hmAllParam = GlUtils.getDefaultGLParam(ctx, company.getId().toString());
        boolean notYearClose = Boolean.valueOf(hmAllParam.get("GL_080").toString());
        Object pa = hmAllParam.get("GL_010");
        sql = new StringBuffer();
        String acctID = "";
        if (!notYearClose && pa != null && pa.toString().length() > 0) {
            boolean useRpt = Boolean.valueOf(hmAllParam.get("G001").toString());
            acctID = pa.toString();
            sql.append(" select 1 where exists ( \r\n");
            sql.append(" select * from " + GLBalanceUtils.getAccountBalanceTable(5) + "  \r\n ");
            sql.append(" where FOrgUnitID = ?  and FPeriod = ? and FAccountID = ? \r\n");
            sql.append(" and (FEndBalanceFor <> 0 or FEndBalanceLocal <> 0");
            if (useRpt) {
                sql.append(" or FEndBalanceRpt <> 0");
            }
            sql.append(") \r\n ) ");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), periodNumber, acctID});
                if (rs != null && rs.next()) {
                    HashMap<String, String> error = new HashMap<String, String>();
                    error.put("id", id + "_" + ++errorIndex);
                    error.put("orgName", this.getLocaleString(ctx, "NOT_ALLOW_CLOSE_YEAR_ON_BALANCE_NOT_ZERO"));
                    errors.add(error);
                    return;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (this.isAjust || curPeriod != null) {
            // empty if block
        }
        if ((plAccount = Boolean.valueOf(hmAllParam.get("GL_011").toString()).booleanValue()) && (plAccount = GLClosePeriodUtils.checkPlAccount(ctx, company.getId().toString(), periodNumber))) {
            throw new GLPeriodEndException(GLPeriodEndException.CLOSE_PNLBAL_NOT_ZERO);
        }
        this.isAjust = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _unCloseYear(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "error");
        ArrayList errors = new ArrayList();
        result.put("errors", errors);
        String orgId = (String)params.get("orgId");
        String userId = (String)params.get("userId");
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        CompanyOrgUnitInfo lc = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), selector);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"unCloseYear", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(orgId), (String)lc.getName(), (String)"gl_PeriodTrans_unClosePeriod");
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = GLMutexUtils.buildModifyBalanceParameter(ctx, orgId, userId, "GL_UncloseYear");
        MutexParameter current = mutex.requestMutex3(mp);
        try {
            HashMap<String, Object> id;
            if (current == null) {
                params.put("result", result);
                GLClosePeriodFacadeFactory.getLocalInstance(ctx).doUnCloseYear(params);
            } else {
                id = (String)params.get("id");
                int errorIndex = errors.size();
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("id", (String)((Object)id) + "_" + ++errorIndex);
                error.put("orgName", GLMutexUtils.getMutexMessage(ctx, current, mp));
                errors.add(error);
            }
            if (errors.size() > 0) {
                id = result;
                return id;
            }
            result.put("status", "success");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            id = result;
            return id;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            String id = (String)params.get("id");
            int errorIndex = errors.size();
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (current == null) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    @Override
    protected Map _doUnCloseYear(Context ctx, Map params) throws BOSException, EASBizException {
        Map result = (Map)params.get("result");
        List errors = (List)result.get("errors");
        params.put("ignores", new HashSet());
        String id = (String)params.get("id");
        int errorIndex = errors.size();
        String orgId = (String)params.get("orgId");
        String periodId = (String)params.get("periodId");
        if (orgId == null || periodId == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "ORG_PERIOD_CANNOT_EMPTY"));
            errors.add(error);
            return result;
        }
        PeriodInfo currentPeriod = null;
        try {
            currentPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        }
        catch (Exception e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", e.getMessage());
            errors.add(error);
            return result;
        }
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean hasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(orgId), "gl_uncloseYear");
        if (!hasPer) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLPeriodEndResource", (String)"noPerm_uncloseyear", (Locale)ctx.getLocale()));
            errors.add(error);
            return result;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(ctx, orgId);
        if (sscInfo == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "GL_SYSTEM_STATUS_ERROR"));
            errors.add(error);
            return result;
        }
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", MessageFormat.format(this.getLocaleString(ctx, "UNCLOSE_YEAR_ERROR"), sscInfo.get("periodName")));
            errors.add(error);
            return result;
        }
        PeriodInfo curPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        boolean isCanNotClosedAfterReport = GlParam.getGlParams((Context)ctx, (String)"GL_068", (String)orgId).getBoolean("GL_068");
        if (isCanNotClosedAfterReport) {
            PeriodInfo prevAdjustPeriod = PeriodUtils.getPreAdjPeriodInfo((Context)ctx, (PeriodInfo)curPeriod);
            PeriodInfo newPeriodInfo = (PeriodInfo)curPeriod.clone();
            if (prevAdjustPeriod == null) {
                newPeriodInfo.setPeriodNumber(1);
            } else {
                newPeriodInfo = (PeriodInfo)prevAdjustPeriod.clone();
                newPeriodInfo.setPeriodNumber(newPeriodInfo.getPeriodNumber() + 1);
            }
            String errInfo = CslRptUtil.isHasReportSubmited((Context)ctx, (PeriodInfo)newPeriodInfo, (String)orgId);
            if (errInfo != null) {
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("id", id + "_" + ++errorIndex);
                error.put("orgName", errInfo + this.getLocaleString(ctx, "NOT_ALLOW_UNCLOSE_YEAR"));
                errors.add(error);
                return result;
            }
        }
        if (errors.size() > 0) {
            return result;
        }
        this.doUnCloseYear2(ctx, params, result);
        if (errors.size() > 0) {
            return result;
        }
        currentPeriod = GLClosePeriodFacadeControllerBean.getCurrentPeriod(ctx, orgId);
        String periodYear = String.valueOf(currentPeriod.getPeriodYear());
        String periodMonth = String.valueOf(currentPeriod.getPeriodNumber());
        if (periodMonth != null && periodMonth.toString().length() == 1) {
            periodMonth = "0" + periodMonth;
        }
        String periodName = periodYear + this.getLocaleString(ctx, "YEAR") + periodMonth + this.getLocaleString(ctx, "PERIOD");
        result.put("periodId", currentPeriod.getId().toString());
        result.put("periodName", periodName);
        return result;
    }

    protected void doUnCloseYear2(Context ctx, Map params, Map<String, Object> result) throws BOSException, EASBizException {
        List errors = (List)result.get("errors");
        String id = (String)params.get("id");
        int errorIndex = errors.size();
        String orgId = (String)params.get("orgId");
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, orgId, GlUtils.getCompanySic(), true);
        PeriodInfo[] aryPrd = GlUtils.getStartCurrentPeriod(ctx, orgId);
        boolean isExt = GLClosePeriodFacadeControllerBean.isExitAdjOfLastYear(ctx, aryPrd[1].getPeriodYear(), aryPrd[1].getPeriodNumber(), company);
        if (!isExt) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "NONEED_UNCLOSE_YEAR"));
            errors.add(error);
            return;
        }
        PeriodInfo period = PeriodUtils.getPreAdjPeriodInfo((Context)ctx, (PeriodInfo)aryPrd[1]);
        if (period == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", this.getLocaleString(ctx, "NONEED_UNCLOSE_YEAR"));
            errors.add(error);
        } else {
            this.checkCanUnCloseYear(ctx, period, company, params, result);
        }
        if (errors.size() > 0) {
            return;
        }
        HashMap hmAllParam = GlUtils.getDefaultGLParam(ctx, orgId);
        boolean useReport = Boolean.valueOf(hmAllParam.get("G001").toString());
        String sql = " and vch.FCompanyID = ? and vch.FPeriodID = ? and vch.FIsClose=1 ";
        if (period.isIsAdjustPeriod()) {
            sql = "update t_GL_Voucher set FIsClose=0 where FCompanyID = ? and FPeriodID = ? and FIsClose=1 ";
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, period.getId().toString()});
        }
    }

    private void checkCanUnCloseYear(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, Map params, Map<String, Object> result) throws BOSException, EASBizException {
        List errors = (List)result.get("errors");
        String id = (String)params.get("id");
        int errorIndex = errors.size();
        StringBuffer sql = new StringBuffer();
        sql.append("Select 1 where exists (Select * From t_GL_Voucher                                       \r\n");
        sql.append("Where FCompanyID = ?\t                                                             \r\n");
        sql.append("\tand FPeriodID = ?                                                                \r\n");
        sql.append("\tand FIsClose=1           \r\n");
        sql.append(")                                               \t\t\t\t\t\t\r\n");
        sql.append("; \r\n");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString(), period.getId().toString()});
        try {
            if (set == null || !set.next()) {
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("id", id + "_" + ++errorIndex);
                error.put("orgName", this.getLocaleString(ctx, "NONEED_UNCLOSE_YEAR"));
                errors.add(error);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

