/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IBizParamItemDeal;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLParamCopy
implements IBizParamItemDeal {
    Logger logger = Logger.getLogger((String)GLParamCopy.class.getName());

    public void copyParam(Context ctx, IObjectValue originalOrgUnit, IObjectCollection destinationOrgUnit) throws EASBizException, BOSException {
        HashSet<String> paramNumbers = new HashSet<String>();
        paramNumbers.add("GL_010");
        Set<String> paramIds = this.getDealParamIds(ctx, paramNumbers);
        paramIds = this.getCanDealParamIds(ctx, paramIds, originalOrgUnit);
        Set<String> destOrgUnitIdSet = this.getDestOrgUnitIds(destinationOrgUnit);
        ParamItemCollection paramItemCollection = this.getDealParamItemCol(ctx, paramIds, destOrgUnitIdSet);
        this.dealGLParams(ctx, paramItemCollection);
    }

    private void dealGLParams(Context ctx, ParamItemCollection paramItemCollection) {
        if (paramItemCollection != null && paramItemCollection.size() > 0) {
            for (int i = 0; i < paramItemCollection.size(); ++i) {
                ParamItemInfo paramItemInfo = paramItemCollection.get(i);
                if (!"GL_010".equals(paramItemInfo.getKeyID().getNumber())) continue;
                this.deal_GL_010(ctx, paramItemInfo);
            }
        }
    }

    private void deal_GL_010(Context ctx, ParamItemInfo paramItemInfo) {
        String paramValue = paramItemInfo.getValue();
        try {
            String newParamValue = null;
            if (!StringUtils.isEmpty((String)paramValue)) {
                AccountViewInfo srcAccountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(paramValue));
                String accountNumber = srcAccountViewInfo.getNumber();
                String orgUnitId = paramItemInfo.getOrgUnitID().getId().toString();
                if (!StringUtils.isEmpty((String)orgUnitId)) {
                    CompanyOrgUnitInfo companyOrgInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
                    StringBuilder sb = new StringBuilder();
                    sb.append("select id where number = '").append(accountNumber).append("' and companyID.id ='").append(paramItemInfo.getOrgUnitID().getId().toString());
                    sb.append("' ").append("and accountTableID.id='").append(companyOrgInfo.getAccountTable().getId().toString()).append("'");
                    AccountViewInfo destAccountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo(sb.toString());
                    if (destAccountViewInfo != null) {
                        newParamValue = destAccountViewInfo.getId().toString();
                    }
                }
            }
            paramItemInfo.setValue(newParamValue);
            ParamItemFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(paramItemInfo.getId().toString()), (CoreBaseInfo)paramItemInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)"Update paramItem error.", (Throwable)e);
        }
    }

    private Set<String> getCanDealParamIds(Context ctx, Set<String> paramIds, IObjectValue originalOrgUnit) throws BOSException {
        HashSet<String> orgIdSet = new HashSet<String>();
        orgIdSet.add(((FullOrgUnitInfo)originalOrgUnit).getId().toString());
        HashSet<String> canDealParamIds = new HashSet<String>();
        ParamItemCollection dealParamItemCol = this.getDealParamItemCol(ctx, paramIds, orgIdSet);
        for (int i = 0; i < dealParamItemCol.size(); ++i) {
            String canDealParamId = dealParamItemCol.get(i).getKeyID().getId().toString();
            canDealParamIds.add(canDealParamId);
        }
        return canDealParamIds;
    }

    private ParamItemCollection getDealParamItemCol(Context ctx, Set<String> paramIds, Set<String> orgUnitIdSet) throws BOSException {
        if (paramIds == null || paramIds.size() <= 0) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("keyID.number"));
        viewInfo.setSelector(selectors);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", orgUnitIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("keyID", paramIds, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(viewInfo);
        return paramItemCollection;
    }

    private Set<String> getDestOrgUnitIds(IObjectCollection destinationOrgUnit) {
        Iterator destOrgUnit = destinationOrgUnit.iterator();
        HashSet<String> orgUnitIdSet = new HashSet<String>();
        while (destOrgUnit.hasNext()) {
            FullOrgUnitInfo tempDestOrgUnit = (FullOrgUnitInfo)destOrgUnit.next();
            orgUnitIdSet.add(tempDestOrgUnit.getId().toString());
        }
        return orgUnitIdSet;
    }

    private Set<String> getDealParamIds(Context ctx, Set<String> paramNumbers) throws BOSException {
        EntityViewInfo paramViewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        paramViewInfo.setSelector(selectors);
        FilterInfo paramFilter = new FilterInfo();
        paramFilter.getFilterItems().add(new FilterItemInfo("number", paramNumbers, CompareType.INCLUDE));
        paramViewInfo.setFilter(paramFilter);
        ParamCollection paramCollection = ParamFactory.getLocalInstance((Context)ctx).getParamCollection(paramViewInfo);
        if (paramCollection == null || paramCollection.size() <= 0) {
            return null;
        }
        HashSet<String> paramIdSet = new HashSet<String>();
        for (int i = 0; i < paramCollection.size(); ++i) {
            paramIdSet.add(paramCollection.get(i).getId().toString());
        }
        return paramIdSet;
    }
}

