/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgCollection;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgInfo;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceRepairFacadeFactory;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.IPeriodTransFacade;
import com.kingdee.eas.fi.gl.PeriodTransFacadeFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.Locale;

public class GLPeriodEndJobHandler
implements IJobHandler {
    private static final long serialVersionUID = -1895675077401083127L;
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLPeriodEndResource";
    private PerfSepCfgInfo info = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Job job) throws Exception {
        try {
            UserInfo user;
            Context ctx = job.getContext();
            String userId = null;
            Object params = job.getParameters();
            CompanyOrgUnitInfo company = null;
            Boolean enter = Boolean.TRUE;
            Boolean post = Boolean.TRUE;
            String type = "1";
            Locale locale = null;
            PeriodInfo curPeriod = null;
            this.info = this.getPerfSepCfgInfo(ctx);
            if (params != null && params instanceof Object[]) {
                Object[] parObjs = (Object[])params;
                company = (CompanyOrgUnitInfo)parObjs[0];
                enter = (Boolean)parObjs[1];
                post = (Boolean)parObjs[2];
                type = (String)parObjs[3];
                locale = (Locale)parObjs[4];
                user = (UserInfo)parObjs[5];
                curPeriod = (PeriodInfo)parObjs[6];
                if (user != null && user.getNumber() != null) {
                    user = UserInfoUtils.getUserInfo4LoinModule((Context)ctx, (String)user.getNumber());
                }
            } else {
                PerfSepServerUtils.updateTaskState((Job)job);
                Boolean parObjs = new Boolean(false);
                return parObjs;
            }
            ctx.put((Object)"UserInfo", (Object)user);
            userId = user.getId().toString();
            ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)company);
            String flag = EASCommonResource.getString((String)RESOURCE_PATH, (String)"GLPeriodEnd", (Locale)locale);
            MessageInfo msgInfo = new MessageInfo();
            this.setMsgInfo(msgInfo, userId, company, flag, true, locale);
            if (this.info != null) {
                msgInfo.setSendMsg(this.info.isIsSendMsg());
            }
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            MutexParameter mp = null;
            if (company != null && userId != null) {
                MutexParameter current;
                String actionDetail = null;
                if (curPeriod != null) {
                    if (curPeriod.getNumber() != 0) {
                        actionDetail = String.valueOf(curPeriod.getNumber());
                    } else if (curPeriod.getPeriodYear() != 0 && curPeriod.getPeriodNumber() != 0) {
                        actionDetail = String.valueOf(curPeriod.getPeriodYear() * 100 + curPeriod.getPeriodNumber());
                    }
                }
                if (type.equals("1")) {
                    mp = GLMutexUtils.buildModifyBalanceParameter(ctx, company.getId().toString(), userId, "GL_Close", actionDetail);
                } else if (type.equals("2") || type.equals("3")) {
                    mp = GLMutexUtils.buildModifyBalanceParameter(ctx, company.getId().toString(), userId, "GL_CloseYear", actionDetail);
                }
                if (mp != null && (current = mutex.requestMutex3(mp)) != null) {
                    EASBizException e = new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
                    msgInfo.setSuccessed(false);
                    msgInfo.setExecption(e.getMessage());
                    if (this.info != null && this.info.isIsSendMsg()) {
                        MessageUtil.sendMsg((Context)ctx, (MessageInfo)msgInfo);
                    }
                    throw e;
                }
            }
            try {
                if (type.equals("1") || type.equals("3")) {
                    HashMap<String, String> in = new HashMap<String, String>();
                    in.put("GL_103", company.getId().toString());
                    in.put("GL_BalRep_Close", company.getId().toString());
                    HashMap out = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(in);
                    boolean isCheckBalance = false;
                    Object value = out.get("GL_103");
                    if (value != null) {
                        isCheckBalance = Boolean.valueOf(value.toString());
                    }
                    if (!isCheckBalance) {
                        boolean balRep = true;
                        value = out.get("GL_BalRep_Close");
                        if (value != null && "false".equals(value.toString())) {
                            balRep = false;
                        }
                        if (balRep) {
                            GLBalanceRepairFacadeFactory.getLocalInstance(ctx).repairCompany(company.getId().toString(), false, false);
                        }
                    }
                    IGLPeriodEndFacade periodEndCtrl = GLPeriodEndFacadeFactory.getLocalInstance(job.getContext());
                    periodEndCtrl.closePeriod(company.getId().toString(), enter);
                }
                if (type.equals("2")) {
                    IPeriodTransFacade transInterface = PeriodTransFacadeFactory.getLocalInstance(job.getContext());
                    transInterface.closePeriod(company.getId().toString(), post);
                }
                PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)curPeriod);
                if (!enter.booleanValue()) {
                    nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod);
                }
                PeriodInfo newCurPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
                if (type.equals("1") || type.equals("3") ? !newCurPeriod.getId().toString().equals(nextPeriod.getId().toString()) : curPeriod.isIsAdjustPeriod() && newCurPeriod.getPeriodYear() != nextPeriod.getPeriodYear()) {
                    throw new GLPeriodEndException(GLPeriodEndException.HASCLOSED);
                }
                JobLog log = new JobLog(JobLog.Type.Info, flag + "Success");
                job.saveMessage(log);
                msgInfo.setSuccessed(true);
                if (this.info != null && this.info.isIsSendMsg()) {
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)msgInfo);
                }
            }
            catch (EASBizException e) {
                msgInfo.setSuccessed(false);
                msgInfo.setExecption(e.getMessage());
                if (this.info != null && this.info.isIsSendMsg()) {
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)msgInfo);
                }
                throw e;
            }
            catch (BOSException be) {
                msgInfo.setSuccessed(false);
                msgInfo.setExecption(be.getMessage());
                if (this.info != null && this.info.isIsSendMsg()) {
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)msgInfo);
                }
                throw be;
            }
            finally {
                if (mp != null) {
                    mutex.releaseMutex(mp.getRequestId());
                }
            }
        }
        finally {
            PerfSepServerUtils.updateTaskState((Job)job);
        }
        return new Boolean(true);
    }

    private void setMsgInfo(MessageInfo msgInfo, String userId, CompanyOrgUnitInfo company, String flag, boolean issuccessed, Locale locale) {
        msgInfo.setbizAction(flag);
        msgInfo.setOrgNumber(company.getName(locale) + "  (" + company.getNumber() + ")");
        msgInfo.setUserID(userId);
        msgInfo.setExecption("");
        msgInfo.setSuccessed(issuccessed);
    }

    private PerfSepCfgInfo getPerfSepCfgInfo(Context ctx) throws BOSException {
        PerfSepCfgInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"FI_GL_001"));
        view.setFilter(filter);
        PerfSepCfgCollection col = PerfSepCfgFactory.getLocalInstance((Context)ctx).getPerfSepCfgCollection(view);
        info = col.get(0);
        return info;
    }
}

