/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLReportGeneralStratBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionBalanceListNew;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportConditionJournal;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedger;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportControllerBean;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class GLReportControllerBean
extends AbstractGLReportControllerBean {
    protected static final BigDecimal ZERO = new BigDecimal("0.00");
    protected static final String SQL_PARAMETERS = "SQL_PARAMETERS";
    protected static final String SQL_FOR_DATA_FORM_AND_WHERE = "SQL_FOR_DATA_FORM_AND_WHERE";
    ReportConditionBase reportcondition = null;
    boolean assiFalg = false;
    Map stratMap = null;
    ArrayList balacelist = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReportResultInfo _findData(Context ctx, EntityViewInfo condition, int start, int count, String tempTableName, CompanyOrgUnitInfo company, boolean allExpand) throws BOSException, EASBizException {
        GLResUtil.setLocale(ctx);
        company = GlUtils.getCurrentCompany(ctx, company.getId().toString(), GlUtils.getCompanySic(), false);
        if (GlUtils.isCompanyUnion(company) && !this.isSupportVirtual()) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        LowTimer t = new LowTimer();
        t.reset();
        ReportPartner partner = this.getReportPartner(ctx);
        partner.setCondition(condition);
        partner.setStartIndex(start);
        partner.setLineCount(count);
        partner.setTempTableName(tempTableName);
        partner.setCompany(company);
        ReportConditionBase cond = partner.getFixCondition();
        Object accountTableId = cond.getExpandInfo().get("accountTableId");
        if (accountTableId != null && !StringUtils.isEmpty((String)((String)accountTableId))) {
            partner.setAccountTableId((String)accountTableId);
        }
        Connection con = null;
        ReportResultInfo result = new ReportResultInfo();
        try {
            con = this.getConnection(ctx);
            if (con == null) {
                throw new ReportException(ReportException.GET_CONNECTION_FAILURE);
            }
            partner.setConnection(con);
            if (partner.getFixCondition() instanceof ReportConditionSubsidiaryLedger) {
                if (this.reportcondition == null) {
                    this.reportcondition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
                }
                if (((ReportConditionSubsidiaryLedger)this.reportcondition).getExpandInfo().get("isForTaoda") != null && (((ReportConditionSubsidiaryLedger)this.reportcondition).getOptionOnlyAsst() || ((ReportConditionSubsidiaryLedger)this.reportcondition).getAssisthgId() != null)) {
                    int isleaf = partner.getAccountViewInfo().isIsLeaf() ? 1 : 0;
                    result.setIsLeaf(isleaf);
                    result.setDc(partner.getAccountViewInfo().getDC());
                    result.setParmBalanceDirSamAsAccount(partner.isParmBalanceDirSamAsAccount());
                    this.assiFalg = true;
                } else {
                    this.assiFalg = false;
                }
            }
            this.doSomethingBeforeQuery(partner);
            if (partner.isNewQuery()) {
                this.doSomethingBeforeInsertData(partner);
                this.insertDataIntoTempTable(partner);
                if (this.assiFalg) {
                    this.stratMap = GLReportGeneralStratBalanceFacadeFactory.getLocalInstance(ctx).getStartHeBalance(partner);
                }
                this.doSomethingAfterInsertData(partner);
            }
            this.doSomethingBeforeExecuteSql(partner);
            if (start == -1 && count == -1) {
                Collection cc = this.executeSqlForAllData(partner, allExpand);
                result.getData().addAll(cc);
                result.setRowCount(1);
            } else {
                if (partner.isNewQuery()) {
                    result.setRowCount(this.getTotel(partner));
                    partner.setLineCount(this.useVirtualMode() ? count : result.getRowCount());
                }
                if (result.getRowCount() != 0) {
                    if (this.assiFalg) {
                        this.balacelist = (ArrayList)GLReportGeneralStratBalanceFacadeFactory.getLocalInstance(ctx).insertStartHeBalance(this.stratMap, partner);
                        result.setYearSumMap(GLReportGeneralStratBalanceFacadeFactory.getLocalInstance(ctx).getYearSum(partner));
                    }
                    result.setStratBalacelist(this.balacelist);
                    Collection resulteCollection = this.executeSqlForData(ctx, partner);
                    result.getData().addAll(resulteCollection);
                    result.getTaodaDate().addAll(resulteCollection);
                }
            }
            result.setTempTableName(partner.getTempTableName());
            result.setTableHeadInfo(partner.getTableHeadInfo());
            this.doSomethingBeforeReturn(partner, result);
            result.setTime(t.msValue());
            t.reset();
            ReportResultInfo reportResultInfo = result;
            return reportResultInfo;
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _findInitData(Context ctx, Collection items, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        GLResUtil.setLocale(ctx);
        if (GlUtils.isCompanyUnion(company) && !this.isSupportVirtual()) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        ReportPartner partner = new ReportPartner(ctx);
        partner.setCompany(company);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (items == null) {
            return map;
        }
        try {
            partner.setConnection(this.getConnection(ctx));
            for (Object itemObj : items) {
                if (map.get(itemObj) != null || !String.class.isInstance(itemObj)) continue;
                String itemName = (String)itemObj;
                if (itemName.equals("DefaultTableHead")) {
                    map.put(itemName, this.getDefalutTableHeadInfo(partner));
                    continue;
                }
                if (itemName.equals("AllCurrency")) {
                    CurrencyCollection cc = this.getAllCurrency(partner);
                    map.put(itemName, cc);
                    String baseCurrencyId = null;
                    try {
                        RptRowSet rs = DBUtilx.executeQuery((String)"select FBaseCurrencyId from t_org_company where FID=?", (SqlParams)new SqlParams().addString(company.getId().toString()), (Context)ctx);
                        rs.next();
                        baseCurrencyId = rs.getString("FBaseCurrencyId");
                    }
                    catch (SQLException e) {
                        throw new SQLDataException(e);
                    }
                    CurrencyInfo commonBase = null;
                    CurrencyInfo companyBase = null;
                    int n = cc.size();
                    for (int i = 0; i < n; ++i) {
                        String currencyId = cc.get(i).getId().toString();
                        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId)) {
                            commonBase = cc.get(i);
                            continue;
                        }
                        if (!baseCurrencyId.equals(currencyId)) continue;
                        companyBase = cc.get(i);
                    }
                    if (commonBase == null) continue;
                    String name = commonBase.getName();
                    String number = commonBase.getNumber();
                    commonBase.putAll(companyBase);
                    commonBase.setId(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                    commonBase.setName(name);
                    commonBase.setNumber(number);
                    continue;
                }
                if (itemName.equals("DefaultCurrency")) {
                    map.put(itemName, this.getDefaultCurrency(partner));
                    continue;
                }
                if (itemName.equals("CurrentPeriod")) {
                    map.put(itemName, partner.getCurrentPeriod());
                    continue;
                }
                if (itemName.equals("MaxAccountLevel")) {
                    if (GlUtils.isCompanyUnion(partner.getCompany())) {
                        map.put(itemName, partner.getMaxGroupControlAccountLeve());
                        continue;
                    }
                    map.put(itemName, partner.getMaxAccountLevel());
                    continue;
                }
                if (itemName.equals("PeriodRange")) {
                    if (GlUtils.isCompanyUnion(partner.getCompany())) {
                        map.put(itemName, partner.getPeriodRangeUnion());
                        continue;
                    }
                    map.put(itemName, partner.getPeriodRange());
                    continue;
                }
                if (itemName.equals("PeriodRangeAll")) {
                    map.put(itemName, partner.getPeriodRange(1));
                    continue;
                }
                if (itemName.equals("StartPeriod")) {
                    if (GlUtils.isCompanyUnion(partner.getCompany())) continue;
                    map.put(itemName, partner.getStartPeriod());
                    continue;
                }
                if (itemName.equals("ParmForeignCurrencyIsUse")) {
                    map.put(itemName, partner.isParmForeignCurrencySu());
                    continue;
                }
                if (itemName.equals("ParmUsingReportingCurrency")) {
                    map.put(itemName, partner.isParmUseReportCurrency());
                    continue;
                }
                if (itemName.equals("ParmGroupPattern")) {
                    map.put(itemName, Boolean.TRUE);
                    continue;
                }
                if (!itemName.equals("CurrentCompany")) continue;
                this.setCompanyInfo(company, ctx);
                map.put(itemName, company);
            }
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        finally {
            SQLUtils.cleanup((Connection)partner.getConnection());
        }
    }

    private void setCompanyInfo(CompanyOrgUnitInfo company, Context ctx) throws BOSException, EASBizException {
        PeriodTypeInfo periodType = company.getAccountPeriodType();
        AccountTableInfo accountType = company.getAccountTable();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        if (periodType != null && accountType != null && periodType.getId() != null && accountType.getId() != null && (periodType.getName() == null || accountType.getName() == null)) {
            String sql = "select FNumber, FName_" + loc + " from T_BD_PeriodType where FID=? \n union all \n select FNumber, FName_" + loc + " from T_BD_AccountTable where FID=?";
            SqlParams sp = new SqlParams();
            sp.setString(1, periodType.getId().toString());
            sp.setString(2, accountType.getId().toString());
            Connection con = this.getConnection(ctx);
            try {
                RptRowSet rst = DBUtil.executeQuery((String)sql, (SqlParams)sp, (Connection)con);
                rst.next();
                periodType.setNumber(rst.getString(0));
                periodType.setName(rst.getString(1));
                rst.next();
                accountType.setNumber(rst.getString(0));
                accountType.setName(rst.getString(1));
            }
            catch (SQLException e) {
                e.setNextException(new SQLException("SQL: " + sql));
                throw new SQLDataException(e);
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    protected boolean isSupportVirtual() {
        return false;
    }

    protected void doSomethingBeforeQuery(ReportPartner partner) throws BOSException, EASBizException {
        if (partner.isNewQuery() && partner.getTempTableName() != null && partner.getTempTableName().length() > 0) {
            partner.dropTempTable(partner.getTempTableName());
            partner.setTempTableName(null);
        }
    }

    protected void doSomethingBeforeInsertData(ReportPartner partner) throws BOSException, EASBizException {
    }

    protected void doSomethingAfterInsertData(ReportPartner partner) throws BOSException, EASBizException {
    }

    protected void doSomethingBeforeExecuteSql(ReportPartner partner) throws BOSException, EASBizException {
    }

    protected void doSomethingBeforeReturn(ReportPartner partner, ReportResultInfo result) throws BOSException, EASBizException {
        if (!GlUtils.isCompanyUnion(partner.getCompany()) && partner.isNewQuery() && result.getRowCount() == result.getData().size() && result.getTempTableName() != null) {
            partner.dropTempTable(result.getTempTableName());
            partner.setTempTableName(null);
            result.setTempTableName(null);
        }
    }

    protected Collection executeSqlForData(Context ctx, ReportPartner partner) throws BOSException, EASBizException {
        String order;
        String sqlSelect;
        String sqlFromAndWhere = this.getSqlForDataFromAndWhere(partner);
        if (sqlFromAndWhere == null) {
            return new ArrayList();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select ");
        if (partner.getLineCount() > 0) {
            sql.append("Top ");
            sql.append(partner.getStartIndex() + partner.getLineCount());
            sql.append(" \r\n");
        }
        if ((sqlSelect = this.getSqlForDataSelect(partner)) == null || sqlSelect.length() == 0) {
            throw new ReportException(ReportException.SQL_SELECT_EMPTY);
        }
        sql.append(sqlSelect);
        sql.append("\r\n");
        sql.append(sqlFromAndWhere);
        sql.append("\r\n");
        if (partner.getFixCondition() instanceof ReportConditionJournal) {
            this.setPermissionFilter(sql, partner, ctx);
            this.addAsstDataPermissionFilter(sql, partner, ctx);
        }
        if ((order = this.getSqlForDataOrder(partner)) != null && order.length() > 0) {
            sql.append(order);
        }
        return this.getDataFormSQL(ctx, partner, sql.toString());
    }

    protected void setPermissionFilter(StringBuffer sql, ReportPartner partner, Context ctx) throws EASBizException, BOSException {
        if (partner.getParmIsUseAccountPermission().booleanValue()) {
            String strPermItem = "bd_account_accountView_view";
            CompanyDisplayModeEnum companyDisplayMode = null;
            String companyIds = "";
            String permSql = GLRptDaoUtil.getDataPermSqlFilter(ctx, companyDisplayMode, partner.getCompany(), companyIds, strPermItem, false, "TA.FID", "TA.fcompanyid");
            if (!StringUtils.isEmpty((String)permSql)) {
                if (sql.length() > 0) {
                    sql.append(" AND ");
                }
                sql.append(permSql);
            }
        }
    }

    protected boolean addAsstDataPermissionFilter(StringBuffer filter, ReportPartner partner, Context ctx) throws EASBizException, BOSException {
        boolean useAccountPermission = partner.getParmIsUseAccountPermission();
        ReportConditionJournal fixCondition = (ReportConditionJournal)partner.getFixCondition();
        boolean optionShowAsstItem = fixCondition.isOptionShowAsstItem();
        if (partner == null || !useAccountPermission || !optionShowAsstItem) {
            return false;
        }
        AsstAccountCollection asstAccountColl = this.getAsstAccountCollection(partner, ctx);
        StringBuffer sql = new StringBuffer();
        boolean existPermSql = false;
        for (int m = 0; m < asstAccountColl.size(); ++m) {
            AsstAccountInfo caa = asstAccountColl.get(m);
            if (m > 0) {
                sql.append(" OR ");
            }
            sql.append("(");
            StringBuffer assgrpSql = new StringBuffer();
            this.addFilterItem(assgrpSql, "HG.FAsstAccountID = '" + caa.getId().toString() + "'");
            sql.append(assgrpSql);
            AsstActGroupDetailCollection detailColl = caa.getAsstActGpDt();
            for (int n = 0; n < detailColl.size(); ++n) {
                AsstActTypeInfo at = detailColl.get(n).getAsstActType();
                if (at.getPermissionItem() == null) continue;
                try {
                    String permSql;
                    String strPermItem = at.getPermissionItem();
                    boolean isPermissionByCU = GLRptDaoUtil.checkIfPermissionByCU(ctx, strPermItem);
                    String companyId = partner.getCompany().getId().toString();
                    if (isPermissionByCU) {
                        companyId = partner.getCompany().getCU().getId().toString();
                    }
                    if ((permSql = GLRptDaoUtil.getDataPermissionSQL(ctx, companyId, at.getPermissionItem())) == null) continue;
                    this.addFilterItem(sql, "HG." + at.getMappingFieldName() + " in (" + permSql + ")");
                    existPermSql = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sql.append(")");
        }
        if (existPermSql) {
            if (filter.length() > 0) {
                filter.append(" AND ");
            }
            filter.append("(").append(sql).append("OR ( HG.FAsstAccountID is null )").append(")");
        }
        return existPermSql;
    }

    private AsstAccountCollection getAsstAccountCollection(ReportPartner partner, Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("CAA.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.name"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.*"));
        FilterInfo filter = new FilterInfo();
        StringBuffer accountIdSql = new StringBuffer();
        accountIdSql.append(" select lav.fid from t_bd_accountview lav ");
        accountIdSql.append(" inner join t_bd_accountview av on lav.fcompanyid = av.fcompanyid  ");
        accountIdSql.append(" and lav.faccounttableid = av.faccounttableid ");
        accountIdSql.append(" and (charindex(av.flongnumber||'!', lav.flongnumber) = 1 or av.fid = lav.fid)");
        accountIdSql.append(" where av.fid in (").append("SELECT distinct FAccountID FROM ").append(partner.getTempTableName()).append(")");
        accountIdSql.append(" and lav.fcaa is not null ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountIdSql.toString(), CompareType.INNER));
        view.setFilter(filter);
        AccountViewCollection accountColl = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        AsstAccountCollection asstAccountColl = new AsstAccountCollection();
        for (int i = 0; i < accountColl.size(); ++i) {
            AsstAccountInfo caa = accountColl.get(i).getCAA();
            if (asstAccountColl.contains((Object)caa.getId())) continue;
            asstAccountColl.add(caa);
        }
        return asstAccountColl;
    }

    protected void addFilterItem(StringBuffer filters, String filterItem) {
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)filterItem)) {
            return;
        }
        if (filters.length() > 0) {
            filters.append(" AND ");
        }
        filters.append(filterItem);
    }

    protected String getQuerySql(ReportPartner partner) throws BOSException, EASBizException {
        return null;
    }

    protected void insertTempTableForVirtual(ReportPartner partner, SimpleCompanyUserObject simpleCompanyUserObject) throws BOSException, EASBizException {
    }

    private void getAllCompanys(ReportPartner partner, DefaultMutableTreeNode parentNode, List allExpandObjects) throws EASBizException, BOSException {
        SimpleCompanyUserObject company = (SimpleCompanyUserObject)parentNode.getUserObject();
        allExpandObjects.add(company);
        if (parentNode.isLeaf()) {
            return;
        }
        this.insertTempTableForVirtual(partner, company);
        Enumeration<TreeNode> children = parentNode.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            this.getAllCompanys(partner, node, allExpandObjects);
        }
    }

    protected Collection executeSqlForAllData(ReportPartner partner, boolean allExpand) throws BOSException, EASBizException {
        EntityViewInfo evi = partner.getCondition();
        ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
        SimpleCompanyUserObject virtureCompany = customCondition.getVirtureCompany();
        ArrayList<Object> userObjects = new ArrayList<Object>();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)customCondition.getTreeModelOfCompany();
        Enumeration<TreeNode> enumer = node.breadthFirstEnumeration();
        DefaultMutableTreeNode findNode = null;
        while (enumer.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumer.nextElement();
            if (!((SimpleCompanyUserObject)node.getUserObject()).getCompanyId().equals(virtureCompany.getCompanyId())) continue;
            findNode = node;
            break;
        }
        if (partner.isNewQuery()) {
            int expandLevel = customCondition.getExpandCompanyLevel();
            if (expandLevel > 0 && findNode != null) {
                expandLevel += findNode.getLevel();
                enumer = findNode.breadthFirstEnumeration();
                while (enumer.hasMoreElements()) {
                    node = (DefaultMutableTreeNode)enumer.nextElement();
                    if (node.getLevel() >= expandLevel) continue;
                    virtureCompany = (SimpleCompanyUserObject)node.getUserObject();
                    if (!node.isLeaf()) {
                        this.insertTempTableForVirtual(partner, virtureCompany);
                    }
                    userObjects.add(virtureCompany);
                }
            } else {
                this.insertTempTableForVirtual(partner, virtureCompany);
                userObjects.add(virtureCompany);
            }
        } else if (findNode != null) {
            if (allExpand) {
                this.getAllCompanys(partner, findNode, userObjects);
                SimpleCompanyUserObject company = (SimpleCompanyUserObject)findNode.getUserObject();
                userObjects.remove(company);
            } else {
                Enumeration<TreeNode> children = findNode.children();
                String accountId = (String)partner.getFixCondition().getExpandInfo().get("AccountID");
                while (children.hasMoreElements()) {
                    node = (DefaultMutableTreeNode)children.nextElement();
                    SimpleCompanyUserObject company = (SimpleCompanyUserObject)node.getUserObject();
                    if (!node.isLeaf() && !" ".equals(accountId)) {
                        this.insertTempTableForVirtual(partner, company);
                    }
                    userObjects.add(company);
                }
                if (customCondition.isExplandAllChildCom()) {
                    enumer = findNode.breadthFirstEnumeration();
                    while (enumer.hasMoreElements()) {
                        node = (DefaultMutableTreeNode)enumer.nextElement();
                        if (node.equals(findNode)) continue;
                        userObjects.add(node.getUserObject());
                    }
                }
            }
            if (GlUtils.isCompanyUnion(partner.getCompany())) {
                ReportConditionJournal conditionJournal;
                ReportConditionBalanceListNew conditionNew;
                if (partner.getFixCondition() instanceof ReportConditionBalanceListNew && (conditionNew = (ReportConditionBalanceListNew)partner.getFixCondition()).getDisplayAsstDetail()) {
                    userObjects.add((SimpleCompanyUserObject)node.getUserObject());
                    if (allExpand && userObjects.size() > 1) {
                        SimpleCompanyUserObject company = (SimpleCompanyUserObject)findNode.getUserObject();
                        userObjects.remove(company);
                    }
                }
                if (partner.getFixCondition() instanceof ReportConditionJournal && (conditionJournal = (ReportConditionJournal)partner.getFixCondition()).isOptionShowAsstItem()) {
                    userObjects.add((SimpleCompanyUserObject)node.getUserObject());
                }
            }
        }
        partner.getCondition().put("allExpand", (Object)allExpand);
        partner.getCondition().put("SelectedCompanyNode", findNode == null ? null : findNode.getUserObject());
        partner.getCondition().put("Companys", userObjects);
        partner.getCondition().put("SelectedCompany", (Object)virtureCompany);
        String querySql = this.getQuerySql(partner);
        if (querySql == null) {
            StringBuffer sql = new StringBuffer();
            String sqlFromAndWhere = this.getSqlForDataFromAndWhere(partner);
            if (sqlFromAndWhere == null) {
                return new ArrayList();
            }
            sql.append(this.useDialect() ? "/*dialect*/" : "").append("Select ");
            String sqlSelect = this.getSqlForDataSelect(partner);
            if (sqlSelect == null || sqlSelect.length() == 0) {
                throw new ReportException(ReportException.SQL_SELECT_EMPTY);
            }
            sql.append(sqlSelect);
            sql.append("\r\n");
            sql.append(sqlFromAndWhere);
            sql.append("\r\n");
            String order = this.getSqlForDataOrder(partner);
            if (order != null && order.length() > 0) {
                sql.append(order);
            }
            querySql = sql.toString();
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        HashMap scale = new HashMap();
        SqlParameter2 parameter = this.getParameters(partner);
        if (parameter != null) {
            querySql = parameter.getSqlWithParameters(querySql);
        }
        IRowSet rs = DbUtil.executeQuery((Context)partner.getContext(), (String)querySql);
        try {
            while (rs.next()) {
                if (allExpand) {
                    Object[] objectNext = this.getLineObjects(partner.getContext(), partner, (ResultSet)rs, scale);
                    int count = arrayList.size();
                    if (count > 0) {
                        Object[] objectPre = (Object[])arrayList.get(count - 1);
                        SimpleCompanyUserObject s1 = (SimpleCompanyUserObject)objectPre[2];
                        SimpleCompanyUserObject s2 = (SimpleCompanyUserObject)objectNext[2];
                        if (s1 == null || s2 == null) {
                            arrayList.add(objectNext);
                            continue;
                        }
                        if (s1.getLongNumber().equals(s2.getLongNumber())) continue;
                        arrayList.add(objectNext);
                        continue;
                    }
                    arrayList.add(objectNext);
                    continue;
                }
                arrayList.add(this.getLineObjects(partner.getContext(), partner, (ResultSet)rs, scale));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!customCondition.isExplandAllChildCom() && customCondition.getExpandCompanyLevel() <= 0) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (((Object[])o1)[2] == null || ((Object[])o2)[2] == null) {
                        return 0;
                    }
                    SimpleCompanyUserObject s1 = (SimpleCompanyUserObject)((Object[])o1)[2];
                    SimpleCompanyUserObject s2 = (SimpleCompanyUserObject)((Object[])o2)[2];
                    return s1.getLongNumber().compareTo(s2.getLongNumber());
                }
            });
        }
        if (allExpand && userObjects.size() == 1) {
            SimpleCompanyUserObject s1 = (SimpleCompanyUserObject)userObjects.get(0);
            if (virtureCompany.getLongNumber().equals(s1.getLongNumber())) {
                arrayList.remove(0);
            }
        }
        return arrayList;
    }

    protected Object[] getLineObjects(Context ctx, ReportPartner partner, ResultSet rs, Map scale) throws SQLException, EASBizException, BOSException {
        return this.getLineObjects(partner, rs);
    }

    protected abstract Object[] getLineObjects(ReportPartner var1, ResultSet var2) throws SQLException, BOSException, EASBizException;

    protected Collection getDataFormSQL(Context ctx, ReportPartner partner, String sql) throws BOSException, EASBizException {
        if (partner.getStartIndex() < 0) {
            throw new IllegalArgumentException("getRowSet: start = " + partner.getStartIndex());
        }
        if (partner.getLineCount() < 0) {
            throw new IllegalArgumentException("getRowSet: length = " + partner.getLineCount());
        }
        if (partner.getStartIndex() + partner.getLineCount() == 0) {
            return new ArrayList();
        }
        SqlParameter2 params = (SqlParameter2)partner.getVariable(SQL_PARAMETERS);
        if (params != null) {
            sql = params.getSqlWithParameters(sql);
        }
        try {
            return this.getDataFromResult(partner, (ResultSet)DbUtil.executeQuery((Context)ctx, (String)sql));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Collection getDataFromResult(ReportPartner partner, ResultSet rs) throws BOSException, SQLException, EASBizException {
        if (partner.getStartIndex() + partner.getLineCount() == 0) {
            return new ArrayList();
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        HashMap scale = new HashMap();
        int index = 0;
        while (rs.next()) {
            if (partner.getStartIndex() > index) {
                ++index;
                continue;
            }
            arrayList.add(this.getLineObjects(partner.getContext(), partner, rs, scale));
        }
        if (partner.getLineCount() > arrayList.size() && this.isAddTotalLine(partner) && (arrayList.size() > 0 || !partner.isNewQuery())) {
            arrayList.add(this.getTotalLine(partner));
        }
        return arrayList;
    }

    protected boolean isAddTotalLine(ReportPartner partner) {
        return false;
    }

    protected Object[] getTotalLine(ReportPartner partner) throws BOSException, SQLException, EASBizException {
        return null;
    }

    protected int getTotel(ReportPartner partner) throws BOSException, EASBizException {
        PreparedStatement stmt = null;
        IRowSet rs = null;
        int total = 0;
        String sqlFromAndWhere = this.getSqlForDataFromAndWhere(partner);
        if (sqlFromAndWhere == null || sqlFromAndWhere.length() == 0) {
            return -1;
        }
        try {
            stmt = partner.getConnection().prepareStatement((this.useDialect() ? "/*dialect*/" : "") + "Select count(*) " + sqlFromAndWhere);
            SqlParameter2 parameter = this.getParameters(partner);
            if (parameter != null) {
                parameter.putToStatement(stmt);
            }
            rs = parameter != null ? DbUtil.executeQuery((Context)partner.getContext(), (String)parameter.getSqlWithParameters("Select count(*) " + sqlFromAndWhere)) : DbUtil.executeQuery((Context)partner.getContext(), (String)("Select count(*) " + sqlFromAndWhere));
            total = rs.next() ? rs.getInt(1) : 0;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + (this.useDialect() ? "/*dialect*/" : "") + "Select count(*) " + sqlFromAndWhere));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return this.isAddTotalLine(partner) && total > 0 ? total + 1 : total;
    }

    protected String getSqlForDataFromAndWhere(ReportPartner partner) throws BOSException, EASBizException {
        String sqlForDataFromAndWhere = (String)partner.getVariable(SQL_FOR_DATA_FORM_AND_WHERE);
        if (sqlForDataFromAndWhere == null) {
            StringBuffer sql = new StringBuffer();
            String from = this.getSqlForDataFrom(partner);
            if (from == null || from.length() == 0) {
                throw new ReportException(ReportException.SQL_FROM_EMPTY);
            }
            sql.append(from);
            this.joinAuthoritySql(partner, sql);
            sql.append("\n\r");
            String where = this.getSqlForDataWhere(partner);
            if (where != null && where.length() > 0) {
                sql.append(where);
            }
            sqlForDataFromAndWhere = sql.toString();
            partner.setVariable(SQL_FOR_DATA_FORM_AND_WHERE, sqlForDataFromAndWhere);
        }
        return sqlForDataFromAndWhere;
    }

    protected abstract String getSqlForDataSelect(ReportPartner var1) throws BOSException, EASBizException;

    protected abstract String getSqlForDataFrom(ReportPartner var1) throws BOSException, EASBizException;

    protected abstract String getSqlForDataWhere(ReportPartner var1) throws BOSException, EASBizException;

    protected abstract String getSqlForDataOrder(ReportPartner var1) throws BOSException, EASBizException;

    protected String getAuthoritySql(ReportPartner partner, String authorityName) throws BOSException, EASBizException {
        return null;
    }

    protected void joinAuthoritySql(ReportPartner partner, StringBuffer sql) throws BOSException, EASBizException {
        String authoritySql;
        if (sql != null && (authoritySql = this.getAuthoritySql(partner, this.getAuthorityName())) != null && authoritySql.length() > 0) {
            sql.append("\n\r");
            sql.append(" Inner Join (");
            sql.append(authoritySql);
            sql.append(") T_Authority ");
            sql.append("\n\r");
            sql.append("on T_Main.FAccountID = T_Authority.ID ");
        }
    }

    protected void insertDataIntoTempTable(ReportPartner partner) throws BOSException, EASBizException {
    }

    protected abstract String getReportName();

    protected abstract String getAuthorityName();

    protected abstract ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner var1) throws BOSException, EASBizException;

    protected void setParameters(ReportPartner partner, SqlParameter2 parameters) {
        partner.setVariable(SQL_PARAMETERS, parameters);
    }

    protected SqlParameter2 getParameters(ReportPartner partner) {
        return (SqlParameter2)partner.getVariable(SQL_PARAMETERS);
    }

    protected CurrencyCollection getAllCurrency(ReportPartner partner) throws BOSException, EASBizException {
        return partner.getAllCurrency();
    }

    protected CurrencyInfo getDefaultCurrency(ReportPartner partner) throws BOSException, EASBizException {
        return partner.getCompany().getBaseCurrency();
    }

    protected BigDecimal getBigDecimalForScale(BigDecimal bigDecimal, int scale) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(scale, 4);
    }

    @Override
    protected void _dropTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        InitHelp.dropTempTable(ctx, tableName);
    }

    protected ReportPartner getReportPartner(Context ctx) {
        return new ReportPartner(ctx);
    }

    protected boolean useVirtualMode() {
        return false;
    }

    protected boolean useDialect() {
        return false;
    }

    protected void execute(Context ctx, String sql) throws BOSException {
        this.execute(ctx, sql, null);
    }

    protected void execute(Context ctx, String sql, Object[] params) throws BOSException {
        if (SQLUtil.isOracle(ctx) && (sql.contains("/*+ opt_param('_complex_view_merging','false') */") || sql.contains("/*+ opt_param('_complex_view_merging','true') */"))) {
            int index;
            sql = sql.replaceAll("ISNULL", "NVL");
            StringBuffer buffer = new StringBuffer();
            String key = "TO_DATE('";
            int start = 0;
            while ((index = sql.indexOf(key, start)) >= 0) {
                buffer.append(sql.substring(start, index += key.length()));
                start = index;
                index = sql.indexOf("')", start);
                String date = sql.substring(start, index);
                if (date.length() <= 10) {
                    date = date + " 00:00:00";
                }
                buffer.append(date).append("', 'YYYY-MM-DD HH24:MI:SS");
                start = index;
            }
            buffer.append(sql.substring(start));
            sql = GLReportControllerBean.replaceFunction(buffer.toString(), "CHARINDEX");
            sql = "/*dialect*/ " + sql;
        }
        if (params == null) {
            DbUtil.execute((Context)ctx, (String)sql);
        } else {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    private static String replaceFunction(String sql, String function) {
        StringBuffer buffer = new StringBuffer();
        int len = sql.length();
        int start = 0;
        int begin = 0;
        block0: while ((begin = sql.indexOf(function, start)) >= 0) {
            buffer.append(sql.substring(start, begin));
            int left = 0;
            for (int index = begin + 9; index < len; ++index) {
                char c = sql.charAt(index);
                if (c == '(') {
                    ++left;
                    continue;
                }
                if (c != ')' || --left != 0) continue;
                String fsql = sql.substring(begin, index + 1);
                buffer.append(GLReportControllerBean.translateFunction(fsql, function));
                start = index + 1;
                continue block0;
            }
        }
        if (buffer.length() > 0) {
            if (start < len) {
                buffer.append(sql.substring(start));
            }
            return buffer.toString();
        }
        return sql;
    }

    private static String translateFunction(String fsql, String function) {
        int index = fsql.indexOf(44);
        int start = fsql.indexOf(40);
        int end = fsql.lastIndexOf(41);
        if (index < 0 || start < 0 || end < 0 || end < start) {
            return fsql;
        }
        String[] strs = fsql.substring(start + 1, end).split(",");
        if (strs.length != 2) {
            return fsql;
        }
        return "INSTR(" + strs[1].trim() + ", " + strs[0].trim() + ")";
    }

    protected boolean isAfterPeriod(ReportPartner partner) throws EASBizException, BOSException {
        Context ctx = partner.getContext();
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)(partner.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : partner.getCompany()));
        int curPeriod = currentPeriod.getNumber();
        ReportConditionBase condition = partner.getFixCondition();
        int peroidYeayEnd = condition.getPeriodYearEnd();
        int peroidNumber = condition.getPeriodNumberEnd();
        return curPeriod < peroidYeayEnd * 100 + peroidNumber;
    }
}

