/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BalanceOrientionTag;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.PLType;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportExchangeRateAdjustCondition;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadItemInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportExchangeRateAdjustControllerBean;
import com.kingdee.eas.fi.gl.app.GLRptHelper;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLReportExchangeRateAdjustControllerBean
extends AbstractGLReportExchangeRateAdjustControllerBean {
    private static final String MAX_ASSTITEM_COUNT = "MaxAsstItemCount";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLReportExchangeRateAdjustControllerBean");
    private Map<String, Integer> actTypeMap;

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, EASBizException, BOSException {
        return null;
    }

    @Override
    protected Object[] getLineObjects(Context ctx, ReportPartner partner, ResultSet rs, Map scale) throws SQLException, EASBizException, BOSException {
        Object obj;
        ReportExchangeRateAdjustCondition condition = (ReportExchangeRateAdjustCondition)partner.getFixCondition();
        int index = 0;
        int asstCount = 0;
        if (condition.getDisplayAsstDetail() && (obj = partner.getVariable(MAX_ASSTITEM_COUNT)) != null && (Integer)obj > 0) {
            asstCount = (Integer)obj;
        }
        Object[] row = new Object[14 + asstCount];
        BigDecimal balance = rs.getBigDecimal("FBalanceFor");
        boolean bSystemTag = true;
        int foriention = rs.getInt("FOriention");
        int scaleFor = rs.getInt("FPrecision");
        int scaleLocal = 0;
        CurrencyInfo baseCurrency = partner.getCompany().getBaseCurrency();
        if (baseCurrency != null) {
            scaleLocal = baseCurrency.getPrecision();
        }
        int scaleRate = 0;
        String currencyid = rs.getString("FCurrencyId");
        if (currencyid != null && baseCurrency != null) {
            scale.put("companyInVoucher", partner.getCompany());
            scaleRate = GlUtils.getEx(ctx, scaleLocal, currencyid, baseCurrency.getId().toString(), scale, true);
        }
        BalanceOrientionTag opposite = new BalanceOrientionTag();
        opposite.setOriention(0);
        String strDC = this.getBalanceDC(partner, balance, opposite, bSystemTag, foriention);
        BigDecimal ori = new BigDecimal(String.valueOf(opposite.getOriention()));
        int totalTag = rs.getInt("FTotalTag");
        int serTag = rs.getInt("FSerTag");
        if (totalTag == 1) {
            row[index++] = null;
            row[index++] = null;
            row[index++] = null;
            row[index++] = partner.TITLE_TOTAL;
            if (condition.getDisplayAsstDetail()) {
                for (int i = 0; i < asstCount; ++i) {
                    row[index++] = null;
                }
            }
            row[index++] = null;
            row[index++] = null;
            row[index++] = null;
            row[index++] = null;
            Object exchRateBefore = null;
            BigDecimal balanceBefore = rs.getBigDecimal("FBalanceBefore");
            if (balanceBefore != null) {
                balanceBefore = balanceBefore.setScale(scaleLocal, 4);
            }
            row[index++] = balanceBefore;
            row[index++] = null;
            BigDecimal balanceAfter = rs.getBigDecimal("FBalanceAfter");
            if (balanceAfter != null) {
                balanceAfter = balanceAfter.setScale(scaleLocal, 4);
            }
            row[index++] = balanceAfter;
            BigDecimal balanceAdjust = rs.getBigDecimal("FBalanceAdjust");
            if (balanceAdjust != null) {
                balanceAdjust = balanceAdjust.setScale(scaleLocal, 4);
            }
            row[index++] = balanceAdjust;
            row[index++] = ReportResultInfo.LINE_TOTAL;
        }
        if (totalTag == 0 && serTag == 1) {
            row[index++] = null;
            row[index++] = null;
            row[index++] = null;
            row[index++] = partner.TITLE_SUB_TOTAL;
            row[index++] = null;
            if (condition.getDisplayAsstDetail()) {
                for (int i = 0; i < asstCount; ++i) {
                    row[index++] = null;
                }
            }
            row[index++] = null;
            row[index++] = null;
            row[index++] = null;
            BigDecimal balanceBefore = rs.getBigDecimal("FBalanceBefore");
            if (balanceBefore != null) {
                balanceBefore = balanceBefore.setScale(scaleLocal, 4);
            }
            row[index++] = balanceBefore;
            row[index++] = null;
            BigDecimal balanceAfter = rs.getBigDecimal("FBalanceAfter");
            if (balanceAfter != null) {
                balanceAfter = balanceAfter.setScale(scaleLocal, 4);
            }
            row[index++] = balanceAfter;
            BigDecimal balanceAdjust = rs.getBigDecimal("FBalanceAdjust");
            if (balanceAdjust != null) {
                balanceAdjust = balanceAdjust.setScale(scaleLocal, 4);
            }
            row[index++] = balanceAdjust;
            row[index++] = ReportResultInfo.LINE_PERIOD_TOTAL;
        }
        if (totalTag == 0 && serTag == 0) {
            row[index++] = rs.getString("FPeriodYear");
            row[index++] = rs.getString("FPeriodNumber");
            row[index++] = rs.getString("FAccountNumber");
            row[index++] = rs.getString("FAccountName");
            row[index++] = rs.getString("FOriginalCurrency");
            if (condition.getDisplayAsstDetail()) {
                String asstNameL = rs.getString("FAsstName");
                String asstNameD = rs.getString("FdisplaynameGroup");
                String asstNameN = rs.getString("FNumberGroup");
                if (StringUtils.isEmpty((String)asstNameL)) {
                    for (int i = 0; i < asstCount; ++i) {
                        row[index++] = null;
                    }
                } else {
                    String[] strAsstNameL = asstNameL.trim().split(";");
                    String[] strAsstNameD = asstNameD.trim().split(";");
                    String[] strAsstNameN = asstNameN.trim().split(";");
                    int splitLen = strAsstNameL.length;
                    String number = null;
                    int acctTypeFlag = 0;
                    if (this.actTypeMap == null) {
                        this.actTypeMap = GLRptHelper.initAcctTypeMap(partner.getContext());
                    }
                    for (int i = 0; i < asstCount; ++i) {
                        if (i < splitLen) {
                            number = strAsstNameN[i].substring(0, strAsstNameN[i].indexOf("_!"));
                            if (number == "" || number == null) {
                                acctTypeFlag = 0;
                            }
                            if (this.actTypeMap.get(number) != null) {
                                acctTypeFlag = this.actTypeMap.get(number);
                            }
                            row[index++] = GLRptHelper.getAssDisplayName1(partner.isParmAssitemShowNumber(), partner.isRptShowLongNameFromGeneral(), partner.isRptShowLongNumberFromGeneral(), acctTypeFlag, strAsstNameL[i], strAsstNameD[i], strAsstNameN[i]);
                            continue;
                        }
                        row[index++] = null;
                    }
                }
            }
            row[index++] = strDC;
            BigDecimal balanceFor = rs.getBigDecimal("FBalanceFor");
            if (balanceFor != null) {
                balanceFor = balanceFor.multiply(ori);
                balanceFor = balanceFor.setScale(scaleFor, 4);
            }
            row[index++] = balanceFor;
            BigDecimal exchRateBefore = rs.getBigDecimal("FExchRateBefore");
            if (exchRateBefore != null) {
                exchRateBefore = exchRateBefore.setScale(scaleRate, 4);
            }
            row[index++] = exchRateBefore;
            BigDecimal balanceBefore = rs.getBigDecimal("FBalanceBefore");
            if (balanceBefore != null) {
                balanceBefore = balanceBefore.multiply(ori);
                balanceBefore = balanceBefore.setScale(scaleLocal, 4);
            }
            row[index++] = balanceBefore;
            BigDecimal exchRateAfter = rs.getBigDecimal("FExchRateAfter");
            if (exchRateAfter != null) {
                exchRateAfter = exchRateAfter.setScale(scaleRate, 4);
            }
            row[index++] = exchRateAfter;
            BigDecimal balanceAfter = rs.getBigDecimal("FBalanceAfter");
            if (balanceAfter != null) {
                balanceAfter = balanceAfter.multiply(ori);
                balanceAfter = balanceAfter.setScale(scaleLocal, 4);
            }
            row[index++] = balanceAfter;
            BigDecimal balanceAdjust = rs.getBigDecimal("FBalanceAdjust");
            if (balanceAdjust != null) {
                balanceAdjust = balanceAdjust.multiply(ori);
                balanceAdjust = balanceAdjust.setScale(scaleLocal, 4);
            }
            row[index++] = balanceAdjust;
            row[index++] = ReportResultInfo.LINE_NORMAL;
        }
        row[index++] = null;
        return row;
    }

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, ReportException {
        StringBuffer strSelect = new StringBuffer();
        ReportExchangeRateAdjustCondition condition = (ReportExchangeRateAdjustCondition)partner.getFixCondition();
        strSelect.append(" T_Main.FPeriodYear, T_Main.FPeriodNumber , T_Main.FTotalTag , T_Main.FSerTag  , \r\n");
        strSelect.append(" T_Main.FAccountNumber, T_Main.FAccountName ,T_Main.FPrecision, \r\n");
        strSelect.append(" T_Main.FOriginalCurrency,T_Main.FCurrencyId,T_Main.FOriention, \r\n");
        if (condition.getDisplayAsstDetail()) {
            strSelect.append(" T_Main.FAssistGrpId, \r\n");
            strSelect.append(" HG.FdisplaynameGroup").append(partner.getFieldNameExtend()).append(" as  FdisplaynameGroup,\r\n");
            strSelect.append(" HG.FNumberGroup").append(partner.getFieldNameExtend()).append(" as  FNumberGroup,\r\n");
            strSelect.append(" HG.flongnamegroup").append(partner.getFieldNameExtend()).append(" as  FAsstName,\r\n");
        }
        strSelect.append(" T_Main.FBalanceFor,T_Main.FExchRateBefore,T_Main.FBalanceBefore ,T_Main.FExchRateAfter,\r\n");
        strSelect.append(" T_Main.FBalanceAfter,T_Main.FBalanceAdjust \r\n");
        return strSelect.toString();
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException, ReportException {
        ReportExchangeRateAdjustCondition condition = (ReportExchangeRateAdjustCondition)partner.getFixCondition();
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append(" from ( select \r\n");
        StringBuffer strSelect = new StringBuffer();
        sqlFrom.append(" FPeriodYear, FPeriodNumber ,FTotalTag ,FSerTag  , \r\n");
        sqlFrom.append(" FAccountNumber,FAccountName ,FPrecision, \r\n");
        sqlFrom.append(" FOriginalCurrency,FCurrencyId,FOriention, \r\n");
        if (condition.getDisplayAsstDetail()) {
            sqlFrom.append("FAssistGrpId,");
        }
        sqlFrom.append(" FBalanceFor,FExchRateBefore,FBalanceBefore ,FExchRateAfter,\r\n");
        sqlFrom.append(" FBalanceAfter,FBalanceAdjust \r\n");
        sqlFrom.append(" from ").append(partner.getTempTableName()).append(" \r\n ");
        sqlFrom.append(") AS T_Main \r\n");
        if (condition.getDisplayAsstDetail()) {
            sqlFrom.append(" LEFT JOIN T_BD_AssistantHG AS HG ON T_Main.FAssistGrpId = HG.FID \r\n");
        }
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws BOSException, ReportException {
        return null;
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, ReportException {
        return " Order By FTotalTag,FPeriodYear, FPeriodNumber, FSerTag, FAccountNumber";
    }

    @Override
    protected String getReportName() {
        return "GLExchangeRateAdjust";
    }

    @Override
    protected String getAuthorityName() {
        return "GLExchangeRateAdjust";
    }

    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.GLReportExchangeRateAdjustQuery";
    }

    @Override
    protected void doSomethingBeforeQuery(ReportPartner partner) throws BOSException, EASBizException {
        super.doSomethingBeforeQuery(partner);
        if (partner.isNewQuery()) {
            ReportTableHeadInfo head = this.getTableHeadInfo(partner);
            ReportExchangeRateAdjustCondition condition = (ReportExchangeRateAdjustCondition)partner.getFixCondition();
            if (!condition.getDisplayAsstDetail()) {
                partner.setTableHeadInfo(head);
            }
            if (!head.check()) {
                throw new ReportException(ReportException.TABLE_HEAD_ERROR);
            }
        }
    }

    @Override
    protected void doSomethingBeforeExecuteSql(ReportPartner partner) throws BOSException, EASBizException {
        block9: {
            ReportExchangeRateAdjustCondition condition = (ReportExchangeRateAdjustCondition)partner.getFixCondition();
            if (!condition.getDisplayAsstDetail()) break block9;
            StringBuffer sqlMax = new StringBuffer();
            sqlMax.append("Select max(hg.fcount) as fcount");
            sqlMax.append("\r\n");
            sqlMax.append(" from ").append(partner.getTempTableName()).append(" as T_Main \r\n");
            sqlMax.append(" LEFT JOIN T_BD_AssistantHG AS HG ON T_Main.FAssistGrpId = HG.FID ");
            sqlMax.append(" LEFT JOIN T_BD_AccountView AS TA ON T_Main.FAccountID = TA.FID");
            sqlMax.append(" WHERE \r\n");
            sqlMax.append(" ((TA.FAccountTableID = ?) ");
            if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
                sqlMax.append(" AND (TA.FNumber >= ?)  \r\n");
            }
            if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
                sqlMax.append(" AND (TA.FNumber <= ?)  \r\n");
            }
            if (condition.isAllCurrency() || GlUtils.isCompanyUnion(partner.getCompany()) && condition.getDisplayAsstDetail()) {
                sqlMax.append(" or (TA.fid is  null )  \r\n");
            }
            sqlMax.append(")");
            SqlParameter2 parameter = new SqlParameter2();
            parameter.addValueChar(partner.getAccountTableId());
            if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
                parameter.addValueVarchar(condition.getAccountCodeStart());
            }
            if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
                parameter.addValueVarchar(condition.getAccountCodeEnd() + "~~");
            }
            PreparedStatement stmt = null;
            ResultSet result = null;
            try {
                stmt = partner.getConnection().prepareStatement(sqlMax.toString());
                parameter.putToStatement(stmt);
                result = stmt.executeQuery();
                result.next();
                int maxCount = result.getInt("FCount");
                partner.setVariable(MAX_ASSTITEM_COUNT, new Integer(maxCount));
            }
            catch (SQLException sqle) {
                try {
                    sqle.setNextException(new SQLException("The query sql is:" + sqlMax));
                    throw new SQLDataException(sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(result, stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)result, (Statement)stmt);
            this.setHeader(partner);
        }
    }

    private void setHeader(ReportPartner partner) throws EASBizException, BOSException {
        ArrayList<ReportTableHeadItemInfo> items = new ArrayList<ReportTableHeadItemInfo>();
        int scaleLocal = partner.getScaleLocal();
        items.add(this.addHeadItemInfo("FPeriodYear", new String[]{"PeriodYear"}, 70, 2, false, true, true, 0, false, 0));
        items.add(this.addHeadItemInfo("FPeriodNumber", new String[]{"PeriodNumber"}, 70, 2, false, true, true, 0, false, 0));
        items.add(this.addHeadItemInfo("FAccountNumber", new String[]{"AccountNumber"}, 70, 0, false, false, true, 0, false, 0));
        items.add(this.addHeadItemInfo("FAccountName", new String[]{"AccountName"}, 100, 0, false, false, true, 0, true, 0));
        items.add(this.addHeadItemInfo("FOriginalCurrency", new String[]{"OriginalCurrency"}, 70, 0, false, false, true, 0, true, 0));
        int asstCount = 0;
        Object obj = partner.getVariable(MAX_ASSTITEM_COUNT);
        if (obj != null && (Integer)obj > 0) {
            asstCount = (Integer)obj;
        }
        for (int i = 0; i < asstCount; ++i) {
            items.add(this.addHeadItemInfo("FAsstItem" + i, new String[]{"AssistActName"}, 160, 0, false, false, true, 0, false, 0));
        }
        items.add(this.addHeadItemInfo("FOriention", new String[]{"Oriention"}, 35, 1, false, false, true, 0, true, 0));
        items.add(this.addHeadItemInfo("FBalanceFor", new String[]{"BalanceFor"}, 80, 2, false, false, true, 1, true, scaleLocal));
        items.add(this.addHeadItemInfo("FExchRateBefore", new String[]{"ExchRateBeforeAdjust"}, 70, 2, false, false, true, 0, true, 0));
        items.add(this.addHeadItemInfo("FBalanceBefore", new String[]{"BalanceLocalBeforeAdjust"}, 105, 2, false, false, true, 1, true, scaleLocal));
        items.add(this.addHeadItemInfo("FExchRateAfter", new String[]{"ExchRateAfterAdjust"}, 70, 2, false, false, true, 0, true, 0));
        items.add(this.addHeadItemInfo("FBalanceAfter", new String[]{"BalanceLocalAfterAdjust"}, 108, 2, false, false, true, 1, true, scaleLocal));
        items.add(this.addHeadItemInfo("FBalanceAdjust", new String[]{"Difference"}, 120, 2, false, false, true, 1, true, scaleLocal));
        ReportTableHeadInfo head = new ReportTableHeadInfo(items.toArray(new ReportTableHeadItemInfo[0]));
        head.setHeadMerge(true);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        partner.setTableHeadInfo(head);
    }

    @Override
    protected void insertDataIntoTempTable(ReportPartner partner) throws BOSException, EASBizException {
        String strStructure = this.getTempTableStructure(partner);
        String srtTempleName = partner.createTempTableAsynchronism("GLADJUST", strStructure);
        partner.setTempTableName(srtTempleName);
        this.insertTempData(partner, srtTempleName);
    }

    private void insertTempData(ReportPartner partner, String strTempTable) throws EASBizException, BOSException {
        ReportExchangeRateAdjustCondition condition = (ReportExchangeRateAdjustCondition)partner.getFixCondition();
        String companyId = partner.getCompanyId();
        int iStartYear = condition.getPeriodYearStart();
        int iEndYear = condition.getPeriodYearEnd();
        int iStartPeriod = condition.getPeriodNumberStart();
        int iEndPeriod = condition.getPeriodNumberEnd();
        String currencyId = null;
        if (!condition.isAllCurrency()) {
            currencyId = condition.getCurrencyID();
        }
        String strAcctNumberStart = condition.getAccountCodeStart();
        String strAcctNumberEnd = condition.getAccountCodeEnd();
        boolean bEndBalDCByAcct = partner.isParmBalanceDirSamAsAccount();
        StringBuffer strSQL = new StringBuffer();
        strSQL.append(" SELECT h.FAccountID,p.FPeriodYear FPeriodYear,p.FPeriodNumber FPeriodNumber,\r\n");
        strSQL.append("    0 FTotalTag, 0 FSerTag, a.FNumber FAccountNumber,\r\n");
        strSQL.append(this.getAccountName(partner));
        strSQL.append(partner.getFieldNameExtend());
        strSQL.append(" FAccountName, \r\n");
        strSQL.append("    c.FPrecision FPrecision, fisocode FCurrencyISOCode,\r\n");
        strSQL.append("    c.fname");
        strSQL.append(partner.getFieldNameExtend());
        strSQL.append(" FOriginalCurrency,c.Fid FCurrencyId,a.fdc FOriention,");
        if (condition.getDisplayAsstDetail()) {
            strSQL.append("h.FAssistHGID FAssistGrpId,");
        }
        strSQL.append("    sum(h.FBalanceFor) FBalanceFor,h.FExchRateBefore FExchRateBefore,\r\n");
        strSQL.append("    sum(FBalanceBefore) FBalanceBefore,h.FExchRateAfter FExchRateAfter,\r\n");
        strSQL.append("    sum(h.FBalanceAfter) FBalanceAfter,sum(case when a.fdc = 1 then h.FBalanceAfter - h.FBalanceBefore else h.FBalanceBefore - h.FBalanceAfter end) FBalanceAdjust \r\n");
        strSQL.append(" FROM T_GL_AdjExchRateHistory  h \r\n");
        strSQL.append("    INNER JOIN T_ORG_Company o \r\n");
        strSQL.append("       On h.FCompanyid = o.fid  \r\n");
        strSQL.append("    INNER JOIN T_BD_PERIOD p \r\n");
        strSQL.append("       ON  h.fperiodid = p.fid \r\n");
        strSQL.append("       AND o.faccountperiodid = p.ftypeid \r\n");
        strSQL.append("    INNER JOIN T_BD_AccountView---\r\n a \r\n");
        strSQL.append("       on h.faccountid = a.fid  \r\n");
        strSQL.append("       AND h.FCompanyID = a.FCompanyID \r\n");
        strSQL.append("    INNER JOIN T_BD_CURRENCY c  \r\n");
        strSQL.append("       on h.fcurrencyid = c.fid \r\n");
        if (condition.getDisplayAsstDetail()) {
            strSQL.append(" LEFT JOIN T_BD_ASSISTANTHG hg  on h.FAssistHGID = hg.fid \r\n");
        }
        strSQL.append(" WHERE \r\n");
        strSQL.append("    h.FCompanyID = '").append(companyId).append("' \r\n");
        strSQL.append("    AND (p.FPeriodYear> ").append(iStartYear).append(" or(p.FPeriodYear= ").append(iStartYear).append(" and FPeriodNumber>= ").append(iStartPeriod).append(")) \r\n");
        strSQL.append("    AND (p.FPeriodYear< ").append(iEndYear).append(" or(p.FPeriodYear= ").append(iEndYear).append(" and FPeriodNumber<= ").append(iEndPeriod).append(")) \r\n");
        if (!condition.isAllCurrency()) {
            strSQL.append("    AND  c.fid = '").append(currencyId).append("'  \r\n");
        }
        if (strAcctNumberStart != null && !strAcctNumberStart.trim().equals("")) {
            strSQL.append("    AND  a.FNumber  >= '").append(strAcctNumberStart).append("'  \r\n");
        }
        if (strAcctNumberEnd != null && !strAcctNumberEnd.trim().equals("")) {
            strSQL.append("    AND a.FNumber  <= '").append(strAcctNumberEnd).append("' \r\n");
        }
        ReportExchangeRateAdjustCondition c = (ReportExchangeRateAdjustCondition)partner.getFixCondition();
        strSQL.append("    AND a.Faccounttableid  = '").append(c.getAccountTable().getId().toString()).append("' \r\n");
        if (PLType.PROFIT.equals((Object)c.getPltype())) {
            strSQL.append("    AND (  h.FBalanceAfter > h.FBalanceBefore  ) \r\n");
        } else if (PLType.LOST.equals((Object)c.getPltype())) {
            strSQL.append("    AND (  h.FBalanceAfter < h.FBalanceBefore ) \r\n");
        }
        strSQL.append(" group By h.FAccountID,a.FNumber ,p.FPeriodYear , p.FPeriodNumber ,c.fisocode,");
        strSQL.append(this.getAccountName(partner));
        strSQL.append(partner.getFieldNameExtend());
        strSQL.append(",c.FPrecision ,");
        strSQL.append("c.fname");
        strSQL.append(partner.getFieldNameExtend());
        strSQL.append(",c.Fid,a.fdc ,h.FExchRateBefore,h.FExchRateAfter ");
        if (condition.getDisplayAsstDetail()) {
            strSQL.append(",h.FAssistHGID ");
        }
        strSQL.append(" Order By p.FPeriodYear , p.FPeriodNumber , a.FNumber,c.fisocode ");
        String strInsert = "insert into " + strTempTable + strSQL.toString();
        this.execute(partner.getContext(), strInsert);
        Connection cn = null;
        ResultSet rs = null;
        strSQL = new StringBuffer();
        strSQL.append(" select ' ' FAccountID, t.FperiodYear FperiodYear,t.FPeriodNumber FPeriodNumber,\r\n");
        strSQL.append("   0 FTotalTag,1 FSerTag,  ' ' FAccountNumber,' ' FAccountName,\r\n");
        strSQL.append("   0 FPrecision, \r\n");
        strSQL.append("   ' ' FCurrencyISOCode,  ' ' FOriginalCurrency,' ' FCurrencyId,0 FOriention,\r\n");
        if (condition.getDisplayAsstDetail()) {
            strSQL.append("' ' FAssistGrpId,");
        }
        strSQL.append("   sum(FBalanceFor*FOriention) FBalanceFor ,0.0 FExchRateBefore,\r\n");
        strSQL.append("   sum(FBalanceBefore*FOriention) FBalanceBefore,0.0 FExchRateAfter,\r\n");
        strSQL.append("   sum(FBalanceAfter*FOriention) FBalanceAfter,\r\n");
        strSQL.append("   sum(FBalanceAdjust*FOriention) FBalanceAdjust\r\n");
        strSQL.append(" from ");
        strSQL.append(strTempTable);
        strSQL.append(" t WHERE t.FSerTag =0 \r\n");
        strSQL.append(" Group by t.FperiodYear,t.FPeriodNumber ");
        StringBuffer strSubTotalBuffer = new StringBuffer();
        strSubTotalBuffer.append(" insert into " + strTempTable + "");
        strSubTotalBuffer.append(strSQL.toString());
        Statement stmtSubTotal = null;
        try {
            cn = partner.getConnection();
            stmtSubTotal = cn.createStatement();
            stmtSubTotal.execute(strSubTotalBuffer.toString());
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)sqle);
                sqle.setNextException(new SQLException("The query sql is:" + strInsert));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtSubTotal);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtSubTotal);
        String strTotal = "select count(*) total from " + strTempTable;
        int iTotal = 0;
        try {
            cn = partner.getConnection();
            stmtSubTotal = cn.createStatement();
            rs = stmtSubTotal.executeQuery(strTotal);
            while (rs.next()) {
                iTotal = rs.getInt("total");
            }
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)sqle);
                sqle.setNextException(new SQLException("The query sql is:" + strInsert));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        strSQL = new StringBuffer();
        strSQL.append(" select ' ' FAccountID,0 FperiodYear,0 FPeriodNumber,\r\n");
        strSQL.append("   1 FTotalTag,2 FSerTag,  ' ' FAccountNumber,' ' FAccountName,\r\n");
        strSQL.append("   0 FPrecision, \r\n");
        strSQL.append("   ' ' FCurrencyISOCode,  ' ' FOriginalCurrency,' ' FCurrencyId,0 FOriention,\r\n");
        if (condition.getDisplayAsstDetail()) {
            strSQL.append("' ' FAssistGrpId,");
        }
        strSQL.append("   sum(FBalanceFor*FOriention) FBalanceFor ,0.0 FExchRateBefore,\r\n");
        strSQL.append("   sum(FBalanceBefore*FOriention) FBalanceBefore,0.0 FExchRateAfter,\r\n");
        strSQL.append("   sum(FBalanceAfter*FOriention) FBalanceAfter,\r\n");
        strSQL.append("   sum(FBalanceAdjust*FOriention) FBalanceAdjust\r\n");
        strSQL.append(" from ");
        strSQL.append(strTempTable);
        strSQL.append(" t WHERE t.FSerTag =0 \r\n");
        StringBuffer strTotalBuffer = new StringBuffer();
        strTotalBuffer.append(" insert into " + strTempTable + "");
        strTotalBuffer.append(strSQL.toString());
        try {
            if (iTotal != 0) {
                cn = partner.getConnection();
                stmtSubTotal = cn.createStatement();
                stmtSubTotal.execute(strTotalBuffer.toString());
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            sqle.setNextException(new SQLException("The query sql is:" + strTotalBuffer));
            throw new SQLDataException(sqle);
        }
        finally {
            SQLUtils.cleanup((Statement)stmtSubTotal);
        }
    }

    private String getAccountName(ReportPartner partner) throws BOSException, EASBizException {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)partner.getContext());
        boolean isAccountShowLongName = false;
        paramKeyMap.put("GL_012", partner.getCompany().getId().toString());
        String strAccountShowLongName = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_012");
        if (strAccountShowLongName != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        return isAccountShowLongName ? "    a.FLongName" : "    a.FName";
    }

    private String getTempTableStructure() {
        StringBuffer sql = new StringBuffer();
        sql.append("(FAccountID VARCHAR(44),FPeriodYear INT, FPeriodNumber INT, FTotalTag INT, FSerTag INT,\r\n");
        sql.append(" FAccountNumber VARCHAR(80),FAccountName NVARCHAR(255),\r\n");
        sql.append(" FPrecision INT,FCurrencyISOCode NVARCHAR(80),\r\n");
        sql.append(" FOriginalCurrency NVARCHAR(80), FCurrencyId VARCHAR(44), \r\n ");
        sql.append(" FOriention INT,FBalanceFor DECIMAL(28,10), \r\n");
        sql.append(" FExchRateBefore DECIMAL(28,10),\r\n");
        sql.append(" FBalanceBefore DECIMAL(28,10), \r\n");
        sql.append(" FExchRateAfter DECIMAL(28,10), \r\n");
        sql.append(" FBalanceAfter DECIMAL(28,10), \r\n");
        sql.append(" FBalanceAdjust DECIMAL(28,10))");
        String tempTempTalbleSql = sql.toString();
        return tempTempTalbleSql;
    }

    private String getTempTableStructure(ReportPartner partner) {
        ReportExchangeRateAdjustCondition condition = (ReportExchangeRateAdjustCondition)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("(FAccountID VARCHAR(44),FPeriodYear INT, FPeriodNumber INT, FTotalTag INT, FSerTag INT,\r\n");
        sql.append(" FAccountNumber VARCHAR(80),FAccountName NVARCHAR(255),\r\n");
        sql.append(" FPrecision INT,FCurrencyISOCode NVARCHAR(80),\r\n");
        sql.append(" FOriginalCurrency NVARCHAR(80), FCurrencyId VARCHAR(44),  FOriention INT,\r\n ");
        if (condition.getDisplayAsstDetail()) {
            sql.append(" FAssistGrpId VARCHAR(44),\r\n ");
        }
        sql.append(" FBalanceFor DECIMAL(28,10),\r\n");
        sql.append(" FExchRateBefore DECIMAL(28,10),\r\n");
        sql.append(" FBalanceBefore DECIMAL(28,10), \r\n");
        sql.append(" FExchRateAfter DECIMAL(28,10), \r\n");
        sql.append(" FBalanceAfter DECIMAL(28,10), \r\n");
        sql.append(" FBalanceAdjust DECIMAL(28,10))");
        String tempTempTalbleSql = sql.toString();
        return tempTempTalbleSql;
    }

    private ReportTableHeadItemInfo addHeadItemInfo(String colName, String[] titles, int width, int alignment, boolean isMerge, boolean isFreeze, boolean isVisible, int numberStyleType, boolean needKilobit, int numberScale) {
        ReportTableHeadItemInfo item = new ReportTableHeadItemInfo();
        item.setColumnName(colName);
        item.setWidth(width);
        item.setAlignment(alignment);
        item.setFreeze(isFreeze);
        item.setMerge(isMerge);
        item.setVisible(isVisible);
        item.setTitles(titles);
        item.setNumberStyleType(numberStyleType);
        item.setNumberScale(numberScale);
        item.setNeedKilobit(needKilobit);
        return item;
    }

    private String getBalanceDC(ReportPartner partner, BigDecimal curBalance, BalanceOrientionTag opposite, boolean bEndBalDCFormat, int iDC) throws BOSException {
        String strDc = null;
        int iOpposite = 0;
        boolean autoBalance = !bEndBalDCFormat;
        BigDecimal zero = new BigDecimal("0.0");
        if (autoBalance) {
            if (curBalance.compareTo(zero) > 0) {
                strDc = partner.TITLE_DEBIT;
                iOpposite = iDC;
            }
            if (curBalance.compareTo(zero) < 0) {
                strDc = partner.TITLE_CREDIT;
                iOpposite = -1;
            }
            if (curBalance.compareTo(zero) == 0) {
                strDc = partner.TITLE_BALANCE;
                iOpposite = 1;
            }
        } else if (curBalance.compareTo(zero) == 0) {
            strDc = partner.TITLE_BALANCE;
            iOpposite = iDC;
        } else {
            if (iDC == 1) {
                strDc = partner.TITLE_DEBIT;
                iOpposite = 1;
            }
            if (iDC == -1) {
                strDc = partner.TITLE_CREDIT;
                iOpposite = -1;
            }
        }
        opposite.setOriention(iOpposite);
        return strDc;
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FPeriodYear", "FPeriodNumber", "FAccountNumber", "FAccountName", "FOriginalCurrency", "FOriention", "FBalanceFor", "FExchRateBefore", "FBalanceBefore", "FExchRateAfter", "FBalanceAfter", "FBalanceAdjust"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"PeriodYear", "PeriodNumber", "AccountNumber", "AccountName", "OriginalCurrency", "Oriention", "BalanceFor", "ExchRateBeforeAdjust", "BalanceLocalBeforeAdjust", "ExchRateAfterAdjust", "BalanceLocalAfterAdjust", "Difference"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{70, 70, 70, 100, 70, 35, 80, 70, 105, 70, 108, 120};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        boolean[] visibles = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
        head.setVisibles(visibles);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        return head;
    }

    protected ReportTableHeadInfo getTableHeadInfo(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FPeriodYear", "FPeriodNumber", "FAccountNumber", "FAccountName", "FOriginalCurrency", "FOriention", "FBalanceFor", "FExchRateBefore", "FBalanceBefore", "FExchRateAfter", "FBalanceAfter", "FBalanceAdjust"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"PeriodYear", "PeriodNumber", "AccountNumber", "AccountName", "OriginalCurrency", "Oriention", "BalanceFor", "ExchRateBeforeAdjust", "BalanceLocalBeforeAdjust", "ExchRateAfterAdjust", "BalanceLocalAfterAdjust", "Difference"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{70, 70, 70, 100, 70, 35, 80, 70, 105, 70, 108, 120};
        head.setWidths(widths);
        int[] alignments = new int[]{2, 2, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        boolean[] visibles = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
        head.setVisibles(visibles);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, true, true, true, true, true, true, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleLocal = partner.getScaleLocal();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, scaleLocal, 0, scaleLocal, 0, scaleLocal, scaleLocal};
        head.setNumberScales(numberScales);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        return head;
    }

    public String getBigDecimalTrimZero(BigDecimal bd) {
        if (bd == null) {
            return "";
        }
        String temp = bd.toString();
        int dot = temp.indexOf(".");
        if (dot == -1) {
            return temp;
        }
        int pos = -1;
        for (int i = temp.length() - 1; i > dot; --i) {
            if (temp.charAt(i) == '0') continue;
            pos = i + 1;
            break;
        }
        if (pos != -1) {
            return temp.substring(0, pos);
        }
        return temp.substring(0, dot);
    }

    protected CompanyOrgUnitInfo getInitCompany(ReportPartner partner) throws BOSException, EASBizException {
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return partner.getCompany();
    }

    @Override
    protected boolean isSupportVirtual() {
        return true;
    }
}

