/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionTrialBalance;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportPLBalanceFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class GLReportPLBalanceFacadeControllerBean
extends AbstractGLReportPLBalanceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLReportPLBalanceFacadeControllerBean");

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, BOSException, EASBizException {
        int scale = partner.getScaleFor();
        int index = 0;
        int sumColTag = 0;
        int lineType = rs.getInt("FLineType");
        int BWType = rs.getInt("FBWType");
        Object[] row = new Object[9];
        row[index++] = rs.getString("FAccountNumber");
        sumColTag = index;
        row[index++] = rs.getString("FAccountName");
        row[index++] = rs.getString("FCurrencyName");
        row[index++] = rs.getBigDecimal("FMonthPLDEbitFor");
        row[index++] = rs.getBigDecimal("FMonthPLCreditFor");
        row[index++] = rs.getBigDecimal("FYearPLDEbitFor");
        row[index++] = rs.getBigDecimal("FYearPLCreditFor");
        if (((ReportConditionTrialBalance)partner.getFixCondition()).getIncludeBWAccount()) {
            if (lineType == 2) {
                if (BWType == 0) {
                    row[index++] = ReportResultInfo.LINE_PERIOD_TOTAL;
                    row[sumColTag] = partner.TITLE_BNSum;
                } else if (BWType == 1) {
                    row[index++] = ReportResultInfo.LINE_PERIOD_TOTAL;
                    row[sumColTag] = partner.TITLE_BWSum;
                } else {
                    row[index++] = ReportResultInfo.LINE_TOTAL;
                    row[sumColTag] = partner.TITLE_SUM;
                }
            } else {
                row[index++] = ReportResultInfo.LINE_NORMAL;
            }
        } else if (lineType == 2) {
            row[index++] = ReportResultInfo.LINE_TOTAL;
            row[sumColTag] = partner.TITLE_SUM;
        } else {
            row[index++] = ReportResultInfo.LINE_NORMAL;
        }
        row[index++] = null;
        for (int i = 3; i < row.length - 2; ++i) {
            if (row[i] == null) continue;
            row[i] = ((BigDecimal)row[i]).setScale(scale, 4);
        }
        return row;
    }

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, EASBizException {
        return " * ";
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append(" FROM \r\n");
        sqlFrom.append(partner.getTempTableName());
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws BOSException, EASBizException {
        return "where 1 = 1  \r\n";
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, EASBizException {
        return " ORDER BY  FBWType,FLineType,FAccountNumber,FCurrencyName ";
    }

    @Override
    protected String getReportName() {
        return "PLBalance";
    }

    @Override
    protected String getAuthorityName() {
        return "PLBalance";
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCurrencyName", "FMonthPLDebitFor", "FMonthPLCreditFor", "FYearPLDebitFor", "FYearPLCreditFor"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "CurrencyType", "MonthPL", "MonthPL", "YearPL", "YearPL"}, {"AccountCode", "AccountName", "CurrencyType", "Debit", "Credit", "Debit", "Credit"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 200, 110, 150, 150, 150, 150};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 2, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false};
        head.setFreezes(freezes);
        boolean[] visibles = new boolean[]{true, true, false, true, true, true, true};
        head.setVisibles(visibles);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        return head;
    }

    @Override
    protected void doSomethingBeforeQuery(ReportPartner partner) throws BOSException, EASBizException {
        super.doSomethingBeforeQuery(partner);
        if (partner.isNewQuery()) {
            partner.setTableHeadInfo(this.getDefalutTableHeadInfo(partner));
        }
    }

    protected void setAccountLevelParameterIndex(ReportPartner partner, int levelIndex) {
        partner.setVariable("TRIL_ACCOUNT_LEVEL", new Integer(levelIndex));
    }

    protected SqlParameter2 getParametersTrialBalance(ReportPartner partner, boolean isOnlyLeaf) throws BOSException, EASBizException {
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValue(partner.getFixCondition().getOptionPosting() ? new Integer(1) : new Integer(5));
        parameter.addValueChar(partner.getPeriodTypeID());
        parameter.addValue(new Integer(partner.getFixCondition().getPeriodYearStart()));
        parameter.addValue(new Integer(partner.getFixCondition().getPeriodNumberStart()));
        parameter.addValueChar(partner.getCompanyId());
        parameter.addValueChar(partner.getAccountTableId());
        if (!isOnlyLeaf) {
            this.setAccountLevelParameterIndex(partner, parameter.getIndex());
            parameter.addValue(new Integer(partner.getFixCondition().getAccountLevelStart()));
        }
        if (!partner.getFixCondition().isAllCurrency()) {
            parameter.addValueChar(partner.getFixCondition().getCurrencyID());
        }
        return parameter;
    }

    @Override
    protected void insertDataIntoTempTable(ReportPartner partner) throws EASBizException, BOSException {
        String strStructure = this.getTempTableStructure();
        String strTempTable = partner.createTempTableAsynchronism("GLPLBal1103", strStructure);
        partner.setTempTableName(strTempTable);
        this.insertTempData(partner, strTempTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTempData(ReportPartner partner, String strTempTable) throws EASBizException, BOSException {
        boolean balanceDirSamAsAccount = partner.isParmBalanceDirSamAsAccount();
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append(" select ");
        sqlSelect.append("    TA.FNumber FAccountNumber,\r\n");
        sqlSelect.append(this.getAccountName(partner));
        sqlSelect.append(partner.getFieldNameExtend());
        sqlSelect.append(" FAccountName, \r\n");
        sqlSelect.append("TA.fbw FBWType ,\r\n");
        sqlSelect.append("    TC.FName");
        sqlSelect.append(partner.getFieldNameExtend());
        sqlSelect.append(" FCurrencyName, \r\n");
        sqlSelect.append("   (CASE WHEN T_Main.Fmonthpnlfor > 0 then T_Main.Fmonthpnlfor else Null end )   FMonthPLDebitFor, \r\n");
        sqlSelect.append("   (CASE WHEN T_Main.Fmonthpnlfor > 0 then null else -1 * T_Main.Fmonthpnlfor end )   FMonthPLCreditFor, \r\n");
        sqlSelect.append("   (CASE WHEN T_Main.Fyearpnlfor > 0 then T_Main.Fyearpnlfor else Null end )   FyearPLDebitfor, \r\n");
        sqlSelect.append("   (CASE WHEN T_Main.Fyearpnlfor > 0 then null else -1 *T_Main.Fyearpnlfor end )   FyearPLCreditfor, \r\n");
        sqlSelect.append(" 1 FLineType\r\n,");
        sqlSelect.append(" TA.FLevel FLevel\r\n,");
        sqlSelect.append(" TA.FIsLeaf FIsLeaf\r\n");
        boolean isOnlyLeaf = ((ReportConditionTrialBalance)partner.getFixCondition()).getOptionOnlyLeaf();
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append("FROM " + GLBalanceUtils.getAccountBalanceTable(5, null) + " T_Main \r\n");
        sqlFrom.append("\tINNER JOIN T_BD_Period TP ON T_Main.FPeriodID = TP.FID \r\n");
        sqlFrom.append("\tINNER JOIN T_BD_AccountView TA \tON T_Main.FAccountID = TA.FID \r\n");
        sqlFrom.append("\tINNER JOIN T_BD_AccountType AP \tON AP.FID = TA.FAccountTypeID \r\n");
        sqlFrom.append("\tINNER JOIN T_BD_Currency TC ON T_Main.FCurrencyID = TC.FID \r\n");
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append("WHERE \r\n");
        if (!((ReportConditionTrialBalance)partner.getFixCondition()).getIncludeBWAccount()) {
            sqlWhere.append("  TA.FBW = 0 and \r\n");
        }
        sqlWhere.append("\tT_Main.FBalType = ?\tAND \r\n");
        sqlWhere.append("\tTP.FTypeID = ? AND \r\n");
        sqlWhere.append("\tT_Main.FPeriodYear = ? AND \r\n");
        sqlWhere.append("\tT_Main.FPeriodNumber = ? AND \r\n");
        sqlWhere.append("\tT_Main.FOrgUnitID = ? AND \r\n");
        sqlWhere.append("\tTA.FAccountTableID = ? AND \r\n");
        if (isOnlyLeaf) {
            sqlWhere.append("\tTA.FIsLeaf = 1 AND \r\n");
        } else {
            sqlWhere.append("\tTA.FLevel <= ? AND \r\n");
        }
        if (!partner.getFixCondition().isAllCurrency()) {
            sqlWhere.append("\tT_Main.FCurrencyID = ? AND \r\n");
        }
        sqlWhere.append("\t AP.Fproperty=4  \r\n");
        StringBuffer sqlOrder = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append(sqlSelect).append(sqlFrom).append(this.getParametersTrialBalance(partner, isOnlyLeaf).getSqlWithParameters(sqlWhere.toString())).append(sqlOrder);
        Connection cn = null;
        PreparedStatement stmt = null;
        cn = partner.getConnection();
        String strInsertTable = " insert into " + strTempTable + sql.toString();
        try {
            stmt = cn.prepareStatement(strInsertTable);
            stmt.executeUpdate();
        }
        catch (SQLException sQLException) {
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
        if (((ReportConditionTrialBalance)partner.getFixCondition()).getIncludeBWAccount()) {
            sql.setLength(0);
            sql.append("insert into ").append(strTempTable);
            sql.append(" select ' ',' ',FBWtype,' ',sum(FMonthPLDebitFor) FMonthPLDebitFor ,sum( FMonthPLCreditFor) FMonthPLCreditFor ,sum(FyearPLDebitfor) FyearPLDebitfor ,sum(FyearPLCreditfor) FyearPLCreditfor , 2 FLineType,to_integer(null),to_integer(null)");
            sql.append("  from ").append("  ").append(strTempTable);
            if (isOnlyLeaf) {
                sql.append(" T_Main where T_Main.fisleaf = 1 group by FBWtype   ");
            } else {
                sql.append(" T_Main where T_Main.flevel = ").append(((ReportConditionTrialBalance)partner.getFixCondition()).getAccountLevelStart()).append(" or T_Main.FIsLeaf = 1 ").append(" group by FBWtype   ");
            }
            try {
                stmt = cn.prepareStatement(sql.toString());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
        }
        sql.setLength(0);
        sql.append("insert into ").append(strTempTable);
        sql.append(" select ' ',' ',2 FBWtype,' ',sum(FMonthPLDebitFor ) FMonthPLDebitFor ,sum(FMonthPLCreditFor ) FMonthPLCreditFor ,sum(FyearPLDebitfor ) FyearPLDebitfor ,sum(FyearPLCreditfor ) FyearPLCreditfor , 2 FLineType,to_integer(null),to_integer(null)");
        sql.append("  from ").append("  ").append(strTempTable);
        sql.append(" where flinetype = 1  and (fisleaf = 1 or  FLevel = ").append(partner.getFixCondition().getAccountLevelStart()).append(") ");
        try {
            stmt = cn.prepareStatement(sql.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    private String getTempTableStructure() {
        String tempTempTalbleSql = " (FAccountNumber VARCHAR(80),FAccountName VARCHAR(256),FBWType INT,FCurrencyName VARCHAR(80),FMonthPLDebitFor DECIMAL(28,10),FMonthPLCreditFor DECIMAL(28,10),FYearPLDebitFor DECIMAL(28,10),FYearPLCreditFor DECIMAL(28,10),FLineType Int,FLevel Int,FIsLeaf Int)";
        return tempTempTalbleSql;
    }

    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.GLReportTrialBalanceQuery";
    }

    protected CompanyOrgUnitInfo getInitCompany(ReportPartner partner) throws BOSException, EASBizException {
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return partner.getCompany();
    }

    private String getAccountName(ReportPartner partner) throws BOSException, EASBizException {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)partner.getContext());
        boolean isAccountShowLongName = false;
        paramKeyMap.put("GL_012", partner.getCompany().getId().toString());
        String strAccountShowLongName = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_012");
        if (strAccountShowLongName != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        return isAccountShowLongName ? "    TA.FLongName" : "    TA.FName";
    }

    @Override
    protected boolean isAddTotalLine(ReportPartner partner) {
        return false;
    }
}

